import{s as ut,n as Jt,o as wt}from"../chunks/scheduler.85c25b89.js";import{S as ht,i as jt,g as i,s,r as p,A as bt,h as M,f as l,c as a,j as Tt,u as r,x as o,k as ct,y as ft,a as n,v as m,d as y,t as d,w as U}from"../chunks/index.c9bcf812.js";import{C as c}from"../chunks/CodeBlock.c004bd26.js";import{H as ee}from"../chunks/getInferenceSnippets.a8eb3b62.js";function It(xe){let T,ne,te,se,u,ae,J,Ye='This tutorial will teach how to fine-tune open LLMs like <a href="https://huggingface.co/Qwen/Qwen3-8B" rel="nofollow">Qwen 3</a> on AWS Trainium.  In our example, we are going to leverage Hugging Face Optimum Neuron, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and datasets.',ie,w,Me,h,$e='<a href="https://aws.amazon.com/de/ec2/instance-types/trn1/" rel="nofollow">AWS Trainium (Trn1)</a> is a purpose-built EC2 for deep learning (DL) training workloads. Trainium is the successor of <a href="https://aws.amazon.com/ec2/instance-types/inf1/?nc1=h_ls" rel="nofollow">AWS Inferentia</a> focused on high-performance training workloads. Trainium has been optimized for training natural language processing, computer vision, and recommender models used.',oe,j,Le='The biggest Trainium instance, the <code>trn1.32xlarge</code> comes with over 500GB of memory, making it easy to fine-tune ~10B parameter models on a single instance. Below you will find an overview of the available instance types. More details <a href="https://aws.amazon.com/en/ec2/instance-types/trn1/#Product_details" rel="nofollow">here</a>:',pe,b,qe="<thead><tr><th>instance size</th> <th>accelerators</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>price per hour</th></tr></thead> <tbody><tr><td>trn1.2xlarge</td> <td>1</td> <td>32</td> <td>8</td> <td>32</td> <td>\\$1.34</td></tr> <tr><td>trn1.32xlarge</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>\\$21.50</td></tr> <tr><td>trn1n.32xlarge (2x bandwidth)</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>\\$24.78</td></tr></tbody>",re,me,ye,f,De="<em>Note: This tutorial was created on a trn1.32xlarge AWS EC2 Instance.</em>",de,I,Ue,C,Pe='In this example, we will use the <code>trn1.32xlarge</code> instance on AWS with 16 Accelerator, including 32 Neuron Cores and the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>. The Hugging Face AMI comes with all important libraries, like Transformers, Datasets, Optimum and Neuron packages pre-installed this makes it super easy to get started, since there is no need for environment management.',Te,Z,Oe='If you want to know more about distributed training you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>.',ce,B,ue,R,Ke='We will use a <a href="https://huggingface.co/datasets/tengomucho/simple_recipes" rel="nofollow">simple recipes</a>, to make LLM get better at suggesting delicious ideas.',Je,g,we,W,et="To load the <code>simple_recipes</code> dataset, we use the <code>load_dataset()</code> method from the 🤗 Datasets library.",he,Q,je,V,tt="To tune our model we need to convert our structured examples into a collection of quotes with a given context, so we define our tokenization function that we will be able to map on the dataset.",be,E,lt="The dataset should be structured with input-output pairs, where each input is a prompt and the output is the expected response from the model. We will make use of the model’s tokenizer chat template and preprocess the dataset to be fed to the trainer.",fe,G,Ie,F,nt="Let’s test our formatting function on a random example:",Ce,_,Ze,X,Be,S,st='Usually, to fine-tune PyTorch-based transformer models you would use <a href="https://huggingface.co/PEFT" rel="nofollow">PEFT</a> to use LoRA adapters to save memory and use the<code>SFTTrainer</code> the perform supervised fine-tuning.',Re,k,at="On AWS Trainium, <code>optimum-neuron</code> offers a 1-to-1 replacement with the <code>NeuronSFTTrainer</code>, optimized to take advantage of the multiple cores available on this setup.",ge,A,it="When it comes to distributed training on AWS Trainium there are few things we need to take care of. Since Qwen3 is a big model it does not fit on a single accelerator. The <code>NeuronSFTTrainer</code> supports different distributed training techniques (DDP, Tensor Parallelism, etc) to solve this.",We,v,Mt="Loading the model an preparing the LoRA adapter is very similar to what you would do with other accelerators.",Qe,N,Ve,z,ot='We prepared a script, <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generationscripts/sft_finetuning_qwen3.py" rel="nofollow">sft_finetuning_qwen3.py</a> to fine-tune Qwen3 that contains everything mentioned in this tutorial. You can launch it with the torchrun command:',Ee,H,Ge,x,pt='For convenience, we provide this command in a shell script called <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generationscripts/sft_finetuning_qwen3.sh" rel="nofollow">sft_finetuning_qwen3.sh</a>.',Fe,Y,_e,$,rt="Optimum Neuron trains and serializes model shard files separately, meaning that they need to be consolidated (i.e.: re-merged) to be used.",Xe,L,mt="To do this, you can use the Optimum CLI as suggested here:",Se,q,ke,D,yt="This will create an <code>adapter_model.safetensors</code> file, the LoRA adapter weights that we trained in the previous step. We can now reload the model and merge it, so it can be loaded for evaluation:",Ae,P,ve,O,dt="Once this step is done, it is possible to test the model with a new prompt.",Ne,K,Ut="You have successfully created a fine-tuned model from Qwen3!",ze,le,He;return u=new ee({props:{title:"Fine-tune Qwen 3 on AWS Trainium",local:"fine-tune-qwen-3-on-aws-trainium",headingTag:"h1"}}),w=new ee({props:{title:"Quick intro: AWS Trainium",local:"quick-intro-aws-trainium",headingTag:"h2"}}),I=new ee({props:{title:"1. Setup AWS environment",local:"1-setup-aws-environment",headingTag:"h2"}}),B=new ee({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),g=new c({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ3JlY2lwZXMnJTNBJTIwJTIyLSUyMFByZWhlYXQlMjBvdmVuJTIwdG8lMjAzNTAlMjBkZWdyZWVzJTVDbi0lMjBCdXR0ZXIlMjB0d28lMjA5eDUnJTIwbG9hZiUyMHBhbnMlNUNuLSUyMENyZWFtJTIwdGhlJTIwc3VnYXIlMjBhbmQlMjB0aGUlMjBidXR0ZXIlMjB1bnRpbCUyMGxpZ2h0JTIwYW5kJTIwd2hpcHBlZCU1Q24tJTIwQWRkJTIwdGhlJTIwYmFuYW5hcyUyQyUyMGVnZ3MlMkMlMjBsZW1vbiUyMGp1aWNlJTJDJTIwb3JhbmdlJTIwcmluZCU1Q24tJTIwQmVhdCUyMHVudGlsJTIwYmxlbmRlZCUyMHVuaWZvcm1seSU1Q24tJTIwQmUlMjBwYXRpZW50JTJDJTIwYW5kJTIwYmVhdCUyMHVudGlsJTIwdGhlJTIwYmFuYW5hJTIwbHVtcHMlMjBhcmUlMjBnb25lJTVDbi0lMjBTaWZ0JTIwdGhlJTIwZHJ5JTIwaW5ncmVkaWVudHMlMjB0b2dldGhlciU1Q24tJTIwRm9sZCUyMGxpZ2h0bHklMjBhbmQlMjB0aG9yb3VnaGx5JTIwaW50byUyMHRoZSUyMGJhbmFuYSUyMG1peHR1cmUlNUNuLSUyMFBvdXIlMjB0aGUlMjBiYXR0ZXIlMjBpbnRvJTIwcHJlcGFyZWQlMjBsb2FmJTIwcGFucyU1Q24tJTIwQmFrZSUyMGZvciUyMDQ1JTIwdG8lMjA1NSUyMG1pbnV0ZXMlMkMlMjB1bnRpbCUyMHRoZSUyMGxvYXZlcyUyMGFyZSUyMGZpcm0lMjBpbiUyMHRoZSUyMG1pZGRsZSUyMGFuZCUyMHRoZSUyMGVkZ2VzJTIwYmVnaW4lMjB0byUyMHB1bGwlMjBhd2F5JTIwZnJvbSUyMHRoZSUyMHBhbnMlNUNuLSUyMENvb2wlMjB0aGUlMjBsb2F2ZXMlMjBvbiUyMHJhY2tzJTIwZm9yJTIwMzAlMjBtaW51dGVzJTIwYmVmb3JlJTIwcmVtb3ZpbmclMjBmcm9tJTIwdGhlJTIwcGFucyU1Q24tJTIwRnJlZXplcyUyMHdlbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAnbmFtZXMnJTNBJTIwJ0JlYXQlMjB0aGlzJTIwYmFuYW5hJTIwYnJlYWQnJTBBJTdE",highlighted:`{
    <span class="hljs-string">&#x27;recipes&#x27;</span>: <span class="hljs-string">&quot;- Preheat oven to 350 degrees\\n- Butter two 9x5&#x27; loaf pans\\n- Cream the sugar and the butter until light and whipped\\n- Add the bananas, eggs, lemon juice, orange rind\\n- Beat until blended uniformly\\n- Be patient, and beat until the banana lumps are gone\\n- Sift the dry ingredients together\\n- Fold lightly and thoroughly into the banana mixture\\n- Pour the batter into prepared loaf pans\\n- Bake for 45 to 55 minutes, until the loaves are firm in the middle and the edges begin to pull away from the pans\\n- Cool the loaves on racks for 30 minutes before removing from the pans\\n- Freezes well&quot;</span>,
    <span class="hljs-string">&#x27;names&#x27;</span>: <span class="hljs-string">&#x27;Beat this banana bread&#x27;</span>
}`,wrap:!1}}),Q=new c({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXRfaWQlMjAlM0QlMjAlMjJ0ZW5nb211Y2hvJTJGc2ltcGxlX3JlY2lwZXMlMjIlMEFyZWNpcGVzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfaWQlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWRhdGFzZXRfc2l6ZSUyMCUzRCUyMGxlbihyZWNpcGVzKSUwQXByaW50KGYlMjJkYXRhc2V0JTIwc2l6ZSUzQSUyMCU3QmRhdGFzZXRfc2l6ZSU3RCUyMiklMEFwcmludChyZWNpcGVzJTVCcmFuZHJhbmdlKGRhdGFzZXRfc2l6ZSklNUQpJTBBJTIzJTIwZGF0YXNldCUyMHNpemUlM0ElMjAyMDAwMA==",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset


<span class="hljs-comment"># Load dataset from the hub</span>
dataset_id = <span class="hljs-string">&quot;tengomucho/simple_recipes&quot;</span>
recipes = load_dataset(dataset_id, split=<span class="hljs-string">&quot;train&quot;</span>)

dataset_size = <span class="hljs-built_in">len</span>(recipes)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{dataset_size}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(recipes[randrange(dataset_size)])
<span class="hljs-comment"># dataset size: 20000</span>`,wrap:!1}}),G=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlF3ZW4lMkZRd2VuMy04QiUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmVjaXBlcyUyMCUzRCUyMGV4YW1wbGVzJTVCJTIycmVjaXBlcyUyMiU1RCUwQSUyMCUyMCUyMCUyMG5hbWVzJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJuYW1lcyUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMGNoYXRzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcmVjaXBlJTJDJTIwbmFtZSUyMGluJTIwemlwKHJlY2lwZXMlMkMlMjBuYW1lcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBcHBlbmQlMjB0aGUlMjBFT1MlMjB0b2tlbiUyMHRvJTIwdGhlJTIwcmVzcG9uc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWNpcGUlMjAlMkIlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMGYlMjJIb3clMjBjYW4lMjBJJTIwbWFrZSUyMCU3Qm5hbWUlN0QlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHJlY2lwZSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKGNoYXQlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hhdHMuYXBwZW5kKGNoYXQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBjaGF0cyU3RCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjByZWNpcGVzLm1hcChwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRHJlY2lwZXMuY29sdW1uX25hbWVzKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

model_id = <span class="hljs-string">&quot;Qwen/Qwen3-8B&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    recipes = examples[<span class="hljs-string">&quot;recipes&quot;</span>]
    names = examples[<span class="hljs-string">&quot;names&quot;</span>]

    chats = []
    <span class="hljs-keyword">for</span> recipe, name <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(recipes, names):
        <span class="hljs-comment"># Append the EOS token to the response</span>
        recipe += tokenizer.eos_token

        chat = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">f&quot;How can I make <span class="hljs-subst">{name}</span>?&quot;</span>},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: recipe},
        ]
        tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)

        chats.append(chat)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;messages&quot;</span>: chats}


dataset = recipes.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>, remove_columns=recipes.column_names)`,wrap:!1}}),_=new c({props:{code:"cHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShkYXRhc2V0X3NpemUpJTVEKSUwQSUyMyUyMCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMCdtZXNzYWdlcyclM0ElMjAlNUIlMEElMjMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0InY29udGVudCclM0ElMjAnSG93JTIwY2FuJTIwSSUyMG1ha2UlMjBBdW50JTIwbGl6JTIwcyUyMGFsbW9uZCUyMGJyb2Njb2xpJTIwY2Fzc2Vyb2xlJyUyQyUyMCdyb2xlJyUzQSUyMCd1c2VyJyU3RCUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdjb250ZW50JyUzQSUyMCctJTIwUHJlLXN0cmVhbSUyMGJyb2Njb2xpJTIwZm9yJTIwYWJvdXQlMjA1JTIwbWludXRlcyU1Q24tJTIwU2F1dGUlMjBvbmlvbnMlMjBhbmQlMjBnYXJsaWMlMjBpbiUyMGJ1dHRlciU1Q24tJTIwQWRkJTIwc291cCUyQyUyMGNoZWVzZSUyMHdoaXolMjBhbmQlMjBtdXNocm9vbXMlMjB0byUyMHNhdXRlZWQlMjBvbmlvbiUyMG1peHR1cmUlNUNuLSUyMFB1dCUyMGJyb2Njb2xpJTIwaW50byUyMGElMjBncmVhc2VkJTIwY2Fzc2Vyb2xlJTIwZGlzaCUyMGFuZCUyMHBvdXIlMjBzYXVjZSUyMG92ZXIlMjBpdCU1Q24tJTIwU3ByaW5rbGUlMjB0aGUlMjBhbG1vbmRzJTIwb3ZlciUyMHRoaXMlMjBhbmQlMjB0aGVuJTIwc3ByaW5rbGUlMjB0aGUlMjBjcm91dG9ucyUyMG9uJTIwdG9wJTVDbi0lMjBCYWtlJTIwYXQlMjAzNTAlMjBkZWdmJTIwZm9yJTIwMzAlMEElMjMlMjBtaW51dGVzJTNDJTdDaW1fZW5kJTdDJTNFJyUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdyb2xlJyUzQSUyMCdhc3Npc3RhbnQnJTBBJTIzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIzJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIzJTIwJTdE",highlighted:`<span class="hljs-built_in">print</span>(dataset[randrange(dataset_size)])
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#     &#x27;messages&#x27;: [</span>
<span class="hljs-comment">#         {&#x27;content&#x27;: &#x27;How can I make Aunt liz s almond broccoli casserole&#x27;, &#x27;role&#x27;: &#x27;user&#x27;},</span>
<span class="hljs-comment">#         {</span>
<span class="hljs-comment">#             &#x27;content&#x27;: &#x27;- Pre-stream broccoli for about 5 minutes\\n- Saute onions and garlic in butter\\n- Add soup, cheese whiz and mushrooms to sauteed onion mixture\\n- Put broccoli into a greased casserole dish and pour sauce over it\\n- Sprinkle the almonds over this and then sprinkle the croutons on top\\n- Bake at 350 degf for 30</span>
<span class="hljs-comment"># minutes&lt;|im_end|&gt;&#x27;,</span>
<span class="hljs-comment">#             &#x27;role&#x27;: &#x27;assistant&#x27;</span>
<span class="hljs-comment">#         }</span>
<span class="hljs-comment">#     ]</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),X=new ee({props:{title:"3. Fine-tune Qwen 3 on AWS Trainium using the NeuronSFTTrainer and PEFT",local:"3-fine-tune-qwen-3-on-aws-trainium-using-the-neuronsfttrainer-and-peft",headingTag:"h2"}}),N=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronSFTConfig, NeuronSFTTrainer, NeuronTrainingArguments
<span class="hljs-keyword">from</span> optimum.neuron.models.training <span class="hljs-keyword">import</span> Qwen3ForCausalLM
<span class="hljs-keyword">from</span> optimum.neuron.models.training.config <span class="hljs-keyword">import</span> TrainingNeuronConfig

<span class="hljs-comment"># This is necessary to pass the training configuration</span>
trn_config = TrainingNeuronConfig(tensor_parallel_size=<span class="hljs-number">8</span>, pipeline_parallel_size=<span class="hljs-number">1</span>)
<span class="hljs-comment"># Define your own training arguments</span>
training_args = NeuronTrainingArguments()

dtype = torch.bfloat16  <span class="hljs-comment"># This will allow to use mixed-precision</span>
model = Qwen3ForCausalLM.from_pretrained(model_id, trn_config, torch_dtype=dtype)

config = LoraConfig(
    r=<span class="hljs-number">64</span>,
    lora_alpha=<span class="hljs-number">128</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>, <span class="hljs-string">&quot;gate_proj&quot;</span>],
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

args = training_args.to_dict()
packing = <span class="hljs-literal">True</span>
sft_config = NeuronSFTConfig(
    max_seq_length=<span class="hljs-number">8192</span>,
    packing=packing,
    **args,
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer.apply_chat_template(examples[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)


trainer = NeuronSFTTrainer(
    args=sft_config,
    model=model,
    peft_config=config,
    tokenizer=tokenizer,
    train_dataset=dataset,
    formatting_func=formatting_function,
)

<span class="hljs-comment"># Start training</span>
train_result = trainer.train()`,wrap:!1}}),H=new c({props:{code:"UFJPQ0VTU0VTX1BFUl9OT0RFJTNEMzIlMEFOVU1fRVBPQ0hTJTNEMyUwQVRQX0RFR1JFRSUzRDglMEFCUyUzRDElMEFHUkFESUVOVF9BQ0NVTVVMQVRJT05fU1RFUFMlM0Q4JTBBTE9HR0lOR19TVEVQUyUzRDIlMEFNT0RFTF9OQU1FJTNEJTIyUXdlbiUyRlF3ZW4zLTMtOEIlMjIlMEFPVVRQVVRfRElSJTNEJTIyJTI0KGVjaG8lMjAlMjRNT0RFTF9OQU1FJTIwJTdDJTIwY3V0JTIwLWQnJTJGJyUyMC1mMiktZmluZXR1bmVkJTIyJTBBTUFYX1NURVBTJTNELTElMEFESVNUUklCVVRFRF9BUkdTJTNEJTIyLS1ucHJvY19wZXJfbm9kZSUyMCUyNFBST0NFU1NFU19QRVJfTk9ERSUyMiUwQSUwQXRvcmNocnVuJTIwJTI0RElTVFJJQlVURURfQVJHUyUyMG5vdGVib29rcyUyRnRleHQtZ2VuZXJhdGlvbnNjcmlwdHMlMkZzZnRfZmluZXR1bmluZ19xd2VuMy5weSUyMCU1QyUwQSUyMCUyMC0tbW9kZWxfaWQlMjAlMjRNT0RFTF9OQU1FJTIwJTVDJTBBJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwJTI0TlVNX0VQT0NIUyUyMCU1QyUwQSUyMCUyMC0tZG9fdHJhaW4lMjAlNUMlMEElMjAlMjAtLW1heF9zdGVwcyUyMCUyNE1BWF9TVEVQUyUyMCU1QyUwQSUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwJTI0QlMlMjAlNUMlMEElMjAlMjAtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwJTI0QlMlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUyNEdSQURJRU5UX0FDQ1VNVUxBVElPTl9TVEVQUyUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMHRydWUlMjAlNUMlMEElMjAlMjAtLWJmMTYlMjB0cnVlJTIwJTVDJTBBJTIwJTIwLS1zYXZlX3N0ZXBzJTIwMjAlMjAlNUMlMEElMjAlMjAtLXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwJTI0VFBfREVHUkVFJTIwJTVDJTBBJTIwJTIwLS1sb2dnaW5nX3N0ZXBzJTIwJTI0TE9HR0lOR19TVEVQUyUyMCU1QyUwQSUyMCUyMC0tc2F2ZV90b3RhbF9saW1pdCUyMC0xJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTIwJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyX3R5cGUlMjAlMjJjb3NpbmUlMjIlMjAlNUMlMEElMjAlMjAtLW92ZXJ3cml0ZV9vdXRwdXRfZGly",highlighted:`PROCESSES_PER_NODE=<span class="hljs-number">32</span>
NUM_EPOCHS=<span class="hljs-number">3</span>
TP_DEGREE=<span class="hljs-number">8</span>
BS=<span class="hljs-number">1</span>
GRADIENT_ACCUMULATION_STEPS=<span class="hljs-number">8</span>
LOGGING_STEPS=<span class="hljs-number">2</span>
MODEL_NAME=<span class="hljs-string">&quot;Qwen/Qwen3-3-8B&quot;</span>
OUTPUT_DIR=<span class="hljs-string">&quot;$(echo $MODEL_NAME | cut -d&#x27;/&#x27; -f2)-finetuned&quot;</span>
MAX_STEPS=-<span class="hljs-number">1</span>
DISTRIBUTED_ARGS=<span class="hljs-string">&quot;--nproc_per_node $PROCESSES_PER_NODE&quot;</span>

torchrun $DISTRIBUTED_ARGS notebooks/text-generationscripts/sft_finetuning_qwen3.py \\
  --model_id $MODEL_NAME \\
  --num_train_epochs $NUM_EPOCHS \\
  --do_train \\
  --max_steps $MAX_STEPS \\
  --per_device_train_batch_size $BS \\
  --per_device_eval_batch_size $BS \\
  --gradient_accumulation_steps $GRADIENT_ACCUMULATION_STEPS \\
  --gradient_checkpointing true \\
  --bf16 true \\
  --save_steps <span class="hljs-number">20</span> \\
  --tensor_parallel_size $TP_DEGREE \\
  --logging_steps $LOGGING_STEPS \\
  --save_total_limit -<span class="hljs-number">1</span> \\
  --output_dir $OUTPUT_DIR \\
  --lr_scheduler_type <span class="hljs-string">&quot;cosine&quot;</span> \\
  --overwrite_output_dir`,wrap:!1}}),Y=new ee({props:{title:"4. Consolidate and Test finetuned model",local:"4-consolidate-and-test-finetuned-model",headingTag:"h2"}}),q=new c({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMFF3ZW4zLThCLWZpbmV0dW5lZCUyMFF3ZW4zLThCLWZpbmV0dW5lZCUyRmFkYXB0ZXJfZGVmYXVsdA==",highlighted:"optimum-cli neuron consolidate Qwen3-8B-finetuned Qwen3-8B-finetuned/adapter_default",wrap:!1}}),P=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTJDJTIwUGVmdENvbmZpZyUwQSUwQSUwQU1PREVMX05BTUUlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjMtOEIlMjIlMEFBREFQVEVSX1BBVEglMjAlM0QlMjAlMjJRd2VuMy04Qi1maW5ldHVuZWQlMkZhZGFwdGVyX2RlZmF1bHQlMjIlMEFNRVJHRURfTU9ERUxfUEFUSCUyMCUzRCUyMCUyMlF3ZW4zLThCLXJlY2lwZXMlMjIlMEElMEElMjMlMjBMb2FkJTIwYmFzZSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoTU9ERUxfTkFNRSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChNT0RFTF9OQU1FKSUwQSUwQSUyMyUyMExvYWQlMjBhZGFwdGVyJTIwY29uZmlndXJhdGlvbiUyMGFuZCUyMG1vZGVsJTBBYWRhcHRlcl9jb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZChBREFQVEVSX1BBVEgpJTBBZmluZXR1bmVkX21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMEFEQVBURVJfUEFUSCUyQyUyMGNvbmZpZyUzRGFkYXB0ZXJfY29uZmlnKSUwQSUwQXByaW50KCUyMlNhdmluZyUyMHRva2VuaXplciUyMiklMEF0b2tlbml6ZXIuc2F2ZV9wcmV0cmFpbmVkKE1FUkdFRF9NT0RFTF9QQVRIKSUwQXByaW50KCUyMlNhdmluZyUyMG1vZGVsJTIyKSUwQWZpbmV0dW5lZF9tb2RlbCUyMCUzRCUyMGZpbmV0dW5lZF9tb2RlbC5tZXJnZV9hbmRfdW5sb2FkKCklMEFmaW5ldHVuZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKE1FUkdFRF9NT0RFTF9QQVRIKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig


MODEL_NAME = <span class="hljs-string">&quot;Qwen/Qwen3-8B&quot;</span>
ADAPTER_PATH = <span class="hljs-string">&quot;Qwen3-8B-finetuned/adapter_default&quot;</span>
MERGED_MODEL_PATH = <span class="hljs-string">&quot;Qwen3-8B-recipes&quot;</span>

<span class="hljs-comment"># Load base model</span>
model = AutoModelForCausalLM.from_pretrained(MODEL_NAME)
tokenizer = AutoTokenizer.from_pretrained(MODEL_NAME)

<span class="hljs-comment"># Load adapter configuration and model</span>
adapter_config = PeftConfig.from_pretrained(ADAPTER_PATH)
finetuned_model = PeftModel.from_pretrained(model, ADAPTER_PATH, config=adapter_config)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving tokenizer&quot;</span>)
tokenizer.save_pretrained(MERGED_MODEL_PATH)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving model&quot;</span>)
finetuned_model = finetuned_model.merge_and_unload()
finetuned_model.save_pretrained(MERGED_MODEL_PATH)`,wrap:!1}}),{c(){T=i("meta"),ne=s(),te=i("p"),se=s(),p(u.$$.fragment),ae=s(),J=i("p"),J.innerHTML=Ye,ie=s(),p(w.$$.fragment),Me=s(),h=i("p"),h.innerHTML=$e,oe=s(),j=i("p"),j.innerHTML=Le,pe=s(),b=i("table"),b.innerHTML=qe,re=s(),me=i("hr"),ye=s(),f=i("p"),f.innerHTML=De,de=s(),p(I.$$.fragment),Ue=s(),C=i("p"),C.innerHTML=Pe,Te=s(),Z=i("p"),Z.innerHTML=Oe,ce=s(),p(B.$$.fragment),ue=s(),R=i("p"),R.innerHTML=Ke,Je=s(),p(g.$$.fragment),we=s(),W=i("p"),W.innerHTML=et,he=s(),p(Q.$$.fragment),je=s(),V=i("p"),V.textContent=tt,be=s(),E=i("p"),E.textContent=lt,fe=s(),p(G.$$.fragment),Ie=s(),F=i("p"),F.textContent=nt,Ce=s(),p(_.$$.fragment),Ze=s(),p(X.$$.fragment),Be=s(),S=i("p"),S.innerHTML=st,Re=s(),k=i("p"),k.innerHTML=at,ge=s(),A=i("p"),A.innerHTML=it,We=s(),v=i("p"),v.textContent=Mt,Qe=s(),p(N.$$.fragment),Ve=s(),z=i("p"),z.innerHTML=ot,Ee=s(),p(H.$$.fragment),Ge=s(),x=i("p"),x.innerHTML=pt,Fe=s(),p(Y.$$.fragment),_e=s(),$=i("p"),$.textContent=rt,Xe=s(),L=i("p"),L.textContent=mt,Se=s(),p(q.$$.fragment),ke=s(),D=i("p"),D.innerHTML=yt,Ae=s(),p(P.$$.fragment),ve=s(),O=i("p"),O.textContent=dt,Ne=s(),K=i("p"),K.textContent=Ut,ze=s(),le=i("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);T=M(t,"META",{name:!0,content:!0}),t.forEach(l),ne=a(e),te=M(e,"P",{}),Tt(te).forEach(l),se=a(e),r(u.$$.fragment,e),ae=a(e),J=M(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-14udgoe"&&(J.innerHTML=Ye),ie=a(e),r(w.$$.fragment,e),Me=a(e),h=M(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-28xjlm"&&(h.innerHTML=$e),oe=a(e),j=M(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-3q7kol"&&(j.innerHTML=Le),pe=a(e),b=M(e,"TABLE",{"data-svelte-h":!0}),o(b)!=="svelte-48yzfd"&&(b.innerHTML=qe),re=a(e),me=M(e,"HR",{}),ye=a(e),f=M(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1qrp4mv"&&(f.innerHTML=De),de=a(e),r(I.$$.fragment,e),Ue=a(e),C=M(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1i6k69t"&&(C.innerHTML=Pe),Te=a(e),Z=M(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-yp02re"&&(Z.innerHTML=Oe),ce=a(e),r(B.$$.fragment,e),ue=a(e),R=M(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-144acui"&&(R.innerHTML=Ke),Je=a(e),r(g.$$.fragment,e),we=a(e),W=M(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-ktj643"&&(W.innerHTML=et),he=a(e),r(Q.$$.fragment,e),je=a(e),V=M(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1e4z25x"&&(V.textContent=tt),be=a(e),E=M(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-ypt5tm"&&(E.textContent=lt),fe=a(e),r(G.$$.fragment,e),Ie=a(e),F=M(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-udl5e3"&&(F.textContent=nt),Ce=a(e),r(_.$$.fragment,e),Ze=a(e),r(X.$$.fragment,e),Be=a(e),S=M(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1teiq6s"&&(S.innerHTML=st),Re=a(e),k=M(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-6sq7k4"&&(k.innerHTML=at),ge=a(e),A=M(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-ra3od5"&&(A.innerHTML=it),We=a(e),v=M(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-5a1d1k"&&(v.textContent=Mt),Qe=a(e),r(N.$$.fragment,e),Ve=a(e),z=M(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1yprkfi"&&(z.innerHTML=ot),Ee=a(e),r(H.$$.fragment,e),Ge=a(e),x=M(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-ptules"&&(x.innerHTML=pt),Fe=a(e),r(Y.$$.fragment,e),_e=a(e),$=M(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-nfffsw"&&($.textContent=rt),Xe=a(e),L=M(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-p4wytx"&&(L.textContent=mt),Se=a(e),r(q.$$.fragment,e),ke=a(e),D=M(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1cigzjn"&&(D.innerHTML=yt),Ae=a(e),r(P.$$.fragment,e),ve=a(e),O=M(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-vght15"&&(O.textContent=dt),Ne=a(e),K=M(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1sz4goc"&&(K.textContent=Ut),ze=a(e),le=M(e,"P",{}),Tt(le).forEach(l),this.h()},h(){ct(T,"name","hf:doc:metadata"),ct(T,"content",Ct)},m(e,t){ft(document.head,T),n(e,ne,t),n(e,te,t),n(e,se,t),m(u,e,t),n(e,ae,t),n(e,J,t),n(e,ie,t),m(w,e,t),n(e,Me,t),n(e,h,t),n(e,oe,t),n(e,j,t),n(e,pe,t),n(e,b,t),n(e,re,t),n(e,me,t),n(e,ye,t),n(e,f,t),n(e,de,t),m(I,e,t),n(e,Ue,t),n(e,C,t),n(e,Te,t),n(e,Z,t),n(e,ce,t),m(B,e,t),n(e,ue,t),n(e,R,t),n(e,Je,t),m(g,e,t),n(e,we,t),n(e,W,t),n(e,he,t),m(Q,e,t),n(e,je,t),n(e,V,t),n(e,be,t),n(e,E,t),n(e,fe,t),m(G,e,t),n(e,Ie,t),n(e,F,t),n(e,Ce,t),m(_,e,t),n(e,Ze,t),m(X,e,t),n(e,Be,t),n(e,S,t),n(e,Re,t),n(e,k,t),n(e,ge,t),n(e,A,t),n(e,We,t),n(e,v,t),n(e,Qe,t),m(N,e,t),n(e,Ve,t),n(e,z,t),n(e,Ee,t),m(H,e,t),n(e,Ge,t),n(e,x,t),n(e,Fe,t),m(Y,e,t),n(e,_e,t),n(e,$,t),n(e,Xe,t),n(e,L,t),n(e,Se,t),m(q,e,t),n(e,ke,t),n(e,D,t),n(e,Ae,t),m(P,e,t),n(e,ve,t),n(e,O,t),n(e,Ne,t),n(e,K,t),n(e,ze,t),n(e,le,t),He=!0},p:Jt,i(e){He||(y(u.$$.fragment,e),y(w.$$.fragment,e),y(I.$$.fragment,e),y(B.$$.fragment,e),y(g.$$.fragment,e),y(Q.$$.fragment,e),y(G.$$.fragment,e),y(_.$$.fragment,e),y(X.$$.fragment,e),y(N.$$.fragment,e),y(H.$$.fragment,e),y(Y.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),He=!0)},o(e){d(u.$$.fragment,e),d(w.$$.fragment,e),d(I.$$.fragment,e),d(B.$$.fragment,e),d(g.$$.fragment,e),d(Q.$$.fragment,e),d(G.$$.fragment,e),d(_.$$.fragment,e),d(X.$$.fragment,e),d(N.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),He=!1},d(e){e&&(l(ne),l(te),l(se),l(ae),l(J),l(ie),l(Me),l(h),l(oe),l(j),l(pe),l(b),l(re),l(me),l(ye),l(f),l(de),l(Ue),l(C),l(Te),l(Z),l(ce),l(ue),l(R),l(Je),l(we),l(W),l(he),l(je),l(V),l(be),l(E),l(fe),l(Ie),l(F),l(Ce),l(Ze),l(Be),l(S),l(Re),l(k),l(ge),l(A),l(We),l(v),l(Qe),l(Ve),l(z),l(Ee),l(Ge),l(x),l(Fe),l(_e),l($),l(Xe),l(L),l(Se),l(ke),l(D),l(Ae),l(ve),l(O),l(Ne),l(K),l(ze),l(le)),l(T),U(u,e),U(w,e),U(I,e),U(B,e),U(g,e),U(Q,e),U(G,e),U(_,e),U(X,e),U(N,e),U(H,e),U(Y,e),U(q,e),U(P,e)}}}const Ct='{"title":"Fine-tune Qwen 3 on AWS Trainium","local":"fine-tune-qwen-3-on-aws-trainium","sections":[{"title":"Quick intro: AWS Trainium","local":"quick-intro-aws-trainium","sections":[],"depth":2},{"title":"1. Setup AWS environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Qwen 3 on AWS Trainium using the NeuronSFTTrainer and PEFT","local":"3-fine-tune-qwen-3-on-aws-trainium-using-the-neuronsfttrainer-and-peft","sections":[],"depth":2},{"title":"4. Consolidate and Test finetuned model","local":"4-consolidate-and-test-finetuned-model","sections":[],"depth":2}],"depth":1}';function Zt(xe){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends ht{constructor(T){super(),jt(this,T,Zt,It,ut,{})}}export{Qt as component};
