import{s as jn,f as Ce,n as Un,o as vn}from"../chunks/scheduler.85c25b89.js";import{S as bn,i as xn,g as i,s as l,r as p,A as Sn,h as o,f as n,c as a,j as In,u,x as r,k as c,y as $n,a as s,v as m,d as h,t as y,w}from"../chunks/index.c9bcf812.js";import{C as Ie}from"../chunks/CodeBlock.c004bd26.js";import{H as f}from"../chunks/getInferenceSnippets.a8eb3b62.js";function An(kt){let M,ve,je,be,T,xe,J,Lt='The simplest way to work with AWS Trainium or Inferentia and Optimum Neuron on Amazon EC2 is the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> (DLAMI). The DLAMI comes with all required libraries pre-packaged for you, including the Neuron Drivers, Transformers, Datasets, and Accelerate. The HF DLAMI is provided at no additional charge to Amazon EC2 users.',Se,d,Nt='Optimum Neuron supports Inf1, Inf2, Trn1 and Trn2, all accessible on Amazon EC2. You can find all the specifications of the Trn and Inf instances <a href="https://aws.amazon.com/ec2/instance-types/" rel="nofollow">here</a>, in the “Accelerated Computing” section.',$e,g,Bt="In this guide, we will show you:",Ae,C,Vt='<li><a href="#how-to-create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami">How to create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI</a><ol><li><a href="#find-a-supported-region">Find a supported region</a></li> <li><a href="#increase-service-quota">Increase service quota</a></li> <li><a href="#launch-the-amazon-ec2-instance-with-the-hf-dlami">Launch the Amazon EC2 instance with the HF DLAMI</a></li> <li><a href="#connect-through-ssh">Connect through SSH</a></li></ol></li> <li><a href="#how-to-set-up-your-remote-development-environment">How to set up your remote development environment</a><ol><li><a href="#access-through-jupyter-notebook">Access through Jupyter Notebook</a></li> <li><a href="#access-through-vs-code-remote-server">Access through VS Code remote server</a></li></ol></li>',_e,I,ke,j,Zt="Before creating the EC2 instance, make sure you are in a supported region for the instance you selected and that you have quota in your AWS account.",Le,U,Ne,v,Wt="Here is the list of regions that support at least one type of Trainium or Inferentia2 instance, as of February 2025:",Be,b,Et="<li>us-east-1: US East (N. Virginia)</li> <li>us-east-2: US East (Ohio)</li> <li>us-west-2: US West (Oregon)</li> <li>ap-south-1: Asia Pacific (Mumbai)</li> <li>ap-northeast-1: Asia Pacific (Tokyo)</li> <li>ap-southeast-1: Asia Pacific (Singapore)</li> <li>ap-southeast-2: Asia Pacific (Sydney)</li> <li>ap-southeast-4: Asia Pacific (Melbourne)</li> <li>eu-north-1: Europe (Stockholm)</li> <li>eu-west-3: Europe (Paris)</li> <li>eu-west-2: Europe (London)</li> <li>eu-west-1: Europe (Ireland)</li> <li>eu-central-1: Europe (Frankfurt)</li> <li>sa-east-1: South America (Sao Paulo)</li>",Ve,x,zt="Here is a Python script that lets you pull the latest supported instance type in each region you have enabled:",Ze,S,We,$,Ee,A,Qt="Now that you selected your region and that you switched to it, you can request a Service Quota increase through the AWS Console by navigating to Service Quota, AWS services in the left panel, search for Amazon EC2, then “trn” or “inf”. You are able to request quota increase for On-Demand and Spot instances separately.",ze,_,Ht="By default, all quotas are 0 for Inferentia and Trainium. There is no charge for increased quotas. There are separate quotas for Inferentia and Trainium, and separate quotas for spot and on-demand. Quotas refer to the maximum TOTAL number of vCPUs assigned to each instance type.",Qe,k,Gt="For example, a quota of 192 will let you run a single inf2.48xlarge, two inf2.24xlarges, six inf2.8xlarges, or forty-eight of the inf2.xlarges. It will also let you run inf1 instance types. Similarly for Trainium, a quota of 128 will let you run a single trn1n.32xlarge or trn1.32xlarge, but it will also let you run sixteen trn1.2xlarge.",He,L,Ge,N,Rt="Let’s deploy a trn1.2xlarge instance in the us-east-1 region (North Virginia) through the EC2 console.",Re,B,Pt="First, click on <strong>Launch instance</strong> and define a name for the instance (<code>trainium-huggingface-demo</code>).",Pe,V,Yt,Ye,Z,Xt="Next, you search the Amazon Marketplace for Hugging Face AMIs. Entering “Hugging Face” in the search bar for “Application and OS Images” and hitting “enter”.",Xe,W,Ft,Fe,E,Dt='This should now open the “Choose an Amazon Machine Image” view with the search. You can now navigate to “AWS Marketplace AMIs” and find the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> and click select.',De,z,qt,qe,Q,Ot="<em>You will be asked to subscribe if you aren’t. The AMI is completely free of charge, and you will only pay for the EC2 compute.</em>",Oe,H,Kt="Then you need to define a key pair, which will be used to connect to the instance via <code>ssh</code>. You can create one in place if you don’t have a key pair.",Ke,G,en,et,R,tn='After that, create or select a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html" rel="nofollow">security group</a> which allows <code>ssh</code> traffic.',tt,P,nn,nt,Y,sn="You are ready to launch the instance. Therefore click on “Launch Instance” on the right side.",st,X,ln,lt,F,an='AWS will now provision the instance using the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.',at,D,it,q,on="Once the instance is ready, you can view and copy the public IPv4 address to <code>ssh</code> into the machine.",ot,O,rn,rt,K,pn="Replace the empty strings <code>&quot;&quot;</code> in the snippet below with the IP address of your instances and the path to the key pair you created/selected when launching the instance.",pt,ee,ut,te,un="Once you are connected, you can run <code>neuron-ls</code> to ensure you have access to the Trainium accelerators. You should see a similar output than below.",ct,ne,mt,se,ht,le,cn="We will walk through setting up Jupyter Notebooks or VS Code remote server on the Amazon EC2 instance.",yt,ae,mn="These two methods require an SSH connection of some kind. These instructions were written for a Mac, but should work on a Linux system as well. A PC may require using Putty.",wt,ie,hn="You should have a .pem file that you created when you deployed your instance or had from previous deployments. You can connect to your system using:",Mt,oe,ft,re,Tt,pe,yn="This method involves running the Jupyter notebook server on the Neuron instance, mapping a port locally, then using the browser on your desktop to access the notebook server.",Jt,ue,wn="Start by mapping a port on your local machine to the Neuron instance. From a terminal on your system, run",dt,ce,gt,me,Mn="Then connect to your Amazon EC2 instance using SSH from your computer. Once connected, from the command prompt, run",Ct,he,It,ye,fn="After a few seconds, check the nohup.out file to find your server’s token:",jt,we,Ut,Me,Tn="Copy the connection string and paste it into your browser. After a few seconds, you should eventually see the Jupyter Notebook browser. It should look like http://localhost:8888/tree?token=337fc8de2aenot_a_real_tokene952c43946e4fb57131",vt,fe,Jn="This process works because you have mapped the 8888 port on your local machine to the 8888 port on the Neuron instance, so when you connect to localhost:8888, you end up accessing the Jupyter server on the Neuron instance.",bt,Te,dn="If you have problems, make sure the initial port mapping was successful. If you already have something running on port 8888 on your machine, this may give you an error. You can always change the port (e.g. 8885) in all the instructions if you need to.",xt,Je,St,de,gn="With Visual Studio Code installed on your local machine, you can use the Remote-SSH command to edit and run files that are stored on a Neuron instance. See the VS Code article for additional details.",$t,ge,Cn="<li>Select Remote-SSH: Connect to Host… from the Command Palette (F1, ⇧⌘P)</li> <li>Enter in the full connection string from the ssh section above: ssh -i “/path/to/sshkey.pem” ubuntu@instance_ip_address</li> <li>VS Code should connect and automatically set up the VS Code server.</li> <li>Eventually, you should be prompted for a base directory. You can browse to a directory on the Neuron instance.</li> <li>In case you find that some commands seem greyed out in the menus, but the keyboard commands still work (⌘S to save or ^⇧` for terminal), you may need to restart VS Code.</li>",At,Ue,_t;return T=new f({props:{title:"Get started on Amazon EC2",local:"get-started-on-amazon-ec2",headingTag:"h1"}}),I=new f({props:{title:"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI",local:"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami",headingTag:"h2"}}),U=new f({props:{title:"Find a supported region",local:"find-a-supported-region",headingTag:"h3"}}),S=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> boto3  
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime

ec2 = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>)  

regions = [region[<span class="hljs-string">&#x27;RegionName&#x27;</span>] <span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> ec2.describe_regions()[<span class="hljs-string">&#x27;Regions&#x27;</span>]]  


<span class="hljs-comment">#Edit this line to change the instance types displayed  </span>
instance_types = [<span class="hljs-string">&#x27;trn1.32xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn1.2xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.48xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.24xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.8xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn2.48xlarge&#x27;</span>]  
  
supported_regions = {}  
  
<span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> regions:  
   ec2_region = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>, region_name=region)  
   response = ec2_region.describe_instance_type_offerings(  
      <span class="hljs-comment">#LocationType=&#x27;availability-zone&#x27;,  </span>
      Filters=[  
        {<span class="hljs-string">&#x27;Name&#x27;</span>: <span class="hljs-string">&#x27;instance-type&#x27;</span>, <span class="hljs-string">&#x27;Values&#x27;</span>: instance_types},  
      ]  
   )
   <span class="hljs-keyword">if</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]:  
      supported_regions[region] = [offer[<span class="hljs-string">&#x27;InstanceType&#x27;</span>] <span class="hljs-keyword">for</span> offer <span class="hljs-keyword">in</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]]  

<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;# Supported Regions as of&#x27;</span>,datetime.now().strftime(<span class="hljs-string">&#x27;%B %d, %Y&#x27;</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;================&#x27;</span>)  


client = boto3.client(<span class="hljs-string">&#x27;ssm&#x27;</span>)

<span class="hljs-keyword">for</span> region, instance_types <span class="hljs-keyword">in</span> supported_regions.items():
    <span class="hljs-keyword">try</span>:
        response = client.get_parameter(Name=<span class="hljs-string">f&#x27;/aws/service/global-infrastructure/regions/<span class="hljs-subst">{region}</span>/longName&#x27;</span>)
        region_long_name = response[<span class="hljs-string">&#x27;Parameter&#x27;</span>][<span class="hljs-string">&#x27;Value&#x27;</span>]
    <span class="hljs-keyword">except</span> (client.exceptions.ParameterNotFound, KeyError):
        region_long_name = region
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27; * <span class="hljs-subst">{region}</span>: <span class="hljs-subst">{region_long_name}</span>&#x27;</span>)
    <span class="hljs-keyword">for</span> instance_type <span class="hljs-keyword">in</span> instance_types:
      <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;  - <span class="hljs-subst">{instance_type}</span>&#x27;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;\\n&#x27;</span>) `,wrap:!1}}),$=new f({props:{title:"Increase service quota",local:"increase-service-quota",headingTag:"h3"}}),L=new f({props:{title:"Launch the Amazon EC2 instance with the HF DLAMI",local:"launch-the-amazon-ec2-instance-with-the-hf-dlami",headingTag:"h3"}}),D=new f({props:{title:"Connect through SSH",local:"connect-through-ssh",headingTag:"h3"}}),ee=new Ie({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUwQUtFWV9QQVRIJTNEJTIyJTIyJTIwJTIzJTIwbG9jYWwlMjBwYXRoJTIwdG8lMjBrZXklMjBwYWlyJTBBJTBBc3NoJTIwLWklMjAlMjRLRVlfUEFUSCUyMHVidW50dSU0MCUyNFBVQkxJQ19ETlM=",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key pair</span>

ssh -i <span class="hljs-variable">$KEY_PATH</span> ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),ne=new Ie({props:{code:"dWJ1bnR1JTQwaXAtMTcyLTMxLTc5LTE2NCUzQX4lMjQlMjBuZXVyb24tbHMlMEFpbnN0YW5jZS10eXBlJTNBJTIwdHJuMS4yeGxhcmdlJTBBaW5zdGFuY2UtaWQlM0ElMjBpLTA1NzA2MTVlNDE3MDBhNDgxJTBBJTJCLS0tLS0tLS0lMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0tJTJCJTBBJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwJTIwJTIwUENJJTIwJTIwJTIwJTdDJTBBJTdDJTIwREVWSUNFJTIwJTdDJTIwQ09SRVMlMjAlMjAlN0MlMjBNRU1PUlklMjAlN0MlMjAlMjAlMjBCREYlMjAlMjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkIlMEElN0MlMjAwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjAwMCUzQTFlLjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkI=",highlighted:`ubuntu@ip<span class="hljs-number">-172</span><span class="hljs-number">-31</span><span class="hljs-number">-79</span><span class="hljs-number">-164</span><span class="hljs-punctuation">:</span>~$ neuron-ls
instance-type<span class="hljs-punctuation">:</span> trn1<span class="hljs-number">.2</span>xlarge
instance-id<span class="hljs-punctuation">:</span> i<span class="hljs-number">-0570615e41700</span>a481
+--------+--------+--------+---------+
| NEURON | NEURON | NEURON |   PCI   |
| DEVICE | CORES  | MEMORY |   BDF   |
+--------+--------+--------+---------+
| <span class="hljs-number">0</span>      | <span class="hljs-number">2</span>      | <span class="hljs-number">32</span> GB  | <span class="hljs-number">00</span><span class="hljs-punctuation">:</span><span class="hljs-number">1</span>e<span class="hljs-number">.0</span> |
+--------+--------+--------+---------+`,wrap:!1}}),se=new f({props:{title:"How to set up your remote development environment",local:"how-to-set-up-your-remote-development-environment",headingTag:"h2"}}),oe=new Ie({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwdWJ1bnR1JTQwaW5zdGFuY2VfaXBfYWRkcmVzcw==",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> ubuntu@instance_ip_address',wrap:!1}}),re=new f({props:{title:"Access through Jupyter Notebook",local:"access-through-jupyter-notebook",headingTag:"h3"}}),ce=new Ie({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwLU4lMjAtZiUyMC1MJTIwbG9jYWxob3N0JTNBODg4OCUzQWxvY2FsaG9zdCUzQTg4ODglMjB1YnVudHUlNDBpbnN0YW5jZV9pcF9hZGRyZXNz",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> -N -f -L localhost:8888:localhost:8888 ubuntu@instance_ip_address',wrap:!1}}),he=new Ie({props:{code:"bm9odXAlMjBqdXB5dGVyJTIwbm90ZWJvb2slMjAtLW5vLWJyb3dzZXIlMjAtLXBvcnQlM0Q4ODg4",highlighted:'<span class="hljs-built_in">nohup</span> jupyter notebook --no-browser --port=8888',wrap:!1}}),we=new Ie({props:{code:"Y2F0JTIwbm9odXAub3V0JTIwJTdDJTIwZ3JlcCUyMGxvY2FsaG9zdA==",highlighted:'<span class="hljs-built_in">cat</span> nohup.out | grep localhost',wrap:!1}}),Je=new f({props:{title:"Access through VS Code remote server",local:"access-through-vs-code-remote-server",headingTag:"h3"}}),{c(){M=i("meta"),ve=l(),je=i("p"),be=l(),p(T.$$.fragment),xe=l(),J=i("p"),J.innerHTML=Lt,Se=l(),d=i("p"),d.innerHTML=Nt,$e=l(),g=i("p"),g.textContent=Bt,Ae=l(),C=i("ol"),C.innerHTML=Vt,_e=l(),p(I.$$.fragment),ke=l(),j=i("p"),j.textContent=Zt,Le=l(),p(U.$$.fragment),Ne=l(),v=i("p"),v.textContent=Wt,Be=l(),b=i("ul"),b.innerHTML=Et,Ve=l(),x=i("p"),x.textContent=zt,Ze=l(),p(S.$$.fragment),We=l(),p($.$$.fragment),Ee=l(),A=i("p"),A.textContent=Qt,ze=l(),_=i("p"),_.textContent=Ht,Qe=l(),k=i("p"),k.textContent=Gt,He=l(),p(L.$$.fragment),Ge=l(),N=i("p"),N.textContent=Rt,Re=l(),B=i("p"),B.innerHTML=Pt,Pe=l(),V=i("img"),Ye=l(),Z=i("p"),Z.textContent=Xt,Xe=l(),W=i("img"),Fe=l(),E=i("p"),E.innerHTML=Dt,De=l(),z=i("img"),qe=l(),Q=i("p"),Q.innerHTML=Ot,Oe=l(),H=i("p"),H.innerHTML=Kt,Ke=l(),G=i("img"),et=l(),R=i("p"),R.innerHTML=tn,tt=l(),P=i("img"),nt=l(),Y=i("p"),Y.textContent=sn,st=l(),X=i("img"),lt=l(),F=i("p"),F.innerHTML=an,at=l(),p(D.$$.fragment),it=l(),q=i("p"),q.innerHTML=on,ot=l(),O=i("img"),rt=l(),K=i("p"),K.innerHTML=pn,pt=l(),p(ee.$$.fragment),ut=l(),te=i("p"),te.innerHTML=un,ct=l(),p(ne.$$.fragment),mt=l(),p(se.$$.fragment),ht=l(),le=i("p"),le.textContent=cn,yt=l(),ae=i("p"),ae.textContent=mn,wt=l(),ie=i("p"),ie.textContent=hn,Mt=l(),p(oe.$$.fragment),ft=l(),p(re.$$.fragment),Tt=l(),pe=i("p"),pe.textContent=yn,Jt=l(),ue=i("p"),ue.textContent=wn,dt=l(),p(ce.$$.fragment),gt=l(),me=i("p"),me.textContent=Mn,Ct=l(),p(he.$$.fragment),It=l(),ye=i("p"),ye.textContent=fn,jt=l(),p(we.$$.fragment),Ut=l(),Me=i("p"),Me.textContent=Tn,vt=l(),fe=i("p"),fe.textContent=Jn,bt=l(),Te=i("p"),Te.textContent=dn,xt=l(),p(Je.$$.fragment),St=l(),de=i("p"),de.textContent=gn,$t=l(),ge=i("ol"),ge.innerHTML=Cn,At=l(),Ue=i("p"),this.h()},l(e){const t=Sn("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(n),ve=a(e),je=o(e,"P",{}),In(je).forEach(n),be=a(e),u(T.$$.fragment,e),xe=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-n1mbei"&&(J.innerHTML=Lt),Se=a(e),d=o(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1g253ra"&&(d.innerHTML=Nt),$e=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-9hcug9"&&(g.textContent=Bt),Ae=a(e),C=o(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-hyxz2x"&&(C.innerHTML=Vt),_e=a(e),u(I.$$.fragment,e),ke=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1y0w0e0"&&(j.textContent=Zt),Le=a(e),u(U.$$.fragment,e),Ne=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-19mf0fu"&&(v.textContent=Wt),Be=a(e),b=o(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-1ur9ox2"&&(b.innerHTML=Et),Ve=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-cd8ooq"&&(x.textContent=zt),Ze=a(e),u(S.$$.fragment,e),We=a(e),u($.$$.fragment,e),Ee=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-mu91xn"&&(A.textContent=Qt),ze=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1oqd42e"&&(_.textContent=Ht),Qe=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tmf6ga"&&(k.textContent=Gt),He=a(e),u(L.$$.fragment,e),Ge=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-r3bcy6"&&(N.textContent=Rt),Re=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-50wzvt"&&(B.innerHTML=Pt),Pe=a(e),V=o(e,"IMG",{src:!0,alt:!0}),Ye=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-7wwfcf"&&(Z.textContent=Xt),Xe=a(e),W=o(e,"IMG",{src:!0,alt:!0}),Fe=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-cgjl8t"&&(E.innerHTML=Dt),De=a(e),z=o(e,"IMG",{src:!0,alt:!0}),qe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-11azj2p"&&(Q.innerHTML=Ot),Oe=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1j7ptbp"&&(H.innerHTML=Kt),Ke=a(e),G=o(e,"IMG",{src:!0,alt:!0}),et=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-jwe09q"&&(R.innerHTML=tn),tt=a(e),P=o(e,"IMG",{src:!0,alt:!0}),nt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1hnrw8h"&&(Y.textContent=sn),st=a(e),X=o(e,"IMG",{src:!0,alt:!0}),lt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-yyg7kn"&&(F.innerHTML=an),at=a(e),u(D.$$.fragment,e),it=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-dpbyx7"&&(q.innerHTML=on),ot=a(e),O=o(e,"IMG",{src:!0,alt:!0}),rt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-pmoe5"&&(K.innerHTML=pn),pt=a(e),u(ee.$$.fragment,e),ut=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1jd2fkg"&&(te.innerHTML=un),ct=a(e),u(ne.$$.fragment,e),mt=a(e),u(se.$$.fragment,e),ht=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-va0ciz"&&(le.textContent=cn),yt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-20tg3z"&&(ae.textContent=mn),wt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-14ylm5t"&&(ie.textContent=hn),Mt=a(e),u(oe.$$.fragment,e),ft=a(e),u(re.$$.fragment,e),Tt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-16s9nvc"&&(pe.textContent=yn),Jt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-s72xtc"&&(ue.textContent=wn),dt=a(e),u(ce.$$.fragment,e),gt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-l0sx97"&&(me.textContent=Mn),Ct=a(e),u(he.$$.fragment,e),It=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1fn6l5y"&&(ye.textContent=fn),jt=a(e),u(we.$$.fragment,e),Ut=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ou1jyu"&&(Me.textContent=Tn),vt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1965vx"&&(fe.textContent=Jn),bt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-165fa3p"&&(Te.textContent=dn),xt=a(e),u(Je.$$.fragment,e),St=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-bzwe4m"&&(de.textContent=gn),$t=a(e),ge=o(e,"OL",{"data-svelte-h":!0}),r(ge)!=="svelte-c41b6w"&&(ge.innerHTML=Cn),At=a(e),Ue=o(e,"P",{}),In(Ue).forEach(n),this.h()},h(){c(M,"name","hf:doc:metadata"),c(M,"content",_n),Ce(V.src,Yt="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/01-name-instance.png")||c(V,"src",Yt),c(V,"alt","name instance"),Ce(W.src,Ft="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/02-search-ami.png")||c(W,"src",Ft),c(W,"alt","search ami"),Ce(z.src,qt="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/03-select-ami.png")||c(z,"src",qt),c(z,"alt","select ami"),Ce(G.src,en="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/04-select-key.png")||c(G,"src",en),c(G,"alt","select ssh key"),Ce(P.src,nn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/05-select-sg.png")||c(P,"src",nn),c(P,"alt","select security group"),Ce(X.src,ln="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/06-launch-instance.png")||c(X,"src",ln),c(X,"alt","select ssh key"),Ce(O.src,rn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/07-copy-dns.png")||c(O,"src",rn),c(O,"alt","select public dns")},m(e,t){$n(document.head,M),s(e,ve,t),s(e,je,t),s(e,be,t),m(T,e,t),s(e,xe,t),s(e,J,t),s(e,Se,t),s(e,d,t),s(e,$e,t),s(e,g,t),s(e,Ae,t),s(e,C,t),s(e,_e,t),m(I,e,t),s(e,ke,t),s(e,j,t),s(e,Le,t),m(U,e,t),s(e,Ne,t),s(e,v,t),s(e,Be,t),s(e,b,t),s(e,Ve,t),s(e,x,t),s(e,Ze,t),m(S,e,t),s(e,We,t),m($,e,t),s(e,Ee,t),s(e,A,t),s(e,ze,t),s(e,_,t),s(e,Qe,t),s(e,k,t),s(e,He,t),m(L,e,t),s(e,Ge,t),s(e,N,t),s(e,Re,t),s(e,B,t),s(e,Pe,t),s(e,V,t),s(e,Ye,t),s(e,Z,t),s(e,Xe,t),s(e,W,t),s(e,Fe,t),s(e,E,t),s(e,De,t),s(e,z,t),s(e,qe,t),s(e,Q,t),s(e,Oe,t),s(e,H,t),s(e,Ke,t),s(e,G,t),s(e,et,t),s(e,R,t),s(e,tt,t),s(e,P,t),s(e,nt,t),s(e,Y,t),s(e,st,t),s(e,X,t),s(e,lt,t),s(e,F,t),s(e,at,t),m(D,e,t),s(e,it,t),s(e,q,t),s(e,ot,t),s(e,O,t),s(e,rt,t),s(e,K,t),s(e,pt,t),m(ee,e,t),s(e,ut,t),s(e,te,t),s(e,ct,t),m(ne,e,t),s(e,mt,t),m(se,e,t),s(e,ht,t),s(e,le,t),s(e,yt,t),s(e,ae,t),s(e,wt,t),s(e,ie,t),s(e,Mt,t),m(oe,e,t),s(e,ft,t),m(re,e,t),s(e,Tt,t),s(e,pe,t),s(e,Jt,t),s(e,ue,t),s(e,dt,t),m(ce,e,t),s(e,gt,t),s(e,me,t),s(e,Ct,t),m(he,e,t),s(e,It,t),s(e,ye,t),s(e,jt,t),m(we,e,t),s(e,Ut,t),s(e,Me,t),s(e,vt,t),s(e,fe,t),s(e,bt,t),s(e,Te,t),s(e,xt,t),m(Je,e,t),s(e,St,t),s(e,de,t),s(e,$t,t),s(e,ge,t),s(e,At,t),s(e,Ue,t),_t=!0},p:Un,i(e){_t||(h(T.$$.fragment,e),h(I.$$.fragment,e),h(U.$$.fragment,e),h(S.$$.fragment,e),h($.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),_t=!0)},o(e){y(T.$$.fragment,e),y(I.$$.fragment,e),y(U.$$.fragment,e),y(S.$$.fragment,e),y($.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(he.$$.fragment,e),y(we.$$.fragment,e),y(Je.$$.fragment,e),_t=!1},d(e){e&&(n(ve),n(je),n(be),n(xe),n(J),n(Se),n(d),n($e),n(g),n(Ae),n(C),n(_e),n(ke),n(j),n(Le),n(Ne),n(v),n(Be),n(b),n(Ve),n(x),n(Ze),n(We),n(Ee),n(A),n(ze),n(_),n(Qe),n(k),n(He),n(Ge),n(N),n(Re),n(B),n(Pe),n(V),n(Ye),n(Z),n(Xe),n(W),n(Fe),n(E),n(De),n(z),n(qe),n(Q),n(Oe),n(H),n(Ke),n(G),n(et),n(R),n(tt),n(P),n(nt),n(Y),n(st),n(X),n(lt),n(F),n(at),n(it),n(q),n(ot),n(O),n(rt),n(K),n(pt),n(ut),n(te),n(ct),n(mt),n(ht),n(le),n(yt),n(ae),n(wt),n(ie),n(Mt),n(ft),n(Tt),n(pe),n(Jt),n(ue),n(dt),n(gt),n(me),n(Ct),n(It),n(ye),n(jt),n(Ut),n(Me),n(vt),n(fe),n(bt),n(Te),n(xt),n(St),n(de),n($t),n(ge),n(At),n(Ue)),n(M),w(T,e),w(I,e),w(U,e),w(S,e),w($,e),w(L,e),w(D,e),w(ee,e),w(ne,e),w(se,e),w(oe,e),w(re,e),w(ce,e),w(he,e),w(we,e),w(Je,e)}}}const _n='{"title":"Get started on Amazon EC2","local":"get-started-on-amazon-ec2","sections":[{"title":"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI","local":"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami","sections":[{"title":"Find a supported region","local":"find-a-supported-region","sections":[],"depth":3},{"title":"Increase service quota","local":"increase-service-quota","sections":[],"depth":3},{"title":"Launch the Amazon EC2 instance with the HF DLAMI","local":"launch-the-amazon-ec2-instance-with-the-hf-dlami","sections":[],"depth":3},{"title":"Connect through SSH","local":"connect-through-ssh","sections":[],"depth":3}],"depth":2},{"title":"How to set up your remote development environment","local":"how-to-set-up-your-remote-development-environment","sections":[{"title":"Access through Jupyter Notebook","local":"access-through-jupyter-notebook","sections":[],"depth":3},{"title":"Access through VS Code remote server","local":"access-through-vs-code-remote-server","sections":[],"depth":3}],"depth":2}],"depth":1}';function kn(kt){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends bn{constructor(M){super(),xn(this,M,kn,An,jn,{})}}export{Zn as component};
