import{s as we,n as Ce,o as Oe}from"../chunks/scheduler.182ea377.js";import{S as Le,i as Pe,g as a,s as o,r as f,A as ke,h as d,f as t,c as i,j as E,u as m,x as S,k as T,y as r,a as l,v as h,d as g,t as _,w as b}from"../chunks/index.abf12888.js";import{D as K}from"../chunks/Docstring.93f6f462.js";import{H as _e}from"../chunks/Heading.16916d63.js";function qe(be){let u,G,R,j,y,B,w,ve='The Euler scheduler (Algorithm 2) is from the <a href="https://huggingface.co/papers/2206.00364" rel="nofollow">Elucidating the Design Space of Diffusion-Based Generative Models</a> paper by Karras et al. This is a fast scheduler which can often generate good outputs in 20-30 steps. The scheduler is based on the original <a href="https://github.com/crowsonkb/k-diffusion/blob/481677d114f6ea445aa009cf5bd7a9cdee909e47/k_diffusion/sampling.py#L51" rel="nofollow">k-diffusion</a> implementation by <a href="https://github.com/crowsonkb/" rel="nofollow">Katherine Crowson</a>.',J,C,Q,s,O,ie,z,xe="Euler scheduler.",ae,H,$e=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/v0.27.2/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,de,v,L,ce,I,De=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep. Scales the denoising model input by <code>(sigma**2 + 1) ** 0.5</code> to match the Euler algorithm.`,le,x,P,ue,N,Ee="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",pe,$,k,fe,A,Se="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",me,D,q,he,V,Te=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).`,X,F,Y,p,M,ge,U,ye="Output class for the scheduler’s <code>step</code> function output.",Z,W,ee;return y=new _e({props:{title:"EulerDiscreteScheduler",local:"eulerdiscretescheduler",headingTag:"h1"}}),C=new _e({props:{title:"EulerDiscreteScheduler",local:"diffusers.EulerDiscreteScheduler",headingTag:"h2"}}),O=new K({props:{name:"class diffusers.EulerDiscreteScheduler",anchor:"diffusers.EulerDiscreteScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": str = 'linear'"},{name:"trained_betas",val:": Union = None"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"interpolation_type",val:": str = 'linear'"},{name:"use_karras_sigmas",val:": Optional = False"},{name:"sigma_min",val:": Optional = None"},{name:"sigma_max",val:": Optional = None"},{name:"timestep_spacing",val:": str = 'linspace'"},{name:"timestep_type",val:": str = 'discrete'"},{name:"steps_offset",val:": int = 0"},{name:"rescale_betas_zero_snr",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.EulerDiscreteScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.EulerDiscreteScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.EulerDiscreteScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code> or <code>scaled_linear</code>.`,name:"beta_schedule"},{anchor:"diffusers.EulerDiscreteScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.EulerDiscreteScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>, <em>optional</em>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.EulerDiscreteScheduler.interpolation_type(str,",description:`<strong>interpolation_type(<code>str</code>,</strong> defaults to <code>&quot;linear&quot;</code>, <em>optional</em>) &#x2014;
The interpolation type to compute intermediate sigmas for the scheduler denoising steps. Should be on of
<code>&quot;linear&quot;</code> or <code>&quot;log_linear&quot;</code>.`,name:"interpolation_type(str,"},{anchor:"diffusers.EulerDiscreteScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.EulerDiscreteScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.EulerDiscreteScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps, as required by some model families.`,name:"steps_offset"},{anchor:"diffusers.EulerDiscreteScheduler.rescale_betas_zero_snr",description:`<strong>rescale_betas_zero_snr</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
dark samples instead of limiting it to samples with medium brightness. Loosely related to
<a href="https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506" rel="nofollow"><code>--offset_noise</code></a>.`,name:"rescale_betas_zero_snr"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_euler_discrete.py#L132"}}),L=new K({props:{name:"scale_model_input",anchor:"diffusers.EulerDiscreteScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": Union"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"},{anchor:"diffusers.EulerDiscreteScheduler.scale_model_input.timestep",description:`<strong>timestep</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The current timestep in the diffusion chain.`,name:"timestep"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_euler_discrete.py#L273",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),P=new K({props:{name:"set_begin_index",anchor:"diffusers.EulerDiscreteScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_euler_discrete.py#L263"}}),k=new K({props:{name:"set_timesteps",anchor:"diffusers.EulerDiscreteScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int"},{name:"device",val:": Union = None"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.EulerDiscreteScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_euler_discrete.py#L299"}}),q=new K({props:{name:"step",anchor:"diffusers.EulerDiscreteScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": Union"},{name:"sample",val:": FloatTensor"},{name:"s_churn",val:": float = 0.0"},{name:"s_tmin",val:": float = 0.0"},{name:"s_tmax",val:": float = inf"},{name:"s_noise",val:": float = 1.0"},{name:"generator",val:": Optional = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.EulerDiscreteScheduler.step.timestep",description:`<strong>timestep</strong> (<code>float</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.EulerDiscreteScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_churn",description:"<strong>s_churn</strong> (<code>float</code>) &#x2014;",name:"s_churn"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_tmin",description:"<strong>s_tmin</strong>  (<code>float</code>) &#x2014;",name:"s_tmin"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_tmax",description:"<strong>s_tmax</strong>  (<code>float</code>) &#x2014;",name:"s_tmax"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_noise",description:`<strong>s_noise</strong> (<code>float</code>, defaults to 1.0) &#x2014;
Scaling factor for noise added to the sample.`,name:"s_noise"},{anchor:"diffusers.EulerDiscreteScheduler.step.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A random number generator.`,name:"generator"},{anchor:"diffusers.EulerDiscreteScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/schedulers/euler#diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput">EulerDiscreteSchedulerOutput</a> or
tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_euler_discrete.py#L434",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/v0.27.2/en/api/schedulers/euler#diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput"
>EulerDiscreteSchedulerOutput</a> is
returned, otherwise a tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/schedulers/euler#diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput"
>EulerDiscreteSchedulerOutput</a> or <code>tuple</code></p>
`}}),F=new _e({props:{title:"EulerDiscreteSchedulerOutput",local:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput",headingTag:"h2"}}),M=new K({props:{name:"class diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput",anchor:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput",parameters:[{name:"prev_sample",val:": FloatTensor"},{name:"pred_original_sample",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"},{anchor:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput.pred_original_sample",description:`<strong>pred_original_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
The predicted denoised sample <code>(x_{0})</code> based on the model output from the current timestep.
<code>pred_original_sample</code> can be used to preview progress or for guidance.`,name:"pred_original_sample"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_euler_discrete.py#L31"}}),{c(){u=a("meta"),G=o(),R=a("p"),j=o(),f(y.$$.fragment),B=o(),w=a("p"),w.innerHTML=ve,J=o(),f(C.$$.fragment),Q=o(),s=a("div"),f(O.$$.fragment),ie=o(),z=a("p"),z.textContent=xe,ae=o(),H=a("p"),H.innerHTML=$e,de=o(),v=a("div"),f(L.$$.fragment),ce=o(),I=a("p"),I.innerHTML=De,le=o(),x=a("div"),f(P.$$.fragment),ue=o(),N=a("p"),N.textContent=Ee,pe=o(),$=a("div"),f(k.$$.fragment),fe=o(),A=a("p"),A.textContent=Se,me=o(),D=a("div"),f(q.$$.fragment),he=o(),V=a("p"),V.textContent=Te,X=o(),f(F.$$.fragment),Y=o(),p=a("div"),f(M.$$.fragment),ge=o(),U=a("p"),U.innerHTML=ye,Z=o(),W=a("p"),this.h()},l(e){const n=ke("svelte-u9bgzb",document.head);u=d(n,"META",{name:!0,content:!0}),n.forEach(t),G=i(e),R=d(e,"P",{}),E(R).forEach(t),j=i(e),m(y.$$.fragment,e),B=i(e),w=d(e,"P",{"data-svelte-h":!0}),S(w)!=="svelte-1gv4s4b"&&(w.innerHTML=ve),J=i(e),m(C.$$.fragment,e),Q=i(e),s=d(e,"DIV",{class:!0});var c=E(s);m(O.$$.fragment,c),ie=i(c),z=d(c,"P",{"data-svelte-h":!0}),S(z)!=="svelte-rqsn3u"&&(z.textContent=xe),ae=i(c),H=d(c,"P",{"data-svelte-h":!0}),S(H)!=="svelte-50bukd"&&(H.innerHTML=$e),de=i(c),v=d(c,"DIV",{class:!0});var te=E(v);m(L.$$.fragment,te),ce=i(te),I=d(te,"P",{"data-svelte-h":!0}),S(I)!=="svelte-1hew89w"&&(I.innerHTML=De),te.forEach(t),le=i(c),x=d(c,"DIV",{class:!0});var re=E(x);m(P.$$.fragment,re),ue=i(re),N=d(re,"P",{"data-svelte-h":!0}),S(N)!=="svelte-1k141rk"&&(N.textContent=Ee),re.forEach(t),pe=i(c),$=d(c,"DIV",{class:!0});var se=E($);m(k.$$.fragment,se),fe=i(se),A=d(se,"P",{"data-svelte-h":!0}),S(A)!=="svelte-1vzm9q"&&(A.textContent=Se),se.forEach(t),me=i(c),D=d(c,"DIV",{class:!0});var ne=E(D);m(q.$$.fragment,ne),he=i(ne),V=d(ne,"P",{"data-svelte-h":!0}),S(V)!=="svelte-hi84tp"&&(V.textContent=Te),ne.forEach(t),c.forEach(t),X=i(e),m(F.$$.fragment,e),Y=i(e),p=d(e,"DIV",{class:!0});var oe=E(p);m(M.$$.fragment,oe),ge=i(oe),U=d(oe,"P",{"data-svelte-h":!0}),S(U)!=="svelte-id9kic"&&(U.innerHTML=ye),oe.forEach(t),Z=i(e),W=d(e,"P",{}),E(W).forEach(t),this.h()},h(){T(u,"name","hf:doc:metadata"),T(u,"content",Fe),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){r(document.head,u),l(e,G,n),l(e,R,n),l(e,j,n),h(y,e,n),l(e,B,n),l(e,w,n),l(e,J,n),h(C,e,n),l(e,Q,n),l(e,s,n),h(O,s,null),r(s,ie),r(s,z),r(s,ae),r(s,H),r(s,de),r(s,v),h(L,v,null),r(v,ce),r(v,I),r(s,le),r(s,x),h(P,x,null),r(x,ue),r(x,N),r(s,pe),r(s,$),h(k,$,null),r($,fe),r($,A),r(s,me),r(s,D),h(q,D,null),r(D,he),r(D,V),l(e,X,n),h(F,e,n),l(e,Y,n),l(e,p,n),h(M,p,null),r(p,ge),r(p,U),l(e,Z,n),l(e,W,n),ee=!0},p:Ce,i(e){ee||(g(y.$$.fragment,e),g(C.$$.fragment,e),g(O.$$.fragment,e),g(L.$$.fragment,e),g(P.$$.fragment,e),g(k.$$.fragment,e),g(q.$$.fragment,e),g(F.$$.fragment,e),g(M.$$.fragment,e),ee=!0)},o(e){_(y.$$.fragment,e),_(C.$$.fragment,e),_(O.$$.fragment,e),_(L.$$.fragment,e),_(P.$$.fragment,e),_(k.$$.fragment,e),_(q.$$.fragment,e),_(F.$$.fragment,e),_(M.$$.fragment,e),ee=!1},d(e){e&&(t(G),t(R),t(j),t(B),t(w),t(J),t(Q),t(s),t(X),t(Y),t(p),t(Z),t(W)),t(u),b(y,e),b(C,e),b(O),b(L),b(P),b(k),b(q),b(F,e),b(M)}}}const Fe='{"title":"EulerDiscreteScheduler","local":"eulerdiscretescheduler","sections":[{"title":"EulerDiscreteScheduler","local":"diffusers.EulerDiscreteScheduler","sections":[],"depth":2},{"title":"EulerDiscreteSchedulerOutput","local":"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput","sections":[],"depth":2}],"depth":1}';function Me(be){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends Le{constructor(u){super(),Pe(this,u,Me,qe,we,{})}}export{Ae as component};
