import{s as Ft,o as Wt,n as Nt}from"../chunks/scheduler.6062bdaf.js";import{S as zt,i as Qt,g as o,s as n,r as h,A as Pt,h as i,f as a,c as s,j as Xt,u as c,x as d,k as Rt,y as Dt,a as l,v as p,d as f,t as u,w as m}from"../chunks/index.4bca734e.js";import{T as Bt}from"../chunks/Tip.b9ac1f03.js";import{C as _}from"../chunks/CodeBlock.fa01571c.js";import{H as b}from"../chunks/Heading.723dceba.js";function St(ue){let r,w=`The returned filepath is a pointer to the HF local cache. Therefore, it is important to not modify the file to avoid
having a corrupted cache. If you are interested in getting to know more about how files are cached, please refer to our
<a href="./manage-cache">caching guide</a>.`;return{c(){r=o("p"),r.innerHTML=w},l(g){r=i(g,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1jtqj65"&&(r.innerHTML=w)},m(g,y){l(g,r,y)},p:Nt,d(g){g&&a(r)}}}function Vt(ue){let r,w=`<code>hf_transfer</code> is a power user tool!
It is tested and production-ready,
but it lacks user-friendly features like advanced error handling or proxies.
For more details, please take a look at this <a href="https://huggingface.co/docs/huggingface_hub/hf_transfer" rel="nofollow">section</a>.`;return{c(){r=o("p"),r.innerHTML=w},l(g){r=i(g,"P",{"data-svelte-h":!0}),d(r)!=="svelte-ac3n7l"&&(r.innerHTML=w)},m(g,y){l(g,r,y)},p:Nt,d(g){g&&a(r)}}}function Et(ue){let r,w,g,y,M,ge,T,ht=`The <code>huggingface_hub</code> library provides functions to download files from the repositories
stored on the Hub. You can use these functions independently or integrate them into your
own library, making it more convenient for your users to interact with the Hub. This
guide will show you how to:`,we,j,ct="<li>Download and cache a single file.</li> <li>Download and cache an entire repository.</li> <li>Download files to a local folder.</li>",be,k,_e,J,pt=`The <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> function is the main function for downloading files from the Hub.
It downloads the remote file, caches it on disk (in a version-aware way), and returns its local file path.`,ye,$,$e,H,ve,q,ft=`Select the file to download using the <code>repo_id</code>, <code>repo_type</code> and <code>filename</code> parameters. By default, the file will
be considered as being part of a <code>model</code> repo.`,Me,x,Te,Z,je,U,ut=`By default, the latest version from the <code>main</code> branch is downloaded. However, in some cases you want to download a file
at a particular version (e.g. from a specific branch, a PR, a tag or a commit hash).
To do so, use the <code>revision</code> parameter:`,ke,L,Je,C,mt="<strong>Note:</strong> When using the commit hash, it must be the full-length hash instead of a 7-character commit hash.",He,Y,qe,I,gt=`In case you want to construct the URL used to download a file from a repo, you can use <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a> which returns a URL.
Note that it is used internally by <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a>.`,xe,G,Ze,X,wt=`<a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads an entire repository at a given revision. It uses internally <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> which
means all downloaded files are also cached on your local disk. Downloads are made concurrently to speed-up the process.`,Ue,R,bt="To download a whole repository, just pass the <code>repo_id</code> and <code>repo_type</code>:",Le,B,Ce,N,_t=`<a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads the latest revision by default. If you want a specific repository revision, use the
<code>revision</code> parameter:`,Ye,F,Ie,W,Ge,z,yt=`<a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> provides an easy way to download a repository. However, you don’t always want to download the
entire content of a repository. For example, you might want to prevent downloading all <code>.bin</code> files if you know you’ll
only use the <code>.safetensors</code> weights. You can do that using <code>allow_patterns</code> and <code>ignore_patterns</code> parameters.`,Xe,Q,$t=`These parameters accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing
patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. The pattern matching is
based on <a href="https://docs.python.org/3/library/fnmatch.html" rel="nofollow"><code>fnmatch</code></a>.`,Re,P,vt="For example, you can use <code>allow_patterns</code> to only download JSON configuration files:",Be,D,Ne,S,Mt=`On the other hand, <code>ignore_patterns</code> can exclude certain files from being downloaded. The
following example ignores the <code>.msgpack</code> and <code>.h5</code> file extensions:`,Fe,V,We,E,Tt=`Finally, you can combine both to precisely filter your download. Here is an example to download all json and markdown
files except <code>vocab.json</code>.`,ze,K,Qe,O,Pe,A,jt=`The recommended (and default) way to download files from the Hub is to use the <a href="./manage-cache">cache-system</a>.
You can define your cache location by setting <code>cache_dir</code> parameter (both in <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a>).`,De,ee,kt=`However, in some cases you want to download files and move them to a specific folder. This is useful to get a workflow
closer to what <code>git</code> commands offer. You can do that using the <code>local_dir</code> and <code>local_dir_use_symlinks</code> parameters:`,Se,te,Jt=`<li><code>local_dir</code> must be a path to a folder on your system. The downloaded files will keep the same file structure as in the
repo. For example if <code>filename=&quot;data/train.csv&quot;</code> and <code>local_dir=&quot;path/to/folder&quot;</code>, then the returned filepath will be
<code>&quot;path/to/folder/data/train.csv&quot;</code>.</li> <li><code>local_dir_use_symlinks</code> defines how the file must be saved in your local folder.<ul><li>The default behavior (<code>&quot;auto&quot;</code>) is to duplicate small files (&lt;5MB) and use symlinks for bigger files. Symlinks allow
to optimize both bandwidth and disk usage. However manually editing a symlinked file might corrupt the cache, hence
the duplication for small files. The 5MB threshold can be configured with the <code>HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD</code>
environment variable.</li> <li>If <code>local_dir_use_symlinks=True</code> is set, all files are symlinked for an optimal disk space optimization. This is
for example useful when downloading a huge dataset with thousands of small files.</li> <li>Finally, if you don’t want symlinks at all you can disable them (<code>local_dir_use_symlinks=False</code>). The cache directory
will still be used to check wether the file is already cached or not. If already cached, the file is <strong>duplicated</strong>
from the cache (i.e. saves bandwidth but increases disk usage). If the file is not already cached, it will be
downloaded and moved directly to the local dir. This means that if you need to reuse it somewhere else later, it
will be <strong>re-downloaded</strong>.</li></ul></li>`,Ve,ae,Ht="Here is a table that summarizes the different options to help you choose the parameters that best suit your use case.",Ee,le,qt='<thead><tr><th>Parameters</th> <th align="center">File already cached</th> <th align="center">Returned path</th> <th align="center">Can read path?</th> <th align="center">Can save to path?</th> <th align="center">Optimized bandwidth</th> <th align="center">Optimized disk usage</th></tr></thead> <tbody><tr><td><code>local_dir=None</code></td> <td align="center"></td> <td align="center">symlink in cache</td> <td align="center">✅</td> <td align="center">❌<br/><em>(save would corrupt the cache)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=&quot;auto&quot;</code></td> <td align="center"></td> <td align="center">file or symlink in folder</td> <td align="center">✅</td> <td align="center">✅ <em>(for small files)</em> <br/> ⚠️ <em>(for big files do not resolve path before saving)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=True</code></td> <td align="center"></td> <td align="center">symlink in folder</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(do not resolve path before saving)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">No</td> <td align="center">file in folder</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">❌<br/><em>(if re-run, file is re-downloaded)</em></td> <td align="center">⚠️<br/>(multiple copies if ran in multiple folders)</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">Yes</td> <td align="center">file in folder</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(file has to be cached first)</em></td> <td align="center">❌<br/><em>(file is duplicated)</em></td></tr></tbody>',Ke,ne,xt=`<strong>Note:</strong> if you are on a Windows machine, you need to enable developer mode or run <code>huggingface_hub</code> as admin to enable
symlinks. Check out the <a href="../guides/manage-cache#limitations">cache limitations</a> section for more details.`,Oe,se,Ae,oe,Zt=`You can use the <code>huggingface-cli download</code> command from the terminal to directly download files from the Hub.
Internally, it uses the same <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/v0.21.2/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described above and prints the
returned path to the terminal.`,et,ie,tt,de,Ut=`You can download multiple files at once which displays a progress bar and returns the snapshot path in which the files
are located:`,at,re,lt,he,Lt='For more details about the CLI download command, please refer to the <a href="./cli#huggingface-cli-download">CLI guide</a>.',nt,ce,st,pe,Ct=`If you are running on a machine with high bandwidth,
you can increase your download speed with <a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a>,
a Rust-based library developed to speed up file transfers with the Hub.
To enable it:`,ot,fe,Yt=`<li>Specify the <code>hf_transfer</code> extra when installing <code>huggingface_hub</code>
(e.g. <code>pip install huggingface_hub[hf_transfer]</code>).</li> <li>Set <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable.</li>`,it,v,dt,me,rt;return M=new b({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h1"}}),k=new b({props:{title:"Download a single file",local:"download-a-single-file",headingTag:"h2"}}),$=new Bt({props:{$$slots:{default:[St]},$$scope:{ctx:ue}}}),H=new b({props:{title:"From latest version",local:"from-latest-version",headingTag:"h3"}}),x=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIyZ29vZ2xlJTJGZmxldXJzJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJmbGV1cnMucHklMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>

<span class="hljs-comment"># Download from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, filename=<span class="hljs-string">&quot;fleurs.py&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34/fleurs.py&#x27;</span>`,wrap:!1}}),Z=new b({props:{title:"From specific version",local:"from-specific-version",headingTag:"h3"}}),L=new _({props:{code:"aGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnYxLjAlMjIpJTBBJTBBaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnRlc3QtYnJhbmNoJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYzJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-comment"># Download from the \`v1.0\` tag</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;v1.0&quot;</span>)

<span class="hljs-comment"># Download from the \`test-branch\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;test-branch&quot;</span>)

<span class="hljs-comment"># Download from Pull Request #3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/3&quot;</span>)

<span class="hljs-comment"># Download from a specific commit hash</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),Y=new b({props:{title:"Construct a download URL",local:"construct-a-download-url",headingTag:"h3"}}),G=new b({props:{title:"Download an entire repository",local:"download-an-entire-repository",headingTag:"h2"}}),B=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKSUwQSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJnb29nbGUlMkZmbGV1cnMlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>

<span class="hljs-comment"># Or from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34&#x27;</span>`,wrap:!1}}),F=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/1&quot;</span>)`,wrap:!1}}),W=new b({props:{title:"Filter files to download",local:"filter-files-to-download",headingTag:"h3"}}),D=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, allow_patterns=<span class="hljs-string">&quot;*.json&quot;</span>)`,wrap:!1}}),V=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwaWdub3JlX3BhdHRlcm5zJTNEJTVCJTIyKi5tc2dwYWNrJTIyJTJDJTIwJTIyKi5oNSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, ignore_patterns=[<span class="hljs-string">&quot;*.msgpack&quot;</span>, <span class="hljs-string">&quot;*.h5&quot;</span>])`,wrap:!1}}),K=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmdwdDIlMjIlMkMlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMioubWQlMjIlMkMlMjAlMjIqLmpzb24lMjIlNUQlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjJ2b2NhYi5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;gpt2&quot;</span>, allow_patterns=[<span class="hljs-string">&quot;*.md&quot;</span>, <span class="hljs-string">&quot;*.json&quot;</span>], ignore_patterns=<span class="hljs-string">&quot;vocab.json&quot;</span>)`,wrap:!1}}),O=new b({props:{title:"Download file(s) to local folder",local:"download-files-to-local-folder",headingTag:"h2"}}),se=new b({props:{title:"Download from the CLI",local:"download-from-the-cli",headingTag:"h2"}}),ie=new _({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24=",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),re=new _({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjBtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json model.safetensors
Fetching 2 files: 100%|████████████████████████████████████████████| 2/2 [00:00&lt;00:00, 23831.27it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),ce=new b({props:{title:"Faster downloads",local:"faster-downloads",headingTag:"h2"}}),v=new Bt({props:{warning:!0,$$slots:{default:[Vt]},$$scope:{ctx:ue}}}),{c(){r=o("meta"),w=n(),g=o("p"),y=n(),h(M.$$.fragment),ge=n(),T=o("p"),T.innerHTML=ht,we=n(),j=o("ul"),j.innerHTML=ct,be=n(),h(k.$$.fragment),_e=n(),J=o("p"),J.innerHTML=pt,ye=n(),h($.$$.fragment),$e=n(),h(H.$$.fragment),ve=n(),q=o("p"),q.innerHTML=ft,Me=n(),h(x.$$.fragment),Te=n(),h(Z.$$.fragment),je=n(),U=o("p"),U.innerHTML=ut,ke=n(),h(L.$$.fragment),Je=n(),C=o("p"),C.innerHTML=mt,He=n(),h(Y.$$.fragment),qe=n(),I=o("p"),I.innerHTML=gt,xe=n(),h(G.$$.fragment),Ze=n(),X=o("p"),X.innerHTML=wt,Ue=n(),R=o("p"),R.innerHTML=bt,Le=n(),h(B.$$.fragment),Ce=n(),N=o("p"),N.innerHTML=_t,Ye=n(),h(F.$$.fragment),Ie=n(),h(W.$$.fragment),Ge=n(),z=o("p"),z.innerHTML=yt,Xe=n(),Q=o("p"),Q.innerHTML=$t,Re=n(),P=o("p"),P.innerHTML=vt,Be=n(),h(D.$$.fragment),Ne=n(),S=o("p"),S.innerHTML=Mt,Fe=n(),h(V.$$.fragment),We=n(),E=o("p"),E.innerHTML=Tt,ze=n(),h(K.$$.fragment),Qe=n(),h(O.$$.fragment),Pe=n(),A=o("p"),A.innerHTML=jt,De=n(),ee=o("p"),ee.innerHTML=kt,Se=n(),te=o("ul"),te.innerHTML=Jt,Ve=n(),ae=o("p"),ae.textContent=Ht,Ee=n(),le=o("table"),le.innerHTML=qt,Ke=n(),ne=o("p"),ne.innerHTML=xt,Oe=n(),h(se.$$.fragment),Ae=n(),oe=o("p"),oe.innerHTML=Zt,et=n(),h(ie.$$.fragment),tt=n(),de=o("p"),de.textContent=Ut,at=n(),h(re.$$.fragment),lt=n(),he=o("p"),he.innerHTML=Lt,nt=n(),h(ce.$$.fragment),st=n(),pe=o("p"),pe.innerHTML=Ct,ot=n(),fe=o("ol"),fe.innerHTML=Yt,it=n(),h(v.$$.fragment),dt=n(),me=o("p"),this.h()},l(e){const t=Pt("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(a),w=s(e),g=i(e,"P",{}),Xt(g).forEach(a),y=s(e),c(M.$$.fragment,e),ge=s(e),T=i(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-10amgpw"&&(T.innerHTML=ht),we=s(e),j=i(e,"UL",{"data-svelte-h":!0}),d(j)!=="svelte-1jcodts"&&(j.innerHTML=ct),be=s(e),c(k.$$.fragment,e),_e=s(e),J=i(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1dshq88"&&(J.innerHTML=pt),ye=s(e),c($.$$.fragment,e),$e=s(e),c(H.$$.fragment,e),ve=s(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-18kdxej"&&(q.innerHTML=ft),Me=s(e),c(x.$$.fragment,e),Te=s(e),c(Z.$$.fragment,e),je=s(e),U=i(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-16duplw"&&(U.innerHTML=ut),ke=s(e),c(L.$$.fragment,e),Je=s(e),C=i(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1inqh8h"&&(C.innerHTML=mt),He=s(e),c(Y.$$.fragment,e),qe=s(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1x3eif6"&&(I.innerHTML=gt),xe=s(e),c(G.$$.fragment,e),Ze=s(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-189p8bp"&&(X.innerHTML=wt),Ue=s(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-18b676r"&&(R.innerHTML=bt),Le=s(e),c(B.$$.fragment,e),Ce=s(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-11apwz2"&&(N.innerHTML=_t),Ye=s(e),c(F.$$.fragment,e),Ie=s(e),c(W.$$.fragment,e),Ge=s(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-qr8odw"&&(z.innerHTML=yt),Xe=s(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-u3vbhu"&&(Q.innerHTML=$t),Re=s(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1dn885x"&&(P.innerHTML=vt),Be=s(e),c(D.$$.fragment,e),Ne=s(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-uzetax"&&(S.innerHTML=Mt),Fe=s(e),c(V.$$.fragment,e),We=s(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-ndvph"&&(E.innerHTML=Tt),ze=s(e),c(K.$$.fragment,e),Qe=s(e),c(O.$$.fragment,e),Pe=s(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1q0be70"&&(A.innerHTML=jt),De=s(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-ph8yhc"&&(ee.innerHTML=kt),Se=s(e),te=i(e,"UL",{"data-svelte-h":!0}),d(te)!=="svelte-8wrzrg"&&(te.innerHTML=Jt),Ve=s(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-bmnyq5"&&(ae.textContent=Ht),Ee=s(e),le=i(e,"TABLE",{"data-svelte-h":!0}),d(le)!=="svelte-1qvhd9t"&&(le.innerHTML=qt),Ke=s(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1slb1nq"&&(ne.innerHTML=xt),Oe=s(e),c(se.$$.fragment,e),Ae=s(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-3gdvk7"&&(oe.innerHTML=Zt),et=s(e),c(ie.$$.fragment,e),tt=s(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-c19wqr"&&(de.textContent=Ut),at=s(e),c(re.$$.fragment,e),lt=s(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-n4le8a"&&(he.innerHTML=Lt),nt=s(e),c(ce.$$.fragment,e),st=s(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-7tg4bb"&&(pe.innerHTML=Ct),ot=s(e),fe=i(e,"OL",{"data-svelte-h":!0}),d(fe)!=="svelte-qiartd"&&(fe.innerHTML=Yt),it=s(e),c(v.$$.fragment,e),dt=s(e),me=i(e,"P",{}),Xt(me).forEach(a),this.h()},h(){Rt(r,"name","hf:doc:metadata"),Rt(r,"content",Kt)},m(e,t){Dt(document.head,r),l(e,w,t),l(e,g,t),l(e,y,t),p(M,e,t),l(e,ge,t),l(e,T,t),l(e,we,t),l(e,j,t),l(e,be,t),p(k,e,t),l(e,_e,t),l(e,J,t),l(e,ye,t),p($,e,t),l(e,$e,t),p(H,e,t),l(e,ve,t),l(e,q,t),l(e,Me,t),p(x,e,t),l(e,Te,t),p(Z,e,t),l(e,je,t),l(e,U,t),l(e,ke,t),p(L,e,t),l(e,Je,t),l(e,C,t),l(e,He,t),p(Y,e,t),l(e,qe,t),l(e,I,t),l(e,xe,t),p(G,e,t),l(e,Ze,t),l(e,X,t),l(e,Ue,t),l(e,R,t),l(e,Le,t),p(B,e,t),l(e,Ce,t),l(e,N,t),l(e,Ye,t),p(F,e,t),l(e,Ie,t),p(W,e,t),l(e,Ge,t),l(e,z,t),l(e,Xe,t),l(e,Q,t),l(e,Re,t),l(e,P,t),l(e,Be,t),p(D,e,t),l(e,Ne,t),l(e,S,t),l(e,Fe,t),p(V,e,t),l(e,We,t),l(e,E,t),l(e,ze,t),p(K,e,t),l(e,Qe,t),p(O,e,t),l(e,Pe,t),l(e,A,t),l(e,De,t),l(e,ee,t),l(e,Se,t),l(e,te,t),l(e,Ve,t),l(e,ae,t),l(e,Ee,t),l(e,le,t),l(e,Ke,t),l(e,ne,t),l(e,Oe,t),p(se,e,t),l(e,Ae,t),l(e,oe,t),l(e,et,t),p(ie,e,t),l(e,tt,t),l(e,de,t),l(e,at,t),p(re,e,t),l(e,lt,t),l(e,he,t),l(e,nt,t),p(ce,e,t),l(e,st,t),l(e,pe,t),l(e,ot,t),l(e,fe,t),l(e,it,t),p(v,e,t),l(e,dt,t),l(e,me,t),rt=!0},p(e,[t]){const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),$.$set(It);const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),v.$set(Gt)},i(e){rt||(f(M.$$.fragment,e),f(k.$$.fragment,e),f($.$$.fragment,e),f(H.$$.fragment,e),f(x.$$.fragment,e),f(Z.$$.fragment,e),f(L.$$.fragment,e),f(Y.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(W.$$.fragment,e),f(D.$$.fragment,e),f(V.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(v.$$.fragment,e),rt=!0)},o(e){u(M.$$.fragment,e),u(k.$$.fragment,e),u($.$$.fragment,e),u(H.$$.fragment,e),u(x.$$.fragment,e),u(Z.$$.fragment,e),u(L.$$.fragment,e),u(Y.$$.fragment,e),u(G.$$.fragment,e),u(B.$$.fragment,e),u(F.$$.fragment,e),u(W.$$.fragment,e),u(D.$$.fragment,e),u(V.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(v.$$.fragment,e),rt=!1},d(e){e&&(a(w),a(g),a(y),a(ge),a(T),a(we),a(j),a(be),a(_e),a(J),a(ye),a($e),a(ve),a(q),a(Me),a(Te),a(je),a(U),a(ke),a(Je),a(C),a(He),a(qe),a(I),a(xe),a(Ze),a(X),a(Ue),a(R),a(Le),a(Ce),a(N),a(Ye),a(Ie),a(Ge),a(z),a(Xe),a(Q),a(Re),a(P),a(Be),a(Ne),a(S),a(Fe),a(We),a(E),a(ze),a(Qe),a(Pe),a(A),a(De),a(ee),a(Se),a(te),a(Ve),a(ae),a(Ee),a(le),a(Ke),a(ne),a(Oe),a(Ae),a(oe),a(et),a(tt),a(de),a(at),a(lt),a(he),a(nt),a(st),a(pe),a(ot),a(fe),a(it),a(dt),a(me)),a(r),m(M,e),m(k,e),m($,e),m(H,e),m(x,e),m(Z,e),m(L,e),m(Y,e),m(G,e),m(B,e),m(F,e),m(W,e),m(D,e),m(V,e),m(K,e),m(O,e),m(se,e),m(ie,e),m(re,e),m(ce,e),m(v,e)}}}const Kt='{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Download a single file","local":"download-a-single-file","sections":[{"title":"From latest version","local":"from-latest-version","sections":[],"depth":3},{"title":"From specific version","local":"from-specific-version","sections":[],"depth":3},{"title":"Construct a download URL","local":"construct-a-download-url","sections":[],"depth":3}],"depth":2},{"title":"Download an entire repository","local":"download-an-entire-repository","sections":[{"title":"Filter files to download","local":"filter-files-to-download","sections":[],"depth":3}],"depth":2},{"title":"Download file(s) to local folder","local":"download-files-to-local-folder","sections":[],"depth":2},{"title":"Download from the CLI","local":"download-from-the-cli","sections":[],"depth":2},{"title":"Faster downloads","local":"faster-downloads","sections":[],"depth":2}],"depth":1}';function Ot(ue){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class na extends zt{constructor(r){super(),Qt(this,r,Ot,Et,Ft,{})}}export{na as component};
