import{s as Jt,o as kt,n as Xt}from"../chunks/scheduler.182ea377.js";import{S as jt,i as Ct,g as a,s as o,r as g,A as Zt,h as r,f as n,c as s,j as L,u,x as m,k as $,y as t,a as l,v as h,d as _,t as v,w as b}from"../chunks/index.abf12888.js";import{T as Dt}from"../chunks/Tip.230e2334.js";import{D as G}from"../chunks/Docstring.93f6f462.js";import{C as Et}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ut}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Ae}from"../chunks/Heading.16916d63.js";function Wt(ae){let d,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines. Also, to know more about reducing the memory usage of this pipeline, refer to the [“Reduce memory usage”] section <a href="../../using-diffusers/svd#reduce-memory-usage">here</a>.';return{c(){d=a("p"),d.innerHTML=M},l(x){d=r(x,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1lhv250"&&(d.innerHTML=M)},m(x,w){l(x,d,w)},p:Xt,d(x){x&&n(d)}}}function Ht(ae){let d,M="Examples:",x,w,I;return w=new Et({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSTJWR2VuWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwSTJWR2VuWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYWxpLXZpbGFiJTJGaTJ2Z2VuLXhsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFpbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhbGktdmlsYWIlMkZpMnZnZW4teGwlMkZibG9iJTJGbWFpbiUyRmRhdGElMkZ0ZXN0X2ltYWdlcyUyRmltZ18wMDA5LnBuZyUzRnJhdyUzRHRydWUlMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1hZ2VfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJQYXBlcnMlMjB3ZXJlJTIwZmxvYXRpbmclMjBpbiUyMHRoZSUyMGFpciUyMG9uJTIwYSUyMHRhYmxlJTIwaW4lMjB0aGUlMjBsaWJyYXJ5JTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyRGlzdG9ydGVkJTJDJTIwZGlzY29udGludW91cyUyQyUyMFVnbHklMkMlMjBibHVycnklMkMlMjBsb3clMjByZXNvbHV0aW9uJTJDJTIwbW90aW9ubGVzcyUyQyUyMHN0YXRpYyUyQyUyMGRpc2ZpZ3VyZWQlMkMlMjBkaXNjb25uZWN0ZWQlMjBsaW1icyUyQyUyMFVnbHklMjBmYWNlcyUyQyUyMGluY29tcGxldGUlMjBhcm1zJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoODg4OCklMEElMEFmcmFtZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q5LjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMEEpLmZyYW1lcyU1QjAlNUQlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJpMnYuZ2lmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> I2VGenXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = I2VGenXLPipeline.from_pretrained(<span class="hljs-string">&quot;ali-vilab/i2vgen-xl&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;https://github.com/ali-vilab/i2vgen-xl/blob/main/data/test_images/img_0009.png?raw=true&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(image_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Papers were floating in the air on a table in the library&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Distorted, discontinuous, Ugly, blurry, low resolution, motionless, static, disfigured, disconnected limbs, Ugly faces, incomplete arms&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">8888</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>frames = pipeline(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">9.0</span>,
<span class="hljs-meta">... </span>    generator=generator
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_gif(frames, <span class="hljs-string">&quot;i2v.gif&quot;</span>)`,wrap:!1}}),{c(){d=a("p"),d.textContent=M,x=o(),g(w.$$.fragment)},l(f){d=r(f,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=M),x=s(f),u(w.$$.fragment,f)},m(f,T){l(f,d,T),l(f,x,T),h(w,f,T),I=!0},p:Xt,i(f){I||(_(w.$$.fragment,f),I=!0)},o(f){v(w.$$.fragment,f),I=!1},d(f){f&&(n(d),n(x)),b(w,f)}}}function At(ae){let d,M,x,w,I,f,T,ct='<a href="https://hf.co/papers/2311.04145.pdf" rel="nofollow">I2VGen-XL: High-Quality Image-to-Video Synthesis via Cascaded Diffusion Models</a> by Shiwei Zhang, Jiayu Wang, Yingya Zhang, Kang Zhao, Hangjie Yuan, Zhiwu Qin, Xiang Wang, Deli Zhao, and Jingren Zhou.',we,H,mt="The abstract from the paper is:",Ie,A,ft='<em>Video synthesis has recently made remarkable strides benefiting from the rapid development of diffusion models. However, it still encounters challenges in terms of semantic accuracy, clarity and spatio-temporal continuity. They primarily arise from the scarcity of well-aligned text-video data and the complex inherent structure of videos, making it difficult for the model to simultaneously ensure semantic and qualitative excellence. In this report, we propose a cascaded I2VGen-XL approach that enhances model performance by decoupling these two factors and ensures the alignment of the input data by utilizing static images as a form of crucial guidance. I2VGen-XL consists of two stages: i) the base stage guarantees coherent semantics and preserves content from input images by using two hierarchical encoders, and ii) the refinement stage enhances the video’s details by incorporating an additional brief text and improves the resolution to 1280×720. To improve the diversity, we collect around 35 million single-shot text-video pairs and 6 billion text-image pairs to optimize the model. By this means, I2VGen-XL can simultaneously enhance the semantic accuracy, continuity of details and clarity of generated videos. Through extensive experiments, we have investigated the underlying principles of I2VGen-XL and compared it with current top methods, which can demonstrate its effectiveness on diverse data. The source code and models will be publicly available at <a href="https://i2vgen-xl.github.io/" rel="nofollow">this https URL</a>.</em>',ye,B,gt='The original codebase can be found <a href="https://github.com/ali-vilab/i2vgen-xl/" rel="nofollow">here</a>. The model checkpoints can be found <a href="https://huggingface.co/ali-vilab/" rel="nofollow">here</a>.',Le,J,$e,R,ut="Sample output with I2VGenXL:",Te,S,ht=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/i2vgen-xl-example.gif" alt="library" style="width: 300px;"/></center></td></tr></tbody>`,Me,z,Ve,F,_t='<li>I2VGenXL always uses a <code>clip_skip</code> value of 1. This means it leverages the penultimate layer representations from the text encoder of CLIP.</li> <li>It can generate videos of quality that is often on par with <a href="../../using-diffusers/svd">Stable Video Diffusion</a> (SVD).</li> <li>Unlike SVD, it additionally accepts text prompts as inputs.</li> <li>It can generate higher resolution videos.</li> <li>When using the <a href="/docs/diffusers/v0.26.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> (which is default for this pipeline), less than 50 steps for inference leads to bad results.</li>',Ge,N,Pe,p,O,Be,re,vt='Pipeline for image-to-video generation as proposed in <a href="https://i2vgen-xl.github.io/" rel="nofollow">I2VGenXL</a>.',Re,le,bt=`This model inherits from <a href="/docs/diffusers/v0.26.3/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Se,V,Y,ze,pe,xt='The call function to the pipeline for image-to-video generation with <a href="/docs/diffusers/v0.26.3/en/api/pipelines/i2vgenxl#diffusers.I2VGenXLPipeline">I2VGenXLPipeline</a>.',Fe,k,Ne,j,Q,Oe,de,wt="Disables the FreeU mechanism if enabled.",Ye,C,q,Qe,ce,It=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,qe,Z,K,Ke,me,yt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,et,y,ee,tt,fe,Lt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',nt,ge,$t="The suffixes after the scaling factors represent the stages where they are being applied.",it,ue,Tt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ot,D,te,st,he,Mt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,at,E,ne,rt,_e,Vt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,lt,U,ie,pt,ve,Gt="Encodes the prompt into text encoder hidden states.",Xe,oe,Je,P,se,dt,be,Pt="Output class for image-to-video pipeline.",ke,xe,je;return I=new Ae({props:{title:"I2VGen-XL",local:"i2vgen-xl",headingTag:"h1"}}),J=new Dt({props:{$$slots:{default:[Wt]},$$scope:{ctx:ae}}}),z=new Ae({props:{title:"Notes",local:"notes",headingTag:"h2"}}),N=new Ae({props:{title:"I2VGenXLPipeline",local:"diffusers.I2VGenXLPipeline",headingTag:"h2"}}),O=new G({props:{name:"class diffusers.I2VGenXLPipeline",anchor:"diffusers.I2VGenXLPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"unet",val:": I2VGenXLUNet"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.26.3/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.I2VGenXLPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.I2VGenXLPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.I2VGenXLPipeline.unet",description:`<strong>unet</strong> (<code>I2VGenXLUNet</code>) &#x2014;
A <code>I2VGenXLUNet</code> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.I2VGenXLPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L109"}}),Y=new G({props:{name:"__call__",anchor:"diffusers.I2VGenXLPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = 704"},{name:"width",val:": Optional = 1280"},{name:"target_fps",val:": Optional = 16"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"decode_chunk_size",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = 1"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
Image or images to guide image generation. If you provide a tensor, it needs to be compatible with
<a href="https://huggingface.co/lambdalabs/sd-image-variations-diffusers/blob/main/feature_extractor/preprocessor_config.json" rel="nofollow"><code>CLIPImageProcessor</code></a>.`,name:"image"},{anchor:"diffusers.I2VGenXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.I2VGenXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.I2VGenXLPipeline.__call__.target_fps",description:`<strong>target_fps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frames per second. The rate at which the generated images shall be exported to a video after generation. This is also used as a &#x201C;micro-condition&#x201D; while generation.`,name:"target_fps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of video frames to generate.`,name:"num_frames"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps.`,name:"num_inference_steps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.26.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of frames to decode at a time. The higher the chunk size, the higher the temporal consistency
between frames, but also the higher the memory consumption. By default, the decoder will decode all frames at once
for maximal quality. Reduce <code>decode_chunk_size</code> to reduce memory usage.`,name:"decode_chunk_size"},{anchor:"diffusers.I2VGenXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.I2VGenXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.I2VGenXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.3/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.I2VGenXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.I2VGenXLPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L594",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.26.3/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.3/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> or <code>tuple</code></p>
`}}),k=new Ut({props:{anchor:"diffusers.I2VGenXLPipeline.__call__.example",$$slots:{default:[Ht]},$$scope:{ctx:ae}}}),Q=new G({props:{name:"disable_freeu",anchor:"diffusers.I2VGenXLPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L590"}}),q=new G({props:{name:"disable_vae_slicing",anchor:"diffusers.I2VGenXLPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L176"}}),K=new G({props:{name:"disable_vae_tiling",anchor:"diffusers.I2VGenXLPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L193"}}),ee=new G({props:{name:"enable_freeu",anchor:"diffusers.I2VGenXLPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L567"}}),te=new G({props:{name:"enable_vae_slicing",anchor:"diffusers.I2VGenXLPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L168"}}),ne=new G({props:{name:"enable_vae_tiling",anchor:"diffusers.I2VGenXLPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L184"}}),ie=new G({props:{name:"encode_prompt",anchor:"diffusers.I2VGenXLPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_videos_per_prompt",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L200"}}),oe=new Ae({props:{title:"I2VGenXLPipelineOutput",local:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",headingTag:"h2"}}),se=new G({props:{name:"class diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput.frames",description:`<strong>frames</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
List of denoised frames (essentially images) as NumPy arrays of shape <code>(height, width, num_channels)</code> or as
a <code>torch</code> tensor. The length of the list denotes the video length (the number of frames).`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L95"}}),{c(){d=a("meta"),M=o(),x=a("p"),w=o(),g(I.$$.fragment),f=o(),T=a("p"),T.innerHTML=ct,we=o(),H=a("p"),H.textContent=mt,Ie=o(),A=a("p"),A.innerHTML=ft,ye=o(),B=a("p"),B.innerHTML=gt,Le=o(),g(J.$$.fragment),$e=o(),R=a("p"),R.textContent=ut,Te=o(),S=a("table"),S.innerHTML=ht,Me=o(),g(z.$$.fragment),Ve=o(),F=a("ul"),F.innerHTML=_t,Ge=o(),g(N.$$.fragment),Pe=o(),p=a("div"),g(O.$$.fragment),Be=o(),re=a("p"),re.innerHTML=vt,Re=o(),le=a("p"),le.innerHTML=bt,Se=o(),V=a("div"),g(Y.$$.fragment),ze=o(),pe=a("p"),pe.innerHTML=xt,Fe=o(),g(k.$$.fragment),Ne=o(),j=a("div"),g(Q.$$.fragment),Oe=o(),de=a("p"),de.textContent=wt,Ye=o(),C=a("div"),g(q.$$.fragment),Qe=o(),ce=a("p"),ce.innerHTML=It,qe=o(),Z=a("div"),g(K.$$.fragment),Ke=o(),me=a("p"),me.innerHTML=yt,et=o(),y=a("div"),g(ee.$$.fragment),tt=o(),fe=a("p"),fe.innerHTML=Lt,nt=o(),ge=a("p"),ge.textContent=$t,it=o(),ue=a("p"),ue.innerHTML=Tt,ot=o(),D=a("div"),g(te.$$.fragment),st=o(),he=a("p"),he.textContent=Mt,at=o(),E=a("div"),g(ne.$$.fragment),rt=o(),_e=a("p"),_e.textContent=Vt,lt=o(),U=a("div"),g(ie.$$.fragment),pt=o(),ve=a("p"),ve.textContent=Gt,Xe=o(),g(oe.$$.fragment),Je=o(),P=a("div"),g(se.$$.fragment),dt=o(),be=a("p"),be.textContent=Pt,ke=o(),xe=a("p"),this.h()},l(e){const i=Zt("svelte-u9bgzb",document.head);d=r(i,"META",{name:!0,content:!0}),i.forEach(n),M=s(e),x=r(e,"P",{}),L(x).forEach(n),w=s(e),u(I.$$.fragment,e),f=s(e),T=r(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1wrjkyv"&&(T.innerHTML=ct),we=s(e),H=r(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1cwsb16"&&(H.textContent=mt),Ie=s(e),A=r(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-uj6rwn"&&(A.innerHTML=ft),ye=s(e),B=r(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1fvvwfs"&&(B.innerHTML=gt),Le=s(e),u(J.$$.fragment,e),$e=s(e),R=r(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-e24chm"&&(R.textContent=ut),Te=s(e),S=r(e,"TABLE",{"data-svelte-h":!0}),m(S)!=="svelte-1h3mo59"&&(S.innerHTML=ht),Me=s(e),u(z.$$.fragment,e),Ve=s(e),F=r(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-1ypu37w"&&(F.innerHTML=_t),Ge=s(e),u(N.$$.fragment,e),Pe=s(e),p=r(e,"DIV",{class:!0});var c=L(p);u(O.$$.fragment,c),Be=s(c),re=r(c,"P",{"data-svelte-h":!0}),m(re)!=="svelte-va7c9e"&&(re.innerHTML=vt),Re=s(c),le=r(c,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1vu93js"&&(le.innerHTML=bt),Se=s(c),V=r(c,"DIV",{class:!0});var X=L(V);u(Y.$$.fragment,X),ze=s(X),pe=r(X,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-b4xi9d"&&(pe.innerHTML=xt),Fe=s(X),u(k.$$.fragment,X),X.forEach(n),Ne=s(c),j=r(c,"DIV",{class:!0});var Ce=L(j);u(Q.$$.fragment,Ce),Oe=s(Ce),de=r(Ce,"P",{"data-svelte-h":!0}),m(de)!=="svelte-psupw6"&&(de.textContent=wt),Ce.forEach(n),Ye=s(c),C=r(c,"DIV",{class:!0});var Ze=L(C);u(q.$$.fragment,Ze),Qe=s(Ze),ce=r(Ze,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1s3c06i"&&(ce.innerHTML=It),Ze.forEach(n),qe=s(c),Z=r(c,"DIV",{class:!0});var De=L(Z);u(K.$$.fragment,De),Ke=s(De),me=r(De,"P",{"data-svelte-h":!0}),m(me)!=="svelte-pkn4ui"&&(me.innerHTML=yt),De.forEach(n),et=s(c),y=r(c,"DIV",{class:!0});var W=L(y);u(ee.$$.fragment,W),tt=s(W),fe=r(W,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1f3tmq1"&&(fe.innerHTML=Lt),nt=s(W),ge=r(W,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-xjijlp"&&(ge.textContent=$t),it=s(W),ue=r(W,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-hy0nzs"&&(ue.innerHTML=Tt),W.forEach(n),ot=s(c),D=r(c,"DIV",{class:!0});var Ee=L(D);u(te.$$.fragment,Ee),st=s(Ee),he=r(Ee,"P",{"data-svelte-h":!0}),m(he)!=="svelte-14bnrb6"&&(he.textContent=Mt),Ee.forEach(n),at=s(c),E=r(c,"DIV",{class:!0});var Ue=L(E);u(ne.$$.fragment,Ue),rt=s(Ue),_e=r(Ue,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1xwrf7t"&&(_e.textContent=Vt),Ue.forEach(n),lt=s(c),U=r(c,"DIV",{class:!0});var We=L(U);u(ie.$$.fragment,We),pt=s(We),ve=r(We,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-16q0ax1"&&(ve.textContent=Gt),We.forEach(n),c.forEach(n),Xe=s(e),u(oe.$$.fragment,e),Je=s(e),P=r(e,"DIV",{class:!0});var He=L(P);u(se.$$.fragment,He),dt=s(He),be=r(He,"P",{"data-svelte-h":!0}),m(be)!=="svelte-ulnuw9"&&(be.textContent=Pt),He.forEach(n),ke=s(e),xe=r(e,"P",{}),L(xe).forEach(n),this.h()},h(){$(d,"name","hf:doc:metadata"),$(d,"content",Bt),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,d),l(e,M,i),l(e,x,i),l(e,w,i),h(I,e,i),l(e,f,i),l(e,T,i),l(e,we,i),l(e,H,i),l(e,Ie,i),l(e,A,i),l(e,ye,i),l(e,B,i),l(e,Le,i),h(J,e,i),l(e,$e,i),l(e,R,i),l(e,Te,i),l(e,S,i),l(e,Me,i),h(z,e,i),l(e,Ve,i),l(e,F,i),l(e,Ge,i),h(N,e,i),l(e,Pe,i),l(e,p,i),h(O,p,null),t(p,Be),t(p,re),t(p,Re),t(p,le),t(p,Se),t(p,V),h(Y,V,null),t(V,ze),t(V,pe),t(V,Fe),h(k,V,null),t(p,Ne),t(p,j),h(Q,j,null),t(j,Oe),t(j,de),t(p,Ye),t(p,C),h(q,C,null),t(C,Qe),t(C,ce),t(p,qe),t(p,Z),h(K,Z,null),t(Z,Ke),t(Z,me),t(p,et),t(p,y),h(ee,y,null),t(y,tt),t(y,fe),t(y,nt),t(y,ge),t(y,it),t(y,ue),t(p,ot),t(p,D),h(te,D,null),t(D,st),t(D,he),t(p,at),t(p,E),h(ne,E,null),t(E,rt),t(E,_e),t(p,lt),t(p,U),h(ie,U,null),t(U,pt),t(U,ve),l(e,Xe,i),h(oe,e,i),l(e,Je,i),l(e,P,i),h(se,P,null),t(P,dt),t(P,be),l(e,ke,i),l(e,xe,i),je=!0},p(e,[i]){const c={};i&2&&(c.$$scope={dirty:i,ctx:e}),J.$set(c);const X={};i&2&&(X.$$scope={dirty:i,ctx:e}),k.$set(X)},i(e){je||(_(I.$$.fragment,e),_(J.$$.fragment,e),_(z.$$.fragment,e),_(N.$$.fragment,e),_(O.$$.fragment,e),_(Y.$$.fragment,e),_(k.$$.fragment,e),_(Q.$$.fragment,e),_(q.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),je=!0)},o(e){v(I.$$.fragment,e),v(J.$$.fragment,e),v(z.$$.fragment,e),v(N.$$.fragment,e),v(O.$$.fragment,e),v(Y.$$.fragment,e),v(k.$$.fragment,e),v(Q.$$.fragment,e),v(q.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),v(ie.$$.fragment,e),v(oe.$$.fragment,e),v(se.$$.fragment,e),je=!1},d(e){e&&(n(M),n(x),n(w),n(f),n(T),n(we),n(H),n(Ie),n(A),n(ye),n(B),n(Le),n($e),n(R),n(Te),n(S),n(Me),n(Ve),n(F),n(Ge),n(Pe),n(p),n(Xe),n(Je),n(P),n(ke),n(xe)),n(d),b(I,e),b(J,e),b(z,e),b(N,e),b(O),b(Y),b(k),b(Q),b(q),b(K),b(ee),b(te),b(ne),b(ie),b(oe,e),b(se)}}}const Bt='{"title":"I2VGen-XL","local":"i2vgen-xl","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"I2VGenXLPipeline","local":"diffusers.I2VGenXLPipeline","sections":[],"depth":2},{"title":"I2VGenXLPipelineOutput","local":"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput","sections":[],"depth":2}],"depth":1}';function Rt(ae){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends jt{constructor(d){super(),Ct(this,d,Rt,At,Jt,{})}}export{qt as component};
