import{s as $n,n as Jn,o as _n}from"../chunks/scheduler.65852ee5.js";import{S as kn,i as xn,g as a,s as n,r as o,A as Zn,h as p,f as l,c as i,j as ms,u as f,x as m,k as Me,l as is,y as ue,a as s,v as r,d as M,t as u,w as y}from"../chunks/index.aa74147d.js";import{D as In,C as c}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as b,E as Hn}from"../chunks/getInferenceSnippets.0bc01211.js";function Ln(os){let h,ye,fe,ce,T,ge,C,he,w,fs='<em>作者: <a href="https://huggingface.co/jamarks" rel="nofollow">Jacob Marks</a></em>',be,U,rs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_cover_image.jpg" alt="Art Analysis Cover Image"/>',de,$,Ms="<strong>视觉数据如图像非常富含信息，但其非结构化的性质使得分析变得困难。</strong>",ve,J,us='在这个 Notebook 中，我们将探索如何使用多模态嵌入和计算属性来分析图像中的艺术风格。我们将使用来自 🤗 Hub 的 <a href="https://huggingface.co/datasets/huggan/wikiart" rel="nofollow">WikiArt 数据集</a>，并将其加载到 <strong>FiftyOne</strong> 中进行数据分析和可视化。我们将以多种方式深入分析数据：',je,_,ys='<li><p><strong>图像相似性搜索与语义搜索</strong>：我们将使用预训练的 <a href="https://huggingface.co/openai/clip-vit-base-patch32" rel="nofollow">CLIP</a> 模型，从 🤗 Transformers 生成数据集中的图像的多模态嵌入，并索引数据以进行无结构搜索。</p></li> <li><p><strong>聚类与可视化</strong>：我们将基于艺术风格使用嵌入对图像进行聚类，并使用 UMAP 降维算法可视化结果。</p></li> <li><p><strong>独特性分析</strong>：我们将使用嵌入为每张图像分配一个独特性评分，依据它与数据集中其他图像的相似度。</p></li> <li><p><strong>图像质量分析</strong>：我们将计算每张图像的亮度、对比度和饱和度等质量指标，并查看这些指标与图像的艺术风格如何相关。</p></li>',Te,k,Ce,x,cs="为了运行这个 Notebook ，你需要安装下面的库：",we,Z,Ue,I,gs='为了下载的更加轻量快捷，安装 <a href="https://pypi.org/project/hf-transfer/" rel="nofollow">HF Transfer</a>:',$e,H,Je,L,hs="并且通过设置环境变量 <code>HF_HUB_ENABLE_HF_TRANSFER</code> 来启用它：",_e,F,ke,d,bs="<b>注意：</b> 本 Notebook 在以下版本下进行了测试：<code>transformers==4.40.0</code>，<code>huggingface_hub==0.22.2</code>，和 <code>fiftyone==0.23.8</code>。",xe,G,ds="现在我们来导入本 Notebook 中需要的模块：",Ze,W,Ie,X,vs='我们首先通过 🤗 Hub 将 WikiArt 数据集加载到 <strong>FiftyOne</strong> 中。这个数据集也可以通过 Hugging Face 的 <code>datasets</code> 库加载，但我们将使用 <a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">FiftyOne 的 🤗 Hub 集成</a> 直接从 Datasets 服务器获取数据。为了加速计算，我们只下载前 1,000 个样本。',He,z,Le,R,js="打印数据集的摘要，以查看其包含的内容：",Fe,V,Ge,N,Ts=`Name:        wikiart
Media type:  image
Num samples: 1000
Persistent:  False
Tags:        []
Sample fields:
    id:       fiftyone.core.fields.ObjectIdField
    filepath: fiftyone.core.fields.StringField
    tags:     fiftyone.core.fields.ListField(fiftyone.core.fields.StringField)
    metadata: fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.metadata.ImageMetadata)
    artist:   fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    style:    fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    genre:    fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    row_idx:  fiftyone.core.fields.IntField
`,We,B,Cs='在 <a href="https://docs.voxel51.com/user_guide/app.html" rel="nofollow">FiftyOne 应用</a> 中可视化数据集：',Xe,q,ze,P,ws='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_wikiart_dataset.jpg" alt="WikiArt Dataset"/>',Re,Y,Us="让我们列出我们将要分析其风格的艺术家名字：",Ve,A,Ne,E,$s=`['Unknown Artist', 'albrecht-durer', 'boris-kustodiev', 'camille-pissarro', 'childe-hassam', 'claude-monet', 'edgar-degas', 'eugene-boudin', 'gustave-dore', 'ilya-repin', 'ivan-aivazovsky', 'ivan-shishkin', 'john-singer-sargent', 'marc-chagall', 'martiros-saryan', 'nicholas-roerich', 'pablo-picasso', 'paul-cezanne', 'pierre-auguste-renoir', 'pyotr-konchalovsky', 'raphael-kirchner', 'rembrandt', 'salvador-dali', 'vincent-van-gogh']
`,Be,Q,qe,S,Js="当你发现一件你喜欢的艺术作品时，想要找到相似的作品是很自然的。我们可以通过向量嵌入来实现这一点！更重要的是，通过使用多模态嵌入，我们将能够根据给定的文本查询（例如描述一幅画或甚至是一首诗）找到与之相似的画作。",Pe,O,_s='让我们使用来自 🤗 Transformers 的预训练 <strong>CLIP Vision Transformer (ViT)</strong> 模型为图像生成多模态嵌入。运行 <a href="https://docs.voxel51.com/user_guide/brain.html" rel="nofollow">FiftyOne Brain</a> 中的 <code>compute_similarity()</code> 函数，将计算这些嵌入并基于这些嵌入生成数据集的相似性索引。',Ye,D,Ae,K,ks=`Computing embeddings...
 100% |███████████████| 1000/1000 [5.0m elapsed, 0s remaining, 3.3 samples/s]
`,Ee,g,pe,xs="或者，您可以直接从 🤗 Transformers 库加载模型并将模型传递进去：",as,tt,ps,me,Zs='有关详细指南，请查看 <a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library">FiftyOne 的 🤗 Transformers 集成</a>。',Qe,et,Is="刷新 <strong>FiftyOne 应用</strong>，在样本网格中选择一个图像的复选框，然后点击照片图标，即可查看数据集中与该图像最相似的图像。在后台，点击此按钮会触发对相似性索引的查询，基于预计算的嵌入，找到与所选图像最相似的图像，并在应用中显示它们。",Se,lt,Hs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_image_search.gif" alt="Image Similarity Search"/>',Oe,st,Ls="我们可以用这个方法查看与给定艺术作品最相似的艺术作品。这对于寻找相似的艺术作品（推荐给用户或添加到收藏）或为新作品获取灵感非常有用。",De,nt,Fs="但这还不止于此！由于 CLIP 是多模态的，我们还可以利用它进行语义搜索。这意味着我们可以根据文本查询来搜索图像。例如，我们可以搜索“粉彩树木”，并查看数据集中与该查询相似的所有图像。要做到这一点，请点击 <strong>FiftyOne 应用</strong> 中的搜索图标，并输入文本查询：",Ke,it,Gs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_semantic_search.gif" alt="Semantic Search"/>',tl,at,Ws="在后台，文本会被标记化，并通过 CLIP 的文本编码器进行嵌入，然后用来查询相似性索引，从而找到数据集中与之最相似的图像。这是一种基于文本查询搜索图像的强大方法，非常适合用于寻找符合特定主题或风格的图像。而且，这不仅仅局限于 CLIP；你可以使用任何可以为图像和文本生成嵌入的 CLIP 类模型，从 🤗 Transformers 中获取！",el,v,Xs='💡 为了在大型数据集上进行高效的向量搜索和索引，FiftyOne 提供了与开源向量数据库的原生 <a href="https://voxel51.com/vector-search">集成</a>。',ll,pt,sl,mt,zs="通过执行相似性和语义搜索，我们可以更有效地与数据进行交互。但我们还可以更进一步，加入一些无监督学习的元素。这将帮助我们在 WikiArt 数据集中识别艺术模式，包括风格、主题，甚至是那些难以用语言描述的艺术主题。",nl,ot,Rs="我们将通过两种方式进行：",il,ft,Vs="<li><strong>降维</strong>：我们将使用 UMAP 将嵌入的维度减少到 2D，并在散点图中可视化数据。这将帮助我们观察图像如何基于风格、流派和艺术家进行聚类。</li> <li><strong>聚类</strong>：我们将使用 K-Means 聚类算法，基于图像的嵌入进行聚类，并观察哪些组别会自然形成。</li>",al,rt,Ns="对于降维，我们将运行 <strong>FiftyOne Brain</strong> 中的 <code>compute_visualization()</code>，并传入之前计算的嵌入。我们指定 <code>method=&quot;umap&quot;</code> 来使用 UMAP 进行降维，但也可以选择使用 PCA 或 t-SNE：",pl,Mt,ml,ut,Bs=`Generating visualization...
`,ol,yt,qs="现在我们可以在 <strong>FiftyOne 应用</strong> 中打开一个面板，在那里我们将看到数据集中每张图像对应的一个 2D 点。我们可以通过数据集中的任何字段（例如艺术家或流派）为这些点着色，以查看这些属性在我们的图像特征中是如何被捕捉的：",fl,ct,Ps='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_visualize_embeddings.gif" alt="UMAP Visualization"/>',rl,gt,Ys='我们还可以在嵌入上运行聚类，将相似的图像分为一组——也许这些艺术作品的主导特征并未通过现有标签捕捉到，或者我们可能想要识别出不同的子流派。为了对我们的数据进行聚类，我们需要下载 <a href="https://github.com/jacobmarks/clustering-plugin" rel="nofollow">FiftyOne Clustering 插件</a>：',Ml,ht,ul,bt,As="再次刷新应用后，我们可以通过应用中的操作符访问聚类功能。按下反引号键（`）打开操作符列表，输入“cluster”并从下拉菜单中选择该操作符。这将打开一个交互式面板，我们可以在其中指定聚类算法、超参数以及要聚类的字段。为了简化操作，我们将使用 K-Means 聚类，并设置为 10 个簇。",yl,dt,Es="然后，我们可以在应用中可视化这些聚类，查看图像如何根据它们的嵌入进行分组：",cl,vt,Qs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_clustering.gif" alt="K-means Clustering"/>',gl,jt,Ss="我们可以看到，部分聚类是按艺术家进行分组的；其他聚类则是按流派或风格进行分组的。还有一些聚类更为抽象，可能代表了子流派或其他不容易从数据中直接看出的分组。",hl,Tt,bl,Ct,Os="我们可以问一个关于数据集的有趣问题，那就是每张图像的<strong>独特性</strong>如何。这对于许多应用场景都非常重要，比如推荐相似图像、检测重复图像或识别异常值。在艺术的语境中，一幅画的独特性可能是决定其价值的重要因素。",dl,wt,Ds="尽管有很多方法可以表征独特性，我们的图像嵌入允许我们基于每张图像与数据集中其他图像的相似度，定量地为每个样本分配一个独特性分数。具体而言，<strong>FiftyOne Brain</strong> 的 <code>compute_uniqueness()</code> 函数会查看每个样本的嵌入与其最近邻之间的距离，并基于这个距离计算一个介于 0 和 1 之间的分数。分数为 0 意味着样本没有特色或与其他样本非常相似，而分数为 1 意味着样本非常独特。",vl,Ut,jl,$t,Ks=`Computing uniqueness...
Uniqueness computation complete
`,Tl,Jt,tn="然后，我们可以在嵌入面板中根据独特性分数为图像着色，或者通过独特性分数进行筛选，甚至按分数排序，以查看数据集中最独特的图像。",Cl,_t,wl,kt,en='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_most_unique.jpg" alt="Most Unique Images"/>',Ul,xt,$l,Zt,ln='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_least_unique.jpg" alt="Least Unique Images"/>',Jl,It,sn="更进一步，我们还可以回答哪个艺术家通常创作出最独特的作品这个问题。我们可以计算每个艺术家在其所有作品中的平均独特性分数：",_l,Ht,kl,Lt,nn=`Unknown Artist: 0.7932221632002723
boris-kustodiev: 0.7480731948424676
salvador-dali: 0.7368807620414014
raphael-kirchner: 0.7315448102204755
ilya-repin: 0.7204744626806383
marc-chagall: 0.7169373812321908
rembrandt: 0.715205220292227
martiros-saryan: 0.708560775790436
childe-hassam: 0.7018343391132756
edgar-degas: 0.699912746806587
albrecht-durer: 0.6969358680800216
john-singer-sargent: 0.6839955708720844
pablo-picasso: 0.6835137858302969
pyotr-konchalovsky: 0.6780653000855895
nicholas-roerich: 0.6676504687452387
ivan-aivazovsky: 0.6484361530090199
vincent-van-gogh: 0.6472004520699081
gustave-dore: 0.6307283287457358
pierre-auguste-renoir: 0.6271467146993583
paul-cezanne: 0.6251076007168186
eugene-boudin: 0.6103397516167454
camille-pissarro: 0.6046182609119615
claude-monet: 0.5998234558947573
ivan-shishkin: 0.589796389836674
`,xl,Ft,an="看起来，在我们的数据集中，创作出最独特作品的艺术家是 <strong>Boris Kustodiev</strong>！让我们来看看他的部分作品：",Zl,Gt,Il,Wt,pn='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_kustodiev_view.jpg" alt="Boris Kustodiev Artwork"/>',Hl,Xt,Ll,zt,mn="为了全面分析，我们将回归基础，分析数据集中图像的一些核心特征。我们将计算每张图像的标准指标，如亮度、对比度和饱和度，并查看这些指标与艺术作品的艺术风格和流派之间的相关性。",Fl,Rt,on='为了进行这些分析，我们需要下载 <a href="https://github.com/jacobmarks/image-quality-issues" rel="nofollow">FiftyOne 图像质量插件</a>：',Gl,Vt,Wl,Nt,fn="再次刷新应用并打开操作符列表。这次输入 <code>compute</code> 并选择其中一个图像质量操作符。我们将从 <strong>亮度</strong> 开始：",Xl,Bt,rn='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_compute_brightness.gif" alt="Compute Brightness"/>',zl,qt,Mn="当操作符运行完成后，我们的数据集中将新增一个字段，其中包含每张图像的亮度分数。然后，我们可以在应用中可视化这些数据：",Rl,Pt,un='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_brightness.gif" alt="Brightness"/>',Vl,Yt,yn="我们还可以根据亮度为图像着色，甚至查看亮度与数据集中的其他字段（如风格）之间的相关性：",Nl,At,cn='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_style_by_brightness.gif" alt="Style by Brightness"/>',Bl,Et,gn="现在对比度和饱和度也做相同的操作。以下是饱和度的结果：",ql,Qt,hn='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_filter_by_saturation.jpg" alt="Filter by Saturation"/>',Pl,St,bn="希望这能说明，并非所有的分析都依赖于将深度神经网络应用于数据。有时候，简单的指标同样可以提供有价值的信息，并能为你的数据提供不同的视角 🤓！",Yl,j,dn='📚 对于更大的数据集，你可能希望 <a href="https://docs.voxel51.com/plugins/using_plugins.html#delegated-operations">委托操作</a> 以便稍后执行。',Al,Ot,El,Dt,vn='在本 Notebook 中，我们探讨了如何使用多模态嵌入、无监督学习和传统图像处理技术来分析图像中的艺术风格。我们展示了如何执行图像相似性和语义搜索，基于风格对图像进行聚类，分析图像的独特性，并计算图像质量指标。这些技术可以应用于广泛的视觉数据集，从艺术收藏到医学图像再到卫星图像。试着 <a href="https://docs.voxel51.com/integrations/huggingface.html#loading-datasets-from-the-hub" rel="nofollow">加载来自 Hugging Face Hub 的不同数据集</a>，看看你能发现哪些有趣的见解！',Ql,Kt,jn="如果你想进一步探索，以下是一些可以尝试的附加分析：",Sl,te,Tn='<li><strong>零样本分类</strong>：使用 🤗 Transformers 提供的预训练视觉语言模型，通过主题或对象对数据集中的图像进行分类，无需任何训练数据。更多信息请参见这个 <a href="https://docs.voxel51.com/tutorials/zero_shot_classification.html" rel="nofollow">零样本分类教程</a>。</li> <li><strong>图像标注</strong>：使用 🤗 Transformers 提供的预训练视觉语言模型为数据集中的图像生成标注。然后，可以利用这些标注进行主题建模，或根据标注的嵌入对艺术作品进行聚类。更多信息请查看 FiftyOne 的 <a href="https://github.com/jacobmarks/fiftyone-image-captioning-plugin" rel="nofollow">图像标注插件</a>。</li>',Ol,ee,Dl,le,Cn='<li><a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">FiftyOne 🤝 🤗 Hub 集成</a></li> <li><a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library" rel="nofollow">FiftyOne 🤝 🤗 Transformers 集成</a></li> <li><a href="https://voxel51.com/vector-search/" rel="nofollow">FiftyOne 向量搜索集成</a></li> <li><a href="https://docs.voxel51.com/tutorials/dimension_reduction.html" rel="nofollow">使用降维技术可视化数据</a></li> <li><a href="https://docs.voxel51.com/tutorials/clustering.html" rel="nofollow">使用嵌入对图像进行聚类</a></li> <li><a href="https://docs.voxel51.com/tutorials/uniqueness.html" rel="nofollow">使用 FiftyOne 探索图像独特性</a></li>',Kl,se,ts,ne,wn='<a href="https://github.com/voxel51/fiftyone/" rel="nofollow">FiftyOne</a> 是构建高质量数据集和计算机视觉模型的领先开源工具包。FiftyOne 已经拥有超过 200 万次下载，全球的开发者和研究人员都信任并使用它。',es,ie,Un='💪 FiftyOne 团队欢迎开源社区的贡献！如果你有兴趣为 FiftyOne 做贡献，可以查看 <a href="https://github.com/voxel51/fiftyone/blob/develop/CONTRIBUTING.md" rel="nofollow">贡献指南</a>。',ls,ae,ss,re,ns;return T=new In({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/analyzing_art_with_hf_and_fiftyone.ipynb"}]}}),C=new b({props:{title:"分析艺术风格与多模态嵌入",local:"分析艺术风格与多模态嵌入",headingTag:"h1"}}),k=new b({props:{title:"让我们开始吧! 🚀",local:"让我们开始吧-",headingTag:"h2"}}),Z=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMHRyYW5zZm9ybWVycyUyMGh1Z2dpbmdmYWNlX2h1YiUyMGZpZnR5b25lJTIwdW1hcC1sZWFybg==",highlighted:"!pip install -U transformers huggingface_hub fiftyone umap-learn",wrap:!1}}),H=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMGhmLXRyYW5zZmVy",highlighted:"pip install hf-transfer",wrap:!1}}),F=new c({props:{code:"aW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIySEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUyMiU1RCUyMCUzRCUyMCUyMjElMjI=",highlighted:`import os
os.environ[<span class="hljs-string">&quot;HF_HUB_ENABLE_HF_TRANSFER&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>`,wrap:!1}}),W=new c({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTIwJTIwJTIzJTIwYmFzZSUyMGxpYnJhcnklMjBhbmQlMjBhcHAlMEFpbXBvcnQlMjBmaWZ0eW9uZS56b28lMjBhcyUyMGZveiUyMCUyMCUyMyUyMHpvbyUyMGRhdGFzZXRzJTIwYW5kJTIwbW9kZWxzJTBBaW1wb3J0JTIwZmlmdHlvbmUuYnJhaW4lMjBhcyUyMGZvYiUyMCUyMCUyMyUyME1MJTIwcm91dGluZXMlMEFmcm9tJTIwZmlmdHlvbmUlMjBpbXBvcnQlMjBWaWV3RmllbGQlMjBhcyUyMEYlMjAlMjAlMjMlMjBmb3IlMjBkZWZpbmluZyUyMGN1c3RvbSUyMHZpZXdzJTBBaW1wb3J0JTIwZmlmdHlvbmUudXRpbHMuaHVnZ2luZ2ZhY2UlMjBhcyUyMGZvdWglMjAlMjAlMjMlMjBmb3IlMjBsb2FkaW5nJTIwZGF0YXNldHMlMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2U=",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo  <span class="hljs-comment"># base library and app</span>
<span class="hljs-keyword">import</span> fiftyone.zoo <span class="hljs-keyword">as</span> foz  <span class="hljs-comment"># zoo datasets and models</span>
<span class="hljs-keyword">import</span> fiftyone.brain <span class="hljs-keyword">as</span> fob  <span class="hljs-comment"># ML routines</span>
<span class="hljs-keyword">from</span> fiftyone <span class="hljs-keyword">import</span> ViewField <span class="hljs-keyword">as</span> F  <span class="hljs-comment"># for defining custom views</span>
<span class="hljs-keyword">import</span> fiftyone.utils.huggingface <span class="hljs-keyword">as</span> fouh  <span class="hljs-comment"># for loading datasets from Hugging Face</span>`,wrap:!1}}),z=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGZvdWgubG9hZF9mcm9tX2h1YiglMEElMjAlMjAlMjAlMjAlMjJodWdnYW4lMkZ3aWtpYXJ0JTIyJTJDJTIwJTIwJTIzJTIzJTIwcmVwb19pZCUwQSUyMCUyMCUyMCUyMGZvcm1hdCUzRCUyMnBhcnF1ZXQlMjIlMkMlMjAlMjAlMjMlMjMlMjBmb3IlMjBQYXJxdWV0JTIwZm9ybWF0JTBBJTIwJTIwJTIwJTIwY2xhc3NpZmljYXRpb25fZmllbGRzJTNEJTVCJTIyYXJ0aXN0JTIyJTJDJTIwJTIyc3R5bGUlMjIlMkMlMjAlMjJnZW5yZSUyMiU1RCUyQyUyMCUyMCUyMyUyMGNvbHVtbnMlMjB0byUyMHN0b3JlJTIwYXMlMjBjbGFzc2lmaWNhdGlvbiUyMGZpZWxkcyUwQSUyMCUyMCUyMCUyMG1heF9zYW1wbGVzJTNEMTAwMCUyQyUyMCUyMCUyMyUyMG51bWJlciUyMG9mJTIwc2FtcGxlcyUyMHRvJTIwbG9hZCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJ3aWtpYXJ0JTIyJTJDJTIwJTIwJTIzJTIwbmFtZSUyMG9mJTIwdGhlJTIwZGF0YXNldCUyMGluJTIwRmlmdHlPbmUlMEEp",highlighted:`dataset = fouh.load_from_hub(
    <span class="hljs-string">&quot;huggan/wikiart&quot;</span>,  <span class="hljs-comment">## repo_id</span>
    <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;parquet&quot;</span>,  <span class="hljs-comment">## for Parquet format</span>
    classification_fields=[<span class="hljs-string">&quot;artist&quot;</span>, <span class="hljs-string">&quot;style&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>],  <span class="hljs-comment"># columns to store as classification fields</span>
    max_samples=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># number of samples to load</span>
    name=<span class="hljs-string">&quot;wikiart&quot;</span>,  <span class="hljs-comment"># name of the dataset in FiftyOne</span>
)`,wrap:!1}}),V=new c({props:{code:"cHJpbnQoZGF0YXNldCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset)',wrap:!1}}),q=new c({props:{code:"c2Vzc2lvbiUyMCUzRCUyMGZvLmxhdW5jaF9hcHAoZGF0YXNldCk=",highlighted:"session = fo.launch_app(dataset)",wrap:!1}}),A=new c({props:{code:"YXJ0aXN0cyUyMCUzRCUyMGRhdGFzZXQuZGlzdGluY3QoJTIyYXJ0aXN0LmxhYmVsJTIyKSUwQXByaW50KGFydGlzdHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>artists = dataset.distinct(<span class="hljs-string">&quot;artist.label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(artists)`,wrap:!1}}),Q=new b({props:{title:"查找相似的艺术作品",local:"查找相似的艺术作品",headingTag:"h2"}}),D=new c({props:{code:"Zm9iLmNvbXB1dGVfc2ltaWxhcml0eSglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24tdHJhbnNmb3JtZXItdG9yY2glMjIlMkMlMjAlMjAlMjMlMjMlMjB0eXBlJTIwb2YlMjBtb2RlbCUyMHRvJTIwbG9hZCUyMGZyb20lMjBtb2RlbCUyMHpvbyUwQSUyMCUyMCUyMCUyMG5hbWVfb3JfcGF0aCUzRCUyMm9wZW5haSUyRmNsaXAtdml0LWJhc2UtcGF0Y2gzMiUyMiUyQyUyMCUyMCUyMyUyMyUyMHJlcG9faWQlMjBvZiUyMGNoZWNrcG9pbnQlMEElMjAlMjAlMjAlMjBlbWJlZGRpbmdzJTNEJTIyY2xpcF9lbWJlZGRpbmdzJTIyJTJDJTIwJTIwJTIzJTIzJTIwbmFtZSUyMG9mJTIwdGhlJTIwZmllbGQlMjB0byUyMHN0b3JlJTIwZW1iZWRkaW5ncyUwQSUyMCUyMCUyMCUyMGJyYWluX2tleSUzRCUyMmNsaXBfc2ltJTIyJTJDJTIwJTIwJTIzJTIzJTIwa2V5JTIwdG8lMjBzdG9yZSUyMHNpbWlsYXJpdHklMjBpbmRleCUyMGluZm8lMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEMzIlMkMlMjAlMjAlMjMlMjMlMjBiYXRjaCUyMHNpemUlMjBmb3IlMjBpbmZlcmVuY2UlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_similarity(
<span class="hljs-meta">... </span>    dataset,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;zero-shot-classification-transformer-torch&quot;</span>,  <span class="hljs-comment">## type of model to load from model zoo</span>
<span class="hljs-meta">... </span>    name_or_path=<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>,  <span class="hljs-comment">## repo_id of checkpoint</span>
<span class="hljs-meta">... </span>    embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>,  <span class="hljs-comment">## name of the field to store embeddings</span>
<span class="hljs-meta">... </span>    brain_key=<span class="hljs-string">&quot;clip_sim&quot;</span>,  <span class="hljs-comment">## key to store similarity index info</span>
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">32</span>,  <span class="hljs-comment">## batch size for inference</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),tt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBNb2RlbCUwQW1vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMzIlMjIpJTBBZm9iLmNvbXB1dGVfc2ltaWxhcml0eSglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTIwJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlM0QlMjJjbGlwX2VtYmVkZGluZ3MlMjIlMkMlMjAlMjAlMjMlMjMlMjAlRTUlQUQlOTglRTUlODIlQTglRTUlQjUlOEMlRTUlODUlQTUlRTclOUElODQlRTUlQUQlOTclRTYlQUUlQjUlRTUlOTAlOEQlRTclQTclQjAlMEElMjAlMjAlMjAlMjBicmFpbl9rZXklM0QlMjJjbGlwX3NpbSUyMiUyMCUyMCUyMyUyMyUyMCVFNSVBRCU5OCVFNSU4MiVBOCVFNyU5QiVCOCVFNCVCQyVCQyVFNiU4MCVBNyVFNyVCNCVBMiVFNSVCQyU5NSVFNCVCRiVBMSVFNiU4MSVBRiVFNyU5QSU4NCVFOSU5NCVBRSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPModel
model = CLIPModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>)
fob.compute_similarity(
    dataset, 
    model=model,
    embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>,  <span class="hljs-comment">## 存储嵌入的字段名称</span>
    brain_key=<span class="hljs-string">&quot;clip_sim&quot;</span>  <span class="hljs-comment">## 存储相似性索引信息的键</span>
)`,wrap:!1}}),pt=new b({props:{title:"通过聚类和可视化揭示艺术主题",local:"通过聚类和可视化揭示艺术主题",headingTag:"h2"}}),Mt=new c({props:{code:"Zm9iLmNvbXB1dGVfdmlzdWFsaXphdGlvbihkYXRhc2V0JTJDJTIwZW1iZWRkaW5ncyUzRCUyMmNsaXBfZW1iZWRkaW5ncyUyMiUyQyUyMG1ldGhvZCUzRCUyMnVtYXAlMjIlMkMlMjBicmFpbl9rZXklM0QlMjJjbGlwX3ZpcyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_visualization(dataset, embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>, method=<span class="hljs-string">&quot;umap&quot;</span>, brain_key=<span class="hljs-string">&quot;clip_vis&quot;</span>)',wrap:!1}}),ht=new c({props:{code:"IWZpZnR5b25lJTIwcGx1Z2lucyUyMGRvd25sb2FkJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFjb2JtYXJrcyUyRmNsdXN0ZXJpbmctcGx1Z2lu",highlighted:"!fiftyone plugins download https://github.com/jacobmarks/clustering-plugin",wrap:!1}}),Tt=new b({props:{title:"识别最独特的艺术作品",local:"识别最独特的艺术作品",headingTag:"h2"}}),Ut=new c({props:{code:"Zm9iLmNvbXB1dGVfdW5pcXVlbmVzcyhkYXRhc2V0JTJDJTIwZW1iZWRkaW5ncyUzRCUyMmNsaXBfZW1iZWRkaW5ncyUyMiklMjAlMjAlMjMlMjBjb21wdXRlJTIwdW5pcXVlbmVzcyUyMHVzaW5nJTIwQ0xJUCUyMGVtYmVkZGluZ3M=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_uniqueness(dataset, embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>)  <span class="hljs-comment"># compute uniqueness using CLIP embeddings</span>',wrap:!1}}),_t=new c({props:{code:"bW9zdF91bmlxdWVfdmlldyUyMCUzRCUyMGRhdGFzZXQuc29ydF9ieSglMjJ1bmlxdWVuZXNzJTIyJTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBc2Vzc2lvbi52aWV3JTIwJTNEJTIwbW9zdF91bmlxdWVfdmlldy52aWV3KCklMjAlMjAlMjMlMjBNb3N0JTIwdW5pcXVlJTIwaW1hZ2Vz",highlighted:`most_unique_view = dataset.sort_by(<span class="hljs-string">&quot;uniqueness&quot;</span>, reverse=<span class="hljs-literal">True</span>)
session.view = most_unique_view.view()  <span class="hljs-comment"># Most unique images</span>`,wrap:!1}}),xt=new c({props:{code:"bGVhc3RfdW5pcXVlX3ZpZXclMjAlM0QlMjBkYXRhc2V0LnNvcnRfYnkoJTIydW5pcXVlbmVzcyUyMiUyQyUyMHJldmVyc2UlM0RGYWxzZSklMEFzZXNzaW9uLnZpZXclMjAlM0QlMjBsZWFzdF91bmlxdWVfdmlldy52aWV3KCklMjAlMjAlMjMlMjBMZWFzdCUyMHVuaXF1ZSUyMGltYWdlcw==",highlighted:`least_unique_view = dataset.sort_by(<span class="hljs-string">&quot;uniqueness&quot;</span>, reverse=<span class="hljs-literal">False</span>)
session.view = least_unique_view.view()  <span class="hljs-comment"># Least unique images</span>`,wrap:!1}}),Ht=new c({props:{code:"YXJ0aXN0X3VuaXF1ZV9zY29yZXMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBhcnRpc3QlM0ElMjBkYXRhc2V0Lm1hdGNoKEYoJTIyYXJ0aXN0LmxhYmVsJTIyKSUyMCUzRCUzRCUyMGFydGlzdCkubWVhbiglMjJ1bmlxdWVuZXNzJTIyKSUyMGZvciUyMGFydGlzdCUyMGluJTIwYXJ0aXN0cyUwQSU3RCUwQSUwQXNvcnRlZF9hcnRpc3RzJTIwJTNEJTIwc29ydGVkKGFydGlzdF91bmlxdWVfc2NvcmVzJTJDJTIwa2V5JTNEYXJ0aXN0X3VuaXF1ZV9zY29yZXMuZ2V0JTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBJTBBZm9yJTIwYXJ0aXN0JTIwaW4lMjBzb3J0ZWRfYXJ0aXN0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JhcnRpc3QlN0QlM0ElMjAlN0JhcnRpc3RfdW5pcXVlX3Njb3JlcyU1QmFydGlzdCU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>artist_unique_scores = {
<span class="hljs-meta">... </span>    artist: dataset.<span class="hljs-keyword">match</span>(F(<span class="hljs-string">&quot;artist.label&quot;</span>) == artist).mean(<span class="hljs-string">&quot;uniqueness&quot;</span>) <span class="hljs-keyword">for</span> artist <span class="hljs-keyword">in</span> artists
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_artists = <span class="hljs-built_in">sorted</span>(artist_unique_scores, key=artist_unique_scores.get, reverse=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> artist <span class="hljs-keyword">in</span> sorted_artists:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{artist}</span>: <span class="hljs-subst">{artist_unique_scores[artist]}</span>&quot;</span>)`,wrap:!1}}),Gt=new c({props:{code:"a3VzdG9kaWV2X3ZpZXclMjAlM0QlMjBkYXRhc2V0Lm1hdGNoKEYoJTIyYXJ0aXN0LmxhYmVsJTIyKSUyMCUzRCUzRCUyMCUyMmJvcmlzLWt1c3RvZGlldiUyMiklMEFzZXNzaW9uLnZpZXclMjAlM0QlMjBrdXN0b2RpZXZfdmlldy52aWV3KCk=",highlighted:`kustodiev_view = dataset.<span class="hljs-keyword">match</span>(F(<span class="hljs-string">&quot;artist.label&quot;</span>) == <span class="hljs-string">&quot;boris-kustodiev&quot;</span>)
session.view = kustodiev_view.view()`,wrap:!1}}),Xt=new b({props:{title:"通过视觉特征描述艺术作品",local:"通过视觉特征描述艺术作品",headingTag:"h2"}}),Vt=new c({props:{code:"IWZpZnR5b25lJTIwcGx1Z2lucyUyMGRvd25sb2FkJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFjb2JtYXJrcyUyRmltYWdlLXF1YWxpdHktaXNzdWVzJTJG",highlighted:"!fiftyone plugins download https://github.com/jacobmarks/image-quality-issues/",wrap:!1}}),Ot=new b({props:{title:"下一步是什么？",local:"下一步是什么",headingTag:"h2"}}),ee=new b({props:{title:"📚 资源",local:"-资源",headingTag:"h3"}}),se=new b({props:{title:"FiftyOne 开源项目",local:"fiftyone-开源项目",headingTag:"h2"}}),ae=new Hn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/analyzing_art_with_hf_and_fiftyone.md"}}),{c(){h=a("meta"),ye=n(),fe=a("p"),ce=n(),o(T.$$.fragment),ge=n(),o(C.$$.fragment),he=n(),w=a("p"),w.innerHTML=fs,be=n(),U=a("p"),U.innerHTML=rs,de=n(),$=a("p"),$.innerHTML=Ms,ve=n(),J=a("p"),J.innerHTML=us,je=n(),_=a("ul"),_.innerHTML=ys,Te=n(),o(k.$$.fragment),Ce=n(),x=a("p"),x.textContent=cs,we=n(),o(Z.$$.fragment),Ue=n(),I=a("p"),I.innerHTML=gs,$e=n(),o(H.$$.fragment),Je=n(),L=a("p"),L.innerHTML=hs,_e=n(),o(F.$$.fragment),ke=n(),d=a("div"),d.innerHTML=bs,xe=n(),G=a("p"),G.textContent=ds,Ze=n(),o(W.$$.fragment),Ie=n(),X=a("p"),X.innerHTML=vs,He=n(),o(z.$$.fragment),Le=n(),R=a("p"),R.textContent=js,Fe=n(),o(V.$$.fragment),Ge=n(),N=a("pre"),N.textContent=Ts,We=n(),B=a("p"),B.innerHTML=Cs,Xe=n(),o(q.$$.fragment),ze=n(),P=a("p"),P.innerHTML=ws,Re=n(),Y=a("p"),Y.textContent=Us,Ve=n(),o(A.$$.fragment),Ne=n(),E=a("pre"),E.textContent=$s,Be=n(),o(Q.$$.fragment),qe=n(),S=a("p"),S.textContent=Js,Pe=n(),O=a("p"),O.innerHTML=_s,Ye=n(),o(D.$$.fragment),Ae=n(),K=a("pre"),K.textContent=ks,Ee=n(),g=a("div"),pe=a("p"),pe.textContent=xs,as=n(),o(tt.$$.fragment),ps=n(),me=a("p"),me.innerHTML=Zs,Qe=n(),et=a("p"),et.innerHTML=Is,Se=n(),lt=a("p"),lt.innerHTML=Hs,Oe=n(),st=a("p"),st.textContent=Ls,De=n(),nt=a("p"),nt.innerHTML=Fs,Ke=n(),it=a("p"),it.innerHTML=Gs,tl=n(),at=a("p"),at.textContent=Ws,el=n(),v=a("div"),v.innerHTML=Xs,ll=n(),o(pt.$$.fragment),sl=n(),mt=a("p"),mt.textContent=zs,nl=n(),ot=a("p"),ot.textContent=Rs,il=n(),ft=a("ol"),ft.innerHTML=Vs,al=n(),rt=a("p"),rt.innerHTML=Ns,pl=n(),o(Mt.$$.fragment),ml=n(),ut=a("pre"),ut.textContent=Bs,ol=n(),yt=a("p"),yt.innerHTML=qs,fl=n(),ct=a("p"),ct.innerHTML=Ps,rl=n(),gt=a("p"),gt.innerHTML=Ys,Ml=n(),o(ht.$$.fragment),ul=n(),bt=a("p"),bt.textContent=As,yl=n(),dt=a("p"),dt.textContent=Es,cl=n(),vt=a("p"),vt.innerHTML=Qs,gl=n(),jt=a("p"),jt.textContent=Ss,hl=n(),o(Tt.$$.fragment),bl=n(),Ct=a("p"),Ct.innerHTML=Os,dl=n(),wt=a("p"),wt.innerHTML=Ds,vl=n(),o(Ut.$$.fragment),jl=n(),$t=a("pre"),$t.textContent=Ks,Tl=n(),Jt=a("p"),Jt.textContent=tn,Cl=n(),o(_t.$$.fragment),wl=n(),kt=a("p"),kt.innerHTML=en,Ul=n(),o(xt.$$.fragment),$l=n(),Zt=a("p"),Zt.innerHTML=ln,Jl=n(),It=a("p"),It.textContent=sn,_l=n(),o(Ht.$$.fragment),kl=n(),Lt=a("pre"),Lt.textContent=nn,xl=n(),Ft=a("p"),Ft.innerHTML=an,Zl=n(),o(Gt.$$.fragment),Il=n(),Wt=a("p"),Wt.innerHTML=pn,Hl=n(),o(Xt.$$.fragment),Ll=n(),zt=a("p"),zt.textContent=mn,Fl=n(),Rt=a("p"),Rt.innerHTML=on,Gl=n(),o(Vt.$$.fragment),Wl=n(),Nt=a("p"),Nt.innerHTML=fn,Xl=n(),Bt=a("p"),Bt.innerHTML=rn,zl=n(),qt=a("p"),qt.textContent=Mn,Rl=n(),Pt=a("p"),Pt.innerHTML=un,Vl=n(),Yt=a("p"),Yt.textContent=yn,Nl=n(),At=a("p"),At.innerHTML=cn,Bl=n(),Et=a("p"),Et.textContent=gn,ql=n(),Qt=a("p"),Qt.innerHTML=hn,Pl=n(),St=a("p"),St.textContent=bn,Yl=n(),j=a("div"),j.innerHTML=dn,Al=n(),o(Ot.$$.fragment),El=n(),Dt=a("p"),Dt.innerHTML=vn,Ql=n(),Kt=a("p"),Kt.textContent=jn,Sl=n(),te=a("ul"),te.innerHTML=Tn,Ol=n(),o(ee.$$.fragment),Dl=n(),le=a("ul"),le.innerHTML=Cn,Kl=n(),o(se.$$.fragment),ts=n(),ne=a("p"),ne.innerHTML=wn,es=n(),ie=a("p"),ie.innerHTML=Un,ls=n(),o(ae.$$.fragment),ss=n(),re=a("p"),this.h()},l(t){const e=Zn("svelte-u9bgzb",document.head);h=p(e,"META",{name:!0,content:!0}),e.forEach(l),ye=i(t),fe=p(t,"P",{}),ms(fe).forEach(l),ce=i(t),f(T.$$.fragment,t),ge=i(t),f(C.$$.fragment,t),he=i(t),w=p(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1n621y5"&&(w.innerHTML=fs),be=i(t),U=p(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1xzj7ip"&&(U.innerHTML=rs),de=i(t),$=p(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1v48993"&&($.innerHTML=Ms),ve=i(t),J=p(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-eo29vv"&&(J.innerHTML=us),je=i(t),_=p(t,"UL",{"data-svelte-h":!0}),m(_)!=="svelte-1xk83y0"&&(_.innerHTML=ys),Te=i(t),f(k.$$.fragment,t),Ce=i(t),x=p(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1yl1sjl"&&(x.textContent=cs),we=i(t),f(Z.$$.fragment,t),Ue=i(t),I=p(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1qjpzm7"&&(I.innerHTML=gs),$e=i(t),f(H.$$.fragment,t),Je=i(t),L=p(t,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1lyxu81"&&(L.innerHTML=hs),_e=i(t),f(F.$$.fragment,t),ke=i(t),d=p(t,"DIV",{class:!0,"data-svelte-h":!0}),m(d)!=="svelte-t4feb5"&&(d.innerHTML=bs),xe=i(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-15s7ou4"&&(G.textContent=ds),Ze=i(t),f(W.$$.fragment,t),Ie=i(t),X=p(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1bnfagi"&&(X.innerHTML=vs),He=i(t),f(z.$$.fragment,t),Le=i(t),R=p(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-jyo60v"&&(R.textContent=js),Fe=i(t),f(V.$$.fragment,t),Ge=i(t),N=p(t,"PRE",{"data-svelte-h":!0}),m(N)!=="svelte-1odavx8"&&(N.textContent=Ts),We=i(t),B=p(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-n4sqks"&&(B.innerHTML=Cs),Xe=i(t),f(q.$$.fragment,t),ze=i(t),P=p(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1cy8zue"&&(P.innerHTML=ws),Re=i(t),Y=p(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-5dty4u"&&(Y.textContent=Us),Ve=i(t),f(A.$$.fragment,t),Ne=i(t),E=p(t,"PRE",{"data-svelte-h":!0}),m(E)!=="svelte-rh6f0n"&&(E.textContent=$s),Be=i(t),f(Q.$$.fragment,t),qe=i(t),S=p(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-fwenmu"&&(S.textContent=Js),Pe=i(t),O=p(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1ty1po9"&&(O.innerHTML=_s),Ye=i(t),f(D.$$.fragment,t),Ae=i(t),K=p(t,"PRE",{"data-svelte-h":!0}),m(K)!=="svelte-mmre29"&&(K.textContent=ks),Ee=i(t),g=p(t,"DIV",{style:!0});var oe=ms(g);pe=p(oe,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-84ubet"&&(pe.textContent=xs),as=i(oe),f(tt.$$.fragment,oe),ps=i(oe),me=p(oe,"P",{"data-svelte-h":!0}),m(me)!=="svelte-akcsst"&&(me.innerHTML=Zs),oe.forEach(l),Qe=i(t),et=p(t,"P",{"data-svelte-h":!0}),m(et)!=="svelte-17n6obl"&&(et.innerHTML=Is),Se=i(t),lt=p(t,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-w8rr2"&&(lt.innerHTML=Hs),Oe=i(t),st=p(t,"P",{"data-svelte-h":!0}),m(st)!=="svelte-1ibwof8"&&(st.textContent=Ls),De=i(t),nt=p(t,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-1sy10b4"&&(nt.innerHTML=Fs),Ke=i(t),it=p(t,"P",{"data-svelte-h":!0}),m(it)!=="svelte-8ah19l"&&(it.innerHTML=Gs),tl=i(t),at=p(t,"P",{"data-svelte-h":!0}),m(at)!=="svelte-6dxe71"&&(at.textContent=Ws),el=i(t),v=p(t,"DIV",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-wqj8k2"&&(v.innerHTML=Xs),ll=i(t),f(pt.$$.fragment,t),sl=i(t),mt=p(t,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1fxj75f"&&(mt.textContent=zs),nl=i(t),ot=p(t,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-1yqqnuo"&&(ot.textContent=Rs),il=i(t),ft=p(t,"OL",{"data-svelte-h":!0}),m(ft)!=="svelte-ep87tj"&&(ft.innerHTML=Vs),al=i(t),rt=p(t,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-4j4d59"&&(rt.innerHTML=Ns),pl=i(t),f(Mt.$$.fragment,t),ml=i(t),ut=p(t,"PRE",{"data-svelte-h":!0}),m(ut)!=="svelte-bhg5yk"&&(ut.textContent=Bs),ol=i(t),yt=p(t,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-bcz5yn"&&(yt.innerHTML=qs),fl=i(t),ct=p(t,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-guqvsc"&&(ct.innerHTML=Ps),rl=i(t),gt=p(t,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-wssvbl"&&(gt.innerHTML=Ys),Ml=i(t),f(ht.$$.fragment,t),ul=i(t),bt=p(t,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-6oqt28"&&(bt.textContent=As),yl=i(t),dt=p(t,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-18u3z1u"&&(dt.textContent=Es),cl=i(t),vt=p(t,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-1ccs8bm"&&(vt.innerHTML=Qs),gl=i(t),jt=p(t,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-16tqcbj"&&(jt.textContent=Ss),hl=i(t),f(Tt.$$.fragment,t),bl=i(t),Ct=p(t,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-1xj35a7"&&(Ct.innerHTML=Os),dl=i(t),wt=p(t,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-5bji2r"&&(wt.innerHTML=Ds),vl=i(t),f(Ut.$$.fragment,t),jl=i(t),$t=p(t,"PRE",{"data-svelte-h":!0}),m($t)!=="svelte-326il2"&&($t.textContent=Ks),Tl=i(t),Jt=p(t,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1ol4fvk"&&(Jt.textContent=tn),Cl=i(t),f(_t.$$.fragment,t),wl=i(t),kt=p(t,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1tb2ntu"&&(kt.innerHTML=en),Ul=i(t),f(xt.$$.fragment,t),$l=i(t),Zt=p(t,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-1vqafg6"&&(Zt.innerHTML=ln),Jl=i(t),It=p(t,"P",{"data-svelte-h":!0}),m(It)!=="svelte-1lskvx4"&&(It.textContent=sn),_l=i(t),f(Ht.$$.fragment,t),kl=i(t),Lt=p(t,"PRE",{"data-svelte-h":!0}),m(Lt)!=="svelte-1n3row5"&&(Lt.textContent=nn),xl=i(t),Ft=p(t,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1t3f2bp"&&(Ft.innerHTML=an),Zl=i(t),f(Gt.$$.fragment,t),Il=i(t),Wt=p(t,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-13rc4gu"&&(Wt.innerHTML=pn),Hl=i(t),f(Xt.$$.fragment,t),Ll=i(t),zt=p(t,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-1f0onmz"&&(zt.textContent=mn),Fl=i(t),Rt=p(t,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-1knwbmw"&&(Rt.innerHTML=on),Gl=i(t),f(Vt.$$.fragment,t),Wl=i(t),Nt=p(t,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1uw9n63"&&(Nt.innerHTML=fn),Xl=i(t),Bt=p(t,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-ojjfuj"&&(Bt.innerHTML=rn),zl=i(t),qt=p(t,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-rx6nc8"&&(qt.textContent=Mn),Rl=i(t),Pt=p(t,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1tiw0lq"&&(Pt.innerHTML=un),Vl=i(t),Yt=p(t,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-1qoywzh"&&(Yt.textContent=yn),Nl=i(t),At=p(t,"P",{"data-svelte-h":!0}),m(At)!=="svelte-b6ayaa"&&(At.innerHTML=cn),Bl=i(t),Et=p(t,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-m3wfu1"&&(Et.textContent=gn),ql=i(t),Qt=p(t,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-1aj2nhz"&&(Qt.innerHTML=hn),Pl=i(t),St=p(t,"P",{"data-svelte-h":!0}),m(St)!=="svelte-1gh0eqx"&&(St.textContent=bn),Yl=i(t),j=p(t,"DIV",{class:!0,"data-svelte-h":!0}),m(j)!=="svelte-19wez0m"&&(j.innerHTML=dn),Al=i(t),f(Ot.$$.fragment,t),El=i(t),Dt=p(t,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-c15amm"&&(Dt.innerHTML=vn),Ql=i(t),Kt=p(t,"P",{"data-svelte-h":!0}),m(Kt)!=="svelte-dje9td"&&(Kt.textContent=jn),Sl=i(t),te=p(t,"UL",{"data-svelte-h":!0}),m(te)!=="svelte-1741qwg"&&(te.innerHTML=Tn),Ol=i(t),f(ee.$$.fragment,t),Dl=i(t),le=p(t,"UL",{"data-svelte-h":!0}),m(le)!=="svelte-1g0ulz8"&&(le.innerHTML=Cn),Kl=i(t),f(se.$$.fragment,t),ts=i(t),ne=p(t,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1ako6e6"&&(ne.innerHTML=wn),es=i(t),ie=p(t,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1mi7wgc"&&(ie.innerHTML=Un),ls=i(t),f(ae.$$.fragment,t),ss=i(t),re=p(t,"P",{}),ms(re).forEach(l),this.h()},h(){Me(h,"name","hf:doc:metadata"),Me(h,"content",Fn),Me(d,"class","alert alert-block alert-info"),is(g,"padding","10px"),is(g,"border-left","5px solid #0078d4"),is(g,"font-family","Arial, sans-serif"),is(g,"margin","10px 0"),Me(v,"class","alert alert-block alert-info"),Me(j,"class","alert alert-block alert-info")},m(t,e){ue(document.head,h),s(t,ye,e),s(t,fe,e),s(t,ce,e),r(T,t,e),s(t,ge,e),r(C,t,e),s(t,he,e),s(t,w,e),s(t,be,e),s(t,U,e),s(t,de,e),s(t,$,e),s(t,ve,e),s(t,J,e),s(t,je,e),s(t,_,e),s(t,Te,e),r(k,t,e),s(t,Ce,e),s(t,x,e),s(t,we,e),r(Z,t,e),s(t,Ue,e),s(t,I,e),s(t,$e,e),r(H,t,e),s(t,Je,e),s(t,L,e),s(t,_e,e),r(F,t,e),s(t,ke,e),s(t,d,e),s(t,xe,e),s(t,G,e),s(t,Ze,e),r(W,t,e),s(t,Ie,e),s(t,X,e),s(t,He,e),r(z,t,e),s(t,Le,e),s(t,R,e),s(t,Fe,e),r(V,t,e),s(t,Ge,e),s(t,N,e),s(t,We,e),s(t,B,e),s(t,Xe,e),r(q,t,e),s(t,ze,e),s(t,P,e),s(t,Re,e),s(t,Y,e),s(t,Ve,e),r(A,t,e),s(t,Ne,e),s(t,E,e),s(t,Be,e),r(Q,t,e),s(t,qe,e),s(t,S,e),s(t,Pe,e),s(t,O,e),s(t,Ye,e),r(D,t,e),s(t,Ae,e),s(t,K,e),s(t,Ee,e),s(t,g,e),ue(g,pe),ue(g,as),r(tt,g,null),ue(g,ps),ue(g,me),s(t,Qe,e),s(t,et,e),s(t,Se,e),s(t,lt,e),s(t,Oe,e),s(t,st,e),s(t,De,e),s(t,nt,e),s(t,Ke,e),s(t,it,e),s(t,tl,e),s(t,at,e),s(t,el,e),s(t,v,e),s(t,ll,e),r(pt,t,e),s(t,sl,e),s(t,mt,e),s(t,nl,e),s(t,ot,e),s(t,il,e),s(t,ft,e),s(t,al,e),s(t,rt,e),s(t,pl,e),r(Mt,t,e),s(t,ml,e),s(t,ut,e),s(t,ol,e),s(t,yt,e),s(t,fl,e),s(t,ct,e),s(t,rl,e),s(t,gt,e),s(t,Ml,e),r(ht,t,e),s(t,ul,e),s(t,bt,e),s(t,yl,e),s(t,dt,e),s(t,cl,e),s(t,vt,e),s(t,gl,e),s(t,jt,e),s(t,hl,e),r(Tt,t,e),s(t,bl,e),s(t,Ct,e),s(t,dl,e),s(t,wt,e),s(t,vl,e),r(Ut,t,e),s(t,jl,e),s(t,$t,e),s(t,Tl,e),s(t,Jt,e),s(t,Cl,e),r(_t,t,e),s(t,wl,e),s(t,kt,e),s(t,Ul,e),r(xt,t,e),s(t,$l,e),s(t,Zt,e),s(t,Jl,e),s(t,It,e),s(t,_l,e),r(Ht,t,e),s(t,kl,e),s(t,Lt,e),s(t,xl,e),s(t,Ft,e),s(t,Zl,e),r(Gt,t,e),s(t,Il,e),s(t,Wt,e),s(t,Hl,e),r(Xt,t,e),s(t,Ll,e),s(t,zt,e),s(t,Fl,e),s(t,Rt,e),s(t,Gl,e),r(Vt,t,e),s(t,Wl,e),s(t,Nt,e),s(t,Xl,e),s(t,Bt,e),s(t,zl,e),s(t,qt,e),s(t,Rl,e),s(t,Pt,e),s(t,Vl,e),s(t,Yt,e),s(t,Nl,e),s(t,At,e),s(t,Bl,e),s(t,Et,e),s(t,ql,e),s(t,Qt,e),s(t,Pl,e),s(t,St,e),s(t,Yl,e),s(t,j,e),s(t,Al,e),r(Ot,t,e),s(t,El,e),s(t,Dt,e),s(t,Ql,e),s(t,Kt,e),s(t,Sl,e),s(t,te,e),s(t,Ol,e),r(ee,t,e),s(t,Dl,e),s(t,le,e),s(t,Kl,e),r(se,t,e),s(t,ts,e),s(t,ne,e),s(t,es,e),s(t,ie,e),s(t,ls,e),r(ae,t,e),s(t,ss,e),s(t,re,e),ns=!0},p:Jn,i(t){ns||(M(T.$$.fragment,t),M(C.$$.fragment,t),M(k.$$.fragment,t),M(Z.$$.fragment,t),M(H.$$.fragment,t),M(F.$$.fragment,t),M(W.$$.fragment,t),M(z.$$.fragment,t),M(V.$$.fragment,t),M(q.$$.fragment,t),M(A.$$.fragment,t),M(Q.$$.fragment,t),M(D.$$.fragment,t),M(tt.$$.fragment,t),M(pt.$$.fragment,t),M(Mt.$$.fragment,t),M(ht.$$.fragment,t),M(Tt.$$.fragment,t),M(Ut.$$.fragment,t),M(_t.$$.fragment,t),M(xt.$$.fragment,t),M(Ht.$$.fragment,t),M(Gt.$$.fragment,t),M(Xt.$$.fragment,t),M(Vt.$$.fragment,t),M(Ot.$$.fragment,t),M(ee.$$.fragment,t),M(se.$$.fragment,t),M(ae.$$.fragment,t),ns=!0)},o(t){u(T.$$.fragment,t),u(C.$$.fragment,t),u(k.$$.fragment,t),u(Z.$$.fragment,t),u(H.$$.fragment,t),u(F.$$.fragment,t),u(W.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u(q.$$.fragment,t),u(A.$$.fragment,t),u(Q.$$.fragment,t),u(D.$$.fragment,t),u(tt.$$.fragment,t),u(pt.$$.fragment,t),u(Mt.$$.fragment,t),u(ht.$$.fragment,t),u(Tt.$$.fragment,t),u(Ut.$$.fragment,t),u(_t.$$.fragment,t),u(xt.$$.fragment,t),u(Ht.$$.fragment,t),u(Gt.$$.fragment,t),u(Xt.$$.fragment,t),u(Vt.$$.fragment,t),u(Ot.$$.fragment,t),u(ee.$$.fragment,t),u(se.$$.fragment,t),u(ae.$$.fragment,t),ns=!1},d(t){t&&(l(ye),l(fe),l(ce),l(ge),l(he),l(w),l(be),l(U),l(de),l($),l(ve),l(J),l(je),l(_),l(Te),l(Ce),l(x),l(we),l(Ue),l(I),l($e),l(Je),l(L),l(_e),l(ke),l(d),l(xe),l(G),l(Ze),l(Ie),l(X),l(He),l(Le),l(R),l(Fe),l(Ge),l(N),l(We),l(B),l(Xe),l(ze),l(P),l(Re),l(Y),l(Ve),l(Ne),l(E),l(Be),l(qe),l(S),l(Pe),l(O),l(Ye),l(Ae),l(K),l(Ee),l(g),l(Qe),l(et),l(Se),l(lt),l(Oe),l(st),l(De),l(nt),l(Ke),l(it),l(tl),l(at),l(el),l(v),l(ll),l(sl),l(mt),l(nl),l(ot),l(il),l(ft),l(al),l(rt),l(pl),l(ml),l(ut),l(ol),l(yt),l(fl),l(ct),l(rl),l(gt),l(Ml),l(ul),l(bt),l(yl),l(dt),l(cl),l(vt),l(gl),l(jt),l(hl),l(bl),l(Ct),l(dl),l(wt),l(vl),l(jl),l($t),l(Tl),l(Jt),l(Cl),l(wl),l(kt),l(Ul),l($l),l(Zt),l(Jl),l(It),l(_l),l(kl),l(Lt),l(xl),l(Ft),l(Zl),l(Il),l(Wt),l(Hl),l(Ll),l(zt),l(Fl),l(Rt),l(Gl),l(Wl),l(Nt),l(Xl),l(Bt),l(zl),l(qt),l(Rl),l(Pt),l(Vl),l(Yt),l(Nl),l(At),l(Bl),l(Et),l(ql),l(Qt),l(Pl),l(St),l(Yl),l(j),l(Al),l(El),l(Dt),l(Ql),l(Kt),l(Sl),l(te),l(Ol),l(Dl),l(le),l(Kl),l(ts),l(ne),l(es),l(ie),l(ls),l(ss),l(re)),l(h),y(T,t),y(C,t),y(k,t),y(Z,t),y(H,t),y(F,t),y(W,t),y(z,t),y(V,t),y(q,t),y(A,t),y(Q,t),y(D,t),y(tt),y(pt,t),y(Mt,t),y(ht,t),y(Tt,t),y(Ut,t),y(_t,t),y(xt,t),y(Ht,t),y(Gt,t),y(Xt,t),y(Vt,t),y(Ot,t),y(ee,t),y(se,t),y(ae,t)}}}const Fn='{"title":"分析艺术风格与多模态嵌入","local":"分析艺术风格与多模态嵌入","sections":[{"title":"让我们开始吧! 🚀","local":"让我们开始吧-","sections":[],"depth":2},{"title":"查找相似的艺术作品","local":"查找相似的艺术作品","sections":[],"depth":2},{"title":"通过聚类和可视化揭示艺术主题","local":"通过聚类和可视化揭示艺术主题","sections":[],"depth":2},{"title":"识别最独特的艺术作品","local":"识别最独特的艺术作品","sections":[],"depth":2},{"title":"通过视觉特征描述艺术作品","local":"通过视觉特征描述艺术作品","sections":[],"depth":2},{"title":"下一步是什么？","local":"下一步是什么","sections":[{"title":"📚 资源","local":"-资源","sections":[],"depth":3}],"depth":2},{"title":"FiftyOne 开源项目","local":"fiftyone-开源项目","sections":[],"depth":2}],"depth":1}';function Gn(os){return _n(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vn extends kn{constructor(h){super(),xn(this,h,Gn,Ln,$n,{})}}export{Vn as component};
