import{s as ZM,n as uM,o as CM}from"../chunks/scheduler.65852ee5.js";import{S as GM,i as BM,g as n,s as t,r as J,A as WM,h as y,f as M,c as a,j as rM,u as U,x as p,k as hM,y as fM,a as s,v as i,d as w,t as m,w as T}from"../chunks/index.aa74147d.js";import{D as XM,C as c}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as o,E as VM}from"../chunks/getInferenceSnippets.0bc01211.js";function gM(He){let j,Wl,Gl,fl,d,Xl,b,Vl,I,Ee='<em>作者: <a href="https://github.com/AkiRusProd" rel="nofollow">Rustam Akimov</a></em>',gl,r,Se="这个 notebook 展示了如何使用 Stable Diffusion 来对图像进行插值。使用 Stable Diffusion 的图像插值是通过基于扩散的生成模型，从一张给定的图像平滑过渡到另一张图像，创建中间图像的过程。",Rl,h,Qe="以下是一些使用 Stable Diffusion 进行图像插值的不同应用场景：",kl,Z,Ne="<li>数据增强： Stable Diffusion 可以通过生成介于现有数据点之间的合成图像，来增强机器学习模型的训练数据。这可以提高机器学习模型的一般化和鲁棒性，特别是在图像生成、分类或对象检测等任务中。</li> <li>产品设计和原型制作： Stable Diffusion 可以通过生成具有微妙差异的产品设计或原型变体，来辅助产品设计。这对于探索设计替代方案、进行用户研究或在投入物理原型之前可视化设计迭代非常有用。</li> <li>媒体制作内容生成：在媒体制作中，如电影和视频编辑， Stable Diffusion 可以用来生成关键帧之间的中间帧，实现更平滑的过渡并增强视觉叙事。与手动逐帧编辑相比，这可以节省时间和资源。</li>",vl,u,Fe="在图像插值的背景下， Stable Diffusion 模型通常用于在多维潜在空间中导航。每个维度代表模型学到的特定特征。通过在这个潜在空间中行走并在不同图像的潜在表示之间进行插值，模型能够生成一系列中间图像，这些图像显示了原始图像之间的平滑过渡。 Stable Diffusion 中有两种类型的潜在：提示潜在和图像潜在。",Al,C,ze="潜在空间行走涉及沿着由两个或多个点（代表图像）定义的路径在潜在空间中移动。通过仔细选择这些点和它们之间的路径，可以控制生成图像的特征，如风格、内容和其他视觉方面。",Yl,G,xe="在这个 notebook 中，我们将探索使用 Stable Diffusion 进行图像插值的示例，并展示如何实现和利用潜在空间行走来创建图像之间的平滑过渡。我们将提供代码片段和可视化来展示这个过程的效果，从而更深入地理解生成模型如何以有意义的方式操纵和转化图像表示。",_l,B,$e="首先，让我们安装所有需要的模块",Hl,W,El,f,De="导入模块",Sl,X,Ql,V,Le="让我们查看一下 CUDA 是否可用",Nl,g,Fl,R,qe="这些设置用于优化在启用 CUDA 的 GPU 上 PyTorch 模型的性能，尤其是在使用混合精度训练或推理时，这在速度和内存使用方面可能有益。",zl,k,Ke='来源：<a href="https://huggingface.co/docs/diffusers/optimization/fp16#memory-efficient-attention" rel="nofollow">https://huggingface.co/docs/diffusers/optimization/fp16#memory-efficient-attention</a>',xl,v,$l,A,Dl,Y,Pe='我们在这个项目中使用了 <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> 模型和 <a href="https://huggingface.co/docs/diffusers/en/api/schedulers/lms_discrete" rel="nofollow"><code>LMSDiscreteScheduler</code></a> 调度器来生成图片。尽管这个模型已经不是最新的技术，但因为它的速度快、对内存的需求小，而且有很多社区成员基于这个版本改进的模型，所以还是挺受欢迎的。当然，如果你想尝试其他模型或调度器来生成图片，也是可以的。',Ll,_,ql,H,Oe="这些方法旨在减少 GPU 消耗的内存。如果你有足够的显存，可以跳过这个步骤。",Kl,E,lM=`更详细的信息可以在这里找到：<a href="https://huggingface.co/docs/diffusers/en/optimization/opt_overview" rel="nofollow">https://huggingface.co/docs/diffusers/en/optimization/opt_overview</a><br/>
特别是，关于以下方法的信息可以在这里找到：<a href="https://huggingface.co/docs/diffusers/optimization/memory" rel="nofollow">https://huggingface.co/docs/diffusers/optimization/memory</a>`,Pl,S,Ol,Q,eM="<code>display_images</code> 函数将图像数组的列表转换成 GIF，保存到指定路径，并返回 GIF 对象以供显示。它使用当前时间来命名 GIF 文件，并通过打印出来处理任何错误。",le,N,ee,F,Me,z,MM="<li><code>seed</code>: 这个变量用于设置一个特定的随机种子，以便复现结果。</li> <li><code>generator</code>: 如果提供了种子，这将设置为一个 PyTorch 随机数生成器对象，否则为 None。它确保使用它的操作具有可复现的结果。</li> <li><code>guidance_scale</code>: 这个参数控制模型在文本到图像生成任务中遵循提示的程度，值越高，对提示的遵循越强。</li> <li><code>num_inference_steps</code>: 这指定了模型生成图像所需的步骤数。更多的步骤可以导致生成更高质量的图像，但生成时间会更长。</li> <li><code>num_interpolation_steps</code>: 这决定了在潜在空间中两点之间插值时使用的步骤数，影响生成动画中过渡的平滑度。</li> <li><code>height</code>: 生成图像的高度，以像素为单位。</li> <li><code>width</code>: 生成图像的宽度，以像素为单位。</li> <li><code>save_path</code>: 生成的 GIF 将保存的文件系统路径。</li>",se,x,te,$,ae,D,sM="在这个例子中，我们将通过在积极提示和消极提示之间进行插值，来探索这两个提示定义的概念之间的空间。这样做可以让我们看到一系列逐渐融合这两种提示特征的图像。具体来说，我们会修改原始提示的嵌入向量，逐渐添加一些小的变化，从而创建出一系列新的提示嵌入。这些新的嵌入将被用来生成图像，这些图像会平滑地从一种提示的状态过渡到另一种。",ne,L,tM='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_1.gif" alt="Example 1"/>',ye,q,aM="首先，我们需要对积极和消极的文本提示进行标记化并获得它们的嵌入。积极提示引导图像生成朝向期望的特征，而消极提示则使其远离不希望出现的特征。",pe,K,Je,P,nM="现在让我们来看看生成随机初始向量的代码部分，该向量使用正态分布生成，其结构符合扩散模型（UNet）预期的维度。这允许通过可选地使用随机数生成器来复现结果。创建了初始向量后，代码通过每次迭代增量地添加一个小步长，在两个嵌入（积极和消极提示）之间进行一系列插值。结果存储在一个名为 “walked_embeddings” 的列表中。",Ue,O,ie,ll,yM="最后，让我们根据插值嵌入生成一系列图像，然后显示这些图像。我们将遍历一个嵌入数组，使用每个嵌入生成具有指定特征（如高度、宽度以及与图像生成相关的其他参数）的图像。然后我们将这些图像收集到一个列表中。一旦生成完成，我们将调用 <code>display_image</code> 函数，以在给定的保存路径上将这些图像保存并显示为 GIF。",we,el,me,Ml,Te,sl,pM="与第一个示例不同，在这个示例中，我们是在扩散模型本身的两个嵌入之间执行插值，而不是在提示之间。请注意，在这种情况下，我们使用 slerp 函数进行插值。然而，这并不妨碍我们在一个嵌入中添加一个常数。",ce,tl,JM='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_2.gif" alt="Example 2"/>',je,al,UM="下面呈现的函数代表球面线性插值（Spherical Linear Interpolation）。这是一种在球面上进行插值的方法。这个函数在计算机图形学中常用于平滑地动画旋转，并且也可以用于机器学习中高维数据点之间的插值，比如生成模型中使用的潜在向量。",oe,nl,iM=`该函数的来源是 Andrej Karpathy 的 gist：<a href="https://gist.github.com/karpathy/00103b0037c5aaea32fe1da1af553355%E3%80%82" rel="nofollow">https://gist.github.com/karpathy/00103b0037c5aaea32fe1da1af553355。</a><br/>
关于这种方法更详细的解释可以在：<a href="https://en.wikipedia.org/wiki/Slerp" rel="nofollow">https://en.wikipedia.org/wiki/Slerp</a> 找到。`,de,yl,be,pl,Ie,Jl,re,Ul,wM="与第一个示例中我们从一个提示移动开来不同，在这个示例中，我们将对任意数量的提示进行插值。为此，我们将取连续的提示对，并创建它们之间的平滑过渡。然后，我们将这些连续对的插值组合起来，并指示模型基于它们生成图像。我们将使用第二个示例中的 slerp 函数进行插值。",he,il,mM='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_3.gif" alt="Example 3"/>',Ze,wl,TM="再次，让我们对多个积极和消极的文本提示进行标记化并获得它们的嵌入。",ue,ml,Ce,Tl,cM="如前所述，我们将使用 <code>slerp</code> 函数对连续的提示对创建平滑过渡。",Ge,cl,Be,jl,jM="最后，我们需要根据嵌入生成图像。",We,ol,fe,dl,Xe,bl,oM='这个示例来自：<a href="https://keras.io/examples/generative/random_walks_with_stable_diffusion/" rel="nofollow">https://keras.io/examples/generative/random_walks_with_stable_diffusion/</a>',Ve,Il,dM="假设我们有两个噪声成分，我们称之为 x 和 y。我们从 0 移动到 2π，在每一步中，我们将 x 的余弦和 y 的正弦加到结果中。使用这种方法，在我们的移动结束时，我们得到了与开始时相同的噪声值。这意味着向量最终转变成它们自己，结束了我们的移动。",ge,rl,bM='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_4.gif" alt="Example 4"/>',Re,hl,ke,Zl,ve,ul,IM="接下来，您可以探索各种参数，如指导比例（guidance scale）、种子（seed）和插值步骤数（number of interpolation steps），以观察它们如何影响生成的图像。此外，尝试使用不同的提示和调度器来进一步优化你的结果。另一个有价值的步骤是实施线性插值（<code>linspace</code>），而不是球面线性插值（<code>slerp</code>），并比较结果，以更深入地了解插值过程。",Ae,Cl,Ye,Bl,_e;return d=new XM({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/stable_diffusion_interpolation.ipynb"}]}}),b=new o({props:{title:"使用 Stable Diffusion 进行图像插值",local:"使用-stable-diffusion-进行图像插值",headingTag:"h2"}}),W=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMHhmb3JtZXJzJTIwYWNjZWxlcmF0ZSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBudW1weSUyMHNjaXB5JTIwZnRmeSUyMFBpbGxvdw==",highlighted:`!pip install -q diffusers transformers xformers accelerate
!pip install -q numpy scipy ftfy Pillow`,wrap:!1}}),X=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBvcyUwQSUwQWltcG9ydCUyMHRpbWUlMEElMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwSVB5dGhvbiUyMGltcG9ydCUyMGRpc3BsYXklMjBhcyUyMElQZGlzcGxheSUwQWZyb20lMjB0cWRtLmF1dG8lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERElNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwUE5ETVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEEpJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvZ2dpbmclMEElMEFsb2dnaW5nLnNldF92ZXJib3NpdHlfZXJyb3IoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> time

<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> IPython <span class="hljs-keyword">import</span> display <span class="hljs-keyword">as</span> IPdisplay
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    DPMSolverMultistepScheduler,
    EulerAncestralDiscreteScheduler,
    EulerDiscreteScheduler,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> logging

logging.set_verbosity_error()`,wrap:!1}}),g=new c({props:{code:"cHJpbnQodG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSklMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMik=",highlighted:`<span class="hljs-built_in">print</span>(torch.cuda.is_available())

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)`,wrap:!1}}),v=new c({props:{code:"dG9yY2guYmFja2VuZHMuY3Vkbm4uYmVuY2htYXJrJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZGEubWF0bXVsLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`torch.backends.cudnn.benchmark = <span class="hljs-literal">True</span>
torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>`,wrap:!1}}),A=new o({props:{title:"模型",local:"模型",headingTag:"h3"}}),_=new c({props:{code:"bW9kZWxfbmFtZV9vcl9wYXRoJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciglMEElMjAlMjAlMjAlMjBiZXRhX3N0YXJ0JTNEMC4wMDA4NSUyQyUyMGJldGFfZW5kJTNEMC4wMTIlMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIyc2NhbGVkX2xpbmVhciUyMiUyQyUyMG51bV90cmFpbl90aW1lc3RlcHMlM0QxMDAwJTBBKSUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwRGlzYWJsZSUyMGltYWdlJTIwZ2VuZXJhdGlvbiUyMHByb2dyZXNzJTIwYmFyJTJDJTIwd2UnbGwlMjBkaXNwbGF5JTIwb3VyJTIwb3duJTBBcGlwZS5zZXRfcHJvZ3Jlc3NfYmFyX2NvbmZpZyhkaXNhYmxlJTNEVHJ1ZSk=",highlighted:`model_name_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

scheduler = LMSDiscreteScheduler(
    beta_start=<span class="hljs-number">0.00085</span>, beta_end=<span class="hljs-number">0.012</span>, beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>, num_train_timesteps=<span class="hljs-number">1000</span>
)


pipe = StableDiffusionPipeline.from_pretrained(
    model_name_or_path,
    scheduler=scheduler,
    torch_dtype=torch.float32,
).to(device)

<span class="hljs-comment"># Disable image generation progress bar, we&#x27;ll display our own</span>
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new c({props:{code:"JTIzJTIwT2ZmbG9hZGluZyUyMHRoZSUyMHdlaWdodHMlMjB0byUyMHRoZSUyMENQVSUyMGFuZCUyMG9ubHklMjBsb2FkaW5nJTIwdGhlbSUyMG9uJTIwdGhlJTIwR1BVJTIwY2FuJTIwcmVkdWNlJTIwbWVtb3J5JTIwY29uc3VtcHRpb24lMjB0byUyMGxlc3MlMjB0aGFuJTIwM0dCLiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBUaWdodGVyJTIwb3JkZXJpbmclMjBvZiUyMG1lbW9yeSUyMHRlbnNvcnMuJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQSUyMyUyMERlY29kaW5nJTIwbGFyZ2UlMjBiYXRjaGVzJTIwb2YlMjBpbWFnZXMlMjB3aXRoJTIwbGltaXRlZCUyMFZSQU0lMjBvciUyMGJhdGNoZXMlMjB3aXRoJTIwMzIlMjBpbWFnZXMlMjBvciUyMG1vcmUlMjBieSUyMGRlY29kaW5nJTIwdGhlJTIwYmF0Y2hlcyUyMG9mJTIwbGF0ZW50cyUyMG9uZSUyMGltYWdlJTIwYXQlMjBhJTIwdGltZS4lMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBJTIzJTIwU3BsaXR0aW5nJTIwdGhlJTIwaW1hZ2UlMjBpbnRvJTIwb3ZlcmxhcHBpbmclMjB0aWxlcyUyQyUyMGRlY29kaW5nJTIwdGhlJTIwdGlsZXMlMkMlMjBhbmQlMjB0aGVuJTIwYmxlbmRpbmclMjB0aGUlMjBvdXRwdXRzJTIwdG9nZXRoZXIlMjB0byUyMGNvbXBvc2UlMjB0aGUlMjBmaW5hbCUyMGltYWdlLiUwQXBpcGUuZW5hYmxlX3ZhZV90aWxpbmcoKSUwQSUwQSUyMyUyMFVzaW5nJTIwRmxhc2glMjBBdHRlbnRpb24lM0IlMjBJZiUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwJTNFJTNEJTIwMi4wJTIwaW5zdGFsbGVkJTJDJTIweW91JTIwc2hvdWxkJTIwbm90JTIwZXhwZWN0JTIwYSUyMHNwZWVkLXVwJTIwZm9yJTIwaW5mZXJlbmNlJTIwd2hlbiUyMGVuYWJsaW5nJTIweGZvcm1lcnMuJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-comment"># Offloading the weights to the CPU and only loading them on the GPU can reduce memory consumption to less than 3GB.</span>
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Tighter ordering of memory tensors.</span>
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-comment"># Decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time.</span>
pipe.enable_vae_slicing()

<span class="hljs-comment"># Splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image.</span>
pipe.enable_vae_tiling()

<span class="hljs-comment"># Using Flash Attention; If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling xformers.</span>
pipe.enable_xformers_memory_efficient_attention()`,wrap:!1}}),N=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">display_images</span>(<span class="hljs-params">images, save_path</span>):
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Convert each image in the &#x27;images&#x27; list from an array to an Image object.</span>
        images = [Image.fromarray(np.array(image[<span class="hljs-number">0</span>], dtype=np.uint8)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]

        <span class="hljs-comment"># Generate a file name based on the current time, replacing colons with hyphens</span>
        <span class="hljs-comment"># to ensure the filename is valid for file systems that don&#x27;t allow colons.</span>
        filename = time.strftime(<span class="hljs-string">&quot;%H:%M:%S&quot;</span>, time.localtime()).replace(<span class="hljs-string">&quot;:&quot;</span>, <span class="hljs-string">&quot;-&quot;</span>)
        <span class="hljs-comment"># Save the first image in the list as a GIF file at the &#x27;save_path&#x27; location.</span>
        <span class="hljs-comment"># The rest of the images in the list are added as subsequent frames to the GIF.</span>
        <span class="hljs-comment"># The GIF will play each frame for 100 milliseconds and will loop indefinitely.</span>
        images[<span class="hljs-number">0</span>].save(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{save_path}</span>/<span class="hljs-subst">{filename}</span>.gif&quot;</span>,
            save_all=<span class="hljs-literal">True</span>,
            append_images=images[<span class="hljs-number">1</span>:],
            duration=<span class="hljs-number">100</span>,
            loop=<span class="hljs-number">0</span>,
        )
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># If there is an error during the process, print the exception message.</span>
        <span class="hljs-built_in">print</span>(e)

    <span class="hljs-comment"># Return the saved GIF as an IPython display object so it can be displayed in a notebook.</span>
    <span class="hljs-keyword">return</span> IPdisplay.Image(<span class="hljs-string">f&quot;<span class="hljs-subst">{save_path}</span>/<span class="hljs-subst">{filename}</span>.gif&quot;</span>)`,wrap:!1}}),F=new o({props:{title:"生成参数",local:"生成参数",headingTag:"h3"}}),x=new c({props:{code:"JTIzJTIwVGhlJTIwc2VlZCUyMGlzJTIwc2V0JTIwdG8lMjAlMjJOb25lJTIyJTJDJTIwYmVjYXVzZSUyMHdlJTIwd2FudCUyMGRpZmZlcmVudCUyMHJlc3VsdHMlMjBlYWNoJTIwdGltZSUyMHdlJTIwcnVuJTIwdGhlJTIwZ2VuZXJhdGlvbi4lMEFzZWVkJTIwJTNEJTIwTm9uZSUwQSUwQWlmJTIwc2VlZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyME5vbmUlMEElMEElMjMlMjBUaGUlMjBndWlkYW5jZSUyMHNjYWxlJTIwaXMlMjBzZXQlMjB0byUyMGl0cyUyMG5vcm1hbCUyMHJhbmdlJTIwKDclMjAtJTIwMTApLiUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwOCUwQSUwQSUyMyUyMFRoZSUyMG51bWJlciUyMG9mJTIwaW5mZXJlbmNlJTIwc3RlcHMlMjB3YXMlMjBjaG9zZW4lMjBlbXBpcmljYWxseSUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGFjY2VwdGFibGUlMjBwaWN0dXJlJTIwd2l0aGluJTIwYW4lMjBhY2NlcHRhYmxlJTIwdGltZS4lMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMTUlMEElMEElMjMlMjBUaGUlMjBoaWdoZXIlMjB5b3UlMjBzZXQlMjB0aGlzJTIwdmFsdWUlMkMlMjB0aGUlMjBzbW9vdGhlciUyMHRoZSUyMGludGVycG9sYXRpb25zJTIwd2lsbCUyMGJlLiUyMEhvd2V2ZXIlMkMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwdGltZSUyMHdpbGwlMjBpbmNyZWFzZS4lMjBUaGlzJTIwdmFsdWUlMjB3YXMlMjBjaG9zZW4lMjBlbXBpcmljYWxseS4lMEFudW1faW50ZXJwb2xhdGlvbl9zdGVwcyUyMCUzRCUyMDMwJTBBJTBBJTIzJTIwSSUyMHdvdWxkJTIwbm90JTIwcmVjb21tZW5kJTIwbGVzcyUyMHRoYW4lMjA1MTIlMjBvbiUyMGVpdGhlciUyMGRpbWVuc2lvbi4lMjBUaGlzJTIwaXMlMjBiZWNhdXNlJTIwdGhpcyUyMG1vZGVsJTIwd2FzJTIwdHJhaW5lZCUyMG9uJTIwNTEyeDUxMiUyMGltYWdlJTIwcmVzb2x1dGlvbi4lMEFoZWlnaHQlMjAlM0QlMjA1MTIlMEF3aWR0aCUyMCUzRCUyMDUxMiUwQSUwQSUyMyUyMFRoZSUyMHBhdGglMjB3aGVyZSUyMHRoZSUyMGdlbmVyYXRlZCUyMEdJRnMlMjB3aWxsJTIwYmUlMjBzYXZlZCUwQXNhdmVfcGF0aCUyMCUzRCUyMCUyMiUyRm91dHB1dCUyMiUwQSUwQWlmJTIwbm90JTIwb3MucGF0aC5leGlzdHMoc2F2ZV9wYXRoKSUzQSUwQSUyMCUyMCUyMCUyMG9zLm1ha2VkaXJzKHNhdmVfcGF0aCk=",highlighted:`<span class="hljs-comment"># The seed is set to &quot;None&quot;, because we want different results each time we run the generation.</span>
seed = <span class="hljs-literal">None</span>

<span class="hljs-keyword">if</span> seed <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    generator = torch.manual_seed(seed)
<span class="hljs-keyword">else</span>:
    generator = <span class="hljs-literal">None</span>

<span class="hljs-comment"># The guidance scale is set to its normal range (7 - 10).</span>
guidance_scale = <span class="hljs-number">8</span>

<span class="hljs-comment"># The number of inference steps was chosen empirically to generate an acceptable picture within an acceptable time.</span>
num_inference_steps = <span class="hljs-number">15</span>

<span class="hljs-comment"># The higher you set this value, the smoother the interpolations will be. However, the generation time will increase. This value was chosen empirically.</span>
num_interpolation_steps = <span class="hljs-number">30</span>

<span class="hljs-comment"># I would not recommend less than 512 on either dimension. This is because this model was trained on 512x512 image resolution.</span>
height = <span class="hljs-number">512</span>
width = <span class="hljs-number">512</span>

<span class="hljs-comment"># The path where the generated GIFs will be saved</span>
save_path = <span class="hljs-string">&quot;/output&quot;</span>

<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(save_path):
    os.makedirs(save_path)`,wrap:!1}}),$=new o({props:{title:"示例 1：提示插值",local:"示例-1提示插值",headingTag:"h3"}}),K=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = <span class="hljs-string">&quot;Epic shot of Sweden, ultra detailed lake with an ren dear, nostalgic vintage, ultra cozy and inviting, wonderful light atmosphere, fairy, little photorealistic, digital painting, sharp focus, ultra cozy and inviting, wish to be there. very detailed, arty, should rank high on youtube for a dream trip.&quot;</span>
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features; here, it is empty.</span>
negative_prompt = <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>

<span class="hljs-comment"># The step size for the interpolation in the latent space.</span>
step_size = <span class="hljs-number">0.001</span>

<span class="hljs-comment"># Tokenizing and encoding the prompt into embeddings.</span>
prompt_tokens = pipe.tokenizer(
    prompt,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
prompt_embeds = pipe.text_encoder(prompt_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]


<span class="hljs-comment"># Tokenizing and encoding the negative prompt into embeddings.</span>
<span class="hljs-keyword">if</span> negative_prompt <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    negative_prompt = [<span class="hljs-string">&quot;&quot;</span>]

negative_prompt_tokens = pipe.tokenizer(
    negative_prompt,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
negative_prompt_embeds = pipe.text_encoder(negative_prompt_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]`,wrap:!1}}),O=new c({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGluaXRpYWwlMjBsYXRlbnQlMjB2ZWN0b3JzJTIwZnJvbSUyMGElMjByYW5kb20lMjBub3JtYWwlMjBkaXN0cmlidXRpb24lMkMlMjB3aXRoJTIwdGhlJTIwb3B0aW9uJTIwdG8lMjB1c2UlMjBhJTIwZ2VuZXJhdG9yJTIwZm9yJTIwcmVwcm9kdWNpYmlsaXR5LiUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMjAlMjAlMjAlMjAoMSUyQyUyMHBpcGUudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSklMEElMEF3YWxrZWRfZW1iZWRkaW5ncyUyMCUzRCUyMCU1QiU1RCUwQSUwQSUyMyUyMEludGVycG9sYXRpbmclMjBiZXR3ZWVuJTIwZW1iZWRkaW5ncyUyMGZvciUyMHRoZSUyMGdpdmVuJTIwbnVtYmVyJTIwb2YlMjBpbnRlcnBvbGF0aW9uJTIwc3RlcHMuJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UobnVtX2ludGVycG9sYXRpb25fc3RlcHMpJTNBJTBBJTIwJTIwJTIwJTIwd2Fsa2VkX2VtYmVkZGluZ3MuYXBwZW5kKCU1QnByb21wdF9lbWJlZHMlMjAlMkIlMjBzdGVwX3NpemUlMjAqJTIwaSUyQyUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlMjAlMkIlMjBzdGVwX3NpemUlMjAqJTIwaSU1RCk=",highlighted:`<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution, with the option to use a generator for reproducibility.</span>
latents = torch.randn(
    (<span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

walked_embeddings = []

<span class="hljs-comment"># Interpolating between embeddings for the given number of interpolation steps.</span>
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_interpolation_steps):
    walked_embeddings.append([prompt_embeds + step_size * i, negative_prompt_embeds + step_size * i])`,wrap:!1}}),el=new c({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGltYWdlcyUyMHVzaW5nJTIwdGhlJTIwaW50ZXJwb2xhdGVkJTIwZW1iZWRkaW5ncy4lMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBsYXRlbnQlMjBpbiUyMHRxZG0od2Fsa2VkX2VtYmVkZGluZ3MpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VzLmFwcGVuZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhlaWdodCUzRGhlaWdodCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpZHRoJTNEd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRGxhdGVudCU1QjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbGF0ZW50JTVCMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhdGVudHMlM0RsYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5pbWFnZXMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIzJTIwRGlzcGxheSUyMG9mJTIwc2F2ZWQlMjBnZW5lcmF0ZWQlMjBpbWFnZXMuJTBBZGlzcGxheV9pbWFnZXMoaW1hZ2VzJTJDJTIwc2F2ZV9wYXRoKQ==",highlighted:`<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent <span class="hljs-keyword">in</span> tqdm(walked_embeddings):
    images.append(
        pipe(
            height=height,
            width=width,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            prompt_embeds=latent[<span class="hljs-number">0</span>],
            negative_prompt_embeds=latent[<span class="hljs-number">1</span>],
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latents,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),Ml=new o({props:{title:"示例 2：针对单个提示的扩散潜在插值",local:"示例-2针对单个提示的扩散潜在插值",headingTag:"h3"}}),yl=new c({props:{code:"ZGVmJTIwc2xlcnAodjAlMkMlMjB2MSUyQyUyMG51bSUyQyUyMHQwJTNEMCUyQyUyMHQxJTNEMSklM0ElMEElMjAlMjAlMjAlMjB2MCUyMCUzRCUyMHYwLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjB2MSUyMCUzRCUyMHYxLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBpbnRlcnBvbGF0aW9uKHQlMkMlMjB2MCUyQyUyMHYxJTJDJTIwRE9UX1RIUkVTSE9MRCUzRDAuOTk5NSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJoZWxwZXIlMjBmdW5jdGlvbiUyMHRvJTIwc3BoZXJpY2FsbHklMjBpbnRlcnBvbGF0ZSUyMHR3byUyMGFycmF5cyUyMHYxJTIwdjIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb3QlMjAlM0QlMjBucC5zdW0odjAlMjAqJTIwdjElMjAlMkYlMjAobnAubGluYWxnLm5vcm0odjApJTIwKiUyMG5wLmxpbmFsZy5ub3JtKHYxKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBucC5hYnMoZG90KSUyMCUzRSUyMERPVF9USFJFU0hPTEQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2MiUyMCUzRCUyMCgxJTIwLSUyMHQpJTIwKiUyMHYwJTIwJTJCJTIwdCUyMColMjB2MSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aGV0YV8wJTIwJTNEJTIwbnAuYXJjY29zKGRvdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaW5fdGhldGFfMCUyMCUzRCUyMG5wLnNpbih0aGV0YV8wKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRoZXRhX3QlMjAlM0QlMjB0aGV0YV8wJTIwKiUyMHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaW5fdGhldGFfdCUyMCUzRCUyMG5wLnNpbih0aGV0YV90KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHMwJTIwJTNEJTIwbnAuc2luKHRoZXRhXzAlMjAtJTIwdGhldGFfdCklMjAlMkYlMjBzaW5fdGhldGFfMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHMxJTIwJTNEJTIwc2luX3RoZXRhX3QlMjAlMkYlMjBzaW5fdGhldGFfMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHYyJTIwJTNEJTIwczAlMjAqJTIwdjAlMjAlMkIlMjBzMSUyMColMjB2MSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHYyJTBBJTBBJTIwJTIwJTIwJTIwdCUyMCUzRCUyMG5wLmxpbnNwYWNlKHQwJTJDJTIwdDElMkMlMjBudW0pJTBBJTBBJTIwJTIwJTIwJTIwdjMlMjAlM0QlMjB0b3JjaC50ZW5zb3IobnAuYXJyYXkoJTVCaW50ZXJwb2xhdGlvbih0JTVCaSU1RCUyQyUyMHYwJTJDJTIwdjEpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobnVtKSU1RCkpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdjM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">slerp</span>(<span class="hljs-params">v0, v1, num, t0=<span class="hljs-number">0</span>, t1=<span class="hljs-number">1</span></span>):
    v0 = v0.detach().cpu().numpy()
    v1 = v1.detach().cpu().numpy()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">interpolation</span>(<span class="hljs-params">t, v0, v1, DOT_THRESHOLD=<span class="hljs-number">0.9995</span></span>):
        <span class="hljs-string">&quot;&quot;&quot;helper function to spherically interpolate two arrays v1 v2&quot;&quot;&quot;</span>
        dot = np.<span class="hljs-built_in">sum</span>(v0 * v1 / (np.linalg.norm(v0) * np.linalg.norm(v1)))
        <span class="hljs-keyword">if</span> np.<span class="hljs-built_in">abs</span>(dot) &gt; DOT_THRESHOLD:
            v2 = (<span class="hljs-number">1</span> - t) * v0 + t * v1
        <span class="hljs-keyword">else</span>:
            theta_0 = np.arccos(dot)
            sin_theta_0 = np.sin(theta_0)
            theta_t = theta_0 * t
            sin_theta_t = np.sin(theta_t)
            s0 = np.sin(theta_0 - theta_t) / sin_theta_0
            s1 = sin_theta_t / sin_theta_0
            v2 = s0 * v0 + s1 * v1
        <span class="hljs-keyword">return</span> v2

    t = np.linspace(t0, t1, num)

    v3 = torch.tensor(np.array([interpolation(t[i], v0, v1) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num)]))

    <span class="hljs-keyword">return</span> v3`,wrap:!1}}),pl=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = (
    <span class="hljs-string">&quot;Sci-fi digital painting of an alien landscape with otherworldly plants, strange creatures, and distant planets.&quot;</span>
)
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features.</span>
negative_prompt = <span class="hljs-string">&quot;poorly drawn,cartoon, 3d, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>

<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution. In this example two latent vectors are generated, which will serve as start and end points for the interpolation.</span>
<span class="hljs-comment"># These vectors are shaped to fit the input requirements of the diffusion model&#x27;s U-Net architecture.</span>
latents = torch.randn(
    (<span class="hljs-number">2</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

<span class="hljs-comment"># Getting our latent embeddings</span>
interpolated_latents = slerp(latents[<span class="hljs-number">0</span>], latents[<span class="hljs-number">1</span>], num_interpolation_steps)

<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent_vector <span class="hljs-keyword">in</span> tqdm(interpolated_latents):
    images.append(
        pipe(
            prompt,
            height=height,
            width=width,
            negative_prompt=negative_prompt,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latent_vector[<span class="hljs-literal">None</span>, ...],
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),Jl=new o({props:{title:"示例 3：多个提示之间的插值",local:"示例-3多个提示之间的插值",headingTag:"h3"}}),ml=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Text prompts that describes the desired output image.</span>
prompts = [
    <span class="hljs-string">&quot;A cute dog in a beautiful field of lavander colorful flowers everywhere, perfect lighting, leica summicron 35mm f2.0, kodak portra 400, film grain&quot;</span>,
    <span class="hljs-string">&quot;A cute cat in a beautiful field of lavander colorful flowers everywhere, perfect lighting, leica summicron 35mm f2.0, kodak portra 400, film grain&quot;</span>,
]
<span class="hljs-comment"># Negative prompts that can be used to steer the generation away from certain features.</span>
negative_prompts = [
    <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, sketch, cartoon, drawing, anime, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>,
    <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, sketch, cartoon, drawing, anime, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>,
]

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> The number of prompts must match the number of negative prompts</span>

batch_size = <span class="hljs-built_in">len</span>(prompts)

<span class="hljs-comment"># Tokenizing and encoding prompts into embeddings.</span>
prompts_tokens = pipe.tokenizer(
    prompts,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
prompts_embeds = pipe.text_encoder(prompts_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Tokenizing and encoding negative prompts into embeddings.</span>
<span class="hljs-keyword">if</span> negative_prompts <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    negative_prompts = [<span class="hljs-string">&quot;&quot;</span>] * batch_size

negative_prompts_tokens = pipe.tokenizer(
    negative_prompts,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
negative_prompts_embeds = pipe.text_encoder(negative_prompts_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]`,wrap:!1}}),cl=new c({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGluaXRpYWwlMjBVLU5ldCUyMGxhdGVudCUyMHZlY3RvcnMlMjBmcm9tJTIwYSUyMHJhbmRvbSUyMG5vcm1hbCUyMGRpc3RyaWJ1dGlvbi4lMEFsYXRlbnRzJTIwJTNEJTIwdG9yY2gucmFuZG4oJTBBJTIwJTIwJTIwJTIwKDElMkMlMjBwaXBlLnVuZXQuY29uZmlnLmluX2NoYW5uZWxzJTJDJTIwaGVpZ2h0JTIwJTJGJTJGJTIwOCUyQyUyMHdpZHRoJTIwJTJGJTJGJTIwOCklMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEEpJTBBJTBBJTIzJTIwSW50ZXJwb2xhdGluZyUyMGJldHdlZW4lMjBlbWJlZGRpbmdzJTIwcGFpcnMlMjBmb3IlMjB0aGUlMjBnaXZlbiUyMG51bWJlciUyMG9mJTIwaW50ZXJwb2xhdGlvbiUyMHN0ZXBzLiUwQWludGVycG9sYXRlZF9wcm9tcHRfZW1iZWRzJTIwJTNEJTIwJTVCJTVEJTBBaW50ZXJwb2xhdGVkX25lZ2F0aXZlX3Byb21wdHNfZW1iZWRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoYmF0Y2hfc2l6ZSUyMC0lMjAxKSUzQSUwQSUyMCUyMCUyMCUyMGludGVycG9sYXRlZF9wcm9tcHRfZW1iZWRzLmFwcGVuZChzbGVycChwcm9tcHRzX2VtYmVkcyU1QmklNUQlMkMlMjBwcm9tcHRzX2VtYmVkcyU1QmklMjAlMkIlMjAxJTVEJTJDJTIwbnVtX2ludGVycG9sYXRpb25fc3RlcHMpKSUwQSUyMCUyMCUyMCUyMGludGVycG9sYXRlZF9uZWdhdGl2ZV9wcm9tcHRzX2VtYmVkcy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2xlcnAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlNUJpJTIwJTJCJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbnRlcnBvbGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCklMEElMEFpbnRlcnBvbGF0ZWRfcHJvbXB0X2VtYmVkcyUyMCUzRCUyMHRvcmNoLmNhdChpbnRlcnBvbGF0ZWRfcHJvbXB0X2VtYmVkcyUyQyUyMGRpbSUzRDApLnRvKGRldmljZSklMEElMEFpbnRlcnBvbGF0ZWRfbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlMjAlM0QlMjB0b3JjaC5jYXQoaW50ZXJwb2xhdGVkX25lZ2F0aXZlX3Byb21wdHNfZW1iZWRzJTJDJTIwZGltJTNEMCkudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-comment"># Generating initial U-Net latent vectors from a random normal distribution.</span>
latents = torch.randn(
    (<span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

<span class="hljs-comment"># Interpolating between embeddings pairs for the given number of interpolation steps.</span>
interpolated_prompt_embeds = []
interpolated_negative_prompts_embeds = []
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size - <span class="hljs-number">1</span>):
    interpolated_prompt_embeds.append(slerp(prompts_embeds[i], prompts_embeds[i + <span class="hljs-number">1</span>], num_interpolation_steps))
    interpolated_negative_prompts_embeds.append(
        slerp(
            negative_prompts_embeds[i],
            negative_prompts_embeds[i + <span class="hljs-number">1</span>],
            num_interpolation_steps,
        )
    )

interpolated_prompt_embeds = torch.cat(interpolated_prompt_embeds, dim=<span class="hljs-number">0</span>).to(device)

interpolated_negative_prompts_embeds = torch.cat(interpolated_negative_prompts_embeds, dim=<span class="hljs-number">0</span>).to(device)`,wrap:!1}}),ol=new c({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGltYWdlcyUyMHVzaW5nJTIwdGhlJTIwaW50ZXJwb2xhdGVkJTIwZW1iZWRkaW5ncy4lMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBwcm9tcHRfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUyMGluJTIwdHFkbSglMEElMjAlMjAlMjAlMjB6aXAoaW50ZXJwb2xhdGVkX3Byb21wdF9lbWJlZHMlMkMlMjBpbnRlcnBvbGF0ZWRfbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMpJTJDJTBBJTIwJTIwJTIwJTIwdG90YWwlM0RsZW4oaW50ZXJwb2xhdGVkX3Byb21wdF9lbWJlZHMpJTJDJTBBKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0RoZWlnaHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aWR0aCUzRHdpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTVCTm9uZSUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTVCTm9uZSUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhdGVudHMlM0RsYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5pbWFnZXMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIzJTIwRGlzcGxheSUyMG9mJTIwc2F2ZWQlMjBnZW5lcmF0ZWQlMjBpbWFnZXMuJTBBZGlzcGxheV9pbWFnZXMoaW1hZ2VzJTJDJTIwc2F2ZV9wYXRoKQ==",highlighted:`<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> prompt_embeds, negative_prompt_embeds <span class="hljs-keyword">in</span> tqdm(
    <span class="hljs-built_in">zip</span>(interpolated_prompt_embeds, interpolated_negative_prompts_embeds),
    total=<span class="hljs-built_in">len</span>(interpolated_prompt_embeds),
):
    images.append(
        pipe(
            height=height,
            width=width,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            prompt_embeds=prompt_embeds[<span class="hljs-literal">None</span>, ...],
            negative_prompt_embeds=negative_prompt_embeds[<span class="hljs-literal">None</span>, ...],
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latents,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),dl=new o({props:{title:"示例 4：针对单个提示在扩散潜在空间中的循环行走",local:"示例-4针对单个提示在扩散潜在空间中的循环行走",headingTag:"h3"}}),hl=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = <span class="hljs-string">&quot;Beautiful sea sunset, warm light, Aivazovsky style&quot;</span>
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features</span>
negative_prompt = <span class="hljs-string">&quot;picture frames&quot;</span>

<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution to create a loop interpolation between them.</span>
latents = torch.randn(
    (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)


<span class="hljs-comment"># Calculation of looped embeddings</span>
walk_noise_x = latents[<span class="hljs-number">0</span>].to(device)
walk_noise_y = latents[<span class="hljs-number">1</span>].to(device)

<span class="hljs-comment"># Walking on a trigonometric circle</span>
walk_scale_x = torch.cos(torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, num_interpolation_steps) * np.pi).to(device)
walk_scale_y = torch.sin(torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, num_interpolation_steps) * np.pi).to(device)

<span class="hljs-comment"># Applying interpolation to noise</span>
noise_x = torch.tensordot(walk_scale_x, walk_noise_x, dims=<span class="hljs-number">0</span>)
noise_y = torch.tensordot(walk_scale_y, walk_noise_y, dims=<span class="hljs-number">0</span>)

circular_latents = noise_x + noise_y

<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent_vector <span class="hljs-keyword">in</span> tqdm(circular_latents):
    images.append(
        pipe(
            prompt,
            height=height,
            width=width,
            negative_prompt=negative_prompt,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latent_vector,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),Zl=new o({props:{title:"下一步",local:"下一步",headingTag:"h2"}}),Cl=new VM({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/stable_diffusion_interpolation.md"}}),{c(){j=n("meta"),Wl=t(),Gl=n("p"),fl=t(),J(d.$$.fragment),Xl=t(),J(b.$$.fragment),Vl=t(),I=n("p"),I.innerHTML=Ee,gl=t(),r=n("p"),r.textContent=Se,Rl=t(),h=n("p"),h.textContent=Qe,kl=t(),Z=n("ul"),Z.innerHTML=Ne,vl=t(),u=n("p"),u.textContent=Fe,Al=t(),C=n("p"),C.textContent=ze,Yl=t(),G=n("p"),G.textContent=xe,_l=t(),B=n("p"),B.textContent=$e,Hl=t(),J(W.$$.fragment),El=t(),f=n("p"),f.textContent=De,Sl=t(),J(X.$$.fragment),Ql=t(),V=n("p"),V.textContent=Le,Nl=t(),J(g.$$.fragment),Fl=t(),R=n("p"),R.textContent=qe,zl=t(),k=n("p"),k.innerHTML=Ke,xl=t(),J(v.$$.fragment),$l=t(),J(A.$$.fragment),Dl=t(),Y=n("p"),Y.innerHTML=Pe,Ll=t(),J(_.$$.fragment),ql=t(),H=n("p"),H.textContent=Oe,Kl=t(),E=n("p"),E.innerHTML=lM,Pl=t(),J(S.$$.fragment),Ol=t(),Q=n("p"),Q.innerHTML=eM,le=t(),J(N.$$.fragment),ee=t(),J(F.$$.fragment),Me=t(),z=n("ul"),z.innerHTML=MM,se=t(),J(x.$$.fragment),te=t(),J($.$$.fragment),ae=t(),D=n("p"),D.textContent=sM,ne=t(),L=n("p"),L.innerHTML=tM,ye=t(),q=n("p"),q.textContent=aM,pe=t(),J(K.$$.fragment),Je=t(),P=n("p"),P.textContent=nM,Ue=t(),J(O.$$.fragment),ie=t(),ll=n("p"),ll.innerHTML=yM,we=t(),J(el.$$.fragment),me=t(),J(Ml.$$.fragment),Te=t(),sl=n("p"),sl.textContent=pM,ce=t(),tl=n("p"),tl.innerHTML=JM,je=t(),al=n("p"),al.textContent=UM,oe=t(),nl=n("p"),nl.innerHTML=iM,de=t(),J(yl.$$.fragment),be=t(),J(pl.$$.fragment),Ie=t(),J(Jl.$$.fragment),re=t(),Ul=n("p"),Ul.textContent=wM,he=t(),il=n("p"),il.innerHTML=mM,Ze=t(),wl=n("p"),wl.textContent=TM,ue=t(),J(ml.$$.fragment),Ce=t(),Tl=n("p"),Tl.innerHTML=cM,Ge=t(),J(cl.$$.fragment),Be=t(),jl=n("p"),jl.textContent=jM,We=t(),J(ol.$$.fragment),fe=t(),J(dl.$$.fragment),Xe=t(),bl=n("p"),bl.innerHTML=oM,Ve=t(),Il=n("p"),Il.textContent=dM,ge=t(),rl=n("p"),rl.innerHTML=bM,Re=t(),J(hl.$$.fragment),ke=t(),J(Zl.$$.fragment),ve=t(),ul=n("p"),ul.innerHTML=IM,Ae=t(),J(Cl.$$.fragment),Ye=t(),Bl=n("p"),this.h()},l(l){const e=WM("svelte-u9bgzb",document.head);j=y(e,"META",{name:!0,content:!0}),e.forEach(M),Wl=a(l),Gl=y(l,"P",{}),rM(Gl).forEach(M),fl=a(l),U(d.$$.fragment,l),Xl=a(l),U(b.$$.fragment,l),Vl=a(l),I=y(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-l1zus2"&&(I.innerHTML=Ee),gl=a(l),r=y(l,"P",{"data-svelte-h":!0}),p(r)!=="svelte-vl3vu"&&(r.textContent=Se),Rl=a(l),h=y(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-3yjhy9"&&(h.textContent=Qe),kl=a(l),Z=y(l,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-x06y5u"&&(Z.innerHTML=Ne),vl=a(l),u=y(l,"P",{"data-svelte-h":!0}),p(u)!=="svelte-1amlnbc"&&(u.textContent=Fe),Al=a(l),C=y(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-80jdxw"&&(C.textContent=ze),Yl=a(l),G=y(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1s0jexb"&&(G.textContent=xe),_l=a(l),B=y(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-90kp52"&&(B.textContent=$e),Hl=a(l),U(W.$$.fragment,l),El=a(l),f=y(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1cpgku1"&&(f.textContent=De),Sl=a(l),U(X.$$.fragment,l),Ql=a(l),V=y(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-kiqgoo"&&(V.textContent=Le),Nl=a(l),U(g.$$.fragment,l),Fl=a(l),R=y(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1xivm34"&&(R.textContent=qe),zl=a(l),k=y(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-10ww4iw"&&(k.innerHTML=Ke),xl=a(l),U(v.$$.fragment,l),$l=a(l),U(A.$$.fragment,l),Dl=a(l),Y=y(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-cjrc4k"&&(Y.innerHTML=Pe),Ll=a(l),U(_.$$.fragment,l),ql=a(l),H=y(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-d699bz"&&(H.textContent=Oe),Kl=a(l),E=y(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-16msx7m"&&(E.innerHTML=lM),Pl=a(l),U(S.$$.fragment,l),Ol=a(l),Q=y(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-kaqcjf"&&(Q.innerHTML=eM),le=a(l),U(N.$$.fragment,l),ee=a(l),U(F.$$.fragment,l),Me=a(l),z=y(l,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1960fzq"&&(z.innerHTML=MM),se=a(l),U(x.$$.fragment,l),te=a(l),U($.$$.fragment,l),ae=a(l),D=y(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1547xx2"&&(D.textContent=sM),ne=a(l),L=y(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1x05mg4"&&(L.innerHTML=tM),ye=a(l),q=y(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-mpab18"&&(q.textContent=aM),pe=a(l),U(K.$$.fragment,l),Je=a(l),P=y(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1loead7"&&(P.textContent=nM),Ue=a(l),U(O.$$.fragment,l),ie=a(l),ll=y(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-qyojnk"&&(ll.innerHTML=yM),we=a(l),U(el.$$.fragment,l),me=a(l),U(Ml.$$.fragment,l),Te=a(l),sl=y(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1n1zuo4"&&(sl.textContent=pM),ce=a(l),tl=y(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-zqtywg"&&(tl.innerHTML=JM),je=a(l),al=y(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-dfsbxo"&&(al.textContent=UM),oe=a(l),nl=y(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-ghr9ym"&&(nl.innerHTML=iM),de=a(l),U(yl.$$.fragment,l),be=a(l),U(pl.$$.fragment,l),Ie=a(l),U(Jl.$$.fragment,l),re=a(l),Ul=y(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-11iwlsu"&&(Ul.textContent=wM),he=a(l),il=y(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1uv5js0"&&(il.innerHTML=mM),Ze=a(l),wl=y(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-1v61gi9"&&(wl.textContent=TM),ue=a(l),U(ml.$$.fragment,l),Ce=a(l),Tl=y(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-hd1991"&&(Tl.innerHTML=cM),Ge=a(l),U(cl.$$.fragment,l),Be=a(l),jl=y(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1edtf72"&&(jl.textContent=jM),We=a(l),U(ol.$$.fragment,l),fe=a(l),U(dl.$$.fragment,l),Xe=a(l),bl=y(l,"P",{"data-svelte-h":!0}),p(bl)!=="svelte-1awlctq"&&(bl.innerHTML=oM),Ve=a(l),Il=y(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-jtjlcu"&&(Il.textContent=dM),ge=a(l),rl=y(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-1h51p8s"&&(rl.innerHTML=bM),Re=a(l),U(hl.$$.fragment,l),ke=a(l),U(Zl.$$.fragment,l),ve=a(l),ul=y(l,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-zjdioo"&&(ul.innerHTML=IM),Ae=a(l),U(Cl.$$.fragment,l),Ye=a(l),Bl=y(l,"P",{}),rM(Bl).forEach(M),this.h()},h(){hM(j,"name","hf:doc:metadata"),hM(j,"content",RM)},m(l,e){fM(document.head,j),s(l,Wl,e),s(l,Gl,e),s(l,fl,e),i(d,l,e),s(l,Xl,e),i(b,l,e),s(l,Vl,e),s(l,I,e),s(l,gl,e),s(l,r,e),s(l,Rl,e),s(l,h,e),s(l,kl,e),s(l,Z,e),s(l,vl,e),s(l,u,e),s(l,Al,e),s(l,C,e),s(l,Yl,e),s(l,G,e),s(l,_l,e),s(l,B,e),s(l,Hl,e),i(W,l,e),s(l,El,e),s(l,f,e),s(l,Sl,e),i(X,l,e),s(l,Ql,e),s(l,V,e),s(l,Nl,e),i(g,l,e),s(l,Fl,e),s(l,R,e),s(l,zl,e),s(l,k,e),s(l,xl,e),i(v,l,e),s(l,$l,e),i(A,l,e),s(l,Dl,e),s(l,Y,e),s(l,Ll,e),i(_,l,e),s(l,ql,e),s(l,H,e),s(l,Kl,e),s(l,E,e),s(l,Pl,e),i(S,l,e),s(l,Ol,e),s(l,Q,e),s(l,le,e),i(N,l,e),s(l,ee,e),i(F,l,e),s(l,Me,e),s(l,z,e),s(l,se,e),i(x,l,e),s(l,te,e),i($,l,e),s(l,ae,e),s(l,D,e),s(l,ne,e),s(l,L,e),s(l,ye,e),s(l,q,e),s(l,pe,e),i(K,l,e),s(l,Je,e),s(l,P,e),s(l,Ue,e),i(O,l,e),s(l,ie,e),s(l,ll,e),s(l,we,e),i(el,l,e),s(l,me,e),i(Ml,l,e),s(l,Te,e),s(l,sl,e),s(l,ce,e),s(l,tl,e),s(l,je,e),s(l,al,e),s(l,oe,e),s(l,nl,e),s(l,de,e),i(yl,l,e),s(l,be,e),i(pl,l,e),s(l,Ie,e),i(Jl,l,e),s(l,re,e),s(l,Ul,e),s(l,he,e),s(l,il,e),s(l,Ze,e),s(l,wl,e),s(l,ue,e),i(ml,l,e),s(l,Ce,e),s(l,Tl,e),s(l,Ge,e),i(cl,l,e),s(l,Be,e),s(l,jl,e),s(l,We,e),i(ol,l,e),s(l,fe,e),i(dl,l,e),s(l,Xe,e),s(l,bl,e),s(l,Ve,e),s(l,Il,e),s(l,ge,e),s(l,rl,e),s(l,Re,e),i(hl,l,e),s(l,ke,e),i(Zl,l,e),s(l,ve,e),s(l,ul,e),s(l,Ae,e),i(Cl,l,e),s(l,Ye,e),s(l,Bl,e),_e=!0},p:uM,i(l){_e||(w(d.$$.fragment,l),w(b.$$.fragment,l),w(W.$$.fragment,l),w(X.$$.fragment,l),w(g.$$.fragment,l),w(v.$$.fragment,l),w(A.$$.fragment,l),w(_.$$.fragment,l),w(S.$$.fragment,l),w(N.$$.fragment,l),w(F.$$.fragment,l),w(x.$$.fragment,l),w($.$$.fragment,l),w(K.$$.fragment,l),w(O.$$.fragment,l),w(el.$$.fragment,l),w(Ml.$$.fragment,l),w(yl.$$.fragment,l),w(pl.$$.fragment,l),w(Jl.$$.fragment,l),w(ml.$$.fragment,l),w(cl.$$.fragment,l),w(ol.$$.fragment,l),w(dl.$$.fragment,l),w(hl.$$.fragment,l),w(Zl.$$.fragment,l),w(Cl.$$.fragment,l),_e=!0)},o(l){m(d.$$.fragment,l),m(b.$$.fragment,l),m(W.$$.fragment,l),m(X.$$.fragment,l),m(g.$$.fragment,l),m(v.$$.fragment,l),m(A.$$.fragment,l),m(_.$$.fragment,l),m(S.$$.fragment,l),m(N.$$.fragment,l),m(F.$$.fragment,l),m(x.$$.fragment,l),m($.$$.fragment,l),m(K.$$.fragment,l),m(O.$$.fragment,l),m(el.$$.fragment,l),m(Ml.$$.fragment,l),m(yl.$$.fragment,l),m(pl.$$.fragment,l),m(Jl.$$.fragment,l),m(ml.$$.fragment,l),m(cl.$$.fragment,l),m(ol.$$.fragment,l),m(dl.$$.fragment,l),m(hl.$$.fragment,l),m(Zl.$$.fragment,l),m(Cl.$$.fragment,l),_e=!1},d(l){l&&(M(Wl),M(Gl),M(fl),M(Xl),M(Vl),M(I),M(gl),M(r),M(Rl),M(h),M(kl),M(Z),M(vl),M(u),M(Al),M(C),M(Yl),M(G),M(_l),M(B),M(Hl),M(El),M(f),M(Sl),M(Ql),M(V),M(Nl),M(Fl),M(R),M(zl),M(k),M(xl),M($l),M(Dl),M(Y),M(Ll),M(ql),M(H),M(Kl),M(E),M(Pl),M(Ol),M(Q),M(le),M(ee),M(Me),M(z),M(se),M(te),M(ae),M(D),M(ne),M(L),M(ye),M(q),M(pe),M(Je),M(P),M(Ue),M(ie),M(ll),M(we),M(me),M(Te),M(sl),M(ce),M(tl),M(je),M(al),M(oe),M(nl),M(de),M(be),M(Ie),M(re),M(Ul),M(he),M(il),M(Ze),M(wl),M(ue),M(Ce),M(Tl),M(Ge),M(Be),M(jl),M(We),M(fe),M(Xe),M(bl),M(Ve),M(Il),M(ge),M(rl),M(Re),M(ke),M(ve),M(ul),M(Ae),M(Ye),M(Bl)),M(j),T(d,l),T(b,l),T(W,l),T(X,l),T(g,l),T(v,l),T(A,l),T(_,l),T(S,l),T(N,l),T(F,l),T(x,l),T($,l),T(K,l),T(O,l),T(el,l),T(Ml,l),T(yl,l),T(pl,l),T(Jl,l),T(ml,l),T(cl,l),T(ol,l),T(dl,l),T(hl,l),T(Zl,l),T(Cl,l)}}}const RM='{"title":"使用 Stable Diffusion 进行图像插值","local":"使用-stable-diffusion-进行图像插值","sections":[{"title":"模型","local":"模型","sections":[],"depth":3},{"title":"生成参数","local":"生成参数","sections":[],"depth":3},{"title":"示例 1：提示插值","local":"示例-1提示插值","sections":[],"depth":3},{"title":"示例 2：针对单个提示的扩散潜在插值","local":"示例-2针对单个提示的扩散潜在插值","sections":[],"depth":3},{"title":"示例 3：多个提示之间的插值","local":"示例-3多个提示之间的插值","sections":[],"depth":3},{"title":"示例 4：针对单个提示在扩散潜在空间中的循环行走","local":"示例-4针对单个提示在扩散潜在空间中的循环行走","sections":[],"depth":3}],"depth":2}';function kM(He){return CM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class HM extends GM{constructor(j){super(),BM(this,j,kM,gM,ZM,{})}}export{HM as component};
