import{s as ht,n as gt,o as ft}from"../chunks/scheduler.39a43cde.js";import{S as Zt,i as vt,g as i,s,r as y,A as Bt,h as r,f as t,c as n,j as kt,u as o,x as M,k as It,y as Gt,a,v as p,d as u,t as m,w as U}from"../chunks/index.23ec2204.js";import{D as Wt,C as J}from"../chunks/DocNotebookDropdown.7c3158f8.js";import{H as d,E as zt}from"../chunks/getInferenceSnippets.6ac8bef9.js";function Rt(_e){let c,fl,hl,Zl,T,vl,b,Bl,j,Qe='<em>Yazar: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em> <em>Çeviren: <a href="https://github.com/alpererdogan8" rel="nofollow">Alper Erdoğan</a></em>',Gl,w,Se='Bu notebook, harika <strong>ajanlar</strong> oluşturmak için <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents’ı</strong></a> nasıl kullanabileceğinizi gösterir!',Wl,C,Ae="<strong>Ajanlar</strong> nedir? Ajanlar, bir LLM tarafından desteklenen ve spesifik istemler ile çıktıların ayrıştırılması sayesinde belirli <em>araçları</em> kullanarak problemleri çözebilen sistemlerdir.",zl,k,Ee='Bu araçlar basitçe LLM’nin kendi başına iyi performans sergileyemediği işlevleri kapsar: örneğin <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a> gibi metin üreten bir LLM için görüntü oluşturma aracı, web arama aracı veya hesap makinesi olabilir…',Rl,I,Xe='<strong>Transformers Agents</strong> nedir? Kendi ajanlarınızı oluşturmak için yapı taşları sağlayan <code>transformers</code> kütüphanemizin bir uzantısıdır! <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">Dökümantasyondan</a> daha fazla bilgi edinin.',Nl,h,$e="Nasıl kullanılacağına ve hangi kullanım senaryolarını çözebileceğine bakalım.",Vl,g,Ye="Gerekli kütüphaneleri yüklemek için aşağıdaki satırı çalıştırın:",_l,f,Ql,Z,Sl,v,xe="Bu kullanım senaryosu için, internette gezinen ve görsel oluşturabilen bir ajan göstermek istiyoruz.",Al,B,He="Bunu oluşturmak için basitçe iki aracın hazır olması gerekiyor: görüntü oluşturma ve internet üzerinden arama.",El,G,Fe="<li>Görsel oluşturmak için, Stable Diffusion kullanarak görseller oluşturmak üzere Hub’dan HF Inference API’yi (Serverless) kullanan bir araç yüklüyoruz.</li> <li>İnternette arama yapmak için yerleşik bir araç kullanıyoruz.</li>",Xl,W,$l,z,qe='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',Yl,R,xl,N,Le="Kısa tanım: Retrieval-Augmented-Generation (RAG), <strong><em>“bir kullanıcı sorgusunu yanıtlamak için bir büyük dil modeli (LLM) kullanır, ancak yanıtı veri setinden elde edilen verilere dayandırır”</em></strong>.",Hl,V,Pe="Bu yöntemin yalın ya da fine-tuned bir LLM kullanımına göre birçok avantajı vardır: bunlardan birkaçını saymak gerekirse, cevabı doğru gerçeklere dayandırmaya ve karışıklıkları azaltmaya izin verir, LLM’e özgü bilgileri sağlamaya ve bilgi tabanından veriye erişimin ince taneli kontrolüne izin verir.",Fl,_,Ke="<li><p>Şöyle bir senaryo düşünelim. RAG yöntemini uygulamak istiyoruz, ancak bazı parametrelerin dinamik olarak belirlenmesi gereken ek bir koşulumuz var. Örneğin, kullanıcı sorgusuna bağlı olarak aramayı bilgi tabanının belirli alt kümeleriyle sınırlamak isteyebiliriz veya alınan belge sayısını ayarlamak isteyebiliriz. Peki, <strong>bu parametreleri kullanıcı sorgusuna göre nasıl dinamik olarak ayarlayabiliriz?</strong></p></li> <li><p>RAG’de sık karşılaşılan bir sorun, kullanıcı sorgusuna verilen cevabın hangi belgeden geldiğinin bulunmamasıdır. <strong>Eğer önceki sonuçlar alakalı değilse, retriever’ı değiştirilmiş bir sorgu ile tekrar çalıştırarak sonuç alma şansımız var mı?</strong></p></li>",ql,Q,De="🔧 Yukarıdaki noktaları basit bir şekilde çözebiliriz: <strong>ajanımıza retriever’ın parametrelerinin kontrolünü vereceğiz!</strong>",Ll,S,Oe="➡️ Hadi bunu nasıl yapacağımızı gösterelim. İlk olarak üzerinde RAG uygulamak istediğimiz bir bilgi tabanını yüklüyoruz: bu veri seti, markdown olarak depolanan birçok Hugging Face kütüphanesinin dokümantasyon sayfalarının bir derlemesidir.",Pl,A,Kl,E,lt="Şimdi veri setini işleyerek ve retriever tarafından kullanılacak bir vektör veritabanına depolayarak bilgi tabanını hazırlıyoruz. Vektör veritabanları için mükemmel yardımcı programlara sahip olduğu için LangChain’i kullanacağız:",Dl,X,Ol,$,et="Artık veritabanımız hazır olduğuna göre, kullanıcı sorgularını buna göre yanıtlayan bir RAG sistemi oluşturalım!",le,Y,tt="Sistemimizin sorguya bağlı olarak yalnızca en alakalı bilgi kaynaklarından seçim yapmasını istiyoruz.",ee,x,at="Dökümantasyon sayfalarımız aşağıdaki kaynaklardan gelecek:",te,H,ae,F,st=`['datasets-server', 'datasets', 'optimum', 'gradio', 'blog', 'course', 'hub-docs', 'pytorch-image-models', 'peft', 'evaluate', 'diffusers', 'hf-endpoints-documentation', 'deep-rl-class', 'transformers']
`,se,q,nt="👉 Şimdi ajanlarımızın bilgi tabanından bilgi almak için kullanabileceği bir <code>RetrieverTool</code> oluşturalım.",ne,L,it='Vectordb’yi aracın bir özelliği olarak eklememiz gerektiği için, <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">basit araç oluşturusunu</a> ve <code>@tool</code> dekoratörünü kullanmak yeterli olmayacak. Bu nedenle, <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">gelişmiş ajanlar dökümantasyonunda</a>  belirtilen gelişmiş yapılandırmayı takip edeceğiz',ie,P,re,K,Me,D,rt="Aracınızı Hub’da paylaşmak için, önce RetrieverTool tanım hücresindeki kodu kopyalayıp, örneğin <code>retriever.py</code> gibi bir adla yeni bir dosyaya yapıştırın.",ye,O,Mt="Araç ayrı bir dosyadan yüklendiğinde, aşağıdaki kodu kullanarak Hub’a gönderebilirsiniz (<code>yazma</code> yetkisine sahip bir token ile giriş yaptığınızdan emin olun).",oe,ll,pe,el,ue,tl,me,al,yt="Peki burada ne oldu? İlk olarak, ajan belirli kaynaklarla (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>) birlikte retriever’ı başlattı.",Ue,sl,ot="Ancak bu arama yeterli sonucu vermedi. Sorun değil! Ajan, önceki sonuçlar üzerinde tekrar çalışabildiği için, daha az kısıtlayıcı arama parametreleriyle yeniden sorgulama yaptı ve sonuç olarak araştırma başarılı oldu!",Je,nl,pt="Bir LLM ajanının bir retriever aracını kullanarak dinamik olarak sorguyu ve retrieval parametrelerini değiştirebilmesi, RAG’in daha genel bir formülasyonunu oluşturur ve aynı zamanda yinelemeli sorgu iyileştirme gibi birçok RAG geliştirme tekniğini de kapsar.",ce,il,ut="<strong>Bir retriever’ı araç olarak kullanıp, sorguyu ve diğer</strong> veri çekme parametrelerini dinamik olarak değiştirebilen <strong>bir LLM ajanı kullanmak</strong>, yinelemeli sorgu iyileştirmesi gibi birçok RAG geliştirme tekniğini de kapsayan <strong>RAG’in daha genel bir formülasyonudur</strong>.",de,rl,Te,Ml,mt="ReactCodeAgent’in yerleşik bir Python kod yorumlayıcısı olduğundan, hatalı Python scriptimizi debug etmek için kullanabiliriz!",be,yl,je,ol,Ut="Gördüğünüz gibi, ajan verilen kodu deniyor, bir hata alıyor, hatayı analiz ediyor, kodu düzeltiyor ve çalıştığını gördükten sonra geri veriyor!",we,pl,Jt="Sonuç olarak düzeltilen kodun son hali:",Ce,ul,ke,ml,ct=`my_list = [0, 1, 2]

for i in range(4):
    if i < len(my_list):
        print(my_list[i])
    else:
        print("Index out of range")
`,Ie,Ul,he,Jl,dt=`Kendi LLM motorunuzu oluşturmak gerçekten çok kolay:
sadece bu kriterlere sahip bir <code>__call__</code> yöntemine ihtiyaç duyar:`,ge,cl,Tt='<li>Girdi olarak <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML formatında</a> bir mesaj listesi alır ve cevabı çıktı olarak verir.</li> <li><code>stop_sequences</code> argümanını destekleyerek metin üretmeyi durduracak dizileri tanımlar.</li> <li>LLM’inizin desteklediği mesaj rolü (asistan, kullanıcı vb.) türlerine göre bazı mesaj rollerini dönüştürmeniz gerekebilir.</li>',fe,dl,Ze,Tl,ve,bl,bt=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,Be,jl,Ge,wl,jt="Yukarıdaki kullanım örnekleri, Agents’ın sunduğu olanaklar hakkında size bir fikir verecektir.",We,Cl,wt='Daha gelişmiş kullanım için <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">dökümantasyonu</a> ve Llama-3-70B’yi temel alan ve son derece zorlayıcı GAIA Liderlik Tablosunda birçok GPT-4 ajanlarını geride bırakan kendi ajanımızı oluşturmamızı sağlayan <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">bu deneyi</a> okuyun!',ze,kl,Ct="Tüm geri bildirimleri bekliyoruz, Agents’ı geliştirmemize yardımcı olacak!",Re,Il,Ne,gl,Ve;return T=new Wt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/tr/agents.ipynb"}]}}),b=new d({props:{title:"Transformers Agents kullanarak, tool-calling süper güçleriyle donatılmış bir ajan oluşturun 🦸",local:"transformers-agents-kullanarak-tool-calling-süper-güçleriyle-donatılmış-bir-ajan-oluşturun-",headingTag:"h1"}}),f=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjIlMjBkYXRhc2V0cyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwb3BlbmFpJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMC0tdXBncmFkZSUyMC1x",highlighted:'!pip install <span class="hljs-string">&quot;transformers[agents]&quot;</span> datasets langchain sentence-transformers faiss-cpu duckduckgo-search openai langchain-community --upgrade -q',wrap:!1}}),Z=new d({props:{title:"1. 🏞️ Çok Modlu + 🌐 Web tarayıcı asistanı",local:"1--çok-modlu---web-tarayıcı-asistanı",headingTag:"h2"}}),W=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMFJlYWN0Q29kZUFnZW50JTJDJTIwSGZBcGlFbmdpbmUlMEElMEElMjMlMjBBcmFjJUM0JUIxJTIwSHViJ2RhbiUyMGklQzMlQTdlJTIwYWt0YXIlQzQlQjFuJTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGdGV4dC10by1pbWFnZSUyMiUyQyUyMGNhY2hlJTNERmFsc2UpJTBBJTBBJTIzJTIwTGFuZ0NoYWluJ2RlbiUyMGFyYWMlQzQlQjElMjBpJUMzJUE3ZSUyMGFrdGFyJUM0JUIxbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzLnNlYXJjaCUyMGltcG9ydCUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMjMlMjBBamFubGFyJUM0JUIxJTIwaGVyJTIwaWtpJTIwYXJhJUMzJUE3bGElMjBiYSVDNSU5RmxhdCVDNCVCMW4uJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBJTIzJTIwJUMzJTg3YWwlQzQlQjElQzUlOUZ0JUM0JUIxciElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyR2VuZXJhdGUlMjBtZSUyMGElMjBwaG90byUyMG9mJTIwdGhlJTIwY2FyJTIwdGhhdCUyMEphbWVzJTIwYm9uZCUyMGRyb3ZlJTIwaW4lMjB0aGUlMjBsYXRlc3QlMjBtb3ZpZS4lMjIlMkMlMEEpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, ReactCodeAgent, HfApiEngine

<span class="hljs-comment"># Aracı Hub&#x27;dan içe aktarın</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, cache=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># LangChain&#x27;den aracı içe aktarın</span>
<span class="hljs-keyword">from</span> transformers.agents.search <span class="hljs-keyword">import</span> DuckDuckGoSearchTool

search_tool = DuckDuckGoSearchTool()

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)
<span class="hljs-comment"># Ajanları her iki araçla başlatın.</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Çalıştır!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),R=new d({props:{title:"2. 📚💬 RAG ile yinelemeli sorgu iyileştirme ve kaynak seçimi",local:"2--rag-ile-yinelemeli-sorgu-iyileştirme-ve-kaynak-seçimi",headingTag:"h2"}}),A=new J({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),X=new J({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),H=new J({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),P=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][<span class="hljs-string">&quot;description&quot;</span>] = (
            <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>.replace(
                <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;\`&quot;</span>
            )
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># eğer kaynak bir listeyi temsil etmiyorsa</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),K=new d({props:{title:"Opsiyonel: Retriever aracınızı Hub’da paylaşın",local:"opsiyonel-retriever-aracınızı-hubda-paylaşın",headingTag:"h3"}}),ll=new J({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwVHJ1ZSUwQSUwQWlmJTIwc2hhcmVfdG9faHViJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHJldHJpZXZlciUyMGltcG9ydCUyMFJldHJpZXZlclRvb2wlMEElMEElMjAlMjAlMjAlMjBsb2dpbiglMjJ5b3VyX3Rva2VuJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTBBJTBBJTIwJTIwJTIwJTIwdG9vbC5wdXNoX3RvX2h1YihyZXBvX2lkJTNEJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBBcmFjJUM0JUIxbiUyMFklQzMlQkNrbGVubWVzaSUwQSUyMCUyMCUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzJTIwaW1wb3J0JTIwbG9hZF90b29sJTBBJTBBJTIwJTIwJTIwJTIwcmV0cmlldmVyX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiUyQyUyMHZlY3RvcmRiJTNEdmVjdG9yZGIlMkMlMjBhbGxfc291cmNlcyUzRGFsbF9zb3VyY2VzKQ==",highlighted:`share_to_hub = <span class="hljs-literal">True</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)

    <span class="hljs-comment"># Aracın Yüklenmesi</span>
    <span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> load_tool

    retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)`,wrap:!1}}),el=new d({props:{title:"Ajanı çalıştırın!",local:"ajanı-çalıştırın",headingTag:"h3"}}),tl=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkFwaUVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIlM0R2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzJTNEYWxsX3NvdXJjZXMpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdEpzb25BZ2VudCh0b29scyUzRCU1QnJldHJpZXZlcl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjB2ZXJib3NlJTNEMCklMEElMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwc2hvdyUyMG1lJTIwYSUyMExPUkElMjBmaW5ldHVuaW5nJTIwc2NyaXB0JTIyKSUwQSUwQXByaW50KCUyMkZpbmFsJTIwb3V0cHV0JTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfApiEngine, ReactJsonAgent

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb=vectordb, all_sources=all_sources)
agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),rl=new d({props:{title:"3. 💻 Python Kodunda Hata Ayıklama",local:"3--python-kodunda-hata-ayıklama",headingTag:"h2"}}),yl=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RIZkFwaUVuZ2luZSglMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpKSUwQSUwQWNvZGUlMjAlM0QlMjAlMjIlMjIlMjIlMEFsaXN0JTNEJTVCMCUyQyUyMDElMkMlMjAyJTVEJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklM0ElMEElMjAlMjAlMjAlMjBwcmludChsaXN0KGkpKSUwQSUyMiUyMiUyMiUwQSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJJTIwaGF2ZSUyMHNvbWUlMjBjb2RlJTIwdGhhdCUyMGNyZWF0ZXMlMjBhJTIwYnVnJTNBJTIwcGxlYXNlJTIwZGVidWclMjBpdCUyQyUyMHRoZW4lMjBydW4lMjBpdCUyMHRvJTIwbWFrZSUyMHN1cmUlMjBpdCUyMHdvcmtzJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwZmluYWwlMjBjb2RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29kZSUzRGNvZGUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[], llm_engine=HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>))

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it, then run it to make sure it works and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),ul=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),Ul=new d({props:{title:"4. Kendi LLM motorunuzu oluşturun (OpenAI)",local:"4-kendi-llm-motorunuzu-oluşturun-openai",headingTag:"h2"}}),dl=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Güvenli mesaj listesini edinin</span>
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        <span class="hljs-comment"># LLM çıktısını alın</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Tl=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),jl=new d({props:{title:"➡️ Son olarak",local:"-son-olarak",headingTag:"h2"}}),Il=new zt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/tr/agents.md"}}),{c(){c=i("meta"),fl=s(),hl=i("p"),Zl=s(),y(T.$$.fragment),vl=s(),y(b.$$.fragment),Bl=s(),j=i("p"),j.innerHTML=Qe,Gl=s(),w=i("p"),w.innerHTML=Se,Wl=s(),C=i("p"),C.innerHTML=Ae,zl=s(),k=i("p"),k.innerHTML=Ee,Rl=s(),I=i("p"),I.innerHTML=Xe,Nl=s(),h=i("p"),h.textContent=$e,Vl=s(),g=i("p"),g.textContent=Ye,_l=s(),y(f.$$.fragment),Ql=s(),y(Z.$$.fragment),Sl=s(),v=i("p"),v.textContent=xe,Al=s(),B=i("p"),B.textContent=He,El=s(),G=i("ul"),G.innerHTML=Fe,Xl=s(),y(W.$$.fragment),$l=s(),z=i("p"),z.innerHTML=qe,Yl=s(),y(R.$$.fragment),xl=s(),N=i("p"),N.innerHTML=Le,Hl=s(),V=i("p"),V.textContent=Pe,Fl=s(),_=i("ul"),_.innerHTML=Ke,ql=s(),Q=i("p"),Q.innerHTML=De,Ll=s(),S=i("p"),S.textContent=Oe,Pl=s(),y(A.$$.fragment),Kl=s(),E=i("p"),E.textContent=lt,Dl=s(),y(X.$$.fragment),Ol=s(),$=i("p"),$.textContent=et,le=s(),Y=i("p"),Y.textContent=tt,ee=s(),x=i("p"),x.textContent=at,te=s(),y(H.$$.fragment),ae=s(),F=i("pre"),F.textContent=st,se=s(),q=i("p"),q.innerHTML=nt,ne=s(),L=i("p"),L.innerHTML=it,ie=s(),y(P.$$.fragment),re=s(),y(K.$$.fragment),Me=s(),D=i("p"),D.innerHTML=rt,ye=s(),O=i("p"),O.innerHTML=Mt,oe=s(),y(ll.$$.fragment),pe=s(),y(el.$$.fragment),ue=s(),y(tl.$$.fragment),me=s(),al=i("p"),al.innerHTML=yt,Ue=s(),sl=i("p"),sl.textContent=ot,Je=s(),nl=i("p"),nl.textContent=pt,ce=s(),il=i("p"),il.innerHTML=ut,de=s(),y(rl.$$.fragment),Te=s(),Ml=i("p"),Ml.textContent=mt,be=s(),y(yl.$$.fragment),je=s(),ol=i("p"),ol.textContent=Ut,we=s(),pl=i("p"),pl.textContent=Jt,Ce=s(),y(ul.$$.fragment),ke=s(),ml=i("pre"),ml.textContent=ct,Ie=s(),y(Ul.$$.fragment),he=s(),Jl=i("p"),Jl.innerHTML=dt,ge=s(),cl=i("ol"),cl.innerHTML=Tt,fe=s(),y(dl.$$.fragment),Ze=s(),y(Tl.$$.fragment),ve=s(),bl=i("pre"),bl.textContent=bt,Be=s(),y(jl.$$.fragment),Ge=s(),wl=i("p"),wl.textContent=jt,We=s(),Cl=i("p"),Cl.innerHTML=wt,ze=s(),kl=i("p"),kl.textContent=Ct,Re=s(),y(Il.$$.fragment),Ne=s(),gl=i("p"),this.h()},l(l){const e=Bt("svelte-u9bgzb",document.head);c=r(e,"META",{name:!0,content:!0}),e.forEach(t),fl=n(l),hl=r(l,"P",{}),kt(hl).forEach(t),Zl=n(l),o(T.$$.fragment,l),vl=n(l),o(b.$$.fragment,l),Bl=n(l),j=r(l,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1itztgb"&&(j.innerHTML=Qe),Gl=n(l),w=r(l,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1okp29d"&&(w.innerHTML=Se),Wl=n(l),C=r(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1tjoz4w"&&(C.innerHTML=Ae),zl=n(l),k=r(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-7pnahf"&&(k.innerHTML=Ee),Rl=n(l),I=r(l,"P",{"data-svelte-h":!0}),M(I)!=="svelte-rgwo7j"&&(I.innerHTML=Xe),Nl=n(l),h=r(l,"P",{"data-svelte-h":!0}),M(h)!=="svelte-rzyg7y"&&(h.textContent=$e),Vl=n(l),g=r(l,"P",{"data-svelte-h":!0}),M(g)!=="svelte-fxmfh3"&&(g.textContent=Ye),_l=n(l),o(f.$$.fragment,l),Ql=n(l),o(Z.$$.fragment,l),Sl=n(l),v=r(l,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1bseyqm"&&(v.textContent=xe),Al=n(l),B=r(l,"P",{"data-svelte-h":!0}),M(B)!=="svelte-qc6yv8"&&(B.textContent=He),El=n(l),G=r(l,"UL",{"data-svelte-h":!0}),M(G)!=="svelte-1c5qckf"&&(G.innerHTML=Fe),Xl=n(l),o(W.$$.fragment,l),$l=n(l),z=r(l,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1hg95q8"&&(z.innerHTML=qe),Yl=n(l),o(R.$$.fragment,l),xl=n(l),N=r(l,"P",{"data-svelte-h":!0}),M(N)!=="svelte-tp8r29"&&(N.innerHTML=Le),Hl=n(l),V=r(l,"P",{"data-svelte-h":!0}),M(V)!=="svelte-yh4nih"&&(V.textContent=Pe),Fl=n(l),_=r(l,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-cr6vrq"&&(_.innerHTML=Ke),ql=n(l),Q=r(l,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-kaaeqm"&&(Q.innerHTML=De),Ll=n(l),S=r(l,"P",{"data-svelte-h":!0}),M(S)!=="svelte-15opnia"&&(S.textContent=Oe),Pl=n(l),o(A.$$.fragment,l),Kl=n(l),E=r(l,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1gbw2ro"&&(E.textContent=lt),Dl=n(l),o(X.$$.fragment,l),Ol=n(l),$=r(l,"P",{"data-svelte-h":!0}),M($)!=="svelte-1rfrrmh"&&($.textContent=et),le=n(l),Y=r(l,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-jx6hhy"&&(Y.textContent=tt),ee=n(l),x=r(l,"P",{"data-svelte-h":!0}),M(x)!=="svelte-19521um"&&(x.textContent=at),te=n(l),o(H.$$.fragment,l),ae=n(l),F=r(l,"PRE",{"data-svelte-h":!0}),M(F)!=="svelte-crsp42"&&(F.textContent=st),se=n(l),q=r(l,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1jufpu2"&&(q.innerHTML=nt),ne=n(l),L=r(l,"P",{"data-svelte-h":!0}),M(L)!=="svelte-ua5lte"&&(L.innerHTML=it),ie=n(l),o(P.$$.fragment,l),re=n(l),o(K.$$.fragment,l),Me=n(l),D=r(l,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1tz4mys"&&(D.innerHTML=rt),ye=n(l),O=r(l,"P",{"data-svelte-h":!0}),M(O)!=="svelte-7ac8y3"&&(O.innerHTML=Mt),oe=n(l),o(ll.$$.fragment,l),pe=n(l),o(el.$$.fragment,l),ue=n(l),o(tl.$$.fragment,l),me=n(l),al=r(l,"P",{"data-svelte-h":!0}),M(al)!=="svelte-14k588x"&&(al.innerHTML=yt),Ue=n(l),sl=r(l,"P",{"data-svelte-h":!0}),M(sl)!=="svelte-180ga06"&&(sl.textContent=ot),Je=n(l),nl=r(l,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-1mpg88y"&&(nl.textContent=pt),ce=n(l),il=r(l,"P",{"data-svelte-h":!0}),M(il)!=="svelte-nw2aw8"&&(il.innerHTML=ut),de=n(l),o(rl.$$.fragment,l),Te=n(l),Ml=r(l,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-1hcmmvc"&&(Ml.textContent=mt),be=n(l),o(yl.$$.fragment,l),je=n(l),ol=r(l,"P",{"data-svelte-h":!0}),M(ol)!=="svelte-1v9l2i5"&&(ol.textContent=Ut),we=n(l),pl=r(l,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-1bcqr6k"&&(pl.textContent=Jt),Ce=n(l),o(ul.$$.fragment,l),ke=n(l),ml=r(l,"PRE",{"data-svelte-h":!0}),M(ml)!=="svelte-eeovy7"&&(ml.textContent=ct),Ie=n(l),o(Ul.$$.fragment,l),he=n(l),Jl=r(l,"P",{"data-svelte-h":!0}),M(Jl)!=="svelte-upvu3f"&&(Jl.innerHTML=dt),ge=n(l),cl=r(l,"OL",{"data-svelte-h":!0}),M(cl)!=="svelte-10i2jt5"&&(cl.innerHTML=Tt),fe=n(l),o(dl.$$.fragment,l),Ze=n(l),o(Tl.$$.fragment,l),ve=n(l),bl=r(l,"PRE",{"data-svelte-h":!0}),M(bl)!=="svelte-tgqz6q"&&(bl.textContent=bt),Be=n(l),o(jl.$$.fragment,l),Ge=n(l),wl=r(l,"P",{"data-svelte-h":!0}),M(wl)!=="svelte-1kdjqlp"&&(wl.textContent=jt),We=n(l),Cl=r(l,"P",{"data-svelte-h":!0}),M(Cl)!=="svelte-1bmzsyo"&&(Cl.innerHTML=wt),ze=n(l),kl=r(l,"P",{"data-svelte-h":!0}),M(kl)!=="svelte-10njswm"&&(kl.textContent=Ct),Re=n(l),o(Il.$$.fragment,l),Ne=n(l),gl=r(l,"P",{}),kt(gl).forEach(t),this.h()},h(){It(c,"name","hf:doc:metadata"),It(c,"content",Nt)},m(l,e){Gt(document.head,c),a(l,fl,e),a(l,hl,e),a(l,Zl,e),p(T,l,e),a(l,vl,e),p(b,l,e),a(l,Bl,e),a(l,j,e),a(l,Gl,e),a(l,w,e),a(l,Wl,e),a(l,C,e),a(l,zl,e),a(l,k,e),a(l,Rl,e),a(l,I,e),a(l,Nl,e),a(l,h,e),a(l,Vl,e),a(l,g,e),a(l,_l,e),p(f,l,e),a(l,Ql,e),p(Z,l,e),a(l,Sl,e),a(l,v,e),a(l,Al,e),a(l,B,e),a(l,El,e),a(l,G,e),a(l,Xl,e),p(W,l,e),a(l,$l,e),a(l,z,e),a(l,Yl,e),p(R,l,e),a(l,xl,e),a(l,N,e),a(l,Hl,e),a(l,V,e),a(l,Fl,e),a(l,_,e),a(l,ql,e),a(l,Q,e),a(l,Ll,e),a(l,S,e),a(l,Pl,e),p(A,l,e),a(l,Kl,e),a(l,E,e),a(l,Dl,e),p(X,l,e),a(l,Ol,e),a(l,$,e),a(l,le,e),a(l,Y,e),a(l,ee,e),a(l,x,e),a(l,te,e),p(H,l,e),a(l,ae,e),a(l,F,e),a(l,se,e),a(l,q,e),a(l,ne,e),a(l,L,e),a(l,ie,e),p(P,l,e),a(l,re,e),p(K,l,e),a(l,Me,e),a(l,D,e),a(l,ye,e),a(l,O,e),a(l,oe,e),p(ll,l,e),a(l,pe,e),p(el,l,e),a(l,ue,e),p(tl,l,e),a(l,me,e),a(l,al,e),a(l,Ue,e),a(l,sl,e),a(l,Je,e),a(l,nl,e),a(l,ce,e),a(l,il,e),a(l,de,e),p(rl,l,e),a(l,Te,e),a(l,Ml,e),a(l,be,e),p(yl,l,e),a(l,je,e),a(l,ol,e),a(l,we,e),a(l,pl,e),a(l,Ce,e),p(ul,l,e),a(l,ke,e),a(l,ml,e),a(l,Ie,e),p(Ul,l,e),a(l,he,e),a(l,Jl,e),a(l,ge,e),a(l,cl,e),a(l,fe,e),p(dl,l,e),a(l,Ze,e),p(Tl,l,e),a(l,ve,e),a(l,bl,e),a(l,Be,e),p(jl,l,e),a(l,Ge,e),a(l,wl,e),a(l,We,e),a(l,Cl,e),a(l,ze,e),a(l,kl,e),a(l,Re,e),p(Il,l,e),a(l,Ne,e),a(l,gl,e),Ve=!0},p:gt,i(l){Ve||(u(T.$$.fragment,l),u(b.$$.fragment,l),u(f.$$.fragment,l),u(Z.$$.fragment,l),u(W.$$.fragment,l),u(R.$$.fragment,l),u(A.$$.fragment,l),u(X.$$.fragment,l),u(H.$$.fragment,l),u(P.$$.fragment,l),u(K.$$.fragment,l),u(ll.$$.fragment,l),u(el.$$.fragment,l),u(tl.$$.fragment,l),u(rl.$$.fragment,l),u(yl.$$.fragment,l),u(ul.$$.fragment,l),u(Ul.$$.fragment,l),u(dl.$$.fragment,l),u(Tl.$$.fragment,l),u(jl.$$.fragment,l),u(Il.$$.fragment,l),Ve=!0)},o(l){m(T.$$.fragment,l),m(b.$$.fragment,l),m(f.$$.fragment,l),m(Z.$$.fragment,l),m(W.$$.fragment,l),m(R.$$.fragment,l),m(A.$$.fragment,l),m(X.$$.fragment,l),m(H.$$.fragment,l),m(P.$$.fragment,l),m(K.$$.fragment,l),m(ll.$$.fragment,l),m(el.$$.fragment,l),m(tl.$$.fragment,l),m(rl.$$.fragment,l),m(yl.$$.fragment,l),m(ul.$$.fragment,l),m(Ul.$$.fragment,l),m(dl.$$.fragment,l),m(Tl.$$.fragment,l),m(jl.$$.fragment,l),m(Il.$$.fragment,l),Ve=!1},d(l){l&&(t(fl),t(hl),t(Zl),t(vl),t(Bl),t(j),t(Gl),t(w),t(Wl),t(C),t(zl),t(k),t(Rl),t(I),t(Nl),t(h),t(Vl),t(g),t(_l),t(Ql),t(Sl),t(v),t(Al),t(B),t(El),t(G),t(Xl),t($l),t(z),t(Yl),t(xl),t(N),t(Hl),t(V),t(Fl),t(_),t(ql),t(Q),t(Ll),t(S),t(Pl),t(Kl),t(E),t(Dl),t(Ol),t($),t(le),t(Y),t(ee),t(x),t(te),t(ae),t(F),t(se),t(q),t(ne),t(L),t(ie),t(re),t(Me),t(D),t(ye),t(O),t(oe),t(pe),t(ue),t(me),t(al),t(Ue),t(sl),t(Je),t(nl),t(ce),t(il),t(de),t(Te),t(Ml),t(be),t(je),t(ol),t(we),t(pl),t(Ce),t(ke),t(ml),t(Ie),t(he),t(Jl),t(ge),t(cl),t(fe),t(Ze),t(ve),t(bl),t(Be),t(Ge),t(wl),t(We),t(Cl),t(ze),t(kl),t(Re),t(Ne),t(gl)),t(c),U(T,l),U(b,l),U(f,l),U(Z,l),U(W,l),U(R,l),U(A,l),U(X,l),U(H,l),U(P,l),U(K,l),U(ll,l),U(el,l),U(tl,l),U(rl,l),U(yl,l),U(ul,l),U(Ul,l),U(dl,l),U(Tl,l),U(jl,l),U(Il,l)}}}const Nt='{"title":"Transformers Agents kullanarak, tool-calling süper güçleriyle donatılmış bir ajan oluşturun 🦸","local":"transformers-agents-kullanarak-tool-calling-süper-güçleriyle-donatılmış-bir-ajan-oluşturun-","sections":[{"title":"1. 🏞️ Çok Modlu + 🌐 Web tarayıcı asistanı","local":"1--çok-modlu---web-tarayıcı-asistanı","sections":[],"depth":2},{"title":"2. 📚💬 RAG ile yinelemeli sorgu iyileştirme ve kaynak seçimi","local":"2--rag-ile-yinelemeli-sorgu-iyileştirme-ve-kaynak-seçimi","sections":[{"title":"Opsiyonel: Retriever aracınızı Hub’da paylaşın","local":"opsiyonel-retriever-aracınızı-hubda-paylaşın","sections":[],"depth":3},{"title":"Ajanı çalıştırın!","local":"ajanı-çalıştırın","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Python Kodunda Hata Ayıklama","local":"3--python-kodunda-hata-ayıklama","sections":[],"depth":2},{"title":"4. Kendi LLM motorunuzu oluşturun (OpenAI)","local":"4-kendi-llm-motorunuzu-oluşturun-openai","sections":[],"depth":2},{"title":"➡️ Son olarak","local":"-son-olarak","sections":[],"depth":2}],"depth":1}';function Vt(_e){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Zt{constructor(c){super(),vt(this,c,Vt,Rt,ht,{})}}export{Et as component};
