import{s as Kt,n as ln,o as en}from"../chunks/scheduler.39a43cde.js";import{S as tn,i as nn,g as i,s,r as J,A as sn,h as a,f as t,c as U,j as Pt,u as M,x as p,k as at,y as Un,a as n,v as y,d as C,t as T,w as m}from"../chunks/index.23ec2204.js";import{D as an,C as V}from"../chunks/DocNotebookDropdown.7c3158f8.js";import{H as h,E as pn}from"../chunks/getInferenceSnippets.6ac8bef9.js";function Jn(pt){let Q,Ol,kl,_l,o,Al,u,Gl,w,Jt='<em>작성자: <a href="https://github.com/dcarpintero" rel="nofollow">Diego Carpintero</a>, 번역: <a href="https://github.com/nuatmochoi" rel="nofollow">최성우</a></em>',Dl,j,Mt="지식 그래프는 상호 연결된 정보를 사람과 기계 모두가 이해할 수 있는 형식으로 모델링하고 저장하는 방법을 제공합니다. 이러한 그래프는 엔티티와 그들의 관계를 나타내는 <em>노드</em>와 <em>엣지</em>로 구성됩니다. 전통적인 데이터베이스와 달리, 그래프의 본질적인 표현력은 더 풍부한 의미론적 이해를 가능하게 하며, 고정된 스키마에 제약받지 않고 새로운 엔티티 유형과 관계를 수용할 수 있는 유연성을 제공합니다.",xl,c,yt="지식 그래프를 임베딩(벡터 검색)과 결합함으로써, <em>다중 홉 연결성</em>과 <em>정보의 맥락적 이해</em>를 활용하여 LLM의 추론과 설명 가능성을 향상시킬 수 있습니다.",Hl,R,Ct="이 노트북은 이 접근 방식의 실제 구현을 탐구하며, 다음과 같은 방법을 보여줍니다.",Ll,I,Tt='<li>합성 데이터셋을 사용하여 <a href="https://neo4j.com/docs/" rel="nofollow">Neo4j</a>에서 연구 출판물 관련 지식 그래프 구축</li> <li><a href="https://python.langchain.com/v0.2/docs/integrations/text_embedding/" rel="nofollow">임베딩 모델</a>을 사용하여 데이터 필드의 일부를 고차원 벡터 공간으로 투영</li> <li>유사도 검색을 가능하게 하는 임베딩에 대한 벡터 인덱스 구축</li> <li><a href="https://python.langchain.com/v0.2/docs/introduction/" rel="nofollow">LangChain</a>을 사용하여 사용자 쿼리를 <a href="https://neo4j.com/docs/cypher-manual/current/introduction/" rel="nofollow">cypher</a> 문으로 쉽게 변환하여 자연어로 그래프에서 인사이트 추출</li>',Wl,r,mt='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/knowledge-graphs.png"/>',Zl,f,ql,g,Xl,E,Yl,$,Vt='그래프 데이터베이스 기술을 전문으로 하는 오픈 소스 데이터베이스 관리 시스템인 <a href="https://neo4j.com/docs/" rel="nofollow">Neo4j</a>를 사용하여 지식 그래프를 생성할 것입니다.',zl,F,ht='빠르고 쉬운 설정을 위해 <a href="https://neo4j.com/product/auradb/" rel="nofollow">Neo4j Aura</a>에서 무료 인스턴스를 시작할 수 있습니다.',Pl,b,Qt="그런 다음 <code>.env</code> 파일을 사용하여 <code>NEO4J_URI</code>, <code>NEO4J_USERNAME</code>, 및 <code>NEO4J_PASSWORD</code>를 환경 변수로 설정할 수 있습니다.",Kl,N,le,d,rt="Langchain은 Neo4j와 상호 작용하기 위한 <code>Neo4jGraph</code> 클래스를 제공합니다.",ee,S,te,B,ne,k,ot='아래 예제는 <code>Neo4j</code> 데이터베이스와 연결을 생성하고 연구 논문과 저자로 구성된 <a href="https://github.com/dcarpintero/generative-ai-101/blob/main/dataset/synthetic_articles.csv" rel="nofollow">합성 데이터</a>로 채웁니다.',se,v,ut="엔티티는 다음과 같습니다.",Ue,O,wt="<li><em>연구원</em></li> <li><em>논문</em></li> <li><em>주제</em></li>",ie,_,jt="관계는 다음과 같습니다.",ae,A,ct="<li><em>연구원</em> —[출판하다]—&gt; <em>논문</em></li> <li><em>논문</em> —[주제이다]—&gt; <em>주제</em></li>",pe,G,Je,D,Rt="노드와 관계가 올바르게 초기화되었는지 확인해 봅시다.",Me,x,ye,H,It=`Node properties:
논문 &#123;제목: STRING, 초록: STRING, 출판일: DATE, embedding: LIST}
연구원 &#123;이름: STRING}
주제 &#123;이름: STRING}
Relationship properties:

The relationships:
(:논문)-[:주제이다]->(:주제)
(:연구원)-[:출판하다]->(:논문)
`,Ce,L,ft="지식 그래프는 Neo4j 작업 공간에서 검사할 수 있습니다.",Te,W,gt='<img src="attachment:image.png" alt="image.png"/>',me,Z,Ve,q,Et="이제 <em>주제, 제목, 초록</em>을 기반으로 관련 <em>논문</em>을 효율적으로 검색하기 위한 벡터 인덱스를 구축합니다. 이 과정에는 이러한 필드를 사용하여 각 논문의 임베딩을 계산하는 것이 포함됩니다. 쿼리 시, 시스템은 코사인 거리와 같은 유사도 메트릭을 사용하여 사용자 입력과 가장 유사한 논문을 찾습니다.",he,X,Qe,Y,$t='<strong>참고</strong>: OpenAI 임베딩 모델에 접근하려면 OpenAI 계정을 만들고 API 키를 받아 <code>OPENAI_API_KEY</code>를 환경 변수로 설정해야 합니다. 다른 <a href="https://python.langchain.com/v0.2/docs/integrations/text_embedding/" rel="nofollow">임베딩 모델</a> 통합을 실험해 보는 것도 유용할 수 있습니다.',re,z,oe,P,Ft="<code>Langchain RetrievalQA</code>는 위의 벡터 인덱스를 검색기로 사용하는 질문-답변(QA) 체인을 생성합니다.",ue,K,we,ll,bt="’<em>AI가 우리의 일상 생활에 어떤 영향을 미칠 수 있는지 논의하는 논문은 어떤 것들이 있나요?</em>‘라고 물어봅시다.",je,el,ce,tl,Nt=`주제: AI의 영향

1. 제목: The Impact of AI on Employment: A Comprehensive Study
   - 초록: 이 연구는 AI가 다양한 직업 부문에 미칠 수 있는 잠재적 영향을 분석하고 부정적 영향을 완화하기 위한 정책 권고를 제안합니다.

2. 제목: The Societal Implications of Advanced AI: A Multidisciplinary Analysis
   - 초록: 우리의 연구는 다양한 분야의 전문가들을 모아 고급 AI가 사회, 경제, 문화에 미칠 잠재적인 장기적 영향을 분석합니다.

3. 제목: The Role of AI in Combating Climate Change: Opportunities and Challenges
   - 초록: 우리의 연구는 AI가 기후 변화 대처에 어떻게 활용될 수 있는지 탐구하며 잠재적 이점과 관련된 윤리적 고려사항을 논의합니다.

4. 제목: Ethical Considerations in AI Development
   - 초록: 우리는 고속으로 진행되고 있는 AI 발전의 윤리적 함의를 탐구하고 책임있는 개발을 위한 지침을 제안합니다.
`,Re,nl,Ie,sl,dt="지식 그래프는 엔티티 간의 연결을 만드는 데 탁월하여 패턴을 추출하고 새로운 인사이트를 발견할 수 있게 합니다.",fe,Ul,St="이 섹션에서는 이 프로세스를 구현하고 자연어 쿼리를 사용하여 LLM 파이프라인에 결과를 통합하는 방법을 보여줍니다.",ge,il,Ee,al,Bt="표현력 있고 효율적인 쿼리를 구성하기 위해 <code>Neo4j</code>는 SQL에서 영감을 받은 선언적 쿼리 언어인 <code>Cypher</code>를 사용합니다. <code>LangChain</code>은 <code>GraphCypherQAChain</code> 래퍼를 제공하여 자연어를 사용해 그래프 데이터베이스를 쿼리할 수 있게 하는 추상화 계층을 제공하여 LLM 파이프라인에 그래프 기반 데이터 검색을 더 쉽게 통합할 수 있게 합니다.",$e,pl,kt="실제로 <code>GraphCypherQAChain</code>은:",Fe,Jl,vt="<li>맥락 내 학습(프롬프트 엔지니어링)을 적용하여 사용자 입력(자연어)에서 Cypher 문(Neo4j와 같은 그래프 데이터베이스용 쿼리)을 생성하고,</li> <li>해당 문을 그래프 데이터베이스에 대해 실행하며,</li> <li>LLM 응답을 정확하고 최신 정보로 뒷받침하기 위해 결과를 컨텍스트로 제공합니다.</li>",be,Ml,Ot="<strong>참고</strong>: 이 구현에는 모델이 생성한 그래프 쿼리를 실행하는 것이 포함되어 있어, 데이터베이스의 민감한 데이터에 대한 의도하지 않은 접근이나 수정과 같은 고유한 위험이 있습니다. 이러한 위험을 완화하기 위해 데이터베이스 연결 권한을 체인/에이전트의 특정 요구 사항을 충족하는 데 필요한 최소한으로 제한해야 합니다. 이 접근 방식은 위험을 줄이지만 완전히 제거하지는 않습니다.",Ne,yl,de,Cl,Se,Tl,_t="다음 예제에서 cypher 쿼리 실행 결과가 LLM에 컨텍스트로 제공되는 방식에 주목하세요.",Be,ml,ke,Vl,At="이 예제에서 우리의 질문 ’<em>Emily Chen이 발표한 논문은 몇 편인가요?</em>‘는 다음과 같은 Cypher 쿼리로 변환됩니다.",ve,hl,Oe,Ql,Gt="이 쿼리는 이름이 ‘Emily Chen’인 <code>연구원</code> 레이블이 있는 노드를 매칭하고 <code>출판하다</code> 관계를 통해 <code>논문</code> 노드로 이동합니다. 그런 다음 ‘Emily Chen’과 연결된 <code>논문</code> 노드의 수를 계산합니다.",_e,rl,Dt='<img src="attachment:image.png" alt="image.png"/>',Ae,ol,Ge,ul,xt=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (:연구원 &#123;이름: "Emily Chen"})-[:출판하다]->(n:논문)
RETURN COUNT(n) AS 논문_수
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'논문_수': 7}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,De,wl,xe,jl,Ht="이 예제에서 ’<em>3편보다 많은 논문을 함께 발표한 연구원 쌍을 알려주세요.</em>‘라는 쿼리는 다음과 같은 Cypher 쿼리로 변환됩니다.",He,cl,Le,Rl,Lt="이 쿼리는 <code>연구원</code> 노드에서 <code>출판하다</code> 관계를 통해 연결된 <code>논문</code> 노드를 찾고, 다시 <code>연구원</code> 쌍을 찾기 위해 역으로 이동합니다.",We,Il,Wt='<img src="attachment:image.png" alt="image.png"/>',Ze,fl,qe,gl,Zt=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r1:연구원)-[:출판하다]->(p:논문)<-[:출판하다]-(r2:연구원)
WHERE r1 <> r2
WITH r1, r2, COUNT(p) AS 논문수
WHERE 논문수 > 3
RETURN r1.이름 AS 연구원1, r2.이름 AS 연구원2, 논문수
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'연구원1': 'David Johnson', '연구원2': 'Emily Chen', '논문수': 4}, &#123;'연구원1': 'Robert Taylor', '연구원2': 'Emily Chen', '논문수': 4}, &#123;'연구원1': 'Emily Chen', '연구원2': 'David Johnson', '논문수': 4}, &#123;'연구원1': 'Emily Chen', '연구원2': 'Robert Taylor', '논문수': 4}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,Xe,El,Ye,$l,qt="가장 많은 동료와 협업한 연구자를 찾아봅시다. 우리의 쿼리 ’<em>가장 많은 동료와 협업한 연구원은 누구인가요?</em>‘는 이제 다음과 같은 Cypher 쿼리로 변환됩니다.",ze,Fl,Pe,bl,Xt="여기서는 모든 <code>연구원</code> 노드에서 시작하여 그들의 <code>출판하다</code> 관계를 통해 연결된 <code>논문</code> 노드를 찾습니다. 각 <code>논문</code> 노드에 대해 Neo4j는 다시 동일한 논문을 발표한 다른 <code>연구원</code> 노드를 찾기 위해 역으로 이동합니다.",Ke,Nl,Yt='<img src="attachment:image.png" alt="image.png"/>',lt,dl,et,Sl,zt=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r:연구원)-[:출판하다]->(:논문)<-[:출판하다]-(coauthor:연구원)
WHERE r <> coauthor
RETURN r.이름 AS 연구원, COUNT(DISTINCT coauthor) AS 동료수
ORDER BY 동료수 DESC
LIMIT 1
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'연구원': 'David Johnson', '동료수': 6}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,tt,nt,st,Bl,Ut,vl,it;return o=new an({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/ko/ko_rag_with_knowledge_graphs_neo4j.ipynb"}]}}),u=new h({props:{title:"지식 그래프를 활용한 RAG 추론 향상",local:"지식-그래프를-활용한-rag-추론-향상",headingTag:"h1"}}),f=new h({props:{title:"초기화",local:"초기화",headingTag:"h2"}}),g=new V({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG5lbzRqJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluX29wZW5haSUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjBweXRob24tZG90ZW52JTIwLS1xdWlldA==",highlighted:"%pip install neo4j langchain langchain_openai langchain-community python-dotenv --quiet",wrap:!1}}),E=new h({props:{title:"Neo4j 인스턴스 설정",local:"neo4j-인스턴스-설정",headingTag:"h3"}}),N=new V({props:{code:"aW1wb3J0JTIwZG90ZW52JTBBJTBBZG90ZW52LmxvYWRfZG90ZW52KCUyMi5lbnYlMjIlMkMlMjBvdmVycmlkZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> dotenv

dotenv.load_dotenv(<span class="hljs-string">&quot;.env&quot;</span>, override=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new V({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5ncmFwaHMlMjBpbXBvcnQlMjBOZW80akdyYXBoJTBBJTBBZ3JhcGglMjAlM0QlMjBOZW80akdyYXBoKCUwQSUyMCUyMCUyMCUyMHVybCUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VUkklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB1c2VybmFtZSUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VU0VSTkFNRSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3N3b3JkJTNEb3MuZW52aXJvbiU1QiUyMk5FTzRKX1BBU1NXT1JEJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> langchain_community.graphs <span class="hljs-keyword">import</span> Neo4jGraph

graph = Neo4jGraph(
    url=os.environ[<span class="hljs-string">&quot;NEO4J_URI&quot;</span>],
    username=os.environ[<span class="hljs-string">&quot;NEO4J_USERNAME&quot;</span>],
    password=os.environ[<span class="hljs-string">&quot;NEO4J_PASSWORD&quot;</span>],
)`,wrap:!1}}),B=new h({props:{title:"데이터셋을 그래프로 로딩",local:"데이터셋을-그래프로-로딩",headingTag:"h3"}}),G=new V({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZ3JhcGhzJTIwaW1wb3J0JTIwTmVvNGpHcmFwaCUwQSUwQWdyYXBoJTIwJTNEJTIwTmVvNGpHcmFwaCgpJTBBJTBBcV9sb2FkX2FydGljbGVzJTIwJTNEJTIwJTIyJTIyJTIyJTBBTE9BRCUyMENTViUyMFdJVEglMjBIRUFERVJTJTBBRlJPTSUyMCdodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZkY2FycGludGVybyUyRmdlbmVyYXRpdmUtYWktMTAxJTJGbWFpbiUyRmRhdGFzZXQlMkZzeW50aGV0aWNfYXJ0aWNsZXMuY3N2JyUyMCUwQUFTJTIwJUVEJTk2JTg5JTIwJTBBRklFTERURVJNSU5BVE9SJTIwJyUzQiclMEFNRVJHRSUyMChhJTNBJUVCJTg1JUJDJUVCJUFDJUI4JTIwJTdCJUVDJUEwJTlDJUVCJUFBJUE5JTNBJUVEJTk2JTg5LlRpdGxlJTdEKSUwQVNFVCUyMGEuJUVDJUI0JTg4JUVCJUExJTlEJTIwJTNEJTIwJUVEJTk2JTg5LkFic3RyYWN0JTJDJTBBJTIwJTIwJTIwJTIwYS4lRUMlQjYlOUMlRUQlOEMlOTAlRUMlOUQlQkMlMjAlM0QlMjBkYXRlKCVFRCU5NiU4OS5QdWJsaWNhdGlvbl9EYXRlKSUwQUZPUkVBQ0glMjAoJUVDJTk3JUIwJUVBJUI1JUFDJUVDJTlFJTkwJTIwaW4lMjBzcGxpdCglRUQlOTYlODkuQXV0aG9ycyUyQyUyMCclMkMnKSUyMCU3QyUyMCUwQSUyMCUyMCUyMCUyME1FUkdFJTIwKHAlM0ElRUMlOTclQjAlRUElQjUlQUMlRUMlOUIlOTAlMjAlN0IlRUMlOUQlQjQlRUIlQTYlODQlM0F0cmltKCVFQyU5NyVCMCVFQSVCNSVBQyVFQyU5RSU5MCklN0QpJTBBJTIwJTIwJTIwJTIwTUVSR0UlMjAocCktJTVCJTNBJUVDJUI2JTlDJUVEJThDJTkwJUVEJTk1JTk4JUVCJThCJUE0JTVELSUzRShhKSklMEFGT1JFQUNIJTIwKCVFQyVBMyVCQyVFQyVBMCU5QyUyMGluJTIwJTVCJUVEJTk2JTg5LlRvcGljJTVEJTIwJTdDJTIwJTBBJTIwJTIwJTIwJTIwTUVSR0UlMjAodCUzQSVFQyVBMyVCQyVFQyVBMCU5QyUyMCU3QiVFQyU5RCVCNCVFQiVBNiU4NCUzQXRyaW0oJUVDJUEzJUJDJUVDJUEwJTlDKSU3RCklMEElMjAlMjAlMjAlMjBNRVJHRSUyMChhKS0lNUIlM0ElRUMlQTMlQkMlRUMlQTAlOUMlRUMlOUQlQjQlRUIlOEIlQTQlNUQtJTNFKHQpKSUwQSUyMiUyMiUyMiUwQSUwQWdyYXBoLnF1ZXJ5KHFfbG9hZF9hcnRpY2xlcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain_community.graphs <span class="hljs-keyword">import</span> Neo4jGraph

graph = Neo4jGraph()

q_load_articles = <span class="hljs-string">&quot;&quot;&quot;
LOAD CSV WITH HEADERS
FROM &#x27;https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/dataset/synthetic_articles.csv&#x27; 
AS 행 
FIELDTERMINATOR &#x27;;&#x27;
MERGE (a:논문 {제목:행.Title})
SET a.초록 = 행.Abstract,
    a.출판일 = date(행.Publication_Date)
FOREACH (연구자 in split(행.Authors, &#x27;,&#x27;) | 
    MERGE (p:연구원 {이름:trim(연구자)})
    MERGE (p)-[:출판하다]-&gt;(a))
FOREACH (주제 in [행.Topic] | 
    MERGE (t:주제 {이름:trim(주제)})
    MERGE (a)-[:주제이다]-&gt;(t))
&quot;&quot;&quot;</span>

graph.query(q_load_articles)`,wrap:!1}}),x=new V({props:{code:"Z3JhcGgucmVmcmVzaF9zY2hlbWEoKSUwQXByaW50KGdyYXBoLmdldF9zY2hlbWEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>graph.refresh_schema()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(graph.get_schema)`,wrap:!1}}),Z=new h({props:{title:"벡터 인덱스 구축",local:"벡터-인덱스-구축",headingTag:"h3"}}),X=new V({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkudmVjdG9yc3RvcmVzJTIwaW1wb3J0JTIwTmVvNGpWZWN0b3IlMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyME9wZW5BSUVtYmVkZGluZ3MlMEElMEF2ZWN0b3JfaW5kZXglMjAlM0QlMjBOZW80alZlY3Rvci5mcm9tX2V4aXN0aW5nX2dyYXBoKCUwQSUyMCUyMCUyMCUyME9wZW5BSUVtYmVkZGluZ3MoKSUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VUkklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB1c2VybmFtZSUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VU0VSTkFNRSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3N3b3JkJTNEb3MuZW52aXJvbiU1QiUyMk5FTzRKX1BBU1NXT1JEJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5kZXhfbmFtZSUzRCUyMiVFQiU4NSVCQyVFQiVBQyVCOCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5vZGVfbGFiZWwlM0QlMjIlRUIlODUlQkMlRUIlQUMlQjglMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X25vZGVfcHJvcGVydGllcyUzRCU1QiUyMiVFQyVBMyVCQyVFQyVBMCU5QyUyMiUyQyUyMCUyMiVFQyVBMCU5QyVFQiVBQSVBOSUyMiUyQyUyMCUyMiVFQyVCNCU4OCVFQiVBMSU5RCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ19ub2RlX3Byb3BlcnR5JTNEJTIyZW1iZWRkaW5nJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Neo4jVector
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> OpenAIEmbeddings

vector_index = Neo4jVector.from_existing_graph(
    OpenAIEmbeddings(),
    url=os.environ[<span class="hljs-string">&quot;NEO4J_URI&quot;</span>],
    username=os.environ[<span class="hljs-string">&quot;NEO4J_USERNAME&quot;</span>],
    password=os.environ[<span class="hljs-string">&quot;NEO4J_PASSWORD&quot;</span>],
    index_name=<span class="hljs-string">&quot;논문&quot;</span>,
    node_label=<span class="hljs-string">&quot;논문&quot;</span>,
    text_node_properties=[<span class="hljs-string">&quot;주제&quot;</span>, <span class="hljs-string">&quot;제목&quot;</span>, <span class="hljs-string">&quot;초록&quot;</span>],
    embedding_node_property=<span class="hljs-string">&quot;embedding&quot;</span>,
)`,wrap:!1}}),z=new h({props:{title:"유사도 기반 Q&A",local:"유사도-기반-qa",headingTag:"h2"}}),K=new V({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBSZXRyaWV2YWxRQSUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQSUwQXZlY3Rvcl9xYSUyMCUzRCUyMFJldHJpZXZhbFFBLmZyb21fY2hhaW5fdHlwZShsbG0lM0RDaGF0T3BlbkFJKCklMkMlMjBjaGFpbl90eXBlJTNEJTIyc3R1ZmYlMjIlMkMlMjByZXRyaWV2ZXIlM0R2ZWN0b3JfaW5kZXguYXNfcmV0cmlldmVyKCkp",highlighted:`<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> RetrievalQA
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

vector_qa = RetrievalQA.from_chain_type(llm=ChatOpenAI(), chain_type=<span class="hljs-string">&quot;stuff&quot;</span>, retriever=vector_index.as_retriever())`,wrap:!1}}),el=new V({props:{code:"ciUyMCUzRCUyMHZlY3Rvcl9xYS5pbnZva2UoJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJBSSVFQSVCMCU4MCUyMCVFQyU5QSVCMCVFQiVBNiVBQyVFQyU5RCU5OCUyMCVFQyU5RCVCQyVFQyU4MyU4MSUyMCVFQyU4MyU5RCVFRCU5OSU5QyVFQyU5NyU5MCUyMCVFQyU5NiVCNCVFQiU5NiVBNCUyMCVFQyU5OCU4MSVFRCU5NiVBNSVFQyU5RCU4NCUyMCVFQiVBRiVCOCVFQyVCOSVBMCUyMCVFQyU4OCU5OCUyMCVFQyU5RSU4OCVFQiU4QSU5NCVFQyVBNyU4MCUyMCVFQiU4NSVCQyVFQyU5RCU5OCVFRCU5NSU5OCVFQiU4QSU5NCUyMCVFQiU4NSVCQyVFQiVBQyVCOCVFQyU5RCU4MCUyMCVFQyU5NiVCNCVFQiU5NiVBNCUyMCVFQSVCMiU4MyVFQiU5MyVBNCVFQyU5RCVCNCUyMCVFQyU5RSU4OCVFQiU4MiU5OCVFQyU5QSU5NCUzRiUyMCVFQiU4NSVCQyVFQiVBQyVCOCUyMCVFQyVBMCU5QyVFQiVBQSVBOSVFQSVCMyVCQyUyMCVFQyVCNCU4OCVFQiVBMSU5RCVFQyU5RCU4NCUyMCVFRCU4RiVBQyVFRCU5NSVBOCVFRCU5NSVCNCVFQyU4NCU5QyUyMCVFQiVBNyU5MCVFRCU5NSVCNCVFQyVBMyVCQyVFQyU4NCVCOCVFQyU5QSU5NC4lMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBcHJpbnQociU1QiUyMnJlc3VsdCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>r = vector_qa.invoke(
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;AI가 우리의 일상 생활에 어떤 영향을 미칠 수 있는지 논의하는 논문은 어떤 것들이 있나요? 논문 제목과 초록을 포함해서 말해주세요.&quot;</span>
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(r[<span class="hljs-string">&quot;result&quot;</span>])`,wrap:!1}}),nl=new h({props:{title:"추론을 위한 지식 그래프 탐색",local:"추론을-위한-지식-그래프-탐색",headingTag:"h2"}}),il=new h({props:{title:"LangChain을 사용한 그래프 Cypher 체인",local:"langchain을-사용한-그래프-cypher-체인",headingTag:"h3"}}),yl=new V({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBHcmFwaEN5cGhlclFBQ2hhaW4lMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyMENoYXRPcGVuQUklMEElMEFncmFwaC5yZWZyZXNoX3NjaGVtYSgpJTBBJTBBY3lwaGVyX2NoYWluJTIwJTNEJTIwR3JhcGhDeXBoZXJRQUNoYWluLmZyb21fbGxtKCUwQSUyMCUyMCUyMCUyMGN5cGhlcl9sbG0lM0RDaGF0T3BlbkFJKHRlbXBlcmF0dXJlJTNEMCUyQyUyMG1vZGVsX25hbWUlM0QlMjJncHQtNG8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwcWFfbGxtJTNEQ2hhdE9wZW5BSSh0ZW1wZXJhdHVyZSUzRDAlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0LTRvJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGdyYXBoJTNEZ3JhcGglMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NlJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> GraphCypherQAChain
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

graph.refresh_schema()

cypher_chain = GraphCypherQAChain.from_llm(
    cypher_llm=ChatOpenAI(temperature=<span class="hljs-number">0</span>, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span>),
    qa_llm=ChatOpenAI(temperature=<span class="hljs-number">0</span>, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span>),
    graph=graph,
    verbose=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Cl=new h({props:{title:"자연어를 사용한 쿼리 예시",local:"자연어를-사용한-쿼리-예시",headingTag:"h3"}}),ml=new h({props:{title:"” Emily Chen이 발표한 논문은 몇 편인가요? ”",local:"-emily-chen이-발표한-논문은-몇-편인가요-",headingTag:"h4"}}),hl=new V({props:{code:"TUFUQ0glMjAoJTNBJUVDJTk3JUIwJUVBJUI1JUFDJUVDJTlCJTkwJTIwJTdCJUVDJTlEJUI0JUVCJUE2JTg0JTNBJTIwJTIyRW1pbHklMjBDaGVuJTIyJTdEKS0lNUIlM0ElRUMlQjYlOUMlRUQlOEMlOTAlRUQlOTUlOTglRUIlOEIlQTQlNUQtJTNFKG4lM0ElRUIlODUlQkMlRUIlQUMlQjgpJTBBUkVUVVJOJTIwQ09VTlQobiklMjBBUyUyMCVFQiU4NSVCQyVFQiVBQyVCOF8lRUMlODglOTg=",highlighted:`MATCH (:연구원 {이름: <span class="hljs-string">&quot;Emily Chen&quot;</span>})-<span class="hljs-selector-attr">[:출판하다]</span>-&gt;(n:논문)
RETURN <span class="hljs-built_in">COUNT</span>(n) AS 논문_수`,wrap:!1}}),ol=new V({props:{code:"JTIzJTIwJUVCJThCJUI1JUVDJTlEJTgwJTIwJzcnJUVDJTlEJUI0JUVDJTk2JUI0JUVDJTk1JUJDJTIwJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQWN5cGhlcl9jaGFpbi5pbnZva2UoJTdCJTIycXVlcnklMjIlM0ElMjAlMjJFbWlseSUyMENoZW4lRUMlOUQlQjQlMjAlRUIlQjAlOUMlRUQlOTElOUMlRUQlOTUlOUMlMjAlRUIlODUlQkMlRUIlQUMlQjglRUMlOUQlODAlMjAlRUIlQUElODclMjAlRUQlOEUlQjglRUMlOUQlQjglRUElQjAlODAlRUMlOUElOTQlM0YlMjIlN0Qp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 답은 &#x27;7&#x27;이어야 합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke({<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;Emily Chen이 발표한 논문은 몇 편인가요?&quot;</span>})`,wrap:!1}}),wl=new h({props:{title:"” 3편보다 많은 논문을 함께 발표한 연구원 쌍을 알려주세요. ”",local:"-3편보다-많은-논문을-함께-발표한-연구원-쌍을-알려주세요-",headingTag:"h4"}}),cl=new V({props:{code:"TUFUQ0glMjAocjElM0ElRUMlOTclQjAlRUElQjUlQUMlRUMlOUIlOTApLSU1QiUzQSVFQyVCNiU5QyVFRCU4QyU5MCVFRCU5NSU5OCVFQiU4QiVBNCU1RC0lM0UocCUzQSVFQiU4NSVCQyVFQiVBQyVCOCklM0MtJTVCJTNBJUVDJUI2JTlDJUVEJThDJTkwJUVEJTk1JTk4JUVCJThCJUE0JTVELShyMiUzQSVFQyU5NyVCMCVFQSVCNSVBQyVFQyU5QiU5MCklMEFXSEVSRSUyMHIxJTIwJTNDJTNFJTIwcjIlMEFXSVRIJTIwcjElMkMlMjByMiUyQyUyMENPVU5UKHApJTIwQVMlMjAlRUIlODUlQkMlRUIlQUMlQjglRUMlODglOTglMEFXSEVSRSUyMCVFQiU4NSVCQyVFQiVBQyVCOCVFQyU4OCU5OCUyMCUzRSUyMDMlMEFSRVRVUk4lMjByMS4lRUMlOUQlQjQlRUIlQTYlODQlMjBBUyUyMCVFQyU5NyVCMCVFQSVCNSVBQyVFQyU5QiU5MDElMkMlMjByMi4lRUMlOUQlQjQlRUIlQTYlODQlMjBBUyUyMCVFQyU5NyVCMCVFQSVCNSVBQyVFQyU5QiU5MDIlMkMlMjAlRUIlODUlQkMlRUIlQUMlQjglRUMlODglOTg=",highlighted:`<span class="hljs-symbol">MATCH</span> (<span class="hljs-built_in">r1</span>:연구원)-[:출판하다]-&gt;(p:논문)&lt;-[:출판하다]-(<span class="hljs-built_in">r2</span>:연구원)
<span class="hljs-symbol">WHERE</span> <span class="hljs-built_in">r1</span> &lt;&gt; <span class="hljs-built_in">r2</span>
<span class="hljs-symbol">WITH</span> <span class="hljs-built_in">r1</span>, <span class="hljs-built_in">r2</span>, COUNT(p) AS 논문수
<span class="hljs-symbol">WHERE</span> 논문수 &gt; <span class="hljs-number">3</span>
<span class="hljs-symbol">RETURN</span> <span class="hljs-built_in">r1</span>.이름 AS 연구원<span class="hljs-number">1</span>, <span class="hljs-built_in">r2</span>.이름 AS 연구원<span class="hljs-number">2</span>, 논문수`,wrap:!1}}),fl=new V({props:{code:"JTIzJTIwJUVCJThCJUI1JUVDJTlEJTgwJTIwRGF2aWQlMjBKb2huc29uJTIwJTI2JTIwRW1pbHklMjBDaGVuJTJDJTIwUm9iZXJ0JTIwVGF5bG9yJTIwJTI2JTIwRW1pbHklMjBDaGVuJUVDJTlEJUI0JUVDJTk2JUI0JUVDJTk1JUJDJTIwJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQWN5cGhlcl9jaGFpbi5pbnZva2UoJTdCJTIycXVlcnklMjIlM0ElMjAlMjIzJUVEJThFJUI4JUVCJUIzJUI0JUVCJThCJUE0JTIwJUVCJUE3JThFJUVDJTlEJTgwJTIwJUVCJTg1JUJDJUVCJUFDJUI4JUVDJTlEJTg0JTIwJUVEJTk1JUE4JUVBJUJCJTk4JTIwJUVCJUIwJTlDJUVEJTkxJTlDJUVEJTk1JTlDJTIwJUVDJTk3JUIwJUVBJUI1JUFDJUVDJTlCJTkwJTIwJUVDJThDJThEJUVDJTlEJTg0JTIwJUVDJTk1JThDJUVCJUEwJUE0JUVDJUEzJUJDJUVDJTg0JUI4JUVDJTlBJTk0LiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 답은 David Johnson &amp; Emily Chen, Robert Taylor &amp; Emily Chen이어야 합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke({<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;3편보다 많은 논문을 함께 발표한 연구원 쌍을 알려주세요.&quot;</span>})`,wrap:!1}}),El=new h({props:{title:"” 가장 많은 동료와 협업한 연구원은 누구인가요? ”",local:"-가장-많은-동료와-협업한-연구원은-누구인가요-",headingTag:"h4"}}),Fl=new V({props:{code:"TUFUQ0glMjAociUzQSVFQyU5NyVCMCVFQSVCNSVBQyVFQyU5QiU5MCktJTVCJTNBJUVDJUI2JTlDJUVEJThDJTkwJUVEJTk1JTk4JUVCJThCJUE0JTVELSUzRSglM0ElRUIlODUlQkMlRUIlQUMlQjgpJTNDLSU1QiUzQSVFQyVCNiU5QyVFRCU4QyU5MCVFRCU5NSU5OCVFQiU4QiVBNCU1RC0oY29hdXRob3IlM0ElRUMlOTclQjAlRUElQjUlQUMlRUMlOUIlOTApJTBBV0hFUkUlMjByJTIwJTNDJTNFJTIwY29hdXRob3IlMEFSRVRVUk4lMjByLiVFQyU5RCVCNCVFQiVBNiU4NCUyMEFTJTIwJUVDJTk3JUIwJUVBJUI1JUFDJUVDJTlCJTkwJTJDJTIwQ09VTlQoRElTVElOQ1QlMjBjb2F1dGhvciklMjBBUyUyMCVFQiU4RiU5OSVFQiVBMyU4QyVFQyU4OCU5OCUwQU9SREVSJTIwQlklMjAlRUIlOEYlOTklRUIlQTMlOEMlRUMlODglOTglMjBERVNDJTBBTElNSVQlMjAx",highlighted:`MATCH (r:연구원)-[:출판하다]-&gt;(:논문)&lt;-[:출판하다]-(coauthor:연구원)
<span class="hljs-keyword">WHERE</span> r &lt;&gt; coauthor
<span class="hljs-keyword">RETURN</span> r.이름 <span class="hljs-keyword">AS</span> 연구원, COUNT(<span class="hljs-keyword">DISTINCT</span> coauthor) <span class="hljs-keyword">AS</span> 동료수
<span class="hljs-keyword">ORDER</span> <span class="hljs-keyword">BY</span> 동료수 <span class="hljs-keyword">DESC</span>
<span class="hljs-keyword">LIMIT</span> <span class="hljs-number">1</span>`,wrap:!1}}),dl=new V({props:{code:"JTIzJTIwJUVCJThCJUI1JUVDJTlEJTgwJTIwJ0RhdmlkJTIwSm9obnNvbiclRUMlOUQlQjQlRUMlOTYlQjQlRUMlOTUlQkMlMjAlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBY3lwaGVyX2NoYWluLmludm9rZSglN0IlMjJxdWVyeSUyMiUzQSUyMCUyMiVFQSVCMCU4MCVFQyU5RSVBNSUyMCVFQiVBNyU4RSVFQyU5RCU4MCUyMCVFQiU4RiU5OSVFQiVBMyU4QyVFQyU5OSU4MCUyMCVFRCU5OCU5MSVFQyU5NyU4NSVFRCU5NSU5QyUyMCVFQyU5NyVCMCVFQSVCNSVBQyVFQyU5QiU5MCVFQyU5RCU4MCUyMCVFQiU4OCU4NCVFQSVCNSVBQyVFQyU5RCVCOCVFQSVCMCU4MCVFQyU5QSU5NCUzRiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 답은 &#x27;David Johnson&#x27;이어야 합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke({<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;가장 많은 동료와 협업한 연구원은 누구인가요?&quot;</span>})`,wrap:!1}}),Bl=new pn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/ko/ko_rag_with_knowledge_graphs_neo4j.md"}}),{c(){Q=i("meta"),Ol=s(),kl=i("p"),_l=s(),J(o.$$.fragment),Al=s(),J(u.$$.fragment),Gl=s(),w=i("p"),w.innerHTML=Jt,Dl=s(),j=i("p"),j.innerHTML=Mt,xl=s(),c=i("p"),c.innerHTML=yt,Hl=s(),R=i("p"),R.textContent=Ct,Ll=s(),I=i("ul"),I.innerHTML=Tt,Wl=s(),r=i("p"),r.innerHTML=mt,Zl=s(),J(f.$$.fragment),ql=s(),J(g.$$.fragment),Xl=s(),J(E.$$.fragment),Yl=s(),$=i("p"),$.innerHTML=Vt,zl=s(),F=i("p"),F.innerHTML=ht,Pl=s(),b=i("p"),b.innerHTML=Qt,Kl=s(),J(N.$$.fragment),le=s(),d=i("p"),d.innerHTML=rt,ee=s(),J(S.$$.fragment),te=s(),J(B.$$.fragment),ne=s(),k=i("p"),k.innerHTML=ot,se=s(),v=i("p"),v.textContent=ut,Ue=s(),O=i("ul"),O.innerHTML=wt,ie=s(),_=i("p"),_.textContent=jt,ae=s(),A=i("ul"),A.innerHTML=ct,pe=s(),J(G.$$.fragment),Je=s(),D=i("p"),D.textContent=Rt,Me=s(),J(x.$$.fragment),ye=s(),H=i("pre"),H.textContent=It,Ce=s(),L=i("p"),L.textContent=ft,Te=s(),W=i("p"),W.innerHTML=gt,me=s(),J(Z.$$.fragment),Ve=s(),q=i("p"),q.innerHTML=Et,he=s(),J(X.$$.fragment),Qe=s(),Y=i("p"),Y.innerHTML=$t,re=s(),J(z.$$.fragment),oe=s(),P=i("p"),P.innerHTML=Ft,ue=s(),J(K.$$.fragment),we=s(),ll=i("p"),ll.innerHTML=bt,je=s(),J(el.$$.fragment),ce=s(),tl=i("pre"),tl.textContent=Nt,Re=s(),J(nl.$$.fragment),Ie=s(),sl=i("p"),sl.textContent=dt,fe=s(),Ul=i("p"),Ul.textContent=St,ge=s(),J(il.$$.fragment),Ee=s(),al=i("p"),al.innerHTML=Bt,$e=s(),pl=i("p"),pl.innerHTML=kt,Fe=s(),Jl=i("ul"),Jl.innerHTML=vt,be=s(),Ml=i("p"),Ml.innerHTML=Ot,Ne=s(),J(yl.$$.fragment),de=s(),J(Cl.$$.fragment),Se=s(),Tl=i("p"),Tl.textContent=_t,Be=s(),J(ml.$$.fragment),ke=s(),Vl=i("p"),Vl.innerHTML=At,ve=s(),J(hl.$$.fragment),Oe=s(),Ql=i("p"),Ql.innerHTML=Gt,_e=s(),rl=i("p"),rl.innerHTML=Dt,Ae=s(),J(ol.$$.fragment),Ge=s(),ul=i("pre"),ul.textContent=xt,De=s(),J(wl.$$.fragment),xe=s(),jl=i("p"),jl.innerHTML=Ht,He=s(),J(cl.$$.fragment),Le=s(),Rl=i("p"),Rl.innerHTML=Lt,We=s(),Il=i("p"),Il.innerHTML=Wt,Ze=s(),J(fl.$$.fragment),qe=s(),gl=i("pre"),gl.textContent=Zt,Xe=s(),J(El.$$.fragment),Ye=s(),$l=i("p"),$l.innerHTML=qt,ze=s(),J(Fl.$$.fragment),Pe=s(),bl=i("p"),bl.innerHTML=Xt,Ke=s(),Nl=i("p"),Nl.innerHTML=Yt,lt=s(),J(dl.$$.fragment),et=s(),Sl=i("pre"),Sl.textContent=zt,tt=s(),nt=i("hr"),st=s(),J(Bl.$$.fragment),Ut=s(),vl=i("p"),this.h()},l(l){const e=sn("svelte-u9bgzb",document.head);Q=a(e,"META",{name:!0,content:!0}),e.forEach(t),Ol=U(l),kl=a(l,"P",{}),Pt(kl).forEach(t),_l=U(l),M(o.$$.fragment,l),Al=U(l),M(u.$$.fragment,l),Gl=U(l),w=a(l,"P",{"data-svelte-h":!0}),p(w)!=="svelte-19sq6n0"&&(w.innerHTML=Jt),Dl=U(l),j=a(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-136agf"&&(j.innerHTML=Mt),xl=U(l),c=a(l,"P",{"data-svelte-h":!0}),p(c)!=="svelte-9vk653"&&(c.innerHTML=yt),Hl=U(l),R=a(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-5b9ee2"&&(R.textContent=Ct),Ll=U(l),I=a(l,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-1af23ed"&&(I.innerHTML=Tt),Wl=U(l),r=a(l,"P",{align:!0,"data-svelte-h":!0}),p(r)!=="svelte-xuaq4q"&&(r.innerHTML=mt),Zl=U(l),M(f.$$.fragment,l),ql=U(l),M(g.$$.fragment,l),Xl=U(l),M(E.$$.fragment,l),Yl=U(l),$=a(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1n1vtxi"&&($.innerHTML=Vt),zl=U(l),F=a(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-b16ai"&&(F.innerHTML=ht),Pl=U(l),b=a(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-8vyk00"&&(b.innerHTML=Qt),Kl=U(l),M(N.$$.fragment,l),le=U(l),d=a(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-17rpj77"&&(d.innerHTML=rt),ee=U(l),M(S.$$.fragment,l),te=U(l),M(B.$$.fragment,l),ne=U(l),k=a(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-cwyvrv"&&(k.innerHTML=ot),se=U(l),v=a(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1sfhb6o"&&(v.textContent=ut),Ue=U(l),O=a(l,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-35segy"&&(O.innerHTML=wt),ie=U(l),_=a(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-13blb8s"&&(_.textContent=jt),ae=U(l),A=a(l,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-13zen22"&&(A.innerHTML=ct),pe=U(l),M(G.$$.fragment,l),Je=U(l),D=a(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-u2rz1i"&&(D.textContent=Rt),Me=U(l),M(x.$$.fragment,l),ye=U(l),H=a(l,"PRE",{"data-svelte-h":!0}),p(H)!=="svelte-1l50klh"&&(H.textContent=It),Ce=U(l),L=a(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-ty1yjp"&&(L.textContent=ft),Te=U(l),W=a(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1v560wd"&&(W.innerHTML=gt),me=U(l),M(Z.$$.fragment,l),Ve=U(l),q=a(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-63px2c"&&(q.innerHTML=Et),he=U(l),M(X.$$.fragment,l),Qe=U(l),Y=a(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1qfkpjm"&&(Y.innerHTML=$t),re=U(l),M(z.$$.fragment,l),oe=U(l),P=a(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1hz8wrw"&&(P.innerHTML=Ft),ue=U(l),M(K.$$.fragment,l),we=U(l),ll=a(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-igr5l"&&(ll.innerHTML=bt),je=U(l),M(el.$$.fragment,l),ce=U(l),tl=a(l,"PRE",{"data-svelte-h":!0}),p(tl)!=="svelte-py5h8i"&&(tl.textContent=Nt),Re=U(l),M(nl.$$.fragment,l),Ie=U(l),sl=a(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1mymh39"&&(sl.textContent=dt),fe=U(l),Ul=a(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-1da167q"&&(Ul.textContent=St),ge=U(l),M(il.$$.fragment,l),Ee=U(l),al=a(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-1dym0c5"&&(al.innerHTML=Bt),$e=U(l),pl=a(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-1y30jf1"&&(pl.innerHTML=kt),Fe=U(l),Jl=a(l,"UL",{"data-svelte-h":!0}),p(Jl)!=="svelte-1ocjrcm"&&(Jl.innerHTML=vt),be=U(l),Ml=a(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-1wkbb5o"&&(Ml.innerHTML=Ot),Ne=U(l),M(yl.$$.fragment,l),de=U(l),M(Cl.$$.fragment,l),Se=U(l),Tl=a(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-13kyuha"&&(Tl.textContent=_t),Be=U(l),M(ml.$$.fragment,l),ke=U(l),Vl=a(l,"P",{"data-svelte-h":!0}),p(Vl)!=="svelte-1eu352z"&&(Vl.innerHTML=At),ve=U(l),M(hl.$$.fragment,l),Oe=U(l),Ql=a(l,"P",{"data-svelte-h":!0}),p(Ql)!=="svelte-i9yy29"&&(Ql.innerHTML=Gt),_e=U(l),rl=a(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-1v560wd"&&(rl.innerHTML=Dt),Ae=U(l),M(ol.$$.fragment,l),Ge=U(l),ul=a(l,"PRE",{"data-svelte-h":!0}),p(ul)!=="svelte-lfkhgt"&&(ul.textContent=xt),De=U(l),M(wl.$$.fragment,l),xe=U(l),jl=a(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-lw3uih"&&(jl.innerHTML=Ht),He=U(l),M(cl.$$.fragment,l),Le=U(l),Rl=a(l,"P",{"data-svelte-h":!0}),p(Rl)!=="svelte-7n2n9b"&&(Rl.innerHTML=Lt),We=U(l),Il=a(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-1v560wd"&&(Il.innerHTML=Wt),Ze=U(l),M(fl.$$.fragment,l),qe=U(l),gl=a(l,"PRE",{"data-svelte-h":!0}),p(gl)!=="svelte-1np6d01"&&(gl.textContent=Zt),Xe=U(l),M(El.$$.fragment,l),Ye=U(l),$l=a(l,"P",{"data-svelte-h":!0}),p($l)!=="svelte-tcvrhx"&&($l.innerHTML=qt),ze=U(l),M(Fl.$$.fragment,l),Pe=U(l),bl=a(l,"P",{"data-svelte-h":!0}),p(bl)!=="svelte-1ijvbof"&&(bl.innerHTML=Xt),Ke=U(l),Nl=a(l,"P",{"data-svelte-h":!0}),p(Nl)!=="svelte-1v560wd"&&(Nl.innerHTML=Yt),lt=U(l),M(dl.$$.fragment,l),et=U(l),Sl=a(l,"PRE",{"data-svelte-h":!0}),p(Sl)!=="svelte-1pyexij"&&(Sl.textContent=zt),tt=U(l),nt=a(l,"HR",{}),st=U(l),M(Bl.$$.fragment,l),Ut=U(l),vl=a(l,"P",{}),Pt(vl).forEach(t),this.h()},h(){at(Q,"name","hf:doc:metadata"),at(Q,"content",Mn),at(r,"align","center")},m(l,e){Un(document.head,Q),n(l,Ol,e),n(l,kl,e),n(l,_l,e),y(o,l,e),n(l,Al,e),y(u,l,e),n(l,Gl,e),n(l,w,e),n(l,Dl,e),n(l,j,e),n(l,xl,e),n(l,c,e),n(l,Hl,e),n(l,R,e),n(l,Ll,e),n(l,I,e),n(l,Wl,e),n(l,r,e),n(l,Zl,e),y(f,l,e),n(l,ql,e),y(g,l,e),n(l,Xl,e),y(E,l,e),n(l,Yl,e),n(l,$,e),n(l,zl,e),n(l,F,e),n(l,Pl,e),n(l,b,e),n(l,Kl,e),y(N,l,e),n(l,le,e),n(l,d,e),n(l,ee,e),y(S,l,e),n(l,te,e),y(B,l,e),n(l,ne,e),n(l,k,e),n(l,se,e),n(l,v,e),n(l,Ue,e),n(l,O,e),n(l,ie,e),n(l,_,e),n(l,ae,e),n(l,A,e),n(l,pe,e),y(G,l,e),n(l,Je,e),n(l,D,e),n(l,Me,e),y(x,l,e),n(l,ye,e),n(l,H,e),n(l,Ce,e),n(l,L,e),n(l,Te,e),n(l,W,e),n(l,me,e),y(Z,l,e),n(l,Ve,e),n(l,q,e),n(l,he,e),y(X,l,e),n(l,Qe,e),n(l,Y,e),n(l,re,e),y(z,l,e),n(l,oe,e),n(l,P,e),n(l,ue,e),y(K,l,e),n(l,we,e),n(l,ll,e),n(l,je,e),y(el,l,e),n(l,ce,e),n(l,tl,e),n(l,Re,e),y(nl,l,e),n(l,Ie,e),n(l,sl,e),n(l,fe,e),n(l,Ul,e),n(l,ge,e),y(il,l,e),n(l,Ee,e),n(l,al,e),n(l,$e,e),n(l,pl,e),n(l,Fe,e),n(l,Jl,e),n(l,be,e),n(l,Ml,e),n(l,Ne,e),y(yl,l,e),n(l,de,e),y(Cl,l,e),n(l,Se,e),n(l,Tl,e),n(l,Be,e),y(ml,l,e),n(l,ke,e),n(l,Vl,e),n(l,ve,e),y(hl,l,e),n(l,Oe,e),n(l,Ql,e),n(l,_e,e),n(l,rl,e),n(l,Ae,e),y(ol,l,e),n(l,Ge,e),n(l,ul,e),n(l,De,e),y(wl,l,e),n(l,xe,e),n(l,jl,e),n(l,He,e),y(cl,l,e),n(l,Le,e),n(l,Rl,e),n(l,We,e),n(l,Il,e),n(l,Ze,e),y(fl,l,e),n(l,qe,e),n(l,gl,e),n(l,Xe,e),y(El,l,e),n(l,Ye,e),n(l,$l,e),n(l,ze,e),y(Fl,l,e),n(l,Pe,e),n(l,bl,e),n(l,Ke,e),n(l,Nl,e),n(l,lt,e),y(dl,l,e),n(l,et,e),n(l,Sl,e),n(l,tt,e),n(l,nt,e),n(l,st,e),y(Bl,l,e),n(l,Ut,e),n(l,vl,e),it=!0},p:ln,i(l){it||(C(o.$$.fragment,l),C(u.$$.fragment,l),C(f.$$.fragment,l),C(g.$$.fragment,l),C(E.$$.fragment,l),C(N.$$.fragment,l),C(S.$$.fragment,l),C(B.$$.fragment,l),C(G.$$.fragment,l),C(x.$$.fragment,l),C(Z.$$.fragment,l),C(X.$$.fragment,l),C(z.$$.fragment,l),C(K.$$.fragment,l),C(el.$$.fragment,l),C(nl.$$.fragment,l),C(il.$$.fragment,l),C(yl.$$.fragment,l),C(Cl.$$.fragment,l),C(ml.$$.fragment,l),C(hl.$$.fragment,l),C(ol.$$.fragment,l),C(wl.$$.fragment,l),C(cl.$$.fragment,l),C(fl.$$.fragment,l),C(El.$$.fragment,l),C(Fl.$$.fragment,l),C(dl.$$.fragment,l),C(Bl.$$.fragment,l),it=!0)},o(l){T(o.$$.fragment,l),T(u.$$.fragment,l),T(f.$$.fragment,l),T(g.$$.fragment,l),T(E.$$.fragment,l),T(N.$$.fragment,l),T(S.$$.fragment,l),T(B.$$.fragment,l),T(G.$$.fragment,l),T(x.$$.fragment,l),T(Z.$$.fragment,l),T(X.$$.fragment,l),T(z.$$.fragment,l),T(K.$$.fragment,l),T(el.$$.fragment,l),T(nl.$$.fragment,l),T(il.$$.fragment,l),T(yl.$$.fragment,l),T(Cl.$$.fragment,l),T(ml.$$.fragment,l),T(hl.$$.fragment,l),T(ol.$$.fragment,l),T(wl.$$.fragment,l),T(cl.$$.fragment,l),T(fl.$$.fragment,l),T(El.$$.fragment,l),T(Fl.$$.fragment,l),T(dl.$$.fragment,l),T(Bl.$$.fragment,l),it=!1},d(l){l&&(t(Ol),t(kl),t(_l),t(Al),t(Gl),t(w),t(Dl),t(j),t(xl),t(c),t(Hl),t(R),t(Ll),t(I),t(Wl),t(r),t(Zl),t(ql),t(Xl),t(Yl),t($),t(zl),t(F),t(Pl),t(b),t(Kl),t(le),t(d),t(ee),t(te),t(ne),t(k),t(se),t(v),t(Ue),t(O),t(ie),t(_),t(ae),t(A),t(pe),t(Je),t(D),t(Me),t(ye),t(H),t(Ce),t(L),t(Te),t(W),t(me),t(Ve),t(q),t(he),t(Qe),t(Y),t(re),t(oe),t(P),t(ue),t(we),t(ll),t(je),t(ce),t(tl),t(Re),t(Ie),t(sl),t(fe),t(Ul),t(ge),t(Ee),t(al),t($e),t(pl),t(Fe),t(Jl),t(be),t(Ml),t(Ne),t(de),t(Se),t(Tl),t(Be),t(ke),t(Vl),t(ve),t(Oe),t(Ql),t(_e),t(rl),t(Ae),t(Ge),t(ul),t(De),t(xe),t(jl),t(He),t(Le),t(Rl),t(We),t(Il),t(Ze),t(qe),t(gl),t(Xe),t(Ye),t($l),t(ze),t(Pe),t(bl),t(Ke),t(Nl),t(lt),t(et),t(Sl),t(tt),t(nt),t(st),t(Ut),t(vl)),t(Q),m(o,l),m(u,l),m(f,l),m(g,l),m(E,l),m(N,l),m(S,l),m(B,l),m(G,l),m(x,l),m(Z,l),m(X,l),m(z,l),m(K,l),m(el,l),m(nl,l),m(il,l),m(yl,l),m(Cl,l),m(ml,l),m(hl,l),m(ol,l),m(wl,l),m(cl,l),m(fl,l),m(El,l),m(Fl,l),m(dl,l),m(Bl,l)}}}const Mn='{"title":"지식 그래프를 활용한 RAG 추론 향상","local":"지식-그래프를-활용한-rag-추론-향상","sections":[{"title":"초기화","local":"초기화","sections":[{"title":"Neo4j 인스턴스 설정","local":"neo4j-인스턴스-설정","sections":[],"depth":3},{"title":"데이터셋을 그래프로 로딩","local":"데이터셋을-그래프로-로딩","sections":[],"depth":3},{"title":"벡터 인덱스 구축","local":"벡터-인덱스-구축","sections":[],"depth":3}],"depth":2},{"title":"유사도 기반 Q&A","local":"유사도-기반-qa","sections":[],"depth":2},{"title":"추론을 위한 지식 그래프 탐색","local":"추론을-위한-지식-그래프-탐색","sections":[{"title":"LangChain을 사용한 그래프 Cypher 체인","local":"langchain을-사용한-그래프-cypher-체인","sections":[],"depth":3},{"title":"자연어를 사용한 쿼리 예시","local":"자연어를-사용한-쿼리-예시","sections":[{"title":"” Emily Chen이 발표한 논문은 몇 편인가요? ”","local":"-emily-chen이-발표한-논문은-몇-편인가요-","sections":[],"depth":4},{"title":"” 3편보다 많은 논문을 함께 발표한 연구원 쌍을 알려주세요. ”","local":"-3편보다-많은-논문을-함께-발표한-연구원-쌍을-알려주세요-","sections":[],"depth":4},{"title":"” 가장 많은 동료와 협업한 연구원은 누구인가요? ”","local":"-가장-많은-동료와-협업한-연구원은-누구인가요-","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function yn(pt){return en(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hn extends tn{constructor(Q){super(),nn(this,Q,yn,Jn,Kt,{})}}export{hn as component};
