import{s as fa,n as Ra,o as Aa}from"../chunks/scheduler.65852ee5.js";import{S as Xa,i as Na,g as j,s as t,r as M,A as Va,h as o,f as a,c as e,j as Ga,u as p,x as T,k as Wa,y as Ya,a as n,v as y,d as i,t as c,w as J}from"../chunks/index.65a1b999.js";import{D as Qa,C as r}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as U,E as Fa}from"../chunks/getInferenceSnippets.0c19d6f8.js";function za(na){let m,Ql,Vl,Fl,w,zl,u,kl,I,ta='<em>Authored by: <a href="https://github.com/behroozazarkhalili" rel="nofollow">Behrooz Azarkhalili</a></em>',El,h,ea="This notebook demonstrates <strong>advanced GRPO (Group Relative Policy Optimization)</strong> for mathematical reasoning using a comprehensive multi-reward training system. We’ll fine-tune a model on the GSM8K dataset with four specialized reward functions.",vl,b,Ma="<strong>Key Features:</strong>",Sl,d,pa="<li><strong>4 Reward Functions</strong>: Format compliance, approximate matching, answer correctness, and number extraction</li> <li><strong>Memory Efficient</strong>: 4-bit quantization + LoRA for consumer GPUs</li> <li><strong>Interactive Monitoring</strong>: Real-time training metrics with trackio dashboard</li> <li><strong>Structured Output</strong>: Enforces step-by-step reasoning format</li>",Hl,C,ya="The model learns to generate structured mathematical solutions with clear reasoning steps and accurate numerical answers.",_l,B,ql,g,ia="Install the required packages for GRPO training with memory-efficient techniques.",$l,Z,xl,G,Ll,W,ca="Verify GPU availability and display hardware specifications for optimal training configuration.",Kl,f,Dl,R,Pl,A,Ja="Import essential libraries for GRPO training, model configuration, and experiment tracking.",Ol,X,ls,N,ss,V,ja="Choose a compact but capable model suitable for mathematical reasoning with memory constraints.",as,Y,ns,Q,ts,F,es,z,Ms,k,oa="Apply Low-Rank Adaptation to train only ~0.1% of parameters while maintaining performance.",ps,E,ys,v,is,S,ra="Configure the GSM8K mathematical reasoning dataset with structured output format for step-by-step solutions.",cs,H,Js,_,js,q,os,$,rs,x,Ta="Implement four complementary reward functions to evaluate different aspects of mathematical reasoning:",Ts,L,Ua="<li><strong>Exact Format Matching</strong>: Perfect structure compliance</li> <li><strong>Approximate Matching</strong>: Partial credit for format elements</li> <li><strong>Answer Correctness</strong>: Mathematical accuracy with graduated scoring</li> <li><strong>Number Extraction</strong>: Ability to parse and output numerical results</li>",Us,K,ms,D,ws,P,us,O,Is,ll,hs,sl,bs,al,ma="Configure training parameters optimized for mathematical reasoning with memory constraints.",ds,nl,Cs,tl,Bs,el,gs,Ml,wa="Set up the GRPO trainer with our multi-reward system and experiment tracking.",Zs,pl,Gs,yl,Ws,il,ua="Start the training process with real-time reward monitoring. Watch for gradual improvement in both format compliance and mathematical accuracy.",fs,cl,Rs,Jl,As,jl,Ia="Launch the interactive trackio dashboard to analyze training progress, reward evolution, and model performance metrics.",Xs,ol,Ns,rl,Vs,Tl,ha="Test the trained model’s mathematical reasoning capability with structured output validation.",Ys,Ul,Qs,ml,Fs,wl,zs,ul,ba="Free GPU memory and clear cached tensors for optimal resource management.",ks,Il,Es,hl,vs,bl,Ss,dl,Hs,Cl,_s,Bl,da='<li><strong>GRPO Algorithm</strong>: <a href="https://arxiv.org/abs/2402.03300" rel="nofollow">Group Relative Policy Optimization</a> - The original GRPO paper introducing group-based relative policy optimization</li> <li><strong>GSM8K Dataset</strong>: <a href="https://arxiv.org/abs/2110.14168" rel="nofollow">Training Verifiers to Solve Math Word Problems</a> - Cobbe et al., OpenAI</li> <li><strong>LoRA</strong>: <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">Low-Rank Adaptation of Large Language Models</a> - Hu et al., Microsoft</li> <li><strong>QLoRA</strong>: <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">Efficient Finetuning of Quantized LLMs</a> - Dettmers et al., 4-bit quantization for efficient training</li>',qs,gl,$s,Zl,Ca='<li><strong>TRL (Transformers Reinforcement Learning)</strong>: <a href="https://github.com/huggingface/trl" rel="nofollow">HuggingFace TRL</a> - Official library for RLHF and advanced training techniques</li> <li><strong>Transformers</strong>: <a href="https://github.com/huggingface/transformers" rel="nofollow">HuggingFace Transformers</a> - State-of-the-art NLP library</li> <li><strong>PEFT</strong>: <a href="https://github.com/huggingface/peft" rel="nofollow">Parameter-Efficient Fine-Tuning</a> - Efficient adaptation methods</li> <li><strong>BitsAndBytes</strong>: <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">8-bit &amp; 4-bit Quantization</a> - Memory-efficient training</li>',xs,Gl,Ls,Wl,Ba='<li><strong>Qwen2.5-3B-Instruct</strong>: <a href="https://github.com/QwenLM/Qwen2.5" rel="nofollow">Qwen Model Series</a> - Alibaba’s instruction-tuned language model</li> <li><strong>Alternative Models</strong>: Gemma-2B, DialoGPT, GPT-2 (configurable in the notebook)</li>',Ks,fl,Ds,Rl,ga='<li><strong>GSM8K</strong>: <a href="https://huggingface.co/datasets/openai/gsm8k" rel="nofollow">OpenAI GSM8K</a> - Grade School Math 8K problems dataset</li> <li><strong>Format</strong>: Mathematical word problems requiring multi-step reasoning and numerical answers</li>',Ps,Al,Os,Xl,Za="<li><strong>Reinforcement Learning from Human Feedback (RLHF)</strong>: Training language models using reward signals</li> <li><strong>Group Relative Policy Optimization</strong>: Advanced RL technique comparing responses in groups rather than absolute scoring</li> <li><strong>Structured Generation</strong>: Teaching models to follow specific output formats with reasoning sections</li> <li><strong>Multi-Reward Training</strong>: Using multiple reward functions for comprehensive evaluation</li>",la,Nl,sa,Yl,aa;return w=new Qa({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/trl_grpo_reasoning_advanced_reward.ipynb"}]}}),u=new U({props:{title:"Advanced GRPO Fine-tuning for Mathematical Reasoning with Multi-Reward Training",local:"advanced-grpo-fine-tuning-for-mathematical-reasoning-with-multi-reward-training",headingTag:"h1"}}),B=new U({props:{title:"Installation and Setup",local:"installation-and-setup",headingTag:"h2"}}),Z=new r({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjBmb3IlMjBHUlBPJTIwbWF0aGVtYXRpY2FsJTIwcmVhc29uaW5nJTIwdHJhaW5pbmclMEEhcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwdHJsJTIwYml0c2FuZGJ5dGVzJTIwcGVmdCUyMHRyYWNraW8=",highlighted:`<span class="hljs-comment"># Install required packages for GRPO mathematical reasoning training</span>
!pip install transformers datasets trl bitsandbytes peft trackio`,wrap:!1}}),G=new U({props:{title:"GPU Environment Detection",local:"gpu-environment-detection",headingTag:"h2"}}),f=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBWZXJpZnklMjBDVURBJTIwYXZhaWxhYmlsaXR5JTIwYW5kJTIwZGlzcGxheSUyMEdQVSUyMHNwZWNpZmljYXRpb25zJTBBcHJpbnQoZiUyMkNVREElMjBhdmFpbGFibGUlM0ElMjAlN0J0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTdEJTIyKSUwQXByaW50KGYlMjJOdW1iZXIlMjBvZiUyMEdQVXMlM0ElMjAlN0J0b3JjaC5jdWRhLmRldmljZV9jb3VudCgpJTdEJTIyKSUwQSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERpc3BsYXklMjBjdXJyZW50JTIwR1BVJTIwZGV0YWlscyUyMGZvciUyMHRyYWluaW5nJTIwb3B0aW1pemF0aW9uJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkN1cnJlbnQlMjBHUFUlM0ElMjAlN0J0b3JjaC5jdWRhLmN1cnJlbnRfZGV2aWNlKCklN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkdQVSUyMG5hbWUlM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgpJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJHUFUlMjBtZW1vcnklM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfcHJvcGVydGllcygwKS50b3RhbF9tZW1vcnklMjAlMkYlMjAxZTklM0EuMWYlN0QlMjBHQiUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJvdmlkZSUyMGd1aWRhbmNlJTIwZm9yJTIwZW5hYmxpbmclMjBHUFUlMjBpbiUyMENvbGFiJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUUyJTlBJUEwJUVGJUI4JThGJTIwJTIwTm8lMjBHUFUlMjBhdmFpbGFibGUuJTIwVGhpcyUyMG5vdGVib29rJTIwcmVxdWlyZXMlMjBhJTIwR1BVJTIwZm9yJTIwZWZmaWNpZW50JTIwdHJhaW5pbmcuJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluJTIwQ29sYWIlM0ElMjBSdW50aW1lJTIwJUUyJTg2JTkyJTIwQ2hhbmdlJTIwcnVudGltZSUyMHR5cGUlMjAlRTIlODYlOTIlMjBIYXJkd2FyZSUyMGFjY2VsZXJhdG9yJTIwJUUyJTg2JTkyJTIwR1BVJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Verify CUDA availability and display GPU specifications</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CUDA available: <span class="hljs-subst">{torch.cuda.is_available()}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of GPUs: <span class="hljs-subst">{torch.cuda.device_count()}</span>&quot;</span>)

<span class="hljs-keyword">if</span> torch.cuda.is_available():
    <span class="hljs-comment"># Display current GPU details for training optimization</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Current GPU: <span class="hljs-subst">{torch.cuda.current_device()}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU name: <span class="hljs-subst">{torch.cuda.get_device_name()}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory: <span class="hljs-subst">{torch.cuda.get_device_properties(<span class="hljs-number">0</span>).total_memory / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># Provide guidance for enabling GPU in Colab</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  No GPU available. This notebook requires a GPU for efficient training.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;In Colab: Runtime → Change runtime type → Hardware accelerator → GPU&quot;</span>)`,wrap:!1}}),R=new U({props:{title:"Core Library Imports",local:"core-library-imports",headingTag:"h2"}}),X=new r({props:{code:"aW1wb3J0JTIwdHJhY2tpbyUyMCUyMCUyMyUyMEV4cGVyaW1lbnQlMjB0cmFja2luZyUyMGRhc2hib2FyZCUwQWltcG9ydCUyMHJlJTIwJTIwJTIzJTIwUmVnZXglMjBwYXR0ZXJucyUyMGZvciUyMHJld2FyZCUyMGZ1bmN0aW9ucyUwQSUwQSUyMyUyMEdSUE8lMjB0cmFpbmluZyUyMGNvbXBvbmVudHMlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwR1JQT0NvbmZpZyUyQyUyMEdSUE9UcmFpbmVyJTBBJTBBJTIzJTIwTW9kZWwlMjBhbmQlMjB0b2tlbml6YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwJTIwJTIzJTIwQ2F1c2FsJTIwbGFuZ3VhZ2UlMjBtb2RlbCUyMGxvYWRpbmclMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTIwJTIwJTIzJTIwVGV4dCUyMHRva2VuaXphdGlvbiUwQSUyMCUyMCUyMCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUyMCUyMCUyMyUyMFF1YW50aXphdGlvbiUyMGNvbmZpZ3VyYXRpb24lMEEpJTBBJTBBJTIzJTIwUGFyYW1ldGVyLWVmZmljaWVudCUyMGZpbmUtdHVuaW5nJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBUYXNrVHlwZSUwQSUwQSUyMyUyMERhdGFzZXQlMjBoYW5kbGluZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMExvZ2dpbmclMjBjb25maWd1cmF0aW9uJTBBaW1wb3J0JTIwbG9nZ2luZyUwQSUwQWxvZ2dpbmcuYmFzaWNDb25maWcobGV2ZWwlM0Rsb2dnaW5nLklORk8pJTBBbG9nZ2VyJTIwJTNEJTIwbG9nZ2luZy5nZXRMb2dnZXIoX19uYW1lX18pJTBBJTBBJTIzJTIwU3VwcHJlc3MlMjBodHRweCUyMHJlcXVlc3QlMjBsb2dzJTIwdGhhdCUyMGFwcGVhciUyMGR1cmluZyUyMHRyYWNraW8lMjB1c2FnZSUwQWxvZ2dpbmcuZ2V0TG9nZ2VyKCUyMmh0dHB4JTIyKS5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcpJTBBbG9nZ2luZy5nZXRMb2dnZXIoJTIyZ3JhZGlvX2NsaWVudCUyMikuc2V0TGV2ZWwobG9nZ2luZy5XQVJOSU5HKQ==",highlighted:`<span class="hljs-keyword">import</span> trackio  <span class="hljs-comment"># Experiment tracking dashboard</span>
<span class="hljs-keyword">import</span> re  <span class="hljs-comment"># Regex patterns for reward functions</span>

<span class="hljs-comment"># GRPO training components</span>
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOConfig, GRPOTrainer

<span class="hljs-comment"># Model and tokenization</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,  <span class="hljs-comment"># Causal language model loading</span>
    AutoTokenizer,  <span class="hljs-comment"># Text tokenization</span>
    BitsAndBytesConfig,  <span class="hljs-comment"># Quantization configuration</span>
)

<span class="hljs-comment"># Parameter-efficient fine-tuning</span>
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model, TaskType

<span class="hljs-comment"># Dataset handling</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Logging configuration</span>
<span class="hljs-keyword">import</span> logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

<span class="hljs-comment"># Suppress httpx request logs that appear during trackio usage</span>
logging.getLogger(<span class="hljs-string">&quot;httpx&quot;</span>).setLevel(logging.WARNING)
logging.getLogger(<span class="hljs-string">&quot;gradio_client&quot;</span>).setLevel(logging.WARNING)`,wrap:!1}}),N=new U({props:{title:"Model Selection and Configuration",local:"model-selection-and-configuration",headingTag:"h2"}}),Y=new r({props:{code:"JTIzJTIwU2VsZWN0JTIwbW9kZWwlMjBvcHRpbWl6ZWQlMjBmb3IlMjBpbnN0cnVjdGlvbi1mb2xsb3dpbmclMjBhbmQlMjByZWFzb25pbmclMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyUXdlbiUyRlF3ZW4yLjUtM0ItSW5zdHJ1Y3QlMjIlMjAlMjAlMjMlMjAzQiUyMHBhcmFtZXRlciUyMG1vZGVsJTIwYmFsYW5jZXMlMjBjYXBhYmlsaXR5JTIwYW5kJTIwbWVtb3J5JTIwdXNhZ2UlMEFtYXhfc2VxX2xlbmd0aCUyMCUzRCUyMDIwNDglMjAlMjAlMjMlMjBUb2tlbiUyMGxpbWl0JTIwZm9yJTIwbWF0aGVtYXRpY2FsJTIwcHJvYmxlbXMlMjAocmVkdWNlJTIwaWYlMjBPT00pJTBBJTBBcHJpbnQoZiUyMkxvYWRpbmclMjBtb2RlbCUzQSUyMCU3Qm1vZGVsX25hbWUlN0QlMjIpJTBBcHJpbnQoZiUyMk1heCUyMHNlcXVlbmNlJTIwbGVuZ3RoJTNBJTIwJTdCbWF4X3NlcV9sZW5ndGglN0QlMjIp",highlighted:`<span class="hljs-comment"># Select model optimized for instruction-following and reasoning</span>
model_name = <span class="hljs-string">&quot;Qwen/Qwen2.5-3B-Instruct&quot;</span>  <span class="hljs-comment"># 3B parameter model balances capability and memory usage</span>
max_seq_length = <span class="hljs-number">2048</span>  <span class="hljs-comment"># Token limit for mathematical problems (reduce if OOM)</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loading model: <span class="hljs-subst">{model_name}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max sequence length: <span class="hljs-subst">{max_seq_length}</span>&quot;</span>)`,wrap:!1}}),Q=new r({props:{code:"JTIzJTIwQ29uZmlndXJlJTIwNC1iaXQlMjBxdWFudGl6YXRpb24lMjBmb3IlMjB+NzUlMjUlMjBtZW1vcnklMjByZWR1Y3Rpb24lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAlMjAlMjMlMjBFbmFibGUlMjA0LWJpdCUyMHByZWNpc2lvbiUyMCh2cyUyMDE2LWJpdCUyMGRlZmF1bHQpJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMCUyMCUyMyUyME5vcm1hbEZsb2F0NCUzQSUyMG9wdGltYWwlMjBmb3IlMjBuZXVyYWwlMjBuZXR3b3JrJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTIwJTIzJTIwVXNlJTIwRlAxNiUyMGZvciUyMGZvcndhcmQlMkZiYWNrd2FyZCUyMHBhc3NlcyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwJTIwJTIzJTIwRnVydGhlciUyMHF1YW50aXplJTIwcXVhbnRpemF0aW9uJTIwY29uc3RhbnRzJTBBKSUwQSUwQXByaW50KCUyMiVFMiU5QyU4NSUyMDQtYml0JTIwcXVhbnRpemF0aW9uJTIwY29uZmlndXJlZCUyMiklMEFwcmludCglMjIlMjAlMjAlMjBNZW1vcnklMjByZWR1Y3Rpb24lM0ElMjB+NzUlMjUlMjB2cyUyMEZQMTYlMjIp",highlighted:`<span class="hljs-comment"># Configure 4-bit quantization for ~75% memory reduction</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable 4-bit precision (vs 16-bit default)</span>
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,  <span class="hljs-comment"># NormalFloat4: optimal for neural network weights</span>
    bnb_4bit_compute_dtype=torch.float16,  <span class="hljs-comment"># Use FP16 for forward/backward passes</span>
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Further quantize quantization constants</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ 4-bit quantization configured&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;   Memory reduction: ~75% vs FP16&quot;</span>)`,wrap:!1}}),F=new r({props:{code:"JTIzJTIwTG9hZCUyMG1vZGVsJTIwd2l0aCUyMHF1YW50aXphdGlvbiUyMGFuZCUyMGF1dG9tYXRpYyUyMGRldmljZSUyMG1hcHBpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWclMkMlMjAlMjAlMjMlMjBBcHBseSUyMDQtYml0JTIwcXVhbnRpemF0aW9uJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjAlMjAlMjMlMjBBdXRvLWRpc3RyaWJ1dGUlMjBhY3Jvc3MlMjBhdmFpbGFibGUlMjBHUFVzJTJGQ1BVJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwJTIwJTIzJTIwQWxsb3clMjBjdXN0b20lMjBtb2RlbCUyMGNvZGUlMjBleGVjdXRpb24lMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjAlMjAlMjMlMjBVc2UlMjBGUDE2JTIwZm9yJTIwbm9uLXF1YW50aXplZCUyMG9wZXJhdGlvbnMlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMGNvcnJlc3BvbmRpbmclMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMCUyMCUyMyUyMEFsbG93JTIwY3VzdG9tJTIwdG9rZW5pemVyJTIwY29kZSUwQSUwQSUyMyUyMEVuc3VyZSUyMHRva2VuaXplciUyMGhhcyUyMHByb3BlciUyMHBhZGRpbmclMjB0b2tlbiUyMGZvciUyMGJhdGNoJTIwcHJvY2Vzc2luZyUwQWlmJTIwdG9rZW5pemVyLnBhZF90b2tlbiUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTBBJTBBcHJpbnQoZiUyMiVFMiU5QyU4NSUyME1vZGVsJTIwbG9hZGVkJTIwc3VjY2Vzc2Z1bGx5ISUyMiklMEFwcmludChmJTIyJUYwJTlGJTkzJThBJTIwTW9kZWwlMjBwYXJhbWV0ZXJzJTNBJTIwfiU3QnN1bShwLm51bWVsKCklMjBmb3IlMjBwJTIwaW4lMjBtb2RlbC5wYXJhbWV0ZXJzKCkpJTIwJTJGJTIwMWU2JTNBLjFmJTdETSUyMiklMEFwcmludChmJTIyJUYwJTlGJUE3JUFFJTIwUXVhbnRpemVkJTIwcGFyYW1ldGVycyUzQSUyMH4lN0JzdW0ocC5udW1lbCgpJTIwZm9yJTIwcCUyMGluJTIwbW9kZWwucGFyYW1ldGVycygpJTIwaWYlMjBoYXNhdHRyKHAlMkMlMjAncXVhbnRfdHlwZScpKSUyMCUyRiUyMDFlNiUzQS4xZiU3RE0lMjIp",highlighted:`<span class="hljs-comment"># Load model with quantization and automatic device mapping</span>
model = AutoModelForCausalLM.from_pretrained(
    model_name,
    quantization_config=bnb_config,  <span class="hljs-comment"># Apply 4-bit quantization</span>
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># Auto-distribute across available GPUs/CPU</span>
    trust_remote_code=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Allow custom model code execution</span>
    torch_dtype=torch.float16,  <span class="hljs-comment"># Use FP16 for non-quantized operations</span>
)

<span class="hljs-comment"># Load corresponding tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(model_name, trust_remote_code=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># Allow custom tokenizer code</span>

<span class="hljs-comment"># Ensure tokenizer has proper padding token for batch processing</span>
<span class="hljs-keyword">if</span> tokenizer.pad_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token = tokenizer.eos_token

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Model loaded successfully!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Model parameters: ~<span class="hljs-subst">{<span class="hljs-built_in">sum</span>(p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters()) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span>M&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🧮 Quantized parameters: ~<span class="hljs-subst">{<span class="hljs-built_in">sum</span>(p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters() <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(p, <span class="hljs-string">&#x27;quant_type&#x27;</span>)) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span>M&quot;</span>)`,wrap:!1}}),z=new U({props:{title:"LoRA Configuration",local:"lora-configuration",headingTag:"h2"}}),E=new r({props:{code:"JTIzJTIwQ29uZmlndXJlJTIwTG9SQSUyMGZvciUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUyMGFkYXB0YXRpb24lMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTIwJTIwJTIzJTIwUmFuayUzQSUyMGFkYXB0YXRpb24lMjBjYXBhY2l0eSUyMCgxNiUyMGdvb2QlMjBmb3IlMjByZWFzb25pbmclMjB0YXNrcyklMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMjAlMjAlMjMlMjBTY2FsaW5nJTIwZmFjdG9yJTIwKHR5cGljYWxseSUyMDJ4JTIwcmFuayklMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUyMCUyMCUyMyUyMEZvY3VzJTIwb24lMjBhdHRlbnRpb24lMjBxdWVyeSUyRnZhbHVlJTIwZm9yJTIwcmVhc29uaW5nJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTIwJTIwJTIzJTIwUmVndWxhcml6YXRpb24lMjB0byUyMHByZXZlbnQlMjBvdmVyZml0dGluZyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTIwJTIwJTIzJTIwU2tpcCUyMGJpYXMlMjBhZGFwdGF0aW9uJTIwZm9yJTIwc2ltcGxpY2l0eSUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLkNBVVNBTF9MTSUyQyUyMCUyMCUyMyUyMENhdXNhbCUyMGxhbmd1YWdlJTIwbW9kZWxpbmclMjB0YXNrJTBBKSUwQSUwQXByaW50KCUyMiVGMCU5RiU5NCVBNyUyMEFwcGx5aW5nJTIwTG9SQSUyMGFkYXB0YXRpb24lMjB0byUyMG1vZGVsLi4uJTIyKSUwQSUwQSUyMyUyMEFwcGx5JTIwTG9SQSUyMGNvbmZpZ3VyYXRpb24lMjB0byUyMGNyZWF0ZSUyMHRyYWluYWJsZSUyMGFkYXB0ZXIlMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwbG9yYV9jb25maWcpJTBBJTBBJTIzJTIwRGlzcGxheSUyMHBhcmFtZXRlciUyMGVmZmljaWVuY3klMEFwcmludCglMjIlRjAlOUYlOTMlOEElMjBMb1JBJTIwVHJhaW5pbmclMjBQYXJhbWV0ZXJzJTIwU3VtbWFyeSUzQSUyMiklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTIwJTIwJTIzJTIwU2hvd3MlMjB0cmFpbmFibGUlMjB2cyUyMHRvdGFsJTIwcGFyYW1ldGVycw==",highlighted:`<span class="hljs-comment"># Configure LoRA for mathematical reasoning adaptation</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,  <span class="hljs-comment"># Rank: adaptation capacity (16 good for reasoning tasks)</span>
    lora_alpha=<span class="hljs-number">32</span>,  <span class="hljs-comment"># Scaling factor (typically 2x rank)</span>
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],  <span class="hljs-comment"># Focus on attention query/value for reasoning</span>
    lora_dropout=<span class="hljs-number">0.1</span>,  <span class="hljs-comment"># Regularization to prevent overfitting</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Skip bias adaptation for simplicity</span>
    task_type=TaskType.CAUSAL_LM,  <span class="hljs-comment"># Causal language modeling task</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔧 Applying LoRA adaptation to model...&quot;</span>)

<span class="hljs-comment"># Apply LoRA configuration to create trainable adapter</span>
model = get_peft_model(model, lora_config)

<span class="hljs-comment"># Display parameter efficiency</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📊 LoRA Training Parameters Summary:&quot;</span>)
model.print_trainable_parameters()  <span class="hljs-comment"># Shows trainable vs total parameters</span>`,wrap:!1}}),v=new U({props:{title:"GSM8K Dataset Setup",local:"gsm8k-dataset-setup",headingTag:"h2"}}),H=new r({props:{code:"JTIzJTIwRGVmaW5lJTIwc3RydWN0dXJlZCUyMG91dHB1dCUyMGZvcm1hdCUyMGZvciUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUwQXJlYXNvbmluZ19zdGFydCUyMCUzRCUyMCUyMiUzQ3N0YXJ0X3dvcmtpbmdfb3V0JTNFJTIyJTIwJTIwJTIzJTIwQmVnaW4lMjByZWFzb25pbmclMjBzZWN0aW9uJTBBcmVhc29uaW5nX2VuZCUyMCUzRCUyMCUyMiUzQ2VuZF93b3JraW5nX291dCUzRSUyMiUyMCUyMCUyMyUyMEVuZCUyMHJlYXNvbmluZyUyMHNlY3Rpb24lMEFzb2x1dGlvbl9zdGFydCUyMCUzRCUyMCUyMiUzQ1NPTFVUSU9OJTNFJTIyJTIwJTIwJTIzJTIwQmVnaW4lMjBmaW5hbCUyMGFuc3dlciUwQXNvbHV0aW9uX2VuZCUyMCUzRCUyMCUyMiUzQyUyRlNPTFVUSU9OJTNFJTIyJTIwJTIwJTIzJTIwRW5kJTIwZmluYWwlMjBhbnN3ZXIlMEElMEElMjMlMjBTeXN0ZW0lMjBwcm9tcHQlMjB0aGF0JTIwdGVhY2hlcyUyMHRoZSUyMG1vZGVsJTIwb3VyJTIwZGVzaXJlZCUyMHJlYXNvbmluZyUyMHN0cnVjdHVyZSUwQXN5c3RlbV9wcm9tcHQlMjAlM0QlMjBmJTIyJTIyJTIyWW91JTIwYXJlJTIwYSUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUyMGFzc2lzdGFudC4lMEFXaGVuJTIwZ2l2ZW4lMjBhJTIwbWF0aCUyMHByb2JsZW0lM0ElMEExLiUyMFNob3clMjB5b3VyJTIwc3RlcC1ieS1zdGVwJTIwd29yayUyMGJldHdlZW4lMjAlN0JyZWFzb25pbmdfc3RhcnQlN0QlMjBhbmQlMjAlN0JyZWFzb25pbmdfZW5kJTdEJTBBMi4lMjBQcm92aWRlJTIweW91ciUyMGZpbmFsJTIwbnVtZXJpY2FsJTIwYW5zd2VyJTIwYmV0d2VlbiUyMCU3QnNvbHV0aW9uX3N0YXJ0JTdEJTIwYW5kJTIwJTdCc29sdXRpb25fZW5kJTdEJTBBMy4lMjBCZSUyMHByZWNpc2UlMjBhbmQlMjBzaG93JTIwYWxsJTIwY2FsY3VsYXRpb24lMjBzdGVwcyUyMGNsZWFybHkuJTIyJTIyJTIyJTBBJTBBcHJpbnQoJTIyJUUyJTlDJTg1JTIwRm9ybWF0JTIwdG9rZW5zJTIwYW5kJTIwc3lzdGVtJTIwcHJvbXB0JTIwZGVmaW5lZCUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwUmVhc29uaW5nJTIwZm9ybWF0JTNBJTIwJTdCcmVhc29uaW5nX3N0YXJ0JTdEJTIwLi4uJTIwJTdCcmVhc29uaW5nX2VuZCU3RCUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwU29sdXRpb24lMjBmb3JtYXQlM0ElMjAlN0Jzb2x1dGlvbl9zdGFydCU3RCUyMC4uLiUyMCU3QnNvbHV0aW9uX2VuZCU3RCUyMik=",highlighted:`<span class="hljs-comment"># Define structured output format for mathematical reasoning</span>
reasoning_start = <span class="hljs-string">&quot;&lt;start_working_out&gt;&quot;</span>  <span class="hljs-comment"># Begin reasoning section</span>
reasoning_end = <span class="hljs-string">&quot;&lt;end_working_out&gt;&quot;</span>  <span class="hljs-comment"># End reasoning section</span>
solution_start = <span class="hljs-string">&quot;&lt;SOLUTION&gt;&quot;</span>  <span class="hljs-comment"># Begin final answer</span>
solution_end = <span class="hljs-string">&quot;&lt;/SOLUTION&gt;&quot;</span>  <span class="hljs-comment"># End final answer</span>

<span class="hljs-comment"># System prompt that teaches the model our desired reasoning structure</span>
system_prompt = <span class="hljs-string">f&quot;&quot;&quot;You are a mathematical reasoning assistant.
When given a math problem:
1. Show your step-by-step work between <span class="hljs-subst">{reasoning_start}</span> and <span class="hljs-subst">{reasoning_end}</span>
2. Provide your final numerical answer between <span class="hljs-subst">{solution_start}</span> and <span class="hljs-subst">{solution_end}</span>
3. Be precise and show all calculation steps clearly.&quot;&quot;&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Format tokens and system prompt defined&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Reasoning format: <span class="hljs-subst">{reasoning_start}</span> ... <span class="hljs-subst">{reasoning_end}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Solution format: <span class="hljs-subst">{solution_start}</span> ... <span class="hljs-subst">{solution_end}</span>&quot;</span>)`,wrap:!1}}),_=new r({props:{code:"JTIzJTIwRGF0YXNldCUyMHByb2Nlc3NpbmclMjB1dGlsaXRpZXMlMEFkZWYlMjBleHRyYWN0X2hhc2hfYW5zd2VyKHRleHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRXh0cmFjdCUyMG51bWVyaWNhbCUyMGFuc3dlciUyMGZyb20lMjBHU004SyUyMGZvcm1hdCUyMCglMjMlMjMlMjMlMjMlMjBtYXJrZXIpJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjIlMjMlMjMlMjMlMjMlMjIlMjBub3QlMjBpbiUyMHRleHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTBBJTIwJTIwJTIwJTIwJTIzJTIwR1NNOEslMjB1c2VzJTIwZm9ybWF0JTNBJTIwJTIyRXhwbGFuYXRpb24uLi4lMjAlMjMlMjMlMjMlMjMlMjA0MiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQuc3BsaXQoJTIyJTIzJTIzJTIzJTIzJTIyKSU1QjElNUQuc3RyaXAoKSUwQSUwQSUwQWRlZiUyMHByb2Nlc3NfZGF0YXNldF9leGFtcGxlKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29udmVydCUyMEdTTThLJTIwZXhhbXBsZSUyMHRvJTIwY29udmVyc2F0aW9uJTIwZm9ybWF0JTIwZm9yJTIwR1JQTyUyMHRyYWluaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lMjAlM0QlMjBleGFtcGxlJTVCJTIycXVlc3Rpb24lMjIlNUQlMEElMjAlMjAlMjAlMjBhbnN3ZXIlMjAlM0QlMjBleHRyYWN0X2hhc2hfYW5zd2VyKGV4YW1wbGUlNUIlMjJhbnN3ZXIlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwY29udmVyc2F0aW9uJTIwd2l0aCUyMHN5c3RlbSUyMHByb21wdCUyMGZvciUyMHN0cnVjdHVyZWQlMjByZWFzb25pbmclMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHN5c3RlbV9wcm9tcHQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBxdWVzdGlvbiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMHByb21wdCUyQyUyMCUyMCUyMyUyMElucHV0JTIwY29udmVyc2F0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYW5zd2VyJTIyJTNBJTIwYW5zd2VyJTJDJTIwJTIwJTIzJTIwR3JvdW5kJTIwdHJ1dGglMjBmb3IlMjByZXdhcmQlMjBmdW5jdGlvbnMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBEYXRhc2V0JTIwcHJvY2Vzc2luZyUyMGZ1bmN0aW9ucyUyMGRlZmluZWQlMjIp",highlighted:`<span class="hljs-comment"># Dataset processing utilities</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_hash_answer</span>(<span class="hljs-params">text</span>):
    <span class="hljs-string">&quot;&quot;&quot;Extract numerical answer from GSM8K format (#### marker)&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;####&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> text:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    <span class="hljs-comment"># GSM8K uses format: &quot;Explanation... #### 42&quot;</span>
    <span class="hljs-keyword">return</span> text.split(<span class="hljs-string">&quot;####&quot;</span>)[<span class="hljs-number">1</span>].strip()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_dataset_example</span>(<span class="hljs-params">example</span>):
    <span class="hljs-string">&quot;&quot;&quot;Convert GSM8K example to conversation format for GRPO training&quot;&quot;&quot;</span>
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    answer = extract_hash_answer(example[<span class="hljs-string">&quot;answer&quot;</span>])

    <span class="hljs-comment"># Create conversation with system prompt for structured reasoning</span>
    prompt = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
    ]

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;prompt&quot;</span>: prompt,  <span class="hljs-comment"># Input conversation</span>
        <span class="hljs-string">&quot;answer&quot;</span>: answer,  <span class="hljs-comment"># Ground truth for reward functions</span>
    }


<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Dataset processing functions defined&quot;</span>)`,wrap:!1}}),q=new r({props:{code:"JTIzJTIwTG9hZCUyMGFuZCUyMHByZXByb2Nlc3MlMjBHU004SyUyMHRyYWluaW5nJTIwZGF0YXNldCUwQXByaW50KCUyMiVGMCU5RiU5NCU4NCUyMExvYWRpbmclMjBHU004SyUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUyMGRhdGFzZXQuLi4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJvcGVuYWklMkZnc204ayUyMiUyQyUyMCUyMm1haW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMEFwcGx5JTIwY29udmVyc2F0aW9uJTIwZm9ybWF0dGluZyUyMHRvJTIwYWxsJTIwZXhhbXBsZXMlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocHJvY2Vzc19kYXRhc2V0X2V4YW1wbGUpJTBBJTBBcHJpbnQoZiUyMiVFMiU5QyU4NSUyMERhdGFzZXQlMjBsb2FkZWQlMjBhbmQlMjBwcm9jZXNzZWQhJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOTMlOEElMjBUcmFpbmluZyUyMGV4YW1wbGVzJTNBJTIwJTdCbGVuKGRhdGFzZXQpJTNBJTJDJTdEJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOEUlQUYlMjBTYW1wbGUlMjBxdWVzdGlvbiUzQSUyMCU3QmRhdGFzZXQlNUIwJTVEJTVCJ3Byb21wdCclNUQlNUIxJTVEJTVCJ2NvbnRlbnQnJTVEJTdELi4uJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOEUlQUYlMjBTYW1wbGUlMjBhbnN3ZXIlM0ElMjAlN0JkYXRhc2V0JTVCMCU1RCU1QidhbnN3ZXInJTVEJTdEJTIyKSUwQSUwQSUyMyUyMFNob3clMjBzdHJ1Y3R1cmUlMjBvZiUyMGZpcnN0JTIwZXhhbXBsZSUyMGZvciUyMHZlcmlmaWNhdGlvbiUwQXByaW50KGYlMjIlNUNuJUYwJTlGJTkzJThCJTIwRXhhbXBsZSUyMHN0cnVjdHVyZSUzQSUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwUHJvbXB0JTNBJTIwJTdCbGVuKGRhdGFzZXQlNUIwJTVEJTVCJ3Byb21wdCclNUQpJTdEJTIwbWVzc2FnZXMlMjAoc3lzdGVtJTIwJTJCJTIwdXNlciklMjIpJTBBcHJpbnQoZiUyMiUyMCUyMCUyMEFuc3dlciUzQSUyMCU3QmRhdGFzZXQlNUIwJTVEJTVCJ2Fuc3dlciclNUQlN0QlMjAoZ3JvdW5kJTIwdHJ1dGglMjBmb3IlMjByZXdhcmRzKSUyMik=",highlighted:`<span class="hljs-comment"># Load and preprocess GSM8K training dataset</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔄 Loading GSM8K mathematical reasoning dataset...&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&quot;main&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Apply conversation formatting to all examples</span>
dataset = dataset.<span class="hljs-built_in">map</span>(process_dataset_example)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Dataset loaded and processed!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Training examples: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Sample question: <span class="hljs-subst">{dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;prompt&#x27;</span>][<span class="hljs-number">1</span>][<span class="hljs-string">&#x27;content&#x27;</span>]}</span>...&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Sample answer: <span class="hljs-subst">{dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>)

<span class="hljs-comment"># Show structure of first example for verification</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📋 Example structure:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Prompt: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;prompt&#x27;</span>])}</span> messages (system + user)&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Answer: <span class="hljs-subst">{dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;answer&#x27;</span>]}</span> (ground truth for rewards)&quot;</span>)`,wrap:!1}}),$=new U({props:{title:"Multi-Reward System Design",local:"multi-reward-system-design",headingTag:"h2"}}),K=new r({props:{code:"JTIzJTIwQ29tcGlsZWQlMjByZWdleCUyMHBhdHRlcm5zJTIwZm9yJTIwZWZmaWNpZW50JTIwcmV3YXJkJTIwY29tcHV0YXRpb24lMEFtYXRjaF9mb3JtYXQlMjAlM0QlMjByZS5jb21waWxlKCUwQSUyMCUyMCUyMCUyMHJmJTIyJTVFJTVCJTVDcyU1RCU3QiU3QjAlMkMlN0QlN0QlMjIlMjAlMjAlMjMlMjBPcHRpb25hbCUyMHdoaXRlc3BhY2UlMjBhdCUyMHN0YXJ0JTBBJTIwJTIwJTIwJTIwcmYlMjIlN0JyZWFzb25pbmdfc3RhcnQlN0QuJTJCJTNGJTdCcmVhc29uaW5nX2VuZCU3RC4qJTNGJTIyJTIwJTIwJTIzJTIwUmVhc29uaW5nJTIwc2VjdGlvbiUyMChub24tZ3JlZWR5KSUwQSUyMCUyMCUyMCUyMHJmJTIyJTdCc29sdXRpb25fc3RhcnQlN0QoLiUyQiUzRiklN0Jzb2x1dGlvbl9lbmQlN0QlMjIlMjAlMjAlMjMlMjBTb2x1dGlvbiUyMHNlY3Rpb24lMjB3aXRoJTIwY2FwdHVyZSUyMGdyb3VwJTBBJTIwJTIwJTIwJTIwcmYlMjIlNUIlNUNzJTVEJTdCJTdCMCUyQyU3RCU3RCUyNCUyMiUyQyUyMCUyMCUyMyUyME9wdGlvbmFsJTIwd2hpdGVzcGFjZSUyMGF0JTIwZW5kJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0RyZS5NVUxUSUxJTkUlMjAlN0MlMjByZS5ET1RBTEwlMkMlMjAlMjAlMjMlMjBNdWx0aS1saW5lJTIwbWF0Y2hpbmclMjB3aXRoJTIwLiUyMG1hdGNoaW5nJTIwbmV3bGluZXMlMEEpJTBBJTBBbWF0Y2hfbnVtYmVycyUyMCUzRCUyMHJlLmNvbXBpbGUoJTBBJTIwJTIwJTIwJTIwcmYlMjIlN0Jzb2x1dGlvbl9zdGFydCU3RC4qJTNGKCU1QiU1Q2QlNUMuJTVEJTdCJTdCMSUyQyU3RCU3RCklMjIlMkMlMjAlMjAlMjMlMjBFeHRyYWN0JTIwbnVtYmVycyUyMGZyb20lMjBzb2x1dGlvbiUyMHNlY3Rpb24lMEElMjAlMjAlMjAlMjBmbGFncyUzRHJlLk1VTFRJTElORSUyMCU3QyUyMHJlLkRPVEFMTCUyQyUyMCUyMCUyMyUyMEZsZXhpYmxlJTIwcGF0dGVybiUyMG1hdGNoaW5nJTBBKQ==",highlighted:`<span class="hljs-comment"># Compiled regex patterns for efficient reward computation</span>
match_format = re.<span class="hljs-built_in">compile</span>(
    <span class="hljs-string">rf&quot;^[\\s]{{0,}}&quot;</span>  <span class="hljs-comment"># Optional whitespace at start</span>
    <span class="hljs-string">rf&quot;<span class="hljs-subst">{reasoning_start}</span>.+?<span class="hljs-subst">{reasoning_end}</span>.*?&quot;</span>  <span class="hljs-comment"># Reasoning section (non-greedy)</span>
    <span class="hljs-string">rf&quot;<span class="hljs-subst">{solution_start}</span>(.+?)<span class="hljs-subst">{solution_end}</span>&quot;</span>  <span class="hljs-comment"># Solution section with capture group</span>
    <span class="hljs-string">rf&quot;[\\s]{{0,}}$&quot;</span>,  <span class="hljs-comment"># Optional whitespace at end</span>
    flags=re.MULTILINE | re.DOTALL,  <span class="hljs-comment"># Multi-line matching with . matching newlines</span>
)

match_numbers = re.<span class="hljs-built_in">compile</span>(
    <span class="hljs-string">rf&quot;<span class="hljs-subst">{solution_start}</span>.*?([\\d\\.]{{1,}})&quot;</span>,  <span class="hljs-comment"># Extract numbers from solution section</span>
    flags=re.MULTILINE | re.DOTALL,  <span class="hljs-comment"># Flexible pattern matching</span>
)`,wrap:!1}}),D=new r({props:{code:"JTIzJTIwUmV3YXJkJTIwRnVuY3Rpb24lMjAxJTNBJTIwRXhhY3QlMjBGb3JtYXQlMjBDb21wbGlhbmNlJTBBZGVmJTIwbWF0Y2hfZm9ybWF0X2V4YWN0bHkoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBIaWdoJTIwcmV3YXJkJTIwKDMuMCklMjBmb3IlMjBwZXJmZWN0JTIwZm9ybWF0JTIwYWRoZXJlbmNlJTBBJTIwJTIwJTIwJTIwRW5zdXJlcyUyMG1vZGVsJTIwbGVhcm5zJTIwdGhlJTIwY29tcGxldGUlMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTIwcGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGNvbXBsZXRpb24lMjBpbiUyMGNvbXBsZXRpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBjb21wbGV0aW9uJTVCMCU1RCU1QiUyMmNvbnRlbnQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDaGVjayUyMGlmJTIwcmVzcG9uc2UlMjBtYXRjaGVzJTIwY29tcGxldGUlMjBmb3JtYXQlMjBwYXR0ZXJuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlM0QlMjAzLjAlMjBpZiUyMG1hdGNoX2Zvcm1hdC5zZWFyY2gocmVzcG9uc2UpJTIwaXMlMjBub3QlMjBOb25lJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3Jlcy5hcHBlbmQoc2NvcmUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NvcmVz",highlighted:`<span class="hljs-comment"># Reward Function 1: Exact Format Compliance</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">match_format_exactly</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    High reward (3.0) for perfect format adherence
    Ensures model learns the complete structured output pattern
    &quot;&quot;&quot;</span>
    scores = []
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions:
        response = completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>]
        <span class="hljs-comment"># Check if response matches complete format pattern</span>
        score = <span class="hljs-number">3.0</span> <span class="hljs-keyword">if</span> match_format.search(response) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span>
        scores.append(score)
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),P=new r({props:{code:"JTIzJTIwUmV3YXJkJTIwRnVuY3Rpb24lMjAyJTNBJTIwUGFydGlhbCUyMEZvcm1hdCUyMENyZWRpdCUwQWRlZiUyMG1hdGNoX2Zvcm1hdF9hcHByb3hpbWF0ZWx5KGNvbXBsZXRpb25zJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwR3JhZHVhdGVkJTIwc2NvcmluZyUyMGZvciUyMGZvcm1hdCUyMGVsZW1lbnRzJTBBJTIwJTIwJTIwJTIwRW5jb3VyYWdlcyUyMGxlYXJuaW5nJTIwaW5kaXZpZHVhbCUyMGNvbXBvbmVudHMlMjBldmVuJTIwaWYlMjBub3QlMjBwZXJmZWN0JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwc2NvcmVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGNvbXBsZXRpb24lNUIwJTVEJTVCJTIyY29udGVudCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwMCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEF3YXJkJTIwJTJCMC41JTIwZm9yJTIwY29ycmVjdCUyMHRva2VuJTIwY291bnQlMkMlMjAtMC41JTIwZm9yJTIwd3JvbmclMjBjb3VudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTJCJTNEJTIwMC41JTIwaWYlMjByZXNwb25zZS5jb3VudChyZWFzb25pbmdfc3RhcnQpJTIwJTNEJTNEJTIwMSUyMGVsc2UlMjAtMC41JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlMkIlM0QlMjAwLjUlMjBpZiUyMHJlc3BvbnNlLmNvdW50KHJlYXNvbmluZ19lbmQpJTIwJTNEJTNEJTIwMSUyMGVsc2UlMjAtMC41JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlMkIlM0QlMjAwLjUlMjBpZiUyMHJlc3BvbnNlLmNvdW50KHNvbHV0aW9uX3N0YXJ0KSUyMCUzRCUzRCUyMDElMjBlbHNlJTIwLTAuNSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTJCJTNEJTIwMC41JTIwaWYlMjByZXNwb25zZS5jb3VudChzb2x1dGlvbl9lbmQpJTIwJTNEJTNEJTIwMSUyMGVsc2UlMjAtMC41JTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmVzLmFwcGVuZChzY29yZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZXM=",highlighted:`<span class="hljs-comment"># Reward Function 2: Partial Format Credit</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">match_format_approximately</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Graduated scoring for format elements
    Encourages learning individual components even if not perfect
    &quot;&quot;&quot;</span>
    scores = []
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions:
        response = completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>]
        score = <span class="hljs-number">0</span>

        <span class="hljs-comment"># Award +0.5 for correct token count, -0.5 for wrong count</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(reasoning_start) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(reasoning_end) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(solution_start) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(solution_end) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>

        scores.append(score)
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),O=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Reward Function 3: Mathematical Accuracy</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_answer_correctness</span>(<span class="hljs-params">prompts, completions, answer, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Graduated scoring for mathematical accuracy:
    - 3.0: Exact match
    - 1.5: Within 10% (close answer)
    - 0.5: Within 20% (reasonable attempt)
    - -0.5: Wrong answer (penalty for incorrect math)
    &quot;&quot;&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]

    <span class="hljs-comment"># Extract answers using format pattern</span>
    extracted_responses = [
        guess.group(<span class="hljs-number">1</span>) <span class="hljs-keyword">if</span> (guess := match_format.search(r)) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses
    ]

    scores = []
    <span class="hljs-keyword">for</span> guess, true_answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(extracted_responses, answer):
        <span class="hljs-keyword">if</span> guess <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:  <span class="hljs-comment"># No extractable answer</span>
            scores.append(<span class="hljs-number">0</span>)
            <span class="hljs-keyword">continue</span>

        <span class="hljs-comment"># Exact string match gets full points</span>
        <span class="hljs-keyword">if</span> guess.strip() == true_answer.strip():
            scores.append(<span class="hljs-number">3.0</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-comment"># Try numerical comparison for partial credit</span>
            <span class="hljs-keyword">try</span>:
                ratio = <span class="hljs-built_in">float</span>(guess) / <span class="hljs-built_in">float</span>(true_answer)
                <span class="hljs-keyword">if</span> <span class="hljs-number">0.9</span> &lt;= ratio &lt;= <span class="hljs-number">1.1</span>:  <span class="hljs-comment"># Within 10%</span>
                    scores.append(<span class="hljs-number">1.5</span>)
                <span class="hljs-keyword">elif</span> <span class="hljs-number">0.8</span> &lt;= ratio &lt;= <span class="hljs-number">1.2</span>:  <span class="hljs-comment"># Within 20%</span>
                    scores.append(<span class="hljs-number">0.5</span>)
                <span class="hljs-keyword">else</span>:  <span class="hljs-comment"># Wrong answer</span>
                    scores.append(-<span class="hljs-number">0.5</span>)
            <span class="hljs-keyword">except</span> (ValueError, ZeroDivisionError):
                scores.append(-<span class="hljs-number">0.5</span>)  <span class="hljs-comment"># Invalid numerical format</span>

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),ll=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Reward Function 4: Number Extraction Ability</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_numbers_extraction</span>(<span class="hljs-params">prompts, completions, answer, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Tests the model&#x27;s ability to extract numerical values from solution sections
    Complementary to exact format matching - focuses on parsing capability
    &quot;&quot;&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]

    <span class="hljs-comment"># Extract numbers from solution sections using number pattern</span>
    extracted_responses = [
        guess.group(<span class="hljs-number">1</span>) <span class="hljs-keyword">if</span> (guess := match_numbers.search(r)) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses
    ]

    scores = []
    <span class="hljs-keyword">for</span> guess, true_answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(extracted_responses, answer):
        <span class="hljs-keyword">if</span> guess <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:  <span class="hljs-comment"># No extractable number</span>
            scores.append(<span class="hljs-number">0</span>)
            <span class="hljs-keyword">continue</span>

        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># Simple numerical equality check</span>
            true_val = <span class="hljs-built_in">float</span>(true_answer.strip())
            guess_val = <span class="hljs-built_in">float</span>(guess.strip())
            <span class="hljs-comment"># Binary scoring: correct (1.5) or incorrect (0)</span>
            scores.append(<span class="hljs-number">1.5</span> <span class="hljs-keyword">if</span> guess_val == true_val <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span>)
        <span class="hljs-keyword">except</span> (ValueError, TypeError):
            scores.append(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Invalid number format</span>

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),sl=new U({props:{title:"GRPO Training Setup",local:"grpo-training-setup",headingTag:"h2"}}),nl=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Configure GRPO training parameters for mathematical reasoning</span>
training_args = GRPOConfig(
    <span class="hljs-comment"># Learning parameters optimized for reasoning tasks</span>
    learning_rate=<span class="hljs-number">5e-6</span>,  <span class="hljs-comment"># Conservative LR to prevent destabilizing reasoning</span>
    <span class="hljs-comment"># Memory-efficient batch configuration</span>
    per_device_train_batch_size=<span class="hljs-number">2</span>,  <span class="hljs-comment"># Small batch for GPU memory constraints</span>
    gradient_accumulation_steps=<span class="hljs-number">8</span>,  <span class="hljs-comment"># Effective batch size = 2 * 8 = 16</span>
    <span class="hljs-comment"># Sequence length limits for mathematical problems</span>
    max_prompt_length=<span class="hljs-number">1024</span>,  <span class="hljs-comment"># Sufficient for complex word problems</span>
    max_completion_length=<span class="hljs-number">1024</span>,  <span class="hljs-comment"># Room for detailed step-by-step reasoning</span>
    <span class="hljs-comment"># Training duration and monitoring</span>
    max_steps=<span class="hljs-number">10</span>,  <span class="hljs-comment"># Short demo run (increase to 500+ for production)</span>
    logging_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Log metrics every step for close monitoring</span>
    <span class="hljs-comment"># Stability and output configuration</span>
    output_dir=<span class="hljs-string">&quot;./trl_grpo_outputs&quot;</span>,
    max_grad_norm=<span class="hljs-number">0.1</span>,  <span class="hljs-comment"># Aggressive gradient clipping for stable training</span>
    report_to=<span class="hljs-string">&quot;trackio&quot;</span>,  <span class="hljs-comment"># use trackio for experiment tracking (instead of wandb/tensorboard)</span>
)`,wrap:!1}}),tl=new r({props:{code:"JTIzJTIwQ3JlYXRlJTIwdW5pcXVlJTIwcnVuJTIwbmFtZSUyMHdpdGglMjB0aW1lc3RhbXAlMjB0byUyMGVuc3VyZSUyMGZyZXNoJTIwdHJhY2tpbmclMEFpbXBvcnQlMjBkYXRldGltZSUwQSUwQXRpbWVzdGFtcCUyMCUzRCUyMGRhdGV0aW1lLmRhdGV0aW1lLm5vdygpLnN0cmZ0aW1lKCUyMiUyNVklMjVtJTI1ZC0lMjVIJTI1TSUyNVMlMjIpJTBBcnVuX25hbWUlMjAlM0QlMjBmJTIycXdlbjIuNS0zYi1nc204ay1ncnBvLSU3QnRpbWVzdGFtcCU3RCUyMiUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0cmFja2lvJTIwZXhwZXJpbWVudCUyMHRyYWNraW5nJTIwd2l0aCUyMHVuaXF1ZSUyMHJ1biUyMG5hbWUlMEF0cmFja2lvLmluaXQoJTBBJTIwJTIwJTIwJTIwcHJvamVjdCUzRCUyMkdSUE8tTWF0aGVtYXRpY2FsLVJlYXNvbmluZyUyMiUyQyUyMCUyMCUyMyUyMFByb2plY3QlMjBuYW1lJTIwZm9yJTIwb3JnYW5pemF0aW9uJTBBJTIwJTIwJTIwJTIwbmFtZSUzRHJ1bl9uYW1lJTJDJTIwJTIwJTIzJTIwVW5pcXVlJTIwcnVuJTIwaWRlbnRpZmllciUyMHdpdGglMjB0aW1lc3RhbXAlMEElMjAlMjAlMjAlMjBjb25maWclM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNb2RlbCUyMGFuZCUyMGRhdGFzZXQlMjBjb25maWd1cmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMlF3ZW4lMkZRd2VuMi41LTNCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCUyMkdTTThLJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVjaG5pcXVlJTIyJTNBJTIwJTIyR1JQTyUyMCUyQiUyMExvUkElMjAlMkIlMjA0LWJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyYWluaW5nJTIwaHlwZXJwYXJhbWV0ZXJzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMHRyYWluaW5nX2FyZ3MubGVhcm5pbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJhdGNoX3NpemUlMjIlM0ElMjB0cmFpbmluZ19hcmdzLnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMiUzQSUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWZmZWN0aXZlX2JhdGNoX3NpemUlMjIlM0ElMjB0cmFpbmluZ19hcmdzLnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMColMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9zdGVwcyUyMiUzQSUyMHRyYWluaW5nX2FyZ3MubWF4X3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9SQSUyMGNvbmZpZ3VyYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3JhX3IlMjIlM0ElMjAxNiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxvcmFfYWxwaGElMjIlM0ElMjAzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEdSUE8tc3BlY2lmaWMlMjBzZXR0aW5ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9nZW5lcmF0aW9ucyUyMiUzQSUyMHRyYWluaW5nX2FyZ3MubnVtX2dlbmVyYXRpb25zJTJDJTIwJTIwJTIzJTIwRGVmYXVsdCUzQSUyMDglMjBnZW5lcmF0aW9ucyUyMHBlciUyMHN0ZXAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfcHJvbXB0X2xlbmd0aCUyMiUzQSUyMHRyYWluaW5nX2FyZ3MubWF4X3Byb21wdF9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfY29tcGxldGlvbl9sZW5ndGglMjIlM0ElMjB0cmFpbmluZ19hcmdzLm1heF9jb21wbGV0aW9uX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFJld2FyZCUyMHN5c3RlbSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9yZXdhcmRfZnVuY3Rpb25zJTIyJTNBJTIwNCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEFwcmludCglMjIlRjAlOUYlOEUlQUYlMjBHUlBPJTIwQ29uZmlndXJhdGlvbiUyMFN1bW1hcnklM0ElMjIpJTBBcHJpbnQoZiUyMiUyMCUyMCUyMExlYXJuaW5nJTIwcmF0ZSUzQSUyMCU3QnRyYWluaW5nX2FyZ3MubGVhcm5pbmdfcmF0ZSU3RCUyMiklMEFwcmludCglMEElMjAlMjAlMjAlMjBmJTIyJTIwJTIwJTIwRWZmZWN0aXZlJTIwYmF0Y2glMjBzaXplJTNBJTIwJTdCdHJhaW5pbmdfYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAqJTIwdHJhaW5pbmdfYXJncy5ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlN0QlMjIlMEEpJTBBcHJpbnQoZiUyMiUyMCUyMCUyMFRyYWluaW5nJTIwc3RlcHMlM0ElMjAlN0J0cmFpbmluZ19hcmdzLm1heF9zdGVwcyU3RCUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwR2VuZXJhdGlvbnMlMjBwZXIlMjBzdGVwJTNBJTIwJTdCdHJhaW5pbmdfYXJncy5udW1fZ2VuZXJhdGlvbnMlN0QlMjIpJTBBcHJpbnQoZiUyMiVFMiU5QyU4NSUyMFRyYWNraW8lMjBleHBlcmltZW50JTIwdHJhY2tpbmclMjBpbml0aWFsaXplZCUyMiklMEFwcmludChmJTIyJUYwJTlGJTkzJThBJTIwUnVuJTIwbmFtZSUzQSUyMCU3QnJ1bl9uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># Create unique run name with timestamp to ensure fresh tracking</span>
<span class="hljs-keyword">import</span> datetime

timestamp = datetime.datetime.now().strftime(<span class="hljs-string">&quot;%Y%m%d-%H%M%S&quot;</span>)
run_name = <span class="hljs-string">f&quot;qwen2.5-3b-gsm8k-grpo-<span class="hljs-subst">{timestamp}</span>&quot;</span>

<span class="hljs-comment"># Initialize trackio experiment tracking with unique run name</span>
trackio.init(
    project=<span class="hljs-string">&quot;GRPO-Mathematical-Reasoning&quot;</span>,  <span class="hljs-comment"># Project name for organization</span>
    name=run_name,  <span class="hljs-comment"># Unique run identifier with timestamp</span>
    config={
        <span class="hljs-comment"># Model and dataset configuration</span>
        <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Qwen/Qwen2.5-3B-Instruct&quot;</span>,
        <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;GSM8K&quot;</span>,
        <span class="hljs-string">&quot;technique&quot;</span>: <span class="hljs-string">&quot;GRPO + LoRA + 4-bit&quot;</span>,
        <span class="hljs-comment"># Training hyperparameters</span>
        <span class="hljs-string">&quot;learning_rate&quot;</span>: training_args.learning_rate,
        <span class="hljs-string">&quot;batch_size&quot;</span>: training_args.per_device_train_batch_size,
        <span class="hljs-string">&quot;gradient_accumulation_steps&quot;</span>: training_args.gradient_accumulation_steps,
        <span class="hljs-string">&quot;effective_batch_size&quot;</span>: training_args.per_device_train_batch_size * training_args.gradient_accumulation_steps,
        <span class="hljs-string">&quot;max_steps&quot;</span>: training_args.max_steps,
        <span class="hljs-comment"># LoRA configuration</span>
        <span class="hljs-string">&quot;lora_r&quot;</span>: <span class="hljs-number">16</span>,
        <span class="hljs-string">&quot;lora_alpha&quot;</span>: <span class="hljs-number">32</span>,
        <span class="hljs-comment"># GRPO-specific settings</span>
        <span class="hljs-string">&quot;num_generations&quot;</span>: training_args.num_generations,  <span class="hljs-comment"># Default: 8 generations per step</span>
        <span class="hljs-string">&quot;max_prompt_length&quot;</span>: training_args.max_prompt_length,
        <span class="hljs-string">&quot;max_completion_length&quot;</span>: training_args.max_completion_length,
        <span class="hljs-comment"># Reward system</span>
        <span class="hljs-string">&quot;num_reward_functions&quot;</span>: <span class="hljs-number">4</span>,
    },
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎯 GRPO Configuration Summary:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Learning rate: <span class="hljs-subst">{training_args.learning_rate}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;   Effective batch size: <span class="hljs-subst">{training_args.per_device_train_batch_size * training_args.gradient_accumulation_steps}</span>&quot;</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Training steps: <span class="hljs-subst">{training_args.max_steps}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Generations per step: <span class="hljs-subst">{training_args.num_generations}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Trackio experiment tracking initialized&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Run name: <span class="hljs-subst">{run_name}</span>&quot;</span>)`,wrap:!1}}),el=new U({props:{title:"Trainer Initialization with Trackio Integration",local:"trainer-initialization-with-trackio-integration",headingTag:"h2"}}),pl=new r({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMEdSUE8lMjB0cmFpbmVyJTIwd2l0aCUyMG11bHRpLXJld2FyZCUyMHN5c3RlbSUwQSUyMyUyMHRyYWNraW9fY2FsbGJhY2slMjAlM0QlMjBUcmFja2lvQ2FsbGJhY2soKSUyMCUyMCUyMyUyMENyZWF0ZSUyMHRyYWNraW8lMjBsb2dnaW5nJTIwY2FsbGJhY2slMEElMEF0cmFpbmVyJTIwJTNEJTIwR1JQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMCUyMCUyMyUyMExvUkEtYWRhcHRlZCUyMHF1YW50aXplZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV3YXJkX2Z1bmNzJTNEJTVCJTIwJTIwJTIzJTIwRm91ciUyMGNvbXBsZW1lbnRhcnklMjByZXdhcmQlMjBmdW5jdGlvbnMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXRjaF9mb3JtYXRfZXhhY3RseSUyQyUyMCUyMCUyMyUyMFBlcmZlY3QlMjBzdHJ1Y3R1cmUlMjBjb21wbGlhbmNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF0Y2hfZm9ybWF0X2FwcHJveGltYXRlbHklMkMlMjAlMjAlMjMlMjBQYXJ0aWFsJTIwZm9ybWF0JTIwY3JlZGl0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hlY2tfYW5zd2VyX2NvcnJlY3RuZXNzJTJDJTIwJTIwJTIzJTIwTWF0aGVtYXRpY2FsJTIwYWNjdXJhY3klMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaGVja19udW1iZXJzX2V4dHJhY3Rpb24lMkMlMjAlMjAlMjMlMjBOdW1iZXIlMjBwYXJzaW5nJTIwYWJpbGl0eSUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwJTIwJTIzJTIwVHJhaW5pbmclMjBjb25maWd1cmF0aW9uJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMjAlMjAlMjMlMjBQcm9jZXNzZWQlMjBHU004SyUyMGRhdGFzZXQlMEEpJTBBJTBBcHJpbnQoJTIyJUUyJTlDJTg1JTIwR1JQTyUyMFRyYWluZXIlMjBpbml0aWFsaXplZCUyMHN1Y2Nlc3NmdWxseSElMjIpJTBBcHJpbnQoZiUyMiVGMCU5RiU5MyU4QSUyMFRyYWluaW5nJTIwZGF0YXNldCUzQSUyMCU3QmxlbihkYXRhc2V0KSUzQSUyQyU3RCUyMGV4YW1wbGVzJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOEUlQUYlMjBSZXdhcmQlMjBmdW5jdGlvbnMlM0ElMjAlN0JsZW4odHJhaW5lci5yZXdhcmRfZnVuY3MpJTdEJTIwYWN0aXZlJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOTMlODglMjBUcmFja2lvJTIwaW50ZWdyYXRpb24lM0ElMjBFbmFibGVkJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOTQlODQlMjBSZWFkeSUyMGZvciUyMHRyYWluaW5nJTIwd2l0aCUyMCU3QnRyYWluaW5nX2FyZ3MubnVtX2dlbmVyYXRpb25zJTdEJTIwZ2VuZXJhdGlvbnMlMjBwZXIlMjBzdGVwJTIyKQ==",highlighted:`<span class="hljs-comment"># Initialize GRPO trainer with multi-reward system</span>
<span class="hljs-comment"># trackio_callback = TrackioCallback()  # Create trackio logging callback</span>

trainer = GRPOTrainer(
    model=model,  <span class="hljs-comment"># LoRA-adapted quantized model</span>
    reward_funcs=[  <span class="hljs-comment"># Four complementary reward functions</span>
        match_format_exactly,  <span class="hljs-comment"># Perfect structure compliance</span>
        match_format_approximately,  <span class="hljs-comment"># Partial format credit</span>
        check_answer_correctness,  <span class="hljs-comment"># Mathematical accuracy</span>
        check_numbers_extraction,  <span class="hljs-comment"># Number parsing ability</span>
    ],
    args=training_args,  <span class="hljs-comment"># Training configuration</span>
    train_dataset=dataset,  <span class="hljs-comment"># Processed GSM8K dataset</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ GRPO Trainer initialized successfully!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Training dataset: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span> examples&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Reward functions: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(trainer.reward_funcs)}</span> active&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📈 Trackio integration: Enabled&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔄 Ready for training with <span class="hljs-subst">{training_args.num_generations}</span> generations per step&quot;</span>)`,wrap:!1}}),yl=new U({props:{title:"Begin GRPO Training",local:"begin-grpo-training",headingTag:"h2"}}),cl=new r({props:{code:"JTIzJTIwRXhlY3V0ZSUyMEdSUE8lMjB0cmFpbmluZyUyMHdpdGglMjBtdWx0aS1yZXdhcmQlMjBvcHRpbWl6YXRpb24lMEFwcmludCglMjIlRjAlOUYlOUElODAlMjBTdGFydGluZyUyMEdSUE8lMjB0cmFpbmluZy4uLiUyMiklMEFwcmludCglMjIlRjAlOUYlOTMlOEElMjBNb25pdG9yJTIwbWV0cmljcyUzQSUyMHJld2FyZCUyMHNjb3JlcyUyQyUyMEtMJTIwZGl2ZXJnZW5jZSUyQyUyMHBvbGljeSUyMGdyYWRpZW50cyUyMiklMEFwcmludCglMjIlRjAlOUYlOTQlOEQlMjBUcmFja2lvJTIwd2lsbCUyMGxvZyUzQSUyMGxvc3NlcyUyQyUyMHJld2FyZHMlMkMlMjBsZWFybmluZyUyMHJhdGUlMkMlMjBncmFkaWVudHMlMjIpJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwdHJhaW5pbmclMjBwcm9jZXNzJTBBdHJhaW5lci50cmFpbigpJTBBJTBBJTIzJTIwQ29tcGxldGUlMjB0aGUlMjB0cmFja2lvJTIwZXhwZXJpbWVudCUwQXRyYWNraW8uZmluaXNoKCklMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBUcmFpbmluZyUyMGNvbXBsZXRlZCUyMHN1Y2Nlc3NmdWxseSElMjIpJTBBcHJpbnQoZiUyMiVGMCU5RiU5MiVCRSUyME1vZGVsJTIwc2F2ZWQlMjB0byUzQSUyMCU3QnRyYWluaW5nX2FyZ3Mub3V0cHV0X2RpciU3RCUyMik=",highlighted:`<span class="hljs-comment"># Execute GRPO training with multi-reward optimization</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🚀 Starting GRPO training...&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📊 Monitor metrics: reward scores, KL divergence, policy gradients&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔍 Trackio will log: losses, rewards, learning rate, gradients&quot;</span>)

<span class="hljs-comment"># Run the training process</span>
trainer.train()

<span class="hljs-comment"># Complete the trackio experiment</span>
trackio.finish()

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Training completed successfully!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;💾 Model saved to: <span class="hljs-subst">{training_args.output_dir}</span>&quot;</span>)`,wrap:!1}}),Jl=new U({props:{title:"Experiment Dashboard",local:"experiment-dashboard",headingTag:"h2"}}),ol=new r({props:{code:"JTIzJTIwTGF1bmNoJTIwaW50ZXJhY3RpdmUlMjB0cmFja2lvJTIwZGFzaGJvYXJkJTIwZm9yJTIwZXhwZXJpbWVudCUyMGFuYWx5c2lzJTBBJTIzJTIwVmlldyUyMHRyYWluaW5nJTIwY3VydmVzJTJDJTIwcmV3YXJkJTIwcHJvZ3Jlc3Npb24lMkMlMjBsb3NzJTIwZXZvbHV0aW9uJTJDJTIwYW5kJTIwaHlwZXJwYXJhbWV0ZXIlMjBlZmZlY3RzJTBBdHJhY2tpby5zaG93KHByb2plY3QlM0QlMjJHUlBPLU1hdGhlbWF0aWNhbC1SZWFzb25pbmclMjIpJTBBJTBBJTBBJTIzJTIwQWx0ZXJuYXRpdmUlM0ElMjBMYXVuY2glMjBmcm9tJTIwY29tbWFuZCUyMGxpbmUlMjB3aXRoJTNBJTIwdHJhY2tpbyUyMHNob3clMjAtLXByb2plY3QlMjAlMjJHUlBPLU1hdGhlbWF0aWNhbC1SZWFzb25pbmclMjI=",highlighted:`<span class="hljs-comment"># Launch interactive trackio dashboard for experiment analysis</span>
<span class="hljs-comment"># View training curves, reward progression, loss evolution, and hyperparameter effects</span>
trackio.show(project=<span class="hljs-string">&quot;GRPO-Mathematical-Reasoning&quot;</span>)


<span class="hljs-comment"># Alternative: Launch from command line with: trackio show --project &quot;GRPO-Mathematical-Reasoning&quot;</span>`,wrap:!1}}),rl=new U({props:{title:"Model Evaluation and Testing",local:"model-evaluation-and-testing",headingTag:"h2"}}),Ul=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Define model testing function with optimized generation parameters</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_model</span>(<span class="hljs-params">question, max_length=<span class="hljs-number">512</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Test the trained model on mathematical questions

    Args:
        question (str): Mathematical problem to solve
        max_length (int): Maximum tokens to generate

    Returns:
        str: Model&#x27;s structured response with reasoning and solution
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Format input using conversation template</span>
    messages = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
    ]

    <span class="hljs-comment"># Apply chat template and tokenize</span>
    text = tokenizer.apply_chat_template(
        messages,
        add_generation_prompt=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Add assistant prompt</span>
        tokenize=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># Return string, not tokens</span>
    )

    <span class="hljs-comment"># Tokenize and move to appropriate device</span>
    inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤔 Processing: <span class="hljs-subst">{question}</span>&quot;</span>)

    <span class="hljs-comment"># Generate response with reasoning-optimized parameters</span>
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model.generate(
            **inputs,
            max_new_tokens=max_length,
            temperature=<span class="hljs-number">0.7</span>,  <span class="hljs-comment"># Balance creativity and consistency</span>
            do_sample=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable sampling for varied reasoning paths</span>
            top_p=<span class="hljs-number">0.9</span>,  <span class="hljs-comment"># Nucleus sampling for quality</span>
            pad_token_id=tokenizer.eos_token_id,
            repetition_penalty=<span class="hljs-number">1.1</span>,  <span class="hljs-comment"># Reduce repetitive reasoning steps</span>
            length_penalty=<span class="hljs-number">1.0</span>,  <span class="hljs-comment"># Neutral preference for response length</span>
            early_stopping=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Stop at natural completion</span>
        )

    <span class="hljs-comment"># Decode and extract only the generated portion</span>
    response = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
    generated_text = response[<span class="hljs-built_in">len</span>(text) :].strip()

    <span class="hljs-keyword">return</span> generated_text`,wrap:!1}}),ml=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Test model on GSM8K problem</span>
gsm8k_question = <span class="hljs-string">&quot;Natalia sold clips to 48 of her friends in April, and then she sold half as many clips in May. How many clips did Natalia sell altogether in April and May?&quot;</span>
expected_answer = <span class="hljs-string">&quot;72&quot;</span>

<span class="hljs-comment"># Generate response</span>
gsm8k_response = test_model(gsm8k_question, max_length=<span class="hljs-number">768</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{gsm8k_question}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model Response:\\n<span class="hljs-subst">{gsm8k_response}</span>&quot;</span>)

<span class="hljs-comment"># Validate format compliance</span>
has_reasoning = reasoning_start <span class="hljs-keyword">in</span> gsm8k_response <span class="hljs-keyword">and</span> reasoning_end <span class="hljs-keyword">in</span> gsm8k_response
has_solution = solution_start <span class="hljs-keyword">in</span> gsm8k_response <span class="hljs-keyword">and</span> solution_end <span class="hljs-keyword">in</span> gsm8k_response

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nFormat Check:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Reasoning section: <span class="hljs-subst">{has_reasoning}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Solution section: <span class="hljs-subst">{has_solution}</span>&quot;</span>)

<span class="hljs-comment"># Check answer accuracy if solution section exists</span>
<span class="hljs-keyword">if</span> has_solution:
    <span class="hljs-keyword">try</span>:
        solution_text = gsm8k_response.split(solution_start)[<span class="hljs-number">1</span>].split(solution_end)[<span class="hljs-number">0</span>].strip()
        extracted_number = <span class="hljs-string">&quot;&quot;</span>.join(<span class="hljs-built_in">filter</span>(<span class="hljs-built_in">str</span>.isdigit, solution_text))
        expected_number = <span class="hljs-string">&quot;&quot;</span>.join(<span class="hljs-built_in">filter</span>(<span class="hljs-built_in">str</span>.isdigit, expected_answer))
        is_correct = extracted_number == expected_number

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Extracted: <span class="hljs-subst">{solution_text}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Expected: <span class="hljs-subst">{expected_answer}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Correct: <span class="hljs-subst">{is_correct}</span>&quot;</span>)
    <span class="hljs-keyword">except</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Could not extract solution&quot;</span>)`,wrap:!1}}),wl=new U({props:{title:"Clean Up Resources",local:"clean-up-resources",headingTag:"h2"}}),Il=new r({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBJTBBZGVmJTIwcmVtb3ZlX3RyYWNraW9fcHJvamVjdChwcm9qZWN0X25hbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUmVtb3ZlJTIwYSUyMHRyYWNraW8lMjBwcm9qZWN0JTIwYnklMjBkZWxldGluZyUyMGl0cyUyMGRhdGFiYXNlJTIwZmlsZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGNhY2hlX2RpciUyMCUzRCUyMFBhdGguaG9tZSgpJTIwJTJGJTIwJTIyLmNhY2hlJTIyJTIwJTJGJTIwJTIyaHVnZ2luZ2ZhY2UlMjIlMjAlMkYlMjAlMjJ0cmFja2lvJTIyJTBBJTIwJTIwJTIwJTIwZGJfZmlsZSUyMCUzRCUyMGNhY2hlX2RpciUyMCUyRiUyMGYlMjIlN0Jwcm9qZWN0X25hbWUlN0QuZGIlMjIlMEElMEElMjAlMjAlMjAlMjBpZiUyMGRiX2ZpbGUuZXhpc3RzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYl9maWxlLnVubGluaygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlJlbW92ZWQlMjB0cmFja2lvJTIwcHJvamVjdCUzQSUyMCU3QnByb2plY3RfbmFtZSU3RCUyMiklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlByb2plY3QlMjBub3QlMjBmb3VuZCUzQSUyMCU3QnByb2plY3RfbmFtZSU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path


<span class="hljs-keyword">def</span> <span class="hljs-title function_">remove_trackio_project</span>(<span class="hljs-params">project_name</span>):
    <span class="hljs-string">&quot;&quot;&quot;Remove a trackio project by deleting its database file&quot;&quot;&quot;</span>
    cache_dir = Path.home() / <span class="hljs-string">&quot;.cache&quot;</span> / <span class="hljs-string">&quot;huggingface&quot;</span> / <span class="hljs-string">&quot;trackio&quot;</span>
    db_file = cache_dir / <span class="hljs-string">f&quot;<span class="hljs-subst">{project_name}</span>.db&quot;</span>

    <span class="hljs-keyword">if</span> db_file.exists():
        db_file.unlink()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Removed trackio project: <span class="hljs-subst">{project_name}</span>&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Project not found: <span class="hljs-subst">{project_name}</span>&quot;</span>)`,wrap:!1}}),hl=new r({props:{code:"JTIzJTIwQ2xlYW4lMjB1cCUyMHRyYWNraW8lMjBleHBlcmltZW50JTIwZGF0YWJhc2UlMjB0byUyMGZyZWUlMjBzdG9yYWdlJTIwc3BhY2UlMEElMjMlMjBXQVJOSU5HJTNBJTIwVGhpcyUyMHBlcm1hbmVudGx5JTIwZGVsZXRlcyUyMGFsbCUyMGV4cGVyaW1lbnQlMjBsb2dzJTIwYW5kJTIwbWV0cmljcyUwQXJlbW92ZV90cmFja2lvX3Byb2plY3QoJTIyR1JQTy1NYXRoZW1hdGljYWwtUmVhc29uaW5nJTIyKQ==",highlighted:`<span class="hljs-comment"># Clean up trackio experiment database to free storage space</span>
<span class="hljs-comment"># WARNING: This permanently deletes all experiment logs and metrics</span>
remove_trackio_project(<span class="hljs-string">&quot;GRPO-Mathematical-Reasoning&quot;</span>)`,wrap:!1}}),bl=new r({props:{code:"JTIzJTIwRnJlZSUyMEdQVSUyMG1lbW9yeSUyMGFuZCUyMGNsZWFyJTIwUHl0aG9uJTIwZ2FyYmFnZSUyMGNvbGxlY3Rpb24lMEFpbXBvcnQlMjBnYyUwQSUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKSUyMCUyMCUyMyUyMENsZWFyJTIwUHlUb3JjaCUyMENVREElMjBtZW1vcnklMjBjYWNoZSUwQWdjLmNvbGxlY3QoKSUyMCUyMCUyMyUyMFJ1biUyMFB5dGhvbiUyMGdhcmJhZ2UlMjBjb2xsZWN0b3IlMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBHUFUlMjBtZW1vcnklMjBjYWNoZSUyMGNsZWFyZWQlMjIpJTBBcHJpbnQoJTIyJUUyJTlDJTg1JTIwUHl0aG9uJTIwZ2FyYmFnZSUyMGNvbGxlY3Rpb24lMjBjb21wbGV0ZWQlMjIpJTBBcHJpbnQoJTIyJUYwJTlGJUE3JUI5JTIwUmVzb3VyY2VzJTIwZnJlZWQlMjBmb3IlMjBvdGhlciUyMHByb2Nlc3NlcyUyMik=",highlighted:`<span class="hljs-comment"># Free GPU memory and clear Python garbage collection</span>
<span class="hljs-keyword">import</span> gc

torch.cuda.empty_cache()  <span class="hljs-comment"># Clear PyTorch CUDA memory cache</span>
gc.collect()  <span class="hljs-comment"># Run Python garbage collector</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ GPU memory cache cleared&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Python garbage collection completed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🧹 Resources freed for other processes&quot;</span>)`,wrap:!1}}),dl=new U({props:{title:"References",local:"references",headingTag:"h2"}}),Cl=new U({props:{title:"Papers and Research",local:"papers-and-research",headingTag:"h3"}}),gl=new U({props:{title:"Libraries and Frameworks",local:"libraries-and-frameworks",headingTag:"h3"}}),Gl=new U({props:{title:"Models Used",local:"models-used",headingTag:"h3"}}),fl=new U({props:{title:"Datasets",local:"datasets",headingTag:"h3"}}),Al=new U({props:{title:"Key Concepts",local:"key-concepts",headingTag:"h3"}}),Nl=new Fa({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/trl_grpo_reasoning_advanced_reward.md"}}),{c(){m=j("meta"),Ql=t(),Vl=j("p"),Fl=t(),M(w.$$.fragment),zl=t(),M(u.$$.fragment),kl=t(),I=j("p"),I.innerHTML=ta,El=t(),h=j("p"),h.innerHTML=ea,vl=t(),b=j("p"),b.innerHTML=Ma,Sl=t(),d=j("ul"),d.innerHTML=pa,Hl=t(),C=j("p"),C.textContent=ya,_l=t(),M(B.$$.fragment),ql=t(),g=j("p"),g.textContent=ia,$l=t(),M(Z.$$.fragment),xl=t(),M(G.$$.fragment),Ll=t(),W=j("p"),W.textContent=ca,Kl=t(),M(f.$$.fragment),Dl=t(),M(R.$$.fragment),Pl=t(),A=j("p"),A.textContent=Ja,Ol=t(),M(X.$$.fragment),ls=t(),M(N.$$.fragment),ss=t(),V=j("p"),V.textContent=ja,as=t(),M(Y.$$.fragment),ns=t(),M(Q.$$.fragment),ts=t(),M(F.$$.fragment),es=t(),M(z.$$.fragment),Ms=t(),k=j("p"),k.textContent=oa,ps=t(),M(E.$$.fragment),ys=t(),M(v.$$.fragment),is=t(),S=j("p"),S.textContent=ra,cs=t(),M(H.$$.fragment),Js=t(),M(_.$$.fragment),js=t(),M(q.$$.fragment),os=t(),M($.$$.fragment),rs=t(),x=j("p"),x.textContent=Ta,Ts=t(),L=j("ol"),L.innerHTML=Ua,Us=t(),M(K.$$.fragment),ms=t(),M(D.$$.fragment),ws=t(),M(P.$$.fragment),us=t(),M(O.$$.fragment),Is=t(),M(ll.$$.fragment),hs=t(),M(sl.$$.fragment),bs=t(),al=j("p"),al.textContent=ma,ds=t(),M(nl.$$.fragment),Cs=t(),M(tl.$$.fragment),Bs=t(),M(el.$$.fragment),gs=t(),Ml=j("p"),Ml.textContent=wa,Zs=t(),M(pl.$$.fragment),Gs=t(),M(yl.$$.fragment),Ws=t(),il=j("p"),il.textContent=ua,fs=t(),M(cl.$$.fragment),Rs=t(),M(Jl.$$.fragment),As=t(),jl=j("p"),jl.textContent=Ia,Xs=t(),M(ol.$$.fragment),Ns=t(),M(rl.$$.fragment),Vs=t(),Tl=j("p"),Tl.textContent=ha,Ys=t(),M(Ul.$$.fragment),Qs=t(),M(ml.$$.fragment),Fs=t(),M(wl.$$.fragment),zs=t(),ul=j("p"),ul.textContent=ba,ks=t(),M(Il.$$.fragment),Es=t(),M(hl.$$.fragment),vs=t(),M(bl.$$.fragment),Ss=t(),M(dl.$$.fragment),Hs=t(),M(Cl.$$.fragment),_s=t(),Bl=j("ul"),Bl.innerHTML=da,qs=t(),M(gl.$$.fragment),$s=t(),Zl=j("ul"),Zl.innerHTML=Ca,xs=t(),M(Gl.$$.fragment),Ls=t(),Wl=j("ul"),Wl.innerHTML=Ba,Ks=t(),M(fl.$$.fragment),Ds=t(),Rl=j("ul"),Rl.innerHTML=ga,Ps=t(),M(Al.$$.fragment),Os=t(),Xl=j("ul"),Xl.innerHTML=Za,la=t(),M(Nl.$$.fragment),sa=t(),Yl=j("p"),this.h()},l(l){const s=Va("svelte-u9bgzb",document.head);m=o(s,"META",{name:!0,content:!0}),s.forEach(a),Ql=e(l),Vl=o(l,"P",{}),Ga(Vl).forEach(a),Fl=e(l),p(w.$$.fragment,l),zl=e(l),p(u.$$.fragment,l),kl=e(l),I=o(l,"P",{"data-svelte-h":!0}),T(I)!=="svelte-1wcfxf7"&&(I.innerHTML=ta),El=e(l),h=o(l,"P",{"data-svelte-h":!0}),T(h)!=="svelte-6p9g8x"&&(h.innerHTML=ea),vl=e(l),b=o(l,"P",{"data-svelte-h":!0}),T(b)!=="svelte-dcww01"&&(b.innerHTML=Ma),Sl=e(l),d=o(l,"UL",{"data-svelte-h":!0}),T(d)!=="svelte-1hq0wzg"&&(d.innerHTML=pa),Hl=e(l),C=o(l,"P",{"data-svelte-h":!0}),T(C)!=="svelte-17fp8qc"&&(C.textContent=ya),_l=e(l),p(B.$$.fragment,l),ql=e(l),g=o(l,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1mnh5n9"&&(g.textContent=ia),$l=e(l),p(Z.$$.fragment,l),xl=e(l),p(G.$$.fragment,l),Ll=e(l),W=o(l,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1lu8zsw"&&(W.textContent=ca),Kl=e(l),p(f.$$.fragment,l),Dl=e(l),p(R.$$.fragment,l),Pl=e(l),A=o(l,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1ylljg7"&&(A.textContent=Ja),Ol=e(l),p(X.$$.fragment,l),ls=e(l),p(N.$$.fragment,l),ss=e(l),V=o(l,"P",{"data-svelte-h":!0}),T(V)!=="svelte-6voocq"&&(V.textContent=ja),as=e(l),p(Y.$$.fragment,l),ns=e(l),p(Q.$$.fragment,l),ts=e(l),p(F.$$.fragment,l),es=e(l),p(z.$$.fragment,l),Ms=e(l),k=o(l,"P",{"data-svelte-h":!0}),T(k)!=="svelte-vh53r0"&&(k.textContent=oa),ps=e(l),p(E.$$.fragment,l),ys=e(l),p(v.$$.fragment,l),is=e(l),S=o(l,"P",{"data-svelte-h":!0}),T(S)!=="svelte-lfycyc"&&(S.textContent=ra),cs=e(l),p(H.$$.fragment,l),Js=e(l),p(_.$$.fragment,l),js=e(l),p(q.$$.fragment,l),os=e(l),p($.$$.fragment,l),rs=e(l),x=o(l,"P",{"data-svelte-h":!0}),T(x)!=="svelte-jcs93c"&&(x.textContent=Ta),Ts=e(l),L=o(l,"OL",{"data-svelte-h":!0}),T(L)!=="svelte-1ei9pa4"&&(L.innerHTML=Ua),Us=e(l),p(K.$$.fragment,l),ms=e(l),p(D.$$.fragment,l),ws=e(l),p(P.$$.fragment,l),us=e(l),p(O.$$.fragment,l),Is=e(l),p(ll.$$.fragment,l),hs=e(l),p(sl.$$.fragment,l),bs=e(l),al=o(l,"P",{"data-svelte-h":!0}),T(al)!=="svelte-1cgqac7"&&(al.textContent=ma),ds=e(l),p(nl.$$.fragment,l),Cs=e(l),p(tl.$$.fragment,l),Bs=e(l),p(el.$$.fragment,l),gs=e(l),Ml=o(l,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-te58gc"&&(Ml.textContent=wa),Zs=e(l),p(pl.$$.fragment,l),Gs=e(l),p(yl.$$.fragment,l),Ws=e(l),il=o(l,"P",{"data-svelte-h":!0}),T(il)!=="svelte-1dre9tl"&&(il.textContent=ua),fs=e(l),p(cl.$$.fragment,l),Rs=e(l),p(Jl.$$.fragment,l),As=e(l),jl=o(l,"P",{"data-svelte-h":!0}),T(jl)!=="svelte-1r7ghy8"&&(jl.textContent=Ia),Xs=e(l),p(ol.$$.fragment,l),Ns=e(l),p(rl.$$.fragment,l),Vs=e(l),Tl=o(l,"P",{"data-svelte-h":!0}),T(Tl)!=="svelte-15chlyi"&&(Tl.textContent=ha),Ys=e(l),p(Ul.$$.fragment,l),Qs=e(l),p(ml.$$.fragment,l),Fs=e(l),p(wl.$$.fragment,l),zs=e(l),ul=o(l,"P",{"data-svelte-h":!0}),T(ul)!=="svelte-rt167n"&&(ul.textContent=ba),ks=e(l),p(Il.$$.fragment,l),Es=e(l),p(hl.$$.fragment,l),vs=e(l),p(bl.$$.fragment,l),Ss=e(l),p(dl.$$.fragment,l),Hs=e(l),p(Cl.$$.fragment,l),_s=e(l),Bl=o(l,"UL",{"data-svelte-h":!0}),T(Bl)!=="svelte-1yuqaza"&&(Bl.innerHTML=da),qs=e(l),p(gl.$$.fragment,l),$s=e(l),Zl=o(l,"UL",{"data-svelte-h":!0}),T(Zl)!=="svelte-1f7hqi0"&&(Zl.innerHTML=Ca),xs=e(l),p(Gl.$$.fragment,l),Ls=e(l),Wl=o(l,"UL",{"data-svelte-h":!0}),T(Wl)!=="svelte-1gpkmz1"&&(Wl.innerHTML=Ba),Ks=e(l),p(fl.$$.fragment,l),Ds=e(l),Rl=o(l,"UL",{"data-svelte-h":!0}),T(Rl)!=="svelte-sgvdwa"&&(Rl.innerHTML=ga),Ps=e(l),p(Al.$$.fragment,l),Os=e(l),Xl=o(l,"UL",{"data-svelte-h":!0}),T(Xl)!=="svelte-189ntwt"&&(Xl.innerHTML=Za),la=e(l),p(Nl.$$.fragment,l),sa=e(l),Yl=o(l,"P",{}),Ga(Yl).forEach(a),this.h()},h(){Wa(m,"name","hf:doc:metadata"),Wa(m,"content",ka)},m(l,s){Ya(document.head,m),n(l,Ql,s),n(l,Vl,s),n(l,Fl,s),y(w,l,s),n(l,zl,s),y(u,l,s),n(l,kl,s),n(l,I,s),n(l,El,s),n(l,h,s),n(l,vl,s),n(l,b,s),n(l,Sl,s),n(l,d,s),n(l,Hl,s),n(l,C,s),n(l,_l,s),y(B,l,s),n(l,ql,s),n(l,g,s),n(l,$l,s),y(Z,l,s),n(l,xl,s),y(G,l,s),n(l,Ll,s),n(l,W,s),n(l,Kl,s),y(f,l,s),n(l,Dl,s),y(R,l,s),n(l,Pl,s),n(l,A,s),n(l,Ol,s),y(X,l,s),n(l,ls,s),y(N,l,s),n(l,ss,s),n(l,V,s),n(l,as,s),y(Y,l,s),n(l,ns,s),y(Q,l,s),n(l,ts,s),y(F,l,s),n(l,es,s),y(z,l,s),n(l,Ms,s),n(l,k,s),n(l,ps,s),y(E,l,s),n(l,ys,s),y(v,l,s),n(l,is,s),n(l,S,s),n(l,cs,s),y(H,l,s),n(l,Js,s),y(_,l,s),n(l,js,s),y(q,l,s),n(l,os,s),y($,l,s),n(l,rs,s),n(l,x,s),n(l,Ts,s),n(l,L,s),n(l,Us,s),y(K,l,s),n(l,ms,s),y(D,l,s),n(l,ws,s),y(P,l,s),n(l,us,s),y(O,l,s),n(l,Is,s),y(ll,l,s),n(l,hs,s),y(sl,l,s),n(l,bs,s),n(l,al,s),n(l,ds,s),y(nl,l,s),n(l,Cs,s),y(tl,l,s),n(l,Bs,s),y(el,l,s),n(l,gs,s),n(l,Ml,s),n(l,Zs,s),y(pl,l,s),n(l,Gs,s),y(yl,l,s),n(l,Ws,s),n(l,il,s),n(l,fs,s),y(cl,l,s),n(l,Rs,s),y(Jl,l,s),n(l,As,s),n(l,jl,s),n(l,Xs,s),y(ol,l,s),n(l,Ns,s),y(rl,l,s),n(l,Vs,s),n(l,Tl,s),n(l,Ys,s),y(Ul,l,s),n(l,Qs,s),y(ml,l,s),n(l,Fs,s),y(wl,l,s),n(l,zs,s),n(l,ul,s),n(l,ks,s),y(Il,l,s),n(l,Es,s),y(hl,l,s),n(l,vs,s),y(bl,l,s),n(l,Ss,s),y(dl,l,s),n(l,Hs,s),y(Cl,l,s),n(l,_s,s),n(l,Bl,s),n(l,qs,s),y(gl,l,s),n(l,$s,s),n(l,Zl,s),n(l,xs,s),y(Gl,l,s),n(l,Ls,s),n(l,Wl,s),n(l,Ks,s),y(fl,l,s),n(l,Ds,s),n(l,Rl,s),n(l,Ps,s),y(Al,l,s),n(l,Os,s),n(l,Xl,s),n(l,la,s),y(Nl,l,s),n(l,sa,s),n(l,Yl,s),aa=!0},p:Ra,i(l){aa||(i(w.$$.fragment,l),i(u.$$.fragment,l),i(B.$$.fragment,l),i(Z.$$.fragment,l),i(G.$$.fragment,l),i(f.$$.fragment,l),i(R.$$.fragment,l),i(X.$$.fragment,l),i(N.$$.fragment,l),i(Y.$$.fragment,l),i(Q.$$.fragment,l),i(F.$$.fragment,l),i(z.$$.fragment,l),i(E.$$.fragment,l),i(v.$$.fragment,l),i(H.$$.fragment,l),i(_.$$.fragment,l),i(q.$$.fragment,l),i($.$$.fragment,l),i(K.$$.fragment,l),i(D.$$.fragment,l),i(P.$$.fragment,l),i(O.$$.fragment,l),i(ll.$$.fragment,l),i(sl.$$.fragment,l),i(nl.$$.fragment,l),i(tl.$$.fragment,l),i(el.$$.fragment,l),i(pl.$$.fragment,l),i(yl.$$.fragment,l),i(cl.$$.fragment,l),i(Jl.$$.fragment,l),i(ol.$$.fragment,l),i(rl.$$.fragment,l),i(Ul.$$.fragment,l),i(ml.$$.fragment,l),i(wl.$$.fragment,l),i(Il.$$.fragment,l),i(hl.$$.fragment,l),i(bl.$$.fragment,l),i(dl.$$.fragment,l),i(Cl.$$.fragment,l),i(gl.$$.fragment,l),i(Gl.$$.fragment,l),i(fl.$$.fragment,l),i(Al.$$.fragment,l),i(Nl.$$.fragment,l),aa=!0)},o(l){c(w.$$.fragment,l),c(u.$$.fragment,l),c(B.$$.fragment,l),c(Z.$$.fragment,l),c(G.$$.fragment,l),c(f.$$.fragment,l),c(R.$$.fragment,l),c(X.$$.fragment,l),c(N.$$.fragment,l),c(Y.$$.fragment,l),c(Q.$$.fragment,l),c(F.$$.fragment,l),c(z.$$.fragment,l),c(E.$$.fragment,l),c(v.$$.fragment,l),c(H.$$.fragment,l),c(_.$$.fragment,l),c(q.$$.fragment,l),c($.$$.fragment,l),c(K.$$.fragment,l),c(D.$$.fragment,l),c(P.$$.fragment,l),c(O.$$.fragment,l),c(ll.$$.fragment,l),c(sl.$$.fragment,l),c(nl.$$.fragment,l),c(tl.$$.fragment,l),c(el.$$.fragment,l),c(pl.$$.fragment,l),c(yl.$$.fragment,l),c(cl.$$.fragment,l),c(Jl.$$.fragment,l),c(ol.$$.fragment,l),c(rl.$$.fragment,l),c(Ul.$$.fragment,l),c(ml.$$.fragment,l),c(wl.$$.fragment,l),c(Il.$$.fragment,l),c(hl.$$.fragment,l),c(bl.$$.fragment,l),c(dl.$$.fragment,l),c(Cl.$$.fragment,l),c(gl.$$.fragment,l),c(Gl.$$.fragment,l),c(fl.$$.fragment,l),c(Al.$$.fragment,l),c(Nl.$$.fragment,l),aa=!1},d(l){l&&(a(Ql),a(Vl),a(Fl),a(zl),a(kl),a(I),a(El),a(h),a(vl),a(b),a(Sl),a(d),a(Hl),a(C),a(_l),a(ql),a(g),a($l),a(xl),a(Ll),a(W),a(Kl),a(Dl),a(Pl),a(A),a(Ol),a(ls),a(ss),a(V),a(as),a(ns),a(ts),a(es),a(Ms),a(k),a(ps),a(ys),a(is),a(S),a(cs),a(Js),a(js),a(os),a(rs),a(x),a(Ts),a(L),a(Us),a(ms),a(ws),a(us),a(Is),a(hs),a(bs),a(al),a(ds),a(Cs),a(Bs),a(gs),a(Ml),a(Zs),a(Gs),a(Ws),a(il),a(fs),a(Rs),a(As),a(jl),a(Xs),a(Ns),a(Vs),a(Tl),a(Ys),a(Qs),a(Fs),a(zs),a(ul),a(ks),a(Es),a(vs),a(Ss),a(Hs),a(_s),a(Bl),a(qs),a($s),a(Zl),a(xs),a(Ls),a(Wl),a(Ks),a(Ds),a(Rl),a(Ps),a(Os),a(Xl),a(la),a(sa),a(Yl)),a(m),J(w,l),J(u,l),J(B,l),J(Z,l),J(G,l),J(f,l),J(R,l),J(X,l),J(N,l),J(Y,l),J(Q,l),J(F,l),J(z,l),J(E,l),J(v,l),J(H,l),J(_,l),J(q,l),J($,l),J(K,l),J(D,l),J(P,l),J(O,l),J(ll,l),J(sl,l),J(nl,l),J(tl,l),J(el,l),J(pl,l),J(yl,l),J(cl,l),J(Jl,l),J(ol,l),J(rl,l),J(Ul,l),J(ml,l),J(wl,l),J(Il,l),J(hl,l),J(bl,l),J(dl,l),J(Cl,l),J(gl,l),J(Gl,l),J(fl,l),J(Al,l),J(Nl,l)}}}const ka='{"title":"Advanced GRPO Fine-tuning for Mathematical Reasoning with Multi-Reward Training","local":"advanced-grpo-fine-tuning-for-mathematical-reasoning-with-multi-reward-training","sections":[{"title":"Installation and Setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"GPU Environment Detection","local":"gpu-environment-detection","sections":[],"depth":2},{"title":"Core Library Imports","local":"core-library-imports","sections":[],"depth":2},{"title":"Model Selection and Configuration","local":"model-selection-and-configuration","sections":[],"depth":2},{"title":"LoRA Configuration","local":"lora-configuration","sections":[],"depth":2},{"title":"GSM8K Dataset Setup","local":"gsm8k-dataset-setup","sections":[],"depth":2},{"title":"Multi-Reward System Design","local":"multi-reward-system-design","sections":[],"depth":2},{"title":"GRPO Training Setup","local":"grpo-training-setup","sections":[],"depth":2},{"title":"Trainer Initialization with Trackio Integration","local":"trainer-initialization-with-trackio-integration","sections":[],"depth":2},{"title":"Begin GRPO Training","local":"begin-grpo-training","sections":[],"depth":2},{"title":"Experiment Dashboard","local":"experiment-dashboard","sections":[],"depth":2},{"title":"Model Evaluation and Testing","local":"model-evaluation-and-testing","sections":[],"depth":2},{"title":"Clean Up Resources","local":"clean-up-resources","sections":[],"depth":2},{"title":"References","local":"references","sections":[{"title":"Papers and Research","local":"papers-and-research","sections":[],"depth":3},{"title":"Libraries and Frameworks","local":"libraries-and-frameworks","sections":[],"depth":3},{"title":"Models Used","local":"models-used","sections":[],"depth":3},{"title":"Datasets","local":"datasets","sections":[],"depth":3},{"title":"Key Concepts","local":"key-concepts","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ea(na){return Aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qa extends Xa{constructor(m){super(),Na(this,m,Ea,za,fa,{})}}export{qa as component};
