import{s as Dt,n as Kt,o as Pt}from"../chunks/scheduler.65852ee5.js";import{S as Ot,i as ln,g as M,s as n,r as p,A as sn,h as o,f as e,c as a,j as Yt,u as y,x as i,k as Lt,y as en,a as t,v as w,d as J,t as r,w as T}from"../chunks/index.65a1b999.js";import{D as tn,C as m}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as U,E as nn}from"../chunks/getInferenceSnippets.0c19d6f8.js";function an(He){let j,ns,es,as,u,Ms,d,os,c,ze='<em>Authored by: <a href="https://huggingface.co/jinnovation" rel="nofollow">Jonathan Jin</a></em>',is,I,ps,h,Fe="This notebook explores solutions for streamlining the deployment of models from a model registry. For teams that want to productionize many models over time, investments at this “transition point” in the AI/ML project lifecycle can meaningfully drive down time-to-production. This can be important for a younger, smaller team that may not have the benefit of existing infrastructure to form a “golden path” for serving online models in production.",ys,C,ws,f,Ye="Optimizing this stage of the model lifecycle is particularly important due to the production-facing aspect of the end result. At this stage, your model becomes, in effect, a microservice. This means that you now need to contend with all elements of service ownership, which can include:",Js,b,Le="<li>Standardizing and enforcing API backwards-compatibility;</li> <li>Logging, metrics, and general observability concerns;</li> <li>Etc.</li>",rs,A,De="Needing to repeat the same general-purpose setup each time you want to deploy a new model will result in development costs adding up significantly over time for you and your team. On the flip side, given the “long tail” of production-model ownership (assuming a productionized model is not likely to be decommissioned anytime soon), streamlining investments here can pay healthy dividends over time.",Ts,g,Ke="Given all of the above, we motivate our exploration here with the following user story:",ms,v,Pe='<p>I would like to deploy a model from a model registry (such as <a href="https://mlflow.org/" rel="nofollow">MLflow</a>) using <strong>only the name of the model</strong>. The less boilerplate and scaffolding that I need to replicate each time I want to deploy a new model, the better. I would like the ability to dynamically select between different versions of the model without needing to set up a whole new deployment to accommodate those new versions.</p>',Us,Z,js,B,Oe="For our exploration here, we’ll use the following minimal stack:",us,_,lt="<li>MLflow for model registry;</li> <li>Ray Serve for model serving.</li>",ds,G,st="For demonstrative purposes, we’ll exclusively use off-the-shelf open-source models from Hugging Face Hub.",cs,W,et="We will <strong>not</strong> use GPUs for inference because inference performance is orthogonal to our focus here today. Needless to say, in “real life,” you will likely not be able to get away with serving your model with CPU compute.",Is,R,tt="Let’s install our dependencies now.",hs,k,Cs,V,fs,E,nt="First, let’s define the model that we’ll use for our exploration today. For simplicity’s sake, we’ll use a simple text translation model, where the source and destination languages are configurable at registration time. In effect, this means that different “versions” of the model can be registered to translate different languages, but the underlying model architecture and weights can stay the same.",bs,x,As,X,at="(You might be wondering why we even bothered making the input label configurable. This will be useful to us later.)",gs,q,Mt='Now that our model is defined, let’s register an actual version of it. This particular version will use Google’s <a href="https://huggingface.co/google-t5/t5-base" rel="nofollow">T5 Base</a> model and be configured to translate from <strong>English</strong> to <strong>German</strong>.',vs,Q,Zs,N,ot="Let’s keep track of this exact version. This will be useful later.",Bs,S,_s,$,it="The registered model metadata contains some useful information for us. Most notably, the registered model version is associated with a strict <strong>signature</strong> that denotes the expected shape of its input and output. This will be useful to us later.",Gs,H,Ws,z,pt=`inputs: 
  ['prompt': string (required)]
outputs: 
  ['translation_text': string (required)]
params: 
  None
`,Rs,F,ks,Y,yt='Now that our model is registered in MLflow, let’s set up our serving scaffolding using <a href="https://docs.ray.io/en/latest/serve/index.html" rel="nofollow">Ray Serve</a>. For now, we’ll limit our “deployment” to the following behavior:',Vs,L,wt="<li>Source the seleted model and version from MLflow;</li> <li>Receive inference requests and return inference responses via a simple REST API.</li>",Es,D,xs,K,Jt="You might have notice that hard-coding <code>&quot;prompt&quot;</code> as the input label here introduces hidden coupling between the registered model’s signature and the deployment implementation. We’ll come back to this later.",Xs,P,rt="Now, let’s run the deployment and play around with it.",qs,O,Qs,ll,Ns,sl,Tt=`[&#123;'translation_text': 'Das Wetter ist heute nett.'}]
`,Ss,el,mt="This works fine, but you might have noticed that the REST API does not line up with the model signature. Namely, it uses the label <code>&quot;input_string&quot;</code> while the served model version itself uses the input label <code>&quot;prompt&quot;</code>. Similarly, the model can accept multiple inputs values, but the API only accepts one.",$s,tl,Ut='If this feels <a href="https://en.wikipedia.org/wiki/Code_smell" rel="nofollow">smelly</a> to you, keep reading; we’ll come back to this.',Hs,nl,zs,al,jt="Now we’ve got a basic endpoint set up for our model. Great! However, notice that this deployment is strictly tethered to a single version of this model — specifically, version <code>1</code> of the registered <code>translation_model</code>.",Fs,Ml,ut='Imagine, now, that your team would like to come back and refine this model — maybe retrain it on new data, or configure it to translate to a new language, e.g. French instead of German. Both would result in a new version of the <code>translation_model</code> getting registered. However, with our current deployment implementation, we’d need to set up a whole new endpoint for <code>translation_model/2</code>, require our users to remember which address and port corresponds to which version of the model, and so on. In other words: very cumbersome, very error-prone, very <a href="https://leaddev.com/velocity/what-toil-and-why-it-damaging-your-engineering-org" rel="nofollow">toilsome</a>.',Ys,ol,dt="Conversely, imagine a scenario where we could reuse the exact same endpoint — same signature, same address and port, same query conventions, etc. — to serve both versions of this model. Our user can simply specify which version of the model they’d like to use, and we can treat one of them as the “default” in cases where the user didn’t explicitly request one.",Ls,il,ct='This is one area where Ray Serve shines with a feature it calls <a href="https://docs.ray.io/en/latest/serve/model-multiplexing.html" rel="nofollow">model multiplexing</a>. In effect, this allows you to load up multiple “versions” of your model, dynamically hot-swapping them as needed, as well as unloading the versions that don’t get used after some time. Very space-efficient, in other words.',Ds,pl,It="Let’s try registering another version of the model — this time, one that translates from English to French. We’ll register this under the version <code>&quot;2&quot;</code>; the model server will retrieve the model version that way.",Ks,yl,ht="But first, let’s extend the model server with multiplexing support.",Ps,wl,Os,Jl,le,rl,Ct="Now let’s actually register the new model version.",se,Tl,ee,ml,ft="Now that that’s registered, we can query for it via the model server like so…",te,Ul,ne,jl,bt=`[&#123;'translation_text': "Le temps est beau aujourd'hui"}]
`,ae,ul,At='Note how we were able to immediately access the model version <strong>without redeploying the model server</strong>. Ray Serve’s multiplexing capabilities allow it to dynamically fetch the model weights in a just-in-time fashion; if I never requested version 2, it never gets loaded. This helps conserve compute resources for the models that <strong>do</strong> get queried. What’s even more useful is that, if the number of models loaded up exceeds the configured maximum (<code>max_num_models_per_replica</code>), the <a href="https://docs.ray.io/en/latest/serve/model-multiplexing.html#why-model-multiplexing" rel="nofollow">least-recently used model version will get evicted</a>.',Me,dl,gt="Given that we set <code>max_num_models_per_replica=2</code> above, the “default” English-to-German version of the model should still be loaded up and readily available to serve requests without any cold-start time. Let’s confirm that now:",oe,cl,ie,Il,vt=`[&#123;'translation_text': 'Das Wetter ist heute nett.'}]
`,pe,hl,ye,Cl,Zt="This is all well and good. However, notice that the following friction point still exists: when defining the server, we need to define a whole new signature for the API itself. At best, this is just some code duplication of the model signature itself (which is registered in MLflow). At worst, this can result in inconsistent APIs across all models that your team or organization owns, which can cause confusion and frustration in your downstream dependencies.",we,fl,Bt="In this particular case, it means that <code>MultiplexedModelDeployment</code> is secretly actually <strong>tightly coupled</strong> to the use-case for <code>translation_model</code>. What if we wanted to deploy another set of models that don’t have to do with language translation? The defined <code>/serve</code> API, which returns a JSON object that looks like <code>{&quot;translated_text&quot;: &quot;foo&quot;}</code>, would no longer make sense.",Je,bl,_t="To address this issue, <strong>what if the API signature for <code>MultiplexedModelDeployment</code> could automatically mirror the signature of the underlying models it’s serving</strong>?",re,Al,Gt="Thankfully, with MLflow Model Registry metadata and some Python dynamic-class-creation shenanigans, this is entirely possible.",Te,gl,Wt="Let’s set things up so that the model server signature is inferred from the registered model itself. Since different versions of an MLflow can have different signatures, we’ll use the “default version” to “pin” the signature; any attempt to multiplex an incompatible-signature model version we will have throw an error.",me,vl,Rt="Since Ray Serve binds the request and response signatures at class-definition time, we will use a Python metaclass to set this as a function of the specified model name and default model version.",Ue,Zl,je,Bl,ue,_l,de,Gl,kt=`[&#123;'translation_text': "Le temps est beau aujourd'hui"}]
`,ce,Wl,Ie,Rl,Vt=`[&#123;'translation_text': "Le temps est beau aujourd'hui"}]
`,he,kl,Et="Let’s now confirm that the signature-check provision we put in place actually works. For this, let’s register this same model with a <strong>slightly</strong> different signature. This should be enough to trigger the failsafe.",Ce,Vl,xt="(Remember when we made the input label configurable at the start of this exercise? This is where that finally comes into play. 😎)",fe,El,be,xl,Ae,Xl,Xt="(The technically “correct” thing to do here would be to implement a response container that allows for an “error message” to be defined as part of the actual response, rather than “abusing” the <code>translation_text</code> field like we do here. For demonstration purposes, however, this’ll do.)",ge,ql,qt="To fully close things out, let’s try registering an entirely different model — with an entirely different signature — and deploying that via <code>deployment_from_model_name()</code>. This will help us confirm that the entire signature is defined from the loaded model.",ve,Ql,Ze,Nl,Be,Sl,_e,$l,Qt=`inputs: 
  ['question': string (required)]
outputs: 
  ['score': double (required), 'start': long (required), 'end': long (required), 'answer': string (required)]
params: 
  None
`,Ge,Hl,We,zl,Re,Fl,Nt=`[&#123;'score': 3.255764386267401e-05, 'start': 30, 'end': 38, 'answer': 'Germany.'}]
`,ke,Yl,Ve,Ll,St="In this notebook, we’ve leveraged MLflow’s built-in support for tracking model signatures to heavily streamline the process of deploying an HTTP server to serve that model in online fashion. We’ve taken Ray Serve’s powerful-but-fiddly primitives to empower ourselves to, in one line, deploy a model server with:",Ee,Dl,$t="<li>Version multiplexing;</li> <li>Automatic REST API signature setup;</li> <li>Safeguards to prevent use of model versions with incompatible signatures.</li>",xe,Kl,Ht='In doing so, we’ve demonstrated Ray Serve’s value and potential as a toolkit upon which you and your team can <a href="https://docs.ray.io/en/latest/serve/index.html#how-does-serve-compare-to" rel="nofollow">“build your own ML platform”</a>.',Xe,Pl,zt="We’ve also demonstrated ways to reduce the integration overhead and toil associated with using multiple tools in combination with each other. Seamless integration is a powerful argument in favor of self-contained all-encompassing platforms such as AWS Sagemaker or GCP Vertex AI. We’ve demonstrated that, with a little clever engineering and principled eye towards the friction points that users — in this case, MLEs — care about, we can reap similar benefits without tethering ourselves and our team to expensive vendor contracts.",qe,Ol,Qe,ls,Ft='<li>The generated API signature is <strong>very similar</strong> to the model signature, but there’s still some mismatch. Can you identify where it is? Try fixing it. Hint: What happens when you try passing in multiple questions to the question-answerer endpoint we set up?</li> <li>MLflow model signatures allow for <a href="https://mlflow.org/docs/latest/model/signatures.html#required-vs-optional-input-fields" rel="nofollow">optional inputs</a>. Our current implementation does not account for this. How might we extend the implementation here to support optional inputs?</li> <li>Similarly, MLflow model signatures allow for non-input <a href="https://mlflow.org/docs/latest/model/signatures.html#model-signatures-with-inference-params" rel="nofollow">“inference parameters”</a>, which our current implementation also does not support. How might we extend our implementation here to support inference parameters?</li> <li>We use the name <code>DynamicallyDefinedDeployment</code> every single time we generate a new deployment, regardless of what model name and version we pass in. Is this a problem? If so, what kind of issues do you foresee this approach creating? Try tweaking <code>deployment_from_model_name()</code> to handle those issues.</li>',Ne,ss,Se,ts,$e;return u=new tn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/mlflow_ray_serve.ipynb"}]}}),d=new U({props:{title:"Signature-Aware Model Serving from MLflow with Ray Serve",local:"signature-aware-model-serving-from-mlflow-with-ray-serve",headingTag:"h1"}}),I=new U({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),C=new U({props:{title:"Motivation",local:"motivation",headingTag:"h2"}}),Z=new U({props:{title:"Components",local:"components",headingTag:"h2"}}),k=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMjAlMjJtbGZsb3ctc2tpbm55JTIyJTIwJTIycmF5JTVCc2VydmUlNUQlMjIlMjAlMjJ0b3JjaCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;transformers&quot;</span> <span class="hljs-string">&quot;mlflow-skinny&quot;</span> <span class="hljs-string">&quot;ray[serve]&quot;</span> <span class="hljs-string">&quot;torch&quot;</span>',wrap:!1}}),V=new U({props:{title:"Register the Model",local:"register-the-model",headingTag:"h2"}}),x=new m({props:{code:"aW1wb3J0JTIwbWxmbG93JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVRyYW5zbGF0aW9uTW9kZWwobWxmbG93LnB5ZnVuYy5QeXRob25Nb2RlbCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBsb2FkX2NvbnRleHQoc2VsZiUyQyUyMGNvbnRleHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sYW5nX2Zyb20lMjAlM0QlMjBjb250ZXh0Lm1vZGVsX2NvbmZpZy5nZXQoJTIybGFuZ19mcm9tJTIyJTJDJTIwJTIyZW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sYW5nX3RvJTIwJTNEJTIwY29udGV4dC5tb2RlbF9jb25maWcuZ2V0KCUyMmxhbmdfdG8lMjIlMkMlMjAlMjJkZSUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmlucHV0X2xhYmVsJTNBJTIwc3RyJTIwJTNEJTIwY29udGV4dC5tb2RlbF9jb25maWcuZ2V0KCUyMmlucHV0X2xhYmVsJTIyJTJDJTIwJTIycHJvbXB0JTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfcmVmJTNBJTIwc3RyJTIwJTNEJTIwY29udGV4dC5tb2RlbF9jb25maWcuZ2V0KCUyMmhmaHViX25hbWUlMjIlMkMlMjAlMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIydHJhbnNsYXRpb25fJTdCc2VsZi5sYW5nX2Zyb20lN0RfdG9fJTdCc2VsZi5sYW5nX3RvJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9yZWYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlZGljdChzZWxmJTJDJTIwY29udGV4dCUyQyUyMG1vZGVsX2lucHV0JTJDJTIwcGFyYW1zJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBtb2RlbF9pbnB1dCU1QnNlbGYuaW5wdXRfbGFiZWwlNUQudG9saXN0KCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnBpcGVsaW5lKHByb21wdCk=",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyTranslationModel</span>(mlflow.pyfunc.PythonModel):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_context</span>(<span class="hljs-params">self, context</span>):
        self.lang_from = context.model_config.get(<span class="hljs-string">&quot;lang_from&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>)
        self.lang_to = context.model_config.get(<span class="hljs-string">&quot;lang_to&quot;</span>, <span class="hljs-string">&quot;de&quot;</span>)

        self.input_label: <span class="hljs-built_in">str</span> = context.model_config.get(<span class="hljs-string">&quot;input_label&quot;</span>, <span class="hljs-string">&quot;prompt&quot;</span>)

        self.model_ref: <span class="hljs-built_in">str</span> = context.model_config.get(<span class="hljs-string">&quot;hfhub_name&quot;</span>, <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

        self.pipeline = pipeline(
            <span class="hljs-string">f&quot;translation_<span class="hljs-subst">{self.lang_from}</span>_to_<span class="hljs-subst">{self.lang_to}</span>&quot;</span>,
            self.model_ref,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">self, context, model_input, params=<span class="hljs-literal">None</span></span>):
        prompt = model_input[self.input_label].tolist()

        <span class="hljs-keyword">return</span> self.pipeline(prompt)`,wrap:!1}}),Q=new m({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXdpdGglMjBtbGZsb3cuc3RhcnRfcnVuKCklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbmZvJTIwJTNEJTIwbWxmbG93LnB5ZnVuYy5sb2dfbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWdpc3RlcmVkX21vZGVsX25hbWUlM0QlMjJ0cmFuc2xhdGlvbl9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dGhvbl9tb2RlbCUzRE15VHJhbnNsYXRpb25Nb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwX3JlcXVpcmVtZW50cyUzRCU1QiUyMnRyYW5zZm9ybWVycyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2V4YW1wbGUlM0RwZC5EYXRhRnJhbWUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTIySGVsbG8lMjBteSUyMG5hbWUlMjBpcyUyMEpvbmF0aGFuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9jb25maWclM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZmh1Yl9uYW1lJTIyJTNBJTIwJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxhbmdfZnJvbSUyMiUzQSUyMCUyMmVuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGFuZ190byUyMiUzQSUyMCUyMmRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    model_info = mlflow.pyfunc.log_model(
        <span class="hljs-string">&quot;translation_model&quot;</span>,
        registered_model_name=<span class="hljs-string">&quot;translation_model&quot;</span>,
        python_model=MyTranslationModel(),
        pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
        input_example=pd.DataFrame(
            {
                <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Hello my name is Jonathan.&quot;</span>],
            }
        ),
        model_config={
            <span class="hljs-string">&quot;hfhub_name&quot;</span>: <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>,
            <span class="hljs-string">&quot;lang_from&quot;</span>: <span class="hljs-string">&quot;en&quot;</span>,
            <span class="hljs-string">&quot;lang_to&quot;</span>: <span class="hljs-string">&quot;de&quot;</span>,
        },
    )`,wrap:!1}}),S=new m({props:{code:"ZW5fdG9fZGVfdmVyc2lvbiUzQSUyMHN0ciUyMCUzRCUyMHN0cihtb2RlbF9pbmZvLnJlZ2lzdGVyZWRfbW9kZWxfdmVyc2lvbik=",highlighted:'en_to_de_version: <span class="hljs-built_in">str</span> = <span class="hljs-built_in">str</span>(model_info.registered_model_version)',wrap:!1}}),H=new m({props:{code:"cHJpbnQobW9kZWxfaW5mby5zaWduYXR1cmUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model_info.signature)',wrap:!1}}),F=new U({props:{title:"Serve the Model",local:"serve-the-model",headingTag:"h2"}}),D=new m({props:{code:"aW1wb3J0JTIwbWxmbG93JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWZyb20lMjByYXklMjBpbXBvcnQlMjBzZXJ2ZSUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwRmFzdEFQSSUwQSUwQWFwcCUyMCUzRCUyMEZhc3RBUEkoKSUwQSUwQSUwQSU0MHNlcnZlLmRlcGxveW1lbnQlMEElNDBzZXJ2ZS5pbmdyZXNzKGFwcCklMEFjbGFzcyUyME1vZGVsRGVwbG95bWVudCUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtb2RlbF9uYW1lJTNBJTIwc3RyJTIwJTNEJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMjBkZWZhdWx0X3ZlcnNpb24lM0ElMjBzdHIlMjAlM0QlMjAlMjIxJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRlZmF1bHRfdmVyc2lvbiUyMCUzRCUyMGRlZmF1bHRfdmVyc2lvbiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBtbGZsb3cucHlmdW5jLmxvYWRfbW9kZWwoZiUyMm1vZGVscyUzQSUyRiU3QnNlbGYubW9kZWxfbmFtZSU3RCUyRiU3QnNlbGYuZGVmYXVsdF92ZXJzaW9uJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCU0MGFwcC5wb3N0KCUyMiUyRnNlcnZlJTIyKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc2VydmUoc2VsZiUyQyUyMGlucHV0X3N0cmluZyUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLm1vZGVsLnByZWRpY3QocGQuRGF0YUZyYW1lKCU3QiUyMnByb21wdCUyMiUzQSUyMCU1QmlucHV0X3N0cmluZyU1RCU3RCkpJTBBJTBBJTBBZGVwbG95bWVudCUyMCUzRCUyME1vZGVsRGVwbG95bWVudC5iaW5kKGRlZmF1bHRfdmVyc2lvbiUzRGVuX3RvX2RlX3ZlcnNpb24p",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()


<span class="hljs-meta">@serve.deployment</span>
<span class="hljs-meta">@serve.ingress(<span class="hljs-params">app</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ModelDeployment</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;translation_model&quot;</span>, default_version: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;1&quot;</span></span>):
        self.model_name = model_name
        self.default_version = default_version

        self.model = mlflow.pyfunc.load_model(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{self.model_name}</span>/<span class="hljs-subst">{self.default_version}</span>&quot;</span>)

<span class="hljs-meta">    @app.post(<span class="hljs-params"><span class="hljs-string">&quot;/serve&quot;</span></span>)</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">serve</span>(<span class="hljs-params">self, input_string: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">return</span> self.model.predict(pd.DataFrame({<span class="hljs-string">&quot;prompt&quot;</span>: [input_string]}))


deployment = ModelDeployment.bind(default_version=en_to_de_version)`,wrap:!1}}),O=new m({props:{code:"c2VydmUucnVuKGRlcGxveW1lbnQlMkMlMjBibG9ja2luZyUzREZhbHNlKQ==",highlighted:'serve.run(deployment, blocking=<span class="hljs-literal">False</span>)',wrap:!1}}),ll=new m({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTgwMDAlMkZzZXJ2ZSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhcmFtcyUzRCU3QiUyMmlucHV0X3N0cmluZyUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlLmpzb24oKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    params={<span class="hljs-string">&quot;input_string&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.json())`,wrap:!1}}),nl=new U({props:{title:"Multiple Versions, One Endpoint",local:"multiple-versions-one-endpoint",headingTag:"h2"}}),wl=new m({props:{code:"ZnJvbSUyMHJheSUyMGltcG9ydCUyMHNlcnZlJTBBZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBYXBwJTIwJTNEJTIwRmFzdEFQSSgpJTBBJTBBJTBBJTQwc2VydmUuZGVwbG95bWVudCUwQSU0MHNlcnZlLmluZ3Jlc3MoYXBwKSUwQWNsYXNzJTIwTXVsdGlwbGV4ZWRNb2RlbERlcGxveW1lbnQlM0ElMEElMEElMjAlMjAlMjAlMjAlNDBzZXJ2ZS5tdWx0aXBsZXhlZChtYXhfbnVtX21vZGVsc19wZXJfcmVwbGljYSUzRDIpJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBnZXRfbW9kZWwoc2VsZiUyQyUyMHZlcnNpb24lM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWxmbG93LnB5ZnVuYy5sb2FkX21vZGVsKGYlMjJtb2RlbHMlM0ElMkYlN0JzZWxmLm1vZGVsX25hbWUlN0QlMkYlN0J2ZXJzaW9uJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNBJTIwc3RyJTIwJTNEJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X3ZlcnNpb24lM0ElMjBzdHIlMjAlM0QlMjBlbl90b19kZV92ZXJzaW9uJTJDJTBBJTIwJTIwJTIwJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRlZmF1bHRfdmVyc2lvbiUyMCUzRCUyMGRlZmF1bHRfdmVyc2lvbiUwQSUwQSUyMCUyMCUyMCUyMCU0MGFwcC5wb3N0KCUyMiUyRnNlcnZlJTIyKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc2VydmUoc2VsZiUyQyUyMGlucHV0X3N0cmluZyUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGF3YWl0JTIwc2VsZi5nZXRfbW9kZWwoc2VydmUuZ2V0X211bHRpcGxleGVkX21vZGVsX2lkKCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwucHJlZGljdChwZC5EYXRhRnJhbWUoJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCaW5wdXRfc3RyaW5nJTVEJTdEKSk=",highlighted:`<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()


<span class="hljs-meta">@serve.deployment</span>
<span class="hljs-meta">@serve.ingress(<span class="hljs-params">app</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiplexedModelDeployment</span>:

<span class="hljs-meta">    @serve.multiplexed(<span class="hljs-params">max_num_models_per_replica=<span class="hljs-number">2</span></span>)</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_model</span>(<span class="hljs-params">self, version: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">return</span> mlflow.pyfunc.load_model(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{self.model_name}</span>/<span class="hljs-subst">{version}</span>&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        model_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;translation_model&quot;</span>,
        default_version: <span class="hljs-built_in">str</span> = en_to_de_version,
    </span>):
        self.model_name = model_name
        self.default_version = default_version

<span class="hljs-meta">    @app.post(<span class="hljs-params"><span class="hljs-string">&quot;/serve&quot;</span></span>)</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">serve</span>(<span class="hljs-params">self, input_string: <span class="hljs-built_in">str</span></span>):
        model = <span class="hljs-keyword">await</span> self.get_model(serve.get_multiplexed_model_id())
        <span class="hljs-keyword">return</span> model.predict(pd.DataFrame({<span class="hljs-string">&quot;prompt&quot;</span>: [input_string]}))`,wrap:!1}}),Jl=new m({props:{code:"bXVsdGlwbGV4ZWRfZGVwbG95bWVudCUyMCUzRCUyME11bHRpcGxleGVkTW9kZWxEZXBsb3ltZW50LmJpbmQobW9kZWxfbmFtZSUzRCUyMnRyYW5zbGF0aW9uX21vZGVsJTIyKSUwQXNlcnZlLnJ1bihtdWx0aXBsZXhlZF9kZXBsb3ltZW50JTJDJTIwYmxvY2tpbmclM0RGYWxzZSk=",highlighted:`multiplexed_deployment = MultiplexedModelDeployment.bind(model_name=<span class="hljs-string">&quot;translation_model&quot;</span>)
serve.run(multiplexed_deployment, blocking=<span class="hljs-literal">False</span>)`,wrap:!1}}),Tl=new m({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXdpdGglMjBtbGZsb3cuc3RhcnRfcnVuKCklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbmZvJTIwJTNEJTIwbWxmbG93LnB5ZnVuYy5sb2dfbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWdpc3RlcmVkX21vZGVsX25hbWUlM0QlMjJ0cmFuc2xhdGlvbl9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dGhvbl9tb2RlbCUzRE15VHJhbnNsYXRpb25Nb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwX3JlcXVpcmVtZW50cyUzRCU1QiUyMnRyYW5zZm9ybWVycyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2V4YW1wbGUlM0RwZC5EYXRhRnJhbWUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMjBteSUyMG5hbWUlMjBpcyUyMEpvbi4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGZodWJfbmFtZSUyMiUzQSUyMCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2Zyb20lMjIlM0ElMjAlMjJlbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxhbmdfdG8lMjIlM0ElMjAlMjJmciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFlbl90b19mcl92ZXJzaW9uJTNBJTIwc3RyJTIwJTNEJTIwc3RyKG1vZGVsX2luZm8ucmVnaXN0ZXJlZF9tb2RlbF92ZXJzaW9uKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    model_info = mlflow.pyfunc.log_model(
        <span class="hljs-string">&quot;translation_model&quot;</span>,
        registered_model_name=<span class="hljs-string">&quot;translation_model&quot;</span>,
        python_model=MyTranslationModel(),
        pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
        input_example=pd.DataFrame(
            {
                <span class="hljs-string">&quot;prompt&quot;</span>: [
                    <span class="hljs-string">&quot;Hello my name is Jon.&quot;</span>,
                ],
            }
        ),
        model_config={
            <span class="hljs-string">&quot;hfhub_name&quot;</span>: <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>,
            <span class="hljs-string">&quot;lang_from&quot;</span>: <span class="hljs-string">&quot;en&quot;</span>,
            <span class="hljs-string">&quot;lang_to&quot;</span>: <span class="hljs-string">&quot;fr&quot;</span>,
        },
    )

en_to_fr_version: <span class="hljs-built_in">str</span> = <span class="hljs-built_in">str</span>(model_info.registered_model_version)`,wrap:!1}}),Ul=new m({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTgwMDAlMkZzZXJ2ZSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhcmFtcyUzRCU3QiUyMmlucHV0X3N0cmluZyUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMnNlcnZlX211bHRpcGxleGVkX21vZGVsX2lkJTIyJTNBJTIwZW5fdG9fZnJfdmVyc2lvbiU3RCUyQyUwQSklMEElMEFwcmludChyZXNwb25zZS5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    params={<span class="hljs-string">&quot;input_string&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>    headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: en_to_fr_version},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.json())`,wrap:!1}}),cl=new m({props:{code:"cHJpbnQoJTBBJTIwJTIwJTIwJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFyYW1zJTNEJTdCJTIyaW5wdXRfc3RyaW5nJTIyJTNBJTIwJTIyVGhlJTIwd2VhdGhlciUyMGlzJTIwbG92ZWx5JTIwdG9kYXklMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWFkZXJzJTNEJTdCJTIyc2VydmVfbXVsdGlwbGV4ZWRfbW9kZWxfaWQlMjIlM0ElMjBlbl90b19kZV92ZXJzaW9uJTdEJTJDJTBBJTIwJTIwJTIwJTIwKS5qc29uKCklMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    requests.post(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>        params={<span class="hljs-string">&quot;input_string&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>        headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: en_to_de_version},
<span class="hljs-meta">... </span>    ).json()
<span class="hljs-meta">... </span>)`,wrap:!1}}),hl=new U({props:{title:"Auto-Signature",local:"auto-signature",headingTag:"h2"}}),Zl=new m({props:{code:"aW1wb3J0JTIwbWxmbG93JTBBaW1wb3J0JTIwcHlkYW50aWMlMEElMEElMEFkZWYlMjBzY2hlbWFfdG9fcHlkYW50aWMoc2NoZW1hJTNBJTIwbWxmbG93LnR5cGVzLnNjaGVtYS5TY2hlbWElMkMlMjAqJTJDJTIwbmFtZSUzQSUyMHN0ciklMjAtJTNFJTIwcHlkYW50aWMuQmFzZU1vZGVsJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHlkYW50aWMuY3JlYXRlX21vZGVsKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlMkMlMjAqKiU3QmslM0ElMjAodi50eXBlLnRvX3B5dGhvbigpJTJDJTIwcHlkYW50aWMuRmllbGQocmVxdWlyZWQlM0RUcnVlKSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwc2NoZW1hLmlucHV0X2RpY3QoKS5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQWRlZiUyMGdldF9yZXFfcmVzcF9zaWduYXR1cmVzKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3NpZ25hdHVyZSUzQSUyMG1sZmxvdy5tb2RlbHMuTW9kZWxTaWduYXR1cmUlMkMlMEEpJTIwLSUzRSUyMHR1cGxlJTVCcHlkYW50aWMuQmFzZU1vZGVsJTJDJTIwcHlkYW50aWMuQmFzZU1vZGVsJTVEJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNBJTIwbWxmbG93LnR5cGVzLnNjaGVtYS5TY2hlbWElMjAlM0QlMjBtb2RlbF9zaWduYXR1cmUuaW5wdXRzJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzQSUyMG1sZmxvdy50eXBlcy5zY2hlbWEuU2NoZW1hJTIwJTNEJTIwbW9kZWxfc2lnbmF0dXJlLm91dHB1dHMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAoc2NoZW1hX3RvX3B5ZGFudGljKGlucHV0cyUyQyUyMG5hbWUlM0QlMjJJbnB1dE1vZGVsJTIyKSUyQyUyMHNjaGVtYV90b19weWRhbnRpYyhvdXRwdXRzJTJDJTIwbmFtZSUzRCUyMk91dHB1dE1vZGVsJTIyKSk=",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">import</span> pydantic


<span class="hljs-keyword">def</span> <span class="hljs-title function_">schema_to_pydantic</span>(<span class="hljs-params">schema: mlflow.types.schema.Schema, *, name: <span class="hljs-built_in">str</span></span>) -&gt; pydantic.BaseModel:
    <span class="hljs-keyword">return</span> pydantic.create_model(
        name, **{k: (v.<span class="hljs-built_in">type</span>.to_python(), pydantic.Field(required=<span class="hljs-literal">True</span>)) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> schema.input_dict().items()}
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_req_resp_signatures</span>(<span class="hljs-params">
    model_signature: mlflow.models.ModelSignature,
</span>) -&gt; <span class="hljs-built_in">tuple</span>[pydantic.BaseModel, pydantic.BaseModel]:
    inputs: mlflow.types.schema.Schema = model_signature.inputs
    outputs: mlflow.types.schema.Schema = model_signature.outputs

    <span class="hljs-keyword">return</span> (schema_to_pydantic(inputs, name=<span class="hljs-string">&quot;InputModel&quot;</span>), schema_to_pydantic(outputs, name=<span class="hljs-string">&quot;OutputModel&quot;</span>))`,wrap:!1}}),Bl=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> mlflow

<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI, Response, status
<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">deployment_from_model_name</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span>, default_version: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;1&quot;</span></span>):
    app = FastAPI()
    model_info = mlflow.models.get_model_info(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{default_version}</span>&quot;</span>)
    input_datamodel, output_datamodel = get_req_resp_signatures(model_info.signature)

<span class="hljs-meta">    @serve.deployment</span>
<span class="hljs-meta">    @serve.ingress(<span class="hljs-params">app</span>)</span>
    <span class="hljs-keyword">class</span> <span class="hljs-title class_">DynamicallyDefinedDeployment</span>:

        MODEL_NAME: <span class="hljs-built_in">str</span> = model_name
        DEFAULT_VERSION: <span class="hljs-built_in">str</span> = default_version

<span class="hljs-meta">        @serve.multiplexed(<span class="hljs-params">max_num_models_per_replica=<span class="hljs-number">2</span></span>)</span>
        <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_model</span>(<span class="hljs-params">self, model_version: <span class="hljs-built_in">str</span></span>):
            model = mlflow.pyfunc.load_model(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{self.MODEL_NAME}</span>/<span class="hljs-subst">{model_version}</span>&quot;</span>)

            <span class="hljs-keyword">if</span> model.metadata.get_model_info().signature != model_info.signature:
                <span class="hljs-keyword">raise</span> ValueError(
                    <span class="hljs-string">f&quot;Requested version <span class="hljs-subst">{model_version}</span> has signature incompatible with that of default version <span class="hljs-subst">{self.DEFAULT_VERSION}</span>&quot;</span>
                )
            <span class="hljs-keyword">return</span> model

        <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Extend this to support batching (lists of inputs and outputs)</span>
<span class="hljs-meta">        @app.post(<span class="hljs-params"><span class="hljs-string">&quot;/serve&quot;</span>, response_model=<span class="hljs-type">List</span>[output_datamodel]</span>)</span>
        <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">serve</span>(<span class="hljs-params">self, model_input: input_datamodel, response: Response</span>):
            model_id = serve.get_multiplexed_model_id()
            <span class="hljs-keyword">if</span> model_id == <span class="hljs-string">&quot;&quot;</span>:
                model_id = self.DEFAULT_VERSION

            <span class="hljs-keyword">try</span>:
                model = <span class="hljs-keyword">await</span> self.get_model(model_id)
            <span class="hljs-keyword">except</span> ValueError:
                response.status_code = status.HTTP_409_CONFLICT
                <span class="hljs-keyword">return</span> [{<span class="hljs-string">&quot;translation_text&quot;</span>: <span class="hljs-string">&quot;FAILED&quot;</span>}]

            <span class="hljs-keyword">return</span> model.predict(model_input.<span class="hljs-built_in">dict</span>())

    <span class="hljs-keyword">return</span> DynamicallyDefinedDeployment


deployment = deployment_from_model_name(<span class="hljs-string">&quot;translation_model&quot;</span>, default_version=en_to_fr_version)

serve.run(deployment.bind(), blocking=<span class="hljs-literal">False</span>)`,wrap:!1}}),_l=new m({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBKSUwQSUwQWFzc2VydCUyMHJlc3Aub2slMEFhc3NlcnQlMjByZXNwLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTBBJTBBcHJpbnQocmVzcC5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>resp = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    json={<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.ok
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.status_code == <span class="hljs-number">200</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(resp.json())`,wrap:!1}}),Wl=new m({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMnNlcnZlX211bHRpcGxleGVkX21vZGVsX2lkJTIyJTNBJTIwc3RyKGVuX3RvX2ZyX3ZlcnNpb24pJTdEJTJDJTBBKSUwQSUwQWFzc2VydCUyMHJlc3Aub2slMEFhc3NlcnQlMjByZXNwLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTBBJTBBcHJpbnQocmVzcC5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>resp = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    json={<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>    headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: <span class="hljs-built_in">str</span>(en_to_fr_version)},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.ok
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.status_code == <span class="hljs-number">200</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(resp.json())`,wrap:!1}}),El=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    incompatible_version = <span class="hljs-built_in">str</span>(
        mlflow.pyfunc.log_model(
            <span class="hljs-string">&quot;translation_model&quot;</span>,
            registered_model_name=<span class="hljs-string">&quot;translation_model&quot;</span>,
            python_model=MyTranslationModel(),
            pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
            input_example=pd.DataFrame(
                {
                    <span class="hljs-string">&quot;text_to_translate&quot;</span>: [
                        <span class="hljs-string">&quot;Hello my name is Jon.&quot;</span>,
                    ],
                }
            ),
            model_config={
                <span class="hljs-string">&quot;input_label&quot;</span>: <span class="hljs-string">&quot;text_to_translate&quot;</span>,
                <span class="hljs-string">&quot;hfhub_name&quot;</span>: <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>,
                <span class="hljs-string">&quot;lang_from&quot;</span>: <span class="hljs-string">&quot;en&quot;</span>,
                <span class="hljs-string">&quot;lang_to&quot;</span>: <span class="hljs-string">&quot;de&quot;</span>,
            },
        ).registered_model_version
    )`,wrap:!1}}),xl=new m({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMnNlcnZlX211bHRpcGxleGVkX21vZGVsX2lkJTIyJTNBJTIwaW5jb21wYXRpYmxlX3ZlcnNpb24lN0QlMkMlMEEpJTBBYXNzZXJ0JTIwbm90JTIwcmVzcC5vayUwQXJlc3Auc3RhdHVzX2NvZGUlMjAlM0QlM0QlMjA0MDklMEElMEFhc3NlcnQlMjByZXNwLmpzb24oKSU1QjAlNUQlNUIlMjJ0cmFuc2xhdGlvbl90ZXh0JTIyJTVEJTIwJTNEJTNEJTIwJTIyRkFJTEVEJTIy",highlighted:`<span class="hljs-keyword">import</span> requests

resp = requests.post(
    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
    json={<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
    headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: incompatible_version},
)
<span class="hljs-keyword">assert</span> <span class="hljs-keyword">not</span> resp.ok
resp.status_code == <span class="hljs-number">409</span>

<span class="hljs-keyword">assert</span> resp.json()[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;translation_text&quot;</span>] == <span class="hljs-string">&quot;FAILED&quot;</span>`,wrap:!1}}),Ql=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">QuestionAnswererModel</span>(mlflow.pyfunc.PythonModel):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_context</span>(<span class="hljs-params">self, context</span>):

        self.model_context = context.model_config.get(
            <span class="hljs-string">&quot;model_context&quot;</span>,
            <span class="hljs-string">&quot;My name is Hans and I live in Germany.&quot;</span>,
        )
        self.model_name = context.model_config.get(
            <span class="hljs-string">&quot;model_name&quot;</span>,
            <span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>,
        )

        self.tokenizer_name = context.model_config.get(
            <span class="hljs-string">&quot;tokenizer_name&quot;</span>,
            <span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>,
        )

        self.pipeline = pipeline(
            <span class="hljs-string">&quot;question-answering&quot;</span>,
            model=self.model_name,
            tokenizer=self.tokenizer_name,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">self, context, model_input, params=<span class="hljs-literal">None</span></span>):
        resp = self.pipeline(
            question=model_input[<span class="hljs-string">&quot;question&quot;</span>].tolist(),
            context=self.model_context,
        )

        <span class="hljs-keyword">return</span> [resp] <span class="hljs-keyword">if</span> <span class="hljs-built_in">type</span>(resp) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">list</span> <span class="hljs-keyword">else</span> resp`,wrap:!1}}),Nl=new m({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXdpdGglMjBtbGZsb3cuc3RhcnRfcnVuKCklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbmZvJTIwJTNEJTIwbWxmbG93LnB5ZnVuYy5sb2dfbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlc3Rpb25fYW5zd2VyZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWdpc3RlcmVkX21vZGVsX25hbWUlM0QlMjJxdWVzdGlvbl9hbnN3ZXJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dGhvbl9tb2RlbCUzRFF1ZXN0aW9uQW5zd2VyZXJNb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwX3JlcXVpcmVtZW50cyUzRCU1QiUyMnRyYW5zZm9ybWVycyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2V4YW1wbGUlM0RwZC5EYXRhRnJhbWUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGVyZSUyMGRvJTIweW91JTIwbGl2ZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHlvdXIlMjBuYW1lJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1vZGVsX2NvbnRleHQlMjIlM0ElMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEhhbnMlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    model_info = mlflow.pyfunc.log_model(
        <span class="hljs-string">&quot;question_answerer&quot;</span>,
        registered_model_name=<span class="hljs-string">&quot;question_answerer&quot;</span>,
        python_model=QuestionAnswererModel(),
        pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
        input_example=pd.DataFrame(
            {
                <span class="hljs-string">&quot;question&quot;</span>: [
                    <span class="hljs-string">&quot;Where do you live?&quot;</span>,
                    <span class="hljs-string">&quot;What is your name?&quot;</span>,
                ],
            }
        ),
        model_config={
            <span class="hljs-string">&quot;model_context&quot;</span>: <span class="hljs-string">&quot;My name is Hans and I live in Germany.&quot;</span>,
        },
    )`,wrap:!1}}),Sl=new m({props:{code:"cHJpbnQobW9kZWxfaW5mby5zaWduYXR1cmUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model_info.signature)',wrap:!1}}),Hl=new m({props:{code:"ZnJvbSUyMHJheSUyMGltcG9ydCUyMHNlcnZlJTBBJTBBc2VydmUucnVuKCUwQSUyMCUyMCUyMCUyMGRlcGxveW1lbnRfZnJvbV9tb2RlbF9uYW1lKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnF1ZXN0aW9uX2Fuc3dlcmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmYXVsdF92ZXJzaW9uJTNEc3RyKG1vZGVsX2luZm8ucmVnaXN0ZXJlZF9tb2RlbF92ZXJzaW9uKSUyQyUwQSUyMCUyMCUyMCUyMCkuYmluZCgpJTJDJTBBJTIwJTIwJTIwJTIwYmxvY2tpbmclM0RGYWxzZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve

serve.run(
    deployment_from_model_name(
        <span class="hljs-string">&quot;question_answerer&quot;</span>,
        default_version=<span class="hljs-built_in">str</span>(model_info.registered_model_version),
    ).bind(),
    blocking=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),zl=new m({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyVGhlJTIwd2VhdGhlciUyMGlzJTIwbG92ZWx5JTIwdG9kYXklMjIlN0QlMkMlMEEpJTBBcHJpbnQocmVzcC5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>resp = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    json={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(resp.json())`,wrap:!1}}),Yl=new U({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Ol=new U({props:{title:"Exercises",local:"exercises",headingTag:"h2"}}),ss=new nn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/mlflow_ray_serve.md"}}),{c(){j=M("meta"),ns=n(),es=M("p"),as=n(),p(u.$$.fragment),Ms=n(),p(d.$$.fragment),os=n(),c=M("p"),c.innerHTML=ze,is=n(),p(I.$$.fragment),ps=n(),h=M("p"),h.textContent=Fe,ys=n(),p(C.$$.fragment),ws=n(),f=M("p"),f.textContent=Ye,Js=n(),b=M("ul"),b.innerHTML=Le,rs=n(),A=M("p"),A.textContent=De,Ts=n(),g=M("p"),g.textContent=Ke,ms=n(),v=M("blockquote"),v.innerHTML=Pe,Us=n(),p(Z.$$.fragment),js=n(),B=M("p"),B.textContent=Oe,us=n(),_=M("ul"),_.innerHTML=lt,ds=n(),G=M("p"),G.textContent=st,cs=n(),W=M("p"),W.innerHTML=et,Is=n(),R=M("p"),R.textContent=tt,hs=n(),p(k.$$.fragment),Cs=n(),p(V.$$.fragment),fs=n(),E=M("p"),E.textContent=nt,bs=n(),p(x.$$.fragment),As=n(),X=M("p"),X.textContent=at,gs=n(),q=M("p"),q.innerHTML=Mt,vs=n(),p(Q.$$.fragment),Zs=n(),N=M("p"),N.textContent=ot,Bs=n(),p(S.$$.fragment),_s=n(),$=M("p"),$.innerHTML=it,Gs=n(),p(H.$$.fragment),Ws=n(),z=M("pre"),z.textContent=pt,Rs=n(),p(F.$$.fragment),ks=n(),Y=M("p"),Y.innerHTML=yt,Vs=n(),L=M("ul"),L.innerHTML=wt,Es=n(),p(D.$$.fragment),xs=n(),K=M("p"),K.innerHTML=Jt,Xs=n(),P=M("p"),P.textContent=rt,qs=n(),p(O.$$.fragment),Qs=n(),p(ll.$$.fragment),Ns=n(),sl=M("pre"),sl.textContent=Tt,Ss=n(),el=M("p"),el.innerHTML=mt,$s=n(),tl=M("p"),tl.innerHTML=Ut,Hs=n(),p(nl.$$.fragment),zs=n(),al=M("p"),al.innerHTML=jt,Fs=n(),Ml=M("p"),Ml.innerHTML=ut,Ys=n(),ol=M("p"),ol.textContent=dt,Ls=n(),il=M("p"),il.innerHTML=ct,Ds=n(),pl=M("p"),pl.innerHTML=It,Ks=n(),yl=M("p"),yl.textContent=ht,Ps=n(),p(wl.$$.fragment),Os=n(),p(Jl.$$.fragment),le=n(),rl=M("p"),rl.textContent=Ct,se=n(),p(Tl.$$.fragment),ee=n(),ml=M("p"),ml.textContent=ft,te=n(),p(Ul.$$.fragment),ne=n(),jl=M("pre"),jl.textContent=bt,ae=n(),ul=M("p"),ul.innerHTML=At,Me=n(),dl=M("p"),dl.innerHTML=gt,oe=n(),p(cl.$$.fragment),ie=n(),Il=M("pre"),Il.textContent=vt,pe=n(),p(hl.$$.fragment),ye=n(),Cl=M("p"),Cl.textContent=Zt,we=n(),fl=M("p"),fl.innerHTML=Bt,Je=n(),bl=M("p"),bl.innerHTML=_t,re=n(),Al=M("p"),Al.textContent=Gt,Te=n(),gl=M("p"),gl.textContent=Wt,me=n(),vl=M("p"),vl.textContent=Rt,Ue=n(),p(Zl.$$.fragment),je=n(),p(Bl.$$.fragment),ue=n(),p(_l.$$.fragment),de=n(),Gl=M("pre"),Gl.textContent=kt,ce=n(),p(Wl.$$.fragment),Ie=n(),Rl=M("pre"),Rl.textContent=Vt,he=n(),kl=M("p"),kl.innerHTML=Et,Ce=n(),Vl=M("p"),Vl.textContent=xt,fe=n(),p(El.$$.fragment),be=n(),p(xl.$$.fragment),Ae=n(),Xl=M("p"),Xl.innerHTML=Xt,ge=n(),ql=M("p"),ql.innerHTML=qt,ve=n(),p(Ql.$$.fragment),Ze=n(),p(Nl.$$.fragment),Be=n(),p(Sl.$$.fragment),_e=n(),$l=M("pre"),$l.textContent=Qt,Ge=n(),p(Hl.$$.fragment),We=n(),p(zl.$$.fragment),Re=n(),Fl=M("pre"),Fl.textContent=Nt,ke=n(),p(Yl.$$.fragment),Ve=n(),Ll=M("p"),Ll.textContent=St,Ee=n(),Dl=M("ul"),Dl.innerHTML=$t,xe=n(),Kl=M("p"),Kl.innerHTML=Ht,Xe=n(),Pl=M("p"),Pl.textContent=zt,qe=n(),p(Ol.$$.fragment),Qe=n(),ls=M("ul"),ls.innerHTML=Ft,Ne=n(),p(ss.$$.fragment),Se=n(),ts=M("p"),this.h()},l(l){const s=sn("svelte-u9bgzb",document.head);j=o(s,"META",{name:!0,content:!0}),s.forEach(e),ns=a(l),es=o(l,"P",{}),Yt(es).forEach(e),as=a(l),y(u.$$.fragment,l),Ms=a(l),y(d.$$.fragment,l),os=a(l),c=o(l,"P",{"data-svelte-h":!0}),i(c)!=="svelte-15wt2km"&&(c.innerHTML=ze),is=a(l),y(I.$$.fragment,l),ps=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1lijov1"&&(h.textContent=Fe),ys=a(l),y(C.$$.fragment,l),ws=a(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1696eie"&&(f.textContent=Ye),Js=a(l),b=o(l,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-alquk9"&&(b.innerHTML=Le),rs=a(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-nuungn"&&(A.textContent=De),Ts=a(l),g=o(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-ixpdif"&&(g.textContent=Ke),ms=a(l),v=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(v)!=="svelte-1nhcdmi"&&(v.innerHTML=Pe),Us=a(l),y(Z.$$.fragment,l),js=a(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-n7k5lz"&&(B.textContent=Oe),us=a(l),_=o(l,"UL",{"data-svelte-h":!0}),i(_)!=="svelte-wvnude"&&(_.innerHTML=lt),ds=a(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-ax5rm3"&&(G.textContent=st),cs=a(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-9gfume"&&(W.innerHTML=et),Is=a(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1hnxkgd"&&(R.textContent=tt),hs=a(l),y(k.$$.fragment,l),Cs=a(l),y(V.$$.fragment,l),fs=a(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1dqc8q9"&&(E.textContent=nt),bs=a(l),y(x.$$.fragment,l),As=a(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1960jap"&&(X.textContent=at),gs=a(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1ncm2gu"&&(q.innerHTML=Mt),vs=a(l),y(Q.$$.fragment,l),Zs=a(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-83645o"&&(N.textContent=ot),Bs=a(l),y(S.$$.fragment,l),_s=a(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-a1ir6"&&($.innerHTML=it),Gs=a(l),y(H.$$.fragment,l),Ws=a(l),z=o(l,"PRE",{"data-svelte-h":!0}),i(z)!=="svelte-10zklww"&&(z.textContent=pt),Rs=a(l),y(F.$$.fragment,l),ks=a(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-uflyhq"&&(Y.innerHTML=yt),Vs=a(l),L=o(l,"UL",{"data-svelte-h":!0}),i(L)!=="svelte-11hhfc9"&&(L.innerHTML=wt),Es=a(l),y(D.$$.fragment,l),xs=a(l),K=o(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-6jerq0"&&(K.innerHTML=Jt),Xs=a(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-cjqdtn"&&(P.textContent=rt),qs=a(l),y(O.$$.fragment,l),Qs=a(l),y(ll.$$.fragment,l),Ns=a(l),sl=o(l,"PRE",{"data-svelte-h":!0}),i(sl)!=="svelte-e2muls"&&(sl.textContent=Tt),Ss=a(l),el=o(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1q4b85e"&&(el.innerHTML=mt),$s=a(l),tl=o(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-1f3zasy"&&(tl.innerHTML=Ut),Hs=a(l),y(nl.$$.fragment,l),zs=a(l),al=o(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1mro102"&&(al.innerHTML=jt),Fs=a(l),Ml=o(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1934t55"&&(Ml.innerHTML=ut),Ys=a(l),ol=o(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1dfp1gw"&&(ol.textContent=dt),Ls=a(l),il=o(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-16nv6bl"&&(il.innerHTML=ct),Ds=a(l),pl=o(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1brh20n"&&(pl.innerHTML=It),Ks=a(l),yl=o(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1w05arq"&&(yl.textContent=ht),Ps=a(l),y(wl.$$.fragment,l),Os=a(l),y(Jl.$$.fragment,l),le=a(l),rl=o(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-gnpi09"&&(rl.textContent=Ct),se=a(l),y(Tl.$$.fragment,l),ee=a(l),ml=o(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-94uta8"&&(ml.textContent=ft),te=a(l),y(Ul.$$.fragment,l),ne=a(l),jl=o(l,"PRE",{"data-svelte-h":!0}),i(jl)!=="svelte-s3g3o9"&&(jl.textContent=bt),ae=a(l),ul=o(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-8h7gxy"&&(ul.innerHTML=At),Me=a(l),dl=o(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1i62yy7"&&(dl.innerHTML=gt),oe=a(l),y(cl.$$.fragment,l),ie=a(l),Il=o(l,"PRE",{"data-svelte-h":!0}),i(Il)!=="svelte-e2muls"&&(Il.textContent=vt),pe=a(l),y(hl.$$.fragment,l),ye=a(l),Cl=o(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-1o4zzgm"&&(Cl.textContent=Zt),we=a(l),fl=o(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-swa1v3"&&(fl.innerHTML=Bt),Je=a(l),bl=o(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1a5u6kx"&&(bl.innerHTML=_t),re=a(l),Al=o(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1vumo5l"&&(Al.textContent=Gt),Te=a(l),gl=o(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-1xhx9bf"&&(gl.textContent=Wt),me=a(l),vl=o(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-12c4mta"&&(vl.textContent=Rt),Ue=a(l),y(Zl.$$.fragment,l),je=a(l),y(Bl.$$.fragment,l),ue=a(l),y(_l.$$.fragment,l),de=a(l),Gl=o(l,"PRE",{"data-svelte-h":!0}),i(Gl)!=="svelte-s3g3o9"&&(Gl.textContent=kt),ce=a(l),y(Wl.$$.fragment,l),Ie=a(l),Rl=o(l,"PRE",{"data-svelte-h":!0}),i(Rl)!=="svelte-s3g3o9"&&(Rl.textContent=Vt),he=a(l),kl=o(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-kwrm3f"&&(kl.innerHTML=Et),Ce=a(l),Vl=o(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-s43neq"&&(Vl.textContent=xt),fe=a(l),y(El.$$.fragment,l),be=a(l),y(xl.$$.fragment,l),Ae=a(l),Xl=o(l,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-1a9wpz3"&&(Xl.innerHTML=Xt),ge=a(l),ql=o(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-uhpahh"&&(ql.innerHTML=qt),ve=a(l),y(Ql.$$.fragment,l),Ze=a(l),y(Nl.$$.fragment,l),Be=a(l),y(Sl.$$.fragment,l),_e=a(l),$l=o(l,"PRE",{"data-svelte-h":!0}),i($l)!=="svelte-hmoafl"&&($l.textContent=Qt),Ge=a(l),y(Hl.$$.fragment,l),We=a(l),y(zl.$$.fragment,l),Re=a(l),Fl=o(l,"PRE",{"data-svelte-h":!0}),i(Fl)!=="svelte-uqrhuo"&&(Fl.textContent=Nt),ke=a(l),y(Yl.$$.fragment,l),Ve=a(l),Ll=o(l,"P",{"data-svelte-h":!0}),i(Ll)!=="svelte-1smtqgx"&&(Ll.textContent=St),Ee=a(l),Dl=o(l,"UL",{"data-svelte-h":!0}),i(Dl)!=="svelte-ltetir"&&(Dl.innerHTML=$t),xe=a(l),Kl=o(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-1bodq55"&&(Kl.innerHTML=Ht),Xe=a(l),Pl=o(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-vdmzas"&&(Pl.textContent=zt),qe=a(l),y(Ol.$$.fragment,l),Qe=a(l),ls=o(l,"UL",{"data-svelte-h":!0}),i(ls)!=="svelte-mffr65"&&(ls.innerHTML=Ft),Ne=a(l),y(ss.$$.fragment,l),Se=a(l),ts=o(l,"P",{}),Yt(ts).forEach(e),this.h()},h(){Lt(j,"name","hf:doc:metadata"),Lt(j,"content",Mn)},m(l,s){en(document.head,j),t(l,ns,s),t(l,es,s),t(l,as,s),w(u,l,s),t(l,Ms,s),w(d,l,s),t(l,os,s),t(l,c,s),t(l,is,s),w(I,l,s),t(l,ps,s),t(l,h,s),t(l,ys,s),w(C,l,s),t(l,ws,s),t(l,f,s),t(l,Js,s),t(l,b,s),t(l,rs,s),t(l,A,s),t(l,Ts,s),t(l,g,s),t(l,ms,s),t(l,v,s),t(l,Us,s),w(Z,l,s),t(l,js,s),t(l,B,s),t(l,us,s),t(l,_,s),t(l,ds,s),t(l,G,s),t(l,cs,s),t(l,W,s),t(l,Is,s),t(l,R,s),t(l,hs,s),w(k,l,s),t(l,Cs,s),w(V,l,s),t(l,fs,s),t(l,E,s),t(l,bs,s),w(x,l,s),t(l,As,s),t(l,X,s),t(l,gs,s),t(l,q,s),t(l,vs,s),w(Q,l,s),t(l,Zs,s),t(l,N,s),t(l,Bs,s),w(S,l,s),t(l,_s,s),t(l,$,s),t(l,Gs,s),w(H,l,s),t(l,Ws,s),t(l,z,s),t(l,Rs,s),w(F,l,s),t(l,ks,s),t(l,Y,s),t(l,Vs,s),t(l,L,s),t(l,Es,s),w(D,l,s),t(l,xs,s),t(l,K,s),t(l,Xs,s),t(l,P,s),t(l,qs,s),w(O,l,s),t(l,Qs,s),w(ll,l,s),t(l,Ns,s),t(l,sl,s),t(l,Ss,s),t(l,el,s),t(l,$s,s),t(l,tl,s),t(l,Hs,s),w(nl,l,s),t(l,zs,s),t(l,al,s),t(l,Fs,s),t(l,Ml,s),t(l,Ys,s),t(l,ol,s),t(l,Ls,s),t(l,il,s),t(l,Ds,s),t(l,pl,s),t(l,Ks,s),t(l,yl,s),t(l,Ps,s),w(wl,l,s),t(l,Os,s),w(Jl,l,s),t(l,le,s),t(l,rl,s),t(l,se,s),w(Tl,l,s),t(l,ee,s),t(l,ml,s),t(l,te,s),w(Ul,l,s),t(l,ne,s),t(l,jl,s),t(l,ae,s),t(l,ul,s),t(l,Me,s),t(l,dl,s),t(l,oe,s),w(cl,l,s),t(l,ie,s),t(l,Il,s),t(l,pe,s),w(hl,l,s),t(l,ye,s),t(l,Cl,s),t(l,we,s),t(l,fl,s),t(l,Je,s),t(l,bl,s),t(l,re,s),t(l,Al,s),t(l,Te,s),t(l,gl,s),t(l,me,s),t(l,vl,s),t(l,Ue,s),w(Zl,l,s),t(l,je,s),w(Bl,l,s),t(l,ue,s),w(_l,l,s),t(l,de,s),t(l,Gl,s),t(l,ce,s),w(Wl,l,s),t(l,Ie,s),t(l,Rl,s),t(l,he,s),t(l,kl,s),t(l,Ce,s),t(l,Vl,s),t(l,fe,s),w(El,l,s),t(l,be,s),w(xl,l,s),t(l,Ae,s),t(l,Xl,s),t(l,ge,s),t(l,ql,s),t(l,ve,s),w(Ql,l,s),t(l,Ze,s),w(Nl,l,s),t(l,Be,s),w(Sl,l,s),t(l,_e,s),t(l,$l,s),t(l,Ge,s),w(Hl,l,s),t(l,We,s),w(zl,l,s),t(l,Re,s),t(l,Fl,s),t(l,ke,s),w(Yl,l,s),t(l,Ve,s),t(l,Ll,s),t(l,Ee,s),t(l,Dl,s),t(l,xe,s),t(l,Kl,s),t(l,Xe,s),t(l,Pl,s),t(l,qe,s),w(Ol,l,s),t(l,Qe,s),t(l,ls,s),t(l,Ne,s),w(ss,l,s),t(l,Se,s),t(l,ts,s),$e=!0},p:Kt,i(l){$e||(J(u.$$.fragment,l),J(d.$$.fragment,l),J(I.$$.fragment,l),J(C.$$.fragment,l),J(Z.$$.fragment,l),J(k.$$.fragment,l),J(V.$$.fragment,l),J(x.$$.fragment,l),J(Q.$$.fragment,l),J(S.$$.fragment,l),J(H.$$.fragment,l),J(F.$$.fragment,l),J(D.$$.fragment,l),J(O.$$.fragment,l),J(ll.$$.fragment,l),J(nl.$$.fragment,l),J(wl.$$.fragment,l),J(Jl.$$.fragment,l),J(Tl.$$.fragment,l),J(Ul.$$.fragment,l),J(cl.$$.fragment,l),J(hl.$$.fragment,l),J(Zl.$$.fragment,l),J(Bl.$$.fragment,l),J(_l.$$.fragment,l),J(Wl.$$.fragment,l),J(El.$$.fragment,l),J(xl.$$.fragment,l),J(Ql.$$.fragment,l),J(Nl.$$.fragment,l),J(Sl.$$.fragment,l),J(Hl.$$.fragment,l),J(zl.$$.fragment,l),J(Yl.$$.fragment,l),J(Ol.$$.fragment,l),J(ss.$$.fragment,l),$e=!0)},o(l){r(u.$$.fragment,l),r(d.$$.fragment,l),r(I.$$.fragment,l),r(C.$$.fragment,l),r(Z.$$.fragment,l),r(k.$$.fragment,l),r(V.$$.fragment,l),r(x.$$.fragment,l),r(Q.$$.fragment,l),r(S.$$.fragment,l),r(H.$$.fragment,l),r(F.$$.fragment,l),r(D.$$.fragment,l),r(O.$$.fragment,l),r(ll.$$.fragment,l),r(nl.$$.fragment,l),r(wl.$$.fragment,l),r(Jl.$$.fragment,l),r(Tl.$$.fragment,l),r(Ul.$$.fragment,l),r(cl.$$.fragment,l),r(hl.$$.fragment,l),r(Zl.$$.fragment,l),r(Bl.$$.fragment,l),r(_l.$$.fragment,l),r(Wl.$$.fragment,l),r(El.$$.fragment,l),r(xl.$$.fragment,l),r(Ql.$$.fragment,l),r(Nl.$$.fragment,l),r(Sl.$$.fragment,l),r(Hl.$$.fragment,l),r(zl.$$.fragment,l),r(Yl.$$.fragment,l),r(Ol.$$.fragment,l),r(ss.$$.fragment,l),$e=!1},d(l){l&&(e(ns),e(es),e(as),e(Ms),e(os),e(c),e(is),e(ps),e(h),e(ys),e(ws),e(f),e(Js),e(b),e(rs),e(A),e(Ts),e(g),e(ms),e(v),e(Us),e(js),e(B),e(us),e(_),e(ds),e(G),e(cs),e(W),e(Is),e(R),e(hs),e(Cs),e(fs),e(E),e(bs),e(As),e(X),e(gs),e(q),e(vs),e(Zs),e(N),e(Bs),e(_s),e($),e(Gs),e(Ws),e(z),e(Rs),e(ks),e(Y),e(Vs),e(L),e(Es),e(xs),e(K),e(Xs),e(P),e(qs),e(Qs),e(Ns),e(sl),e(Ss),e(el),e($s),e(tl),e(Hs),e(zs),e(al),e(Fs),e(Ml),e(Ys),e(ol),e(Ls),e(il),e(Ds),e(pl),e(Ks),e(yl),e(Ps),e(Os),e(le),e(rl),e(se),e(ee),e(ml),e(te),e(ne),e(jl),e(ae),e(ul),e(Me),e(dl),e(oe),e(ie),e(Il),e(pe),e(ye),e(Cl),e(we),e(fl),e(Je),e(bl),e(re),e(Al),e(Te),e(gl),e(me),e(vl),e(Ue),e(je),e(ue),e(de),e(Gl),e(ce),e(Ie),e(Rl),e(he),e(kl),e(Ce),e(Vl),e(fe),e(be),e(Ae),e(Xl),e(ge),e(ql),e(ve),e(Ze),e(Be),e(_e),e($l),e(Ge),e(We),e(Re),e(Fl),e(ke),e(Ve),e(Ll),e(Ee),e(Dl),e(xe),e(Kl),e(Xe),e(Pl),e(qe),e(Qe),e(ls),e(Ne),e(Se),e(ts)),e(j),T(u,l),T(d,l),T(I,l),T(C,l),T(Z,l),T(k,l),T(V,l),T(x,l),T(Q,l),T(S,l),T(H,l),T(F,l),T(D,l),T(O,l),T(ll,l),T(nl,l),T(wl,l),T(Jl,l),T(Tl,l),T(Ul,l),T(cl,l),T(hl,l),T(Zl,l),T(Bl,l),T(_l,l),T(Wl,l),T(El,l),T(xl,l),T(Ql,l),T(Nl,l),T(Sl,l),T(Hl,l),T(zl,l),T(Yl,l),T(Ol,l),T(ss,l)}}}const Mn='{"title":"Signature-Aware Model Serving from MLflow with Ray Serve","local":"signature-aware-model-serving-from-mlflow-with-ray-serve","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Motivation","local":"motivation","sections":[],"depth":2},{"title":"Components","local":"components","sections":[],"depth":2},{"title":"Register the Model","local":"register-the-model","sections":[],"depth":2},{"title":"Serve the Model","local":"serve-the-model","sections":[],"depth":2},{"title":"Multiple Versions, One Endpoint","local":"multiple-versions-one-endpoint","sections":[],"depth":2},{"title":"Auto-Signature","local":"auto-signature","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Exercises","local":"exercises","sections":[],"depth":2}],"depth":1}';function on(He){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rn extends Ot{constructor(j){super(),ln(this,j,on,an,Dt,{})}}export{rn as component};
