import{s as Me,n as _e,o as we}from"../chunks/scheduler.85c25b89.js";import{S as be,i as ye,g as a,s,r as u,A as Te,h as o,f as n,c as l,j as ne,u as m,x as c,k as ie,y as le,a as i,v as d,d as f,t as h,w as g}from"../chunks/index.c9bcf812.js";import{D as ge}from"../chunks/Docstring.631f5571.js";import{C as ve}from"../chunks/CodeBlock.c004bd26.js";import{H as E}from"../chunks/getInferenceSnippets.80b657e7.js";function Ne(ae){let r,H,Z,C,M,G,_,L,w,oe='<a href="https://huggingface.co/papers/2211.09800" rel="nofollow">InstructPix2Pix: Learning to Follow Image Editing Instructions</a> is by Tim Brooks, Aleksander Holynski and Alexei A. Efros.',z,b,re="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",B,y,Q,T,pe="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",V,v,ue="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",X,N,me="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionInstructPix2PixPipeline</code> class.",D,x,F,J,ce="With the <code>NeuronStableDiffusionInstructPix2PixPipeline</code> class, you can apply instruction-based image editing using both text guidance and image guidance.",q,U,R,$,de='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Add a beautiful sunset</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/11-sd-ip2p.png" alt="drawing" width="250"/></td></tr></tbody>',Y,I,A,p,P,se,k,j,K,S,fe='Are there any other diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',O,W,ee;return M=new E({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),_=new E({props:{title:"Overview",local:"overview",headingTag:"h2"}}),y=new E({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),x=new E({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),U=new ve({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBQSUwlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSklMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJzZF9pcDJwJTJGJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWRkJTIwYSUyMGJlYXV0aWZ1bCUyMHN1bnNldCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnN1bnNldF9tb3VudGFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInstructPix2PixPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

pipe = NeuronStableDiffusionInstructPix2PixPipeline.from_pretrained(
  model_id, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">True</span>, **input_shapes,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_ip2p/&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Add a beautiful sunset&quot;</span>
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sunset_mountain.png&quot;</span>)`,wrap:!1}}),I=new E({props:{title:"NeuronStableDiffusionInstructPix2PixPipeline",local:"optimum.neuron.NeuronStableDiffusionInstructPix2PixPipeline",headingTag:"h4"}}),P=new ge({props:{name:"class optimum.neuron.NeuronStableDiffusionInstructPix2PixPipeline",anchor:"optimum.neuron.NeuronStableDiffusionInstructPix2PixPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1535"}}),j=new ge({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionInstructPix2PixPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1087"}}),{c(){r=a("meta"),H=s(),Z=a("p"),C=s(),u(M.$$.fragment),G=s(),u(_.$$.fragment),L=s(),w=a("p"),w.innerHTML=oe,z=s(),b=a("p"),b.innerHTML=re,B=s(),u(y.$$.fragment),Q=s(),T=a("p"),T.innerHTML=pe,V=s(),v=a("ul"),v.innerHTML=ue,X=s(),N=a("p"),N.innerHTML=me,D=s(),u(x.$$.fragment),F=s(),J=a("p"),J.innerHTML=ce,q=s(),u(U.$$.fragment),R=s(),$=a("table"),$.innerHTML=de,Y=s(),u(I.$$.fragment),A=s(),p=a("div"),u(P.$$.fragment),se=s(),k=a("div"),u(j.$$.fragment),K=s(),S=a("p"),S.innerHTML=fe,O=s(),W=a("p"),this.h()},l(e){const t=Te("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(n),H=l(e),Z=o(e,"P",{}),ne(Z).forEach(n),C=l(e),m(M.$$.fragment,e),G=l(e),m(_.$$.fragment,e),L=l(e),w=o(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1tl4gnd"&&(w.innerHTML=oe),z=l(e),b=o(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1g87d8z"&&(b.innerHTML=re),B=l(e),m(y.$$.fragment,e),Q=l(e),T=o(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-3qllio"&&(T.innerHTML=pe),V=l(e),v=o(e,"UL",{"data-svelte-h":!0}),c(v)!=="svelte-1c1t3y0"&&(v.innerHTML=ue),X=l(e),N=o(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-xuclry"&&(N.innerHTML=me),D=l(e),m(x.$$.fragment,e),F=l(e),J=o(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1836mxv"&&(J.innerHTML=ce),q=l(e),m(U.$$.fragment,e),R=l(e),$=o(e,"TABLE",{"data-svelte-h":!0}),c($)!=="svelte-w6yzym"&&($.innerHTML=de),Y=l(e),m(I.$$.fragment,e),A=l(e),p=o(e,"DIV",{class:!0});var te=ne(p);m(P.$$.fragment,te),se=l(te),k=o(te,"DIV",{class:!0});var he=ne(k);m(j.$$.fragment,he),he.forEach(n),te.forEach(n),K=l(e),S=o(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1wos5lv"&&(S.innerHTML=fe),O=l(e),W=o(e,"P",{}),ne(W).forEach(n),this.h()},h(){ie(r,"name","hf:doc:metadata"),ie(r,"content",xe),ie(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ie(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){le(document.head,r),i(e,H,t),i(e,Z,t),i(e,C,t),d(M,e,t),i(e,G,t),d(_,e,t),i(e,L,t),i(e,w,t),i(e,z,t),i(e,b,t),i(e,B,t),d(y,e,t),i(e,Q,t),i(e,T,t),i(e,V,t),i(e,v,t),i(e,X,t),i(e,N,t),i(e,D,t),d(x,e,t),i(e,F,t),i(e,J,t),i(e,q,t),d(U,e,t),i(e,R,t),i(e,$,t),i(e,Y,t),d(I,e,t),i(e,A,t),i(e,p,t),d(P,p,null),le(p,se),le(p,k),d(j,k,null),i(e,K,t),i(e,S,t),i(e,O,t),i(e,W,t),ee=!0},p:_e,i(e){ee||(f(M.$$.fragment,e),f(_.$$.fragment,e),f(y.$$.fragment,e),f(x.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(P.$$.fragment,e),f(j.$$.fragment,e),ee=!0)},o(e){h(M.$$.fragment,e),h(_.$$.fragment,e),h(y.$$.fragment,e),h(x.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(P.$$.fragment,e),h(j.$$.fragment,e),ee=!1},d(e){e&&(n(H),n(Z),n(C),n(G),n(L),n(w),n(z),n(b),n(B),n(Q),n(T),n(V),n(v),n(X),n(N),n(D),n(F),n(J),n(q),n(R),n($),n(Y),n(A),n(p),n(K),n(S),n(O),n(W)),n(r),g(M,e),g(_,e),g(y,e),g(x,e),g(U,e),g(I,e),g(P),g(j)}}}const xe='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Export to Neuron","local":"export-to-neuron","sections":[],"depth":2},{"title":"Usage Example","local":"usage-example","sections":[{"title":"NeuronStableDiffusionInstructPix2PixPipeline","local":"optimum.neuron.NeuronStableDiffusionInstructPix2PixPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function Je(ae){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Se extends be{constructor(r){super(),ye(this,r,Je,Ne,Me,{})}}export{Se as component};
