import{s as Dn,o as qn,n as ol}from"../chunks/scheduler.85c25b89.js";import{S as Kn,i as ei,g as s,s as i,r as p,A as li,h as r,f as t,c as a,j as Pn,u as y,x as M,k as On,y as ti,a as n,v as c,d as U,t as T,w as u}from"../chunks/index.c9bcf812.js";import{T as ml}from"../chunks/Tip.d8f753fa.js";import{C as B}from"../chunks/CodeBlock.c004bd26.js";import{H as J}from"../chunks/getInferenceSnippets.80b657e7.js";function ni(g){let m,b="All the training examples in the optimum-neuron repo use these parallelism features via the <code>NeuronTrainer</code>.";return{c(){m=s("p"),m.innerHTML=b},l(d){m=r(d,"P",{"data-svelte-h":!0}),M(m)!=="svelte-1s96mwn"&&(m.innerHTML=b)},m(d,w){n(d,m,w)},p:ol,d(d){d&&t(m)}}}function ii(g){let m,b="Since the example scripts use the <code>NeuronTrainer</code>, you can enable ZeRO-1 when using them by adding the <code>--zero_1</code> flag to your command line.",d,w,j="For example:",C,h,$;return h=new B({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMGV4YW1wbGVzJTJGdHJhaW5pbmclMkZxd2VuMyUyRmZpbmV0dW5lX3F3ZW4zLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBRd2VuJTJGUXdlbjIuNS0wLjVCJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjB3aWtpdGV4dCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9jb25maWdfbmFtZSUyMHdpa2l0ZXh0LTItcmF3LXYxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kb190cmFpbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmxvY2tfc2l6ZSUyMDEwMjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWJmMTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXplcm9fMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjAyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwbXlfdHJhaW5pbmclMkY=",highlighted:`torchrun --nproc_per_node=2 examples/training/qwen3/finetune_qwen3.py \\
    --model_name_or_path Qwen/Qwen2.5-0.5B \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --zero_1 \\
    --tensor_parallel_size 2 \\
    --output_dir my_training/`,wrap:!1}}),{c(){m=s("p"),m.innerHTML=b,d=i(),w=s("p"),w.textContent=j,C=i(),p(h.$$.fragment)},l(o){m=r(o,"P",{"data-svelte-h":!0}),M(m)!=="svelte-nmzr1t"&&(m.innerHTML=b),d=a(o),w=r(o,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1gkqha7"&&(w.textContent=j),C=a(o),y(h.$$.fragment,o)},m(o,f){n(o,m,f),n(o,d,f),n(o,w,f),n(o,C,f),c(h,o,f),$=!0},p:ol,i(o){$||(U(h.$$.fragment,o),$=!0)},o(o){T(h.$$.fragment,o),$=!1},d(o){o&&(t(m),t(d),t(w),t(C)),u(h,o)}}}function ai(g){let m,b="Since the example scripts use the <code>NeuronTrainer</code>, you can enable Tensor Parallelism when using them by specifying the <code>--tensor_parallel_size</code> argument.",d,w,j="For example:",C,h,$;return h=new B({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEOCUyMGV4YW1wbGVzJTJGdHJhaW5pbmclMkZxd2VuMyUyRmZpbmV0dW5lX3F3ZW4zLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBRd2VuJTJGUXdlbjIuNS0wLjVCJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjB3aWtpdGV4dCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9jb25maWdfbmFtZSUyMHdpa2l0ZXh0LTItcmF3LXYxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kb190cmFpbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmxvY2tfc2l6ZSUyMDEwMjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWJmMTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMG15X3RyYWluaW5nJTJG",highlighted:`torchrun --nproc_per_node=8 examples/training/qwen3/finetune_qwen3.py \\
    --model_name_or_path Qwen/Qwen2.5-0.5B \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --tensor_parallel_size 8 \\
    --output_dir my_training/`,wrap:!1}}),{c(){m=s("p"),m.innerHTML=b,d=i(),w=s("p"),w.textContent=j,C=i(),p(h.$$.fragment)},l(o){m=r(o,"P",{"data-svelte-h":!0}),M(m)!=="svelte-7fhmhn"&&(m.innerHTML=b),d=a(o),w=r(o,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1gkqha7"&&(w.textContent=j),C=a(o),y(h.$$.fragment,o)},m(o,f){n(o,m,f),n(o,d,f),n(o,w,f),n(o,C,f),c(h,o,f),$=!0},p:ol,i(o){$||(U(h.$$.fragment,o),$=!0)},o(o){T(h.$$.fragment,o),$=!1},d(o){o&&(t(m),t(d),t(w),t(C)),u(h,o)}}}function si(g){let m,b="When using pipeline parallelism, the total number of processes should be at least <code>tensor_parallel_size * pipeline_parallel_size</code>. For example, with <code>tensor_parallel_size=2</code> and <code>pipeline_parallel_size=4</code>, you need 8 processes total.";return{c(){m=s("p"),m.innerHTML=b},l(d){m=r(d,"P",{"data-svelte-h":!0}),M(m)!=="svelte-1ypidsl"&&(m.innerHTML=b)},m(d,w){n(d,m,w)},p:ol,d(d){d&&t(m)}}}function ri(g){let m,b="The sharded checkpoints are saved under a directory called <code>shards</code>. The <code>optimum-cli neuron consolidate</code> command accepts as input both a directory that contains a <code>shards</code> directory, or the <code>shards</code> directory itself.";return{c(){m=s("p"),m.innerHTML=b},l(d){m=r(d,"P",{"data-svelte-h":!0}),M(m)!=="svelte-1sydsko"&&(m.innerHTML=b)},m(d,w){n(d,m,w)},p:ol,d(d){d&&t(m)}}}function Mi(g){let m,b,d,w,j,C,h,$="AWS Trainium instances provide powerful infrastructure for training large language models at scale. A <code>trn1.32xlarge</code> instance contains 16 Neuron devices with 32 cores total, offering 512GB of memory (16GB per core).",o,f,xt="However, training large models presents a fundamental challenge: by default, each Neuron core operates as an independent data-parallel worker, requiring the entire model, gradients, and optimizer state (approximately 4× the model size) to fit within a single core’s 16GB memory limit, with additional space needed for activations.",pl,V,Lt="For models that exceed these memory constraints, <code>optimum-neuron</code> provides sophisticated parallelism strategies that distribute computation and memory across multiple devices, enabling you to train models that would be impossible to fit on individual cores:",yl,G,cl,F,Ul,k,Pt='<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a> is an optimizer-level optimization that reduces memory usage without changing your model architecture.',Tl,R,Ot="<strong>How it works</strong>: Shards the optimizer state (gradients, momentum, variance) across data-parallel ranks instead of replicating it on each device.",ul,X,Dt="<strong>Memory savings</strong>: Reduces optimizer memory usage by <code>1/data_parellel_size</code>.",dl,N,qt="<strong>When to use</strong>: Always beneficial when training with multiple devices, regardless of model size.",wl,A,Jl,H,Kt='<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a> splits individual model layers across multiple devices.',hl,E,en="<strong>How it works</strong>: Shards matrix multiplications (linear layers, attention) along rows or columns across devices. Each device computes part of each layer, requiring communication between devices for each forward/backward pass.",bl,Q,ln="<strong>Memory savings</strong>: Reduces model parameter memory by <code>1/tensor_parallel_size</code>.",fl,z,tn="<strong>When to use</strong>: When your model is too large to fit on a single device, even after applying ZeRO-1.",Cl,Y,nn="<strong>Typical deployment</strong>: Usually applied within a single node (intra-node) due to high communication requirements.",jl,S,an="<strong>Trade-offs</strong>: Increases communication overhead between devices, which can slow down training if overused.",gl,x,$l,L,sn='<a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a> is an optimization that works alongside Tensor Parallelism to further reduce memory usage.',Bl,P,rn="<strong>How it works</strong>: Shards activations along the sequence dimension in regions where tensors are not already sharded by tensor parallelism.",Il,O,Mn="<strong>Memory savings</strong>: Reduces activation memory proportional to sequence length, especially beneficial for long sequences.",vl,D,mn="<strong>When to use</strong>: Always enable when using tensor parallelism - it provides additional memory savings with minimal overhead.",_l,q,on="<strong>Requirement</strong>: Only works in combination with tensor parallelism.",Wl,K,Zl,ee,pn='<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a> splits model layers across different devices.',Vl,le,yn="<strong>How it works</strong>: Divides your model into stages, with each stage containing consecutive layers running on different devices. Uses microbatching to keep all devices busy.",Gl,te,cn="<strong>Memory savings</strong>: Reduces model parameter memory by <code>1/pipeline_parallel_size</code>.",Fl,ne,Un="<strong>When to use</strong>: For very large models that don’t fit even with tensor parallelism, or when you want to scale across many devices with less communication overhead than tensor parallelism.",kl,ie,Tn="<strong>Typical deployment</strong>: Usually applied across multiple nodes (inter-node) to scale to larger numbers of devices while minimizing high-bandwidth communication requirements.",Rl,ae,un="<strong>Trade-offs</strong>: Introduces pipeline bubbles (idle time) and requires careful tuning of microbatch sizes.",Xl,se,dn="The good news is that it is possible to combine those techniques, and <code>optimum-neuron</code> makes it very easy!",Nl,I,Al,re,Hl,Me,wn="ZeRO-1 can be enabled either through the <code>NeuronTrainer</code> or directly with the <code>NeuronAccelerator</code>.",El,me,Ql,oe,zl,v,Yl,pe,Sl,ye,Jn="When using the <code>NeuronAccelerator</code> directly, you need to create a <code>TrainingNeuronConfig</code> and enable ZeRO-1 separately:",xl,ce,Ll,Ue,Pl,Te,hn="Tensor Parallelism can be used with either the <code>NeuronTrainer</code> or <code>NeuronAccelerator</code>.",Ol,ue,bn="<strong>Important</strong>: Tensor parallelism requires models that have a custom modeling implementation in <code>optimum.neuron.models.training</code>.",Dl,de,fn="When doing Tensor Parallelism, you have several important settings:",ql,we,Cn='<li>The <code>tensor_parallel_size</code>: Ideally it should be the smallest value for which the model fits in memory.</li> <li>Whether sequence parallelism should be enabled: <a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a> shards the activations on the sequence axis outside of the tensor parallel regions, saving memory by sharding the activations.</li>',Kl,Je,jn="When using distributed training, the training script is called by <code>torchrun</code>, which will dispatch it to workers, one worker per core. Each worker will load the sharded model and dispatch the parameters automatically across the cores. The <code>tensor_parallel_size</code> is the number of workers to shard the model parameters on.",et,he,lt,be,tt,_,nt,fe,it,Ce,gn="When using the <code>NeuronAccelerator</code> directly, you configure tensor parallelism through the <code>TrainingNeuronConfig</code>:",at,je,st,ge,rt,$e,$n="Pipeline Parallelism allows you to split your model layers across multiple devices, enabling training of very large models that wouldn’t fit on a single device, or even a signle node.",Mt,Be,Bn="<strong>Important</strong>: Pipeline parallelism requires models that have a custom modeling implementation in <code>optimum.neuron.models.training</code> and declare <code>SUPPORTS_PIPELINE_PARALLELISM = True</code>.",mt,Ie,ot,ve,In="Pipeline parallelism has several configuration parameters:",pt,_e,vn="<li><code>pipeline_parallel_size</code>: Number of pipeline stages (devices to split layers across)</li> <li><code>pipeline_parallel_num_microbatches</code>: Number of microbatches for pipeline scheduling</li> <li>When pipeline parallelism is enabled, ZeRO-1 can be automatically applied to the pipeline parallel optimizer</li>",yt,We,ct,Ze,Ut,Ve,Tt,Ge,ut,W,dt,Fe,wt,ke,_n="You can combine multiple parallelism strategies for maximum memory efficiency and performance. Here’s an example with all strategies combined:",Jt,Re,ht,Xe,bt,Ne,Wn="This configuration uses 4 * 2 = 8 total processes:",ft,Ae,Zn="<li>Each tensor parallel group has 4 processes</li> <li>Each pipeline stage runs on one tensor parallel group</li>",Ct,He,Vn="We can then run the training script on the <code>trn1.32xlarge</code> instance with 32 Neuron cores, resulting in the following configuration: <code>dp=4, tp=4, pp=2</code>, which means 4 data-parallel groups, each with 4 tensor-parallel devices, and 2 pipeline stages.",jt,Ee,gt,Qe,Gn="Since distributed training uses sharded checkpoints across different workers, you need to consolidate them to create a standard model checkpoint that can be shared and used outside of the specific training configuration.",$t,ze,Fn="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate</code> command:",Bt,Ye,It,Se,kn=`All you need to do is specify the sharded checkpoints directory and the output directory that will contain the consolidated checkpoints, and the command takes care of the rest.
It is also possible to specify the output format of the consolidated checkpoints. By default it will export them to the <code>safetensors</code> format, which is the recommended format to use.`,vt,xe,Rn="Example:",_t,Le,Xn="Training with distributed parallelism just completed and the output dir is called <code>my_training</code>. The directory looks like the following:",Wt,Pe,Zt,Oe,Nn="You can consolidate the sharded checkpoints in <code>my_training/shards</code>, which correspond to the sharded checkpoints saved at the end of training, by running the following command:",Vt,De,Gt,Z,Ft,qe,kt,Ke,Rt,el,An="<li><strong>Start with Tensor Parallelism</strong>: Use the smallest <code>tensor_parallel_size</code> that fits your model in memory</li> <li><strong>Add Pipeline Parallelism</strong>: For very large models, combine with pipeline parallelism</li> <li><strong>Enable Sequence Parallelism</strong>: Always enable when using tensor parallelism for memory savings (set <code>disable_sequence_parallel=False</code>)</li> <li><strong>Use ZeRO-1</strong>: Combine with any parallelism strategy for optimizer memory savings</li>",Xt,ll,Nt,tl,Hn="<li>Enable <code>gradient_checkpointing</code> for large models</li> <li>Set appropriate <code>pipeline_parallel_num_microbatches</code> for pipeline parallelism</li>",At,nl,Ht,il,Et,al,En="<li><strong>Out of Memory</strong>: Reduce batch size, increase parallelism, or enable gradient checkpointing</li> <li><strong>Model Not Supported</strong>: Ensure you’re using a model from <code>optimum.neuron.models.training</code></li> <li><strong>Pipeline Parallelism Fails</strong>: Check that the model supports pipeline parallelism</li> <li><strong>Incorrect Process Count</strong>: Ensure <code>nproc_per_node</code> matches your parallelism configuration</li>",Qt,sl,zt,rl,Qn="<li>Start with smaller models and parallelism sizes</li> <li>Check that all processes can communicate properly</li> <li>Verify checkpoint directories and permissions</li> <li>Monitor Neuron device utilization</li>",Yt,Ml,St;return j=new J({props:{title:"Distributed Training with optimum-neuron",local:"distributed-training-with-optimum-neuron",headingTag:"h1"}}),G=new J({props:{title:"Parallelism Strategies Overview",local:"parallelism-strategies-overview",headingTag:"h2"}}),F=new J({props:{title:"1. ZeRO-1 (Optimizer State Sharding)",local:"1-zero-1-optimizer-state-sharding",headingTag:"h3"}}),A=new J({props:{title:"2. Tensor Parallelism (Intra-layer Model Parallelism)",local:"2-tensor-parallelism-intra-layer-model-parallelism",headingTag:"h3"}}),x=new J({props:{title:"3. Sequence Parallelism (Activation Sharding)",local:"3-sequence-parallelism-activation-sharding",headingTag:"h3"}}),K=new J({props:{title:"4. Pipeline Parallelism (Inter-layer Model Parallelism)",local:"4-pipeline-parallelism-inter-layer-model-parallelism",headingTag:"h3"}}),I=new ml({props:{$$slots:{default:[ni]},$$scope:{ctx:g}}}),re=new J({props:{title:"How to enable ZeRO-1?",local:"how-to-enable-zero-1",headingTag:"h2"}}),me=new J({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),oe=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTIzJTIwRW5hYmxlJTIwWmVSTy0xJTIwaW4lMjB0aGUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBOZXVyb25UcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyLiUyRm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMEElMjAlMjAlMjAlMjB6ZXJvXzElM0RUcnVlJTJDJTIwJTIwJTIzJTIwRW5hYmxlJTIwWmVSTy0xJTBBJTIwJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBvdGhlciUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBOZXVyb25UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer

<span class="hljs-comment"># Enable ZeRO-1 in the training arguments</span>
training_args = NeuronTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    zero_1=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable ZeRO-1</span>
    bf16=<span class="hljs-literal">True</span>,
    <span class="hljs-comment"># ... other training arguments</span>
)

trainer = NeuronTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),v=new ml({props:{$$slots:{default:[ii]},$$scope:{ctx:g}}}),pe=new J({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),ce=new B({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25BY2NlbGVyYXRvciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5tb2RlbHMudHJhaW5pbmcuY29uZmlnJTIwaW1wb3J0JTIwVHJhaW5pbmdOZXVyb25Db25maWclMEElMEElMjMlMjBDcmVhdGUlMjB0aGUlMjB0cmFpbmluZyUyMGNvbmZpZ3VyYXRpb24lMEF0cm5fY29uZmlnJTIwJTNEJTIwVHJhaW5pbmdOZXVyb25Db25maWcoKSUwQSUwQSUyMyUyMENyZWF0ZSUyMGFjY2VsZXJhdG9yJTIwd2l0aCUyMFplUk8tMSUyMGVuYWJsZWQlMEFhY2NlbGVyYXRvciUyMCUzRCUyME5ldXJvbkFjY2VsZXJhdG9yKCUwQSUyMCUyMCUyMCUyMHRybl9jb25maWclM0R0cm5fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwemVyb18xJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMEVuYWJsZSUyMFplUk8tMSUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUzRCUyMmJmMTYlMjIlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjAuLi4lMjAlMjAlMjMlMjBZb3VyJTIwbW9kZWwlMjBpbnN0YW5jZSUwQW9wdGltaXplciUyMCUzRCUyMEFkYW1XKG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNENWUtNSklMEElMEElMjMlMjBQcmVwYXJlJTIwbW9kZWwlMjBhbmQlMjBvcHRpbWl6ZXIlMEFtb2RlbCUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronAccelerator
<span class="hljs-keyword">from</span> optimum.neuron.models.training.config <span class="hljs-keyword">import</span> TrainingNeuronConfig

<span class="hljs-comment"># Create the training configuration</span>
trn_config = TrainingNeuronConfig()

<span class="hljs-comment"># Create accelerator with ZeRO-1 enabled</span>
accelerator = NeuronAccelerator(
    trn_config=trn_config,
    zero_1=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable ZeRO-1</span>
    mixed_precision=<span class="hljs-string">&quot;bf16&quot;</span>,
)

model = ...  <span class="hljs-comment"># Your model instance</span>
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)

<span class="hljs-comment"># Prepare model and optimizer</span>
model, optimizer = accelerator.prepare(model, optimizer)`,wrap:!1}}),Ue=new J({props:{title:"How to enable Tensor Parallelism?",local:"how-to-enable-tensor-parallelism",headingTag:"h2"}}),he=new J({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),be=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwdGVuc29yJTIwcGFyYWxsZWxpc20lMjBpbiUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyME5ldXJvblRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGb3V0cHV0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGJmMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVuc29yX3BhcmFsbGVsX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwb3RoZXIlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQSklMEElMEF0cmFpbmVyJTIwJTNEJTIwTmV1cm9uVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer

<span class="hljs-comment"># Configure tensor parallelism in training arguments</span>
training_args = NeuronTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    bf16=<span class="hljs-literal">True</span>,
    tensor_parallel_size=<span class="hljs-number">8</span>,
    <span class="hljs-comment"># ... other training arguments</span>
)

trainer = NeuronTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),_=new ml({props:{$$slots:{default:[ai]},$$scope:{ctx:g}}}),fe=new J({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),je=new B({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25BY2NlbGVyYXRvciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5tb2RlbHMudHJhaW5pbmcuY29uZmlnJTIwaW1wb3J0JTIwVHJhaW5pbmdOZXVyb25Db25maWclMEElMEElMjMlMjBDb25maWd1cmUlMjB0ZW5zb3IlMjBwYXJhbGxlbGlzbSUwQXRybl9jb25maWclMjAlM0QlMjBUcmFpbmluZ05ldXJvbkNvbmZpZyglMEElMjAlMjAlMjAlMjB0ZW5zb3JfcGFyYWxsZWxfc2l6ZSUzRDglMkMlMEElMjAlMjAlMjAlMjBzZXF1ZW5jZV9wYXJhbGxlbF9lbmFibGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNoZWNrcG9pbnRfZGlyJTNETm9uZSUyQyUyMCUyMCUyMyUyMENhbiUyMGJlJTIwc3BlY2lmaWVkJTIwd2hlbiUyMHJlc3VtaW5nJTIwZnJvbSUyMGNoZWNrcG9pbnQlMEEpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBOZXVyb25BY2NlbGVyYXRvciglMEElMjAlMjAlMjAlMjB0cm5fY29uZmlnJTNEdHJuX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUzRCUyMmJmMTYlMjIlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjAuLi4lMjAlMjAlMjMlMjBZb3VyJTIwbW9kZWwlMjBpbnN0YW5jZSUwQW9wdGltaXplciUyMCUzRCUyMEFkYW1XKG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNENWUtNSklMEElMEFtb2RlbCUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronAccelerator
<span class="hljs-keyword">from</span> optimum.neuron.models.training.config <span class="hljs-keyword">import</span> TrainingNeuronConfig

<span class="hljs-comment"># Configure tensor parallelism</span>
trn_config = TrainingNeuronConfig(
    tensor_parallel_size=<span class="hljs-number">8</span>,
    sequence_parallel_enabled=<span class="hljs-literal">True</span>,
    checkpoint_dir=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Can be specified when resuming from checkpoint</span>
)

accelerator = NeuronAccelerator(
    trn_config=trn_config,
    mixed_precision=<span class="hljs-string">&quot;bf16&quot;</span>,
)

model = ...  <span class="hljs-comment"># Your model instance</span>
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)

model, optimizer = accelerator.prepare(model, optimizer)`,wrap:!1}}),ge=new J({props:{title:"How to enable Pipeline Parallelism?",local:"how-to-enable-pipeline-parallelism",headingTag:"h2"}}),Ie=new J({props:{title:"Configuration Options",local:"configuration-options",headingTag:"h3"}}),We=new J({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),Ze=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer
<span class="hljs-keyword">from</span> optimum.neuron.models.training <span class="hljs-keyword">import</span> LlamaForCausalLM  <span class="hljs-comment"># Custom model implementation</span>

<span class="hljs-comment"># Configure pipeline parallelism in training arguments</span>
training_args = NeuronTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Will be split into microbatches</span>
    bf16=<span class="hljs-literal">True</span>,
    tensor_parallel_size=<span class="hljs-number">2</span>,
    pipeline_parallel_size=<span class="hljs-number">4</span>,                    <span class="hljs-comment"># Split model across 4 pipeline stages</span>
    pipeline_parallel_num_microbatches=<span class="hljs-number">4</span>,        <span class="hljs-comment"># Number of microbatches</span>
    zero_1=<span class="hljs-literal">True</span>,                                 <span class="hljs-comment"># Enable ZeRO-1 with pipeline parallelism</span>
    <span class="hljs-comment"># ... other training arguments</span>
)

<span class="hljs-comment"># Load model using custom implementation - must be done with the model class directly</span>
model = LlamaForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Llama-3.2-3B&quot;</span>,
    trn_config=training_args.trn_config  <span class="hljs-comment"># Pass the auto-generated trn_config</span>
)

trainer = NeuronTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),Ve=new J({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),Ge=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uQWNjZWxlcmF0b3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24ubW9kZWxzLnRyYWluaW5nLmNvbmZpZyUyMGltcG9ydCUyMFRyYWluaW5nTmV1cm9uQ29uZmlnJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uLm1vZGVscy50cmFpbmluZyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMEFmcm9tJTIwdG9yY2gub3B0aW0lMjBpbXBvcnQlMjBBZGFtVyUwQSUwQSUyMyUyMENvbmZpZ3VyZSUyMGNvbWJpbmVkJTIwcGFyYWxsZWxpc20lMjBzdHJhdGVnaWVzJTBBdHJuX2NvbmZpZyUyMCUzRCUyMFRyYWluaW5nTmV1cm9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lX3BhcmFsbGVsX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfcGFyYWxsZWxfbnVtX21pY3JvYmF0Y2hlcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBzZXF1ZW5jZV9wYXJhbGxlbF9lbmFibGVkJTNEVHJ1ZSUyQyUwQSklMEElMEFhY2NlbGVyYXRvciUyMCUzRCUyME5ldXJvbkFjY2VsZXJhdG9yKCUwQSUyMCUyMCUyMCUyMHRybl9jb25maWclM0R0cm5fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwemVyb18xJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMENhbiUyMGNvbWJpbmUlMjB3aXRoJTIwWmVSTy0xJTBBJTIwJTIwJTIwJTIwbWl4ZWRfcHJlY2lzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSklMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjB3aXRoJTIwY3VzdG9tJTIwaW1wbGVtZW50YXRpb24lMEFtb2RlbCUyMCUzRCUyMExsYW1hRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0IlMjIlMkMlMEElMjAlMjAlMjAlMjB0cm5fY29uZmlnJTNEdHJuX2NvbmZpZyUwQSklMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUpJTBBbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwb3B0aW1pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronAccelerator
<span class="hljs-keyword">from</span> optimum.neuron.models.training.config <span class="hljs-keyword">import</span> TrainingNeuronConfig
<span class="hljs-keyword">from</span> optimum.neuron.models.training <span class="hljs-keyword">import</span> LlamaForCausalLM
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

<span class="hljs-comment"># Configure combined parallelism strategies</span>
trn_config = TrainingNeuronConfig(
    tensor_parallel_size=<span class="hljs-number">2</span>,
    pipeline_parallel_size=<span class="hljs-number">4</span>,
    pipeline_parallel_num_microbatches=<span class="hljs-number">4</span>,
    sequence_parallel_enabled=<span class="hljs-literal">True</span>,
)

accelerator = NeuronAccelerator(
    trn_config=trn_config,
    zero_1=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Can combine with ZeRO-1</span>
    mixed_precision=<span class="hljs-string">&quot;bf16&quot;</span>,
)

<span class="hljs-comment"># Load model with custom implementation</span>
model = LlamaForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Llama-3.2-3B&quot;</span>,
    trn_config=trn_config
)

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)
model, optimizer = accelerator.prepare(model, optimizer)`,wrap:!1}}),W=new ml({props:{$$slots:{default:[si]},$$scope:{ctx:g}}}),Fe=new J({props:{title:"Combining Parallelism Strategies",local:"combining-parallelism-strategies",headingTag:"h2"}}),Re=new J({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),Xe=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uLm1vZGVscy50cmFpbmluZyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBFeGFtcGxlJTNBJTIwQ29tYmluZSUyMGFsbCUyMHBhcmFsbGVsaXNtJTIwc3RyYXRlZ2llcyUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBOZXVyb25UcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyLiUyRm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFplUk8tMSUwQSUyMCUyMCUyMCUyMHplcm9fMSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBUZW5zb3IlMjBwYXJhbGxlbGlzbSUwQSUyMCUyMCUyMCUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGRpc2FibGVfc2VxdWVuY2VfcGFyYWxsZWwlM0RGYWxzZSUyQyUyMCUyMCUyMCUyMCUyMCUyMyUyMEVuYWJsZSUyMHNlcXVlbmNlJTIwcGFyYWxsZWxpc20lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQaXBlbGluZSUyMHBhcmFsbGVsaXNtJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfcGFyYWxsZWxfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9wYXJhbGxlbF9udW1fbWljcm9iYXRjaGVzJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEFkZGl0aW9uYWwlMjBvcHRpbWl6YXRpb25zJTBBJTIwJTIwJTIwJTIwZnVzZV9xa3YlM0RUcnVlJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRnVzZSUyMFFLViUyMHByb2plY3Rpb25zJTIwZm9yJTIwZWZmaWNpZW5jeSUwQSUyMCUyMCUyMCUyMGt2X3NpemVfbXVsdGlwbGllciUzRE5vbmUlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBdXRvLWNhbGN1bGF0ZSUyMG9wdGltYWwlMjBLViUyMG11bHRpcGxpZXIlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMG1vZGVsJTIwdXNpbmclMjBjdXN0b20lMjBpbXBsZW1lbnRhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0zQiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRybl9jb25maWclM0R0cmFpbmluZ19hcmdzLnRybl9jb25maWclMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyME5ldXJvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer
<span class="hljs-keyword">from</span> optimum.neuron.models.training <span class="hljs-keyword">import</span> LlamaForCausalLM

<span class="hljs-comment"># Example: Combine all parallelism strategies</span>
training_args = NeuronTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">32</span>,
    bf16=<span class="hljs-literal">True</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    
    <span class="hljs-comment"># ZeRO-1</span>
    zero_1=<span class="hljs-literal">True</span>,
    
    <span class="hljs-comment"># Tensor parallelism</span>
    tensor_parallel_size=<span class="hljs-number">4</span>,
    disable_sequence_parallel=<span class="hljs-literal">False</span>,     <span class="hljs-comment"># Enable sequence parallelism</span>
    
    <span class="hljs-comment"># Pipeline parallelism</span>
    pipeline_parallel_size=<span class="hljs-number">2</span>,
    pipeline_parallel_num_microbatches=<span class="hljs-number">8</span>,
    
    <span class="hljs-comment"># Additional optimizations</span>
    fuse_qkv=<span class="hljs-literal">True</span>,                      <span class="hljs-comment"># Fuse QKV projections for efficiency</span>
    kv_size_multiplier=<span class="hljs-literal">None</span>,            <span class="hljs-comment"># Auto-calculate optimal KV multiplier</span>
)

<span class="hljs-comment"># Load model using custom implementation</span>
model = LlamaForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Llama-3.2-3B&quot;</span>,
    trn_config=training_args.trn_config
)

trainer = NeuronTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),Ee=new J({props:{title:"Checkpoint consolidation",local:"checkpoint-consolidation",headingTag:"h2"}}),Ye=new B({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMC0taGVscCUwQSUwQXVzYWdlJTNBJTIwb3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMCU1Qi1oJTVEJTIwJTVCLWYlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlNUQlMjBjaGVja3BvaW50X2RpciUyMG91dHB1dF9kaXIlMEElMEFwb3NpdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwY2hlY2twb2ludF9kaXIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBwYXRoJTIwdG8lMjB0aGUlMjBkaXJlY3RvcnklMjBjb250YWluaW5nJTIwdGhlJTIwY2hlY2twb2ludHMuJTBBJTIwJTIwb3V0cHV0X2RpciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRoZSUyMHBhdGglMjB0byUyMHRoZSUyMG91dHB1dCUyMGRpcmVjdG9yeSUyMGNvbnRhaW5pbmclMjB0aGUlMjBjb25zb2xpZGF0ZWQlMjBjaGVja3BvaW50LiUwQSUwQW9wdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwLWglMkMlMjAtLWhlbHAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaG93JTIwdGhpcyUyMGhlbHAlMjBtZXNzYWdlJTIwYW5kJTIwZXhpdCUwQSUyMCUyMC1mJTIwJTdCcHl0b3JjaCUyQ3NhZmV0ZW5zb3JzJTdEJTJDJTIwLS1mb3JtYXQlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBmb3JtYXQlMjB1c2VkJTIwdG8lMjBzYXZlJTIwdGhlJTIwY29uc29saWRhdGVkJTIwY2hlY2twb2ludC4=",highlighted:`optimum-cli neuron consolidate --<span class="hljs-built_in">help</span>

usage: optimum-cli neuron consolidate [-h] [-f {pytorch,safetensors}] checkpoint_dir output_dir

positional arguments:
  checkpoint_dir        The path to the directory containing the checkpoints.
  output_dir            The path to the output directory containing the consolidated checkpoint.

optional arguments:
  -h, --<span class="hljs-built_in">help</span>            show this <span class="hljs-built_in">help</span> message and <span class="hljs-built_in">exit</span>
  -f {pytorch,safetensors}, --format {pytorch,safetensors}
                        The format used to save the consolidated checkpoint.`,wrap:!1}}),Pe=new B({props:{code:"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",highlighted:`my_training/
├── README.md
├── all_results.json 
├── checkpoint-10 
│   ├── config.json
│   ├── scheduler.pt
│   ├── special_tokens_map.json
│   ├── shards/
│   ├── tokenizer.json
│   ├── tokenizer.model
│   ├── tokenizer_config.json
│   ├── trainer_state.json
│   └── training_args.bin
├── config.json
├── special_tokens_map.json
├── shards/
│   ├── tp_rank_00_pp_rank_00
│   ├── tp_rank_01_pp_rank_00
│   ├── tp_rank_02_pp_rank_00
│   ├── tp_rank_03_pp_rank_00
│   ├── tp_rank_00_pp_rank_01
│   ├── tp_rank_01_pp_rank_01
│   ├── tp_rank_02_pp_rank_01
│   └── tp_rank_03_pp_rank_01
├── tokenizer.json
├── tokenizer.model
├── tokenizer_config.json
├── train_results.json
├── trainer_state.json
├── training_args.bin
└── trn_config.json`,wrap:!1}}),De=new B({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMG15X3RyYWluaW5nJTIwbXlfdHJhaW5pbmdfY29uc29saWRhdGVkX2NoZWNrcG9pbnQ=",highlighted:"optimum-cli neuron consolidate my_training my_training_consolidated_checkpoint",wrap:!1}}),Z=new ml({props:{$$slots:{default:[ri]},$$scope:{ctx:g}}}),qe=new J({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),Ke=new J({props:{title:"Choosing Parallelism Strategy",local:"choosing-parallelism-strategy",headingTag:"h3"}}),ll=new J({props:{title:"Memory Optimization",local:"memory-optimization",headingTag:"h3"}}),nl=new J({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h2"}}),il=new J({props:{title:"Common Issues",local:"common-issues",headingTag:"h3"}}),sl=new J({props:{title:"Debugging Tips",local:"debugging-tips",headingTag:"h3"}}),{c(){m=s("meta"),b=i(),d=s("p"),w=i(),p(j.$$.fragment),C=i(),h=s("p"),h.innerHTML=$,o=i(),f=s("p"),f.textContent=xt,pl=i(),V=s("p"),V.innerHTML=Lt,yl=i(),p(G.$$.fragment),cl=i(),p(F.$$.fragment),Ul=i(),k=s("p"),k.innerHTML=Pt,Tl=i(),R=s("p"),R.innerHTML=Ot,ul=i(),X=s("p"),X.innerHTML=Dt,dl=i(),N=s("p"),N.innerHTML=qt,wl=i(),p(A.$$.fragment),Jl=i(),H=s("p"),H.innerHTML=Kt,hl=i(),E=s("p"),E.innerHTML=en,bl=i(),Q=s("p"),Q.innerHTML=ln,fl=i(),z=s("p"),z.innerHTML=tn,Cl=i(),Y=s("p"),Y.innerHTML=nn,jl=i(),S=s("p"),S.innerHTML=an,gl=i(),p(x.$$.fragment),$l=i(),L=s("p"),L.innerHTML=sn,Bl=i(),P=s("p"),P.innerHTML=rn,Il=i(),O=s("p"),O.innerHTML=Mn,vl=i(),D=s("p"),D.innerHTML=mn,_l=i(),q=s("p"),q.innerHTML=on,Wl=i(),p(K.$$.fragment),Zl=i(),ee=s("p"),ee.innerHTML=pn,Vl=i(),le=s("p"),le.innerHTML=yn,Gl=i(),te=s("p"),te.innerHTML=cn,Fl=i(),ne=s("p"),ne.innerHTML=Un,kl=i(),ie=s("p"),ie.innerHTML=Tn,Rl=i(),ae=s("p"),ae.innerHTML=un,Xl=i(),se=s("p"),se.innerHTML=dn,Nl=i(),p(I.$$.fragment),Al=i(),p(re.$$.fragment),Hl=i(),Me=s("p"),Me.innerHTML=wn,El=i(),p(me.$$.fragment),Ql=i(),p(oe.$$.fragment),zl=i(),p(v.$$.fragment),Yl=i(),p(pe.$$.fragment),Sl=i(),ye=s("p"),ye.innerHTML=Jn,xl=i(),p(ce.$$.fragment),Ll=i(),p(Ue.$$.fragment),Pl=i(),Te=s("p"),Te.innerHTML=hn,Ol=i(),ue=s("p"),ue.innerHTML=bn,Dl=i(),de=s("p"),de.textContent=fn,ql=i(),we=s("ol"),we.innerHTML=Cn,Kl=i(),Je=s("p"),Je.innerHTML=jn,et=i(),p(he.$$.fragment),lt=i(),p(be.$$.fragment),tt=i(),p(_.$$.fragment),nt=i(),p(fe.$$.fragment),it=i(),Ce=s("p"),Ce.innerHTML=gn,at=i(),p(je.$$.fragment),st=i(),p(ge.$$.fragment),rt=i(),$e=s("p"),$e.textContent=$n,Mt=i(),Be=s("p"),Be.innerHTML=Bn,mt=i(),p(Ie.$$.fragment),ot=i(),ve=s("p"),ve.textContent=In,pt=i(),_e=s("ul"),_e.innerHTML=vn,yt=i(),p(We.$$.fragment),ct=i(),p(Ze.$$.fragment),Ut=i(),p(Ve.$$.fragment),Tt=i(),p(Ge.$$.fragment),ut=i(),p(W.$$.fragment),dt=i(),p(Fe.$$.fragment),wt=i(),ke=s("p"),ke.textContent=_n,Jt=i(),p(Re.$$.fragment),ht=i(),p(Xe.$$.fragment),bt=i(),Ne=s("p"),Ne.textContent=Wn,ft=i(),Ae=s("ul"),Ae.innerHTML=Zn,Ct=i(),He=s("p"),He.innerHTML=Vn,jt=i(),p(Ee.$$.fragment),gt=i(),Qe=s("p"),Qe.textContent=Gn,$t=i(),ze=s("p"),ze.innerHTML=Fn,Bt=i(),p(Ye.$$.fragment),It=i(),Se=s("p"),Se.innerHTML=kn,vt=i(),xe=s("p"),xe.textContent=Rn,_t=i(),Le=s("p"),Le.innerHTML=Xn,Wt=i(),p(Pe.$$.fragment),Zt=i(),Oe=s("p"),Oe.innerHTML=Nn,Vt=i(),p(De.$$.fragment),Gt=i(),p(Z.$$.fragment),Ft=i(),p(qe.$$.fragment),kt=i(),p(Ke.$$.fragment),Rt=i(),el=s("ol"),el.innerHTML=An,Xt=i(),p(ll.$$.fragment),Nt=i(),tl=s("ul"),tl.innerHTML=Hn,At=i(),p(nl.$$.fragment),Ht=i(),p(il.$$.fragment),Et=i(),al=s("ol"),al.innerHTML=En,Qt=i(),p(sl.$$.fragment),zt=i(),rl=s("ul"),rl.innerHTML=Qn,Yt=i(),Ml=s("p"),this.h()},l(e){const l=li("svelte-u9bgzb",document.head);m=r(l,"META",{name:!0,content:!0}),l.forEach(t),b=a(e),d=r(e,"P",{}),Pn(d).forEach(t),w=a(e),y(j.$$.fragment,e),C=a(e),h=r(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1hnco7m"&&(h.innerHTML=$),o=a(e),f=r(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-d2kadp"&&(f.textContent=xt),pl=a(e),V=r(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1ndq4u8"&&(V.innerHTML=Lt),yl=a(e),y(G.$$.fragment,e),cl=a(e),y(F.$$.fragment,e),Ul=a(e),k=r(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1mjmifd"&&(k.innerHTML=Pt),Tl=a(e),R=r(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1f0jrrz"&&(R.innerHTML=Ot),ul=a(e),X=r(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-18396cf"&&(X.innerHTML=Dt),dl=a(e),N=r(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-190zbi2"&&(N.innerHTML=qt),wl=a(e),y(A.$$.fragment,e),Jl=a(e),H=r(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1r1vc5"&&(H.innerHTML=Kt),hl=a(e),E=r(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-wsb08h"&&(E.innerHTML=en),bl=a(e),Q=r(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1rz7p8m"&&(Q.innerHTML=ln),fl=a(e),z=r(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-kpqjki"&&(z.innerHTML=tn),Cl=a(e),Y=r(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-fc78y5"&&(Y.innerHTML=nn),jl=a(e),S=r(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-otaiec"&&(S.innerHTML=an),gl=a(e),y(x.$$.fragment,e),$l=a(e),L=r(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-4fh0sm"&&(L.innerHTML=sn),Bl=a(e),P=r(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1cma7oi"&&(P.innerHTML=rn),Il=a(e),O=r(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-hrmmz0"&&(O.innerHTML=Mn),vl=a(e),D=r(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1obmcw0"&&(D.innerHTML=mn),_l=a(e),q=r(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-41lgu1"&&(q.innerHTML=on),Wl=a(e),y(K.$$.fragment,e),Zl=a(e),ee=r(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1lhkl2x"&&(ee.innerHTML=pn),Vl=a(e),le=r(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-a3vdn"&&(le.innerHTML=yn),Gl=a(e),te=r(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1jq8cu1"&&(te.innerHTML=cn),Fl=a(e),ne=r(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1vm5hdt"&&(ne.innerHTML=Un),kl=a(e),ie=r(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-4tw4cj"&&(ie.innerHTML=Tn),Rl=a(e),ae=r(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-l89uy8"&&(ae.innerHTML=un),Xl=a(e),se=r(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1p0ihsg"&&(se.innerHTML=dn),Nl=a(e),y(I.$$.fragment,e),Al=a(e),y(re.$$.fragment,e),Hl=a(e),Me=r(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1s8nzlr"&&(Me.innerHTML=wn),El=a(e),y(me.$$.fragment,e),Ql=a(e),y(oe.$$.fragment,e),zl=a(e),y(v.$$.fragment,e),Yl=a(e),y(pe.$$.fragment,e),Sl=a(e),ye=r(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-106kvj9"&&(ye.innerHTML=Jn),xl=a(e),y(ce.$$.fragment,e),Ll=a(e),y(Ue.$$.fragment,e),Pl=a(e),Te=r(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1r4hhew"&&(Te.innerHTML=hn),Ol=a(e),ue=r(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-v1qtdm"&&(ue.innerHTML=bn),Dl=a(e),de=r(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-n127re"&&(de.textContent=fn),ql=a(e),we=r(e,"OL",{"data-svelte-h":!0}),M(we)!=="svelte-pnxffy"&&(we.innerHTML=Cn),Kl=a(e),Je=r(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-1pr0t5"&&(Je.innerHTML=jn),et=a(e),y(he.$$.fragment,e),lt=a(e),y(be.$$.fragment,e),tt=a(e),y(_.$$.fragment,e),nt=a(e),y(fe.$$.fragment,e),it=a(e),Ce=r(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1ncu8vs"&&(Ce.innerHTML=gn),at=a(e),y(je.$$.fragment,e),st=a(e),y(ge.$$.fragment,e),rt=a(e),$e=r(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1vp0c4m"&&($e.textContent=$n),Mt=a(e),Be=r(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-1ytrjb2"&&(Be.innerHTML=Bn),mt=a(e),y(Ie.$$.fragment,e),ot=a(e),ve=r(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-wwttlo"&&(ve.textContent=In),pt=a(e),_e=r(e,"UL",{"data-svelte-h":!0}),M(_e)!=="svelte-9fwfrb"&&(_e.innerHTML=vn),yt=a(e),y(We.$$.fragment,e),ct=a(e),y(Ze.$$.fragment,e),Ut=a(e),y(Ve.$$.fragment,e),Tt=a(e),y(Ge.$$.fragment,e),ut=a(e),y(W.$$.fragment,e),dt=a(e),y(Fe.$$.fragment,e),wt=a(e),ke=r(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-ktf0yf"&&(ke.textContent=_n),Jt=a(e),y(Re.$$.fragment,e),ht=a(e),y(Xe.$$.fragment,e),bt=a(e),Ne=r(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-e9hr70"&&(Ne.textContent=Wn),ft=a(e),Ae=r(e,"UL",{"data-svelte-h":!0}),M(Ae)!=="svelte-138kta0"&&(Ae.innerHTML=Zn),Ct=a(e),He=r(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-1oatqej"&&(He.innerHTML=Vn),jt=a(e),y(Ee.$$.fragment,e),gt=a(e),Qe=r(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-10z9rkn"&&(Qe.textContent=Gn),$t=a(e),ze=r(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-24042q"&&(ze.innerHTML=Fn),Bt=a(e),y(Ye.$$.fragment,e),It=a(e),Se=r(e,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-7l8i2j"&&(Se.innerHTML=kn),vt=a(e),xe=r(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-11lpom8"&&(xe.textContent=Rn),_t=a(e),Le=r(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-15ioqnc"&&(Le.innerHTML=Xn),Wt=a(e),y(Pe.$$.fragment,e),Zt=a(e),Oe=r(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-1e8fv74"&&(Oe.innerHTML=Nn),Vt=a(e),y(De.$$.fragment,e),Gt=a(e),y(Z.$$.fragment,e),Ft=a(e),y(qe.$$.fragment,e),kt=a(e),y(Ke.$$.fragment,e),Rt=a(e),el=r(e,"OL",{"data-svelte-h":!0}),M(el)!=="svelte-1j56tw2"&&(el.innerHTML=An),Xt=a(e),y(ll.$$.fragment,e),Nt=a(e),tl=r(e,"UL",{"data-svelte-h":!0}),M(tl)!=="svelte-pjt7c2"&&(tl.innerHTML=Hn),At=a(e),y(nl.$$.fragment,e),Ht=a(e),y(il.$$.fragment,e),Et=a(e),al=r(e,"OL",{"data-svelte-h":!0}),M(al)!=="svelte-j5qw5u"&&(al.innerHTML=En),Qt=a(e),y(sl.$$.fragment,e),zt=a(e),rl=r(e,"UL",{"data-svelte-h":!0}),M(rl)!=="svelte-jjqy14"&&(rl.innerHTML=Qn),Yt=a(e),Ml=r(e,"P",{}),Pn(Ml).forEach(t),this.h()},h(){On(m,"name","hf:doc:metadata"),On(m,"content",mi)},m(e,l){ti(document.head,m),n(e,b,l),n(e,d,l),n(e,w,l),c(j,e,l),n(e,C,l),n(e,h,l),n(e,o,l),n(e,f,l),n(e,pl,l),n(e,V,l),n(e,yl,l),c(G,e,l),n(e,cl,l),c(F,e,l),n(e,Ul,l),n(e,k,l),n(e,Tl,l),n(e,R,l),n(e,ul,l),n(e,X,l),n(e,dl,l),n(e,N,l),n(e,wl,l),c(A,e,l),n(e,Jl,l),n(e,H,l),n(e,hl,l),n(e,E,l),n(e,bl,l),n(e,Q,l),n(e,fl,l),n(e,z,l),n(e,Cl,l),n(e,Y,l),n(e,jl,l),n(e,S,l),n(e,gl,l),c(x,e,l),n(e,$l,l),n(e,L,l),n(e,Bl,l),n(e,P,l),n(e,Il,l),n(e,O,l),n(e,vl,l),n(e,D,l),n(e,_l,l),n(e,q,l),n(e,Wl,l),c(K,e,l),n(e,Zl,l),n(e,ee,l),n(e,Vl,l),n(e,le,l),n(e,Gl,l),n(e,te,l),n(e,Fl,l),n(e,ne,l),n(e,kl,l),n(e,ie,l),n(e,Rl,l),n(e,ae,l),n(e,Xl,l),n(e,se,l),n(e,Nl,l),c(I,e,l),n(e,Al,l),c(re,e,l),n(e,Hl,l),n(e,Me,l),n(e,El,l),c(me,e,l),n(e,Ql,l),c(oe,e,l),n(e,zl,l),c(v,e,l),n(e,Yl,l),c(pe,e,l),n(e,Sl,l),n(e,ye,l),n(e,xl,l),c(ce,e,l),n(e,Ll,l),c(Ue,e,l),n(e,Pl,l),n(e,Te,l),n(e,Ol,l),n(e,ue,l),n(e,Dl,l),n(e,de,l),n(e,ql,l),n(e,we,l),n(e,Kl,l),n(e,Je,l),n(e,et,l),c(he,e,l),n(e,lt,l),c(be,e,l),n(e,tt,l),c(_,e,l),n(e,nt,l),c(fe,e,l),n(e,it,l),n(e,Ce,l),n(e,at,l),c(je,e,l),n(e,st,l),c(ge,e,l),n(e,rt,l),n(e,$e,l),n(e,Mt,l),n(e,Be,l),n(e,mt,l),c(Ie,e,l),n(e,ot,l),n(e,ve,l),n(e,pt,l),n(e,_e,l),n(e,yt,l),c(We,e,l),n(e,ct,l),c(Ze,e,l),n(e,Ut,l),c(Ve,e,l),n(e,Tt,l),c(Ge,e,l),n(e,ut,l),c(W,e,l),n(e,dt,l),c(Fe,e,l),n(e,wt,l),n(e,ke,l),n(e,Jt,l),c(Re,e,l),n(e,ht,l),c(Xe,e,l),n(e,bt,l),n(e,Ne,l),n(e,ft,l),n(e,Ae,l),n(e,Ct,l),n(e,He,l),n(e,jt,l),c(Ee,e,l),n(e,gt,l),n(e,Qe,l),n(e,$t,l),n(e,ze,l),n(e,Bt,l),c(Ye,e,l),n(e,It,l),n(e,Se,l),n(e,vt,l),n(e,xe,l),n(e,_t,l),n(e,Le,l),n(e,Wt,l),c(Pe,e,l),n(e,Zt,l),n(e,Oe,l),n(e,Vt,l),c(De,e,l),n(e,Gt,l),c(Z,e,l),n(e,Ft,l),c(qe,e,l),n(e,kt,l),c(Ke,e,l),n(e,Rt,l),n(e,el,l),n(e,Xt,l),c(ll,e,l),n(e,Nt,l),n(e,tl,l),n(e,At,l),c(nl,e,l),n(e,Ht,l),c(il,e,l),n(e,Et,l),n(e,al,l),n(e,Qt,l),c(sl,e,l),n(e,zt,l),n(e,rl,l),n(e,Yt,l),n(e,Ml,l),St=!0},p(e,[l]){const zn={};l&2&&(zn.$$scope={dirty:l,ctx:e}),I.$set(zn);const Yn={};l&2&&(Yn.$$scope={dirty:l,ctx:e}),v.$set(Yn);const Sn={};l&2&&(Sn.$$scope={dirty:l,ctx:e}),_.$set(Sn);const xn={};l&2&&(xn.$$scope={dirty:l,ctx:e}),W.$set(xn);const Ln={};l&2&&(Ln.$$scope={dirty:l,ctx:e}),Z.$set(Ln)},i(e){St||(U(j.$$.fragment,e),U(G.$$.fragment,e),U(F.$$.fragment,e),U(A.$$.fragment,e),U(x.$$.fragment,e),U(K.$$.fragment,e),U(I.$$.fragment,e),U(re.$$.fragment,e),U(me.$$.fragment,e),U(oe.$$.fragment,e),U(v.$$.fragment,e),U(pe.$$.fragment,e),U(ce.$$.fragment,e),U(Ue.$$.fragment,e),U(he.$$.fragment,e),U(be.$$.fragment,e),U(_.$$.fragment,e),U(fe.$$.fragment,e),U(je.$$.fragment,e),U(ge.$$.fragment,e),U(Ie.$$.fragment,e),U(We.$$.fragment,e),U(Ze.$$.fragment,e),U(Ve.$$.fragment,e),U(Ge.$$.fragment,e),U(W.$$.fragment,e),U(Fe.$$.fragment,e),U(Re.$$.fragment,e),U(Xe.$$.fragment,e),U(Ee.$$.fragment,e),U(Ye.$$.fragment,e),U(Pe.$$.fragment,e),U(De.$$.fragment,e),U(Z.$$.fragment,e),U(qe.$$.fragment,e),U(Ke.$$.fragment,e),U(ll.$$.fragment,e),U(nl.$$.fragment,e),U(il.$$.fragment,e),U(sl.$$.fragment,e),St=!0)},o(e){T(j.$$.fragment,e),T(G.$$.fragment,e),T(F.$$.fragment,e),T(A.$$.fragment,e),T(x.$$.fragment,e),T(K.$$.fragment,e),T(I.$$.fragment,e),T(re.$$.fragment,e),T(me.$$.fragment,e),T(oe.$$.fragment,e),T(v.$$.fragment,e),T(pe.$$.fragment,e),T(ce.$$.fragment,e),T(Ue.$$.fragment,e),T(he.$$.fragment,e),T(be.$$.fragment,e),T(_.$$.fragment,e),T(fe.$$.fragment,e),T(je.$$.fragment,e),T(ge.$$.fragment,e),T(Ie.$$.fragment,e),T(We.$$.fragment,e),T(Ze.$$.fragment,e),T(Ve.$$.fragment,e),T(Ge.$$.fragment,e),T(W.$$.fragment,e),T(Fe.$$.fragment,e),T(Re.$$.fragment,e),T(Xe.$$.fragment,e),T(Ee.$$.fragment,e),T(Ye.$$.fragment,e),T(Pe.$$.fragment,e),T(De.$$.fragment,e),T(Z.$$.fragment,e),T(qe.$$.fragment,e),T(Ke.$$.fragment,e),T(ll.$$.fragment,e),T(nl.$$.fragment,e),T(il.$$.fragment,e),T(sl.$$.fragment,e),St=!1},d(e){e&&(t(b),t(d),t(w),t(C),t(h),t(o),t(f),t(pl),t(V),t(yl),t(cl),t(Ul),t(k),t(Tl),t(R),t(ul),t(X),t(dl),t(N),t(wl),t(Jl),t(H),t(hl),t(E),t(bl),t(Q),t(fl),t(z),t(Cl),t(Y),t(jl),t(S),t(gl),t($l),t(L),t(Bl),t(P),t(Il),t(O),t(vl),t(D),t(_l),t(q),t(Wl),t(Zl),t(ee),t(Vl),t(le),t(Gl),t(te),t(Fl),t(ne),t(kl),t(ie),t(Rl),t(ae),t(Xl),t(se),t(Nl),t(Al),t(Hl),t(Me),t(El),t(Ql),t(zl),t(Yl),t(Sl),t(ye),t(xl),t(Ll),t(Pl),t(Te),t(Ol),t(ue),t(Dl),t(de),t(ql),t(we),t(Kl),t(Je),t(et),t(lt),t(tt),t(nt),t(it),t(Ce),t(at),t(st),t(rt),t($e),t(Mt),t(Be),t(mt),t(ot),t(ve),t(pt),t(_e),t(yt),t(ct),t(Ut),t(Tt),t(ut),t(dt),t(wt),t(ke),t(Jt),t(ht),t(bt),t(Ne),t(ft),t(Ae),t(Ct),t(He),t(jt),t(gt),t(Qe),t($t),t(ze),t(Bt),t(It),t(Se),t(vt),t(xe),t(_t),t(Le),t(Wt),t(Zt),t(Oe),t(Vt),t(Gt),t(Ft),t(kt),t(Rt),t(el),t(Xt),t(Nt),t(tl),t(At),t(Ht),t(Et),t(al),t(Qt),t(zt),t(rl),t(Yt),t(Ml)),t(m),u(j,e),u(G,e),u(F,e),u(A,e),u(x,e),u(K,e),u(I,e),u(re,e),u(me,e),u(oe,e),u(v,e),u(pe,e),u(ce,e),u(Ue,e),u(he,e),u(be,e),u(_,e),u(fe,e),u(je,e),u(ge,e),u(Ie,e),u(We,e),u(Ze,e),u(Ve,e),u(Ge,e),u(W,e),u(Fe,e),u(Re,e),u(Xe,e),u(Ee,e),u(Ye,e),u(Pe,e),u(De,e),u(Z,e),u(qe,e),u(Ke,e),u(ll,e),u(nl,e),u(il,e),u(sl,e)}}}const mi='{"title":"Distributed Training with optimum-neuron","local":"distributed-training-with-optimum-neuron","sections":[{"title":"Parallelism Strategies Overview","local":"parallelism-strategies-overview","sections":[{"title":"1. ZeRO-1 (Optimizer State Sharding)","local":"1-zero-1-optimizer-state-sharding","sections":[],"depth":3},{"title":"2. Tensor Parallelism (Intra-layer Model Parallelism)","local":"2-tensor-parallelism-intra-layer-model-parallelism","sections":[],"depth":3},{"title":"3. Sequence Parallelism (Activation Sharding)","local":"3-sequence-parallelism-activation-sharding","sections":[],"depth":3},{"title":"4. Pipeline Parallelism (Inter-layer Model Parallelism)","local":"4-pipeline-parallelism-inter-layer-model-parallelism","sections":[],"depth":3}],"depth":2},{"title":"How to enable ZeRO-1?","local":"how-to-enable-zero-1","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3}],"depth":2},{"title":"How to enable Tensor Parallelism?","local":"how-to-enable-tensor-parallelism","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3}],"depth":2},{"title":"How to enable Pipeline Parallelism?","local":"how-to-enable-pipeline-parallelism","sections":[{"title":"Configuration Options","local":"configuration-options","sections":[],"depth":3},{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3}],"depth":2},{"title":"Combining Parallelism Strategies","local":"combining-parallelism-strategies","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3}],"depth":2},{"title":"Checkpoint consolidation","local":"checkpoint-consolidation","sections":[],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[{"title":"Choosing Parallelism Strategy","local":"choosing-parallelism-strategy","sections":[],"depth":3},{"title":"Memory Optimization","local":"memory-optimization","sections":[],"depth":3}],"depth":2},{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Common Issues","local":"common-issues","sections":[],"depth":3},{"title":"Debugging Tips","local":"debugging-tips","sections":[],"depth":3}],"depth":2}],"depth":1}';function oi(g){return qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ui extends Kn{constructor(m){super(),ei(this,m,oi,Mi,Dn,{})}}export{ui as component};
