import{s as zt,o as Ft,n as et}from"../chunks/scheduler.182ea377.js";import{S as Lt,i as Et,g as p,s as a,r,A as Qt,h as i,f as t,c as n,j as St,u as d,x as m,k as U,y as Yt,a as l,v as c,d as h,t as u,w as f}from"../chunks/index.abf12888.js";import{T as Os}from"../chunks/Tip.230e2334.js";import{C as g}from"../chunks/CodeBlock.57fe6e13.js";import{D as At}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as I}from"../chunks/Heading.16916d63.js";function Dt(J){let o,y='💡 Read the <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> blog for more details about how the VAE, UNet, and text encoder models work.';return{c(){o=p("p"),o.innerHTML=y},l(M){o=i(M,"P",{"data-svelte-h":!0}),m(o)!=="svelte-14e2v6n"&&(o.innerHTML=y)},m(M,j){l(M,o,j)},p:et,d(M){M&&t(o)}}}function qt(J){let o,y="💡 The <code>guidance_scale</code> parameter determines how much weight should be given to the prompt when generating an image.";return{c(){o=p("p"),o.innerHTML=y},l(M){o=i(M,"P",{"data-svelte-h":!0}),m(o)!=="svelte-vswzt8"&&(o.innerHTML=y)},m(M,j){l(M,o,j)},p:et,d(M){M&&t(o)}}}function Pt(J){let o,y="💡 The height and width are divided by 8 because the <code>vae</code> model has 3 down-sampling layers. You can check by running the following:",M,j,w;return j=new g({props:{code:"MiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMjAlM0QlM0QlMjA4",highlighted:'<span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>) == <span class="hljs-number">8</span>',wrap:!1}}),{c(){o=p("p"),o.innerHTML=y,M=a(),r(j.$$.fragment)},l(b){o=i(b,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1c9k596"&&(o.innerHTML=y),M=n(b),d(j.$$.fragment,b)},m(b,T){l(b,o,T),l(b,M,T),c(j,b,T),w=!0},p:et,i(b){w||(h(j.$$.fragment,b),w=!0)},o(b){u(j.$$.fragment,b),w=!1},d(b){b&&(t(o),t(M)),f(j,b)}}}function Kt(J){let o,y,M,j,w,b,T,Xe,R,st='🧨 Diffusers is designed to be a user-friendly and flexible toolbox for building diffusion systems tailored to your use-case. At the core of the toolbox are models and schedulers. While the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> bundles these components together for convenience, you can also unbundle the pipeline and use the models and schedulers separately to create new diffusion systems.',He,N,tt="In this tutorial, you’ll learn how to use models and schedulers to assemble a diffusion system for inference, starting with a basic pipeline and then progressing to the Stable Diffusion pipeline.",Se,B,ze,X,lt="A pipeline is a quick and easy way to run a model for inference, requiring no more than four lines of code to generate an image:",Fe,H,Le,$,at='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ddpm-cat.png" alt="Image of cat created from DDPMPipeline"/>',Ee,S,nt="That was super easy, but how did the pipeline do that? Let’s breakdown the pipeline and take a look at what’s happening under the hood.",Qe,z,pt='In the example above, the pipeline contains a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> model and a <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>. The pipeline denoises an image by taking random noise the size of the desired output and passing it through the model several times. At each timestep, the model predicts the <em>noise residual</em> and the scheduler uses it to predict a less noisy image. The pipeline repeats this process until it reaches the end of the specified number of inference steps.',Ye,F,it="To recreate the pipeline with the model and scheduler separately, let’s write our own denoising process.",Ae,L,mt="<li>Load the model and scheduler:</li>",De,E,qe,Z,ot="<li>Set the number of timesteps to run the denoising process for:</li>",Pe,Q,Ke,v,rt="<li>Setting the scheduler timesteps creates a tensor with evenly spaced elements in it, 50 in this example. Each element corresponds to a timestep at which the model denoises an image. When you create the denoising loop later, you’ll iterate over this tensor to denoise an image:</li>",Oe,Y,es,C,dt="<li>Create some random noise with the same shape as the desired output:</li>",ss,A,ts,_,ct='<li>Now write a loop to iterate over the timesteps. At each timestep, the model does a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel.forward">UNet2DModel.forward()</a> pass and returns the noisy residual. The scheduler’s <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler.step">step()</a> method takes the noisy residual, timestep, and input and it predicts the image at the previous timestep. This output becomes the next input to the model in the denoising loop, and it’ll repeat until it reaches the end of the <code>timesteps</code> array.</li>',ls,D,as,q,ht="This is the entire denoising process, and you can use this same pattern to write any diffusion system.",ns,k,ut="<li>The last step is to convert the denoised output into an image:</li>",ps,P,is,K,ft="In the next section, you’ll put your skills to the test and breakdown the more complex Stable Diffusion pipeline. The steps are more or less the same. You’ll initialize the necessary components, and set the number of timesteps to create a <code>timestep</code> array. The <code>timestep</code> array is used in the denoising loop, and for each element in this array, the model predicts a less noisy image. The denoising loop iterates over the <code>timestep</code>’s, and at each timestep, it outputs a noisy residual and the scheduler uses it to predict a less noisy image at the previous timestep. This process is repeated until you reach the end of the <code>timestep</code> array.",ms,O,Mt="Let’s try it out!",os,ee,rs,se,gt="Stable Diffusion is a text-to-image <em>latent diffusion</em> model. It is called a latent diffusion model because it works with a lower-dimensional representation of the image instead of the actual pixel space, which makes it more memory efficient. The encoder compresses the image into a smaller representation, and a decoder to convert the compressed representation back into an image. For text-to-image models, you’ll need a tokenizer and an encoder to generate text embeddings. From the previous example, you already know you need a UNet model and a scheduler.",ds,te,bt="As you can see, this is already more complex than the DDPM pipeline which only contains a UNet model. The Stable Diffusion model has three separate pretrained models.",cs,V,hs,le,jt='Now that you know what you need for the Stable Diffusion pipeline, load all these components with the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method. You can find them in the pretrained <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> checkpoint, and each component is stored in a separate subfolder:',us,ae,fs,ne,yt='Instead of the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>, exchange it for the <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> to see how easy it is to plug a different scheduler in:',Ms,pe,gs,ie,wt="To speed up inference, move the models to a GPU since, unlike the scheduler, they have trainable weights:",bs,me,js,oe,ys,re,Tt="The next step is to tokenize the text to generate embeddings. The text is used to condition the UNet model and steer the diffusion process towards something that resembles the input prompt.",ws,W,Ts,de,Ut="Feel free to choose any prompt you like if you want to generate something else!",Us,ce,Js,he,Jt="Tokenize the text and generate the embeddings from the prompt:",$s,ue,Zs,fe,$t="You’ll also need to generate the <em>unconditional text embeddings</em> which are the embeddings for the padding token. These need to have the same shape (<code>batch_size</code> and <code>seq_length</code>) as the conditional <code>text_embeddings</code>:",vs,Me,Cs,ge,Zt="Let’s concatenate the conditional and unconditional embeddings into a batch to avoid doing two forward passes:",_s,be,ks,je,Vs,ye,vt="Next, generate some initial random noise as a starting point for the diffusion process. This is the latent representation of the image, and it’ll be gradually denoised. At this point, the <code>latent</code> image is smaller than the final image size but that’s okay though because the model will transform it into the final 512x512 image dimensions later.",Ws,x,xs,we,Gs,Te,Is,Ue,Ct='Start by scaling the input with the initial noise distribution, <em>sigma</em>, the noise scale value, which is required for improved schedulers like <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>:',Rs,Je,Ns,$e,_t="The last step is to create the denoising loop that’ll progressively transform the pure noise in <code>latents</code> to an image described by your prompt. Remember, the denoising loop needs to do three things:",Bs,Ze,kt="<li>Set the scheduler’s timesteps to use during denoising.</li> <li>Iterate over the timesteps.</li> <li>At each timestep, call the UNet model to predict the noise residual and pass it to the scheduler to compute the previous noisy sample.</li>",Xs,ve,Hs,Ce,Ss,_e,Vt="The final step is to use the <code>vae</code> to decode the latent representation into an image and get the decoded output with <code>sample</code>:",zs,ke,Fs,Ve,Wt="Lastly, convert the image to a <code>PIL.Image</code> to see your generated image!",Ls,We,Es,G,xt='<img src="https://huggingface.co/blog/assets/98_stable_diffusion/stable_diffusion_k_lms.png"/>',Qs,xe,Ys,Ge,Gt="From basic to complex pipelines, you’ve seen that all you really need to write your own diffusion system is a denoising loop. The loop should set the scheduler’s timesteps, iterate over them, and alternate between calling the UNet model to predict the noise residual and passing it to the scheduler to compute the previous noisy sample.",As,Ie,It="This is really what 🧨 Diffusers is designed for: to make it intuitive and easy to write your own diffusion system using models and schedulers.",Ds,Re,Rt="For your next steps, feel free to:",qs,Ne,Nt='<li>Learn how to <a href="../using-diffusers/contribute_pipeline">build and contribute a pipeline</a> to 🧨 Diffusers. We can’t wait and see what you’ll come up with!</li> <li>Explore <a href="../api/pipelines/overview">existing pipelines</a> in the library, and see if you can deconstruct and build a pipeline from scratch using the models and schedulers separately.</li>',Ps,Be,Ks;return w=new I({props:{title:"Understanding pipelines, models and schedulers",local:"understanding-pipelines-models-and-schedulers",headingTag:"h1"}}),T=new At({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"}]}}),B=new I({props:{title:"Deconstruct a basic pipeline",local:"deconstruct-a-basic-pipeline",headingTag:"h2"}}),H=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWRkcG0lMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBkZHBtKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>ddpm = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ddpm(num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),E=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFVOZXQyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNhdC0yNTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Q=new g({props:{code:"c2NoZWR1bGVyLnNldF90aW1lc3RlcHMoNTAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)',wrap:!1}}),Y=new g({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.timesteps
tensor([<span class="hljs-number">980</span>, <span class="hljs-number">960</span>, <span class="hljs-number">940</span>, <span class="hljs-number">920</span>, <span class="hljs-number">900</span>, <span class="hljs-number">880</span>, <span class="hljs-number">860</span>, <span class="hljs-number">840</span>, <span class="hljs-number">820</span>, <span class="hljs-number">800</span>, <span class="hljs-number">780</span>, <span class="hljs-number">760</span>, <span class="hljs-number">740</span>, <span class="hljs-number">720</span>,
    <span class="hljs-number">700</span>, <span class="hljs-number">680</span>, <span class="hljs-number">660</span>, <span class="hljs-number">640</span>, <span class="hljs-number">620</span>, <span class="hljs-number">600</span>, <span class="hljs-number">580</span>, <span class="hljs-number">560</span>, <span class="hljs-number">540</span>, <span class="hljs-number">520</span>, <span class="hljs-number">500</span>, <span class="hljs-number">480</span>, <span class="hljs-number">460</span>, <span class="hljs-number">440</span>,
    <span class="hljs-number">420</span>, <span class="hljs-number">400</span>, <span class="hljs-number">380</span>, <span class="hljs-number">360</span>, <span class="hljs-number">340</span>, <span class="hljs-number">320</span>, <span class="hljs-number">300</span>, <span class="hljs-number">280</span>, <span class="hljs-number">260</span>, <span class="hljs-number">240</span>, <span class="hljs-number">220</span>, <span class="hljs-number">200</span>, <span class="hljs-number">180</span>, <span class="hljs-number">160</span>,
    <span class="hljs-number">140</span>, <span class="hljs-number">120</span>, <span class="hljs-number">100</span>,  <span class="hljs-number">80</span>,  <span class="hljs-number">60</span>,  <span class="hljs-number">40</span>,  <span class="hljs-number">20</span>,   <span class="hljs-number">0</span>])`,wrap:!1}}),A=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzYW1wbGVfc2l6ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5zYW1wbGVfc2l6ZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjAzJTJDJTIwc2FtcGxlX3NpemUlMkMlMjBzYW1wbGVfc2l6ZSklMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_size = model.config.sample_size
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, sample_size, sample_size), device=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),D=new g({props:{code:"aW5wdXQlMjAlM0QlMjBub2lzZSUwQSUwQWZvciUyMHQlMjBpbiUyMHNjaGVkdWxlci50aW1lc3RlcHMlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChpbnB1dCUyQyUyMHQpLnNhbXBsZSUwQSUyMCUyMCUyMCUyMHByZXZpb3VzX25vaXN5X3NhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXN5X3Jlc2lkdWFsJTJDJTIwdCUyQyUyMGlucHV0KS5wcmV2X3NhbXBsZSUwQSUyMCUyMCUyMCUyMGlucHV0JTIwJTNEJTIwcHJldmlvdXNfbm9pc3lfc2FtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = noise

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> scheduler.timesteps:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noisy_residual = model(<span class="hljs-built_in">input</span>, t).sample
<span class="hljs-meta">... </span>    previous_noisy_sample = scheduler.step(noisy_residual, t, <span class="hljs-built_in">input</span>).prev_sample
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span> = previous_noisy_sample`,wrap:!1}}),P=new g({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjAoaW5wdXQlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkucm91bmQoKS50byh0b3JjaC51aW50OCkuY3B1KCkubnVtcHkoKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image = (<span class="hljs-built_in">input</span> / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),ee=new I({props:{title:"Deconstruct the Stable Diffusion pipeline",local:"deconstruct-the-stable-diffusion-pipeline",headingTag:"h2"}}),V=new Os({props:{$$slots:{default:[Dt]},$$scope:{ctx:J}}}),ae=new g({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUyQyUyMENMSVBUb2tlbml6ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUyQyUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwUE5ETVNjaGVkdWxlciUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ2YWUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwQ0xJUFRleHRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, UNet2DConditionModel, PNDMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder = CLIPTextModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),pe=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = UniPCMultistepScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),me=new g({props:{code:"dG9yY2hfZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXZhZS50byh0b3JjaF9kZXZpY2UpJTBBdGV4dF9lbmNvZGVyLnRvKHRvcmNoX2RldmljZSklMEF1bmV0LnRvKHRvcmNoX2RldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch_device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet.to(torch_device)`,wrap:!1}}),oe=new I({props:{title:"Create text embeddings",local:"create-text-embeddings",headingTag:"h3"}}),W=new Os({props:{$$slots:{default:[qt]},$$scope:{ctx:J}}}),ce=new g({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIyJTVEJTBBaGVpZ2h0JTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwZGVmYXVsdCUyMGhlaWdodCUyMG9mJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTBBd2lkdGglMjAlM0QlMjA1MTIlMjAlMjAlMjMlMjBkZWZhdWx0JTIwd2lkdGglMjBvZiUyMFN0YWJsZSUyMERpZmZ1c2lvbiUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyNSUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwZGVub2lzaW5nJTIwc3RlcHMlMEFndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDcuNSUyMCUyMCUyMyUyMFNjYWxlJTIwZm9yJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUyMCUyMCUyMyUyMFNlZWQlMjBnZW5lcmF0b3IlMjB0byUyMGNyZWF0ZSUyMHRoZSUyMGluaXRpYWwlMjBsYXRlbnQlMjBub2lzZSUwQWJhdGNoX3NpemUlMjAlM0QlMjBsZW4ocHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">512</span>  <span class="hljs-comment"># default height of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">512</span>  <span class="hljs-comment"># default width of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">25</span>  <span class="hljs-comment"># Number of denoising steps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># Scale for classifier-free guidance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Seed generator to create the initial latent noise</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-built_in">len</span>(prompt)`,wrap:!1}}),ue=new g({props:{code:"dGV4dF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0R0b2tlbml6ZXIubW9kZWxfbWF4X2xlbmd0aCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKHRleHRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_input = tokenizer(
<span class="hljs-meta">... </span>    prompt, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=tokenizer.model_max_length, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = text_encoder(text_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),Me=new g({props:{code:"bWF4X2xlbmd0aCUyMCUzRCUyMHRleHRfaW5wdXQuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlMEF1bmNvbmRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyJTIyJTVEJTIwKiUyMGJhdGNoX3NpemUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF1bmNvbmRfZW1iZWRkaW5ncyUyMCUzRCUyMHRleHRfZW5jb2Rlcih1bmNvbmRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>max_length = text_input.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_input = tokenizer([<span class="hljs-string">&quot;&quot;</span>] * batch_size, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=max_length, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_embeddings = text_encoder(uncond_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),be=new g({props:{code:"dGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2guY2F0KCU1QnVuY29uZF9lbWJlZGRpbmdzJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.cat([uncond_embeddings, text_embeddings])',wrap:!1}}),je=new I({props:{title:"Create random noise",local:"create-random-noise",headingTag:"h3"}}),x=new Os({props:{$$slots:{default:[Pt]},$$scope:{ctx:J}}}),we=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCUwQSUyMCUyMCUyMCUyMChiYXRjaF9zaXplJTJDJTIwdW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRHRvcmNoX2RldmljZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(
<span class="hljs-meta">... </span>    (batch_size, unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    device=torch_device,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Te=new I({props:{title:"Denoise the image",local:"denoise-the-image",headingTag:"h3"}}),Je=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwc2NoZWR1bGVyLmluaXRfbm9pc2Vfc2lnbWE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>latents = latents * scheduler.init_noise_sigma',wrap:!1}}),ve=new g({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzKSUwQSUwQWZvciUyMHQlMjBpbiUyMHRxZG0oc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBleHBhbmQlMjB0aGUlMjBsYXRlbnRzJTIwaWYlMjB3ZSUyMGFyZSUyMGRvaW5nJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMjB0byUyMGF2b2lkJTIwZG9pbmclMjB0d28lMjBmb3J3YXJkJTIwcGFzc2VzLiUwQSUyMCUyMCUyMCUyMGxhdGVudF9tb2RlbF9pbnB1dCUyMCUzRCUyMHRvcmNoLmNhdCglNUJsYXRlbnRzJTVEJTIwKiUyMDIpJTBBJTBBJTIwJTIwJTIwJTIwbGF0ZW50X21vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHRpbWVzdGVwJTNEdCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwcmVkaWN0JTIwdGhlJTIwbm9pc2UlMjByZXNpZHVhbCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwdW5ldChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTNEdGV4dF9lbWJlZGRpbmdzKS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJmb3JtJTIwZ3VpZGFuY2UlMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkX3VuY29uZCUyQyUyMG5vaXNlX3ByZWRfdGV4dCUyMCUzRCUyMG5vaXNlX3ByZWQuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwbm9pc2VfcHJlZF91bmNvbmQlMjAlMkIlMjBndWlkYW5jZV9zY2FsZSUyMColMjAobm9pc2VfcHJlZF90ZXh0JTIwLSUyMG5vaXNlX3ByZWRfdW5jb25kKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjB0aGUlMjBwcmV2aW91cyUyMG5vaXN5JTIwc2FtcGxlJTIweF90JTIwLSUzRSUyMHhfdC0xJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXNlX3ByZWQlMkMlMjB0JTJDJTIwbGF0ZW50cykucHJldl9zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(num_inference_steps)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tqdm(scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># expand the latents if we are doing classifier-free guidance to avoid doing two forward passes.</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    latent_model_input = scheduler.scale_model_input(latent_model_input, timestep=t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict the noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = scheduler.step(noise_pred, t, latents).prev_sample`,wrap:!1}}),Ce=new I({props:{title:"Decode the image",local:"decode-the-image",headingTag:"h3"}}),ke=new g({props:{code:"JTIzJTIwc2NhbGUlMjBhbmQlMjBkZWNvZGUlMjB0aGUlMjBpbWFnZSUyMGxhdGVudHMlMjB3aXRoJTIwdmFlJTBBbGF0ZW50cyUyMCUzRCUyMDElMjAlMkYlMjAwLjE4MjE1JTIwKiUyMGxhdGVudHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB2YWUuZGVjb2RlKGxhdGVudHMpLnNhbXBsZQ==",highlighted:`<span class="hljs-comment"># scale and decode the image latents with vae</span>
latents = <span class="hljs-number">1</span> / <span class="hljs-number">0.18215</span> * latents
<span class="hljs-keyword">with</span> torch.no_grad():
    image = vae.decode(latents).sample`,wrap:!1}}),We=new g({props:{code:"aW1hZ2UlMjAlM0QlMjAoaW1hZ2UlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkudG8odG9yY2gudWludDgpLmNwdSgpLm51bXB5KCklMEFpbWFnZXMlMjAlM0QlMjAoaW1hZ2UlMjAqJTIwMjU1KS5yb3VuZCgpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>images = (image * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),xe=new I({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){o=p("meta"),y=a(),M=p("p"),j=a(),r(w.$$.fragment),b=a(),r(T.$$.fragment),Xe=a(),R=p("p"),R.innerHTML=st,He=a(),N=p("p"),N.textContent=tt,Se=a(),r(B.$$.fragment),ze=a(),X=p("p"),X.textContent=lt,Fe=a(),r(H.$$.fragment),Le=a(),$=p("div"),$.innerHTML=at,Ee=a(),S=p("p"),S.textContent=nt,Qe=a(),z=p("p"),z.innerHTML=pt,Ye=a(),F=p("p"),F.textContent=it,Ae=a(),L=p("ol"),L.innerHTML=mt,De=a(),r(E.$$.fragment),qe=a(),Z=p("ol"),Z.innerHTML=ot,Pe=a(),r(Q.$$.fragment),Ke=a(),v=p("ol"),v.innerHTML=rt,Oe=a(),r(Y.$$.fragment),es=a(),C=p("ol"),C.innerHTML=dt,ss=a(),r(A.$$.fragment),ts=a(),_=p("ol"),_.innerHTML=ct,ls=a(),r(D.$$.fragment),as=a(),q=p("p"),q.textContent=ht,ns=a(),k=p("ol"),k.innerHTML=ut,ps=a(),r(P.$$.fragment),is=a(),K=p("p"),K.innerHTML=ft,ms=a(),O=p("p"),O.textContent=Mt,os=a(),r(ee.$$.fragment),rs=a(),se=p("p"),se.innerHTML=gt,ds=a(),te=p("p"),te.textContent=bt,cs=a(),r(V.$$.fragment),hs=a(),le=p("p"),le.innerHTML=jt,us=a(),r(ae.$$.fragment),fs=a(),ne=p("p"),ne.innerHTML=yt,Ms=a(),r(pe.$$.fragment),gs=a(),ie=p("p"),ie.textContent=wt,bs=a(),r(me.$$.fragment),js=a(),r(oe.$$.fragment),ys=a(),re=p("p"),re.textContent=Tt,ws=a(),r(W.$$.fragment),Ts=a(),de=p("p"),de.textContent=Ut,Us=a(),r(ce.$$.fragment),Js=a(),he=p("p"),he.textContent=Jt,$s=a(),r(ue.$$.fragment),Zs=a(),fe=p("p"),fe.innerHTML=$t,vs=a(),r(Me.$$.fragment),Cs=a(),ge=p("p"),ge.textContent=Zt,_s=a(),r(be.$$.fragment),ks=a(),r(je.$$.fragment),Vs=a(),ye=p("p"),ye.innerHTML=vt,Ws=a(),r(x.$$.fragment),xs=a(),r(we.$$.fragment),Gs=a(),r(Te.$$.fragment),Is=a(),Ue=p("p"),Ue.innerHTML=Ct,Rs=a(),r(Je.$$.fragment),Ns=a(),$e=p("p"),$e.innerHTML=_t,Bs=a(),Ze=p("ol"),Ze.innerHTML=kt,Xs=a(),r(ve.$$.fragment),Hs=a(),r(Ce.$$.fragment),Ss=a(),_e=p("p"),_e.innerHTML=Vt,zs=a(),r(ke.$$.fragment),Fs=a(),Ve=p("p"),Ve.innerHTML=Wt,Ls=a(),r(We.$$.fragment),Es=a(),G=p("div"),G.innerHTML=xt,Qs=a(),r(xe.$$.fragment),Ys=a(),Ge=p("p"),Ge.textContent=Gt,As=a(),Ie=p("p"),Ie.textContent=It,Ds=a(),Re=p("p"),Re.textContent=Rt,qs=a(),Ne=p("ul"),Ne.innerHTML=Nt,Ps=a(),Be=p("p"),this.h()},l(e){const s=Qt("svelte-u9bgzb",document.head);o=i(s,"META",{name:!0,content:!0}),s.forEach(t),y=n(e),M=i(e,"P",{}),St(M).forEach(t),j=n(e),d(w.$$.fragment,e),b=n(e),d(T.$$.fragment,e),Xe=n(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-eguqi8"&&(R.innerHTML=st),He=n(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-5khcjg"&&(N.textContent=tt),Se=n(e),d(B.$$.fragment,e),ze=n(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1o4pmop"&&(X.textContent=lt),Fe=n(e),d(H.$$.fragment,e),Le=n(e),$=i(e,"DIV",{class:!0,"data-svelte-h":!0}),m($)!=="svelte-ej6f4c"&&($.innerHTML=at),Ee=n(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-7b411q"&&(S.textContent=nt),Qe=n(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-rmfggx"&&(z.innerHTML=pt),Ye=n(e),F=i(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-mwr50"&&(F.textContent=it),Ae=n(e),L=i(e,"OL",{"data-svelte-h":!0}),m(L)!=="svelte-g7uo25"&&(L.innerHTML=mt),De=n(e),d(E.$$.fragment,e),qe=n(e),Z=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(Z)!=="svelte-o7kbas"&&(Z.innerHTML=ot),Pe=n(e),d(Q.$$.fragment,e),Ke=n(e),v=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(v)!=="svelte-1jnsvh9"&&(v.innerHTML=rt),Oe=n(e),d(Y.$$.fragment,e),es=n(e),C=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(C)!=="svelte-1hrlquj"&&(C.innerHTML=dt),ss=n(e),d(A.$$.fragment,e),ts=n(e),_=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(_)!=="svelte-1hivual"&&(_.innerHTML=ct),ls=n(e),d(D.$$.fragment,e),as=n(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-sdv3mq"&&(q.textContent=ht),ns=n(e),k=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(k)!=="svelte-1du7raq"&&(k.innerHTML=ut),ps=n(e),d(P.$$.fragment,e),is=n(e),K=i(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-t8ln8h"&&(K.innerHTML=ft),ms=n(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-tru974"&&(O.textContent=Mt),os=n(e),d(ee.$$.fragment,e),rs=n(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-hpeh95"&&(se.innerHTML=gt),ds=n(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1yb6q1d"&&(te.textContent=bt),cs=n(e),d(V.$$.fragment,e),hs=n(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1hy9tdr"&&(le.innerHTML=jt),us=n(e),d(ae.$$.fragment,e),fs=n(e),ne=i(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1mwizy3"&&(ne.innerHTML=yt),Ms=n(e),d(pe.$$.fragment,e),gs=n(e),ie=i(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1tr4efr"&&(ie.textContent=wt),bs=n(e),d(me.$$.fragment,e),js=n(e),d(oe.$$.fragment,e),ys=n(e),re=i(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-ltx5oa"&&(re.textContent=Tt),ws=n(e),d(W.$$.fragment,e),Ts=n(e),de=i(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-z6gwd8"&&(de.textContent=Ut),Us=n(e),d(ce.$$.fragment,e),Js=n(e),he=i(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-q7skg3"&&(he.textContent=Jt),$s=n(e),d(ue.$$.fragment,e),Zs=n(e),fe=i(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-e64ab9"&&(fe.innerHTML=$t),vs=n(e),d(Me.$$.fragment,e),Cs=n(e),ge=i(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-41mj23"&&(ge.textContent=Zt),_s=n(e),d(be.$$.fragment,e),ks=n(e),d(je.$$.fragment,e),Vs=n(e),ye=i(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1gyrog2"&&(ye.innerHTML=vt),Ws=n(e),d(x.$$.fragment,e),xs=n(e),d(we.$$.fragment,e),Gs=n(e),d(Te.$$.fragment,e),Is=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1ltl3zx"&&(Ue.innerHTML=Ct),Rs=n(e),d(Je.$$.fragment,e),Ns=n(e),$e=i(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-ul1wgx"&&($e.innerHTML=_t),Bs=n(e),Ze=i(e,"OL",{"data-svelte-h":!0}),m(Ze)!=="svelte-ceuo6w"&&(Ze.innerHTML=kt),Xs=n(e),d(ve.$$.fragment,e),Hs=n(e),d(Ce.$$.fragment,e),Ss=n(e),_e=i(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-rzriwa"&&(_e.innerHTML=Vt),zs=n(e),d(ke.$$.fragment,e),Fs=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-6reqqn"&&(Ve.innerHTML=Wt),Ls=n(e),d(We.$$.fragment,e),Es=n(e),G=i(e,"DIV",{class:!0,"data-svelte-h":!0}),m(G)!=="svelte-1b0w6va"&&(G.innerHTML=xt),Qs=n(e),d(xe.$$.fragment,e),Ys=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-9a4wlz"&&(Ge.textContent=Gt),As=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-u3h7jy"&&(Ie.textContent=It),Ds=n(e),Re=i(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-xe6tlx"&&(Re.textContent=Rt),qs=n(e),Ne=i(e,"UL",{"data-svelte-h":!0}),m(Ne)!=="svelte-wmho1r"&&(Ne.innerHTML=Nt),Ps=n(e),Be=i(e,"P",{}),St(Be).forEach(t),this.h()},h(){U(o,"name","hf:doc:metadata"),U(o,"content",Ot),U($,"class","flex justify-center"),U(Z,"start","2"),U(v,"start","3"),U(C,"start","4"),U(_,"start","5"),U(k,"start","6"),U(G,"class","flex justify-center")},m(e,s){Yt(document.head,o),l(e,y,s),l(e,M,s),l(e,j,s),c(w,e,s),l(e,b,s),c(T,e,s),l(e,Xe,s),l(e,R,s),l(e,He,s),l(e,N,s),l(e,Se,s),c(B,e,s),l(e,ze,s),l(e,X,s),l(e,Fe,s),c(H,e,s),l(e,Le,s),l(e,$,s),l(e,Ee,s),l(e,S,s),l(e,Qe,s),l(e,z,s),l(e,Ye,s),l(e,F,s),l(e,Ae,s),l(e,L,s),l(e,De,s),c(E,e,s),l(e,qe,s),l(e,Z,s),l(e,Pe,s),c(Q,e,s),l(e,Ke,s),l(e,v,s),l(e,Oe,s),c(Y,e,s),l(e,es,s),l(e,C,s),l(e,ss,s),c(A,e,s),l(e,ts,s),l(e,_,s),l(e,ls,s),c(D,e,s),l(e,as,s),l(e,q,s),l(e,ns,s),l(e,k,s),l(e,ps,s),c(P,e,s),l(e,is,s),l(e,K,s),l(e,ms,s),l(e,O,s),l(e,os,s),c(ee,e,s),l(e,rs,s),l(e,se,s),l(e,ds,s),l(e,te,s),l(e,cs,s),c(V,e,s),l(e,hs,s),l(e,le,s),l(e,us,s),c(ae,e,s),l(e,fs,s),l(e,ne,s),l(e,Ms,s),c(pe,e,s),l(e,gs,s),l(e,ie,s),l(e,bs,s),c(me,e,s),l(e,js,s),c(oe,e,s),l(e,ys,s),l(e,re,s),l(e,ws,s),c(W,e,s),l(e,Ts,s),l(e,de,s),l(e,Us,s),c(ce,e,s),l(e,Js,s),l(e,he,s),l(e,$s,s),c(ue,e,s),l(e,Zs,s),l(e,fe,s),l(e,vs,s),c(Me,e,s),l(e,Cs,s),l(e,ge,s),l(e,_s,s),c(be,e,s),l(e,ks,s),c(je,e,s),l(e,Vs,s),l(e,ye,s),l(e,Ws,s),c(x,e,s),l(e,xs,s),c(we,e,s),l(e,Gs,s),c(Te,e,s),l(e,Is,s),l(e,Ue,s),l(e,Rs,s),c(Je,e,s),l(e,Ns,s),l(e,$e,s),l(e,Bs,s),l(e,Ze,s),l(e,Xs,s),c(ve,e,s),l(e,Hs,s),c(Ce,e,s),l(e,Ss,s),l(e,_e,s),l(e,zs,s),c(ke,e,s),l(e,Fs,s),l(e,Ve,s),l(e,Ls,s),c(We,e,s),l(e,Es,s),l(e,G,s),l(e,Qs,s),c(xe,e,s),l(e,Ys,s),l(e,Ge,s),l(e,As,s),l(e,Ie,s),l(e,Ds,s),l(e,Re,s),l(e,qs,s),l(e,Ne,s),l(e,Ps,s),l(e,Be,s),Ks=!0},p(e,[s]){const Bt={};s&2&&(Bt.$$scope={dirty:s,ctx:e}),V.$set(Bt);const Xt={};s&2&&(Xt.$$scope={dirty:s,ctx:e}),W.$set(Xt);const Ht={};s&2&&(Ht.$$scope={dirty:s,ctx:e}),x.$set(Ht)},i(e){Ks||(h(w.$$.fragment,e),h(T.$$.fragment,e),h(B.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(P.$$.fragment,e),h(ee.$$.fragment,e),h(V.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(oe.$$.fragment,e),h(W.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),h(x.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(ve.$$.fragment,e),h(Ce.$$.fragment,e),h(ke.$$.fragment,e),h(We.$$.fragment,e),h(xe.$$.fragment,e),Ks=!0)},o(e){u(w.$$.fragment,e),u(T.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(P.$$.fragment,e),u(ee.$$.fragment,e),u(V.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(oe.$$.fragment,e),u(W.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(je.$$.fragment,e),u(x.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),u(ve.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(We.$$.fragment,e),u(xe.$$.fragment,e),Ks=!1},d(e){e&&(t(y),t(M),t(j),t(b),t(Xe),t(R),t(He),t(N),t(Se),t(ze),t(X),t(Fe),t(Le),t($),t(Ee),t(S),t(Qe),t(z),t(Ye),t(F),t(Ae),t(L),t(De),t(qe),t(Z),t(Pe),t(Ke),t(v),t(Oe),t(es),t(C),t(ss),t(ts),t(_),t(ls),t(as),t(q),t(ns),t(k),t(ps),t(is),t(K),t(ms),t(O),t(os),t(rs),t(se),t(ds),t(te),t(cs),t(hs),t(le),t(us),t(fs),t(ne),t(Ms),t(gs),t(ie),t(bs),t(js),t(ys),t(re),t(ws),t(Ts),t(de),t(Us),t(Js),t(he),t($s),t(Zs),t(fe),t(vs),t(Cs),t(ge),t(_s),t(ks),t(Vs),t(ye),t(Ws),t(xs),t(Gs),t(Is),t(Ue),t(Rs),t(Ns),t($e),t(Bs),t(Ze),t(Xs),t(Hs),t(Ss),t(_e),t(zs),t(Fs),t(Ve),t(Ls),t(Es),t(G),t(Qs),t(Ys),t(Ge),t(As),t(Ie),t(Ds),t(Re),t(qs),t(Ne),t(Ps),t(Be)),t(o),f(w,e),f(T,e),f(B,e),f(H,e),f(E,e),f(Q,e),f(Y,e),f(A,e),f(D,e),f(P,e),f(ee,e),f(V,e),f(ae,e),f(pe,e),f(me,e),f(oe,e),f(W,e),f(ce,e),f(ue,e),f(Me,e),f(be,e),f(je,e),f(x,e),f(we,e),f(Te,e),f(Je,e),f(ve,e),f(Ce,e),f(ke,e),f(We,e),f(xe,e)}}}const Ot='{"title":"Understanding pipelines, models and schedulers","local":"understanding-pipelines-models-and-schedulers","sections":[{"title":"Deconstruct a basic pipeline","local":"deconstruct-a-basic-pipeline","sections":[],"depth":2},{"title":"Deconstruct the Stable Diffusion pipeline","local":"deconstruct-the-stable-diffusion-pipeline","sections":[{"title":"Create text embeddings","local":"create-text-embeddings","sections":[],"depth":3},{"title":"Create random noise","local":"create-random-noise","sections":[],"depth":3},{"title":"Denoise the image","local":"denoise-the-image","sections":[],"depth":3},{"title":"Decode the image","local":"decode-the-image","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function el(J){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Lt{constructor(o){super(),Et(this,o,el,Kt,zt,{})}}export{il as component};
