import{s as vi,o as Zi,n as Vi}from"../chunks/scheduler.37c15a92.js";import{S as Wi,i as _i,g as i,s as n,r as o,A as Bi,h as p,f as s,c as a,j as Ci,u as c,x as r,k as aa,y as Qi,a as l,v as M,d as m,t as y,w as h}from"../chunks/index.2bf4358c.js";import{T as Ai}from"../chunks/Tip.363c041f.js";import{Y as Ri}from"../chunks/Youtube.1e50a667.js";import{C as u}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ni}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as Ms}from"../chunks/Heading.8ada512a.js";function Xi(ms){let d,j=`<strong>To go further</strong> If you test the two versions of the previous normalizers on a string containing the unicode character <code>u&quot;\\u0085&quot;</code> you will surely notice that these two normalizers are not exactly equivalent.
To not over-complicate the version with <code>normalizers.Sequence</code> too much , we haven’t included the Regex replacements that the <code>BertNormalizer</code> requires when the <code>clean_text</code> argument is set to <code>True</code> - which is the default behavior. But don’t worry: it is possible to get exactly the same normalization without using the handy <code>BertNormalizer</code> by adding two <code>normalizers.Replace</code>’s to the normalizers sequence.`;return{c(){d=i("p"),d.innerHTML=j},l(J){d=p(J,"P",{"data-svelte-h":!0}),r(d)!=="svelte-fwgfxt"&&(d.innerHTML=j)},m(J,os){l(J,d,os)},p:Vi,d(J){J&&s(d)}}}function Gi(ms){let d,j,J,os,k,ys,w,hs,b,ia="As we’ve seen in the previous sections, tokenization comprises several steps:",us,$,pa="<li>Normalization (any cleanup of the text that is deemed necessary, such as removing spaces or accents, Unicode normalization, etc.)</li> <li>Pre-tokenization (splitting the input into words)</li> <li>Running the input through the model (using the pre-tokenized words to produce a sequence of tokens)</li> <li>Post-processing (adding the special tokens of the tokenizer, generating the attention mask and token type IDs)</li>",ds,g,ra="As a reminder, here’s another look at the overall process:",Js,f,oa='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',fs,U,ca='The 🤗 Tokenizers library has been built to provide several options for each of those steps, which you can mix and match together. In this section we’ll see how we can build a tokenizer from scratch, as opposed to training a new tokenizer from an old one as we did in <a href="/course/chapter6/2">section 2</a>. You’ll then be able to build any kind of tokenizer you can think of!',Ts,x,js,z,Ma="More precisely, the library is built around a central <code>Tokenizer</code> class with the building blocks regrouped in submodules:",ks,I,ma='<li><code>normalizers</code> contains all the possible types of <code>Normalizer</code> you can use (complete list <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.normalizers" rel="nofollow">here</a>).</li> <li><code>pre_tokenizers</code> contains all the possible types of <code>PreTokenizer</code> you can use (complete list <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.pre_tokenizers" rel="nofollow">here</a>).</li> <li><code>models</code> contains the various types of <code>Model</code> you can use, like <code>BPE</code>, <code>WordPiece</code>, and <code>Unigram</code> (complete list <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.models" rel="nofollow">here</a>).</li> <li><code>trainers</code> contains all the different types of <code>Trainer</code> you can use to train your model on a corpus (one per type of model; complete list <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.trainers" rel="nofollow">here</a>).</li> <li><code>post_processors</code> contains the various types of <code>PostProcessor</code> you can use (complete list <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.processors" rel="nofollow">here</a>).</li> <li><code>decoders</code> contains the various types of <code>Decoder</code> you can use to decode the outputs of tokenization (complete list <a href="https://huggingface.co/docs/tokenizers/python/latest/components.html#decoders" rel="nofollow">here</a>).</li>',ws,C,ya='You can find the whole list of building blocks <a href="https://huggingface.co/docs/tokenizers/python/latest/components.html" rel="nofollow">here</a>.',bs,v,$s,Z,ha='To train our new tokenizer, we will use a small corpus of text (so the examples run fast). The steps for acquiring the corpus are similar to the ones we took at the <a href="/course/chapter6/2">beginning of this chapter</a>, but this time we’ll use the <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a> dataset:',gs,V,Us,W,ua="The function <code>get_training_corpus()</code> is a generator that will yield batches of 1,000 texts, which we will use to train the tokenizer.",xs,_,da="🤗 Tokenizers can also be trained on text files directly. Here’s how we can generate a text file containing all the texts/inputs from WikiText-2 that we can use locally:",zs,B,Is,Q,Ja="Next we’ll show you how to build your own BERT, GPT-2, and XLNet tokenizers, block by block. That will give us an example of each of the three main tokenization algorithms: WordPiece, BPE, and Unigram. Let’s start with BERT!",Cs,A,vs,R,fa="To build a tokenizer with the 🤗 Tokenizers library, we start by instantiating a <code>Tokenizer</code> object with a <code>model</code>, then set its <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code>, and <code>decoder</code> attributes to the values we want.",Zs,N,Ta="For this example, we’ll create a <code>Tokenizer</code> with a WordPiece model:",Vs,X,Ws,G,ja="We have to specify the <code>unk_token</code> so the model knows what to return when it encounters characters it hasn’t seen before. Other arguments we can set here include the <code>vocab</code> of our model (we’re going to train the model, so we don’t need to set this) and <code>max_input_chars_per_word</code>, which specifies a maximum length for each word (words longer than the value passed will be split).",_s,q,ka="The first step of tokenization is normalization, so let’s begin with that. Since BERT is widely used, there is a <code>BertNormalizer</code> with the classic options we can set for BERT: <code>lowercase</code> and <code>strip_accents</code>, which are self-explanatory; <code>clean_text</code> to remove all control characters and replace repeating spaces with a single one; and <code>handle_chinese_chars</code>, which places spaces around Chinese characters. To replicate the <code>bert-base-uncased</code> tokenizer, we can just set this normalizer:",Bs,L,Qs,H,wa="Generally speaking, however, when building a new tokenizer you won’t have access to such a handy normalizer already implemented in the 🤗 Tokenizers library — so let’s see how to create the BERT normalizer by hand. The library provides a <code>Lowercase</code> normalizer and a <code>StripAccents</code> normalizer, and you can compose several normalizers using a <code>Sequence</code>:",As,D,Rs,E,ba="We’re also using an <code>NFD</code> Unicode normalizer, as otherwise the <code>StripAccents</code> normalizer won’t properly recognize the accented characters and thus won’t strip them out.",Ns,S,$a="As we’ve seen before, we can use the <code>normalize_str()</code> method of the <code>normalizer</code> to check out the effects it has on a given text:",Xs,P,Gs,F,qs,T,Ls,Y,ga="Next is the pre-tokenization step. Again, there is a prebuilt <code>BertPreTokenizer</code> that we can use:",Hs,K,Ds,O,Ua="Or we can build it from scratch:",Es,ee,Ss,te,xa="Note that the <code>Whitespace</code> pre-tokenizer splits on whitespace and all characters that are not letters, digits, or the underscore character, so it technically splits on whitespace and punctuation:",Ps,se,Fs,le,Ys,ne,za="If you only want to split on whitespace, you should use the <code>WhitespaceSplit</code> pre-tokenizer instead:",Ks,ae,Os,ie,el,pe,Ia="Like with normalizers, you can use a <code>Sequence</code> to compose several pre-tokenizers:",tl,re,sl,oe,ll,ce,Ca="The next step in the tokenization pipeline is running the inputs through the model. We already specified our model in the initialization, but we still need to train it, which will require a <code>WordPieceTrainer</code>. The main thing to remember when instantiating a trainer in 🤗 Tokenizers is that you need to pass it all the special tokens you intend to use — otherwise it won’t add them to the vocabulary, since they are not in the training corpus:",nl,Me,al,me,va="As well as specifying the <code>vocab_size</code> and <code>special_tokens</code>, we can set the <code>min_frequency</code> (the number of times a token must appear to be included in the vocabulary) or change the <code>continuing_subword_prefix</code> (if we want to use something different from <code>##</code>).",il,ye,Za="To train our model using the iterator we defined earlier, we just have to execute this command:",pl,he,rl,ue,Va="We can also use text files to train our tokenizer, which would look like this (we reinitialize the model with an empty <code>WordPiece</code> beforehand):",ol,de,cl,Je,Wa="In both cases, we can then test the tokenizer on a text by calling the <code>encode()</code> method:",Ml,fe,ml,Te,yl,je,_a="The <code>encoding</code> obtained is an <code>Encoding</code>, which contains all the necessary outputs of the tokenizer in its various attributes: <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code>, and <code>overflowing</code>.",hl,ke,Ba="The last step in the tokenization pipeline is post-processing. We need to add the <code>[CLS]</code> token at the beginning and the <code>[SEP]</code> token at the end (or after each sentence, if we have a pair of sentences). We will use a <code>TemplateProcessor</code> for this, but first we need to know the IDs of the <code>[CLS]</code> and <code>[SEP]</code> tokens in the vocabulary:",ul,we,dl,be,Jl,$e,Qa="To write the template for the <code>TemplateProcessor</code>, we have to specify how to treat a single sentence and a pair of sentences. For both, we write the special tokens we want to use; the first (or single) sentence is represented by <code>$A</code>, while the second sentence (if encoding a pair) is represented by <code>$B</code>. For each of these (special tokens and sentences), we also specify the corresponding token type ID after a colon.",fl,ge,Aa="The classic BERT template is thus defined as follows:",Tl,Ue,jl,xe,Ra="Note that we need to pass along the IDs of the special tokens, so the tokenizer can properly convert them to their IDs.",kl,ze,Na="Once this is added, going back to our previous example will give:",wl,Ie,bl,Ce,$l,ve,Xa="And on a pair of sentences, we get the proper result:",gl,Ze,Ul,Ve,xl,We,Ga="We’ve almost finished building this tokenizer from scratch — the last step is to include a decoder:",zl,_e,Il,Be,qa="Let’s test it on our previous <code>encoding</code>:",Cl,Qe,vl,Ae,Zl,Re,La="Great! We can save our tokenizer in a single JSON file like this:",Vl,Ne,Wl,Xe,Ha="We can then reload that file in a <code>Tokenizer</code> object with the <code>from_file()</code> method:",_l,Ge,Bl,qe,Da="To use this tokenizer in 🤗 Transformers, we have to wrap it in a <code>PreTrainedTokenizerFast</code>. We can either use the generic class or, if our tokenizer corresponds to an existing model, use that class (here, <code>BertTokenizerFast</code>). If you apply this lesson to build a brand new tokenizer, you will have to use the first option.",Ql,Le,Ea="To wrap the tokenizer in a <code>PreTrainedTokenizerFast</code>, we can either pass the tokenizer we built as a <code>tokenizer_object</code> or pass the tokenizer file we saved as <code>tokenizer_file</code>. The key thing to remember is that we have to manually set all the special tokens, since that class can’t infer from the <code>tokenizer</code> object which token is the mask token, the <code>[CLS]</code> token, etc.:",Al,He,Rl,De,Sa="If you are using a specific tokenizer class (like <code>BertTokenizerFast</code>), you will only need to specify the special tokens that are different from the default ones (here, none):",Nl,Ee,Xl,Se,Pa="You can then use this tokenizer like any other 🤗 Transformers tokenizer. You can save it with the <code>save_pretrained()</code> method, or upload it to the Hub with the <code>push_to_hub()</code> method.",Gl,Pe,Fa="Now that we’ve seen how to build a WordPiece tokenizer, let’s do the same for a BPE tokenizer. We’ll go a bit faster since you know all the steps, and only highlight the differences.",ql,Fe,Ll,Ye,Ya="Let’s now build a GPT-2 tokenizer. Like for the BERT tokenizer, we start by initializing a <code>Tokenizer</code> with a BPE model:",Hl,Ke,Dl,Oe,Ka="Also like for BERT, we could initialize this model with a vocabulary if we had one (we would need to pass the <code>vocab</code> and <code>merges</code> in this case), but since we will train from scratch, we don’t need to do that. We also don’t need to specify an <code>unk_token</code> because GPT-2 uses byte-level BPE, which doesn’t require it.",El,et,Oa="GPT-2 does not use a normalizer, so we skip that step and go directly to the pre-tokenization:",Sl,tt,Pl,st,ei="The option we added to <code>ByteLevel</code> here is to not add a space at the beginning of a sentence (which is the default otherwise). We can have a look at the pre-tokenization of an example text like before:",Fl,lt,Yl,nt,Kl,at,ti="Next is the model, which needs training. For GPT-2, the only special token is the end-of-text token:",Ol,it,en,pt,si="Like with the <code>WordPieceTrainer</code>, as well as the <code>vocab_size</code> and <code>special_tokens</code>, we can specify the <code>min_frequency</code> if we want to, or if we have an end-of-word suffix (like <code>&lt;/w&gt;</code>), we can set it with <code>end_of_word_suffix</code>.",tn,rt,li="This tokenizer can also be trained on text files:",sn,ot,ln,ct,ni="Let’s have a look at the tokenization of a sample text:",nn,Mt,an,mt,pn,yt,ai="We apply the byte-level post-processing for the GPT-2 tokenizer as follows:",rn,ht,on,ut,ii="The <code>trim_offsets = False</code> option indicates to the post-processor that we should leave the offsets of tokens that begin with ‘Ġ’ as they are: this way the start of the offsets will point to the space before the word, not the first character of the word (since the space is technically part of the token). Let’s have a look at the result with the text we just encoded, where <code>&#39;Ġtest&#39;</code> is the token at index 4:",cn,dt,Mn,Jt,mn,ft,pi="Finally, we add a byte-level decoder:",yn,Tt,hn,jt,ri="and we can double-check it works properly:",un,kt,dn,wt,Jn,bt,oi="Great! Now that we’re done, we can save the tokenizer like before, and wrap it in a <code>PreTrainedTokenizerFast</code> or <code>GPT2TokenizerFast</code> if we want to use it in 🤗 Transformers:",fn,$t,Tn,gt,ci="or:",jn,Ut,kn,xt,Mi="As the last example, we’ll show you how to build a Unigram tokenizer from scratch.",wn,zt,bn,It,mi="Let’s now build an XLNet tokenizer. Like for the previous tokenizers, we start by initializing a <code>Tokenizer</code> with a Unigram model:",$n,Ct,gn,vt,yi="Again, we could initialize this model with a vocabulary if we had one.",Un,Zt,hi="For the normalization, XLNet uses a few replacements (which come from SentencePiece):",xn,Vt,zn,Wt,ui="This replaces <code>“</code> and <code>”</code> with <code>”</code> and any sequence of two or more spaces with a single space, as well as removing the accents in the texts to tokenize.",In,_t,di="The pre-tokenizer to use for any SentencePiece tokenizer is <code>Metaspace</code>:",Cn,Bt,vn,Qt,Ji="We can have a look at the pre-tokenization of an example text like before:",Zn,At,Vn,Rt,Wn,Nt,fi="Next is the model, which needs training. XLNet has quite a few special tokens:",_n,Xt,Bn,Gt,Ti="A very important argument not to forget for the <code>UnigramTrainer</code> is the <code>unk_token</code>. We can also pass along other arguments specific to the Unigram algorithm, such as the <code>shrinking_factor</code> for each step where we remove tokens (defaults to 0.75) or the <code>max_piece_length</code> to specify the maximum length of a given token (defaults to 16).",Qn,qt,ji="This tokenizer can also be trained on text files:",An,Lt,Rn,Ht,ki="Let’s have a look at the tokenization of a sample text:",Nn,Dt,Xn,Et,Gn,St,wi="A peculiarity of XLNet is that it puts the <code>&lt;cls&gt;</code> token at the end of the sentence, with a type ID of 2 (to distinguish it from the other tokens). It’s padding on the left, as a result. We can deal with all the special tokens and token type IDs with a template, like for BERT, but first we have to get the IDs of the <code>&lt;cls&gt;</code> and <code>&lt;sep&gt;</code> tokens:",qn,Pt,Ln,Ft,Hn,Yt,bi="The template looks like this:",Dn,Kt,En,Ot,$i="And we can test it works by encoding a pair of sentences:",Sn,es,Pn,ts,Fn,ss,gi="Finally, we add a <code>Metaspace</code> decoder:",Yn,ls,Kn,ns,Ui="and we’re done with this tokenizer! We can save the tokenizer like before, and wrap it in a <code>PreTrainedTokenizerFast</code> or <code>XLNetTokenizerFast</code> if we want to use it in 🤗 Transformers. One thing to note when using <code>PreTrainedTokenizerFast</code> is that on top of the special tokens, we need to tell the 🤗 Transformers library to pad on the left:",On,as,ea,is,xi="Or alternatively:",ta,ps,sa,rs,zi="Now that you have seen how the various building blocks are used to build existing tokenizers, you should be able to write any tokenizer you want with the 🤗 Tokenizers library and be able to use it in 🤗 Transformers.",la,cs,na;return k=new Ms({props:{title:"Building a tokenizer, block by block",local:"building-a-tokenizer-block-by-block",headingTag:"h1"}}),w=new Ni({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"}]}}),x=new Ri({props:{id:"MR8tZm5ViWU"}}),v=new Ms({props:{title:"Acquiring a corpus",local:"acquiring-a-corpus",headingTag:"h2"}}),V=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),B=new u({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),A=new Ms({props:{title:"Building a WordPiece tokenizer from scratch",local:"building-a-wordpiece-tokenizer-from-scratch",headingTag:"h2"}}),X=new u({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),L=new u({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),D=new u({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),P=new u({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),F=new u({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),T=new Ai({props:{$$slots:{default:[Xi]},$$scope:{ctx:ms}}}),K=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),ee=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),se=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),le=new u({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ae=new u({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ie=new u({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),re=new u({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),oe=new u({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),Me=new u({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),he=new u({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),de=new u({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),fe=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Te=new u({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),we=new u({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),be=new u({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),Ue=new u({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ie=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ce=new u({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ze=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),Ve=new u({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),_e=new u({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Qe=new u({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Ae=new u({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Ne=new u({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ge=new u({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),He=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFlvdSUyMGNhbiUyMGxvYWQlMjBmcm9tJTIwdGhlJTIwdG9rZW5pemVyJTIwZmlsZSUyQyUyMGFsdGVybmF0aXZlbHklMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # You can load from the tokenizer file, alternatively</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Ee=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Fe=new Ms({props:{title:"Building a BPE tokenizer from scratch",local:"building-a-bpe-tokenizer-from-scratch",headingTag:"h2"}}),Ke=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),tt=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),lt=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),nt=new u({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),it=new u({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),ot=new u({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Mt=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),mt=new u({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ht=new u({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),dt=new u({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),Jt=new u({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),Tt=new u({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),kt=new u({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),wt=new u({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),$t=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),Ut=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),zt=new Ms({props:{title:"Building a Unigram tokenizer from scratch",local:"building-a-unigram-tokenizer-from-scratch",headingTag:"h2"}}),Ct=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),Vt=new u({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Bt=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),At=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Rt=new u({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Xt=new u({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Lt=new u({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Dt=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Et=new u({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Pt=new u({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Ft=new u({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Kt=new u({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),es=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),ts=new u({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),ls=new u({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),as=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),ps=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),{c(){d=i("meta"),j=n(),J=i("p"),os=n(),o(k.$$.fragment),ys=n(),o(w.$$.fragment),hs=n(),b=i("p"),b.textContent=ia,us=n(),$=i("ul"),$.innerHTML=pa,ds=n(),g=i("p"),g.textContent=ra,Js=n(),f=i("div"),f.innerHTML=oa,fs=n(),U=i("p"),U.innerHTML=ca,Ts=n(),o(x.$$.fragment),js=n(),z=i("p"),z.innerHTML=Ma,ks=n(),I=i("ul"),I.innerHTML=ma,ws=n(),C=i("p"),C.innerHTML=ya,bs=n(),o(v.$$.fragment),$s=n(),Z=i("p"),Z.innerHTML=ha,gs=n(),o(V.$$.fragment),Us=n(),W=i("p"),W.innerHTML=ua,xs=n(),_=i("p"),_.textContent=da,zs=n(),o(B.$$.fragment),Is=n(),Q=i("p"),Q.textContent=Ja,Cs=n(),o(A.$$.fragment),vs=n(),R=i("p"),R.innerHTML=fa,Zs=n(),N=i("p"),N.innerHTML=Ta,Vs=n(),o(X.$$.fragment),Ws=n(),G=i("p"),G.innerHTML=ja,_s=n(),q=i("p"),q.innerHTML=ka,Bs=n(),o(L.$$.fragment),Qs=n(),H=i("p"),H.innerHTML=wa,As=n(),o(D.$$.fragment),Rs=n(),E=i("p"),E.innerHTML=ba,Ns=n(),S=i("p"),S.innerHTML=$a,Xs=n(),o(P.$$.fragment),Gs=n(),o(F.$$.fragment),qs=n(),o(T.$$.fragment),Ls=n(),Y=i("p"),Y.innerHTML=ga,Hs=n(),o(K.$$.fragment),Ds=n(),O=i("p"),O.textContent=Ua,Es=n(),o(ee.$$.fragment),Ss=n(),te=i("p"),te.innerHTML=xa,Ps=n(),o(se.$$.fragment),Fs=n(),o(le.$$.fragment),Ys=n(),ne=i("p"),ne.innerHTML=za,Ks=n(),o(ae.$$.fragment),Os=n(),o(ie.$$.fragment),el=n(),pe=i("p"),pe.innerHTML=Ia,tl=n(),o(re.$$.fragment),sl=n(),o(oe.$$.fragment),ll=n(),ce=i("p"),ce.innerHTML=Ca,nl=n(),o(Me.$$.fragment),al=n(),me=i("p"),me.innerHTML=va,il=n(),ye=i("p"),ye.textContent=Za,pl=n(),o(he.$$.fragment),rl=n(),ue=i("p"),ue.innerHTML=Va,ol=n(),o(de.$$.fragment),cl=n(),Je=i("p"),Je.innerHTML=Wa,Ml=n(),o(fe.$$.fragment),ml=n(),o(Te.$$.fragment),yl=n(),je=i("p"),je.innerHTML=_a,hl=n(),ke=i("p"),ke.innerHTML=Ba,ul=n(),o(we.$$.fragment),dl=n(),o(be.$$.fragment),Jl=n(),$e=i("p"),$e.innerHTML=Qa,fl=n(),ge=i("p"),ge.textContent=Aa,Tl=n(),o(Ue.$$.fragment),jl=n(),xe=i("p"),xe.textContent=Ra,kl=n(),ze=i("p"),ze.textContent=Na,wl=n(),o(Ie.$$.fragment),bl=n(),o(Ce.$$.fragment),$l=n(),ve=i("p"),ve.textContent=Xa,gl=n(),o(Ze.$$.fragment),Ul=n(),o(Ve.$$.fragment),xl=n(),We=i("p"),We.textContent=Ga,zl=n(),o(_e.$$.fragment),Il=n(),Be=i("p"),Be.innerHTML=qa,Cl=n(),o(Qe.$$.fragment),vl=n(),o(Ae.$$.fragment),Zl=n(),Re=i("p"),Re.textContent=La,Vl=n(),o(Ne.$$.fragment),Wl=n(),Xe=i("p"),Xe.innerHTML=Ha,_l=n(),o(Ge.$$.fragment),Bl=n(),qe=i("p"),qe.innerHTML=Da,Ql=n(),Le=i("p"),Le.innerHTML=Ea,Al=n(),o(He.$$.fragment),Rl=n(),De=i("p"),De.innerHTML=Sa,Nl=n(),o(Ee.$$.fragment),Xl=n(),Se=i("p"),Se.innerHTML=Pa,Gl=n(),Pe=i("p"),Pe.textContent=Fa,ql=n(),o(Fe.$$.fragment),Ll=n(),Ye=i("p"),Ye.innerHTML=Ya,Hl=n(),o(Ke.$$.fragment),Dl=n(),Oe=i("p"),Oe.innerHTML=Ka,El=n(),et=i("p"),et.textContent=Oa,Sl=n(),o(tt.$$.fragment),Pl=n(),st=i("p"),st.innerHTML=ei,Fl=n(),o(lt.$$.fragment),Yl=n(),o(nt.$$.fragment),Kl=n(),at=i("p"),at.textContent=ti,Ol=n(),o(it.$$.fragment),en=n(),pt=i("p"),pt.innerHTML=si,tn=n(),rt=i("p"),rt.textContent=li,sn=n(),o(ot.$$.fragment),ln=n(),ct=i("p"),ct.textContent=ni,nn=n(),o(Mt.$$.fragment),an=n(),o(mt.$$.fragment),pn=n(),yt=i("p"),yt.textContent=ai,rn=n(),o(ht.$$.fragment),on=n(),ut=i("p"),ut.innerHTML=ii,cn=n(),o(dt.$$.fragment),Mn=n(),o(Jt.$$.fragment),mn=n(),ft=i("p"),ft.textContent=pi,yn=n(),o(Tt.$$.fragment),hn=n(),jt=i("p"),jt.textContent=ri,un=n(),o(kt.$$.fragment),dn=n(),o(wt.$$.fragment),Jn=n(),bt=i("p"),bt.innerHTML=oi,fn=n(),o($t.$$.fragment),Tn=n(),gt=i("p"),gt.textContent=ci,jn=n(),o(Ut.$$.fragment),kn=n(),xt=i("p"),xt.textContent=Mi,wn=n(),o(zt.$$.fragment),bn=n(),It=i("p"),It.innerHTML=mi,$n=n(),o(Ct.$$.fragment),gn=n(),vt=i("p"),vt.textContent=yi,Un=n(),Zt=i("p"),Zt.textContent=hi,xn=n(),o(Vt.$$.fragment),zn=n(),Wt=i("p"),Wt.innerHTML=ui,In=n(),_t=i("p"),_t.innerHTML=di,Cn=n(),o(Bt.$$.fragment),vn=n(),Qt=i("p"),Qt.textContent=Ji,Zn=n(),o(At.$$.fragment),Vn=n(),o(Rt.$$.fragment),Wn=n(),Nt=i("p"),Nt.textContent=fi,_n=n(),o(Xt.$$.fragment),Bn=n(),Gt=i("p"),Gt.innerHTML=Ti,Qn=n(),qt=i("p"),qt.textContent=ji,An=n(),o(Lt.$$.fragment),Rn=n(),Ht=i("p"),Ht.textContent=ki,Nn=n(),o(Dt.$$.fragment),Xn=n(),o(Et.$$.fragment),Gn=n(),St=i("p"),St.innerHTML=wi,qn=n(),o(Pt.$$.fragment),Ln=n(),o(Ft.$$.fragment),Hn=n(),Yt=i("p"),Yt.textContent=bi,Dn=n(),o(Kt.$$.fragment),En=n(),Ot=i("p"),Ot.textContent=$i,Sn=n(),o(es.$$.fragment),Pn=n(),o(ts.$$.fragment),Fn=n(),ss=i("p"),ss.innerHTML=gi,Yn=n(),o(ls.$$.fragment),Kn=n(),ns=i("p"),ns.innerHTML=Ui,On=n(),o(as.$$.fragment),ea=n(),is=i("p"),is.textContent=xi,ta=n(),o(ps.$$.fragment),sa=n(),rs=i("p"),rs.textContent=zi,la=n(),cs=i("p"),this.h()},l(e){const t=Bi("svelte-u9bgzb",document.head);d=p(t,"META",{name:!0,content:!0}),t.forEach(s),j=a(e),J=p(e,"P",{}),Ci(J).forEach(s),os=a(e),c(k.$$.fragment,e),ys=a(e),c(w.$$.fragment,e),hs=a(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-3qwu2n"&&(b.textContent=ia),us=a(e),$=p(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-12vigqn"&&($.innerHTML=pa),ds=a(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1msje3z"&&(g.textContent=ra),Js=a(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-oxfng3"&&(f.innerHTML=oa),fs=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-il604i"&&(U.innerHTML=ca),Ts=a(e),c(x.$$.fragment,e),js=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-3r1vi2"&&(z.innerHTML=Ma),ks=a(e),I=p(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1hlph7i"&&(I.innerHTML=ma),ws=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-em8n5x"&&(C.innerHTML=ya),bs=a(e),c(v.$$.fragment,e),$s=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1njyr3z"&&(Z.innerHTML=ha),gs=a(e),c(V.$$.fragment,e),Us=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-cmf9ti"&&(W.innerHTML=ua),xs=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1b40lyu"&&(_.textContent=da),zs=a(e),c(B.$$.fragment,e),Is=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-14xvwqr"&&(Q.textContent=Ja),Cs=a(e),c(A.$$.fragment,e),vs=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-kr34bb"&&(R.innerHTML=fa),Zs=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ldh8kh"&&(N.innerHTML=Ta),Vs=a(e),c(X.$$.fragment,e),Ws=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-szj6vq"&&(G.innerHTML=ja),_s=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ch9g0x"&&(q.innerHTML=ka),Bs=a(e),c(L.$$.fragment,e),Qs=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-g661z7"&&(H.innerHTML=wa),As=a(e),c(D.$$.fragment,e),Rs=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-sqrbhp"&&(E.innerHTML=ba),Ns=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ifl1uh"&&(S.innerHTML=$a),Xs=a(e),c(P.$$.fragment,e),Gs=a(e),c(F.$$.fragment,e),qs=a(e),c(T.$$.fragment,e),Ls=a(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1hzmz8v"&&(Y.innerHTML=ga),Hs=a(e),c(K.$$.fragment,e),Ds=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-5f2ppa"&&(O.textContent=Ua),Es=a(e),c(ee.$$.fragment,e),Ss=a(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-17g5tkh"&&(te.innerHTML=xa),Ps=a(e),c(se.$$.fragment,e),Fs=a(e),c(le.$$.fragment,e),Ys=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1nzvxks"&&(ne.innerHTML=za),Ks=a(e),c(ae.$$.fragment,e),Os=a(e),c(ie.$$.fragment,e),el=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-e8ls79"&&(pe.innerHTML=Ia),tl=a(e),c(re.$$.fragment,e),sl=a(e),c(oe.$$.fragment,e),ll=a(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1flaqiu"&&(ce.innerHTML=Ca),nl=a(e),c(Me.$$.fragment,e),al=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-zfisnc"&&(me.innerHTML=va),il=a(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-fxwv2n"&&(ye.textContent=Za),pl=a(e),c(he.$$.fragment,e),rl=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-wisurr"&&(ue.innerHTML=Va),ol=a(e),c(de.$$.fragment,e),cl=a(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-132nejo"&&(Je.innerHTML=Wa),Ml=a(e),c(fe.$$.fragment,e),ml=a(e),c(Te.$$.fragment,e),yl=a(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-gj3rj2"&&(je.innerHTML=_a),hl=a(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1oy2o1b"&&(ke.innerHTML=Ba),ul=a(e),c(we.$$.fragment,e),dl=a(e),c(be.$$.fragment,e),Jl=a(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-z3selt"&&($e.innerHTML=Qa),fl=a(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-q1nzmh"&&(ge.textContent=Aa),Tl=a(e),c(Ue.$$.fragment,e),jl=a(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-14xkv0z"&&(xe.textContent=Ra),kl=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1i25qf9"&&(ze.textContent=Na),wl=a(e),c(Ie.$$.fragment,e),bl=a(e),c(Ce.$$.fragment,e),$l=a(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-th6dsg"&&(ve.textContent=Xa),gl=a(e),c(Ze.$$.fragment,e),Ul=a(e),c(Ve.$$.fragment,e),xl=a(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-xbo1fy"&&(We.textContent=Ga),zl=a(e),c(_e.$$.fragment,e),Il=a(e),Be=p(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-10hc9jg"&&(Be.innerHTML=qa),Cl=a(e),c(Qe.$$.fragment,e),vl=a(e),c(Ae.$$.fragment,e),Zl=a(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-bx3ks1"&&(Re.textContent=La),Vl=a(e),c(Ne.$$.fragment,e),Wl=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1j80g7l"&&(Xe.innerHTML=Ha),_l=a(e),c(Ge.$$.fragment,e),Bl=a(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-138iql"&&(qe.innerHTML=Da),Ql=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-k6u833"&&(Le.innerHTML=Ea),Al=a(e),c(He.$$.fragment,e),Rl=a(e),De=p(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1o14t6o"&&(De.innerHTML=Sa),Nl=a(e),c(Ee.$$.fragment,e),Xl=a(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1y1ppn4"&&(Se.innerHTML=Pa),Gl=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1w2ckw7"&&(Pe.textContent=Fa),ql=a(e),c(Fe.$$.fragment,e),Ll=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-16961ta"&&(Ye.innerHTML=Ya),Hl=a(e),c(Ke.$$.fragment,e),Dl=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1bovaty"&&(Oe.innerHTML=Ka),El=a(e),et=p(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1ezw1yn"&&(et.textContent=Oa),Sl=a(e),c(tt.$$.fragment,e),Pl=a(e),st=p(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1bw3nt0"&&(st.innerHTML=ei),Fl=a(e),c(lt.$$.fragment,e),Yl=a(e),c(nt.$$.fragment,e),Kl=a(e),at=p(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-7y4l0y"&&(at.textContent=ti),Ol=a(e),c(it.$$.fragment,e),en=a(e),pt=p(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-bv31bn"&&(pt.innerHTML=si),tn=a(e),rt=p(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-11ph16f"&&(rt.textContent=li),sn=a(e),c(ot.$$.fragment,e),ln=a(e),ct=p(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1hgpn33"&&(ct.textContent=ni),nn=a(e),c(Mt.$$.fragment,e),an=a(e),c(mt.$$.fragment,e),pn=a(e),yt=p(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-n1vz05"&&(yt.textContent=ai),rn=a(e),c(ht.$$.fragment,e),on=a(e),ut=p(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-ghzhch"&&(ut.innerHTML=ii),cn=a(e),c(dt.$$.fragment,e),Mn=a(e),c(Jt.$$.fragment,e),mn=a(e),ft=p(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1h8tvqm"&&(ft.textContent=pi),yn=a(e),c(Tt.$$.fragment,e),hn=a(e),jt=p(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1507zp"&&(jt.textContent=ri),un=a(e),c(kt.$$.fragment,e),dn=a(e),c(wt.$$.fragment,e),Jn=a(e),bt=p(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1uknlc4"&&(bt.innerHTML=oi),fn=a(e),c($t.$$.fragment,e),Tn=a(e),gt=p(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-ylttvt"&&(gt.textContent=ci),jn=a(e),c(Ut.$$.fragment,e),kn=a(e),xt=p(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1tk1zdg"&&(xt.textContent=Mi),wn=a(e),c(zt.$$.fragment,e),bn=a(e),It=p(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1lojr4m"&&(It.innerHTML=mi),$n=a(e),c(Ct.$$.fragment,e),gn=a(e),vt=p(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1g43fmt"&&(vt.textContent=yi),Un=a(e),Zt=p(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-d9cfcx"&&(Zt.textContent=hi),xn=a(e),c(Vt.$$.fragment,e),zn=a(e),Wt=p(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-qkvtqd"&&(Wt.innerHTML=ui),In=a(e),_t=p(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-8x763t"&&(_t.innerHTML=di),Cn=a(e),c(Bt.$$.fragment,e),vn=a(e),Qt=p(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1ejt7m0"&&(Qt.textContent=Ji),Zn=a(e),c(At.$$.fragment,e),Vn=a(e),c(Rt.$$.fragment,e),Wn=a(e),Nt=p(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-csrqog"&&(Nt.textContent=fi),_n=a(e),c(Xt.$$.fragment,e),Bn=a(e),Gt=p(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-11hh239"&&(Gt.innerHTML=Ti),Qn=a(e),qt=p(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-11ph16f"&&(qt.textContent=ji),An=a(e),c(Lt.$$.fragment,e),Rn=a(e),Ht=p(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1hgpn33"&&(Ht.textContent=ki),Nn=a(e),c(Dt.$$.fragment,e),Xn=a(e),c(Et.$$.fragment,e),Gn=a(e),St=p(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-kqa3ra"&&(St.innerHTML=wi),qn=a(e),c(Pt.$$.fragment,e),Ln=a(e),c(Ft.$$.fragment,e),Hn=a(e),Yt=p(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1xkp6h4"&&(Yt.textContent=bi),Dn=a(e),c(Kt.$$.fragment,e),En=a(e),Ot=p(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-11ia5pa"&&(Ot.textContent=$i),Sn=a(e),c(es.$$.fragment,e),Pn=a(e),c(ts.$$.fragment,e),Fn=a(e),ss=p(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-16qaug1"&&(ss.innerHTML=gi),Yn=a(e),c(ls.$$.fragment,e),Kn=a(e),ns=p(e,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1nk2cqv"&&(ns.innerHTML=Ui),On=a(e),c(as.$$.fragment,e),ea=a(e),is=p(e,"P",{"data-svelte-h":!0}),r(is)!=="svelte-igjp7d"&&(is.textContent=xi),ta=a(e),c(ps.$$.fragment,e),sa=a(e),rs=p(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-l5rkk1"&&(rs.textContent=zi),la=a(e),cs=p(e,"P",{}),Ci(cs).forEach(s),this.h()},h(){aa(d,"name","hf:doc:metadata"),aa(d,"content",qi),aa(f,"class","flex justify-center")},m(e,t){Qi(document.head,d),l(e,j,t),l(e,J,t),l(e,os,t),M(k,e,t),l(e,ys,t),M(w,e,t),l(e,hs,t),l(e,b,t),l(e,us,t),l(e,$,t),l(e,ds,t),l(e,g,t),l(e,Js,t),l(e,f,t),l(e,fs,t),l(e,U,t),l(e,Ts,t),M(x,e,t),l(e,js,t),l(e,z,t),l(e,ks,t),l(e,I,t),l(e,ws,t),l(e,C,t),l(e,bs,t),M(v,e,t),l(e,$s,t),l(e,Z,t),l(e,gs,t),M(V,e,t),l(e,Us,t),l(e,W,t),l(e,xs,t),l(e,_,t),l(e,zs,t),M(B,e,t),l(e,Is,t),l(e,Q,t),l(e,Cs,t),M(A,e,t),l(e,vs,t),l(e,R,t),l(e,Zs,t),l(e,N,t),l(e,Vs,t),M(X,e,t),l(e,Ws,t),l(e,G,t),l(e,_s,t),l(e,q,t),l(e,Bs,t),M(L,e,t),l(e,Qs,t),l(e,H,t),l(e,As,t),M(D,e,t),l(e,Rs,t),l(e,E,t),l(e,Ns,t),l(e,S,t),l(e,Xs,t),M(P,e,t),l(e,Gs,t),M(F,e,t),l(e,qs,t),M(T,e,t),l(e,Ls,t),l(e,Y,t),l(e,Hs,t),M(K,e,t),l(e,Ds,t),l(e,O,t),l(e,Es,t),M(ee,e,t),l(e,Ss,t),l(e,te,t),l(e,Ps,t),M(se,e,t),l(e,Fs,t),M(le,e,t),l(e,Ys,t),l(e,ne,t),l(e,Ks,t),M(ae,e,t),l(e,Os,t),M(ie,e,t),l(e,el,t),l(e,pe,t),l(e,tl,t),M(re,e,t),l(e,sl,t),M(oe,e,t),l(e,ll,t),l(e,ce,t),l(e,nl,t),M(Me,e,t),l(e,al,t),l(e,me,t),l(e,il,t),l(e,ye,t),l(e,pl,t),M(he,e,t),l(e,rl,t),l(e,ue,t),l(e,ol,t),M(de,e,t),l(e,cl,t),l(e,Je,t),l(e,Ml,t),M(fe,e,t),l(e,ml,t),M(Te,e,t),l(e,yl,t),l(e,je,t),l(e,hl,t),l(e,ke,t),l(e,ul,t),M(we,e,t),l(e,dl,t),M(be,e,t),l(e,Jl,t),l(e,$e,t),l(e,fl,t),l(e,ge,t),l(e,Tl,t),M(Ue,e,t),l(e,jl,t),l(e,xe,t),l(e,kl,t),l(e,ze,t),l(e,wl,t),M(Ie,e,t),l(e,bl,t),M(Ce,e,t),l(e,$l,t),l(e,ve,t),l(e,gl,t),M(Ze,e,t),l(e,Ul,t),M(Ve,e,t),l(e,xl,t),l(e,We,t),l(e,zl,t),M(_e,e,t),l(e,Il,t),l(e,Be,t),l(e,Cl,t),M(Qe,e,t),l(e,vl,t),M(Ae,e,t),l(e,Zl,t),l(e,Re,t),l(e,Vl,t),M(Ne,e,t),l(e,Wl,t),l(e,Xe,t),l(e,_l,t),M(Ge,e,t),l(e,Bl,t),l(e,qe,t),l(e,Ql,t),l(e,Le,t),l(e,Al,t),M(He,e,t),l(e,Rl,t),l(e,De,t),l(e,Nl,t),M(Ee,e,t),l(e,Xl,t),l(e,Se,t),l(e,Gl,t),l(e,Pe,t),l(e,ql,t),M(Fe,e,t),l(e,Ll,t),l(e,Ye,t),l(e,Hl,t),M(Ke,e,t),l(e,Dl,t),l(e,Oe,t),l(e,El,t),l(e,et,t),l(e,Sl,t),M(tt,e,t),l(e,Pl,t),l(e,st,t),l(e,Fl,t),M(lt,e,t),l(e,Yl,t),M(nt,e,t),l(e,Kl,t),l(e,at,t),l(e,Ol,t),M(it,e,t),l(e,en,t),l(e,pt,t),l(e,tn,t),l(e,rt,t),l(e,sn,t),M(ot,e,t),l(e,ln,t),l(e,ct,t),l(e,nn,t),M(Mt,e,t),l(e,an,t),M(mt,e,t),l(e,pn,t),l(e,yt,t),l(e,rn,t),M(ht,e,t),l(e,on,t),l(e,ut,t),l(e,cn,t),M(dt,e,t),l(e,Mn,t),M(Jt,e,t),l(e,mn,t),l(e,ft,t),l(e,yn,t),M(Tt,e,t),l(e,hn,t),l(e,jt,t),l(e,un,t),M(kt,e,t),l(e,dn,t),M(wt,e,t),l(e,Jn,t),l(e,bt,t),l(e,fn,t),M($t,e,t),l(e,Tn,t),l(e,gt,t),l(e,jn,t),M(Ut,e,t),l(e,kn,t),l(e,xt,t),l(e,wn,t),M(zt,e,t),l(e,bn,t),l(e,It,t),l(e,$n,t),M(Ct,e,t),l(e,gn,t),l(e,vt,t),l(e,Un,t),l(e,Zt,t),l(e,xn,t),M(Vt,e,t),l(e,zn,t),l(e,Wt,t),l(e,In,t),l(e,_t,t),l(e,Cn,t),M(Bt,e,t),l(e,vn,t),l(e,Qt,t),l(e,Zn,t),M(At,e,t),l(e,Vn,t),M(Rt,e,t),l(e,Wn,t),l(e,Nt,t),l(e,_n,t),M(Xt,e,t),l(e,Bn,t),l(e,Gt,t),l(e,Qn,t),l(e,qt,t),l(e,An,t),M(Lt,e,t),l(e,Rn,t),l(e,Ht,t),l(e,Nn,t),M(Dt,e,t),l(e,Xn,t),M(Et,e,t),l(e,Gn,t),l(e,St,t),l(e,qn,t),M(Pt,e,t),l(e,Ln,t),M(Ft,e,t),l(e,Hn,t),l(e,Yt,t),l(e,Dn,t),M(Kt,e,t),l(e,En,t),l(e,Ot,t),l(e,Sn,t),M(es,e,t),l(e,Pn,t),M(ts,e,t),l(e,Fn,t),l(e,ss,t),l(e,Yn,t),M(ls,e,t),l(e,Kn,t),l(e,ns,t),l(e,On,t),M(as,e,t),l(e,ea,t),l(e,is,t),l(e,ta,t),M(ps,e,t),l(e,sa,t),l(e,rs,t),l(e,la,t),l(e,cs,t),na=!0},p(e,[t]){const Ii={};t&2&&(Ii.$$scope={dirty:t,ctx:e}),T.$set(Ii)},i(e){na||(m(k.$$.fragment,e),m(w.$$.fragment,e),m(x.$$.fragment,e),m(v.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(A.$$.fragment,e),m(X.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(F.$$.fragment,e),m(T.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(Me.$$.fragment,e),m(he.$$.fragment,e),m(de.$$.fragment,e),m(fe.$$.fragment,e),m(Te.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(Ue.$$.fragment,e),m(Ie.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m(Ve.$$.fragment,e),m(_e.$$.fragment,e),m(Qe.$$.fragment,e),m(Ae.$$.fragment,e),m(Ne.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(Ee.$$.fragment,e),m(Fe.$$.fragment,e),m(Ke.$$.fragment,e),m(tt.$$.fragment,e),m(lt.$$.fragment,e),m(nt.$$.fragment,e),m(it.$$.fragment,e),m(ot.$$.fragment,e),m(Mt.$$.fragment,e),m(mt.$$.fragment,e),m(ht.$$.fragment,e),m(dt.$$.fragment,e),m(Jt.$$.fragment,e),m(Tt.$$.fragment,e),m(kt.$$.fragment,e),m(wt.$$.fragment,e),m($t.$$.fragment,e),m(Ut.$$.fragment,e),m(zt.$$.fragment,e),m(Ct.$$.fragment,e),m(Vt.$$.fragment,e),m(Bt.$$.fragment,e),m(At.$$.fragment,e),m(Rt.$$.fragment,e),m(Xt.$$.fragment,e),m(Lt.$$.fragment,e),m(Dt.$$.fragment,e),m(Et.$$.fragment,e),m(Pt.$$.fragment,e),m(Ft.$$.fragment,e),m(Kt.$$.fragment,e),m(es.$$.fragment,e),m(ts.$$.fragment,e),m(ls.$$.fragment,e),m(as.$$.fragment,e),m(ps.$$.fragment,e),na=!0)},o(e){y(k.$$.fragment,e),y(w.$$.fragment,e),y(x.$$.fragment,e),y(v.$$.fragment,e),y(V.$$.fragment,e),y(B.$$.fragment,e),y(A.$$.fragment,e),y(X.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),y(F.$$.fragment,e),y(T.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(re.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(he.$$.fragment,e),y(de.$$.fragment,e),y(fe.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(be.$$.fragment,e),y(Ue.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),y(Ze.$$.fragment,e),y(Ve.$$.fragment,e),y(_e.$$.fragment,e),y(Qe.$$.fragment,e),y(Ae.$$.fragment,e),y(Ne.$$.fragment,e),y(Ge.$$.fragment,e),y(He.$$.fragment,e),y(Ee.$$.fragment,e),y(Fe.$$.fragment,e),y(Ke.$$.fragment,e),y(tt.$$.fragment,e),y(lt.$$.fragment,e),y(nt.$$.fragment,e),y(it.$$.fragment,e),y(ot.$$.fragment,e),y(Mt.$$.fragment,e),y(mt.$$.fragment,e),y(ht.$$.fragment,e),y(dt.$$.fragment,e),y(Jt.$$.fragment,e),y(Tt.$$.fragment,e),y(kt.$$.fragment,e),y(wt.$$.fragment,e),y($t.$$.fragment,e),y(Ut.$$.fragment,e),y(zt.$$.fragment,e),y(Ct.$$.fragment,e),y(Vt.$$.fragment,e),y(Bt.$$.fragment,e),y(At.$$.fragment,e),y(Rt.$$.fragment,e),y(Xt.$$.fragment,e),y(Lt.$$.fragment,e),y(Dt.$$.fragment,e),y(Et.$$.fragment,e),y(Pt.$$.fragment,e),y(Ft.$$.fragment,e),y(Kt.$$.fragment,e),y(es.$$.fragment,e),y(ts.$$.fragment,e),y(ls.$$.fragment,e),y(as.$$.fragment,e),y(ps.$$.fragment,e),na=!1},d(e){e&&(s(j),s(J),s(os),s(ys),s(hs),s(b),s(us),s($),s(ds),s(g),s(Js),s(f),s(fs),s(U),s(Ts),s(js),s(z),s(ks),s(I),s(ws),s(C),s(bs),s($s),s(Z),s(gs),s(Us),s(W),s(xs),s(_),s(zs),s(Is),s(Q),s(Cs),s(vs),s(R),s(Zs),s(N),s(Vs),s(Ws),s(G),s(_s),s(q),s(Bs),s(Qs),s(H),s(As),s(Rs),s(E),s(Ns),s(S),s(Xs),s(Gs),s(qs),s(Ls),s(Y),s(Hs),s(Ds),s(O),s(Es),s(Ss),s(te),s(Ps),s(Fs),s(Ys),s(ne),s(Ks),s(Os),s(el),s(pe),s(tl),s(sl),s(ll),s(ce),s(nl),s(al),s(me),s(il),s(ye),s(pl),s(rl),s(ue),s(ol),s(cl),s(Je),s(Ml),s(ml),s(yl),s(je),s(hl),s(ke),s(ul),s(dl),s(Jl),s($e),s(fl),s(ge),s(Tl),s(jl),s(xe),s(kl),s(ze),s(wl),s(bl),s($l),s(ve),s(gl),s(Ul),s(xl),s(We),s(zl),s(Il),s(Be),s(Cl),s(vl),s(Zl),s(Re),s(Vl),s(Wl),s(Xe),s(_l),s(Bl),s(qe),s(Ql),s(Le),s(Al),s(Rl),s(De),s(Nl),s(Xl),s(Se),s(Gl),s(Pe),s(ql),s(Ll),s(Ye),s(Hl),s(Dl),s(Oe),s(El),s(et),s(Sl),s(Pl),s(st),s(Fl),s(Yl),s(Kl),s(at),s(Ol),s(en),s(pt),s(tn),s(rt),s(sn),s(ln),s(ct),s(nn),s(an),s(pn),s(yt),s(rn),s(on),s(ut),s(cn),s(Mn),s(mn),s(ft),s(yn),s(hn),s(jt),s(un),s(dn),s(Jn),s(bt),s(fn),s(Tn),s(gt),s(jn),s(kn),s(xt),s(wn),s(bn),s(It),s($n),s(gn),s(vt),s(Un),s(Zt),s(xn),s(zn),s(Wt),s(In),s(_t),s(Cn),s(vn),s(Qt),s(Zn),s(Vn),s(Wn),s(Nt),s(_n),s(Bn),s(Gt),s(Qn),s(qt),s(An),s(Rn),s(Ht),s(Nn),s(Xn),s(Gn),s(St),s(qn),s(Ln),s(Hn),s(Yt),s(Dn),s(En),s(Ot),s(Sn),s(Pn),s(Fn),s(ss),s(Yn),s(Kn),s(ns),s(On),s(ea),s(is),s(ta),s(sa),s(rs),s(la),s(cs)),s(d),h(k,e),h(w,e),h(x,e),h(v,e),h(V,e),h(B,e),h(A,e),h(X,e),h(L,e),h(D,e),h(P,e),h(F,e),h(T,e),h(K,e),h(ee,e),h(se,e),h(le,e),h(ae,e),h(ie,e),h(re,e),h(oe,e),h(Me,e),h(he,e),h(de,e),h(fe,e),h(Te,e),h(we,e),h(be,e),h(Ue,e),h(Ie,e),h(Ce,e),h(Ze,e),h(Ve,e),h(_e,e),h(Qe,e),h(Ae,e),h(Ne,e),h(Ge,e),h(He,e),h(Ee,e),h(Fe,e),h(Ke,e),h(tt,e),h(lt,e),h(nt,e),h(it,e),h(ot,e),h(Mt,e),h(mt,e),h(ht,e),h(dt,e),h(Jt,e),h(Tt,e),h(kt,e),h(wt,e),h($t,e),h(Ut,e),h(zt,e),h(Ct,e),h(Vt,e),h(Bt,e),h(At,e),h(Rt,e),h(Xt,e),h(Lt,e),h(Dt,e),h(Et,e),h(Pt,e),h(Ft,e),h(Kt,e),h(es,e),h(ts,e),h(ls,e),h(as,e),h(ps,e)}}}const qi='{"title":"Building a tokenizer, block by block","local":"building-a-tokenizer-block-by-block","sections":[{"title":"Acquiring a corpus","local":"acquiring-a-corpus","sections":[],"depth":2},{"title":"Building a WordPiece tokenizer from scratch","local":"building-a-wordpiece-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Building a BPE tokenizer from scratch","local":"building-a-bpe-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Building a Unigram tokenizer from scratch","local":"building-a-unigram-tokenizer-from-scratch","sections":[],"depth":2}],"depth":1}';function Li(ms){return Zi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ki extends Wi{constructor(d){super(),_i(this,d,Li,Gi,vi,{})}}export{Ki as component};
