import{s as ut,n as pt,o as mt}from"../chunks/scheduler.182ea377.js";import{S as ht,i as ft,g as i,s as r,r as p,A as gt,h as d,f as t,c as o,j as v,u as m,x as u,k as b,y as s,a as l,v as h,d as f,t as g,w as _}from"../chunks/index.abf12888.js";import{D as $}from"../chunks/Docstring.93f6f462.js";import{H as De}from"../chunks/Heading.16916d63.js";function _t(Ze){let x,de,oe,ae,D,le,F,Ke='<code>UniPCMultistepScheduler</code> is a training-free framework designed for fast sampling of diffusion models. It was introduced in <a href="https://huggingface.co/papers/2302.04867" rel="nofollow">UniPC: A Unified Predictor-Corrector Framework for Fast Sampling of Diffusion Models</a> by Wenliang Zhao, Lujia Bai, Yongming Rao, Jie Zhou, Jiwen Lu.',ce,L,Ye=`It consists of a corrector (UniC) and a predictor (UniP) that share a unified analytical form and support arbitrary orders.
UniPC is by design model-agnostic, supporting pixel-space/latent-space DPMs on unconditional/conditional sampling. It can also be applied to both noise prediction and data prediction models. The corrector UniC can be also applied after any off-the-shelf solvers to increase the order of accuracy.`,ue,I,Ge="The abstract from the paper is:",pe,k,Qe='<em>Diffusion probabilistic models (DPMs) have demonstrated a very promising ability in high-resolution image synthesis. However, sampling from a pre-trained DPM is time-consuming due to the multiple evaluations of the denoising network, making it more and more important to accelerate the sampling of DPMs. Despite recent progress in designing fast samplers, existing methods still cannot generate satisfying images in many applications where fewer steps (e.g., &lt;10) are favored. In this paper, we develop a unified corrector (UniC) that can be applied after any existing DPM sampler to increase the order of accuracy without extra model evaluations, and derive a unified predictor (UniP) that supports arbitrary order as a byproduct. Combining UniP and UniC, we propose a unified predictor-corrector framework called UniPC for the fast sampling of DPMs, which has a unified analytical form for any order and can significantly improve the sampling quality over previous methods, especially in extremely few steps. We evaluate our methods through extensive experiments including both unconditional and conditional sampling using pixel-space and latent-space DPMs. Our UniPC can achieve 3.87 FID on CIFAR10 (unconditional) and 7.51 FID on ImageNet 256×256 (conditional) with only 10 function evaluations. Code is available at <a href="https://github.com/wl-zhao/UniPC" rel="nofollow">this https URL</a>.</em>',me,H,he,O,Xe="It is recommended to set <code>solver_order</code> to 2 for guide sampling, and <code>solver_order=3</code> for unconditional sampling.",fe,E,et=`Dynamic thresholding from <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen</a> is supported, and for pixel-space
diffusion models, you can set both <code>predict_x0=True</code> and <code>thresholding=True</code> to use dynamic thresholding. This thresholding method is unsuitable for latent-space diffusion models such as Stable Diffusion.`,ge,N,_e,a,q,Fe,K,tt="<code>UniPCMultistepScheduler</code> is a training-free framework designed for the fast sampling of diffusion models.",Le,Y,st=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/v0.27.2/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,Ie,P,V,ke,G,nt="Convert the model output to the corresponding type the UniPC algorithm needs.",He,T,A,Oe,Q,rt="One step for the UniC (B(h) version).",Ee,y,z,Ne,X,ot="One step for the UniP (B(h) version). Alternatively, <code>self.solver_p</code> is used if is specified.",qe,M,W,Ve,ee,it=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,Ae,S,j,ze,te,dt="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",We,U,R,je,se,at="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",Re,w,B,Be,ne,lt=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep UniPC.`,ve,J,be,C,Z,Je,re,ct="Base class for the output of a scheduler’s <code>step</code> function.",xe,ie,Ce;return D=new De({props:{title:"UniPCMultistepScheduler",local:"unipcmultistepscheduler",headingTag:"h1"}}),H=new De({props:{title:"Tips",local:"tips",headingTag:"h2"}}),N=new De({props:{title:"UniPCMultistepScheduler",local:"diffusers.UniPCMultistepScheduler",headingTag:"h2"}}),q=new $({props:{name:"class diffusers.UniPCMultistepScheduler",anchor:"diffusers.UniPCMultistepScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": str = 'linear'"},{name:"trained_betas",val:": Union = None"},{name:"solver_order",val:": int = 2"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"predict_x0",val:": bool = True"},{name:"solver_type",val:": str = 'bh2'"},{name:"lower_order_final",val:": bool = True"},{name:"disable_corrector",val:": List = []"},{name:"solver_p",val:": SchedulerMixin = None"},{name:"use_karras_sigmas",val:": Optional = False"},{name:"timestep_spacing",val:": str = 'linspace'"},{name:"steps_offset",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.UniPCMultistepScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.UniPCMultistepScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.UniPCMultistepScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code>, <code>scaled_linear</code>, or <code>squaredcos_cap_v2</code>.`,name:"beta_schedule"},{anchor:"diffusers.UniPCMultistepScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.UniPCMultistepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, default <code>2</code>) &#x2014;
The UniPC order which can be any positive integer. The effective order of accuracy is <code>solver_order + 1</code>
due to the UniC. It is recommended to use <code>solver_order=2</code> for guided sampling, and <code>solver_order=3</code> for
unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.UniPCMultistepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>, <em>optional</em>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.UniPCMultistepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.UniPCMultistepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.UniPCMultistepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code> and <code>predict_x0=True</code>.`,name:"sample_max_value"},{anchor:"diffusers.UniPCMultistepScheduler.predict_x0",description:`<strong>predict_x0</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use the updating algorithm on the predicted x0.`,name:"predict_x0"},{anchor:"diffusers.UniPCMultistepScheduler.solver_type",description:`<strong>solver_type</strong> (<code>str</code>, default <code>bh2</code>) &#x2014;
Solver type for UniPC. It is recommended to use <code>bh1</code> for unconditional sampling when steps &lt; 10, and <code>bh2</code>
otherwise.`,name:"solver_type"},{anchor:"diffusers.UniPCMultistepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, default <code>True</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps. This can
stabilize the sampling of DPMSolver for steps &lt; 15, especially for steps &lt;= 10.`,name:"lower_order_final"},{anchor:"diffusers.UniPCMultistepScheduler.disable_corrector",description:`<strong>disable_corrector</strong> (<code>list</code>, default <code>[]</code>) &#x2014;
Decides which step to disable the corrector to mitigate the misalignment between <code>epsilon_theta(x_t, c)</code>
and <code>epsilon_theta(x_t^c, c)</code> which can influence convergence for a large guidance scale. Corrector is
usually disabled during the first few steps.`,name:"disable_corrector"},{anchor:"diffusers.UniPCMultistepScheduler.solver_p",description:`<strong>solver_p</strong> (<code>SchedulerMixin</code>, default <code>None</code>) &#x2014;
Any other scheduler that if specified, the algorithm becomes <code>solver_p + UniC</code>.`,name:"solver_p"},{anchor:"diffusers.UniPCMultistepScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.UniPCMultistepScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.UniPCMultistepScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps, as required by some model families.`,name:"steps_offset"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L74"}}),V=new $({props:{name:"convert_model_output",anchor:"diffusers.UniPCMultistepScheduler.convert_model_output",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.UniPCMultistepScheduler.convert_model_output.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.UniPCMultistepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),A=new $({props:{name:"multistep_uni_c_bh_update",anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update",parameters:[{name:"this_model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"last_sample",val:": FloatTensor = None"},{name:"this_sample",val:": FloatTensor = None"},{name:"order",val:": int = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.this_model_output",description:`<strong>this_model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The model outputs at <code>x_t</code>.`,name:"this_model_output"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.this_timestep",description:`<strong>this_timestep</strong> (<code>int</code>) &#x2014;
The current timestep <code>t</code>.`,name:"this_timestep"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.last_sample",description:`<strong>last_sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The generated sample before the last predictor <code>x_{t-1}</code>.`,name:"last_sample"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.this_sample",description:`<strong>this_sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The generated sample after the last predictor <code>x_{t}</code>.`,name:"this_sample"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.order",description:`<strong>order</strong> (<code>int</code>) &#x2014;
The <code>p</code> of UniC-p at this step. The effective order of accuracy should be <code>order + 1</code>.`,name:"order"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L582",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The corrected sample tensor at the current timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),z=new $({props:{name:"multistep_uni_p_bh_update",anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"order",val:": int = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model at the current timestep.`,name:"model_output"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.order",description:`<strong>order</strong> (<code>int</code>) &#x2014;
The order of UniP at this timestep (corresponds to the <em>p</em> in UniPC-p).`,name:"order"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L453",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),W=new $({props:{name:"scale_model_input",anchor:"diffusers.UniPCMultistepScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L833",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),j=new $({props:{name:"set_begin_index",anchor:"diffusers.UniPCMultistepScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L217"}}),R=new $({props:{name:"set_timesteps",anchor:"diffusers.UniPCMultistepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int"},{name:"device",val:": Union = None"}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.UniPCMultistepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L227"}}),B=new $({props:{name:"step",anchor:"diffusers.UniPCMultistepScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": int"},{name:"sample",val:": FloatTensor"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.UniPCMultistepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.UniPCMultistepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.UniPCMultistepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_unipc_multistep.py#L752",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),J=new De({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),Z=new $({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/schedulers/scheduling_utils.py#L51"}}),{c(){x=i("meta"),de=r(),oe=i("p"),ae=r(),p(D.$$.fragment),le=r(),F=i("p"),F.innerHTML=Ke,ce=r(),L=i("p"),L.textContent=Ye,ue=r(),I=i("p"),I.textContent=Ge,pe=r(),k=i("p"),k.innerHTML=Qe,me=r(),p(H.$$.fragment),he=r(),O=i("p"),O.innerHTML=Xe,fe=r(),E=i("p"),E.innerHTML=et,ge=r(),p(N.$$.fragment),_e=r(),a=i("div"),p(q.$$.fragment),Fe=r(),K=i("p"),K.innerHTML=tt,Le=r(),Y=i("p"),Y.innerHTML=st,Ie=r(),P=i("div"),p(V.$$.fragment),ke=r(),G=i("p"),G.textContent=nt,He=r(),T=i("div"),p(A.$$.fragment),Oe=r(),Q=i("p"),Q.textContent=rt,Ee=r(),y=i("div"),p(z.$$.fragment),Ne=r(),X=i("p"),X.innerHTML=ot,qe=r(),M=i("div"),p(W.$$.fragment),Ve=r(),ee=i("p"),ee.textContent=it,Ae=r(),S=i("div"),p(j.$$.fragment),ze=r(),te=i("p"),te.textContent=dt,We=r(),U=i("div"),p(R.$$.fragment),je=r(),se=i("p"),se.textContent=at,Re=r(),w=i("div"),p(B.$$.fragment),Be=r(),ne=i("p"),ne.textContent=lt,ve=r(),p(J.$$.fragment),be=r(),C=i("div"),p(Z.$$.fragment),Je=r(),re=i("p"),re.innerHTML=ct,xe=r(),ie=i("p"),this.h()},l(e){const n=gt("svelte-u9bgzb",document.head);x=d(n,"META",{name:!0,content:!0}),n.forEach(t),de=o(e),oe=d(e,"P",{}),v(oe).forEach(t),ae=o(e),m(D.$$.fragment,e),le=o(e),F=d(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1tyrzxd"&&(F.innerHTML=Ke),ce=o(e),L=d(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-16di28y"&&(L.textContent=Ye),ue=o(e),I=d(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1cwsb16"&&(I.textContent=Ge),pe=o(e),k=d(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1n6uqo6"&&(k.innerHTML=Qe),me=o(e),m(H.$$.fragment,e),he=o(e),O=d(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-pt2glg"&&(O.innerHTML=Xe),fe=o(e),E=d(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-j7jp76"&&(E.innerHTML=et),ge=o(e),m(N.$$.fragment,e),_e=o(e),a=d(e,"DIV",{class:!0});var c=v(a);m(q.$$.fragment,c),Fe=o(c),K=d(c,"P",{"data-svelte-h":!0}),u(K)!=="svelte-lu1m8w"&&(K.innerHTML=tt),Le=o(c),Y=d(c,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-50bukd"&&(Y.innerHTML=st),Ie=o(c),P=d(c,"DIV",{class:!0});var $e=v(P);m(V.$$.fragment,$e),ke=o($e),G=d($e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-ixnexx"&&(G.textContent=nt),$e.forEach(t),He=o(c),T=d(c,"DIV",{class:!0});var Pe=v(T);m(A.$$.fragment,Pe),Oe=o(Pe),Q=d(Pe,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-d0n1u7"&&(Q.textContent=rt),Pe.forEach(t),Ee=o(c),y=d(c,"DIV",{class:!0});var Te=v(y);m(z.$$.fragment,Te),Ne=o(Te),X=d(Te,"P",{"data-svelte-h":!0}),u(X)!=="svelte-s6vwmd"&&(X.innerHTML=ot),Te.forEach(t),qe=o(c),M=d(c,"DIV",{class:!0});var ye=v(M);m(W.$$.fragment,ye),Ve=o(ye),ee=d(ye,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1rkfgpx"&&(ee.textContent=it),ye.forEach(t),Ae=o(c),S=d(c,"DIV",{class:!0});var Me=v(S);m(j.$$.fragment,Me),ze=o(Me),te=d(Me,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1k141rk"&&(te.textContent=dt),Me.forEach(t),We=o(c),U=d(c,"DIV",{class:!0});var Se=v(U);m(R.$$.fragment,Se),je=o(Se),se=d(Se,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1vzm9q"&&(se.textContent=at),Se.forEach(t),Re=o(c),w=d(c,"DIV",{class:!0});var Ue=v(w);m(B.$$.fragment,Ue),Be=o(Ue),ne=d(Ue,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-5y602c"&&(ne.textContent=lt),Ue.forEach(t),c.forEach(t),ve=o(e),m(J.$$.fragment,e),be=o(e),C=d(e,"DIV",{class:!0});var we=v(C);m(Z.$$.fragment,we),Je=o(we),re=d(we,"P",{"data-svelte-h":!0}),u(re)!=="svelte-6ojmkw"&&(re.innerHTML=ct),we.forEach(t),xe=o(e),ie=d(e,"P",{}),v(ie).forEach(t),this.h()},h(){b(x,"name","hf:doc:metadata"),b(x,"content",vt),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){s(document.head,x),l(e,de,n),l(e,oe,n),l(e,ae,n),h(D,e,n),l(e,le,n),l(e,F,n),l(e,ce,n),l(e,L,n),l(e,ue,n),l(e,I,n),l(e,pe,n),l(e,k,n),l(e,me,n),h(H,e,n),l(e,he,n),l(e,O,n),l(e,fe,n),l(e,E,n),l(e,ge,n),h(N,e,n),l(e,_e,n),l(e,a,n),h(q,a,null),s(a,Fe),s(a,K),s(a,Le),s(a,Y),s(a,Ie),s(a,P),h(V,P,null),s(P,ke),s(P,G),s(a,He),s(a,T),h(A,T,null),s(T,Oe),s(T,Q),s(a,Ee),s(a,y),h(z,y,null),s(y,Ne),s(y,X),s(a,qe),s(a,M),h(W,M,null),s(M,Ve),s(M,ee),s(a,Ae),s(a,S),h(j,S,null),s(S,ze),s(S,te),s(a,We),s(a,U),h(R,U,null),s(U,je),s(U,se),s(a,Re),s(a,w),h(B,w,null),s(w,Be),s(w,ne),l(e,ve,n),h(J,e,n),l(e,be,n),l(e,C,n),h(Z,C,null),s(C,Je),s(C,re),l(e,xe,n),l(e,ie,n),Ce=!0},p:pt,i(e){Ce||(f(D.$$.fragment,e),f(H.$$.fragment,e),f(N.$$.fragment,e),f(q.$$.fragment,e),f(V.$$.fragment,e),f(A.$$.fragment,e),f(z.$$.fragment,e),f(W.$$.fragment,e),f(j.$$.fragment,e),f(R.$$.fragment,e),f(B.$$.fragment,e),f(J.$$.fragment,e),f(Z.$$.fragment,e),Ce=!0)},o(e){g(D.$$.fragment,e),g(H.$$.fragment,e),g(N.$$.fragment,e),g(q.$$.fragment,e),g(V.$$.fragment,e),g(A.$$.fragment,e),g(z.$$.fragment,e),g(W.$$.fragment,e),g(j.$$.fragment,e),g(R.$$.fragment,e),g(B.$$.fragment,e),g(J.$$.fragment,e),g(Z.$$.fragment,e),Ce=!1},d(e){e&&(t(de),t(oe),t(ae),t(le),t(F),t(ce),t(L),t(ue),t(I),t(pe),t(k),t(me),t(he),t(O),t(fe),t(E),t(ge),t(_e),t(a),t(ve),t(be),t(C),t(xe),t(ie)),t(x),_(D,e),_(H,e),_(N,e),_(q),_(V),_(A),_(z),_(W),_(j),_(R),_(B),_(J,e),_(Z)}}}const vt='{"title":"UniPCMultistepScheduler","local":"unipcmultistepscheduler","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"UniPCMultistepScheduler","local":"diffusers.UniPCMultistepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function bt(Ze){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends ht{constructor(x){super(),ft(this,x,bt,_t,ut,{})}}export{Tt as component};
