import{s as Ts,o as ws,n as wt}from"../chunks/scheduler.182ea377.js";import{S as Us,i as Zs,g as i,s as n,r,A as js,h as o,f as t,c as a,j as bs,u as c,x as p,k as T,y as Ws,a as s,v as d,d as M,t as y,w as u}from"../chunks/index.abf12888.js";import{T as Tt}from"../chunks/Tip.230e2334.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{H as Ae}from"../chunks/Heading.16916d63.js";function vs(U){let m,g='Check out Section 3.5 of the <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">ControlNet</a> paper v1 for a list of ControlNet implementations on various conditioning inputs. You can find the official Stable Diffusion ControlNet conditioned models on <a href="https://huggingface.co/lllyasviel" rel="nofollow">lllyasviel</a>’s Hub profile, and more <a href="https://huggingface.co/models?other=stable-diffusion&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.',h,f,Z='For Stable Diffusion XL (SDXL) ControlNet models, you can find them on the 🤗 <a href="https://huggingface.co/diffusers" rel="nofollow">Diffusers</a> Hub organization, or you can browse <a href="https://huggingface.co/models?other=stable-diffusion-xl&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.';return{c(){m=i("p"),m.innerHTML=g,h=n(),f=i("p"),f.innerHTML=Z},l(b){m=o(b,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1scaly9"&&(m.innerHTML=g),h=a(b),f=o(b,"P",{"data-svelte-h":!0}),p(f)!=="svelte-2pe81s"&&(f.innerHTML=Z)},m(b,w){s(b,m,w),s(b,h,w),s(b,f,w)},p:wt,d(b){b&&(t(m),t(h),t(f))}}}function Cs(U){let m,g="Guess mode does not have any impact on prompt conditioning and you can still provide a prompt if you want.";return{c(){m=i("p"),m.textContent=g},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-14ez4w"&&(m.textContent=g)},m(h,f){s(h,m,f)},p:wt,d(h){h&&t(m)}}}function Gs(U){let m,g='The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter determines how much weight to assign to the conditioning inputs. A value of 0.5 is recommended for good generalization, but feel free to experiment with this number!';return{c(){m=i("p"),m.innerHTML=g},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-52h992"&&(m.innerHTML=g)},m(h,f){s(h,m,f)},p:wt,d(h){h&&t(m)}}}function Is(U){let m,g='Replace the SDXL model with a model like <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> to use multiple conditioning inputs with Stable Diffusion models.';return{c(){m=i("p"),m.innerHTML=g},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-lnumtz"&&(m.innerHTML=g)},m(h,f){s(h,m,f)},p:wt,d(h){h&&t(m)}}}function ks(U){let m,g,h,f,Z,b,w,Ut="ControlNet is a type of model for controlling image diffusion models by conditioning the model with an additional input image. There are many types of conditioning inputs (canny edge, user sketching, human pose, depth, and more) you can use to control a diffusion model. This is hugely useful because it affords you greater control over image generation, making it easier to generate specific images without experimenting with different text prompts or denoising values as much.",qe,j,Pe,V,Zt="A ControlNet model has two sets of weights (or blocks) connected by a zero-convolution layer:",Ke,F,jt="<li>a <em>locked copy</em> keeps everything a large pretrained diffusion model has learned</li> <li>a <em>trainable copy</em> is trained on the additional conditioning input</li>",Oe,Q,Wt="Since the locked copy preserves the pretrained model, training and implementing a ControlNet on a new conditioning input is as fast as finetuning any other model because you aren’t training the model from scratch.",el,S,vt="This guide will show you how to use ControlNet for text-to-image, image-to-image, inpainting, and more! There are many types of ControlNet conditioning inputs to choose from, but in this guide we’ll only focus on several of them. Feel free to experiment with other conditioning inputs!",ll,$,Ct="Before you begin, make sure you have the following libraries installed:",tl,H,sl,z,nl,L,Gt="For text-to-image, you normally pass a text prompt to the model. But with ControlNet, you can specify an additional conditioning input. Let’s condition the model with a canny image, a white outline of an image on a black background. This way, the ControlNet can use the canny image as a control to guide the model to generate an image with the same outline.",al,A,It='Load an image and use the <a href="https://github.com/opencv/opencv-python" rel="nofollow">opencv-python</a> library to extract the canny image:',il,D,ol,W,kt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vermeer_canny_edged.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',pl,q,Bt='Next, load a ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/v0.26.3/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',ml,P,rl,K,_t="Now pass your prompt and canny image to the pipeline:",cl,O,dl,v,Nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-text2img.png"/>',Ml,ee,yl,le,Xt="For image-to-image, you’d typically pass an initial image and a prompt to the pipeline to generate a new image. With ControlNet, you can pass an additional conditioning input to guide the model. Let’s condition the model with a depth map, an image which contains spatial information. This way, the ControlNet can use the depth map as a control to guide the model to generate an image that preserves spatial information.",ul,te,Yt='You’ll use the <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a> for this task, which is different from the <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> because it allows you to pass an initial image as the starting point for the image generation process.',hl,se,xt='Load an image and use the <code>depth-estimation</code> <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/pipelines#transformers.Pipeline" rel="nofollow">Pipeline</a> from 🤗 Transformers to extract the depth map of an image:',Jl,ne,fl,ae,Rt='Next, load a ControlNet model conditioned on depth maps and pass it to the <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a>. Use the faster <a href="/docs/diffusers/v0.26.3/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',gl,ie,bl,oe,Et="Now pass your prompt, initial image, and depth map to the pipeline:",Tl,pe,wl,C,Vt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Ul,me,Zl,re,Ft="For inpainting, you need an initial image, a mask image, and a prompt describing what to replace the mask with. ControlNet models allow you to add another control image to condition a model with. Let’s condition the model with an inpainting mask. This way, the ControlNet can use the inpainting mask as a control to guide the model to generate an image within the mask area.",jl,ce,Qt="Load an initial image and a mask image:",Wl,de,vl,Me,St="Create a function to prepare the control image from the initial and mask images. This’ll create a tensor to mark the pixels in <code>init_image</code> as masked if the corresponding pixel in <code>mask_image</code> is over a certain threshold.",Cl,ye,Gl,G,$t='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask image</figcaption></div>',Il,ue,Ht='Load a ControlNet model conditioned on inpainting and pass it to the <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetInpaintPipeline">StableDiffusionControlNetInpaintPipeline</a>. Use the faster <a href="/docs/diffusers/v0.26.3/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',kl,he,Bl,Je,zt="Now pass your prompt, initial image, mask image, and control image to the pipeline:",_l,fe,Nl,I,Lt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-result.png"/>',Xl,ge,Yl,be,At='<a href="https://github.com/lllyasviel/ControlNet/discussions/188" rel="nofollow">Guess mode</a> does not require supplying a prompt to a ControlNet at all! This forces the ControlNet encoder to do it’s best to “guess” the contents of the input control map (depth map, pose estimation, canny edge, etc.).',xl,Te,Dt="Guess mode adjusts the scale of the output residuals from a ControlNet by a fixed ratio depending on the block depth. The shallowest <code>DownBlock</code> corresponds to 0.1, and as the blocks get deeper, the scale increases exponentially such that the scale of the <code>MidBlock</code> output becomes 1.0.",Rl,k,El,we,qt='Set <code>guess_mode=True</code> in the pipeline, and it is <a href="https://github.com/lllyasviel/ControlNet#guess-mode--non-prompt-mode" rel="nofollow">recommended</a> to set the <code>guidance_scale</code> value between 3.0 and 5.0.',Vl,Ue,Fl,B,Pt='<div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">regular mode with prompt</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0_gm.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guess mode without prompt</figcaption></div>',Ql,Ze,Sl,je,Kt='There aren’t too many ControlNet models compatible with Stable Diffusion XL (SDXL) at the moment, but we’ve trained two full-sized ControlNet models for SDXL conditioned on canny edge detection and depth maps. We’re also experimenting with creating smaller versions of these SDXL-compatible ControlNet models so it is easier to run on resource-constrained hardware. You can find these checkpoints on the <a href="https://huggingface.co/diffusers" rel="nofollow">🤗 Diffusers Hub organization</a>!',$l,We,Ot="Let’s use a SDXL ControlNet conditioned on canny images to generate an image. Start by loading an image and prepare the canny image:",Hl,ve,zl,_,es='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hf-logo-canny.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',Ll,Ce,ls='Load a SDXL ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. You can also enable model offloading to reduce memory usage.',Al,Ge,Dl,Ie,ts="Now pass your prompt (and optionally a negative prompt if you’re using one) and canny image to the pipeline:",ql,N,Pl,ke,Kl,X,ss='<img class="rounded-xl" src="https://huggingface.co/diffusers/controlnet-canny-sdxl-1.0/resolve/main/out_hug_lab_7.png"/>',Ol,Be,ns='You can use <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a> in guess mode as well by setting the parameter to <code>True</code>:',et,_e,lt,Ne,tt,Y,st,Xe,as="You can compose multiple ControlNet conditionings from different image inputs to create a <em>MultiControlNet</em>. To get better results, it is often helpful to:",nt,Ye,is='<li>mask conditionings such that they don’t overlap (for example, mask the area of a canny image where the pose conditioning is located)</li> <li>experiment with the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter to determine how much weight to assign to each conditioning input</li>',at,xe,os="In this example, you’ll combine a canny image and a human pose estimation image to generate a new image.",it,Re,ps="Prepare the canny image conditioning:",ot,Ee,pt,x,ms='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/landscape_canny_masked.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',mt,Ve,rs='For human pose estimation, install <a href="https://github.com/patrickvonplaten/controlnet_aux" rel="nofollow">controlnet_aux</a>:',rt,Fe,ct,Qe,cs="Prepare the human pose estimation conditioning:",dt,Se,Mt,R,ds='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/person_pose.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">human pose image</figcaption></div>',yt,$e,Ms='Load a list of ControlNet models that correspond to each conditioning, and pass them to the <a href="/docs/diffusers/v0.26.3/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/v0.26.3/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to reduce memory usage.',ut,He,ht,ze,ys="Now you can pass your prompt (an optional negative prompt if you’re using one), canny image, and pose image to the pipeline:",Jt,Le,ft,E,us='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/multicontrolnet.png"/>',gt,De,bt;return Z=new Ae({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),j=new Tt({props:{$$slots:{default:[vs]},$$scope:{ctx:U}}}),H=new J({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwb3BlbmN2LXB5dGhvbg==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate opencv-python</span>`,wrap:!1}}),z=new Ae({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),D=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBjdjIlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZoZi5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wdXRfaW1hZ2VfdmVybWVlci5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShvcmlnaW5hbF9pbWFnZSklMEElMEFsb3dfdGhyZXNob2xkJTIwJTNEJTIwMTAwJTBBaGlnaF90aHJlc2hvbGQlMjAlM0QlMjAyMDAlMEElMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlMkMlMjBoaWdoX3RocmVzaG9sZCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2Up",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)`,wrap:!1}}),P=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),O=new J({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBtb25hJTIwbGlzYSUyMiUyQyUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMEEpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),ee=new Ae({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),ne=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWltZzJpbWcuanBnJTIyJTBBKSUwQSUwQWRlZiUyMGdldF9kZXB0aF9tYXAoaW1hZ2UlMkMlMjBkZXB0aF9lc3RpbWF0b3IpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoaW1hZ2UpJTVCJTIyZGVwdGglMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEElMjAlMjAlMjAlMjBkZXRlY3RlZF9tYXAlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KGltYWdlKS5mbG9hdCgpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjBkZXB0aF9tYXAlMjAlM0QlMjBkZXRlY3RlZF9tYXAucGVybXV0ZSgyJTJDJTIwMCUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGVwdGhfbWFwJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiklMEFkZXB0aF9tYXAlMjAlM0QlMjBnZXRfZGVwdGhfbWFwKGltYWdlJTJDJTIwZGVwdGhfZXN0aW1hdG9yKS51bnNxdWVlemUoMCkuaGFsZigpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg&quot;</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image, depth_estimator</span>):
    image = depth_estimator(image)[<span class="hljs-string">&quot;depth&quot;</span>]
    image = np.array(image)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    detected_map = torch.from_numpy(image).<span class="hljs-built_in">float</span>() / <span class="hljs-number">255.0</span>
    depth_map = detected_map.permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> depth_map

depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>)
depth_map = get_depth_map(image, depth_estimator).unsqueeze(<span class="hljs-number">0</span>).half().to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ie=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbWcySW1nUGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRmNvbnRyb2xfdjExZjFwX3NkMTVfZGVwdGglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetImg2ImgPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),pe=new J({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJsZWdvJTIwYmF0bWFuJTIwYW5kJTIwcm9iaW4lMjIlMkMlMjBpbWFnZSUzRGltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX21hcCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;lego batman and robin&quot;</span>, image=image, control_image=depth_map,
).images[<span class="hljs-number">0</span>]
make_image_grid([image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),me=new Ae({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),de=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQuanBnJTIyJTBBKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQtbWFzay5qcGclMjIlMEEpJTBBbWFza19pbWFnZSUyMCUzRCUyMG1hc2tfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg&quot;</span>
)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg&quot;</span>
)
mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
make_image_grid([init_image, mask_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ye=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBtYWtlX2lucGFpbnRfY29uZGl0aW9uKGltYWdlJTJDJTIwaW1hZ2VfbWFzayklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSkuYXN0eXBlKG5wLmZsb2F0MzIpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjBpbWFnZV9tYXNrJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2VfbWFzay5jb252ZXJ0KCUyMkwlMjIpKS5hc3R5cGUobnAuZmxvYXQzMiklMjAlMkYlMjAyNTUuMCUwQSUwQSUyMCUyMCUyMCUyMGFzc2VydCUyMGltYWdlLnNoYXBlJTVCMCUzQTElNUQlMjAlM0QlM0QlMjBpbWFnZV9tYXNrLnNoYXBlJTVCMCUzQTElNUQlMEElMjAlMjAlMjAlMjBpbWFnZSU1QmltYWdlX21hc2slMjAlM0UlMjAwLjUlNUQlMjAlM0QlMjAtMS4wJTIwJTIwJTIzJTIwc2V0JTIwYXMlMjBtYXNrZWQlMjBwaXhlbCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuZXhwYW5kX2RpbXMoaW1hZ2UlMkMlMjAwKS50cmFuc3Bvc2UoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbWFrZV9pbnBhaW50X2NvbmRpdGlvbihpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_inpaint_condition</span>(<span class="hljs-params">image, image_mask</span>):
    image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>
    image_mask = np.array(image_mask.convert(<span class="hljs-string">&quot;L&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>

    <span class="hljs-keyword">assert</span> image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>] == image_mask.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>]
    image[image_mask &gt; <span class="hljs-number">0.5</span>] = -<span class="hljs-number">1.0</span>  <span class="hljs-comment"># set as masked pixel</span>
    image = np.expand_dims(image, <span class="hljs-number">0</span>).transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    image = torch.from_numpy(image)
    <span class="hljs-keyword">return</span> image

control_image = make_inpaint_condition(init_image, mask_image)`,wrap:!1}}),he=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9pbnBhaW50JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldElucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, UniPCMultistepScheduler

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),fe=new J({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJjb3JnaSUyMGZhY2UlMjB3aXRoJTIwbGFyZ2UlMjBlYXJzJTJDJTIwZGV0YWlsZWQlMkMlMjBwaXhhciUyQyUyMGFuaW1hdGVkJTJDJTIwZGlzbmV5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZXRhJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;corgi face with large ears, detailed, pixar, animated, disney&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    eta=<span class="hljs-number">1.0</span>,
    image=init_image,
    mask_image=mask_image,
    control_image=control_image,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),ge=new Ae({props:{title:"Guess mode",local:"guess-mode",headingTag:"h2"}}),k=new Tt({props:{$$slots:{default:[Cs]},$$scope:{ctx:U}}}),Ue=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBjdjIlMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZ0YWt1bWExMDQlMkZjb250cm9sbmV0X2RldiUyRnJlc29sdmUlMkZtYWluJTJGYmlyZF81MTJ4NTEyLnBuZyUyMiklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIyJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUyMGd1ZXNzX21vZGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjApLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

original_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/takuma104/controlnet_dev/resolve/main/bird_512x512.png&quot;</span>)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

image = pipe(<span class="hljs-string">&quot;&quot;</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3.0</span>).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Ze=new Ae({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),ve=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkX2NvbnRyb2xuZXQlMkZoZi1sb2dvLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)
make_image_grid([original_image, canny_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ge=new J({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZzZHhsLXZhZS1mcDE2LWZpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRHZhZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    vae=vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()`,wrap:!1}}),N=new Tt({props:{$$slots:{default:[Gs]},$$scope:{ctx:U}}}),ke=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYWVyaWFsJTIwdmlldyUyQyUyMGElMjBmdXR1cmlzdGljJTIwcmVzZWFyY2glMjBjb21wbGV4JTIwaW4lMjBhJTIwYnJpZ2h0JTIwZm9nZ3klMjBqdW5nbGUlMkMlMjBoYXJkJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAnbG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyclMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTNEMC41JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1Qm9yaWdpbmFsX2ltYWdlJTJDJTIwY2FubnlfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&#x27;low quality, bad quality, sketches&#x27;</span>

image = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),_e=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()

image = np.array(original_image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

image = pipe(
    prompt, negative_prompt=negative_prompt, controlnet_conditioning_scale=<span class="hljs-number">0.5</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>,
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Ne=new Ae({props:{title:"MultiControlNet",local:"multicontrolnet",headingTag:"h2"}}),Y=new Tt({props:{$$slots:{default:[Is]},$$scope:{ctx:U}}}),Ee=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBjdjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbGFuZHNjYXBlLnBuZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQSUwQSUyMyUyMHplcm8lMjBvdXQlMjBtaWRkbGUlMjBjb2x1bW5zJTIwb2YlMjBpbWFnZSUyMHdoZXJlJTIwcG9zZSUyMHdpbGwlMjBiZSUyMG92ZXJsYWlkJTBBemVyb19zdGFydCUyMCUzRCUyMGltYWdlLnNoYXBlJTVCMSU1RCUyMCUyRiUyRiUyMDQlMEF6ZXJvX2VuZCUyMCUzRCUyMHplcm9fc3RhcnQlMjAlMkIlMjBpbWFnZS5zaGFwZSU1QjElNUQlMjAlMkYlMkYlMjAyJTBBaW1hZ2UlNUIlM0ElMkMlMjB6ZXJvX3N0YXJ0JTNBemVyb19lbmQlNUQlMjAlM0QlMjAwJTBBJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWNhbm55X2ltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMGNhbm55X2ltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> cv2

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
)
image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)

<span class="hljs-comment"># zero out middle columns of image where pose will be overlaid</span>
zero_start = image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">4</span>
zero_end = zero_start + image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
image[:, zero_start:zero_end] = <span class="hljs-number">0</span>

image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)
make_image_grid([original_image, canny_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Fe=new J({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyeSUyMGluJTIwQ29sYWIlMEElMjMhcGlwJTIwaW5zdGFsbCUyMC1xJTIwY29udHJvbG5ldC1hdXg=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary library in Colab</span>
<span class="hljs-comment">#!pip install -q controlnet-aux</span>`,wrap:!1}}),Se=new J({props:{code:"ZnJvbSUyMGNvbnRyb2xuZXRfYXV4JTIwaW1wb3J0JTIwT3BlbnBvc2VEZXRlY3RvciUwQSUwQW9wZW5wb3NlJTIwJTNEJTIwT3BlbnBvc2VEZXRlY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRkNvbnRyb2xOZXQlMjIpJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnBlcnNvbi5wbmclMjIlMEEpJTBBb3BlbnBvc2VfaW1hZ2UlMjAlM0QlMjBvcGVucG9zZShvcmlnaW5hbF9pbWFnZSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBvcGVucG9zZV9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector

openpose = OpenposeDetector.from_pretrained(<span class="hljs-string">&quot;lllyasviel/ControlNet&quot;</span>)
original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png&quot;</span>
)
openpose_image = openpose(original_image)
make_image_grid([original_image, openpose_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),He=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGhpYmF1ZCUyRmNvbnRyb2xuZXQtb3BlbnBvc2Utc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZjb250cm9sbmV0LWNhbm55LXNkeGwtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCklMkMlMEElNUQlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0cyUyQyUyMHZhZSUzRHZhZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnets = [
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;thibaud/controlnet-openpose-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
    ),
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
    ),
]

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnets, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),Le=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdpYW50JTIwc3RhbmRpbmclMjBpbiUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwYmVzdCUyMHF1YWxpdHklMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgxKSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1Qm9wZW5wb3NlX2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUyQyUyMGNhbm55X2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QlNUIxLjAlMkMlMjAwLjglNUQlMkMlMEEpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMGNhbm55X2ltYWdlJTJDJTIwb3BlbnBvc2VfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMlNUIwJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMkMlMjBpbWFnZXMlNUIxJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMkMlMjBpbWFnZXMlNUIyJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklNUQlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0QzKQ==",highlighted:`prompt = <span class="hljs-string">&quot;a giant standing in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">1</span>)

images = [openpose_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>)), canny_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))]

images = pipe(
    prompt,
    image=images,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    negative_prompt=negative_prompt,
    num_images_per_prompt=<span class="hljs-number">3</span>,
    controlnet_conditioning_scale=[<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>],
).images
make_image_grid([original_image, canny_image, openpose_image,
                images[<span class="hljs-number">0</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), images[<span class="hljs-number">1</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), images[<span class="hljs-number">2</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),{c(){m=i("meta"),g=n(),h=i("p"),f=n(),r(Z.$$.fragment),b=n(),w=i("p"),w.textContent=Ut,qe=n(),r(j.$$.fragment),Pe=n(),V=i("p"),V.textContent=Zt,Ke=n(),F=i("ul"),F.innerHTML=jt,Oe=n(),Q=i("p"),Q.textContent=Wt,el=n(),S=i("p"),S.textContent=vt,ll=n(),$=i("p"),$.textContent=Ct,tl=n(),r(H.$$.fragment),sl=n(),r(z.$$.fragment),nl=n(),L=i("p"),L.textContent=Gt,al=n(),A=i("p"),A.innerHTML=It,il=n(),r(D.$$.fragment),ol=n(),W=i("div"),W.innerHTML=kt,pl=n(),q=i("p"),q.innerHTML=Bt,ml=n(),r(P.$$.fragment),rl=n(),K=i("p"),K.textContent=_t,cl=n(),r(O.$$.fragment),dl=n(),v=i("div"),v.innerHTML=Nt,Ml=n(),r(ee.$$.fragment),yl=n(),le=i("p"),le.textContent=Xt,ul=n(),te=i("p"),te.innerHTML=Yt,hl=n(),se=i("p"),se.innerHTML=xt,Jl=n(),r(ne.$$.fragment),fl=n(),ae=i("p"),ae.innerHTML=Rt,gl=n(),r(ie.$$.fragment),bl=n(),oe=i("p"),oe.textContent=Et,Tl=n(),r(pe.$$.fragment),wl=n(),C=i("div"),C.innerHTML=Vt,Ul=n(),r(me.$$.fragment),Zl=n(),re=i("p"),re.textContent=Ft,jl=n(),ce=i("p"),ce.textContent=Qt,Wl=n(),r(de.$$.fragment),vl=n(),Me=i("p"),Me.innerHTML=St,Cl=n(),r(ye.$$.fragment),Gl=n(),G=i("div"),G.innerHTML=$t,Il=n(),ue=i("p"),ue.innerHTML=Ht,kl=n(),r(he.$$.fragment),Bl=n(),Je=i("p"),Je.textContent=zt,_l=n(),r(fe.$$.fragment),Nl=n(),I=i("div"),I.innerHTML=Lt,Xl=n(),r(ge.$$.fragment),Yl=n(),be=i("p"),be.innerHTML=At,xl=n(),Te=i("p"),Te.innerHTML=Dt,Rl=n(),r(k.$$.fragment),El=n(),we=i("p"),we.innerHTML=qt,Vl=n(),r(Ue.$$.fragment),Fl=n(),B=i("div"),B.innerHTML=Pt,Ql=n(),r(Ze.$$.fragment),Sl=n(),je=i("p"),je.innerHTML=Kt,$l=n(),We=i("p"),We.textContent=Ot,Hl=n(),r(ve.$$.fragment),zl=n(),_=i("div"),_.innerHTML=es,Ll=n(),Ce=i("p"),Ce.innerHTML=ls,Al=n(),r(Ge.$$.fragment),Dl=n(),Ie=i("p"),Ie.textContent=ts,ql=n(),r(N.$$.fragment),Pl=n(),r(ke.$$.fragment),Kl=n(),X=i("div"),X.innerHTML=ss,Ol=n(),Be=i("p"),Be.innerHTML=ns,et=n(),r(_e.$$.fragment),lt=n(),r(Ne.$$.fragment),tt=n(),r(Y.$$.fragment),st=n(),Xe=i("p"),Xe.innerHTML=as,nt=n(),Ye=i("ol"),Ye.innerHTML=is,at=n(),xe=i("p"),xe.textContent=os,it=n(),Re=i("p"),Re.textContent=ps,ot=n(),r(Ee.$$.fragment),pt=n(),x=i("div"),x.innerHTML=ms,mt=n(),Ve=i("p"),Ve.innerHTML=rs,rt=n(),r(Fe.$$.fragment),ct=n(),Qe=i("p"),Qe.textContent=cs,dt=n(),r(Se.$$.fragment),Mt=n(),R=i("div"),R.innerHTML=ds,yt=n(),$e=i("p"),$e.innerHTML=Ms,ut=n(),r(He.$$.fragment),ht=n(),ze=i("p"),ze.textContent=ys,Jt=n(),r(Le.$$.fragment),ft=n(),E=i("div"),E.innerHTML=us,gt=n(),De=i("p"),this.h()},l(e){const l=js("svelte-u9bgzb",document.head);m=o(l,"META",{name:!0,content:!0}),l.forEach(t),g=a(e),h=o(e,"P",{}),bs(h).forEach(t),f=a(e),c(Z.$$.fragment,e),b=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1ersfq7"&&(w.textContent=Ut),qe=a(e),c(j.$$.fragment,e),Pe=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-r7ehkq"&&(V.textContent=Zt),Ke=a(e),F=o(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-1jzb95l"&&(F.innerHTML=jt),Oe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-10jstxp"&&(Q.textContent=Wt),el=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1rkzg2g"&&(S.textContent=vt),ll=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-cwruts"&&($.textContent=Ct),tl=a(e),c(H.$$.fragment,e),sl=a(e),c(z.$$.fragment,e),nl=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1cb54q2"&&(L.textContent=Gt),al=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-9znxu8"&&(A.innerHTML=It),il=a(e),c(D.$$.fragment,e),ol=a(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1jr9xr4"&&(W.innerHTML=kt),pl=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1dy5le"&&(q.innerHTML=Bt),ml=a(e),c(P.$$.fragment,e),rl=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-17x9oax"&&(K.textContent=_t),cl=a(e),c(O.$$.fragment,e),dl=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-3r1z1k"&&(v.innerHTML=Nt),Ml=a(e),c(ee.$$.fragment,e),yl=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-g01jh2"&&(le.textContent=Xt),ul=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1n4jyiy"&&(te.innerHTML=Yt),hl=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1v7q7pv"&&(se.innerHTML=xt),Jl=a(e),c(ne.$$.fragment,e),fl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-a0ccx5"&&(ae.innerHTML=Rt),gl=a(e),c(ie.$$.fragment,e),bl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-wyr53z"&&(oe.textContent=Et),Tl=a(e),c(pe.$$.fragment,e),wl=a(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-8qhhvs"&&(C.innerHTML=Vt),Ul=a(e),c(me.$$.fragment,e),Zl=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1i60bwf"&&(re.textContent=Ft),jl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-175mm0t"&&(ce.textContent=Qt),Wl=a(e),c(de.$$.fragment,e),vl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-4efl8b"&&(Me.innerHTML=St),Cl=a(e),c(ye.$$.fragment,e),Gl=a(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-grxw51"&&(G.innerHTML=$t),Il=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-v98n0b"&&(ue.innerHTML=Ht),kl=a(e),c(he.$$.fragment,e),Bl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-118t2qr"&&(Je.textContent=zt),_l=a(e),c(fe.$$.fragment,e),Nl=a(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-1qk6bz9"&&(I.innerHTML=Lt),Xl=a(e),c(ge.$$.fragment,e),Yl=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-w08m5a"&&(be.innerHTML=At),xl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-vnjl1j"&&(Te.innerHTML=Dt),Rl=a(e),c(k.$$.fragment,e),El=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-vqtz65"&&(we.innerHTML=qt),Vl=a(e),c(Ue.$$.fragment,e),Fl=a(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-1hf21gv"&&(B.innerHTML=Pt),Ql=a(e),c(Ze.$$.fragment,e),Sl=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1jgtfzx"&&(je.innerHTML=Kt),$l=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-7i5g8g"&&(We.textContent=Ot),Hl=a(e),c(ve.$$.fragment,e),zl=a(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-j8n5na"&&(_.innerHTML=es),Ll=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-gn68ar"&&(Ce.innerHTML=ls),Al=a(e),c(Ge.$$.fragment,e),Dl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-172pcgi"&&(Ie.textContent=ts),ql=a(e),c(N.$$.fragment,e),Pl=a(e),c(ke.$$.fragment,e),Kl=a(e),X=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(X)!=="svelte-8vwtkd"&&(X.innerHTML=ss),Ol=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-cylufb"&&(Be.innerHTML=ns),et=a(e),c(_e.$$.fragment,e),lt=a(e),c(Ne.$$.fragment,e),tt=a(e),c(Y.$$.fragment,e),st=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1engdvd"&&(Xe.innerHTML=as),nt=a(e),Ye=o(e,"OL",{"data-svelte-h":!0}),p(Ye)!=="svelte-18sf1v5"&&(Ye.innerHTML=is),at=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1gpdoop"&&(xe.textContent=os),it=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1k4sivd"&&(Re.textContent=ps),ot=a(e),c(Ee.$$.fragment,e),pt=a(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-1cl87j5"&&(x.innerHTML=ms),mt=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-2v63o"&&(Ve.innerHTML=rs),rt=a(e),c(Fe.$$.fragment,e),ct=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-bab8ey"&&(Qe.textContent=cs),dt=a(e),c(Se.$$.fragment,e),Mt=a(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-1og8gmm"&&(R.innerHTML=ds),yt=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1j0qveb"&&($e.innerHTML=Ms),ut=a(e),c(He.$$.fragment,e),ht=a(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-d5aph9"&&(ze.textContent=ys),Jt=a(e),c(Le.$$.fragment,e),ft=a(e),E=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(E)!=="svelte-1qlyggw"&&(E.innerHTML=us),gt=a(e),De=o(e,"P",{}),bs(De).forEach(t),this.h()},h(){T(m,"name","hf:doc:metadata"),T(m,"content",Bs),T(W,"class","flex gap-4"),T(v,"class","flex justify-center"),T(C,"class","flex gap-4"),T(G,"class","flex gap-4"),T(I,"class","flex justify-center"),T(B,"class","flex gap-4"),T(_,"class","flex gap-4"),T(X,"class","flex justify-center"),T(x,"class","flex gap-4"),T(R,"class","flex gap-4"),T(E,"class","flex justify-center")},m(e,l){Ws(document.head,m),s(e,g,l),s(e,h,l),s(e,f,l),d(Z,e,l),s(e,b,l),s(e,w,l),s(e,qe,l),d(j,e,l),s(e,Pe,l),s(e,V,l),s(e,Ke,l),s(e,F,l),s(e,Oe,l),s(e,Q,l),s(e,el,l),s(e,S,l),s(e,ll,l),s(e,$,l),s(e,tl,l),d(H,e,l),s(e,sl,l),d(z,e,l),s(e,nl,l),s(e,L,l),s(e,al,l),s(e,A,l),s(e,il,l),d(D,e,l),s(e,ol,l),s(e,W,l),s(e,pl,l),s(e,q,l),s(e,ml,l),d(P,e,l),s(e,rl,l),s(e,K,l),s(e,cl,l),d(O,e,l),s(e,dl,l),s(e,v,l),s(e,Ml,l),d(ee,e,l),s(e,yl,l),s(e,le,l),s(e,ul,l),s(e,te,l),s(e,hl,l),s(e,se,l),s(e,Jl,l),d(ne,e,l),s(e,fl,l),s(e,ae,l),s(e,gl,l),d(ie,e,l),s(e,bl,l),s(e,oe,l),s(e,Tl,l),d(pe,e,l),s(e,wl,l),s(e,C,l),s(e,Ul,l),d(me,e,l),s(e,Zl,l),s(e,re,l),s(e,jl,l),s(e,ce,l),s(e,Wl,l),d(de,e,l),s(e,vl,l),s(e,Me,l),s(e,Cl,l),d(ye,e,l),s(e,Gl,l),s(e,G,l),s(e,Il,l),s(e,ue,l),s(e,kl,l),d(he,e,l),s(e,Bl,l),s(e,Je,l),s(e,_l,l),d(fe,e,l),s(e,Nl,l),s(e,I,l),s(e,Xl,l),d(ge,e,l),s(e,Yl,l),s(e,be,l),s(e,xl,l),s(e,Te,l),s(e,Rl,l),d(k,e,l),s(e,El,l),s(e,we,l),s(e,Vl,l),d(Ue,e,l),s(e,Fl,l),s(e,B,l),s(e,Ql,l),d(Ze,e,l),s(e,Sl,l),s(e,je,l),s(e,$l,l),s(e,We,l),s(e,Hl,l),d(ve,e,l),s(e,zl,l),s(e,_,l),s(e,Ll,l),s(e,Ce,l),s(e,Al,l),d(Ge,e,l),s(e,Dl,l),s(e,Ie,l),s(e,ql,l),d(N,e,l),s(e,Pl,l),d(ke,e,l),s(e,Kl,l),s(e,X,l),s(e,Ol,l),s(e,Be,l),s(e,et,l),d(_e,e,l),s(e,lt,l),d(Ne,e,l),s(e,tt,l),d(Y,e,l),s(e,st,l),s(e,Xe,l),s(e,nt,l),s(e,Ye,l),s(e,at,l),s(e,xe,l),s(e,it,l),s(e,Re,l),s(e,ot,l),d(Ee,e,l),s(e,pt,l),s(e,x,l),s(e,mt,l),s(e,Ve,l),s(e,rt,l),d(Fe,e,l),s(e,ct,l),s(e,Qe,l),s(e,dt,l),d(Se,e,l),s(e,Mt,l),s(e,R,l),s(e,yt,l),s(e,$e,l),s(e,ut,l),d(He,e,l),s(e,ht,l),s(e,ze,l),s(e,Jt,l),d(Le,e,l),s(e,ft,l),s(e,E,l),s(e,gt,l),s(e,De,l),bt=!0},p(e,[l]){const hs={};l&2&&(hs.$$scope={dirty:l,ctx:e}),j.$set(hs);const Js={};l&2&&(Js.$$scope={dirty:l,ctx:e}),k.$set(Js);const fs={};l&2&&(fs.$$scope={dirty:l,ctx:e}),N.$set(fs);const gs={};l&2&&(gs.$$scope={dirty:l,ctx:e}),Y.$set(gs)},i(e){bt||(M(Z.$$.fragment,e),M(j.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(D.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(ye.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(k.$$.fragment,e),M(Ue.$$.fragment,e),M(Ze.$$.fragment,e),M(ve.$$.fragment,e),M(Ge.$$.fragment,e),M(N.$$.fragment,e),M(ke.$$.fragment,e),M(_e.$$.fragment,e),M(Ne.$$.fragment,e),M(Y.$$.fragment,e),M(Ee.$$.fragment,e),M(Fe.$$.fragment,e),M(Se.$$.fragment,e),M(He.$$.fragment,e),M(Le.$$.fragment,e),bt=!0)},o(e){y(Z.$$.fragment,e),y(j.$$.fragment,e),y(H.$$.fragment,e),y(z.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(de.$$.fragment,e),y(ye.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(k.$$.fragment,e),y(Ue.$$.fragment,e),y(Ze.$$.fragment,e),y(ve.$$.fragment,e),y(Ge.$$.fragment,e),y(N.$$.fragment,e),y(ke.$$.fragment,e),y(_e.$$.fragment,e),y(Ne.$$.fragment,e),y(Y.$$.fragment,e),y(Ee.$$.fragment,e),y(Fe.$$.fragment,e),y(Se.$$.fragment,e),y(He.$$.fragment,e),y(Le.$$.fragment,e),bt=!1},d(e){e&&(t(g),t(h),t(f),t(b),t(w),t(qe),t(Pe),t(V),t(Ke),t(F),t(Oe),t(Q),t(el),t(S),t(ll),t($),t(tl),t(sl),t(nl),t(L),t(al),t(A),t(il),t(ol),t(W),t(pl),t(q),t(ml),t(rl),t(K),t(cl),t(dl),t(v),t(Ml),t(yl),t(le),t(ul),t(te),t(hl),t(se),t(Jl),t(fl),t(ae),t(gl),t(bl),t(oe),t(Tl),t(wl),t(C),t(Ul),t(Zl),t(re),t(jl),t(ce),t(Wl),t(vl),t(Me),t(Cl),t(Gl),t(G),t(Il),t(ue),t(kl),t(Bl),t(Je),t(_l),t(Nl),t(I),t(Xl),t(Yl),t(be),t(xl),t(Te),t(Rl),t(El),t(we),t(Vl),t(Fl),t(B),t(Ql),t(Sl),t(je),t($l),t(We),t(Hl),t(zl),t(_),t(Ll),t(Ce),t(Al),t(Dl),t(Ie),t(ql),t(Pl),t(Kl),t(X),t(Ol),t(Be),t(et),t(lt),t(tt),t(st),t(Xe),t(nt),t(Ye),t(at),t(xe),t(it),t(Re),t(ot),t(pt),t(x),t(mt),t(Ve),t(rt),t(ct),t(Qe),t(dt),t(Mt),t(R),t(yt),t($e),t(ut),t(ht),t(ze),t(Jt),t(ft),t(E),t(gt),t(De)),t(m),u(Z,e),u(j,e),u(H,e),u(z,e),u(D,e),u(P,e),u(O,e),u(ee,e),u(ne,e),u(ie,e),u(pe,e),u(me,e),u(de,e),u(ye,e),u(he,e),u(fe,e),u(ge,e),u(k,e),u(Ue,e),u(Ze,e),u(ve,e),u(Ge,e),u(N,e),u(ke,e),u(_e,e),u(Ne,e),u(Y,e),u(Ee,e),u(Fe,e),u(Se,e),u(He,e),u(Le,e)}}}const Bs='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Guess mode","local":"guess-mode","sections":[],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[],"depth":2},{"title":"MultiControlNet","local":"multicontrolnet","sections":[],"depth":2}],"depth":1}';function _s(U){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends Us{constructor(m){super(),Zs(this,m,_s,ks,Ts,{})}}export{Es as component};
