import{s as $t,o as It,n as Re}from"../chunks/scheduler.8c3d61f6.js";import{S as Wt,i as Xt,g as p,s as i,r as c,A as Rt,h as d,f as s,c as o,j as Bt,u as J,x as f,k as ft,y as Gt,a as l,v as M,d as T,t as b,w as h}from"../chunks/index.da70eac4.js";import{T as Xe}from"../chunks/Tip.1d9b8c37.js";import{C as z}from"../chunks/CodeBlock.00a903b3.js";import{H as ee,E as kt}from"../chunks/EditOnGithub.1e64e623.js";import{H as Ft,a as vt}from"../chunks/HfOption.c1483eb1.js";function Vt(I){let a,w='The <code>CLIPTextModel</code> and <a href="/docs/diffusers/v0.32.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/v0.32.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.';return{c(){a=p("p"),a.innerHTML=w},l(m){a=d(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-2ryp8k"&&(a.innerHTML=w)},m(m,u){l(m,a,u)},p:Re,d(m){m&&s(a)}}}function zt(I){let a,w="Quantizing a model in 8-bit halves the memory-usage:",m,u,y=`bitsandbytes is supported in both Transformers and Diffusers, so you can quantize both the
<a href="/docs/diffusers/v0.32.0/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/v4.47.1/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,C,U,D="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",E,g,L,B,k,W,S="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",F,X,q,_,te="Let’s generate an image using our quantized models.",N,j,P=`Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the
CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.`,V,R,Q,Z,K='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/8bit.png"/>',G,v,Y='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/v0.32.0/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',A,$,H='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/v0.32.0/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 8-bit models locally with <a href="/docs/diffusers/v0.32.0/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',x;return g=new Xe({props:{warning:!1,$$slots:{default:[Vt]},$$scope:{ctx:I}}}),B=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyklMEElMEF0ZXh0X2VuY29kZXJfMl84Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyklMEElMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

transformer_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),X=new z({props:{code:"dHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyQiUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSk=",highlighted:`transformer_8bit = FluxTransformer2DModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),R=new z({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSgqKnBpcGVfa3dhcmdzJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCklMkMpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_8bit,
    text_encoder_2=text_encoder_2_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=p("p"),a.textContent=w,m=i(),u=p("p"),u.innerHTML=y,C=i(),U=p("p"),U.innerHTML=D,E=i(),c(g.$$.fragment),L=i(),c(B.$$.fragment),k=i(),W=p("p"),W.innerHTML=S,F=i(),c(X.$$.fragment),q=i(),_=p("p"),_.textContent=te,N=i(),j=p("p"),j.innerHTML=P,V=i(),c(R.$$.fragment),Q=i(),Z=p("div"),Z.innerHTML=K,G=i(),v=p("p"),v.innerHTML=Y,A=i(),$=p("p"),$.innerHTML=H,this.h()},l(t){a=d(t,"P",{"data-svelte-h":!0}),f(a)!=="svelte-4djpqq"&&(a.textContent=w),m=o(t),u=d(t,"P",{"data-svelte-h":!0}),f(u)!=="svelte-145qfzk"&&(u.innerHTML=y),C=o(t),U=d(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-mdqrzc"&&(U.innerHTML=D),E=o(t),J(g.$$.fragment,t),L=o(t),J(B.$$.fragment,t),k=o(t),W=d(t,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1qozsrk"&&(W.innerHTML=S),F=o(t),J(X.$$.fragment,t),q=o(t),_=d(t,"P",{"data-svelte-h":!0}),f(_)!=="svelte-2bde4h"&&(_.textContent=te),N=o(t),j=d(t,"P",{"data-svelte-h":!0}),f(j)!=="svelte-1eyrcy7"&&(j.innerHTML=P),V=o(t),J(R.$$.fragment,t),Q=o(t),Z=d(t,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-14afenp"&&(Z.innerHTML=K),G=o(t),v=d(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1vq7eky"&&(v.innerHTML=Y),A=o(t),$=d(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-1lyo5s"&&($.innerHTML=H),this.h()},h(){ft(Z,"class","flex justify-center")},m(t,r){l(t,a,r),l(t,m,r),l(t,u,r),l(t,C,r),l(t,U,r),l(t,E,r),M(g,t,r),l(t,L,r),M(B,t,r),l(t,k,r),l(t,W,r),l(t,F,r),M(X,t,r),l(t,q,r),l(t,_,r),l(t,N,r),l(t,j,r),l(t,V,r),M(R,t,r),l(t,Q,r),l(t,Z,r),l(t,G,r),l(t,v,r),l(t,A,r),l(t,$,r),x=!0},p(t,r){const O={};r&2&&(O.$$scope={dirty:r,ctx:t}),g.$set(O)},i(t){x||(T(g.$$.fragment,t),T(B.$$.fragment,t),T(X.$$.fragment,t),T(R.$$.fragment,t),x=!0)},o(t){b(g.$$.fragment,t),b(B.$$.fragment,t),b(X.$$.fragment,t),b(R.$$.fragment,t),x=!1},d(t){t&&(s(a),s(m),s(u),s(C),s(U),s(E),s(L),s(k),s(W),s(F),s(q),s(_),s(N),s(j),s(V),s(Q),s(Z),s(G),s(v),s(A),s($)),h(g,t),h(B,t),h(X,t),h(R,t)}}}function Et(I){let a,w='The <code>CLIPTextModel</code> and <a href="/docs/diffusers/v0.32.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/v0.32.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.';return{c(){a=p("p"),a.innerHTML=w},l(m){a=d(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-2ryp8k"&&(a.innerHTML=w)},m(m,u){l(m,a,u)},p:Re,d(m){m&&s(a)}}}function qt(I){let a,w="Quantizing a model in 4-bit reduces your memory-usage by 4x:",m,u,y=`bitsandbytes is supported in both Transformers and Diffusers, so you can can quantize both the
<a href="/docs/diffusers/v0.32.0/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/v4.47.1/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,C,U,D="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",E,g,L,B,k,W,S="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",F,X,q,_,te="Let’s generate an image using our quantized models.",N,j,P="Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.",V,R,Q,Z,K='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/4bit.png"/>',G,v,Y='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/v0.32.0/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',A,$,H='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/v0.32.0/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 4-bit models locally with <a href="/docs/diffusers/v0.32.0/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',x;return g=new Xe({props:{warning:!1,$$slots:{default:[Et]},$$scope:{ctx:I}}}),B=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),X=new z({props:{code:"dHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyQiUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSk=",highlighted:`transformer_4bit = FluxTransformer2DModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),R=new z({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSgqKnBpcGVfa3dhcmdzJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCklMkMpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_4bit,
    text_encoder_2=text_encoder_2_4bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=p("p"),a.textContent=w,m=i(),u=p("p"),u.innerHTML=y,C=i(),U=p("p"),U.innerHTML=D,E=i(),c(g.$$.fragment),L=i(),c(B.$$.fragment),k=i(),W=p("p"),W.innerHTML=S,F=i(),c(X.$$.fragment),q=i(),_=p("p"),_.textContent=te,N=i(),j=p("p"),j.innerHTML=P,V=i(),c(R.$$.fragment),Q=i(),Z=p("div"),Z.innerHTML=K,G=i(),v=p("p"),v.innerHTML=Y,A=i(),$=p("p"),$.innerHTML=H,this.h()},l(t){a=d(t,"P",{"data-svelte-h":!0}),f(a)!=="svelte-i07c71"&&(a.textContent=w),m=o(t),u=d(t,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1j53ouq"&&(u.innerHTML=y),C=o(t),U=d(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-mdqrzc"&&(U.innerHTML=D),E=o(t),J(g.$$.fragment,t),L=o(t),J(B.$$.fragment,t),k=o(t),W=d(t,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1qozsrk"&&(W.innerHTML=S),F=o(t),J(X.$$.fragment,t),q=o(t),_=d(t,"P",{"data-svelte-h":!0}),f(_)!=="svelte-2bde4h"&&(_.textContent=te),N=o(t),j=d(t,"P",{"data-svelte-h":!0}),f(j)!=="svelte-6ilppp"&&(j.innerHTML=P),V=o(t),J(R.$$.fragment,t),Q=o(t),Z=d(t,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-qev6y1"&&(Z.innerHTML=K),G=o(t),v=d(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1vq7eky"&&(v.innerHTML=Y),A=o(t),$=d(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-13kmjng"&&($.innerHTML=H),this.h()},h(){ft(Z,"class","flex justify-center")},m(t,r){l(t,a,r),l(t,m,r),l(t,u,r),l(t,C,r),l(t,U,r),l(t,E,r),M(g,t,r),l(t,L,r),M(B,t,r),l(t,k,r),l(t,W,r),l(t,F,r),M(X,t,r),l(t,q,r),l(t,_,r),l(t,N,r),l(t,j,r),l(t,V,r),M(R,t,r),l(t,Q,r),l(t,Z,r),l(t,G,r),l(t,v,r),l(t,A,r),l(t,$,r),x=!0},p(t,r){const O={};r&2&&(O.$$scope={dirty:r,ctx:t}),g.$set(O)},i(t){x||(T(g.$$.fragment,t),T(B.$$.fragment,t),T(X.$$.fragment,t),T(R.$$.fragment,t),x=!0)},o(t){b(g.$$.fragment,t),b(B.$$.fragment,t),b(X.$$.fragment,t),b(R.$$.fragment,t),x=!1},d(t){t&&(s(a),s(m),s(u),s(C),s(U),s(E),s(L),s(k),s(W),s(F),s(q),s(_),s(N),s(j),s(V),s(Q),s(Z),s(G),s(v),s(A),s($)),h(g,t),h(B,t),h(X,t),h(R,t)}}}function Nt(I){let a,w,m,u;return a=new vt({props:{id:"bnb",option:"8-bit",$$slots:{default:[zt]},$$scope:{ctx:I}}}),m=new vt({props:{id:"bnb",option:"4-bit",$$slots:{default:[qt]},$$scope:{ctx:I}}}),{c(){c(a.$$.fragment),w=i(),c(m.$$.fragment)},l(y){J(a.$$.fragment,y),w=o(y),J(m.$$.fragment,y)},m(y,C){M(a,y,C),l(y,w,C),M(m,y,C),u=!0},p(y,C){const U={};C&2&&(U.$$scope={dirty:C,ctx:y}),a.$set(U);const D={};C&2&&(D.$$scope={dirty:C,ctx:y}),m.$set(D)},i(y){u||(T(a.$$.fragment,y),T(m.$$.fragment,y),u=!0)},o(y){b(a.$$.fragment,y),b(m.$$.fragment,y),u=!1},d(y){y&&s(w),h(a,y),h(m,y)}}}function Qt(I){let a,w="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){a=p("p"),a.innerHTML=w},l(m){a=d(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-of9sym"&&(a.innerHTML=w)},m(m,u){l(m,a,u)},p:Re,d(m){m&&s(a)}}}function xt(I){let a,w='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){a=p("p"),a.innerHTML=w},l(m){a=d(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1bb05fp"&&(a.innerHTML=w)},m(m,u){l(m,a,u)},p:Re,d(m){m&&s(a)}}}function Yt(I){let a,w='Learn more about its details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){a=p("p"),a.innerHTML=w},l(m){a=d(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-kpdzjq"&&(a.innerHTML=w)},m(m,u){l(m,a,u)},p:Re,d(m){m&&s(a)}}}function Ht(I){let a,w,m,u,y,C,U,D='<a href="https://huggingface.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance.',E,g,L='4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',B,k,W=`This guide demonstrates how quantization can enable running
<a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a>
on less than 16GB of VRAM and even on a free Google
Colab instance.`,S,F,X='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/comparison.png" alt="comparison image"/>',q,_,te="To use bitsandbytes, make sure you have the following libraries installed:",N,j,P,V,R='Now you can quantize a model by passing a <a href="/docs/diffusers/v0.32.0/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/diffusers/v0.32.0/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',Q,Z,K,G,v,Y,A="Check your memory footprint with the <code>get_memory_footprint</code> method:",$,H,x,t,r='Quantized models can be loaded from the <a href="/docs/diffusers/v0.32.0/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method without needing to specify the <code>quantization_config</code> parameters:',O,ne,Ge,ae,ke,se,Fe,ie,ut="This section explores some of the specific features of 8-bit models, such as outlier thresholds and skipping module conversion.",Ve,oe,ze,re,yt="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",Ee,me,ct='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/diffusers/v0.32.0/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',qe,pe,Ne,de,Qe,fe,Jt='For some models, you don’t need to quantize every module to 8-bit which can actually cause instability. For example, for diffusion models like <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>, the <code>proj_out</code> module can be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/diffusers/v0.32.0/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',xe,ue,Ye,ye,He,le,Le,ce,Mt="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",Ae,Je,De,Me,Tt='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/diffusers/v0.32.0/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Se,Te,Pe,be,Ke,he,bt='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/diffusers/v0.32.0/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Oe,we,et,Ue,ht="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",tt,Ze,st,ge,wt="Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter.",lt,Ce,nt,_e,at,je,Ut="Once quantized, you can dequantize a model to its original precision, but this might result in a small loss of quality. Make sure you have enough GPU RAM to fit the dequantized model.",it,Be,ot,ve,rt,$e,Zt='<li><a href="https://gist.github.com/sayakpaul/c76bd845b48759e11687ac550b99d8b4" rel="nofollow">End-to-end notebook showing Flux.1 Dev inference in a free-tier Colab</a></li> <li><a href="https://gist.github.com/sayakpaul/05afd428bc089b47af7c016e42004527" rel="nofollow">Training</a></li>',mt,Ie,pt,We,dt;return y=new ee({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),j=new z({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMjAtVQ==",highlighted:"pip install diffusers transformers accelerate bitsandbytes -U",wrap:!1}}),Z=new Ft({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Nt]},$$scope:{ctx:I}}}),G=new Xe({props:{warning:!0,$$slots:{default:[Qt]},$$scope:{ctx:I}}}),H=new z({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),ne=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZmbHV4LjEtZGV2LW5mNC1wa2clMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;hf-internal-testing/flux.1-dev-nf4-pkg&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>
)`,wrap:!1}}),ae=new ee({props:{title:"8-bit (LLM.int8() algorithm)",local:"8-bit-llmint8-algorithm",headingTag:"h2"}}),se=new Xe({props:{$$slots:{default:[xt]},$$scope:{ctx:I}}}),oe=new ee({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),pe=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBsbG1faW50OF90aHJlc2hvbGQlM0QxMCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),de=new ee({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),ue=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3NraXBfbW9kdWxlcyUzRCU1QiUyMnByb2pfb3V0JTIyJTVEJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_skip_modules=[<span class="hljs-string">&quot;proj_out&quot;</span>],
)

model_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),ye=new ee({props:{title:"4-bit (QLoRA algorithm)",local:"4-bit-qlora-algorithm",headingTag:"h2"}}),le=new Xe({props:{$$slots:{default:[Yt]},$$scope:{ctx:I}}}),Je=new ee({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),Te=new z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),be=new ee({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),we=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBKSUwQSUwQXRyYW5zZm9ybWVyXzRiaXQlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Ze=new ee({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),Ce=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),_e=new ee({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),Be=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0LmRlcXVhbnRpemUoKSUwQXRyYW5zZm9ybWVyXzRiaXQuZGVxdWFudGl6ZSgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

text_encoder_2_4bit.dequantize()
transformer_4bit.dequantize()`,wrap:!1}}),ve=new ee({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ie=new kt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){a=p("meta"),w=i(),m=p("p"),u=i(),c(y.$$.fragment),C=i(),U=p("p"),U.innerHTML=D,E=i(),g=p("p"),g.innerHTML=L,B=i(),k=p("p"),k.innerHTML=W,S=i(),F=p("p"),F.innerHTML=X,q=i(),_=p("p"),_.textContent=te,N=i(),c(j.$$.fragment),P=i(),V=p("p"),V.innerHTML=R,Q=i(),c(Z.$$.fragment),K=i(),c(G.$$.fragment),v=i(),Y=p("p"),Y.innerHTML=A,$=i(),c(H.$$.fragment),x=i(),t=p("p"),t.innerHTML=r,O=i(),c(ne.$$.fragment),Ge=i(),c(ae.$$.fragment),ke=i(),c(se.$$.fragment),Fe=i(),ie=p("p"),ie.textContent=ut,Ve=i(),c(oe.$$.fragment),ze=i(),re=p("p"),re.textContent=yt,Ee=i(),me=p("p"),me.innerHTML=ct,qe=i(),c(pe.$$.fragment),Ne=i(),c(de.$$.fragment),Qe=i(),fe=p("p"),fe.innerHTML=Jt,xe=i(),c(ue.$$.fragment),Ye=i(),c(ye.$$.fragment),He=i(),c(le.$$.fragment),Le=i(),ce=p("p"),ce.textContent=Mt,Ae=i(),c(Je.$$.fragment),De=i(),Me=p("p"),Me.innerHTML=Tt,Se=i(),c(Te.$$.fragment),Pe=i(),c(be.$$.fragment),Ke=i(),he=p("p"),he.innerHTML=bt,Oe=i(),c(we.$$.fragment),et=i(),Ue=p("p"),Ue.innerHTML=ht,tt=i(),c(Ze.$$.fragment),st=i(),ge=p("p"),ge.textContent=wt,lt=i(),c(Ce.$$.fragment),nt=i(),c(_e.$$.fragment),at=i(),je=p("p"),je.textContent=Ut,it=i(),c(Be.$$.fragment),ot=i(),c(ve.$$.fragment),rt=i(),$e=p("ul"),$e.innerHTML=Zt,mt=i(),c(Ie.$$.fragment),pt=i(),We=p("p"),this.h()},l(e){const n=Rt("svelte-u9bgzb",document.head);a=d(n,"META",{name:!0,content:!0}),n.forEach(s),w=o(e),m=d(e,"P",{}),Bt(m).forEach(s),u=o(e),J(y.$$.fragment,e),C=o(e),U=d(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1m50ob7"&&(U.innerHTML=D),E=o(e),g=d(e,"P",{"data-svelte-h":!0}),f(g)!=="svelte-11pyf03"&&(g.innerHTML=L),B=o(e),k=d(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1erhi5i"&&(k.innerHTML=W),S=o(e),F=d(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-ryfe7d"&&(F.innerHTML=X),q=o(e),_=d(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-gf36q7"&&(_.textContent=te),N=o(e),J(j.$$.fragment,e),P=o(e),V=d(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1r6p7j5"&&(V.innerHTML=R),Q=o(e),J(Z.$$.fragment,e),K=o(e),J(G.$$.fragment,e),v=o(e),Y=d(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-139tok6"&&(Y.innerHTML=A),$=o(e),J(H.$$.fragment,e),x=o(e),t=d(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-6mp6b1"&&(t.innerHTML=r),O=o(e),J(ne.$$.fragment,e),Ge=o(e),J(ae.$$.fragment,e),ke=o(e),J(se.$$.fragment,e),Fe=o(e),ie=d(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1myadau"&&(ie.textContent=ut),Ve=o(e),J(oe.$$.fragment,e),ze=o(e),re=d(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-ur5rgd"&&(re.textContent=yt),Ee=o(e),me=d(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-etone1"&&(me.innerHTML=ct),qe=o(e),J(pe.$$.fragment,e),Ne=o(e),J(de.$$.fragment,e),Qe=o(e),fe=d(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1epa174"&&(fe.innerHTML=Jt),xe=o(e),J(ue.$$.fragment,e),Ye=o(e),J(ye.$$.fragment,e),He=o(e),J(le.$$.fragment,e),Le=o(e),ce=d(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-7ob7j"&&(ce.textContent=Mt),Ae=o(e),J(Je.$$.fragment,e),De=o(e),Me=d(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1rdddh0"&&(Me.innerHTML=Tt),Se=o(e),J(Te.$$.fragment,e),Pe=o(e),J(be.$$.fragment,e),Ke=o(e),he=d(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-tm9uu4"&&(he.innerHTML=bt),Oe=o(e),J(we.$$.fragment,e),et=o(e),Ue=d(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1qoc2ct"&&(Ue.innerHTML=ht),tt=o(e),J(Ze.$$.fragment,e),st=o(e),ge=d(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-ep1hhf"&&(ge.textContent=wt),lt=o(e),J(Ce.$$.fragment,e),nt=o(e),J(_e.$$.fragment,e),at=o(e),je=d(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-lubruw"&&(je.textContent=Ut),it=o(e),J(Be.$$.fragment,e),ot=o(e),J(ve.$$.fragment,e),rt=o(e),$e=d(e,"UL",{"data-svelte-h":!0}),f($e)!=="svelte-vejlmz"&&($e.innerHTML=Zt),mt=o(e),J(Ie.$$.fragment,e),pt=o(e),We=d(e,"P",{}),Bt(We).forEach(s),this.h()},h(){ft(a,"name","hf:doc:metadata"),ft(a,"content",Lt)},m(e,n){Gt(document.head,a),l(e,w,n),l(e,m,n),l(e,u,n),M(y,e,n),l(e,C,n),l(e,U,n),l(e,E,n),l(e,g,n),l(e,B,n),l(e,k,n),l(e,S,n),l(e,F,n),l(e,q,n),l(e,_,n),l(e,N,n),M(j,e,n),l(e,P,n),l(e,V,n),l(e,Q,n),M(Z,e,n),l(e,K,n),M(G,e,n),l(e,v,n),l(e,Y,n),l(e,$,n),M(H,e,n),l(e,x,n),l(e,t,n),l(e,O,n),M(ne,e,n),l(e,Ge,n),M(ae,e,n),l(e,ke,n),M(se,e,n),l(e,Fe,n),l(e,ie,n),l(e,Ve,n),M(oe,e,n),l(e,ze,n),l(e,re,n),l(e,Ee,n),l(e,me,n),l(e,qe,n),M(pe,e,n),l(e,Ne,n),M(de,e,n),l(e,Qe,n),l(e,fe,n),l(e,xe,n),M(ue,e,n),l(e,Ye,n),M(ye,e,n),l(e,He,n),M(le,e,n),l(e,Le,n),l(e,ce,n),l(e,Ae,n),M(Je,e,n),l(e,De,n),l(e,Me,n),l(e,Se,n),M(Te,e,n),l(e,Pe,n),M(be,e,n),l(e,Ke,n),l(e,he,n),l(e,Oe,n),M(we,e,n),l(e,et,n),l(e,Ue,n),l(e,tt,n),M(Ze,e,n),l(e,st,n),l(e,ge,n),l(e,lt,n),M(Ce,e,n),l(e,nt,n),M(_e,e,n),l(e,at,n),l(e,je,n),l(e,it,n),M(Be,e,n),l(e,ot,n),M(ve,e,n),l(e,rt,n),l(e,$e,n),l(e,mt,n),M(Ie,e,n),l(e,pt,n),l(e,We,n),dt=!0},p(e,[n]){const gt={};n&2&&(gt.$$scope={dirty:n,ctx:e}),Z.$set(gt);const Ct={};n&2&&(Ct.$$scope={dirty:n,ctx:e}),G.$set(Ct);const _t={};n&2&&(_t.$$scope={dirty:n,ctx:e}),se.$set(_t);const jt={};n&2&&(jt.$$scope={dirty:n,ctx:e}),le.$set(jt)},i(e){dt||(T(y.$$.fragment,e),T(j.$$.fragment,e),T(Z.$$.fragment,e),T(G.$$.fragment,e),T(H.$$.fragment,e),T(ne.$$.fragment,e),T(ae.$$.fragment,e),T(se.$$.fragment,e),T(oe.$$.fragment,e),T(pe.$$.fragment,e),T(de.$$.fragment,e),T(ue.$$.fragment,e),T(ye.$$.fragment,e),T(le.$$.fragment,e),T(Je.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(we.$$.fragment,e),T(Ze.$$.fragment,e),T(Ce.$$.fragment,e),T(_e.$$.fragment,e),T(Be.$$.fragment,e),T(ve.$$.fragment,e),T(Ie.$$.fragment,e),dt=!0)},o(e){b(y.$$.fragment,e),b(j.$$.fragment,e),b(Z.$$.fragment,e),b(G.$$.fragment,e),b(H.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(oe.$$.fragment,e),b(pe.$$.fragment,e),b(de.$$.fragment,e),b(ue.$$.fragment,e),b(ye.$$.fragment,e),b(le.$$.fragment,e),b(Je.$$.fragment,e),b(Te.$$.fragment,e),b(be.$$.fragment,e),b(we.$$.fragment,e),b(Ze.$$.fragment,e),b(Ce.$$.fragment,e),b(_e.$$.fragment,e),b(Be.$$.fragment,e),b(ve.$$.fragment,e),b(Ie.$$.fragment,e),dt=!1},d(e){e&&(s(w),s(m),s(u),s(C),s(U),s(E),s(g),s(B),s(k),s(S),s(F),s(q),s(_),s(N),s(P),s(V),s(Q),s(K),s(v),s(Y),s($),s(x),s(t),s(O),s(Ge),s(ke),s(Fe),s(ie),s(Ve),s(ze),s(re),s(Ee),s(me),s(qe),s(Ne),s(Qe),s(fe),s(xe),s(Ye),s(He),s(Le),s(ce),s(Ae),s(De),s(Me),s(Se),s(Pe),s(Ke),s(he),s(Oe),s(et),s(Ue),s(tt),s(st),s(ge),s(lt),s(nt),s(at),s(je),s(it),s(ot),s(rt),s($e),s(mt),s(pt),s(We)),s(a),h(y,e),h(j,e),h(Z,e),h(G,e),h(H,e),h(ne,e),h(ae,e),h(se,e),h(oe,e),h(pe,e),h(de,e),h(ue,e),h(ye,e),h(le,e),h(Je,e),h(Te,e),h(be,e),h(we,e),h(Ze,e),h(Ce,e),h(_e,e),h(Be,e),h(ve,e),h(Ie,e)}}}const Lt='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit (LLM.int8() algorithm)","local":"8-bit-llmint8-algorithm","sections":[{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3}],"depth":2},{"title":"4-bit (QLoRA algorithm)","local":"4-bit-qlora-algorithm","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function At(I){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Wt{constructor(a){super(),Xt(this,a,At,Ht,$t,{})}}export{ts as component};
