import{s as Ue,o as ge,n as ke}from"../chunks/scheduler.182ea377.js";import{S as Ce,i as Ie,g as p,s as n,r as G,A as Ze,h as o,f as l,c as a,j as _e,u as x,x as c,k as Te,y as Be,a as s,v as Y,d as W,t as X,w as $}from"../chunks/index.abf12888.js";import{T as ve}from"../chunks/Tip.230e2334.js";import{C as ie}from"../chunks/CodeBlock.57fe6e13.js";import{H as je}from"../chunks/Heading.16916d63.js";function Ge(R){let i,d='🤗 Diffusers currently only supports <code>callback_on_step_end</code>, but feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you have a cool use-case and require a callback function with a different execution point!';return{c(){i=p("p"),i.innerHTML=d},l(r){i=o(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1wsblrf"&&(i.innerHTML=d)},m(r,v){s(r,i,v)},p:ke,d(r){r&&l(i)}}}function xe(R){let i,d,r,v,f,V,m,pe="The denoising loop of a pipeline can be modified with custom defined functions using the <code>callback_on_step_end</code> parameter. This can be really useful for <em>dynamically</em> adjusting certain pipeline attributes, or modifying tensor variables. The flexibility of callbacks opens up some interesting use-cases such as changing the prompt embeddings at each timestep, assigning different weights to the prompt embeddings, and editing the guidance scale.",H,h,oe="This guide will show you how to use the <code>callback_on_step_end</code> parameter to disable classifier-free guidance (CFG) after 40% of the inference steps to save compute with minimal cost to performance.",E,M,ce="The callback function should have the following arguments:",N,b,re="<li><code>pipe</code> (or the pipeline instance) provides access to useful properties such as <code>num_timestep</code> and <code>guidance_scale</code>. You can modify these properties by updating the underlying attributes. For this example, you’ll disable CFG by setting <code>pipe._guidance_scale=0.0</code>.</li> <li><code>step_index</code> and <code>timestep</code> tell you where you are in the denoising loop. Use <code>step_index</code> to turn off CFG after reaching 40% of <code>num_timestep</code>.</li> <li><code>callback_kwargs</code> is a dict that contains tensor variables you can modify during the denoising loop. It only includes variables specified in the <code>callback_on_step_end_tensor_inputs</code> argument, which is passed to the pipeline’s <code>__call__</code> method. Different pipelines may use different sets of variables, so please check a pipeline’s <code>_callback_tensor_inputs</code> attribute for the list of variables you can modify. Some common variables include <code>latents</code> and <code>prompt_embeds</code>. For this function, change the batch size of <code>prompt_embeds</code> after setting <code>guidance_scale=0.0</code> in order for it to work properly.</li>",z,w,ue="Your callback function should look something like this:",F,J,S,y,de="Now, you can pass the callback function to the <code>callback_on_step_end</code> parameter and the <code>prompt_embeds</code> to <code>callback_on_step_end_tensor_inputs</code>.",P,_,L,T,fe="The callback function is executed at the end of each denoising step, and modifies the pipeline attributes and tensor variables for the next denoising step.",Q,j,me="With callbacks, you can implement features such as dynamic CFG without having to modify the underlying code at all!",q,u,D,U,K,g,he="The following Pipelines support interrupting the diffusion process via callback",O,k,Me='<li><a href="../api/pipelines/stable_diffusion/overview.md">StableDiffusionPipeline</a></li> <li><a href="..api/pipelines/stable_diffusion/img2img.md">StableDiffusionImg2ImgPipeline</a></li> <li><a href="..api/pipelines/stable_diffusion/inpaint.md">StableDiffusionInpaintPipeline</a></li> <li><a href="../api/pipelines/stable_diffusion/stable_diffusion_xl.md">StableDiffusionXLPipeline</a></li> <li><a href="../api/pipelines/stable_diffusion/stable_diffusion_xl.md">StableDiffusionXLImg2ImgPipeline</a></li> <li><a href="../api/pipelines/stable_diffusion/stable_diffusion_xl.md">StableDiffusionXLInpaintPipeline</a></li>',ee,C,be="Interrupting the diffusion process is particularly useful when building UIs that work with Diffusers because it allows users to stop the generation process if they’re unhappy with the intermediate results. You can incorporate this into your pipeline with a callback.",te,I,we="This callback function should take the following arguments: <code>pipe</code>, <code>i</code>, <code>t</code>, and <code>callback_kwargs</code> (this must be returned). Set the pipeline’s <code>_interrupt</code> attribute to <code>True</code> to stop the diffusion process after a certain number of steps. You are also free to implement your own custom stopping logic inside the callback.",le,Z,Je="In this example, the diffusion process is stopped after 10 steps even though <code>num_inference_steps</code> is set to 50.",se,B,ne,A,ae;return f=new je({props:{title:"Pipeline callbacks",local:"pipeline-callbacks",headingTag:"h1"}}),J=new ie({props:{code:"ZGVmJTIwY2FsbGJhY2tfZHluYW1pY19jZmcocGlwZSUyQyUyMHN0ZXBfaW5kZXglMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBhZGp1c3QlMjB0aGUlMjBiYXRjaF9zaXplJTIwb2YlMjBwcm9tcHRfZW1iZWRzJTIwYWNjb3JkaW5nJTIwdG8lMjBndWlkYW5jZV9zY2FsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3RlcF9pbmRleCUyMCUzRCUzRCUyMGludChwaXBlLm51bV90aW1lc3RlcCUyMColMjAwLjQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNhbGxiYWNrX2t3YXJncyU1QiUyMnByb21wdF9lbWJlZHMlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTIwJTNEJTIwcHJvbXB0X2VtYmVkcy5jaHVuaygyKSU1Qi0xJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdXBkYXRlJTIwZ3VpZGFuY2Vfc2NhbGUlMjBhbmQlMjBwcm9tcHRfZW1iZWRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZS5fZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWxsYmFja19rd2FyZ3MlNUIlMjJwcm9tcHRfZW1iZWRzJTIyJTVEJTIwJTNEJTIwcHJvbXB0X2VtYmVkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNhbGxiYWNrX2t3YXJncw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">callback_dynamic_cfg</span>(<span class="hljs-params">pipe, step_index, timestep, callback_kwargs</span>):
        <span class="hljs-comment"># adjust the batch_size of prompt_embeds according to guidance_scale</span>
        <span class="hljs-keyword">if</span> step_index == <span class="hljs-built_in">int</span>(pipe.num_timestep * <span class="hljs-number">0.4</span>):
                prompt_embeds = callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>]
                prompt_embeds = prompt_embeds.chunk(<span class="hljs-number">2</span>)[-<span class="hljs-number">1</span>]

        <span class="hljs-comment"># update guidance_scale and prompt_embeds</span>
        pipe._guidance_scale = <span class="hljs-number">0.0</span>
        callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>] = prompt_embeds
        <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),_=new ie({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgxKSUwQW91dCUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RjYWxsYmFja19jdXN0b21fY2ZnJTJDJTIwY2FsbGJhY2tfb25fc3RlcF9lbmRfdGVuc29yX2lucHV0cyUzRCU1Qidwcm9tcHRfZW1iZWRzJyU1RCklMEElMEFvdXQuaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMm91dF9jdXN0b21fY2ZnLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
out = pipe(prompt, generator=generator, callback_on_step_end=callback_custom_cfg, callback_on_step_end_tensor_inputs=[<span class="hljs-string">&#x27;prompt_embeds&#x27;</span>])

out.images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;out_custom_cfg.png&quot;</span>)`,wrap:!1}}),u=new ve({props:{$$slots:{default:[Ge]},$$scope:{ctx:R}}}),U=new je({props:{title:"Using Callbacks to interrupt the Diffusion Process",local:"using-callbacks-to-interrupt-the-diffusion-process",headingTag:"h2"}}),B=new ie({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBbnVtX2luZmVyZW5jZV9zdGVwcyUyMCUzRCUyMDUwJTBBJTBBZGVmJTIwaW50ZXJydXB0X2NhbGxiYWNrKHBpcGUlMkMlMjBpJTJDJTIwdCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBzdG9wX2lkeCUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwc3RvcF9pZHglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlLl9pbnRlcnJ1cHQlMjAlM0QlMjBUcnVlJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FsbGJhY2tfa3dhcmdzJTBBJTBBcGlwZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kJTNEaW50ZXJydXB0X2NhbGxiYWNrJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
pipe.enable_model_cpu_offload()
num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">interrupt_callback</span>(<span class="hljs-params">pipe, i, t, callback_kwargs</span>):
    stop_idx = <span class="hljs-number">10</span>
    <span class="hljs-keyword">if</span> i == stop_idx:
        pipe._interrupt = <span class="hljs-literal">True</span>

    <span class="hljs-keyword">return</span> callback_kwargs

pipe(
    <span class="hljs-string">&quot;A photo of a cat&quot;</span>,
    num_inference_steps=num_inference_steps,
    callback_on_step_end=interrupt_callback,
)`,wrap:!1}}),{c(){i=p("meta"),d=n(),r=p("p"),v=n(),G(f.$$.fragment),V=n(),m=p("p"),m.innerHTML=pe,H=n(),h=p("p"),h.innerHTML=oe,E=n(),M=p("p"),M.textContent=ce,N=n(),b=p("ul"),b.innerHTML=re,z=n(),w=p("p"),w.textContent=ue,F=n(),G(J.$$.fragment),S=n(),y=p("p"),y.innerHTML=de,P=n(),G(_.$$.fragment),L=n(),T=p("p"),T.textContent=fe,Q=n(),j=p("p"),j.textContent=me,q=n(),G(u.$$.fragment),D=n(),G(U.$$.fragment),K=n(),g=p("p"),g.textContent=he,O=n(),k=p("ul"),k.innerHTML=Me,ee=n(),C=p("p"),C.textContent=be,te=n(),I=p("p"),I.innerHTML=we,le=n(),Z=p("p"),Z.innerHTML=Je,se=n(),G(B.$$.fragment),ne=n(),A=p("p"),this.h()},l(e){const t=Ze("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(l),d=a(e),r=o(e,"P",{}),_e(r).forEach(l),v=a(e),x(f.$$.fragment,e),V=a(e),m=o(e,"P",{"data-svelte-h":!0}),c(m)!=="svelte-z3ufgq"&&(m.innerHTML=pe),H=a(e),h=o(e,"P",{"data-svelte-h":!0}),c(h)!=="svelte-1e9w3c8"&&(h.innerHTML=oe),E=a(e),M=o(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-gxr3fz"&&(M.textContent=ce),N=a(e),b=o(e,"UL",{"data-svelte-h":!0}),c(b)!=="svelte-gz6h7k"&&(b.innerHTML=re),z=a(e),w=o(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1s2b9st"&&(w.textContent=ue),F=a(e),x(J.$$.fragment,e),S=a(e),y=o(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-y3yxaw"&&(y.innerHTML=de),P=a(e),x(_.$$.fragment,e),L=a(e),T=o(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1531nu7"&&(T.textContent=fe),Q=a(e),j=o(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-14y2as5"&&(j.textContent=me),q=a(e),x(u.$$.fragment,e),D=a(e),x(U.$$.fragment,e),K=a(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1v6aptz"&&(g.textContent=he),O=a(e),k=o(e,"UL",{"data-svelte-h":!0}),c(k)!=="svelte-uxt8z2"&&(k.innerHTML=Me),ee=a(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-hvg75e"&&(C.textContent=be),te=a(e),I=o(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1q7cqry"&&(I.innerHTML=we),le=a(e),Z=o(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-s21qgj"&&(Z.innerHTML=Je),se=a(e),x(B.$$.fragment,e),ne=a(e),A=o(e,"P",{}),_e(A).forEach(l),this.h()},h(){Te(i,"name","hf:doc:metadata"),Te(i,"content",Ye)},m(e,t){Be(document.head,i),s(e,d,t),s(e,r,t),s(e,v,t),Y(f,e,t),s(e,V,t),s(e,m,t),s(e,H,t),s(e,h,t),s(e,E,t),s(e,M,t),s(e,N,t),s(e,b,t),s(e,z,t),s(e,w,t),s(e,F,t),Y(J,e,t),s(e,S,t),s(e,y,t),s(e,P,t),Y(_,e,t),s(e,L,t),s(e,T,t),s(e,Q,t),s(e,j,t),s(e,q,t),Y(u,e,t),s(e,D,t),Y(U,e,t),s(e,K,t),s(e,g,t),s(e,O,t),s(e,k,t),s(e,ee,t),s(e,C,t),s(e,te,t),s(e,I,t),s(e,le,t),s(e,Z,t),s(e,se,t),Y(B,e,t),s(e,ne,t),s(e,A,t),ae=!0},p(e,[t]){const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),u.$set(ye)},i(e){ae||(W(f.$$.fragment,e),W(J.$$.fragment,e),W(_.$$.fragment,e),W(u.$$.fragment,e),W(U.$$.fragment,e),W(B.$$.fragment,e),ae=!0)},o(e){X(f.$$.fragment,e),X(J.$$.fragment,e),X(_.$$.fragment,e),X(u.$$.fragment,e),X(U.$$.fragment,e),X(B.$$.fragment,e),ae=!1},d(e){e&&(l(d),l(r),l(v),l(V),l(m),l(H),l(h),l(E),l(M),l(N),l(b),l(z),l(w),l(F),l(S),l(y),l(P),l(L),l(T),l(Q),l(j),l(q),l(D),l(K),l(g),l(O),l(k),l(ee),l(C),l(te),l(I),l(le),l(Z),l(se),l(ne),l(A)),l(i),$(f,e),$(J,e),$(_,e),$(u,e),$(U,e),$(B,e)}}}const Ye='{"title":"Pipeline callbacks","local":"pipeline-callbacks","sections":[{"title":"Using Callbacks to interrupt the Diffusion Process","local":"using-callbacks-to-interrupt-the-diffusion-process","sections":[],"depth":2}],"depth":1}';function We(R){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class He extends Ce{constructor(i){super(),Ie(this,i,We,xe,Ue,{})}}export{He as component};
