import{s as He,o as ze,n as Re}from"../chunks/scheduler.0219f8bd.js";import{S as We,i as Ye,g as p,s as a,r,A as _e,h as i,f as l,c as n,j as Se,u as c,x as u,k as ke,y as Ee,a as t,v as o,d as m,t as h,w as y}from"../chunks/index.f61edf3b.js";import{T as Qe}from"../chunks/Tip.5d1e3ef4.js";import{C as J}from"../chunks/CodeBlock.15473de1.js";import{H as C,E as Xe}from"../chunks/getInferenceSnippets.352fd352.js";function Ve(us){let M,U='Although you can always use the <a href="https://github.com/huggingface/transformers" rel="nofollow">Python library</a> for server-side inference, using Transformers.js means that you can write all of your code in JavaScript (instead of having to set up and communicate with a separate Python process).';return{c(){M=p("p"),M.innerHTML=U},l(w){M=i(w,"P",{"data-svelte-h":!0}),u(M)!=="svelte-k7e8xo"&&(M.innerHTML=U)},m(w,f){t(w,M,f)},p:Re,d(w){w&&l(M)}}}function Le(us){let M,U="Since we use lazy loading, the first request made to the server will also be responsible for loading the pipeline. If you would like to begin loading the pipeline as soon as the server starts running, you can add the following line of code after defining <code>MyClassificationPipeline</code>:",w,f,T;return f=new J({props:{code:"TXlDbGFzc2lmaWNhdGlvblBpcGVsaW5lLmdldEluc3RhbmNlKCklM0I=",highlighted:'<span class="hljs-title class_">MyClassificationPipeline</span>.<span class="hljs-title function_">getInstance</span>();',wrap:!1}}),{c(){M=p("p"),M.innerHTML=U,w=a(),r(f.$$.fragment)},l(d){M=i(d,"P",{"data-svelte-h":!0}),u(M)!=="svelte-1ym4f5o"&&(M.innerHTML=U),w=n(d),c(f.$$.fragment,d)},m(d,j){t(d,M,j),t(d,w,j),o(f,d,j),T=!0},p:Re,i(d){T||(m(f.$$.fragment,d),T=!0)},o(d){h(f.$$.fragment,d),T=!1},d(d){d&&(l(M),l(w)),y(f,d)}}}function Fe(us){let M,U,w,f,T,d,j,oe="Although Transformers.js was originally designed to be used in the browser, it’s also able to run inference on the server. In this tutorial, we will design a simple Node.js API that uses Transformers.js for sentiment analysis.",ws,b,me="We’ll also show you how to use the library in both CommonJS and ECMAScript modules, so you can choose the module system that works best for your project:",fs,I,he=`<li><a href="#ecmascript-modules-esm">ECMAScript modules (ESM)</a> - The official standard format
to package JavaScript code for reuse. It’s the default module system in modern
browsers, with modules imported using <code>import</code> and exported using <code>export</code>.
Fortunately, starting with version 13.2.0, Node.js has stable support of ES modules.</li> <li><a href="#commonjs">CommonJS</a> - The default module system in Node.js. In this system,
modules are imported using <code>require()</code> and exported using <code>module.exports</code>.</li>`,Js,g,Ts,v,ye="<strong>Useful links:</strong>",js,G,Me='<li>Source code (<a href="https://github.com/huggingface/transformers.js/tree/main/examples/node/esm/app.js" rel="nofollow">ESM</a> or <a href="https://github.com/huggingface/transformers.js/tree/main/examples/node/commonjs/app.js" rel="nofollow">CommonJS</a>)</li> <li><a href="https://huggingface.co/docs/transformers.js" rel="nofollow">Documentation</a></li>',Us,N,Cs,x,ue='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',gs,B,$s,Z,de='Let’s start by creating a new Node.js project and installing Transformers.js via <a href="https://www.npmjs.com/package/@huggingface/transformers" rel="nofollow">NPM</a>:',bs,S,Is,k,we='Next, create a new file called <code>app.js</code>, which will be the entry point for our application. Depending on whether you’re using <a href="#ecmascript-modules-esm">ECMAScript modules</a> or <a href="#commonjs">CommonJS</a>, you will need to do some things differently (see below).',vs,Q,fe='We’ll also create a helper class called <code>MyClassificationPipeline</code> control the loading of the pipeline. It uses the <a href="https://en.wikipedia.org/wiki/Singleton_pattern" rel="nofollow">singleton pattern</a> to lazily create a single instance of the pipeline when <code>getInstance</code> is first called, and uses this pipeline for all subsequent calls:',Gs,R,Ns,H,Je="To indicate that your project uses ECMAScript modules, you need to add <code>&quot;type&quot;: &quot;module&quot;</code> to your <code>package.json</code>:",xs,z,Bs,W,Te="Next, you will need to add the following imports to the top of <code>app.js</code>:",Zs,Y,Ss,_,je="Following that, let’s import Transformers.js and define the <code>MyClassificationPipeline</code> class.",ks,E,Qs,X,Rs,V,Ue="Start by adding the following imports to the top of <code>app.js</code>:",Hs,L,zs,F,Ce='Following that, let’s import Transformers.js and define the <code>MyClassificationPipeline</code> class. Since Transformers.js is an ESM module, we will need to dynamically import the library using the <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/import" rel="nofollow"><code>import()</code></a> function:',Ws,q,Ys,P,_s,A,ge='Next, let’s create a basic server with the built-in <a href="https://nodejs.org/api/http.html#http" rel="nofollow">HTTP</a> module. We will listen for requests made to the server (using the <code>/classify</code> endpoint), extract the <code>text</code> query parameter, and run this through the pipeline.',Es,D,Xs,$,Vs,K,$e="To start the server, run the following command:",Ls,O,Fs,ss,be='The server should be live at <a href="http://127.0.0.1:3000/" rel="nofollow">http://127.0.0.1:3000/</a>, which you can visit in your web browser. You should see the following message:',qs,es,Ps,ls,Ie='This is because we aren’t targeting the <code>/classify</code> endpoint with a valid <code>text</code> query parameter. Let’s try again, this time with a valid request. For example, you can visit <a href="http://127.0.0.1:3000/classify?text=I%20love%20Transformers.js" rel="nofollow">http://127.0.0.1:3000/classify?text=I%20love%20Transformers.js</a> and you should see:',As,ts,Ds,as,ve="Great! We’ve successfully created a basic HTTP server that uses Transformers.js to classify text.",Ks,ns,Os,ps,se,is,Ge="By default, the first time you run the application, it will download the model files and cache them on your file system (in <code>./node_modules/@huggingface/transformers/.cache/</code>). All subsequent requests will then use this model. You can change the location of the cache by setting <code>env.cacheDir</code>. For example, to cache the model in the <code>.cache</code> directory in the current working directory, you can add:",ee,rs,le,cs,te,os,Ne="If you want to use local model files, you can set <code>env.localModelPath</code> as follows:",ae,ms,ne,hs,xe="You can also disable loading of remote models by setting <code>env.allowRemoteModels</code> to <code>false</code>:",pe,ys,ie,Ms,re,ds,ce;return T=new C({props:{title:"Server-side Inference in Node.js",local:"server-side-inference-in-nodejs",headingTag:"h1"}}),g=new Qe({props:{$$slots:{default:[Ve]},$$scope:{ctx:us}}}),N=new C({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),B=new C({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),S=new J({props:{code:"bnBtJTIwaW5pdCUyMC15JTBBbnBtJTIwaSUyMCU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:`npm init -y
npm i @huggingface/transformers`,wrap:!1}}),R=new C({props:{title:"ECMAScript modules (ESM)",local:"ecmascript-modules-esm",headingTag:"h3"}}),z=new J({props:{code:"JTdCJTBBJTIwJTIwLi4uJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm1vZHVsZSUyMiUyQyUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  ...
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;module&quot;</span><span class="hljs-punctuation">,</span>
  ...
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Y=new J({props:{code:"aW1wb3J0JTIwaHR0cCUyMGZyb20lMjAnaHR0cCclM0IlMEFpbXBvcnQlMjBxdWVyeXN0cmluZyUyMGZyb20lMjAncXVlcnlzdHJpbmcnJTNCJTBBaW1wb3J0JTIwdXJsJTIwZnJvbSUyMCd1cmwnJTNC",highlighted:`<span class="hljs-keyword">import</span> http <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;http&#x27;</span>;
<span class="hljs-keyword">import</span> querystring <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;querystring&#x27;</span>;
<span class="hljs-keyword">import</span> url <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;url&#x27;</span>;`,wrap:!1}}),E=new J({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNsYXNzJTIwTXlDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTIwJTdCJTBBJTIwJTIwc3RhdGljJTIwdGFzayUyMCUzRCUyMCd0ZXh0LWNsYXNzaWZpY2F0aW9uJyUzQiUwQSUyMCUyMHN0YXRpYyUyMG1vZGVsJTIwJTNEJTIwJ1hlbm92YSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJyUzQiUwQSUyMCUyMHN0YXRpYyUyMGluc3RhbmNlJTIwJTNEJTIwbnVsbCUzQiUwQSUwQSUyMCUyMHN0YXRpYyUyMGFzeW5jJTIwZ2V0SW5zdGFuY2UocHJvZ3Jlc3NfY2FsbGJhY2slMjAlM0QlMjBudWxsKSUyMCU3QiUwQSUyMCUyMCUyMCUyMGlmJTIwKHRoaXMuaW5zdGFuY2UlMjAlM0QlM0QlM0QlMjBudWxsKSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyRiUyRiUyME5PVEUlM0ElMjBVbmNvbW1lbnQlMjB0aGlzJTIwdG8lMjBjaGFuZ2UlMjB0aGUlMjBjYWNoZSUyMGRpcmVjdG9yeSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyRiUyRiUyMGVudi5jYWNoZURpciUyMCUzRCUyMCcuJTJGLmNhY2hlJyUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHRoaXMuaW5zdGFuY2UlMjAlM0QlMjBwaXBlbGluZSh0aGlzLnRhc2slMkMlMjB0aGlzLm1vZGVsJTJDJTIwJTdCJTIwcHJvZ3Jlc3NfY2FsbGJhY2slMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGhpcy5pbnN0YW5jZSUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-keyword">import</span> { pipeline, env } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyClassificationPipeline</span> {
  <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
  <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
  <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

  <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
    <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
      <span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> Uncomment this to change the cache directory</span>
      <span class="hljs-comment">// env.cacheDir = &#x27;./.cache&#x27;;</span>

      <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
    }

    <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
  }
}`,wrap:!1}}),X=new C({props:{title:"CommonJS",local:"commonjs",headingTag:"h3"}}),L=new J({props:{code:"Y29uc3QlMjBodHRwJTIwJTNEJTIwcmVxdWlyZSgnaHR0cCcpJTNCJTBBY29uc3QlMjBxdWVyeXN0cmluZyUyMCUzRCUyMHJlcXVpcmUoJ3F1ZXJ5c3RyaW5nJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMHJlcXVpcmUoJ3VybCcpJTNC",highlighted:`<span class="hljs-keyword">const</span> http = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;http&#x27;</span>);
<span class="hljs-keyword">const</span> querystring = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;querystring&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;url&#x27;</span>);`,wrap:!1}}),q=new J({props:{code:"Y2xhc3MlMjBNeUNsYXNzaWZpY2F0aW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjBzdGF0aWMlMjB0YXNrJTIwJTNEJTIwJ3RleHQtY2xhc3NpZmljYXRpb24nJTNCJTBBJTIwJTIwc3RhdGljJTIwbW9kZWwlMjAlM0QlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTNCJTBBJTIwJTIwc3RhdGljJTIwaW5zdGFuY2UlMjAlM0QlMjBudWxsJTNCJTBBJTBBJTIwJTIwc3RhdGljJTIwYXN5bmMlMjBnZXRJbnN0YW5jZShwcm9ncmVzc19jYWxsYmFjayUyMCUzRCUyMG51bGwpJTIwJTdCJTBBJTIwJTIwJTIwJTIwaWYlMjAodGhpcy5pbnN0YW5jZSUyMCUzRCUzRCUzRCUyMG51bGwpJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwRHluYW1pY2FsbHklMjBpbXBvcnQlMjB0aGUlMjBUcmFuc2Zvcm1lcnMuanMlMjBsaWJyYXJ5JTBBJTIwJTIwJTIwJTIwJTIwJTIwbGV0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGltcG9ydCgnJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMnKSUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyRiUyRiUyME5PVEUlM0ElMjBVbmNvbW1lbnQlMjB0aGlzJTIwdG8lMjBjaGFuZ2UlMjB0aGUlMjBjYWNoZSUyMGRpcmVjdG9yeSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyRiUyRiUyMGVudi5jYWNoZURpciUyMCUzRCUyMCcuJTJGLmNhY2hlJyUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHRoaXMuaW5zdGFuY2UlMjAlM0QlMjBwaXBlbGluZSh0aGlzLnRhc2slMkMlMjB0aGlzLm1vZGVsJTJDJTIwJTdCJTIwcHJvZ3Jlc3NfY2FsbGJhY2slMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGhpcy5pbnN0YW5jZSUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyClassificationPipeline</span> {
  <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
  <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
  <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

  <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
    <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
      <span class="hljs-comment">// Dynamically import the Transformers.js library</span>
      <span class="hljs-keyword">let</span> { pipeline, env } = <span class="hljs-keyword">await</span> <span class="hljs-keyword">import</span>(<span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>);

      <span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> Uncomment this to change the cache directory</span>
      <span class="hljs-comment">// env.cacheDir = &#x27;./.cache&#x27;;</span>

      <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
    }

    <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
  }
}`,wrap:!1}}),P=new C({props:{title:"Creating a basic HTTP server",local:"creating-a-basic-http-server",headingTag:"h2"}}),D=new J({props:{code:"JTJGJTJGJTIwRGVmaW5lJTIwdGhlJTIwSFRUUCUyMHNlcnZlciUwQWNvbnN0JTIwc2VydmVyJTIwJTNEJTIwaHR0cC5jcmVhdGVTZXJ2ZXIoKSUzQiUwQWNvbnN0JTIwaG9zdG5hbWUlMjAlM0QlMjAnMTI3LjAuMC4xJyUzQiUwQWNvbnN0JTIwcG9ydCUyMCUzRCUyMDMwMDAlM0IlMEElMEElMkYlMkYlMjBMaXN0ZW4lMjBmb3IlMjByZXF1ZXN0cyUyMG1hZGUlMjB0byUyMHRoZSUyMHNlcnZlciUwQXNlcnZlci5vbigncmVxdWVzdCclMkMlMjBhc3luYyUyMChyZXElMkMlMjByZXMpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwUGFyc2UlMjB0aGUlMjByZXF1ZXN0JTIwVVJMJTBBJTIwJTIwY29uc3QlMjBwYXJzZWRVcmwlMjAlM0QlMjB1cmwucGFyc2UocmVxLnVybCklM0IlMEElMEElMjAlMjAlMkYlMkYlMjBFeHRyYWN0JTIwdGhlJTIwcXVlcnklMjBwYXJhbWV0ZXJzJTBBJTIwJTIwY29uc3QlMjAlN0IlMjB0ZXh0JTIwJTdEJTIwJTNEJTIwcXVlcnlzdHJpbmcucGFyc2UocGFyc2VkVXJsLnF1ZXJ5KSUzQiUwQSUwQSUyMCUyMCUyRiUyRiUyMFNldCUyMHRoZSUyMHJlc3BvbnNlJTIwaGVhZGVycyUwQSUyMCUyMHJlcy5zZXRIZWFkZXIoJ0NvbnRlbnQtVHlwZSclMkMlMjAnYXBwbGljYXRpb24lMkZqc29uJyklM0IlMEElMEElMjAlMjBsZXQlMjByZXNwb25zZSUzQiUwQSUyMCUyMGlmJTIwKHBhcnNlZFVybC5wYXRobmFtZSUyMCUzRCUzRCUzRCUyMCclMkZjbGFzc2lmeSclMjAlMjYlMjYlMjB0ZXh0KSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwTXlDbGFzc2lmaWNhdGlvblBpcGVsaW5lLmdldEluc3RhbmNlKCklM0IlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0KSUzQiUwQSUyMCUyMCUyMCUyMHJlcy5zdGF0dXNDb2RlJTIwJTNEJTIwMjAwJTNCJTBBJTIwJTIwJTdEJTIwZWxzZSUyMCU3QiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwJTdCJTIwJ2Vycm9yJyUzQSUyMCdCYWQlMjByZXF1ZXN0JyUyMCU3RCUwQSUyMCUyMCUyMCUyMHJlcy5zdGF0dXNDb2RlJTIwJTNEJTIwNDAwJTNCJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTJGJTJGJTIwU2VuZCUyMHRoZSUyMEpTT04lMjByZXNwb25zZSUwQSUyMCUyMHJlcy5lbmQoSlNPTi5zdHJpbmdpZnkocmVzcG9uc2UpKSUzQiUwQSU3RCklM0IlMEElMEFzZXJ2ZXIubGlzdGVuKHBvcnQlMkMlMjBob3N0bmFtZSUyQyUyMCgpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwY29uc29sZS5sb2coJTYwU2VydmVyJTIwcnVubmluZyUyMGF0JTIwaHR0cCUzQSUyRiUyRiUyNCU3Qmhvc3RuYW1lJTdEJTNBJTI0JTdCcG9ydCU3RCUyRiU2MCklM0IlMEElN0QpJTNCJTBB",highlighted:`<span class="hljs-comment">// Define the HTTP server</span>
<span class="hljs-keyword">const</span> server = http.<span class="hljs-title function_">createServer</span>();
<span class="hljs-keyword">const</span> hostname = <span class="hljs-string">&#x27;127.0.0.1&#x27;</span>;
<span class="hljs-keyword">const</span> port = <span class="hljs-number">3000</span>;

<span class="hljs-comment">// Listen for requests made to the server</span>
server.<span class="hljs-title function_">on</span>(<span class="hljs-string">&#x27;request&#x27;</span>, <span class="hljs-keyword">async</span> (req, res) =&gt; {
  <span class="hljs-comment">// Parse the request URL</span>
  <span class="hljs-keyword">const</span> parsedUrl = url.<span class="hljs-title function_">parse</span>(req.<span class="hljs-property">url</span>);

  <span class="hljs-comment">// Extract the query parameters</span>
  <span class="hljs-keyword">const</span> { text } = querystring.<span class="hljs-title function_">parse</span>(parsedUrl.<span class="hljs-property">query</span>);

  <span class="hljs-comment">// Set the response headers</span>
  res.<span class="hljs-title function_">setHeader</span>(<span class="hljs-string">&#x27;Content-Type&#x27;</span>, <span class="hljs-string">&#x27;application/json&#x27;</span>);

  <span class="hljs-keyword">let</span> response;
  <span class="hljs-keyword">if</span> (parsedUrl.<span class="hljs-property">pathname</span> === <span class="hljs-string">&#x27;/classify&#x27;</span> &amp;&amp; text) {
    <span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title class_">MyClassificationPipeline</span>.<span class="hljs-title function_">getInstance</span>();
    response = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text);
    res.<span class="hljs-property">statusCode</span> = <span class="hljs-number">200</span>;
  } <span class="hljs-keyword">else</span> {
    response = { <span class="hljs-string">&#x27;error&#x27;</span>: <span class="hljs-string">&#x27;Bad request&#x27;</span> }
    res.<span class="hljs-property">statusCode</span> = <span class="hljs-number">400</span>;
  }

  <span class="hljs-comment">// Send the JSON response</span>
  res.<span class="hljs-title function_">end</span>(<span class="hljs-title class_">JSON</span>.<span class="hljs-title function_">stringify</span>(response));
});

server.<span class="hljs-title function_">listen</span>(port, hostname, <span class="hljs-function">() =&gt;</span> {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Server running at http://<span class="hljs-subst">\${hostname}</span>:<span class="hljs-subst">\${port}</span>/\`</span>);
});
`,wrap:!1}}),$=new Qe({props:{$$slots:{default:[Le]},$$scope:{ctx:us}}}),O=new J({props:{code:"bm9kZSUyMGFwcC5qcw==",highlighted:"node app.js",wrap:!1}}),es=new J({props:{code:"JTdCJTIyZXJyb3IlMjIlM0ElMjJCYWQlMjByZXF1ZXN0JTIyJTdE",highlighted:'<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;error&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;Bad request&quot;</span><span class="hljs-punctuation">}</span>',wrap:!1}}),ts=new J({props:{code:"JTVCJTdCJTIybGFiZWwlMjIlM0ElMjJQT1NJVElWRSUyMiUyQyUyMnNjb3JlJTIyJTNBMC45OTk2NzIxMTQ4NDkwOTA2JTdEJTVE",highlighted:'<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;label&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;POSITIVE&quot;</span><span class="hljs-punctuation">,</span><span class="hljs-attr">&quot;score&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-number">0.9996721148490906</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>',wrap:!1}}),ns=new C({props:{title:"(Optional) Customization",local:"optional-customization",headingTag:"h2"}}),ps=new C({props:{title:"Model caching",local:"model-caching",headingTag:"h3"}}),rs=new J({props:{code:"ZW52LmNhY2hlRGlyJTIwJTNEJTIwJy4lMkYuY2FjaGUnJTNC",highlighted:'env.<span class="hljs-property">cacheDir</span> = <span class="hljs-string">&#x27;./.cache&#x27;</span>;',wrap:!1}}),cs=new C({props:{title:"Use local models",local:"use-local-models",headingTag:"h3"}}),ms=new J({props:{code:"JTJGJTJGJTIwU3BlY2lmeSUyMGElMjBjdXN0b20lMjBsb2NhdGlvbiUyMGZvciUyMG1vZGVscyUyMChkZWZhdWx0cyUyMHRvJTIwJyUyRm1vZGVscyUyRicpLiUwQWVudi5sb2NhbE1vZGVsUGF0aCUyMCUzRCUyMCclMkZwYXRoJTJGdG8lMkZtb2RlbHMlMkYnJTNC",highlighted:`<span class="hljs-comment">// Specify a custom location for models (defaults to &#x27;/models/&#x27;).</span>
env.<span class="hljs-property">localModelPath</span> = <span class="hljs-string">&#x27;/path/to/models/&#x27;</span>;`,wrap:!1}}),ys=new J({props:{code:"JTJGJTJGJTIwRGlzYWJsZSUyMHRoZSUyMGxvYWRpbmclMjBvZiUyMHJlbW90ZSUyMG1vZGVscyUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUzQSUwQWVudi5hbGxvd1JlbW90ZU1vZGVscyUyMCUzRCUyMGZhbHNlJTNC",highlighted:`<span class="hljs-comment">// Disable the loading of remote models from the Hugging Face Hub:</span>
env.<span class="hljs-property">allowRemoteModels</span> = <span class="hljs-literal">false</span>;`,wrap:!1}}),Ms=new Xe({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/tutorials/node.md"}}),{c(){M=p("meta"),U=a(),w=p("p"),f=a(),r(T.$$.fragment),d=a(),j=p("p"),j.textContent=oe,ws=a(),b=p("p"),b.textContent=me,fs=a(),I=p("ul"),I.innerHTML=he,Js=a(),r(g.$$.fragment),Ts=a(),v=p("p"),v.innerHTML=ye,js=a(),G=p("ul"),G.innerHTML=Me,Us=a(),r(N.$$.fragment),Cs=a(),x=p("ul"),x.innerHTML=ue,gs=a(),r(B.$$.fragment),$s=a(),Z=p("p"),Z.innerHTML=de,bs=a(),r(S.$$.fragment),Is=a(),k=p("p"),k.innerHTML=we,vs=a(),Q=p("p"),Q.innerHTML=fe,Gs=a(),r(R.$$.fragment),Ns=a(),H=p("p"),H.innerHTML=Je,xs=a(),r(z.$$.fragment),Bs=a(),W=p("p"),W.innerHTML=Te,Zs=a(),r(Y.$$.fragment),Ss=a(),_=p("p"),_.innerHTML=je,ks=a(),r(E.$$.fragment),Qs=a(),r(X.$$.fragment),Rs=a(),V=p("p"),V.innerHTML=Ue,Hs=a(),r(L.$$.fragment),zs=a(),F=p("p"),F.innerHTML=Ce,Ws=a(),r(q.$$.fragment),Ys=a(),r(P.$$.fragment),_s=a(),A=p("p"),A.innerHTML=ge,Es=a(),r(D.$$.fragment),Xs=a(),r($.$$.fragment),Vs=a(),K=p("p"),K.textContent=$e,Ls=a(),r(O.$$.fragment),Fs=a(),ss=p("p"),ss.innerHTML=be,qs=a(),r(es.$$.fragment),Ps=a(),ls=p("p"),ls.innerHTML=Ie,As=a(),r(ts.$$.fragment),Ds=a(),as=p("p"),as.textContent=ve,Ks=a(),r(ns.$$.fragment),Os=a(),r(ps.$$.fragment),se=a(),is=p("p"),is.innerHTML=Ge,ee=a(),r(rs.$$.fragment),le=a(),r(cs.$$.fragment),te=a(),os=p("p"),os.innerHTML=Ne,ae=a(),r(ms.$$.fragment),ne=a(),hs=p("p"),hs.innerHTML=xe,pe=a(),r(ys.$$.fragment),ie=a(),r(Ms.$$.fragment),re=a(),ds=p("p"),this.h()},l(s){const e=_e("svelte-u9bgzb",document.head);M=i(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(s),w=i(s,"P",{}),Se(w).forEach(l),f=n(s),c(T.$$.fragment,s),d=n(s),j=i(s,"P",{"data-svelte-h":!0}),u(j)!=="svelte-vfkn35"&&(j.textContent=oe),ws=n(s),b=i(s,"P",{"data-svelte-h":!0}),u(b)!=="svelte-a8f7x7"&&(b.textContent=me),fs=n(s),I=i(s,"UL",{"data-svelte-h":!0}),u(I)!=="svelte-9qlumf"&&(I.innerHTML=he),Js=n(s),c(g.$$.fragment,s),Ts=n(s),v=i(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1kriz5m"&&(v.innerHTML=ye),js=n(s),G=i(s,"UL",{"data-svelte-h":!0}),u(G)!=="svelte-v7exsi"&&(G.innerHTML=Me),Us=n(s),c(N.$$.fragment,s),Cs=n(s),x=i(s,"UL",{"data-svelte-h":!0}),u(x)!=="svelte-1qy4daj"&&(x.innerHTML=ue),gs=n(s),c(B.$$.fragment,s),$s=n(s),Z=i(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1xetp1f"&&(Z.innerHTML=de),bs=n(s),c(S.$$.fragment,s),Is=n(s),k=i(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-7flmsa"&&(k.innerHTML=we),vs=n(s),Q=i(s,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1dmzt6g"&&(Q.innerHTML=fe),Gs=n(s),c(R.$$.fragment,s),Ns=n(s),H=i(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-nul6wy"&&(H.innerHTML=Je),xs=n(s),c(z.$$.fragment,s),Bs=n(s),W=i(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-44hxyv"&&(W.innerHTML=Te),Zs=n(s),c(Y.$$.fragment,s),Ss=n(s),_=i(s,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1va2gp1"&&(_.innerHTML=je),ks=n(s),c(E.$$.fragment,s),Qs=n(s),c(X.$$.fragment,s),Rs=n(s),V=i(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1nm1y09"&&(V.innerHTML=Ue),Hs=n(s),c(L.$$.fragment,s),zs=n(s),F=i(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1qn48sh"&&(F.innerHTML=Ce),Ws=n(s),c(q.$$.fragment,s),Ys=n(s),c(P.$$.fragment,s),_s=n(s),A=i(s,"P",{"data-svelte-h":!0}),u(A)!=="svelte-aklufa"&&(A.innerHTML=ge),Es=n(s),c(D.$$.fragment,s),Xs=n(s),c($.$$.fragment,s),Vs=n(s),K=i(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1orujzn"&&(K.textContent=$e),Ls=n(s),c(O.$$.fragment,s),Fs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-52uecr"&&(ss.innerHTML=be),qs=n(s),c(es.$$.fragment,s),Ps=n(s),ls=i(s,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-tmlcgt"&&(ls.innerHTML=Ie),As=n(s),c(ts.$$.fragment,s),Ds=n(s),as=i(s,"P",{"data-svelte-h":!0}),u(as)!=="svelte-xomwwl"&&(as.textContent=ve),Ks=n(s),c(ns.$$.fragment,s),Os=n(s),c(ps.$$.fragment,s),se=n(s),is=i(s,"P",{"data-svelte-h":!0}),u(is)!=="svelte-1rlke8u"&&(is.innerHTML=Ge),ee=n(s),c(rs.$$.fragment,s),le=n(s),c(cs.$$.fragment,s),te=n(s),os=i(s,"P",{"data-svelte-h":!0}),u(os)!=="svelte-tw138n"&&(os.innerHTML=Ne),ae=n(s),c(ms.$$.fragment,s),ne=n(s),hs=i(s,"P",{"data-svelte-h":!0}),u(hs)!=="svelte-1tbr80q"&&(hs.innerHTML=xe),pe=n(s),c(ys.$$.fragment,s),ie=n(s),c(Ms.$$.fragment,s),re=n(s),ds=i(s,"P",{}),Se(ds).forEach(l),this.h()},h(){ke(M,"name","hf:doc:metadata"),ke(M,"content",qe)},m(s,e){Ee(document.head,M),t(s,U,e),t(s,w,e),t(s,f,e),o(T,s,e),t(s,d,e),t(s,j,e),t(s,ws,e),t(s,b,e),t(s,fs,e),t(s,I,e),t(s,Js,e),o(g,s,e),t(s,Ts,e),t(s,v,e),t(s,js,e),t(s,G,e),t(s,Us,e),o(N,s,e),t(s,Cs,e),t(s,x,e),t(s,gs,e),o(B,s,e),t(s,$s,e),t(s,Z,e),t(s,bs,e),o(S,s,e),t(s,Is,e),t(s,k,e),t(s,vs,e),t(s,Q,e),t(s,Gs,e),o(R,s,e),t(s,Ns,e),t(s,H,e),t(s,xs,e),o(z,s,e),t(s,Bs,e),t(s,W,e),t(s,Zs,e),o(Y,s,e),t(s,Ss,e),t(s,_,e),t(s,ks,e),o(E,s,e),t(s,Qs,e),o(X,s,e),t(s,Rs,e),t(s,V,e),t(s,Hs,e),o(L,s,e),t(s,zs,e),t(s,F,e),t(s,Ws,e),o(q,s,e),t(s,Ys,e),o(P,s,e),t(s,_s,e),t(s,A,e),t(s,Es,e),o(D,s,e),t(s,Xs,e),o($,s,e),t(s,Vs,e),t(s,K,e),t(s,Ls,e),o(O,s,e),t(s,Fs,e),t(s,ss,e),t(s,qs,e),o(es,s,e),t(s,Ps,e),t(s,ls,e),t(s,As,e),o(ts,s,e),t(s,Ds,e),t(s,as,e),t(s,Ks,e),o(ns,s,e),t(s,Os,e),o(ps,s,e),t(s,se,e),t(s,is,e),t(s,ee,e),o(rs,s,e),t(s,le,e),o(cs,s,e),t(s,te,e),t(s,os,e),t(s,ae,e),o(ms,s,e),t(s,ne,e),t(s,hs,e),t(s,pe,e),o(ys,s,e),t(s,ie,e),o(Ms,s,e),t(s,re,e),t(s,ds,e),ce=!0},p(s,[e]){const Be={};e&2&&(Be.$$scope={dirty:e,ctx:s}),g.$set(Be);const Ze={};e&2&&(Ze.$$scope={dirty:e,ctx:s}),$.$set(Ze)},i(s){ce||(m(T.$$.fragment,s),m(g.$$.fragment,s),m(N.$$.fragment,s),m(B.$$.fragment,s),m(S.$$.fragment,s),m(R.$$.fragment,s),m(z.$$.fragment,s),m(Y.$$.fragment,s),m(E.$$.fragment,s),m(X.$$.fragment,s),m(L.$$.fragment,s),m(q.$$.fragment,s),m(P.$$.fragment,s),m(D.$$.fragment,s),m($.$$.fragment,s),m(O.$$.fragment,s),m(es.$$.fragment,s),m(ts.$$.fragment,s),m(ns.$$.fragment,s),m(ps.$$.fragment,s),m(rs.$$.fragment,s),m(cs.$$.fragment,s),m(ms.$$.fragment,s),m(ys.$$.fragment,s),m(Ms.$$.fragment,s),ce=!0)},o(s){h(T.$$.fragment,s),h(g.$$.fragment,s),h(N.$$.fragment,s),h(B.$$.fragment,s),h(S.$$.fragment,s),h(R.$$.fragment,s),h(z.$$.fragment,s),h(Y.$$.fragment,s),h(E.$$.fragment,s),h(X.$$.fragment,s),h(L.$$.fragment,s),h(q.$$.fragment,s),h(P.$$.fragment,s),h(D.$$.fragment,s),h($.$$.fragment,s),h(O.$$.fragment,s),h(es.$$.fragment,s),h(ts.$$.fragment,s),h(ns.$$.fragment,s),h(ps.$$.fragment,s),h(rs.$$.fragment,s),h(cs.$$.fragment,s),h(ms.$$.fragment,s),h(ys.$$.fragment,s),h(Ms.$$.fragment,s),ce=!1},d(s){s&&(l(U),l(w),l(f),l(d),l(j),l(ws),l(b),l(fs),l(I),l(Js),l(Ts),l(v),l(js),l(G),l(Us),l(Cs),l(x),l(gs),l($s),l(Z),l(bs),l(Is),l(k),l(vs),l(Q),l(Gs),l(Ns),l(H),l(xs),l(Bs),l(W),l(Zs),l(Ss),l(_),l(ks),l(Qs),l(Rs),l(V),l(Hs),l(zs),l(F),l(Ws),l(Ys),l(_s),l(A),l(Es),l(Xs),l(Vs),l(K),l(Ls),l(Fs),l(ss),l(qs),l(Ps),l(ls),l(As),l(Ds),l(as),l(Ks),l(Os),l(se),l(is),l(ee),l(le),l(te),l(os),l(ae),l(ne),l(hs),l(pe),l(ie),l(re),l(ds)),l(M),y(T,s),y(g,s),y(N,s),y(B,s),y(S,s),y(R,s),y(z,s),y(Y,s),y(E,s),y(X,s),y(L,s),y(q,s),y(P,s),y(D,s),y($,s),y(O,s),y(es,s),y(ts,s),y(ns,s),y(ps,s),y(rs,s),y(cs,s),y(ms,s),y(ys,s),y(Ms,s)}}}const qe='{"title":"Server-side Inference in Node.js","local":"server-side-inference-in-nodejs","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Getting started","local":"getting-started","sections":[{"title":"ECMAScript modules (ESM)","local":"ecmascript-modules-esm","sections":[],"depth":3},{"title":"CommonJS","local":"commonjs","sections":[],"depth":3}],"depth":2},{"title":"Creating a basic HTTP server","local":"creating-a-basic-http-server","sections":[],"depth":2},{"title":"(Optional) Customization","local":"optional-customization","sections":[{"title":"Model caching","local":"model-caching","sections":[],"depth":3},{"title":"Use local models","local":"use-local-models","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pe(us){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends We{constructor(M){super(),Ye(this,M,Pe,Fe,He,{})}}export{el as component};
