import{s as ns,o as is,n as ls}from"../chunks/scheduler.0219f8bd.js";import{S as os,i as rs,g as i,s as l,r as p,A as ps,h as o,f as s,c as n,j as ts,u as c,x as r,k as ss,y as cs,a,v as d,d as h,t as m,w as f}from"../chunks/index.f61edf3b.js";import{T as as}from"../chunks/Tip.5d1e3ef4.js";import{C as w}from"../chunks/CodeBlock.15473de1.js";import{H as M,E as ds}from"../chunks/getInferenceSnippets.352fd352.js";function hs(be){let g,y='For the full list of available tasks/pipelines, check out <a href="#available-tasks">this table</a>.';return{c(){g=i("p"),g.innerHTML=y},l(u){g=o(u,"P",{"data-svelte-h":!0}),r(g)!=="svelte-gomgj3"&&(g.innerHTML=y)},m(u,j){a(u,g,j)},p:ls,d(u){u&&s(g)}}}function ms(be){let g,y='By default, models will be downloaded from the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> and stored in <a href="https://developer.mozilla.org/en-US/docs/Web/API/Cache" rel="nofollow">browser cache</a>, but there are ways to specify custom models and cache locations. For more information see <a href="./custom_usage">here</a>.';return{c(){g=i("p"),g.innerHTML=y},l(u){g=o(u,"P",{"data-svelte-h":!0}),r(g)!=="svelte-197t2db"&&(g.innerHTML=y)},m(u,j){a(u,g,j)},p:ls,d(u){u&&s(g)}}}function fs(be){let g,y,u,j,J,Ue,U,xt='Just like the <a href="https://github.com/huggingface/transformers" rel="nofollow">transformers Python library</a>, Transformers.js provides users with a simple way to leverage the power of transformers. The <code>pipeline()</code> function is the easiest and fastest way to use a pretrained model for inference.',ke,T,xe,k,$e,x,$t="Start by creating an instance of <code>pipeline()</code> and specifying a task you want to use it for. For example, to create a sentiment analysis pipeline, you can do:",Ie,$,ve,I,It="When running for the first time, the <code>pipeline</code> will download and cache the default pretrained model associated with the task. This can take a while, but subsequent calls will be much faster.",Ge,b,Ce,v,vt="You can now use the classifier on your target text by calling it as a function:",Be,G,Ze,C,Gt="If you have multiple inputs, you can pass them as an array:",Qe,B,_e,Z,Ct="You can also specify a different model to use for the pipeline by passing it as the second argument to the <code>pipeline()</code> function. For example, to use a different model for sentiment analysis (like one trained to predict sentiment of a review as a number of stars between 1 and 5), you can do:",We,Q,He,_,Bt='Transformers.js supports loading any model hosted on the Hugging Face Hub, provided it has ONNX weights (located in a subfolder called <code>onnx</code>). For more information on how to convert your PyTorch, TensorFlow, or JAX model to ONNX, see the <a href="./custom_usage#convert-your-models-to-onnx">conversion section</a>.',Se,W,Zt="The <code>pipeline()</code> function is a great way to quickly use a pretrained model for inference, as it takes care of all the preprocessing and postprocessing for you. For example, if you want to perform Automatic Speech Recognition (ASR) using OpenAI’s Whisper model, you can do:",Xe,H,Ne,S,Ye,X,Re,N,Qt=`We offer a variety of options to control how models are loaded from the Hugging Face Hub (or locally).
By default, when running in-browser, a <em>quantized</em> version of the model is used, which is smaller and faster,
but usually less accurate. To override this behaviour (i.e., use the unquantized model), you can use a custom
<code>PretrainedOptions</code> object as the third parameter to the <code>pipeline</code> function:`,Ae,Y,Ee,R,_t='Check out the section on <a href="./guides/dtypes">quantization</a> to learn more.',Fe,A,Wt=`You can also specify which revision of the model to use, by passing a <code>revision</code> parameter.
Since the Hugging Face Hub uses a git-based versioning system, you can use any valid git revision specifier (e.g., branch name or commit hash).`,Ve,E,ze,F,Ht='For the full list of options, check out the <a href="./api/utils/hub#module_utils/hub..PretrainedOptions">PretrainedOptions</a> documentation.',Le,V,Pe,z,St="Many pipelines have additional options that you can specify. For example, when using a model that does multilingual translation, you can specify the source and target languages like this:",De,L,qe,P,Xt='When using models that support auto-regressive generation, you can specify generation parameters like the number of new tokens, sampling methods, temperature, repetition penalty, and much more. For a full list of available parameters, see to the <a href="./api/utils/generation#module_utils/generation.GenerationConfig">GenerationConfig</a> class.',Oe,D,Nt="For example, to generate a poem using <code>LaMini-Flan-T5-783M</code>, you can do:",Ke,q,et,O,Yt="Logging <code>result[0].generated_text</code> to the console gives:",tt,K,st,ee,at,te,Rt="Some pipelines such as <code>text-generation</code> or <code>automatic-speech-recognition</code> support streaming output. This is achieved using the <code>TextStreamer</code> class. For example, when using a chat model like <code>Qwen2.5-Coder-0.5B-Instruct</code>, you can specify a callback function that will be called with each generated token text (if unset, new tokens will be printed to the console).",lt,se,nt,ae,At="Logging <code>result[0].generated_text</code> to the console gives:",it,le,Et=`<summary>Click to view the console output</summary> <pre>Here&#39;s a simple implementation of the quick sort algorithm in Python:
\`\`\`python
def quick_sort(arr):
    if len(arr) &lt;= 1:
        return arr
    pivot = arr[len(arr) // 2]
    left = [x for x in arr if x &lt; pivot]
    middle = [x for x in arr if x == pivot]
    right = [x for x in arr if x &gt; pivot]
    return quick_sort(left) + middle + quick_sort(right)
# Example usage:
arr = [3, 6, 8, 10, 1, 2]
sorted_arr = quick_sort(arr)
print(sorted_arr)
\`\`\`
### Explanation:
- **Base Case**: If the array has less than or equal to one element (i.e., \`len(arr)\` is less than or equal to \`1\`), it is already sorted and can be returned as is.
- **Pivot Selection**: The pivot is chosen as the middle element of the array.
- **Partitioning**: The array is partitioned into three parts: elements less than the pivot (\`left\`), elements equal to the pivot (\`middle\`), and elements greater than the pivot (\`right\`). These partitions are then recursively sorted.
- **Recursive Sorting**: The subarrays are sorted recursively using \`quick_sort\`.
This approach ensures that each recursive call reduces the problem size by half until it reaches a base case.
</pre>`,ot,ne,Ft="This streaming feature allows you to process the output as it is generated, rather than waiting for the entire output to be generated before processing it.",rt,ie,Vt=`For more information on the available options for each pipeline, refer to the <a href="./api/pipelines">API Reference</a>.
If you would like more control over the inference process, you can use the <a href="./api/models"><code>AutoModel</code></a>, <a href="./api/tokenizers"><code>AutoTokenizer</code></a>, or <a href="./api/processors"><code>AutoProcessor</code></a> classes instead.`,pt,oe,ct,re,dt,pe,ht,ce,zt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill-Mask</a></td> <td><code>fill-mask</code></td> <td>Masking some of the words in a sentence and predicting which words should replace those masks.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FillMaskPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=fill-mask&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td><code>question-answering</code></td> <td>Retrieve the answer to a question from a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.QuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td><code>sentence-similarity</code></td> <td>Determining how similar two texts are.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=sentence-similarity&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td><code>summarization</code></td> <td>Producing a shorter version of a document while preserving its important information.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.SummarizationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=summarization&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td><code>table-question-answering</code></td> <td>Answering a question about information from a given table.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td><code>text-classification</code> or <code>sentiment-analysis</code></td> <td>Assigning a label or class to a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#completion-generation-models" rel="nofollow">Text Generation</a></td> <td><code>text-generation</code></td> <td>Producing new text by predicting the next word in a sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#text-to-text-generation-models" rel="nofollow">Text-to-text Generation</a></td> <td><code>text2text-generation</code></td> <td>Converting one text sequence into another text sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.Text2TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text2text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td><code>token-classification</code> or <code>ner</code></td> <td>Assigning a label to each token in a text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TokenClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=token-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td><code>translation</code></td> <td>Converting text from one language to another.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TranslationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=translation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero-Shot Classification</a></td> <td><code>zero-shot-classification</code></td> <td>Classifying text into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td><code>feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original dataset.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',mt,de,ft,he,Lt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/image-segmentation#background-removal" rel="nofollow">Background Removal</a></td> <td><code>background-removal</code></td> <td>Isolating the main subject of an image by removing or making the background transparent.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.BackgroundRemovalPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=background-removal&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/depth-estimation" rel="nofollow">Depth Estimation</a></td> <td><code>depth-estimation</code></td> <td>Predicting the depth of objects present in an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DepthEstimationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td><code>image-classification</code></td> <td>Assigning a label or class to an entire image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td><code>image-segmentation</code></td> <td>Divides an image into segments where each pixel is mapped to an object. This task has multiple variants such as instance segmentation, panoptic segmentation and semantic segmentation.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageSegmentationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-segmentation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td><code>image-to-image</code></td> <td>Transforming a source image to match the characteristics of a target image or a target image domain.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToImagePipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-image&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/mask-generation" rel="nofollow">Mask Generation</a></td> <td><code>mask-generation</code></td> <td>Generate masks for the objects in an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td><code>object-detection</code></td> <td>Identify objects of certain defined classes within an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/video-classification" rel="nofollow">Video Classification</a></td> <td>n/a</td> <td>Assigning a label or class to an entire video.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/unconditional-image-generation" rel="nofollow">Unconditional Image Generation</a></td> <td>n/a</td> <td>Generating images with no condition in any context (like a prompt text or another image).</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/image-feature-extraction" rel="nofollow">Image Feature Extraction</a></td> <td><code>image-feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageFeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',gt,me,ut,fe,Pt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td><code>audio-classification</code></td> <td>Assigning a label or class to a given audio.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>n/a</td> <td>Generating audio from an input audio source.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td><code>automatic-speech-recognition</code></td> <td>Transcribing a given audio into text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AutomaticSpeechRecognitionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td><code>text-to-speech</code> or <code>text-to-audio</code></td> <td>Generating natural-sounding speech given text input.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextToAudioPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-to-audio&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',Mt,ge,wt,ue,Dt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>n/a</td> <td>Classifying a target category (a group) based on set of attributes.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>n/a</td> <td>Predicting a numerical value given a set of attributes.</td> <td>❌</td></tr></tbody>',yt,Me,jt,we,qt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Document Question Answering</a></td> <td><code>document-question-answering</code></td> <td>Answering questions on document images.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DocumentQuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=document-question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td><code>image-to-text</code></td> <td>Output text from a given image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToTextPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-text&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td><code>text-to-image</code></td> <td>Generates images from input text.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td><code>visual-question-answering</code></td> <td>Answering open-ended questions based on an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/learn/audio-course/chapter4/classification_models#zero-shot-audio-classification" rel="nofollow">Zero-Shot Audio Classification</a></td> <td><code>zero-shot-audio-classification</code></td> <td>Classifying audios into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotAudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=zero-shot-audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot Image Classification</a></td> <td><code>zero-shot-image-classification</code></td> <td>Classifying images into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-object-detection" rel="nofollow">Zero-Shot Object Detection</a></td> <td><code>zero-shot-object-detection</code></td> <td>Identify objects of classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=zero-shot-object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',Tt,ye,bt,je,Ot='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/reinforcement-learning" rel="nofollow">Reinforcement Learning</a></td> <td>n/a</td> <td>Learning from actions by interacting with an environment through trial and error and receiving rewards (negative or positive) as feedback.</td> <td>✅</td></tr></tbody>',Jt,Te,Ut,Je,kt;return J=new M({props:{title:"The pipeline API",local:"the-pipeline-api",headingTag:"h1"}}),T=new as({props:{$$slots:{default:[hs]},$$scope:{ctx:be}}}),k=new M({props:{title:"The basics",local:"the-basics",headingTag:"h2"}}),$=new w({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcycpJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);`,wrap:!1}}),b=new as({props:{$$slots:{default:[ms]},$$scope:{ctx:be}}}),G=new w({props:{code:"Y29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4JTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}]</span>`,wrap:!1}}),B=new w({props:{code:"Y29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJTVCJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzISclMkMlMjAnSSUyMGhhdGUlMjB0cmFuc2Zvcm1lcnMhJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ1BPU0lUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTglN0QlMkMlMjAlN0InbGFiZWwnJTNBJTIwJ05FR0FUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5ODIlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>([<span class="hljs-string">&#x27;I love transformers!&#x27;</span>, <span class="hljs-string">&#x27;I hate transformers!&#x27;</span>]);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}, {&#x27;label&#x27;: &#x27;NEGATIVE&#x27;, &#x27;score&#x27;: 0.9982}]</span>`,wrap:!1}}),Q=new w({props:{code:"Y29uc3QlMjByZXZpZXdlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHJldmlld2VyKCdUaGUlMjBTaGF3c2hhbmslMjBSZWRlbXB0aW9uJTIwaXMlMjBhJTIwdHJ1ZSUyMG1hc3RlcnBpZWNlJTIwb2YlMjBjaW5lbWEuJyklM0IlMEElMkYlMkYlMjAlNUIlN0JsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjgxNjc5Mjk2NDkzNTMwMjclN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> reviewer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">reviewer</span>(<span class="hljs-string">&#x27;The Shawshank Redemption is a true masterpiece of cinema.&#x27;</span>);
<span class="hljs-comment">// [{label: &#x27;5 stars&#x27;, score: 0.8167929649353027}]</span>`,wrap:!1}}),H=new w({props:{code:"JTJGJTJGJTIwQ3JlYXRlJTIwYSUyMHBpcGVsaW5lJTIwZm9yJTIwQXV0b21hdGljJTIwU3BlZWNoJTIwUmVjb2duaXRpb24lMEFjb25zdCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbC5lbicpJTNCJTBBJTBBJTJGJTJGJTIwVHJhbnNjcmliZSUyMGFuJTIwYXVkaW8lMjBmaWxlJTJDJTIwbG9hZGVkJTIwZnJvbSUyMGElMjBVUkwuJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyklM0IlMEElMkYlMkYlMjAlN0J0ZXh0JTNBJTIwJyUyMEklMjBoYXZlJTIwYSUyMGRyZWFtJTIwdGhhdCUyMG9uZSUyMGRheSUyMHRoaXMlMjBuYXRpb24lMjB3aWxsJTIwcmlzZSUyMHVwJTIwYW5kJTIwbGl2ZSUyMG91dCUyMHRoZSUyMHRydWUlMjBtZWFuaW5nJTIwb2YlMjBpdHMlMjBjcmVlZC4nJTdE",highlighted:`<span class="hljs-comment">// Create a pipeline for Automatic Speech Recognition</span>
<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small.en&#x27;</span>);

<span class="hljs-comment">// Transcribe an audio file, loaded from a URL.</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>);
<span class="hljs-comment">// {text: &#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;}</span>`,wrap:!1}}),S=new M({props:{title:"Pipeline options",local:"pipeline-options",headingTag:"h2"}}),X=new M({props:{title:"Loading",local:"loading",headingTag:"h3"}}),Y=new w({props:{code:"JTJGJTJGJTIwQ3JlYXRlJTIwYSUyMHBpcGVsaW5lJTIwZm9yJTIwZmVhdHVyZSUyMGV4dHJhY3Rpb24lMkMlMjB1c2luZyUyMHRoZSUyMGZ1bGwtcHJlY2lzaW9uJTIwbW9kZWwlMjAoZnAzMiklMEFjb25zdCUyMHBpcGUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmZWF0dXJlLWV4dHJhY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmFsbC1NaW5pTE0tTDYtdjInJTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0ElMjAlMjJmcDMyJTIyJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-comment">// Create a pipeline for feature extraction, using the full-precision model (fp32)</span>
<span class="hljs-keyword">const</span> pipe = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>, {
    <span class="hljs-attr">dtype</span>: <span class="hljs-string">&quot;fp32&quot;</span>,
});`,wrap:!1}}),E=new w({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItdGlueS5lbiclMkMlMjAlN0IlMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzQSUyMCdvdXRwdXRfYXR0ZW50aW9ucyclMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});`,wrap:!1}}),V=new M({props:{title:"Running",local:"running",headingTag:"h3"}}),L=new w({props:{code:"JTJGJTJGJTIwQ3JlYXRlJTIwYSUyMHBpcGVsaW5lJTIwZm9yJTIwdHJhbnNsYXRpb24lMEFjb25zdCUyMHRyYW5zbGF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0cmFuc2xhdGlvbiclMkMlMjAnWGVub3ZhJTJGbmxsYi0yMDAtZGlzdGlsbGVkLTYwME0nKSUzQiUwQSUwQSUyRiUyRiUyMFRyYW5zbGF0ZSUyMGZyb20lMjBFbmdsaXNoJTIwdG8lMjBHcmVlayUwQWNvbnN0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCdJJTIwbGlrZSUyMHRvJTIwd2FsayUyMG15JTIwZG9nLiclMkMlMjAlN0IlMEElMjAlMjAlMjAlMjBzcmNfbGFuZyUzQSUyMCdlbmdfTGF0biclMkMlMEElMjAlMjAlMjAlMjB0Z3RfbGFuZyUzQSUyMCdlbGxfR3JlayclMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTIwJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCclQ0UlOUMlQ0UlQkYlQ0YlODUlMjAlQ0UlQjElQ0YlODElQ0UlQUQlQ0YlODMlQ0UlQjUlQ0UlQjklMjAlQ0UlQkQlQ0UlQjElMjAlQ0YlODAlQ0UlQjUlQ0YlODElQ0YlODAlQ0UlQjElQ0YlODQlQ0UlQUMlQ0YlODklMjAlQ0YlODQlQ0UlQkYlMjAlQ0YlODMlQ0UlQkElQ0YlODUlQ0UlQkIlQ0UlQUYlMjAlQ0UlQkMlQ0UlQkYlQ0YlODUuJyUyMCU3RCUyMCU1RCUwQSUwQSUyRiUyRiUyMFRyYW5zbGF0ZSUyMGJhY2slMjB0byUyMEVuZ2xpc2glMEFjb25zdCUyMHJlc3VsdDIlMjAlM0QlMjBhd2FpdCUyMHRyYW5zbGF0b3IocmVzdWx0JTVCMCU1RC50cmFuc2xhdGlvbl90ZXh0JTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwc3JjX2xhbmclM0ElMjAnZWxsX0dyZWsnJTJDJTBBJTIwJTIwJTIwJTIwdGd0X2xhbmclM0ElMjAnZW5nX0xhdG4nJTBBJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUyMCU3QiUyMHRyYW5zbGF0aW9uX3RleHQlM0ElMjAnSSUyMGxpa2UlMjB0byUyMHdhbGslMjBteSUyMGRvZy4nJTIwJTdEJTIwJTVE",highlighted:`<span class="hljs-comment">// Create a pipeline for translation</span>
<span class="hljs-keyword">const</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);

<span class="hljs-comment">// Translate from English to Greek</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;I like to walk my dog.&#x27;</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;Μου αρέσει να περπατάω το σκυλί μου.&#x27; } ]</span>

<span class="hljs-comment">// Translate back to English</span>
<span class="hljs-keyword">const</span> result2 = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(result[<span class="hljs-number">0</span>].<span class="hljs-property">translation_text</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;I like to walk my dog.&#x27; } ]</span>`,wrap:!1}}),q=new w({props:{code:"JTJGJTJGJTIwQ3JlYXRlJTIwYSUyMHBpcGVsaW5lJTIwZm9yJTIwdGV4dDJ0ZXh0LWdlbmVyYXRpb24lMEFjb25zdCUyMHBvZXQlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0MnRleHQtZ2VuZXJhdGlvbiclMkMlMjAnWGVub3ZhJTJGTGFNaW5pLUZsYW4tVDUtNzgzTScpJTNCJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHBvZXQoJ1dyaXRlJTIwbWUlMjBhJTIwbG92ZSUyMHBvZW0lMjBhYm91dCUyMGNoZWVzZS4nJTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAyMDAlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuOSUyQyUwQSUyMCUyMCUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzQSUyMDIuMCUyQyUwQSUyMCUyMCUyMCUyMG5vX3JlcGVhdF9uZ3JhbV9zaXplJTNBJTIwMyUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-comment">// Create a pipeline for text2text-generation</span>
<span class="hljs-keyword">const</span> poet = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">poet</span>(<span class="hljs-string">&#x27;Write me a love poem about cheese.&#x27;</span>, {
    <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">200</span>,
    <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">2.0</span>,
    <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">3</span>,
});`,wrap:!1}}),K=new w({props:{code:"Q2hlZXNlJTJDJTIwb2glMjBjaGVlc2UhJTIwWW91J3JlJTIwdGhlJTIwcGVyZmVjdCUyMGNvbWZvcnQlMjBmb29kLiUwQVlvdXIlMjB0ZXh0dXJlJTIwc28lMjBzbW9vdGglMjBhbmQlMjBjcmVhbXklMjB5b3UlMjBjYW4lMjBuZXZlciUyMGdldCUyMG9sZC4lMEFXaXRoJTIwZXZlcnklMjBiaXRlJTIwaXQlMjBtZWx0cyUyMGluJTIweW91ciUyMG1vdXRoJTIwbGlrZSUyMGJ1dHRlcnklMjBkZWxpZ2h0cyUwQXRoYXQlMjBtYWtlJTIwbWUlMjBmZWVsJTIwcmlnaHQlMjBhdCUyMGhvbWUlMjB3aXRoJTIwdGhpcyUyMHN3ZWV0JTIwdHJlYXQlMjBvZiUyMG1pbmUuJTIwJTBBJTBBRnJvbSUyMGNsYXNzaWMlMjB0byUyMGJvbGQlMjBmbGF2b3IlMjBjb21iaW5hdGlvbnMlMkMlMEFJJTIwbG92ZSUyMGhvdyUyMHZlcnNhdGlsZSUyMHlvdSUyMGFyZSUyMGFzJTIwYW4lMjBpbmdyZWRpZW50JTIwdG9vJTNGJTBBQ2hlZGRhciUyMGlzJTIwbXklMjBnby10byUyMGZvciUyMGFueSUyMG9jY2FzaW9uJTIwb3IlMjBtb29kJTNCJTIwJTBBSXQlMjBhZGRzJTIwZGVwdGglMjBhbmQlMjByaWNobmVzcyUyMHdpdGhvdXQlMjBiZWluZyUyMG92ZXJwb3dlcmluZyUyMGl0cyUyMHRhc3RlJTIwYnVkcyUyMGFsb25l",highlighted:`Cheese, oh cheese! You&#x27;re <span class="hljs-keyword">the</span> perfect comfort food.
Your texture so smooth <span class="hljs-keyword">and</span> creamy you can never <span class="hljs-keyword">get</span> old.
With <span class="hljs-keyword">every</span> bite <span class="hljs-keyword">it</span> melts <span class="hljs-keyword">in</span> your mouth like buttery delights
<span class="hljs-keyword">that</span> make <span class="hljs-keyword">me</span> feel right <span class="hljs-keyword">at</span> home <span class="hljs-keyword">with</span> this sweet treat <span class="hljs-keyword">of</span> mine. 

From classic <span class="hljs-keyword">to</span> bold flavor combinations,
I love how versatile you are <span class="hljs-keyword">as</span> an ingredient too?
Cheddar <span class="hljs-keyword">is</span> <span class="hljs-keyword">my</span> go-<span class="hljs-keyword">to</span> <span class="hljs-keyword">for</span> any occasion <span class="hljs-keyword">or</span> mood; 
It adds depth <span class="hljs-keyword">and</span> richness <span class="hljs-keyword">without</span> being overpowering <span class="hljs-keyword">its</span> taste buds alone`,wrap:!1}}),ee=new M({props:{title:"Streaming",local:"streaming",headingTag:"h3"}}),se=new w({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBUZXh0U3RyZWFtZXIlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBhJTIwdGV4dCUyMGdlbmVyYXRpb24lMjBwaXBlbGluZSUwQWNvbnN0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSglMEElMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjJvbm54LWNvbW11bml0eSUyRlF3ZW4yLjUtQ29kZXItMC41Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCU3QiUyMGR0eXBlJTNBJTIwJTIycTQlMjIlMjAlN0QlMkMlMEEpJTNCJTBBJTBBJTJGJTJGJTIwRGVmaW5lJTIwdGhlJTIwbGlzdCUyMG9mJTIwbWVzc2FnZXMlMEFjb25zdCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjAlMjJXcml0ZSUyMGElMjBxdWljayUyMHNvcnQlMjBhbGdvcml0aG0uJTIyJTIwJTdEJTJDJTBBJTVEJTNCJTBBJTBBJTJGJTJGJTIwQ3JlYXRlJTIwdGV4dCUyMHN0cmVhbWVyJTBBY29uc3QlMjBzdHJlYW1lciUyMCUzRCUyMG5ldyUyMFRleHRTdHJlYW1lcihnZW5lcmF0b3IudG9rZW5pemVyJTJDJTIwJTdCJTBBJTIwJTIwc2tpcF9wcm9tcHQlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTJGJTJGJTIwT3B0aW9uYWxseSUyQyUyMGRvJTIwc29tZXRoaW5nJTIwd2l0aCUyMHRoZSUyMHRleHQlMjAoZS5nLiUyQyUyMHdyaXRlJTIwdG8lMjBhJTIwdGV4dGJveCklMEElMjAlMjAlMkYlMkYlMjBjYWxsYmFja19mdW5jdGlvbiUzQSUyMCh0ZXh0KSUyMCUzRCUzRSUyMCU3QiUyMCUyRiolMjBEbyUyMHNvbWV0aGluZyUyMHdpdGglMjB0ZXh0JTIwKiUyRiUyMCU3RCUyQyUwQSU3RCklMEElMEElMkYlMkYlMjBHZW5lcmF0ZSUyMGElMjByZXNwb25zZSUwQWNvbnN0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBnZW5lcmF0b3IobWVzc2FnZXMlMkMlMjAlN0IlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDUxMiUyQyUyMGRvX3NhbXBsZSUzQSUyMGZhbHNlJTJDJTIwc3RyZWFtZXIlMjAlN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline, <span class="hljs-title class_">TextStreamer</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create a text generation pipeline</span>
<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;text-generation&quot;</span>,
  <span class="hljs-string">&quot;onnx-community/Qwen2.5-Coder-0.5B-Instruct&quot;</span>,
  { <span class="hljs-attr">dtype</span>: <span class="hljs-string">&quot;q4&quot;</span> },
);

<span class="hljs-comment">// Define the list of messages</span>
<span class="hljs-keyword">const</span> messages = [
  { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
  { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>:  <span class="hljs-string">&quot;Write a quick sort algorithm.&quot;</span> },
];

<span class="hljs-comment">// Create text streamer</span>
<span class="hljs-keyword">const</span> streamer = <span class="hljs-keyword">new</span> <span class="hljs-title class_">TextStreamer</span>(generator.<span class="hljs-property">tokenizer</span>, {
  <span class="hljs-attr">skip_prompt</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-comment">// Optionally, do something with the text (e.g., write to a textbox)</span>
  <span class="hljs-comment">// callback_function: (text) =&gt; { /* Do something with text */ },</span>
})

<span class="hljs-comment">// Generate a response</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(messages, { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">512</span>, <span class="hljs-attr">do_sample</span>: <span class="hljs-literal">false</span>, streamer });`,wrap:!1}}),oe=new M({props:{title:"Available tasks",local:"available-tasks",headingTag:"h2"}}),re=new M({props:{title:"Tasks",local:"tasks",headingTag:"h3"}}),pe=new M({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h4"}}),de=new M({props:{title:"Vision",local:"vision",headingTag:"h4"}}),me=new M({props:{title:"Audio",local:"audio",headingTag:"h4"}}),ge=new M({props:{title:"Tabular",local:"tabular",headingTag:"h4"}}),Me=new M({props:{title:"Multimodal",local:"multimodal",headingTag:"h4"}}),ye=new M({props:{title:"Reinforcement Learning",local:"reinforcement-learning",headingTag:"h4"}}),Te=new ds({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/pipelines.md"}}),{c(){g=i("meta"),y=l(),u=i("p"),j=l(),p(J.$$.fragment),Ue=l(),U=i("p"),U.innerHTML=xt,ke=l(),p(T.$$.fragment),xe=l(),p(k.$$.fragment),$e=l(),x=i("p"),x.innerHTML=$t,Ie=l(),p($.$$.fragment),ve=l(),I=i("p"),I.innerHTML=It,Ge=l(),p(b.$$.fragment),Ce=l(),v=i("p"),v.textContent=vt,Be=l(),p(G.$$.fragment),Ze=l(),C=i("p"),C.textContent=Gt,Qe=l(),p(B.$$.fragment),_e=l(),Z=i("p"),Z.innerHTML=Ct,We=l(),p(Q.$$.fragment),He=l(),_=i("p"),_.innerHTML=Bt,Se=l(),W=i("p"),W.innerHTML=Zt,Xe=l(),p(H.$$.fragment),Ne=l(),p(S.$$.fragment),Ye=l(),p(X.$$.fragment),Re=l(),N=i("p"),N.innerHTML=Qt,Ae=l(),p(Y.$$.fragment),Ee=l(),R=i("p"),R.innerHTML=_t,Fe=l(),A=i("p"),A.innerHTML=Wt,Ve=l(),p(E.$$.fragment),ze=l(),F=i("p"),F.innerHTML=Ht,Le=l(),p(V.$$.fragment),Pe=l(),z=i("p"),z.textContent=St,De=l(),p(L.$$.fragment),qe=l(),P=i("p"),P.innerHTML=Xt,Oe=l(),D=i("p"),D.innerHTML=Nt,Ke=l(),p(q.$$.fragment),et=l(),O=i("p"),O.innerHTML=Yt,tt=l(),p(K.$$.fragment),st=l(),p(ee.$$.fragment),at=l(),te=i("p"),te.innerHTML=Rt,lt=l(),p(se.$$.fragment),nt=l(),ae=i("p"),ae.innerHTML=At,it=l(),le=i("details"),le.innerHTML=Et,ot=l(),ne=i("p"),ne.textContent=Ft,rt=l(),ie=i("p"),ie.innerHTML=Vt,pt=l(),p(oe.$$.fragment),ct=l(),p(re.$$.fragment),dt=l(),p(pe.$$.fragment),ht=l(),ce=i("table"),ce.innerHTML=zt,mt=l(),p(de.$$.fragment),ft=l(),he=i("table"),he.innerHTML=Lt,gt=l(),p(me.$$.fragment),ut=l(),fe=i("table"),fe.innerHTML=Pt,Mt=l(),p(ge.$$.fragment),wt=l(),ue=i("table"),ue.innerHTML=Dt,yt=l(),p(Me.$$.fragment),jt=l(),we=i("table"),we.innerHTML=qt,Tt=l(),p(ye.$$.fragment),bt=l(),je=i("table"),je.innerHTML=Ot,Jt=l(),p(Te.$$.fragment),Ut=l(),Je=i("p"),this.h()},l(e){const t=ps("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),y=n(e),u=o(e,"P",{}),ts(u).forEach(s),j=n(e),c(J.$$.fragment,e),Ue=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-i79xeb"&&(U.innerHTML=xt),ke=n(e),c(T.$$.fragment,e),xe=n(e),c(k.$$.fragment,e),$e=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1fxrwx6"&&(x.innerHTML=$t),Ie=n(e),c($.$$.fragment,e),ve=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-q94tv7"&&(I.innerHTML=It),Ge=n(e),c(b.$$.fragment,e),Ce=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1iimk7d"&&(v.textContent=vt),Be=n(e),c(G.$$.fragment,e),Ze=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1rl0sgr"&&(C.textContent=Gt),Qe=n(e),c(B.$$.fragment,e),_e=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ceakdm"&&(Z.innerHTML=Ct),We=n(e),c(Q.$$.fragment,e),He=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6d1hww"&&(_.innerHTML=Bt),Se=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-16cwp52"&&(W.innerHTML=Zt),Xe=n(e),c(H.$$.fragment,e),Ne=n(e),c(S.$$.fragment,e),Ye=n(e),c(X.$$.fragment,e),Re=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1659z3p"&&(N.innerHTML=Qt),Ae=n(e),c(Y.$$.fragment,e),Ee=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-13ev79t"&&(R.innerHTML=_t),Fe=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-74wskf"&&(A.innerHTML=Wt),Ve=n(e),c(E.$$.fragment,e),ze=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-166r3ga"&&(F.innerHTML=Ht),Le=n(e),c(V.$$.fragment,e),Pe=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1pm722b"&&(z.textContent=St),De=n(e),c(L.$$.fragment,e),qe=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1ml0f50"&&(P.innerHTML=Xt),Oe=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1tl1lis"&&(D.innerHTML=Nt),Ke=n(e),c(q.$$.fragment,e),et=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1y86c95"&&(O.innerHTML=Yt),tt=n(e),c(K.$$.fragment,e),st=n(e),c(ee.$$.fragment,e),at=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-9navcy"&&(te.innerHTML=Rt),lt=n(e),c(se.$$.fragment,e),nt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1y86c95"&&(ae.innerHTML=At),it=n(e),le=o(e,"DETAILS",{"data-svelte-h":!0}),r(le)!=="svelte-f75h31"&&(le.innerHTML=Et),ot=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1yu2d49"&&(ne.textContent=Ft),rt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-iq082d"&&(ie.innerHTML=Vt),pt=n(e),c(oe.$$.fragment,e),ct=n(e),c(re.$$.fragment,e),dt=n(e),c(pe.$$.fragment,e),ht=n(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),r(ce)!=="svelte-16dc737"&&(ce.innerHTML=zt),mt=n(e),c(de.$$.fragment,e),ft=n(e),he=o(e,"TABLE",{"data-svelte-h":!0}),r(he)!=="svelte-93fio9"&&(he.innerHTML=Lt),gt=n(e),c(me.$$.fragment,e),ut=n(e),fe=o(e,"TABLE",{"data-svelte-h":!0}),r(fe)!=="svelte-vw70ih"&&(fe.innerHTML=Pt),Mt=n(e),c(ge.$$.fragment,e),wt=n(e),ue=o(e,"TABLE",{"data-svelte-h":!0}),r(ue)!=="svelte-1rd81se"&&(ue.innerHTML=Dt),yt=n(e),c(Me.$$.fragment,e),jt=n(e),we=o(e,"TABLE",{"data-svelte-h":!0}),r(we)!=="svelte-sb1q1h"&&(we.innerHTML=qt),Tt=n(e),c(ye.$$.fragment,e),bt=n(e),je=o(e,"TABLE",{"data-svelte-h":!0}),r(je)!=="svelte-93ujrz"&&(je.innerHTML=Ot),Jt=n(e),c(Te.$$.fragment,e),Ut=n(e),Je=o(e,"P",{}),ts(Je).forEach(s),this.h()},h(){ss(g,"name","hf:doc:metadata"),ss(g,"content",gs)},m(e,t){cs(document.head,g),a(e,y,t),a(e,u,t),a(e,j,t),d(J,e,t),a(e,Ue,t),a(e,U,t),a(e,ke,t),d(T,e,t),a(e,xe,t),d(k,e,t),a(e,$e,t),a(e,x,t),a(e,Ie,t),d($,e,t),a(e,ve,t),a(e,I,t),a(e,Ge,t),d(b,e,t),a(e,Ce,t),a(e,v,t),a(e,Be,t),d(G,e,t),a(e,Ze,t),a(e,C,t),a(e,Qe,t),d(B,e,t),a(e,_e,t),a(e,Z,t),a(e,We,t),d(Q,e,t),a(e,He,t),a(e,_,t),a(e,Se,t),a(e,W,t),a(e,Xe,t),d(H,e,t),a(e,Ne,t),d(S,e,t),a(e,Ye,t),d(X,e,t),a(e,Re,t),a(e,N,t),a(e,Ae,t),d(Y,e,t),a(e,Ee,t),a(e,R,t),a(e,Fe,t),a(e,A,t),a(e,Ve,t),d(E,e,t),a(e,ze,t),a(e,F,t),a(e,Le,t),d(V,e,t),a(e,Pe,t),a(e,z,t),a(e,De,t),d(L,e,t),a(e,qe,t),a(e,P,t),a(e,Oe,t),a(e,D,t),a(e,Ke,t),d(q,e,t),a(e,et,t),a(e,O,t),a(e,tt,t),d(K,e,t),a(e,st,t),d(ee,e,t),a(e,at,t),a(e,te,t),a(e,lt,t),d(se,e,t),a(e,nt,t),a(e,ae,t),a(e,it,t),a(e,le,t),a(e,ot,t),a(e,ne,t),a(e,rt,t),a(e,ie,t),a(e,pt,t),d(oe,e,t),a(e,ct,t),d(re,e,t),a(e,dt,t),d(pe,e,t),a(e,ht,t),a(e,ce,t),a(e,mt,t),d(de,e,t),a(e,ft,t),a(e,he,t),a(e,gt,t),d(me,e,t),a(e,ut,t),a(e,fe,t),a(e,Mt,t),d(ge,e,t),a(e,wt,t),a(e,ue,t),a(e,yt,t),d(Me,e,t),a(e,jt,t),a(e,we,t),a(e,Tt,t),d(ye,e,t),a(e,bt,t),a(e,je,t),a(e,Jt,t),d(Te,e,t),a(e,Ut,t),a(e,Je,t),kt=!0},p(e,[t]){const Kt={};t&2&&(Kt.$$scope={dirty:t,ctx:e}),T.$set(Kt);const es={};t&2&&(es.$$scope={dirty:t,ctx:e}),b.$set(es)},i(e){kt||(h(J.$$.fragment,e),h(T.$$.fragment,e),h(k.$$.fragment,e),h($.$$.fragment,e),h(b.$$.fragment,e),h(G.$$.fragment,e),h(B.$$.fragment,e),h(Q.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),kt=!0)},o(e){m(J.$$.fragment,e),m(T.$$.fragment,e),m(k.$$.fragment,e),m($.$$.fragment,e),m(b.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(V.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(ge.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(Te.$$.fragment,e),kt=!1},d(e){e&&(s(y),s(u),s(j),s(Ue),s(U),s(ke),s(xe),s($e),s(x),s(Ie),s(ve),s(I),s(Ge),s(Ce),s(v),s(Be),s(Ze),s(C),s(Qe),s(_e),s(Z),s(We),s(He),s(_),s(Se),s(W),s(Xe),s(Ne),s(Ye),s(Re),s(N),s(Ae),s(Ee),s(R),s(Fe),s(A),s(Ve),s(ze),s(F),s(Le),s(Pe),s(z),s(De),s(qe),s(P),s(Oe),s(D),s(Ke),s(et),s(O),s(tt),s(st),s(at),s(te),s(lt),s(nt),s(ae),s(it),s(le),s(ot),s(ne),s(rt),s(ie),s(pt),s(ct),s(dt),s(ht),s(ce),s(mt),s(ft),s(he),s(gt),s(ut),s(fe),s(Mt),s(wt),s(ue),s(yt),s(jt),s(we),s(Tt),s(bt),s(je),s(Jt),s(Ut),s(Je)),s(g),f(J,e),f(T,e),f(k,e),f($,e),f(b,e),f(G,e),f(B,e),f(Q,e),f(H,e),f(S,e),f(X,e),f(Y,e),f(E,e),f(V,e),f(L,e),f(q,e),f(K,e),f(ee,e),f(se,e),f(oe,e),f(re,e),f(pe,e),f(de,e),f(me,e),f(ge,e),f(Me,e),f(ye,e),f(Te,e)}}}const gs='{"title":"The pipeline API","local":"the-pipeline-api","sections":[{"title":"The basics","local":"the-basics","sections":[],"depth":2},{"title":"Pipeline options","local":"pipeline-options","sections":[{"title":"Loading","local":"loading","sections":[],"depth":3},{"title":"Running","local":"running","sections":[],"depth":3},{"title":"Streaming","local":"streaming","sections":[],"depth":3}],"depth":2},{"title":"Available tasks","local":"available-tasks","sections":[{"title":"Tasks","local":"tasks","sections":[{"title":"Natural Language Processing","local":"natural-language-processing","sections":[],"depth":4},{"title":"Vision","local":"vision","sections":[],"depth":4},{"title":"Audio","local":"audio","sections":[],"depth":4},{"title":"Tabular","local":"tabular","sections":[],"depth":4},{"title":"Multimodal","local":"multimodal","sections":[],"depth":4},{"title":"Reinforcement Learning","local":"reinforcement-learning","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function us(be){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends os{constructor(g){super(),rs(this,g,us,fs,ns,{})}}export{bs as component};
