import{s as Le,o as Fe,n as Ve}from"../chunks/scheduler.0219f8bd.js";import{S as ze,i as Pe,g as p,s as a,r as m,A as De,h as o,f as t,c as n,j as Ae,u as h,x as c,k as Se,y as qe,a as l,v as d,d as w,t as u,w as f}from"../chunks/index.f61edf3b.js";import{T as Ee}from"../chunks/Tip.5d1e3ef4.js";import{C as F}from"../chunks/CodeBlock.15473de1.js";import{H as Ue,E as Ke}from"../chunks/getInferenceSnippets.352fd352.js";function Oe(z){let i,j='This tutorial will be written as an ES module, but you can easily adapt it to use CommonJS instead. For more information, see the <a href="https://huggingface.co/docs/transformers.js/tutorials/node" rel="nofollow">node tutorial</a>.';return{c(){i=p("p"),i.innerHTML=j},l(r){i=o(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-19bu2gi"&&(i.innerHTML=j)},m(r,T){l(r,i,T)},p:Ve,d(r){r&&t(i)}}}function es(z){let i,j="Remember to add <code>&quot;type&quot;: &quot;module&quot;</code> to your <code>package.json</code> to indicate that your project uses ECMAScript modules.";return{c(){i=p("p"),i.innerHTML=j},l(r){i=o(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1hk65wu"&&(i.innerHTML=j)},m(r,T){l(r,i,T)},p:Ve,d(r){r&&t(i)}}}function ss(z){let i,j,r,T,y,D,b,Ie='A major benefit of writing code for the web is that you can access the multitude of APIs that are available in modern browsers. Unfortunately, when writing server-side code, we are not afforded such luxury, so we have to find another way. In this tutorial, we will design a simple Node.js application that uses Transformers.js for speech recognition with <a href="https://huggingface.co/Xenova/whisper-tiny.en" rel="nofollow">Whisper</a>, and in the process, learn how to process audio on the server.',q,$,ve='The main problem we need to solve is that the <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API" rel="nofollow">Web Audio API</a> is not available in Node.js, meaning we can’t use the <a href="https://developer.mozilla.org/en-US/docs/Web/API/AudioContext" rel="nofollow"><code>AudioContext</code></a> class to process audio. So, we will need to install third-party libraries to obtain the raw audio data. For this example, we will only consider <code>.wav</code> files, but the same principles apply to other audio formats.',K,M,O,g,Ce="<strong>Useful links:</strong>",ee,U,ke='<li><a href="https://github.com/huggingface/transformers.js/tree/main/examples/node-audio-processing" rel="nofollow">Source code</a></li> <li><a href="https://huggingface.co/docs/transformers.js" rel="nofollow">Documentation</a></li>',se,I,te,v,Ze='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',le,C,ae,k,Be='Let’s start by creating a new Node.js project and installing Transformers.js via <a href="https://www.npmjs.com/package/@huggingface/transformers" rel="nofollow">NPM</a>:',ne,Z,ie,J,pe,B,xe='Next, let’s install the <a href="https://www.npmjs.com/package/wavefile" rel="nofollow"><code>wavefile</code></a> package, which we will use for loading <code>.wav</code> files:',oe,x,re,G,ce,_,Ge="Start by creating a new file called <code>index.js</code>, which will be the entry point for our application. Let’s also import the necessary modules:",me,W,he,N,_e='For this tutorial, we will use the <code>Xenova/whisper-tiny.en</code> model, but feel free to choose one of the other whisper models from the <a href="https://huggingface.co/models?library=transformers.js&amp;search=whisper" rel="nofollow">Hugging Face Hub</a>. Let’s create our pipeline with:',de,X,we,Y,We="Next, let’s load an audio file and convert it to the format required by Transformers.js:",ue,H,fe,Q,Ne="Finally, let’s run the model and measure execution duration.",je,R,Te,A,Xe="You can now run the application with <code>node index.js</code>. Note that when running the script for the first time, it may take a while to download and cache the model. Subsequent requests will use the cached model, and model loading will be much faster.",Me,S,Ye="You should see output similar to:",Je,E,ye,V,He="That’s it! You’ve successfully created a Node.js application that uses Transformers.js for speech recognition with Whisper. You can now use this as a starting point for your own applications.",be,L,$e,P,ge;return y=new Ue({props:{title:"Server-side Audio Processing in Node.js",local:"server-side-audio-processing-in-nodejs",headingTag:"h1"}}),M=new Ee({props:{$$slots:{default:[Oe]},$$scope:{ctx:z}}}),I=new Ue({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),C=new Ue({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),Z=new F({props:{code:"bnBtJTIwaW5pdCUyMC15JTBBbnBtJTIwaSUyMCU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:`npm init -y
npm i @huggingface/transformers`,wrap:!1}}),J=new Ee({props:{$$slots:{default:[es]},$$scope:{ctx:z}}}),x=new F({props:{code:"bnBtJTIwaSUyMHdhdmVmaWxl",highlighted:"npm i wavefile",wrap:!1}}),G=new Ue({props:{title:"Creating the application",local:"creating-the-application",headingTag:"h2"}}),W=new F({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQWltcG9ydCUyMHdhdmVmaWxlJTIwZnJvbSUyMCd3YXZlZmlsZSclM0I=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;
<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;`,wrap:!1}}),X=new F({props:{code:"bGV0JTIwdHJhbnNjcmliZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJyUyQyUyMCdYZW5vdmElMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQg==",highlighted:'<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);',wrap:!1}}),H=new F({props:{code:"JTJGJTJGJTIwTG9hZCUyMGF1ZGlvJTIwZGF0YSUwQWxldCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGamZrLndhdiclM0IlMEFsZXQlMjBidWZmZXIlMjAlM0QlMjBCdWZmZXIuZnJvbShhd2FpdCUyMGZldGNoKHVybCkudGhlbih4JTIwJTNEJTNFJTIweC5hcnJheUJ1ZmZlcigpKSklMEElMEElMkYlMkYlMjBSZWFkJTIwLndhdiUyMGZpbGUlMjBhbmQlMjBjb252ZXJ0JTIwaXQlMjB0byUyMHJlcXVpcmVkJTIwZm9ybWF0JTBBbGV0JTIwd2F2JTIwJTNEJTIwbmV3JTIwd2F2ZWZpbGUuV2F2ZUZpbGUoYnVmZmVyKSUzQiUwQXdhdi50b0JpdERlcHRoKCczMmYnKSUzQiUyMCUyRiUyRiUyMFBpcGVsaW5lJTIwZXhwZWN0cyUyMGlucHV0JTIwYXMlMjBhJTIwRmxvYXQzMkFycmF5JTBBd2F2LnRvU2FtcGxlUmF0ZSgxNjAwMCklM0IlMjAlMkYlMkYlMjBXaGlzcGVyJTIwZXhwZWN0cyUyMGF1ZGlvJTIwd2l0aCUyMGElMjBzYW1wbGluZyUyMHJhdGUlMjBvZiUyMDE2MDAwJTBBbGV0JTIwYXVkaW9EYXRhJTIwJTNEJTIwd2F2LmdldFNhbXBsZXMoKSUzQiUwQWlmJTIwKEFycmF5LmlzQXJyYXkoYXVkaW9EYXRhKSklMjAlN0IlMEElMjAlMjBpZiUyMChhdWRpb0RhdGEubGVuZ3RoJTIwJTNFJTIwMSklMjAlN0IlMEElMjAlMjAlMjAlMjBjb25zdCUyMFNDQUxJTkdfRkFDVE9SJTIwJTNEJTIwTWF0aC5zcXJ0KDIpJTNCJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwTWVyZ2UlMjBjaGFubmVscyUyMChpbnRvJTIwZmlyc3QlMjBjaGFubmVsJTIwdG8lMjBzYXZlJTIwbWVtb3J5KSUwQSUyMCUyMCUyMCUyMGZvciUyMChsZXQlMjBpJTIwJTNEJTIwMCUzQiUyMGklMjAlM0MlMjBhdWRpb0RhdGElNUIwJTVELmxlbmd0aCUzQiUyMCUyQiUyQmkpJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9EYXRhJTVCMCU1RCU1QmklNUQlMjAlM0QlMjBTQ0FMSU5HX0ZBQ1RPUiUyMColMjAoYXVkaW9EYXRhJTVCMCU1RCU1QmklNUQlMjAlMkIlMjBhdWRpb0RhdGElNUIxJTVEJTVCaSU1RCklMjAlMkYlMjAyJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTJGJTJGJTIwU2VsZWN0JTIwZmlyc3QlMjBjaGFubmVsJTBBJTIwJTIwYXVkaW9EYXRhJTIwJTNEJTIwYXVkaW9EYXRhJTVCMCU1RCUzQiUwQSU3RA==",highlighted:`<span class="hljs-comment">// Load audio data</span>
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> buffer = <span class="hljs-title class_">Buffer</span>.<span class="hljs-title function_">from</span>(<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(url).<span class="hljs-title function_">then</span>(<span class="hljs-function"><span class="hljs-params">x</span> =&gt;</span> x.<span class="hljs-title function_">arrayBuffer</span>()))

<span class="hljs-comment">// Read .wav file and convert it to required format</span>
<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>(buffer);
wav.<span class="hljs-title function_">toBitDepth</span>(<span class="hljs-string">&#x27;32f&#x27;</span>); <span class="hljs-comment">// Pipeline expects input as a Float32Array</span>
wav.<span class="hljs-title function_">toSampleRate</span>(<span class="hljs-number">16000</span>); <span class="hljs-comment">// Whisper expects audio with a sampling rate of 16000</span>
<span class="hljs-keyword">let</span> audioData = wav.<span class="hljs-title function_">getSamples</span>();
<span class="hljs-keyword">if</span> (<span class="hljs-title class_">Array</span>.<span class="hljs-title function_">isArray</span>(audioData)) {
  <span class="hljs-keyword">if</span> (audioData.<span class="hljs-property">length</span> &gt; <span class="hljs-number">1</span>) {
    <span class="hljs-keyword">const</span> <span class="hljs-variable constant_">SCALING_FACTOR</span> = <span class="hljs-title class_">Math</span>.<span class="hljs-title function_">sqrt</span>(<span class="hljs-number">2</span>);

    <span class="hljs-comment">// Merge channels (into first channel to save memory)</span>
    <span class="hljs-keyword">for</span> (<span class="hljs-keyword">let</span> i = <span class="hljs-number">0</span>; i &lt; audioData[<span class="hljs-number">0</span>].<span class="hljs-property">length</span>; ++i) {
      audioData[<span class="hljs-number">0</span>][i] = <span class="hljs-variable constant_">SCALING_FACTOR</span> * (audioData[<span class="hljs-number">0</span>][i] + audioData[<span class="hljs-number">1</span>][i]) / <span class="hljs-number">2</span>;
    }
  }

  <span class="hljs-comment">// Select first channel</span>
  audioData = audioData[<span class="hljs-number">0</span>];
}`,wrap:!1}}),R=new F({props:{code:"bGV0JTIwc3RhcnQlMjAlM0QlMjBwZXJmb3JtYW5jZS5ub3coKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNjcmliZXIoYXVkaW9EYXRhKSUzQiUwQWxldCUyMGVuZCUyMCUzRCUyMHBlcmZvcm1hbmNlLm5vdygpJTNCJTBBY29uc29sZS5sb2coJTYwRXhlY3V0aW9uJTIwZHVyYXRpb24lM0ElMjAlMjQlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDEwMDAlN0QlMjBzZWNvbmRzJTYwKSUzQiUwQWNvbnNvbGUubG9nKG91dHB1dCklM0I=",highlighted:`<span class="hljs-keyword">let</span> start = performance.<span class="hljs-title function_">now</span>();
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(audioData);
<span class="hljs-keyword">let</span> end = performance.<span class="hljs-title function_">now</span>();
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Execution duration: <span class="hljs-subst">\${(end - start) / <span class="hljs-number">1000</span>}</span> seconds\`</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output);`,wrap:!1}}),E=new F({props:{code:"RXhlY3V0aW9uJTIwZHVyYXRpb24lM0ElMjAwLjY0NjAzMTc5OTk3MjA1NzQlMjBzZWNvbmRzJTBBJTdCJTBBJTIwJTIwdGV4dCUzQSUyMCclMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UuJTIwQXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJyUwQSU3RA==",highlighted:`Execution duration: <span class="hljs-number">0.6460317999720574</span> seconds
{
  text: &#x27; And so my fellow Americans ask not what your country can <span class="hljs-keyword">do</span> <span class="hljs-keyword">for</span> <span class="hljs-title class_">you</span>. Ask what you can <span class="hljs-keyword">do</span> <span class="hljs-keyword">for</span> <span class="hljs-title class_">your</span> country.&#x27;
}`,wrap:!1}}),L=new Ke({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/guides/node-audio-processing.md"}}),{c(){i=p("meta"),j=a(),r=p("p"),T=a(),m(y.$$.fragment),D=a(),b=p("p"),b.innerHTML=Ie,q=a(),$=p("p"),$.innerHTML=ve,K=a(),m(M.$$.fragment),O=a(),g=p("p"),g.innerHTML=Ce,ee=a(),U=p("ul"),U.innerHTML=ke,se=a(),m(I.$$.fragment),te=a(),v=p("ul"),v.innerHTML=Ze,le=a(),m(C.$$.fragment),ae=a(),k=p("p"),k.innerHTML=Be,ne=a(),m(Z.$$.fragment),ie=a(),m(J.$$.fragment),pe=a(),B=p("p"),B.innerHTML=xe,oe=a(),m(x.$$.fragment),re=a(),m(G.$$.fragment),ce=a(),_=p("p"),_.innerHTML=Ge,me=a(),m(W.$$.fragment),he=a(),N=p("p"),N.innerHTML=_e,de=a(),m(X.$$.fragment),we=a(),Y=p("p"),Y.textContent=We,ue=a(),m(H.$$.fragment),fe=a(),Q=p("p"),Q.textContent=Ne,je=a(),m(R.$$.fragment),Te=a(),A=p("p"),A.innerHTML=Xe,Me=a(),S=p("p"),S.textContent=Ye,Je=a(),m(E.$$.fragment),ye=a(),V=p("p"),V.textContent=He,be=a(),m(L.$$.fragment),$e=a(),P=p("p"),this.h()},l(e){const s=De("svelte-u9bgzb",document.head);i=o(s,"META",{name:!0,content:!0}),s.forEach(t),j=n(e),r=o(e,"P",{}),Ae(r).forEach(t),T=n(e),h(y.$$.fragment,e),D=n(e),b=o(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-ga23p1"&&(b.innerHTML=Ie),q=n(e),$=o(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1p7qc0w"&&($.innerHTML=ve),K=n(e),h(M.$$.fragment,e),O=n(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1kriz5m"&&(g.innerHTML=Ce),ee=n(e),U=o(e,"UL",{"data-svelte-h":!0}),c(U)!=="svelte-gjomd0"&&(U.innerHTML=ke),se=n(e),h(I.$$.fragment,e),te=n(e),v=o(e,"UL",{"data-svelte-h":!0}),c(v)!=="svelte-1qy4daj"&&(v.innerHTML=Ze),le=n(e),h(C.$$.fragment,e),ae=n(e),k=o(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1xetp1f"&&(k.innerHTML=Be),ne=n(e),h(Z.$$.fragment,e),ie=n(e),h(J.$$.fragment,e),pe=n(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-e9y8ng"&&(B.innerHTML=xe),oe=n(e),h(x.$$.fragment,e),re=n(e),h(G.$$.fragment,e),ce=n(e),_=o(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-wc1j2"&&(_.innerHTML=Ge),me=n(e),h(W.$$.fragment,e),he=n(e),N=o(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-g3d4hf"&&(N.innerHTML=_e),de=n(e),h(X.$$.fragment,e),we=n(e),Y=o(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1jpls9q"&&(Y.textContent=We),ue=n(e),h(H.$$.fragment,e),fe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1sjiopi"&&(Q.textContent=Ne),je=n(e),h(R.$$.fragment,e),Te=n(e),A=o(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-cx7eio"&&(A.innerHTML=Xe),Me=n(e),S=o(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-s5mxam"&&(S.textContent=Ye),Je=n(e),h(E.$$.fragment,e),ye=n(e),V=o(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1mxb03j"&&(V.textContent=He),be=n(e),h(L.$$.fragment,e),$e=n(e),P=o(e,"P",{}),Ae(P).forEach(t),this.h()},h(){Se(i,"name","hf:doc:metadata"),Se(i,"content",ts)},m(e,s){qe(document.head,i),l(e,j,s),l(e,r,s),l(e,T,s),d(y,e,s),l(e,D,s),l(e,b,s),l(e,q,s),l(e,$,s),l(e,K,s),d(M,e,s),l(e,O,s),l(e,g,s),l(e,ee,s),l(e,U,s),l(e,se,s),d(I,e,s),l(e,te,s),l(e,v,s),l(e,le,s),d(C,e,s),l(e,ae,s),l(e,k,s),l(e,ne,s),d(Z,e,s),l(e,ie,s),d(J,e,s),l(e,pe,s),l(e,B,s),l(e,oe,s),d(x,e,s),l(e,re,s),d(G,e,s),l(e,ce,s),l(e,_,s),l(e,me,s),d(W,e,s),l(e,he,s),l(e,N,s),l(e,de,s),d(X,e,s),l(e,we,s),l(e,Y,s),l(e,ue,s),d(H,e,s),l(e,fe,s),l(e,Q,s),l(e,je,s),d(R,e,s),l(e,Te,s),l(e,A,s),l(e,Me,s),l(e,S,s),l(e,Je,s),d(E,e,s),l(e,ye,s),l(e,V,s),l(e,be,s),d(L,e,s),l(e,$e,s),l(e,P,s),ge=!0},p(e,[s]){const Qe={};s&2&&(Qe.$$scope={dirty:s,ctx:e}),M.$set(Qe);const Re={};s&2&&(Re.$$scope={dirty:s,ctx:e}),J.$set(Re)},i(e){ge||(w(y.$$.fragment,e),w(M.$$.fragment,e),w(I.$$.fragment,e),w(C.$$.fragment,e),w(Z.$$.fragment,e),w(J.$$.fragment,e),w(x.$$.fragment,e),w(G.$$.fragment,e),w(W.$$.fragment,e),w(X.$$.fragment,e),w(H.$$.fragment,e),w(R.$$.fragment,e),w(E.$$.fragment,e),w(L.$$.fragment,e),ge=!0)},o(e){u(y.$$.fragment,e),u(M.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(Z.$$.fragment,e),u(J.$$.fragment,e),u(x.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),ge=!1},d(e){e&&(t(j),t(r),t(T),t(D),t(b),t(q),t($),t(K),t(O),t(g),t(ee),t(U),t(se),t(te),t(v),t(le),t(ae),t(k),t(ne),t(ie),t(pe),t(B),t(oe),t(re),t(ce),t(_),t(me),t(he),t(N),t(de),t(we),t(Y),t(ue),t(fe),t(Q),t(je),t(Te),t(A),t(Me),t(S),t(Je),t(ye),t(V),t(be),t($e),t(P)),t(i),f(y,e),f(M,e),f(I,e),f(C,e),f(Z,e),f(J,e),f(x,e),f(G,e),f(W,e),f(X,e),f(H,e),f(R,e),f(E,e),f(L,e)}}}const ts='{"title":"Server-side Audio Processing in Node.js","local":"server-side-audio-processing-in-nodejs","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Getting started","local":"getting-started","sections":[],"depth":2},{"title":"Creating the application","local":"creating-the-application","sections":[],"depth":2}],"depth":1}';function ls(z){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends ze{constructor(i){super(),Pe(this,i,ls,ss,Le,{})}}export{rs as component};
