import{s as Wt,n as vt,o as Ft}from"../chunks/scheduler.c59d9fbb.js";import{S as Zt,i as $t,g as i,s,r as d,A as Rt,h as r,f as a,c as n,j as _t,u as p,x as o,k as It,y as Gt,a as l,v as m,d as M,t as b,w as f}from"../chunks/index.a47918e3.js";import{C as mt}from"../chunks/CodeBlock.936db8cd.js";import{H as x}from"../chunks/Heading.604bc707.js";function Qt(Mt){let c,X,B,H,h,A,y,bt="SetFit models can be influenced by callbacks, for example for logging or early stopping.",E,u,ft="This guide will show you what they are and how they can be used.",N,T,q,g,ht='Callbacks are objects that customize the behaviour of the training loop in the SetFit <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.Trainer">Trainer</a> that can inspect the training loop state (for progress reporting, logging, inspecting embeddings during training) and take decisions (e.g. early stopping).',z,w,yt='In particular, the <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.Trainer">Trainer</a> uses a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerControl" rel="nofollow"><code>TrainerControl</code></a> that can be influenced by callbacks to stop training, save models, evaluate, or log, and a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerState" rel="nofollow"><code>TrainerState</code></a> which tracks some training loop metrics during training, such as the number of training steps so far.',L,J,ut='SetFit relies on the Callbacks implemented in <code>transformers</code>, as described in the <code>transformers</code> documentation <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">here</a>.',V,U,P,C,Tt='SetFit uses the <code>TrainingArguments.report_to</code> argument to specify which of the built-in callbacks should be enabled. This argument defaults to <code>&quot;all&quot;</code>, meaning that all third-party callbacks from <code>transformers</code> that are also installed will be enabled. For example the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow"><code>TensorBoardCallback</code></a> or the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.WandbCallback" rel="nofollow"><code>WandbCallback</code></a>.',D,j,gt='Beyond that, the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.PrinterCallback" rel="nofollow"><code>PrinterCallback</code></a> or <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.ProgressCallback" rel="nofollow"><code>ProgressCallback</code></a> is always enabled to show the training progress, and <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.DefaultFlowCallback" rel="nofollow"><code>DefaultFlowCallback</code></a> is also always enabled to properly update the <code>TrainerControl</code>.',K,k,O,_,wt="As mentioned, you can use <code>TrainingArguments.report_to</code> to specify exactly which callbacks you would like to enable. For example:",tt,I,et,W,Jt='You can also use <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.DistillationTrainer.add_callback">Trainer.add_callback()</a>, <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.DistillationTrainer.pop_callback">Trainer.pop_callback()</a> and <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.DistillationTrainer.remove_callback">Trainer.remove_callback()</a> to influence the trainer callbacks, and you can specify callbacks via the <a href="/docs/setfit/v1.0.3/en/reference/trainer#setfit.Trainer">Trainer</a> init, e.g.:',at,v,lt,F,st,Z,Ut='SetFit supports custom callbacks in the same way that <code>transformers</code> does: by subclassing <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerCallback" rel="nofollow"><code>TrainerCallback</code></a>. This class implements a lot of <code>on_...</code> methods that can be overridden. For example, the following script shows a custom callback that saves plots of the tSNE of the training and evaluation embeddings during training.',nt,$,it,R,Ct="with",rt,G,ot,Q,jt="The <code>on_evaluate</code> from <code>EmbeddingPlotCallback</code> will be triggered on every single evaluation call. In the case of this example, it resulted in the following figures being plotted:",ct,Y,kt='<thead><tr><th>Step 20</th> <th>Step 40</th></tr></thead> <tbody><tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/7200d00a-fd48-4038-bcbe-f2d5f1280162" alt="step_20"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/be12e3c4-867c-452d-89a0-0677f035516d" alt="step_40"/></td></tr> <tr><td><strong>Step 60</strong></td> <td><strong>Step 80</strong></td></tr> <tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/3a384aa2-51ce-40d7-b02c-a2c986f3aeb4" alt="step_60"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/b5aa9835-40cb-4327-9f31-b3ababeca769" alt="step_80"/></td></tr></tbody>',dt,S,pt;return h=new x({props:{title:"Callbacks",local:"callbacks",headingTag:"h1"}}),T=new x({props:{title:"Callbacks in SetFit",local:"callbacks-in-setfit",headingTag:"h2"}}),U=new x({props:{title:"Default Callbacks",local:"default-callbacks",headingTag:"h2"}}),k=new x({props:{title:"Using Callbacks",local:"using-callbacks",headingTag:"h2"}}),I=new mt({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCUyMndhbmRiJTIyJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBKSUwQSUyMyUyMG9yJTIwJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCU1QiUyMndhbmRiJTIyJTJDJTIwJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAuLi4lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments

args = TrainingArguments(
    ...,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    ...,
)
<span class="hljs-comment"># or </span>
args = TrainingArguments(
    ...,
    report_to=[<span class="hljs-string">&quot;wandb&quot;</span>, <span class="hljs-string">&quot;tensorboard&quot;</span>],
    ...,
)`,wrap:!1}}),v=new mt({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

...

trainer = Trainer(
    model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EarlyStoppingCallback(early_stopping_patience=<span class="hljs-number">5</span>)],
)
trainer.train()`,wrap:!1}}),F=new x({props:{title:"Custom Callbacks",local:"custom-callbacks",headingTag:"h2"}}),$=new mt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> sklearn.manifold <span class="hljs-keyword">import</span> TSNE

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmbeddingPlotCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-string">&quot;&quot;&quot;Simple embedding plotting callback that plots the tSNE of the training and evaluation datasets throughout training.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_evaluate</span>(<span class="hljs-params">self, args: TrainingArguments, state: TrainerState, control: TrainerControl, model: SetFitModel, **kwargs</span>):
        train_embeddings = model.encode(train_dataset[<span class="hljs-string">&quot;text&quot;</span>])
        eval_embeddings = model.encode(eval_dataset[<span class="hljs-string">&quot;text&quot;</span>])

        fig, (train_ax, eval_ax) = plt.subplots(ncols=<span class="hljs-number">2</span>)

        train_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(train_embeddings)
        train_ax.scatter(*train_X.T, c=train_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=train_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        train_ax.set_title(<span class="hljs-string">&quot;Training embeddings&quot;</span>)

        eval_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(eval_embeddings)
        eval_ax.scatter(*eval_X.T, c=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        eval_ax.set_title(<span class="hljs-string">&quot;Evaluation embeddings&quot;</span>)

        fig.suptitle(<span class="hljs-string">f&quot;tSNE of training and evaluation embeddings at step <span class="hljs-subst">{state.global_step}</span> of <span class="hljs-subst">{state.max_steps}</span>.&quot;</span>)
        fig.savefig(<span class="hljs-string">f&quot;logs/step_<span class="hljs-subst">{state.global_step}</span>.png&quot;</span>)`,wrap:!1}}),G=new mt({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja3MlM0QlNUJFbWJlZGRpbmdQbG90Q2FsbGJhY2soKSU1RCUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EmbeddingPlotCallback()]
)
trainer.train()`,wrap:!1}}),{c(){c=i("meta"),X=s(),B=i("p"),H=s(),d(h.$$.fragment),A=s(),y=i("p"),y.textContent=bt,E=s(),u=i("p"),u.textContent=ft,N=s(),d(T.$$.fragment),q=s(),g=i("p"),g.innerHTML=ht,z=s(),w=i("p"),w.innerHTML=yt,L=s(),J=i("p"),J.innerHTML=ut,V=s(),d(U.$$.fragment),P=s(),C=i("p"),C.innerHTML=Tt,D=s(),j=i("p"),j.innerHTML=gt,K=s(),d(k.$$.fragment),O=s(),_=i("p"),_.innerHTML=wt,tt=s(),d(I.$$.fragment),et=s(),W=i("p"),W.innerHTML=Jt,at=s(),d(v.$$.fragment),lt=s(),d(F.$$.fragment),st=s(),Z=i("p"),Z.innerHTML=Ut,nt=s(),d($.$$.fragment),it=s(),R=i("p"),R.textContent=Ct,rt=s(),d(G.$$.fragment),ot=s(),Q=i("p"),Q.innerHTML=jt,ct=s(),Y=i("table"),Y.innerHTML=kt,dt=s(),S=i("p"),this.h()},l(t){const e=Rt("svelte-u9bgzb",document.head);c=r(e,"META",{name:!0,content:!0}),e.forEach(a),X=n(t),B=r(t,"P",{}),_t(B).forEach(a),H=n(t),p(h.$$.fragment,t),A=n(t),y=r(t,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1qsyej"&&(y.textContent=bt),E=n(t),u=r(t,"P",{"data-svelte-h":!0}),o(u)!=="svelte-1neobwt"&&(u.textContent=ft),N=n(t),p(T.$$.fragment,t),q=n(t),g=r(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-11ia882"&&(g.innerHTML=ht),z=n(t),w=r(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-ot055h"&&(w.innerHTML=yt),L=n(t),J=r(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-m6jr23"&&(J.innerHTML=ut),V=n(t),p(U.$$.fragment,t),P=n(t),C=r(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1d5its4"&&(C.innerHTML=Tt),D=n(t),j=r(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-195z5eh"&&(j.innerHTML=gt),K=n(t),p(k.$$.fragment,t),O=n(t),_=r(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-9jofl1"&&(_.innerHTML=wt),tt=n(t),p(I.$$.fragment,t),et=n(t),W=r(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-134gh6b"&&(W.innerHTML=Jt),at=n(t),p(v.$$.fragment,t),lt=n(t),p(F.$$.fragment,t),st=n(t),Z=r(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1a0isl"&&(Z.innerHTML=Ut),nt=n(t),p($.$$.fragment,t),it=n(t),R=r(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1jtaf10"&&(R.textContent=Ct),rt=n(t),p(G.$$.fragment,t),ot=n(t),Q=r(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-14nrepa"&&(Q.innerHTML=jt),ct=n(t),Y=r(t,"TABLE",{"data-svelte-h":!0}),o(Y)!=="svelte-g475cj"&&(Y.innerHTML=kt),dt=n(t),S=r(t,"P",{}),_t(S).forEach(a),this.h()},h(){It(c,"name","hf:doc:metadata"),It(c,"content",Yt)},m(t,e){Gt(document.head,c),l(t,X,e),l(t,B,e),l(t,H,e),m(h,t,e),l(t,A,e),l(t,y,e),l(t,E,e),l(t,u,e),l(t,N,e),m(T,t,e),l(t,q,e),l(t,g,e),l(t,z,e),l(t,w,e),l(t,L,e),l(t,J,e),l(t,V,e),m(U,t,e),l(t,P,e),l(t,C,e),l(t,D,e),l(t,j,e),l(t,K,e),m(k,t,e),l(t,O,e),l(t,_,e),l(t,tt,e),m(I,t,e),l(t,et,e),l(t,W,e),l(t,at,e),m(v,t,e),l(t,lt,e),m(F,t,e),l(t,st,e),l(t,Z,e),l(t,nt,e),m($,t,e),l(t,it,e),l(t,R,e),l(t,rt,e),m(G,t,e),l(t,ot,e),l(t,Q,e),l(t,ct,e),l(t,Y,e),l(t,dt,e),l(t,S,e),pt=!0},p:vt,i(t){pt||(M(h.$$.fragment,t),M(T.$$.fragment,t),M(U.$$.fragment,t),M(k.$$.fragment,t),M(I.$$.fragment,t),M(v.$$.fragment,t),M(F.$$.fragment,t),M($.$$.fragment,t),M(G.$$.fragment,t),pt=!0)},o(t){b(h.$$.fragment,t),b(T.$$.fragment,t),b(U.$$.fragment,t),b(k.$$.fragment,t),b(I.$$.fragment,t),b(v.$$.fragment,t),b(F.$$.fragment,t),b($.$$.fragment,t),b(G.$$.fragment,t),pt=!1},d(t){t&&(a(X),a(B),a(H),a(A),a(y),a(E),a(u),a(N),a(q),a(g),a(z),a(w),a(L),a(J),a(V),a(P),a(C),a(D),a(j),a(K),a(O),a(_),a(tt),a(et),a(W),a(at),a(lt),a(st),a(Z),a(nt),a(it),a(R),a(rt),a(ot),a(Q),a(ct),a(Y),a(dt),a(S)),a(c),f(h,t),f(T,t),f(U,t),f(k,t),f(I,t),f(v,t),f(F,t),f($,t),f(G,t)}}}const Yt='{"title":"Callbacks","local":"callbacks","sections":[{"title":"Callbacks in SetFit","local":"callbacks-in-setfit","sections":[],"depth":2},{"title":"Default Callbacks","local":"default-callbacks","sections":[],"depth":2},{"title":"Using Callbacks","local":"using-callbacks","sections":[],"depth":2},{"title":"Custom Callbacks","local":"custom-callbacks","sections":[],"depth":2}],"depth":1}';function Bt(Mt){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Zt{constructor(c){super(),$t(this,c,Bt,Qt,Wt,{})}}export{At as component};
