import{s as ps,o as ms,n as R}from"../chunks/scheduler.6062bdaf.js";import{S as gs,i as _s,g as d,s as o,r as _,A as fs,h,f as a,c as i,j as H,u as f,x as m,k as U,y as r,a as l,v as u,d as b,t as v,w as $}from"../chunks/index.4bca734e.js";import{T as Ue}from"../chunks/Tip.b9ac1f03.js";import{D as ue}from"../chunks/Docstring.81ba5e3c.js";import{C as Ut}from"../chunks/CodeBlock.fa01571c.js";import{E as Ht}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as W,E as us}from"../chunks/EditOnGithub.74ab2baa.js";function bs(y){let t,g=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=g},l(n){t=h(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-16sq104"&&(t.innerHTML=g)},m(n,p){l(n,t,p)},p:R,d(n){n&&a(t)}}}function vs(y){let t,g="Example:",n,p,w;return p=new Ut({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNhdmVfdG9yY2hfbW9kZWwlMEFtb2RlbCUyMCUzRCUyMC4uLiUyMCUyMyUyMEElMjBQeVRvcmNoJTIwbW9kZWwlMEElMEFzYXZlX3RvcmNoX21vZGVsKG1vZGVsJTJDJTIwJTIycGF0aCUyRnRvJTJGZm9sZGVyJTIyKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2FkX3RvcmNoX21vZGVsJTIwJTIwJTIzJTIwVE9ETyUwQWxvYWRfdG9yY2hfbW9kZWwobW9kZWwlMkMlMjAlMjJwYXRoJTJGdG8lMkZmb2xkZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> save_torch_model
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ... <span class="hljs-comment"># A PyTorch model</span>

<span class="hljs-comment"># Save state dict to &quot;path/to/folder&quot;. The model will be split into shards of 5GB each and saved as safetensors.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_torch_model(model, <span class="hljs-string">&quot;path/to/folder&quot;</span>)

<span class="hljs-comment"># Load model back</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> load_torch_model  <span class="hljs-comment"># TODO</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>load_torch_model(model, <span class="hljs-string">&quot;path/to/folder&quot;</span>)
&gt;&gt;&gt;`,wrap:!1}}),{c(){t=d("p"),t.textContent=g,n=o(),_(p.$$.fragment)},l(c){t=h(c,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=g),n=i(c),f(p.$$.fragment,c)},m(c,x){l(c,t,x),l(c,n,x),u(p,c,x),w=!0},p:R,i(c){w||(b(p.$$.fragment,c),w=!0)},o(c){v(p.$$.fragment,c),w=!1},d(c){c&&(a(t),a(n)),$(p,c)}}}function $s(y){let t,g=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=g},l(n){t=h(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-16sq104"&&(t.innerHTML=g)},m(n,p){l(n,t,p)},p:R,d(n){n&&a(t)}}}function ws(y){let t,g="Example:",n,p,w;return p=new Ut({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNhdmVfdG9yY2hfc3RhdGVfZGljdCUwQW1vZGVsJTIwJTNEJTIwLi4uJTIwJTIzJTIwQSUyMFB5VG9yY2glMjBtb2RlbCUwQSUwQXN0YXRlX2RpY3QlMjAlM0QlMjBtb2RlbF90b19zYXZlLnN0YXRlX2RpY3QoKSUwQXNhdmVfdG9yY2hfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwJTIycGF0aCUyRnRvJTJGZm9sZGVyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> save_torch_state_dict
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ... <span class="hljs-comment"># A PyTorch model</span>

<span class="hljs-comment"># Save state dict to &quot;path/to/folder&quot;. The model will be split into shards of 5GB each and saved as safetensors.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = model_to_save.state_dict()
<span class="hljs-meta">&gt;&gt;&gt; </span>save_torch_state_dict(state_dict, <span class="hljs-string">&quot;path/to/folder&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=g,n=o(),_(p.$$.fragment)},l(c){t=h(c,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=g),n=i(c),f(p.$$.fragment,c)},m(c,x){l(c,t,x),l(c,n,x),u(p,c,x),w=!0},p:R,i(c){w||(b(p.$$.fragment,c),w=!0)},o(c){v(p.$$.fragment,c),w=!1},d(c){c&&(a(t),a(n)),$(p,c)}}}function Ts(y){let t,g=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=g},l(n){t=h(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-16sq104"&&(t.innerHTML=g)},m(n,p){l(n,t,p)},p:R,d(n){n&&a(t)}}}function Ms(y){let t,g=`To save a model state dictionary to the disk, see <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_state_dict">save_torch_state_dict()</a>. This helper uses
<code>split_torch_state_dict_into_shards</code> under the hood.`;return{c(){t=d("p"),t.innerHTML=g},l(n){t=h(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-6g0ega"&&(t.innerHTML=g)},m(n,p){l(n,t,p)},p:R,d(n){n&&a(t)}}}function ys(y){let t,g=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=g},l(n){t=h(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-16sq104"&&(t.innerHTML=g)},m(n,p){l(n,t,p)},p:R,d(n){n&&a(t)}}}function xs(y){let t,g="Example:",n,p,w;return p=new Ut({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMG9zJTBBZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwc2F2ZV9maWxlJTIwYXMlMjBzYWZlX3NhdmVfZmlsZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBzcGxpdF90b3JjaF9zdGF0ZV9kaWN0X2ludG9fc2hhcmRzJTBBJTBBZGVmJTIwc2F2ZV9zdGF0ZV9kaWN0KHN0YXRlX2RpY3QlM0ElMjBEaWN0JTVCc3RyJTJDJTIwdG9yY2guVGVuc29yJTVEJTJDJTIwc2F2ZV9kaXJlY3RvcnklM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwc3RhdGVfZGljdF9zcGxpdCUyMCUzRCUyMHNwbGl0X3RvcmNoX3N0YXRlX2RpY3RfaW50b19zaGFyZHMoc3RhdGVfZGljdCklMEElMjAlMjAlMjAlMjBmb3IlMjBmaWxlbmFtZSUyQyUyMHRlbnNvcnMlMjBpbiUyMHN0YXRlX2RpY3Rfc3BsaXQuZmlsZW5hbWVfdG9fdGVuc29ycy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2hhcmQlMjAlM0QlMjAlN0J0ZW5zb3IlM0ElMjBzdGF0ZV9kaWN0JTVCdGVuc29yJTVEJTIwZm9yJTIwdGVuc29yJTIwaW4lMjB0ZW5zb3JzJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FmZV9zYXZlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2hhcmQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5wYXRoLmpvaW4oc2F2ZV9kaXJlY3RvcnklMkMlMjBmaWxlbmFtZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMmZvcm1hdCUyMiUzQSUyMCUyMnB0JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGlmJTIwc3RhdGVfZGljdF9zcGxpdC5pc19zaGFyZGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5kZXglMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXRhZGF0YSUyMiUzQSUyMHN0YXRlX2RpY3Rfc3BsaXQubWV0YWRhdGElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWlnaHRfbWFwJTIyJTNBJTIwc3RhdGVfZGljdF9zcGxpdC50ZW5zb3JfdG9fZmlsZW5hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihvcy5wYXRoLmpvaW4oc2F2ZV9kaXJlY3RvcnklMkMlMjAlMjJtb2RlbC5zYWZldGVuc29ycy5pbmRleC5qc29uJTIyKSUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKGluZGV4JTJDJTIwaW5kZW50JTNEMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> save_file <span class="hljs-keyword">as</span> safe_save_file
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> split_torch_state_dict_into_shards

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_state_dict</span>(<span class="hljs-params">state_dict: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor], save_directory: <span class="hljs-built_in">str</span></span>):
<span class="hljs-meta">... </span>    state_dict_split = split_torch_state_dict_into_shards(state_dict)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> filename, tensors <span class="hljs-keyword">in</span> state_dict_split.filename_to_tensors.items():
<span class="hljs-meta">... </span>        shard = {tensor: state_dict[tensor] <span class="hljs-keyword">for</span> tensor <span class="hljs-keyword">in</span> tensors}
<span class="hljs-meta">... </span>        safe_save_file(
<span class="hljs-meta">... </span>            shard,
<span class="hljs-meta">... </span>            os.path.join(save_directory, filename),
<span class="hljs-meta">... </span>            metadata={<span class="hljs-string">&quot;format&quot;</span>: <span class="hljs-string">&quot;pt&quot;</span>},
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> state_dict_split.is_sharded:
<span class="hljs-meta">... </span>        index = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;metadata&quot;</span>: state_dict_split.metadata,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;weight_map&quot;</span>: state_dict_split.tensor_to_filename,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(os.path.join(save_directory, <span class="hljs-string">&quot;model.safetensors.index.json&quot;</span>), <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>            f.write(json.dumps(index, indent=<span class="hljs-number">2</span>))`,wrap:!1}}),{c(){t=d("p"),t.textContent=g,n=o(),_(p.$$.fragment)},l(c){t=h(c,"P",{"data-svelte-h":!0}),m(t)!=="svelte-11lpom8"&&(t.textContent=g),n=i(c),f(p.$$.fragment,c)},m(c,x){l(c,t,x),l(c,n,x),u(p,c,x),w=!0},p:R,i(c){w||(b(p.$$.fragment,c),w=!0)},o(c){v(p.$$.fragment,c),w=!1},d(c){c&&(a(t),a(n)),$(p,c)}}}function js(y){let t,g=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=g},l(n){t=h(n,"P",{"data-svelte-h":!0}),m(t)!=="svelte-16sq104"&&(t.innerHTML=g)},m(n,p){l(n,t,p)},p:R,d(n){n&&a(t)}}}function Js(y){let t,g,n,p,w,c,x,Wt="<code>huggingface_hub</code> contains helpers to help ML libraries serialize models weights in a standardized way. This part of the lib is still under development and will be improved in future releases. The goal is to harmonize how weights are serialized on the Hub, both to remove code duplication across libraries and to foster conventions on the Hub.",Re,Y,Se,Q,Rt='The main helper of the <code>serialization</code> module takes a torch <code>nn.Module</code> as input and saves it to disk. It handles the logic to save shared tensors (see <a href="https://huggingface.co/docs/safetensors/torch_shared_tensors" rel="nofollow">safetensors explanation</a>) as well as logic to split the state dictionary into shards, using <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a> under the hood. At the moment, only <code>torch</code> framework is supported.',Ve,O,St='If you want to save a state dictionary (e.g. a mapping between layer names and related tensors) instead of a <code>nn.Module</code>, you can use <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_state_dict">save_torch_state_dict()</a> which provides the same features. This is useful for example if you want to apply custom logic to the state dict before saving it.',De,T,K,lt,be,Vt="Saves a given torch model to disk, handling sharding and shared tensors issues.",ct,ve,Dt='See also <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_state_dict">save_torch_state_dict()</a> to save a state dict with more flexibility.',dt,$e,Et='For more information about tensor sharing, check out <a href="https://huggingface.co/docs/safetensors/torch_shared_tensors" rel="nofollow">this guide</a>.',ht,we,Pt=`The model state dictionary is split into shards so that each shard is smaller than a given size. The shards are
saved in the <code>save_directory</code> with the given <code>filename_pattern</code>. If the model is too big to fit in a single shard,
an index file is saved in the <code>save_directory</code> to indicate where each tensor is saved. This helper uses
<a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a> under the hood. If <code>safe_serialization</code> is <code>True</code>, the shards are saved as
safetensors (the default). Otherwise, the shards are saved as pickle.`,pt,Te,qt="Before saving the model, the <code>save_directory</code> is cleaned from any previous shard files.",mt,S,gt,V,Ee,M,ee,_t,Me,Xt="Save a model state dictionary to the disk, handling sharding and shared tensors issues.",ft,ye,Nt='See also <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_model">save_torch_model()</a> to directly save a PyTorch model.',ut,xe,Ft='For more information about tensor sharing, check out <a href="https://huggingface.co/docs/safetensors/torch_shared_tensors" rel="nofollow">this guide</a>.',bt,je,Yt=`The model state dictionary is split into shards so that each shard is smaller than a given size. The shards are
saved in the <code>save_directory</code> with the given <code>filename_pattern</code>. If the model is too big to fit in a single shard,
an index file is saved in the <code>save_directory</code> to indicate where each tensor is saved. This helper uses
<a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a> under the hood. If <code>safe_serialization</code> is <code>True</code>, the shards are saved as
safetensors (the default). Otherwise, the shards are saved as pickle.`,vt,Je,Qt="Before saving the model, the <code>save_directory</code> is cleaned from any previous shard files.",$t,D,wt,E,Pe,te,qe,se,Ot="The <code>serialization</code> module also contains low-level helpers to split a state dictionary into several shards, while creating a proper index in the process. These helpers are available for <code>torch</code> and <code>tensorflow</code> tensors and are designed to be easily extended to any other ML frameworks.",Xe,ae,Ne,G,ne,Tt,ze,Kt="Split a model state dictionary in shards so that each shard is smaller than a given size.",Mt,Ie,es=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,yt,P,Fe,oe,Ye,z,ie,xt,Ge,ts="Split a model state dictionary in shards so that each shard is smaller than a given size.",jt,ke,ss=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,Jt,q,zt,X,It,N,Qe,re,Oe,le,as='This is the underlying factory from which each framework-specific helper is derived. In practice, you are not expected to use this factory directly except if you need to adapt it to a framework that is not yet supported. If that is the case, please let us know by <a href="https://github.com/huggingface/huggingface_hub/issues/new" rel="nofollow">opening a new issue</a> on the <code>huggingface_hub</code> repo.',Ke,k,ce,Gt,Be,ns="Split a model state dictionary in shards so that each shard is smaller than a given size.",kt,Ce,os=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,Bt,F,et,de,tt,he,st,B,pe,Ct,Ae,is="Return unique identifier to a tensor storage.",At,Ze,rs=`Multiple different tensors can share the same underlying storage. This identifier is
guaranteed to be unique and constant for this tensor’s storage during its lifetime. Two tensor storages with
non-overlapping lifetimes may have the same id.
In the case of meta tensors, we return None since we can’t tell if they share the same storage.`,Zt,Le,ls='Taken from <a href="https://github.com/huggingface/transformers/blob/1ecf5f7c982d761b4daaa96719d162c324187c64/src/transformers/pytorch_utils.py#L278" rel="nofollow">https://github.com/huggingface/transformers/blob/1ecf5f7c982d761b4daaa96719d162c324187c64/src/transformers/pytorch_utils.py#L278</a>.',at,me,nt,L,ge,Lt,He,cs='Taken from <a href="https://github.com/huggingface/safetensors/blob/08db34094e9e59e2f9218f2df133b7b4aaff5a99/bindings/python/py_src/safetensors/torch.py#L31C1-L41C59" rel="nofollow">https://github.com/huggingface/safetensors/blob/08db34094e9e59e2f9218f2df133b7b4aaff5a99/bindings/python/py_src/safetensors/torch.py#L31C1-L41C59</a>',ot,_e,it,We,rt;return w=new W({props:{title:"Serialization",local:"serialization",headingTag:"h1"}}),Y=new W({props:{title:"Save torch state dict",local:"huggingface_hub.save_torch_model",headingTag:"h2"}}),K=new ue({props:{name:"huggingface_hub.save_torch_model",anchor:"huggingface_hub.save_torch_model",parameters:[{name:"model",val:": torch.nn.Module"},{name:"save_directory",val:": Union"},{name:"filename_pattern",val:": Optional = None"},{name:"force_contiguous",val:": bool = True"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"metadata",val:": Optional = None"},{name:"safe_serialization",val:": bool = True"},{name:"is_main_process",val:": bool = True"}],parametersDescription:[{anchor:"huggingface_hub.save_torch_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to save on disk.`,name:"model"},{anchor:"huggingface_hub.save_torch_model.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The directory in which the model will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.save_torch_model.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code> or <code>pytorch_model{suffix}.bin</code> depending on <code>safe_serialization</code>
parameter.`,name:"filename_pattern"},{anchor:"huggingface_hub.save_torch_model.force_contiguous",description:`<strong>force_contiguous</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Forcing the state_dict to be saved as contiguous tensors. This has no effect on the correctness of the
model, but it could potentially change performance if the layout of the tensor was chosen specifically for
that reason. Defaults to <code>True</code>.`,name:"force_contiguous"},{anchor:"huggingface_hub.save_torch_model.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"},{anchor:"huggingface_hub.save_torch_model.metadata",description:`<strong>metadata</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Extra information to save along with the model. Some metadata will be added for each dropped tensors.
This information will not be enough to recover the entire shared structure but might help understanding
things.`,name:"metadata"},{anchor:"huggingface_hub.save_torch_model.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to save as safetensors, which is the default behavior. If <code>False</code>, the shards are saved as pickle.
Safe serialization is recommended for security reasons. Saving as pickle is deprecated and will be removed
in a future version.`,name:"safe_serialization"},{anchor:"huggingface_hub.save_torch_model.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the process calling this is the main process or not. Useful when in distributed training like
TPUs and need to call this function from all processes. In this case, set <code>is_main_process=True</code> only on
the main process to avoid race conditions. Defaults to True.`,name:"is_main_process"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L35"}}),S=new Ue({props:{warning:!0,$$slots:{default:[bs]},$$scope:{ctx:y}}}),V=new Ht({props:{anchor:"huggingface_hub.save_torch_model.example",$$slots:{default:[vs]},$$scope:{ctx:y}}}),ee=new ue({props:{name:"huggingface_hub.save_torch_state_dict",anchor:"huggingface_hub.save_torch_state_dict",parameters:[{name:"state_dict",val:": Dict"},{name:"save_directory",val:": Union"},{name:"filename_pattern",val:": Optional = None"},{name:"force_contiguous",val:": bool = True"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"metadata",val:": Optional = None"},{name:"safe_serialization",val:": bool = True"},{name:"is_main_process",val:": bool = True"}],parametersDescription:[{anchor:"huggingface_hub.save_torch_state_dict.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.save_torch_state_dict.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The directory in which the model will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.save_torch_state_dict.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code> or <code>pytorch_model{suffix}.bin</code> depending on <code>safe_serialization</code>
parameter.`,name:"filename_pattern"},{anchor:"huggingface_hub.save_torch_state_dict.force_contiguous",description:`<strong>force_contiguous</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Forcing the state_dict to be saved as contiguous tensors. This has no effect on the correctness of the
model, but it could potentially change performance if the layout of the tensor was chosen specifically for
that reason. Defaults to <code>True</code>.`,name:"force_contiguous"},{anchor:"huggingface_hub.save_torch_state_dict.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"},{anchor:"huggingface_hub.save_torch_state_dict.metadata",description:`<strong>metadata</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Extra information to save along with the model. Some metadata will be added for each dropped tensors.
This information will not be enough to recover the entire shared structure but might help understanding
things.`,name:"metadata"},{anchor:"huggingface_hub.save_torch_state_dict.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to save as safetensors, which is the default behavior. If <code>False</code>, the shards are saved as pickle.
Safe serialization is recommended for security reasons. Saving as pickle is deprecated and will be removed
in a future version.`,name:"safe_serialization"},{anchor:"huggingface_hub.save_torch_state_dict.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the process calling this is the main process or not. Useful when in distributed training like
TPUs and need to call this function from all processes. In this case, set <code>is_main_process=True</code> only on
the main process to avoid race conditions. Defaults to True.`,name:"is_main_process"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L124"}}),D=new Ue({props:{warning:!0,$$slots:{default:[$s]},$$scope:{ctx:y}}}),E=new Ht({props:{anchor:"huggingface_hub.save_torch_state_dict.example",$$slots:{default:[ws]},$$scope:{ctx:y}}}),te=new W({props:{title:"Split state dict into shards",local:"split-state-dict-into-shards",headingTag:"h2"}}),ae=new W({props:{title:"split_tf_state_dict_into_shards",local:"huggingface_hub.split_tf_state_dict_into_shards",headingTag:"h3"}}),ne=new ue({props:{name:"huggingface_hub.split_tf_state_dict_into_shards",anchor:"huggingface_hub.split_tf_state_dict_into_shards",parameters:[{name:"state_dict",val:": Dict"},{name:"filename_pattern",val:": str = 'tf_model{suffix}.h5'"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_tf_state_dict_into_shards.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_tf_state_dict_into_shards.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;tf_model{suffix}.h5&quot;</code>.`,name:"filename_pattern"},{anchor:"huggingface_hub.split_tf_state_dict_into_shards.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_tensorflow.py#L28",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),P=new Ue({props:{warning:!0,$$slots:{default:[Ts]},$$scope:{ctx:y}}}),oe=new W({props:{title:"split_torch_state_dict_into_shards",local:"huggingface_hub.split_torch_state_dict_into_shards",headingTag:"h3"}}),ie=new ue({props:{name:"huggingface_hub.split_torch_state_dict_into_shards",anchor:"huggingface_hub.split_torch_state_dict_into_shards",parameters:[{name:"state_dict",val:": Dict"},{name:"filename_pattern",val:": str = 'model{suffix}.safetensors'"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_torch_state_dict_into_shards.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_torch_state_dict_into_shards.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code>.`,name:"filename_pattern"},{anchor:"huggingface_hub.split_torch_state_dict_into_shards.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L276",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),q=new Ue({props:{$$slots:{default:[Ms]},$$scope:{ctx:y}}}),X=new Ue({props:{warning:!0,$$slots:{default:[ys]},$$scope:{ctx:y}}}),N=new Ht({props:{anchor:"huggingface_hub.split_torch_state_dict_into_shards.example",$$slots:{default:[xs]},$$scope:{ctx:y}}}),re=new W({props:{title:"split_state_dict_into_shards_factory",local:"huggingface_hub.split_state_dict_into_shards_factory",headingTag:"h3"}}),ce=new ue({props:{name:"huggingface_hub.split_state_dict_into_shards_factory",anchor:"huggingface_hub.split_state_dict_into_shards_factory",parameters:[{name:"state_dict",val:": Dict"},{name:"get_storage_size",val:": Callable"},{name:"filename_pattern",val:": str"},{name:"get_storage_id",val:": Callable = <function <lambda> at 0x7fee62bd7a30>"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_state_dict_into_shards_factory.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.get_storage_size",description:`<strong>get_storage_size</strong> (<code>Callable[[Tensor], int]</code>) &#x2014;
A function that returns the size of a tensor when saved on disk in bytes.`,name:"get_storage_size"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.get_storage_id",description:`<strong>get_storage_id</strong> (<code>Callable[[Tensor], Optional[Any]]</code>, <em>optional</em>) &#x2014;
A function that returns a unique identifier to a tensor storage. Multiple different tensors can share the
same underlying storage. This identifier is guaranteed to be unique and constant for this tensor&#x2019;s storage
during its lifetime. Two tensor storages with non-overlapping lifetimes may have the same id.`,name:"get_storage_id"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>`,name:"filename_pattern"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_base.py#L49",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),F=new Ue({props:{warning:!0,$$slots:{default:[js]},$$scope:{ctx:y}}}),de=new W({props:{title:"Helpers",local:"helpers",headingTag:"h2"}}),he=new W({props:{title:"get_torch_storage_id",local:"huggingface_hub.get_torch_storage_id",headingTag:"h3"}}),pe=new ue({props:{name:"huggingface_hub.get_torch_storage_id",anchor:"huggingface_hub.get_torch_storage_id",parameters:[{name:"tensor",val:": torch.Tensor"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L384"}}),me=new W({props:{title:"get_torch_storage_size",local:"huggingface_hub.get_torch_storage_size",headingTag:"h3"}}),ge=new ue({props:{name:"huggingface_hub.get_torch_storage_size",anchor:"huggingface_hub.get_torch_storage_size",parameters:[{name:"tensor",val:": torch.Tensor"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L401"}}),_e=new us({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/serialization.md"}}),{c(){t=d("meta"),g=o(),n=d("p"),p=o(),_(w.$$.fragment),c=o(),x=d("p"),x.innerHTML=Wt,Re=o(),_(Y.$$.fragment),Se=o(),Q=d("p"),Q.innerHTML=Rt,Ve=o(),O=d("p"),O.innerHTML=St,De=o(),T=d("div"),_(K.$$.fragment),lt=o(),be=d("p"),be.textContent=Vt,ct=o(),ve=d("p"),ve.innerHTML=Dt,dt=o(),$e=d("p"),$e.innerHTML=Et,ht=o(),we=d("p"),we.innerHTML=Pt,pt=o(),Te=d("p"),Te.innerHTML=qt,mt=o(),_(S.$$.fragment),gt=o(),_(V.$$.fragment),Ee=o(),M=d("div"),_(ee.$$.fragment),_t=o(),Me=d("p"),Me.textContent=Xt,ft=o(),ye=d("p"),ye.innerHTML=Nt,ut=o(),xe=d("p"),xe.innerHTML=Ft,bt=o(),je=d("p"),je.innerHTML=Yt,vt=o(),Je=d("p"),Je.innerHTML=Qt,$t=o(),_(D.$$.fragment),wt=o(),_(E.$$.fragment),Pe=o(),_(te.$$.fragment),qe=o(),se=d("p"),se.innerHTML=Ot,Xe=o(),_(ae.$$.fragment),Ne=o(),G=d("div"),_(ne.$$.fragment),Tt=o(),ze=d("p"),ze.textContent=Kt,Mt=o(),Ie=d("p"),Ie.innerHTML=es,yt=o(),_(P.$$.fragment),Fe=o(),_(oe.$$.fragment),Ye=o(),z=d("div"),_(ie.$$.fragment),xt=o(),Ge=d("p"),Ge.textContent=ts,jt=o(),ke=d("p"),ke.innerHTML=ss,Jt=o(),_(q.$$.fragment),zt=o(),_(X.$$.fragment),It=o(),_(N.$$.fragment),Qe=o(),_(re.$$.fragment),Oe=o(),le=d("p"),le.innerHTML=as,Ke=o(),k=d("div"),_(ce.$$.fragment),Gt=o(),Be=d("p"),Be.textContent=ns,kt=o(),Ce=d("p"),Ce.innerHTML=os,Bt=o(),_(F.$$.fragment),et=o(),_(de.$$.fragment),tt=o(),_(he.$$.fragment),st=o(),B=d("div"),_(pe.$$.fragment),Ct=o(),Ae=d("p"),Ae.textContent=is,At=o(),Ze=d("p"),Ze.textContent=rs,Zt=o(),Le=d("p"),Le.innerHTML=ls,at=o(),_(me.$$.fragment),nt=o(),L=d("div"),_(ge.$$.fragment),Lt=o(),He=d("p"),He.innerHTML=cs,ot=o(),_(_e.$$.fragment),it=o(),We=d("p"),this.h()},l(e){const s=fs("svelte-u9bgzb",document.head);t=h(s,"META",{name:!0,content:!0}),s.forEach(a),g=i(e),n=h(e,"P",{}),H(n).forEach(a),p=i(e),f(w.$$.fragment,e),c=i(e),x=h(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-pikz64"&&(x.innerHTML=Wt),Re=i(e),f(Y.$$.fragment,e),Se=i(e),Q=h(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1gnm445"&&(Q.innerHTML=Rt),Ve=i(e),O=h(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1mocwb"&&(O.innerHTML=St),De=i(e),T=h(e,"DIV",{class:!0});var j=H(T);f(K.$$.fragment,j),lt=i(j),be=h(j,"P",{"data-svelte-h":!0}),m(be)!=="svelte-ts5jcq"&&(be.textContent=Vt),ct=i(j),ve=h(j,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-12jpcei"&&(ve.innerHTML=Dt),dt=i(j),$e=h(j,"P",{"data-svelte-h":!0}),m($e)!=="svelte-hxbjn2"&&($e.innerHTML=Et),ht=i(j),we=h(j,"P",{"data-svelte-h":!0}),m(we)!=="svelte-b08cux"&&(we.innerHTML=Pt),pt=i(j),Te=h(j,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-zotpm4"&&(Te.innerHTML=qt),mt=i(j),f(S.$$.fragment,j),gt=i(j),f(V.$$.fragment,j),j.forEach(a),Ee=i(e),M=h(e,"DIV",{class:!0});var J=H(M);f(ee.$$.fragment,J),_t=i(J),Me=h(J,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1hwpwyy"&&(Me.textContent=Xt),ft=i(J),ye=h(J,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1sy8rkx"&&(ye.innerHTML=Nt),ut=i(J),xe=h(J,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-hxbjn2"&&(xe.innerHTML=Ft),bt=i(J),je=h(J,"P",{"data-svelte-h":!0}),m(je)!=="svelte-b08cux"&&(je.innerHTML=Yt),vt=i(J),Je=h(J,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-zotpm4"&&(Je.innerHTML=Qt),$t=i(J),f(D.$$.fragment,J),wt=i(J),f(E.$$.fragment,J),J.forEach(a),Pe=i(e),f(te.$$.fragment,e),qe=i(e),se=h(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1jvx2r9"&&(se.innerHTML=Ot),Xe=i(e),f(ae.$$.fragment,e),Ne=i(e),G=h(e,"DIV",{class:!0});var C=H(G);f(ne.$$.fragment,C),Tt=i(C),ze=h(C,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1q1pe7b"&&(ze.textContent=Kt),Mt=i(C),Ie=h(C,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-17rio2z"&&(Ie.innerHTML=es),yt=i(C),f(P.$$.fragment,C),C.forEach(a),Fe=i(e),f(oe.$$.fragment,e),Ye=i(e),z=h(e,"DIV",{class:!0});var I=H(z);f(ie.$$.fragment,I),xt=i(I),Ge=h(I,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1q1pe7b"&&(Ge.textContent=ts),jt=i(I),ke=h(I,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-17rio2z"&&(ke.innerHTML=ss),Jt=i(I),f(q.$$.fragment,I),zt=i(I),f(X.$$.fragment,I),It=i(I),f(N.$$.fragment,I),I.forEach(a),Qe=i(e),f(re.$$.fragment,e),Oe=i(e),le=h(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1hva642"&&(le.innerHTML=as),Ke=i(e),k=h(e,"DIV",{class:!0});var A=H(k);f(ce.$$.fragment,A),Gt=i(A),Be=h(A,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1q1pe7b"&&(Be.textContent=ns),kt=i(A),Ce=h(A,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-17rio2z"&&(Ce.innerHTML=os),Bt=i(A),f(F.$$.fragment,A),A.forEach(a),et=i(e),f(de.$$.fragment,e),tt=i(e),f(he.$$.fragment,e),st=i(e),B=h(e,"DIV",{class:!0});var Z=H(B);f(pe.$$.fragment,Z),Ct=i(Z),Ae=h(Z,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-lfv2l4"&&(Ae.textContent=is),At=i(Z),Ze=h(Z,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1o86t9o"&&(Ze.textContent=rs),Zt=i(Z),Le=h(Z,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-akggeo"&&(Le.innerHTML=ls),Z.forEach(a),at=i(e),f(me.$$.fragment,e),nt=i(e),L=h(e,"DIV",{class:!0});var fe=H(L);f(ge.$$.fragment,fe),Lt=i(fe),He=h(fe,"P",{"data-svelte-h":!0}),m(He)!=="svelte-1ey7lf2"&&(He.innerHTML=cs),fe.forEach(a),ot=i(e),f(_e.$$.fragment,e),it=i(e),We=h(e,"P",{}),H(We).forEach(a),this.h()},h(){U(t,"name","hf:doc:metadata"),U(t,"content",zs),U(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){r(document.head,t),l(e,g,s),l(e,n,s),l(e,p,s),u(w,e,s),l(e,c,s),l(e,x,s),l(e,Re,s),u(Y,e,s),l(e,Se,s),l(e,Q,s),l(e,Ve,s),l(e,O,s),l(e,De,s),l(e,T,s),u(K,T,null),r(T,lt),r(T,be),r(T,ct),r(T,ve),r(T,dt),r(T,$e),r(T,ht),r(T,we),r(T,pt),r(T,Te),r(T,mt),u(S,T,null),r(T,gt),u(V,T,null),l(e,Ee,s),l(e,M,s),u(ee,M,null),r(M,_t),r(M,Me),r(M,ft),r(M,ye),r(M,ut),r(M,xe),r(M,bt),r(M,je),r(M,vt),r(M,Je),r(M,$t),u(D,M,null),r(M,wt),u(E,M,null),l(e,Pe,s),u(te,e,s),l(e,qe,s),l(e,se,s),l(e,Xe,s),u(ae,e,s),l(e,Ne,s),l(e,G,s),u(ne,G,null),r(G,Tt),r(G,ze),r(G,Mt),r(G,Ie),r(G,yt),u(P,G,null),l(e,Fe,s),u(oe,e,s),l(e,Ye,s),l(e,z,s),u(ie,z,null),r(z,xt),r(z,Ge),r(z,jt),r(z,ke),r(z,Jt),u(q,z,null),r(z,zt),u(X,z,null),r(z,It),u(N,z,null),l(e,Qe,s),u(re,e,s),l(e,Oe,s),l(e,le,s),l(e,Ke,s),l(e,k,s),u(ce,k,null),r(k,Gt),r(k,Be),r(k,kt),r(k,Ce),r(k,Bt),u(F,k,null),l(e,et,s),u(de,e,s),l(e,tt,s),u(he,e,s),l(e,st,s),l(e,B,s),u(pe,B,null),r(B,Ct),r(B,Ae),r(B,At),r(B,Ze),r(B,Zt),r(B,Le),l(e,at,s),u(me,e,s),l(e,nt,s),l(e,L,s),u(ge,L,null),r(L,Lt),r(L,He),l(e,ot,s),u(_e,e,s),l(e,it,s),l(e,We,s),rt=!0},p(e,[s]){const j={};s&2&&(j.$$scope={dirty:s,ctx:e}),S.$set(j);const J={};s&2&&(J.$$scope={dirty:s,ctx:e}),V.$set(J);const C={};s&2&&(C.$$scope={dirty:s,ctx:e}),D.$set(C);const I={};s&2&&(I.$$scope={dirty:s,ctx:e}),E.$set(I);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),P.$set(A);const Z={};s&2&&(Z.$$scope={dirty:s,ctx:e}),q.$set(Z);const fe={};s&2&&(fe.$$scope={dirty:s,ctx:e}),X.$set(fe);const ds={};s&2&&(ds.$$scope={dirty:s,ctx:e}),N.$set(ds);const hs={};s&2&&(hs.$$scope={dirty:s,ctx:e}),F.$set(hs)},i(e){rt||(b(w.$$.fragment,e),b(Y.$$.fragment,e),b(K.$$.fragment,e),b(S.$$.fragment,e),b(V.$$.fragment,e),b(ee.$$.fragment,e),b(D.$$.fragment,e),b(E.$$.fragment,e),b(te.$$.fragment,e),b(ae.$$.fragment,e),b(ne.$$.fragment,e),b(P.$$.fragment,e),b(oe.$$.fragment,e),b(ie.$$.fragment,e),b(q.$$.fragment,e),b(X.$$.fragment,e),b(N.$$.fragment,e),b(re.$$.fragment,e),b(ce.$$.fragment,e),b(F.$$.fragment,e),b(de.$$.fragment,e),b(he.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),b(ge.$$.fragment,e),b(_e.$$.fragment,e),rt=!0)},o(e){v(w.$$.fragment,e),v(Y.$$.fragment,e),v(K.$$.fragment,e),v(S.$$.fragment,e),v(V.$$.fragment,e),v(ee.$$.fragment,e),v(D.$$.fragment,e),v(E.$$.fragment,e),v(te.$$.fragment,e),v(ae.$$.fragment,e),v(ne.$$.fragment,e),v(P.$$.fragment,e),v(oe.$$.fragment,e),v(ie.$$.fragment,e),v(q.$$.fragment,e),v(X.$$.fragment,e),v(N.$$.fragment,e),v(re.$$.fragment,e),v(ce.$$.fragment,e),v(F.$$.fragment,e),v(de.$$.fragment,e),v(he.$$.fragment,e),v(pe.$$.fragment,e),v(me.$$.fragment,e),v(ge.$$.fragment,e),v(_e.$$.fragment,e),rt=!1},d(e){e&&(a(g),a(n),a(p),a(c),a(x),a(Re),a(Se),a(Q),a(Ve),a(O),a(De),a(T),a(Ee),a(M),a(Pe),a(qe),a(se),a(Xe),a(Ne),a(G),a(Fe),a(Ye),a(z),a(Qe),a(Oe),a(le),a(Ke),a(k),a(et),a(tt),a(st),a(B),a(at),a(nt),a(L),a(ot),a(it),a(We)),a(t),$(w,e),$(Y,e),$(K),$(S),$(V),$(ee),$(D),$(E),$(te,e),$(ae,e),$(ne),$(P),$(oe,e),$(ie),$(q),$(X),$(N),$(re,e),$(ce),$(F),$(de,e),$(he,e),$(pe),$(me,e),$(ge),$(_e,e)}}}const zs='{"title":"Serialization","local":"serialization","sections":[{"title":"Save torch state dict","local":"huggingface_hub.save_torch_model","sections":[],"depth":2},{"title":"Split state dict into shards","local":"split-state-dict-into-shards","sections":[{"title":"split_tf_state_dict_into_shards","local":"huggingface_hub.split_tf_state_dict_into_shards","sections":[],"depth":3},{"title":"split_torch_state_dict_into_shards","local":"huggingface_hub.split_torch_state_dict_into_shards","sections":[],"depth":3},{"title":"split_state_dict_into_shards_factory","local":"huggingface_hub.split_state_dict_into_shards_factory","sections":[],"depth":3}],"depth":2},{"title":"Helpers","local":"helpers","sections":[{"title":"get_torch_storage_id","local":"huggingface_hub.get_torch_storage_id","sections":[],"depth":3},{"title":"get_torch_storage_size","local":"huggingface_hub.get_torch_storage_size","sections":[],"depth":3}],"depth":2}],"depth":1}';function Is(y){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends gs{constructor(t){super(),_s(this,t,Is,Js,ps,{})}}export{Hs as component};
