import{s as Do,o as Ko,n as X}from"../chunks/scheduler.9bc65507.js";import{S as es,i as ts,g as l,s,r as u,A as ns,h as d,f as a,c as r,j as w,u as f,x as h,k as $,y as n,a as m,v as g,d as _,t as M,w as b}from"../chunks/index.707bf1b6.js";import{T as It}from"../chunks/Tip.c2ecdbf4.js";import{D as E}from"../chunks/Docstring.17db21ae.js";import{C as Zt}from"../chunks/CodeBlock.54a9f38d.js";import{E as Wt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as A}from"../chunks/Heading.342b1fa6.js";function os(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=y},l(c){t=d(c,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(c,p){m(c,t,p)},p:X,d(c){c&&a(t)}}}function ss(v){let t,y="Example:",c,p,T;return p=new Zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMModel.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=l("p"),t.textContent=y,c=s(),u(p.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),c=r(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,c,k),g(p,o,k),T=!0},p:X,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(a(t),a(c)),b(p,o)}}}function rs(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=y},l(c){t=d(c,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(c,p){m(c,t,p)},p:X,d(c){c&&a(t)}}}function as(v){let t,y="Example of single-label classification:",c,p,T;return p=new Zt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=l("p"),t.textContent=y,c=s(),u(p.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-ykxpe4"&&(t.textContent=y),c=r(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,c,k),g(p,o,k),T=!0},p:X,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(a(t),a(c)),b(p,o)}}}function is(v){let t,y="Example of multi-label classification:",c,p,T;return p=new Zt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=l("p"),t.textContent=y,c=s(),u(p.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1l8e32d"&&(t.textContent=y),c=r(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,c,k),g(p,o,k),T=!0},p:X,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(a(t),a(c)),b(p,o)}}}function ls(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=y},l(c){t=d(c,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(c,p){m(c,t,p)},p:X,d(c){c&&a(t)}}}function ds(v){let t,y="Example:",c,p,T;return p=new Zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JNdWx0aXBsZUNob2ljZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJJbiUyMEl0YWx5JTJDJTIwcGl6emElMjBzZXJ2ZWQlMjBpbiUyMGZvcm1hbCUyMHNldHRpbmdzJTJDJTIwc3VjaCUyMGFzJTIwYXQlMjBhJTIwcmVzdGF1cmFudCUyQyUyMGlzJTIwcHJlc2VudGVkJTIwdW5zbGljZWQuJTIyJTBBY2hvaWNlMCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdpdGglMjBhJTIwZm9yayUyMGFuZCUyMGElMjBrbmlmZS4lMjIlMEFjaG9pY2UxJTIwJTNEJTIwJTIySXQlMjBpcyUyMGVhdGVuJTIwd2hpbGUlMjBoZWxkJTIwaW4lMjB0aGUlMjBoYW5kLiUyMiUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvcigwKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBjaG9pY2UwJTIwaXMlMjBjb3JyZWN0JTIwKGFjY29yZGluZyUyMHRvJTIwV2lraXBlZGlhJTIwJTNCKSklMkMlMjBiYXRjaCUyMHNpemUlMjAxJTBBJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoJTVCcHJvbXB0JTJDJTIwcHJvbXB0JTVEJTJDJTIwJTVCY2hvaWNlMCUyQyUyMGNob2ljZTElNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQSUyMHYudW5zcXVlZXplKDApJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklN0QlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTIwJTIwJTIzJTIwYmF0Y2glMjBzaXplJTIwaXMlMjAxJTBBJTBBJTIzJTIwdGhlJTIwbGluZWFyJTIwY2xhc3NpZmllciUyMHN0aWxsJTIwbmVlZHMlMjB0byUyMGJlJTIwdHJhaW5lZCUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=l("p"),t.textContent=y,c=s(),u(p.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),c=r(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,c,k),g(p,o,k),T=!0},p:X,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(a(t),a(c)),b(p,o)}}}function cs(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=y},l(c){t=d(c,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(c,p){m(c,t,p)},p:X,d(c){c&&a(t)}}}function ps(v){let t,y="Example:",c,p,T;return p=new Zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForTokenClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=l("p"),t.textContent=y,c=s(),u(p.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),c=r(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,c,k),g(p,o,k),T=!0},p:X,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(a(t),a(c)),b(p,o)}}}function ms(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=y},l(c){t=d(c,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(c,p){m(c,t,p)},p:X,d(c){c&&a(t)}}}function hs(v){let t,y="Example:",c,p,T;return p=new Zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){t=l("p"),t.textContent=y,c=s(),u(p.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),c=r(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,c,k),g(p,o,k),T=!0},p:X,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(a(t),a(c)),b(p,o)}}}function us(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=l("p"),t.innerHTML=y},l(c){t=d(c,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(c,p){m(c,t,p)},p:X,d(c){c&&a(t)}}}function fs(v){let t,y,c,p,T,o,k,Ht,Me,ho=`The ErnieM model was proposed in <a href="https://arxiv.org/abs/2012.15674" rel="nofollow">ERNIE-M: Enhanced Multilingual Representation by Aligning
Cross-lingual Semantics with Monolingual Corpora</a>  by Xuan Ouyang, Shuohuan Wang, Chao Pang, Yu Sun,
Hao Tian, Hua Wu, Haifeng Wang.`,Vt,be,uo="The abstract from the paper is the following:",Gt,ye,fo="<em>Recent studies have demonstrated that pre-trained cross-lingual models achieve impressive performance in downstream cross-lingual tasks. This improvement benefits from learning a large amount of monolingual and parallel corpora. Although it is generally acknowledged that parallel corpora are critical for improving the model performance, existing methods are often constrained by the size of parallel corpora, especially for lowresource languages. In this paper, we propose ERNIE-M, a new training method that encourages the model to align the representation of multiple languages with monolingual corpora, to overcome the constraint that the parallel corpus size places on the model performance. Our key insight is to integrate back-translation into the pre-training process. We generate pseudo-parallel sentence pairs on a monolingual corpus to enable the learning of semantic alignments between different languages, thereby enhancing the semantic modeling of cross-lingual models. Experimental results show that ERNIE-M outperforms existing cross-lingual models and delivers new state-of-the-art results in various cross-lingual downstream tasks.</em>",Bt,Te,go="Tips:",Lt,ke,_o="<li>Ernie-M is a BERT-like model so it is a stacked Transformer Encoder.</li> <li>Instead of using MaskedLM for pretraining (like BERT) the authors used two novel techniques: <code>Cross-attention Masked Language Modeling</code> and <code>Back-translation Masked Language Modeling</code>. For now these two LMHead objectives are not implemented here.</li> <li>It is a multilingual language model.</li> <li>Next Sentence Prediction was not used in pretraining process.</li>",Rt,ve,Mo='This model was contributed by <a href="https://huggingface.co/susnato" rel="nofollow">Susnato Dhar</a>. The original code can be found <a href="https://github.com/PaddlePaddle/PaddleNLP/tree/develop/paddlenlp/transformers/ernie_m" rel="nofollow">here</a>.',Xt,we,St,$e,bo='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/multiple_choice">Multiple choice task guide</a></li>',Qt,Ee,Pt,Z,xe,mn,et,yo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>. It is used to instantiate a
Ernie-M model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <code>Ernie-M</code> <a href="https://huggingface.co/susnato/ernie-m-base_pytorch" rel="nofollow">susnato/ernie-m-base_pytorch</a> architecture.`,hn,tt,To=`Configuration objects inherit from <a href="/docs/transformers/v4.34.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,un,nt,ko=`A normal_initializer initializes weight matrices as normal distributions. See
<code>ErnieMPretrainedModel._init_weights()</code> for how weights are initialized in <code>ErnieMModel</code>.`,At,Ce,Yt,x,je,fn,ot,vo="Constructs a Ernie-M tokenizer. It uses the <code>sentencepiece</code> tools to cut the words to sub-words.",gn,Y,Je,_n,st,wo=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An ErnieM sequence has the following format:`,Mn,rt,$o="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] [SEP] B [SEP]</code></li>",bn,ne,ze,yn,at,Eo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>encode</code> method.`,Tn,oe,Ue,kn,it,xo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a> Should be overridden in a subclass if the model has a special way of
building: those.`,vn,lt,Fe,Ot,Ie,Dt,C,We,wn,dt,Co="The bare ErnieM Model transformer outputting raw hidden-states without any specific head on top.",$n,ct,jo=`This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,En,pt,Jo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,xn,G,Ze,Cn,mt,zo='The <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> forward method, overrides the <code>__call__</code> special method.',jn,se,Jn,re,Kt,Ne,en,j,qe,zn,ht,Uo=`ErnieM Model transformer with a sequence classification/regression head on top (a linear layer on top of
the pooled output) e.g. for GLUE tasks.`,Un,ut,Fo=`This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Fn,ft,Io=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,In,W,He,Wn,gt,Wo='The <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMForSequenceClassification">ErnieMForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Zn,ae,Nn,ie,qn,le,tn,Ve,nn,J,Ge,Hn,_t,Zo=`ErnieM Model with a multiple choice classification head on top (a linear layer on top of
the pooled output and a softmax) e.g. for RocStories/SWAG tasks.`,Vn,Mt,No=`This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Gn,bt,qo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Bn,B,Be,Ln,yt,Ho='The <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMForMultipleChoice">ErnieMForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',Rn,de,Xn,ce,on,Le,sn,z,Re,Sn,Tt,Vo=`ErnieM Model with a token classification head on top (a linear layer on top of
the hidden-states output) e.g. for Named-Entity-Recognition (NER) tasks.`,Qn,kt,Go=`This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pn,vt,Bo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,An,L,Xe,Yn,wt,Lo='The <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMForTokenClassification">ErnieMForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',On,pe,Dn,me,rn,Se,an,U,Qe,Kn,$t,Ro=`ErnieM Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,eo,Et,Xo=`This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,to,xt,So=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,no,R,Pe,oo,Ct,Qo='The <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMForQuestionAnswering">ErnieMForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',so,he,ro,ue,ln,Ae,dn,F,Ye,ao,jt,Po=`ErnieMForInformationExtraction is a Ernie-M Model with two linear layer on top of the hidden-states output to
compute <code>start_prob</code> and <code>end_prob</code>, designed for Universal Information Extraction.`,io,Jt,Ao=`This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lo,zt,Yo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,co,O,Oe,po,Ut,Oo='The <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMForInformationExtraction">ErnieMForInformationExtraction</a> forward method, overrides the <code>__call__</code> special method.',mo,fe,cn,Nt,pn;return T=new A({props:{title:"ErnieM",local:"erniem",headingTag:"h1"}}),k=new A({props:{title:"Overview",local:"overview",headingTag:"h2"}}),we=new A({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),Ee=new A({props:{title:"ErnieMConfig",local:"transformers.ErnieMConfig",headingTag:"h2"}}),xe=new E({props:{name:"class transformers.ErnieMConfig",anchor:"transformers.ErnieMConfig",parameters:[{name:"vocab_size",val:": int = 250002"},{name:"hidden_size",val:": int = 768"},{name:"num_hidden_layers",val:": int = 12"},{name:"num_attention_heads",val:": int = 12"},{name:"intermediate_size",val:": int = 3072"},{name:"hidden_act",val:": str = 'gelu'"},{name:"hidden_dropout_prob",val:": float = 0.1"},{name:"attention_probs_dropout_prob",val:": float = 0.1"},{name:"max_position_embeddings",val:": int = 514"},{name:"initializer_range",val:": float = 0.02"},{name:"pad_token_id",val:": int = 1"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"classifier_dropout",val:" = None"},{name:"is_decoder",val:" = False"},{name:"act_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieMConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 250002) &#x2014;
Vocabulary size of <code>inputs_ids</code> in <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>. Also is the vocab size of token embedding matrix.
Defines the number of different tokens that can be represented by the <code>inputs_ids</code> passed when calling
<a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>.`,name:"vocab_size"},{anchor:"transformers.ErnieMConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the embedding layer, encoder layers and pooler layer.`,name:"hidden_size"},{anchor:"transformers.ErnieMConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.ErnieMConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.ErnieMConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the feed-forward (ff) layer in the encoder. Input tensors to feed-forward layers are
firstly projected from hidden_size to intermediate_size, and then projected back to hidden_size. Typically
intermediate_size is larger than hidden_size.`,name:"intermediate_size"},{anchor:"transformers.ErnieMConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function in the feed-forward layer. <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code> and any other torch
supported activation functions are supported.`,name:"hidden_act"},{anchor:"transformers.ErnieMConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.ErnieMConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability used in <code>MultiHeadAttention</code> in all encoder layers to drop some attention target.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.ErnieMConfig.act_dropout",description:`<strong>act_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This dropout probability is used in <code>ErnieMEncoderLayer</code> after activation.`,name:"act_dropout"},{anchor:"transformers.ErnieMConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum value of the dimensionality of position encoding, which dictates the maximum supported length
of an input sequence.`,name:"max_position_embeddings"},{anchor:"transformers.ErnieMConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.ErnieMConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"},{anchor:"transformers.ErnieMConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the normal initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ErnieMConfig.pad_token_id(int,",description:`<strong>pad_token_id(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The index of padding token in the token vocabulary.`,name:"pad_token_id(int,"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/configuration_ernie_m.py#L31"}}),Ce=new A({props:{title:"ErnieMTokenizer",local:"transformers.ErnieMTokenizer",headingTag:"h2"}}),je=new E({props:{name:"class transformers.ErnieMTokenizer",anchor:"transformers.ErnieMTokenizer",parameters:[{name:"sentencepiece_model_ckpt",val:""},{name:"vocab_file",val:" = None"},{name:"do_lower_case",val:" = False"},{name:"encoding",val:" = 'utf8'"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.sentencepiece_model_file",description:`<strong>sentencepiece_model_file</strong> (<code>str</code>) &#x2014;
The file path of sentencepiece model.`,name:"sentencepiece_model_file"},{anchor:"transformers.ErnieMTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file path of the vocabulary.`,name:"vocab_file"},{anchor:"transformers.ErnieMTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>str</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.ErnieMTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
A special token representing the <code>unknown (out-of-vocabulary)</code> token. An unknown token is set to be
<code>unk_token</code> inorder to be converted to an ID.`,name:"unk_token"},{anchor:"transformers.ErnieMTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
A special token separating two different sentences in the same input.`,name:"sep_token"},{anchor:"transformers.ErnieMTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
A special token used to make arrays of tokens the same size for batching purposes.`,name:"pad_token"},{anchor:"transformers.ErnieMTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
A special token used for sequence classification. It is the last token of the sequence when built with
special tokens.`,name:"cls_token"},{anchor:"transformers.ErnieMTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
A special token representing a masked token. This is the token used in the masked language modeling task
which the model tries to predict the original unmasked ones.`,name:"mask_token"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/tokenization_ernie_m.py#L62"}}),Je=new E({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/tokenization_ernie_m.py#L264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of input_id with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ze=new E({props:{name:"get_special_tokens_mask",anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"},{name:"already_has_special_tokens",val:" = False"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/tokenization_ernie_m.py#L307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ue=new E({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The first tokenized sequence.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The second tokenized sequence.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/tokenization_ernie_m.py#L336",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Fe=new E({props:{name:"save_vocabulary",anchor:"transformers.ErnieMTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/tokenization_ernie_m.py#L405"}}),Ie=new A({props:{title:"ErnieMModel",local:"transformers.ErnieMModel",headingTag:"h2"}}),We=new E({props:{name:"class transformers.ErnieMModel",anchor:"transformers.ErnieMModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.ErnieMModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L499"}}),Ze=new E({props:{name:"forward",anchor:"transformers.ErnieMModel.forward",parameters:[{name:"input_ids",val:": typing.Union[<built-in method tensor of type object at 0x7f8ee20979e0>, NoneType] = None"},{name:"position_ids",val:": typing.Union[<built-in method tensor of type object at 0x7f8ee20979e0>, NoneType] = None"},{name:"attention_mask",val:": typing.Union[<built-in method tensor of type object at 0x7f8ee20979e0>, NoneType] = None"},{name:"head_mask",val:": typing.Union[<built-in method tensor of type object at 0x7f8ee20979e0>, NoneType] = None"},{name:"inputs_embeds",val:": typing.Union[<built-in method tensor of type object at 0x7f8ee20979e0>, NoneType] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[<built-in method tensor of type object at 0x7f8ee20979e0>]], NoneType] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieMModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L522",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new It({props:{$$slots:{default:[os]},$$scope:{ctx:v}}}),re=new Wt({props:{anchor:"transformers.ErnieMModel.forward.example",$$slots:{default:[ss]},$$scope:{ctx:v}}}),Ne=new A({props:{title:"ErnieMForSequenceClassification",local:"transformers.ErnieMForSequenceClassification",headingTag:"h2"}}),qe=new E({props:{name:"class transformers.ErnieMForSequenceClassification",anchor:"transformers.ErnieMForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L613"}}),He=new E({props:{name:"forward",anchor:"transformers.ErnieMForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.ErnieMForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L630",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new It({props:{$$slots:{default:[rs]},$$scope:{ctx:v}}}),ie=new Wt({props:{anchor:"transformers.ErnieMForSequenceClassification.forward.example",$$slots:{default:[as]},$$scope:{ctx:v}}}),le=new Wt({props:{anchor:"transformers.ErnieMForSequenceClassification.forward.example-2",$$slots:{default:[is]},$$scope:{ctx:v}}}),Ve=new A({props:{title:"ErnieMForMultipleChoice",local:"transformers.ErnieMForMultipleChoice",headingTag:"h2"}}),Ge=new E({props:{name:"class transformers.ErnieMForMultipleChoice",anchor:"transformers.ErnieMForMultipleChoice",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L715"}}),Be=new E({props:{name:"forward",anchor:"transformers.ErnieMForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForMultipleChoice.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForMultipleChoice.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <code>num_choices</code> is the size of the second dimension of the input tensors. (See
<code>input_ids</code> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L730",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new It({props:{$$slots:{default:[ls]},$$scope:{ctx:v}}}),ce=new Wt({props:{anchor:"transformers.ErnieMForMultipleChoice.forward.example",$$slots:{default:[ds]},$$scope:{ctx:v}}}),Le=new A({props:{title:"ErnieMForTokenClassification",local:"transformers.ErnieMForTokenClassification",headingTag:"h2"}}),Re=new E({props:{name:"class transformers.ErnieMForTokenClassification",anchor:"transformers.ErnieMForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L805"}}),Xe=new E({props:{name:"forward",anchor:"transformers.ErnieMForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.ErnieMForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L821",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new It({props:{$$slots:{default:[cs]},$$scope:{ctx:v}}}),me=new Wt({props:{anchor:"transformers.ErnieMForTokenClassification.forward.example",$$slots:{default:[ps]},$$scope:{ctx:v}}}),Se=new A({props:{title:"ErnieMForQuestionAnswering",local:"transformers.ErnieMForQuestionAnswering",headingTag:"h2"}}),Qe=new E({props:{name:"class transformers.ErnieMForQuestionAnswering",anchor:"transformers.ErnieMForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L886"}}),Pe=new E({props:{name:"forward",anchor:"transformers.ErnieMForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L898",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new It({props:{$$slots:{default:[ms]},$$scope:{ctx:v}}}),ue=new Wt({props:{anchor:"transformers.ErnieMForQuestionAnswering.forward.example",$$slots:{default:[hs]},$$scope:{ctx:v}}}),Ae=new A({props:{title:"ErnieMForInformationExtraction",local:"transformers.ErnieMForInformationExtraction",headingTag:"h2"}}),Ye=new E({props:{name:"class transformers.ErnieMForInformationExtraction",anchor:"transformers.ErnieMForInformationExtraction",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForInformationExtraction.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L984"}}),Oe=new E({props:{name:"forward",anchor:"transformers.ErnieMForInformationExtraction.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForInformationExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForInformationExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForInformationExtraction.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForInformationExtraction.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForInformationExtraction.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForInformationExtraction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForInformationExtraction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForInformationExtraction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForInformationExtraction.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for position (index) for computing the start_positions loss. Position outside of the sequence are
not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ErnieMForInformationExtraction.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) for computing the end_positions loss. Position outside of the sequence are not
taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/ernie_m/modeling_ernie_m.py#L993"}}),fe=new It({props:{$$slots:{default:[us]},$$scope:{ctx:v}}}),{c(){t=l("meta"),y=s(),c=l("p"),p=s(),u(T.$$.fragment),o=s(),u(k.$$.fragment),Ht=s(),Me=l("p"),Me.innerHTML=ho,Vt=s(),be=l("p"),be.textContent=uo,Gt=s(),ye=l("p"),ye.innerHTML=fo,Bt=s(),Te=l("p"),Te.textContent=go,Lt=s(),ke=l("ol"),ke.innerHTML=_o,Rt=s(),ve=l("p"),ve.innerHTML=Mo,Xt=s(),u(we.$$.fragment),St=s(),$e=l("ul"),$e.innerHTML=bo,Qt=s(),u(Ee.$$.fragment),Pt=s(),Z=l("div"),u(xe.$$.fragment),mn=s(),et=l("p"),et.innerHTML=yo,hn=s(),tt=l("p"),tt.innerHTML=To,un=s(),nt=l("p"),nt.innerHTML=ko,At=s(),u(Ce.$$.fragment),Yt=s(),x=l("div"),u(je.$$.fragment),fn=s(),ot=l("p"),ot.innerHTML=vo,gn=s(),Y=l("div"),u(Je.$$.fragment),_n=s(),st=l("p"),st.textContent=wo,Mn=s(),rt=l("ul"),rt.innerHTML=$o,bn=s(),ne=l("div"),u(ze.$$.fragment),yn=s(),at=l("p"),at.innerHTML=Eo,Tn=s(),oe=l("div"),u(Ue.$$.fragment),kn=s(),it=l("p"),it.innerHTML=xo,vn=s(),lt=l("div"),u(Fe.$$.fragment),Ot=s(),u(Ie.$$.fragment),Dt=s(),C=l("div"),u(We.$$.fragment),wn=s(),dt=l("p"),dt.textContent=Co,$n=s(),ct=l("p"),ct.innerHTML=jo,En=s(),pt=l("p"),pt.innerHTML=Jo,xn=s(),G=l("div"),u(Ze.$$.fragment),Cn=s(),mt=l("p"),mt.innerHTML=zo,jn=s(),u(se.$$.fragment),Jn=s(),u(re.$$.fragment),Kt=s(),u(Ne.$$.fragment),en=s(),j=l("div"),u(qe.$$.fragment),zn=s(),ht=l("p"),ht.textContent=Uo,Un=s(),ut=l("p"),ut.innerHTML=Fo,Fn=s(),ft=l("p"),ft.innerHTML=Io,In=s(),W=l("div"),u(He.$$.fragment),Wn=s(),gt=l("p"),gt.innerHTML=Wo,Zn=s(),u(ae.$$.fragment),Nn=s(),u(ie.$$.fragment),qn=s(),u(le.$$.fragment),tn=s(),u(Ve.$$.fragment),nn=s(),J=l("div"),u(Ge.$$.fragment),Hn=s(),_t=l("p"),_t.textContent=Zo,Vn=s(),Mt=l("p"),Mt.innerHTML=No,Gn=s(),bt=l("p"),bt.innerHTML=qo,Bn=s(),B=l("div"),u(Be.$$.fragment),Ln=s(),yt=l("p"),yt.innerHTML=Ho,Rn=s(),u(de.$$.fragment),Xn=s(),u(ce.$$.fragment),on=s(),u(Le.$$.fragment),sn=s(),z=l("div"),u(Re.$$.fragment),Sn=s(),Tt=l("p"),Tt.textContent=Vo,Qn=s(),kt=l("p"),kt.innerHTML=Go,Pn=s(),vt=l("p"),vt.innerHTML=Bo,An=s(),L=l("div"),u(Xe.$$.fragment),Yn=s(),wt=l("p"),wt.innerHTML=Lo,On=s(),u(pe.$$.fragment),Dn=s(),u(me.$$.fragment),rn=s(),u(Se.$$.fragment),an=s(),U=l("div"),u(Qe.$$.fragment),Kn=s(),$t=l("p"),$t.innerHTML=Ro,eo=s(),Et=l("p"),Et.innerHTML=Xo,to=s(),xt=l("p"),xt.innerHTML=So,no=s(),R=l("div"),u(Pe.$$.fragment),oo=s(),Ct=l("p"),Ct.innerHTML=Qo,so=s(),u(he.$$.fragment),ro=s(),u(ue.$$.fragment),ln=s(),u(Ae.$$.fragment),dn=s(),F=l("div"),u(Ye.$$.fragment),ao=s(),jt=l("p"),jt.innerHTML=Po,io=s(),Jt=l("p"),Jt.innerHTML=Ao,lo=s(),zt=l("p"),zt.innerHTML=Yo,co=s(),O=l("div"),u(Oe.$$.fragment),po=s(),Ut=l("p"),Ut.innerHTML=Oo,mo=s(),u(fe.$$.fragment),cn=s(),Nt=l("p"),this.h()},l(e){const i=ns("svelte-u9bgzb",document.head);t=d(i,"META",{name:!0,content:!0}),i.forEach(a),y=r(e),c=d(e,"P",{}),w(c).forEach(a),p=r(e),f(T.$$.fragment,e),o=r(e),f(k.$$.fragment,e),Ht=r(e),Me=d(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-1leh8xw"&&(Me.innerHTML=ho),Vt=r(e),be=d(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-vfdo9a"&&(be.textContent=uo),Gt=r(e),ye=d(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-hvyogk"&&(ye.innerHTML=fo),Bt=r(e),Te=d(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-axv494"&&(Te.textContent=go),Lt=r(e),ke=d(e,"OL",{"data-svelte-h":!0}),h(ke)!=="svelte-539a85"&&(ke.innerHTML=_o),Rt=r(e),ve=d(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-ht78wx"&&(ve.innerHTML=Mo),Xt=r(e),f(we.$$.fragment,e),St=r(e),$e=d(e,"UL",{"data-svelte-h":!0}),h($e)!=="svelte-1521k64"&&($e.innerHTML=bo),Qt=r(e),f(Ee.$$.fragment,e),Pt=r(e),Z=d(e,"DIV",{class:!0});var S=w(Z);f(xe.$$.fragment,S),mn=r(S),et=d(S,"P",{"data-svelte-h":!0}),h(et)!=="svelte-1ffjsx0"&&(et.innerHTML=yo),hn=r(S),tt=d(S,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-1onjy9f"&&(tt.innerHTML=To),un=r(S),nt=d(S,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-199crak"&&(nt.innerHTML=ko),S.forEach(a),At=r(e),f(Ce.$$.fragment,e),Yt=r(e),x=d(e,"DIV",{class:!0});var I=w(x);f(je.$$.fragment,I),fn=r(I),ot=d(I,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-16hpk2a"&&(ot.innerHTML=vo),gn=r(I),Y=d(I,"DIV",{class:!0});var te=w(Y);f(Je.$$.fragment,te),_n=r(te),st=d(te,"P",{"data-svelte-h":!0}),h(st)!=="svelte-ld95nz"&&(st.textContent=wo),Mn=r(te),rt=d(te,"UL",{"data-svelte-h":!0}),h(rt)!=="svelte-fnydu1"&&(rt.innerHTML=$o),te.forEach(a),bn=r(I),ne=d(I,"DIV",{class:!0});var De=w(ne);f(ze.$$.fragment,De),yn=r(De),at=d(De,"P",{"data-svelte-h":!0}),h(at)!=="svelte-9bhc6n"&&(at.innerHTML=Eo),De.forEach(a),Tn=r(I),oe=d(I,"DIV",{class:!0});var Ke=w(oe);f(Ue.$$.fragment,Ke),kn=r(Ke),it=d(Ke,"P",{"data-svelte-h":!0}),h(it)!=="svelte-sahzwn"&&(it.innerHTML=xo),Ke.forEach(a),vn=r(I),lt=d(I,"DIV",{class:!0});var qt=w(lt);f(Fe.$$.fragment,qt),qt.forEach(a),I.forEach(a),Ot=r(e),f(Ie.$$.fragment,e),Dt=r(e),C=d(e,"DIV",{class:!0});var N=w(C);f(We.$$.fragment,N),wn=r(N),dt=d(N,"P",{"data-svelte-h":!0}),h(dt)!=="svelte-x3zjez"&&(dt.textContent=Co),$n=r(N),ct=d(N,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-l15rv1"&&(ct.innerHTML=jo),En=r(N),pt=d(N,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-68lg8f"&&(pt.innerHTML=Jo),xn=r(N),G=d(N,"DIV",{class:!0});var Q=w(G);f(Ze.$$.fragment,Q),Cn=r(Q),mt=d(Q,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-15zlr8d"&&(mt.innerHTML=zo),jn=r(Q),f(se.$$.fragment,Q),Jn=r(Q),f(re.$$.fragment,Q),Q.forEach(a),N.forEach(a),Kt=r(e),f(Ne.$$.fragment,e),en=r(e),j=d(e,"DIV",{class:!0});var q=w(j);f(qe.$$.fragment,q),zn=r(q),ht=d(q,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-jluzg6"&&(ht.textContent=Uo),Un=r(q),ut=d(q,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-l15rv1"&&(ut.innerHTML=Fo),Fn=r(q),ft=d(q,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-68lg8f"&&(ft.innerHTML=Io),In=r(q),W=d(q,"DIV",{class:!0});var H=w(W);f(He.$$.fragment,H),Wn=r(H),gt=d(H,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-1crvbrx"&&(gt.innerHTML=Wo),Zn=r(H),f(ae.$$.fragment,H),Nn=r(H),f(ie.$$.fragment,H),qn=r(H),f(le.$$.fragment,H),H.forEach(a),q.forEach(a),tn=r(e),f(Ve.$$.fragment,e),nn=r(e),J=d(e,"DIV",{class:!0});var V=w(J);f(Ge.$$.fragment,V),Hn=r(V),_t=d(V,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-d30d0y"&&(_t.textContent=Zo),Vn=r(V),Mt=d(V,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-l15rv1"&&(Mt.innerHTML=No),Gn=r(V),bt=d(V,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-68lg8f"&&(bt.innerHTML=qo),Bn=r(V),B=d(V,"DIV",{class:!0});var P=w(B);f(Be.$$.fragment,P),Ln=r(P),yt=d(P,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-onpufp"&&(yt.innerHTML=Ho),Rn=r(P),f(de.$$.fragment,P),Xn=r(P),f(ce.$$.fragment,P),P.forEach(a),V.forEach(a),on=r(e),f(Le.$$.fragment,e),sn=r(e),z=d(e,"DIV",{class:!0});var D=w(z);f(Re.$$.fragment,D),Sn=r(D),Tt=d(D,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-pdhuup"&&(Tt.textContent=Vo),Qn=r(D),kt=d(D,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-l15rv1"&&(kt.innerHTML=Go),Pn=r(D),vt=d(D,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-68lg8f"&&(vt.innerHTML=Bo),An=r(D),L=d(D,"DIV",{class:!0});var ge=w(L);f(Xe.$$.fragment,ge),Yn=r(ge),wt=d(ge,"P",{"data-svelte-h":!0}),h(wt)!=="svelte-8oiibh"&&(wt.innerHTML=Lo),On=r(ge),f(pe.$$.fragment,ge),Dn=r(ge),f(me.$$.fragment,ge),ge.forEach(a),D.forEach(a),rn=r(e),f(Se.$$.fragment,e),an=r(e),U=d(e,"DIV",{class:!0});var K=w(U);f(Qe.$$.fragment,K),Kn=r(K),$t=d(K,"P",{"data-svelte-h":!0}),h($t)!=="svelte-cu4xzn"&&($t.innerHTML=Ro),eo=r(K),Et=d(K,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-l15rv1"&&(Et.innerHTML=Xo),to=r(K),xt=d(K,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-68lg8f"&&(xt.innerHTML=So),no=r(K),R=d(K,"DIV",{class:!0});var _e=w(R);f(Pe.$$.fragment,_e),oo=r(_e),Ct=d(_e,"P",{"data-svelte-h":!0}),h(Ct)!=="svelte-a9ek3r"&&(Ct.innerHTML=Qo),so=r(_e),f(he.$$.fragment,_e),ro=r(_e),f(ue.$$.fragment,_e),_e.forEach(a),K.forEach(a),ln=r(e),f(Ae.$$.fragment,e),dn=r(e),F=d(e,"DIV",{class:!0});var ee=w(F);f(Ye.$$.fragment,ee),ao=r(ee),jt=d(ee,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-192fs6z"&&(jt.innerHTML=Po),io=r(ee),Jt=d(ee,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-l15rv1"&&(Jt.innerHTML=Ao),lo=r(ee),zt=d(ee,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-68lg8f"&&(zt.innerHTML=Yo),co=r(ee),O=d(ee,"DIV",{class:!0});var Ft=w(O);f(Oe.$$.fragment,Ft),po=r(Ft),Ut=d(Ft,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-zvuo8l"&&(Ut.innerHTML=Oo),mo=r(Ft),f(fe.$$.fragment,Ft),Ft.forEach(a),ee.forEach(a),cn=r(e),Nt=d(e,"P",{}),w(Nt).forEach(a),this.h()},h(){$(t,"name","hf:doc:metadata"),$(t,"content",gs),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){n(document.head,t),m(e,y,i),m(e,c,i),m(e,p,i),g(T,e,i),m(e,o,i),g(k,e,i),m(e,Ht,i),m(e,Me,i),m(e,Vt,i),m(e,be,i),m(e,Gt,i),m(e,ye,i),m(e,Bt,i),m(e,Te,i),m(e,Lt,i),m(e,ke,i),m(e,Rt,i),m(e,ve,i),m(e,Xt,i),g(we,e,i),m(e,St,i),m(e,$e,i),m(e,Qt,i),g(Ee,e,i),m(e,Pt,i),m(e,Z,i),g(xe,Z,null),n(Z,mn),n(Z,et),n(Z,hn),n(Z,tt),n(Z,un),n(Z,nt),m(e,At,i),g(Ce,e,i),m(e,Yt,i),m(e,x,i),g(je,x,null),n(x,fn),n(x,ot),n(x,gn),n(x,Y),g(Je,Y,null),n(Y,_n),n(Y,st),n(Y,Mn),n(Y,rt),n(x,bn),n(x,ne),g(ze,ne,null),n(ne,yn),n(ne,at),n(x,Tn),n(x,oe),g(Ue,oe,null),n(oe,kn),n(oe,it),n(x,vn),n(x,lt),g(Fe,lt,null),m(e,Ot,i),g(Ie,e,i),m(e,Dt,i),m(e,C,i),g(We,C,null),n(C,wn),n(C,dt),n(C,$n),n(C,ct),n(C,En),n(C,pt),n(C,xn),n(C,G),g(Ze,G,null),n(G,Cn),n(G,mt),n(G,jn),g(se,G,null),n(G,Jn),g(re,G,null),m(e,Kt,i),g(Ne,e,i),m(e,en,i),m(e,j,i),g(qe,j,null),n(j,zn),n(j,ht),n(j,Un),n(j,ut),n(j,Fn),n(j,ft),n(j,In),n(j,W),g(He,W,null),n(W,Wn),n(W,gt),n(W,Zn),g(ae,W,null),n(W,Nn),g(ie,W,null),n(W,qn),g(le,W,null),m(e,tn,i),g(Ve,e,i),m(e,nn,i),m(e,J,i),g(Ge,J,null),n(J,Hn),n(J,_t),n(J,Vn),n(J,Mt),n(J,Gn),n(J,bt),n(J,Bn),n(J,B),g(Be,B,null),n(B,Ln),n(B,yt),n(B,Rn),g(de,B,null),n(B,Xn),g(ce,B,null),m(e,on,i),g(Le,e,i),m(e,sn,i),m(e,z,i),g(Re,z,null),n(z,Sn),n(z,Tt),n(z,Qn),n(z,kt),n(z,Pn),n(z,vt),n(z,An),n(z,L),g(Xe,L,null),n(L,Yn),n(L,wt),n(L,On),g(pe,L,null),n(L,Dn),g(me,L,null),m(e,rn,i),g(Se,e,i),m(e,an,i),m(e,U,i),g(Qe,U,null),n(U,Kn),n(U,$t),n(U,eo),n(U,Et),n(U,to),n(U,xt),n(U,no),n(U,R),g(Pe,R,null),n(R,oo),n(R,Ct),n(R,so),g(he,R,null),n(R,ro),g(ue,R,null),m(e,ln,i),g(Ae,e,i),m(e,dn,i),m(e,F,i),g(Ye,F,null),n(F,ao),n(F,jt),n(F,io),n(F,Jt),n(F,lo),n(F,zt),n(F,co),n(F,O),g(Oe,O,null),n(O,po),n(O,Ut),n(O,mo),g(fe,O,null),m(e,cn,i),m(e,Nt,i),pn=!0},p(e,[i]){const S={};i&2&&(S.$$scope={dirty:i,ctx:e}),se.$set(S);const I={};i&2&&(I.$$scope={dirty:i,ctx:e}),re.$set(I);const te={};i&2&&(te.$$scope={dirty:i,ctx:e}),ae.$set(te);const De={};i&2&&(De.$$scope={dirty:i,ctx:e}),ie.$set(De);const Ke={};i&2&&(Ke.$$scope={dirty:i,ctx:e}),le.$set(Ke);const qt={};i&2&&(qt.$$scope={dirty:i,ctx:e}),de.$set(qt);const N={};i&2&&(N.$$scope={dirty:i,ctx:e}),ce.$set(N);const Q={};i&2&&(Q.$$scope={dirty:i,ctx:e}),pe.$set(Q);const q={};i&2&&(q.$$scope={dirty:i,ctx:e}),me.$set(q);const H={};i&2&&(H.$$scope={dirty:i,ctx:e}),he.$set(H);const V={};i&2&&(V.$$scope={dirty:i,ctx:e}),ue.$set(V);const P={};i&2&&(P.$$scope={dirty:i,ctx:e}),fe.$set(P)},i(e){pn||(_(T.$$.fragment,e),_(k.$$.fragment,e),_(we.$$.fragment,e),_(Ee.$$.fragment,e),_(xe.$$.fragment,e),_(Ce.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_(ze.$$.fragment,e),_(Ue.$$.fragment,e),_(Fe.$$.fragment,e),_(Ie.$$.fragment,e),_(We.$$.fragment,e),_(Ze.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(Ne.$$.fragment,e),_(qe.$$.fragment,e),_(He.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(Ve.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(Le.$$.fragment,e),_(Re.$$.fragment,e),_(Xe.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(Se.$$.fragment,e),_(Qe.$$.fragment,e),_(Pe.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(Ae.$$.fragment,e),_(Ye.$$.fragment,e),_(Oe.$$.fragment,e),_(fe.$$.fragment,e),pn=!0)},o(e){M(T.$$.fragment,e),M(k.$$.fragment,e),M(we.$$.fragment,e),M(Ee.$$.fragment,e),M(xe.$$.fragment,e),M(Ce.$$.fragment,e),M(je.$$.fragment,e),M(Je.$$.fragment,e),M(ze.$$.fragment,e),M(Ue.$$.fragment,e),M(Fe.$$.fragment,e),M(Ie.$$.fragment,e),M(We.$$.fragment,e),M(Ze.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(Ne.$$.fragment,e),M(qe.$$.fragment,e),M(He.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(le.$$.fragment,e),M(Ve.$$.fragment,e),M(Ge.$$.fragment,e),M(Be.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(Le.$$.fragment,e),M(Re.$$.fragment,e),M(Xe.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(Se.$$.fragment,e),M(Qe.$$.fragment,e),M(Pe.$$.fragment,e),M(he.$$.fragment,e),M(ue.$$.fragment,e),M(Ae.$$.fragment,e),M(Ye.$$.fragment,e),M(Oe.$$.fragment,e),M(fe.$$.fragment,e),pn=!1},d(e){e&&(a(y),a(c),a(p),a(o),a(Ht),a(Me),a(Vt),a(be),a(Gt),a(ye),a(Bt),a(Te),a(Lt),a(ke),a(Rt),a(ve),a(Xt),a(St),a($e),a(Qt),a(Pt),a(Z),a(At),a(Yt),a(x),a(Ot),a(Dt),a(C),a(Kt),a(en),a(j),a(tn),a(nn),a(J),a(on),a(sn),a(z),a(rn),a(an),a(U),a(ln),a(dn),a(F),a(cn),a(Nt)),a(t),b(T,e),b(k,e),b(we,e),b(Ee,e),b(xe),b(Ce,e),b(je),b(Je),b(ze),b(Ue),b(Fe),b(Ie,e),b(We),b(Ze),b(se),b(re),b(Ne,e),b(qe),b(He),b(ae),b(ie),b(le),b(Ve,e),b(Ge),b(Be),b(de),b(ce),b(Le,e),b(Re),b(Xe),b(pe),b(me),b(Se,e),b(Qe),b(Pe),b(he),b(ue),b(Ae,e),b(Ye),b(Oe),b(fe)}}}const gs='{"title":"ErnieM","local":"erniem","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"ErnieMConfig","local":"transformers.ErnieMConfig","sections":[],"depth":2},{"title":"ErnieMTokenizer","local":"transformers.ErnieMTokenizer","sections":[],"depth":2},{"title":"ErnieMModel","local":"transformers.ErnieMModel","sections":[],"depth":2},{"title":"ErnieMForSequenceClassification","local":"transformers.ErnieMForSequenceClassification","sections":[],"depth":2},{"title":"ErnieMForMultipleChoice","local":"transformers.ErnieMForMultipleChoice","sections":[],"depth":2},{"title":"ErnieMForTokenClassification","local":"transformers.ErnieMForTokenClassification","sections":[],"depth":2},{"title":"ErnieMForQuestionAnswering","local":"transformers.ErnieMForQuestionAnswering","sections":[],"depth":2},{"title":"ErnieMForInformationExtraction","local":"transformers.ErnieMForInformationExtraction","sections":[],"depth":2}],"depth":1}';function _s(v){return Ko(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends es{constructor(t){super(),ts(this,t,_s,fs,Do,{})}}export{$s as component};
