import{s as xl,o as Yl,n as St}from"../chunks/scheduler.9bc65507.js";import{S as Gl,i as Vl,g as o,s as n,r as d,A as Ql,h as i,f as l,c as a,j as Rl,u as m,x as r,k as Xl,y as El,a as s,v as p,d as c,t as y,w as u}from"../chunks/index.707bf1b6.js";import{T as Ft}from"../chunks/Tip.c2ecdbf4.js";import{C as f}from"../chunks/CodeBlock.54a9f38d.js";import{H as ve}from"../chunks/Heading.342b1fa6.js";function Hl(T){let M,h="If your model is very similar to a model inside the library, you can re-use the same configuration as this model.";return{c(){M=o("p"),M.textContent=h},l(w){M=i(w,"P",{"data-svelte-h":!0}),r(M)!=="svelte-alg4p1"&&(M.textContent=h)},m(w,J){s(w,M,J)},p:St,d(w){w&&l(M)}}}function zl(T){let M,h="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){M=o("p"),M.textContent=h},l(w){M=i(w,"P",{"data-svelte-h":!0}),r(M)!=="svelte-15rpg4"&&(M.textContent=h)},m(w,J){s(w,M,J)},p:St,d(w){w&&l(M)}}}function Fl(T){let M,h=`If copying a modeling files from the library, you will need to replace all the relative imports at the top of the file
to import from the <code>transformers</code> package.`;return{c(){M=o("p"),M.innerHTML=h},l(w){M=i(w,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1816fmc"&&(M.innerHTML=h)},m(w,J){s(w,M,J)},p:St,d(w){w&&l(M)}}}function Sl(T){let M,h,w,J,C,We,g,Lt=`The 🤗 Transformers library is designed to be easily extensible. Every model is fully coded in a given subfolder
of the repository with no abstraction, so you can easily copy a modeling file and tweak it to your needs.`,Be,I,Pt=`If you are writing a brand new model, it might be easier to start from scratch. In this tutorial, we will show you
how to write a custom model and its configuration so it can be used inside Transformers, and how you can share it
with the community (with the code it relies on) so that anyone can use it, even if it’s not present in the 🤗
Transformers library.`,Re,_,qt=`We will illustrate all of this on a ResNet model, by wrapping the ResNet class of the
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm library</a> into a <a href="/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.`,Xe,Z,xe,A,Dt=`Before we dive into the model, let’s first write its configuration. The configuration of a model is an object that
will contain all the necessary information to build the model. As we will see in the next section, the model can only
take a <code>config</code> to be initialized, so we really need that object to be as complete as possible.`,Ye,$,Kt=`In our example, we will take a couple of arguments of the ResNet class that we might want to tweak. Different
configurations will then give us the different types of ResNets that are possible. We then just store those arguments,
after checking the validity of a few of them.`,Ge,k,Ve,v,Ot="The three important things to remember when writing you own configuration are the following:",Qe,N,el="<li>you have to inherit from <code>PretrainedConfig</code>,</li> <li>the <code>__init__</code> of your <code>PretrainedConfig</code> must accept any kwargs,</li> <li>those <code>kwargs</code> need to be passed to the superclass <code>__init__</code>.</li>",Ee,W,tl=`The inheritance is to make sure you get all the functionality from the 🤗 Transformers library, while the two other
constraints come from the fact a <code>PretrainedConfig</code> has more fields than the ones you are setting. When reloading a
config with the <code>from_pretrained</code> method, those fields need to be accepted by your config and then sent to the
superclass.`,He,B,ll=`Defining a <code>model_type</code> for your configuration (here <code>model_type=&quot;resnet&quot;</code>) is not mandatory, unless you want to
register your model with the auto classes (see last section).`,ze,R,sl=`With this done, you can easily create and save your configuration like you would do with any other model config of the
library. Here is how we can create a resnet50d config and save it:`,Fe,X,Se,x,nl=`This will save a file named <code>config.json</code> inside the folder <code>custom-resnet</code>. You can then reload your config with the
<code>from_pretrained</code> method:`,Le,Y,Pe,G,al=`You can also use any other method of the <a href="/docs/transformers/v4.35.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> class, like <a href="/docs/transformers/v4.35.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> to
directly upload your config to the Hub.`,qe,V,De,Q,ol=`Now that we have our ResNet configuration, we can go on writing the model. We will actually write two: one that
extracts the hidden features from a batch of images (like <a href="/docs/transformers/v4.35.0/en/model_doc/bert#transformers.BertModel">BertModel</a>) and one that is suitable for image
classification (like <a href="/docs/transformers/v4.35.0/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a>).`,Ke,E,il=`As we mentioned before, we’ll only write a loose wrapper of the model to keep it simple for this example. The only
thing we need to do before writing this class is a map between the block types and actual block classes. Then the
model is defined from the configuration by passing everything to the <code>ResNet</code> class:`,Oe,H,et,z,rl="For the model that will classify images, we just change the forward method:",tt,F,lt,S,Ml=`In both cases, notice how we inherit from <code>PreTrainedModel</code> and call the superclass initialization with the <code>config</code>
(a bit like when you write a regular <code>torch.nn.Module</code>). The line that sets the <code>config_class</code> is not mandatory, unless
you want to register your model with the auto classes (see last section).`,st,j,nt,L,dl=`You can have your model return anything you want, but returning a dictionary like we did for
<code>ResnetModelForImageClassification</code>, with the loss included when labels are passed, will make your model directly
usable inside the <a href="/docs/transformers/v4.35.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> class. Using another output format is fine as long as you are planning on using your own
training loop or another library for training.`,at,P,ml="Now that we have our model class, let’s create one:",ot,q,it,D,pl=`Again, you can use any of the methods of <a href="/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, like <a href="/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or
<a href="/docs/transformers/v4.35.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a>. We will use the second in the next section, and see how to push the model weights
with the code of our model. But first, let’s load some pretrained weights inside our model.`,rt,K,cl=`In your own use case, you will probably be training your custom model on your own data. To go fast for this tutorial,
we will use the pretrained version of the resnet50d. Since our model is just a wrapper around it, it’s going to be
easy to transfer those weights:`,Mt,O,dt,ee,yl=`Now let’s see how to make sure that when we do <a href="/docs/transformers/v4.35.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or <a href="/docs/transformers/v4.35.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a>, the
code of the model is saved.`,mt,te,pt,U,ct,le,ul=`First, make sure your model is fully defined in a <code>.py</code> file. It can rely on relative imports to some other files as
long as all the files are in the same directory (we don’t support submodules for this feature yet). For our example,
we’ll define a <code>modeling_resnet.py</code> file and a <code>configuration_resnet.py</code> file in a folder of the current working
directory named <code>resnet_model</code>. The configuration file contains the code for <code>ResnetConfig</code> and the modeling file
contains the code of <code>ResnetModel</code> and <code>ResnetModelForImageClassification</code>.`,yt,se,ut,ne,wl="The <code>__init__.py</code> can be empty, it’s just there so that Python detects <code>resnet_model</code> can be use as a module.",wt,b,ft,ae,fl="Note that you can re-use (or subclass) an existing configuration/model.",ht,oe,hl=`To share your model with the community, follow those steps: first import the ResNet model and config from the newly
created files:`,Jt,ie,Tt,re,Jl=`Then you have to tell the library you want to copy the code files of those objects when using the <code>save_pretrained</code>
method and properly register them with a given Auto class (especially for models), just run:`,jt,Me,Ut,de,Tl=`Note that there is no need to specify an auto class for the configuration (there is only one auto class for them,
<a href="/docs/transformers/v4.35.0/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>) but it’s different for models. Your custom model could be suitable for many different tasks, so you
have to specify which one of the auto classes is the correct one for your model.`,bt,me,jl="Next, let’s create the config and models as we did before:",Ct,pe,gt,ce,Ul="Now to send the model to the Hub, make sure you are logged in. Either run in your terminal:",It,ye,_t,ue,bl="or from a notebook:",Zt,we,At,fe,Cl="You can then push to your own namespace (or an organization you are a member of) like this:",$t,he,kt,Je,gl=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.`,vt,Te,Il='See the <a href="model_sharing">sharing tutorial</a> for more information on the push to Hub method.',Nt,je,Wt,Ue,_l=`You can use any configuration, model or tokenizer with custom code files in its repository with the auto-classes and
the <code>from_pretrained</code> method. All files and code uploaded to the Hub are scanned for malware (refer to the <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub security</a> documentation for more information), but you should still
review the model code and author to avoid executing malicious code on your machine. Set <code>trust_remote_code=True</code> to use
a model with custom code:`,Bt,be,Rt,Ce,Zl=`It is also strongly encouraged to pass a commit hash as a <code>revision</code> to make sure the author of the models did not
update the code with some malicious new lines (unless you fully trust the authors of the models).`,Xt,ge,xt,Ie,Al=`Note that when browsing the commit history of the model repo on the Hub, there is a button to easily copy the commit
hash of any commit.`,Yt,_e,Gt,Ze,$l=`If you are writing a library that extends 🤗 Transformers, you may want to extend the auto classes to include your own
model. This is different from pushing the code to the Hub in the sense that users will need to import your library to
get the custom models (contrarily to automatically downloading the model code from the Hub).`,Vt,Ae,kl=`As long as your config has a <code>model_type</code> attribute that is different from existing model types, and that your model
classes have the right <code>config_class</code> attributes, you can just add them to the auto classes like this:`,Qt,$e,Et,ke,vl=`Note that the first argument used when registering your custom config to <a href="/docs/transformers/v4.35.0/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a> needs to match the <code>model_type</code>
of your custom config, and the first argument used when registering your custom models to any auto model class needs
to match the <code>config_class</code> of those models.`,Ht,Ne,zt;return C=new ve({props:{title:"Sharing custom models",local:"sharing-custom-models",headingTag:"h1"}}),Z=new ve({props:{title:"Writing a custom configuration",local:"writing-a-custom-configuration",headingTag:"h2"}}),k=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),Y=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),V=new ve({props:{title:"Writing a custom model",local:"writing-a-custom-model",headingTag:"h2"}}),H=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),j=new Ft({props:{$$slots:{default:[Hl]},$$scope:{ctx:T}}}),q=new f({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new f({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),te=new ve({props:{title:"Sending the code to the Hub",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),U=new Ft({props:{warning:!0,$$slots:{default:[zl]},$$scope:{ctx:T}}}),se=new f({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Ft({props:{warning:!0,$$slots:{default:[Fl]},$$scope:{ctx:T}}}),ie=new f({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),Me=new f({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),pe=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ye=new f({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),we=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),he=new f({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),je=new ve({props:{title:"Using a model with custom code",local:"using-a-model-with-custom-code",headingTag:"h2"}}),be=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),ge=new f({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),_e=new ve({props:{title:"Registering a model with custom code to the auto classes",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),$e=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){M=o("meta"),h=n(),w=o("p"),J=n(),d(C.$$.fragment),We=n(),g=o("p"),g.textContent=Lt,Be=n(),I=o("p"),I.textContent=Pt,Re=n(),_=o("p"),_.innerHTML=qt,Xe=n(),d(Z.$$.fragment),xe=n(),A=o("p"),A.innerHTML=Dt,Ye=n(),$=o("p"),$.textContent=Kt,Ge=n(),d(k.$$.fragment),Ve=n(),v=o("p"),v.textContent=Ot,Qe=n(),N=o("ul"),N.innerHTML=el,Ee=n(),W=o("p"),W.innerHTML=tl,He=n(),B=o("p"),B.innerHTML=ll,ze=n(),R=o("p"),R.textContent=sl,Fe=n(),d(X.$$.fragment),Se=n(),x=o("p"),x.innerHTML=nl,Le=n(),d(Y.$$.fragment),Pe=n(),G=o("p"),G.innerHTML=al,qe=n(),d(V.$$.fragment),De=n(),Q=o("p"),Q.innerHTML=ol,Ke=n(),E=o("p"),E.innerHTML=il,Oe=n(),d(H.$$.fragment),et=n(),z=o("p"),z.textContent=rl,tt=n(),d(F.$$.fragment),lt=n(),S=o("p"),S.innerHTML=Ml,st=n(),d(j.$$.fragment),nt=n(),L=o("p"),L.innerHTML=dl,at=n(),P=o("p"),P.textContent=ml,ot=n(),d(q.$$.fragment),it=n(),D=o("p"),D.innerHTML=pl,rt=n(),K=o("p"),K.textContent=cl,Mt=n(),d(O.$$.fragment),dt=n(),ee=o("p"),ee.innerHTML=yl,mt=n(),d(te.$$.fragment),pt=n(),d(U.$$.fragment),ct=n(),le=o("p"),le.innerHTML=ul,yt=n(),d(se.$$.fragment),ut=n(),ne=o("p"),ne.innerHTML=wl,wt=n(),d(b.$$.fragment),ft=n(),ae=o("p"),ae.textContent=fl,ht=n(),oe=o("p"),oe.textContent=hl,Jt=n(),d(ie.$$.fragment),Tt=n(),re=o("p"),re.innerHTML=Jl,jt=n(),d(Me.$$.fragment),Ut=n(),de=o("p"),de.innerHTML=Tl,bt=n(),me=o("p"),me.textContent=jl,Ct=n(),d(pe.$$.fragment),gt=n(),ce=o("p"),ce.textContent=Ul,It=n(),d(ye.$$.fragment),_t=n(),ue=o("p"),ue.textContent=bl,Zt=n(),d(we.$$.fragment),At=n(),fe=o("p"),fe.textContent=Cl,$t=n(),d(he.$$.fragment),kt=n(),Je=o("p"),Je.innerHTML=gl,vt=n(),Te=o("p"),Te.innerHTML=Il,Nt=n(),d(je.$$.fragment),Wt=n(),Ue=o("p"),Ue.innerHTML=_l,Bt=n(),d(be.$$.fragment),Rt=n(),Ce=o("p"),Ce.innerHTML=Zl,Xt=n(),d(ge.$$.fragment),xt=n(),Ie=o("p"),Ie.textContent=Al,Yt=n(),d(_e.$$.fragment),Gt=n(),Ze=o("p"),Ze.textContent=$l,Vt=n(),Ae=o("p"),Ae.innerHTML=kl,Qt=n(),d($e.$$.fragment),Et=n(),ke=o("p"),ke.innerHTML=vl,Ht=n(),Ne=o("p"),this.h()},l(e){const t=Ql("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),w=i(e,"P",{}),Rl(w).forEach(l),J=a(e),m(C.$$.fragment,e),We=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1bvx2nz"&&(g.textContent=Lt),Be=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-t7mxg8"&&(I.textContent=Pt),Re=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-198mwzd"&&(_.innerHTML=qt),Xe=a(e),m(Z.$$.fragment,e),xe=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-15o85x"&&(A.innerHTML=Dt),Ye=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1u8fbq1"&&($.textContent=Kt),Ge=a(e),m(k.$$.fragment,e),Ve=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-9tm0xv"&&(v.textContent=Ot),Qe=a(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1l985bz"&&(N.innerHTML=el),Ee=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-ttxucl"&&(W.innerHTML=tl),He=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9uxjnq"&&(B.innerHTML=ll),ze=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1229zpx"&&(R.textContent=sl),Fe=a(e),m(X.$$.fragment,e),Se=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1hshoid"&&(x.innerHTML=nl),Le=a(e),m(Y.$$.fragment,e),Pe=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-akpltk"&&(G.innerHTML=al),qe=a(e),m(V.$$.fragment,e),De=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-41tt9f"&&(Q.innerHTML=ol),Ke=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-13oyc7x"&&(E.innerHTML=il),Oe=a(e),m(H.$$.fragment,e),et=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-85b6xb"&&(z.textContent=rl),tt=a(e),m(F.$$.fragment,e),lt=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1vktyut"&&(S.innerHTML=Ml),st=a(e),m(j.$$.fragment,e),nt=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-15wzoy0"&&(L.innerHTML=dl),at=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-zsjn9b"&&(P.textContent=ml),ot=a(e),m(q.$$.fragment,e),it=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1czyvve"&&(D.innerHTML=pl),rt=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-kn8bw1"&&(K.textContent=cl),Mt=a(e),m(O.$$.fragment,e),dt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1p09xy1"&&(ee.innerHTML=yl),mt=a(e),m(te.$$.fragment,e),pt=a(e),m(U.$$.fragment,e),ct=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-w79o0g"&&(le.innerHTML=ul),yt=a(e),m(se.$$.fragment,e),ut=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1orsl60"&&(ne.innerHTML=wl),wt=a(e),m(b.$$.fragment,e),ft=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-miae0j"&&(ae.textContent=fl),ht=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1kyhtnz"&&(oe.textContent=hl),Jt=a(e),m(ie.$$.fragment,e),Tt=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1ce24vd"&&(re.innerHTML=Jl),jt=a(e),m(Me.$$.fragment,e),Ut=a(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1q41x6e"&&(de.innerHTML=Tl),bt=a(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-19txhag"&&(me.textContent=jl),Ct=a(e),m(pe.$$.fragment,e),gt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1w2dqml"&&(ce.textContent=Ul),It=a(e),m(ye.$$.fragment,e),_t=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-11lw65d"&&(ue.textContent=bl),Zt=a(e),m(we.$$.fragment,e),At=a(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1c2397x"&&(fe.textContent=Cl),$t=a(e),m(he.$$.fragment,e),kt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-djed3h"&&(Je.innerHTML=gl),vt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1sdq6eg"&&(Te.innerHTML=Il),Nt=a(e),m(je.$$.fragment,e),Wt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-nao5c0"&&(Ue.innerHTML=_l),Bt=a(e),m(be.$$.fragment,e),Rt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1i8vto1"&&(Ce.innerHTML=Zl),Xt=a(e),m(ge.$$.fragment,e),xt=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1y2zx54"&&(Ie.textContent=Al),Yt=a(e),m(_e.$$.fragment,e),Gt=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-bccbz6"&&(Ze.textContent=$l),Vt=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-uijzdg"&&(Ae.innerHTML=kl),Qt=a(e),m($e.$$.fragment,e),Et=a(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-ddhwml"&&(ke.innerHTML=vl),Ht=a(e),Ne=i(e,"P",{}),Rl(Ne).forEach(l),this.h()},h(){Xl(M,"name","hf:doc:metadata"),Xl(M,"content",Ll)},m(e,t){El(document.head,M),s(e,h,t),s(e,w,t),s(e,J,t),p(C,e,t),s(e,We,t),s(e,g,t),s(e,Be,t),s(e,I,t),s(e,Re,t),s(e,_,t),s(e,Xe,t),p(Z,e,t),s(e,xe,t),s(e,A,t),s(e,Ye,t),s(e,$,t),s(e,Ge,t),p(k,e,t),s(e,Ve,t),s(e,v,t),s(e,Qe,t),s(e,N,t),s(e,Ee,t),s(e,W,t),s(e,He,t),s(e,B,t),s(e,ze,t),s(e,R,t),s(e,Fe,t),p(X,e,t),s(e,Se,t),s(e,x,t),s(e,Le,t),p(Y,e,t),s(e,Pe,t),s(e,G,t),s(e,qe,t),p(V,e,t),s(e,De,t),s(e,Q,t),s(e,Ke,t),s(e,E,t),s(e,Oe,t),p(H,e,t),s(e,et,t),s(e,z,t),s(e,tt,t),p(F,e,t),s(e,lt,t),s(e,S,t),s(e,st,t),p(j,e,t),s(e,nt,t),s(e,L,t),s(e,at,t),s(e,P,t),s(e,ot,t),p(q,e,t),s(e,it,t),s(e,D,t),s(e,rt,t),s(e,K,t),s(e,Mt,t),p(O,e,t),s(e,dt,t),s(e,ee,t),s(e,mt,t),p(te,e,t),s(e,pt,t),p(U,e,t),s(e,ct,t),s(e,le,t),s(e,yt,t),p(se,e,t),s(e,ut,t),s(e,ne,t),s(e,wt,t),p(b,e,t),s(e,ft,t),s(e,ae,t),s(e,ht,t),s(e,oe,t),s(e,Jt,t),p(ie,e,t),s(e,Tt,t),s(e,re,t),s(e,jt,t),p(Me,e,t),s(e,Ut,t),s(e,de,t),s(e,bt,t),s(e,me,t),s(e,Ct,t),p(pe,e,t),s(e,gt,t),s(e,ce,t),s(e,It,t),p(ye,e,t),s(e,_t,t),s(e,ue,t),s(e,Zt,t),p(we,e,t),s(e,At,t),s(e,fe,t),s(e,$t,t),p(he,e,t),s(e,kt,t),s(e,Je,t),s(e,vt,t),s(e,Te,t),s(e,Nt,t),p(je,e,t),s(e,Wt,t),s(e,Ue,t),s(e,Bt,t),p(be,e,t),s(e,Rt,t),s(e,Ce,t),s(e,Xt,t),p(ge,e,t),s(e,xt,t),s(e,Ie,t),s(e,Yt,t),p(_e,e,t),s(e,Gt,t),s(e,Ze,t),s(e,Vt,t),s(e,Ae,t),s(e,Qt,t),p($e,e,t),s(e,Et,t),s(e,ke,t),s(e,Ht,t),s(e,Ne,t),zt=!0},p(e,[t]){const Nl={};t&2&&(Nl.$$scope={dirty:t,ctx:e}),j.$set(Nl);const Wl={};t&2&&(Wl.$$scope={dirty:t,ctx:e}),U.$set(Wl);const Bl={};t&2&&(Bl.$$scope={dirty:t,ctx:e}),b.$set(Bl)},i(e){zt||(c(C.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(V.$$.fragment,e),c(H.$$.fragment,e),c(F.$$.fragment,e),c(j.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(U.$$.fragment,e),c(se.$$.fragment,e),c(b.$$.fragment,e),c(ie.$$.fragment,e),c(Me.$$.fragment,e),c(pe.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(he.$$.fragment,e),c(je.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(_e.$$.fragment,e),c($e.$$.fragment,e),zt=!0)},o(e){y(C.$$.fragment,e),y(Z.$$.fragment,e),y(k.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(V.$$.fragment,e),y(H.$$.fragment,e),y(F.$$.fragment,e),y(j.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(U.$$.fragment,e),y(se.$$.fragment,e),y(b.$$.fragment,e),y(ie.$$.fragment,e),y(Me.$$.fragment,e),y(pe.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(he.$$.fragment,e),y(je.$$.fragment,e),y(be.$$.fragment,e),y(ge.$$.fragment,e),y(_e.$$.fragment,e),y($e.$$.fragment,e),zt=!1},d(e){e&&(l(h),l(w),l(J),l(We),l(g),l(Be),l(I),l(Re),l(_),l(Xe),l(xe),l(A),l(Ye),l($),l(Ge),l(Ve),l(v),l(Qe),l(N),l(Ee),l(W),l(He),l(B),l(ze),l(R),l(Fe),l(Se),l(x),l(Le),l(Pe),l(G),l(qe),l(De),l(Q),l(Ke),l(E),l(Oe),l(et),l(z),l(tt),l(lt),l(S),l(st),l(nt),l(L),l(at),l(P),l(ot),l(it),l(D),l(rt),l(K),l(Mt),l(dt),l(ee),l(mt),l(pt),l(ct),l(le),l(yt),l(ut),l(ne),l(wt),l(ft),l(ae),l(ht),l(oe),l(Jt),l(Tt),l(re),l(jt),l(Ut),l(de),l(bt),l(me),l(Ct),l(gt),l(ce),l(It),l(_t),l(ue),l(Zt),l(At),l(fe),l($t),l(kt),l(Je),l(vt),l(Te),l(Nt),l(Wt),l(Ue),l(Bt),l(Rt),l(Ce),l(Xt),l(xt),l(Ie),l(Yt),l(Gt),l(Ze),l(Vt),l(Ae),l(Qt),l(Et),l(ke),l(Ht),l(Ne)),l(M),u(C,e),u(Z,e),u(k,e),u(X,e),u(Y,e),u(V,e),u(H,e),u(F,e),u(j,e),u(q,e),u(O,e),u(te,e),u(U,e),u(se,e),u(b,e),u(ie,e),u(Me,e),u(pe,e),u(ye,e),u(we,e),u(he,e),u(je,e),u(be,e),u(ge,e),u(_e,e),u($e,e)}}}const Ll='{"title":"Sharing custom models","local":"sharing-custom-models","sections":[{"title":"Writing a custom configuration","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"Writing a custom model","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Sending the code to the Hub","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"Using a model with custom code","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"Registering a model with custom code to the auto classes","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function Pl(T){return Yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Gl{constructor(M){super(),Vl(this,M,Pl,Sl,xl,{})}}export{ts as component};
