import{s as os,n as cs,o as Js}from"../chunks/scheduler.b108d059.js";import{S as Ms,i as hs,g as i,s as n,r as o,A as Ts,h as c,f as a,c as t,j as ps,u as J,x as k,k as is,y as rs,a as e,v as M,d as h,t as T,w as r}from"../chunks/index.008de539.js";import{C as K}from"../chunks/CodeBlock.3968c746.js";import{H as W}from"../chunks/Heading.88bfeb84.js";function ws(O){let p,R,Q,E,w,N,y,ss="Official utilities to use the Hugging Face hub API, still very experimental.",v,d,V,j,Y,m,F,U,X,u,_,b,ls='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',H,I,A,f,S,g,as="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",x,B,es="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",z,Z,ns="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",q,G,L,C,ts="<li><code>hash-wasm</code> : Only used in the browser, when committing files over 10 MB. Browsers do not natively support streaming sha256 computations.</li> <li><code>type-fest</code> : Typings only</li>",D,$,P;return w=new W({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),d=new W({props:{title:"Install",local:"install",headingTag:"h2"}}),j=new K({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),m=new W({props:{title:"Deno",local:"deno",headingTag:"h3"}}),U=new K({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),u=new W({props:{title:"Usage",local:"usage",headingTag:"h2"}}),I=new K({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, uploadFilesWithProgress, deleteFile, deleteRepo, listFiles, whoAmI } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };
<span class="hljs-keyword">const</span> <span class="hljs-attr">credentials</span>: <span class="hljs-title class_">Credentials</span> = { <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({credentials});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, credentials})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, credentials, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, credentials, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, credentials });`,wrap:!1}}),f=new W({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),G=new W({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),{c(){p=i("meta"),R=n(),Q=i("p"),E=n(),o(w.$$.fragment),N=n(),y=i("p"),y.textContent=ss,v=n(),o(d.$$.fragment),V=n(),o(j.$$.fragment),Y=n(),o(m.$$.fragment),F=n(),o(U.$$.fragment),X=n(),o(u.$$.fragment),_=n(),b=i("p"),b.innerHTML=ls,H=n(),o(I.$$.fragment),A=n(),o(f.$$.fragment),S=n(),g=i("p"),g.innerHTML=as,x=n(),B=i("p"),B.innerHTML=es,z=n(),Z=i("p"),Z.innerHTML=ns,q=n(),o(G.$$.fragment),L=n(),C=i("ul"),C.innerHTML=ts,D=n(),$=i("p"),this.h()},l(s){const l=Ts("svelte-u9bgzb",document.head);p=c(l,"META",{name:!0,content:!0}),l.forEach(a),R=t(s),Q=c(s,"P",{}),ps(Q).forEach(a),E=t(s),J(w.$$.fragment,s),N=t(s),y=c(s,"P",{"data-svelte-h":!0}),k(y)!=="svelte-1rd1r5p"&&(y.textContent=ss),v=t(s),J(d.$$.fragment,s),V=t(s),J(j.$$.fragment,s),Y=t(s),J(m.$$.fragment,s),F=t(s),J(U.$$.fragment,s),X=t(s),J(u.$$.fragment,s),_=t(s),b=c(s,"P",{"data-svelte-h":!0}),k(b)!=="svelte-1nqczoz"&&(b.innerHTML=ls),H=t(s),J(I.$$.fragment,s),A=t(s),J(f.$$.fragment,s),S=t(s),g=c(s,"P",{"data-svelte-h":!0}),k(g)!=="svelte-1gspubq"&&(g.innerHTML=as),x=t(s),B=c(s,"P",{"data-svelte-h":!0}),k(B)!=="svelte-em0etc"&&(B.innerHTML=es),z=t(s),Z=c(s,"P",{"data-svelte-h":!0}),k(Z)!=="svelte-lja874"&&(Z.innerHTML=ns),q=t(s),J(G.$$.fragment,s),L=t(s),C=c(s,"UL",{"data-svelte-h":!0}),k(C)!=="svelte-cfwqb4"&&(C.innerHTML=ts),D=t(s),$=c(s,"P",{}),ps($).forEach(a),this.h()},h(){is(p,"name","hf:doc:metadata"),is(p,"content",ys)},m(s,l){rs(document.head,p),e(s,R,l),e(s,Q,l),e(s,E,l),M(w,s,l),e(s,N,l),e(s,y,l),e(s,v,l),M(d,s,l),e(s,V,l),M(j,s,l),e(s,Y,l),M(m,s,l),e(s,F,l),M(U,s,l),e(s,X,l),M(u,s,l),e(s,_,l),e(s,b,l),e(s,H,l),M(I,s,l),e(s,A,l),M(f,s,l),e(s,S,l),e(s,g,l),e(s,x,l),e(s,B,l),e(s,z,l),e(s,Z,l),e(s,q,l),M(G,s,l),e(s,L,l),e(s,C,l),e(s,D,l),e(s,$,l),P=!0},p:cs,i(s){P||(h(w.$$.fragment,s),h(d.$$.fragment,s),h(j.$$.fragment,s),h(m.$$.fragment,s),h(U.$$.fragment,s),h(u.$$.fragment,s),h(I.$$.fragment,s),h(f.$$.fragment,s),h(G.$$.fragment,s),P=!0)},o(s){T(w.$$.fragment,s),T(d.$$.fragment,s),T(j.$$.fragment,s),T(m.$$.fragment,s),T(U.$$.fragment,s),T(u.$$.fragment,s),T(I.$$.fragment,s),T(f.$$.fragment,s),T(G.$$.fragment,s),P=!1},d(s){s&&(a(R),a(Q),a(E),a(N),a(y),a(v),a(V),a(Y),a(F),a(X),a(_),a(b),a(H),a(A),a(S),a(g),a(x),a(B),a(z),a(Z),a(q),a(L),a(C),a(D),a($)),a(p),r(w,s),r(d,s),r(j,s),r(m,s),r(U,s),r(u,s),r(I,s),r(f,s),r(G,s)}}}const ys='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function ds(O){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends Ms{constructor(p){super(),hs(this,p,ds,ws,os,{})}}export{bs as component};
