import{s as xl,o as kl,n as Lt}from"../chunks/scheduler.182ea377.js";import{S as Wl,i as Il,g as i,s,r as m,A as Bl,h as o,f as l,c as n,j as Gl,u as d,x as r,k as W,y as Cl,a,v as u,d as c,t as f,w as g}from"../chunks/index.abf12888.js";import{T as Et}from"../chunks/Tip.230e2334.js";import{C as b}from"../chunks/CodeBlock.57fe6e13.js";import{D as Vl}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as y}from"../chunks/Heading.16916d63.js";function Rl(T){let p,M='Read the <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> blog post to learn more about how a latent diffusion model works.';return{c(){p=i("p"),p.innerHTML=M},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-j8481q"&&(p.innerHTML=M)},m(h,w){a(h,p,w)},p:Lt,d(h){h&&l(p)}}}function Xl(T){let p,M="Other models may have different default image sizes depending on the image size’s in the training dataset. For example, SDXL’s default image size is 1024x1024 and using lower <code>height</code> and <code>width</code> values may result in lower quality images. Make sure you check the model’s API reference first!";return{c(){p=i("p"),p.innerHTML=M},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1sujtos"&&(p.innerHTML=M)},m(h,w){a(h,p,w)},p:Lt,d(h){h&&l(p)}}}function Ql(T){let p,M='Learn how to create the prompt embeddings in the <a href="weighted_prompts">Prompt weighting</a> guide. This example focuses on how to use the prompt embeddings in the pipeline.';return{c(){p=i("p"),p.innerHTML=M},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ed23cy"&&(p.innerHTML=M)},m(h,w){a(h,p,w)},p:Lt,d(h){h&&l(p)}}}function Fl(T){let p,M,h,w,I,Ce,B,Ve,C,Nt="When you think of diffusion models, text-to-image is usually one of the first things that come to mind. Text-to-image generates an image from a text description (for example, “Astronaut in a jungle, cold color palette, muted colors, detailed, 8k”) which is also known as a <em>prompt</em>.",Re,V,zt="From a very high level, a diffusion model takes a prompt and some random initial noise, and iteratively removes the noise to construct an image. The <em>denoising</em> process is guided by the prompt, and once the denoising process ends after a predetermined number of time steps, the image representation is decoded into an image.",Xe,J,Qe,R,Dt="You can generate images from a prompt in 🤗 Diffusers in two steps:",Fe,X,Pt='<li>Load a checkpoint into the <a href="/docs/diffusers/v0.22.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a> class, which automatically detects the appropriate pipeline class to use based on the checkpoint:</li>',_e,Q,Se,v,At="<li>Pass a prompt to the pipeline to generate an image:</li>",Ye,F,He,Z,Kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-vader.png"/>',qe,_,Ee,S,Ot='The most common text-to-image models are <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">Stable Diffusion v1.5</a>, <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">Stable Diffusion XL (SDXL)</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder" rel="nofollow">Kandinsky 2.2</a>. There are also ControlNet models or adapters that can be used with text-to-image models for more direct control in generating images. The results from each model are slightly different because of their architecture and training process, but no matter which model you choose, their usage is more or less the same. Let’s use the same prompt for each model and compare their results.',Le,Y,Ne,H,el='<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">Stable Diffusion v1.5</a> is a latent diffusion model initialized from <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">Stable Diffusion v1-4</a>, and finetuned for 595K steps on 512x512 images from the LAION-Aesthetics V2 dataset. You can use this model like:',ze,q,De,E,Pe,L,tl='SDXL is a much larger version of the previous Stable Diffusion models, and involves a two-stage model process that adds even more details to an image. It also includes some additional <em>micro-conditionings</em> to generate high-quality images centered subjects. Take a look at the more comprehensive <a href="sdxl">SDXL</a> guide to learn more about how to use it. In general, you can use SDXL like:',Ae,N,Ke,z,Oe,D,ll="The Kandinsky model is a bit different from the Stable Diffusion models because it also uses an image prior model to create embeddings that are used to better align text and images in the diffusion model.",et,P,al="The easiest way to use Kandinsky 2.2 is:",tt,A,lt,K,at,O,sl='ControlNet are auxiliary models or adapters that are finetuned on top of text-to-image models, such as <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">Stable Diffusion V1.5</a>. Using ControlNet models in combination with text-to-image models offers diverse options for more explicit control over how to generate an image. With ControlNet’s, you add an additional conditioning input image to the model. For example, if you provide an image of a human pose (usually represented as multiple keypoints that are connected into a skeleton) as a conditioning input, the model generates an image that follows the pose of the image. Check out the more in-depth <a href="controlnet">ControlNet</a> guide to learn more about other conditioning inputs and how to use them.',st,ee,nl="In this example, let’s condition the ControlNet with a human pose estimation image. Load the ControlNet model pretrained on human pose estimations:",nt,te,it,le,il='Pass the <code>controlnet</code> to the <a href="/docs/diffusers/v0.22.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a>, and provide the prompt and pose estimation image:',ot,ae,rt,U,ol='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion v1.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion XL</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Kandinsky 2.2</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet (pose conditioning)</figcaption></div>',pt,se,mt,ne,rl="There are a number of parameters that can be configured in the pipeline that affect how an image is generated. You can change the image’s output size, specify a negative prompt to improve image quality, and more. This section dives deeper into how to use these parameters.",dt,ie,ut,oe,pl="The <code>height</code> and <code>width</code> parameters control the height and width (in pixels) of the generated image. By default, the Stable Diffusion v1.5 model outputs 512x512 images, but you can change this to any size that is a multiple of 8. For example, to create a rectangular image:",ct,re,ft,$,ml='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-hw.png"/>',gt,j,ht,pe,yt,me,dl="The <code>guidance_scale</code> parameter affects how much the prompt influences image generation. A lower value gives the model “creativity” to generate images that are more loosely related to the prompt. Higher <code>guidance_scale</code> values push the model to follow the prompt more closely, and if this value is too high, you may observe some artifacts in the generated image.",Mt,de,bt,G,ul='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-guidance-scale-2.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 2.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-guidance-scale-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 7.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-guidance-scale-10.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 10.5</figcaption></div>',wt,ue,Tt,ce,cl="Just like how a prompt guides generation, a <em>negative prompt</em> steers the model away from things you don’t want the model to generate. This is commonly used to improve overall image quality by removing poor or bad image features such as “low resolution” or “bad details”. You can also use a negative prompt to remove or modify the content and style of an image.",Jt,fe,vt,x,fl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-neg-prompt-1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative prompt = &quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/text2img-neg-prompt-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative prompt = &quot;astronaut&quot;</figcaption></div>',Zt,ge,Ut,he,gl='A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html#generator" rel="nofollow"><code>torch.Generator</code></a> object enables reproducibility in a pipeline by setting a manual seed. You can use a <code>Generator</code> to generate batches of images and iteratively improve on an image generated from a seed as detailed in the <a href="reusing_seeds">Improve image quality with deterministic generation</a> guide.',$t,ye,hl="You can set a seed and <code>Generator</code> as shown below. Creating an image with a <code>Generator</code> should return the same result each time instead of randomly generating a new image.",jt,Me,Gt,be,xt,we,yl="There are several ways to exert more control over how an image is generated outside of configuring a pipeline’s parameters, such as prompt weighting and ControlNet models.",kt,Te,Wt,Je,Ml='Prompt weighting is a technique for increasing or decreasing the importance of concepts in a prompt to emphasize or minimize certain features in an image. We recommend using the <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library to help you generate the weighted prompt embeddings.',It,k,Bt,ve,bl="Once you’ve created the embeddings, you can pass them to the <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter in the pipeline.",Ct,Ze,Vt,Ue,Rt,$e,wl='As you saw in the <a href="#controlnet">ControlNet</a> section, these models offer a more flexible and accurate way to generate images by incorporating an additional conditioning image input. Each ControlNet model is pretrained on a particular type of conditioning image to generate new images that resemble it. For example, if you take a ControlNet pretrained on depth maps, you can give the model a depth map as a conditioning input and it’ll generate an image that preserves the spatial information in it. This is quicker and easier than specifying the depth information in a prompt. You can even combine multiple conditioning inputs with a <a href="controlnet#multicontrolnet">MultiControlNet</a>!',Xt,je,Tl='There are many types of conditioning inputs you can use, and 🤗 Diffusers supports ControlNet for Stable Diffusion and SDXL models. Take a look at the more comprehensive <a href="controlnet">ControlNet</a> guide to learn how you can use these models.',Qt,Ge,Ft,xe,Jl="Diffusion models are large, and the iterative nature of denoising an image is computationally expensive and intensive. But this doesn’t mean you need access to powerful - or even many - GPUs to use them. There are many optimization techniques for running diffusion models on consumer and free-tier resources. For example, you can load model weights in half-precision to save GPU memory and increase speed or offload the entire model to the GPU to save even more memory.",_t,ke,vl='PyTorch 2.0 also supports a more memory-efficient attention mechanism called <a href="../optimization/torch2.0#scaled-dot-product-attention"><em>scaled dot product attention</em></a> that is automatically enabled if you’re using PyTorch 2.0. You can combine this with <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile</code></a> to speed your code up even more:',St,We,Yt,Ie,Zl='For more tips on how to optimize your code to save memory and speed up inference, read the <a href="../optimization/fp16">Memory and speed</a> and <a href="../optimization/torch2.0">Torch 2.0</a> guides.',Ht,Be,qt;return I=new y({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),B=new Vl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/conditional_image_generation.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/conditional_image_generation.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/conditional_image_generation.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/conditional_image_generation.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/conditional_image_generation.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/conditional_image_generation.ipynb"}]}}),J=new Et({props:{$$slots:{default:[Rl]},$$scope:{ctx:T}}}),Q=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUwOSUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),F=new b({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMDklMjJzdGFpbmVkJTIwZ2xhc3MlMjBvZiUyMGRhcnRoJTIwdmFkZXIlMkMlMjBiYWNrbGlnaHQlMkMlMjBjZW50ZXJlZCUyMGNvbXBvc2l0aW9uJTJDJTIwbWFzdGVycGllY2UlMkMlMjBwaG90b3JlYWxpc3RpYyUyQyUyMDhrJTIyJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`image = pipeline(
	<span class="hljs-string">&quot;stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k&quot;</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_=new y({props:{title:"Popular models",local:"popular-models",headingTag:"h2"}}),Y=new y({props:{title:"Stable Diffusion v1.5",local:"stable-diffusion-v15",headingTag:"h3"}}),q=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMzEpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),E=new y({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h3"}}),N=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDMxKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),z=new y({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h3"}}),A=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgzMSklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),K=new y({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),te=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIybGxseWFzdmllbCUyRmNvbnRyb2xfdjExcF9zZDE1X29wZW5wb3NlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcG9zZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9vcGVucG9zZSUyRnJlc29sdmUlMkZtYWluJTJGaW1hZ2VzJTJGY29udHJvbC5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(
	<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_openpose&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pose_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_openpose/resolve/main/images/control.png&quot;</span>)`,wrap:!1}}),ae=new b({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDMxKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUyQyUyMGltYWdlJTNEcG9zZV9pbWFnZSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=pose_image, generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),se=new y({props:{title:"Configure pipeline parameters",local:"configure-pipeline-parameters",headingTag:"h2"}}),ie=new y({props:{title:"Height and width",local:"height-and-width",headingTag:"h3"}}),re=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUwOSUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBoZWlnaHQlM0Q3NjglMkMlMjB3aWR0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = pipeline(
	<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, height=<span class="hljs-number">768</span>, width=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),j=new Et({props:{warning:!0,$$slots:{default:[Xl]},$$scope:{ctx:T}}}),pe=new y({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),de=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMDklMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = pipeline(
	<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, guidance_scale=<span class="hljs-number">3.5</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ue=new y({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),fe=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMDlwcm9tcHQlM0QlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTIwJTBBJTA5bmVnYXRpdmVfcHJvbXB0JTNEJTIydWdseSUyQyUyMGRlZm9ybWVkJTJDJTIwZGlzZmlndXJlZCUyQyUyMHBvb3IlMjBkZXRhaWxzJTJDJTIwYmFkJTIwYW5hdG9teSUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = pipeline(
	prompt=<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, 
	negative_prompt=<span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ge=new y({props:{title:"Generator",local:"generator",headingTag:"h3"}}),Me=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDMwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTA5JTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUyQyUyMCUwQSUwOWdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">30</span>)
image = pipeline(
	<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, 
	generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),be=new y({props:{title:"Control image generation",local:"control-image-generation",headingTag:"h2"}}),Te=new y({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h3"}}),k=new Et({props:{$$slots:{default:[Ql]},$$scope:{ctx:T}}}),Ze=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMDlwcm9tcHRfZW1lYmRzJTNEcHJvbXB0X2VtYmVkcyUyQyUyMCUyMyUyMGdlbmVyYXRlZCUyMGZyb20lMjBDb21wZWwlMEElMDluZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUyQyUyMCUyMyUyMGdlbmVyYXRlZCUyMGZyb20lMjBDb21wZWwlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
	<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = pipeline(
	prompt_emebds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
	negative_prompt_embeds=negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ue=new y({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),Ge=new y({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),We=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlbGluZS51bmV0JTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhcmQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overheard&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){p=i("meta"),M=s(),h=i("p"),w=s(),m(I.$$.fragment),Ce=s(),m(B.$$.fragment),Ve=s(),C=i("p"),C.innerHTML=Nt,Re=s(),V=i("p"),V.innerHTML=zt,Xe=s(),m(J.$$.fragment),Qe=s(),R=i("p"),R.textContent=Dt,Fe=s(),X=i("ol"),X.innerHTML=Pt,_e=s(),m(Q.$$.fragment),Se=s(),v=i("ol"),v.innerHTML=At,Ye=s(),m(F.$$.fragment),He=s(),Z=i("div"),Z.innerHTML=Kt,qe=s(),m(_.$$.fragment),Ee=s(),S=i("p"),S.innerHTML=Ot,Le=s(),m(Y.$$.fragment),Ne=s(),H=i("p"),H.innerHTML=el,ze=s(),m(q.$$.fragment),De=s(),m(E.$$.fragment),Pe=s(),L=i("p"),L.innerHTML=tl,Ae=s(),m(N.$$.fragment),Ke=s(),m(z.$$.fragment),Oe=s(),D=i("p"),D.textContent=ll,et=s(),P=i("p"),P.textContent=al,tt=s(),m(A.$$.fragment),lt=s(),m(K.$$.fragment),at=s(),O=i("p"),O.innerHTML=sl,st=s(),ee=i("p"),ee.textContent=nl,nt=s(),m(te.$$.fragment),it=s(),le=i("p"),le.innerHTML=il,ot=s(),m(ae.$$.fragment),rt=s(),U=i("div"),U.innerHTML=ol,pt=s(),m(se.$$.fragment),mt=s(),ne=i("p"),ne.textContent=rl,dt=s(),m(ie.$$.fragment),ut=s(),oe=i("p"),oe.innerHTML=pl,ct=s(),m(re.$$.fragment),ft=s(),$=i("div"),$.innerHTML=ml,gt=s(),m(j.$$.fragment),ht=s(),m(pe.$$.fragment),yt=s(),me=i("p"),me.innerHTML=dl,Mt=s(),m(de.$$.fragment),bt=s(),G=i("div"),G.innerHTML=ul,wt=s(),m(ue.$$.fragment),Tt=s(),ce=i("p"),ce.innerHTML=cl,Jt=s(),m(fe.$$.fragment),vt=s(),x=i("div"),x.innerHTML=fl,Zt=s(),m(ge.$$.fragment),Ut=s(),he=i("p"),he.innerHTML=gl,$t=s(),ye=i("p"),ye.innerHTML=hl,jt=s(),m(Me.$$.fragment),Gt=s(),m(be.$$.fragment),xt=s(),we=i("p"),we.textContent=yl,kt=s(),m(Te.$$.fragment),Wt=s(),Je=i("p"),Je.innerHTML=Ml,It=s(),m(k.$$.fragment),Bt=s(),ve=i("p"),ve.innerHTML=bl,Ct=s(),m(Ze.$$.fragment),Vt=s(),m(Ue.$$.fragment),Rt=s(),$e=i("p"),$e.innerHTML=wl,Xt=s(),je=i("p"),je.innerHTML=Tl,Qt=s(),m(Ge.$$.fragment),Ft=s(),xe=i("p"),xe.textContent=Jl,_t=s(),ke=i("p"),ke.innerHTML=vl,St=s(),m(We.$$.fragment),Yt=s(),Ie=i("p"),Ie.innerHTML=Zl,Ht=s(),Be=i("p"),this.h()},l(e){const t=Bl("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),M=n(e),h=o(e,"P",{}),Gl(h).forEach(l),w=n(e),d(I.$$.fragment,e),Ce=n(e),d(B.$$.fragment,e),Ve=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1l46gj3"&&(C.innerHTML=Nt),Re=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1t2ibrh"&&(V.innerHTML=zt),Xe=n(e),d(J.$$.fragment,e),Qe=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1n6nnyu"&&(R.textContent=Dt),Fe=n(e),X=o(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-xo1vxw"&&(X.innerHTML=Pt),_e=n(e),d(Q.$$.fragment,e),Se=n(e),v=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-omo4p8"&&(v.innerHTML=At),Ye=n(e),d(F.$$.fragment,e),He=n(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-12i7yhb"&&(Z.innerHTML=Kt),qe=n(e),d(_.$$.fragment,e),Ee=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1aa9fjw"&&(S.innerHTML=Ot),Le=n(e),d(Y.$$.fragment,e),Ne=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-zuifws"&&(H.innerHTML=el),ze=n(e),d(q.$$.fragment,e),De=n(e),d(E.$$.fragment,e),Pe=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16df6ya"&&(L.innerHTML=tl),Ae=n(e),d(N.$$.fragment,e),Ke=n(e),d(z.$$.fragment,e),Oe=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-4hv0fs"&&(D.textContent=ll),et=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-11xg80m"&&(P.textContent=al),tt=n(e),d(A.$$.fragment,e),lt=n(e),d(K.$$.fragment,e),at=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-9h8hmq"&&(O.innerHTML=sl),st=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-sut514"&&(ee.textContent=nl),nt=n(e),d(te.$$.fragment,e),it=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-uh6cgg"&&(le.innerHTML=il),ot=n(e),d(ae.$$.fragment,e),rt=n(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-16c2hir"&&(U.innerHTML=ol),pt=n(e),d(se.$$.fragment,e),mt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-eshh8b"&&(ne.textContent=rl),dt=n(e),d(ie.$$.fragment,e),ut=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1qwh4hb"&&(oe.innerHTML=pl),ct=n(e),d(re.$$.fragment,e),ft=n(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-oonymb"&&($.innerHTML=ml),gt=n(e),d(j.$$.fragment,e),ht=n(e),d(pe.$$.fragment,e),yt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-bwviyb"&&(me.innerHTML=dl),Mt=n(e),d(de.$$.fragment,e),bt=n(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-yknxlr"&&(G.innerHTML=ul),wt=n(e),d(ue.$$.fragment,e),Tt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-10oi6q0"&&(ce.innerHTML=cl),Jt=n(e),d(fe.$$.fragment,e),vt=n(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-1nciqa8"&&(x.innerHTML=fl),Zt=n(e),d(ge.$$.fragment,e),Ut=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-am7ub1"&&(he.innerHTML=gl),$t=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-11rytjg"&&(ye.innerHTML=hl),jt=n(e),d(Me.$$.fragment,e),Gt=n(e),d(be.$$.fragment,e),xt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-nhxl1e"&&(we.textContent=yl),kt=n(e),d(Te.$$.fragment,e),Wt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-16kzvf0"&&(Je.innerHTML=Ml),It=n(e),d(k.$$.fragment,e),Bt=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-3641kw"&&(ve.innerHTML=bl),Ct=n(e),d(Ze.$$.fragment,e),Vt=n(e),d(Ue.$$.fragment,e),Rt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-9tztsn"&&($e.innerHTML=wl),Xt=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-3yz46e"&&(je.innerHTML=Tl),Qt=n(e),d(Ge.$$.fragment,e),Ft=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-jaf97h"&&(xe.textContent=Jl),_t=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1qf8p42"&&(ke.innerHTML=vl),St=n(e),d(We.$$.fragment,e),Yt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-ulej4r"&&(Ie.innerHTML=Zl),Ht=n(e),Be=o(e,"P",{}),Gl(Be).forEach(l),this.h()},h(){W(p,"name","hf:doc:metadata"),W(p,"content",_l),W(v,"start","2"),W(Z,"class","flex justify-center"),W(U,"class","flex flex-row gap-4"),W($,"class","flex justify-center"),W(G,"class","flex flex-row gap-4"),W(x,"class","flex flex-row gap-4")},m(e,t){Cl(document.head,p),a(e,M,t),a(e,h,t),a(e,w,t),u(I,e,t),a(e,Ce,t),u(B,e,t),a(e,Ve,t),a(e,C,t),a(e,Re,t),a(e,V,t),a(e,Xe,t),u(J,e,t),a(e,Qe,t),a(e,R,t),a(e,Fe,t),a(e,X,t),a(e,_e,t),u(Q,e,t),a(e,Se,t),a(e,v,t),a(e,Ye,t),u(F,e,t),a(e,He,t),a(e,Z,t),a(e,qe,t),u(_,e,t),a(e,Ee,t),a(e,S,t),a(e,Le,t),u(Y,e,t),a(e,Ne,t),a(e,H,t),a(e,ze,t),u(q,e,t),a(e,De,t),u(E,e,t),a(e,Pe,t),a(e,L,t),a(e,Ae,t),u(N,e,t),a(e,Ke,t),u(z,e,t),a(e,Oe,t),a(e,D,t),a(e,et,t),a(e,P,t),a(e,tt,t),u(A,e,t),a(e,lt,t),u(K,e,t),a(e,at,t),a(e,O,t),a(e,st,t),a(e,ee,t),a(e,nt,t),u(te,e,t),a(e,it,t),a(e,le,t),a(e,ot,t),u(ae,e,t),a(e,rt,t),a(e,U,t),a(e,pt,t),u(se,e,t),a(e,mt,t),a(e,ne,t),a(e,dt,t),u(ie,e,t),a(e,ut,t),a(e,oe,t),a(e,ct,t),u(re,e,t),a(e,ft,t),a(e,$,t),a(e,gt,t),u(j,e,t),a(e,ht,t),u(pe,e,t),a(e,yt,t),a(e,me,t),a(e,Mt,t),u(de,e,t),a(e,bt,t),a(e,G,t),a(e,wt,t),u(ue,e,t),a(e,Tt,t),a(e,ce,t),a(e,Jt,t),u(fe,e,t),a(e,vt,t),a(e,x,t),a(e,Zt,t),u(ge,e,t),a(e,Ut,t),a(e,he,t),a(e,$t,t),a(e,ye,t),a(e,jt,t),u(Me,e,t),a(e,Gt,t),u(be,e,t),a(e,xt,t),a(e,we,t),a(e,kt,t),u(Te,e,t),a(e,Wt,t),a(e,Je,t),a(e,It,t),u(k,e,t),a(e,Bt,t),a(e,ve,t),a(e,Ct,t),u(Ze,e,t),a(e,Vt,t),u(Ue,e,t),a(e,Rt,t),a(e,$e,t),a(e,Xt,t),a(e,je,t),a(e,Qt,t),u(Ge,e,t),a(e,Ft,t),a(e,xe,t),a(e,_t,t),a(e,ke,t),a(e,St,t),u(We,e,t),a(e,Yt,t),a(e,Ie,t),a(e,Ht,t),a(e,Be,t),qt=!0},p(e,[t]){const Ul={};t&2&&(Ul.$$scope={dirty:t,ctx:e}),J.$set(Ul);const $l={};t&2&&($l.$$scope={dirty:t,ctx:e}),j.$set($l);const jl={};t&2&&(jl.$$scope={dirty:t,ctx:e}),k.$set(jl)},i(e){qt||(c(I.$$.fragment,e),c(B.$$.fragment,e),c(J.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(_.$$.fragment,e),c(Y.$$.fragment,e),c(q.$$.fragment,e),c(E.$$.fragment,e),c(N.$$.fragment,e),c(z.$$.fragment,e),c(A.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(j.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(Me.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),c(k.$$.fragment,e),c(Ze.$$.fragment,e),c(Ue.$$.fragment,e),c(Ge.$$.fragment,e),c(We.$$.fragment,e),qt=!0)},o(e){f(I.$$.fragment,e),f(B.$$.fragment,e),f(J.$$.fragment,e),f(Q.$$.fragment,e),f(F.$$.fragment,e),f(_.$$.fragment,e),f(Y.$$.fragment,e),f(q.$$.fragment,e),f(E.$$.fragment,e),f(N.$$.fragment,e),f(z.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(j.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(Me.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(k.$$.fragment,e),f(Ze.$$.fragment,e),f(Ue.$$.fragment,e),f(Ge.$$.fragment,e),f(We.$$.fragment,e),qt=!1},d(e){e&&(l(M),l(h),l(w),l(Ce),l(Ve),l(C),l(Re),l(V),l(Xe),l(Qe),l(R),l(Fe),l(X),l(_e),l(Se),l(v),l(Ye),l(He),l(Z),l(qe),l(Ee),l(S),l(Le),l(Ne),l(H),l(ze),l(De),l(Pe),l(L),l(Ae),l(Ke),l(Oe),l(D),l(et),l(P),l(tt),l(lt),l(at),l(O),l(st),l(ee),l(nt),l(it),l(le),l(ot),l(rt),l(U),l(pt),l(mt),l(ne),l(dt),l(ut),l(oe),l(ct),l(ft),l($),l(gt),l(ht),l(yt),l(me),l(Mt),l(bt),l(G),l(wt),l(Tt),l(ce),l(Jt),l(vt),l(x),l(Zt),l(Ut),l(he),l($t),l(ye),l(jt),l(Gt),l(xt),l(we),l(kt),l(Wt),l(Je),l(It),l(Bt),l(ve),l(Ct),l(Vt),l(Rt),l($e),l(Xt),l(je),l(Qt),l(Ft),l(xe),l(_t),l(ke),l(St),l(Yt),l(Ie),l(Ht),l(Be)),l(p),g(I,e),g(B,e),g(J,e),g(Q,e),g(F,e),g(_,e),g(Y,e),g(q,e),g(E,e),g(N,e),g(z,e),g(A,e),g(K,e),g(te,e),g(ae,e),g(se,e),g(ie,e),g(re,e),g(j,e),g(pe,e),g(de,e),g(ue,e),g(fe,e),g(ge,e),g(Me,e),g(be,e),g(Te,e),g(k,e),g(Ze,e),g(Ue,e),g(Ge,e),g(We,e)}}}const _l='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"Popular models","local":"popular-models","sections":[{"title":"Stable Diffusion v1.5","local":"stable-diffusion-v15","sections":[],"depth":3},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":3},{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Configure pipeline parameters","local":"configure-pipeline-parameters","sections":[{"title":"Height and width","local":"height-and-width","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3},{"title":"Generator","local":"generator","sections":[],"depth":3}],"depth":2},{"title":"Control image generation","local":"control-image-generation","sections":[{"title":"Prompt weighting","local":"prompt-weighting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2}],"depth":1}';function Sl(T){return kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends Wl{constructor(p){super(),Il(this,p,Sl,Fl,xl,{})}}export{zl as component};
