import{s as Le,n as We,o as Ze}from"../chunks/scheduler.182ea377.js";import{S as je,i as Ge,g as i,s,r as c,A as Ke,h as r,f as n,c as a,j as Q,u as m,x as _,k as I,y as d,a as o,v as p,d as u,t as f,w as h}from"../chunks/index.abf12888.js";import{D as ue}from"../chunks/Docstring.93f6f462.js";import{C as Ne}from"../chunks/CodeBlock.57fe6e13.js";import{H as z}from"../chunks/Heading.16916d63.js";function Ve(_e){let g,F,R,E,v,X,k,we='Improved larger variational autoencoder (VAE) model with KL loss for inpainting task: <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">Designing a Better Asymmetric VQGAN for StableDiffusion</a> by Zixin Zhu, Xuelu Feng, Dongdong Chen, Jianmin Bao, Le Wang, Yinpeng Chen, Lu Yuan, Gang Hua.',q,A,ve="The abstract from the paper is:",H,T,ke='<em>StableDiffusion is a revolutionary text-to-image generator that is causing a stir in the world of image generation and editing. Unlike traditional methods that learn a diffusion model in pixel space, StableDiffusion learns a diffusion model in the latent space via a VQGAN, ensuring both efficiency and quality. It not only supports image generation tasks, but also enables image editing for real images, such as image inpainting and local editing. However, we have observed that the vanilla VQGAN used in StableDiffusion leads to significant information loss, causing distortion artifacts even in non-edited image regions. To this end, we propose a new asymmetric VQGAN with two simple designs. Firstly, in addition to the input from the encoder, the decoder contains a conditional branch that incorporates information from task-specific priors, such as the unmasked image region in inpainting. Secondly, the decoder is much heavier than the encoder, allowing for more detailed recovery while only slightly increasing the total inference cost. The training cost of our asymmetric VQGAN is cheap, and we only need to retrain a new asymmetric decoder while keeping the vanilla VQGAN encoder and StableDiffusion unchanged. Our asymmetric VQGAN can be widely used in StableDiffusion-based inpainting and local editing methods. Extensive experiments demonstrate that it can significantly improve the inpainting and editing performance, while maintaining the original text-to-image capability. The code is available at <a href="https://github.com/buxiangzhiren/Asymmetric_VQGAN" rel="nofollow">https://github.com/buxiangzhiren/Asymmetric_VQGAN</a></em>',O,$,Ae="Evaluation results can be found in section 4.1 of the original paper.",P,M,ee,U,Te='<li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5</a></li> <li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2</a></li>',te,x,ne,J,oe,L,se,l,W,fe,V,$e=`Designing a Better Asymmetric VQGAN for StableDiffusion <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">https://arxiv.org/abs/2306.04632</a> . A VAE model with KL loss
for encoding images into latents and decoding latent representations into images.`,he,D,Me=`This model inherits from <a href="/docs/diffusers/v0.23.0/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,ge,C,Z,ae,j,ie,b,G,be,S,Ue="Output of AutoencoderKL encoding method.",re,K,le,y,N,ye,B,xe="Output of decoding method.",ce,Y,me;return v=new z({props:{title:"AsymmetricAutoencoderKL",local:"asymmetricautoencoderkl",headingTag:"h1"}}),M=new z({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),x=new z({props:{title:"Example Usage",local:"example-usage",headingTag:"h2"}}),J=new Ne({props:{code:"ZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFzeW1tZXRyaWNBdXRvZW5jb2RlcktMJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsJTNBJTIwc3RyKSUyMC0lM0UlMjBJbWFnZS5JbWFnZSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYSUyMHBlcnNvbiUyMiUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcmVwYWludCUyRmNlbGViYV9ocV8yNTYucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcmVwYWludCUyRm1hc2tfMjU2LnBuZyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCgyNTYlMkMlMjAyNTYpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShtYXNrX3VybCkucmVzaXplKCgyNTYlMkMlMjAyNTYpKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyKSUwQXBpcGUudmFlJTIwJTNEJTIwQXN5bW1ldHJpY0F1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMmNyb3NzLWF0dGVudGlvbiUyRmFzeW1tZXRyaWMtYXV0b2VuY29kZXIta2wteC0xLTUlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmltYWdlLmpwZWclMjIp",highlighted:`<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AsymmetricAutoencoderKL, StableDiffusionInpaintPipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; Image.Image:
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


prompt = <span class="hljs-string">&quot;a photo of a person&quot;</span>
img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/celeba_hq_256.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/mask_256.png&quot;</span>

image = download_image(img_url).resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>)
pipe.vae = AsymmetricAutoencoderKL.from_pretrained(<span class="hljs-string">&quot;cross-attention/asymmetric-autoencoder-kl-x-1-5&quot;</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(prompt=prompt, image=image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;image.jpeg&quot;</span>)`,wrap:!1}}),L=new z({props:{title:"AsymmetricAutoencoderKL",local:"diffusers.AsymmetricAutoencoderKL",headingTag:"h2"}}),W=new ue({props:{name:"class diffusers.AsymmetricAutoencoderKL",anchor:"diffusers.AsymmetricAutoencoderKL",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"down_block_types",val:": typing.Tuple[str] = ('DownEncoderBlock2D',)"},{name:"down_block_out_channels",val:": typing.Tuple[int] = (64,)"},{name:"layers_per_down_block",val:": int = 1"},{name:"up_block_types",val:": typing.Tuple[str] = ('UpDecoderBlock2D',)"},{name:"up_block_out_channels",val:": typing.Tuple[int] = (64,)"},{name:"layers_per_up_block",val:": int = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"latent_channels",val:": int = 4"},{name:"norm_num_groups",val:": int = 32"},{name:"sample_size",val:": int = 32"},{name:"scaling_factor",val:": float = 0.18215"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.in_channels",description:"<strong>in_channels</strong> (int, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.out_channels",description:"<strong>out_channels</strong> (int,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;DownEncoderBlock2D&quot;,)</code>) &#x2014;
Tuple of downsample block types.`,name:"down_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_out_channels",description:`<strong>down_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of down block output channels.`,name:"down_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_down_block",description:`<strong>layers_per_down_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for down block.`,name:"layers_per_down_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpDecoderBlock2D&quot;,)</code>) &#x2014;
Tuple of upsample block types.`,name:"up_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_out_channels",description:`<strong>up_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of up block output channels.`,name:"up_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_up_block",description:`<strong>layers_per_up_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for up block.`,name:"layers_per_up_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AsymmetricAutoencoderKL.latent_channels",description:"<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the latent space.",name:"latent_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.sample_size",description:"<strong>sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014; Sample input size.",name:"sample_size"},{anchor:"diffusers.AsymmetricAutoencoderKL.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
Number of groups to use for the first normalization layer in ResNet blocks.`,name:"norm_num_groups"},{anchor:"diffusers.AsymmetricAutoencoderKL.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.0/src/diffusers/models/autoencoder_asym_kl.py#L26"}}),Z=new ue({props:{name:"forward",anchor:"diffusers.AsymmetricAutoencoderKL.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"sample_posterior",val:": bool = False"},{name:"return_dict",val:": bool = True"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample",description:"<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.mask",description:"<strong>mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014; Optional inpainting mask.",name:"mask"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample_posterior",description:`<strong>sample_posterior</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample from the posterior.`,name:"sample_posterior"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.0/src/diffusers/models/autoencoder_asym_kl.py#L153"}}),j=new z({props:{title:"AutoencoderKLOutput",local:"diffusers.models.autoencoder_kl.AutoencoderKLOutput",headingTag:"h2"}}),G=new ue({props:{name:"class diffusers.models.autoencoder_kl.AutoencoderKLOutput",anchor:"diffusers.models.autoencoder_kl.AutoencoderKLOutput",parameters:[{name:"latent_dist",val:": DiagonalGaussianDistribution"}],parametersDescription:[{anchor:"diffusers.models.autoencoder_kl.AutoencoderKLOutput.latent_dist",description:`<strong>latent_dist</strong> (<code>DiagonalGaussianDistribution</code>) &#x2014;
Encoded outputs of <code>Encoder</code> represented as the mean and logvar of <code>DiagonalGaussianDistribution</code>.
<code>DiagonalGaussianDistribution</code> allows for sampling latents from the distribution.`,name:"latent_dist"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.0/src/diffusers/models/autoencoder_kl.py#L36"}}),K=new z({props:{title:"DecoderOutput",local:"diffusers.models.vae.DecoderOutput",headingTag:"h2"}}),N=new ue({props:{name:"class diffusers.models.vae.DecoderOutput",anchor:"diffusers.models.vae.DecoderOutput",parameters:[{name:"sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.models.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/v0.23.0/src/diffusers/models/vae.py#L29"}}),{c(){g=i("meta"),F=s(),R=i("p"),E=s(),c(v.$$.fragment),X=s(),k=i("p"),k.innerHTML=we,q=s(),A=i("p"),A.textContent=ve,H=s(),T=i("p"),T.innerHTML=ke,O=s(),$=i("p"),$.textContent=Ae,P=s(),c(M.$$.fragment),ee=s(),U=i("ul"),U.innerHTML=Te,te=s(),c(x.$$.fragment),ne=s(),c(J.$$.fragment),oe=s(),c(L.$$.fragment),se=s(),l=i("div"),c(W.$$.fragment),fe=s(),V=i("p"),V.innerHTML=$e,he=s(),D=i("p"),D.innerHTML=Me,ge=s(),C=i("div"),c(Z.$$.fragment),ae=s(),c(j.$$.fragment),ie=s(),b=i("div"),c(G.$$.fragment),be=s(),S=i("p"),S.textContent=Ue,re=s(),c(K.$$.fragment),le=s(),y=i("div"),c(N.$$.fragment),ye=s(),B=i("p"),B.textContent=xe,ce=s(),Y=i("p"),this.h()},l(e){const t=Ke("svelte-u9bgzb",document.head);g=r(t,"META",{name:!0,content:!0}),t.forEach(n),F=a(e),R=r(e,"P",{}),Q(R).forEach(n),E=a(e),m(v.$$.fragment,e),X=a(e),k=r(e,"P",{"data-svelte-h":!0}),_(k)!=="svelte-8mpj0"&&(k.innerHTML=we),q=a(e),A=r(e,"P",{"data-svelte-h":!0}),_(A)!=="svelte-1cwsb16"&&(A.textContent=ve),H=a(e),T=r(e,"P",{"data-svelte-h":!0}),_(T)!=="svelte-ggnlwl"&&(T.innerHTML=ke),O=a(e),$=r(e,"P",{"data-svelte-h":!0}),_($)!=="svelte-1vpcrnj"&&($.textContent=Ae),P=a(e),m(M.$$.fragment,e),ee=a(e),U=r(e,"UL",{"data-svelte-h":!0}),_(U)!=="svelte-1m6ravg"&&(U.innerHTML=Te),te=a(e),m(x.$$.fragment,e),ne=a(e),m(J.$$.fragment,e),oe=a(e),m(L.$$.fragment,e),se=a(e),l=r(e,"DIV",{class:!0});var w=Q(l);m(W.$$.fragment,w),fe=a(w),V=r(w,"P",{"data-svelte-h":!0}),_(V)!=="svelte-4v08r1"&&(V.innerHTML=$e),he=a(w),D=r(w,"P",{"data-svelte-h":!0}),_(D)!=="svelte-xkcl48"&&(D.innerHTML=Me),ge=a(w),C=r(w,"DIV",{class:!0});var Je=Q(C);m(Z.$$.fragment,Je),Je.forEach(n),w.forEach(n),ae=a(e),m(j.$$.fragment,e),ie=a(e),b=r(e,"DIV",{class:!0});var de=Q(b);m(G.$$.fragment,de),be=a(de),S=r(de,"P",{"data-svelte-h":!0}),_(S)!=="svelte-1vsc7ag"&&(S.textContent=Ue),de.forEach(n),re=a(e),m(K.$$.fragment,e),le=a(e),y=r(e,"DIV",{class:!0});var pe=Q(y);m(N.$$.fragment,pe),ye=a(pe),B=r(pe,"P",{"data-svelte-h":!0}),_(B)!=="svelte-18u8upa"&&(B.textContent=xe),pe.forEach(n),ce=a(e),Y=r(e,"P",{}),Q(Y).forEach(n),this.h()},h(){I(g,"name","hf:doc:metadata"),I(g,"content",De),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,g),o(e,F,t),o(e,R,t),o(e,E,t),p(v,e,t),o(e,X,t),o(e,k,t),o(e,q,t),o(e,A,t),o(e,H,t),o(e,T,t),o(e,O,t),o(e,$,t),o(e,P,t),p(M,e,t),o(e,ee,t),o(e,U,t),o(e,te,t),p(x,e,t),o(e,ne,t),p(J,e,t),o(e,oe,t),p(L,e,t),o(e,se,t),o(e,l,t),p(W,l,null),d(l,fe),d(l,V),d(l,he),d(l,D),d(l,ge),d(l,C),p(Z,C,null),o(e,ae,t),p(j,e,t),o(e,ie,t),o(e,b,t),p(G,b,null),d(b,be),d(b,S),o(e,re,t),p(K,e,t),o(e,le,t),o(e,y,t),p(N,y,null),d(y,ye),d(y,B),o(e,ce,t),o(e,Y,t),me=!0},p:We,i(e){me||(u(v.$$.fragment,e),u(M.$$.fragment,e),u(x.$$.fragment,e),u(J.$$.fragment,e),u(L.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(j.$$.fragment,e),u(G.$$.fragment,e),u(K.$$.fragment,e),u(N.$$.fragment,e),me=!0)},o(e){f(v.$$.fragment,e),f(M.$$.fragment,e),f(x.$$.fragment,e),f(J.$$.fragment,e),f(L.$$.fragment,e),f(W.$$.fragment,e),f(Z.$$.fragment,e),f(j.$$.fragment,e),f(G.$$.fragment,e),f(K.$$.fragment,e),f(N.$$.fragment,e),me=!1},d(e){e&&(n(F),n(R),n(E),n(X),n(k),n(q),n(A),n(H),n(T),n(O),n($),n(P),n(ee),n(U),n(te),n(ne),n(oe),n(se),n(l),n(ae),n(ie),n(b),n(re),n(le),n(y),n(ce),n(Y)),n(g),h(v,e),h(M,e),h(x,e),h(J,e),h(L,e),h(W),h(Z),h(j,e),h(G),h(K,e),h(N)}}}const De='{"title":"AsymmetricAutoencoderKL","local":"asymmetricautoencoderkl","sections":[{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Example Usage","local":"example-usage","sections":[],"depth":2},{"title":"AsymmetricAutoencoderKL","local":"diffusers.AsymmetricAutoencoderKL","sections":[],"depth":2},{"title":"AutoencoderKLOutput","local":"diffusers.models.autoencoder_kl.AutoencoderKLOutput","sections":[],"depth":2},{"title":"DecoderOutput","local":"diffusers.models.vae.DecoderOutput","sections":[],"depth":2}],"depth":1}';function Ce(_e){return Ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Re extends je{constructor(g){super(),Ge(this,g,Ce,Ve,Le,{})}}export{Re as component};
