import{s as we,o as $e,n as he}from"../chunks/scheduler.182ea377.js";import{S as Te,i as ye,g as r,s as l,r as h,A as ge,h as p,f as n,c as i,j as fe,u as w,x as f,k as de,y as be,a as s,v as $,d as T,t as y,w as g}from"../chunks/index.abf12888.js";import{T as ue}from"../chunks/Tip.230e2334.js";import{C as ce}from"../chunks/CodeBlock.57fe6e13.js";import{H as ee}from"../chunks/Heading.16916d63.js";function Me(P){let a,m='In many cases, optimizing for speed or memory leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on inference speed, but you can learn more about preserving memory in the <a href="memory">Reduce memory usage</a> guide.';return{c(){a=r("p"),a.innerHTML=m},l(o){a=p(o,"P",{"data-svelte-h":!0}),f(a)!=="svelte-1dpd5a8"&&(a.innerHTML=m)},m(o,d){s(o,a,d)},p:he,d(o){o&&n(a)}}}function Je(P){let a,m='Don’t use <a href="https://pytorch.org/docs/stable/amp.html#torch.autocast" rel="nofollow"><code>torch.autocast</code></a> in any of the pipelines as it can lead to black images and is always slower than pure float16 precision.';return{c(){a=r("p"),a.innerHTML=m},l(o){a=p(o,"P",{"data-svelte-h":!0}),f(a)!=="svelte-19ow5yd"&&(a.innerHTML=m)},m(o,d){s(o,a,d)},p:he,d(o){o&&n(a)}}}function ve(P){let a,m,o,d,b,W,M,te='There are several ways to optimize 🤗 Diffusers for inference speed. As a general rule of thumb, we recommend using either <a href="xformers">xFormers</a> or <code>torch.nn.functional.scaled_dot_product_attention</code> in PyTorch 2.0 for their memory-efficient attention.',B,u,D,J,ne="The results below are obtained from generating a single 512x512 image from the prompt <code>a photo of an astronaut riding a horse on mars</code> with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect.",S,v,se="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",k,_,F,U,ae='On Ampere and later CUDA devices, matrix multiplications and convolutions can use the <a href="https://blogs.nvidia.com/blog/2020/05/14/tensorfloat-32-precision-format/" rel="nofollow">TensorFloat-32 (TF32)</a> mode for faster, but slightly less accurate computations. By default, PyTorch enables TF32 mode for convolutions but not matrix multiplications. Unless your network requires full float32 precision, we recommend enabling TF32 for matrix multiplications. It can significantly speeds up computations with typically negligible loss in numerical accuracy.',R,x,z,C,le='You can learn more about TF32 in the <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_one#tf32" rel="nofollow">Mixed precision training</a> guide.',N,I,V,H,ie="To save GPU memory and get more speed, try loading and running the model weights directly in half-precision or float16:",X,j,q,c,Y,E,Q,L,oe="You could also use a distilled Stable Diffusion model and autoencoder to speed up inference. During distillation, many of the UNet’s residual and attention blocks are shed to reduce the model size. The distilled model is faster and uses less memory while generating images of comparable quality to the full Stable Diffusion model.",A,G,re='Learn more about in the <a href="../using-diffusers/distilled_sd">Distilled Stable Diffusion inference</a> guide!',K,Z,O;return b=new ee({props:{title:"Speed up inference",local:"speed-up-inference",headingTag:"h1"}}),u=new ue({props:{$$slots:{default:[Me]},$$scope:{ctx:P}}}),_=new ee({props:{title:"Use TensorFloat-32",local:"use-tensorfloat-32",headingTag:"h2"}}),x=new ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">import</span> torch

torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>`,wrap:!1}}),I=new ee({props:{title:"Half-precision weights",local:"half-precision-weights",headingTag:"h2"}}),j=new ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),c=new ue({props:{warning:!0,$$slots:{default:[Je]},$$scope:{ctx:P}}}),E=new ee({props:{title:"Distilled model",local:"distilled-model",headingTag:"h2"}}),{c(){a=r("meta"),m=l(),o=r("p"),d=l(),h(b.$$.fragment),W=l(),M=r("p"),M.innerHTML=te,B=l(),h(u.$$.fragment),D=l(),J=r("p"),J.innerHTML=ne,S=l(),v=r("table"),v.innerHTML=se,k=l(),h(_.$$.fragment),F=l(),U=r("p"),U.innerHTML=ae,R=l(),h(x.$$.fragment),z=l(),C=r("p"),C.innerHTML=le,N=l(),h(I.$$.fragment),V=l(),H=r("p"),H.textContent=ie,X=l(),h(j.$$.fragment),q=l(),h(c.$$.fragment),Y=l(),h(E.$$.fragment),Q=l(),L=r("p"),L.textContent=oe,A=l(),G=r("p"),G.innerHTML=re,K=l(),Z=r("p"),this.h()},l(e){const t=ge("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(n),m=i(e),o=p(e,"P",{}),fe(o).forEach(n),d=i(e),w(b.$$.fragment,e),W=i(e),M=p(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1pehmy1"&&(M.innerHTML=te),B=i(e),w(u.$$.fragment,e),D=i(e),J=p(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-1iu9895"&&(J.innerHTML=ne),S=i(e),v=p(e,"TABLE",{"data-svelte-h":!0}),f(v)!=="svelte-1osaemz"&&(v.innerHTML=se),k=i(e),w(_.$$.fragment,e),F=i(e),U=p(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-sgc3mn"&&(U.innerHTML=ae),R=i(e),w(x.$$.fragment,e),z=i(e),C=p(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-ahb0o9"&&(C.innerHTML=le),N=i(e),w(I.$$.fragment,e),V=i(e),H=p(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-rv9wu9"&&(H.textContent=ie),X=i(e),w(j.$$.fragment,e),q=i(e),w(c.$$.fragment,e),Y=i(e),w(E.$$.fragment,e),Q=i(e),L=p(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-yfaonv"&&(L.textContent=oe),A=i(e),G=p(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-1f6kjv7"&&(G.innerHTML=re),K=i(e),Z=p(e,"P",{}),fe(Z).forEach(n),this.h()},h(){de(a,"name","hf:doc:metadata"),de(a,"content",_e)},m(e,t){be(document.head,a),s(e,m,t),s(e,o,t),s(e,d,t),$(b,e,t),s(e,W,t),s(e,M,t),s(e,B,t),$(u,e,t),s(e,D,t),s(e,J,t),s(e,S,t),s(e,v,t),s(e,k,t),$(_,e,t),s(e,F,t),s(e,U,t),s(e,R,t),$(x,e,t),s(e,z,t),s(e,C,t),s(e,N,t),$(I,e,t),s(e,V,t),s(e,H,t),s(e,X,t),$(j,e,t),s(e,q,t),$(c,e,t),s(e,Y,t),$(E,e,t),s(e,Q,t),s(e,L,t),s(e,A,t),s(e,G,t),s(e,K,t),s(e,Z,t),O=!0},p(e,[t]){const pe={};t&2&&(pe.$$scope={dirty:t,ctx:e}),u.$set(pe);const me={};t&2&&(me.$$scope={dirty:t,ctx:e}),c.$set(me)},i(e){O||(T(b.$$.fragment,e),T(u.$$.fragment,e),T(_.$$.fragment,e),T(x.$$.fragment,e),T(I.$$.fragment,e),T(j.$$.fragment,e),T(c.$$.fragment,e),T(E.$$.fragment,e),O=!0)},o(e){y(b.$$.fragment,e),y(u.$$.fragment,e),y(_.$$.fragment,e),y(x.$$.fragment,e),y(I.$$.fragment,e),y(j.$$.fragment,e),y(c.$$.fragment,e),y(E.$$.fragment,e),O=!1},d(e){e&&(n(m),n(o),n(d),n(W),n(M),n(B),n(D),n(J),n(S),n(v),n(k),n(F),n(U),n(R),n(z),n(C),n(N),n(V),n(H),n(X),n(q),n(Y),n(Q),n(L),n(A),n(G),n(K),n(Z)),n(a),g(b,e),g(u,e),g(_,e),g(x,e),g(I,e),g(j,e),g(c,e),g(E,e)}}}const _e='{"title":"Speed up inference","local":"speed-up-inference","sections":[{"title":"Use TensorFloat-32","local":"use-tensorfloat-32","sections":[],"depth":2},{"title":"Half-precision weights","local":"half-precision-weights","sections":[],"depth":2},{"title":"Distilled model","local":"distilled-model","sections":[],"depth":2}],"depth":1}';function Ue(P){return $e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends Te{constructor(a){super(),ye(this,a,Ue,ve,we,{})}}export{Ee as component};
