import{s as lo,n as io,o as so}from"../chunks/scheduler.9039eef2.js";import{S as co,i as po,g as l,s as a,r as m,A as mo,h as i,f as t,c as r,j as _,u as h,x as d,k as v,l as ho,y as o,a as s,v as g,d as u,t as f,w as M}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{C as vn}from"../chunks/CodeBlock.8580f3e8.js";import{H as xe}from"../chunks/Heading.f027f30d.js";function go(bn){let C,Ye,Ve,Ke,q,et,E,yn='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',tt,H,Tn="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",nt,z,ot,N,wn='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',at,j,$n='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',rt,W,xn="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",lt,B,Cn="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",it,S,jn="for example:",st,F,dt,Q,Un="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",ct,Z,pt,R,Pn="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",mt,X,ht,V,Dn="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",gt,G,ut,Y,Jn="After this one can then call:",ft,K,Mt,ee,In="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",_t,te,vt,ne,On="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",bt,oe,An='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',yt,ae,Ln='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer.',Tt,re,kn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Use the <code>loss_type=&quot;cdpo&quot;</code> argument to the trainer to use it.',wt,le,qn='The <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">KTO</a> loss is derived to directly maximize the utility of LLM generations instead of the log-likelihood of prefereces. Thus the dataset are not neccsarily prefereces but rather desirable vs undersirable pairs. Use the <code>loss_type=&quot;kto&quot;</code> argument to the trainer to utilize this loss.',$t,ie,xt,se,En="While training and evaluating we record the following reward metrics:",Ct,de,Hn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",jt,ce,Ut,c,pe,Ht,Ce,zn="Initialize DPOTrainer.",zt,U,me,Nt,je,Nn=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Wt,P,he,Bt,Ue,Wn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",St,T,ge,Ft,Pe,Bn="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Qt,De,Sn="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Zt,D,ue,Rt,Je,Fn="Concatenate the chosen and rejected inputs into a single tensor.",Xt,J,fe,Vt,Ie,Qn="Compute the DPO loss for a batch of policy and reference model log probabilities.",Gt,w,Me,Yt,Oe,Zn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Kt,Ae,Rn="Works both with or without labels.",en,I,_e,tn,Le,Xn="Compute the log probabilities of the given labels under the given logits.",nn,O,ve,on,ke,Vn="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",an,A,be,rn,qe,Gn="Generate samples from the model and reference model for the given batch of inputs.",ln,$,ye,sn,Ee,Yn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",dn,He,Kn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",cn,x,Te,pn,ze,eo="Returns the training <code>~torch.utils.data.DataLoader</code>.",mn,Ne,to="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",hn,L,we,gn,We,no="Log <code>logs</code> on the various objects watching training, including stored metrics.",un,y,$e,fn,Be,oo="Tokenize a single row from a DPO specific dataset.",Mn,Se,ao=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,_n,Fe,ro=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Pt,Ge,Dt;return q=new xe({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),z=new xe({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),F=new vn({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),Z=new xe({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),X=new xe({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),G=new vn({props:{code:"JTIwZHBvX3RyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcmVmJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:` dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),K=new vn({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),te=new xe({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),ie=new xe({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ce=new xe({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),pe=new b({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge', 'ipo', 'kto'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L57"}}),me=new b({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L497"}}),he=new b({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": typing.Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L670"}}),ge=new b({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L860"}}),ue=new b({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": typing.Optional[torch.device] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L694",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),fe=new b({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L756",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Me=new b({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1069"}}),_e=new b({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L824",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ve=new b({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L906"}}),be=new b({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L985"}}),ye=new b({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L448"}}),Te=new b({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L405"}}),we=new b({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1119"}}),$e=new b({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L547"}}),{c(){C=l("meta"),Ye=a(),Ve=l("p"),Ke=a(),m(q.$$.fragment),et=a(),E=l("p"),E.innerHTML=yn,tt=a(),H=l("p"),H.textContent=Tn,nt=a(),m(z.$$.fragment),ot=a(),N=l("p"),N.innerHTML=wn,at=a(),j=l("div"),j.innerHTML=$n,rt=a(),W=l("p"),W.innerHTML=xn,lt=a(),B=l("ul"),B.innerHTML=Cn,it=a(),S=l("p"),S.textContent=jn,st=a(),m(F.$$.fragment),dt=a(),Q=l("p"),Q.innerHTML=Un,ct=a(),m(Z.$$.fragment),pt=a(),R=l("p"),R.innerHTML=Pn,mt=a(),m(X.$$.fragment),ht=a(),V=l("p"),V.innerHTML=Dn,gt=a(),m(G.$$.fragment),ut=a(),Y=l("p"),Y.textContent=Jn,ft=a(),m(K.$$.fragment),Mt=a(),ee=l("p"),ee.innerHTML=In,_t=a(),m(te.$$.fragment),vt=a(),ne=l("p"),ne.innerHTML=On,bt=a(),oe=l("p"),oe.innerHTML=An,yt=a(),ae=l("p"),ae.innerHTML=Ln,Tt=a(),re=l("p"),re.innerHTML=kn,wt=a(),le=l("p"),le.innerHTML=qn,$t=a(),m(ie.$$.fragment),xt=a(),se=l("p"),se.textContent=En,Ct=a(),de=l("ul"),de.innerHTML=Hn,jt=a(),m(ce.$$.fragment),Ut=a(),c=l("div"),m(pe.$$.fragment),Ht=a(),Ce=l("p"),Ce.textContent=zn,zt=a(),U=l("div"),m(me.$$.fragment),Nt=a(),je=l("p"),je.innerHTML=Nn,Wt=a(),P=l("div"),m(he.$$.fragment),Bt=a(),Ue=l("p"),Ue.textContent=Wn,St=a(),T=l("div"),m(ge.$$.fragment),Ft=a(),Pe=l("p"),Pe.textContent=Bn,Qt=a(),De=l("p"),De.textContent=Sn,Zt=a(),D=l("div"),m(ue.$$.fragment),Rt=a(),Je=l("p"),Je.textContent=Fn,Xt=a(),J=l("div"),m(fe.$$.fragment),Vt=a(),Ie=l("p"),Ie.textContent=Qn,Gt=a(),w=l("div"),m(Me.$$.fragment),Yt=a(),Oe=l("p"),Oe.innerHTML=Zn,Kt=a(),Ae=l("p"),Ae.textContent=Rn,en=a(),I=l("div"),m(_e.$$.fragment),tn=a(),Le=l("p"),Le.textContent=Xn,nn=a(),O=l("div"),m(ve.$$.fragment),on=a(),ke=l("p"),ke.textContent=Vn,an=a(),A=l("div"),m(be.$$.fragment),rn=a(),qe=l("p"),qe.textContent=Gn,ln=a(),$=l("div"),m(ye.$$.fragment),sn=a(),Ee=l("p"),Ee.innerHTML=Yn,dn=a(),He=l("p"),He.innerHTML=Kn,cn=a(),x=l("div"),m(Te.$$.fragment),pn=a(),ze=l("p"),ze.innerHTML=eo,mn=a(),Ne=l("p"),Ne.innerHTML=to,hn=a(),L=l("div"),m(we.$$.fragment),gn=a(),We=l("p"),We.innerHTML=no,un=a(),y=l("div"),m($e.$$.fragment),fn=a(),Be=l("p"),Be.textContent=oo,Mn=a(),Se=l("p"),Se.textContent=ao,_n=a(),Fe=l("p"),Fe.textContent=ro,Pt=a(),Ge=l("p"),this.h()},l(e){const n=mo("svelte-u9bgzb",document.head);C=i(n,"META",{name:!0,content:!0}),n.forEach(t),Ye=r(e),Ve=i(e,"P",{}),_(Ve).forEach(t),Ke=r(e),h(q.$$.fragment,e),et=r(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-5p7twb"&&(E.innerHTML=yn),tt=r(e),H=i(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-xh4sh7"&&(H.textContent=Tn),nt=r(e),h(z.$$.fragment,e),ot=r(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-dcawbe"&&(N.innerHTML=wn),at=r(e),j=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(j)!=="svelte-z15c7z"&&(j.innerHTML=$n),rt=r(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-cb9b0v"&&(W.innerHTML=xn),lt=r(e),B=i(e,"UL",{"data-svelte-h":!0}),d(B)!=="svelte-17vxuta"&&(B.innerHTML=Cn),it=r(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1gl9mvz"&&(S.textContent=jn),st=r(e),h(F.$$.fragment,e),dt=r(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1a8oxjk"&&(Q.innerHTML=Un),ct=r(e),h(Z.$$.fragment,e),pt=r(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-174yw9s"&&(R.innerHTML=Pn),mt=r(e),h(X.$$.fragment,e),ht=r(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1wn9xrv"&&(V.innerHTML=Dn),gt=r(e),h(G.$$.fragment,e),ut=r(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1lg6q1l"&&(Y.textContent=Jn),ft=r(e),h(K.$$.fragment,e),Mt=r(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1ac5mum"&&(ee.innerHTML=In),_t=r(e),h(te.$$.fragment,e),vt=r(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-7nvktz"&&(ne.innerHTML=On),bt=r(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-bl9wh7"&&(oe.innerHTML=An),yt=r(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1x8box7"&&(ae.innerHTML=Ln),Tt=r(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-x8vvul"&&(re.innerHTML=kn),wt=r(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-pbk8wo"&&(le.innerHTML=qn),$t=r(e),h(ie.$$.fragment,e),xt=r(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-132s7j9"&&(se.textContent=En),Ct=r(e),de=i(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-1oji3mm"&&(de.innerHTML=Hn),jt=r(e),h(ce.$$.fragment,e),Ut=r(e),c=i(e,"DIV",{class:!0});var p=_(c);h(pe.$$.fragment,p),Ht=r(p),Ce=i(p,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-n6cc8y"&&(Ce.textContent=zn),zt=r(p),U=i(p,"DIV",{class:!0});var Jt=_(U);h(me.$$.fragment,Jt),Nt=r(Jt),je=i(Jt,"P",{"data-svelte-h":!0}),d(je)!=="svelte-mcz8nm"&&(je.innerHTML=Nn),Jt.forEach(t),Wt=r(p),P=i(p,"DIV",{class:!0});var It=_(P);h(he.$$.fragment,It),Bt=r(It),Ue=i(It,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-10t1062"&&(Ue.textContent=Wn),It.forEach(t),St=r(p),T=i(p,"DIV",{class:!0});var Qe=_(T);h(ge.$$.fragment,Qe),Ft=r(Qe),Pe=i(Qe,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-16i1nac"&&(Pe.textContent=Bn),Qt=r(Qe),De=i(Qe,"P",{"data-svelte-h":!0}),d(De)!=="svelte-tgti68"&&(De.textContent=Sn),Qe.forEach(t),Zt=r(p),D=i(p,"DIV",{class:!0});var Ot=_(D);h(ue.$$.fragment,Ot),Rt=r(Ot),Je=i(Ot,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1cvsgkk"&&(Je.textContent=Fn),Ot.forEach(t),Xt=r(p),J=i(p,"DIV",{class:!0});var At=_(J);h(fe.$$.fragment,At),Vt=r(At),Ie=i(At,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-ymgxq7"&&(Ie.textContent=Qn),At.forEach(t),Gt=r(p),w=i(p,"DIV",{class:!0});var Ze=_(w);h(Me.$$.fragment,Ze),Yt=r(Ze),Oe=i(Ze,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-8qlty5"&&(Oe.innerHTML=Zn),Kt=r(Ze),Ae=i(Ze,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1tyo99t"&&(Ae.textContent=Rn),Ze.forEach(t),en=r(p),I=i(p,"DIV",{class:!0});var Lt=_(I);h(_e.$$.fragment,Lt),tn=r(Lt),Le=i(Lt,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-4nmimv"&&(Le.textContent=Xn),Lt.forEach(t),nn=r(p),O=i(p,"DIV",{class:!0});var kt=_(O);h(ve.$$.fragment,kt),on=r(kt),ke=i(kt,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-11q8u7l"&&(ke.textContent=Vn),kt.forEach(t),an=r(p),A=i(p,"DIV",{class:!0});var qt=_(A);h(be.$$.fragment,qt),rn=r(qt),qe=i(qt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-18uwvbi"&&(qe.textContent=Gn),qt.forEach(t),ln=r(p),$=i(p,"DIV",{class:!0});var Re=_($);h(ye.$$.fragment,Re),sn=r(Re),Ee=i(Re,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-xesobz"&&(Ee.innerHTML=Yn),dn=r(Re),He=i(Re,"P",{"data-svelte-h":!0}),d(He)!=="svelte-qg43tm"&&(He.innerHTML=Kn),Re.forEach(t),cn=r(p),x=i(p,"DIV",{class:!0});var Xe=_(x);h(Te.$$.fragment,Xe),pn=r(Xe),ze=i(Xe,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-dkae9b"&&(ze.innerHTML=eo),mn=r(Xe),Ne=i(Xe,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-hmd5cw"&&(Ne.innerHTML=to),Xe.forEach(t),hn=r(p),L=i(p,"DIV",{class:!0});var Et=_(L);h(we.$$.fragment,Et),gn=r(Et),We=i(Et,"P",{"data-svelte-h":!0}),d(We)!=="svelte-nqksfz"&&(We.innerHTML=no),Et.forEach(t),un=r(p),y=i(p,"DIV",{class:!0});var k=_(y);h($e.$$.fragment,k),fn=r(k),Be=i(k,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1861yti"&&(Be.textContent=oo),Mn=r(k),Se=i(k,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1mn1gnw"&&(Se.textContent=ao),_n=r(k),Fe=i(k,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1xvpyih"&&(Fe.textContent=ro),k.forEach(t),p.forEach(t),Pt=r(e),Ge=i(e,"P",{}),_(Ge).forEach(t),this.h()},h(){v(C,"name","hf:doc:metadata"),v(C,"content",uo),ho(j,"text-align","center"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){o(document.head,C),s(e,Ye,n),s(e,Ve,n),s(e,Ke,n),g(q,e,n),s(e,et,n),s(e,E,n),s(e,tt,n),s(e,H,n),s(e,nt,n),g(z,e,n),s(e,ot,n),s(e,N,n),s(e,at,n),s(e,j,n),s(e,rt,n),s(e,W,n),s(e,lt,n),s(e,B,n),s(e,it,n),s(e,S,n),s(e,st,n),g(F,e,n),s(e,dt,n),s(e,Q,n),s(e,ct,n),g(Z,e,n),s(e,pt,n),s(e,R,n),s(e,mt,n),g(X,e,n),s(e,ht,n),s(e,V,n),s(e,gt,n),g(G,e,n),s(e,ut,n),s(e,Y,n),s(e,ft,n),g(K,e,n),s(e,Mt,n),s(e,ee,n),s(e,_t,n),g(te,e,n),s(e,vt,n),s(e,ne,n),s(e,bt,n),s(e,oe,n),s(e,yt,n),s(e,ae,n),s(e,Tt,n),s(e,re,n),s(e,wt,n),s(e,le,n),s(e,$t,n),g(ie,e,n),s(e,xt,n),s(e,se,n),s(e,Ct,n),s(e,de,n),s(e,jt,n),g(ce,e,n),s(e,Ut,n),s(e,c,n),g(pe,c,null),o(c,Ht),o(c,Ce),o(c,zt),o(c,U),g(me,U,null),o(U,Nt),o(U,je),o(c,Wt),o(c,P),g(he,P,null),o(P,Bt),o(P,Ue),o(c,St),o(c,T),g(ge,T,null),o(T,Ft),o(T,Pe),o(T,Qt),o(T,De),o(c,Zt),o(c,D),g(ue,D,null),o(D,Rt),o(D,Je),o(c,Xt),o(c,J),g(fe,J,null),o(J,Vt),o(J,Ie),o(c,Gt),o(c,w),g(Me,w,null),o(w,Yt),o(w,Oe),o(w,Kt),o(w,Ae),o(c,en),o(c,I),g(_e,I,null),o(I,tn),o(I,Le),o(c,nn),o(c,O),g(ve,O,null),o(O,on),o(O,ke),o(c,an),o(c,A),g(be,A,null),o(A,rn),o(A,qe),o(c,ln),o(c,$),g(ye,$,null),o($,sn),o($,Ee),o($,dn),o($,He),o(c,cn),o(c,x),g(Te,x,null),o(x,pn),o(x,ze),o(x,mn),o(x,Ne),o(c,hn),o(c,L),g(we,L,null),o(L,gn),o(L,We),o(c,un),o(c,y),g($e,y,null),o(y,fn),o(y,Be),o(y,Mn),o(y,Se),o(y,_n),o(y,Fe),s(e,Pt,n),s(e,Ge,n),Dt=!0},p:io,i(e){Dt||(u(q.$$.fragment,e),u(z.$$.fragment,e),u(F.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(Me.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),Dt=!0)},o(e){f(q.$$.fragment,e),f(z.$$.fragment,e),f(F.$$.fragment,e),f(Z.$$.fragment,e),f(X.$$.fragment,e),f(G.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ie.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(Me.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f($e.$$.fragment,e),Dt=!1},d(e){e&&(t(Ye),t(Ve),t(Ke),t(et),t(E),t(tt),t(H),t(nt),t(ot),t(N),t(at),t(j),t(rt),t(W),t(lt),t(B),t(it),t(S),t(st),t(dt),t(Q),t(ct),t(pt),t(R),t(mt),t(ht),t(V),t(gt),t(ut),t(Y),t(ft),t(Mt),t(ee),t(_t),t(vt),t(ne),t(bt),t(oe),t(yt),t(ae),t(Tt),t(re),t(wt),t(le),t($t),t(xt),t(se),t(Ct),t(de),t(jt),t(Ut),t(c),t(Pt),t(Ge)),t(C),M(q,e),M(z,e),M(F,e),M(Z,e),M(X,e),M(G,e),M(K,e),M(te,e),M(ie,e),M(ce,e),M(pe),M(me),M(he),M(ge),M(ue),M(fe),M(Me),M(_e),M(ve),M(be),M(ye),M(Te),M(we),M($e)}}}const uo='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2}],"depth":1}';function fo(bn){return so(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class To extends co{constructor(C){super(),po(this,C,fo,go,lo,{})}}export{To as component};
