import{s as Fo,n as zo,o as Io}from"../chunks/scheduler.9039eef2.js";import{S as Mo,i as qo,g as r,s as n,r as d,A as So,h as o,f as i,c as a,j as _,u as c,x as l,k as u,y as t,a as v,v as p,d as m,t as g,w as h}from"../chunks/index.ded8f90d.js";import{D as f}from"../chunks/Docstring.a2ba2b54.js";import{H as C}from"../chunks/Heading.f027f30d.js";function Ao(zr){let q,mn,cn,gn,pe,hn,me,Ir=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,_n,ge,un,S,he,da,st,Mr="Configuration class for PPOTrainer",fn,_e,vn,T,ue,ca,lt,qr=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,pa,U,fe,ma,dt,Sr="Calculate model outputs in multiple batches.",ga,R,ve,ha,ct,Ar="Compute per token rewards from scores and KL-penalty.",_a,V,be,ua,pt,Er="Creates and saves a model card for a TRL model.",fa,j,Te,va,mt,Hr="Gather stats from all processes. Useful in the context of distributed training.",ba,W,ye,Ta,gt,Ur=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,ya,B,xe,xa,ht,Rr="A function that logs all the training stats. Call it at the end of each epoch.",$a,G,$e,Pa,_t,Vr="Calculate policy and value losses.",Oa,J,Pe,Da,ut,jr="Prepare the dataloader for training.",wa,K,Oe,ka,ft,Wr="Record training step statistics.",Ca,Y,De,La,vt,Br="Run a PPO optimisation step given a list of queries, model responses, and rewards.",Na,Z,we,Fa,bt,Gr="Train one PPO minibatch",bn,ke,Tn,w,Ce,za,Tt,Jr='RewardConfig collects all training arguments related to the <a href="/docs/trl/main/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a> class.',Ia,yt,Kr=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,yn,Le,xn,$,Ne,Ma,xt,Yr=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,qa,$t,Zr=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,Sa,Pt,Qr="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Aa,Ot,Xr=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,$n,Fe,Pn,A,ze,Ea,Dt,eo=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,On,Ie,Dn,b,Me,Ha,wt,to="Initialize DPOTrainer.",Ua,Q,qe,Ra,kt,no=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Va,X,Se,ja,Ct,ao="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Wa,L,Ae,Ba,Lt,ro="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Ga,Nt,oo="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Ja,ee,Ee,Ka,Ft,io="Concatenate the chosen and rejected inputs into a single tensor.",Ya,te,He,Za,zt,so="Compute the DPO loss for a batch of policy and reference model log probabilities.",Qa,N,Ue,Xa,It,lo=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,er,Mt,co="Works both with or without labels.",tr,ne,Re,nr,qt,po="Compute the log probabilities of the given labels under the given logits.",ar,ae,Ve,rr,St,mo="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",or,re,je,ir,At,go="Generate samples from the model and reference model for the given batch of inputs.",sr,F,We,lr,Et,ho="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",dr,Ht,_o="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",cr,z,Be,pr,Ut,uo="Returns the training <code>~torch.utils.data.DataLoader</code>.",mr,Rt,fo="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",gr,oe,Ge,hr,Vt,vo="Log <code>logs</code> on the various objects watching training, including stored metrics.",_r,O,Je,ur,jt,bo="Tokenize a single row from a DPO specific dataset.",fr,Wt,To=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,vr,Bt,yo=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,wn,Ke,kn,E,Ye,br,Gt,xo="Configuration class for DDPOTrainer",Cn,Ze,Ln,P,Qe,Tr,Jt,$o=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,yr,ie,Xe,xr,Kt,Po="Calculate the loss for a batch of an unpacked sample",$r,D,et,Pr,Yt,Oo="Perform a single step of training.",Or,Zt,Do="Side Effects:",Dr,Qt,wo="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",wr,se,tt,kr,Xt,ko="Train the model for a given number of epochs",Nn,nt,Fn,k,at,Cr,en,Co="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",Lr,le,rt,Nr,tn,Lo="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",zn,ot,In,H,it,Fr,nn,No="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",Mn,pn,qn;return pe=new C({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),ge=new C({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),he=new f({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"task_name",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"query_dataset",val:": typing.Optional[str] = None"},{name:"reward_model",val:": typing.Optional[str] = None"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"accelerator_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"project_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": typing.Optional[float] = 0.2"},{name:"kl_penalty",val:": typing.Literal['kl', 'abs', 'mse', 'full'] = 'kl'"},{name:"target",val:": typing.Optional[float] = 6"},{name:"horizon",val:": typing.Optional[float] = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 256"},{name:"forward_batch_size",val:": typing.Optional[int] = None"},{name:"mini_batch_size",val:": int = 1"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": typing.Optional[float] = None"},{name:"optimize_cuda_cache",val:": typing.Optional[bool] = None"},{name:"optimize_device_cache",val:": typing.Optional[bool] = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": typing.Optional[float] = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"is_peft_model",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L35"}}),_e=new C({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),ue=new f({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": PPOConfig = None"},{name:"model",val:": PreTrainedModelWrapper = None"},{name:"ref_model",val:": typing.Optional[trl.models.modeling_base.PreTrainedModelWrapper] = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset, NoneType] = None"},{name:"optimizer",val:": typing.Optional[torch.optim.optimizer.Optimizer] = None"},{name:"data_collator",val:": typing.Optional[typing.Callable] = None"},{name:"num_shared_layers",val:": typing.Optional[int] = None"},{name:"lr_scheduler",val:": typing.Optional[torch.optim.lr_scheduler._LRScheduler] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L108"}}),fe=new f({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L935",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),ve=new f({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1072"}}),be=new f({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": typing.Optional[str] = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1371"}}),Te=new f({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),ye=new f({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor]]"},{name:"length_sampler",val:": typing.Callable = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L426",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),xe=new f({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": typing.List[torch.FloatTensor]"},{name:"columns_to_log",val:": typing.List[str] = ['query', 'response']"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1300"}}),$e=new f({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1148"}}),Pe=new f({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset]"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),Oe=new f({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),De=new f({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": typing.List[torch.LongTensor]"},{name:"responses",val:": typing.List[torch.LongTensor]"},{name:"scores",val:": typing.List[torch.FloatTensor]"},{name:"response_masks",val:": typing.Optional[typing.List[torch.LongTensor]] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),we=new f({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1026",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),ke=new C({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),Ce=new f({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Optional[typing.Dict] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Optional[str] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"deepspeed",val:": typing.Optional[str] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Optional[typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": typing.Optional[bool] = True"},{name:"gradient_checkpointing_kwargs",val:": typing.Optional[dict] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = False"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": float = None"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/training_configs.py#L23"}}),Le=new C({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),Ne=new f({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"},{name:"args",val:": typing.Optional[trl.trainer.training_configs.RewardConfig] = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_trainer.py#L36"}}),Fe=new C({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),ze=new f({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = None"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instrcution
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L52"}}),Ie=new C({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Me=new f({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge', 'ipo', 'kto'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L57"}}),qe=new f({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L497"}}),Se=new f({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": typing.Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L670"}}),Ae=new f({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L860"}}),Ee=new f({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": typing.Optional[torch.device] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L694",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),He=new f({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L756",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ue=new f({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1069"}}),Re=new f({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L824",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Ve=new f({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L906"}}),je=new f({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L985"}}),We=new f({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L448"}}),Be=new f({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L405"}}),Ge=new f({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1119"}}),Je=new f({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L547"}}),Ke=new C({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),Ye=new f({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": typing.Optional[str] = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": typing.Optional[str] = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": typing.Optional[str] = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_config.py#L12"}}),Ze=new C({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),Qe=new f({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": typing.Callable[[torch.Tensor, typing.Tuple[str], typing.Tuple[typing.Any]], torch.Tensor]"},{name:"prompt_function",val:": typing.Callable[[], typing.Tuple[str, typing.Any]]"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": typing.Union[typing.Callable[[typing.Any, typing.Any, typing.Any], typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L34"}}),Xe=new f({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_steps, &#x2026;]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_steps, &#x2026;]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L311",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),et=new f({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L205",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),tt=new f({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L565"}}),nt=new C({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),at=new f({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": PreTrainedModel = None"},{name:"args",val:": TrainingArguments = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": typing.Optional[str] = 'keep_end'"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"optimize_device_cache",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModel</code>) &#x2014; Model to be optimized, either an &#x2018;AutoModelForCausalLM&#x2019; or an &#x2018;AutoModelForSeq2SeqLM&#x2019;. &#x2014;
Check the documentation of <code>PreTrainedModel</code> for more details.`,name:"*model**"},{anchor:"trl.IterativeSFTTrainer.*args**",description:"*<strong>*args**</strong> (<code>transformers.TrainingArguments</code>) &#x2014; &#x2014; The arguments to use for training.",name:"*args**"},{anchor:"trl.IterativeSFTTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.IterativeSFTTrainer.*optimizers**",description:"*<strong>*optimizers**</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014; &#x2014; The optimizer and scheduler to use for training.",name:"*optimizers**"},{anchor:"trl.IterativeSFTTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (Union[DataCollatorForLanguageModeling, DataCollatorForSeq2Seq], <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader.`,name:"*data_collator**"},{anchor:"trl.IterativeSFTTrainer.*eval_dataset**",description:"*<strong>*eval_dataset**</strong> (<code>datasets.Dataset</code>) &#x2014; The dataset to use for evaluation.",name:"*eval_dataset**"},{anchor:"trl.IterativeSFTTrainer.*max_length**",description:"*<strong>*max_length**</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014; &#x2014; The maximum length of the input.",name:"*max_length**"},{anchor:"trl.IterativeSFTTrainer.*truncation_mode**",description:"*<strong>*truncation_mode**</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014; &#x2014; The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>.",name:"*truncation_mode**"},{anchor:"trl.IterativeSFTTrainer.*preprocess_logits_for_metrics**",description:"*<strong>*preprocess_logits_for_metrics**</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014; &#x2014; The function to use to preprocess the logits before computing the metrics.",name:"*preprocess_logits_for_metrics**"},{anchor:"trl.IterativeSFTTrainer.*compute_metrics**",description:"*<strong>*compute_metrics**</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014; &#x2014; The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.",name:"*compute_metrics**"},{anchor:"trl.IterativeSFTTrainer.*optimize_device_cache",description:"*<strong>*optimize_device_cache</strong> *<em> (<code>bool</code>, </em>optional*, defaults to <code>False</code>) &#x2014; Optimize CUDA cache for slightly more memory-efficient training. &#x2014;",name:"*optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L39"}}),rt=new f({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"attention_mask",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"labels",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"texts",val:": typing.Optional[typing.List[str]] = None"},{name:"texts_labels",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (List<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),ot=new C({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),it=new f({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/main/trl/core.py#L236"}}),{c(){q=r("meta"),mn=n(),cn=r("p"),gn=n(),d(pe.$$.fragment),hn=n(),me=r("p"),me.innerHTML=Ir,_n=n(),d(ge.$$.fragment),un=n(),S=r("div"),d(he.$$.fragment),da=n(),st=r("p"),st.textContent=Mr,fn=n(),d(_e.$$.fragment),vn=n(),T=r("div"),d(ue.$$.fragment),ca=n(),lt=r("p"),lt.innerHTML=qr,pa=n(),U=r("div"),d(fe.$$.fragment),ma=n(),dt=r("p"),dt.textContent=Sr,ga=n(),R=r("div"),d(ve.$$.fragment),ha=n(),ct=r("p"),ct.textContent=Ar,_a=n(),V=r("div"),d(be.$$.fragment),ua=n(),pt=r("p"),pt.textContent=Er,fa=n(),j=r("div"),d(Te.$$.fragment),va=n(),mt=r("p"),mt.textContent=Hr,ba=n(),W=r("div"),d(ye.$$.fragment),Ta=n(),gt=r("p"),gt.innerHTML=Ur,ya=n(),B=r("div"),d(xe.$$.fragment),xa=n(),ht=r("p"),ht.textContent=Rr,$a=n(),G=r("div"),d($e.$$.fragment),Pa=n(),_t=r("p"),_t.textContent=Vr,Oa=n(),J=r("div"),d(Pe.$$.fragment),Da=n(),ut=r("p"),ut.textContent=jr,wa=n(),K=r("div"),d(Oe.$$.fragment),ka=n(),ft=r("p"),ft.textContent=Wr,Ca=n(),Y=r("div"),d(De.$$.fragment),La=n(),vt=r("p"),vt.textContent=Br,Na=n(),Z=r("div"),d(we.$$.fragment),Fa=n(),bt=r("p"),bt.textContent=Gr,bn=n(),d(ke.$$.fragment),Tn=n(),w=r("div"),d(Ce.$$.fragment),za=n(),Tt=r("p"),Tt.innerHTML=Jr,Ia=n(),yt=r("p"),yt.innerHTML=Kr,yn=n(),d(Le.$$.fragment),xn=n(),$=r("div"),d(Ne.$$.fragment),Ma=n(),xt=r("p"),xt.innerHTML=Yr,qa=n(),$t=r("p"),$t.innerHTML=Zr,Sa=n(),Pt=r("ul"),Pt.innerHTML=Qr,Aa=n(),Ot=r("p"),Ot.innerHTML=Xr,$n=n(),d(Fe.$$.fragment),Pn=n(),A=r("div"),d(ze.$$.fragment),Ea=n(),Dt=r("p"),Dt.innerHTML=eo,On=n(),d(Ie.$$.fragment),Dn=n(),b=r("div"),d(Me.$$.fragment),Ha=n(),wt=r("p"),wt.textContent=to,Ua=n(),Q=r("div"),d(qe.$$.fragment),Ra=n(),kt=r("p"),kt.innerHTML=no,Va=n(),X=r("div"),d(Se.$$.fragment),ja=n(),Ct=r("p"),Ct.textContent=ao,Wa=n(),L=r("div"),d(Ae.$$.fragment),Ba=n(),Lt=r("p"),Lt.textContent=ro,Ga=n(),Nt=r("p"),Nt.textContent=oo,Ja=n(),ee=r("div"),d(Ee.$$.fragment),Ka=n(),Ft=r("p"),Ft.textContent=io,Ya=n(),te=r("div"),d(He.$$.fragment),Za=n(),zt=r("p"),zt.textContent=so,Qa=n(),N=r("div"),d(Ue.$$.fragment),Xa=n(),It=r("p"),It.innerHTML=lo,er=n(),Mt=r("p"),Mt.textContent=co,tr=n(),ne=r("div"),d(Re.$$.fragment),nr=n(),qt=r("p"),qt.textContent=po,ar=n(),ae=r("div"),d(Ve.$$.fragment),rr=n(),St=r("p"),St.textContent=mo,or=n(),re=r("div"),d(je.$$.fragment),ir=n(),At=r("p"),At.textContent=go,sr=n(),F=r("div"),d(We.$$.fragment),lr=n(),Et=r("p"),Et.innerHTML=ho,dr=n(),Ht=r("p"),Ht.innerHTML=_o,cr=n(),z=r("div"),d(Be.$$.fragment),pr=n(),Ut=r("p"),Ut.innerHTML=uo,mr=n(),Rt=r("p"),Rt.innerHTML=fo,gr=n(),oe=r("div"),d(Ge.$$.fragment),hr=n(),Vt=r("p"),Vt.innerHTML=vo,_r=n(),O=r("div"),d(Je.$$.fragment),ur=n(),jt=r("p"),jt.textContent=bo,fr=n(),Wt=r("p"),Wt.textContent=To,vr=n(),Bt=r("p"),Bt.textContent=yo,wn=n(),d(Ke.$$.fragment),kn=n(),E=r("div"),d(Ye.$$.fragment),br=n(),Gt=r("p"),Gt.textContent=xo,Cn=n(),d(Ze.$$.fragment),Ln=n(),P=r("div"),d(Qe.$$.fragment),Tr=n(),Jt=r("p"),Jt.innerHTML=$o,yr=n(),ie=r("div"),d(Xe.$$.fragment),xr=n(),Kt=r("p"),Kt.textContent=Po,$r=n(),D=r("div"),d(et.$$.fragment),Pr=n(),Yt=r("p"),Yt.textContent=Oo,Or=n(),Zt=r("p"),Zt.textContent=Do,Dr=n(),Qt=r("ul"),Qt.innerHTML=wo,wr=n(),se=r("div"),d(tt.$$.fragment),kr=n(),Xt=r("p"),Xt.textContent=ko,Nn=n(),d(nt.$$.fragment),Fn=n(),k=r("div"),d(at.$$.fragment),Cr=n(),en=r("p"),en.textContent=Co,Lr=n(),le=r("div"),d(rt.$$.fragment),Nr=n(),tn=r("p"),tn.textContent=Lo,zn=n(),d(ot.$$.fragment),In=n(),H=r("div"),d(it.$$.fragment),Fr=n(),nn=r("p"),nn.innerHTML=No,Mn=n(),pn=r("p"),this.h()},l(e){const s=So("svelte-u9bgzb",document.head);q=o(s,"META",{name:!0,content:!0}),s.forEach(i),mn=a(e),cn=o(e,"P",{}),_(cn).forEach(i),gn=a(e),c(pe.$$.fragment,e),hn=a(e),me=o(e,"P",{"data-svelte-h":!0}),l(me)!=="svelte-dxrcnp"&&(me.innerHTML=Ir),_n=a(e),c(ge.$$.fragment,e),un=a(e),S=o(e,"DIV",{class:!0});var Sn=_(S);c(he.$$.fragment,Sn),da=a(Sn),st=o(Sn,"P",{"data-svelte-h":!0}),l(st)!=="svelte-aondqr"&&(st.textContent=Mr),Sn.forEach(i),fn=a(e),c(_e.$$.fragment,e),vn=a(e),T=o(e,"DIV",{class:!0});var x=_(T);c(ue.$$.fragment,x),ca=a(x),lt=o(x,"P",{"data-svelte-h":!0}),l(lt)!=="svelte-hys9rl"&&(lt.innerHTML=qr),pa=a(x),U=o(x,"DIV",{class:!0});var An=_(U);c(fe.$$.fragment,An),ma=a(An),dt=o(An,"P",{"data-svelte-h":!0}),l(dt)!=="svelte-185nst0"&&(dt.textContent=Sr),An.forEach(i),ga=a(x),R=o(x,"DIV",{class:!0});var En=_(R);c(ve.$$.fragment,En),ha=a(En),ct=o(En,"P",{"data-svelte-h":!0}),l(ct)!=="svelte-3nt516"&&(ct.textContent=Ar),En.forEach(i),_a=a(x),V=o(x,"DIV",{class:!0});var Hn=_(V);c(be.$$.fragment,Hn),ua=a(Hn),pt=o(Hn,"P",{"data-svelte-h":!0}),l(pt)!=="svelte-3jfrz9"&&(pt.textContent=Er),Hn.forEach(i),fa=a(x),j=o(x,"DIV",{class:!0});var Un=_(j);c(Te.$$.fragment,Un),va=a(Un),mt=o(Un,"P",{"data-svelte-h":!0}),l(mt)!=="svelte-lcc1u3"&&(mt.textContent=Hr),Un.forEach(i),ba=a(x),W=o(x,"DIV",{class:!0});var Rn=_(W);c(ye.$$.fragment,Rn),Ta=a(Rn),gt=o(Rn,"P",{"data-svelte-h":!0}),l(gt)!=="svelte-1gqqzmu"&&(gt.innerHTML=Ur),Rn.forEach(i),ya=a(x),B=o(x,"DIV",{class:!0});var Vn=_(B);c(xe.$$.fragment,Vn),xa=a(Vn),ht=o(Vn,"P",{"data-svelte-h":!0}),l(ht)!=="svelte-ffqz5"&&(ht.textContent=Rr),Vn.forEach(i),$a=a(x),G=o(x,"DIV",{class:!0});var jn=_(G);c($e.$$.fragment,jn),Pa=a(jn),_t=o(jn,"P",{"data-svelte-h":!0}),l(_t)!=="svelte-febvhf"&&(_t.textContent=Vr),jn.forEach(i),Oa=a(x),J=o(x,"DIV",{class:!0});var Wn=_(J);c(Pe.$$.fragment,Wn),Da=a(Wn),ut=o(Wn,"P",{"data-svelte-h":!0}),l(ut)!=="svelte-1hbodkw"&&(ut.textContent=jr),Wn.forEach(i),wa=a(x),K=o(x,"DIV",{class:!0});var Bn=_(K);c(Oe.$$.fragment,Bn),ka=a(Bn),ft=o(Bn,"P",{"data-svelte-h":!0}),l(ft)!=="svelte-1hfgx92"&&(ft.textContent=Wr),Bn.forEach(i),Ca=a(x),Y=o(x,"DIV",{class:!0});var Gn=_(Y);c(De.$$.fragment,Gn),La=a(Gn),vt=o(Gn,"P",{"data-svelte-h":!0}),l(vt)!=="svelte-yrsdu6"&&(vt.textContent=Br),Gn.forEach(i),Na=a(x),Z=o(x,"DIV",{class:!0});var Jn=_(Z);c(we.$$.fragment,Jn),Fa=a(Jn),bt=o(Jn,"P",{"data-svelte-h":!0}),l(bt)!=="svelte-3k7k5e"&&(bt.textContent=Gr),Jn.forEach(i),x.forEach(i),bn=a(e),c(ke.$$.fragment,e),Tn=a(e),w=o(e,"DIV",{class:!0});var an=_(w);c(Ce.$$.fragment,an),za=a(an),Tt=o(an,"P",{"data-svelte-h":!0}),l(Tt)!=="svelte-1alpag9"&&(Tt.innerHTML=Jr),Ia=a(an),yt=o(an,"P",{"data-svelte-h":!0}),l(yt)!=="svelte-1xl7jqc"&&(yt.innerHTML=Kr),an.forEach(i),yn=a(e),c(Le.$$.fragment,e),xn=a(e),$=o(e,"DIV",{class:!0});var I=_($);c(Ne.$$.fragment,I),Ma=a(I),xt=o(I,"P",{"data-svelte-h":!0}),l(xt)!=="svelte-qafafj"&&(xt.innerHTML=Yr),qa=a(I),$t=o(I,"P",{"data-svelte-h":!0}),l($t)!=="svelte-bkmbwh"&&($t.innerHTML=Zr),Sa=a(I),Pt=o(I,"UL",{"data-svelte-h":!0}),l(Pt)!=="svelte-1ytuxgw"&&(Pt.innerHTML=Qr),Aa=a(I),Ot=o(I,"P",{"data-svelte-h":!0}),l(Ot)!=="svelte-18tbp4c"&&(Ot.innerHTML=Xr),I.forEach(i),$n=a(e),c(Fe.$$.fragment,e),Pn=a(e),A=o(e,"DIV",{class:!0});var Kn=_(A);c(ze.$$.fragment,Kn),Ea=a(Kn),Dt=o(Kn,"P",{"data-svelte-h":!0}),l(Dt)!=="svelte-14oyph8"&&(Dt.innerHTML=eo),Kn.forEach(i),On=a(e),c(Ie.$$.fragment,e),Dn=a(e),b=o(e,"DIV",{class:!0});var y=_(b);c(Me.$$.fragment,y),Ha=a(y),wt=o(y,"P",{"data-svelte-h":!0}),l(wt)!=="svelte-n6cc8y"&&(wt.textContent=to),Ua=a(y),Q=o(y,"DIV",{class:!0});var Yn=_(Q);c(qe.$$.fragment,Yn),Ra=a(Yn),kt=o(Yn,"P",{"data-svelte-h":!0}),l(kt)!=="svelte-mcz8nm"&&(kt.innerHTML=no),Yn.forEach(i),Va=a(y),X=o(y,"DIV",{class:!0});var Zn=_(X);c(Se.$$.fragment,Zn),ja=a(Zn),Ct=o(Zn,"P",{"data-svelte-h":!0}),l(Ct)!=="svelte-10t1062"&&(Ct.textContent=ao),Zn.forEach(i),Wa=a(y),L=o(y,"DIV",{class:!0});var rn=_(L);c(Ae.$$.fragment,rn),Ba=a(rn),Lt=o(rn,"P",{"data-svelte-h":!0}),l(Lt)!=="svelte-16i1nac"&&(Lt.textContent=ro),Ga=a(rn),Nt=o(rn,"P",{"data-svelte-h":!0}),l(Nt)!=="svelte-tgti68"&&(Nt.textContent=oo),rn.forEach(i),Ja=a(y),ee=o(y,"DIV",{class:!0});var Qn=_(ee);c(Ee.$$.fragment,Qn),Ka=a(Qn),Ft=o(Qn,"P",{"data-svelte-h":!0}),l(Ft)!=="svelte-1cvsgkk"&&(Ft.textContent=io),Qn.forEach(i),Ya=a(y),te=o(y,"DIV",{class:!0});var Xn=_(te);c(He.$$.fragment,Xn),Za=a(Xn),zt=o(Xn,"P",{"data-svelte-h":!0}),l(zt)!=="svelte-ymgxq7"&&(zt.textContent=so),Xn.forEach(i),Qa=a(y),N=o(y,"DIV",{class:!0});var on=_(N);c(Ue.$$.fragment,on),Xa=a(on),It=o(on,"P",{"data-svelte-h":!0}),l(It)!=="svelte-8qlty5"&&(It.innerHTML=lo),er=a(on),Mt=o(on,"P",{"data-svelte-h":!0}),l(Mt)!=="svelte-1tyo99t"&&(Mt.textContent=co),on.forEach(i),tr=a(y),ne=o(y,"DIV",{class:!0});var ea=_(ne);c(Re.$$.fragment,ea),nr=a(ea),qt=o(ea,"P",{"data-svelte-h":!0}),l(qt)!=="svelte-4nmimv"&&(qt.textContent=po),ea.forEach(i),ar=a(y),ae=o(y,"DIV",{class:!0});var ta=_(ae);c(Ve.$$.fragment,ta),rr=a(ta),St=o(ta,"P",{"data-svelte-h":!0}),l(St)!=="svelte-11q8u7l"&&(St.textContent=mo),ta.forEach(i),or=a(y),re=o(y,"DIV",{class:!0});var na=_(re);c(je.$$.fragment,na),ir=a(na),At=o(na,"P",{"data-svelte-h":!0}),l(At)!=="svelte-18uwvbi"&&(At.textContent=go),na.forEach(i),sr=a(y),F=o(y,"DIV",{class:!0});var sn=_(F);c(We.$$.fragment,sn),lr=a(sn),Et=o(sn,"P",{"data-svelte-h":!0}),l(Et)!=="svelte-xesobz"&&(Et.innerHTML=ho),dr=a(sn),Ht=o(sn,"P",{"data-svelte-h":!0}),l(Ht)!=="svelte-qg43tm"&&(Ht.innerHTML=_o),sn.forEach(i),cr=a(y),z=o(y,"DIV",{class:!0});var ln=_(z);c(Be.$$.fragment,ln),pr=a(ln),Ut=o(ln,"P",{"data-svelte-h":!0}),l(Ut)!=="svelte-dkae9b"&&(Ut.innerHTML=uo),mr=a(ln),Rt=o(ln,"P",{"data-svelte-h":!0}),l(Rt)!=="svelte-hmd5cw"&&(Rt.innerHTML=fo),ln.forEach(i),gr=a(y),oe=o(y,"DIV",{class:!0});var aa=_(oe);c(Ge.$$.fragment,aa),hr=a(aa),Vt=o(aa,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-nqksfz"&&(Vt.innerHTML=vo),aa.forEach(i),_r=a(y),O=o(y,"DIV",{class:!0});var de=_(O);c(Je.$$.fragment,de),ur=a(de),jt=o(de,"P",{"data-svelte-h":!0}),l(jt)!=="svelte-1861yti"&&(jt.textContent=bo),fr=a(de),Wt=o(de,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-1mn1gnw"&&(Wt.textContent=To),vr=a(de),Bt=o(de,"P",{"data-svelte-h":!0}),l(Bt)!=="svelte-1xvpyih"&&(Bt.textContent=yo),de.forEach(i),y.forEach(i),wn=a(e),c(Ke.$$.fragment,e),kn=a(e),E=o(e,"DIV",{class:!0});var ra=_(E);c(Ye.$$.fragment,ra),br=a(ra),Gt=o(ra,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-2zpx1f"&&(Gt.textContent=xo),ra.forEach(i),Cn=a(e),c(Ze.$$.fragment,e),Ln=a(e),P=o(e,"DIV",{class:!0});var M=_(P);c(Qe.$$.fragment,M),Tr=a(M),Jt=o(M,"P",{"data-svelte-h":!0}),l(Jt)!=="svelte-8q861t"&&(Jt.innerHTML=$o),yr=a(M),ie=o(M,"DIV",{class:!0});var oa=_(ie);c(Xe.$$.fragment,oa),xr=a(oa),Kt=o(oa,"P",{"data-svelte-h":!0}),l(Kt)!=="svelte-1ag17u3"&&(Kt.textContent=Po),oa.forEach(i),$r=a(M),D=o(M,"DIV",{class:!0});var ce=_(D);c(et.$$.fragment,ce),Pr=a(ce),Yt=o(ce,"P",{"data-svelte-h":!0}),l(Yt)!=="svelte-r6y15n"&&(Yt.textContent=Oo),Or=a(ce),Zt=o(ce,"P",{"data-svelte-h":!0}),l(Zt)!=="svelte-imqqfp"&&(Zt.textContent=Do),Dr=a(ce),Qt=o(ce,"UL",{"data-svelte-h":!0}),l(Qt)!=="svelte-105j238"&&(Qt.innerHTML=wo),ce.forEach(i),wr=a(M),se=o(M,"DIV",{class:!0});var ia=_(se);c(tt.$$.fragment,ia),kr=a(ia),Xt=o(ia,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-1an944l"&&(Xt.textContent=ko),ia.forEach(i),M.forEach(i),Nn=a(e),c(nt.$$.fragment,e),Fn=a(e),k=o(e,"DIV",{class:!0});var dn=_(k);c(at.$$.fragment,dn),Cr=a(dn),en=o(dn,"P",{"data-svelte-h":!0}),l(en)!=="svelte-xqyw6w"&&(en.textContent=Co),Lr=a(dn),le=o(dn,"DIV",{class:!0});var sa=_(le);c(rt.$$.fragment,sa),Nr=a(sa),tn=o(sa,"P",{"data-svelte-h":!0}),l(tn)!=="svelte-v7dhdf"&&(tn.textContent=Lo),sa.forEach(i),dn.forEach(i),zn=a(e),c(ot.$$.fragment,e),In=a(e),H=o(e,"DIV",{class:!0});var la=_(H);c(it.$$.fragment,la),Fr=a(la),nn=o(la,"P",{"data-svelte-h":!0}),l(nn)!=="svelte-1aeuhep"&&(nn.innerHTML=No),la.forEach(i),Mn=a(e),pn=o(e,"P",{}),_(pn).forEach(i),this.h()},h(){u(q,"name","hf:doc:metadata"),u(q,"content",Eo),u(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,q),v(e,mn,s),v(e,cn,s),v(e,gn,s),p(pe,e,s),v(e,hn,s),v(e,me,s),v(e,_n,s),p(ge,e,s),v(e,un,s),v(e,S,s),p(he,S,null),t(S,da),t(S,st),v(e,fn,s),p(_e,e,s),v(e,vn,s),v(e,T,s),p(ue,T,null),t(T,ca),t(T,lt),t(T,pa),t(T,U),p(fe,U,null),t(U,ma),t(U,dt),t(T,ga),t(T,R),p(ve,R,null),t(R,ha),t(R,ct),t(T,_a),t(T,V),p(be,V,null),t(V,ua),t(V,pt),t(T,fa),t(T,j),p(Te,j,null),t(j,va),t(j,mt),t(T,ba),t(T,W),p(ye,W,null),t(W,Ta),t(W,gt),t(T,ya),t(T,B),p(xe,B,null),t(B,xa),t(B,ht),t(T,$a),t(T,G),p($e,G,null),t(G,Pa),t(G,_t),t(T,Oa),t(T,J),p(Pe,J,null),t(J,Da),t(J,ut),t(T,wa),t(T,K),p(Oe,K,null),t(K,ka),t(K,ft),t(T,Ca),t(T,Y),p(De,Y,null),t(Y,La),t(Y,vt),t(T,Na),t(T,Z),p(we,Z,null),t(Z,Fa),t(Z,bt),v(e,bn,s),p(ke,e,s),v(e,Tn,s),v(e,w,s),p(Ce,w,null),t(w,za),t(w,Tt),t(w,Ia),t(w,yt),v(e,yn,s),p(Le,e,s),v(e,xn,s),v(e,$,s),p(Ne,$,null),t($,Ma),t($,xt),t($,qa),t($,$t),t($,Sa),t($,Pt),t($,Aa),t($,Ot),v(e,$n,s),p(Fe,e,s),v(e,Pn,s),v(e,A,s),p(ze,A,null),t(A,Ea),t(A,Dt),v(e,On,s),p(Ie,e,s),v(e,Dn,s),v(e,b,s),p(Me,b,null),t(b,Ha),t(b,wt),t(b,Ua),t(b,Q),p(qe,Q,null),t(Q,Ra),t(Q,kt),t(b,Va),t(b,X),p(Se,X,null),t(X,ja),t(X,Ct),t(b,Wa),t(b,L),p(Ae,L,null),t(L,Ba),t(L,Lt),t(L,Ga),t(L,Nt),t(b,Ja),t(b,ee),p(Ee,ee,null),t(ee,Ka),t(ee,Ft),t(b,Ya),t(b,te),p(He,te,null),t(te,Za),t(te,zt),t(b,Qa),t(b,N),p(Ue,N,null),t(N,Xa),t(N,It),t(N,er),t(N,Mt),t(b,tr),t(b,ne),p(Re,ne,null),t(ne,nr),t(ne,qt),t(b,ar),t(b,ae),p(Ve,ae,null),t(ae,rr),t(ae,St),t(b,or),t(b,re),p(je,re,null),t(re,ir),t(re,At),t(b,sr),t(b,F),p(We,F,null),t(F,lr),t(F,Et),t(F,dr),t(F,Ht),t(b,cr),t(b,z),p(Be,z,null),t(z,pr),t(z,Ut),t(z,mr),t(z,Rt),t(b,gr),t(b,oe),p(Ge,oe,null),t(oe,hr),t(oe,Vt),t(b,_r),t(b,O),p(Je,O,null),t(O,ur),t(O,jt),t(O,fr),t(O,Wt),t(O,vr),t(O,Bt),v(e,wn,s),p(Ke,e,s),v(e,kn,s),v(e,E,s),p(Ye,E,null),t(E,br),t(E,Gt),v(e,Cn,s),p(Ze,e,s),v(e,Ln,s),v(e,P,s),p(Qe,P,null),t(P,Tr),t(P,Jt),t(P,yr),t(P,ie),p(Xe,ie,null),t(ie,xr),t(ie,Kt),t(P,$r),t(P,D),p(et,D,null),t(D,Pr),t(D,Yt),t(D,Or),t(D,Zt),t(D,Dr),t(D,Qt),t(P,wr),t(P,se),p(tt,se,null),t(se,kr),t(se,Xt),v(e,Nn,s),p(nt,e,s),v(e,Fn,s),v(e,k,s),p(at,k,null),t(k,Cr),t(k,en),t(k,Lr),t(k,le),p(rt,le,null),t(le,Nr),t(le,tn),v(e,zn,s),p(ot,e,s),v(e,In,s),v(e,H,s),p(it,H,null),t(H,Fr),t(H,nn),v(e,Mn,s),v(e,pn,s),qn=!0},p:zo,i(e){qn||(m(pe.$$.fragment,e),m(ge.$$.fragment,e),m(he.$$.fragment,e),m(_e.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(ve.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(ye.$$.fragment,e),m(xe.$$.fragment,e),m($e.$$.fragment,e),m(Pe.$$.fragment,e),m(Oe.$$.fragment,e),m(De.$$.fragment,e),m(we.$$.fragment,e),m(ke.$$.fragment,e),m(Ce.$$.fragment,e),m(Le.$$.fragment,e),m(Ne.$$.fragment,e),m(Fe.$$.fragment,e),m(ze.$$.fragment,e),m(Ie.$$.fragment,e),m(Me.$$.fragment,e),m(qe.$$.fragment,e),m(Se.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(He.$$.fragment,e),m(Ue.$$.fragment,e),m(Re.$$.fragment,e),m(Ve.$$.fragment,e),m(je.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Ge.$$.fragment,e),m(Je.$$.fragment,e),m(Ke.$$.fragment,e),m(Ye.$$.fragment,e),m(Ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Xe.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),m(at.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(it.$$.fragment,e),qn=!0)},o(e){g(pe.$$.fragment,e),g(ge.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(Pe.$$.fragment,e),g(Oe.$$.fragment,e),g(De.$$.fragment,e),g(we.$$.fragment,e),g(ke.$$.fragment,e),g(Ce.$$.fragment,e),g(Le.$$.fragment,e),g(Ne.$$.fragment,e),g(Fe.$$.fragment,e),g(ze.$$.fragment,e),g(Ie.$$.fragment,e),g(Me.$$.fragment,e),g(qe.$$.fragment,e),g(Se.$$.fragment,e),g(Ae.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ue.$$.fragment,e),g(Re.$$.fragment,e),g(Ve.$$.fragment,e),g(je.$$.fragment,e),g(We.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g(Je.$$.fragment,e),g(Ke.$$.fragment,e),g(Ye.$$.fragment,e),g(Ze.$$.fragment,e),g(Qe.$$.fragment,e),g(Xe.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(nt.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(ot.$$.fragment,e),g(it.$$.fragment,e),qn=!1},d(e){e&&(i(mn),i(cn),i(gn),i(hn),i(me),i(_n),i(un),i(S),i(fn),i(vn),i(T),i(bn),i(Tn),i(w),i(yn),i(xn),i($),i($n),i(Pn),i(A),i(On),i(Dn),i(b),i(wn),i(kn),i(E),i(Cn),i(Ln),i(P),i(Nn),i(Fn),i(k),i(zn),i(In),i(H),i(Mn),i(pn)),i(q),h(pe,e),h(ge,e),h(he),h(_e,e),h(ue),h(fe),h(ve),h(be),h(Te),h(ye),h(xe),h($e),h(Pe),h(Oe),h(De),h(we),h(ke,e),h(Ce),h(Le,e),h(Ne),h(Fe,e),h(ze),h(Ie,e),h(Me),h(qe),h(Se),h(Ae),h(Ee),h(He),h(Ue),h(Re),h(Ve),h(je),h(We),h(Be),h(Ge),h(Je),h(Ke,e),h(Ye),h(Ze,e),h(Qe),h(Xe),h(et),h(tt),h(nt,e),h(at),h(rt),h(ot,e),h(it)}}}const Eo='{"title":"Trainer","local":"trainer","sections":[{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function Ho(zr){return Io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wo extends Mo{constructor(q){super(),qo(this,q,Ho,Ao,Fo,{})}}export{Wo as component};
