import{s as ls,n as os,o as is}from"../chunks/scheduler.9039eef2.js";import{S as rs,i as ps,g as o,s,r as p,A as ds,h as i,f as a,c as l,j as Oa,u as d,x as r,k as Ka,l as ns,y as _,a as n,v as c,d as m,t as u,w as h}from"../chunks/index.ded8f90d.js";import{D as ss}from"../chunks/Docstring.a2ba2b54.js";import{C as f}from"../chunks/CodeBlock.8580f3e8.js";import{H as M}from"../chunks/Heading.f027f30d.js";function cs(sn){let T,ce,pe,me,k,ue,j,ln="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",he,J,on='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',fe,C,Me,$,rn=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,ye,x,Te,v,pn="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",ge,F,dn="You can also construct a model outside of the trainer and pass it as follows:",we,I,be,G,cn='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',Ue,R,_e,Z,ke,z,mn=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,je,B,Je,S,un="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Ce,N,$e,E,hn="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",xe,A,ve,X,fn="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",Fe,V,Ie,Q,Mn="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Ge,W,yn="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",Re,q,Tn="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Ze,L,ze,H,gn="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Be,Y,Se,D,Ne,P,wn=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Ee,O,Ae,K,bn="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",Xe,tt,Ve,et,Un='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Qe,at,We,nt,_n='<a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',qe,st,Le,lt,kn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",He,ot,Ye,it,jn="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",De,rt,Pe,pt,Jn='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',Oe,dt,Ke,ct,Cn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',ta,mt,ea,ut,aa,ht,$n="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",na,ft,sa,Mt,xn="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",la,yt,oa,Tt,vn="Note that in case of training adapters, we manually add a saving callback to automatically save the adapters only:",ia,gt,ra,wt,Fn="If you want to add more callbacks, make sure to add this one as well to properly save the adapters only during training.",pa,bt,da,Ut,In="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",ca,_t,ma,kt,Gn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",ua,jt,ha,Jt,fa,Ct,Rn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,Ma,$t,ya,xt,Zn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Ta,vt,ga,Ft,zn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",wa,It,ba,Gt,Bn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",Ua,Rt,_a,Zt,Sn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",ka,zt,Nn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",ja,Bt,En="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",Ja,St,Ca,Nt,An="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",$a,Et,xa,At,Xn="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",va,Xt,Fa,Vt,Vn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,Ia,Qt,Qn="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",Ga,Wt,Ra,qt,Wn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Za,Lt,qn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",za,w,Ln='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',Ba,Ht,Hn="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",Sa,Yt,Na,Dt,Yn='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',Ea,b,Dn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Aa,Pt,Pn='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',Xa,Ot,Va,Kt,On="Pay attention to the following best practices when training a model with that trainer:",Qa,te,Kn='<li><a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Wa,ee,qa,g,ae,tn,oe,ts=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,La,ne,Ha,y,se,en,ie,es=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,an,le,nn,re,as=`”<code>infinite (</code>bool<code>, *optional*, defaults to </code>False<code>): If True the iterator is reset after dataset reaches end else stops. seq_length (</code>int<code>, *optional*, defaults to </code>1024<code>): Length of token sequences to return. num_of_sequences (</code>int<code>, *optional*, defaults to </code>1024<code>): Number of token sequences to keep in buffer. chars_per_token (</code>int<code>, *optional*, defaults to </code>3.6<code>): Number of characters per token used to estimate number of tokens in text buffer. eos_token_id (</code>int<code>, *optional*, defaults to </code>0\`):
Id of the end of sequence token if the passed tokenizer does not have an EOS token.
shuffle (‘bool’, <em>optional</em>, defaults to True)
Shuffle the examples before they are returned`,Ya,de,Da;return k=new M({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),C=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),x=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),I=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),R=new M({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Z=new M({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),B=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),N=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),A=new M({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),V=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),L=new f({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCklMjAlMjAlMjA=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)   ',wrap:!1}}),Y=new f({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),D=new M({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),O=new f({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),tt=new f({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),at=new M({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),st=new f({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),ot=new M({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),rt=new f({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),dt=new M({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),mt=new f({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)',wrap:!1}}),ut=new f({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16,
    },
)

trainer.train()`,wrap:!1}}),ft=new M({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),yt=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),gt=new f({props:{code:"Y2xhc3MlMjBQZWZ0U2F2aW5nQ2FsbGJhY2soVHJhaW5lckNhbGxiYWNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMG9uX3NhdmUoc2VsZiUyQyUyMGFyZ3MlMkMlMjBzdGF0ZSUyQyUyMGNvbnRyb2wlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaGVja3BvaW50X3BhdGglMjAlM0QlMjBvcy5wYXRoLmpvaW4oYXJncy5vdXRwdXRfZGlyJTJDJTIwZiUyMmNoZWNrcG9pbnQtJTdCc3RhdGUuZ2xvYmFsX3N0ZXAlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTVCJTIybW9kZWwlMjIlNUQuc2F2ZV9wcmV0cmFpbmVkKGNoZWNrcG9pbnRfcGF0aCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyJTIwaW4lMjBvcy5saXN0ZGlyKGNoZWNrcG9pbnRfcGF0aCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5yZW1vdmUob3MucGF0aC5qb2luKGNoZWNrcG9pbnRfcGF0aCUyQyUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PeftSavingCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_save</span>(<span class="hljs-params">self, args, state, control, **kwargs</span>):
        checkpoint_path = os.path.join(args.output_dir, <span class="hljs-string">f&quot;checkpoint-<span class="hljs-subst">{state.global_step}</span>&quot;</span>)
        kwargs[<span class="hljs-string">&quot;model&quot;</span>].save_pretrained(checkpoint_path)

        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pytorch_model.bin&quot;</span> <span class="hljs-keyword">in</span> os.listdir(checkpoint_path):
            os.remove(os.path.join(checkpoint_path, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>))`,wrap:!1}}),bt=new f({props:{code:"JTBBJTBB",highlighted:`...

callbacks = [YourCustomCallback(), PeftSavingCallback()]

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
    callbacks=callbacks
)

trainer.train()`,wrap:!1}}),_t=new M({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),jt=new f({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Jt=new M({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),$t=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),vt=new M({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),It=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Rt=new f({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),St=new M({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Et=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Xt=new f({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Wt=new M({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),Yt=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),Ot=new M({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),ee=new M({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),ae=new ss({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = None"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instrcution
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L52"}}),ne=new M({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h2"}}),se=new ss({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"*args",val:""},{name:"**kwds",val:""}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as \`&#x201D;### Question: {question}`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L333"}}),le=new M({props:{title:"Answer: {answer}",local:"answer-answer",headingTag:"h3"}}),{c(){T=o("meta"),ce=s(),pe=o("p"),me=s(),p(k.$$.fragment),ue=s(),j=o("p"),j.textContent=ln,he=s(),J=o("p"),J.innerHTML=on,fe=s(),p(C.$$.fragment),Me=s(),$=o("p"),$.innerHTML=rn,ye=s(),p(x.$$.fragment),Te=s(),v=o("p"),v.innerHTML=pn,ge=s(),F=o("p"),F.textContent=dn,we=s(),p(I.$$.fragment),be=s(),G=o("p"),G.innerHTML=cn,Ue=s(),p(R.$$.fragment),_e=s(),p(Z.$$.fragment),ke=s(),z=o("p"),z.innerHTML=mn,je=s(),p(B.$$.fragment),Je=s(),S=o("p"),S.innerHTML=un,Ce=s(),p(N.$$.fragment),$e=s(),E=o("p"),E.innerHTML=hn,xe=s(),p(A.$$.fragment),ve=s(),X=o("p"),X.innerHTML=fn,Fe=s(),p(V.$$.fragment),Ie=s(),Q=o("p"),Q.innerHTML=Mn,Ge=s(),W=o("ul"),W.innerHTML=yn,Re=s(),q=o("p"),q.innerHTML=Tn,Ze=s(),p(L.$$.fragment),ze=s(),H=o("p"),H.innerHTML=gn,Be=s(),p(Y.$$.fragment),Se=s(),p(D.$$.fragment),Ne=s(),P=o("p"),P.innerHTML=wn,Ee=s(),p(O.$$.fragment),Ae=s(),K=o("p"),K.innerHTML=bn,Xe=s(),p(tt.$$.fragment),Ve=s(),et=o("p"),et.innerHTML=Un,Qe=s(),p(at.$$.fragment),We=s(),nt=o("p"),nt.innerHTML=_n,qe=s(),p(st.$$.fragment),Le=s(),lt=o("p"),lt.innerHTML=kn,He=s(),p(ot.$$.fragment),Ye=s(),it=o("p"),it.innerHTML=jn,De=s(),p(rt.$$.fragment),Pe=s(),pt=o("p"),pt.innerHTML=Jn,Oe=s(),p(dt.$$.fragment),Ke=s(),ct=o("p"),ct.innerHTML=Cn,ta=s(),p(mt.$$.fragment),ea=s(),p(ut.$$.fragment),aa=s(),ht=o("p"),ht.innerHTML=$n,na=s(),p(ft.$$.fragment),sa=s(),Mt=o("p"),Mt.textContent=xn,la=s(),p(yt.$$.fragment),oa=s(),Tt=o("p"),Tt.textContent=vn,ia=s(),p(gt.$$.fragment),ra=s(),wt=o("p"),wt.textContent=Fn,pa=s(),p(bt.$$.fragment),da=s(),Ut=o("p"),Ut.innerHTML=In,ca=s(),p(_t.$$.fragment),ma=s(),kt=o("p"),kt.innerHTML=Gn,ua=s(),p(jt.$$.fragment),ha=s(),p(Jt.$$.fragment),fa=s(),Ct=o("p"),Ct.textContent=Rn,Ma=s(),p($t.$$.fragment),ya=s(),xt=o("p"),xt.textContent=Zn,Ta=s(),p(vt.$$.fragment),ga=s(),Ft=o("p"),Ft.innerHTML=zn,wa=s(),p(It.$$.fragment),ba=s(),Gt=o("p"),Gt.innerHTML=Bn,Ua=s(),p(Rt.$$.fragment),_a=s(),Zt=o("p"),Zt.innerHTML=Sn,ka=s(),zt=o("p"),zt.textContent=Nn,ja=s(),Bt=o("table"),Bt.innerHTML=En,Ja=s(),p(St.$$.fragment),Ca=s(),Nt=o("p"),Nt.innerHTML=An,$a=s(),p(Et.$$.fragment),xa=s(),At=o("p"),At.innerHTML=Xn,va=s(),p(Xt.$$.fragment),Fa=s(),Vt=o("p"),Vt.textContent=Vn,Ia=s(),Qt=o("p"),Qt.textContent=Qn,Ga=s(),p(Wt.$$.fragment),Ra=s(),qt=o("p"),qt.innerHTML=Wn,Za=s(),Lt=o("blockquote"),Lt.innerHTML=qn,za=s(),w=o("div"),w.innerHTML=Ln,Ba=s(),Ht=o("p"),Ht.innerHTML=Hn,Sa=s(),p(Yt.$$.fragment),Na=s(),Dt=o("p"),Dt.innerHTML=Yn,Ea=s(),b=o("div"),b.innerHTML=Dn,Aa=s(),Pt=o("p"),Pt.innerHTML=Pn,Xa=s(),p(Ot.$$.fragment),Va=s(),Kt=o("p"),Kt.textContent=On,Qa=s(),te=o("ul"),te.innerHTML=Kn,Wa=s(),p(ee.$$.fragment),qa=s(),g=o("div"),p(ae.$$.fragment),tn=s(),oe=o("p"),oe.innerHTML=ts,La=s(),p(ne.$$.fragment),Ha=s(),y=o("div"),p(se.$$.fragment),en=s(),ie=o("p"),ie.textContent=es,an=s(),p(le.$$.fragment),nn=s(),re=o("p"),re.innerHTML=as,Ya=s(),de=o("p"),this.h()},l(t){const e=ds("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(a),ce=l(t),pe=i(t,"P",{}),Oa(pe).forEach(a),me=l(t),d(k.$$.fragment,t),ue=l(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-o839x3"&&(j.textContent=ln),he=l(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-exgkch"&&(J.innerHTML=on),fe=l(t),d(C.$$.fragment,t),Me=l(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-8asaew"&&($.innerHTML=rn),ye=l(t),d(x.$$.fragment,t),Te=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gbidw"&&(v.innerHTML=pn),ge=l(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ulikv8"&&(F.textContent=dn),we=l(t),d(I.$$.fragment,t),be=l(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ryagwl"&&(G.innerHTML=cn),Ue=l(t),d(R.$$.fragment,t),_e=l(t),d(Z.$$.fragment,t),ke=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-13sbeoj"&&(z.innerHTML=mn),je=l(t),d(B.$$.fragment,t),Je=l(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1a743rp"&&(S.innerHTML=un),Ce=l(t),d(N.$$.fragment,t),$e=l(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-17fkgzr"&&(E.innerHTML=hn),xe=l(t),d(A.$$.fragment,t),ve=l(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-dfggk8"&&(X.innerHTML=fn),Fe=l(t),d(V.$$.fragment,t),Ie=l(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-xlwe87"&&(Q.innerHTML=Mn),Ge=l(t),W=i(t,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1enki0k"&&(W.innerHTML=yn),Re=l(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-14yxh0m"&&(q.innerHTML=Tn),Ze=l(t),d(L.$$.fragment,t),ze=l(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-13h81gp"&&(H.innerHTML=gn),Be=l(t),d(Y.$$.fragment,t),Se=l(t),d(D.$$.fragment,t),Ne=l(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-cqsf2h"&&(P.innerHTML=wn),Ee=l(t),d(O.$$.fragment,t),Ae=l(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-l25vq0"&&(K.innerHTML=bn),Xe=l(t),d(tt.$$.fragment,t),Ve=l(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1iqmdsd"&&(et.innerHTML=Un),Qe=l(t),d(at.$$.fragment,t),We=l(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1a4epj8"&&(nt.innerHTML=_n),qe=l(t),d(st.$$.fragment,t),Le=l(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-wtbvzy"&&(lt.innerHTML=kn),He=l(t),d(ot.$$.fragment,t),Ye=l(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-iejqw3"&&(it.innerHTML=jn),De=l(t),d(rt.$$.fragment,t),Pe=l(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-qqgn8q"&&(pt.innerHTML=Jn),Oe=l(t),d(dt.$$.fragment,t),Ke=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-oxgwyg"&&(ct.innerHTML=Cn),ta=l(t),d(mt.$$.fragment,t),ea=l(t),d(ut.$$.fragment,t),aa=l(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1rnsxc5"&&(ht.innerHTML=$n),na=l(t),d(ft.$$.fragment,t),sa=l(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-11jfbzz"&&(Mt.textContent=xn),la=l(t),d(yt.$$.fragment,t),oa=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1iplhln"&&(Tt.textContent=vn),ia=l(t),d(gt.$$.fragment,t),ra=l(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-645tfb"&&(wt.textContent=Fn),pa=l(t),d(bt.$$.fragment,t),da=l(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-pwdaav"&&(Ut.innerHTML=In),ca=l(t),d(_t.$$.fragment,t),ma=l(t),kt=i(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-zbh7v5"&&(kt.innerHTML=Gn),ua=l(t),d(jt.$$.fragment,t),ha=l(t),d(Jt.$$.fragment,t),fa=l(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-fyvvsj"&&(Ct.textContent=Rn),Ma=l(t),d($t.$$.fragment,t),ya=l(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-yypgof"&&(xt.textContent=Zn),Ta=l(t),d(vt.$$.fragment,t),ga=l(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-yugu96"&&(Ft.innerHTML=zn),wa=l(t),d(It.$$.fragment,t),ba=l(t),Gt=i(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1qms4cl"&&(Gt.innerHTML=Bn),Ua=l(t),d(Rt.$$.fragment,t),_a=l(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-qe5zfz"&&(Zt.innerHTML=Sn),ka=l(t),zt=i(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-69u1rz"&&(zt.textContent=Nn),ja=l(t),Bt=i(t,"TABLE",{"data-svelte-h":!0}),r(Bt)!=="svelte-8fq96j"&&(Bt.innerHTML=En),Ja=l(t),d(St.$$.fragment,t),Ca=l(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1rqlm78"&&(Nt.innerHTML=An),$a=l(t),d(Et.$$.fragment,t),xa=l(t),At=i(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-sqoxna"&&(At.innerHTML=Xn),va=l(t),d(Xt.$$.fragment,t),Fa=l(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-vfpk19"&&(Vt.textContent=Vn),Ia=l(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-zatc00"&&(Qt.textContent=Qn),Ga=l(t),d(Wt.$$.fragment,t),Ra=l(t),qt=i(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-6trhkk"&&(qt.innerHTML=Wn),Za=l(t),Lt=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Lt)!=="svelte-1ejl1pl"&&(Lt.innerHTML=qn),za=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wkjgyb"&&(w.innerHTML=Ln),Ba=l(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-7jwpzy"&&(Ht.innerHTML=Hn),Sa=l(t),d(Yt.$$.fragment,t),Na=l(t),Dt=i(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-sqj12"&&(Dt.innerHTML=Yn),Ea=l(t),b=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(b)!=="svelte-a1m5gi"&&(b.innerHTML=Dn),Aa=l(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-rwofnh"&&(Pt.innerHTML=Pn),Xa=l(t),d(Ot.$$.fragment,t),Va=l(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-g801h1"&&(Kt.textContent=On),Qa=l(t),te=i(t,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-1mmsr46"&&(te.innerHTML=Kn),Wa=l(t),d(ee.$$.fragment,t),qa=l(t),g=i(t,"DIV",{class:!0});var Pa=Oa(g);d(ae.$$.fragment,Pa),tn=l(Pa),oe=i(Pa,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-14oyph8"&&(oe.innerHTML=ts),Pa.forEach(a),La=l(t),d(ne.$$.fragment,t),Ha=l(t),y=i(t,"DIV",{class:!0});var U=Oa(y);d(se.$$.fragment,U),en=l(U),ie=i(U,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1dlriq1"&&(ie.textContent=es),an=l(U),d(le.$$.fragment,U),nn=l(U),re=i(U,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1quwuq5"&&(re.innerHTML=as),U.forEach(a),Ya=l(t),de=i(t,"P",{}),Oa(de).forEach(a),this.h()},h(){Ka(T,"name","hf:doc:metadata"),Ka(T,"content",ms),ns(w,"text-align","center"),ns(b,"text-align","center"),Ka(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ka(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){_(document.head,T),n(t,ce,e),n(t,pe,e),n(t,me,e),c(k,t,e),n(t,ue,e),n(t,j,e),n(t,he,e),n(t,J,e),n(t,fe,e),c(C,t,e),n(t,Me,e),n(t,$,e),n(t,ye,e),c(x,t,e),n(t,Te,e),n(t,v,e),n(t,ge,e),n(t,F,e),n(t,we,e),c(I,t,e),n(t,be,e),n(t,G,e),n(t,Ue,e),c(R,t,e),n(t,_e,e),c(Z,t,e),n(t,ke,e),n(t,z,e),n(t,je,e),c(B,t,e),n(t,Je,e),n(t,S,e),n(t,Ce,e),c(N,t,e),n(t,$e,e),n(t,E,e),n(t,xe,e),c(A,t,e),n(t,ve,e),n(t,X,e),n(t,Fe,e),c(V,t,e),n(t,Ie,e),n(t,Q,e),n(t,Ge,e),n(t,W,e),n(t,Re,e),n(t,q,e),n(t,Ze,e),c(L,t,e),n(t,ze,e),n(t,H,e),n(t,Be,e),c(Y,t,e),n(t,Se,e),c(D,t,e),n(t,Ne,e),n(t,P,e),n(t,Ee,e),c(O,t,e),n(t,Ae,e),n(t,K,e),n(t,Xe,e),c(tt,t,e),n(t,Ve,e),n(t,et,e),n(t,Qe,e),c(at,t,e),n(t,We,e),n(t,nt,e),n(t,qe,e),c(st,t,e),n(t,Le,e),n(t,lt,e),n(t,He,e),c(ot,t,e),n(t,Ye,e),n(t,it,e),n(t,De,e),c(rt,t,e),n(t,Pe,e),n(t,pt,e),n(t,Oe,e),c(dt,t,e),n(t,Ke,e),n(t,ct,e),n(t,ta,e),c(mt,t,e),n(t,ea,e),c(ut,t,e),n(t,aa,e),n(t,ht,e),n(t,na,e),c(ft,t,e),n(t,sa,e),n(t,Mt,e),n(t,la,e),c(yt,t,e),n(t,oa,e),n(t,Tt,e),n(t,ia,e),c(gt,t,e),n(t,ra,e),n(t,wt,e),n(t,pa,e),c(bt,t,e),n(t,da,e),n(t,Ut,e),n(t,ca,e),c(_t,t,e),n(t,ma,e),n(t,kt,e),n(t,ua,e),c(jt,t,e),n(t,ha,e),c(Jt,t,e),n(t,fa,e),n(t,Ct,e),n(t,Ma,e),c($t,t,e),n(t,ya,e),n(t,xt,e),n(t,Ta,e),c(vt,t,e),n(t,ga,e),n(t,Ft,e),n(t,wa,e),c(It,t,e),n(t,ba,e),n(t,Gt,e),n(t,Ua,e),c(Rt,t,e),n(t,_a,e),n(t,Zt,e),n(t,ka,e),n(t,zt,e),n(t,ja,e),n(t,Bt,e),n(t,Ja,e),c(St,t,e),n(t,Ca,e),n(t,Nt,e),n(t,$a,e),c(Et,t,e),n(t,xa,e),n(t,At,e),n(t,va,e),c(Xt,t,e),n(t,Fa,e),n(t,Vt,e),n(t,Ia,e),n(t,Qt,e),n(t,Ga,e),c(Wt,t,e),n(t,Ra,e),n(t,qt,e),n(t,Za,e),n(t,Lt,e),n(t,za,e),n(t,w,e),n(t,Ba,e),n(t,Ht,e),n(t,Sa,e),c(Yt,t,e),n(t,Na,e),n(t,Dt,e),n(t,Ea,e),n(t,b,e),n(t,Aa,e),n(t,Pt,e),n(t,Xa,e),c(Ot,t,e),n(t,Va,e),n(t,Kt,e),n(t,Qa,e),n(t,te,e),n(t,Wa,e),c(ee,t,e),n(t,qa,e),n(t,g,e),c(ae,g,null),_(g,tn),_(g,oe),n(t,La,e),c(ne,t,e),n(t,Ha,e),n(t,y,e),c(se,y,null),_(y,en),_(y,ie),_(y,an),c(le,y,null),_(y,nn),_(y,re),n(t,Ya,e),n(t,de,e),Da=!0},p:os,i(t){Da||(m(k.$$.fragment,t),m(C.$$.fragment,t),m(x.$$.fragment,t),m(I.$$.fragment,t),m(R.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(N.$$.fragment,t),m(A.$$.fragment,t),m(V.$$.fragment,t),m(L.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(at.$$.fragment,t),m(st.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(ut.$$.fragment,t),m(ft.$$.fragment,t),m(yt.$$.fragment,t),m(gt.$$.fragment,t),m(bt.$$.fragment,t),m(_t.$$.fragment,t),m(jt.$$.fragment,t),m(Jt.$$.fragment,t),m($t.$$.fragment,t),m(vt.$$.fragment,t),m(It.$$.fragment,t),m(Rt.$$.fragment,t),m(St.$$.fragment,t),m(Et.$$.fragment,t),m(Xt.$$.fragment,t),m(Wt.$$.fragment,t),m(Yt.$$.fragment,t),m(Ot.$$.fragment,t),m(ee.$$.fragment,t),m(ae.$$.fragment,t),m(ne.$$.fragment,t),m(se.$$.fragment,t),m(le.$$.fragment,t),Da=!0)},o(t){u(k.$$.fragment,t),u(C.$$.fragment,t),u(x.$$.fragment,t),u(I.$$.fragment,t),u(R.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(N.$$.fragment,t),u(A.$$.fragment,t),u(V.$$.fragment,t),u(L.$$.fragment,t),u(Y.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(at.$$.fragment,t),u(st.$$.fragment,t),u(ot.$$.fragment,t),u(rt.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(ut.$$.fragment,t),u(ft.$$.fragment,t),u(yt.$$.fragment,t),u(gt.$$.fragment,t),u(bt.$$.fragment,t),u(_t.$$.fragment,t),u(jt.$$.fragment,t),u(Jt.$$.fragment,t),u($t.$$.fragment,t),u(vt.$$.fragment,t),u(It.$$.fragment,t),u(Rt.$$.fragment,t),u(St.$$.fragment,t),u(Et.$$.fragment,t),u(Xt.$$.fragment,t),u(Wt.$$.fragment,t),u(Yt.$$.fragment,t),u(Ot.$$.fragment,t),u(ee.$$.fragment,t),u(ae.$$.fragment,t),u(ne.$$.fragment,t),u(se.$$.fragment,t),u(le.$$.fragment,t),Da=!1},d(t){t&&(a(ce),a(pe),a(me),a(ue),a(j),a(he),a(J),a(fe),a(Me),a($),a(ye),a(Te),a(v),a(ge),a(F),a(we),a(be),a(G),a(Ue),a(_e),a(ke),a(z),a(je),a(Je),a(S),a(Ce),a($e),a(E),a(xe),a(ve),a(X),a(Fe),a(Ie),a(Q),a(Ge),a(W),a(Re),a(q),a(Ze),a(ze),a(H),a(Be),a(Se),a(Ne),a(P),a(Ee),a(Ae),a(K),a(Xe),a(Ve),a(et),a(Qe),a(We),a(nt),a(qe),a(Le),a(lt),a(He),a(Ye),a(it),a(De),a(Pe),a(pt),a(Oe),a(Ke),a(ct),a(ta),a(ea),a(aa),a(ht),a(na),a(sa),a(Mt),a(la),a(oa),a(Tt),a(ia),a(ra),a(wt),a(pa),a(da),a(Ut),a(ca),a(ma),a(kt),a(ua),a(ha),a(fa),a(Ct),a(Ma),a(ya),a(xt),a(Ta),a(ga),a(Ft),a(wa),a(ba),a(Gt),a(Ua),a(_a),a(Zt),a(ka),a(zt),a(ja),a(Bt),a(Ja),a(Ca),a(Nt),a($a),a(xa),a(At),a(va),a(Fa),a(Vt),a(Ia),a(Qt),a(Ga),a(Ra),a(qt),a(Za),a(Lt),a(za),a(w),a(Ba),a(Ht),a(Sa),a(Na),a(Dt),a(Ea),a(b),a(Aa),a(Pt),a(Xa),a(Va),a(Kt),a(Qa),a(te),a(Wa),a(qa),a(g),a(La),a(Ha),a(y),a(Ya),a(de)),a(T),h(k,t),h(C,t),h(x,t),h(I,t),h(R,t),h(Z,t),h(B,t),h(N,t),h(A,t),h(V,t),h(L,t),h(Y,t),h(D,t),h(O,t),h(tt,t),h(at,t),h(st,t),h(ot,t),h(rt,t),h(dt,t),h(mt,t),h(ut,t),h(ft,t),h(yt,t),h(gt,t),h(bt,t),h(_t,t),h(jt,t),h(Jt,t),h($t,t),h(vt,t),h(It,t),h(Rt,t),h(St,t),h(Et,t),h(Xt,t),h(Wt,t),h(Yt,t),h(Ot,t),h(ee,t),h(ae),h(ne,t),h(se),h(le)}}}const ms='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[{"title":"Answer: {answer}","local":"answer-answer","sections":[],"depth":3}],"depth":2}],"depth":1}';function us(sn){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends rs{constructor(T){super(),ps(this,T,us,cs,ls,{})}}export{gs as component};
