import{s as Nn,n as Vn,o as Rn}from"../chunks/scheduler.9039eef2.js";import{S as Wn,i as Hn,g as l,s as a,r as c,A as Xn,h as i,f as n,c as r,j as T,u as m,x as p,k as b,y as s,a as o,v as h,d as g,t as u,w as f}from"../chunks/index.ded8f90d.js";import{D as _}from"../chunks/Docstring.a2ba2b54.js";import{C as v}from"../chunks/CodeBlock.8580f3e8.js";import{H as $e}from"../chunks/Heading.f027f30d.js";function En(pn){let w,Re,Ne,We,O,He,Z,cn='TRL supports the <a href="https://arxiv.org/abs/1707.06347" rel="nofollow">PPO</a> Trainer for training language models on any reward signal with RL. The reward signal can come from a handcrafted rule, a metric or from preference data using a Reward Model. For a full example have a look at <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a>. The trainer is heavily inspired by the original <a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">OpenAI learning to summarize work</a>.',Xe,B,mn='The first step is to train your SFT model (see the <a href="sft_trainer">SFTTrainer</a>), to ensure the data we train on is in-distribution for the PPO algorithm. In addition we need to train a Reward model (see <a href="reward_trainer">RewardTrainer</a>) which will be used to optimize the SFT model using the PPO algorithm.',Ee,q,Qe,L,hn="The <code>PPOTrainer</code> expects to align a generated response with a query given the rewards obtained from the Reward model. During each step of the PPO algorithm we sample a batch of prompts from the dataset, we then use these prompts to generate the a responses from the SFT model. Next, the Reward model is used to compute the rewards for the generated response. Finally, these rewards are used to optimize the SFT model using the PPO algorithm.",Se,G,gn="Therefore the dataset should contain a text column which we can rename to <code>query</code>. Each of the other data-points required to optimize the SFT model are obtained during the training loop.",Ae,N,un='Here is an example with the <a href="https://huggingface.co/datasets/HuggingFaceH4/cherry_picked_prompts" rel="nofollow">HuggingFaceH4/cherry_picked_prompts</a> dataset:',De,V,Ye,R,fn="Resulting in the following subset of the dataset:",Ke,W,et,H,tt,X,yn='For a detailed example have a look at the <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a> notebook. At a high level we need to initialize the <code>PPOTrainer</code> with a <code>model</code> we wish to train. Additionally, we require a reference <code>reward_model</code> which we will use to rate the generated response.',nt,E,at,Q,Tn="The <code>PPOConfig</code> dataclass controls all the hyperparameters and settings for the PPO algorithm and trainer.",rt,S,ot,A,bn="Now we can initialize our model. Note that PPO also requires a reference model, but this model is generated by the ‘PPOTrainer` automatically. The model can be initialized as follows:",st,D,lt,Y,_n="As mentioned above, the reward can be generated using any function that returns a single value for a string, be it a simple rule (e.g. length of string), a metric (e.g. BLEU), or a reward model based on human preferences. In this example we use a reward model and initialize it using <code>transformers.pipeline</code> for ease of use.",it,K,dt,ee,wn="Lastly, we pretokenize our dataset using the <code>tokenizer</code> to ensure we can efficiently generate responses during the training loop:",pt,te,ct,ne,Mn="Now we are ready to initialize the <code>PPOTrainer</code> using the defined config, datasets, and model.",mt,ae,ht,re,gt,oe,vn="Because the <code>PPOTrainer</code> needs an active <code>reward</code> per execution step, we need to define a method to get rewards during each step of the PPO algorithm. In this example we will be using the sentiment <code>reward_model</code> initialized above.",ut,se,Jn='To guide the generation process we use the <code>generation_kwargs</code> which are passed to the <code>model.generate</code> method for the SFT-model during each step. A more detailed example can be found over <a href="how_to_train#how-to-generate-text-for-training">here</a>.',ft,le,yt,ie,Pn="We can then loop over all examples in the dataset and generate a response for each query. We then calculate the reward for each generated response using the <code>reward_model</code> and pass these rewards to the <code>ppo_trainer.step</code> method. The <code>ppo_trainer.step</code> method will then optimize the SFT model using the PPO algorithm.",Tt,de,bt,pe,_t,ce,Un="While training and evaluating we log the following metrics:",wt,me,$n="<li><code>stats</code>: The statistics of the PPO algorithm, including the loss, entropy, etc.</li> <li><code>batch</code>: The batch of data used to train the SFT model.</li> <li><code>rewards</code>: The rewards obtained from the Reward model.</li>",Mt,he,vt,d,ge,Lt,xe,xn=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Gt,J,ue,Nt,Ce,Cn="Calculate model outputs in multiple batches.",Vt,P,fe,Rt,Ie,In="Compute per token rewards from scores and KL-penalty.",Wt,U,ye,Ht,je,jn="Creates and saves a model card for a TRL model.",Xt,$,Te,Et,ke,kn="Gather stats from all processes. Useful in the context of distributed training.",Qt,x,be,St,ze,zn=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,At,C,_e,Dt,Fe,Fn="A function that logs all the training stats. Call it at the end of each epoch.",Yt,I,we,Kt,Oe,On="Calculate policy and value losses.",en,j,Me,tn,Ze,Zn="Prepare the dataloader for training.",nn,k,ve,an,Be,Bn="Record training step statistics.",rn,z,Je,on,qe,qn="Run a PPO optimisation step given a list of queries, model responses, and rewards.",sn,F,Pe,ln,Le,Ln="Train one PPO minibatch",Jt,M,Ue,dn,Ge,Gn="Configuration class for PPOTrainer",Pt,Ve,Ut;return O=new $e({props:{title:"PPO Trainer",local:"ppo-trainer",headingTag:"h1"}}),q=new $e({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),V=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGY2hlcnJ5X3BpY2tlZF9wcm9tcHRzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW5hbWVfY29sdW1uKCUyMnByb21wdCUyMiUyQyUyMCUyMnF1ZXJ5JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMm1ldGElMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/cherry_picked_prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;query&quot;</span>)
dataset = dataset.remove_columns([<span class="hljs-string">&quot;meta&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),W=new v({props:{code:"cHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRXhwbGFpbiUyMHRoZSUyMG1vb24lMjBsYW5kaW5nJTIwdG8lMjBhJTIwNiUyMHllYXIlMjBvbGQlMjBpbiUyMGElMjBmZXclMjBzZW50ZW5jZXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2h5JTIwYXJlbiVFMiU4MCU5OXQlMjBiaXJkcyUyMHJlYWwlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaGFwcGVucyUyMGlmJTIweW91JTIwZmlyZSUyMGElMjBjYW5ub25iYWxsJTIwZGlyZWN0bHklMjBhdCUyMGElMjBwdW1wa2luJTIwYXQlMjBoaWdoJTIwc3BlZWRzJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwSSUyMHN0ZWFsJTIwZnJvbSUyMGElMjBncm9jZXJ5JTIwc3RvcmUlMjB3aXRob3V0JTIwZ2V0dGluZyUyMGNhdWdodCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoeSUyMGlzJTIwaXQlMjBpbXBvcnRhbnQlMjB0byUyMGVhdCUyMHNvY2tzJTIwYWZ0ZXIlMjBtZWRpdGF0aW5nJTNGJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`ppo_dataset_dict = {
    <span class="hljs-string">&quot;query&quot;</span>: [
        <span class="hljs-string">&quot;Explain the moon landing to a 6 year old in a few sentences.&quot;</span>,
        <span class="hljs-string">&quot;Why aren’t birds real?&quot;</span>,
        <span class="hljs-string">&quot;What happens if you fire a cannonball directly at a pumpkin at high speeds?&quot;</span>,
        <span class="hljs-string">&quot;How can I steal from a grocery store without getting caught?&quot;</span>,
        <span class="hljs-string">&quot;Why is it important to eat socks after meditating? &quot;</span>
    ]
}`,wrap:!1}}),H=new $e({props:{title:"Using the PPOTrainer",local:"using-the-ppotrainer",headingTag:"h2"}}),E=new $e({props:{title:"Initializing the PPOTrainer",local:"initializing-the-ppotrainer",headingTag:"h3"}}),S=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMFBQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxLjQxZS01JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

config = PPOConfig(
    model_name=<span class="hljs-string">&quot;gpt2&quot;</span>,
    learning_rate=<span class="hljs-number">1.41e-5</span>,
)`,wrap:!1}}),D=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwUFBPQ29uZmlnJTJDJTIwUFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEElMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer

model = AutoModelForCausalLMWithValueHead.from_pretrained(config.model_name)
tokenizer = AutoTokenizer.from_pretrained(config.model_name)

tokenizer.pad_token = tokenizer.eos_token`,wrap:!1}}),K=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcmV3YXJkX21vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

reward_model = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)`,wrap:!1}}),te=new v({props:{code:"ZGVmJTIwdG9rZW5pemUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmlucHV0X2lkcyUyMiU1RCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoc2FtcGxlJTVCJTIycXVlcnklMjIlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzREZhbHNlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenizer.encode(sample[<span class="hljs-string">&quot;query&quot;</span>])
    <span class="hljs-keyword">return</span> sample

dataset = dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">False</span>)`,wrap:!1}}),ae=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMEElMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRGNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer

ppo_trainer = PPOTrainer(
    model=model,
    config=config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),re=new $e({props:{title:"Starting the training loop",local:"starting-the-training-loop",headingTag:"h3"}}),le=new v({props:{code:"Z2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtaW5fbGVuZ3RoJTIyJTNBJTIwLTElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhZF90b2tlbl9pZCUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMkMlMEElN0Q=",highlighted:`generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
}`,wrap:!1}}),de=new v({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZm9yJTIwZXBvY2glMkMlMjBiYXRjaCUyMGluJTIwdHFkbShlbnVtZXJhdGUocHBvX3RyYWluZXIuZGF0YWxvYWRlcikpJTNBJTBBJTIwJTIwJTIwJTIwcXVlcnlfdGVuc29ycyUyMCUzRCUyMGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwR2V0JTIwcmVzcG9uc2UlMjBmcm9tJTIwU0ZUTW9kZWwlMEElMjAlMjAlMjAlMjByZXNwb25zZV90ZW5zb3JzJTIwJTNEJTIwcHBvX3RyYWluZXIuZ2VuZXJhdGUocXVlcnlfdGVuc29ycyUyQyUyMCoqZ2VuZXJhdGlvbl9rd2FyZ3MpJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJyZXNwb25zZSUyMiU1RCUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUoci5zcXVlZXplKCkpJTIwZm9yJTIwciUyMGluJTIwcmVzcG9uc2VfdGVuc29ycyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMyUyMyUyMyUyMENvbXB1dGUlMjByZXdhcmQlMjBzY29yZSUwQSUyMCUyMCUyMCUyMHRleHRzJTIwJTNEJTIwJTVCcSUyMCUyQiUyMHIlMjBmb3IlMjBxJTJDJTIwciUyMGluJTIwemlwKGJhdGNoJTVCJTIycXVlcnklMjIlNUQlMkMlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEKSU1RCUwQSUyMCUyMCUyMCUyMHBpcGVfb3V0cHV0cyUyMCUzRCUyMHJld2FyZF9tb2RlbCh0ZXh0cyklMEElMjAlMjAlMjAlMjByZXdhcmRzJTIwJTNEJTIwJTVCdG9yY2gudGVuc29yKG91dHB1dCU1QjElNUQlNUIlMjJzY29yZSUyMiU1RCklMjBmb3IlMjBvdXRwdXQlMjBpbiUyMHBpcGVfb3V0cHV0cyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMyUyMyUyMyUyMFJ1biUyMFBQTyUyMHN0ZXAlMEElMjAlMjAlMjAlMjBzdGF0cyUyMCUzRCUyMHBwb190cmFpbmVyLnN0ZXAocXVlcnlfdGVuc29ycyUyQyUyMHJlc3BvbnNlX3RlbnNvcnMlMkMlMjByZXdhcmRzKSUwQSUyMCUyMCUyMCUyMHBwb190cmFpbmVyLmxvZ19zdGF0cyhzdGF0cyUyQyUyMGJhdGNoJTJDJTIwcmV3YXJkcyklMEElMEElMjMlMjMlMjMlMjMlMjBTYXZlJTIwbW9kZWwlMEFwcG9fdHJhaW5lci5zYXZlX21vZGVsKCUyMm15X3Bwb19tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

<span class="hljs-keyword">for</span> epoch, batch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(ppo_trainer.dataloader)):
    query_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]

    <span class="hljs-comment">#### Get response from SFTModel</span>
    response_tensors = ppo_trainer.generate(query_tensors, **generation_kwargs)
    batch[<span class="hljs-string">&quot;response&quot;</span>] = [tokenizer.decode(r.squeeze()) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> response_tensors]

    <span class="hljs-comment">#### Compute reward score</span>
    texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
    pipe_outputs = reward_model(texts)
    rewards = [torch.tensor(output[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;score&quot;</span>]) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]

    <span class="hljs-comment">#### Run PPO step</span>
    stats = ppo_trainer.step(query_tensors, response_tensors, rewards)
    ppo_trainer.log_stats(stats, batch, rewards)

<span class="hljs-comment">#### Save model</span>
ppo_trainer.save_model(<span class="hljs-string">&quot;my_ppo_model&quot;</span>)`,wrap:!1}}),pe=new $e({props:{title:"Logging",local:"logging",headingTag:"h2"}}),he=new $e({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),ge=new _({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": PPOConfig = None"},{name:"model",val:": PreTrainedModelWrapper = None"},{name:"ref_model",val:": typing.Optional[trl.models.modeling_base.PreTrainedModelWrapper] = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset, NoneType] = None"},{name:"optimizer",val:": typing.Optional[torch.optim.optimizer.Optimizer] = None"},{name:"data_collator",val:": typing.Optional[typing.Callable] = None"},{name:"num_shared_layers",val:": typing.Optional[int] = None"},{name:"lr_scheduler",val:": typing.Optional[torch.optim.lr_scheduler._LRScheduler] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L108"}}),ue=new _({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L935",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),fe=new _({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1072"}}),ye=new _({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": typing.Optional[str] = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1371"}}),Te=new _({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),be=new _({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor]]"},{name:"length_sampler",val:": typing.Callable = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L426",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),_e=new _({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": typing.List[torch.FloatTensor]"},{name:"columns_to_log",val:": typing.List[str] = ['query', 'response']"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1300"}}),we=new _({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1148"}}),Me=new _({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset]"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),ve=new _({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),Je=new _({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": typing.List[torch.LongTensor]"},{name:"responses",val:": typing.List[torch.LongTensor]"},{name:"scores",val:": typing.List[torch.FloatTensor]"},{name:"response_masks",val:": typing.Optional[typing.List[torch.LongTensor]] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Pe=new _({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1026",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),Ue=new _({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"task_name",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"query_dataset",val:": typing.Optional[str] = None"},{name:"reward_model",val:": typing.Optional[str] = None"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"accelerator_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"project_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f3125f22280>)] = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": typing.Optional[float] = 0.2"},{name:"kl_penalty",val:": typing.Literal['kl', 'abs', 'mse', 'full'] = 'kl'"},{name:"target",val:": typing.Optional[float] = 6"},{name:"horizon",val:": typing.Optional[float] = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 256"},{name:"forward_batch_size",val:": typing.Optional[int] = None"},{name:"mini_batch_size",val:": int = 1"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": typing.Optional[float] = None"},{name:"optimize_cuda_cache",val:": typing.Optional[bool] = None"},{name:"optimize_device_cache",val:": typing.Optional[bool] = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": typing.Optional[float] = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"is_peft_model",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L35"}}),{c(){w=l("meta"),Re=a(),Ne=l("p"),We=a(),c(O.$$.fragment),He=a(),Z=l("p"),Z.innerHTML=cn,Xe=a(),B=l("p"),B.innerHTML=mn,Ee=a(),c(q.$$.fragment),Qe=a(),L=l("p"),L.innerHTML=hn,Se=a(),G=l("p"),G.innerHTML=gn,Ae=a(),N=l("p"),N.innerHTML=un,De=a(),c(V.$$.fragment),Ye=a(),R=l("p"),R.textContent=fn,Ke=a(),c(W.$$.fragment),et=a(),c(H.$$.fragment),tt=a(),X=l("p"),X.innerHTML=yn,nt=a(),c(E.$$.fragment),at=a(),Q=l("p"),Q.innerHTML=Tn,rt=a(),c(S.$$.fragment),ot=a(),A=l("p"),A.textContent=bn,st=a(),c(D.$$.fragment),lt=a(),Y=l("p"),Y.innerHTML=_n,it=a(),c(K.$$.fragment),dt=a(),ee=l("p"),ee.innerHTML=wn,pt=a(),c(te.$$.fragment),ct=a(),ne=l("p"),ne.innerHTML=Mn,mt=a(),c(ae.$$.fragment),ht=a(),c(re.$$.fragment),gt=a(),oe=l("p"),oe.innerHTML=vn,ut=a(),se=l("p"),se.innerHTML=Jn,ft=a(),c(le.$$.fragment),yt=a(),ie=l("p"),ie.innerHTML=Pn,Tt=a(),c(de.$$.fragment),bt=a(),c(pe.$$.fragment),_t=a(),ce=l("p"),ce.textContent=Un,wt=a(),me=l("ul"),me.innerHTML=$n,Mt=a(),c(he.$$.fragment),vt=a(),d=l("div"),c(ge.$$.fragment),Lt=a(),xe=l("p"),xe.innerHTML=xn,Gt=a(),J=l("div"),c(ue.$$.fragment),Nt=a(),Ce=l("p"),Ce.textContent=Cn,Vt=a(),P=l("div"),c(fe.$$.fragment),Rt=a(),Ie=l("p"),Ie.textContent=In,Wt=a(),U=l("div"),c(ye.$$.fragment),Ht=a(),je=l("p"),je.textContent=jn,Xt=a(),$=l("div"),c(Te.$$.fragment),Et=a(),ke=l("p"),ke.textContent=kn,Qt=a(),x=l("div"),c(be.$$.fragment),St=a(),ze=l("p"),ze.innerHTML=zn,At=a(),C=l("div"),c(_e.$$.fragment),Dt=a(),Fe=l("p"),Fe.textContent=Fn,Yt=a(),I=l("div"),c(we.$$.fragment),Kt=a(),Oe=l("p"),Oe.textContent=On,en=a(),j=l("div"),c(Me.$$.fragment),tn=a(),Ze=l("p"),Ze.textContent=Zn,nn=a(),k=l("div"),c(ve.$$.fragment),an=a(),Be=l("p"),Be.textContent=Bn,rn=a(),z=l("div"),c(Je.$$.fragment),on=a(),qe=l("p"),qe.textContent=qn,sn=a(),F=l("div"),c(Pe.$$.fragment),ln=a(),Le=l("p"),Le.textContent=Ln,Jt=a(),M=l("div"),c(Ue.$$.fragment),dn=a(),Ge=l("p"),Ge.textContent=Gn,Pt=a(),Ve=l("p"),this.h()},l(e){const t=Xn("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(n),Re=r(e),Ne=i(e,"P",{}),T(Ne).forEach(n),We=r(e),m(O.$$.fragment,e),He=r(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1ulw62x"&&(Z.innerHTML=cn),Xe=r(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1c2evbn"&&(B.innerHTML=mn),Ee=r(e),m(q.$$.fragment,e),Qe=r(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-r47fon"&&(L.innerHTML=hn),Se=r(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-nw9p0e"&&(G.innerHTML=gn),Ae=r(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-ew3j45"&&(N.innerHTML=un),De=r(e),m(V.$$.fragment,e),Ye=r(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1lutirw"&&(R.textContent=fn),Ke=r(e),m(W.$$.fragment,e),et=r(e),m(H.$$.fragment,e),tt=r(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-kuth75"&&(X.innerHTML=yn),nt=r(e),m(E.$$.fragment,e),at=r(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-15i9f61"&&(Q.innerHTML=Tn),rt=r(e),m(S.$$.fragment,e),ot=r(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-ft92fq"&&(A.textContent=bn),st=r(e),m(D.$$.fragment,e),lt=r(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-5saaij"&&(Y.innerHTML=_n),it=r(e),m(K.$$.fragment,e),dt=r(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1tdshp6"&&(ee.innerHTML=wn),pt=r(e),m(te.$$.fragment,e),ct=r(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1dqo05b"&&(ne.innerHTML=Mn),mt=r(e),m(ae.$$.fragment,e),ht=r(e),m(re.$$.fragment,e),gt=r(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1gfcgdl"&&(oe.innerHTML=vn),ut=r(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-xqje4x"&&(se.innerHTML=Jn),ft=r(e),m(le.$$.fragment,e),yt=r(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-jd50df"&&(ie.innerHTML=Pn),Tt=r(e),m(de.$$.fragment,e),bt=r(e),m(pe.$$.fragment,e),_t=r(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1jybr47"&&(ce.textContent=Un),wt=r(e),me=i(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-1qs2o7q"&&(me.innerHTML=$n),Mt=r(e),m(he.$$.fragment,e),vt=r(e),d=i(e,"DIV",{class:!0});var y=T(d);m(ge.$$.fragment,y),Lt=r(y),xe=i(y,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-hys9rl"&&(xe.innerHTML=xn),Gt=r(y),J=i(y,"DIV",{class:!0});var $t=T(J);m(ue.$$.fragment,$t),Nt=r($t),Ce=i($t,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-185nst0"&&(Ce.textContent=Cn),$t.forEach(n),Vt=r(y),P=i(y,"DIV",{class:!0});var xt=T(P);m(fe.$$.fragment,xt),Rt=r(xt),Ie=i(xt,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-3nt516"&&(Ie.textContent=In),xt.forEach(n),Wt=r(y),U=i(y,"DIV",{class:!0});var Ct=T(U);m(ye.$$.fragment,Ct),Ht=r(Ct),je=i(Ct,"P",{"data-svelte-h":!0}),p(je)!=="svelte-3jfrz9"&&(je.textContent=jn),Ct.forEach(n),Xt=r(y),$=i(y,"DIV",{class:!0});var It=T($);m(Te.$$.fragment,It),Et=r(It),ke=i(It,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-lcc1u3"&&(ke.textContent=kn),It.forEach(n),Qt=r(y),x=i(y,"DIV",{class:!0});var jt=T(x);m(be.$$.fragment,jt),St=r(jt),ze=i(jt,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1gqqzmu"&&(ze.innerHTML=zn),jt.forEach(n),At=r(y),C=i(y,"DIV",{class:!0});var kt=T(C);m(_e.$$.fragment,kt),Dt=r(kt),Fe=i(kt,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-ffqz5"&&(Fe.textContent=Fn),kt.forEach(n),Yt=r(y),I=i(y,"DIV",{class:!0});var zt=T(I);m(we.$$.fragment,zt),Kt=r(zt),Oe=i(zt,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-febvhf"&&(Oe.textContent=On),zt.forEach(n),en=r(y),j=i(y,"DIV",{class:!0});var Ft=T(j);m(Me.$$.fragment,Ft),tn=r(Ft),Ze=i(Ft,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1hbodkw"&&(Ze.textContent=Zn),Ft.forEach(n),nn=r(y),k=i(y,"DIV",{class:!0});var Ot=T(k);m(ve.$$.fragment,Ot),an=r(Ot),Be=i(Ot,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1hfgx92"&&(Be.textContent=Bn),Ot.forEach(n),rn=r(y),z=i(y,"DIV",{class:!0});var Zt=T(z);m(Je.$$.fragment,Zt),on=r(Zt),qe=i(Zt,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-yrsdu6"&&(qe.textContent=qn),Zt.forEach(n),sn=r(y),F=i(y,"DIV",{class:!0});var Bt=T(F);m(Pe.$$.fragment,Bt),ln=r(Bt),Le=i(Bt,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-3k7k5e"&&(Le.textContent=Ln),Bt.forEach(n),y.forEach(n),Jt=r(e),M=i(e,"DIV",{class:!0});var qt=T(M);m(Ue.$$.fragment,qt),dn=r(qt),Ge=i(qt,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-aondqr"&&(Ge.textContent=Gn),qt.forEach(n),Pt=r(e),Ve=i(e,"P",{}),T(Ve).forEach(n),this.h()},h(){b(w,"name","hf:doc:metadata"),b(w,"content",Qn),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,w),o(e,Re,t),o(e,Ne,t),o(e,We,t),h(O,e,t),o(e,He,t),o(e,Z,t),o(e,Xe,t),o(e,B,t),o(e,Ee,t),h(q,e,t),o(e,Qe,t),o(e,L,t),o(e,Se,t),o(e,G,t),o(e,Ae,t),o(e,N,t),o(e,De,t),h(V,e,t),o(e,Ye,t),o(e,R,t),o(e,Ke,t),h(W,e,t),o(e,et,t),h(H,e,t),o(e,tt,t),o(e,X,t),o(e,nt,t),h(E,e,t),o(e,at,t),o(e,Q,t),o(e,rt,t),h(S,e,t),o(e,ot,t),o(e,A,t),o(e,st,t),h(D,e,t),o(e,lt,t),o(e,Y,t),o(e,it,t),h(K,e,t),o(e,dt,t),o(e,ee,t),o(e,pt,t),h(te,e,t),o(e,ct,t),o(e,ne,t),o(e,mt,t),h(ae,e,t),o(e,ht,t),h(re,e,t),o(e,gt,t),o(e,oe,t),o(e,ut,t),o(e,se,t),o(e,ft,t),h(le,e,t),o(e,yt,t),o(e,ie,t),o(e,Tt,t),h(de,e,t),o(e,bt,t),h(pe,e,t),o(e,_t,t),o(e,ce,t),o(e,wt,t),o(e,me,t),o(e,Mt,t),h(he,e,t),o(e,vt,t),o(e,d,t),h(ge,d,null),s(d,Lt),s(d,xe),s(d,Gt),s(d,J),h(ue,J,null),s(J,Nt),s(J,Ce),s(d,Vt),s(d,P),h(fe,P,null),s(P,Rt),s(P,Ie),s(d,Wt),s(d,U),h(ye,U,null),s(U,Ht),s(U,je),s(d,Xt),s(d,$),h(Te,$,null),s($,Et),s($,ke),s(d,Qt),s(d,x),h(be,x,null),s(x,St),s(x,ze),s(d,At),s(d,C),h(_e,C,null),s(C,Dt),s(C,Fe),s(d,Yt),s(d,I),h(we,I,null),s(I,Kt),s(I,Oe),s(d,en),s(d,j),h(Me,j,null),s(j,tn),s(j,Ze),s(d,nn),s(d,k),h(ve,k,null),s(k,an),s(k,Be),s(d,rn),s(d,z),h(Je,z,null),s(z,on),s(z,qe),s(d,sn),s(d,F),h(Pe,F,null),s(F,ln),s(F,Le),o(e,Jt,t),o(e,M,t),h(Ue,M,null),s(M,dn),s(M,Ge),o(e,Pt,t),o(e,Ve,t),Ut=!0},p:Vn,i(e){Ut||(g(O.$$.fragment,e),g(q.$$.fragment,e),g(V.$$.fragment,e),g(W.$$.fragment,e),g(H.$$.fragment,e),g(E.$$.fragment,e),g(S.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(be.$$.fragment,e),g(_e.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(Je.$$.fragment,e),g(Pe.$$.fragment,e),g(Ue.$$.fragment,e),Ut=!0)},o(e){u(O.$$.fragment,e),u(q.$$.fragment,e),u(V.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u(_e.$$.fragment,e),u(we.$$.fragment,e),u(Me.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(Pe.$$.fragment,e),u(Ue.$$.fragment,e),Ut=!1},d(e){e&&(n(Re),n(Ne),n(We),n(He),n(Z),n(Xe),n(B),n(Ee),n(Qe),n(L),n(Se),n(G),n(Ae),n(N),n(De),n(Ye),n(R),n(Ke),n(et),n(tt),n(X),n(nt),n(at),n(Q),n(rt),n(ot),n(A),n(st),n(lt),n(Y),n(it),n(dt),n(ee),n(pt),n(ct),n(ne),n(mt),n(ht),n(gt),n(oe),n(ut),n(se),n(ft),n(yt),n(ie),n(Tt),n(bt),n(_t),n(ce),n(wt),n(me),n(Mt),n(vt),n(d),n(Jt),n(M),n(Pt),n(Ve)),n(w),f(O,e),f(q,e),f(V,e),f(W,e),f(H,e),f(E,e),f(S,e),f(D,e),f(K,e),f(te,e),f(ae,e),f(re,e),f(le,e),f(de,e),f(pe,e),f(he,e),f(ge),f(ue),f(fe),f(ye),f(Te),f(be),f(_e),f(we),f(Me),f(ve),f(Je),f(Pe),f(Ue)}}}const Qn='{"title":"PPO Trainer","local":"ppo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the PPOTrainer","local":"using-the-ppotrainer","sections":[{"title":"Initializing the PPOTrainer","local":"initializing-the-ppotrainer","sections":[],"depth":3},{"title":"Starting the training loop","local":"starting-the-training-loop","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2}],"depth":1}';function Sn(pn){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ta extends Wn{constructor(w){super(),Hn(this,w,Sn,En,Nn,{})}}export{ta as component};
