import{s as Uj,n as fj,o as bj}from"../chunks/scheduler.b108d059.js";import{S as xj,i as Cj,g as a,s as i,r as c,A as gj,h as p,f as l,c as n,j as J,u as M,x as o,k as d,y as Ij,a as s,v as r,d as T,t as m,w as y}from"../chunks/index.008de539.js";import{C as u}from"../chunks/CodeBlock.3968c746.js";import{H as h}from"../chunks/Heading.88bfeb84.js";function kj(UJ){let w,_a,Na,Ya,j,Ra,U,$a,f,fJ="Pipelines provide a high-level, easy to use, API for running machine learning models.",Pa,b,bJ="<strong>Example:</strong> Instantiate pipeline using the <code>pipeline</code> function.",Va,x,Ea,C,xJ='<li><a href="#module_pipelines">pipelines</a><ul><li><em>static</em><ul><li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call(question, context, options)</code></a> ⇒ <code>QuestionAnsweringReturnType</code></li></ul></li> <li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call(texts, [options])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a></li> <li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a></li> <li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call(texts, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call(texts, options)</code></a> ⇒</li></ul></li> <li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline">.ZeroShotAudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotAudioClassificationPipeline_new"><code>new ZeroShotAudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline+_call"><code>._call(audios, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline">.ZeroShotObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotObjectDetectionPipeline_new"><code>new ZeroShotObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToImagePipeline">.ImageToImagePipeline</a><ul><li><a href="#module_pipelines.ImageToImagePipeline+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.DepthEstimationPipeline">.DepthEstimationPipeline</a><ul><li><a href="#module_pipelines.DepthEstimationPipeline+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.pipeline"><code>.pipeline(task, [model], [options])</code></a> ⇒ <code>Promise.&lt;Pipeline&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_pipelines..QuestionAnsweringResult"><code>~QuestionAnsweringResult</code></a> : <code>object</code></li> <li><a href="#module_pipelines..QuestionAnsweringReturnType"><code>~QuestionAnsweringReturnType</code></a> : <code>Promise.&lt;(QuestionAnsweringResult|Array&lt;QuestionAnsweringResult&gt;)&gt;</code></li> <li><a href="#module_pipelines..ChunkCallback"><code>~ChunkCallback</code></a> : <code>function</code></li></ul></li></ul></li>',za,Ha,Wa,g,Sa,I,Xa,k,CJ=`The Pipeline class is the class from which all pipelines inherit.
Refer to this class for methods shared across different pipelines.`,La,G,gJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Da,Z,IJ='<li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Fa,qa,Oa,Q,Ka,B,ep,A,kJ="Create a new Pipeline.",tp,N,GJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><code></code></td><td><p>The tokenizer to use (if any).</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><code></code></td><td><p>The processor to use (if any).</p></td></tr></tbody>",lp,sp,ip,v,np,_,ap,Y,ZJ="Disposes the model.",pp,R,QJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;void&gt;</code> - A promise that resolves when the model has been disposed.',op,dp,cp,$,Mp,P,rp,V,BJ="Executes the task associated with the pipeline.",Tp,E,AJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A promise that resolves to an array containing the inputs and outputs of the task.',mp,z,NJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be processed.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",yp,Jp,hp,H,up,W,wp,S,vJ="Text classification pipeline using any <code>ModelForSequenceClassification</code>.",jp,X,_J="<strong>Example:</strong> Sentiment-analysis w/ <code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code>.",Up,L,fp,D,YJ="<strong>Example:</strong> Multilingual sentiment-analysis w/ <code>Xenova/bert-base-multilingual-uncased-sentiment</code> (and return top 5 classes).",bp,F,xp,q,RJ="<strong>Example:</strong> Toxic comment classification w/ <code>Xenova/toxic-bert</code> (and return all classes).",Cp,O,gp,K,$J='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ip,kp,Gp,ee,Zp,te,Qp,le,PJ="Executes the text classification task.",Bp,se,VJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextClassificationPipeline"><code>TextClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Ap,ie,EJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Np,vp,_p,ne,Yp,ae,Rp,pe,zJ="Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>.",$p,oe,HJ="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code>.",Pp,de,Vp,ce,WJ="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code> (and return all labels).",Ep,Me,zp,re,SJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Hp,Wp,Sp,Te,Xp,me,Lp,ye,XJ="Executes the token classification task.",Dp,Je,LJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TokenClassificationPipeline"><code>TokenClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Fp,he,DJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>An optional object containing the following properties:</p></td></tr></tbody>",qp,Op,Kp,ue,eo,we,to,je,FJ="Question Answering pipeline using any <code>ModelForQuestionAnswering</code>.",lo,Ue,qJ="<strong>Example:</strong> Run question answering with <code>Xenova/distilbert-base-uncased-distilled-squad</code>.",so,fe,io,be,OJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',no,ao,po,xe,oo,Ce,co,ge,KJ="Executes the question answering task.",Mo,Ie,eh=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.QuestionAnsweringPipeline"><code>QuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>QuestionAnsweringReturnType</code> - A promise that resolves to an array or object
containing the predicted answers and scores.`,ro,ke,th="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>question</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The question(s) to be answered.</p></td> </tr><tr><td>context</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The context(s) where the answer(s) can be found.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top answer predictions to be returned.</p></td></tr></tbody>",To,mo,yo,Ge,Jo,Ze,ho,Qe,lh="Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>.",uo,Be,sh="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-uncased</code>.",wo,Ae,jo,Ne,ih="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-cased</code> (and return top result).",Uo,ve,fo,_e,nh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',bo,xo,Co,Ye,go,Re,Io,$e,ah="Fill the masked token in the text(s) given as inputs.",ko,Pe,ph='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FillMaskPipeline"><code>FillMaskPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted tokens and scores.',Go,Ve,oh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The masked input texts.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Zo,Qo,Bo,Ee,Ao,ze,No,He,dh="Text2TextGenerationPipeline class for generating text using a model that performs text-to-text generation tasks.",vo,We,ch="<strong>Example:</strong> Text-to-text generation w/ <code>Xenova/LaMini-Flan-T5-783M</code>.",_o,Se,Yo,Xe,Mh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ro,$o,Po,Le,Vo,De,Eo,Fe,rh="Fill the masked token in the text(s) given as inputs.",zo,qe,Th=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of objects containing the score, predicted token, predicted token string,
and the sequence with the predicted token filled in, or an array of such arrays (one for each input text).
If only one input text is given, the output will be an array of objects.<br/> <strong>Throws</strong>:`,Ho,Oe,mh="<li><code>Error</code> When the mask token is not found in the input text.</li>",Wo,Ke,yh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text or array of texts to be processed.</p></td> </tr><tr><td>[options]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Options for the fill-mask pipeline.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top-k predictions to return.</p></td></tr></tbody>",So,Xo,Lo,et,Do,tt,Fo,lt,Jh="A pipeline for summarization tasks, inheriting from Text2TextGenerationPipeline.",qo,st,hh="<strong>Example:</strong> Summarization w/ <code>Xenova/distilbart-cnn-6-6</code>.",Oo,it,Ko,nt,uh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ed,td,ld,at,sd,pt,id,ot,wh="Translates text from one language to another.",nd,dt,jh="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/nllb-200-distilled-600M</code>.",ad,ct,Uh=`See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,pd,Mt,od,rt,fh="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/m2m100_418M</code>.",dd,Tt,bh=`See <a href="https://huggingface.co/facebook/m2m100_418M#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,cd,mt,Md,yt,xh="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/mbart-large-50-many-to-many-mmt</code>.",rd,Jt,Ch=`See <a href="https://huggingface.co/facebook/mbart-large-50-many-to-many-mmt#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,Td,ht,md,ut,gh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',yd,Jd,hd,wt,ud,jt,wd,Ut,Ih=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>.
This pipeline predicts the words that will follow a specified text prompt.
NOTE: For the full list of generation parameters, see <a href="./utils/generation#module_utils/generation.GenerationConfig"><code>GenerationConfig</code></a>.`,jd,ft,kh="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (default settings).",Ud,bt,fd,xt,Gh="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (custom settings).",bd,Ct,xd,gt,Zh="<strong>Example:</strong> Run code generation with <code>Xenova/codegen-350M-mono</code>.",Cd,It,gd,kt,Qh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Id,kd,Gd,Gt,Zd,Zt,Qd,Qt,Bh="Generates text based on an input prompt.",Bd,Bt,Ah='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextGenerationPipeline"><code>TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The generated text or texts.',Ad,At,Nh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input prompt or prompts to generate text from.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional arguments for text generation.</p></td></tr></tbody>",Nd,vd,_d,Nt,Yd,vt,Rd,_t,vh=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code>
trained on NLI (natural language inference) tasks. Equivalent of <code>text-classification</code>
pipelines, but these models don’t require a hardcoded number of potential classes, they
can be chosen at runtime. It usually means it’s slower but it is <strong>much</strong> more flexible.`,$d,Yt,_h="<strong>Example:</strong> Zero shot classification with <code>Xenova/mobilebert-uncased-mnli</code>.",Pd,Rt,Vd,$t,Yh="<strong>Example:</strong> Zero shot classification with <code>Xenova/nli-deberta-v3-xsmall</code> (multi-label).",Ed,Pt,zd,Vt,Rh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Hd,Et,$h='<li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Wd,Sd,Xd,zt,Ld,Ht,Dd,Wt,Ph="Create a new ZeroShotClassificationPipeline.",Fd,St,Vh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td></tr></tbody>",qd,Od,Kd,Xt,ec,Lt,tc,Dt,Eh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - The prediction(s), as a map (or list of maps) from label to score.',lc,Ft,zh=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;any&gt;</code></td><td></td><td></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This example is {}.&quot;&quot;</code></td><td><p>The template used to turn each
candidate label into an NLI-style hypothesis. The candidate label will replace the &amp;#123;} placeholder.</p></td> </tr><tr><td>[options.multi_label]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not multiple candidate labels can be true.
If <code>false</code>, the scores are normalized such that the sum of the label likelihoods for each sequence
is 1. If <code>true</code>, the labels are considered independent and probabilities are normalized for each
candidate by doing a softmax of the entailment score vs. the contradiction score.</p></td></tr></tbody>`,sc,ic,nc,qt,ac,Ot,pc,Kt,Hh=`Feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,oc,el,Wh="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (without pooling/normalization).",dc,tl,cc,ll,Sh="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (with pooling/normalization).",Mc,sl,rc,il,Xh="<strong>Example:</strong> Calculating embeddings with <code>sentence-transformers</code> models.",Tc,nl,mc,al,Lh='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',yc,Jc,hc,pl,uc,ol,wc,dl,Dh="Extract the features of the input(s).",jc,cl,Fh='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FeatureExtractionPipeline"><code>FeatureExtractionPipeline</code></a><br/> <strong>Returns</strong>: The features computed by the model.',Uc,Ml,qh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The input texts</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.pooling]</td><td><code>string</code></td><td><code>&quot;&quot;none&quot;&quot;</code></td><td><p>The pooling method to use. Can be one of: &quot;none&quot;, &quot;mean&quot;.</p></td> </tr><tr><td>[options.normalize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to normalize the embeddings in the last dimension.</p></td></tr></tbody>",fc,bc,xc,rl,Cc,Tl,gc,ml,Oh=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>.
This pipeline predicts the class of a raw waveform or an audio file.`,Ic,yl,Kh="<strong>Example:</strong> Perform audio classification with <code>Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech</code>.",kc,Jl,Gc,hl,eu="<strong>Example:</strong> Perform audio classification with <code>Xenova/ast-finetuned-audioset-10-10-0.4593</code> and return top 4 results.",Zc,ul,Qc,wl,tu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Bc,jl,lu='<li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li>',Ac,Nc,vc,Ul,_c,fl,Yc,bl,su="Create a new AudioClassificationPipeline.",Rc,xl,iu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",$c,Pc,Vc,Cl,Ec,gl,zc,Il,nu="Executes the audio classification task.",Hc,kl,au='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AudioClassificationPipeline"><code>AudioClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Wc,Gl,pu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td></td><td><p>The input audio files to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Sc,Xc,Lc,Zl,Dc,Ql,Fc,Bl,ou=`Zero shot audio classification pipeline using <code>ClapModel</code>. This pipeline predicts the class of an audio when you
provide an audio and a set of <code>candidate_labels</code>.`,qc,Al,du="<strong>Example</strong>: Perform zero-shot audio classification with <code>Xenova/clap-htsat-unfused</code>.",Oc,Nl,Kc,vl,cu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',eM,_l,Mu='<li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline">.ZeroShotAudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotAudioClassificationPipeline_new"><code>new ZeroShotAudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline+_call"><code>._call(audios, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',tM,lM,sM,Yl,iM,Rl,nM,$l,ru="Create a new ZeroShotAudioClassificationPipeline.",aM,Pl,Tu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",pM,oM,dM,Vl,cM,El,MM,zl,mu="Assign labels to the audio(s) passed as inputs.",rM,Hl,yu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotAudioClassificationPipeline"><code>ZeroShotAudioClassificationPipeline</code></a>',TM,Wl,Ju=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audios</td><td><code>Array</code></td><td><p>The input audios.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels for this audio</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><p>The sentence used in cunjunction with <em>candidate_labels</em> to attempt
the audio classification by replacing the placeholder with the candidate_labels.
Then likelihood is estimated by using logits_per_audio.</p></td></tr></tbody>`,mM,yM,JM,Sl,hM,Xl,uM,Ll,hu="Pipeline that aims at extracting spoken text contained within some audio.",wM,Dl,uu="<strong>Example:</strong> Transcribe English.",jM,Fl,UM,ql,wu="<strong>Example:</strong> Transcribe English w/ timestamps.",fM,Ol,bM,Kl,ju="<strong>Example:</strong> Transcribe English w/ word-level timestamps.",xM,es,CM,ts,Uu="<strong>Example:</strong> Transcribe French.",gM,ls,IM,ss,fu="<strong>Example:</strong> Translate French to English.",kM,is,GM,ns,bu="<strong>Example:</strong> Transcribe/translate audio longer than 30 seconds.",ZM,as,QM,ps,xu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',BM,os,Cu='<li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',AM,NM,vM,ds,_M,cs,YM,Ms,gu="Create a new AutomaticSpeechRecognitionPipeline.",RM,rs,Iu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",$M,PM,VM,Ts,EM,ms,zM,ys,ku="Asynchronously processes audio and generates text transcription using the model.",HM,Js,Gu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AutomaticSpeechRecognitionPipeline"><code>AutomaticSpeechRecognitionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves to an object containing the transcription text and optionally timestamps if <code>return_timestamps</code> is <code>true</code>.',WM,hs,Zu=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code> | <code>Array&lt;Float32Array&gt;</code></td><td></td><td><p>The audio to be transcribed. Can be a single Float32Array or an array of Float32Arrays.</p></td> </tr><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional arguments.</p></td> </tr><tr><td>[kwargs.return_timestamps]</td><td><code>boolean</code> | <code>&#39;word&#39;</code></td><td></td><td><p>Whether to return timestamps or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.chunk_length_s]</td><td><code>number</code></td><td></td><td><p>The length of audio chunks to process in seconds. Default is 0 (no chunking).</p></td> </tr><tr><td>[kwargs.stride_length_s]</td><td><code>number</code></td><td></td><td><p>The length of overlap between consecutive audio chunks in seconds. If not provided, defaults to <code>chunk_length_s / 6</code>.</p></td> </tr><tr><td>[kwargs.chunk_callback]</td><td><code>ChunkCallback</code></td><td></td><td><p>Callback function to be called with each chunk processed.</p></td> </tr><tr><td>[kwargs.force_full_sequences]</td><td><code>boolean</code></td><td></td><td><p>Whether to force outputting full sequences or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.language]</td><td><code>string</code></td><td></td><td><p>The source language. Default is <code>null</code>, meaning it should be auto-detected. Use this to potentially improve performance if the source language is known.</p></td> </tr><tr><td>[kwargs.task]</td><td><code>string</code></td><td></td><td><p>The task to perform. Default is <code>null</code>, meaning it should be auto-detected.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices
that will be forced before sampling. For example, [[1, 123]] means the second generated token will always be a token of index 123.</p></td></tr></tbody>`,SM,XM,LM,us,DM,ws,FM,js,Qu="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",qM,Us,Bu="<strong>Example:</strong> Generate a caption for an image w/ <code>Xenova/vit-gpt2-image-captioning</code>.",OM,fs,KM,bs,Au="<strong>Example:</strong> Optical Character Recognition (OCR) w/ <code>Xenova/trocr-small-handwritten</code>.",er,xs,tr,Cs,Nu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',lr,gs,vu='<li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',sr,ir,nr,Is,ar,ks,pr,Gs,_u="Create a new ImageToTextPipeline.",or,Zs,Yu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",dr,cr,Mr,Qs,rr,Bs,Tr,As,Ru="Assign labels to the image(s) passed as inputs.",mr,Ns,$u='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToTextPipeline"><code>ImageToTextPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',yr,vs,Pu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The images to be captioned.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",Jr,hr,ur,_s,wr,Ys,jr,Rs,Vu=`Image classification pipeline using any <code>AutoModelForImageClassification</code>.
This pipeline predicts the class of an image.`,Ur,$s,Eu="<strong>Example:</strong> Classify an image.",fr,Ps,br,Vs,zu="<strong>Example:</strong> Classify an image and return top <code>n</code> classes.",xr,Es,Cr,zs,Hu="<strong>Example:</strong> Classify an image and return all classes.",gr,Hs,Ir,Ws,Wu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',kr,Ss,Su='<li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Gr,Zr,Qr,Xs,Br,Ls,Ar,Ds,Xu="Create a new ImageClassificationPipeline.",Nr,Fs,Lu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",vr,_r,Yr,qs,Rr,Os,$r,Ks,Du="Classify the given images.",Pr,ei,Fu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageClassificationPipeline"><code>ImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The top classification results for the images.',Vr,ti,qu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td></td><td><p>The images to classify.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for classification.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top results to return.</p></td></tr></tbody>",Er,zr,Hr,li,Wr,si,Sr,ii,Ou=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>.
This pipeline predicts masks of objects and their classes.`,Xr,ni,Ku="<strong>Example:</strong> Perform image segmentation with <code>Xenova/detr-resnet-50-panoptic</code>.",Lr,ai,Dr,pi,ew='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Fr,oi,tw='<li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li>',qr,Or,Kr,di,eT,ci,tT,Mi,lw="Create a new ImageSegmentationPipeline.",lT,ri,sw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",sT,iT,nT,Ti,aT,mi,pT,yi,iw="Segment the input images.",oT,Ji,nw='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageSegmentationPipeline"><code>ImageSegmentationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Array&gt;</code> - The annotated segments.',dT,hi,aw="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for segmentation.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Probability threshold to filter out predicted masks.</p></td> </tr><tr><td>[options.mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[options.overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>Mask overlap threshold to eliminate small, disconnected segments.</p></td> </tr><tr><td>[options.subtask]</td><td><code>null</code> | <code>string</code></td><td><code></code></td><td><p>Segmentation task to be performed. One of [<code>panoptic</code>, <code>instance</code>, and <code>semantic</code>], depending on model capabilities. If not set, the pipeline will attempt to resolve (in that order).</p></td> </tr><tr><td>[options.label_ids_to_fuse]</td><td><code>Array</code></td><td><code></code></td><td><p>List of label ids to fuse. If not set, do not fuse any labels.</p></td> </tr><tr><td>[options.target_sizes]</td><td><code>Array</code></td><td><code></code></td><td><p>List of target sizes for the input images. If not set, use the original image sizes.</p></td></tr></tbody>",cT,MT,rT,ui,TT,wi,mT,ji,pw=`Zero shot image classification pipeline. This pipeline predicts the class of
an image when you provide an image and a set of <code>candidate_labels</code>.`,yT,Ui,ow="<strong>Example:</strong> Zero shot image classification w/ <code>Xenova/clip-vit-base-patch32</code>.",JT,fi,hT,bi,dw='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',uT,xi,cw='<li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',wT,jT,UT,Ci,fT,gi,bT,Ii,Mw="Create a new ZeroShotImageClassificationPipeline.",xT,ki,rw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",CT,gT,IT,Gi,kT,Zi,GT,Qi,Tw="Classify the input images with candidate labels using a zero-shot approach.",ZT,Bi,mw='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotImageClassificationPipeline"><code>ZeroShotImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',QT,Ai,yw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><p>The hypothesis template to use for zero-shot classification. Default: &quot;This is a photo of &amp;#123;}&quot;.</p></td></tr></tbody>",BT,AT,NT,Ni,vT,vi,_T,_i,Jw=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>.
This pipeline predicts bounding boxes of objects and their classes.`,YT,Yi,hw="<strong>Example:</strong> Run object-detection with <code>facebook/detr-resnet-50</code>.",RT,Ri,$T,$i,uw='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',PT,Pi,ww='<li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li>',VT,ET,zT,Vi,HT,Ei,WT,zi,jw="Create a new ObjectDetectionPipeline.",ST,Hi,Uw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",XT,LT,DT,Wi,FT,Si,qT,Xi,fw="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",OT,Li,bw='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ObjectDetectionPipeline"><code>ObjectDetectionPipeline</code></a>',KT,Di,xw="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the object detection.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.9</code></td><td><p>The threshold used to filter boxes by score.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>",em,tm,lm,Fi,sm,qi,im,Oi,Cw=`Zero-shot object detection pipeline. This pipeline predicts bounding boxes of
objects when you provide an image and a set of <code>candidate_labels</code>.`,nm,Ki,gw="<strong>Example:</strong> Zero-shot object detection w/ <code>Xenova/clip-vit-base-patch32</code>.",am,en,pm,tn,Iw="<strong>Example:</strong> Zero-shot object detection w/ <code>Xenova/clip-vit-base-patch32</code> (returning top 4 matches and setting a threshold).",om,ln,dm,sn,kw='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',cm,nn,Gw='<li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline">.ZeroShotObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotObjectDetectionPipeline_new"><code>new ZeroShotObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Mm,rm,Tm,an,mm,pn,ym,on,Zw="Create a new ZeroShotObjectDetectionPipeline.",Jm,dn,Qw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",hm,um,wm,cn,jm,Mn,Um,rn,Bw="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",fm,Tn,Aw='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotObjectDetectionPipeline"><code>ZeroShotObjectDetectionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',bm,mn,Nw=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td><p>What the model should recognize in the image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td></td><td><p>The probability necessary to make a prediction.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td></td><td><p>The number of top predictions that will be returned by the pipeline.
If the provided number is <code>null</code> or higher than the number of predictions available, it will default
to the number of predictions.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>`,xm,Cm,gm,yn,Im,Jn,km,hn,vw=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>.
The inputs/outputs are similar to the (extractive) question answering pipeline; however,
the pipeline takes an image (and optional OCR’d words/boxes) as input instead of text context.`,Gm,un,_w="<strong>Example:</strong> Answer questions about a document with <code>Xenova/donut-base-finetuned-docvqa</code>.",Zm,wn,Qm,jn,Yw='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Bm,Un,Rw='<li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Am,Nm,vm,fn,_m,bn,Ym,xn,$w="Create a new DocumentQuestionAnsweringPipeline.",Rm,Cn,Pw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",$m,Pm,Vm,gn,Em,In,zm,kn,Vw="Answer the question given as input by using the document.",Hm,Gn,Ew='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DocumentQuestionAnsweringPipeline"><code>DocumentQuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',Wm,Zn,zw="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>any</code></td><td></td><td><p>The image of the document to use.</p></td> </tr><tr><td>question</td><td><code>string</code></td><td></td><td><p>A question to ask of the document.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",Sm,Xm,Lm,Qn,Dm,Bn,Fm,An,Hw=`Text-to-audio generation pipeline using any <code>AutoModelForTextToWaveform</code> or <code>AutoModelForTextToSpectrogram</code>.
This pipeline generates an audio file from an input text and optional other conditional inputs.`,qm,Nn,Ww="<strong>Example:</strong> Generate audio from text with <code>Xenova/speecht5_tts</code>.",Om,vn,Km,_n,Sw="You can then save the audio to a .wav file with the <code>wavefile</code> package:",ey,Yn,ty,Rn,Xw='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ly,$n,Lw='<li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',sy,iy,ny,Pn,ay,Vn,py,En,Dw="Create a new TextToAudioPipeline.",oy,zn,Fw="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><p>The vocoder to use.</p></td></tr></tbody>",dy,cy,My,Hn,ry,Wn,Ty,Sn,qw="Generates speech/audio from the inputs.",my,Xn,Ow='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextToAudioPipeline"><code>TextToAudioPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - An object containing the generated audio and sampling rate.',yy,Ln,Kw="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>text_inputs</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text(s) to generate.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Parameters passed to the model generation/forward method.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><code></code></td><td><p>The vocoder to use (if the model uses one). If not provided, use the default HifiGan vocoder.</p></td> </tr><tr><td>[options.speaker_embeddings]</td><td><code>Tensor</code> | <code>Float32Array</code> | <code>string</code> | <code>URL</code></td><td><code></code></td><td></td></tr></tbody>",Jy,hy,uy,Dn,wy,Fn,jy,qn,ej="Image to Image pipeline using any <code>AutoModelForImageToImage</code>. This pipeline generates an image based on a previous image input.",Uy,On,tj="<strong>Example:</strong> Super-resolution w/ <code>Xenova/swin2SR-classical-sr-x2-64</code>",fy,Kn,by,ea,lj='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',xy,Cy,gy,ta,Iy,la,ky,sa,sj="Transform the image(s) passed as inputs.",Gy,ia,ij='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToImagePipeline"><code>ImageToImagePipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An image or a list of images containing result(s).',Zy,na,nj="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td><p>The images to transform.</p></td></tr></tbody>",Qy,By,Ay,aa,Ny,pa,vy,oa,aj="Depth estimation pipeline using any <code>AutoModelForDepthEstimation</code>. This pipeline predicts the depth of an image.",_y,da,pj="<strong>Example:</strong> Depth estimation w/ <code>Xenova/dpt-hybrid-midas</code>",Yy,ca,Ry,Ma,oj='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',$y,Py,Vy,ra,Ey,Ta,zy,ma,dj="Predicts the depth for the image(s) passed as inputs.",Hy,ya,cj='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DepthEstimationPipeline"><code>DepthEstimationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An image or a list of images containing result(s).',Wy,Ja,Mj="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td><p>The images to compute depth for.</p></td></tr></tbody>",Sy,Xy,Ly,ha,Dy,ua,Fy,wa,rj="Utility factory method to build a [<code>Pipeline</code>] object.",qy,ja,Tj='<strong>Kind</strong>: static method of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Pipeline&gt;</code> - A Pipeline object for the specified task.<br/> <strong>Throws</strong>:',Oy,Ua,mj="<li><code>Error</code> If an unsupported pipeline is requested.</li>",Ky,fa,yj="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td></td><td><p>The task defining which pipeline will be returned. Currently accepted tasks are:</p> <ul><li><code>&quot;audio-classification&quot;</code>: will return a <code>AudioClassificationPipeline</code>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <code>AutomaticSpeechRecognitionPipeline</code>.</li> <li><code>&quot;depth-estimation&quot;</code>: will return a <code>DepthEstimationPipeline</code>.</li> <li><code>&quot;document-question-answering&quot;</code>: will return a <code>DocumentQuestionAnsweringPipeline</code>.</li> <li><code>&quot;feature-extraction&quot;</code>: will return a <code>FeatureExtractionPipeline</code>.</li> <li><code>&quot;fill-mask&quot;</code>: will return a <code>FillMaskPipeline</code>.</li> <li><code>&quot;image-classification&quot;</code>: will return a <code>ImageClassificationPipeline</code>.</li> <li><code>&quot;image-segmentation&quot;</code>: will return a <code>ImageSegmentationPipeline</code>.</li> <li><code>&quot;image-to-text&quot;</code>: will return a <code>ImageToTextPipeline</code>.</li> <li><code>&quot;object-detection&quot;</code>: will return a <code>ObjectDetectionPipeline</code>.</li> <li><code>&quot;question-answering&quot;</code>: will return a <code>QuestionAnsweringPipeline</code>.</li> <li><code>&quot;summarization&quot;</code>: will return a <code>SummarizationPipeline</code>.</li> <li><code>&quot;text2text-generation&quot;</code>: will return a <code>Text2TextGenerationPipeline</code>.</li> <li><code>&quot;text-classification&quot;</code> (alias &quot;sentiment-analysis&quot; available): will return a <code>TextClassificationPipeline</code>.</li> <li><code>&quot;text-generation&quot;</code>: will return a <code>TextGenerationPipeline</code>.</li> <li><code>&quot;token-classification&quot;</code> (alias &quot;ner&quot; available): will return a <code>TokenClassificationPipeline</code>.</li> <li><code>&quot;translation&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;zero-shot-classification&quot;</code>: will return a <code>ZeroShotClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-audio-classification&quot;</code>: will return a <code>ZeroShotAudioClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <code>ZeroShotImageClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-object-detection&quot;</code>: will return a <code>ZeroShotObjectDetectionPipeline</code>.</li></ul></td> </tr><tr><td>[model]</td><td><code>string</code></td><td><code>null</code></td><td><p>The name of the pre-trained model to use. If not specified, the default model for the task will be used.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td></td><td><p>Optional parameters for the pipeline.</p></td></tr></tbody>",eJ,tJ,lJ,ba,sJ,xa,iJ,Ca,Jj='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',nJ,ga,hj="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>answer</td><td><code>string</code></td><td><p>The answer.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score.</p></td></tr></tbody>",aJ,pJ,oJ,Ia,dJ,ka,cJ,Ga,uj='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',MJ,rJ,TJ,Za,mJ,Qa,yJ,Ba,wj='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',JJ,Aa,jj="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>chunk</td><td><code>Chunk</code></td><td><p>The chunk to process.</p></td></tr></tbody>",hJ,uJ,wJ,va,jJ;return U=new h({props:{title:"pipelines",local:"pipelines",headingTag:"h1"}}),x=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4MTc2ODYlN0QlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),I=new h({props:{title:"pipelines.Pipeline ⇐ <code> Callable </code>",local:"pipelinespipeline--code-callable-code",headingTag:"h2"}}),B=new h({props:{title:"new Pipeline(options)",local:"new-pipelineoptions",headingTag:"h3"}}),_=new h({props:{title:"pipeline.dispose() ⇒ <code> Promise. < void > </code>",local:"pipelinedispose--code-promise--void--code",headingTag:"h3"}}),P=new h({props:{title:"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>",local:"pipelinecalltexts-args--code-promise--any--code",headingTag:"h3"}}),W=new h({props:{title:"pipelines.TextClassificationPipeline",local:"pipelinestextclassificationpipeline",headingTag:"h2"}}),L=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBsYWJlbCUzQSUyMCdQT1NJVElWRSclMkMlMjBzY29yZSUzQSUyMDAuOTk5Nzg4NzYxMTM4OTE2JTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{ label: &#x27;POSITIVE&#x27;, score: 0.999788761138916 }]</span>`,wrap:!1}}),F=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdMZSUyMG1laWxsZXVyJTIwZmlsbSUyMGRlJTIwdG91cyUyMGxlcyUyMHRlbXBzLiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwNSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjk2MTA3NTk2MTU4OTgxMzIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc0JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAzMzIzMzUxNTkxODI1NDg1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMyUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDM2MTU1MTgxMDA1NTk3MTE1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMSUyMHN0YXInJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTEzMjU5Njc0OTgxMjM2NDYlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCcyJTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDk0MjM5NzEwNTk3MzIxMzklMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Le meilleur film de tous les temps.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;5 stars&#x27;, score: 0.9610759615898132 },</span>
<span class="hljs-comment">//   { label: &#x27;4 stars&#x27;, score: 0.03323351591825485 },</span>
<span class="hljs-comment">//   { label: &#x27;3 stars&#x27;, score: 0.0036155181005597115 },</span>
<span class="hljs-comment">//   { label: &#x27;1 star&#x27;, score: 0.0011325967498123646 },</span>
<span class="hljs-comment">//   { label: &#x27;2 stars&#x27;, score: 0.0009423971059732139 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),O=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnRveGljLWJlcnQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGhhdGUlMjB5b3UhJyUyQyUyMCU3QiUyMHRvcGslM0ElMjBudWxsJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC45NTkzMTQwNDgyOTAyNTI3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaW5zdWx0JyUyQyUyMHNjb3JlJTNBJTIwMC4xNjE4NzMzNDA2MDY2ODk0NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ29ic2NlbmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzNDUyNjgwNjMyNDcyMDM4JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaWRlbnRpdHlfaGF0ZSclMkMlMjBzY29yZSUzQSUyMDAuMDIyMzI1MDU3NTM2MzYzNiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RocmVhdCclMkMlMjBzY29yZSUzQSUyMDAuMDE5MTk3MDQxMTY4ODA4OTM3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnc2V2ZXJlX3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDU2NTEwOTk2MDczNDg0NDIlMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/toxic-bert&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I hate you!&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-literal">null</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;toxic&#x27;, score: 0.9593140482902527 },</span>
<span class="hljs-comment">//   { label: &#x27;insult&#x27;, score: 0.16187334060668945 },</span>
<span class="hljs-comment">//   { label: &#x27;obscene&#x27;, score: 0.03452680632472038 },</span>
<span class="hljs-comment">//   { label: &#x27;identity_hate&#x27;, score: 0.0223250575363636 },</span>
<span class="hljs-comment">//   { label: &#x27;threat&#x27;, score: 0.019197041168808937 },</span>
<span class="hljs-comment">//   { label: &#x27;severe_toxic&#x27;, score: 0.005651099607348442 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),te=new h({props:{title:"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),ae=new h({props:{title:"pipelines.TokenClassificationPipeline",local:"pipelinestokenclassificationpipeline",headingTag:"h2"}}),de=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ015JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwTG9uZG9uJyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1QRVInJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODAyMDI5MTMyODQzMDIlMkMlMjBpbmRleCUzQSUyMDQlMkMlMjB3b3JkJTNBJTIwJ1NhcmFoJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NDQ3NDA1MzM4Mjg3NCUyQyUyMGluZGV4JTNBJTIwOSUyQyUyMHdvcmQlM0ElMjAnTG9uZG9uJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;My name is Sarah and I live in London&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9980202913284302, index: 4, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9994474053382874, index: 9, word: &#x27;London&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Me=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ1NhcmFoJTIwbGl2ZXMlMjBpbiUyMHRoZSUyMFVuaXRlZCUyMFN0YXRlcyUyMG9mJTIwQW1lcmljYSclMkMlMjAlN0IlMjBpZ25vcmVfbGFiZWxzJTNBJTIwJTVCJTVEJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLVBFUiclMkMlMjBzY29yZSUzQSUyMDAuOTk2NjU4NzQyNDI3ODI1OSUyQyUyMGluZGV4JTNBJTIwMSUyQyUyMHdvcmQlM0ElMjAnU2FyYWgnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ08nJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODczODU4NjkwMjYxODQlMkMlMjBpbmRleCUzQSUyMDIlMkMlMjB3b3JkJTNBJTIwJ2xpdmVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdPJyUyQyUyMHNjb3JlJTNBJTIwMC45OTkwMDcyODQ2NDEyNjU5JTJDJTIwaW5kZXglM0ElMjAzJTJDJTIwd29yZCUzQSUyMCdpbiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnTyclMkMlMjBzY29yZSUzQSUyMDAuOTk4ODI5ODQxNjEzNzY5NSUyQyUyMGluZGV4JTNBJTIwNCUyQyUyMHdvcmQlM0ElMjAndGhlJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NTUxMDU3ODE1NTUxOCUyQyUyMGluZGV4JTNBJTIwNSUyQyUyMHdvcmQlM0ElMjAnVW5pdGVkJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5MDM5NTMwNzU0MDg5NCUyQyUyMGluZGV4JTNBJTIwNiUyQyUyMHdvcmQlM0ElMjAnU3RhdGVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk4NjcyNDg1MzUxNTYyNSUyQyUyMGluZGV4JTNBJTIwNyUyQyUyMHdvcmQlM0ElMjAnb2YnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ0ktTE9DJyUyQyUyMHNjb3JlJTNBJTIwMC45OTc1Mjk0NDcwNzg3MDQ4JTJDJTIwaW5kZXglM0ElMjA4JTJDJTIwd29yZCUzQSUyMCdBbWVyaWNhJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Sarah lives in the United States of America&#x27;</span>, { <span class="hljs-attr">ignore_labels</span>: [] });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9966587424278259, index: 1, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9987385869026184, index: 2, word: &#x27;lives&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9990072846412659, index: 3, word: &#x27;in&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9988298416137695, index: 4, word: &#x27;the&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9995510578155518, index: 5, word: &#x27;United&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9990395307540894, index: 6, word: &#x27;States&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9986724853515625, index: 7, word: &#x27;of&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9975294470787048, index: 8, word: &#x27;America&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),me=new h({props:{title:"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),we=new h({props:{title:"pipelines.QuestionAnsweringPipeline",local:"pipelinesquestionansweringpipeline",headingTag:"h2"}}),fe=new u({props:{code:"bGV0JTIwcXVlc3Rpb24lMjAlM0QlMjAnV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJyUzQiUwQWxldCUyMGNvbnRleHQlMjAlM0QlMjAnSmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQuJyUzQiUwQSUwQWxldCUyMGFuc3dlcmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgncXVlc3Rpb24tYW5zd2VyaW5nJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwYW5zd2VyZXIocXVlc3Rpb24lMkMlMjBjb250ZXh0KSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMmElMjBuaWNlJTIwcHVwcGV0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjAwLjU3Njg5MTE1MDI1MjY3NDElMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;Who was Jim Henson?&#x27;</span>;
<span class="hljs-keyword">let</span> context = <span class="hljs-string">&#x27;Jim Henson was a nice puppet.&#x27;</span>;

<span class="hljs-keyword">let</span> answerer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-distilled-squad&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">answerer</span>(question, context);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;answer&quot;: &quot;a nice puppet&quot;,</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.5768911502526741</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ce=new h({props:{title:"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>",local:"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code",headingTag:"h3"}}),Ze=new h({props:{title:"pipelines.FillMaskPipeline",local:"pipelinesfillmaskpipeline",headingTag:"h2"}}),Ae=new u({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4nKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdzdXJ2aXZhbCclMkMlMjBzY29yZSUzQSUyMDAuMDYxMzc0MTk0OTIwMDYzMDIlMkMlMjB0b2tlbiUzQSUyMDgxMTUlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBzdXJ2aXZhbC4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2xvdmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzOTAyNDUwMjAzODk1NTY5JTJDJTIwdG9rZW4lM0ElMjAxNTY3JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwbG92ZS4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2hhcHBpbmVzcyclMkMlMjBzY29yZSUzQSUyMDAuMDMyNTMxODM1MTM4Nzk3NzYlMkMlMjB0b2tlbiUzQSUyMDkyNjYlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBoYXBwaW5lc3MuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdmcmVlZG9tJyUyQyUyMHNjb3JlJTNBJTIwMC4wMTg3MzYzMDY1Nzc5MjA5MTQlMkMlMjB0b2tlbiUzQSUyMDQ0MzglMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBmcmVlZG9tLiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnbGlmZSclMkMlMjBzY29yZSUzQSUyMDAuMDE4NTk3OTQ3NDMzNTkwODklMkMlMjB0b2tlbiUzQSUyMDEyOTclMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBsaWZlLiclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The goal of life is [MASK].&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { token_str: &#x27;survival&#x27;, score: 0.06137419492006302, token: 8115, sequence: &#x27;The goal of life is survival.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;love&#x27;, score: 0.03902450203895569, token: 1567, sequence: &#x27;The goal of life is love.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;happiness&#x27;, score: 0.03253183513879776, token: 9266, sequence: &#x27;The goal of life is happiness.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;freedom&#x27;, score: 0.018736306577920914, token: 4438, sequence: &#x27;The goal of life is freedom.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;life&#x27;, score: 0.01859794743359089, token: 1297, sequence: &#x27;The goal of life is life.&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ve=new u({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwTWlsa3klMjBXYXklMjBpcyUyMGElMjAlNUJNQVNLJTVEJTIwZ2FsYXh5LiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwMSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0b2tlbl9zdHIlM0ElMjAnc3BpcmFsJyUyQyUyMHNjb3JlJTNBJTIwMC42Mjk5OTg3NDM1MzQwODgxJTJDJTIwdG9rZW4lM0ElMjAxNDA2MSUyQyUyMHNlcXVlbmNlJTNBJTIwJ1RoZSUyME1pbGt5JTIwV2F5JTIwaXMlMjBhJTIwc3BpcmFsJTIwZ2FsYXh5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The Milky Way is a [MASK] galaxy.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">1</span> });
<span class="hljs-comment">// [{ token_str: &#x27;spiral&#x27;, score: 0.6299987435340881, token: 14061, sequence: &#x27;The Milky Way is a spiral galaxy.&#x27; }]</span>`,wrap:!1}}),Re=new h({props:{title:"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),ze=new h({props:{title:"pipelines.Text2TextGenerationPipeline",local:"pipelinestext2textgenerationpipeline",headingTag:"h2"}}),Se=new u({props:{code:"bGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dDJ0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRkxhTWluaS1GbGFuLVQ1LTc4M00nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKCdob3clMjBjYW4lMjBJJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklM0YnJTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMDAlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJUbyUyMGJlY29tZSUyMG1vcmUlMjBoZWFsdGh5JTJDJTIweW91JTIwY2FuJTNBJTIwMS4lMjBFYXQlMjBhJTIwYmFsYW5jZWQlMjBkaWV0JTIwd2l0aCUyMHBsZW50eSUyMG9mJTIwZnJ1aXRzJTJDJTIwdmVnZXRhYmxlcyUyQyUyMHdob2xlJTIwZ3JhaW5zJTJDJTIwbGVhbiUyMHByb3RlaW5zJTJDJTIwYW5kJTIwaGVhbHRoeSUyMGZhdHMuJTIwMi4lMjBTdGF5JTIwaHlkcmF0ZWQlMjBieSUyMGRyaW5raW5nJTIwcGxlbnR5JTIwb2YlMjB3YXRlci4lMjAzLiUyMEdldCUyMGVub3VnaCUyMHNsZWVwJTIwYW5kJTIwbWFuYWdlJTIwc3RyZXNzJTIwbGV2ZWxzLiUyMDQuJTIwQXZvaWQlMjBzbW9raW5nJTIwYW5kJTIwZXhjZXNzaXZlJTIwYWxjb2hvbCUyMGNvbnN1bXB0aW9uLiUyMDUuJTIwUmVndWxhcmx5JTIwZXhlcmNpc2UlMjBhbmQlMjBtYWludGFpbiUyMGElMjBoZWFsdGh5JTIwd2VpZ2h0LiUyMDYuJTIwUHJhY3RpY2UlMjBnb29kJTIwaHlnaWVuZSUyMGFuZCUyMHNhbml0YXRpb24uJTIwNy4lMjBTZWVrJTIwbWVkaWNhbCUyMGF0dGVudGlvbiUyMGlmJTIweW91JTIwZXhwZXJpZW5jZSUyMGFueSUyMGhlYWx0aCUyMGlzc3Vlcy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(<span class="hljs-string">&#x27;how can I become more healthy?&#x27;</span>, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ generated_text: &quot;To become more healthy, you can: 1. Eat a balanced diet with plenty of fruits, vegetables, whole grains, lean proteins, and healthy fats. 2. Stay hydrated by drinking plenty of water. 3. Get enough sleep and manage stress levels. 4. Avoid smoking and excessive alcohol consumption. 5. Regularly exercise and maintain a healthy weight. 6. Practice good hygiene and sanitation. 7. Seek medical attention if you experience any health issues.&quot; }]</span>`,wrap:!1}}),De=new h({props:{title:"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>",local:"text2textgenerationpipelinecalltexts-options--code-promise--any--code",headingTag:"h3"}}),tt=new h({props:{title:"pipelines.SummarizationPipeline",local:"pipelinessummarizationpipeline",headingTag:"h2"}}),it=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, &#x27;</span> +
  <span class="hljs-string">&#x27;and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. &#x27;</span> +
  <span class="hljs-string">&#x27;During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest &#x27;</span> +
  <span class="hljs-string">&#x27;man-made structure in the world, a title it held for 41 years until the Chrysler Building in New &#x27;</span> +
  <span class="hljs-string">&#x27;York City was finished in 1930. It was the first structure to reach a height of 300 metres. Due to &#x27;</span> +
  <span class="hljs-string">&#x27;the addition of a broadcasting aerial at the top of the tower in 1957, it is now taller than the &#x27;</span> +
  <span class="hljs-string">&#x27;Chrysler Building by 5.2 metres (17 ft). Excluding transmitters, the Eiffel Tower is the second &#x27;</span> +
  <span class="hljs-string">&#x27;tallest free-standing structure in France after the Millau Viaduct.&#x27;</span>;

<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;summarization&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbart-cnn-6-6&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ summary_text: &#x27; The Eiffel Tower is about the same height as an 81-storey building and the tallest structure in Paris. It is the second tallest free-standing structure in France after the Millau Viaduct.&#x27; }]</span>`,wrap:!1}}),pt=new h({props:{title:"pipelines.TranslationPipeline",local:"pipelinestranslationpipeline",headingTag:"h2"}}),Mt=new u({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTAlQTQlOUMlRTAlQTUlODAlRTAlQTQlQjUlRTAlQTQlQTglMjAlRTAlQTQlOEYlRTAlQTQlOTUlMjAlRTAlQTQlOUElRTAlQTUlODklRTAlQTQlOTUlRTAlQTQlQjIlRTAlQTUlODclRTAlQTQlOUYlMjAlRTAlQTQlQUMlRTAlQTUlODklRTAlQTQlOTUlRTAlQTUlOEQlRTAlQTQlQjglMjAlRTAlQTQlOTUlRTAlQTUlODAlMjAlRTAlQTQlQTQlRTAlQTQlQjAlRTAlQTQlQjklMjAlRTAlQTQlQjklRTAlQTUlODglRTAlQTUlQTQnJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnaGluX0RldmEnJTJDJTIwJTJGJTJGJTIwSGluZGklMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdmcmFfTGF0biclMkMlMjAlMkYlMkYlMjBGcmVuY2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMYSUyMHZpZSUyMGVzdCUyMGNvbW1lJTIwdW5lJTIwYm8lQzMlQUV0ZSUyMCVDMyVBMCUyMGNob2NvbGF0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;जीवन एक चॉकलेट बॉक्स की तरह है।&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hin_Deva&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fra_Latn&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;La vie est comme une boîte à chocolat.&#x27; }]</span>`,wrap:!1}}),mt=new u({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtMm0xMDBfNDE4TScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTclOTQlOUYlRTYlQjQlQkIlRTUlQjAlQjElRTUlODMlOEYlRTQlQjglODAlRTclOUIlOTIlRTUlQjclQTclRTUlODUlOEIlRTUlOEElOUIlRTMlODAlODInJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnemgnJTJDJTIwJTJGJTJGJTIwQ2hpbmVzZSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuJyUyQyUyMCUyRiUyRiUyMEVuZ2xpc2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMaWZlJTIwaXMlMjBsaWtlJTIwYSUyMGJveCUyMG9mJTIwY2hvY29sYXRlLiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/m2m100_418M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;生活就像一盒巧克力。&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;zh&#x27;</span>, <span class="hljs-comment">// Chinese</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-comment">// English</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Life is like a box of chocolate.&#x27; }]</span>`,wrap:!1}}),ht=new u({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zbGF0b3IoJyVFMCVBNCVCOCVFMCVBNCU4MiVFMCVBNCVBRiVFMCVBNSU4MSVFMCVBNCU5NSVFMCVBNSU4RCVFMCVBNCVBNCUyMCVFMCVBNCVCMCVFMCVBNCVCRSVFMCVBNCVCNyVFMCVBNSU4RCVFMCVBNCU5RiVFMCVBNSU4RCVFMCVBNCVCMCUyMCVFMCVBNCU5NSVFMCVBNSU4NyUyMCVFMCVBNCVBQSVFMCVBNSU4RCVFMCVBNCVCMCVFMCVBNCVBRSVFMCVBNSU4MSVFMCVBNCU5NiUyMCVFMCVBNCU5NSVFMCVBNCVCRSUyMCVFMCVBNCU5NSVFMCVBNCVCOSVFMCVBNCVBOCVFMCVBNCVCRSUyMCVFMCVBNCVCOSVFMCVBNSU4OCUyMCVFMCVBNCU5NSVFMCVBNCVCRiUyMCVFMCVBNCVCOCVFMCVBNSU4MCVFMCVBNCVCMCVFMCVBNCVCRiVFMCVBNCVBRiVFMCVBNCVCRSUyMCVFMCVBNCVBRSVFMCVBNSU4NyVFMCVBNCU4MiUyMCVFMCVBNCU5NSVFMCVBNSU4QiVFMCVBNCU4OCUyMCVFMCVBNCVCOCVFMCVBNSU4OCVFMCVBNCVBOCVFMCVBNSU4RCVFMCVBNCVBRiUyMCVFMCVBNCVCOCVFMCVBNCVBRSVFMCVBNCVCRSVFMCVBNCVBNyVFMCVBNCVCRSVFMCVBNCVBOCUyMCVFMCVBNCVBOCVFMCVBNCVCOSVFMCVBNSU4MCVFMCVBNCU4MiUyMCVFMCVBNCVCOSVFMCVBNSU4OCclMkMlMjAlN0IlMEElMjAlMjBzcmNfbGFuZyUzQSUyMCdoaV9JTiclMkMlMjAlMkYlMkYlMjBIaW5kaSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2ZyX1hYJyUyQyUyMCUyRiUyRiUyMEZyZW5jaCUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0xlJTIwY2hlZiUyMGRlcyUyME5hdGlvbnMlMjBhZmZpcm1lJTIwcXUlMjAnaWwlMjBuJTIwJ3klMjBhJTIwbWlsaXRhcnklMjBzb2x1dGlvbiUyMGluJTIwU3lyaWEuJyUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mbart-large-50-many-to-many-mmt&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;संयुक्त राष्ट्र के प्रमुख का कहना है कि सीरिया में कोई सैन्य समाधान नहीं है&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hi_IN&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fr_XX&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Le chef des Nations affirme qu &#x27;il n &#x27;y a military solution in Syria.&#x27; }]</span>`,wrap:!1}}),jt=new h({props:{title:"pipelines.TextGenerationPipeline",local:"pipelinestextgenerationpipeline",headingTag:"h2"}}),bt=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyclM0IlMEFsZXQlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRmRpc3RpbGdwdDInKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKHRleHQpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyUyMGFuZCUyMEklMjBsb3ZlJTIwdG8lMjBwbGF5JTIwd2l0aCUyMHRoZSUyMG90aGVyJTIwZG9ncy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I enjoy walking with my cute dog,&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text);
<span class="hljs-comment">// [{ generated_text: &quot;I enjoy walking with my cute dog, and I love to play with the other dogs.&quot; }]</span>`,wrap:!1}}),Ct=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxncHQyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGdlbmVyYXRvcih0ZXh0JTJDJTIwJTdCJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAyJTJDJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMCUyQyUwQSUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzQSUyMDEuNSUyQyUwQSUyMCUyMG5vX3JlcGVhdF9uZ3JhbV9zaXplJTNBJTIwMiUyQyUwQSUyMCUyMG51bV9iZWFtcyUzQSUyMDIlMkMlMEElMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzQSUyMDIlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIyZ2VuZXJhdGVkX3RleHQlMjIlM0ElMjAlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMlMjBhbiUyMGFidW5kYW5jZSUyMG9mJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMHRoZSUyMGhpc3RvcnklMjBhbmQlMjBhY3Rpdml0aWVzJTIwdGhhdCUyMiUwQSUyRiUyRiUyMCU3RCUyQyUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIwJTIyT25jZSUyMHVwb24lMjBhJTIwdGltZSUyQyUyMHRoZXJlJTIwd2FzJTIwYW4lMjBhYnVuZGFuY2UlMjBvZiUyMGluZm9ybWF0aW9uJTIwYWJvdXQlMjB0aGUlMjBtb3N0JTIwaW1wb3J0YW50JTIwYW5kJTIwaW5mbHVlbnRpYWwlMjIlMEElMkYlMkYlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Once upon a time, there was&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">10</span>,
  <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">1.5</span>,
  <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_beams</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_return_sequences</span>: <span class="hljs-number">2</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the history and activities that&quot;</span>
<span class="hljs-comment">// }, {</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the most important and influential&quot;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),It=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdkZWYlMjBmaWIobiklM0EnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZjb2RlZ2VuLTM1ME0tbW9ubycpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBnZW5lcmF0b3IodGV4dCUyQyUyMCU3QiUwQSUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwNDQlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnZGVmJTIwZmliKG4pJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwaWYlMjBuJTIwJTNEJTNEJTIwMCUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMDAlNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBlbGlmJTIwbiUyMCUzRCUzRCUyMDElM0ElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAxJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwZWxzZSUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZpYihuLTEpJTIwJTJCJTIwZmliKG4tMiklNUNuJyUwQSUyRiUyRiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;def fib(n):&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/codegen-350M-mono&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">44</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   generated_text: &#x27;def fib(n):\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    if n == 0:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 0\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    elif n == 1:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 1\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    else:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return fib(n-1) + fib(n-2)\\n&#x27;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),Zt=new h({props:{title:"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>",local:"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code",headingTag:"h3"}}),vt=new h({props:{title:"pipelines.ZeroShotClassificationPipeline",local:"pipelineszeroshotclassificationpipeline",headingTag:"h2"}}),Rt=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdMYXN0JTIwd2VlayUyMEklMjB1cGdyYWRlZCUyMG15JTIwaU9TJTIwdmVyc2lvbiUyMGFuZCUyMGV2ZXIlMjBzaW5jZSUyMHRoZW4lMjBteSUyMHBob25lJTIwaGFzJTIwYmVlbiUyMG92ZXJoZWF0aW5nJTIwd2hlbmV2ZXIlMjBJJTIwdXNlJTIweW91ciUyMGFwcC4nJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ21vYmlsZSclMkMlMjAnYmlsbGluZyclMkMlMjAnd2Vic2l0ZSclMkMlMjAnYWNjb3VudCUyMGFjY2VzcyclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZtb2JpbGViZXJ0LXVuY2FzZWQtbW5saScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjBsYWJlbHMpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwc2VxdWVuY2UlM0ElMjAnTGFzdCUyMHdlZWslMjBJJTIwdXBncmFkZWQlMjBteSUyMGlPUyUyMHZlcnNpb24lMjBhbmQlMjBldmVyJTIwc2luY2UlMjB0aGVuJTIwbXklMjBwaG9uZSUyMGhhcyUyMGJlZW4lMjBvdmVyaGVhdGluZyUyMHdoZW5ldmVyJTIwSSUyMHVzZSUyMHlvdXIlMjBhcHAuJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVscyUzQSUyMCU1QiUyMCdtb2JpbGUnJTJDJTIwJ3dlYnNpdGUnJTJDJTIwJ2JpbGxpbmcnJTJDJTIwJ2FjY291bnQlMjBhY2Nlc3MnJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2NvcmVzJTNBJTIwJTVCJTIwMC41NTYyMDkxMDQwNDgyMDE4JTJDJTIwMC4xODQzNjIxMzA3ODYwODUzJTJDJTIwMC4xMzk0MjY0NjYzOTMzNjM3NiUyQyUyMDAuMTIwMDAyMjk4NzcyMzQ5MjMlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;mobile&#x27;</span>, <span class="hljs-string">&#x27;billing&#x27;</span>, <span class="hljs-string">&#x27;website&#x27;</span>, <span class="hljs-string">&#x27;account access&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mobilebert-uncased-mnli&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;mobile&#x27;, &#x27;website&#x27;, &#x27;billing&#x27;, &#x27;account access&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.5562091040482018, 0.1843621307860853, 0.13942646639336376, 0.12000229877234923 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Pt=new u({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEnJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ3VyZ2VudCclMkMlMjAnbm90JTIwdXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAndGFibGV0JyUyQyUyMCdjb21wdXRlciclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZubGktZGViZXJ0YS12My14c21hbGwnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwJTdCJTIwbXVsdGlfbGFiZWwlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHNlcXVlbmNlJTNBJTIwJ0klMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISclMkMlMEElMkYlMkYlMjAlMjAlMjBsYWJlbHMlM0ElMjAlNUIlMjAndXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAnY29tcHV0ZXInJTJDJTIwJ3RhYmxldCclMkMlMjAnbm90JTIwdXJnZW50JyUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHNjb3JlcyUzQSUyMCU1QiUyMDAuOTk1ODg3MDk1NjM2MDI3NSUyQyUyMDAuOTkyMzk2MzQwMDY5NzAzNSUyQyUyMDAuMDAyMzMzNTM3OTQ2MTYwMjM1JTJDJTIwMC4wMDE1MTM0MTM4NTY3NTk4NzY1JTJDJTIwMC4wMDEwNjk5Mzg0MjA4Mzc3MTYzJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nli-deberta-v3-xsmall&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels, { <span class="hljs-attr">multi_label</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;urgent&#x27;, &#x27;phone&#x27;, &#x27;computer&#x27;, &#x27;tablet&#x27;, &#x27;not urgent&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.9958870956360275, 0.9923963400697035, 0.002333537946160235, 0.0015134138567598765, 0.0010699384208377163 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ht=new h({props:{title:"new ZeroShotClassificationPipeline(options)",local:"new-zeroshotclassificationpipelineoptions",headingTag:"h3"}}),Lt=new h({props:{title:"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code",headingTag:"h3"}}),Ot=new h({props:{title:"pipelines.FeatureExtractionPipeline",local:"pipelinesfeatureextractionpipeline",headingTag:"h2"}}),tl=new u({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDU5Mzk5MjQ3MTY5NDk0NjMlMkMlMjAwLjAyMTY1NTkzNTc5NDExNTA2NyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwOCUyQyUyMDc2OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.05939924716949463, 0.021655935794115067, ...],</span>
<span class="hljs-comment">//   dims: [1, 8, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),sl=new u({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wMzM3Mzc3ODk4Mzk1MDYxNSUyQyUyMC0wLjAxMDEwNjA3NzQxNzczMTI4NSUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwNzY4JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.03373778983950615, -0.010106077417731285, ...],</span>
<span class="hljs-comment">//   dims: [1, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),nl=new u({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wOTA5NDk4MjU5NDI1MTYzMyUyQyUyMC0wLjAxNDc3NDI0NjE0MTMxNDUwNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwMzg0JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.09094982594251633, -0.014774246141314507, ...],</span>
<span class="hljs-comment">//   dims: [1, 384]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ol=new h({props:{title:"featureExtractionPipeline._call(texts, options) ⇒",local:"featureextractionpipelinecalltexts-options-",headingTag:"h3"}}),Tl=new h({props:{title:"pipelines.AudioClassificationPipeline",local:"pipelinesaudioclassificationpipeline",headingTag:"h2"}}),Jl=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdWRpby1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGd2F2MnZlYzItbGFyZ2UteGxzci01My1nZW5kZXItcmVjb2duaXRpb24tbGlicmlzcGVlY2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuOTk4MTU0MjIyOTY1MjQwNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2ZlbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuMDAxODQ1NzQ3ODE0NTEzNzQzJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;male&#x27;, score: 0.9981542229652405 },</span>
<span class="hljs-comment">//   { label: &#x27;female&#x27;, score: 0.001845747814513743 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ul=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRfbWVvdy53YXYnJTNCJTBBbGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1ZGlvLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZhc3QtZmluZXR1bmVkLWF1ZGlvc2V0LTEwLTEwLTAuNDU5MycpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjA0JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ01lb3cnJTJDJTIwc2NvcmUlM0ElMjAwLjU2MTc4NzQyNjQ3MTcxMDIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCdDYXQnJTJDJTIwc2NvcmUlM0ElMjAwLjIyMzY1Mzc2MzUzMjYzODU1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnRG9tZXN0aWMlMjBhbmltYWxzJTJDJTIwcGV0cyclMkMlMjBzY29yZSUzQSUyMDAuMTE0MTA2OTA4NDQwNTg5OSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ0FuaW1hbCclMkMlMjBzY29yZSUzQSUyMDAuMDg5ODU2OTIyNjI2NDk1MzYlMjAlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cat_meow.wav&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/ast-finetuned-audioset-10-10-0.4593&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">4</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;Meow&#x27;, score: 0.5617874264717102 },</span>
<span class="hljs-comment">//   { label: &#x27;Cat&#x27;, score: 0.22365376353263855 },</span>
<span class="hljs-comment">//   { label: &#x27;Domestic animals, pets&#x27;, score: 0.1141069084405899 },</span>
<span class="hljs-comment">//   { label: &#x27;Animal&#x27;, score: 0.08985692262649536 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),fl=new h({props:{title:"new AudioClassificationPipeline(options)",local:"new-audioclassificationpipelineoptions",headingTag:"h3"}}),gl=new h({props:{title:"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code",headingTag:"h3"}}),Ql=new h({props:{title:"pipelines.ZeroShotAudioClassificationPipeline",local:"pipelineszeroshotaudioclassificationpipeline",headingTag:"h2"}}),Nl=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3plcm8tc2hvdC1hdWRpby1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xhcC1odHNhdC11bmZ1c2VkJyklM0IlMEFsZXQlMjBhdWRpbyUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGZG9nX2Jhcmtpbmcud2F2JyUzQiUwQWxldCUyMGNhbmRpZGF0ZV9sYWJlbHMlMjAlM0QlMjAlNUInZG9nJyUyQyUyMCd2YWNjdW0lMjBjbGVhbmVyJyU1RCUzQiUwQWxldCUyMHNjb3JlcyUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcihhdWRpbyUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjk5OTM5OTI0NDc4NTMwODglMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDYwMDc2MDMzNjk2NTMyMjUlMkMlMjBsYWJlbCUzQSUyMCd2YWNjdW0lMjBjbGVhbmVyJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clap-htsat-unfused&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/dog_barking.wav&#x27;</span>;
<span class="hljs-keyword">let</span> candidate_labels = [<span class="hljs-string">&#x27;dog&#x27;</span>, <span class="hljs-string">&#x27;vaccum cleaner&#x27;</span>];
<span class="hljs-keyword">let</span> scores = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(audio, candidate_labels);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993992447853088, label: &#x27;dog&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0006007603369653225, label: &#x27;vaccum cleaner&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Rl=new h({props:{title:"new ZeroShotAudioClassificationPipeline(options)",local:"new-zeroshotaudioclassificationpipelineoptions",headingTag:"h3"}}),El=new h({props:{title:"zeroShotAudioClassificationPipeline._call(audios, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotaudioclassificationpipelinecallaudios-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),Xl=new h({props:{title:"pipelines.AutomaticSpeechRecognitionPipeline",local:"pipelinesautomaticspeechrecognitionpipeline",headingTag:"h2"}}),Fl=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-comment">// { text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot; }</span>`,wrap:!1}}),Ol=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTBBJTJGJTJGJTIwJTIwJTIwY2h1bmtzJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCMCUyQyUyMDglNUQlMkMlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTIyJTIwJTdEJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCOCUyQyUyMDExJTVEJTJDJTIwdGV4dCUzQSUyMCUyMiUyMGFzayUyMHdoYXQlMjB5b3UlMjBjYW4lMjBkbyUyMGZvciUyMHlvdXIlMjBjb3VudHJ5LiUyMiUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot;</span>
<span class="hljs-comment">//   chunks: [</span>
<span class="hljs-comment">//     { timestamp: [0, 8],  text: &quot; And so my fellow Americans ask not what your country can do for you&quot; }</span>
<span class="hljs-comment">//     { timestamp: [8, 11], text: &quot; ask what you can do for your country.&quot; }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),es=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwJ3dvcmQnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UlMjBhc2slMjB3aGF0JTIweW91JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3VyJTIwY291bnRyeS4lMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJjaHVua3MlMjIlM0ElMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwQW5kJTIyJTJDJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwJTVCMCUyQyUyMDAuNzglNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwc28lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIwLjc4JTJDJTIwMS4wNiU1RCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBteSUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjEuMDYlMkMlMjAxLjQ2JTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMGZvciUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjkuNzIlMkMlMjA5LjkyJTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMHlvdXIlMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUI5LjkyJTJDJTIwMTAuMjIlNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwY291bnRyeS4lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIxMC4yMiUyQyUyMDEzLjUlNUQlMjAlN0QlMEElMkYlMkYlMjAlMjAlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-string">&#x27;word&#x27;</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;text&quot;: &quot; And so my fellow Americans ask not what your country can do for you ask what you can do for your country.&quot;,</span>
<span class="hljs-comment">//   &quot;chunks&quot;: [</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; And&quot;, &quot;timestamp&quot;: [0, 0.78] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; so&quot;, &quot;timestamp&quot;: [0.78, 1.06] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; my&quot;, &quot;timestamp&quot;: [1.06, 1.46] },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; for&quot;, &quot;timestamp&quot;: [9.72, 9.92] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; your&quot;, &quot;timestamp&quot;: [9.92, 10.22] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; country.&quot;, &quot;timestamp&quot;: [10.22, 13.5] }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ls=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2NyaWJlJyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwSidhZG9yZSUyQyUyMGonYWltZSUyQyUyMGplJTIwbidhaW1lJTIwcGFzJTJDJTIwamUlMjBkJUMzJUE5dGVzdGUuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;transcribe&#x27;</span> });
<span class="hljs-comment">// { text: &quot; J&#x27;adore, j&#x27;aime, je n&#x27;aime pas, je déteste.&quot; }</span>`,wrap:!1}}),is=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2xhdGUnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBJJTIwbG92ZSUyQyUyMEklMjBsaWtlJTJDJTIwSSUyMGRvbid0JTIwbGlrZSUyQyUyMEklMjBoYXRlLiUyMiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;translate&#x27;</span> });
<span class="hljs-comment">// { text: &quot; I love, I like, I don&#x27;t like, I hate.&quot; }</span>`,wrap:!1}}),as=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0ZWRfNjAud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMGNodW5rX2xlbmd0aF9zJTNBJTIwMzAlMkMlMjBzdHJpZGVfbGVuZ3RoX3MlM0ElMjA1JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBTbyUyMGluJTIwY29sbGVnZSUyQyUyMEklMjB3YXMlMjBhJTIwZ292ZXJubWVudCUyMG1ham9yJTJDJTIwd2hpY2glMjBtZWFucyUyMCU1Qi4uLiU1RCUyMFNvJTIwSSdkJTIwc3RhcnQlMjBvZmYlMjBsaWdodCUyMGFuZCUyMEknZCUyMGJ1bXAlMjBpdCUyMHVwJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/ted_60.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">chunk_length_s</span>: <span class="hljs-number">30</span>, <span class="hljs-attr">stride_length_s</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// { text: &quot; So in college, I was a government major, which means [...] So I&#x27;d start off light and I&#x27;d bump it up&quot; }</span>`,wrap:!1}}),cs=new h({props:{title:"new AutomaticSpeechRecognitionPipeline(options)",local:"new-automaticspeechrecognitionpipelineoptions",headingTag:"h3"}}),ms=new h({props:{title:"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>",local:"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code",headingTag:"h3"}}),ws=new h({props:{title:"pipelines.ImageToTextPipeline",local:"pipelinesimagetotextpipeline",headingTag:"h2"}}),fs=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNhcHRpb25lcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnYSUyMGNhdCUyMGxheWluZyUyMG9uJTIwYSUyMGNvdWNoJTIwd2l0aCUyMGFub3RoZXIlMjBjYXQnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-gpt2-image-captioning&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;a cat laying on a couch with another cat&#x27; }]</span>`,wrap:!1}}),xs=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZoYW5kd3JpdGluZy5qcGcnJTNCJTBBbGV0JTIwY2FwdGlvbmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtdG8tdGV4dCclMkMlMjAnWGVub3ZhJTJGdHJvY3Itc21hbGwtaGFuZHdyaXR0ZW4nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2FwdGlvbmVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCdNci4lMjBCcm93biUyMGNvbW1lbnRlZCUyMGljaWx5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/handwriting.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/trocr-small-handwritten&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;Mr. Brown commented icily.&#x27; }]</span>`,wrap:!1}}),ks=new h({props:{title:"new ImageToTextPipeline(options)",local:"new-imagetotextpipelineoptions",headingTag:"h3"}}),Bs=new h({props:{title:"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Ys=new h({props:{title:"pipelines.ImageClassificationPipeline",local:"pipelinesimageclassificationpipeline",headingTag:"h2"}}),Ps=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0JsYWJlbCUzQSUyMCd0aWdlciUyQyUyMFBhbnRoZXJhJTIwdGlncmlzJyUyQyUyMHNjb3JlJTNBJTIwMC42MzI2OTU3MzQ1MDA4ODUlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Es=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAzJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">3</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Hs=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAwJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ2phZ3VhciUyQyUyMHBhbnRoZXIlMkMlMjBQYW50aGVyYSUyMG9uY2ElMkMlMjBGZWxpcyUyMG9uY2EnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDM1NDY1NDk5OTY4MjY3OTc3JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">0</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">//   {label: &#x27;tiger cat&#x27;, score: 0.3634825646877289},</span>
<span class="hljs-comment">//   {label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707},</span>
<span class="hljs-comment">//   {label: &#x27;jaguar, panther, Panthera onca, Felis onca&#x27;, score: 0.00035465499968267977},</span>
<span class="hljs-comment">//   ...</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ls=new h({props:{title:"new ImageClassificationPipeline(options)",local:"new-imageclassificationpipelineoptions",headingTag:"h3"}}),Os=new h({props:{title:"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>",local:"imageclassificationpipelinecallimages-options--code-promise--any--code",headingTag:"h3"}}),si=new h({props:{title:"pipelines.ImageSegmentationPipeline",local:"pipelinesimagesegmentationpipeline",headingTag:"h2"}}),ai=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBzZWdtZW50ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS1zZWdtZW50YXRpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHNlZ21lbnRlcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAncmVtb3RlJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg0NjQ5NDE5Nzg0NTQ2JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC45OTk0MzE2MTAxMDc0MjE5JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> segmenter = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-segmentation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50-panoptic&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">segmenter</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;remote&#x27;, score: 0.9984649419784546, mask: RawImage { ... } },</span>
<span class="hljs-comment">//   { label: &#x27;cat&#x27;, score: 0.9994316101074219, mask: RawImage { ... } }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ci=new h({props:{title:"new ImageSegmentationPipeline(options)",local:"new-imagesegmentationpipelineoptions",headingTag:"h3"}}),mi=new h({props:{title:"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>",local:"imagesegmentationpipelinecallimages-options--code-promise--array--code",headingTag:"h3"}}),wi=new h({props:{title:"pipelines.ZeroShotImageClassificationPipeline",local:"pipelineszeroshotimageclassificationpipeline",headingTag:"h2"}}),fi=new u({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3plcm8tc2hvdC1pbWFnZS1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJyklM0IlMEFsZXQlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyclM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodXJsJTJDJTIwJTVCJ3RpZ2VyJyUyQyUyMCdob3JzZSclMkMlMjAnZG9nJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5MzkxNzk0MjA0NzExOSUyQyUyMGxhYmVsJTNBJTIwJ3RpZ2VyJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHNjb3JlJTNBJTIwMC4wMDAzNTE5Mjk0ODQxNjgwNjc2JTJDJTIwbGFiZWwlM0ElMjAnaG9yc2UnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDI1NjI2OTg3OTE3MzQ4NzQlMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, [<span class="hljs-string">&#x27;tiger&#x27;</span>, <span class="hljs-string">&#x27;horse&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993917942047119, label: &#x27;tiger&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0003519294841680676, label: &#x27;horse&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0002562698791734874, label: &#x27;dog&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),gi=new h({props:{title:"new ZeroShotImageClassificationPipeline(options)",local:"new-zeroshotimageclassificationpipelineoptions",headingTag:"h3"}}),Zi=new h({props:{title:"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),vi=new h({props:{title:"pipelines.ObjectDetectionPipeline",local:"pipelinesobjectdetectionpipeline",headingTag:"h2"}}),Ri=new u({props:{code:"bGV0JTIwaW1nJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEElMEFsZXQlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ29iamVjdC1kZXRlY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZyUyQyUyMCU3QiUyMHRocmVzaG9sZCUzQSUyMDAuOSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk3NjM3MDkzMDY3MTY5MiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIycmVtb3RlJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMxJTJDJTIwJTIyeW1pbiUyMiUzQSUyMDY4JTJDJTIwJTIyeG1heCUyMiUzQSUyMDE5MCUyQyUyMCUyMnltYXglMjIlM0ElMjAxMTglMjAlN0QlMEElMkYlMkYlMjAlN0QlMkMlMEElMkYlMkYlMjAuLi4lMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk4NDA5MjExNjM1NTg5NiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2F0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMzMSUyQyUyMCUyMnltaW4lMjIlM0ElMjAxOSUyQyUyMCUyMnhtYXglMjIlM0ElMjA2NDklMkMlMjAlMjJ5bWF4JTIyJTNBJTIwMzcxJTIwJTdEJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> img = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;

<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img, { <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.9</span> });
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9976370930671692,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;remote&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 31, &quot;ymin&quot;: 68, &quot;xmax&quot;: 190, &quot;ymax&quot;: 118 }</span>
<span class="hljs-comment">// },</span>
<span class="hljs-comment">// ...</span>
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9984092116355896,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;cat&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 331, &quot;ymin&quot;: 19, &quot;xmax&quot;: 649, &quot;ymax&quot;: 371 }</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),Ei=new h({props:{title:"new ObjectDetectionPipeline(options)",local:"new-objectdetectionpipelineoptions",headingTag:"h3"}}),Si=new h({props:{title:"objectDetectionPipeline._call(images, options)",local:"objectdetectionpipelinecallimages-options",headingTag:"h3"}}),qi=new h({props:{title:"pipelines.ZeroShotObjectDetectionPipeline",local:"pipelineszeroshotobjectdetectionpipeline",headingTag:"h2"}}),en=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/astronaut.png&#x27;</span>;
<span class="hljs-keyword">let</span> candidate_labels = [<span class="hljs-string">&#x27;human face&#x27;</span>, <span class="hljs-string">&#x27;rocket&#x27;</span>, <span class="hljs-string">&#x27;helmet&#x27;</span>, <span class="hljs-string">&#x27;american flag&#x27;</span>];
<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/owlvit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(url, candidate_labels);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.24392342567443848,</span>
<span class="hljs-comment">//     label: &#x27;human face&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 180, ymin: 67, xmax: 274, ymax: 175 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.15129457414150238,</span>
<span class="hljs-comment">//     label: &#x27;american flag&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 0, ymin: 4, xmax: 106, ymax: 513 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.13649864494800568,</span>
<span class="hljs-comment">//     label: &#x27;helmet&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 277, ymin: 337, xmax: 511, ymax: 511 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.10262022167444229,</span>
<span class="hljs-comment">//     label: &#x27;rocket&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 352, ymin: -1, xmax: 463, ymax: 287 }</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ln=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/beach.png&#x27;</span>;
<span class="hljs-keyword">let</span> candidate_labels = [<span class="hljs-string">&#x27;hat&#x27;</span>, <span class="hljs-string">&#x27;book&#x27;</span>, <span class="hljs-string">&#x27;sunglasses&#x27;</span>, <span class="hljs-string">&#x27;camera&#x27;</span>];
<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/owlvit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(url, candidate_labels, { <span class="hljs-attr">topk</span>: <span class="hljs-number">4</span>, <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.05</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.1606510728597641,</span>
<span class="hljs-comment">//     label: &#x27;sunglasses&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 347, ymin: 229, xmax: 429, ymax: 264 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08935828506946564,</span>
<span class="hljs-comment">//     label: &#x27;hat&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 38, ymin: 174, xmax: 258, ymax: 364 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08530698716640472,</span>
<span class="hljs-comment">//     label: &#x27;camera&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 187, ymin: 350, xmax: 260, ymax: 411 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08349756896495819,</span>
<span class="hljs-comment">//     label: &#x27;book&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 261, ymin: 280, xmax: 494, ymax: 425 }</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),pn=new h({props:{title:"new ZeroShotObjectDetectionPipeline(options)",local:"new-zeroshotobjectdetectionpipelineoptions",headingTag:"h3"}}),Mn=new h({props:{title:"zeroShotObjectDetectionPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotobjectdetectionpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),Jn=new h({props:{title:"pipelines.DocumentQuestionAnsweringPipeline",local:"pipelinesdocumentquestionansweringpipeline",headingTag:"h2"}}),wn=new u({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmludm9pY2UucG5nJyUzQiUwQWxldCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1doYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YnJTNCJTBBJTBBbGV0JTIwcWFfcGlwZWxpbmUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmcnJTJDJTIwJ1hlbm92YSUyRmRvbnV0LWJhc2UtZmluZXR1bmVkLWRvY3ZxYScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBxYV9waXBlbGluZShpbWFnZSUyQyUyMHF1ZXN0aW9uKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMGFuc3dlciUzQSUyMCd1cy0wMDEnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/invoice.png&#x27;</span>;
<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;What is the invoice number?&#x27;</span>;

<span class="hljs-keyword">let</span> qa_pipeline = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;document-question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/donut-base-finetuned-docvqa&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">qa_pipeline</span>(image, question);
<span class="hljs-comment">// [{ answer: &#x27;us-001&#x27; }]</span>`,wrap:!1}}),bn=new h({props:{title:"new DocumentQuestionAnsweringPipeline(options)",local:"new-documentquestionansweringpipelineoptions",headingTag:"h3"}}),In=new h({props:{title:"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Bn=new h({props:{title:"pipelines.TextToAudioPipeline",local:"pipelinestexttoaudiopipeline",headingTag:"h2"}}),vn=new u({props:{code:"bGV0JTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZzcGVha2VyX2VtYmVkZGluZ3MuYmluJyUzQiUwQWxldCUyMHN5bnRoZXNpemVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC10by1zcGVlY2gnJTJDJTIwJ1hlbm92YSUyRnNwZWVjaHQ1X3R0cyclMkMlMjAlN0IlMjBxdWFudGl6ZWQlM0ElMjBmYWxzZSUyMCU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMHN5bnRoZXNpemVyKCdIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJyUyQyUyMCU3QiUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBhdWRpbyUzQSUyMEZsb2F0MzJBcnJheSgyNjExMiklMjAlNUItMC4wMDAwNTY1NzMzNzg5Njk5MTUyMSUyQyUyMDAuMDAwMjA1ODM4NzQ3MjA2MTQ0MDMlMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNBJTIwMTYwMDAlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> speaker_embeddings = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/speaker_embeddings.bin&#x27;</span>;
<span class="hljs-keyword">let</span> synthesizer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-to-speech&#x27;</span>, <span class="hljs-string">&#x27;Xenova/speecht5_tts&#x27;</span>, { <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span> });
<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">synthesizer</span>(<span class="hljs-string">&#x27;Hello, my dog is cute&#x27;</span>, { speaker_embeddings });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   audio: Float32Array(26112) [-0.00005657337896991521, 0.00020583874720614403, ...],</span>
<span class="hljs-comment">//   sampling_rate: 16000</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Yn=new u({props:{code:"aW1wb3J0JTIwd2F2ZWZpbGUlMjBmcm9tJTIwJ3dhdmVmaWxlJyUzQiUwQWltcG9ydCUyMGZzJTIwZnJvbSUyMCdmcyclM0IlMEElMEFsZXQlMjB3YXYlMjAlM0QlMjBuZXclMjB3YXZlZmlsZS5XYXZlRmlsZSgpJTNCJTBBd2F2LmZyb21TY3JhdGNoKDElMkMlMjBvdXQuc2FtcGxpbmdfcmF0ZSUyQyUyMCczMmYnJTJDJTIwb3V0LmF1ZGlvKSUzQiUwQWZzLndyaXRlRmlsZVN5bmMoJ291dC53YXYnJTJDJTIwd2F2LnRvQnVmZmVyKCkpJTNC",highlighted:`<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;
<span class="hljs-keyword">import</span> fs <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;fs&#x27;</span>;

<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>();
wav.<span class="hljs-title function_">fromScratch</span>(<span class="hljs-number">1</span>, out.<span class="hljs-property">sampling_rate</span>, <span class="hljs-string">&#x27;32f&#x27;</span>, out.<span class="hljs-property">audio</span>);
fs.<span class="hljs-title function_">writeFileSync</span>(<span class="hljs-string">&#x27;out.wav&#x27;</span>, wav.<span class="hljs-title function_">toBuffer</span>());`,wrap:!1}}),Vn=new h({props:{title:"new TextToAudioPipeline(options)",local:"new-texttoaudiopipelineoptions",headingTag:"h3"}}),Wn=new h({props:{title:"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>",local:"texttoaudiopipelinecalltextinputs-options--code-promise--object--code",headingTag:"h3"}}),Fn=new h({props:{title:"pipelines.ImageToImagePipeline",local:"pipelinesimagetoimagepipeline",headingTag:"h2"}}),Kn=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZidXR0ZXJmbHkuanBnJyUzQiUwQWxldCUyMHVwc2NhbGVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtdG8taW1hZ2UnJTJDJTIwJ1hlbm92YSUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHVwc2NhbGVyKHVybCklM0IlMEElMkYlMkYlMjBSYXdJbWFnZSUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMGRhdGElM0ElMjBVaW50OEFycmF5KDc4NjQzMiklMjAlNUIlMjA0MSUyQyUyMDMxJTJDJTIwMjQlMkMlMjAlMjA0MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHdpZHRoJTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwY2hhbm5lbHMlM0ElMjAzJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/butterfly.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> upscaler = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-image&#x27;</span>, <span class="hljs-string">&#x27;Xenova/swin2SR-classical-sr-x2-64&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">upscaler</span>(url);
<span class="hljs-comment">// RawImage {</span>
<span class="hljs-comment">//   data: Uint8Array(786432) [ 41, 31, 24,  43, ... ],</span>
<span class="hljs-comment">//   width: 512,</span>
<span class="hljs-comment">//   height: 512,</span>
<span class="hljs-comment">//   channels: 3</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),la=new h({props:{title:"imageToImagePipeline._call(images) ⇒ <code> Promise. < any > </code>",local:"imagetoimagepipelinecallimages--code-promise--any--code",headingTag:"h3"}}),pa=new h({props:{title:"pipelines.DepthEstimationPipeline",local:"pipelinesdepthestimationpipeline",headingTag:"h2"}}),ca=new u({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBkZXB0aF9lc3RpbWF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkZXB0aC1lc3RpbWF0aW9uJyUyQyUyMCdYZW5vdmElMkZkcHQtaHlicmlkLW1pZGFzJyklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMGRlcHRoX2VzdGltYXRvcih1cmwpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTNBJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwZGltcyUzQSUyMCU1QiUyMDM4NCUyQyUyMDM4NCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDE0NzQ1NiklMjAlNUIlMjA1NDIuODU5MTMwODU5Mzc1JTJDJTIwNTQ1LjI4MzM4NjIzMDQ2ODglMkMlMjA1NDYuMTY0OTE2OTkyMTg3NSUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHNpemUlM0ElMjAxNDc0NTYlMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjBkZXB0aCUzQSUyMFJhd0ltYWdlJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwZGF0YSUzQSUyMFVpbnQ4QXJyYXkoMzA3MjAwKSUyMCU1QiUyMDg2JTJDJTIwODYlMkMlMjA4NiUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHdpZHRoJTNBJTIwNjQwJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNDgwJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwY2hhbm5lbHMlM0ElMjAxJTBBJTJGJTJGJTIwJTIwJTIwJTdEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> depth_estimator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;depth-estimation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/dpt-hybrid-midas&#x27;</span>);
<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">depth_estimator</span>(url);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   predicted_depth: Tensor {</span>
<span class="hljs-comment">//     dims: [ 384, 384 ],</span>
<span class="hljs-comment">//     type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//     data: Float32Array(147456) [ 542.859130859375, 545.2833862304688, 546.1649169921875, ... ],</span>
<span class="hljs-comment">//     size: 147456</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   depth: RawImage {</span>
<span class="hljs-comment">//     data: Uint8Array(307200) [ 86, 86, 86, ... ],</span>
<span class="hljs-comment">//     width: 640,</span>
<span class="hljs-comment">//     height: 480,</span>
<span class="hljs-comment">//     channels: 1</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ta=new h({props:{title:"depthEstimationPipeline._call(images) ⇒ <code> Promise. < any > </code>",local:"depthestimationpipelinecallimages--code-promise--any--code",headingTag:"h3"}}),ua=new h({props:{title:"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>",local:"pipelinespipelinetask-model-options--code-promise--pipeline--code",headingTag:"h2"}}),xa=new h({props:{title:"pipelines~QuestionAnsweringResult : <code> object </code>",local:"pipelinesquestionansweringresult--code-object-code",headingTag:"h2"}}),ka=new h({props:{title:"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>",local:"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code",headingTag:"h2"}}),Qa=new h({props:{title:"pipelines~ChunkCallback : <code> function </code>",local:"pipelineschunkcallback--code-function-code",headingTag:"h2"}}),{c(){w=a("meta"),_a=i(),Na=a("p"),Ya=i(),j=a("a"),Ra=i(),c(U.$$.fragment),$a=i(),f=a("p"),f.textContent=fJ,Pa=i(),b=a("p"),b.innerHTML=bJ,Va=i(),c(x.$$.fragment),Ea=i(),C=a("ul"),C.innerHTML=xJ,za=i(),Ha=a("hr"),Wa=i(),g=a("a"),Sa=i(),c(I.$$.fragment),Xa=i(),k=a("p"),k.textContent=CJ,La=i(),G=a("p"),G.innerHTML=gJ,Da=i(),Z=a("ul"),Z.innerHTML=IJ,Fa=i(),qa=a("hr"),Oa=i(),Q=a("a"),Ka=i(),c(B.$$.fragment),ep=i(),A=a("p"),A.textContent=kJ,tp=i(),N=a("table"),N.innerHTML=GJ,lp=i(),sp=a("hr"),ip=i(),v=a("a"),np=i(),c(_.$$.fragment),ap=i(),Y=a("p"),Y.textContent=ZJ,pp=i(),R=a("p"),R.innerHTML=QJ,op=i(),dp=a("hr"),cp=i(),$=a("a"),Mp=i(),c(P.$$.fragment),rp=i(),V=a("p"),V.textContent=BJ,Tp=i(),E=a("p"),E.innerHTML=AJ,mp=i(),z=a("table"),z.innerHTML=NJ,yp=i(),Jp=a("hr"),hp=i(),H=a("a"),up=i(),c(W.$$.fragment),wp=i(),S=a("p"),S.innerHTML=vJ,jp=i(),X=a("p"),X.innerHTML=_J,Up=i(),c(L.$$.fragment),fp=i(),D=a("p"),D.innerHTML=YJ,bp=i(),c(F.$$.fragment),xp=i(),q=a("p"),q.innerHTML=RJ,Cp=i(),c(O.$$.fragment),gp=i(),K=a("p"),K.innerHTML=$J,Ip=i(),kp=a("hr"),Gp=i(),ee=a("a"),Zp=i(),c(te.$$.fragment),Qp=i(),le=a("p"),le.textContent=PJ,Bp=i(),se=a("p"),se.innerHTML=VJ,Ap=i(),ie=a("table"),ie.innerHTML=EJ,Np=i(),vp=a("hr"),_p=i(),ne=a("a"),Yp=i(),c(ae.$$.fragment),Rp=i(),pe=a("p"),pe.innerHTML=zJ,$p=i(),oe=a("p"),oe.innerHTML=HJ,Pp=i(),c(de.$$.fragment),Vp=i(),ce=a("p"),ce.innerHTML=WJ,Ep=i(),c(Me.$$.fragment),zp=i(),re=a("p"),re.innerHTML=SJ,Hp=i(),Wp=a("hr"),Sp=i(),Te=a("a"),Xp=i(),c(me.$$.fragment),Lp=i(),ye=a("p"),ye.textContent=XJ,Dp=i(),Je=a("p"),Je.innerHTML=LJ,Fp=i(),he=a("table"),he.innerHTML=DJ,qp=i(),Op=a("hr"),Kp=i(),ue=a("a"),eo=i(),c(we.$$.fragment),to=i(),je=a("p"),je.innerHTML=FJ,lo=i(),Ue=a("p"),Ue.innerHTML=qJ,so=i(),c(fe.$$.fragment),io=i(),be=a("p"),be.innerHTML=OJ,no=i(),ao=a("hr"),po=i(),xe=a("a"),oo=i(),c(Ce.$$.fragment),co=i(),ge=a("p"),ge.textContent=KJ,Mo=i(),Ie=a("p"),Ie.innerHTML=eh,ro=i(),ke=a("table"),ke.innerHTML=th,To=i(),mo=a("hr"),yo=i(),Ge=a("a"),Jo=i(),c(Ze.$$.fragment),ho=i(),Qe=a("p"),Qe.innerHTML=lh,uo=i(),Be=a("p"),Be.innerHTML=sh,wo=i(),c(Ae.$$.fragment),jo=i(),Ne=a("p"),Ne.innerHTML=ih,Uo=i(),c(ve.$$.fragment),fo=i(),_e=a("p"),_e.innerHTML=nh,bo=i(),xo=a("hr"),Co=i(),Ye=a("a"),go=i(),c(Re.$$.fragment),Io=i(),$e=a("p"),$e.textContent=ah,ko=i(),Pe=a("p"),Pe.innerHTML=ph,Go=i(),Ve=a("table"),Ve.innerHTML=oh,Zo=i(),Qo=a("hr"),Bo=i(),Ee=a("a"),Ao=i(),c(ze.$$.fragment),No=i(),He=a("p"),He.textContent=dh,vo=i(),We=a("p"),We.innerHTML=ch,_o=i(),c(Se.$$.fragment),Yo=i(),Xe=a("p"),Xe.innerHTML=Mh,Ro=i(),$o=a("hr"),Po=i(),Le=a("a"),Vo=i(),c(De.$$.fragment),Eo=i(),Fe=a("p"),Fe.textContent=rh,zo=i(),qe=a("p"),qe.innerHTML=Th,Ho=i(),Oe=a("ul"),Oe.innerHTML=mh,Wo=i(),Ke=a("table"),Ke.innerHTML=yh,So=i(),Xo=a("hr"),Lo=i(),et=a("a"),Do=i(),c(tt.$$.fragment),Fo=i(),lt=a("p"),lt.textContent=Jh,qo=i(),st=a("p"),st.innerHTML=hh,Oo=i(),c(it.$$.fragment),Ko=i(),nt=a("p"),nt.innerHTML=uh,ed=i(),td=a("hr"),ld=i(),at=a("a"),sd=i(),c(pt.$$.fragment),id=i(),ot=a("p"),ot.textContent=wh,nd=i(),dt=a("p"),dt.innerHTML=jh,ad=i(),ct=a("p"),ct.innerHTML=Uh,pd=i(),c(Mt.$$.fragment),od=i(),rt=a("p"),rt.innerHTML=fh,dd=i(),Tt=a("p"),Tt.innerHTML=bh,cd=i(),c(mt.$$.fragment),Md=i(),yt=a("p"),yt.innerHTML=xh,rd=i(),Jt=a("p"),Jt.innerHTML=Ch,Td=i(),c(ht.$$.fragment),md=i(),ut=a("p"),ut.innerHTML=gh,yd=i(),Jd=a("hr"),hd=i(),wt=a("a"),ud=i(),c(jt.$$.fragment),wd=i(),Ut=a("p"),Ut.innerHTML=Ih,jd=i(),ft=a("p"),ft.innerHTML=kh,Ud=i(),c(bt.$$.fragment),fd=i(),xt=a("p"),xt.innerHTML=Gh,bd=i(),c(Ct.$$.fragment),xd=i(),gt=a("p"),gt.innerHTML=Zh,Cd=i(),c(It.$$.fragment),gd=i(),kt=a("p"),kt.innerHTML=Qh,Id=i(),kd=a("hr"),Gd=i(),Gt=a("a"),Zd=i(),c(Zt.$$.fragment),Qd=i(),Qt=a("p"),Qt.textContent=Bh,Bd=i(),Bt=a("p"),Bt.innerHTML=Ah,Ad=i(),At=a("table"),At.innerHTML=Nh,Nd=i(),vd=a("hr"),_d=i(),Nt=a("a"),Yd=i(),c(vt.$$.fragment),Rd=i(),_t=a("p"),_t.innerHTML=vh,$d=i(),Yt=a("p"),Yt.innerHTML=_h,Pd=i(),c(Rt.$$.fragment),Vd=i(),$t=a("p"),$t.innerHTML=Yh,Ed=i(),c(Pt.$$.fragment),zd=i(),Vt=a("p"),Vt.innerHTML=Rh,Hd=i(),Et=a("ul"),Et.innerHTML=$h,Wd=i(),Sd=a("hr"),Xd=i(),zt=a("a"),Ld=i(),c(Ht.$$.fragment),Dd=i(),Wt=a("p"),Wt.textContent=Ph,Fd=i(),St=a("table"),St.innerHTML=Vh,qd=i(),Od=a("hr"),Kd=i(),Xt=a("a"),ec=i(),c(Lt.$$.fragment),tc=i(),Dt=a("p"),Dt.innerHTML=Eh,lc=i(),Ft=a("table"),Ft.innerHTML=zh,sc=i(),ic=a("hr"),nc=i(),qt=a("a"),ac=i(),c(Ot.$$.fragment),pc=i(),Kt=a("p"),Kt.textContent=Hh,oc=i(),el=a("p"),el.innerHTML=Wh,dc=i(),c(tl.$$.fragment),cc=i(),ll=a("p"),ll.innerHTML=Sh,Mc=i(),c(sl.$$.fragment),rc=i(),il=a("p"),il.innerHTML=Xh,Tc=i(),c(nl.$$.fragment),mc=i(),al=a("p"),al.innerHTML=Lh,yc=i(),Jc=a("hr"),hc=i(),pl=a("a"),uc=i(),c(ol.$$.fragment),wc=i(),dl=a("p"),dl.textContent=Dh,jc=i(),cl=a("p"),cl.innerHTML=Fh,Uc=i(),Ml=a("table"),Ml.innerHTML=qh,fc=i(),bc=a("hr"),xc=i(),rl=a("a"),Cc=i(),c(Tl.$$.fragment),gc=i(),ml=a("p"),ml.innerHTML=Oh,Ic=i(),yl=a("p"),yl.innerHTML=Kh,kc=i(),c(Jl.$$.fragment),Gc=i(),hl=a("p"),hl.innerHTML=eu,Zc=i(),c(ul.$$.fragment),Qc=i(),wl=a("p"),wl.innerHTML=tu,Bc=i(),jl=a("ul"),jl.innerHTML=lu,Ac=i(),Nc=a("hr"),vc=i(),Ul=a("a"),_c=i(),c(fl.$$.fragment),Yc=i(),bl=a("p"),bl.textContent=su,Rc=i(),xl=a("table"),xl.innerHTML=iu,$c=i(),Pc=a("hr"),Vc=i(),Cl=a("a"),Ec=i(),c(gl.$$.fragment),zc=i(),Il=a("p"),Il.textContent=nu,Hc=i(),kl=a("p"),kl.innerHTML=au,Wc=i(),Gl=a("table"),Gl.innerHTML=pu,Sc=i(),Xc=a("hr"),Lc=i(),Zl=a("a"),Dc=i(),c(Ql.$$.fragment),Fc=i(),Bl=a("p"),Bl.innerHTML=ou,qc=i(),Al=a("p"),Al.innerHTML=du,Oc=i(),c(Nl.$$.fragment),Kc=i(),vl=a("p"),vl.innerHTML=cu,eM=i(),_l=a("ul"),_l.innerHTML=Mu,tM=i(),lM=a("hr"),sM=i(),Yl=a("a"),iM=i(),c(Rl.$$.fragment),nM=i(),$l=a("p"),$l.textContent=ru,aM=i(),Pl=a("table"),Pl.innerHTML=Tu,pM=i(),oM=a("hr"),dM=i(),Vl=a("a"),cM=i(),c(El.$$.fragment),MM=i(),zl=a("p"),zl.textContent=mu,rM=i(),Hl=a("p"),Hl.innerHTML=yu,TM=i(),Wl=a("table"),Wl.innerHTML=Ju,mM=i(),yM=a("hr"),JM=i(),Sl=a("a"),hM=i(),c(Xl.$$.fragment),uM=i(),Ll=a("p"),Ll.textContent=hu,wM=i(),Dl=a("p"),Dl.innerHTML=uu,jM=i(),c(Fl.$$.fragment),UM=i(),ql=a("p"),ql.innerHTML=wu,fM=i(),c(Ol.$$.fragment),bM=i(),Kl=a("p"),Kl.innerHTML=ju,xM=i(),c(es.$$.fragment),CM=i(),ts=a("p"),ts.innerHTML=Uu,gM=i(),c(ls.$$.fragment),IM=i(),ss=a("p"),ss.innerHTML=fu,kM=i(),c(is.$$.fragment),GM=i(),ns=a("p"),ns.innerHTML=bu,ZM=i(),c(as.$$.fragment),QM=i(),ps=a("p"),ps.innerHTML=xu,BM=i(),os=a("ul"),os.innerHTML=Cu,AM=i(),NM=a("hr"),vM=i(),ds=a("a"),_M=i(),c(cs.$$.fragment),YM=i(),Ms=a("p"),Ms.textContent=gu,RM=i(),rs=a("table"),rs.innerHTML=Iu,$M=i(),PM=a("hr"),VM=i(),Ts=a("a"),EM=i(),c(ms.$$.fragment),zM=i(),ys=a("p"),ys.textContent=ku,HM=i(),Js=a("p"),Js.innerHTML=Gu,WM=i(),hs=a("table"),hs.innerHTML=Zu,SM=i(),XM=a("hr"),LM=i(),us=a("a"),DM=i(),c(ws.$$.fragment),FM=i(),js=a("p"),js.innerHTML=Qu,qM=i(),Us=a("p"),Us.innerHTML=Bu,OM=i(),c(fs.$$.fragment),KM=i(),bs=a("p"),bs.innerHTML=Au,er=i(),c(xs.$$.fragment),tr=i(),Cs=a("p"),Cs.innerHTML=Nu,lr=i(),gs=a("ul"),gs.innerHTML=vu,sr=i(),ir=a("hr"),nr=i(),Is=a("a"),ar=i(),c(ks.$$.fragment),pr=i(),Gs=a("p"),Gs.textContent=_u,or=i(),Zs=a("table"),Zs.innerHTML=Yu,dr=i(),cr=a("hr"),Mr=i(),Qs=a("a"),rr=i(),c(Bs.$$.fragment),Tr=i(),As=a("p"),As.textContent=Ru,mr=i(),Ns=a("p"),Ns.innerHTML=$u,yr=i(),vs=a("table"),vs.innerHTML=Pu,Jr=i(),hr=a("hr"),ur=i(),_s=a("a"),wr=i(),c(Ys.$$.fragment),jr=i(),Rs=a("p"),Rs.innerHTML=Vu,Ur=i(),$s=a("p"),$s.innerHTML=Eu,fr=i(),c(Ps.$$.fragment),br=i(),Vs=a("p"),Vs.innerHTML=zu,xr=i(),c(Es.$$.fragment),Cr=i(),zs=a("p"),zs.innerHTML=Hu,gr=i(),c(Hs.$$.fragment),Ir=i(),Ws=a("p"),Ws.innerHTML=Wu,kr=i(),Ss=a("ul"),Ss.innerHTML=Su,Gr=i(),Zr=a("hr"),Qr=i(),Xs=a("a"),Br=i(),c(Ls.$$.fragment),Ar=i(),Ds=a("p"),Ds.textContent=Xu,Nr=i(),Fs=a("table"),Fs.innerHTML=Lu,vr=i(),_r=a("hr"),Yr=i(),qs=a("a"),Rr=i(),c(Os.$$.fragment),$r=i(),Ks=a("p"),Ks.textContent=Du,Pr=i(),ei=a("p"),ei.innerHTML=Fu,Vr=i(),ti=a("table"),ti.innerHTML=qu,Er=i(),zr=a("hr"),Hr=i(),li=a("a"),Wr=i(),c(si.$$.fragment),Sr=i(),ii=a("p"),ii.innerHTML=Ou,Xr=i(),ni=a("p"),ni.innerHTML=Ku,Lr=i(),c(ai.$$.fragment),Dr=i(),pi=a("p"),pi.innerHTML=ew,Fr=i(),oi=a("ul"),oi.innerHTML=tw,qr=i(),Or=a("hr"),Kr=i(),di=a("a"),eT=i(),c(ci.$$.fragment),tT=i(),Mi=a("p"),Mi.textContent=lw,lT=i(),ri=a("table"),ri.innerHTML=sw,sT=i(),iT=a("hr"),nT=i(),Ti=a("a"),aT=i(),c(mi.$$.fragment),pT=i(),yi=a("p"),yi.textContent=iw,oT=i(),Ji=a("p"),Ji.innerHTML=nw,dT=i(),hi=a("table"),hi.innerHTML=aw,cT=i(),MT=a("hr"),rT=i(),ui=a("a"),TT=i(),c(wi.$$.fragment),mT=i(),ji=a("p"),ji.innerHTML=pw,yT=i(),Ui=a("p"),Ui.innerHTML=ow,JT=i(),c(fi.$$.fragment),hT=i(),bi=a("p"),bi.innerHTML=dw,uT=i(),xi=a("ul"),xi.innerHTML=cw,wT=i(),jT=a("hr"),UT=i(),Ci=a("a"),fT=i(),c(gi.$$.fragment),bT=i(),Ii=a("p"),Ii.textContent=Mw,xT=i(),ki=a("table"),ki.innerHTML=rw,CT=i(),gT=a("hr"),IT=i(),Gi=a("a"),kT=i(),c(Zi.$$.fragment),GT=i(),Qi=a("p"),Qi.textContent=Tw,ZT=i(),Bi=a("p"),Bi.innerHTML=mw,QT=i(),Ai=a("table"),Ai.innerHTML=yw,BT=i(),AT=a("hr"),NT=i(),Ni=a("a"),vT=i(),c(vi.$$.fragment),_T=i(),_i=a("p"),_i.innerHTML=Jw,YT=i(),Yi=a("p"),Yi.innerHTML=hw,RT=i(),c(Ri.$$.fragment),$T=i(),$i=a("p"),$i.innerHTML=uw,PT=i(),Pi=a("ul"),Pi.innerHTML=ww,VT=i(),ET=a("hr"),zT=i(),Vi=a("a"),HT=i(),c(Ei.$$.fragment),WT=i(),zi=a("p"),zi.textContent=jw,ST=i(),Hi=a("table"),Hi.innerHTML=Uw,XT=i(),LT=a("hr"),DT=i(),Wi=a("a"),FT=i(),c(Si.$$.fragment),qT=i(),Xi=a("p"),Xi.textContent=fw,OT=i(),Li=a("p"),Li.innerHTML=bw,KT=i(),Di=a("table"),Di.innerHTML=xw,em=i(),tm=a("hr"),lm=i(),Fi=a("a"),sm=i(),c(qi.$$.fragment),im=i(),Oi=a("p"),Oi.innerHTML=Cw,nm=i(),Ki=a("p"),Ki.innerHTML=gw,am=i(),c(en.$$.fragment),pm=i(),tn=a("p"),tn.innerHTML=Iw,om=i(),c(ln.$$.fragment),dm=i(),sn=a("p"),sn.innerHTML=kw,cm=i(),nn=a("ul"),nn.innerHTML=Gw,Mm=i(),rm=a("hr"),Tm=i(),an=a("a"),mm=i(),c(pn.$$.fragment),ym=i(),on=a("p"),on.textContent=Zw,Jm=i(),dn=a("table"),dn.innerHTML=Qw,hm=i(),um=a("hr"),wm=i(),cn=a("a"),jm=i(),c(Mn.$$.fragment),Um=i(),rn=a("p"),rn.textContent=Bw,fm=i(),Tn=a("p"),Tn.innerHTML=Aw,bm=i(),mn=a("table"),mn.innerHTML=Nw,xm=i(),Cm=a("hr"),gm=i(),yn=a("a"),Im=i(),c(Jn.$$.fragment),km=i(),hn=a("p"),hn.innerHTML=vw,Gm=i(),un=a("p"),un.innerHTML=_w,Zm=i(),c(wn.$$.fragment),Qm=i(),jn=a("p"),jn.innerHTML=Yw,Bm=i(),Un=a("ul"),Un.innerHTML=Rw,Am=i(),Nm=a("hr"),vm=i(),fn=a("a"),_m=i(),c(bn.$$.fragment),Ym=i(),xn=a("p"),xn.textContent=$w,Rm=i(),Cn=a("table"),Cn.innerHTML=Pw,$m=i(),Pm=a("hr"),Vm=i(),gn=a("a"),Em=i(),c(In.$$.fragment),zm=i(),kn=a("p"),kn.textContent=Vw,Hm=i(),Gn=a("p"),Gn.innerHTML=Ew,Wm=i(),Zn=a("table"),Zn.innerHTML=zw,Sm=i(),Xm=a("hr"),Lm=i(),Qn=a("a"),Dm=i(),c(Bn.$$.fragment),Fm=i(),An=a("p"),An.innerHTML=Hw,qm=i(),Nn=a("p"),Nn.innerHTML=Ww,Om=i(),c(vn.$$.fragment),Km=i(),_n=a("p"),_n.innerHTML=Sw,ey=i(),c(Yn.$$.fragment),ty=i(),Rn=a("p"),Rn.innerHTML=Xw,ly=i(),$n=a("ul"),$n.innerHTML=Lw,sy=i(),iy=a("hr"),ny=i(),Pn=a("a"),ay=i(),c(Vn.$$.fragment),py=i(),En=a("p"),En.textContent=Dw,oy=i(),zn=a("table"),zn.innerHTML=Fw,dy=i(),cy=a("hr"),My=i(),Hn=a("a"),ry=i(),c(Wn.$$.fragment),Ty=i(),Sn=a("p"),Sn.textContent=qw,my=i(),Xn=a("p"),Xn.innerHTML=Ow,yy=i(),Ln=a("table"),Ln.innerHTML=Kw,Jy=i(),hy=a("hr"),uy=i(),Dn=a("a"),wy=i(),c(Fn.$$.fragment),jy=i(),qn=a("p"),qn.innerHTML=ej,Uy=i(),On=a("p"),On.innerHTML=tj,fy=i(),c(Kn.$$.fragment),by=i(),ea=a("p"),ea.innerHTML=lj,xy=i(),Cy=a("hr"),gy=i(),ta=a("a"),Iy=i(),c(la.$$.fragment),ky=i(),sa=a("p"),sa.textContent=sj,Gy=i(),ia=a("p"),ia.innerHTML=ij,Zy=i(),na=a("table"),na.innerHTML=nj,Qy=i(),By=a("hr"),Ay=i(),aa=a("a"),Ny=i(),c(pa.$$.fragment),vy=i(),oa=a("p"),oa.innerHTML=aj,_y=i(),da=a("p"),da.innerHTML=pj,Yy=i(),c(ca.$$.fragment),Ry=i(),Ma=a("p"),Ma.innerHTML=oj,$y=i(),Py=a("hr"),Vy=i(),ra=a("a"),Ey=i(),c(Ta.$$.fragment),zy=i(),ma=a("p"),ma.textContent=dj,Hy=i(),ya=a("p"),ya.innerHTML=cj,Wy=i(),Ja=a("table"),Ja.innerHTML=Mj,Sy=i(),Xy=a("hr"),Ly=i(),ha=a("a"),Dy=i(),c(ua.$$.fragment),Fy=i(),wa=a("p"),wa.innerHTML=rj,qy=i(),ja=a("p"),ja.innerHTML=Tj,Oy=i(),Ua=a("ul"),Ua.innerHTML=mj,Ky=i(),fa=a("table"),fa.innerHTML=yj,eJ=i(),tJ=a("hr"),lJ=i(),ba=a("a"),sJ=i(),c(xa.$$.fragment),iJ=i(),Ca=a("p"),Ca.innerHTML=Jj,nJ=i(),ga=a("table"),ga.innerHTML=hj,aJ=i(),pJ=a("hr"),oJ=i(),Ia=a("a"),dJ=i(),c(ka.$$.fragment),cJ=i(),Ga=a("p"),Ga.innerHTML=uj,MJ=i(),rJ=a("hr"),TJ=i(),Za=a("a"),mJ=i(),c(Qa.$$.fragment),yJ=i(),Ba=a("p"),Ba.innerHTML=wj,JJ=i(),Aa=a("table"),Aa.innerHTML=jj,hJ=i(),uJ=a("hr"),wJ=i(),va=a("p"),this.h()},l(e){const t=gj("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(l),_a=n(e),Na=p(e,"P",{}),J(Na).forEach(l),Ya=n(e),j=p(e,"A",{id:!0,class:!0}),J(j).forEach(l),Ra=n(e),M(U.$$.fragment,e),$a=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1inm2t9"&&(f.textContent=fJ),Pa=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pjech"&&(b.innerHTML=bJ),Va=n(e),M(x.$$.fragment,e),Ea=n(e),C=p(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-1s01i4d"&&(C.innerHTML=xJ),za=n(e),Ha=p(e,"HR",{}),Wa=n(e),g=p(e,"A",{id:!0,class:!0}),J(g).forEach(l),Sa=n(e),M(I.$$.fragment,e),Xa=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-16ix8v2"&&(k.textContent=CJ),La=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1olpg2f"&&(G.innerHTML=gJ),Da=n(e),Z=p(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-1wo4saj"&&(Z.innerHTML=IJ),Fa=n(e),qa=p(e,"HR",{}),Oa=n(e),Q=p(e,"A",{id:!0,class:!0}),J(Q).forEach(l),Ka=n(e),M(B.$$.fragment,e),ep=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-10jkwj"&&(A.textContent=kJ),tp=n(e),N=p(e,"TABLE",{"data-svelte-h":!0}),o(N)!=="svelte-13q0syp"&&(N.innerHTML=GJ),lp=n(e),sp=p(e,"HR",{}),ip=n(e),v=p(e,"A",{id:!0,class:!0}),J(v).forEach(l),np=n(e),M(_.$$.fragment,e),ap=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1yhr8qe"&&(Y.textContent=ZJ),pp=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1yqombv"&&(R.innerHTML=QJ),op=n(e),dp=p(e,"HR",{}),cp=n(e),$=p(e,"A",{id:!0,class:!0}),J($).forEach(l),Mp=n(e),M(P.$$.fragment,e),rp=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-phuke9"&&(V.textContent=BJ),Tp=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1xajepz"&&(E.innerHTML=AJ),mp=n(e),z=p(e,"TABLE",{"data-svelte-h":!0}),o(z)!=="svelte-1dl6le6"&&(z.innerHTML=NJ),yp=n(e),Jp=p(e,"HR",{}),hp=n(e),H=p(e,"A",{id:!0,class:!0}),J(H).forEach(l),up=n(e),M(W.$$.fragment,e),wp=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1aega0x"&&(S.innerHTML=vJ),jp=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-twv4w2"&&(X.innerHTML=_J),Up=n(e),M(L.$$.fragment,e),fp=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-9l8wqs"&&(D.innerHTML=YJ),bp=n(e),M(F.$$.fragment,e),xp=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-63pkoo"&&(q.innerHTML=RJ),Cp=n(e),M(O.$$.fragment,e),gp=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-s10qq4"&&(K.innerHTML=$J),Ip=n(e),kp=p(e,"HR",{}),Gp=n(e),ee=p(e,"A",{id:!0,class:!0}),J(ee).forEach(l),Zp=n(e),M(te.$$.fragment,e),Qp=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-319swt"&&(le.textContent=PJ),Bp=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vshn55"&&(se.innerHTML=VJ),Ap=n(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),o(ie)!=="svelte-mqkhxk"&&(ie.innerHTML=EJ),Np=n(e),vp=p(e,"HR",{}),_p=n(e),ne=p(e,"A",{id:!0,class:!0}),J(ne).forEach(l),Yp=n(e),M(ae.$$.fragment,e),Rp=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-199l8oj"&&(pe.innerHTML=zJ),$p=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-3ojewp"&&(oe.innerHTML=HJ),Pp=n(e),M(de.$$.fragment,e),Vp=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ln7q61"&&(ce.innerHTML=WJ),Ep=n(e),M(Me.$$.fragment,e),zp=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-s10qq4"&&(re.innerHTML=SJ),Hp=n(e),Wp=p(e,"HR",{}),Sp=n(e),Te=p(e,"A",{id:!0,class:!0}),J(Te).forEach(l),Xp=n(e),M(me.$$.fragment,e),Lp=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-qfvk6r"&&(ye.textContent=XJ),Dp=n(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1tvkl0p"&&(Je.innerHTML=LJ),Fp=n(e),he=p(e,"TABLE",{"data-svelte-h":!0}),o(he)!=="svelte-1p6smdx"&&(he.innerHTML=DJ),qp=n(e),Op=p(e,"HR",{}),Kp=n(e),ue=p(e,"A",{id:!0,class:!0}),J(ue).forEach(l),eo=n(e),M(we.$$.fragment,e),to=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-14f3xkz"&&(je.innerHTML=FJ),lo=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-o2pgcr"&&(Ue.innerHTML=qJ),so=n(e),M(fe.$$.fragment,e),io=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-s10qq4"&&(be.innerHTML=OJ),no=n(e),ao=p(e,"HR",{}),po=n(e),xe=p(e,"A",{id:!0,class:!0}),J(xe).forEach(l),oo=n(e),M(Ce.$$.fragment,e),co=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-v1s8i"&&(ge.textContent=KJ),Mo=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jet258"&&(Ie.innerHTML=eh),ro=n(e),ke=p(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-dmekw3"&&(ke.innerHTML=th),To=n(e),mo=p(e,"HR",{}),yo=n(e),Ge=p(e,"A",{id:!0,class:!0}),J(Ge).forEach(l),Jo=n(e),M(Ze.$$.fragment,e),ho=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-nzjx48"&&(Qe.innerHTML=lh),uo=n(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1xict4f"&&(Be.innerHTML=sh),wo=n(e),M(Ae.$$.fragment,e),jo=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1sz7ava"&&(Ne.innerHTML=ih),Uo=n(e),M(ve.$$.fragment,e),fo=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-s10qq4"&&(_e.innerHTML=nh),bo=n(e),xo=p(e,"HR",{}),Co=n(e),Ye=p(e,"A",{id:!0,class:!0}),J(Ye).forEach(l),go=n(e),M(Re.$$.fragment,e),Io=n(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1dgb1r"&&($e.textContent=ah),ko=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-ht5bcu"&&(Pe.innerHTML=ph),Go=n(e),Ve=p(e,"TABLE",{"data-svelte-h":!0}),o(Ve)!=="svelte-dhvci0"&&(Ve.innerHTML=oh),Zo=n(e),Qo=p(e,"HR",{}),Bo=n(e),Ee=p(e,"A",{id:!0,class:!0}),J(Ee).forEach(l),Ao=n(e),M(ze.$$.fragment,e),No=n(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-e2spcq"&&(He.textContent=dh),vo=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-j4hwgn"&&(We.innerHTML=ch),_o=n(e),M(Se.$$.fragment,e),Yo=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-s10qq4"&&(Xe.innerHTML=Mh),Ro=n(e),$o=p(e,"HR",{}),Po=n(e),Le=p(e,"A",{id:!0,class:!0}),J(Le).forEach(l),Vo=n(e),M(De.$$.fragment,e),Eo=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1dgb1r"&&(Fe.textContent=rh),zo=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-k5n4xx"&&(qe.innerHTML=Th),Ho=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),o(Oe)!=="svelte-wmzf9w"&&(Oe.innerHTML=mh),Wo=n(e),Ke=p(e,"TABLE",{"data-svelte-h":!0}),o(Ke)!=="svelte-18cf78d"&&(Ke.innerHTML=yh),So=n(e),Xo=p(e,"HR",{}),Lo=n(e),et=p(e,"A",{id:!0,class:!0}),J(et).forEach(l),Do=n(e),M(tt.$$.fragment,e),Fo=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1axdht2"&&(lt.textContent=Jh),qo=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1416cqx"&&(st.innerHTML=hh),Oo=n(e),M(it.$$.fragment,e),Ko=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-s10qq4"&&(nt.innerHTML=uh),ed=n(e),td=p(e,"HR",{}),ld=n(e),at=p(e,"A",{id:!0,class:!0}),J(at).forEach(l),sd=n(e),M(pt.$$.fragment,e),id=n(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-3abd20"&&(ot.textContent=wh),nd=n(e),dt=p(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1ut0vme"&&(dt.innerHTML=jh),ad=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-dr1wsd"&&(ct.innerHTML=Uh),pd=n(e),M(Mt.$$.fragment,e),od=n(e),rt=p(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-mqh15a"&&(rt.innerHTML=fh),dd=n(e),Tt=p(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-zf4dht"&&(Tt.innerHTML=bh),cd=n(e),M(mt.$$.fragment,e),Md=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1877ohf"&&(yt.innerHTML=xh),rd=n(e),Jt=p(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1ox1juk"&&(Jt.innerHTML=Ch),Td=n(e),M(ht.$$.fragment,e),md=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-s10qq4"&&(ut.innerHTML=gh),yd=n(e),Jd=p(e,"HR",{}),hd=n(e),wt=p(e,"A",{id:!0,class:!0}),J(wt).forEach(l),ud=n(e),M(jt.$$.fragment,e),wd=n(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1yek3op"&&(Ut.innerHTML=Ih),jd=n(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-11p32pq"&&(ft.innerHTML=kh),Ud=n(e),M(bt.$$.fragment,e),fd=n(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1uqom1e"&&(xt.innerHTML=Gh),bd=n(e),M(Ct.$$.fragment,e),xd=n(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1a7k67n"&&(gt.innerHTML=Zh),Cd=n(e),M(It.$$.fragment,e),gd=n(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-s10qq4"&&(kt.innerHTML=Qh),Id=n(e),kd=p(e,"HR",{}),Gd=n(e),Gt=p(e,"A",{id:!0,class:!0}),J(Gt).forEach(l),Zd=n(e),M(Zt.$$.fragment,e),Qd=n(e),Qt=p(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-6m3xhk"&&(Qt.textContent=Bh),Bd=n(e),Bt=p(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1f5btis"&&(Bt.innerHTML=Ah),Ad=n(e),At=p(e,"TABLE",{"data-svelte-h":!0}),o(At)!=="svelte-5kvkn6"&&(At.innerHTML=Nh),Nd=n(e),vd=p(e,"HR",{}),_d=n(e),Nt=p(e,"A",{id:!0,class:!0}),J(Nt).forEach(l),Yd=n(e),M(vt.$$.fragment,e),Rd=n(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-104v5zf"&&(_t.innerHTML=vh),$d=n(e),Yt=p(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-17n9q32"&&(Yt.innerHTML=_h),Pd=n(e),M(Rt.$$.fragment,e),Vd=n(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-v99qry"&&($t.innerHTML=Yh),Ed=n(e),M(Pt.$$.fragment,e),zd=n(e),Vt=p(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-s10qq4"&&(Vt.innerHTML=Rh),Hd=n(e),Et=p(e,"UL",{"data-svelte-h":!0}),o(Et)!=="svelte-svwcak"&&(Et.innerHTML=$h),Wd=n(e),Sd=p(e,"HR",{}),Xd=n(e),zt=p(e,"A",{id:!0,class:!0}),J(zt).forEach(l),Ld=n(e),M(Ht.$$.fragment,e),Dd=n(e),Wt=p(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-1n1xlcl"&&(Wt.textContent=Ph),Fd=n(e),St=p(e,"TABLE",{"data-svelte-h":!0}),o(St)!=="svelte-1h8f"&&(St.innerHTML=Vh),qd=n(e),Od=p(e,"HR",{}),Kd=n(e),Xt=p(e,"A",{id:!0,class:!0}),J(Xt).forEach(l),ec=n(e),M(Lt.$$.fragment,e),tc=n(e),Dt=p(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-c8gx4u"&&(Dt.innerHTML=Eh),lc=n(e),Ft=p(e,"TABLE",{"data-svelte-h":!0}),o(Ft)!=="svelte-y9oo3q"&&(Ft.innerHTML=zh),sc=n(e),ic=p(e,"HR",{}),nc=n(e),qt=p(e,"A",{id:!0,class:!0}),J(qt).forEach(l),ac=n(e),M(Ot.$$.fragment,e),pc=n(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-tzucv0"&&(Kt.textContent=Hh),oc=n(e),el=p(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-zrdgvs"&&(el.innerHTML=Wh),dc=n(e),M(tl.$$.fragment,e),cc=n(e),ll=p(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-et9i9m"&&(ll.innerHTML=Sh),Mc=n(e),M(sl.$$.fragment,e),rc=n(e),il=p(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-162t9ct"&&(il.innerHTML=Xh),Tc=n(e),M(nl.$$.fragment,e),mc=n(e),al=p(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-s10qq4"&&(al.innerHTML=Lh),yc=n(e),Jc=p(e,"HR",{}),hc=n(e),pl=p(e,"A",{id:!0,class:!0}),J(pl).forEach(l),uc=n(e),M(ol.$$.fragment,e),wc=n(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-11eoigb"&&(dl.textContent=Dh),jc=n(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-un4fzt"&&(cl.innerHTML=Fh),Uc=n(e),Ml=p(e,"TABLE",{"data-svelte-h":!0}),o(Ml)!=="svelte-1qj38gf"&&(Ml.innerHTML=qh),fc=n(e),bc=p(e,"HR",{}),xc=n(e),rl=p(e,"A",{id:!0,class:!0}),J(rl).forEach(l),Cc=n(e),M(Tl.$$.fragment,e),gc=n(e),ml=p(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-9xhkxa"&&(ml.innerHTML=Oh),Ic=n(e),yl=p(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-11cz03b"&&(yl.innerHTML=Kh),kc=n(e),M(Jl.$$.fragment,e),Gc=n(e),hl=p(e,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-1mkx6vp"&&(hl.innerHTML=eu),Zc=n(e),M(ul.$$.fragment,e),Qc=n(e),wl=p(e,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-s10qq4"&&(wl.innerHTML=tu),Bc=n(e),jl=p(e,"UL",{"data-svelte-h":!0}),o(jl)!=="svelte-fjr04l"&&(jl.innerHTML=lu),Ac=n(e),Nc=p(e,"HR",{}),vc=n(e),Ul=p(e,"A",{id:!0,class:!0}),J(Ul).forEach(l),_c=n(e),M(fl.$$.fragment,e),Yc=n(e),bl=p(e,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1enract"&&(bl.textContent=su),Rc=n(e),xl=p(e,"TABLE",{"data-svelte-h":!0}),o(xl)!=="svelte-dgeggs"&&(xl.innerHTML=iu),$c=n(e),Pc=p(e,"HR",{}),Vc=n(e),Cl=p(e,"A",{id:!0,class:!0}),J(Cl).forEach(l),Ec=n(e),M(gl.$$.fragment,e),zc=n(e),Il=p(e,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-19qhuwa"&&(Il.textContent=nu),Hc=n(e),kl=p(e,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-1gq3dbn"&&(kl.innerHTML=au),Wc=n(e),Gl=p(e,"TABLE",{"data-svelte-h":!0}),o(Gl)!=="svelte-17m2nm1"&&(Gl.innerHTML=pu),Sc=n(e),Xc=p(e,"HR",{}),Lc=n(e),Zl=p(e,"A",{id:!0,class:!0}),J(Zl).forEach(l),Dc=n(e),M(Ql.$$.fragment,e),Fc=n(e),Bl=p(e,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-tmg4zt"&&(Bl.innerHTML=ou),qc=n(e),Al=p(e,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-em947q"&&(Al.innerHTML=du),Oc=n(e),M(Nl.$$.fragment,e),Kc=n(e),vl=p(e,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-s10qq4"&&(vl.innerHTML=cu),eM=n(e),_l=p(e,"UL",{"data-svelte-h":!0}),o(_l)!=="svelte-1oaesl"&&(_l.innerHTML=Mu),tM=n(e),lM=p(e,"HR",{}),sM=n(e),Yl=p(e,"A",{id:!0,class:!0}),J(Yl).forEach(l),iM=n(e),M(Rl.$$.fragment,e),nM=n(e),$l=p(e,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1edlvjn"&&($l.textContent=ru),aM=n(e),Pl=p(e,"TABLE",{"data-svelte-h":!0}),o(Pl)!=="svelte-1a94q5m"&&(Pl.innerHTML=Tu),pM=n(e),oM=p(e,"HR",{}),dM=n(e),Vl=p(e,"A",{id:!0,class:!0}),J(Vl).forEach(l),cM=n(e),M(El.$$.fragment,e),MM=n(e),zl=p(e,"P",{"data-svelte-h":!0}),o(zl)!=="svelte-kd58rd"&&(zl.textContent=mu),rM=n(e),Hl=p(e,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-1cetnsf"&&(Hl.innerHTML=yu),TM=n(e),Wl=p(e,"TABLE",{"data-svelte-h":!0}),o(Wl)!=="svelte-1pv38nb"&&(Wl.innerHTML=Ju),mM=n(e),yM=p(e,"HR",{}),JM=n(e),Sl=p(e,"A",{id:!0,class:!0}),J(Sl).forEach(l),hM=n(e),M(Xl.$$.fragment,e),uM=n(e),Ll=p(e,"P",{"data-svelte-h":!0}),o(Ll)!=="svelte-vm8asa"&&(Ll.textContent=hu),wM=n(e),Dl=p(e,"P",{"data-svelte-h":!0}),o(Dl)!=="svelte-p9nqmy"&&(Dl.innerHTML=uu),jM=n(e),M(Fl.$$.fragment,e),UM=n(e),ql=p(e,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-1xb4yln"&&(ql.innerHTML=wu),fM=n(e),M(Ol.$$.fragment,e),bM=n(e),Kl=p(e,"P",{"data-svelte-h":!0}),o(Kl)!=="svelte-aly754"&&(Kl.innerHTML=ju),xM=n(e),M(es.$$.fragment,e),CM=n(e),ts=p(e,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-127z1r2"&&(ts.innerHTML=Uu),gM=n(e),M(ls.$$.fragment,e),IM=n(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-5ad2vc"&&(ss.innerHTML=fu),kM=n(e),M(is.$$.fragment,e),GM=n(e),ns=p(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1ybp4y9"&&(ns.innerHTML=bu),ZM=n(e),M(as.$$.fragment,e),QM=n(e),ps=p(e,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-s10qq4"&&(ps.innerHTML=xu),BM=n(e),os=p(e,"UL",{"data-svelte-h":!0}),o(os)!=="svelte-32csn1"&&(os.innerHTML=Cu),AM=n(e),NM=p(e,"HR",{}),vM=n(e),ds=p(e,"A",{id:!0,class:!0}),J(ds).forEach(l),_M=n(e),M(cs.$$.fragment,e),YM=n(e),Ms=p(e,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1kkefov"&&(Ms.textContent=gu),RM=n(e),rs=p(e,"TABLE",{"data-svelte-h":!0}),o(rs)!=="svelte-1a94q5m"&&(rs.innerHTML=Iu),$M=n(e),PM=p(e,"HR",{}),VM=n(e),Ts=p(e,"A",{id:!0,class:!0}),J(Ts).forEach(l),EM=n(e),M(ms.$$.fragment,e),zM=n(e),ys=p(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-d8vj38"&&(ys.textContent=ku),HM=n(e),Js=p(e,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-hgdjqs"&&(Js.innerHTML=Gu),WM=n(e),hs=p(e,"TABLE",{"data-svelte-h":!0}),o(hs)!=="svelte-1usuiaq"&&(hs.innerHTML=Zu),SM=n(e),XM=p(e,"HR",{}),LM=n(e),us=p(e,"A",{id:!0,class:!0}),J(us).forEach(l),DM=n(e),M(ws.$$.fragment,e),FM=n(e),js=p(e,"P",{"data-svelte-h":!0}),o(js)!=="svelte-yuzbfo"&&(js.innerHTML=Qu),qM=n(e),Us=p(e,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-gwolyd"&&(Us.innerHTML=Bu),OM=n(e),M(fs.$$.fragment,e),KM=n(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-vvjehq"&&(bs.innerHTML=Au),er=n(e),M(xs.$$.fragment,e),tr=n(e),Cs=p(e,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-s10qq4"&&(Cs.innerHTML=Nu),lr=n(e),gs=p(e,"UL",{"data-svelte-h":!0}),o(gs)!=="svelte-3k2o01"&&(gs.innerHTML=vu),sr=n(e),ir=p(e,"HR",{}),nr=n(e),Is=p(e,"A",{id:!0,class:!0}),J(Is).forEach(l),ar=n(e),M(ks.$$.fragment,e),pr=n(e),Gs=p(e,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-10qze5e"&&(Gs.textContent=_u),or=n(e),Zs=p(e,"TABLE",{"data-svelte-h":!0}),o(Zs)!=="svelte-1a94q5m"&&(Zs.innerHTML=Yu),dr=n(e),cr=p(e,"HR",{}),Mr=n(e),Qs=p(e,"A",{id:!0,class:!0}),J(Qs).forEach(l),rr=n(e),M(Bs.$$.fragment,e),Tr=n(e),As=p(e,"P",{"data-svelte-h":!0}),o(As)!=="svelte-ypfmt8"&&(As.textContent=Ru),mr=n(e),Ns=p(e,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-sv0g8q"&&(Ns.innerHTML=$u),yr=n(e),vs=p(e,"TABLE",{"data-svelte-h":!0}),o(vs)!=="svelte-1d2oy3p"&&(vs.innerHTML=Pu),Jr=n(e),hr=p(e,"HR",{}),ur=n(e),_s=p(e,"A",{id:!0,class:!0}),J(_s).forEach(l),wr=n(e),M(Ys.$$.fragment,e),jr=n(e),Rs=p(e,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-w5osnc"&&(Rs.innerHTML=Vu),Ur=n(e),$s=p(e,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1h4310j"&&($s.innerHTML=Eu),fr=n(e),M(Ps.$$.fragment,e),br=n(e),Vs=p(e,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-xv6hak"&&(Vs.innerHTML=zu),xr=n(e),M(Es.$$.fragment,e),Cr=n(e),zs=p(e,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-1ids6l"&&(zs.innerHTML=Hu),gr=n(e),M(Hs.$$.fragment,e),Ir=n(e),Ws=p(e,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-s10qq4"&&(Ws.innerHTML=Wu),kr=n(e),Ss=p(e,"UL",{"data-svelte-h":!0}),o(Ss)!=="svelte-z3581k"&&(Ss.innerHTML=Su),Gr=n(e),Zr=p(e,"HR",{}),Qr=n(e),Xs=p(e,"A",{id:!0,class:!0}),J(Xs).forEach(l),Br=n(e),M(Ls.$$.fragment,e),Ar=n(e),Ds=p(e,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-71b02w"&&(Ds.textContent=Xu),Nr=n(e),Fs=p(e,"TABLE",{"data-svelte-h":!0}),o(Fs)!=="svelte-dgeggs"&&(Fs.innerHTML=Lu),vr=n(e),_r=p(e,"HR",{}),Yr=n(e),qs=p(e,"A",{id:!0,class:!0}),J(qs).forEach(l),Rr=n(e),M(Os.$$.fragment,e),$r=n(e),Ks=p(e,"P",{"data-svelte-h":!0}),o(Ks)!=="svelte-1rpepg8"&&(Ks.textContent=Du),Pr=n(e),ei=p(e,"P",{"data-svelte-h":!0}),o(ei)!=="svelte-zgzruq"&&(ei.innerHTML=Fu),Vr=n(e),ti=p(e,"TABLE",{"data-svelte-h":!0}),o(ti)!=="svelte-17j2fmt"&&(ti.innerHTML=qu),Er=n(e),zr=p(e,"HR",{}),Hr=n(e),li=p(e,"A",{id:!0,class:!0}),J(li).forEach(l),Wr=n(e),M(si.$$.fragment,e),Sr=n(e),ii=p(e,"P",{"data-svelte-h":!0}),o(ii)!=="svelte-1rwi35s"&&(ii.innerHTML=Ou),Xr=n(e),ni=p(e,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-1tpbwb6"&&(ni.innerHTML=Ku),Lr=n(e),M(ai.$$.fragment,e),Dr=n(e),pi=p(e,"P",{"data-svelte-h":!0}),o(pi)!=="svelte-s10qq4"&&(pi.innerHTML=ew),Fr=n(e),oi=p(e,"UL",{"data-svelte-h":!0}),o(oi)!=="svelte-1n3ebqn"&&(oi.innerHTML=tw),qr=n(e),Or=p(e,"HR",{}),Kr=n(e),di=p(e,"A",{id:!0,class:!0}),J(di).forEach(l),eT=n(e),M(ci.$$.fragment,e),tT=n(e),Mi=p(e,"P",{"data-svelte-h":!0}),o(Mi)!=="svelte-1ctgtyq"&&(Mi.textContent=lw),lT=n(e),ri=p(e,"TABLE",{"data-svelte-h":!0}),o(ri)!=="svelte-dgeggs"&&(ri.innerHTML=sw),sT=n(e),iT=p(e,"HR",{}),nT=n(e),Ti=p(e,"A",{id:!0,class:!0}),J(Ti).forEach(l),aT=n(e),M(mi.$$.fragment,e),pT=n(e),yi=p(e,"P",{"data-svelte-h":!0}),o(yi)!=="svelte-1v51wpq"&&(yi.textContent=iw),oT=n(e),Ji=p(e,"P",{"data-svelte-h":!0}),o(Ji)!=="svelte-7em0sw"&&(Ji.innerHTML=nw),dT=n(e),hi=p(e,"TABLE",{"data-svelte-h":!0}),o(hi)!=="svelte-usc03t"&&(hi.innerHTML=aw),cT=n(e),MT=p(e,"HR",{}),rT=n(e),ui=p(e,"A",{id:!0,class:!0}),J(ui).forEach(l),TT=n(e),M(wi.$$.fragment,e),mT=n(e),ji=p(e,"P",{"data-svelte-h":!0}),o(ji)!=="svelte-20dgme"&&(ji.innerHTML=pw),yT=n(e),Ui=p(e,"P",{"data-svelte-h":!0}),o(Ui)!=="svelte-eob2i5"&&(Ui.innerHTML=ow),JT=n(e),M(fi.$$.fragment,e),hT=n(e),bi=p(e,"P",{"data-svelte-h":!0}),o(bi)!=="svelte-s10qq4"&&(bi.innerHTML=dw),uT=n(e),xi=p(e,"UL",{"data-svelte-h":!0}),o(xi)!=="svelte-1psrxkl"&&(xi.innerHTML=cw),wT=n(e),jT=p(e,"HR",{}),UT=n(e),Ci=p(e,"A",{id:!0,class:!0}),J(Ci).forEach(l),fT=n(e),M(gi.$$.fragment,e),bT=n(e),Ii=p(e,"P",{"data-svelte-h":!0}),o(Ii)!=="svelte-3wys82"&&(Ii.textContent=Mw),xT=n(e),ki=p(e,"TABLE",{"data-svelte-h":!0}),o(ki)!=="svelte-1a94q5m"&&(ki.innerHTML=rw),CT=n(e),gT=p(e,"HR",{}),IT=n(e),Gi=p(e,"A",{id:!0,class:!0}),J(Gi).forEach(l),kT=n(e),M(Zi.$$.fragment,e),GT=n(e),Qi=p(e,"P",{"data-svelte-h":!0}),o(Qi)!=="svelte-g4x6jx"&&(Qi.textContent=Tw),ZT=n(e),Bi=p(e,"P",{"data-svelte-h":!0}),o(Bi)!=="svelte-zhb55f"&&(Bi.innerHTML=mw),QT=n(e),Ai=p(e,"TABLE",{"data-svelte-h":!0}),o(Ai)!=="svelte-tncnks"&&(Ai.innerHTML=yw),BT=n(e),AT=p(e,"HR",{}),NT=n(e),Ni=p(e,"A",{id:!0,class:!0}),J(Ni).forEach(l),vT=n(e),M(vi.$$.fragment,e),_T=n(e),_i=p(e,"P",{"data-svelte-h":!0}),o(_i)!=="svelte-11wm84h"&&(_i.innerHTML=Jw),YT=n(e),Yi=p(e,"P",{"data-svelte-h":!0}),o(Yi)!=="svelte-yzldbw"&&(Yi.innerHTML=hw),RT=n(e),M(Ri.$$.fragment,e),$T=n(e),$i=p(e,"P",{"data-svelte-h":!0}),o($i)!=="svelte-s10qq4"&&($i.innerHTML=uw),PT=n(e),Pi=p(e,"UL",{"data-svelte-h":!0}),o(Pi)!=="svelte-1kysuxh"&&(Pi.innerHTML=ww),VT=n(e),ET=p(e,"HR",{}),zT=n(e),Vi=p(e,"A",{id:!0,class:!0}),J(Vi).forEach(l),HT=n(e),M(Ei.$$.fragment,e),WT=n(e),zi=p(e,"P",{"data-svelte-h":!0}),o(zi)!=="svelte-1la8w69"&&(zi.textContent=jw),ST=n(e),Hi=p(e,"TABLE",{"data-svelte-h":!0}),o(Hi)!=="svelte-dgeggs"&&(Hi.innerHTML=Uw),XT=n(e),LT=p(e,"HR",{}),DT=n(e),Wi=p(e,"A",{id:!0,class:!0}),J(Wi).forEach(l),FT=n(e),M(Si.$$.fragment,e),qT=n(e),Xi=p(e,"P",{"data-svelte-h":!0}),o(Xi)!=="svelte-1ws18e1"&&(Xi.textContent=fw),OT=n(e),Li=p(e,"P",{"data-svelte-h":!0}),o(Li)!=="svelte-i9mudt"&&(Li.innerHTML=bw),KT=n(e),Di=p(e,"TABLE",{"data-svelte-h":!0}),o(Di)!=="svelte-th688q"&&(Di.innerHTML=xw),em=n(e),tm=p(e,"HR",{}),lm=n(e),Fi=p(e,"A",{id:!0,class:!0}),J(Fi).forEach(l),sm=n(e),M(qi.$$.fragment,e),im=n(e),Oi=p(e,"P",{"data-svelte-h":!0}),o(Oi)!=="svelte-1hdoc64"&&(Oi.innerHTML=Cw),nm=n(e),Ki=p(e,"P",{"data-svelte-h":!0}),o(Ki)!=="svelte-244nqj"&&(Ki.innerHTML=gw),am=n(e),M(en.$$.fragment,e),pm=n(e),tn=p(e,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-13bh7zz"&&(tn.innerHTML=Iw),om=n(e),M(ln.$$.fragment,e),dm=n(e),sn=p(e,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-s10qq4"&&(sn.innerHTML=kw),cm=n(e),nn=p(e,"UL",{"data-svelte-h":!0}),o(nn)!=="svelte-1sc4xqq"&&(nn.innerHTML=Gw),Mm=n(e),rm=p(e,"HR",{}),Tm=n(e),an=p(e,"A",{id:!0,class:!0}),J(an).forEach(l),mm=n(e),M(pn.$$.fragment,e),ym=n(e),on=p(e,"P",{"data-svelte-h":!0}),o(on)!=="svelte-t69287"&&(on.textContent=Zw),Jm=n(e),dn=p(e,"TABLE",{"data-svelte-h":!0}),o(dn)!=="svelte-1a94q5m"&&(dn.innerHTML=Qw),hm=n(e),um=p(e,"HR",{}),wm=n(e),cn=p(e,"A",{id:!0,class:!0}),J(cn).forEach(l),jm=n(e),M(Mn.$$.fragment,e),Um=n(e),rn=p(e,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-1ws18e1"&&(rn.textContent=Bw),fm=n(e),Tn=p(e,"P",{"data-svelte-h":!0}),o(Tn)!=="svelte-1c20g67"&&(Tn.innerHTML=Aw),bm=n(e),mn=p(e,"TABLE",{"data-svelte-h":!0}),o(mn)!=="svelte-u8y6du"&&(mn.innerHTML=Nw),xm=n(e),Cm=p(e,"HR",{}),gm=n(e),yn=p(e,"A",{id:!0,class:!0}),J(yn).forEach(l),Im=n(e),M(Jn.$$.fragment,e),km=n(e),hn=p(e,"P",{"data-svelte-h":!0}),o(hn)!=="svelte-iv1c6p"&&(hn.innerHTML=vw),Gm=n(e),un=p(e,"P",{"data-svelte-h":!0}),o(un)!=="svelte-1mtx2cy"&&(un.innerHTML=_w),Zm=n(e),M(wn.$$.fragment,e),Qm=n(e),jn=p(e,"P",{"data-svelte-h":!0}),o(jn)!=="svelte-s10qq4"&&(jn.innerHTML=Yw),Bm=n(e),Un=p(e,"UL",{"data-svelte-h":!0}),o(Un)!=="svelte-1x43yje"&&(Un.innerHTML=Rw),Am=n(e),Nm=p(e,"HR",{}),vm=n(e),fn=p(e,"A",{id:!0,class:!0}),J(fn).forEach(l),_m=n(e),M(bn.$$.fragment,e),Ym=n(e),xn=p(e,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-at8fug"&&(xn.textContent=$w),Rm=n(e),Cn=p(e,"TABLE",{"data-svelte-h":!0}),o(Cn)!=="svelte-1a94q5m"&&(Cn.innerHTML=Pw),$m=n(e),Pm=p(e,"HR",{}),Vm=n(e),gn=p(e,"A",{id:!0,class:!0}),J(gn).forEach(l),Em=n(e),M(In.$$.fragment,e),zm=n(e),kn=p(e,"P",{"data-svelte-h":!0}),o(kn)!=="svelte-bu7lod"&&(kn.textContent=Vw),Hm=n(e),Gn=p(e,"P",{"data-svelte-h":!0}),o(Gn)!=="svelte-1or1fiw"&&(Gn.innerHTML=Ew),Wm=n(e),Zn=p(e,"TABLE",{"data-svelte-h":!0}),o(Zn)!=="svelte-55abd5"&&(Zn.innerHTML=zw),Sm=n(e),Xm=p(e,"HR",{}),Lm=n(e),Qn=p(e,"A",{id:!0,class:!0}),J(Qn).forEach(l),Dm=n(e),M(Bn.$$.fragment,e),Fm=n(e),An=p(e,"P",{"data-svelte-h":!0}),o(An)!=="svelte-1nzvfes"&&(An.innerHTML=Hw),qm=n(e),Nn=p(e,"P",{"data-svelte-h":!0}),o(Nn)!=="svelte-1qq0cp9"&&(Nn.innerHTML=Ww),Om=n(e),M(vn.$$.fragment,e),Km=n(e),_n=p(e,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-1mslt41"&&(_n.innerHTML=Sw),ey=n(e),M(Yn.$$.fragment,e),ty=n(e),Rn=p(e,"P",{"data-svelte-h":!0}),o(Rn)!=="svelte-s10qq4"&&(Rn.innerHTML=Xw),ly=n(e),$n=p(e,"UL",{"data-svelte-h":!0}),o($n)!=="svelte-1p37gsh"&&($n.innerHTML=Lw),sy=n(e),iy=p(e,"HR",{}),ny=n(e),Pn=p(e,"A",{id:!0,class:!0}),J(Pn).forEach(l),ay=n(e),M(Vn.$$.fragment,e),py=n(e),En=p(e,"P",{"data-svelte-h":!0}),o(En)!=="svelte-ipwl63"&&(En.textContent=Dw),oy=n(e),zn=p(e,"TABLE",{"data-svelte-h":!0}),o(zn)!=="svelte-11vehfm"&&(zn.innerHTML=Fw),dy=n(e),cy=p(e,"HR",{}),My=n(e),Hn=p(e,"A",{id:!0,class:!0}),J(Hn).forEach(l),ry=n(e),M(Wn.$$.fragment,e),Ty=n(e),Sn=p(e,"P",{"data-svelte-h":!0}),o(Sn)!=="svelte-1a4c4hr"&&(Sn.textContent=qw),my=n(e),Xn=p(e,"P",{"data-svelte-h":!0}),o(Xn)!=="svelte-70tp0b"&&(Xn.innerHTML=Ow),yy=n(e),Ln=p(e,"TABLE",{"data-svelte-h":!0}),o(Ln)!=="svelte-1hspmv9"&&(Ln.innerHTML=Kw),Jy=n(e),hy=p(e,"HR",{}),uy=n(e),Dn=p(e,"A",{id:!0,class:!0}),J(Dn).forEach(l),wy=n(e),M(Fn.$$.fragment,e),jy=n(e),qn=p(e,"P",{"data-svelte-h":!0}),o(qn)!=="svelte-1y1a6n"&&(qn.innerHTML=ej),Uy=n(e),On=p(e,"P",{"data-svelte-h":!0}),o(On)!=="svelte-el75jg"&&(On.innerHTML=tj),fy=n(e),M(Kn.$$.fragment,e),by=n(e),ea=p(e,"P",{"data-svelte-h":!0}),o(ea)!=="svelte-s10qq4"&&(ea.innerHTML=lj),xy=n(e),Cy=p(e,"HR",{}),gy=n(e),ta=p(e,"A",{id:!0,class:!0}),J(ta).forEach(l),Iy=n(e),M(la.$$.fragment,e),ky=n(e),sa=p(e,"P",{"data-svelte-h":!0}),o(sa)!=="svelte-1ega32d"&&(sa.textContent=sj),Gy=n(e),ia=p(e,"P",{"data-svelte-h":!0}),o(ia)!=="svelte-mkrlem"&&(ia.innerHTML=ij),Zy=n(e),na=p(e,"TABLE",{"data-svelte-h":!0}),o(na)!=="svelte-1l7b6wj"&&(na.innerHTML=nj),Qy=n(e),By=p(e,"HR",{}),Ay=n(e),aa=p(e,"A",{id:!0,class:!0}),J(aa).forEach(l),Ny=n(e),M(pa.$$.fragment,e),vy=n(e),oa=p(e,"P",{"data-svelte-h":!0}),o(oa)!=="svelte-cmozej"&&(oa.innerHTML=aj),_y=n(e),da=p(e,"P",{"data-svelte-h":!0}),o(da)!=="svelte-10zf5uq"&&(da.innerHTML=pj),Yy=n(e),M(ca.$$.fragment,e),Ry=n(e),Ma=p(e,"P",{"data-svelte-h":!0}),o(Ma)!=="svelte-s10qq4"&&(Ma.innerHTML=oj),$y=n(e),Py=p(e,"HR",{}),Vy=n(e),ra=p(e,"A",{id:!0,class:!0}),J(ra).forEach(l),Ey=n(e),M(Ta.$$.fragment,e),zy=n(e),ma=p(e,"P",{"data-svelte-h":!0}),o(ma)!=="svelte-1u7ku6i"&&(ma.textContent=dj),Hy=n(e),ya=p(e,"P",{"data-svelte-h":!0}),o(ya)!=="svelte-gbsimw"&&(ya.innerHTML=cj),Wy=n(e),Ja=p(e,"TABLE",{"data-svelte-h":!0}),o(Ja)!=="svelte-1cgj6cy"&&(Ja.innerHTML=Mj),Sy=n(e),Xy=p(e,"HR",{}),Ly=n(e),ha=p(e,"A",{id:!0,class:!0}),J(ha).forEach(l),Dy=n(e),M(ua.$$.fragment,e),Fy=n(e),wa=p(e,"P",{"data-svelte-h":!0}),o(wa)!=="svelte-mcsd8f"&&(wa.innerHTML=rj),qy=n(e),ja=p(e,"P",{"data-svelte-h":!0}),o(ja)!=="svelte-lb0vbj"&&(ja.innerHTML=Tj),Oy=n(e),Ua=p(e,"UL",{"data-svelte-h":!0}),o(Ua)!=="svelte-wk6owh"&&(Ua.innerHTML=mj),Ky=n(e),fa=p(e,"TABLE",{"data-svelte-h":!0}),o(fa)!=="svelte-5vjmiz"&&(fa.innerHTML=yj),eJ=n(e),tJ=p(e,"HR",{}),lJ=n(e),ba=p(e,"A",{id:!0,class:!0}),J(ba).forEach(l),sJ=n(e),M(xa.$$.fragment,e),iJ=n(e),Ca=p(e,"P",{"data-svelte-h":!0}),o(Ca)!=="svelte-ptv3i7"&&(Ca.innerHTML=Jj),nJ=n(e),ga=p(e,"TABLE",{"data-svelte-h":!0}),o(ga)!=="svelte-2eqjop"&&(ga.innerHTML=hj),aJ=n(e),pJ=p(e,"HR",{}),oJ=n(e),Ia=p(e,"A",{id:!0,class:!0}),J(Ia).forEach(l),dJ=n(e),M(ka.$$.fragment,e),cJ=n(e),Ga=p(e,"P",{"data-svelte-h":!0}),o(Ga)!=="svelte-1axcw5l"&&(Ga.innerHTML=uj),MJ=n(e),rJ=p(e,"HR",{}),TJ=n(e),Za=p(e,"A",{id:!0,class:!0}),J(Za).forEach(l),mJ=n(e),M(Qa.$$.fragment,e),yJ=n(e),Ba=p(e,"P",{"data-svelte-h":!0}),o(Ba)!=="svelte-1axcw5l"&&(Ba.innerHTML=wj),JJ=n(e),Aa=p(e,"TABLE",{"data-svelte-h":!0}),o(Aa)!=="svelte-flnl7b"&&(Aa.innerHTML=jj),hJ=n(e),uJ=p(e,"HR",{}),wJ=n(e),va=p(e,"P",{}),J(va).forEach(l),this.h()},h(){d(w,"name","hf:doc:metadata"),d(w,"content",Gj),d(j,"id","module_pipelines"),d(j,"class","group"),d(g,"id","module_pipelines.Pipeline"),d(g,"class","group"),d(Q,"id","new_module_pipelines.Pipeline_new"),d(Q,"class","group"),d(v,"id","module_pipelines.Pipeline+dispose"),d(v,"class","group"),d($,"id","module_pipelines.Pipeline+_call"),d($,"class","group"),d(H,"id","module_pipelines.TextClassificationPipeline"),d(H,"class","group"),d(ee,"id","module_pipelines.TextClassificationPipeline+_call"),d(ee,"class","group"),d(ne,"id","module_pipelines.TokenClassificationPipeline"),d(ne,"class","group"),d(Te,"id","module_pipelines.TokenClassificationPipeline+_call"),d(Te,"class","group"),d(ue,"id","module_pipelines.QuestionAnsweringPipeline"),d(ue,"class","group"),d(xe,"id","module_pipelines.QuestionAnsweringPipeline+_call"),d(xe,"class","group"),d(Ge,"id","module_pipelines.FillMaskPipeline"),d(Ge,"class","group"),d(Ye,"id","module_pipelines.FillMaskPipeline+_call"),d(Ye,"class","group"),d(Ee,"id","module_pipelines.Text2TextGenerationPipeline"),d(Ee,"class","group"),d(Le,"id","module_pipelines.Text2TextGenerationPipeline+_call"),d(Le,"class","group"),d(et,"id","module_pipelines.SummarizationPipeline"),d(et,"class","group"),d(at,"id","module_pipelines.TranslationPipeline"),d(at,"class","group"),d(wt,"id","module_pipelines.TextGenerationPipeline"),d(wt,"class","group"),d(Gt,"id","module_pipelines.TextGenerationPipeline+_call"),d(Gt,"class","group"),d(Nt,"id","module_pipelines.ZeroShotClassificationPipeline"),d(Nt,"class","group"),d(zt,"id","new_module_pipelines.ZeroShotClassificationPipeline_new"),d(zt,"class","group"),d(Xt,"id","module_pipelines.ZeroShotClassificationPipeline+_call"),d(Xt,"class","group"),d(qt,"id","module_pipelines.FeatureExtractionPipeline"),d(qt,"class","group"),d(pl,"id","module_pipelines.FeatureExtractionPipeline+_call"),d(pl,"class","group"),d(rl,"id","module_pipelines.AudioClassificationPipeline"),d(rl,"class","group"),d(Ul,"id","new_module_pipelines.AudioClassificationPipeline_new"),d(Ul,"class","group"),d(Cl,"id","module_pipelines.AudioClassificationPipeline+_call"),d(Cl,"class","group"),d(Zl,"id","module_pipelines.ZeroShotAudioClassificationPipeline"),d(Zl,"class","group"),d(Yl,"id","new_module_pipelines.ZeroShotAudioClassificationPipeline_new"),d(Yl,"class","group"),d(Vl,"id","module_pipelines.ZeroShotAudioClassificationPipeline+_call"),d(Vl,"class","group"),d(Sl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline"),d(Sl,"class","group"),d(ds,"id","new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"),d(ds,"class","group"),d(Ts,"id","module_pipelines.AutomaticSpeechRecognitionPipeline+_call"),d(Ts,"class","group"),d(us,"id","module_pipelines.ImageToTextPipeline"),d(us,"class","group"),d(Is,"id","new_module_pipelines.ImageToTextPipeline_new"),d(Is,"class","group"),d(Qs,"id","module_pipelines.ImageToTextPipeline+_call"),d(Qs,"class","group"),d(_s,"id","module_pipelines.ImageClassificationPipeline"),d(_s,"class","group"),d(Xs,"id","new_module_pipelines.ImageClassificationPipeline_new"),d(Xs,"class","group"),d(qs,"id","module_pipelines.ImageClassificationPipeline+_call"),d(qs,"class","group"),d(li,"id","module_pipelines.ImageSegmentationPipeline"),d(li,"class","group"),d(di,"id","new_module_pipelines.ImageSegmentationPipeline_new"),d(di,"class","group"),d(Ti,"id","module_pipelines.ImageSegmentationPipeline+_call"),d(Ti,"class","group"),d(ui,"id","module_pipelines.ZeroShotImageClassificationPipeline"),d(ui,"class","group"),d(Ci,"id","new_module_pipelines.ZeroShotImageClassificationPipeline_new"),d(Ci,"class","group"),d(Gi,"id","module_pipelines.ZeroShotImageClassificationPipeline+_call"),d(Gi,"class","group"),d(Ni,"id","module_pipelines.ObjectDetectionPipeline"),d(Ni,"class","group"),d(Vi,"id","new_module_pipelines.ObjectDetectionPipeline_new"),d(Vi,"class","group"),d(Wi,"id","module_pipelines.ObjectDetectionPipeline+_call"),d(Wi,"class","group"),d(Fi,"id","module_pipelines.ZeroShotObjectDetectionPipeline"),d(Fi,"class","group"),d(an,"id","new_module_pipelines.ZeroShotObjectDetectionPipeline_new"),d(an,"class","group"),d(cn,"id","module_pipelines.ZeroShotObjectDetectionPipeline+_call"),d(cn,"class","group"),d(yn,"id","module_pipelines.DocumentQuestionAnsweringPipeline"),d(yn,"class","group"),d(fn,"id","new_module_pipelines.DocumentQuestionAnsweringPipeline_new"),d(fn,"class","group"),d(gn,"id","module_pipelines.DocumentQuestionAnsweringPipeline+_call"),d(gn,"class","group"),d(Qn,"id","module_pipelines.TextToAudioPipeline"),d(Qn,"class","group"),d(Pn,"id","new_module_pipelines.TextToAudioPipeline_new"),d(Pn,"class","group"),d(Hn,"id","module_pipelines.TextToAudioPipeline+_call"),d(Hn,"class","group"),d(Dn,"id","module_pipelines.ImageToImagePipeline"),d(Dn,"class","group"),d(ta,"id","module_pipelines.ImageToImagePipeline+_call"),d(ta,"class","group"),d(aa,"id","module_pipelines.DepthEstimationPipeline"),d(aa,"class","group"),d(ra,"id","module_pipelines.DepthEstimationPipeline+_call"),d(ra,"class","group"),d(ha,"id","module_pipelines.pipeline"),d(ha,"class","group"),d(ba,"id","module_pipelines..QuestionAnsweringResult"),d(ba,"class","group"),d(Ia,"id","module_pipelines..QuestionAnsweringReturnType"),d(Ia,"class","group"),d(Za,"id","module_pipelines..ChunkCallback"),d(Za,"class","group")},m(e,t){Ij(document.head,w),s(e,_a,t),s(e,Na,t),s(e,Ya,t),s(e,j,t),s(e,Ra,t),r(U,e,t),s(e,$a,t),s(e,f,t),s(e,Pa,t),s(e,b,t),s(e,Va,t),r(x,e,t),s(e,Ea,t),s(e,C,t),s(e,za,t),s(e,Ha,t),s(e,Wa,t),s(e,g,t),s(e,Sa,t),r(I,e,t),s(e,Xa,t),s(e,k,t),s(e,La,t),s(e,G,t),s(e,Da,t),s(e,Z,t),s(e,Fa,t),s(e,qa,t),s(e,Oa,t),s(e,Q,t),s(e,Ka,t),r(B,e,t),s(e,ep,t),s(e,A,t),s(e,tp,t),s(e,N,t),s(e,lp,t),s(e,sp,t),s(e,ip,t),s(e,v,t),s(e,np,t),r(_,e,t),s(e,ap,t),s(e,Y,t),s(e,pp,t),s(e,R,t),s(e,op,t),s(e,dp,t),s(e,cp,t),s(e,$,t),s(e,Mp,t),r(P,e,t),s(e,rp,t),s(e,V,t),s(e,Tp,t),s(e,E,t),s(e,mp,t),s(e,z,t),s(e,yp,t),s(e,Jp,t),s(e,hp,t),s(e,H,t),s(e,up,t),r(W,e,t),s(e,wp,t),s(e,S,t),s(e,jp,t),s(e,X,t),s(e,Up,t),r(L,e,t),s(e,fp,t),s(e,D,t),s(e,bp,t),r(F,e,t),s(e,xp,t),s(e,q,t),s(e,Cp,t),r(O,e,t),s(e,gp,t),s(e,K,t),s(e,Ip,t),s(e,kp,t),s(e,Gp,t),s(e,ee,t),s(e,Zp,t),r(te,e,t),s(e,Qp,t),s(e,le,t),s(e,Bp,t),s(e,se,t),s(e,Ap,t),s(e,ie,t),s(e,Np,t),s(e,vp,t),s(e,_p,t),s(e,ne,t),s(e,Yp,t),r(ae,e,t),s(e,Rp,t),s(e,pe,t),s(e,$p,t),s(e,oe,t),s(e,Pp,t),r(de,e,t),s(e,Vp,t),s(e,ce,t),s(e,Ep,t),r(Me,e,t),s(e,zp,t),s(e,re,t),s(e,Hp,t),s(e,Wp,t),s(e,Sp,t),s(e,Te,t),s(e,Xp,t),r(me,e,t),s(e,Lp,t),s(e,ye,t),s(e,Dp,t),s(e,Je,t),s(e,Fp,t),s(e,he,t),s(e,qp,t),s(e,Op,t),s(e,Kp,t),s(e,ue,t),s(e,eo,t),r(we,e,t),s(e,to,t),s(e,je,t),s(e,lo,t),s(e,Ue,t),s(e,so,t),r(fe,e,t),s(e,io,t),s(e,be,t),s(e,no,t),s(e,ao,t),s(e,po,t),s(e,xe,t),s(e,oo,t),r(Ce,e,t),s(e,co,t),s(e,ge,t),s(e,Mo,t),s(e,Ie,t),s(e,ro,t),s(e,ke,t),s(e,To,t),s(e,mo,t),s(e,yo,t),s(e,Ge,t),s(e,Jo,t),r(Ze,e,t),s(e,ho,t),s(e,Qe,t),s(e,uo,t),s(e,Be,t),s(e,wo,t),r(Ae,e,t),s(e,jo,t),s(e,Ne,t),s(e,Uo,t),r(ve,e,t),s(e,fo,t),s(e,_e,t),s(e,bo,t),s(e,xo,t),s(e,Co,t),s(e,Ye,t),s(e,go,t),r(Re,e,t),s(e,Io,t),s(e,$e,t),s(e,ko,t),s(e,Pe,t),s(e,Go,t),s(e,Ve,t),s(e,Zo,t),s(e,Qo,t),s(e,Bo,t),s(e,Ee,t),s(e,Ao,t),r(ze,e,t),s(e,No,t),s(e,He,t),s(e,vo,t),s(e,We,t),s(e,_o,t),r(Se,e,t),s(e,Yo,t),s(e,Xe,t),s(e,Ro,t),s(e,$o,t),s(e,Po,t),s(e,Le,t),s(e,Vo,t),r(De,e,t),s(e,Eo,t),s(e,Fe,t),s(e,zo,t),s(e,qe,t),s(e,Ho,t),s(e,Oe,t),s(e,Wo,t),s(e,Ke,t),s(e,So,t),s(e,Xo,t),s(e,Lo,t),s(e,et,t),s(e,Do,t),r(tt,e,t),s(e,Fo,t),s(e,lt,t),s(e,qo,t),s(e,st,t),s(e,Oo,t),r(it,e,t),s(e,Ko,t),s(e,nt,t),s(e,ed,t),s(e,td,t),s(e,ld,t),s(e,at,t),s(e,sd,t),r(pt,e,t),s(e,id,t),s(e,ot,t),s(e,nd,t),s(e,dt,t),s(e,ad,t),s(e,ct,t),s(e,pd,t),r(Mt,e,t),s(e,od,t),s(e,rt,t),s(e,dd,t),s(e,Tt,t),s(e,cd,t),r(mt,e,t),s(e,Md,t),s(e,yt,t),s(e,rd,t),s(e,Jt,t),s(e,Td,t),r(ht,e,t),s(e,md,t),s(e,ut,t),s(e,yd,t),s(e,Jd,t),s(e,hd,t),s(e,wt,t),s(e,ud,t),r(jt,e,t),s(e,wd,t),s(e,Ut,t),s(e,jd,t),s(e,ft,t),s(e,Ud,t),r(bt,e,t),s(e,fd,t),s(e,xt,t),s(e,bd,t),r(Ct,e,t),s(e,xd,t),s(e,gt,t),s(e,Cd,t),r(It,e,t),s(e,gd,t),s(e,kt,t),s(e,Id,t),s(e,kd,t),s(e,Gd,t),s(e,Gt,t),s(e,Zd,t),r(Zt,e,t),s(e,Qd,t),s(e,Qt,t),s(e,Bd,t),s(e,Bt,t),s(e,Ad,t),s(e,At,t),s(e,Nd,t),s(e,vd,t),s(e,_d,t),s(e,Nt,t),s(e,Yd,t),r(vt,e,t),s(e,Rd,t),s(e,_t,t),s(e,$d,t),s(e,Yt,t),s(e,Pd,t),r(Rt,e,t),s(e,Vd,t),s(e,$t,t),s(e,Ed,t),r(Pt,e,t),s(e,zd,t),s(e,Vt,t),s(e,Hd,t),s(e,Et,t),s(e,Wd,t),s(e,Sd,t),s(e,Xd,t),s(e,zt,t),s(e,Ld,t),r(Ht,e,t),s(e,Dd,t),s(e,Wt,t),s(e,Fd,t),s(e,St,t),s(e,qd,t),s(e,Od,t),s(e,Kd,t),s(e,Xt,t),s(e,ec,t),r(Lt,e,t),s(e,tc,t),s(e,Dt,t),s(e,lc,t),s(e,Ft,t),s(e,sc,t),s(e,ic,t),s(e,nc,t),s(e,qt,t),s(e,ac,t),r(Ot,e,t),s(e,pc,t),s(e,Kt,t),s(e,oc,t),s(e,el,t),s(e,dc,t),r(tl,e,t),s(e,cc,t),s(e,ll,t),s(e,Mc,t),r(sl,e,t),s(e,rc,t),s(e,il,t),s(e,Tc,t),r(nl,e,t),s(e,mc,t),s(e,al,t),s(e,yc,t),s(e,Jc,t),s(e,hc,t),s(e,pl,t),s(e,uc,t),r(ol,e,t),s(e,wc,t),s(e,dl,t),s(e,jc,t),s(e,cl,t),s(e,Uc,t),s(e,Ml,t),s(e,fc,t),s(e,bc,t),s(e,xc,t),s(e,rl,t),s(e,Cc,t),r(Tl,e,t),s(e,gc,t),s(e,ml,t),s(e,Ic,t),s(e,yl,t),s(e,kc,t),r(Jl,e,t),s(e,Gc,t),s(e,hl,t),s(e,Zc,t),r(ul,e,t),s(e,Qc,t),s(e,wl,t),s(e,Bc,t),s(e,jl,t),s(e,Ac,t),s(e,Nc,t),s(e,vc,t),s(e,Ul,t),s(e,_c,t),r(fl,e,t),s(e,Yc,t),s(e,bl,t),s(e,Rc,t),s(e,xl,t),s(e,$c,t),s(e,Pc,t),s(e,Vc,t),s(e,Cl,t),s(e,Ec,t),r(gl,e,t),s(e,zc,t),s(e,Il,t),s(e,Hc,t),s(e,kl,t),s(e,Wc,t),s(e,Gl,t),s(e,Sc,t),s(e,Xc,t),s(e,Lc,t),s(e,Zl,t),s(e,Dc,t),r(Ql,e,t),s(e,Fc,t),s(e,Bl,t),s(e,qc,t),s(e,Al,t),s(e,Oc,t),r(Nl,e,t),s(e,Kc,t),s(e,vl,t),s(e,eM,t),s(e,_l,t),s(e,tM,t),s(e,lM,t),s(e,sM,t),s(e,Yl,t),s(e,iM,t),r(Rl,e,t),s(e,nM,t),s(e,$l,t),s(e,aM,t),s(e,Pl,t),s(e,pM,t),s(e,oM,t),s(e,dM,t),s(e,Vl,t),s(e,cM,t),r(El,e,t),s(e,MM,t),s(e,zl,t),s(e,rM,t),s(e,Hl,t),s(e,TM,t),s(e,Wl,t),s(e,mM,t),s(e,yM,t),s(e,JM,t),s(e,Sl,t),s(e,hM,t),r(Xl,e,t),s(e,uM,t),s(e,Ll,t),s(e,wM,t),s(e,Dl,t),s(e,jM,t),r(Fl,e,t),s(e,UM,t),s(e,ql,t),s(e,fM,t),r(Ol,e,t),s(e,bM,t),s(e,Kl,t),s(e,xM,t),r(es,e,t),s(e,CM,t),s(e,ts,t),s(e,gM,t),r(ls,e,t),s(e,IM,t),s(e,ss,t),s(e,kM,t),r(is,e,t),s(e,GM,t),s(e,ns,t),s(e,ZM,t),r(as,e,t),s(e,QM,t),s(e,ps,t),s(e,BM,t),s(e,os,t),s(e,AM,t),s(e,NM,t),s(e,vM,t),s(e,ds,t),s(e,_M,t),r(cs,e,t),s(e,YM,t),s(e,Ms,t),s(e,RM,t),s(e,rs,t),s(e,$M,t),s(e,PM,t),s(e,VM,t),s(e,Ts,t),s(e,EM,t),r(ms,e,t),s(e,zM,t),s(e,ys,t),s(e,HM,t),s(e,Js,t),s(e,WM,t),s(e,hs,t),s(e,SM,t),s(e,XM,t),s(e,LM,t),s(e,us,t),s(e,DM,t),r(ws,e,t),s(e,FM,t),s(e,js,t),s(e,qM,t),s(e,Us,t),s(e,OM,t),r(fs,e,t),s(e,KM,t),s(e,bs,t),s(e,er,t),r(xs,e,t),s(e,tr,t),s(e,Cs,t),s(e,lr,t),s(e,gs,t),s(e,sr,t),s(e,ir,t),s(e,nr,t),s(e,Is,t),s(e,ar,t),r(ks,e,t),s(e,pr,t),s(e,Gs,t),s(e,or,t),s(e,Zs,t),s(e,dr,t),s(e,cr,t),s(e,Mr,t),s(e,Qs,t),s(e,rr,t),r(Bs,e,t),s(e,Tr,t),s(e,As,t),s(e,mr,t),s(e,Ns,t),s(e,yr,t),s(e,vs,t),s(e,Jr,t),s(e,hr,t),s(e,ur,t),s(e,_s,t),s(e,wr,t),r(Ys,e,t),s(e,jr,t),s(e,Rs,t),s(e,Ur,t),s(e,$s,t),s(e,fr,t),r(Ps,e,t),s(e,br,t),s(e,Vs,t),s(e,xr,t),r(Es,e,t),s(e,Cr,t),s(e,zs,t),s(e,gr,t),r(Hs,e,t),s(e,Ir,t),s(e,Ws,t),s(e,kr,t),s(e,Ss,t),s(e,Gr,t),s(e,Zr,t),s(e,Qr,t),s(e,Xs,t),s(e,Br,t),r(Ls,e,t),s(e,Ar,t),s(e,Ds,t),s(e,Nr,t),s(e,Fs,t),s(e,vr,t),s(e,_r,t),s(e,Yr,t),s(e,qs,t),s(e,Rr,t),r(Os,e,t),s(e,$r,t),s(e,Ks,t),s(e,Pr,t),s(e,ei,t),s(e,Vr,t),s(e,ti,t),s(e,Er,t),s(e,zr,t),s(e,Hr,t),s(e,li,t),s(e,Wr,t),r(si,e,t),s(e,Sr,t),s(e,ii,t),s(e,Xr,t),s(e,ni,t),s(e,Lr,t),r(ai,e,t),s(e,Dr,t),s(e,pi,t),s(e,Fr,t),s(e,oi,t),s(e,qr,t),s(e,Or,t),s(e,Kr,t),s(e,di,t),s(e,eT,t),r(ci,e,t),s(e,tT,t),s(e,Mi,t),s(e,lT,t),s(e,ri,t),s(e,sT,t),s(e,iT,t),s(e,nT,t),s(e,Ti,t),s(e,aT,t),r(mi,e,t),s(e,pT,t),s(e,yi,t),s(e,oT,t),s(e,Ji,t),s(e,dT,t),s(e,hi,t),s(e,cT,t),s(e,MT,t),s(e,rT,t),s(e,ui,t),s(e,TT,t),r(wi,e,t),s(e,mT,t),s(e,ji,t),s(e,yT,t),s(e,Ui,t),s(e,JT,t),r(fi,e,t),s(e,hT,t),s(e,bi,t),s(e,uT,t),s(e,xi,t),s(e,wT,t),s(e,jT,t),s(e,UT,t),s(e,Ci,t),s(e,fT,t),r(gi,e,t),s(e,bT,t),s(e,Ii,t),s(e,xT,t),s(e,ki,t),s(e,CT,t),s(e,gT,t),s(e,IT,t),s(e,Gi,t),s(e,kT,t),r(Zi,e,t),s(e,GT,t),s(e,Qi,t),s(e,ZT,t),s(e,Bi,t),s(e,QT,t),s(e,Ai,t),s(e,BT,t),s(e,AT,t),s(e,NT,t),s(e,Ni,t),s(e,vT,t),r(vi,e,t),s(e,_T,t),s(e,_i,t),s(e,YT,t),s(e,Yi,t),s(e,RT,t),r(Ri,e,t),s(e,$T,t),s(e,$i,t),s(e,PT,t),s(e,Pi,t),s(e,VT,t),s(e,ET,t),s(e,zT,t),s(e,Vi,t),s(e,HT,t),r(Ei,e,t),s(e,WT,t),s(e,zi,t),s(e,ST,t),s(e,Hi,t),s(e,XT,t),s(e,LT,t),s(e,DT,t),s(e,Wi,t),s(e,FT,t),r(Si,e,t),s(e,qT,t),s(e,Xi,t),s(e,OT,t),s(e,Li,t),s(e,KT,t),s(e,Di,t),s(e,em,t),s(e,tm,t),s(e,lm,t),s(e,Fi,t),s(e,sm,t),r(qi,e,t),s(e,im,t),s(e,Oi,t),s(e,nm,t),s(e,Ki,t),s(e,am,t),r(en,e,t),s(e,pm,t),s(e,tn,t),s(e,om,t),r(ln,e,t),s(e,dm,t),s(e,sn,t),s(e,cm,t),s(e,nn,t),s(e,Mm,t),s(e,rm,t),s(e,Tm,t),s(e,an,t),s(e,mm,t),r(pn,e,t),s(e,ym,t),s(e,on,t),s(e,Jm,t),s(e,dn,t),s(e,hm,t),s(e,um,t),s(e,wm,t),s(e,cn,t),s(e,jm,t),r(Mn,e,t),s(e,Um,t),s(e,rn,t),s(e,fm,t),s(e,Tn,t),s(e,bm,t),s(e,mn,t),s(e,xm,t),s(e,Cm,t),s(e,gm,t),s(e,yn,t),s(e,Im,t),r(Jn,e,t),s(e,km,t),s(e,hn,t),s(e,Gm,t),s(e,un,t),s(e,Zm,t),r(wn,e,t),s(e,Qm,t),s(e,jn,t),s(e,Bm,t),s(e,Un,t),s(e,Am,t),s(e,Nm,t),s(e,vm,t),s(e,fn,t),s(e,_m,t),r(bn,e,t),s(e,Ym,t),s(e,xn,t),s(e,Rm,t),s(e,Cn,t),s(e,$m,t),s(e,Pm,t),s(e,Vm,t),s(e,gn,t),s(e,Em,t),r(In,e,t),s(e,zm,t),s(e,kn,t),s(e,Hm,t),s(e,Gn,t),s(e,Wm,t),s(e,Zn,t),s(e,Sm,t),s(e,Xm,t),s(e,Lm,t),s(e,Qn,t),s(e,Dm,t),r(Bn,e,t),s(e,Fm,t),s(e,An,t),s(e,qm,t),s(e,Nn,t),s(e,Om,t),r(vn,e,t),s(e,Km,t),s(e,_n,t),s(e,ey,t),r(Yn,e,t),s(e,ty,t),s(e,Rn,t),s(e,ly,t),s(e,$n,t),s(e,sy,t),s(e,iy,t),s(e,ny,t),s(e,Pn,t),s(e,ay,t),r(Vn,e,t),s(e,py,t),s(e,En,t),s(e,oy,t),s(e,zn,t),s(e,dy,t),s(e,cy,t),s(e,My,t),s(e,Hn,t),s(e,ry,t),r(Wn,e,t),s(e,Ty,t),s(e,Sn,t),s(e,my,t),s(e,Xn,t),s(e,yy,t),s(e,Ln,t),s(e,Jy,t),s(e,hy,t),s(e,uy,t),s(e,Dn,t),s(e,wy,t),r(Fn,e,t),s(e,jy,t),s(e,qn,t),s(e,Uy,t),s(e,On,t),s(e,fy,t),r(Kn,e,t),s(e,by,t),s(e,ea,t),s(e,xy,t),s(e,Cy,t),s(e,gy,t),s(e,ta,t),s(e,Iy,t),r(la,e,t),s(e,ky,t),s(e,sa,t),s(e,Gy,t),s(e,ia,t),s(e,Zy,t),s(e,na,t),s(e,Qy,t),s(e,By,t),s(e,Ay,t),s(e,aa,t),s(e,Ny,t),r(pa,e,t),s(e,vy,t),s(e,oa,t),s(e,_y,t),s(e,da,t),s(e,Yy,t),r(ca,e,t),s(e,Ry,t),s(e,Ma,t),s(e,$y,t),s(e,Py,t),s(e,Vy,t),s(e,ra,t),s(e,Ey,t),r(Ta,e,t),s(e,zy,t),s(e,ma,t),s(e,Hy,t),s(e,ya,t),s(e,Wy,t),s(e,Ja,t),s(e,Sy,t),s(e,Xy,t),s(e,Ly,t),s(e,ha,t),s(e,Dy,t),r(ua,e,t),s(e,Fy,t),s(e,wa,t),s(e,qy,t),s(e,ja,t),s(e,Oy,t),s(e,Ua,t),s(e,Ky,t),s(e,fa,t),s(e,eJ,t),s(e,tJ,t),s(e,lJ,t),s(e,ba,t),s(e,sJ,t),r(xa,e,t),s(e,iJ,t),s(e,Ca,t),s(e,nJ,t),s(e,ga,t),s(e,aJ,t),s(e,pJ,t),s(e,oJ,t),s(e,Ia,t),s(e,dJ,t),r(ka,e,t),s(e,cJ,t),s(e,Ga,t),s(e,MJ,t),s(e,rJ,t),s(e,TJ,t),s(e,Za,t),s(e,mJ,t),r(Qa,e,t),s(e,yJ,t),s(e,Ba,t),s(e,JJ,t),s(e,Aa,t),s(e,hJ,t),s(e,uJ,t),s(e,wJ,t),s(e,va,t),jJ=!0},p:fj,i(e){jJ||(T(U.$$.fragment,e),T(x.$$.fragment,e),T(I.$$.fragment,e),T(B.$$.fragment,e),T(_.$$.fragment,e),T(P.$$.fragment,e),T(W.$$.fragment,e),T(L.$$.fragment,e),T(F.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(de.$$.fragment,e),T(Me.$$.fragment,e),T(me.$$.fragment,e),T(we.$$.fragment,e),T(fe.$$.fragment,e),T(Ce.$$.fragment,e),T(Ze.$$.fragment,e),T(Ae.$$.fragment,e),T(ve.$$.fragment,e),T(Re.$$.fragment,e),T(ze.$$.fragment,e),T(Se.$$.fragment,e),T(De.$$.fragment,e),T(tt.$$.fragment,e),T(it.$$.fragment,e),T(pt.$$.fragment,e),T(Mt.$$.fragment,e),T(mt.$$.fragment,e),T(ht.$$.fragment,e),T(jt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(It.$$.fragment,e),T(Zt.$$.fragment,e),T(vt.$$.fragment,e),T(Rt.$$.fragment,e),T(Pt.$$.fragment,e),T(Ht.$$.fragment,e),T(Lt.$$.fragment,e),T(Ot.$$.fragment,e),T(tl.$$.fragment,e),T(sl.$$.fragment,e),T(nl.$$.fragment,e),T(ol.$$.fragment,e),T(Tl.$$.fragment,e),T(Jl.$$.fragment,e),T(ul.$$.fragment,e),T(fl.$$.fragment,e),T(gl.$$.fragment,e),T(Ql.$$.fragment,e),T(Nl.$$.fragment,e),T(Rl.$$.fragment,e),T(El.$$.fragment,e),T(Xl.$$.fragment,e),T(Fl.$$.fragment,e),T(Ol.$$.fragment,e),T(es.$$.fragment,e),T(ls.$$.fragment,e),T(is.$$.fragment,e),T(as.$$.fragment,e),T(cs.$$.fragment,e),T(ms.$$.fragment,e),T(ws.$$.fragment,e),T(fs.$$.fragment,e),T(xs.$$.fragment,e),T(ks.$$.fragment,e),T(Bs.$$.fragment,e),T(Ys.$$.fragment,e),T(Ps.$$.fragment,e),T(Es.$$.fragment,e),T(Hs.$$.fragment,e),T(Ls.$$.fragment,e),T(Os.$$.fragment,e),T(si.$$.fragment,e),T(ai.$$.fragment,e),T(ci.$$.fragment,e),T(mi.$$.fragment,e),T(wi.$$.fragment,e),T(fi.$$.fragment,e),T(gi.$$.fragment,e),T(Zi.$$.fragment,e),T(vi.$$.fragment,e),T(Ri.$$.fragment,e),T(Ei.$$.fragment,e),T(Si.$$.fragment,e),T(qi.$$.fragment,e),T(en.$$.fragment,e),T(ln.$$.fragment,e),T(pn.$$.fragment,e),T(Mn.$$.fragment,e),T(Jn.$$.fragment,e),T(wn.$$.fragment,e),T(bn.$$.fragment,e),T(In.$$.fragment,e),T(Bn.$$.fragment,e),T(vn.$$.fragment,e),T(Yn.$$.fragment,e),T(Vn.$$.fragment,e),T(Wn.$$.fragment,e),T(Fn.$$.fragment,e),T(Kn.$$.fragment,e),T(la.$$.fragment,e),T(pa.$$.fragment,e),T(ca.$$.fragment,e),T(Ta.$$.fragment,e),T(ua.$$.fragment,e),T(xa.$$.fragment,e),T(ka.$$.fragment,e),T(Qa.$$.fragment,e),jJ=!0)},o(e){m(U.$$.fragment,e),m(x.$$.fragment,e),m(I.$$.fragment,e),m(B.$$.fragment,e),m(_.$$.fragment,e),m(P.$$.fragment,e),m(W.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(we.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m(Ae.$$.fragment,e),m(ve.$$.fragment,e),m(Re.$$.fragment,e),m(ze.$$.fragment,e),m(Se.$$.fragment,e),m(De.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(Mt.$$.fragment,e),m(mt.$$.fragment,e),m(ht.$$.fragment,e),m(jt.$$.fragment,e),m(bt.$$.fragment,e),m(Ct.$$.fragment,e),m(It.$$.fragment,e),m(Zt.$$.fragment,e),m(vt.$$.fragment,e),m(Rt.$$.fragment,e),m(Pt.$$.fragment,e),m(Ht.$$.fragment,e),m(Lt.$$.fragment,e),m(Ot.$$.fragment,e),m(tl.$$.fragment,e),m(sl.$$.fragment,e),m(nl.$$.fragment,e),m(ol.$$.fragment,e),m(Tl.$$.fragment,e),m(Jl.$$.fragment,e),m(ul.$$.fragment,e),m(fl.$$.fragment,e),m(gl.$$.fragment,e),m(Ql.$$.fragment,e),m(Nl.$$.fragment,e),m(Rl.$$.fragment,e),m(El.$$.fragment,e),m(Xl.$$.fragment,e),m(Fl.$$.fragment,e),m(Ol.$$.fragment,e),m(es.$$.fragment,e),m(ls.$$.fragment,e),m(is.$$.fragment,e),m(as.$$.fragment,e),m(cs.$$.fragment,e),m(ms.$$.fragment,e),m(ws.$$.fragment,e),m(fs.$$.fragment,e),m(xs.$$.fragment,e),m(ks.$$.fragment,e),m(Bs.$$.fragment,e),m(Ys.$$.fragment,e),m(Ps.$$.fragment,e),m(Es.$$.fragment,e),m(Hs.$$.fragment,e),m(Ls.$$.fragment,e),m(Os.$$.fragment,e),m(si.$$.fragment,e),m(ai.$$.fragment,e),m(ci.$$.fragment,e),m(mi.$$.fragment,e),m(wi.$$.fragment,e),m(fi.$$.fragment,e),m(gi.$$.fragment,e),m(Zi.$$.fragment,e),m(vi.$$.fragment,e),m(Ri.$$.fragment,e),m(Ei.$$.fragment,e),m(Si.$$.fragment,e),m(qi.$$.fragment,e),m(en.$$.fragment,e),m(ln.$$.fragment,e),m(pn.$$.fragment,e),m(Mn.$$.fragment,e),m(Jn.$$.fragment,e),m(wn.$$.fragment,e),m(bn.$$.fragment,e),m(In.$$.fragment,e),m(Bn.$$.fragment,e),m(vn.$$.fragment,e),m(Yn.$$.fragment,e),m(Vn.$$.fragment,e),m(Wn.$$.fragment,e),m(Fn.$$.fragment,e),m(Kn.$$.fragment,e),m(la.$$.fragment,e),m(pa.$$.fragment,e),m(ca.$$.fragment,e),m(Ta.$$.fragment,e),m(ua.$$.fragment,e),m(xa.$$.fragment,e),m(ka.$$.fragment,e),m(Qa.$$.fragment,e),jJ=!1},d(e){e&&(l(_a),l(Na),l(Ya),l(j),l(Ra),l($a),l(f),l(Pa),l(b),l(Va),l(Ea),l(C),l(za),l(Ha),l(Wa),l(g),l(Sa),l(Xa),l(k),l(La),l(G),l(Da),l(Z),l(Fa),l(qa),l(Oa),l(Q),l(Ka),l(ep),l(A),l(tp),l(N),l(lp),l(sp),l(ip),l(v),l(np),l(ap),l(Y),l(pp),l(R),l(op),l(dp),l(cp),l($),l(Mp),l(rp),l(V),l(Tp),l(E),l(mp),l(z),l(yp),l(Jp),l(hp),l(H),l(up),l(wp),l(S),l(jp),l(X),l(Up),l(fp),l(D),l(bp),l(xp),l(q),l(Cp),l(gp),l(K),l(Ip),l(kp),l(Gp),l(ee),l(Zp),l(Qp),l(le),l(Bp),l(se),l(Ap),l(ie),l(Np),l(vp),l(_p),l(ne),l(Yp),l(Rp),l(pe),l($p),l(oe),l(Pp),l(Vp),l(ce),l(Ep),l(zp),l(re),l(Hp),l(Wp),l(Sp),l(Te),l(Xp),l(Lp),l(ye),l(Dp),l(Je),l(Fp),l(he),l(qp),l(Op),l(Kp),l(ue),l(eo),l(to),l(je),l(lo),l(Ue),l(so),l(io),l(be),l(no),l(ao),l(po),l(xe),l(oo),l(co),l(ge),l(Mo),l(Ie),l(ro),l(ke),l(To),l(mo),l(yo),l(Ge),l(Jo),l(ho),l(Qe),l(uo),l(Be),l(wo),l(jo),l(Ne),l(Uo),l(fo),l(_e),l(bo),l(xo),l(Co),l(Ye),l(go),l(Io),l($e),l(ko),l(Pe),l(Go),l(Ve),l(Zo),l(Qo),l(Bo),l(Ee),l(Ao),l(No),l(He),l(vo),l(We),l(_o),l(Yo),l(Xe),l(Ro),l($o),l(Po),l(Le),l(Vo),l(Eo),l(Fe),l(zo),l(qe),l(Ho),l(Oe),l(Wo),l(Ke),l(So),l(Xo),l(Lo),l(et),l(Do),l(Fo),l(lt),l(qo),l(st),l(Oo),l(Ko),l(nt),l(ed),l(td),l(ld),l(at),l(sd),l(id),l(ot),l(nd),l(dt),l(ad),l(ct),l(pd),l(od),l(rt),l(dd),l(Tt),l(cd),l(Md),l(yt),l(rd),l(Jt),l(Td),l(md),l(ut),l(yd),l(Jd),l(hd),l(wt),l(ud),l(wd),l(Ut),l(jd),l(ft),l(Ud),l(fd),l(xt),l(bd),l(xd),l(gt),l(Cd),l(gd),l(kt),l(Id),l(kd),l(Gd),l(Gt),l(Zd),l(Qd),l(Qt),l(Bd),l(Bt),l(Ad),l(At),l(Nd),l(vd),l(_d),l(Nt),l(Yd),l(Rd),l(_t),l($d),l(Yt),l(Pd),l(Vd),l($t),l(Ed),l(zd),l(Vt),l(Hd),l(Et),l(Wd),l(Sd),l(Xd),l(zt),l(Ld),l(Dd),l(Wt),l(Fd),l(St),l(qd),l(Od),l(Kd),l(Xt),l(ec),l(tc),l(Dt),l(lc),l(Ft),l(sc),l(ic),l(nc),l(qt),l(ac),l(pc),l(Kt),l(oc),l(el),l(dc),l(cc),l(ll),l(Mc),l(rc),l(il),l(Tc),l(mc),l(al),l(yc),l(Jc),l(hc),l(pl),l(uc),l(wc),l(dl),l(jc),l(cl),l(Uc),l(Ml),l(fc),l(bc),l(xc),l(rl),l(Cc),l(gc),l(ml),l(Ic),l(yl),l(kc),l(Gc),l(hl),l(Zc),l(Qc),l(wl),l(Bc),l(jl),l(Ac),l(Nc),l(vc),l(Ul),l(_c),l(Yc),l(bl),l(Rc),l(xl),l($c),l(Pc),l(Vc),l(Cl),l(Ec),l(zc),l(Il),l(Hc),l(kl),l(Wc),l(Gl),l(Sc),l(Xc),l(Lc),l(Zl),l(Dc),l(Fc),l(Bl),l(qc),l(Al),l(Oc),l(Kc),l(vl),l(eM),l(_l),l(tM),l(lM),l(sM),l(Yl),l(iM),l(nM),l($l),l(aM),l(Pl),l(pM),l(oM),l(dM),l(Vl),l(cM),l(MM),l(zl),l(rM),l(Hl),l(TM),l(Wl),l(mM),l(yM),l(JM),l(Sl),l(hM),l(uM),l(Ll),l(wM),l(Dl),l(jM),l(UM),l(ql),l(fM),l(bM),l(Kl),l(xM),l(CM),l(ts),l(gM),l(IM),l(ss),l(kM),l(GM),l(ns),l(ZM),l(QM),l(ps),l(BM),l(os),l(AM),l(NM),l(vM),l(ds),l(_M),l(YM),l(Ms),l(RM),l(rs),l($M),l(PM),l(VM),l(Ts),l(EM),l(zM),l(ys),l(HM),l(Js),l(WM),l(hs),l(SM),l(XM),l(LM),l(us),l(DM),l(FM),l(js),l(qM),l(Us),l(OM),l(KM),l(bs),l(er),l(tr),l(Cs),l(lr),l(gs),l(sr),l(ir),l(nr),l(Is),l(ar),l(pr),l(Gs),l(or),l(Zs),l(dr),l(cr),l(Mr),l(Qs),l(rr),l(Tr),l(As),l(mr),l(Ns),l(yr),l(vs),l(Jr),l(hr),l(ur),l(_s),l(wr),l(jr),l(Rs),l(Ur),l($s),l(fr),l(br),l(Vs),l(xr),l(Cr),l(zs),l(gr),l(Ir),l(Ws),l(kr),l(Ss),l(Gr),l(Zr),l(Qr),l(Xs),l(Br),l(Ar),l(Ds),l(Nr),l(Fs),l(vr),l(_r),l(Yr),l(qs),l(Rr),l($r),l(Ks),l(Pr),l(ei),l(Vr),l(ti),l(Er),l(zr),l(Hr),l(li),l(Wr),l(Sr),l(ii),l(Xr),l(ni),l(Lr),l(Dr),l(pi),l(Fr),l(oi),l(qr),l(Or),l(Kr),l(di),l(eT),l(tT),l(Mi),l(lT),l(ri),l(sT),l(iT),l(nT),l(Ti),l(aT),l(pT),l(yi),l(oT),l(Ji),l(dT),l(hi),l(cT),l(MT),l(rT),l(ui),l(TT),l(mT),l(ji),l(yT),l(Ui),l(JT),l(hT),l(bi),l(uT),l(xi),l(wT),l(jT),l(UT),l(Ci),l(fT),l(bT),l(Ii),l(xT),l(ki),l(CT),l(gT),l(IT),l(Gi),l(kT),l(GT),l(Qi),l(ZT),l(Bi),l(QT),l(Ai),l(BT),l(AT),l(NT),l(Ni),l(vT),l(_T),l(_i),l(YT),l(Yi),l(RT),l($T),l($i),l(PT),l(Pi),l(VT),l(ET),l(zT),l(Vi),l(HT),l(WT),l(zi),l(ST),l(Hi),l(XT),l(LT),l(DT),l(Wi),l(FT),l(qT),l(Xi),l(OT),l(Li),l(KT),l(Di),l(em),l(tm),l(lm),l(Fi),l(sm),l(im),l(Oi),l(nm),l(Ki),l(am),l(pm),l(tn),l(om),l(dm),l(sn),l(cm),l(nn),l(Mm),l(rm),l(Tm),l(an),l(mm),l(ym),l(on),l(Jm),l(dn),l(hm),l(um),l(wm),l(cn),l(jm),l(Um),l(rn),l(fm),l(Tn),l(bm),l(mn),l(xm),l(Cm),l(gm),l(yn),l(Im),l(km),l(hn),l(Gm),l(un),l(Zm),l(Qm),l(jn),l(Bm),l(Un),l(Am),l(Nm),l(vm),l(fn),l(_m),l(Ym),l(xn),l(Rm),l(Cn),l($m),l(Pm),l(Vm),l(gn),l(Em),l(zm),l(kn),l(Hm),l(Gn),l(Wm),l(Zn),l(Sm),l(Xm),l(Lm),l(Qn),l(Dm),l(Fm),l(An),l(qm),l(Nn),l(Om),l(Km),l(_n),l(ey),l(ty),l(Rn),l(ly),l($n),l(sy),l(iy),l(ny),l(Pn),l(ay),l(py),l(En),l(oy),l(zn),l(dy),l(cy),l(My),l(Hn),l(ry),l(Ty),l(Sn),l(my),l(Xn),l(yy),l(Ln),l(Jy),l(hy),l(uy),l(Dn),l(wy),l(jy),l(qn),l(Uy),l(On),l(fy),l(by),l(ea),l(xy),l(Cy),l(gy),l(ta),l(Iy),l(ky),l(sa),l(Gy),l(ia),l(Zy),l(na),l(Qy),l(By),l(Ay),l(aa),l(Ny),l(vy),l(oa),l(_y),l(da),l(Yy),l(Ry),l(Ma),l($y),l(Py),l(Vy),l(ra),l(Ey),l(zy),l(ma),l(Hy),l(ya),l(Wy),l(Ja),l(Sy),l(Xy),l(Ly),l(ha),l(Dy),l(Fy),l(wa),l(qy),l(ja),l(Oy),l(Ua),l(Ky),l(fa),l(eJ),l(tJ),l(lJ),l(ba),l(sJ),l(iJ),l(Ca),l(nJ),l(ga),l(aJ),l(pJ),l(oJ),l(Ia),l(dJ),l(cJ),l(Ga),l(MJ),l(rJ),l(TJ),l(Za),l(mJ),l(yJ),l(Ba),l(JJ),l(Aa),l(hJ),l(uJ),l(wJ),l(va)),l(w),y(U,e),y(x,e),y(I,e),y(B,e),y(_,e),y(P,e),y(W,e),y(L,e),y(F,e),y(O,e),y(te,e),y(ae,e),y(de,e),y(Me,e),y(me,e),y(we,e),y(fe,e),y(Ce,e),y(Ze,e),y(Ae,e),y(ve,e),y(Re,e),y(ze,e),y(Se,e),y(De,e),y(tt,e),y(it,e),y(pt,e),y(Mt,e),y(mt,e),y(ht,e),y(jt,e),y(bt,e),y(Ct,e),y(It,e),y(Zt,e),y(vt,e),y(Rt,e),y(Pt,e),y(Ht,e),y(Lt,e),y(Ot,e),y(tl,e),y(sl,e),y(nl,e),y(ol,e),y(Tl,e),y(Jl,e),y(ul,e),y(fl,e),y(gl,e),y(Ql,e),y(Nl,e),y(Rl,e),y(El,e),y(Xl,e),y(Fl,e),y(Ol,e),y(es,e),y(ls,e),y(is,e),y(as,e),y(cs,e),y(ms,e),y(ws,e),y(fs,e),y(xs,e),y(ks,e),y(Bs,e),y(Ys,e),y(Ps,e),y(Es,e),y(Hs,e),y(Ls,e),y(Os,e),y(si,e),y(ai,e),y(ci,e),y(mi,e),y(wi,e),y(fi,e),y(gi,e),y(Zi,e),y(vi,e),y(Ri,e),y(Ei,e),y(Si,e),y(qi,e),y(en,e),y(ln,e),y(pn,e),y(Mn,e),y(Jn,e),y(wn,e),y(bn,e),y(In,e),y(Bn,e),y(vn,e),y(Yn,e),y(Vn,e),y(Wn,e),y(Fn,e),y(Kn,e),y(la,e),y(pa,e),y(ca,e),y(Ta,e),y(ua,e),y(xa,e),y(ka,e),y(Qa,e)}}}const Gj='{"title":"pipelines","local":"pipelines","sections":[{"title":"pipelines.Pipeline ⇐ <code> Callable </code>","local":"pipelinespipeline--code-callable-code","sections":[{"title":"new Pipeline(options)","local":"new-pipelineoptions","sections":[],"depth":3},{"title":"pipeline.dispose() ⇒ <code> Promise. < void > </code>","local":"pipelinedispose--code-promise--void--code","sections":[],"depth":3},{"title":"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>","local":"pipelinecalltexts-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextClassificationPipeline","local":"pipelinestextclassificationpipeline","sections":[{"title":"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TokenClassificationPipeline","local":"pipelinestokenclassificationpipeline","sections":[{"title":"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.QuestionAnsweringPipeline","local":"pipelinesquestionansweringpipeline","sections":[{"title":"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>","local":"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FillMaskPipeline","local":"pipelinesfillmaskpipeline","sections":[{"title":"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.Text2TextGenerationPipeline","local":"pipelinestext2textgenerationpipeline","sections":[{"title":"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>","local":"text2textgenerationpipelinecalltexts-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.SummarizationPipeline","local":"pipelinessummarizationpipeline","sections":[],"depth":2},{"title":"pipelines.TranslationPipeline","local":"pipelinestranslationpipeline","sections":[],"depth":2},{"title":"pipelines.TextGenerationPipeline","local":"pipelinestextgenerationpipeline","sections":[{"title":"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>","local":"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotClassificationPipeline","local":"pipelineszeroshotclassificationpipeline","sections":[{"title":"new ZeroShotClassificationPipeline(options)","local":"new-zeroshotclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FeatureExtractionPipeline","local":"pipelinesfeatureextractionpipeline","sections":[{"title":"featureExtractionPipeline._call(texts, options) ⇒","local":"featureextractionpipelinecalltexts-options-","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AudioClassificationPipeline","local":"pipelinesaudioclassificationpipeline","sections":[{"title":"new AudioClassificationPipeline(options)","local":"new-audioclassificationpipelineoptions","sections":[],"depth":3},{"title":"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotAudioClassificationPipeline","local":"pipelineszeroshotaudioclassificationpipeline","sections":[{"title":"new ZeroShotAudioClassificationPipeline(options)","local":"new-zeroshotaudioclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotAudioClassificationPipeline._call(audios, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotaudioclassificationpipelinecallaudios-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AutomaticSpeechRecognitionPipeline","local":"pipelinesautomaticspeechrecognitionpipeline","sections":[{"title":"new AutomaticSpeechRecognitionPipeline(options)","local":"new-automaticspeechrecognitionpipelineoptions","sections":[],"depth":3},{"title":"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>","local":"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToTextPipeline","local":"pipelinesimagetotextpipeline","sections":[{"title":"new ImageToTextPipeline(options)","local":"new-imagetotextpipelineoptions","sections":[],"depth":3},{"title":"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageClassificationPipeline","local":"pipelinesimageclassificationpipeline","sections":[{"title":"new ImageClassificationPipeline(options)","local":"new-imageclassificationpipelineoptions","sections":[],"depth":3},{"title":"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>","local":"imageclassificationpipelinecallimages-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageSegmentationPipeline","local":"pipelinesimagesegmentationpipeline","sections":[{"title":"new ImageSegmentationPipeline(options)","local":"new-imagesegmentationpipelineoptions","sections":[],"depth":3},{"title":"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>","local":"imagesegmentationpipelinecallimages-options--code-promise--array--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotImageClassificationPipeline","local":"pipelineszeroshotimageclassificationpipeline","sections":[{"title":"new ZeroShotImageClassificationPipeline(options)","local":"new-zeroshotimageclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ObjectDetectionPipeline","local":"pipelinesobjectdetectionpipeline","sections":[{"title":"new ObjectDetectionPipeline(options)","local":"new-objectdetectionpipelineoptions","sections":[],"depth":3},{"title":"objectDetectionPipeline._call(images, options)","local":"objectdetectionpipelinecallimages-options","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotObjectDetectionPipeline","local":"pipelineszeroshotobjectdetectionpipeline","sections":[{"title":"new ZeroShotObjectDetectionPipeline(options)","local":"new-zeroshotobjectdetectionpipelineoptions","sections":[],"depth":3},{"title":"zeroShotObjectDetectionPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotobjectdetectionpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DocumentQuestionAnsweringPipeline","local":"pipelinesdocumentquestionansweringpipeline","sections":[{"title":"new DocumentQuestionAnsweringPipeline(options)","local":"new-documentquestionansweringpipelineoptions","sections":[],"depth":3},{"title":"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextToAudioPipeline","local":"pipelinestexttoaudiopipeline","sections":[{"title":"new TextToAudioPipeline(options)","local":"new-texttoaudiopipelineoptions","sections":[],"depth":3},{"title":"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>","local":"texttoaudiopipelinecalltextinputs-options--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToImagePipeline","local":"pipelinesimagetoimagepipeline","sections":[{"title":"imageToImagePipeline._call(images) ⇒ <code> Promise. < any > </code>","local":"imagetoimagepipelinecallimages--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DepthEstimationPipeline","local":"pipelinesdepthestimationpipeline","sections":[{"title":"depthEstimationPipeline._call(images) ⇒ <code> Promise. < any > </code>","local":"depthestimationpipelinecallimages--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>","local":"pipelinespipelinetask-model-options--code-promise--pipeline--code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringResult : <code> object </code>","local":"pipelinesquestionansweringresult--code-object-code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>","local":"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code","sections":[],"depth":2},{"title":"pipelines~ChunkCallback : <code> function </code>","local":"pipelineschunkcallback--code-function-code","sections":[],"depth":2}],"depth":1}';function Zj(UJ){return bj(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vj extends xj{constructor(w){super(),Cj(this,w,Zj,kj,Uj,{})}}export{vj as component};
