import{s as Nt,n as Ct,o as Bt}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as vt,g as i,s as a,r as o,A as Et,h as p,f as s,c as n,j as Zt,u as c,x as m,k as xt,y as Gt,a as l,v as r,d as h,t as M,w as g}from"../chunks/index.c9bcf812.js";import{C as _}from"../chunks/CodeBlock.94efc595.js";import{H as A}from"../chunks/Heading.3c6e5b17.js";function Qt(dt){let d,z,R,Y,j,F,f,jt="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",H,w,ft="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",S,J,wt='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a>.',L,u,q,b,Jt="To load a pretrained model:",P,y,D,T,ut="To load and preprocess the image:",K,$,O,U,bt="To get the model predictions:",tt,I,et,k,yt="To get the top-5 predictions class names:",st,Z,lt,x,Tt="Replace the model name with the variant you want to use, e.g. <code>efficientnet_b0</code>. You can find the IDs in the model summaries at the top of this page.",at,N,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',nt,C,it,B,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,W,mt,v,It=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ot,E,ct,G,kt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',rt,Q,ht,V,Mt,X,gt;return j=new A({props:{title:"EfficientNet",local:"efficientnet",headingTag:"h1"}}),u=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VmZmljaWVudG5ldF9iMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),$=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWZmaWNpZW50bmV0X2IwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new _({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){d=i("meta"),z=a(),R=i("p"),Y=a(),o(j.$$.fragment),F=a(),f=i("p"),f.innerHTML=jt,H=a(),w=i("p"),w.textContent=ft,S=a(),J=i("p"),J.innerHTML=wt,L=a(),o(u.$$.fragment),q=a(),b=i("p"),b.textContent=Jt,P=a(),o(y.$$.fragment),D=a(),T=i("p"),T.textContent=ut,K=a(),o($.$$.fragment),O=a(),U=i("p"),U.textContent=bt,tt=a(),o(I.$$.fragment),et=a(),k=i("p"),k.textContent=yt,st=a(),o(Z.$$.fragment),lt=a(),x=i("p"),x.innerHTML=Tt,at=a(),N=i("p"),N.innerHTML=$t,nt=a(),o(C.$$.fragment),it=a(),B=i("p"),B.textContent=Ut,pt=a(),o(W.$$.fragment),mt=a(),v=i("p"),v.innerHTML=It,ot=a(),o(E.$$.fragment),ct=a(),G=i("p"),G.innerHTML=kt,rt=a(),o(Q.$$.fragment),ht=a(),o(V.$$.fragment),Mt=a(),X=i("p"),this.h()},l(t){const e=Et("svelte-u9bgzb",document.head);d=p(e,"META",{name:!0,content:!0}),e.forEach(s),z=n(t),R=p(t,"P",{}),Zt(R).forEach(s),Y=n(t),c(j.$$.fragment,t),F=n(t),f=p(t,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1bwkfja"&&(f.innerHTML=jt),H=n(t),w=p(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-5z334a"&&(w.textContent=ft),S=n(t),J=p(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1j8z7ka"&&(J.innerHTML=wt),L=n(t),c(u.$$.fragment,t),q=n(t),b=p(t,"P",{"data-svelte-h":!0}),m(b)!=="svelte-18ywhxh"&&(b.textContent=Jt),P=n(t),c(y.$$.fragment,t),D=n(t),T=p(t,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1c2ipa8"&&(T.textContent=ut),K=n(t),c($.$$.fragment,t),O=n(t),U=p(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1n9qsq1"&&(U.textContent=bt),tt=n(t),c(I.$$.fragment,t),et=n(t),k=p(t,"P",{"data-svelte-h":!0}),m(k)!=="svelte-19cnvx1"&&(k.textContent=yt),st=n(t),c(Z.$$.fragment,t),lt=n(t),x=p(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1vzaktz"&&(x.innerHTML=Tt),at=n(t),N=p(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1wmi3ea"&&(N.innerHTML=$t),nt=n(t),c(C.$$.fragment,t),it=n(t),B=p(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-9sr7nh"&&(B.textContent=Ut),pt=n(t),c(W.$$.fragment,t),mt=n(t),v=p(t,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1kguc51"&&(v.innerHTML=It),ot=n(t),c(E.$$.fragment,t),ct=n(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n0coha"&&(G.innerHTML=kt),rt=n(t),c(Q.$$.fragment,t),ht=n(t),c(V.$$.fragment,t),Mt=n(t),X=p(t,"P",{}),Zt(X).forEach(s),this.h()},h(){xt(d,"name","hf:doc:metadata"),xt(d,"content",Vt)},m(t,e){Gt(document.head,d),l(t,z,e),l(t,R,e),l(t,Y,e),r(j,t,e),l(t,F,e),l(t,f,e),l(t,H,e),l(t,w,e),l(t,S,e),l(t,J,e),l(t,L,e),r(u,t,e),l(t,q,e),l(t,b,e),l(t,P,e),r(y,t,e),l(t,D,e),l(t,T,e),l(t,K,e),r($,t,e),l(t,O,e),l(t,U,e),l(t,tt,e),r(I,t,e),l(t,et,e),l(t,k,e),l(t,st,e),r(Z,t,e),l(t,lt,e),l(t,x,e),l(t,at,e),l(t,N,e),l(t,nt,e),r(C,t,e),l(t,it,e),l(t,B,e),l(t,pt,e),r(W,t,e),l(t,mt,e),l(t,v,e),l(t,ot,e),r(E,t,e),l(t,ct,e),l(t,G,e),l(t,rt,e),r(Q,t,e),l(t,ht,e),r(V,t,e),l(t,Mt,e),l(t,X,e),gt=!0},p:Ct,i(t){gt||(h(j.$$.fragment,t),h(u.$$.fragment,t),h(y.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(Z.$$.fragment,t),h(C.$$.fragment,t),h(W.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(V.$$.fragment,t),gt=!0)},o(t){M(j.$$.fragment,t),M(u.$$.fragment,t),M(y.$$.fragment,t),M($.$$.fragment,t),M(I.$$.fragment,t),M(Z.$$.fragment,t),M(C.$$.fragment,t),M(W.$$.fragment,t),M(E.$$.fragment,t),M(Q.$$.fragment,t),M(V.$$.fragment,t),gt=!1},d(t){t&&(s(z),s(R),s(Y),s(F),s(f),s(H),s(w),s(S),s(J),s(L),s(q),s(b),s(P),s(D),s(T),s(K),s(O),s(U),s(tt),s(et),s(k),s(st),s(lt),s(x),s(at),s(N),s(nt),s(it),s(B),s(pt),s(mt),s(v),s(ot),s(ct),s(G),s(rt),s(ht),s(Mt),s(X)),s(d),g(j,t),g(u,t),g(y,t),g($,t),g(I,t),g(Z,t),g(C,t),g(W,t),g(E,t),g(Q,t),g(V,t)}}}const Vt='{"title":"EfficientNet","local":"efficientnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _t(dt){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Wt{constructor(d){super(),vt(this,d,_t,Qt,Nt,{})}}export{Yt as component};
