import{s as Ye,o as Pe,n as qe}from"../chunks/scheduler.182ea377.js";import{S as Ae,i as Ke,g as i,s as a,r as f,A as Oe,h as p,f as s,c as n,j as ze,u as m,x as o,k as De,y as et,a as l,v as u,d as c,t as h,w as d}from"../chunks/index.abf12888.js";import{T as tt}from"../chunks/Tip.230e2334.js";import{C as Y}from"../chunks/CodeBlock.57fe6e13.js";import{D as st}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as $e}from"../chunks/Heading.16916d63.js";function lt(q){let r,M="Disable the FreeU mechanism by calling <code>disable_freeu()</code> on a pipeline.";return{c(){r=i("p"),r.innerHTML=M},l(b){r=p(b,"P",{"data-svelte-h":!0}),o(r)!=="svelte-vhfeba"&&(r.innerHTML=M)},m(b,D){l(b,r,D)},p:qe,d(b){b&&s(r)}}}function at(q){let r,M,b,D,g,A,J,K,w,We="The UNet is responsible for denoising during the reverse diffusion process, and there are two distinct features in its architecture:",O,T,ke="<li>Backbone features primarily contribute to the denoising process</li> <li>Skip features mainly introduce high-frequency features into the decoder module and can make the network overlook the semantics in the backbone features</li>",ee,U,Be='However, the skip connection can sometimes introduce unnatural image details. <a href="https://hf.co/papers/2309.11497" rel="nofollow">FreeU</a> is a technique for improving image quality by rebalancing the contributions from the UNet’s skip connections and backbone feature maps.',te,j,_e="FreeU is applied during inference and it does not require any additional training. The technique works for different tasks such as text-to-image, image-to-image, and text-to-video.",se,Z,xe='In this guide, you will apply FreeU to the <a href="/docs/diffusers/v0.26.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, <a href="/docs/diffusers/v0.26.0/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>, and <a href="/docs/diffusers/v0.26.0/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>. You need to install Diffusers from source to run the examples below.',le,v,ae,$,Ce="Load the pipeline:",ne,W,ie,k,Ge="Then enable the FreeU mechanism with the FreeU-specific hyperparameters. These values are scaling factors for the backbone and skip features.",pe,B,oe,_,Se='The values above are from the official FreeU <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">code repository</a> where you can also find <a href="https://github.com/ChenyangSi/FreeU#range-for-more-parameters" rel="nofollow">reference hyperparameters</a> for different models.',re,y,fe,x,Ve="And then run inference:",me,C,ue,G,Ee="The figure below compares non-FreeU and FreeU results respectively for the same hyperparameters used above (<code>prompt</code> and <code>seed</code>):",ce,S,Ie='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/freeu/sdv1_5_freeu.jpg"/>',he,V,He="Let’s see how Stable Diffusion 2 results are impacted:",de,E,be,I,Re='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/freeu/sdv2_1_freeu.jpg"/>',ye,H,Me,R,Xe="Finally, let’s take a look at how FreeU affects Stable Diffusion XL results:",ge,X,Je,N,Ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/freeu/sdxl_freeu.jpg"/>',we,Q,Te,F,Qe="FreeU can also be used to improve video quality:",Ue,L,je,z,Fe='Thanks to <a href="https://github.com/kadirnar/" rel="nofollow">kadirnar</a> for helping to integrate the feature, and to <a href="https://github.com/justindujardin" rel="nofollow">justindujardin</a> for the helpful discussions.',Ze,P,ve;return g=new $e({props:{title:"Improve generation quality with FreeU",local:"improve-generation-quality-with-freeu",headingTag:"h1"}}),J=new st({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/freeu.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/freeu.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/freeu.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/freeu.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/freeu.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/freeu.ipynb"}]}}),v=new $e({props:{title:"StableDiffusionPipeline",local:"stablediffusionpipeline",headingTag:"h2"}}),W=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUwQSkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, safety_checker=<span class="hljs-literal">None</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),B=new Y({props:{code:"cGlwZWxpbmUuZW5hYmxlX2ZyZWV1KHMxJTNEMC45JTJDJTIwczIlM0QwLjIlMkMlMjBiMSUzRDEuMiUyQyUyMGIyJTNEMS40KQ==",highlighted:'pipeline.enable_freeu(s1=<span class="hljs-number">0.9</span>, s2=<span class="hljs-number">0.2</span>, b1=<span class="hljs-number">1.2</span>, b2=<span class="hljs-number">1.4</span>)',wrap:!1}}),y=new tt({props:{$$slots:{default:[lt]},$$scope:{ctx:q}}}),C=new Y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHNxdWlycmVsJTIwZWF0aW5nJTIwYSUyMGJ1cmdlciUyMiUwQXNlZWQlMjAlM0QlMjAyMDIzJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZChzZWVkKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`prompt = <span class="hljs-string">&quot;A squirrel eating a burger&quot;</span>
seed = <span class="hljs-number">2023</span>
image = pipeline(prompt, generator=torch.manual_seed(seed)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),E=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBzcXVpcnJlbCUyMGVhdGluZyUyMGElMjBidXJnZXIlMjIlMEFzZWVkJTIwJTNEJTIwMjAyMyUwQSUwQXBpcGVsaW5lLmVuYWJsZV9mcmVldShzMSUzRDAuOSUyQyUyMHMyJTNEMC4yJTJDJTIwYjElM0QxLjElMkMlMjBiMiUzRDEuMiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16, safety_checker=<span class="hljs-literal">None</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A squirrel eating a burger&quot;</span>
seed = <span class="hljs-number">2023</span>

pipeline.enable_freeu(s1=<span class="hljs-number">0.9</span>, s2=<span class="hljs-number">0.2</span>, b1=<span class="hljs-number">1.1</span>, b2=<span class="hljs-number">1.2</span>)
image = pipeline(prompt, generator=torch.manual_seed(seed)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),H=new $e({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),X=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHNxdWlycmVsJTIwZWF0aW5nJTIwYSUyMGJ1cmdlciUyMiUwQXNlZWQlMjAlM0QlMjAyMDIzJTBBJTBBJTIzJTIwQ29tZXMlMjBmcm9tJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3YW5kYi5haSUyRm5hc2lyazI0JTJGVU5FVC1GcmVlVS1TRFhMJTJGcmVwb3J0cyUyRkZyZWVVLVNEWEwtT3B0aW1hbC1QYXJhbWV0ZXJzLS1WbWxsZHpvMU5EZzROVFV3JTBBcGlwZWxpbmUuZW5hYmxlX2ZyZWV1KHMxJTNEMC42JTJDJTIwczIlM0QwLjQlMkMlMjBiMSUzRDEuMSUyQyUyMGIyJTNEMS4yKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoc2VlZCkpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A squirrel eating a burger&quot;</span>
seed = <span class="hljs-number">2023</span>

<span class="hljs-comment"># Comes from</span>
<span class="hljs-comment"># https://wandb.ai/nasirk24/UNET-FreeU-SDXL/reports/FreeU-SDXL-Optimal-Parameters--Vmlldzo1NDg4NTUw</span>
pipeline.enable_freeu(s1=<span class="hljs-number">0.6</span>, s2=<span class="hljs-number">0.4</span>, b1=<span class="hljs-number">1.1</span>, b2=<span class="hljs-number">1.2</span>)
image = pipeline(prompt, generator=torch.manual_seed(seed)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Q=new $e({props:{title:"Text-to-video generation",local:"text-to-video-generation",headingTag:"h2"}}),L=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFzZWVkJTIwJTNEJTIwMjAyMyUwQSUwQSUyMyUyMFRoZSUyMHZhbHVlcyUyMGNvbWUlMjBmcm9tJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGbHluLXJnYiUyRkZyZWVVX0RpZmZ1c2VycyUyM3ZpZGVvLXBpcGVsaW5lcyUwQXBpcGUuZW5hYmxlX2ZyZWV1KGIxJTNEMS4yJTJDJTIwYjIlM0QxLjQlMkMlMjBzMSUzRDAuOSUyQyUyMHMyJTNEMC4yKSUwQXZpZGVvX2ZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwaGVpZ2h0JTNEMzIwJTJDJTIwd2lkdGglM0Q1NzYlMkMlMjBudW1fZnJhbWVzJTNEMzAlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZChzZWVkKSkuZnJhbWVzJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyUyQyUyMCUyMmFzdHJvbmF1dF9yaWRlc19ob3JzZS5tcDQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>
pipe = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;an astronaut riding a horse on mars&quot;</span>
seed = <span class="hljs-number">2023</span>

<span class="hljs-comment"># The values come from</span>
<span class="hljs-comment"># https://github.com/lyn-rgb/FreeU_Diffusers#video-pipelines</span>
pipe.enable_freeu(b1=<span class="hljs-number">1.2</span>, b2=<span class="hljs-number">1.4</span>, s1=<span class="hljs-number">0.9</span>, s2=<span class="hljs-number">0.2</span>)
video_frames = pipe(prompt, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">30</span>, generator=torch.manual_seed(seed)).frames
export_to_video(video_frames, <span class="hljs-string">&quot;astronaut_rides_horse.mp4&quot;</span>)`,wrap:!1}}),{c(){r=i("meta"),M=a(),b=i("p"),D=a(),f(g.$$.fragment),A=a(),f(J.$$.fragment),K=a(),w=i("p"),w.textContent=We,O=a(),T=i("ol"),T.innerHTML=ke,ee=a(),U=i("p"),U.innerHTML=Be,te=a(),j=i("p"),j.textContent=_e,se=a(),Z=i("p"),Z.innerHTML=xe,le=a(),f(v.$$.fragment),ae=a(),$=i("p"),$.textContent=Ce,ne=a(),f(W.$$.fragment),ie=a(),k=i("p"),k.textContent=Ge,pe=a(),f(B.$$.fragment),oe=a(),_=i("p"),_.innerHTML=Se,re=a(),f(y.$$.fragment),fe=a(),x=i("p"),x.textContent=Ve,me=a(),f(C.$$.fragment),ue=a(),G=i("p"),G.innerHTML=Ee,ce=a(),S=i("p"),S.innerHTML=Ie,he=a(),V=i("p"),V.textContent=He,de=a(),f(E.$$.fragment),be=a(),I=i("p"),I.innerHTML=Re,ye=a(),f(H.$$.fragment),Me=a(),R=i("p"),R.textContent=Xe,ge=a(),f(X.$$.fragment),Je=a(),N=i("p"),N.innerHTML=Ne,we=a(),f(Q.$$.fragment),Te=a(),F=i("p"),F.textContent=Qe,Ue=a(),f(L.$$.fragment),je=a(),z=i("p"),z.innerHTML=Fe,Ze=a(),P=i("p"),this.h()},l(e){const t=Oe("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(s),M=n(e),b=p(e,"P",{}),ze(b).forEach(s),D=n(e),m(g.$$.fragment,e),A=n(e),m(J.$$.fragment,e),K=n(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1ppsh1y"&&(w.textContent=We),O=n(e),T=p(e,"OL",{"data-svelte-h":!0}),o(T)!=="svelte-8wamr8"&&(T.innerHTML=ke),ee=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-153lhh2"&&(U.innerHTML=Be),te=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1l2549u"&&(j.textContent=_e),se=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-tv96r7"&&(Z.innerHTML=xe),le=n(e),m(v.$$.fragment,e),ae=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1t6isft"&&($.textContent=Ce),ne=n(e),m(W.$$.fragment,e),ie=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1kfovwo"&&(k.textContent=Ge),pe=n(e),m(B.$$.fragment,e),oe=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-gb72tw"&&(_.innerHTML=Se),re=n(e),m(y.$$.fragment,e),fe=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-yyi4rw"&&(x.textContent=Ve),me=n(e),m(C.$$.fragment,e),ue=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-u90fev"&&(G.innerHTML=Ee),ce=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-gexrkr"&&(S.innerHTML=Ie),he=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-61gii3"&&(V.textContent=He),de=n(e),m(E.$$.fragment,e),be=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-evvlf0"&&(I.innerHTML=Re),ye=n(e),m(H.$$.fragment,e),Me=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-2ehsm1"&&(R.textContent=Xe),ge=n(e),m(X.$$.fragment,e),Je=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1vig68s"&&(N.innerHTML=Ne),we=n(e),m(Q.$$.fragment,e),Te=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-pga2sp"&&(F.textContent=Qe),Ue=n(e),m(L.$$.fragment,e),je=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1cx6l39"&&(z.innerHTML=Fe),Ze=n(e),P=p(e,"P",{}),ze(P).forEach(s),this.h()},h(){De(r,"name","hf:doc:metadata"),De(r,"content",nt)},m(e,t){et(document.head,r),l(e,M,t),l(e,b,t),l(e,D,t),u(g,e,t),l(e,A,t),u(J,e,t),l(e,K,t),l(e,w,t),l(e,O,t),l(e,T,t),l(e,ee,t),l(e,U,t),l(e,te,t),l(e,j,t),l(e,se,t),l(e,Z,t),l(e,le,t),u(v,e,t),l(e,ae,t),l(e,$,t),l(e,ne,t),u(W,e,t),l(e,ie,t),l(e,k,t),l(e,pe,t),u(B,e,t),l(e,oe,t),l(e,_,t),l(e,re,t),u(y,e,t),l(e,fe,t),l(e,x,t),l(e,me,t),u(C,e,t),l(e,ue,t),l(e,G,t),l(e,ce,t),l(e,S,t),l(e,he,t),l(e,V,t),l(e,de,t),u(E,e,t),l(e,be,t),l(e,I,t),l(e,ye,t),u(H,e,t),l(e,Me,t),l(e,R,t),l(e,ge,t),u(X,e,t),l(e,Je,t),l(e,N,t),l(e,we,t),u(Q,e,t),l(e,Te,t),l(e,F,t),l(e,Ue,t),u(L,e,t),l(e,je,t),l(e,z,t),l(e,Ze,t),l(e,P,t),ve=!0},p(e,[t]){const Le={};t&2&&(Le.$$scope={dirty:t,ctx:e}),y.$set(Le)},i(e){ve||(c(g.$$.fragment,e),c(J.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(y.$$.fragment,e),c(C.$$.fragment,e),c(E.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),ve=!0)},o(e){h(g.$$.fragment,e),h(J.$$.fragment,e),h(v.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(y.$$.fragment,e),h(C.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),ve=!1},d(e){e&&(s(M),s(b),s(D),s(A),s(K),s(w),s(O),s(T),s(ee),s(U),s(te),s(j),s(se),s(Z),s(le),s(ae),s($),s(ne),s(ie),s(k),s(pe),s(oe),s(_),s(re),s(fe),s(x),s(me),s(ue),s(G),s(ce),s(S),s(he),s(V),s(de),s(be),s(I),s(ye),s(Me),s(R),s(ge),s(Je),s(N),s(we),s(Te),s(F),s(Ue),s(je),s(z),s(Ze),s(P)),s(r),d(g,e),d(J,e),d(v,e),d(W,e),d(B,e),d(y,e),d(C,e),d(E,e),d(H,e),d(X,e),d(Q,e),d(L,e)}}}const nt='{"title":"Improve generation quality with FreeU","local":"improve-generation-quality-with-freeu","sections":[{"title":"StableDiffusionPipeline","local":"stablediffusionpipeline","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Text-to-video generation","local":"text-to-video-generation","sections":[],"depth":2}],"depth":1}';function it(q){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ae{constructor(r){super(),Ke(this,r,it,at,Ye,{})}}export{ct as component};
