import{s as El,n as Rl,o as kl}from"../chunks/scheduler.9680c161.js";import{S as Il,i as Gl,g as a,s,r as p,A as Bl,h as r,f as l,c as n,j as vl,u as m,x as o,k as Ll,y as _l,a as i,v as M,d,t as y,w as u}from"../chunks/index.8ae9bd2f.js";import{H as h,C as c}from"../chunks/Heading.78e3d528.js";function Hl(St){let b,Le,xe,Ee,f,Re,w,Zt="The bitsandbytes is a lightweight wrapper around CUDA custom functions, in particular 8-bit optimizers, matrix multiplication (LLM.int8()), and quantization functions.",ke,T,Ft="Resources:",Ie,U,Nt='<li><p><a href="https://arxiv.org/abs/2110.02861" rel="nofollow">8-bit Optimizer Paper</a> —  <a href="https://www.youtube.com/watch?v=IxrlHAJtqKE" rel="nofollow">Video</a> — <a href="https://bitsandbytes.readthedocs.io/en/latest/" rel="nofollow">Docs</a></p></li> <li><p><a href="https://arxiv.org/abs/2208.07339" rel="nofollow">LLM.int8() Paper</a> — <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">LLM.int8() Software Blog Post</a> — <a href="https://timdettmers.com/2022/08/17/llm-int8-and-emergent-features/" rel="nofollow">LLM.int8() Emergent Features Blog Post</a></p></li>',Ge,J,Be,j,Yt=`<strong>Requirements</strong>
Python &gt;=3.8. Linux distribution (Ubuntu, MacOS, etc.) + CUDA &gt; 10.0.`,_e,$,Xt="(Deprecated: CUDA 10.0 is deprecated and only CUDA >= 11.0) will be supported with release 0.39.0)",He,C,Dt="<strong>Installation</strong>:",Qe,g,At="<code>pip install bitsandbytes</code>",We,x,Vt="In some cases it can happen that you need to compile from source. If this happens please consider submitting a bug report with <code>python -m bitsandbytes</code> information. What now follows is some short instructions which might work out of the box if <code>nvcc</code> is installed. If these do not work see further below.",ze,v,Pt="Compilation quickstart:",Se,L,Ze,E,Ot="<strong>Using Int8 inference with HuggingFace Transformers</strong>",Fe,R,Ne,k,qt='A more detailed example, can be found in <a href="examples/int8_inference_huggingface.py">examples/int8_inference_huggingface.py</a>.',Ye,I,Kt="<strong>Using 8-bit optimizer</strong>:",Xe,G,el="<li>Comment out optimizer: <code>#torch.optim.Adam(....)</code></li> <li>Add 8-bit optimizer of your choice <code>bnb.optim.Adam8bit(....)</code> (arguments stay the same)</li> <li>Replace embedding layer if necessary: <code>torch.nn.Embedding(..) -&gt; bnb.nn.Embedding(..)</code></li>",De,B,tl="<strong>Using 8-bit Inference</strong>:",Ae,_,ll="<li>Comment out torch.nn.Linear: <code>#linear = torch.nn.Linear(...)</code></li> <li>Add bnb 8-bit linear light module: <code>linear = bnb.nn.Linear8bitLt(...)</code> (base arguments stay the same)</li> <li>There are two modes:<ul><li>Mixed 8-bit training with 16-bit main weights. Pass the argument <code>has_fp16_weights=True</code> (default)</li> <li>Int8 inference. Pass the argument <code>has_fp16_weights=False</code></li></ul></li> <li>To use the full LLM.int8() method, use the <code>threshold=k</code> argument. We recommend <code>k=6.0</code>.</li>",Ve,H,Pe,Q,Oe,W,il="<li>8-bit Matrix multiplication with mixed precision decomposition</li> <li>LLM.int8() inference</li> <li>8-bit Optimizers: Adam, AdamW, RMSProp, LARS, LAMB, Lion (saves 75% memory)</li> <li>Stable Embedding Layer: Improved stability through better initialization, and normalization</li> <li>8-bit quantization: Quantile, Linear, and Dynamic quantization</li> <li>Fast quantile estimation: Up to 100x faster than other algorithms</li>",qe,z,Ke,S,sl="Requirements: anaconda, cudatoolkit, pytorch",et,Z,nl="Hardware requirements:",tt,F,al="<li>LLM.int8(): NVIDIA Turing (RTX 20xx; T4) or Ampere GPU (RTX 30xx; A4-A100); (a GPU from 2018 or newer).</li> <li>8-bit optimizers and quantization: NVIDIA Kepler GPU or newer (&gt;=GTX 78X).</li>",lt,N,rl="Supported CUDA versions: 10.2 - 12.0",it,Y,ol="The bitsandbytes library is currently only supported on Linux distributions. Windows is not supported at the moment.",st,X,pl='The requirements can best be fulfilled by installing pytorch via anaconda. You can install PyTorch by following the <a href="https://pytorch.org/get-started/locally/" rel="nofollow">“Get Started”</a> instructions on the official website.',nt,D,ml="To install run:",at,A,Ml="<code>pip install bitsandbytes</code>",rt,V,ot,P,pt,O,dl="For straight Int8 matrix multiplication with mixed precision decomposition you can use <code>bnb.matmul(...)</code>. To enable mixed precision decomposition, use the threshold parameter:",mt,q,Mt,K,yl='For instructions how to use LLM.int8() inference layers in your own code, see the TL;DR above or for extended instruction see <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">this blog post</a>.',dt,ee,yt,te,ul="With bitsandbytes 8-bit optimizers can be used by changing a single line of code in your codebase. For NLP models we recommend also to use the StableEmbedding layers (see below) which improves results and helps with stable 8-bit optimization.  To get started with 8-bit optimizers, it is sufficient to replace your old optimizer with the 8-bit optimizer in the following way:",ut,le,ht,ie,hl="Note that by default all parameter tensors with less than 4096 elements are kept at 32-bit even if you initialize those parameters with 8-bit optimizers. This is done since such small tensors do not save much memory and often contain highly variable parameters (biases) or parameters that require high precision (batch norm, layer norm). You can change this behavior like so:",bt,se,ct,ne,ft,ae,bl='If you want to optimize some unstable parameters with 32-bit Adam and others with 8-bit Adam, you can use the <code>GlobalOptimManager</code>. With this, we can also configure specific hyperparameters for particular layers, such as embedding layers. To do that, we need two things: (1) register the parameter while they are still on the CPU, (2) override the config with the new desired hyperparameters (anytime, anywhere). See our <a href="howto_config_override.md">guide</a> for more details',wt,re,Tt,oe,cl="To use the Stable Embedding Layer, override the respective <code>build_embedding(...)</code> function of your model. Make sure to also use the <code>--no-scale-embedding</code> flag to disable scaling of the word embedding layer (nor replaced with layer norm). You can use the optimizers by replacing the optimizer in the respective file (<code>adam.py</code> etc.).",Ut,pe,Jt,me,fl='For upcoming features and changes and full history see <a href="CHANGELOG.md">Patch Notes</a>.',jt,Me,$t,de,wl='<li>RuntimeError: CUDA error: no kernel image is available for execution on the device. <a href="errors_and_solutions.md#No-kernel-image-available">Solution</a></li> <li>_<em>fatbinwrap</em>.. <a href="errors_and_solutions.md#fatbinwrap_">Solution</a></li>',Ct,ye,gt,ue,Tl="To compile from source, you need an installation of CUDA. If <code>nvcc</code> is not installed, you can install the CUDA Toolkit with nvcc through the following commands.",xt,he,vt,be,Ul="To use a specific CUDA version just for a single compile run, you can set the variable <code>CUDA_HOME</code>, for example the following command compiles <code>libbitsandbytes_cuda117.so</code> using compiler flags for cuda11x with the cuda version at <code>~/local/cuda-11.7</code>:",Lt,ce,Jl="<code>CUDA_HOME=~/local/cuda-11.7 CUDA_VERSION=117 make cuda11x</code>",Et,fe,jl='For more detailed instruction, please follow the <a href="compile_from_source.md">compile_from_source.md</a> instructions.',Rt,we,kt,Te,$l="The majority of bitsandbytes is licensed under MIT, however portions of the project are available under separate license terms: Pytorch is licensed under the BSD license.",It,Ue,Cl='We thank Fabio Cannizzo for his work on <a href="https://github.com/fabiocannizzo/FastBinarySearch" rel="nofollow">FastBinarySearch</a> which we use for CPU quantization.',Gt,Je,Bt,je,gl="If you found this library and found LLM.int8() useful, please consider citing our work:",_t,$e,Ht,Ce,xl="For 8-bit optimizers or quantization routines, please consider citing the following work:",Qt,ge,Wt,ve,zt;return f=new h({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),J=new h({props:{title:"TL;DR",local:"tldr",headingTag:"h2"}}),L=new c({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZ0aW1kZXR0bWVycyUyRmJpdHNhbmRieXRlcy5naXQlMEFjZCUyMGJpdHNhbmRieXRlcyUwQSUwQSUyMyUyMENVREFfVkVSU0lPTlMlMjBpbiUyMCU3QjExMCUyQyUyMDExMSUyQyUyMDExMiUyQyUyMDExMyUyQyUyMDExNCUyQyUyMDExNSUyQyUyMDExNiUyQyUyMDExNyUyQyUyMDExOCUyQyUyMDExOSUyQyUyMDEyMCUyQyUyMDEyMCU3RCUwQSUyMyUyMG1ha2UlMjBhcmd1bWVudCUyMGluJTIwJTdCY3VkYTExMCUyQyUyMGN1ZGExMXglMkMlMjBjdWRhMTJ4JTdEJTBBJTIzJTIwaWYlMjB5b3UlMjBkbyUyMG5vdCUyMGtub3clMjB3aGF0JTIwQ1VEQSUyMHlvdSUyMGhhdmUlMkMlMjB0cnklMjBsb29raW5nJTIwYXQlMjB0aGUlMjBvdXRwdXQlMjBvZiUzQSUyMHB5dGhvbiUyMC1tJTIwYml0c2FuZGJ5dGVzJTBBQ1VEQV9WRVJTSU9OJTNEMTE3JTIwbWFrZSUyMGN1ZGExMXglMEFweXRob24lMjBzZXR1cC5weSUyMGluc3RhbGw=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/timdettmers/bitsandbytes.git
<span class="hljs-built_in">cd</span> bitsandbytes

<span class="hljs-comment"># CUDA_VERSIONS in {110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 120}</span>
<span class="hljs-comment"># make argument in {cuda110, cuda11x, cuda12x}</span>
<span class="hljs-comment"># if you do not know what CUDA you have, try looking at the output of: python -m bitsandbytes</span>
CUDA_VERSION=117 make cuda11x
python setup.py install`,wrap:!1}}),R=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJ2RlY2Fwb2RhLXJlc2VhcmNoJTJGbGxhbWEtN2ItaGYnJTJDJTBBJTIwJTIwZGV2aWNlX21hcCUzRCdhdXRvJyUyQyUwQSUyMCUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMEElMjAlMjBtYXhfbWVtb3J5JTNEZiclN0JpbnQodG9yY2guY3VkYS5tZW1fZ2V0X2luZm8oKSU1QjAlNUQlMkYxMDI0KiozKS0yJTdER0InKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(
  <span class="hljs-string">&#x27;decapoda-research/llama-7b-hf&#x27;</span>,
  device_map=<span class="hljs-string">&#x27;auto&#x27;</span>,
  load_in_8bit=<span class="hljs-literal">True</span>,
  max_memory=<span class="hljs-string">f&#x27;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(torch.cuda.mem_get_info()[<span class="hljs-number">0</span>]/<span class="hljs-number">1024</span>**<span class="hljs-number">3</span>)-<span class="hljs-number">2</span>}</span>GB&#x27;</span>)`,wrap:!1}}),H=new c({props:{code:"JTIzJTIwTExNLmludDgoKSUwQWxpbmVhciUyMCUzRCUyMGJuYi5ubi5MaW5lYXI4Yml0THQoZGltMSUyQyUyMGRpbTIlMkMlMjBiaWFzJTNEVHJ1ZSUyQyUyMGhhc19mcDE2X3dlaWdodHMlM0RGYWxzZSUyQyUyMHRocmVzaG9sZCUzRDYuMCklMEElMjMlMjBpbnB1dHMlMjBuZWVkJTIwdG8lMjBiZSUyMGZwMTYlMEFvdXQlMjAlM0QlMjBsaW5lYXIoeC50byh0b3JjaC5mbG9hdDE2KSk=",highlighted:`<span class="hljs-comment"># LLM.int8()</span>
linear = bnb.nn.Linear8bitLt(dim1, dim2, bias=<span class="hljs-literal">True</span>, has_fp16_weights=<span class="hljs-literal">False</span>, threshold=<span class="hljs-number">6.0</span>)
<span class="hljs-comment"># inputs need to be fp16</span>
out = linear(x.to(torch.float16))`,wrap:!1}}),Q=new h({props:{title:"Features",local:"features",headingTag:"h2"}}),z=new h({props:{title:"Requirements & Installation",local:"requirements--installation",headingTag:"h2"}}),V=new h({props:{title:"Using bitsandbytes",local:"using-bitsandbytes",headingTag:"h2"}}),P=new h({props:{title:"Using Int8 Matrix Multiplication",local:"using-int8-matrix-multiplication",headingTag:"h3"}}),q=new c({props:{code:"Ym5iLm1hdG11bCguLi4lMkMlMjB0aHJlc2hvbGQlM0Q2LjAp",highlighted:'bnb.matmul(..., threshold=<span class="hljs-number">6.0</span>)',wrap:!1}}),ee=new h({props:{title:"Using the 8-bit Optimizers",local:"using-the-8-bit-optimizers",headingTag:"h3"}}),le=new c({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEElMjMlMjBhZGFtJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbShtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDAuMDAxJTJDJTIwYmV0YXMlM0QoMC45JTJDJTIwMC45OTUpKSUyMCUyMyUyMGNvbW1lbnQlMjBvdXQlMjBvbGQlMjBvcHRpbWl6ZXIlMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW04Yml0KG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEMC4wMDElMkMlMjBiZXRhcyUzRCgwLjklMkMlMjAwLjk5NSkpJTIwJTIzJTIwYWRkJTIwYm5iJTIwb3B0aW1pemVyJTBBYWRhbSUyMCUzRCUyMGJuYi5vcHRpbS5BZGFtKG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEMC4wMDElMkMlMjBiZXRhcyUzRCgwLjklMkMlMjAwLjk5NSklMkMlMjBvcHRpbV9iaXRzJTNEOCklMjAlMjMlMjBlcXVpdmFsZW50JTBBJTBBJTBBdG9yY2gubm4uRW1iZWRkaW5nKC4uLiklMjAtJTNFJTIwJTIwYm5iLm5uLlN0YWJsZUVtYmVkZGluZyguLi4pJTIwJTIzJTIwcmVjb21tZW5kZWQlMjBmb3IlMjBOTFAlMjBtb2RlbHM=",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

<span class="hljs-comment"># adam = torch.optim.Adam(model.parameters(), lr=0.001, betas=(0.9, 0.995)) # comment out old optimizer</span>
adam = bnb.optim.Adam8bit(model.parameters(), lr=<span class="hljs-number">0.001</span>, betas=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.995</span>)) <span class="hljs-comment"># add bnb optimizer</span>
adam = bnb.optim.Adam(model.parameters(), lr=<span class="hljs-number">0.001</span>, betas=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.995</span>), optim_bits=<span class="hljs-number">8</span>) <span class="hljs-comment"># equivalent</span>


torch.nn.Embedding(...) -&gt;  bnb.nn.StableEmbedding(...) <span class="hljs-comment"># recommended for NLP models</span>`,wrap:!1}}),se=new c({props:{code:"JTIzJTIwcGFyYW1ldGVyJTIwdGVuc29ycyUyMHdpdGglMjBsZXNzJTIwdGhhbiUyMDE2Mzg0JTIwdmFsdWVzJTIwYXJlJTIwb3B0aW1pemVkJTIwaW4lMjAzMi1iaXQlMEElMjMlMjBpdCUyMGlzJTIwcmVjb21tZW5kZWQlMjB0byUyMHVzZSUyMG11bHRpcGxpZXMlMjBvZiUyMDQwOTYlMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW04Yml0KG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMG1pbl84Yml0X3NpemUlM0QxNjM4NCk=",highlighted:`<span class="hljs-comment"># parameter tensors with less than 16384 values are optimized in 32-bit</span>
<span class="hljs-comment"># it is recommended to use multiplies of 4096</span>
adam = bnb.optim.Adam8bit(model.parameters(), min_8bit_size=<span class="hljs-number">16384</span>)`,wrap:!1}}),ne=new h({props:{title:"Change Bits and other Hyperparameters for Individual Parameters",local:"change-bits-and-other-hyperparameters-for-individual-parameters",headingTag:"h3"}}),re=new h({props:{title:"Fairseq Users",local:"fairseq-users",headingTag:"h3"}}),pe=new h({props:{title:"Release and Feature History",local:"release-and-feature-history",headingTag:"h2"}}),Me=new h({props:{title:"Errors",local:"errors",headingTag:"h2"}}),ye=new h({props:{title:"Compile from source",local:"compile-from-source",headingTag:"h2"}}),he=new c({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRlRpbURldHRtZXJzJTJGYml0c2FuZGJ5dGVzJTJGbWFpbiUyRmluc3RhbGxfY3VkYS5zaCUwQSUyMyUyMFN5bnRheCUyMGN1ZGFfaW5zdGFsbCUyMENVREFfVkVSU0lPTiUyMElOU1RBTExfUFJFRklYJTIwRVhQT1JUX1RPX0JBU0glMEElMjMlMjAlMjAlMjBDVURBX1ZFUlNJT04lMjBpbiUyMCU3QjExMCUyQyUyMDExMSUyQyUyMDExMiUyQyUyMDExMyUyQyUyMDExNCUyQyUyMDExNSUyQyUyMDExNiUyQyUyMDExNyUyQyUyMDExOCUyQyUyMDEyMCUyQyUyMDEyMSUyQyUyMDEyMiU3RCUwQSUyMyUyMCUyMCUyMEVYUE9SVF9UT19CQVNIJTIwaW4lMjAlN0IwJTJDJTIwMSU3RCUyMHdpdGglMjAwJTNERmFsc2UlMjBhbmQlMjAxJTNEVHJ1ZSUwQSUwQSUyMyUyMEZvciUyMGV4YW1wbGUlMkMlMjB0aGUlMjBmb2xsb3dpbmclMjBpbnN0YWxscyUyMENVREElMjAxMS43JTIwdG8lMjB+JTJGbG9jYWwlMkZjdWRhLTExLjclMjBhbmQlMjBleHBvcnRzJTIwdGhlJTIwcGF0aCUyMHRvJTIweW91ciUyMC5iYXNocmMlMEFiYXNoJTIwaW5zdGFsbF9jdWRhLnNoJTIwMTE3JTIwfiUyRmxvY2FsJTIwMQ==",highlighted:`wget https://raw.githubusercontent.com/TimDettmers/bitsandbytes/main/install_cuda.sh
<span class="hljs-comment"># Syntax cuda_install CUDA_VERSION INSTALL_PREFIX EXPORT_TO_BASH</span>
<span class="hljs-comment">#   CUDA_VERSION in {110, 111, 112, 113, 114, 115, 116, 117, 118, 120, 121, 122}</span>
<span class="hljs-comment">#   EXPORT_TO_BASH in {0, 1} with 0=False and 1=True</span>

<span class="hljs-comment"># For example, the following installs CUDA 11.7 to ~/local/cuda-11.7 and exports the path to your .bashrc</span>
bash install_cuda.sh 117 ~/local 1`,wrap:!1}}),we=new h({props:{title:"License",local:"license",headingTag:"h2"}}),Je=new h({props:{title:"How to cite us",local:"how-to-cite-us",headingTag:"h2"}}),$e=new c({props:{code:"JTQwYXJ0aWNsZSU3QmRldHRtZXJzMjAyMmxsbWludDglMkMlMEElMjAlMjB0aXRsZSUzRCU3QkxMTS5pbnQ4KCklM0ElMjA4LWJpdCUyME1hdHJpeCUyME11bHRpcGxpY2F0aW9uJTIwZm9yJTIwVHJhbnNmb3JtZXJzJTIwYXQlMjBTY2FsZSU3RCUyQyUwQSUyMCUyMGF1dGhvciUzRCU3QkRldHRtZXJzJTJDJTIwVGltJTIwYW5kJTIwTGV3aXMlMkMlMjBNaWtlJTIwYW5kJTIwQmVsa2FkYSUyQyUyMFlvdW5lcyUyMGFuZCUyMFpldHRsZW1veWVyJTJDJTIwTHVrZSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyMjA4LjA3MzM5JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjIlN0QlMEElN0Q=",highlighted:`@article{dettmers2022llmint8,
  title={<span class="hljs-keyword">LLM.int8(): </span><span class="hljs-number">8</span>-<span class="hljs-keyword">bit </span>Matrix <span class="hljs-keyword">Multiplication </span>for Transformers <span class="hljs-built_in">at</span> <span class="hljs-keyword">Scale},
</span>  author={Dettmers, Tim <span class="hljs-keyword">and </span>Lewis, Mike <span class="hljs-keyword">and </span><span class="hljs-keyword">Belkada, </span>Younes <span class="hljs-keyword">and </span>Zettlemoyer, Luke},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2208</span>.<span class="hljs-number">07339</span>},
  year={<span class="hljs-number">2022</span>}
}`,wrap:!1}}),ge=new c({props:{code:"JTQwYXJ0aWNsZSU3QmRldHRtZXJzMjAyMm9wdGltaXplcnMlMkMlMEElMjAlMjB0aXRsZSUzRCU3QjgtYml0JTIwT3B0aW1pemVycyUyMHZpYSUyMEJsb2NrLXdpc2UlMjBRdWFudGl6YXRpb24lN0QlMkMlMEElMjAlMjBhdXRob3IlM0QlN0JEZXR0bWVycyUyQyUyMFRpbSUyMGFuZCUyMExld2lzJTJDJTIwTWlrZSUyMGFuZCUyMFNobGVpZmVyJTJDJTIwU2FtJTIwYW5kJTIwWmV0dGxlbW95ZXIlMkMlMjBMdWtlJTdEJTJDJTBBJTIwJTIwam91cm5hbCUzRCU3Qjl0aCUyMEludGVybmF0aW9uYWwlMjBDb25mZXJlbmNlJTIwb24lMjBMZWFybmluZyUyMFJlcHJlc2VudGF0aW9ucyUyQyUyMElDTFIlN0QlMkMlMEElMjAlMjB5ZWFyJTNEJTdCMjAyMiU3RCUwQSU3RA==",highlighted:`@article{dettmers2022optimizers,
  title={<span class="hljs-number">8</span>-<span class="hljs-keyword">bit </span>Optimizers via <span class="hljs-keyword">Block-wise </span>Quantization},
  author={Dettmers, Tim <span class="hljs-keyword">and </span>Lewis, Mike <span class="hljs-keyword">and </span><span class="hljs-keyword">Shleifer, </span>Sam <span class="hljs-keyword">and </span>Zettlemoyer, Luke},
  <span class="hljs-keyword">journal={9th </span>International Conference on Learning Representations, ICLR},
  year={<span class="hljs-number">2022</span>}
}`,wrap:!1}}),{c(){b=a("meta"),Le=s(),xe=a("p"),Ee=s(),p(f.$$.fragment),Re=s(),w=a("p"),w.textContent=Zt,ke=s(),T=a("p"),T.textContent=Ft,Ie=s(),U=a("ul"),U.innerHTML=Nt,Ge=s(),p(J.$$.fragment),Be=s(),j=a("p"),j.innerHTML=Yt,_e=s(),$=a("p"),$.textContent=Xt,He=s(),C=a("p"),C.innerHTML=Dt,Qe=s(),g=a("p"),g.innerHTML=At,We=s(),x=a("p"),x.innerHTML=Vt,ze=s(),v=a("p"),v.textContent=Pt,Se=s(),p(L.$$.fragment),Ze=s(),E=a("p"),E.innerHTML=Ot,Fe=s(),p(R.$$.fragment),Ne=s(),k=a("p"),k.innerHTML=qt,Ye=s(),I=a("p"),I.innerHTML=Kt,Xe=s(),G=a("ol"),G.innerHTML=el,De=s(),B=a("p"),B.innerHTML=tl,Ae=s(),_=a("ol"),_.innerHTML=ll,Ve=s(),p(H.$$.fragment),Pe=s(),p(Q.$$.fragment),Oe=s(),W=a("ul"),W.innerHTML=il,qe=s(),p(z.$$.fragment),Ke=s(),S=a("p"),S.textContent=sl,et=s(),Z=a("p"),Z.textContent=nl,tt=s(),F=a("ul"),F.innerHTML=al,lt=s(),N=a("p"),N.textContent=rl,it=s(),Y=a("p"),Y.textContent=ol,st=s(),X=a("p"),X.innerHTML=pl,nt=s(),D=a("p"),D.textContent=ml,at=s(),A=a("p"),A.innerHTML=Ml,rt=s(),p(V.$$.fragment),ot=s(),p(P.$$.fragment),pt=s(),O=a("p"),O.innerHTML=dl,mt=s(),p(q.$$.fragment),Mt=s(),K=a("p"),K.innerHTML=yl,dt=s(),p(ee.$$.fragment),yt=s(),te=a("p"),te.textContent=ul,ut=s(),p(le.$$.fragment),ht=s(),ie=a("p"),ie.textContent=hl,bt=s(),p(se.$$.fragment),ct=s(),p(ne.$$.fragment),ft=s(),ae=a("p"),ae.innerHTML=bl,wt=s(),p(re.$$.fragment),Tt=s(),oe=a("p"),oe.innerHTML=cl,Ut=s(),p(pe.$$.fragment),Jt=s(),me=a("p"),me.innerHTML=fl,jt=s(),p(Me.$$.fragment),$t=s(),de=a("ol"),de.innerHTML=wl,Ct=s(),p(ye.$$.fragment),gt=s(),ue=a("p"),ue.innerHTML=Tl,xt=s(),p(he.$$.fragment),vt=s(),be=a("p"),be.innerHTML=Ul,Lt=s(),ce=a("p"),ce.innerHTML=Jl,Et=s(),fe=a("p"),fe.innerHTML=jl,Rt=s(),p(we.$$.fragment),kt=s(),Te=a("p"),Te.textContent=$l,It=s(),Ue=a("p"),Ue.innerHTML=Cl,Gt=s(),p(Je.$$.fragment),Bt=s(),je=a("p"),je.textContent=gl,_t=s(),p($e.$$.fragment),Ht=s(),Ce=a("p"),Ce.textContent=xl,Qt=s(),p(ge.$$.fragment),Wt=s(),ve=a("p"),this.h()},l(e){const t=Bl("svelte-u9bgzb",document.head);b=r(t,"META",{name:!0,content:!0}),t.forEach(l),Le=n(e),xe=r(e,"P",{}),vl(xe).forEach(l),Ee=n(e),m(f.$$.fragment,e),Re=n(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1524s61"&&(w.textContent=Zt),ke=n(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1plfg5n"&&(T.textContent=Ft),Ie=n(e),U=r(e,"UL",{"data-svelte-h":!0}),o(U)!=="svelte-1c7h3as"&&(U.innerHTML=Nt),Ge=n(e),m(J.$$.fragment,e),Be=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-l1632j"&&(j.innerHTML=Yt),_e=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1p647sl"&&($.textContent=Xt),He=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-np8g0f"&&(C.innerHTML=Dt),Qe=n(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-e58kdn"&&(g.innerHTML=At),We=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1g755db"&&(x.innerHTML=Vt),ze=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-d8urui"&&(v.textContent=Pt),Se=n(e),m(L.$$.fragment,e),Ze=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-14fm4sn"&&(E.innerHTML=Ot),Fe=n(e),m(R.$$.fragment,e),Ne=n(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-l4ydsj"&&(k.innerHTML=qt),Ye=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-225eje"&&(I.innerHTML=Kt),Xe=n(e),G=r(e,"OL",{"data-svelte-h":!0}),o(G)!=="svelte-byx1wb"&&(G.innerHTML=el),De=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-yfx4r6"&&(B.innerHTML=tl),Ae=n(e),_=r(e,"OL",{"data-svelte-h":!0}),o(_)!=="svelte-qovb4e"&&(_.innerHTML=ll),Ve=n(e),m(H.$$.fragment,e),Pe=n(e),m(Q.$$.fragment,e),Oe=n(e),W=r(e,"UL",{"data-svelte-h":!0}),o(W)!=="svelte-2fzoyi"&&(W.innerHTML=il),qe=n(e),m(z.$$.fragment,e),Ke=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1k7sgnb"&&(S.textContent=sl),et=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-i4ijdu"&&(Z.textContent=nl),tt=n(e),F=r(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-mfep4l"&&(F.innerHTML=al),lt=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-yo9g3h"&&(N.textContent=rl),it=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-he1w22"&&(Y.textContent=ol),st=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-zum5gu"&&(X.innerHTML=pl),nt=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-16ib0br"&&(D.textContent=ml),at=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-e58kdn"&&(A.innerHTML=Ml),rt=n(e),m(V.$$.fragment,e),ot=n(e),m(P.$$.fragment,e),pt=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-rlddd"&&(O.innerHTML=dl),mt=n(e),m(q.$$.fragment,e),Mt=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-ul3e7v"&&(K.innerHTML=yl),dt=n(e),m(ee.$$.fragment,e),yt=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-14y3jdv"&&(te.textContent=ul),ut=n(e),m(le.$$.fragment,e),ht=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1ime86q"&&(ie.textContent=hl),bt=n(e),m(se.$$.fragment,e),ct=n(e),m(ne.$$.fragment,e),ft=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1xc54m3"&&(ae.innerHTML=bl),wt=n(e),m(re.$$.fragment,e),Tt=n(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-11h35ws"&&(oe.innerHTML=cl),Ut=n(e),m(pe.$$.fragment,e),Jt=n(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1ezgurm"&&(me.innerHTML=fl),jt=n(e),m(Me.$$.fragment,e),$t=n(e),de=r(e,"OL",{"data-svelte-h":!0}),o(de)!=="svelte-lqs4qk"&&(de.innerHTML=wl),Ct=n(e),m(ye.$$.fragment,e),gt=n(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-9ia3cj"&&(ue.innerHTML=Tl),xt=n(e),m(he.$$.fragment,e),vt=n(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1r4mw8p"&&(be.innerHTML=Ul),Lt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-rmvlv2"&&(ce.innerHTML=Jl),Et=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-lecznc"&&(fe.innerHTML=jl),Rt=n(e),m(we.$$.fragment,e),kt=n(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-luhn2w"&&(Te.textContent=$l),It=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-18bjayv"&&(Ue.innerHTML=Cl),Gt=n(e),m(Je.$$.fragment,e),Bt=n(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-18urb29"&&(je.textContent=gl),_t=n(e),m($e.$$.fragment,e),Ht=n(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-kd50n4"&&(Ce.textContent=xl),Qt=n(e),m(ge.$$.fragment,e),Wt=n(e),ve=r(e,"P",{}),vl(ve).forEach(l),this.h()},h(){Ll(b,"name","hf:doc:metadata"),Ll(b,"content",Ql)},m(e,t){_l(document.head,b),i(e,Le,t),i(e,xe,t),i(e,Ee,t),M(f,e,t),i(e,Re,t),i(e,w,t),i(e,ke,t),i(e,T,t),i(e,Ie,t),i(e,U,t),i(e,Ge,t),M(J,e,t),i(e,Be,t),i(e,j,t),i(e,_e,t),i(e,$,t),i(e,He,t),i(e,C,t),i(e,Qe,t),i(e,g,t),i(e,We,t),i(e,x,t),i(e,ze,t),i(e,v,t),i(e,Se,t),M(L,e,t),i(e,Ze,t),i(e,E,t),i(e,Fe,t),M(R,e,t),i(e,Ne,t),i(e,k,t),i(e,Ye,t),i(e,I,t),i(e,Xe,t),i(e,G,t),i(e,De,t),i(e,B,t),i(e,Ae,t),i(e,_,t),i(e,Ve,t),M(H,e,t),i(e,Pe,t),M(Q,e,t),i(e,Oe,t),i(e,W,t),i(e,qe,t),M(z,e,t),i(e,Ke,t),i(e,S,t),i(e,et,t),i(e,Z,t),i(e,tt,t),i(e,F,t),i(e,lt,t),i(e,N,t),i(e,it,t),i(e,Y,t),i(e,st,t),i(e,X,t),i(e,nt,t),i(e,D,t),i(e,at,t),i(e,A,t),i(e,rt,t),M(V,e,t),i(e,ot,t),M(P,e,t),i(e,pt,t),i(e,O,t),i(e,mt,t),M(q,e,t),i(e,Mt,t),i(e,K,t),i(e,dt,t),M(ee,e,t),i(e,yt,t),i(e,te,t),i(e,ut,t),M(le,e,t),i(e,ht,t),i(e,ie,t),i(e,bt,t),M(se,e,t),i(e,ct,t),M(ne,e,t),i(e,ft,t),i(e,ae,t),i(e,wt,t),M(re,e,t),i(e,Tt,t),i(e,oe,t),i(e,Ut,t),M(pe,e,t),i(e,Jt,t),i(e,me,t),i(e,jt,t),M(Me,e,t),i(e,$t,t),i(e,de,t),i(e,Ct,t),M(ye,e,t),i(e,gt,t),i(e,ue,t),i(e,xt,t),M(he,e,t),i(e,vt,t),i(e,be,t),i(e,Lt,t),i(e,ce,t),i(e,Et,t),i(e,fe,t),i(e,Rt,t),M(we,e,t),i(e,kt,t),i(e,Te,t),i(e,It,t),i(e,Ue,t),i(e,Gt,t),M(Je,e,t),i(e,Bt,t),i(e,je,t),i(e,_t,t),M($e,e,t),i(e,Ht,t),i(e,Ce,t),i(e,Qt,t),M(ge,e,t),i(e,Wt,t),i(e,ve,t),zt=!0},p:Rl,i(e){zt||(d(f.$$.fragment,e),d(J.$$.fragment,e),d(L.$$.fragment,e),d(R.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),d(V.$$.fragment,e),d(P.$$.fragment,e),d(q.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(ye.$$.fragment,e),d(he.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d($e.$$.fragment,e),d(ge.$$.fragment,e),zt=!0)},o(e){y(f.$$.fragment,e),y(J.$$.fragment,e),y(L.$$.fragment,e),y(R.$$.fragment,e),y(H.$$.fragment,e),y(Q.$$.fragment,e),y(z.$$.fragment,e),y(V.$$.fragment,e),y(P.$$.fragment,e),y(q.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(ye.$$.fragment,e),y(he.$$.fragment,e),y(we.$$.fragment,e),y(Je.$$.fragment,e),y($e.$$.fragment,e),y(ge.$$.fragment,e),zt=!1},d(e){e&&(l(Le),l(xe),l(Ee),l(Re),l(w),l(ke),l(T),l(Ie),l(U),l(Ge),l(Be),l(j),l(_e),l($),l(He),l(C),l(Qe),l(g),l(We),l(x),l(ze),l(v),l(Se),l(Ze),l(E),l(Fe),l(Ne),l(k),l(Ye),l(I),l(Xe),l(G),l(De),l(B),l(Ae),l(_),l(Ve),l(Pe),l(Oe),l(W),l(qe),l(Ke),l(S),l(et),l(Z),l(tt),l(F),l(lt),l(N),l(it),l(Y),l(st),l(X),l(nt),l(D),l(at),l(A),l(rt),l(ot),l(pt),l(O),l(mt),l(Mt),l(K),l(dt),l(yt),l(te),l(ut),l(ht),l(ie),l(bt),l(ct),l(ft),l(ae),l(wt),l(Tt),l(oe),l(Ut),l(Jt),l(me),l(jt),l($t),l(de),l(Ct),l(gt),l(ue),l(xt),l(vt),l(be),l(Lt),l(ce),l(Et),l(fe),l(Rt),l(kt),l(Te),l(It),l(Ue),l(Gt),l(Bt),l(je),l(_t),l(Ht),l(Ce),l(Qt),l(Wt),l(ve)),l(b),u(f,e),u(J,e),u(L,e),u(R,e),u(H,e),u(Q,e),u(z,e),u(V,e),u(P,e),u(q,e),u(ee,e),u(le,e),u(se,e),u(ne,e),u(re,e),u(pe,e),u(Me,e),u(ye,e),u(he,e),u(we,e),u(Je,e),u($e,e),u(ge,e)}}}const Ql='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"TL;DR","local":"tldr","sections":[],"depth":2},{"title":"Features","local":"features","sections":[],"depth":2},{"title":"Requirements & Installation","local":"requirements--installation","sections":[],"depth":2},{"title":"Using bitsandbytes","local":"using-bitsandbytes","sections":[{"title":"Using Int8 Matrix Multiplication","local":"using-int8-matrix-multiplication","sections":[],"depth":3},{"title":"Using the 8-bit Optimizers","local":"using-the-8-bit-optimizers","sections":[],"depth":3},{"title":"Change Bits and other Hyperparameters for Individual Parameters","local":"change-bits-and-other-hyperparameters-for-individual-parameters","sections":[],"depth":3},{"title":"Fairseq Users","local":"fairseq-users","sections":[],"depth":3}],"depth":2},{"title":"Release and Feature History","local":"release-and-feature-history","sections":[],"depth":2},{"title":"Errors","local":"errors","sections":[],"depth":2},{"title":"Compile from source","local":"compile-from-source","sections":[],"depth":2},{"title":"License","local":"license","sections":[],"depth":2},{"title":"How to cite us","local":"how-to-cite-us","sections":[],"depth":2}],"depth":1}';function Wl(St){return kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fl extends Il{constructor(b){super(),Gl(this,b,Wl,Hl,El,{})}}export{Fl as component};
