import{s as Ve,n as Re,o as qe}from"../chunks/scheduler.b108d059.js";import{S as ze,i as Fe,g as j,s as e,r as i,A as _e,h,f as l,c as n,j as Ye,u as p,x as m,k as Se,y as He,a,v as M,d as o,t as r,w as c}from"../chunks/index.008de539.js";import{H as J,g as Le}from"../chunks/Heading.37e1c838.js";import{C as y}from"../chunks/CodeBlock.3968c746.js";function De(La){let g,Gt,kt,Nt,u,Et,T,Da='A Typescript powered wrapper for the Hugging Face Inference API. Learn more about the Inference API at <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Hugging Face</a>. It also works with <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.',Wt,w,Pa='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how the Inference API works</a>.',vt,f,Xt,d,At,U,Yt,$,St,I,Vt,b,Rt,C,qt,x,zt,B,Ka='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',Ft,Z,Oa="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",_t,k,Ht,Q,se="You can import the functions you need directly from the module instead of using the <code>HfInference</code> class.",Lt,G,Dt,N,te="This will enable tree-shaking by your bundler.",Pt,E,Kt,W,Ot,v,le="Tries to fill in a hole with a missing word (token to be precise).",sl,X,tl,A,ll,Y,ae="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",al,S,el,V,nl,R,ee="Answers questions based on the context you provide.",il,q,pl,z,Ml,F,ol,_,rl,H,ne="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",cl,L,jl,D,hl,P,ie="Generates text from an input prompt.",ml,K,pe='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',Jl,O,yl,ss,gl,ts,Me="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",ul,ls,Tl,as,wl,es,oe="Converts text from one language to another.",fl,ns,dl,is,Ul,ps,re="Checks how well an input text fits into a set of labels you provide.",$l,Ms,Il,os,bl,rs,ce="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",Cl,cs,xl,js,Bl,hs,je="Calculate the semantic similarity between one text and a list of other sentences.",Zl,ms,kl,Js,Ql,ys,Gl,gs,he="Transcribes speech from an audio file.",Nl,us,me='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',El,Ts,Wl,ws,vl,fs,Je="Assigns labels to the given audio along with a probability score of that label.",Xl,ds,ye='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',Al,Us,Yl,$s,Sl,Is,ge="Generates natural-sounding speech from text input.",Vl,bs,Rl,Cs,ql,xs,ue="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",zl,Bs,Fl,Zs,_l,ks,Hl,Qs,Te="Assigns labels to a given image along with a probability score of that label.",Ll,Gs,we='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',Dl,Ns,Pl,Es,Kl,Ws,fe="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",Ol,vs,de='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',sa,Xs,ta,As,la,Ys,Ue="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",aa,Ss,ea,Vs,na,Rs,$e="Outputs text from a given image, commonly used for captioning or optical character recognition.",ia,qs,pa,zs,Ma,Fs,Ie="Creates an image from a text prompt.",oa,_s,be='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',ra,Hs,ca,Ls,ja,Ds,Ce="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",ha,Ps,ma,Ks,Ja,Os,xe="Checks how well an input image fits into a set of labels you provide.",ya,st,ga,tt,ua,lt,Ta,at,Be="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",wa,et,fa,nt,da,it,Ze="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",Ua,pt,ke='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',$a,Mt,Ia,ot,ba,rt,Qe="Document question answering models take a (document, question) pair as input and return an answer in natural language.",Ca,ct,Ge='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',xa,jt,Ba,ht,Za,mt,ka,Jt,Ne="Tabular regression is the task of predicting a numerical value given a set of attributes.",Qa,yt,Ga,gt,Na,ut,Ee="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",Ea,Tt,Wa,wt,va,ft,We="For models with custom parameters / outputs.",Xa,dt,Aa,Ut,Ya,$t,ve='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',Sa,It,Va,bt,Ra,Ct,qa,xt,za,Bt,Xe='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',Fa,Zt,Ae="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",_a,Qt,Ha;return u=new J({props:{title:"🤗 Hugging Face Inference API",local:"-hugging-face-inference-api",headingTag:"h1"}}),f=new J({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),d=new J({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new J({props:{title:"Node",local:"node",headingTag:"h4"}}),$=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),I=new J({props:{title:"Deno",local:"deno",headingTag:"h4"}}),b=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new J({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),x=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZSgneW91ciUyMGFjY2VzcyUyMHRva2VuJyk=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),k=new J({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h4"}}),G=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),E=new J({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),W=new J({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),X=new y({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),A=new J({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),S=new y({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),V=new J({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),q=new y({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),z=new J({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),F=new y({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),_=new J({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),L=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),D=new J({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),O=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),ss=new J({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),ls=new y({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),as=new J({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ns=new y({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUwOSUwOSUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMDklMDklMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTA5JTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
		<span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
		<span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
	}
})`,wrap:!1}}),is=new J({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),Ms=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),os=new J({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),cs=new y({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),js=new J({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),ms=new y({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),Js=new J({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ys=new J({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),Ts=new y({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),ws=new J({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),Us=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),$s=new J({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),bs=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),Cs=new J({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Bs=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Zs=new J({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),ks=new J({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Ns=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),Es=new J({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),Xs=new y({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),As=new J({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),Ss=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),Vs=new J({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),qs=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),zs=new J({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),Hs=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBpbnB1dHMlM0ElMjAnYXdhcmQlMjB3aW5uaW5nJTIwaGlnaCUyMHJlc29sdXRpb24lMjBwaG90byUyMG9mJTIwYSUyMGdpYW50JTIwdG9ydG9pc2UlMkYoKGxhZHliaXJkKSklMjBoeWJyaWQlMkMlMjAlNUJ0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiU1RCclMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNBJTIwJ2JsdXJyeSclMkMlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})`,wrap:!1}}),Ls=new J({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),Ps=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),Ks=new J({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),st=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMjAlMjAlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },  
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),tt=new J({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),lt=new J({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),et=new y({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),nt=new J({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),Mt=new y({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),ot=new J({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),jt=new y({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),ht=new J({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),mt=new J({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),yt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),gt=new J({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),Tt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),wt=new J({props:{title:"Custom Calls",local:"custom-calls",headingTag:"h2"}}),dt=new y({props:{code:"YXdhaXQlMjBoZi5yZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBJTJGJTJGJTIwQ3VzdG9tJTIwc3RyZWFtaW5nJTIwY2FsbCUyQyUyMGZvciUyMG1vZGVscyUyMHdpdGglMjBjdXN0b20lMjBwYXJhbWV0ZXJzJTIwJTJGJTIwb3V0cHV0cyUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi5zdHJlYW1pbmdSZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">request</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})

<span class="hljs-comment">// Custom streaming call, for models with custom parameters / outputs</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">streamingRequest</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})) {
  ...
}`,wrap:!1}}),Ut=new J({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),It=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});`,wrap:!1}}),bt=new J({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),Ct=new y({props:{code:"SEZfQUNDRVNTX1RPS0VOJTNEJTIyeW91ciUyMGFjY2VzcyUyMHRva2VuJTIyJTIwcG5wbSUyMHJ1biUyMHRlc3Q=",highlighted:"HF_ACCESS_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),xt=new J({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),{c(){g=j("meta"),Gt=e(),kt=j("p"),Nt=e(),i(u.$$.fragment),Et=e(),T=j("p"),T.innerHTML=Da,Wt=e(),w=j("p"),w.innerHTML=Pa,vt=e(),i(f.$$.fragment),Xt=e(),i(d.$$.fragment),At=e(),i(U.$$.fragment),Yt=e(),i($.$$.fragment),St=e(),i(I.$$.fragment),Vt=e(),i(b.$$.fragment),Rt=e(),i(C.$$.fragment),qt=e(),i(x.$$.fragment),zt=e(),B=j("p"),B.innerHTML=Ka,Ft=e(),Z=j("p"),Z.textContent=Oa,_t=e(),i(k.$$.fragment),Ht=e(),Q=j("p"),Q.innerHTML=se,Lt=e(),i(G.$$.fragment),Dt=e(),N=j("p"),N.textContent=te,Pt=e(),i(E.$$.fragment),Kt=e(),i(W.$$.fragment),Ot=e(),v=j("p"),v.textContent=le,sl=e(),i(X.$$.fragment),tl=e(),i(A.$$.fragment),ll=e(),Y=j("p"),Y.textContent=ae,al=e(),i(S.$$.fragment),el=e(),i(V.$$.fragment),nl=e(),R=j("p"),R.textContent=ee,il=e(),i(q.$$.fragment),pl=e(),i(z.$$.fragment),Ml=e(),i(F.$$.fragment),ol=e(),i(_.$$.fragment),rl=e(),H=j("p"),H.textContent=ne,cl=e(),i(L.$$.fragment),jl=e(),i(D.$$.fragment),hl=e(),P=j("p"),P.textContent=ie,ml=e(),K=j("p"),K.innerHTML=pe,Jl=e(),i(O.$$.fragment),yl=e(),i(ss.$$.fragment),gl=e(),ts=j("p"),ts.textContent=Me,ul=e(),i(ls.$$.fragment),Tl=e(),i(as.$$.fragment),wl=e(),es=j("p"),es.textContent=oe,fl=e(),i(ns.$$.fragment),dl=e(),i(is.$$.fragment),Ul=e(),ps=j("p"),ps.textContent=re,$l=e(),i(Ms.$$.fragment),Il=e(),i(os.$$.fragment),bl=e(),rs=j("p"),rs.textContent=ce,Cl=e(),i(cs.$$.fragment),xl=e(),i(js.$$.fragment),Bl=e(),hs=j("p"),hs.textContent=je,Zl=e(),i(ms.$$.fragment),kl=e(),i(Js.$$.fragment),Ql=e(),i(ys.$$.fragment),Gl=e(),gs=j("p"),gs.textContent=he,Nl=e(),us=j("p"),us.innerHTML=me,El=e(),i(Ts.$$.fragment),Wl=e(),i(ws.$$.fragment),vl=e(),fs=j("p"),fs.textContent=Je,Xl=e(),ds=j("p"),ds.innerHTML=ye,Al=e(),i(Us.$$.fragment),Yl=e(),i($s.$$.fragment),Sl=e(),Is=j("p"),Is.textContent=ge,Vl=e(),i(bs.$$.fragment),Rl=e(),i(Cs.$$.fragment),ql=e(),xs=j("p"),xs.textContent=ue,zl=e(),i(Bs.$$.fragment),Fl=e(),i(Zs.$$.fragment),_l=e(),i(ks.$$.fragment),Hl=e(),Qs=j("p"),Qs.textContent=Te,Ll=e(),Gs=j("p"),Gs.innerHTML=we,Dl=e(),i(Ns.$$.fragment),Pl=e(),i(Es.$$.fragment),Kl=e(),Ws=j("p"),Ws.textContent=fe,Ol=e(),vs=j("p"),vs.innerHTML=de,sa=e(),i(Xs.$$.fragment),ta=e(),i(As.$$.fragment),la=e(),Ys=j("p"),Ys.textContent=Ue,aa=e(),i(Ss.$$.fragment),ea=e(),i(Vs.$$.fragment),na=e(),Rs=j("p"),Rs.textContent=$e,ia=e(),i(qs.$$.fragment),pa=e(),i(zs.$$.fragment),Ma=e(),Fs=j("p"),Fs.textContent=Ie,oa=e(),_s=j("p"),_s.innerHTML=be,ra=e(),i(Hs.$$.fragment),ca=e(),i(Ls.$$.fragment),ja=e(),Ds=j("p"),Ds.textContent=Ce,ha=e(),i(Ps.$$.fragment),ma=e(),i(Ks.$$.fragment),Ja=e(),Os=j("p"),Os.textContent=xe,ya=e(),i(st.$$.fragment),ga=e(),i(tt.$$.fragment),ua=e(),i(lt.$$.fragment),Ta=e(),at=j("p"),at.textContent=Be,wa=e(),i(et.$$.fragment),fa=e(),i(nt.$$.fragment),da=e(),it=j("p"),it.textContent=Ze,Ua=e(),pt=j("p"),pt.innerHTML=ke,$a=e(),i(Mt.$$.fragment),Ia=e(),i(ot.$$.fragment),ba=e(),rt=j("p"),rt.textContent=Qe,Ca=e(),ct=j("p"),ct.innerHTML=Ge,xa=e(),i(jt.$$.fragment),Ba=e(),i(ht.$$.fragment),Za=e(),i(mt.$$.fragment),ka=e(),Jt=j("p"),Jt.textContent=Ne,Qa=e(),i(yt.$$.fragment),Ga=e(),i(gt.$$.fragment),Na=e(),ut=j("p"),ut.textContent=Ee,Ea=e(),i(Tt.$$.fragment),Wa=e(),i(wt.$$.fragment),va=e(),ft=j("p"),ft.textContent=We,Xa=e(),i(dt.$$.fragment),Aa=e(),i(Ut.$$.fragment),Ya=e(),$t=j("p"),$t.innerHTML=ve,Sa=e(),i(It.$$.fragment),Va=e(),i(bt.$$.fragment),Ra=e(),i(Ct.$$.fragment),qa=e(),i(xt.$$.fragment),za=e(),Bt=j("p"),Bt.innerHTML=Xe,Fa=e(),Zt=j("p"),Zt.textContent=Ae,_a=e(),Qt=j("p"),this.h()},l(s){const t=_e("svelte-u9bgzb",document.head);g=h(t,"META",{name:!0,content:!0}),t.forEach(l),Gt=n(s),kt=h(s,"P",{}),Ye(kt).forEach(l),Nt=n(s),p(u.$$.fragment,s),Et=n(s),T=h(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-8gxt4m"&&(T.innerHTML=Da),Wt=n(s),w=h(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1xxn7kt"&&(w.innerHTML=Pa),vt=n(s),p(f.$$.fragment,s),Xt=n(s),p(d.$$.fragment,s),At=n(s),p(U.$$.fragment,s),Yt=n(s),p($.$$.fragment,s),St=n(s),p(I.$$.fragment,s),Vt=n(s),p(b.$$.fragment,s),Rt=n(s),p(C.$$.fragment,s),qt=n(s),p(x.$$.fragment,s),zt=n(s),B=h(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-ys53zo"&&(B.innerHTML=Ka),Ft=n(s),Z=h(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-2l8ybr"&&(Z.textContent=Oa),_t=n(s),p(k.$$.fragment,s),Ht=n(s),Q=h(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-62skcu"&&(Q.innerHTML=se),Lt=n(s),p(G.$$.fragment,s),Dt=n(s),N=h(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-88xj6h"&&(N.textContent=te),Pt=n(s),p(E.$$.fragment,s),Kt=n(s),p(W.$$.fragment,s),Ot=n(s),v=h(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1mnrr3b"&&(v.textContent=le),sl=n(s),p(X.$$.fragment,s),tl=n(s),p(A.$$.fragment,s),ll=n(s),Y=h(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-4s1xv3"&&(Y.textContent=ae),al=n(s),p(S.$$.fragment,s),el=n(s),p(V.$$.fragment,s),nl=n(s),R=h(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-vnhv92"&&(R.textContent=ee),il=n(s),p(q.$$.fragment,s),pl=n(s),p(z.$$.fragment,s),Ml=n(s),p(F.$$.fragment,s),ol=n(s),p(_.$$.fragment,s),rl=n(s),H=h(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-vlz10z"&&(H.textContent=ne),cl=n(s),p(L.$$.fragment,s),jl=n(s),p(D.$$.fragment,s),hl=n(s),P=h(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-18cimv4"&&(P.textContent=ie),ml=n(s),K=h(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-kjz90x"&&(K.innerHTML=pe),Jl=n(s),p(O.$$.fragment,s),yl=n(s),p(ss.$$.fragment,s),gl=n(s),ts=h(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-qln4hq"&&(ts.textContent=Me),ul=n(s),p(ls.$$.fragment,s),Tl=n(s),p(as.$$.fragment,s),wl=n(s),es=h(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-yinzpl"&&(es.textContent=oe),fl=n(s),p(ns.$$.fragment,s),dl=n(s),p(is.$$.fragment,s),Ul=n(s),ps=h(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-mqluby"&&(ps.textContent=re),$l=n(s),p(Ms.$$.fragment,s),Il=n(s),p(os.$$.fragment,s),bl=n(s),rs=h(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-1wq8md5"&&(rs.textContent=ce),Cl=n(s),p(cs.$$.fragment,s),xl=n(s),p(js.$$.fragment,s),Bl=n(s),hs=h(s,"P",{"data-svelte-h":!0}),m(hs)!=="svelte-tf7teq"&&(hs.textContent=je),Zl=n(s),p(ms.$$.fragment,s),kl=n(s),p(Js.$$.fragment,s),Ql=n(s),p(ys.$$.fragment,s),Gl=n(s),gs=h(s,"P",{"data-svelte-h":!0}),m(gs)!=="svelte-1in7idl"&&(gs.textContent=he),Nl=n(s),us=h(s,"P",{"data-svelte-h":!0}),m(us)!=="svelte-18afluh"&&(us.innerHTML=me),El=n(s),p(Ts.$$.fragment,s),Wl=n(s),p(ws.$$.fragment,s),vl=n(s),fs=h(s,"P",{"data-svelte-h":!0}),m(fs)!=="svelte-12s1din"&&(fs.textContent=Je),Xl=n(s),ds=h(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-1jpdfy8"&&(ds.innerHTML=ye),Al=n(s),p(Us.$$.fragment,s),Yl=n(s),p($s.$$.fragment,s),Sl=n(s),Is=h(s,"P",{"data-svelte-h":!0}),m(Is)!=="svelte-1h8ubig"&&(Is.textContent=ge),Vl=n(s),p(bs.$$.fragment,s),Rl=n(s),p(Cs.$$.fragment,s),ql=n(s),xs=h(s,"P",{"data-svelte-h":!0}),m(xs)!=="svelte-zj5o06"&&(xs.textContent=ue),zl=n(s),p(Bs.$$.fragment,s),Fl=n(s),p(Zs.$$.fragment,s),_l=n(s),p(ks.$$.fragment,s),Hl=n(s),Qs=h(s,"P",{"data-svelte-h":!0}),m(Qs)!=="svelte-1nlp89w"&&(Qs.textContent=Te),Ll=n(s),Gs=h(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-10vvvxx"&&(Gs.innerHTML=we),Dl=n(s),p(Ns.$$.fragment,s),Pl=n(s),p(Es.$$.fragment,s),Kl=n(s),Ws=h(s,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-d15mev"&&(Ws.textContent=fe),Ol=n(s),vs=h(s,"P",{"data-svelte-h":!0}),m(vs)!=="svelte-pxrbuw"&&(vs.innerHTML=de),sa=n(s),p(Xs.$$.fragment,s),ta=n(s),p(As.$$.fragment,s),la=n(s),Ys=h(s,"P",{"data-svelte-h":!0}),m(Ys)!=="svelte-1oenl8f"&&(Ys.textContent=Ue),aa=n(s),p(Ss.$$.fragment,s),ea=n(s),p(Vs.$$.fragment,s),na=n(s),Rs=h(s,"P",{"data-svelte-h":!0}),m(Rs)!=="svelte-66badz"&&(Rs.textContent=$e),ia=n(s),p(qs.$$.fragment,s),pa=n(s),p(zs.$$.fragment,s),Ma=n(s),Fs=h(s,"P",{"data-svelte-h":!0}),m(Fs)!=="svelte-13iv3hh"&&(Fs.textContent=Ie),oa=n(s),_s=h(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-1mgyz4r"&&(_s.innerHTML=be),ra=n(s),p(Hs.$$.fragment,s),ca=n(s),p(Ls.$$.fragment,s),ja=n(s),Ds=h(s,"P",{"data-svelte-h":!0}),m(Ds)!=="svelte-1y7kqaa"&&(Ds.textContent=Ce),ha=n(s),p(Ps.$$.fragment,s),ma=n(s),p(Ks.$$.fragment,s),Ja=n(s),Os=h(s,"P",{"data-svelte-h":!0}),m(Os)!=="svelte-m7q2yg"&&(Os.textContent=xe),ya=n(s),p(st.$$.fragment,s),ga=n(s),p(tt.$$.fragment,s),ua=n(s),p(lt.$$.fragment,s),Ta=n(s),at=h(s,"P",{"data-svelte-h":!0}),m(at)!=="svelte-174b8m1"&&(at.textContent=Be),wa=n(s),p(et.$$.fragment,s),fa=n(s),p(nt.$$.fragment,s),da=n(s),it=h(s,"P",{"data-svelte-h":!0}),m(it)!=="svelte-cnruui"&&(it.textContent=Ze),Ua=n(s),pt=h(s,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-hwgezm"&&(pt.innerHTML=ke),$a=n(s),p(Mt.$$.fragment,s),Ia=n(s),p(ot.$$.fragment,s),ba=n(s),rt=h(s,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-1tpexz3"&&(rt.textContent=Qe),Ca=n(s),ct=h(s,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-hwgezm"&&(ct.innerHTML=Ge),xa=n(s),p(jt.$$.fragment,s),Ba=n(s),p(ht.$$.fragment,s),Za=n(s),p(mt.$$.fragment,s),ka=n(s),Jt=h(s,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1js246c"&&(Jt.textContent=Ne),Qa=n(s),p(yt.$$.fragment,s),Ga=n(s),p(gt.$$.fragment,s),Na=n(s),ut=h(s,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-7l7zu1"&&(ut.textContent=Ee),Ea=n(s),p(Tt.$$.fragment,s),Wa=n(s),p(wt.$$.fragment,s),va=n(s),ft=h(s,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-1uv5lul"&&(ft.textContent=We),Xa=n(s),p(dt.$$.fragment,s),Aa=n(s),p(Ut.$$.fragment,s),Ya=n(s),$t=h(s,"P",{"data-svelte-h":!0}),m($t)!=="svelte-14q869u"&&($t.innerHTML=ve),Sa=n(s),p(It.$$.fragment,s),Va=n(s),p(bt.$$.fragment,s),Ra=n(s),p(Ct.$$.fragment,s),qa=n(s),p(xt.$$.fragment,s),za=n(s),Bt=h(s,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-62a9et"&&(Bt.innerHTML=Xe),Fa=n(s),Zt=h(s,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-1yyf4wc"&&(Zt.textContent=Ae),_a=n(s),Qt=h(s,"P",{}),Ye(Qt).forEach(l),this.h()},h(){Se(g,"name","hf:doc:metadata"),Se(g,"content",Pe)},m(s,t){He(document.head,g),a(s,Gt,t),a(s,kt,t),a(s,Nt,t),M(u,s,t),a(s,Et,t),a(s,T,t),a(s,Wt,t),a(s,w,t),a(s,vt,t),M(f,s,t),a(s,Xt,t),M(d,s,t),a(s,At,t),M(U,s,t),a(s,Yt,t),M($,s,t),a(s,St,t),M(I,s,t),a(s,Vt,t),M(b,s,t),a(s,Rt,t),M(C,s,t),a(s,qt,t),M(x,s,t),a(s,zt,t),a(s,B,t),a(s,Ft,t),a(s,Z,t),a(s,_t,t),M(k,s,t),a(s,Ht,t),a(s,Q,t),a(s,Lt,t),M(G,s,t),a(s,Dt,t),a(s,N,t),a(s,Pt,t),M(E,s,t),a(s,Kt,t),M(W,s,t),a(s,Ot,t),a(s,v,t),a(s,sl,t),M(X,s,t),a(s,tl,t),M(A,s,t),a(s,ll,t),a(s,Y,t),a(s,al,t),M(S,s,t),a(s,el,t),M(V,s,t),a(s,nl,t),a(s,R,t),a(s,il,t),M(q,s,t),a(s,pl,t),M(z,s,t),a(s,Ml,t),M(F,s,t),a(s,ol,t),M(_,s,t),a(s,rl,t),a(s,H,t),a(s,cl,t),M(L,s,t),a(s,jl,t),M(D,s,t),a(s,hl,t),a(s,P,t),a(s,ml,t),a(s,K,t),a(s,Jl,t),M(O,s,t),a(s,yl,t),M(ss,s,t),a(s,gl,t),a(s,ts,t),a(s,ul,t),M(ls,s,t),a(s,Tl,t),M(as,s,t),a(s,wl,t),a(s,es,t),a(s,fl,t),M(ns,s,t),a(s,dl,t),M(is,s,t),a(s,Ul,t),a(s,ps,t),a(s,$l,t),M(Ms,s,t),a(s,Il,t),M(os,s,t),a(s,bl,t),a(s,rs,t),a(s,Cl,t),M(cs,s,t),a(s,xl,t),M(js,s,t),a(s,Bl,t),a(s,hs,t),a(s,Zl,t),M(ms,s,t),a(s,kl,t),M(Js,s,t),a(s,Ql,t),M(ys,s,t),a(s,Gl,t),a(s,gs,t),a(s,Nl,t),a(s,us,t),a(s,El,t),M(Ts,s,t),a(s,Wl,t),M(ws,s,t),a(s,vl,t),a(s,fs,t),a(s,Xl,t),a(s,ds,t),a(s,Al,t),M(Us,s,t),a(s,Yl,t),M($s,s,t),a(s,Sl,t),a(s,Is,t),a(s,Vl,t),M(bs,s,t),a(s,Rl,t),M(Cs,s,t),a(s,ql,t),a(s,xs,t),a(s,zl,t),M(Bs,s,t),a(s,Fl,t),M(Zs,s,t),a(s,_l,t),M(ks,s,t),a(s,Hl,t),a(s,Qs,t),a(s,Ll,t),a(s,Gs,t),a(s,Dl,t),M(Ns,s,t),a(s,Pl,t),M(Es,s,t),a(s,Kl,t),a(s,Ws,t),a(s,Ol,t),a(s,vs,t),a(s,sa,t),M(Xs,s,t),a(s,ta,t),M(As,s,t),a(s,la,t),a(s,Ys,t),a(s,aa,t),M(Ss,s,t),a(s,ea,t),M(Vs,s,t),a(s,na,t),a(s,Rs,t),a(s,ia,t),M(qs,s,t),a(s,pa,t),M(zs,s,t),a(s,Ma,t),a(s,Fs,t),a(s,oa,t),a(s,_s,t),a(s,ra,t),M(Hs,s,t),a(s,ca,t),M(Ls,s,t),a(s,ja,t),a(s,Ds,t),a(s,ha,t),M(Ps,s,t),a(s,ma,t),M(Ks,s,t),a(s,Ja,t),a(s,Os,t),a(s,ya,t),M(st,s,t),a(s,ga,t),M(tt,s,t),a(s,ua,t),M(lt,s,t),a(s,Ta,t),a(s,at,t),a(s,wa,t),M(et,s,t),a(s,fa,t),M(nt,s,t),a(s,da,t),a(s,it,t),a(s,Ua,t),a(s,pt,t),a(s,$a,t),M(Mt,s,t),a(s,Ia,t),M(ot,s,t),a(s,ba,t),a(s,rt,t),a(s,Ca,t),a(s,ct,t),a(s,xa,t),M(jt,s,t),a(s,Ba,t),M(ht,s,t),a(s,Za,t),M(mt,s,t),a(s,ka,t),a(s,Jt,t),a(s,Qa,t),M(yt,s,t),a(s,Ga,t),M(gt,s,t),a(s,Na,t),a(s,ut,t),a(s,Ea,t),M(Tt,s,t),a(s,Wa,t),M(wt,s,t),a(s,va,t),a(s,ft,t),a(s,Xa,t),M(dt,s,t),a(s,Aa,t),M(Ut,s,t),a(s,Ya,t),a(s,$t,t),a(s,Sa,t),M(It,s,t),a(s,Va,t),M(bt,s,t),a(s,Ra,t),M(Ct,s,t),a(s,qa,t),M(xt,s,t),a(s,za,t),a(s,Bt,t),a(s,Fa,t),a(s,Zt,t),a(s,_a,t),a(s,Qt,t),Ha=!0},p:Re,i(s){Ha||(o(u.$$.fragment,s),o(f.$$.fragment,s),o(d.$$.fragment,s),o(U.$$.fragment,s),o($.$$.fragment,s),o(I.$$.fragment,s),o(b.$$.fragment,s),o(C.$$.fragment,s),o(x.$$.fragment,s),o(k.$$.fragment,s),o(G.$$.fragment,s),o(E.$$.fragment,s),o(W.$$.fragment,s),o(X.$$.fragment,s),o(A.$$.fragment,s),o(S.$$.fragment,s),o(V.$$.fragment,s),o(q.$$.fragment,s),o(z.$$.fragment,s),o(F.$$.fragment,s),o(_.$$.fragment,s),o(L.$$.fragment,s),o(D.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ls.$$.fragment,s),o(as.$$.fragment,s),o(ns.$$.fragment,s),o(is.$$.fragment,s),o(Ms.$$.fragment,s),o(os.$$.fragment,s),o(cs.$$.fragment,s),o(js.$$.fragment,s),o(ms.$$.fragment,s),o(Js.$$.fragment,s),o(ys.$$.fragment,s),o(Ts.$$.fragment,s),o(ws.$$.fragment,s),o(Us.$$.fragment,s),o($s.$$.fragment,s),o(bs.$$.fragment,s),o(Cs.$$.fragment,s),o(Bs.$$.fragment,s),o(Zs.$$.fragment,s),o(ks.$$.fragment,s),o(Ns.$$.fragment,s),o(Es.$$.fragment,s),o(Xs.$$.fragment,s),o(As.$$.fragment,s),o(Ss.$$.fragment,s),o(Vs.$$.fragment,s),o(qs.$$.fragment,s),o(zs.$$.fragment,s),o(Hs.$$.fragment,s),o(Ls.$$.fragment,s),o(Ps.$$.fragment,s),o(Ks.$$.fragment,s),o(st.$$.fragment,s),o(tt.$$.fragment,s),o(lt.$$.fragment,s),o(et.$$.fragment,s),o(nt.$$.fragment,s),o(Mt.$$.fragment,s),o(ot.$$.fragment,s),o(jt.$$.fragment,s),o(ht.$$.fragment,s),o(mt.$$.fragment,s),o(yt.$$.fragment,s),o(gt.$$.fragment,s),o(Tt.$$.fragment,s),o(wt.$$.fragment,s),o(dt.$$.fragment,s),o(Ut.$$.fragment,s),o(It.$$.fragment,s),o(bt.$$.fragment,s),o(Ct.$$.fragment,s),o(xt.$$.fragment,s),Ha=!0)},o(s){r(u.$$.fragment,s),r(f.$$.fragment,s),r(d.$$.fragment,s),r(U.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r(x.$$.fragment,s),r(k.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(W.$$.fragment,s),r(X.$$.fragment,s),r(A.$$.fragment,s),r(S.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(z.$$.fragment,s),r(F.$$.fragment,s),r(_.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(O.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(ns.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(js.$$.fragment,s),r(ms.$$.fragment,s),r(Js.$$.fragment,s),r(ys.$$.fragment,s),r(Ts.$$.fragment,s),r(ws.$$.fragment,s),r(Us.$$.fragment,s),r($s.$$.fragment,s),r(bs.$$.fragment,s),r(Cs.$$.fragment,s),r(Bs.$$.fragment,s),r(Zs.$$.fragment,s),r(ks.$$.fragment,s),r(Ns.$$.fragment,s),r(Es.$$.fragment,s),r(Xs.$$.fragment,s),r(As.$$.fragment,s),r(Ss.$$.fragment,s),r(Vs.$$.fragment,s),r(qs.$$.fragment,s),r(zs.$$.fragment,s),r(Hs.$$.fragment,s),r(Ls.$$.fragment,s),r(Ps.$$.fragment,s),r(Ks.$$.fragment,s),r(st.$$.fragment,s),r(tt.$$.fragment,s),r(lt.$$.fragment,s),r(et.$$.fragment,s),r(nt.$$.fragment,s),r(Mt.$$.fragment,s),r(ot.$$.fragment,s),r(jt.$$.fragment,s),r(ht.$$.fragment,s),r(mt.$$.fragment,s),r(yt.$$.fragment,s),r(gt.$$.fragment,s),r(Tt.$$.fragment,s),r(wt.$$.fragment,s),r(dt.$$.fragment,s),r(Ut.$$.fragment,s),r(It.$$.fragment,s),r(bt.$$.fragment,s),r(Ct.$$.fragment,s),r(xt.$$.fragment,s),Ha=!1},d(s){s&&(l(Gt),l(kt),l(Nt),l(Et),l(T),l(Wt),l(w),l(vt),l(Xt),l(At),l(Yt),l(St),l(Vt),l(Rt),l(qt),l(zt),l(B),l(Ft),l(Z),l(_t),l(Ht),l(Q),l(Lt),l(Dt),l(N),l(Pt),l(Kt),l(Ot),l(v),l(sl),l(tl),l(ll),l(Y),l(al),l(el),l(nl),l(R),l(il),l(pl),l(Ml),l(ol),l(rl),l(H),l(cl),l(jl),l(hl),l(P),l(ml),l(K),l(Jl),l(yl),l(gl),l(ts),l(ul),l(Tl),l(wl),l(es),l(fl),l(dl),l(Ul),l(ps),l($l),l(Il),l(bl),l(rs),l(Cl),l(xl),l(Bl),l(hs),l(Zl),l(kl),l(Ql),l(Gl),l(gs),l(Nl),l(us),l(El),l(Wl),l(vl),l(fs),l(Xl),l(ds),l(Al),l(Yl),l(Sl),l(Is),l(Vl),l(Rl),l(ql),l(xs),l(zl),l(Fl),l(_l),l(Hl),l(Qs),l(Ll),l(Gs),l(Dl),l(Pl),l(Kl),l(Ws),l(Ol),l(vs),l(sa),l(ta),l(la),l(Ys),l(aa),l(ea),l(na),l(Rs),l(ia),l(pa),l(Ma),l(Fs),l(oa),l(_s),l(ra),l(ca),l(ja),l(Ds),l(ha),l(ma),l(Ja),l(Os),l(ya),l(ga),l(ua),l(Ta),l(at),l(wa),l(fa),l(da),l(it),l(Ua),l(pt),l($a),l(Ia),l(ba),l(rt),l(Ca),l(ct),l(xa),l(Ba),l(Za),l(ka),l(Jt),l(Qa),l(Ga),l(Na),l(ut),l(Ea),l(Wa),l(va),l(ft),l(Xa),l(Aa),l(Ya),l($t),l(Sa),l(Va),l(Ra),l(qa),l(za),l(Bt),l(Fa),l(Zt),l(_a),l(Qt)),l(g),c(u,s),c(f,s),c(d,s),c(U,s),c($,s),c(I,s),c(b,s),c(C,s),c(x,s),c(k,s),c(G,s),c(E,s),c(W,s),c(X,s),c(A,s),c(S,s),c(V,s),c(q,s),c(z,s),c(F,s),c(_,s),c(L,s),c(D,s),c(O,s),c(ss,s),c(ls,s),c(as,s),c(ns,s),c(is,s),c(Ms,s),c(os,s),c(cs,s),c(js,s),c(ms,s),c(Js,s),c(ys,s),c(Ts,s),c(ws,s),c(Us,s),c($s,s),c(bs,s),c(Cs,s),c(Bs,s),c(Zs,s),c(ks,s),c(Ns,s),c(Es,s),c(Xs,s),c(As,s),c(Ss,s),c(Vs,s),c(qs,s),c(zs,s),c(Hs,s),c(Ls,s),c(Ps,s),c(Ks,s),c(st,s),c(tt,s),c(lt,s),c(et,s),c(nt,s),c(Mt,s),c(ot,s),c(jt,s),c(ht,s),c(mt,s),c(yt,s),c(gt,s),c(Tt,s),c(wt,s),c(dt,s),c(Ut,s),c(It,s),c(bt,s),c(Ct,s),c(xt,s)}}}const Pe='{"title":"🤗 Hugging Face Inference API","local":"-hugging-face-inference-api","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Calls","local":"custom-calls","sections":[],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2}],"depth":1}';function Ke(La){return qe(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Le}),[]}class an extends ze{constructor(g){super(),Fe(this,g,Ke,De,Ve,{})}}export{an as component};
