import{s as tp,n as lp,o as ap}from"../chunks/scheduler.7bc62968.js";import{S as ep,i as np,g as h,s as e,r as p,A as pp,h as j,f as l,c as n,j as On,u as i,x as J,k as sp,y as ip,a,v as M,d as o,t as r,w as c}from"../chunks/index.66556066.js";import{C as y}from"../chunks/CodeBlock.a759539a.js";import{H as m,E as Mp}from"../chunks/EditOnGithub.46ca76a5.js";function op(ze){let u,el,ll,nl,T,pl,w,He=`A Typescript powered wrapper for the Hugging Face Inference API (serverless), Inference Endpoints (dedicated), and third-party Inference Providers.
It works with <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API (serverless)</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints (dedicated)</a>, and even with supported third-party Inference Providers.`,il,f,Fe='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how Inference Endpoints works</a>.',Ml,d,ol,g,rl,U,cl,I,hl,$,jl,b,Jl,C,ml,B,yl,x,_e='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',ul,k,Le="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",Tl,Z,wl,G,De="You can send inference requests to third-party providers with the inference client.",fl,Q,Pe='Currently, we support the following providers: <a href="https://fal.ai" rel="nofollow">Fal.ai</a>, <a href="https://replicate.com" rel="nofollow">Replicate</a>, <a href="https://together.xyz" rel="nofollow">Together</a> and <a href="https://sambanova.ai" rel="nofollow">Sambanova</a>.',dl,N,Ke="To send requests to a third-party provider, you have to pass the <code>provider</code> parameter to the inference function. Make sure your request is authenticated with an access token.",gl,E,Ul,v,Oe=`When authenticated with a Hugging Face access token, the request is routed through <a href="https://huggingface.co." rel="nofollow">https://huggingface.co.</a>
When authenticated with a third-party provider key, the request is made directly against that provider’s inference API.`,Il,W,sn="Only a subset of models are supported when requesting third-party providers. You can check the list of supported models per pipeline tasks here:",$l,Y,tn='<li><a href="./src/providers/fal-ai.ts">Fal.ai supported models</a></li> <li><a href="./src/providers/replicate.ts">Replicate supported models</a></li> <li><a href="./src/providers/sambanova.ts">Sambanova supported models</a></li> <li><a href="./src/providers/together.ts">Together supported models</a></li> <li><a href="https://huggingface.co/models?inference=warm&amp;sort=trending" rel="nofollow">HF Inference API (serverless)</a></li>',bl,A,ln=`❗<strong>Important note:</strong> To be compatible, the third-party API must adhere to the “standard” shape API we expect on HF model pages for each pipeline task type.
This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there exists no standard API. Let us know if any help is needed or if we can make things easier for you!`,Cl,X,an='👋<strong>Want to add another provider?</strong> Get in touch if you’d like to add support for another Inference provider, and/or request it on <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49</a>',Bl,S,xl,V,en="You can import the functions you need directly from the module instead of using the <code>HfInference</code> class.",kl,R,Zl,q,nn="This will enable tree-shaking by your bundler.",Gl,z,Ql,H,Nl,F,pn="Generates text from an input prompt.",El,_,Mn='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',vl,L,Wl,D,Yl,P,on='Using the <code>chatCompletion</code> method, you can generate text with models compatible with the OpenAI Chat Completion API. All models served by <a href="https://api-inference.huggingface.co/framework/text-generation-inference" rel="nofollow">TGI</a> on Hugging Face support Messages API.',Al,K,rn='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-chat-completion" rel="nofollow">Demo</a>',Xl,O,Sl,ss,cn="It’s also possible to call Mistral or OpenAI endpoints directly:",Vl,ts,Rl,ls,ql,as,hn="Tries to fill in a hole with a missing word (token to be precise).",zl,es,Hl,ns,Fl,ps,jn="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",_l,is,Ll,Ms,Dl,os,Jn="Answers questions based on the context you provide.",Pl,rs,Kl,cs,Ol,hs,sa,js,ta,Js,mn="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",la,ms,aa,ys,ea,us,yn="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",na,Ts,pa,ws,ia,fs,un="Converts text from one language to another.",Ma,ds,oa,gs,ra,Us,Tn="Checks how well an input text fits into a set of labels you provide.",ca,Is,ha,$s,ja,bs,wn="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",Ja,Cs,ma,Bs,ya,xs,fn="Calculate the semantic similarity between one text and a list of other sentences.",ua,ks,Ta,Zs,wa,Gs,fa,Qs,dn="Transcribes speech from an audio file.",da,Ns,gn='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',ga,Es,Ua,vs,Ia,Ws,Un="Assigns labels to the given audio along with a probability score of that label.",$a,Ys,In='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',ba,As,Ca,Xs,Ba,Ss,$n="Generates natural-sounding speech from text input.",xa,Vs,bn='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',ka,Rs,Za,qs,Ga,zs,Cn="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",Qa,Hs,Na,Fs,Ea,_s,va,Ls,Bn="Assigns labels to a given image along with a probability score of that label.",Wa,Ds,xn='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',Ya,Ps,Aa,Ks,Xa,Os,kn="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",Sa,st,Zn='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',Va,tt,Ra,lt,qa,at,Gn="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",za,et,Ha,nt,Fa,pt,Qn="Outputs text from a given image, commonly used for captioning or optical character recognition.",_a,it,La,Mt,Da,ot,Nn="Creates an image from a text prompt.",Pa,rt,En='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',Ka,ct,Oa,ht,se,jt,vn="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",te,Jt,Wn='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',le,mt,ae,yt,ee,ut,Yn="Checks how well an input image fits into a set of labels you provide.",ne,Tt,pe,wt,ie,ft,Me,dt,An="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",oe,gt,re,Ut,ce,It,Xn="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",he,$t,Sn='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',je,bt,Je,Ct,me,Bt,Vn="Document question answering models take a (document, question) pair as input and return an answer in natural language.",ye,xt,Rn='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',ue,kt,Te,Zt,we,Gt,fe,Qt,qn="Tabular regression is the task of predicting a numerical value given a set of attributes.",de,Nt,ge,Et,Ue,vt,zn="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",Ie,Wt,$e,Yt,be,At,Hn="For models with custom parameters / outputs.",Ce,Xt,Be,St,Fn="You can use any Chat Completion API-compatible provider with the <code>chatCompletion</code> method.",xe,Vt,ke,Rt,Ze,qt,_n='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',Ge,zt,Qe,Ht,Ln=`By default, all calls to the inference endpoint will wait until the model is
loaded. When <a href="https://huggingface.co/docs/inference-endpoints/en/autoscaling#scaling-to-0" rel="nofollow">scaling to
0</a>
is enabled on the endpoint, this can result in non-trivial waiting time. If
you’d rather disable this behavior and handle the endpoint’s returned 500 HTTP
errors yourself, you can do so like so:`,Ne,Ft,Ee,_t,ve,Lt,We,Dt,Ye,Pt,Dn='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',Ae,Kt,Pn="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",Xe,Ot,Se,sl,Kn="<li><code>@huggingface/tasks</code> : Typings only</li>",Ve,tl,Re,al,qe;return T=new m({props:{title:"🤗 Hugging Face Inference Endpoints",local:"-hugging-face-inference-endpoints",headingTag:"h1"}}),d=new m({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),g=new m({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new m({props:{title:"Node",local:"node",headingTag:"h4"}}),I=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),$=new m({props:{title:"Deno",local:"deno",headingTag:"h4"}}),b=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new m({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),B=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZSgneW91ciUyMGFjY2VzcyUyMHRva2VuJyk=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),Z=new m({props:{title:"Third-party inference providers",local:"third-party-inference-providers",headingTag:"h3"}}),E=new y({props:{code:"Y29uc3QlMjBhY2Nlc3NUb2tlbiUyMCUzRCUyMCUyMmhmXy4uLiUyMiUzQiUyMCUyRiUyRiUyMEVpdGhlciUyMGElMjBIRiUyMGFjY2VzcyUyMHRva2VuJTJDJTIwb3IlMjBhbiUyMEFQSSUyMGtleSUyMGZyb20lMjB0aGUlMjB0aGlyZC1wYXJ0eSUyMHByb3ZpZGVyJTIwKFJlcGxpY2F0ZSUyMGluJTIwdGhpcyUyMGV4YW1wbGUpJTBBJTBBY29uc3QlMjBjbGllbnQlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZShhY2Nlc3NUb2tlbiklM0IlMEFhd2FpdCUyMGNsaWVudC50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBwcm92aWRlciUzQSUyMCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMG1vZGVsJTNBJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtZGV2JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyQSUyMGJsYWNrJTIwZm9yZXN0JTIwY2FrZSUyMiUwQSU3RCk=",highlighted:`<span class="hljs-keyword">const</span> accessToken = <span class="hljs-string">&quot;hf_...&quot;</span>; <span class="hljs-comment">// Either a HF access token, or an API key from the third-party provider (Replicate in this example)</span>

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(accessToken);
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>,
  <span class="hljs-attr">model</span>:<span class="hljs-string">&quot;black-forest-labs/Flux.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;A black forest cake&quot;</span>
})`,wrap:!1}}),S=new m({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h3"}}),R=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),z=new m({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),H=new m({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),L=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),D=new m({props:{title:"Text Generation (Chat Completion API Compatible)",local:"text-generation-chat-completion-api-compatible",headingTag:"h3"}}),O=new y({props:{code:"JTJGJTJGJTIwTm9uLXN0cmVhbWluZyUyMEFQSSUwQWNvbnN0JTIwb3V0JTIwJTNEJTIwYXdhaXQlMjBoZi5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkhlbGxvJTJDJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlMjAlN0QlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwU3RyZWFtaW5nJTIwQVBJJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwaGYuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDYW4lMjB5b3UlMjBoZWxwJTIwbWUlMjBzb2x2ZSUyMGFuJTIwZXF1YXRpb24lM0YlMjIlMjAlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGlmJTIwKGNodW5rLmNob2ljZXMlMjAlMjYlMjYlMjBjaHVuay5jaG9pY2VzLmxlbmd0aCUyMCUzRSUyMDApJTIwJTdCJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTJCJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-comment">// Non-streaming API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
});

<span class="hljs-comment">// Streaming API</span>
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Can you help me solve an equation?&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}`,wrap:!1}}),ts=new y({props:{code:"Y29uc3QlMjBvcGVuYWklMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZShPUEVOQUlfVE9LRU4pLmVuZHBvaW50KCUyMmh0dHBzJTNBJTJGJTJGYXBpLm9wZW5haS5jb20lMjIpJTNCJTBBJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwb3BlbmFpLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIyZ3B0LTMuNS10dXJibyUyMiUyQyUwQSUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyQ29tcGxldGUlMjB0aGUlMjBlcXVhdGlvbiUyMDElMkIxJTNEJTIwJTJDanVzdCUyMHRoZSUyMGFuc3dlciUyMiUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0ElMjA1MDAlMkMlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuMSUyQyUwQSUyMCUyMHNlZWQlM0ElMjAwJTJDJTBBJTdEKSklMjAlN0IlMEElMjAlMjBpZiUyMChjaHVuay5jaG9pY2VzJTIwJTI2JTI2JTIwY2h1bmsuY2hvaWNlcy5sZW5ndGglMjAlM0UlMjAwKSUyMCU3QiUwQSUyMCUyMCUyMCUyMG91dCUyMCUyQiUzRCUyMGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlM0IlMEElMjAlMjAlN0QlMEElN0QlMEElMEElMkYlMkYlMjBGb3IlMjBtaXN0cmFsJTIwQUklM0ElMEElMkYlMkYlMjBlbmRwb2ludFVybCUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGYXBpLm1pc3RyYWwuYWklMjIlMEElMkYlMkYlMjBtb2RlbCUzQSUyMCUyMm1pc3RyYWwtdGlueSUyMg==",highlighted:`<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">OPENAI_TOKEN</span>).<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.openai.com&quot;</span>);

<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> openai.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;gpt-3.5-turbo&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}

<span class="hljs-comment">// For mistral AI:</span>
<span class="hljs-comment">// endpointUrl: &quot;https://api.mistral.ai&quot;</span>
<span class="hljs-comment">// model: &quot;mistral-tiny&quot;</span>`,wrap:!1}}),ls=new m({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),es=new y({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),ns=new m({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),is=new y({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),Ms=new m({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),rs=new y({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),cs=new m({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),hs=new y({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),js=new m({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),ms=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),ys=new m({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),Ts=new y({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),ws=new m({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ds=new y({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMjAlMjAlMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
  <span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
  <span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
 }
})`,wrap:!1}}),gs=new m({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),Is=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),$s=new m({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),Cs=new y({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),Bs=new m({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),ks=new y({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),Zs=new m({props:{title:"Audio",local:"audio",headingTag:"h2"}}),Gs=new m({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),Es=new y({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),vs=new m({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),As=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Xs=new m({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),Rs=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),qs=new m({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Hs=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Fs=new m({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),_s=new m({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Ps=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),Ks=new m({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),tt=new y({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),lt=new m({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),et=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),nt=new m({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),it=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),Mt=new m({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),ct=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2ElMjBwaWN0dXJlJTIwb2YlMjBhJTIwZ3JlZW4lMjBiaXJkJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;a picture of a green bird&#x27;</span>
})`,wrap:!1}}),ht=new m({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),mt=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),yt=new m({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),Tt=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMjAlMjAlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },  
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),wt=new m({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),ft=new m({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),gt=new y({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),Ut=new m({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),bt=new y({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),Ct=new m({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),kt=new y({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),Zt=new m({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),Gt=new m({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),Nt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),Et=new m({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),Wt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),Yt=new m({props:{title:"Custom Calls",local:"custom-calls",headingTag:"h2"}}),Xt=new y({props:{code:"YXdhaXQlMjBoZi5yZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBJTJGJTJGJTIwQ3VzdG9tJTIwc3RyZWFtaW5nJTIwY2FsbCUyQyUyMGZvciUyMG1vZGVscyUyMHdpdGglMjBjdXN0b20lMjBwYXJhbWV0ZXJzJTIwJTJGJTIwb3V0cHV0cyUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi5zdHJlYW1pbmdSZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">request</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})

<span class="hljs-comment">// Custom streaming call, for models with custom parameters / outputs</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">streamingRequest</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})) {
  ...
}`,wrap:!1}}),Vt=new y({props:{code:"JTJGJTJGJTIwQ2hhdCUyMENvbXBsZXRpb24lMjBFeGFtcGxlJTBBY29uc3QlMjBNSVNUUkFMX0tFWSUyMCUzRCUyMHByb2Nlc3MuZW52Lk1JU1RSQUxfS0VZJTNCJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEhmSW5mZXJlbmNlKE1JU1RSQUxfS0VZKSUzQiUwQWNvbnN0JTIwZXAlMjAlM0QlMjBoZi5lbmRwb2ludCglMjJodHRwcyUzQSUyRiUyRmFwaS5taXN0cmFsLmFpJTIyKSUzQiUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwZXAuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtaXN0cmFsLXRpbnklMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkNvbXBsZXRlJTIwdGhlJTIwZXF1YXRpb24lMjBvbmUlMjAlMkIlMjBvbmUlMjAlM0QlMjAlMkMlMjBqdXN0JTIwdGhlJTIwYW5zd2VyJTIyJTIwJTdEJTVEJTJDJTBBJTdEKSUzQiUwQWxldCUyMG91dCUyMCUzRCUyMCUyMiUyMiUzQiUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwY2h1bmslMjBvZiUyMHN0cmVhbSklMjAlN0IlMEElMjAlMjBpZiUyMChjaHVuay5jaG9pY2VzJTIwJTI2JTI2JTIwY2h1bmsuY2hvaWNlcy5sZW5ndGglMjAlM0UlMjAwKSUyMCU3QiUwQSUyMCUyMCUyMCUyMG91dCUyMCUyQiUzRCUyMGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlM0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmxvZyhvdXQpJTNCJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">MISTRAL_KEY</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">MISTRAL_KEY</span>;
<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">MISTRAL_KEY</span>);
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.mistral.ai&quot;</span>);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistral-tiny&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation one + one = , just the answer&quot;</span> }],
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),Rt=new m({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),zt=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0IlMEElMEElMkYlMkYlMjBDaGF0JTIwQ29tcGxldGlvbiUyMEV4YW1wbGUlMEFjb25zdCUyMGVwJTIwJTNEJTIwaGYuZW5kcG9pbnQoJTBBJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGbWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiUwQSklM0IlMEFjb25zdCUyMHN0cmVhbSUyMCUzRCUyMGVwLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDb21wbGV0ZSUyMHRoZSUyMGVxdWF0aW9uJTIwMSUyQjElM0QlMjAlMkNqdXN0JTIwdGhlJTIwYW5zd2VyJTIyJTIwJTdEJTVEJTJDJTBBJTIwJTIwbWF4X3Rva2VucyUzQSUyMDUwMCUyQyUwQSUyMCUyMHRlbXBlcmF0dXJlJTNBJTIwMC4xJTJDJTBBJTIwJTIwc2VlZCUzQSUyMDAlMkMlMEElN0QpJTNCJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMGlmJTIwKGNodW5rLmNob2ljZXMlMjAlMjYlMjYlMjBjaHVuay5jaG9pY2VzLmxlbmd0aCUyMCUzRSUyMDApJTIwJTdCJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTJCJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUzQiUwQSUyMCUyMCUyMCUyMGNvbnNvbGUubG9nKG91dCklM0IlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});

<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://api-inference.huggingface.co/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),Ft=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglMEElMjAlMjAlN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCUyQyUwQSUyMCUyMCU3QnJldHJ5X29uX2Vycm9yJTNBJTIwZmFsc2UlN0QlMkMlMEEpJTNC",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>(
  {<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>},
  {<span class="hljs-attr">retry_on_error</span>: <span class="hljs-literal">false</span>},
);`,wrap:!1}}),_t=new m({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),Lt=new y({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),Dt=new m({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),Ot=new m({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),tl=new Mp({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/inference/README.md"}}),{c(){u=h("meta"),el=e(),ll=h("p"),nl=e(),p(T.$$.fragment),pl=e(),w=h("p"),w.innerHTML=He,il=e(),f=h("p"),f.innerHTML=Fe,Ml=e(),p(d.$$.fragment),ol=e(),p(g.$$.fragment),rl=e(),p(U.$$.fragment),cl=e(),p(I.$$.fragment),hl=e(),p($.$$.fragment),jl=e(),p(b.$$.fragment),Jl=e(),p(C.$$.fragment),ml=e(),p(B.$$.fragment),yl=e(),x=h("p"),x.innerHTML=_e,ul=e(),k=h("p"),k.textContent=Le,Tl=e(),p(Z.$$.fragment),wl=e(),G=h("p"),G.textContent=De,fl=e(),Q=h("p"),Q.innerHTML=Pe,dl=e(),N=h("p"),N.innerHTML=Ke,gl=e(),p(E.$$.fragment),Ul=e(),v=h("p"),v.innerHTML=Oe,Il=e(),W=h("p"),W.textContent=sn,$l=e(),Y=h("ul"),Y.innerHTML=tn,bl=e(),A=h("p"),A.innerHTML=ln,Cl=e(),X=h("p"),X.innerHTML=an,Bl=e(),p(S.$$.fragment),xl=e(),V=h("p"),V.innerHTML=en,kl=e(),p(R.$$.fragment),Zl=e(),q=h("p"),q.textContent=nn,Gl=e(),p(z.$$.fragment),Ql=e(),p(H.$$.fragment),Nl=e(),F=h("p"),F.textContent=pn,El=e(),_=h("p"),_.innerHTML=Mn,vl=e(),p(L.$$.fragment),Wl=e(),p(D.$$.fragment),Yl=e(),P=h("p"),P.innerHTML=on,Al=e(),K=h("p"),K.innerHTML=rn,Xl=e(),p(O.$$.fragment),Sl=e(),ss=h("p"),ss.textContent=cn,Vl=e(),p(ts.$$.fragment),Rl=e(),p(ls.$$.fragment),ql=e(),as=h("p"),as.textContent=hn,zl=e(),p(es.$$.fragment),Hl=e(),p(ns.$$.fragment),Fl=e(),ps=h("p"),ps.textContent=jn,_l=e(),p(is.$$.fragment),Ll=e(),p(Ms.$$.fragment),Dl=e(),os=h("p"),os.textContent=Jn,Pl=e(),p(rs.$$.fragment),Kl=e(),p(cs.$$.fragment),Ol=e(),p(hs.$$.fragment),sa=e(),p(js.$$.fragment),ta=e(),Js=h("p"),Js.textContent=mn,la=e(),p(ms.$$.fragment),aa=e(),p(ys.$$.fragment),ea=e(),us=h("p"),us.textContent=yn,na=e(),p(Ts.$$.fragment),pa=e(),p(ws.$$.fragment),ia=e(),fs=h("p"),fs.textContent=un,Ma=e(),p(ds.$$.fragment),oa=e(),p(gs.$$.fragment),ra=e(),Us=h("p"),Us.textContent=Tn,ca=e(),p(Is.$$.fragment),ha=e(),p($s.$$.fragment),ja=e(),bs=h("p"),bs.textContent=wn,Ja=e(),p(Cs.$$.fragment),ma=e(),p(Bs.$$.fragment),ya=e(),xs=h("p"),xs.textContent=fn,ua=e(),p(ks.$$.fragment),Ta=e(),p(Zs.$$.fragment),wa=e(),p(Gs.$$.fragment),fa=e(),Qs=h("p"),Qs.textContent=dn,da=e(),Ns=h("p"),Ns.innerHTML=gn,ga=e(),p(Es.$$.fragment),Ua=e(),p(vs.$$.fragment),Ia=e(),Ws=h("p"),Ws.textContent=Un,$a=e(),Ys=h("p"),Ys.innerHTML=In,ba=e(),p(As.$$.fragment),Ca=e(),p(Xs.$$.fragment),Ba=e(),Ss=h("p"),Ss.textContent=$n,xa=e(),Vs=h("p"),Vs.innerHTML=bn,ka=e(),p(Rs.$$.fragment),Za=e(),p(qs.$$.fragment),Ga=e(),zs=h("p"),zs.textContent=Cn,Qa=e(),p(Hs.$$.fragment),Na=e(),p(Fs.$$.fragment),Ea=e(),p(_s.$$.fragment),va=e(),Ls=h("p"),Ls.textContent=Bn,Wa=e(),Ds=h("p"),Ds.innerHTML=xn,Ya=e(),p(Ps.$$.fragment),Aa=e(),p(Ks.$$.fragment),Xa=e(),Os=h("p"),Os.textContent=kn,Sa=e(),st=h("p"),st.innerHTML=Zn,Va=e(),p(tt.$$.fragment),Ra=e(),p(lt.$$.fragment),qa=e(),at=h("p"),at.textContent=Gn,za=e(),p(et.$$.fragment),Ha=e(),p(nt.$$.fragment),Fa=e(),pt=h("p"),pt.textContent=Qn,_a=e(),p(it.$$.fragment),La=e(),p(Mt.$$.fragment),Da=e(),ot=h("p"),ot.textContent=Nn,Pa=e(),rt=h("p"),rt.innerHTML=En,Ka=e(),p(ct.$$.fragment),Oa=e(),p(ht.$$.fragment),se=e(),jt=h("p"),jt.textContent=vn,te=e(),Jt=h("p"),Jt.innerHTML=Wn,le=e(),p(mt.$$.fragment),ae=e(),p(yt.$$.fragment),ee=e(),ut=h("p"),ut.textContent=Yn,ne=e(),p(Tt.$$.fragment),pe=e(),p(wt.$$.fragment),ie=e(),p(ft.$$.fragment),Me=e(),dt=h("p"),dt.textContent=An,oe=e(),p(gt.$$.fragment),re=e(),p(Ut.$$.fragment),ce=e(),It=h("p"),It.textContent=Xn,he=e(),$t=h("p"),$t.innerHTML=Sn,je=e(),p(bt.$$.fragment),Je=e(),p(Ct.$$.fragment),me=e(),Bt=h("p"),Bt.textContent=Vn,ye=e(),xt=h("p"),xt.innerHTML=Rn,ue=e(),p(kt.$$.fragment),Te=e(),p(Zt.$$.fragment),we=e(),p(Gt.$$.fragment),fe=e(),Qt=h("p"),Qt.textContent=qn,de=e(),p(Nt.$$.fragment),ge=e(),p(Et.$$.fragment),Ue=e(),vt=h("p"),vt.textContent=zn,Ie=e(),p(Wt.$$.fragment),$e=e(),p(Yt.$$.fragment),be=e(),At=h("p"),At.textContent=Hn,Ce=e(),p(Xt.$$.fragment),Be=e(),St=h("p"),St.innerHTML=Fn,xe=e(),p(Vt.$$.fragment),ke=e(),p(Rt.$$.fragment),Ze=e(),qt=h("p"),qt.innerHTML=_n,Ge=e(),p(zt.$$.fragment),Qe=e(),Ht=h("p"),Ht.innerHTML=Ln,Ne=e(),p(Ft.$$.fragment),Ee=e(),p(_t.$$.fragment),ve=e(),p(Lt.$$.fragment),We=e(),p(Dt.$$.fragment),Ye=e(),Pt=h("p"),Pt.innerHTML=Dn,Ae=e(),Kt=h("p"),Kt.textContent=Pn,Xe=e(),p(Ot.$$.fragment),Se=e(),sl=h("ul"),sl.innerHTML=Kn,Ve=e(),p(tl.$$.fragment),Re=e(),al=h("p"),this.h()},l(s){const t=pp("svelte-u9bgzb",document.head);u=j(t,"META",{name:!0,content:!0}),t.forEach(l),el=n(s),ll=j(s,"P",{}),On(ll).forEach(l),nl=n(s),i(T.$$.fragment,s),pl=n(s),w=j(s,"P",{"data-svelte-h":!0}),J(w)!=="svelte-1h760yd"&&(w.innerHTML=He),il=n(s),f=j(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-15l1k62"&&(f.innerHTML=Fe),Ml=n(s),i(d.$$.fragment,s),ol=n(s),i(g.$$.fragment,s),rl=n(s),i(U.$$.fragment,s),cl=n(s),i(I.$$.fragment,s),hl=n(s),i($.$$.fragment,s),jl=n(s),i(b.$$.fragment,s),Jl=n(s),i(C.$$.fragment,s),ml=n(s),i(B.$$.fragment,s),yl=n(s),x=j(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-ys53zo"&&(x.innerHTML=_e),ul=n(s),k=j(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-2l8ybr"&&(k.textContent=Le),Tl=n(s),i(Z.$$.fragment,s),wl=n(s),G=j(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-jymwke"&&(G.textContent=De),fl=n(s),Q=j(s,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-iewgla"&&(Q.innerHTML=Pe),dl=n(s),N=j(s,"P",{"data-svelte-h":!0}),J(N)!=="svelte-10p6n92"&&(N.innerHTML=Ke),gl=n(s),i(E.$$.fragment,s),Ul=n(s),v=j(s,"P",{"data-svelte-h":!0}),J(v)!=="svelte-chybr3"&&(v.innerHTML=Oe),Il=n(s),W=j(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1q5o8lp"&&(W.textContent=sn),$l=n(s),Y=j(s,"UL",{"data-svelte-h":!0}),J(Y)!=="svelte-101x4zz"&&(Y.innerHTML=tn),bl=n(s),A=j(s,"P",{"data-svelte-h":!0}),J(A)!=="svelte-w24fai"&&(A.innerHTML=ln),Cl=n(s),X=j(s,"P",{"data-svelte-h":!0}),J(X)!=="svelte-anhj2e"&&(X.innerHTML=an),Bl=n(s),i(S.$$.fragment,s),xl=n(s),V=j(s,"P",{"data-svelte-h":!0}),J(V)!=="svelte-62skcu"&&(V.innerHTML=en),kl=n(s),i(R.$$.fragment,s),Zl=n(s),q=j(s,"P",{"data-svelte-h":!0}),J(q)!=="svelte-88xj6h"&&(q.textContent=nn),Gl=n(s),i(z.$$.fragment,s),Ql=n(s),i(H.$$.fragment,s),Nl=n(s),F=j(s,"P",{"data-svelte-h":!0}),J(F)!=="svelte-18cimv4"&&(F.textContent=pn),El=n(s),_=j(s,"P",{"data-svelte-h":!0}),J(_)!=="svelte-kjz90x"&&(_.innerHTML=Mn),vl=n(s),i(L.$$.fragment,s),Wl=n(s),i(D.$$.fragment,s),Yl=n(s),P=j(s,"P",{"data-svelte-h":!0}),J(P)!=="svelte-13o9mww"&&(P.innerHTML=on),Al=n(s),K=j(s,"P",{"data-svelte-h":!0}),J(K)!=="svelte-slg7wg"&&(K.innerHTML=rn),Xl=n(s),i(O.$$.fragment,s),Sl=n(s),ss=j(s,"P",{"data-svelte-h":!0}),J(ss)!=="svelte-1daohkt"&&(ss.textContent=cn),Vl=n(s),i(ts.$$.fragment,s),Rl=n(s),i(ls.$$.fragment,s),ql=n(s),as=j(s,"P",{"data-svelte-h":!0}),J(as)!=="svelte-1mnrr3b"&&(as.textContent=hn),zl=n(s),i(es.$$.fragment,s),Hl=n(s),i(ns.$$.fragment,s),Fl=n(s),ps=j(s,"P",{"data-svelte-h":!0}),J(ps)!=="svelte-4s1xv3"&&(ps.textContent=jn),_l=n(s),i(is.$$.fragment,s),Ll=n(s),i(Ms.$$.fragment,s),Dl=n(s),os=j(s,"P",{"data-svelte-h":!0}),J(os)!=="svelte-vnhv92"&&(os.textContent=Jn),Pl=n(s),i(rs.$$.fragment,s),Kl=n(s),i(cs.$$.fragment,s),Ol=n(s),i(hs.$$.fragment,s),sa=n(s),i(js.$$.fragment,s),ta=n(s),Js=j(s,"P",{"data-svelte-h":!0}),J(Js)!=="svelte-vlz10z"&&(Js.textContent=mn),la=n(s),i(ms.$$.fragment,s),aa=n(s),i(ys.$$.fragment,s),ea=n(s),us=j(s,"P",{"data-svelte-h":!0}),J(us)!=="svelte-qln4hq"&&(us.textContent=yn),na=n(s),i(Ts.$$.fragment,s),pa=n(s),i(ws.$$.fragment,s),ia=n(s),fs=j(s,"P",{"data-svelte-h":!0}),J(fs)!=="svelte-yinzpl"&&(fs.textContent=un),Ma=n(s),i(ds.$$.fragment,s),oa=n(s),i(gs.$$.fragment,s),ra=n(s),Us=j(s,"P",{"data-svelte-h":!0}),J(Us)!=="svelte-mqluby"&&(Us.textContent=Tn),ca=n(s),i(Is.$$.fragment,s),ha=n(s),i($s.$$.fragment,s),ja=n(s),bs=j(s,"P",{"data-svelte-h":!0}),J(bs)!=="svelte-1wq8md5"&&(bs.textContent=wn),Ja=n(s),i(Cs.$$.fragment,s),ma=n(s),i(Bs.$$.fragment,s),ya=n(s),xs=j(s,"P",{"data-svelte-h":!0}),J(xs)!=="svelte-tf7teq"&&(xs.textContent=fn),ua=n(s),i(ks.$$.fragment,s),Ta=n(s),i(Zs.$$.fragment,s),wa=n(s),i(Gs.$$.fragment,s),fa=n(s),Qs=j(s,"P",{"data-svelte-h":!0}),J(Qs)!=="svelte-1in7idl"&&(Qs.textContent=dn),da=n(s),Ns=j(s,"P",{"data-svelte-h":!0}),J(Ns)!=="svelte-18afluh"&&(Ns.innerHTML=gn),ga=n(s),i(Es.$$.fragment,s),Ua=n(s),i(vs.$$.fragment,s),Ia=n(s),Ws=j(s,"P",{"data-svelte-h":!0}),J(Ws)!=="svelte-12s1din"&&(Ws.textContent=Un),$a=n(s),Ys=j(s,"P",{"data-svelte-h":!0}),J(Ys)!=="svelte-1jpdfy8"&&(Ys.innerHTML=In),ba=n(s),i(As.$$.fragment,s),Ca=n(s),i(Xs.$$.fragment,s),Ba=n(s),Ss=j(s,"P",{"data-svelte-h":!0}),J(Ss)!=="svelte-1h8ubig"&&(Ss.textContent=$n),xa=n(s),Vs=j(s,"P",{"data-svelte-h":!0}),J(Vs)!=="svelte-1edrfzt"&&(Vs.innerHTML=bn),ka=n(s),i(Rs.$$.fragment,s),Za=n(s),i(qs.$$.fragment,s),Ga=n(s),zs=j(s,"P",{"data-svelte-h":!0}),J(zs)!=="svelte-zj5o06"&&(zs.textContent=Cn),Qa=n(s),i(Hs.$$.fragment,s),Na=n(s),i(Fs.$$.fragment,s),Ea=n(s),i(_s.$$.fragment,s),va=n(s),Ls=j(s,"P",{"data-svelte-h":!0}),J(Ls)!=="svelte-1nlp89w"&&(Ls.textContent=Bn),Wa=n(s),Ds=j(s,"P",{"data-svelte-h":!0}),J(Ds)!=="svelte-10vvvxx"&&(Ds.innerHTML=xn),Ya=n(s),i(Ps.$$.fragment,s),Aa=n(s),i(Ks.$$.fragment,s),Xa=n(s),Os=j(s,"P",{"data-svelte-h":!0}),J(Os)!=="svelte-d15mev"&&(Os.textContent=kn),Sa=n(s),st=j(s,"P",{"data-svelte-h":!0}),J(st)!=="svelte-pxrbuw"&&(st.innerHTML=Zn),Va=n(s),i(tt.$$.fragment,s),Ra=n(s),i(lt.$$.fragment,s),qa=n(s),at=j(s,"P",{"data-svelte-h":!0}),J(at)!=="svelte-1oenl8f"&&(at.textContent=Gn),za=n(s),i(et.$$.fragment,s),Ha=n(s),i(nt.$$.fragment,s),Fa=n(s),pt=j(s,"P",{"data-svelte-h":!0}),J(pt)!=="svelte-66badz"&&(pt.textContent=Qn),_a=n(s),i(it.$$.fragment,s),La=n(s),i(Mt.$$.fragment,s),Da=n(s),ot=j(s,"P",{"data-svelte-h":!0}),J(ot)!=="svelte-13iv3hh"&&(ot.textContent=Nn),Pa=n(s),rt=j(s,"P",{"data-svelte-h":!0}),J(rt)!=="svelte-1mgyz4r"&&(rt.innerHTML=En),Ka=n(s),i(ct.$$.fragment,s),Oa=n(s),i(ht.$$.fragment,s),se=n(s),jt=j(s,"P",{"data-svelte-h":!0}),J(jt)!=="svelte-1y7kqaa"&&(jt.textContent=vn),te=n(s),Jt=j(s,"P",{"data-svelte-h":!0}),J(Jt)!=="svelte-m8xmew"&&(Jt.innerHTML=Wn),le=n(s),i(mt.$$.fragment,s),ae=n(s),i(yt.$$.fragment,s),ee=n(s),ut=j(s,"P",{"data-svelte-h":!0}),J(ut)!=="svelte-m7q2yg"&&(ut.textContent=Yn),ne=n(s),i(Tt.$$.fragment,s),pe=n(s),i(wt.$$.fragment,s),ie=n(s),i(ft.$$.fragment,s),Me=n(s),dt=j(s,"P",{"data-svelte-h":!0}),J(dt)!=="svelte-174b8m1"&&(dt.textContent=An),oe=n(s),i(gt.$$.fragment,s),re=n(s),i(Ut.$$.fragment,s),ce=n(s),It=j(s,"P",{"data-svelte-h":!0}),J(It)!=="svelte-cnruui"&&(It.textContent=Xn),he=n(s),$t=j(s,"P",{"data-svelte-h":!0}),J($t)!=="svelte-hwgezm"&&($t.innerHTML=Sn),je=n(s),i(bt.$$.fragment,s),Je=n(s),i(Ct.$$.fragment,s),me=n(s),Bt=j(s,"P",{"data-svelte-h":!0}),J(Bt)!=="svelte-1tpexz3"&&(Bt.textContent=Vn),ye=n(s),xt=j(s,"P",{"data-svelte-h":!0}),J(xt)!=="svelte-hwgezm"&&(xt.innerHTML=Rn),ue=n(s),i(kt.$$.fragment,s),Te=n(s),i(Zt.$$.fragment,s),we=n(s),i(Gt.$$.fragment,s),fe=n(s),Qt=j(s,"P",{"data-svelte-h":!0}),J(Qt)!=="svelte-1js246c"&&(Qt.textContent=qn),de=n(s),i(Nt.$$.fragment,s),ge=n(s),i(Et.$$.fragment,s),Ue=n(s),vt=j(s,"P",{"data-svelte-h":!0}),J(vt)!=="svelte-7l7zu1"&&(vt.textContent=zn),Ie=n(s),i(Wt.$$.fragment,s),$e=n(s),i(Yt.$$.fragment,s),be=n(s),At=j(s,"P",{"data-svelte-h":!0}),J(At)!=="svelte-1uv5lul"&&(At.textContent=Hn),Ce=n(s),i(Xt.$$.fragment,s),Be=n(s),St=j(s,"P",{"data-svelte-h":!0}),J(St)!=="svelte-cw0lq3"&&(St.innerHTML=Fn),xe=n(s),i(Vt.$$.fragment,s),ke=n(s),i(Rt.$$.fragment,s),Ze=n(s),qt=j(s,"P",{"data-svelte-h":!0}),J(qt)!=="svelte-14q869u"&&(qt.innerHTML=_n),Ge=n(s),i(zt.$$.fragment,s),Qe=n(s),Ht=j(s,"P",{"data-svelte-h":!0}),J(Ht)!=="svelte-16znzc1"&&(Ht.innerHTML=Ln),Ne=n(s),i(Ft.$$.fragment,s),Ee=n(s),i(_t.$$.fragment,s),ve=n(s),i(Lt.$$.fragment,s),We=n(s),i(Dt.$$.fragment,s),Ye=n(s),Pt=j(s,"P",{"data-svelte-h":!0}),J(Pt)!=="svelte-62a9et"&&(Pt.innerHTML=Dn),Ae=n(s),Kt=j(s,"P",{"data-svelte-h":!0}),J(Kt)!=="svelte-1yyf4wc"&&(Kt.textContent=Pn),Xe=n(s),i(Ot.$$.fragment,s),Se=n(s),sl=j(s,"UL",{"data-svelte-h":!0}),J(sl)!=="svelte-mopwlb"&&(sl.innerHTML=Kn),Ve=n(s),i(tl.$$.fragment,s),Re=n(s),al=j(s,"P",{}),On(al).forEach(l),this.h()},h(){sp(u,"name","hf:doc:metadata"),sp(u,"content",rp)},m(s,t){ip(document.head,u),a(s,el,t),a(s,ll,t),a(s,nl,t),M(T,s,t),a(s,pl,t),a(s,w,t),a(s,il,t),a(s,f,t),a(s,Ml,t),M(d,s,t),a(s,ol,t),M(g,s,t),a(s,rl,t),M(U,s,t),a(s,cl,t),M(I,s,t),a(s,hl,t),M($,s,t),a(s,jl,t),M(b,s,t),a(s,Jl,t),M(C,s,t),a(s,ml,t),M(B,s,t),a(s,yl,t),a(s,x,t),a(s,ul,t),a(s,k,t),a(s,Tl,t),M(Z,s,t),a(s,wl,t),a(s,G,t),a(s,fl,t),a(s,Q,t),a(s,dl,t),a(s,N,t),a(s,gl,t),M(E,s,t),a(s,Ul,t),a(s,v,t),a(s,Il,t),a(s,W,t),a(s,$l,t),a(s,Y,t),a(s,bl,t),a(s,A,t),a(s,Cl,t),a(s,X,t),a(s,Bl,t),M(S,s,t),a(s,xl,t),a(s,V,t),a(s,kl,t),M(R,s,t),a(s,Zl,t),a(s,q,t),a(s,Gl,t),M(z,s,t),a(s,Ql,t),M(H,s,t),a(s,Nl,t),a(s,F,t),a(s,El,t),a(s,_,t),a(s,vl,t),M(L,s,t),a(s,Wl,t),M(D,s,t),a(s,Yl,t),a(s,P,t),a(s,Al,t),a(s,K,t),a(s,Xl,t),M(O,s,t),a(s,Sl,t),a(s,ss,t),a(s,Vl,t),M(ts,s,t),a(s,Rl,t),M(ls,s,t),a(s,ql,t),a(s,as,t),a(s,zl,t),M(es,s,t),a(s,Hl,t),M(ns,s,t),a(s,Fl,t),a(s,ps,t),a(s,_l,t),M(is,s,t),a(s,Ll,t),M(Ms,s,t),a(s,Dl,t),a(s,os,t),a(s,Pl,t),M(rs,s,t),a(s,Kl,t),M(cs,s,t),a(s,Ol,t),M(hs,s,t),a(s,sa,t),M(js,s,t),a(s,ta,t),a(s,Js,t),a(s,la,t),M(ms,s,t),a(s,aa,t),M(ys,s,t),a(s,ea,t),a(s,us,t),a(s,na,t),M(Ts,s,t),a(s,pa,t),M(ws,s,t),a(s,ia,t),a(s,fs,t),a(s,Ma,t),M(ds,s,t),a(s,oa,t),M(gs,s,t),a(s,ra,t),a(s,Us,t),a(s,ca,t),M(Is,s,t),a(s,ha,t),M($s,s,t),a(s,ja,t),a(s,bs,t),a(s,Ja,t),M(Cs,s,t),a(s,ma,t),M(Bs,s,t),a(s,ya,t),a(s,xs,t),a(s,ua,t),M(ks,s,t),a(s,Ta,t),M(Zs,s,t),a(s,wa,t),M(Gs,s,t),a(s,fa,t),a(s,Qs,t),a(s,da,t),a(s,Ns,t),a(s,ga,t),M(Es,s,t),a(s,Ua,t),M(vs,s,t),a(s,Ia,t),a(s,Ws,t),a(s,$a,t),a(s,Ys,t),a(s,ba,t),M(As,s,t),a(s,Ca,t),M(Xs,s,t),a(s,Ba,t),a(s,Ss,t),a(s,xa,t),a(s,Vs,t),a(s,ka,t),M(Rs,s,t),a(s,Za,t),M(qs,s,t),a(s,Ga,t),a(s,zs,t),a(s,Qa,t),M(Hs,s,t),a(s,Na,t),M(Fs,s,t),a(s,Ea,t),M(_s,s,t),a(s,va,t),a(s,Ls,t),a(s,Wa,t),a(s,Ds,t),a(s,Ya,t),M(Ps,s,t),a(s,Aa,t),M(Ks,s,t),a(s,Xa,t),a(s,Os,t),a(s,Sa,t),a(s,st,t),a(s,Va,t),M(tt,s,t),a(s,Ra,t),M(lt,s,t),a(s,qa,t),a(s,at,t),a(s,za,t),M(et,s,t),a(s,Ha,t),M(nt,s,t),a(s,Fa,t),a(s,pt,t),a(s,_a,t),M(it,s,t),a(s,La,t),M(Mt,s,t),a(s,Da,t),a(s,ot,t),a(s,Pa,t),a(s,rt,t),a(s,Ka,t),M(ct,s,t),a(s,Oa,t),M(ht,s,t),a(s,se,t),a(s,jt,t),a(s,te,t),a(s,Jt,t),a(s,le,t),M(mt,s,t),a(s,ae,t),M(yt,s,t),a(s,ee,t),a(s,ut,t),a(s,ne,t),M(Tt,s,t),a(s,pe,t),M(wt,s,t),a(s,ie,t),M(ft,s,t),a(s,Me,t),a(s,dt,t),a(s,oe,t),M(gt,s,t),a(s,re,t),M(Ut,s,t),a(s,ce,t),a(s,It,t),a(s,he,t),a(s,$t,t),a(s,je,t),M(bt,s,t),a(s,Je,t),M(Ct,s,t),a(s,me,t),a(s,Bt,t),a(s,ye,t),a(s,xt,t),a(s,ue,t),M(kt,s,t),a(s,Te,t),M(Zt,s,t),a(s,we,t),M(Gt,s,t),a(s,fe,t),a(s,Qt,t),a(s,de,t),M(Nt,s,t),a(s,ge,t),M(Et,s,t),a(s,Ue,t),a(s,vt,t),a(s,Ie,t),M(Wt,s,t),a(s,$e,t),M(Yt,s,t),a(s,be,t),a(s,At,t),a(s,Ce,t),M(Xt,s,t),a(s,Be,t),a(s,St,t),a(s,xe,t),M(Vt,s,t),a(s,ke,t),M(Rt,s,t),a(s,Ze,t),a(s,qt,t),a(s,Ge,t),M(zt,s,t),a(s,Qe,t),a(s,Ht,t),a(s,Ne,t),M(Ft,s,t),a(s,Ee,t),M(_t,s,t),a(s,ve,t),M(Lt,s,t),a(s,We,t),M(Dt,s,t),a(s,Ye,t),a(s,Pt,t),a(s,Ae,t),a(s,Kt,t),a(s,Xe,t),M(Ot,s,t),a(s,Se,t),a(s,sl,t),a(s,Ve,t),M(tl,s,t),a(s,Re,t),a(s,al,t),qe=!0},p:lp,i(s){qe||(o(T.$$.fragment,s),o(d.$$.fragment,s),o(g.$$.fragment,s),o(U.$$.fragment,s),o(I.$$.fragment,s),o($.$$.fragment,s),o(b.$$.fragment,s),o(C.$$.fragment,s),o(B.$$.fragment,s),o(Z.$$.fragment,s),o(E.$$.fragment,s),o(S.$$.fragment,s),o(R.$$.fragment,s),o(z.$$.fragment,s),o(H.$$.fragment,s),o(L.$$.fragment,s),o(D.$$.fragment,s),o(O.$$.fragment,s),o(ts.$$.fragment,s),o(ls.$$.fragment,s),o(es.$$.fragment,s),o(ns.$$.fragment,s),o(is.$$.fragment,s),o(Ms.$$.fragment,s),o(rs.$$.fragment,s),o(cs.$$.fragment,s),o(hs.$$.fragment,s),o(js.$$.fragment,s),o(ms.$$.fragment,s),o(ys.$$.fragment,s),o(Ts.$$.fragment,s),o(ws.$$.fragment,s),o(ds.$$.fragment,s),o(gs.$$.fragment,s),o(Is.$$.fragment,s),o($s.$$.fragment,s),o(Cs.$$.fragment,s),o(Bs.$$.fragment,s),o(ks.$$.fragment,s),o(Zs.$$.fragment,s),o(Gs.$$.fragment,s),o(Es.$$.fragment,s),o(vs.$$.fragment,s),o(As.$$.fragment,s),o(Xs.$$.fragment,s),o(Rs.$$.fragment,s),o(qs.$$.fragment,s),o(Hs.$$.fragment,s),o(Fs.$$.fragment,s),o(_s.$$.fragment,s),o(Ps.$$.fragment,s),o(Ks.$$.fragment,s),o(tt.$$.fragment,s),o(lt.$$.fragment,s),o(et.$$.fragment,s),o(nt.$$.fragment,s),o(it.$$.fragment,s),o(Mt.$$.fragment,s),o(ct.$$.fragment,s),o(ht.$$.fragment,s),o(mt.$$.fragment,s),o(yt.$$.fragment,s),o(Tt.$$.fragment,s),o(wt.$$.fragment,s),o(ft.$$.fragment,s),o(gt.$$.fragment,s),o(Ut.$$.fragment,s),o(bt.$$.fragment,s),o(Ct.$$.fragment,s),o(kt.$$.fragment,s),o(Zt.$$.fragment,s),o(Gt.$$.fragment,s),o(Nt.$$.fragment,s),o(Et.$$.fragment,s),o(Wt.$$.fragment,s),o(Yt.$$.fragment,s),o(Xt.$$.fragment,s),o(Vt.$$.fragment,s),o(Rt.$$.fragment,s),o(zt.$$.fragment,s),o(Ft.$$.fragment,s),o(_t.$$.fragment,s),o(Lt.$$.fragment,s),o(Dt.$$.fragment,s),o(Ot.$$.fragment,s),o(tl.$$.fragment,s),qe=!0)},o(s){r(T.$$.fragment,s),r(d.$$.fragment,s),r(g.$$.fragment,s),r(U.$$.fragment,s),r(I.$$.fragment,s),r($.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r(B.$$.fragment,s),r(Z.$$.fragment,s),r(E.$$.fragment,s),r(S.$$.fragment,s),r(R.$$.fragment,s),r(z.$$.fragment,s),r(H.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(O.$$.fragment,s),r(ts.$$.fragment,s),r(ls.$$.fragment,s),r(es.$$.fragment,s),r(ns.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(rs.$$.fragment,s),r(cs.$$.fragment,s),r(hs.$$.fragment,s),r(js.$$.fragment,s),r(ms.$$.fragment,s),r(ys.$$.fragment,s),r(Ts.$$.fragment,s),r(ws.$$.fragment,s),r(ds.$$.fragment,s),r(gs.$$.fragment,s),r(Is.$$.fragment,s),r($s.$$.fragment,s),r(Cs.$$.fragment,s),r(Bs.$$.fragment,s),r(ks.$$.fragment,s),r(Zs.$$.fragment,s),r(Gs.$$.fragment,s),r(Es.$$.fragment,s),r(vs.$$.fragment,s),r(As.$$.fragment,s),r(Xs.$$.fragment,s),r(Rs.$$.fragment,s),r(qs.$$.fragment,s),r(Hs.$$.fragment,s),r(Fs.$$.fragment,s),r(_s.$$.fragment,s),r(Ps.$$.fragment,s),r(Ks.$$.fragment,s),r(tt.$$.fragment,s),r(lt.$$.fragment,s),r(et.$$.fragment,s),r(nt.$$.fragment,s),r(it.$$.fragment,s),r(Mt.$$.fragment,s),r(ct.$$.fragment,s),r(ht.$$.fragment,s),r(mt.$$.fragment,s),r(yt.$$.fragment,s),r(Tt.$$.fragment,s),r(wt.$$.fragment,s),r(ft.$$.fragment,s),r(gt.$$.fragment,s),r(Ut.$$.fragment,s),r(bt.$$.fragment,s),r(Ct.$$.fragment,s),r(kt.$$.fragment,s),r(Zt.$$.fragment,s),r(Gt.$$.fragment,s),r(Nt.$$.fragment,s),r(Et.$$.fragment,s),r(Wt.$$.fragment,s),r(Yt.$$.fragment,s),r(Xt.$$.fragment,s),r(Vt.$$.fragment,s),r(Rt.$$.fragment,s),r(zt.$$.fragment,s),r(Ft.$$.fragment,s),r(_t.$$.fragment,s),r(Lt.$$.fragment,s),r(Dt.$$.fragment,s),r(Ot.$$.fragment,s),r(tl.$$.fragment,s),qe=!1},d(s){s&&(l(el),l(ll),l(nl),l(pl),l(w),l(il),l(f),l(Ml),l(ol),l(rl),l(cl),l(hl),l(jl),l(Jl),l(ml),l(yl),l(x),l(ul),l(k),l(Tl),l(wl),l(G),l(fl),l(Q),l(dl),l(N),l(gl),l(Ul),l(v),l(Il),l(W),l($l),l(Y),l(bl),l(A),l(Cl),l(X),l(Bl),l(xl),l(V),l(kl),l(Zl),l(q),l(Gl),l(Ql),l(Nl),l(F),l(El),l(_),l(vl),l(Wl),l(Yl),l(P),l(Al),l(K),l(Xl),l(Sl),l(ss),l(Vl),l(Rl),l(ql),l(as),l(zl),l(Hl),l(Fl),l(ps),l(_l),l(Ll),l(Dl),l(os),l(Pl),l(Kl),l(Ol),l(sa),l(ta),l(Js),l(la),l(aa),l(ea),l(us),l(na),l(pa),l(ia),l(fs),l(Ma),l(oa),l(ra),l(Us),l(ca),l(ha),l(ja),l(bs),l(Ja),l(ma),l(ya),l(xs),l(ua),l(Ta),l(wa),l(fa),l(Qs),l(da),l(Ns),l(ga),l(Ua),l(Ia),l(Ws),l($a),l(Ys),l(ba),l(Ca),l(Ba),l(Ss),l(xa),l(Vs),l(ka),l(Za),l(Ga),l(zs),l(Qa),l(Na),l(Ea),l(va),l(Ls),l(Wa),l(Ds),l(Ya),l(Aa),l(Xa),l(Os),l(Sa),l(st),l(Va),l(Ra),l(qa),l(at),l(za),l(Ha),l(Fa),l(pt),l(_a),l(La),l(Da),l(ot),l(Pa),l(rt),l(Ka),l(Oa),l(se),l(jt),l(te),l(Jt),l(le),l(ae),l(ee),l(ut),l(ne),l(pe),l(ie),l(Me),l(dt),l(oe),l(re),l(ce),l(It),l(he),l($t),l(je),l(Je),l(me),l(Bt),l(ye),l(xt),l(ue),l(Te),l(we),l(fe),l(Qt),l(de),l(ge),l(Ue),l(vt),l(Ie),l($e),l(be),l(At),l(Ce),l(Be),l(St),l(xe),l(ke),l(Ze),l(qt),l(Ge),l(Qe),l(Ht),l(Ne),l(Ee),l(ve),l(We),l(Ye),l(Pt),l(Ae),l(Kt),l(Xe),l(Se),l(sl),l(Ve),l(Re),l(al)),l(u),c(T,s),c(d,s),c(g,s),c(U,s),c(I,s),c($,s),c(b,s),c(C,s),c(B,s),c(Z,s),c(E,s),c(S,s),c(R,s),c(z,s),c(H,s),c(L,s),c(D,s),c(O,s),c(ts,s),c(ls,s),c(es,s),c(ns,s),c(is,s),c(Ms,s),c(rs,s),c(cs,s),c(hs,s),c(js,s),c(ms,s),c(ys,s),c(Ts,s),c(ws,s),c(ds,s),c(gs,s),c(Is,s),c($s,s),c(Cs,s),c(Bs,s),c(ks,s),c(Zs,s),c(Gs,s),c(Es,s),c(vs,s),c(As,s),c(Xs,s),c(Rs,s),c(qs,s),c(Hs,s),c(Fs,s),c(_s,s),c(Ps,s),c(Ks,s),c(tt,s),c(lt,s),c(et,s),c(nt,s),c(it,s),c(Mt,s),c(ct,s),c(ht,s),c(mt,s),c(yt,s),c(Tt,s),c(wt,s),c(ft,s),c(gt,s),c(Ut,s),c(bt,s),c(Ct,s),c(kt,s),c(Zt,s),c(Gt,s),c(Nt,s),c(Et,s),c(Wt,s),c(Yt,s),c(Xt,s),c(Vt,s),c(Rt,s),c(zt,s),c(Ft,s),c(_t,s),c(Lt,s),c(Dt,s),c(Ot,s),c(tl,s)}}}const rp='{"title":"🤗 Hugging Face Inference Endpoints","local":"-hugging-face-inference-endpoints","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[],"depth":3},{"title":"Third-party inference providers","local":"third-party-inference-providers","sections":[],"depth":3},{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Text Generation (Chat Completion API Compatible)","local":"text-generation-chat-completion-api-compatible","sections":[],"depth":3},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Calls","local":"custom-calls","sections":[],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function cp(ze){return ap(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yp extends ep{constructor(u){super(),np(this,u,cp,op,tp,{})}}export{yp as component};
