import{s as Or,o as Kr,n as eo}from"../chunks/scheduler.9bc65507.js";import{S as to,i as no,g as i,s as a,r as p,A as so,h as r,f as n,c as l,j as Qr,u as m,x as o,k as Yr,y as ao,a as s,v as d,d as f,t as h,w as u}from"../chunks/index.707bf1b6.js";import{T as lo}from"../chunks/Tip.c2ecdbf4.js";import{Y as Bn}from"../chunks/Youtube.e1129c6f.js";import{C as $}from"../chunks/CodeBlock.54a9f38d.js";import{H as g}from"../chunks/Heading.342b1fa6.js";function io(Xn){let c,w=`Each model’s labels may be different, so be sure to always check the documentation of each model for more information
about their specific labels!`;return{c(){c=i("p"),c.textContent=w},l(b){c=r(b,"P",{"data-svelte-h":!0}),o(c)!=="svelte-1nifkrh"&&(c.textContent=w)},m(b,Gn){s(b,c,Gn)},p:eo,d(b){b&&n(c)}}}function ro(Xn){let c,w,b,Gn,T,Rn,x,fi=`This glossary defines general machine learning and 🤗 Transformers terms to help you better understand the
documentation.`,An,k,Sn,y,En,C,hi="The attention mask is an optional argument used when batching sequences together.",Dn,j,Qn,_,ui="This argument indicates to the model which tokens should be attended to, and which should not.",Yn,M,gi="For example, consider these two sequences:",On,P,Kn,q,ci="The encoded versions have different lengths:",es,H,ts,L,$i=`Therefore, we can’t put them together in the same tensor as-is. The first sequence needs to be padded up to the length
of the second one, or the second one needs to be truncated down to the length of the first one.`,ns,z,bi=`In the first case, the list of IDs will be extended by the padding indices. We can pass a list to the tokenizer and ask
it to pad like this:`,ss,V,as,Z,vi="We can see that 0s have been added on the right of the first sentence to make it the same length as the second one:",ls,U,is,F,wi=`This can then be converted into a tensor in PyTorch or TensorFlow. The attention mask is a binary tensor indicating the
position of the padded indices so that the model does not attend to them. For the <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>, <code>1</code> indicates a
value that should be attended to, while <code>0</code> indicates a padded value. This attention mask is in the dictionary returned
by the tokenizer under the key “attention_mask”:`,rs,I,os,N,ps,J,Ti='See <a href="#encoder-models">encoder models</a> and <a href="#masked-language-modeling-mlm">masked language modeling</a>',ms,G,ds,W,xi='See <a href="#causal-language-modeling">causal language modeling</a> and <a href="#decoder-models">decoder models</a>',fs,B,hs,X,us,R,ki='The backbone is the network (embeddings and layers) that outputs the raw hidden states or features. It is usually connected to a <a href="#head">head</a> which accepts the features as its input to make a prediction. For example, <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTModel">ViTModel</a> is a backbone without a specific head on top. Other models can also use <code>VitModel</code> as a backbone such as <a href="model_doc/dpt">DPT</a>.',gs,A,cs,S,$s,E,yi=`A pretraining task where the model reads the texts in order and has to predict the next word. It’s usually done by
reading the whole sentence but using a mask inside the model to hide the future tokens at a certain timestep.`,bs,D,vs,Q,Ci="Color images are made up of some combination of values in three channels: red, green, and blue (RGB) and grayscale images only have one channel. In 🤗 Transformers, the channel can be the first or last dimension of an image’s tensor: [<code>n_channels</code>, <code>height</code>, <code>width</code>] or [<code>height</code>, <code>width</code>, <code>n_channels</code>].",ws,Y,Ts,O,ji="An algorithm which allows a model to learn without knowing exactly how the input and output are aligned; CTC calculates the distribution of all possible outputs for a given input and chooses the most likely output from it. CTC is commonly used in speech recognition tasks because speech doesn’t always cleanly align with the transcript for a variety of reasons such as a speaker’s different speech rates.",xs,K,ks,ee,_i="A type of layer in a neural network where the input matrix is multiplied element-wise by a smaller matrix (kernel or filter) and the values are summed up in a new matrix. This is known as a convolutional operation which is repeated over the entire input matrix. Each operation is applied to a different segment of the input matrix. Convolutional neural networks (CNNs) are commonly used in computer vision.",ys,te,Cs,ne,js,se,Mi=`Parallelism technique for training on multiple GPUs where the same setup is replicated multiple times, with each instance
receiving a distinct data slice. The processing is done in parallel and all setups are synchronized at the end of each training step.`,_s,ae,Pi='Learn more about how DataParallel works <a href="perf_train_gpu_many#dataparallel-vs-distributeddataparallel">here</a>.',Ms,le,Ps,ie,qi=`This input is specific to encoder-decoder models, and contains the input IDs that will be fed to the decoder. These
inputs should be used for sequence to sequence tasks, such as translation or summarization, and are usually built in a
way specific to each model.`,qs,re,Hi=`Most encoder-decoder models (BART, T5) create their <code>decoder_input_ids</code> on their own from the <code>labels</code>. In such models,
passing the <code>labels</code> is the preferred way to handle training.`,Hs,oe,Li="Please check each model’s docs to see how they handle these input IDs for sequence to sequence training.",Ls,pe,zs,me,zi=`Also referred to as autoregressive models, decoder models involve a pretraining task (called causal language modeling) where the model reads the texts in order and has to predict the next word. It’s usually done by
reading the whole sentence with a mask to hide future tokens at a certain timestep.`,Vs,de,Zs,fe,Us,he,Vi="Machine learning algorithms which uses neural networks with several layers.",Fs,ue,Is,ge,Ns,ce,Zi='Also known as autoencoding models, encoder models take an input (such as text or images) and transform them into a condensed numerical representation called an embedding. Oftentimes, encoder models are pretrained using techniques like <a href="#masked-language-modeling-mlm">masked language modeling</a>, which masks parts of the input sequence and forces the model to create more meaningful representations.',Js,$e,Gs,be,Ws,ve,Bs,we,Ui="The process of selecting and transforming raw data into a set of features that are more informative and useful for machine learning algorithms. Some examples of feature extraction include transforming raw text into word embeddings and extracting important features such as edges or shapes from image/video data.",Xs,Te,Rs,xe,Fi=`In each residual attention block in transformers the self-attention layer is usually followed by 2 feed forward layers.
The intermediate embedding size of the feed forward layers is often bigger than the hidden size of the model (e.g., for
<code>bert-base-uncased</code>).`,As,ke,Ii=`For an input of size <code>[batch_size, sequence_length]</code>, the memory required to store the intermediate feed forward
embeddings <code>[batch_size, sequence_length, config.intermediate_size]</code> can account for a large fraction of the memory
use. The authors of <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> noticed that since the
computation is independent of the <code>sequence_length</code> dimension, it is mathematically equivalent to compute the output
embeddings of both feed forward layers <code>[batch_size, config.hidden_size]_0, ..., [batch_size, config.hidden_size]_n</code>
individually and concat them afterward to <code>[batch_size, sequence_length, config.hidden_size]</code> with <code>n = sequence_length</code>, which trades increased computation time against reduced memory use, but yields a mathematically
<strong>equivalent</strong> result.`,Ss,ye,Ni=`For models employing the function <a href="/docs/transformers/v4.37.0/en/internal/modeling_utils#transformers.apply_chunking_to_forward">apply_chunking_to_forward()</a>, the <code>chunk_size</code> defines the number of output
embeddings that are computed in parallel and thus defines the trade-off between memory and time complexity. If
<code>chunk_size</code> is set to 0, no feed forward chunking is done.`,Es,Ce,Ds,je,Ji='Finetuning is a form of transfer learning which involves taking a pretrained model, freezing its weights, and replacing the output layer with a newly added <a href="#head">model head</a>. The model head is trained on your target dataset.',Qs,_e,Gi='See the <a href="https://huggingface.co/docs/transformers/training" rel="nofollow">Fine-tune a pretrained model</a> tutorial for more details, and learn how to fine-tune models with 🤗 Transformers.',Ys,Me,Os,Pe,Ks,qe,Wi="The model head refers to the last layer of a neural network that accepts the raw hidden states and projects them onto a different dimension. There is a different model head for each task. For example:",ea,He,Bi='<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> is a sequence classification head - a linear layer - on top of the base <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a>.</li> <li><a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> is an image classification head - a linear layer on top of the final hidden state of the <code>CLS</code> token - on top of the base <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTModel">ViTModel</a>.</li> <li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> is a language modeling head with <a href="#connectionist-temporal-classification-(CTC)">CTC</a> on top of the base <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a>.</li>',ta,Le,na,ze,sa,Ve,Xi="Vision-based Transformers models split an image into smaller patches which are linearly embedded, and then passed as a sequence to the model. You can find the <code>patch_size</code> - or resolution - of the model in its configuration.",aa,Ze,la,Ue,Ri='Inference is the process of evaluating a model on new data after training is complete. See the <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">Pipeline for inference</a> tutorial to learn how to perform inference with 🤗 Transformers.',ia,Fe,ra,Ie,Ai=`The input ids are often the only required parameters to be passed to the model as input. They are token indices,
numerical representations of tokens building the sequences that will be used as input by the model.`,oa,Ne,pa,Je,Si=`Each tokenizer works differently but the underlying mechanism remains the same. Here’s an example using the BERT
tokenizer, which is a <a href="https://arxiv.org/pdf/1609.08144.pdf" rel="nofollow">WordPiece</a> tokenizer:`,ma,Ge,da,We,Ei="The tokenizer takes care of splitting the sequence into tokens available in the tokenizer vocabulary.",fa,Be,ha,Xe,Di=`The tokens are either words or subwords. Here for instance, “VRAM” wasn’t in the model vocabulary, so it’s been split
in “V”, “RA” and “M”. To indicate those tokens are not separate words but parts of the same word, a double-hash prefix
is added for “RA” and “M”:`,ua,Re,ga,Ae,Qi='These tokens can then be converted into IDs which are understandable by the model. This can be done by directly feeding the sentence to the tokenizer, which leverages the Rust implementation of <a href="https://github.com/huggingface/tokenizers" rel="nofollow">🤗 Tokenizers</a> for peak performance.',ca,Se,$a,Ee,Yi=`The tokenizer returns a dictionary with all the arguments necessary for its corresponding model to work properly. The
token indices are under the key <code>input_ids</code>:`,ba,De,va,Qe,Oi=`Note that the tokenizer automatically adds “special tokens” (if the associated model relies on them) which are special
IDs the model sometimes uses.`,wa,Ye,Ki="If we decode the previous sequence of ids,",Ta,Oe,xa,Ke,er="we will see",ka,et,ya,tt,tr='because this is the way a <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertModel">BertModel</a> is going to expect its inputs.',Ca,nt,ja,st,_a,at,nr=`The labels are an optional argument which can be passed in order for the model to compute the loss itself. These labels
should be the expected prediction of the model: it will use the standard loss in order to compute the loss between its
predictions and the expected value (the label).`,Ma,lt,sr="These labels are different according to the model head, for example:",Pa,it,ar=`<li>For sequence classification models, (<a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a>), the model expects a tensor of dimension
<code>(batch_size)</code> with each value of the batch corresponding to the expected label of the entire sequence.</li> <li>For token classification models, (<a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForTokenClassification">BertForTokenClassification</a>), the model expects a tensor of dimension
<code>(batch_size, seq_length)</code> with each value corresponding to the expected label of each individual token.</li> <li>For masked language modeling, (<a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a>), the model expects a tensor of dimension <code>(batch_size, seq_length)</code> with each value corresponding to the expected label of each individual token: the labels being the token
ID for the masked token, and values to be ignored for the rest (usually -100).</li> <li>For sequence to sequence tasks, (<a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a>, <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a>), the model
expects a tensor of dimension <code>(batch_size, tgt_seq_length)</code> with each value corresponding to the target sequences
associated with each input sequence. During training, both BART and T5 will make the appropriate
<code>decoder_input_ids</code> and decoder attention masks internally. They usually do not need to be supplied. This does not
apply to models leveraging the Encoder-Decoder framework.</li> <li>For image classification models, (<a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a>), the model expects a tensor of dimension
<code>(batch_size)</code> with each value of the batch corresponding to the expected label of each individual image.</li> <li>For semantic segmentation models, (<a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerForSemanticSegmentation">SegformerForSemanticSegmentation</a>), the model expects a tensor of dimension
<code>(batch_size, height, width)</code> with each value of the batch corresponding to the expected label of each individual pixel.</li> <li>For object detection models, (<a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a>), the model expects a list of dictionaries with a
<code>class_labels</code> and <code>boxes</code> key where each value of the batch corresponds to the expected label and number of bounding boxes of each individual image.</li> <li>For automatic speech recognition models, (<a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>), the model expects a tensor of dimension <code>(batch_size, target_length)</code> with each value corresponding to the expected label of each individual token.</li>`,qa,v,Ha,rt,lr=`The base models (<a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertModel">BertModel</a>) do not accept labels, as these are the base transformer models, simply outputting
features.`,La,ot,za,pt,ir="A generic term that refers to transformer language models (GPT-3, BLOOM, OPT) that were trained on a large quantity of data. These models also tend to have a large number of learnable parameters (e.g. 175 billion for GPT-3).",Va,mt,Za,dt,Ua,ft,rr=`A pretraining task where the model sees a corrupted version of the texts, usually done by
masking some tokens randomly, and has to predict the original text.`,Fa,ht,Ia,ut,or="A task that combines texts with another kind of inputs (for instance images).",Na,gt,Ja,ct,Ga,$t,pr='All tasks related to generating text (for instance, <a href="https://transformer.huggingface.co/" rel="nofollow">Write With Transformers</a>, translation).',Wa,bt,Ba,vt,mr="A generic way to say “deal with texts”.",Xa,wt,Ra,Tt,dr=`All tasks related to understanding what is in a text (for instance classifying the
whole text, individual words).`,Aa,xt,Sa,kt,Ea,yt,fr="A pipeline in 🤗 Transformers is an abstraction referring to a series of steps that are executed in a specific order to preprocess and transform data and return a prediction from a model. Some example stages found in a pipeline might be data preprocessing, feature extraction, and normalization.",Da,Ct,hr='For more details, see <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">Pipelines for inference</a>.',Qa,jt,Ya,_t,ur=`Parallelism technique in which the model is split up vertically (layer-level) across multiple GPUs, so that only one or
several layers of the model are placed on a single GPU. Each GPU processes in parallel different stages of the pipeline
and working on a small chunk of the batch. Learn more about how PipelineParallel works <a href="perf_train_gpu_many#from-naive-model-parallelism-to-pipeline-parallelism">here</a>.`,Oa,Mt,Ka,Pt,gr="A tensor of the numerical representations of an image that is passed to a model. The pixel values have a shape of [<code>batch_size</code>, <code>num_channels</code>, <code>height</code>, <code>width</code>], and are generated from an image processor.",el,qt,tl,Ht,cr="An operation that reduces a matrix into a smaller matrix, either by taking the maximum or average of the pooled dimension(s). Pooling layers are commonly found between convolutional layers to downsample the feature representation.",nl,Lt,sl,zt,$r=`Contrary to RNNs that have the position of each token embedded within them, transformers are unaware of the position of
each token. Therefore, the position IDs (<code>position_ids</code>) are used by the model to identify each token’s position in the
list of tokens.`,al,Vt,br=`They are an optional parameter. If no <code>position_ids</code> are passed to the model, the IDs are automatically created as
absolute positional embeddings.`,ll,Zt,vr=`Absolute positional embeddings are selected in the range <code>[0, config.max_position_embeddings - 1]</code>. Some models use
other types of positional embeddings, such as sinusoidal position embeddings or relative position embeddings.`,il,Ut,rl,Ft,wr='The task of preparing raw data into a format that can be easily consumed by machine learning models. For example, text is typically preprocessed by tokenization. To gain a better idea of what preprocessing looks like for other input types, check out the <a href="https://huggingface.co/docs/transformers/preprocessing" rel="nofollow">Preprocess</a> tutorial.',ol,It,pl,Nt,Tr=`A model that has been pretrained on some data (for instance all of Wikipedia). Pretraining methods involve a
self-supervised objective, which can be reading the text and trying to predict the next word (see <a href="#causal-language-modeling">causal language
modeling</a>) or masking some words and trying to predict them (see <a href="#masked-language-modeling-mlm">masked language
modeling</a>).`,ml,Jt,xr="Speech and vision models have their own pretraining objectives. For example, Wav2Vec2 is a speech model pretrained on a contrastive task which requires the model to identify the “true” speech representation from a set of “false” speech representations. On the other hand, BEiT is a vision model pretrained on a masked image modeling task which masks some of the image patches and requires the model to predict the masked patches (similar to the masked language modeling objective).",dl,Gt,fl,Wt,hl,Bt,kr="A type of model that uses a loop over a layer to process texts.",ul,Xt,gl,Rt,yr="A subfield of machine learning which focuses on learning meaningful representations of raw data. Some examples of representation learning techniques include word embeddings, autoencoders, and Generative Adversarial Networks (GANs).",cl,At,$l,St,bl,Et,Cr="A measurement in hertz of the number of samples (the audio signal) taken per second. The sampling rate is a result of discretizing a continuous signal such as speech.",vl,Dt,wl,Qt,jr="Each element of the input finds out which other elements of the input they should attend to.",Tl,Yt,xl,Ot,_r='A category of machine learning techniques in which a model creates its own learning objective from unlabeled data. It differs from <a href="#unsupervised-learning">unsupervised learning</a> and <a href="#supervised-learning">supervised learning</a> in that the learning process is supervised, but not explicitly from the user.',kl,Kt,Mr='One example of self-supervised learning is <a href="#masked-language-modeling-mlm">masked language modeling</a>, where a model is passed sentences with a proportion of its tokens removed and learns to predict the missing tokens.',yl,en,Cl,tn,Pr='A broad category of machine learning training techniques that leverages a small amount of labeled data with a larger quantity of unlabeled data to improve the accuracy of a model, unlike <a href="#supervised-learning">supervised learning</a> and <a href="#unsupervised-learning">unsupervised learning</a>.',jl,nn,qr="An example of a semi-supervised learning approach is “self-training”, in which a model is trained on labeled data, and then used to make predictions on the unlabeled data. The portion of the unlabeled data that the model predicts with the most confidence gets added to the labeled dataset and used to retrain the model.",_l,sn,Ml,an,Hr=`Models that generate a new sequence from an input, like translation models, or summarization models (such as
<a href="model_doc/bart">Bart</a> or <a href="model_doc/t5">T5</a>).`,Pl,ln,ql,rn,Lr='Another name for the foundational <a href="#zero-redundancy-optimizer--zero-">ZeRO</a> concept as used by various other implementations of ZeRO.',Hl,on,Ll,pn,zr='In <a href="#convolution">convolution</a> or <a href="#pooling">pooling</a>, the stride refers to the distance the kernel is moved over a matrix. A stride of 1 means the kernel is moved one pixel over at a time, and a stride of 2 means the kernel is moved two pixels over at a time.',zl,mn,Vl,dn,Vr="A form of model training that directly uses labeled data to correct and instruct model performance. Data is fed into the model being trained, and its predictions are compared to the known labels. The model updates its weights based on how incorrect its predictions were, and the process is repeated to optimize model performance.",Zl,fn,Ul,hn,Fl,un,Zr=`Parallelism technique for training on multiple GPUs in which each tensor is split up into multiple chunks, so instead of
having the whole tensor reside on a single GPU, each shard of the tensor resides on its designated GPU. Shards gets
processed separately and in parallel on different GPUs and the results are synced at the end of the processing step.
This is what is sometimes called horizontal parallelism, as the splitting happens on horizontal level.
Learn more about Tensor Parallelism <a href="perf_train_gpu_many#tensor-parallelism">here</a>.`,Il,gn,Nl,cn,Ur=`A part of a sentence, usually a word, but can also be a subword (non-common words are often split in subwords) or a
punctuation symbol.`,Jl,$n,Gl,bn,Fr="Some models’ purpose is to do classification on pairs of sentences or question answering.",Wl,vn,Bl,wn,Ir=`These require two different sequences to be joined in a single “input_ids” entry, which usually is performed with the
help of special tokens, such as the classifier (<code>[CLS]</code>) and separator (<code>[SEP]</code>) tokens. For example, the BERT model
builds its two sequence input as such:`,Xl,Tn,Rl,xn,Nr=`We can use our tokenizer to automatically generate such a sentence by passing the two sequences to <code>tokenizer</code> as two
arguments (and not a list, like before) like this:`,Al,kn,Sl,yn,Jr="which will return:",El,Cn,Dl,jn,Gr=`This is enough for some models to understand where one sequence ends and where another begins. However, other models,
such as BERT, also deploy token type IDs (also called segment IDs). They are represented as a binary mask identifying
the two types of sequence in the model.`,Ql,_n,Wr="The tokenizer returns this mask as the “token_type_ids” entry:",Yl,Mn,Ol,Pn,Br=`The first sequence, the “context” used for the question, has all its tokens represented by a <code>0</code>, whereas the second
sequence, corresponding to the “question”, has all its tokens represented by a <code>1</code>.`,Kl,qn,Xr='Some models, like <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> use an additional token represented by a <code>2</code>.',ei,Hn,ti,Ln,Rr="A technique that involves taking a pretrained model and adapting it to a dataset specific to your task. Instead of training a model from scratch, you can leverage knowledge obtained from an existing model as a starting point. This speeds up the learning process and reduces the amount of training data needed.",ni,zn,si,Vn,Ar="Self-attention based deep learning model architecture.",ai,Zn,li,Un,ii,Fn,Sr="A form of model training in which data provided to the model is not labeled. Unsupervised learning techniques leverage statistical information of the data distribution to find patterns useful for the task at hand.",ri,In,oi,Nn,pi,Jn,Er=`Parallelism technique which performs sharding of the tensors somewhat similar to <a href="#tensor-parallelism-tp">TensorParallel</a>,
except the whole tensor gets reconstructed in time for a forward or backward computation, therefore the model doesn’t need
to be modified. This method also supports various offloading techniques to compensate for limited GPU memory.
Learn more about ZeRO <a href="perf_train_gpu_many#zero-data-parallelism">here</a>.`,mi,Wn,di;return T=new g({props:{title:"Glossary",local:"glossary",headingTag:"h1"}}),k=new g({props:{title:"A",local:"a",headingTag:"h2"}}),y=new g({props:{title:"attention mask",local:"attention-mask",headingTag:"h3"}}),j=new Bn({props:{id:"M6adb1j2jPI"}}),P=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBc2VxdWVuY2VfYSUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBzaG9ydCUyMHNlcXVlbmNlLiUyMiUwQXNlcXVlbmNlX2IlMjAlM0QlMjAlMjJUaGlzJTIwaXMlMjBhJTIwcmF0aGVyJTIwbG9uZyUyMHNlcXVlbmNlLiUyMEl0JTIwaXMlMjBhdCUyMGxlYXN0JTIwbG9uZ2VyJTIwdGhhbiUyMHRoZSUyMHNlcXVlbmNlJTIwQS4lMjIlMEElMEFlbmNvZGVkX3NlcXVlbmNlX2ElMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VfYSklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEFlbmNvZGVkX3NlcXVlbmNlX2IlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VfYiklNUIlMjJpbnB1dF9pZHMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_a = <span class="hljs-string">&quot;This is a short sequence.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_b = <span class="hljs-string">&quot;This is a rather long sequence. It is at least longer than the sequence A.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence_a = tokenizer(sequence_a)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence_b = tokenizer(sequence_b)[<span class="hljs-string">&quot;input_ids&quot;</span>]`,wrap:!1}}),H=new $({props:{code:"bGVuKGVuY29kZWRfc2VxdWVuY2VfYSklMkMlMjBsZW4oZW5jb2RlZF9zZXF1ZW5jZV9iKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(encoded_sequence_a), <span class="hljs-built_in">len</span>(encoded_sequence_b)
(<span class="hljs-number">8</span>, <span class="hljs-number">19</span>)`,wrap:!1}}),V=new $({props:{code:"cGFkZGVkX3NlcXVlbmNlcyUyMCUzRCUyMHRva2VuaXplciglNUJzZXF1ZW5jZV9hJTJDJTIwc2VxdWVuY2VfYiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences = tokenizer([sequence_a, sequence_b], padding=<span class="hljs-literal">True</span>)',wrap:!1}}),U=new $({props:{code:"cGFkZGVkX3NlcXVlbmNlcyU1QiUyMmlucHV0X2lkcyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences[<span class="hljs-string">&quot;input_ids&quot;</span>]
[[<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1603</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1897</span>, <span class="hljs-number">1263</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">119</span>, <span class="hljs-number">1135</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">1120</span>, <span class="hljs-number">1655</span>, <span class="hljs-number">2039</span>, <span class="hljs-number">1190</span>, <span class="hljs-number">1103</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">138</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>]]`,wrap:!1}}),I=new $({props:{code:"cGFkZGVkX3NlcXVlbmNlcyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences[<span class="hljs-string">&quot;attention_mask&quot;</span>]
[[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]`,wrap:!1}}),N=new g({props:{title:"autoencoding models",local:"autoencoding-models",headingTag:"h3"}}),G=new g({props:{title:"autoregressive models",local:"autoregressive-models",headingTag:"h3"}}),B=new g({props:{title:"B",local:"b",headingTag:"h2"}}),X=new g({props:{title:"backbone",local:"backbone",headingTag:"h3"}}),A=new g({props:{title:"C",local:"c",headingTag:"h2"}}),S=new g({props:{title:"causal language modeling",local:"causal-language-modeling",headingTag:"h3"}}),D=new g({props:{title:"channel",local:"channel",headingTag:"h3"}}),Y=new g({props:{title:"connectionist temporal classification (CTC)",local:"connectionist-temporal-classification-ctc",headingTag:"h3"}}),K=new g({props:{title:"convolution",local:"convolution",headingTag:"h3"}}),te=new g({props:{title:"D",local:"d",headingTag:"h2"}}),ne=new g({props:{title:"DataParallel (DP)",local:"dataparallel-dp",headingTag:"h3"}}),le=new g({props:{title:"decoder input IDs",local:"decoder-input-ids",headingTag:"h3"}}),pe=new g({props:{title:"decoder models",local:"decoder-models",headingTag:"h3"}}),de=new Bn({props:{id:"d_ixlCubqQw"}}),fe=new g({props:{title:"deep learning (DL)",local:"deep-learning-dl",headingTag:"h3"}}),ue=new g({props:{title:"E",local:"e",headingTag:"h2"}}),ge=new g({props:{title:"encoder models",local:"encoder-models",headingTag:"h3"}}),$e=new Bn({props:{id:"H39Z_720T5s"}}),be=new g({props:{title:"F",local:"f",headingTag:"h2"}}),ve=new g({props:{title:"feature extraction",local:"feature-extraction",headingTag:"h3"}}),Te=new g({props:{title:"feed forward chunking",local:"feed-forward-chunking",headingTag:"h3"}}),Ce=new g({props:{title:"finetuned models",local:"finetuned-models",headingTag:"h3"}}),Me=new g({props:{title:"H",local:"h",headingTag:"h2"}}),Pe=new g({props:{title:"head",local:"head",headingTag:"h3"}}),Le=new g({props:{title:"I",local:"i",headingTag:"h2"}}),ze=new g({props:{title:"image patch",local:"image-patch",headingTag:"h3"}}),Ze=new g({props:{title:"inference",local:"inference",headingTag:"h3"}}),Fe=new g({props:{title:"input IDs",local:"input-ids",headingTag:"h3"}}),Ne=new Bn({props:{id:"VFp38yj8h3A"}}),Ge=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBc2VxdWVuY2UlMjAlM0QlMjAlMjJBJTIwVGl0YW4lMjBSVFglMjBoYXMlMjAyNEdCJTIwb2YlMjBWUkFNJTIy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = <span class="hljs-string">&quot;A Titan RTX has 24GB of VRAM&quot;</span>`,wrap:!1}}),Be=new $({props:{code:"dG9rZW5pemVkX3NlcXVlbmNlJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKHNlcXVlbmNlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_sequence = tokenizer.tokenize(sequence)',wrap:!1}}),Re=new $({props:{code:"cHJpbnQodG9rZW5pemVkX3NlcXVlbmNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenized_sequence)
[<span class="hljs-string">&#x27;A&#x27;</span>, <span class="hljs-string">&#x27;Titan&#x27;</span>, <span class="hljs-string">&#x27;R&#x27;</span>, <span class="hljs-string">&#x27;##T&#x27;</span>, <span class="hljs-string">&#x27;##X&#x27;</span>, <span class="hljs-string">&#x27;has&#x27;</span>, <span class="hljs-string">&#x27;24&#x27;</span>, <span class="hljs-string">&#x27;##GB&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;V&#x27;</span>, <span class="hljs-string">&#x27;##RA&#x27;</span>, <span class="hljs-string">&#x27;##M&#x27;</span>]`,wrap:!1}}),Se=new $({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(sequence)',wrap:!1}}),De=new $({props:{code:"ZW5jb2RlZF9zZXF1ZW5jZSUyMCUzRCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQXByaW50KGVuY29kZWRfc2VxdWVuY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoded_sequence)
[<span class="hljs-number">101</span>, <span class="hljs-number">138</span>, <span class="hljs-number">18696</span>, <span class="hljs-number">155</span>, <span class="hljs-number">1942</span>, <span class="hljs-number">3190</span>, <span class="hljs-number">1144</span>, <span class="hljs-number">1572</span>, <span class="hljs-number">13745</span>, <span class="hljs-number">1104</span>, <span class="hljs-number">159</span>, <span class="hljs-number">9664</span>, <span class="hljs-number">2107</span>, <span class="hljs-number">102</span>]`,wrap:!1}}),Oe=new $({props:{code:"ZGVjb2RlZF9zZXF1ZW5jZSUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZW5jb2RlZF9zZXF1ZW5jZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>decoded_sequence = tokenizer.decode(encoded_sequence)',wrap:!1}}),et=new $({props:{code:"cHJpbnQoZGVjb2RlZF9zZXF1ZW5jZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(decoded_sequence)
[CLS] A Titan RTX has 24GB of VRAM [SEP]`,wrap:!1}}),nt=new g({props:{title:"L",local:"l",headingTag:"h2"}}),st=new g({props:{title:"labels",local:"labels",headingTag:"h3"}}),v=new lo({props:{$$slots:{default:[io]},$$scope:{ctx:Xn}}}),ot=new g({props:{title:"large language models (LLM)",local:"large-language-models-llm",headingTag:"h3"}}),mt=new g({props:{title:"M",local:"m",headingTag:"h2"}}),dt=new g({props:{title:"masked language modeling (MLM)",local:"masked-language-modeling-mlm",headingTag:"h3"}}),ht=new g({props:{title:"multimodal",local:"multimodal",headingTag:"h3"}}),gt=new g({props:{title:"N",local:"n",headingTag:"h2"}}),ct=new g({props:{title:"Natural language generation (NLG)",local:"natural-language-generation-nlg",headingTag:"h3"}}),bt=new g({props:{title:"Natural language processing (NLP)",local:"natural-language-processing-nlp",headingTag:"h3"}}),wt=new g({props:{title:"Natural language understanding (NLU)",local:"natural-language-understanding-nlu",headingTag:"h3"}}),xt=new g({props:{title:"P",local:"p",headingTag:"h2"}}),kt=new g({props:{title:"pipeline",local:"pipeline",headingTag:"h3"}}),jt=new g({props:{title:"PipelineParallel (PP)",local:"pipelineparallel-pp",headingTag:"h3"}}),Mt=new g({props:{title:"pixel values",local:"pixel-values",headingTag:"h3"}}),qt=new g({props:{title:"pooling",local:"pooling",headingTag:"h3"}}),Lt=new g({props:{title:"position IDs",local:"position-ids",headingTag:"h3"}}),Ut=new g({props:{title:"preprocessing",local:"preprocessing",headingTag:"h3"}}),It=new g({props:{title:"pretrained model",local:"pretrained-model",headingTag:"h3"}}),Gt=new g({props:{title:"R",local:"r",headingTag:"h2"}}),Wt=new g({props:{title:"recurrent neural network (RNN)",local:"recurrent-neural-network-rnn",headingTag:"h3"}}),Xt=new g({props:{title:"representation learning",local:"representation-learning",headingTag:"h3"}}),At=new g({props:{title:"S",local:"s",headingTag:"h2"}}),St=new g({props:{title:"sampling rate",local:"sampling-rate",headingTag:"h3"}}),Dt=new g({props:{title:"self-attention",local:"self-attention",headingTag:"h3"}}),Yt=new g({props:{title:"self-supervised learning",local:"self-supervised-learning",headingTag:"h3"}}),en=new g({props:{title:"semi-supervised learning",local:"semi-supervised-learning",headingTag:"h3"}}),sn=new g({props:{title:"sequence-to-sequence (seq2seq)",local:"sequence-to-sequence-seq2seq",headingTag:"h3"}}),ln=new g({props:{title:"Sharded DDP",local:"sharded-ddp",headingTag:"h3"}}),on=new g({props:{title:"stride",local:"stride",headingTag:"h3"}}),mn=new g({props:{title:"supervised learning",local:"supervised-learning",headingTag:"h3"}}),fn=new g({props:{title:"T",local:"t",headingTag:"h2"}}),hn=new g({props:{title:"Tensor Parallelism (TP)",local:"tensor-parallelism-tp",headingTag:"h3"}}),gn=new g({props:{title:"token",local:"token",headingTag:"h3"}}),$n=new g({props:{title:"token Type IDs",local:"token-type-ids",headingTag:"h3"}}),vn=new Bn({props:{id:"0u3ioSwev3s"}}),Tn=new $({props:{code:"JTIzJTIwJTVCQ0xTJTVEJTIwU0VRVUVOQ0VfQSUyMCU1QlNFUCU1RCUyMFNFUVVFTkNFX0IlMjAlNUJTRVAlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [CLS] SEQUENCE_A [SEP] SEQUENCE_B [SEP]</span>',wrap:!1}}),kn=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBc2VxdWVuY2VfYSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBiYXNlZCUyMGluJTIwTllDJTIyJTBBc2VxdWVuY2VfYiUyMCUzRCUyMCUyMldoZXJlJTIwaXMlMjBIdWdnaW5nRmFjZSUyMGJhc2VkJTNGJTIyJTBBJTBBZW5jb2RlZF9kaWN0JTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlX2ElMkMlMjBzZXF1ZW5jZV9iKSUwQWRlY29kZWQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGVuY29kZWRfZGljdCU1QiUyMmlucHV0X2lkcyUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_a = <span class="hljs-string">&quot;HuggingFace is based in NYC&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_b = <span class="hljs-string">&quot;Where is HuggingFace based?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dict = tokenizer(sequence_a, sequence_b)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoded = tokenizer.decode(encoded_dict[<span class="hljs-string">&quot;input_ids&quot;</span>])`,wrap:!1}}),Cn=new $({props:{code:"cHJpbnQoZGVjb2RlZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(decoded)
[CLS] HuggingFace <span class="hljs-keyword">is</span> based <span class="hljs-keyword">in</span> NYC [SEP] Where <span class="hljs-keyword">is</span> HuggingFace based? [SEP]`,wrap:!1}}),Mn=new $({props:{code:"ZW5jb2RlZF9kaWN0JTVCJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dict[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Hn=new g({props:{title:"transfer learning",local:"transfer-learning",headingTag:"h3"}}),zn=new g({props:{title:"transformer",local:"transformer",headingTag:"h3"}}),Zn=new g({props:{title:"U",local:"u",headingTag:"h2"}}),Un=new g({props:{title:"unsupervised learning",local:"unsupervised-learning",headingTag:"h3"}}),In=new g({props:{title:"Z",local:"z",headingTag:"h2"}}),Nn=new g({props:{title:"Zero Redundancy Optimizer (ZeRO)",local:"zero-redundancy-optimizer-zero",headingTag:"h3"}}),{c(){c=i("meta"),w=a(),b=i("p"),Gn=a(),p(T.$$.fragment),Rn=a(),x=i("p"),x.textContent=fi,An=a(),p(k.$$.fragment),Sn=a(),p(y.$$.fragment),En=a(),C=i("p"),C.textContent=hi,Dn=a(),p(j.$$.fragment),Qn=a(),_=i("p"),_.textContent=ui,Yn=a(),M=i("p"),M.textContent=gi,On=a(),p(P.$$.fragment),Kn=a(),q=i("p"),q.textContent=ci,es=a(),p(H.$$.fragment),ts=a(),L=i("p"),L.textContent=$i,ns=a(),z=i("p"),z.textContent=bi,ss=a(),p(V.$$.fragment),as=a(),Z=i("p"),Z.textContent=vi,ls=a(),p(U.$$.fragment),is=a(),F=i("p"),F.innerHTML=wi,rs=a(),p(I.$$.fragment),os=a(),p(N.$$.fragment),ps=a(),J=i("p"),J.innerHTML=Ti,ms=a(),p(G.$$.fragment),ds=a(),W=i("p"),W.innerHTML=xi,fs=a(),p(B.$$.fragment),hs=a(),p(X.$$.fragment),us=a(),R=i("p"),R.innerHTML=ki,gs=a(),p(A.$$.fragment),cs=a(),p(S.$$.fragment),$s=a(),E=i("p"),E.textContent=yi,bs=a(),p(D.$$.fragment),vs=a(),Q=i("p"),Q.innerHTML=Ci,ws=a(),p(Y.$$.fragment),Ts=a(),O=i("p"),O.textContent=ji,xs=a(),p(K.$$.fragment),ks=a(),ee=i("p"),ee.textContent=_i,ys=a(),p(te.$$.fragment),Cs=a(),p(ne.$$.fragment),js=a(),se=i("p"),se.textContent=Mi,_s=a(),ae=i("p"),ae.innerHTML=Pi,Ms=a(),p(le.$$.fragment),Ps=a(),ie=i("p"),ie.textContent=qi,qs=a(),re=i("p"),re.innerHTML=Hi,Hs=a(),oe=i("p"),oe.textContent=Li,Ls=a(),p(pe.$$.fragment),zs=a(),me=i("p"),me.textContent=zi,Vs=a(),p(de.$$.fragment),Zs=a(),p(fe.$$.fragment),Us=a(),he=i("p"),he.textContent=Vi,Fs=a(),p(ue.$$.fragment),Is=a(),p(ge.$$.fragment),Ns=a(),ce=i("p"),ce.innerHTML=Zi,Js=a(),p($e.$$.fragment),Gs=a(),p(be.$$.fragment),Ws=a(),p(ve.$$.fragment),Bs=a(),we=i("p"),we.textContent=Ui,Xs=a(),p(Te.$$.fragment),Rs=a(),xe=i("p"),xe.innerHTML=Fi,As=a(),ke=i("p"),ke.innerHTML=Ii,Ss=a(),ye=i("p"),ye.innerHTML=Ni,Es=a(),p(Ce.$$.fragment),Ds=a(),je=i("p"),je.innerHTML=Ji,Qs=a(),_e=i("p"),_e.innerHTML=Gi,Ys=a(),p(Me.$$.fragment),Os=a(),p(Pe.$$.fragment),Ks=a(),qe=i("p"),qe.textContent=Wi,ea=a(),He=i("ul"),He.innerHTML=Bi,ta=a(),p(Le.$$.fragment),na=a(),p(ze.$$.fragment),sa=a(),Ve=i("p"),Ve.innerHTML=Xi,aa=a(),p(Ze.$$.fragment),la=a(),Ue=i("p"),Ue.innerHTML=Ri,ia=a(),p(Fe.$$.fragment),ra=a(),Ie=i("p"),Ie.textContent=Ai,oa=a(),p(Ne.$$.fragment),pa=a(),Je=i("p"),Je.innerHTML=Si,ma=a(),p(Ge.$$.fragment),da=a(),We=i("p"),We.textContent=Ei,fa=a(),p(Be.$$.fragment),ha=a(),Xe=i("p"),Xe.textContent=Di,ua=a(),p(Re.$$.fragment),ga=a(),Ae=i("p"),Ae.innerHTML=Qi,ca=a(),p(Se.$$.fragment),$a=a(),Ee=i("p"),Ee.innerHTML=Yi,ba=a(),p(De.$$.fragment),va=a(),Qe=i("p"),Qe.textContent=Oi,wa=a(),Ye=i("p"),Ye.textContent=Ki,Ta=a(),p(Oe.$$.fragment),xa=a(),Ke=i("p"),Ke.textContent=er,ka=a(),p(et.$$.fragment),ya=a(),tt=i("p"),tt.innerHTML=tr,Ca=a(),p(nt.$$.fragment),ja=a(),p(st.$$.fragment),_a=a(),at=i("p"),at.textContent=nr,Ma=a(),lt=i("p"),lt.textContent=sr,Pa=a(),it=i("ul"),it.innerHTML=ar,qa=a(),p(v.$$.fragment),Ha=a(),rt=i("p"),rt.innerHTML=lr,La=a(),p(ot.$$.fragment),za=a(),pt=i("p"),pt.textContent=ir,Va=a(),p(mt.$$.fragment),Za=a(),p(dt.$$.fragment),Ua=a(),ft=i("p"),ft.textContent=rr,Fa=a(),p(ht.$$.fragment),Ia=a(),ut=i("p"),ut.textContent=or,Na=a(),p(gt.$$.fragment),Ja=a(),p(ct.$$.fragment),Ga=a(),$t=i("p"),$t.innerHTML=pr,Wa=a(),p(bt.$$.fragment),Ba=a(),vt=i("p"),vt.textContent=mr,Xa=a(),p(wt.$$.fragment),Ra=a(),Tt=i("p"),Tt.textContent=dr,Aa=a(),p(xt.$$.fragment),Sa=a(),p(kt.$$.fragment),Ea=a(),yt=i("p"),yt.textContent=fr,Da=a(),Ct=i("p"),Ct.innerHTML=hr,Qa=a(),p(jt.$$.fragment),Ya=a(),_t=i("p"),_t.innerHTML=ur,Oa=a(),p(Mt.$$.fragment),Ka=a(),Pt=i("p"),Pt.innerHTML=gr,el=a(),p(qt.$$.fragment),tl=a(),Ht=i("p"),Ht.textContent=cr,nl=a(),p(Lt.$$.fragment),sl=a(),zt=i("p"),zt.innerHTML=$r,al=a(),Vt=i("p"),Vt.innerHTML=br,ll=a(),Zt=i("p"),Zt.innerHTML=vr,il=a(),p(Ut.$$.fragment),rl=a(),Ft=i("p"),Ft.innerHTML=wr,ol=a(),p(It.$$.fragment),pl=a(),Nt=i("p"),Nt.innerHTML=Tr,ml=a(),Jt=i("p"),Jt.textContent=xr,dl=a(),p(Gt.$$.fragment),fl=a(),p(Wt.$$.fragment),hl=a(),Bt=i("p"),Bt.textContent=kr,ul=a(),p(Xt.$$.fragment),gl=a(),Rt=i("p"),Rt.textContent=yr,cl=a(),p(At.$$.fragment),$l=a(),p(St.$$.fragment),bl=a(),Et=i("p"),Et.textContent=Cr,vl=a(),p(Dt.$$.fragment),wl=a(),Qt=i("p"),Qt.textContent=jr,Tl=a(),p(Yt.$$.fragment),xl=a(),Ot=i("p"),Ot.innerHTML=_r,kl=a(),Kt=i("p"),Kt.innerHTML=Mr,yl=a(),p(en.$$.fragment),Cl=a(),tn=i("p"),tn.innerHTML=Pr,jl=a(),nn=i("p"),nn.textContent=qr,_l=a(),p(sn.$$.fragment),Ml=a(),an=i("p"),an.innerHTML=Hr,Pl=a(),p(ln.$$.fragment),ql=a(),rn=i("p"),rn.innerHTML=Lr,Hl=a(),p(on.$$.fragment),Ll=a(),pn=i("p"),pn.innerHTML=zr,zl=a(),p(mn.$$.fragment),Vl=a(),dn=i("p"),dn.textContent=Vr,Zl=a(),p(fn.$$.fragment),Ul=a(),p(hn.$$.fragment),Fl=a(),un=i("p"),un.innerHTML=Zr,Il=a(),p(gn.$$.fragment),Nl=a(),cn=i("p"),cn.textContent=Ur,Jl=a(),p($n.$$.fragment),Gl=a(),bn=i("p"),bn.textContent=Fr,Wl=a(),p(vn.$$.fragment),Bl=a(),wn=i("p"),wn.innerHTML=Ir,Xl=a(),p(Tn.$$.fragment),Rl=a(),xn=i("p"),xn.innerHTML=Nr,Al=a(),p(kn.$$.fragment),Sl=a(),yn=i("p"),yn.textContent=Jr,El=a(),p(Cn.$$.fragment),Dl=a(),jn=i("p"),jn.textContent=Gr,Ql=a(),_n=i("p"),_n.textContent=Wr,Yl=a(),p(Mn.$$.fragment),Ol=a(),Pn=i("p"),Pn.innerHTML=Br,Kl=a(),qn=i("p"),qn.innerHTML=Xr,ei=a(),p(Hn.$$.fragment),ti=a(),Ln=i("p"),Ln.textContent=Rr,ni=a(),p(zn.$$.fragment),si=a(),Vn=i("p"),Vn.textContent=Ar,ai=a(),p(Zn.$$.fragment),li=a(),p(Un.$$.fragment),ii=a(),Fn=i("p"),Fn.textContent=Sr,ri=a(),p(In.$$.fragment),oi=a(),p(Nn.$$.fragment),pi=a(),Jn=i("p"),Jn.innerHTML=Er,mi=a(),Wn=i("p"),this.h()},l(e){const t=so("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(n),w=l(e),b=r(e,"P",{}),Qr(b).forEach(n),Gn=l(e),m(T.$$.fragment,e),Rn=l(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1dvjafk"&&(x.textContent=fi),An=l(e),m(k.$$.fragment,e),Sn=l(e),m(y.$$.fragment,e),En=l(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-zageh2"&&(C.textContent=hi),Dn=l(e),m(j.$$.fragment,e),Qn=l(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-16bi7cp"&&(_.textContent=ui),Yn=l(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1s3smvj"&&(M.textContent=gi),On=l(e),m(P.$$.fragment,e),Kn=l(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-xx5dsm"&&(q.textContent=ci),es=l(e),m(H.$$.fragment,e),ts=l(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-mhr0gb"&&(L.textContent=$i),ns=l(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-zbn0tl"&&(z.textContent=bi),ss=l(e),m(V.$$.fragment,e),as=l(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1lmyquq"&&(Z.textContent=vi),ls=l(e),m(U.$$.fragment,e),is=l(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ga72y7"&&(F.innerHTML=wi),rs=l(e),m(I.$$.fragment,e),os=l(e),m(N.$$.fragment,e),ps=l(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1oazoau"&&(J.innerHTML=Ti),ms=l(e),m(G.$$.fragment,e),ds=l(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-rond5"&&(W.innerHTML=xi),fs=l(e),m(B.$$.fragment,e),hs=l(e),m(X.$$.fragment,e),us=l(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-10tfmvy"&&(R.innerHTML=ki),gs=l(e),m(A.$$.fragment,e),cs=l(e),m(S.$$.fragment,e),$s=l(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1l74vbi"&&(E.textContent=yi),bs=l(e),m(D.$$.fragment,e),vs=l(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-17mz02t"&&(Q.innerHTML=Ci),ws=l(e),m(Y.$$.fragment,e),Ts=l(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1fbuf3j"&&(O.textContent=ji),xs=l(e),m(K.$$.fragment,e),ks=l(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1ld4khv"&&(ee.textContent=_i),ys=l(e),m(te.$$.fragment,e),Cs=l(e),m(ne.$$.fragment,e),js=l(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-qq7mzd"&&(se.textContent=Mi),_s=l(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1380bi6"&&(ae.innerHTML=Pi),Ms=l(e),m(le.$$.fragment,e),Ps=l(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-10vz57"&&(ie.textContent=qi),qs=l(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1v396xu"&&(re.innerHTML=Hi),Hs=l(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-ssnlyg"&&(oe.textContent=Li),Ls=l(e),m(pe.$$.fragment,e),zs=l(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1ur5avw"&&(me.textContent=zi),Vs=l(e),m(de.$$.fragment,e),Zs=l(e),m(fe.$$.fragment,e),Us=l(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1fczmsm"&&(he.textContent=Vi),Fs=l(e),m(ue.$$.fragment,e),Is=l(e),m(ge.$$.fragment,e),Ns=l(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-jzdlbw"&&(ce.innerHTML=Zi),Js=l(e),m($e.$$.fragment,e),Gs=l(e),m(be.$$.fragment,e),Ws=l(e),m(ve.$$.fragment,e),Bs=l(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-14m2s4w"&&(we.textContent=Ui),Xs=l(e),m(Te.$$.fragment,e),Rs=l(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1tiu5po"&&(xe.innerHTML=Fi),As=l(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1xp8jp0"&&(ke.innerHTML=Ii),Ss=l(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-mkgrbq"&&(ye.innerHTML=Ni),Es=l(e),m(Ce.$$.fragment,e),Ds=l(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-192shka"&&(je.innerHTML=Ji),Qs=l(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1gtjz9f"&&(_e.innerHTML=Gi),Ys=l(e),m(Me.$$.fragment,e),Os=l(e),m(Pe.$$.fragment,e),Ks=l(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1espo04"&&(qe.textContent=Wi),ea=l(e),He=r(e,"UL",{"data-svelte-h":!0}),o(He)!=="svelte-17ceo0l"&&(He.innerHTML=Bi),ta=l(e),m(Le.$$.fragment,e),na=l(e),m(ze.$$.fragment,e),sa=l(e),Ve=r(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1mw8vlz"&&(Ve.innerHTML=Xi),aa=l(e),m(Ze.$$.fragment,e),la=l(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-17c2u3c"&&(Ue.innerHTML=Ri),ia=l(e),m(Fe.$$.fragment,e),ra=l(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jkg17q"&&(Ie.textContent=Ai),oa=l(e),m(Ne.$$.fragment,e),pa=l(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-f3pbty"&&(Je.innerHTML=Si),ma=l(e),m(Ge.$$.fragment,e),da=l(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1k2pdza"&&(We.textContent=Ei),fa=l(e),m(Be.$$.fragment,e),ha=l(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1439yqx"&&(Xe.textContent=Di),ua=l(e),m(Re.$$.fragment,e),ga=l(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-z90sko"&&(Ae.innerHTML=Qi),ca=l(e),m(Se.$$.fragment,e),$a=l(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1dyjpha"&&(Ee.innerHTML=Yi),ba=l(e),m(De.$$.fragment,e),va=l(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-we66x9"&&(Qe.textContent=Oi),wa=l(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-by6kqv"&&(Ye.textContent=Ki),Ta=l(e),m(Oe.$$.fragment,e),xa=l(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1ojjtj3"&&(Ke.textContent=er),ka=l(e),m(et.$$.fragment,e),ya=l(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-33ifol"&&(tt.innerHTML=tr),Ca=l(e),m(nt.$$.fragment,e),ja=l(e),m(st.$$.fragment,e),_a=l(e),at=r(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-7ywmff"&&(at.textContent=nr),Ma=l(e),lt=r(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-psjost"&&(lt.textContent=sr),Pa=l(e),it=r(e,"UL",{"data-svelte-h":!0}),o(it)!=="svelte-lo6agj"&&(it.innerHTML=ar),qa=l(e),m(v.$$.fragment,e),Ha=l(e),rt=r(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-siz5kz"&&(rt.innerHTML=lr),La=l(e),m(ot.$$.fragment,e),za=l(e),pt=r(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1vm9qc5"&&(pt.textContent=ir),Va=l(e),m(mt.$$.fragment,e),Za=l(e),m(dt.$$.fragment,e),Ua=l(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1kgpofh"&&(ft.textContent=rr),Fa=l(e),m(ht.$$.fragment,e),Ia=l(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-me9jqn"&&(ut.textContent=or),Na=l(e),m(gt.$$.fragment,e),Ja=l(e),m(ct.$$.fragment,e),Ga=l(e),$t=r(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1lci4tz"&&($t.innerHTML=pr),Wa=l(e),m(bt.$$.fragment,e),Ba=l(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1xw03f6"&&(vt.textContent=mr),Xa=l(e),m(wt.$$.fragment,e),Ra=l(e),Tt=r(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-jloa1o"&&(Tt.textContent=dr),Aa=l(e),m(xt.$$.fragment,e),Sa=l(e),m(kt.$$.fragment,e),Ea=l(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-11425z2"&&(yt.textContent=fr),Da=l(e),Ct=r(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-d7g64p"&&(Ct.innerHTML=hr),Qa=l(e),m(jt.$$.fragment,e),Ya=l(e),_t=r(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-1atuy26"&&(_t.innerHTML=ur),Oa=l(e),m(Mt.$$.fragment,e),Ka=l(e),Pt=r(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-1kebnp7"&&(Pt.innerHTML=gr),el=l(e),m(qt.$$.fragment,e),tl=l(e),Ht=r(e,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-1r6n0wg"&&(Ht.textContent=cr),nl=l(e),m(Lt.$$.fragment,e),sl=l(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-igup9t"&&(zt.innerHTML=$r),al=l(e),Vt=r(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-11pr6r1"&&(Vt.innerHTML=br),ll=l(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1ytbypv"&&(Zt.innerHTML=vr),il=l(e),m(Ut.$$.fragment,e),rl=l(e),Ft=r(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-f3comh"&&(Ft.innerHTML=wr),ol=l(e),m(It.$$.fragment,e),pl=l(e),Nt=r(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-k4gwb8"&&(Nt.innerHTML=Tr),ml=l(e),Jt=r(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-ufotjt"&&(Jt.textContent=xr),dl=l(e),m(Gt.$$.fragment,e),fl=l(e),m(Wt.$$.fragment,e),hl=l(e),Bt=r(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1mx2xgz"&&(Bt.textContent=kr),ul=l(e),m(Xt.$$.fragment,e),gl=l(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-161935m"&&(Rt.textContent=yr),cl=l(e),m(At.$$.fragment,e),$l=l(e),m(St.$$.fragment,e),bl=l(e),Et=r(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-1lulygn"&&(Et.textContent=Cr),vl=l(e),m(Dt.$$.fragment,e),wl=l(e),Qt=r(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-7tevil"&&(Qt.textContent=jr),Tl=l(e),m(Yt.$$.fragment,e),xl=l(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-q5srtm"&&(Ot.innerHTML=_r),kl=l(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1gi4tsf"&&(Kt.innerHTML=Mr),yl=l(e),m(en.$$.fragment,e),Cl=l(e),tn=r(e,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-pmee3i"&&(tn.innerHTML=Pr),jl=l(e),nn=r(e,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-1s8tag4"&&(nn.textContent=qr),_l=l(e),m(sn.$$.fragment,e),Ml=l(e),an=r(e,"P",{"data-svelte-h":!0}),o(an)!=="svelte-1js9xy4"&&(an.innerHTML=Hr),Pl=l(e),m(ln.$$.fragment,e),ql=l(e),rn=r(e,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-loga5k"&&(rn.innerHTML=Lr),Hl=l(e),m(on.$$.fragment,e),Ll=l(e),pn=r(e,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-1uq3sec"&&(pn.innerHTML=zr),zl=l(e),m(mn.$$.fragment,e),Vl=l(e),dn=r(e,"P",{"data-svelte-h":!0}),o(dn)!=="svelte-14ftbmc"&&(dn.textContent=Vr),Zl=l(e),m(fn.$$.fragment,e),Ul=l(e),m(hn.$$.fragment,e),Fl=l(e),un=r(e,"P",{"data-svelte-h":!0}),o(un)!=="svelte-1e72nph"&&(un.innerHTML=Zr),Il=l(e),m(gn.$$.fragment,e),Nl=l(e),cn=r(e,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-16cfsju"&&(cn.textContent=Ur),Jl=l(e),m($n.$$.fragment,e),Gl=l(e),bn=r(e,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-1lo37lj"&&(bn.textContent=Fr),Wl=l(e),m(vn.$$.fragment,e),Bl=l(e),wn=r(e,"P",{"data-svelte-h":!0}),o(wn)!=="svelte-10jv2li"&&(wn.innerHTML=Ir),Xl=l(e),m(Tn.$$.fragment,e),Rl=l(e),xn=r(e,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-10hgp93"&&(xn.innerHTML=Nr),Al=l(e),m(kn.$$.fragment,e),Sl=l(e),yn=r(e,"P",{"data-svelte-h":!0}),o(yn)!=="svelte-19vzvwp"&&(yn.textContent=Jr),El=l(e),m(Cn.$$.fragment,e),Dl=l(e),jn=r(e,"P",{"data-svelte-h":!0}),o(jn)!=="svelte-fygh0e"&&(jn.textContent=Gr),Ql=l(e),_n=r(e,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-u6fatw"&&(_n.textContent=Wr),Yl=l(e),m(Mn.$$.fragment,e),Ol=l(e),Pn=r(e,"P",{"data-svelte-h":!0}),o(Pn)!=="svelte-13hm16g"&&(Pn.innerHTML=Br),Kl=l(e),qn=r(e,"P",{"data-svelte-h":!0}),o(qn)!=="svelte-g68bdy"&&(qn.innerHTML=Xr),ei=l(e),m(Hn.$$.fragment,e),ti=l(e),Ln=r(e,"P",{"data-svelte-h":!0}),o(Ln)!=="svelte-nsuab6"&&(Ln.textContent=Rr),ni=l(e),m(zn.$$.fragment,e),si=l(e),Vn=r(e,"P",{"data-svelte-h":!0}),o(Vn)!=="svelte-cpkjuk"&&(Vn.textContent=Ar),ai=l(e),m(Zn.$$.fragment,e),li=l(e),m(Un.$$.fragment,e),ii=l(e),Fn=r(e,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-1pfu149"&&(Fn.textContent=Sr),ri=l(e),m(In.$$.fragment,e),oi=l(e),m(Nn.$$.fragment,e),pi=l(e),Jn=r(e,"P",{"data-svelte-h":!0}),o(Jn)!=="svelte-f1o49"&&(Jn.innerHTML=Er),mi=l(e),Wn=r(e,"P",{}),Qr(Wn).forEach(n),this.h()},h(){Yr(c,"name","hf:doc:metadata"),Yr(c,"content",oo)},m(e,t){ao(document.head,c),s(e,w,t),s(e,b,t),s(e,Gn,t),d(T,e,t),s(e,Rn,t),s(e,x,t),s(e,An,t),d(k,e,t),s(e,Sn,t),d(y,e,t),s(e,En,t),s(e,C,t),s(e,Dn,t),d(j,e,t),s(e,Qn,t),s(e,_,t),s(e,Yn,t),s(e,M,t),s(e,On,t),d(P,e,t),s(e,Kn,t),s(e,q,t),s(e,es,t),d(H,e,t),s(e,ts,t),s(e,L,t),s(e,ns,t),s(e,z,t),s(e,ss,t),d(V,e,t),s(e,as,t),s(e,Z,t),s(e,ls,t),d(U,e,t),s(e,is,t),s(e,F,t),s(e,rs,t),d(I,e,t),s(e,os,t),d(N,e,t),s(e,ps,t),s(e,J,t),s(e,ms,t),d(G,e,t),s(e,ds,t),s(e,W,t),s(e,fs,t),d(B,e,t),s(e,hs,t),d(X,e,t),s(e,us,t),s(e,R,t),s(e,gs,t),d(A,e,t),s(e,cs,t),d(S,e,t),s(e,$s,t),s(e,E,t),s(e,bs,t),d(D,e,t),s(e,vs,t),s(e,Q,t),s(e,ws,t),d(Y,e,t),s(e,Ts,t),s(e,O,t),s(e,xs,t),d(K,e,t),s(e,ks,t),s(e,ee,t),s(e,ys,t),d(te,e,t),s(e,Cs,t),d(ne,e,t),s(e,js,t),s(e,se,t),s(e,_s,t),s(e,ae,t),s(e,Ms,t),d(le,e,t),s(e,Ps,t),s(e,ie,t),s(e,qs,t),s(e,re,t),s(e,Hs,t),s(e,oe,t),s(e,Ls,t),d(pe,e,t),s(e,zs,t),s(e,me,t),s(e,Vs,t),d(de,e,t),s(e,Zs,t),d(fe,e,t),s(e,Us,t),s(e,he,t),s(e,Fs,t),d(ue,e,t),s(e,Is,t),d(ge,e,t),s(e,Ns,t),s(e,ce,t),s(e,Js,t),d($e,e,t),s(e,Gs,t),d(be,e,t),s(e,Ws,t),d(ve,e,t),s(e,Bs,t),s(e,we,t),s(e,Xs,t),d(Te,e,t),s(e,Rs,t),s(e,xe,t),s(e,As,t),s(e,ke,t),s(e,Ss,t),s(e,ye,t),s(e,Es,t),d(Ce,e,t),s(e,Ds,t),s(e,je,t),s(e,Qs,t),s(e,_e,t),s(e,Ys,t),d(Me,e,t),s(e,Os,t),d(Pe,e,t),s(e,Ks,t),s(e,qe,t),s(e,ea,t),s(e,He,t),s(e,ta,t),d(Le,e,t),s(e,na,t),d(ze,e,t),s(e,sa,t),s(e,Ve,t),s(e,aa,t),d(Ze,e,t),s(e,la,t),s(e,Ue,t),s(e,ia,t),d(Fe,e,t),s(e,ra,t),s(e,Ie,t),s(e,oa,t),d(Ne,e,t),s(e,pa,t),s(e,Je,t),s(e,ma,t),d(Ge,e,t),s(e,da,t),s(e,We,t),s(e,fa,t),d(Be,e,t),s(e,ha,t),s(e,Xe,t),s(e,ua,t),d(Re,e,t),s(e,ga,t),s(e,Ae,t),s(e,ca,t),d(Se,e,t),s(e,$a,t),s(e,Ee,t),s(e,ba,t),d(De,e,t),s(e,va,t),s(e,Qe,t),s(e,wa,t),s(e,Ye,t),s(e,Ta,t),d(Oe,e,t),s(e,xa,t),s(e,Ke,t),s(e,ka,t),d(et,e,t),s(e,ya,t),s(e,tt,t),s(e,Ca,t),d(nt,e,t),s(e,ja,t),d(st,e,t),s(e,_a,t),s(e,at,t),s(e,Ma,t),s(e,lt,t),s(e,Pa,t),s(e,it,t),s(e,qa,t),d(v,e,t),s(e,Ha,t),s(e,rt,t),s(e,La,t),d(ot,e,t),s(e,za,t),s(e,pt,t),s(e,Va,t),d(mt,e,t),s(e,Za,t),d(dt,e,t),s(e,Ua,t),s(e,ft,t),s(e,Fa,t),d(ht,e,t),s(e,Ia,t),s(e,ut,t),s(e,Na,t),d(gt,e,t),s(e,Ja,t),d(ct,e,t),s(e,Ga,t),s(e,$t,t),s(e,Wa,t),d(bt,e,t),s(e,Ba,t),s(e,vt,t),s(e,Xa,t),d(wt,e,t),s(e,Ra,t),s(e,Tt,t),s(e,Aa,t),d(xt,e,t),s(e,Sa,t),d(kt,e,t),s(e,Ea,t),s(e,yt,t),s(e,Da,t),s(e,Ct,t),s(e,Qa,t),d(jt,e,t),s(e,Ya,t),s(e,_t,t),s(e,Oa,t),d(Mt,e,t),s(e,Ka,t),s(e,Pt,t),s(e,el,t),d(qt,e,t),s(e,tl,t),s(e,Ht,t),s(e,nl,t),d(Lt,e,t),s(e,sl,t),s(e,zt,t),s(e,al,t),s(e,Vt,t),s(e,ll,t),s(e,Zt,t),s(e,il,t),d(Ut,e,t),s(e,rl,t),s(e,Ft,t),s(e,ol,t),d(It,e,t),s(e,pl,t),s(e,Nt,t),s(e,ml,t),s(e,Jt,t),s(e,dl,t),d(Gt,e,t),s(e,fl,t),d(Wt,e,t),s(e,hl,t),s(e,Bt,t),s(e,ul,t),d(Xt,e,t),s(e,gl,t),s(e,Rt,t),s(e,cl,t),d(At,e,t),s(e,$l,t),d(St,e,t),s(e,bl,t),s(e,Et,t),s(e,vl,t),d(Dt,e,t),s(e,wl,t),s(e,Qt,t),s(e,Tl,t),d(Yt,e,t),s(e,xl,t),s(e,Ot,t),s(e,kl,t),s(e,Kt,t),s(e,yl,t),d(en,e,t),s(e,Cl,t),s(e,tn,t),s(e,jl,t),s(e,nn,t),s(e,_l,t),d(sn,e,t),s(e,Ml,t),s(e,an,t),s(e,Pl,t),d(ln,e,t),s(e,ql,t),s(e,rn,t),s(e,Hl,t),d(on,e,t),s(e,Ll,t),s(e,pn,t),s(e,zl,t),d(mn,e,t),s(e,Vl,t),s(e,dn,t),s(e,Zl,t),d(fn,e,t),s(e,Ul,t),d(hn,e,t),s(e,Fl,t),s(e,un,t),s(e,Il,t),d(gn,e,t),s(e,Nl,t),s(e,cn,t),s(e,Jl,t),d($n,e,t),s(e,Gl,t),s(e,bn,t),s(e,Wl,t),d(vn,e,t),s(e,Bl,t),s(e,wn,t),s(e,Xl,t),d(Tn,e,t),s(e,Rl,t),s(e,xn,t),s(e,Al,t),d(kn,e,t),s(e,Sl,t),s(e,yn,t),s(e,El,t),d(Cn,e,t),s(e,Dl,t),s(e,jn,t),s(e,Ql,t),s(e,_n,t),s(e,Yl,t),d(Mn,e,t),s(e,Ol,t),s(e,Pn,t),s(e,Kl,t),s(e,qn,t),s(e,ei,t),d(Hn,e,t),s(e,ti,t),s(e,Ln,t),s(e,ni,t),d(zn,e,t),s(e,si,t),s(e,Vn,t),s(e,ai,t),d(Zn,e,t),s(e,li,t),d(Un,e,t),s(e,ii,t),s(e,Fn,t),s(e,ri,t),d(In,e,t),s(e,oi,t),d(Nn,e,t),s(e,pi,t),s(e,Jn,t),s(e,mi,t),s(e,Wn,t),di=!0},p(e,[t]){const Dr={};t&2&&(Dr.$$scope={dirty:t,ctx:e}),v.$set(Dr)},i(e){di||(f(T.$$.fragment,e),f(k.$$.fragment,e),f(y.$$.fragment,e),f(j.$$.fragment,e),f(P.$$.fragment,e),f(H.$$.fragment,e),f(V.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(N.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(X.$$.fragment,e),f(A.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(Y.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f($e.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(Ce.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(Le.$$.fragment,e),f(ze.$$.fragment,e),f(Ze.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ge.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(nt.$$.fragment,e),f(st.$$.fragment,e),f(v.$$.fragment,e),f(ot.$$.fragment,e),f(mt.$$.fragment,e),f(dt.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(ct.$$.fragment,e),f(bt.$$.fragment,e),f(wt.$$.fragment,e),f(xt.$$.fragment,e),f(kt.$$.fragment,e),f(jt.$$.fragment,e),f(Mt.$$.fragment,e),f(qt.$$.fragment,e),f(Lt.$$.fragment,e),f(Ut.$$.fragment,e),f(It.$$.fragment,e),f(Gt.$$.fragment,e),f(Wt.$$.fragment,e),f(Xt.$$.fragment,e),f(At.$$.fragment,e),f(St.$$.fragment,e),f(Dt.$$.fragment,e),f(Yt.$$.fragment,e),f(en.$$.fragment,e),f(sn.$$.fragment,e),f(ln.$$.fragment,e),f(on.$$.fragment,e),f(mn.$$.fragment,e),f(fn.$$.fragment,e),f(hn.$$.fragment,e),f(gn.$$.fragment,e),f($n.$$.fragment,e),f(vn.$$.fragment,e),f(Tn.$$.fragment,e),f(kn.$$.fragment,e),f(Cn.$$.fragment,e),f(Mn.$$.fragment,e),f(Hn.$$.fragment,e),f(zn.$$.fragment,e),f(Zn.$$.fragment,e),f(Un.$$.fragment,e),f(In.$$.fragment,e),f(Nn.$$.fragment,e),di=!0)},o(e){h(T.$$.fragment,e),h(k.$$.fragment,e),h(y.$$.fragment,e),h(j.$$.fragment,e),h(P.$$.fragment,e),h(H.$$.fragment,e),h(V.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(N.$$.fragment,e),h(G.$$.fragment,e),h(B.$$.fragment,e),h(X.$$.fragment,e),h(A.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Me.$$.fragment,e),h(Pe.$$.fragment,e),h(Le.$$.fragment,e),h(ze.$$.fragment,e),h(Ze.$$.fragment,e),h(Fe.$$.fragment,e),h(Ne.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(Re.$$.fragment,e),h(Se.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(nt.$$.fragment,e),h(st.$$.fragment,e),h(v.$$.fragment,e),h(ot.$$.fragment,e),h(mt.$$.fragment,e),h(dt.$$.fragment,e),h(ht.$$.fragment,e),h(gt.$$.fragment,e),h(ct.$$.fragment,e),h(bt.$$.fragment,e),h(wt.$$.fragment,e),h(xt.$$.fragment,e),h(kt.$$.fragment,e),h(jt.$$.fragment,e),h(Mt.$$.fragment,e),h(qt.$$.fragment,e),h(Lt.$$.fragment,e),h(Ut.$$.fragment,e),h(It.$$.fragment,e),h(Gt.$$.fragment,e),h(Wt.$$.fragment,e),h(Xt.$$.fragment,e),h(At.$$.fragment,e),h(St.$$.fragment,e),h(Dt.$$.fragment,e),h(Yt.$$.fragment,e),h(en.$$.fragment,e),h(sn.$$.fragment,e),h(ln.$$.fragment,e),h(on.$$.fragment,e),h(mn.$$.fragment,e),h(fn.$$.fragment,e),h(hn.$$.fragment,e),h(gn.$$.fragment,e),h($n.$$.fragment,e),h(vn.$$.fragment,e),h(Tn.$$.fragment,e),h(kn.$$.fragment,e),h(Cn.$$.fragment,e),h(Mn.$$.fragment,e),h(Hn.$$.fragment,e),h(zn.$$.fragment,e),h(Zn.$$.fragment,e),h(Un.$$.fragment,e),h(In.$$.fragment,e),h(Nn.$$.fragment,e),di=!1},d(e){e&&(n(w),n(b),n(Gn),n(Rn),n(x),n(An),n(Sn),n(En),n(C),n(Dn),n(Qn),n(_),n(Yn),n(M),n(On),n(Kn),n(q),n(es),n(ts),n(L),n(ns),n(z),n(ss),n(as),n(Z),n(ls),n(is),n(F),n(rs),n(os),n(ps),n(J),n(ms),n(ds),n(W),n(fs),n(hs),n(us),n(R),n(gs),n(cs),n($s),n(E),n(bs),n(vs),n(Q),n(ws),n(Ts),n(O),n(xs),n(ks),n(ee),n(ys),n(Cs),n(js),n(se),n(_s),n(ae),n(Ms),n(Ps),n(ie),n(qs),n(re),n(Hs),n(oe),n(Ls),n(zs),n(me),n(Vs),n(Zs),n(Us),n(he),n(Fs),n(Is),n(Ns),n(ce),n(Js),n(Gs),n(Ws),n(Bs),n(we),n(Xs),n(Rs),n(xe),n(As),n(ke),n(Ss),n(ye),n(Es),n(Ds),n(je),n(Qs),n(_e),n(Ys),n(Os),n(Ks),n(qe),n(ea),n(He),n(ta),n(na),n(sa),n(Ve),n(aa),n(la),n(Ue),n(ia),n(ra),n(Ie),n(oa),n(pa),n(Je),n(ma),n(da),n(We),n(fa),n(ha),n(Xe),n(ua),n(ga),n(Ae),n(ca),n($a),n(Ee),n(ba),n(va),n(Qe),n(wa),n(Ye),n(Ta),n(xa),n(Ke),n(ka),n(ya),n(tt),n(Ca),n(ja),n(_a),n(at),n(Ma),n(lt),n(Pa),n(it),n(qa),n(Ha),n(rt),n(La),n(za),n(pt),n(Va),n(Za),n(Ua),n(ft),n(Fa),n(Ia),n(ut),n(Na),n(Ja),n(Ga),n($t),n(Wa),n(Ba),n(vt),n(Xa),n(Ra),n(Tt),n(Aa),n(Sa),n(Ea),n(yt),n(Da),n(Ct),n(Qa),n(Ya),n(_t),n(Oa),n(Ka),n(Pt),n(el),n(tl),n(Ht),n(nl),n(sl),n(zt),n(al),n(Vt),n(ll),n(Zt),n(il),n(rl),n(Ft),n(ol),n(pl),n(Nt),n(ml),n(Jt),n(dl),n(fl),n(hl),n(Bt),n(ul),n(gl),n(Rt),n(cl),n($l),n(bl),n(Et),n(vl),n(wl),n(Qt),n(Tl),n(xl),n(Ot),n(kl),n(Kt),n(yl),n(Cl),n(tn),n(jl),n(nn),n(_l),n(Ml),n(an),n(Pl),n(ql),n(rn),n(Hl),n(Ll),n(pn),n(zl),n(Vl),n(dn),n(Zl),n(Ul),n(Fl),n(un),n(Il),n(Nl),n(cn),n(Jl),n(Gl),n(bn),n(Wl),n(Bl),n(wn),n(Xl),n(Rl),n(xn),n(Al),n(Sl),n(yn),n(El),n(Dl),n(jn),n(Ql),n(_n),n(Yl),n(Ol),n(Pn),n(Kl),n(qn),n(ei),n(ti),n(Ln),n(ni),n(si),n(Vn),n(ai),n(li),n(ii),n(Fn),n(ri),n(oi),n(pi),n(Jn),n(mi),n(Wn)),n(c),u(T,e),u(k,e),u(y,e),u(j,e),u(P,e),u(H,e),u(V,e),u(U,e),u(I,e),u(N,e),u(G,e),u(B,e),u(X,e),u(A,e),u(S,e),u(D,e),u(Y,e),u(K,e),u(te,e),u(ne,e),u(le,e),u(pe,e),u(de,e),u(fe,e),u(ue,e),u(ge,e),u($e,e),u(be,e),u(ve,e),u(Te,e),u(Ce,e),u(Me,e),u(Pe,e),u(Le,e),u(ze,e),u(Ze,e),u(Fe,e),u(Ne,e),u(Ge,e),u(Be,e),u(Re,e),u(Se,e),u(De,e),u(Oe,e),u(et,e),u(nt,e),u(st,e),u(v,e),u(ot,e),u(mt,e),u(dt,e),u(ht,e),u(gt,e),u(ct,e),u(bt,e),u(wt,e),u(xt,e),u(kt,e),u(jt,e),u(Mt,e),u(qt,e),u(Lt,e),u(Ut,e),u(It,e),u(Gt,e),u(Wt,e),u(Xt,e),u(At,e),u(St,e),u(Dt,e),u(Yt,e),u(en,e),u(sn,e),u(ln,e),u(on,e),u(mn,e),u(fn,e),u(hn,e),u(gn,e),u($n,e),u(vn,e),u(Tn,e),u(kn,e),u(Cn,e),u(Mn,e),u(Hn,e),u(zn,e),u(Zn,e),u(Un,e),u(In,e),u(Nn,e)}}}const oo='{"title":"Glossary","local":"glossary","sections":[{"title":"A","local":"a","sections":[{"title":"attention mask","local":"attention-mask","sections":[],"depth":3},{"title":"autoencoding models","local":"autoencoding-models","sections":[],"depth":3},{"title":"autoregressive models","local":"autoregressive-models","sections":[],"depth":3}],"depth":2},{"title":"B","local":"b","sections":[{"title":"backbone","local":"backbone","sections":[],"depth":3}],"depth":2},{"title":"C","local":"c","sections":[{"title":"causal language modeling","local":"causal-language-modeling","sections":[],"depth":3},{"title":"channel","local":"channel","sections":[],"depth":3},{"title":"connectionist temporal classification (CTC)","local":"connectionist-temporal-classification-ctc","sections":[],"depth":3},{"title":"convolution","local":"convolution","sections":[],"depth":3}],"depth":2},{"title":"D","local":"d","sections":[{"title":"DataParallel (DP)","local":"dataparallel-dp","sections":[],"depth":3},{"title":"decoder input IDs","local":"decoder-input-ids","sections":[],"depth":3},{"title":"decoder models","local":"decoder-models","sections":[],"depth":3},{"title":"deep learning (DL)","local":"deep-learning-dl","sections":[],"depth":3}],"depth":2},{"title":"E","local":"e","sections":[{"title":"encoder models","local":"encoder-models","sections":[],"depth":3}],"depth":2},{"title":"F","local":"f","sections":[{"title":"feature extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"feed forward chunking","local":"feed-forward-chunking","sections":[],"depth":3},{"title":"finetuned models","local":"finetuned-models","sections":[],"depth":3}],"depth":2},{"title":"H","local":"h","sections":[{"title":"head","local":"head","sections":[],"depth":3}],"depth":2},{"title":"I","local":"i","sections":[{"title":"image patch","local":"image-patch","sections":[],"depth":3},{"title":"inference","local":"inference","sections":[],"depth":3},{"title":"input IDs","local":"input-ids","sections":[],"depth":3}],"depth":2},{"title":"L","local":"l","sections":[{"title":"labels","local":"labels","sections":[],"depth":3},{"title":"large language models (LLM)","local":"large-language-models-llm","sections":[],"depth":3}],"depth":2},{"title":"M","local":"m","sections":[{"title":"masked language modeling (MLM)","local":"masked-language-modeling-mlm","sections":[],"depth":3},{"title":"multimodal","local":"multimodal","sections":[],"depth":3}],"depth":2},{"title":"N","local":"n","sections":[{"title":"Natural language generation (NLG)","local":"natural-language-generation-nlg","sections":[],"depth":3},{"title":"Natural language processing (NLP)","local":"natural-language-processing-nlp","sections":[],"depth":3},{"title":"Natural language understanding (NLU)","local":"natural-language-understanding-nlu","sections":[],"depth":3}],"depth":2},{"title":"P","local":"p","sections":[{"title":"pipeline","local":"pipeline","sections":[],"depth":3},{"title":"PipelineParallel (PP)","local":"pipelineparallel-pp","sections":[],"depth":3},{"title":"pixel values","local":"pixel-values","sections":[],"depth":3},{"title":"pooling","local":"pooling","sections":[],"depth":3},{"title":"position IDs","local":"position-ids","sections":[],"depth":3},{"title":"preprocessing","local":"preprocessing","sections":[],"depth":3},{"title":"pretrained model","local":"pretrained-model","sections":[],"depth":3}],"depth":2},{"title":"R","local":"r","sections":[{"title":"recurrent neural network (RNN)","local":"recurrent-neural-network-rnn","sections":[],"depth":3},{"title":"representation learning","local":"representation-learning","sections":[],"depth":3}],"depth":2},{"title":"S","local":"s","sections":[{"title":"sampling rate","local":"sampling-rate","sections":[],"depth":3},{"title":"self-attention","local":"self-attention","sections":[],"depth":3},{"title":"self-supervised learning","local":"self-supervised-learning","sections":[],"depth":3},{"title":"semi-supervised learning","local":"semi-supervised-learning","sections":[],"depth":3},{"title":"sequence-to-sequence (seq2seq)","local":"sequence-to-sequence-seq2seq","sections":[],"depth":3},{"title":"Sharded DDP","local":"sharded-ddp","sections":[],"depth":3},{"title":"stride","local":"stride","sections":[],"depth":3},{"title":"supervised learning","local":"supervised-learning","sections":[],"depth":3}],"depth":2},{"title":"T","local":"t","sections":[{"title":"Tensor Parallelism (TP)","local":"tensor-parallelism-tp","sections":[],"depth":3},{"title":"token","local":"token","sections":[],"depth":3},{"title":"token Type IDs","local":"token-type-ids","sections":[],"depth":3},{"title":"transfer learning","local":"transfer-learning","sections":[],"depth":3},{"title":"transformer","local":"transformer","sections":[],"depth":3}],"depth":2},{"title":"U","local":"u","sections":[{"title":"unsupervised learning","local":"unsupervised-learning","sections":[],"depth":3}],"depth":2},{"title":"Z","local":"z","sections":[{"title":"Zero Redundancy Optimizer (ZeRO)","local":"zero-redundancy-optimizer-zero","sections":[],"depth":3}],"depth":2}],"depth":1}';function po(Xn){return Kr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $o extends to{constructor(c){super(),no(this,c,po,ro,Or,{})}}export{$o as component};
