import{s as Ke,o as Oe,n as et}from"../chunks/scheduler.182ea377.js";import{S as tt,i as st,g as n,s as i,p as f,A as lt,h as a,f as s,c as r,j as g,q as m,m as c,k as d,v as u,a as l,r as y,d as w,t as M,u as b}from"../chunks/index.008d68e4.js";import{T as nt}from"../chunks/Tip.4f096367.js";import{I as ke}from"../chunks/IconCopyLink.96bbb92b.js";import{C as K}from"../chunks/CodeBlock.5ed6eb7b.js";function at(se){let o,j='To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.';return{c(){o=n("p"),o.innerHTML=j},l(p){o=a(p,"P",{"data-svelte-h":!0}),c(o)!=="svelte-c8rg1s"&&(o.innerHTML=j)},m(p,h){l(p,o,h)},p:et,d(p){p&&s(o)}}}function it(se){let o,j,p,h,O,$,$e,Q,Ge="Distributed inference with multiple GPUs",le,C,Ie='On distributed setups, you can run inference across multiple GPUs with 🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> or <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a>, which is useful for generating with multiple prompts in parallel.',ne,Z,Ee="This guide will show you how to use 🤗 Accelerate and PyTorch Distributed for distributed inference.",ae,J,v,ee,k,Ce,F,He="🤗 Accelerate",ie,G,Pe='🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> is a library designed to make it easy to train or run inference across distributed setups. It simplifies the process of setting up the distributed environment, allowing you to focus on your PyTorch code.',re,I,xe='To begin, create a Python file and initialize an <a href="https://huggingface.co/docs/accelerate/v0.25.0/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> to create a distributed environment; your setup is automatically detected so you don’t need to explicitly define the <code>rank</code> or <code>world_size</code>. Move the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>distributed_state.device</code> to assign a GPU to each process.',oe,E,We='Now use the <a href="https://huggingface.co/docs/accelerate/v0.25.0/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',ce,H,pe,P,ze="Use the <code>--num_processes</code> argument to specify the number of GPUs to use, and call <code>accelerate launch</code> to run the script:",de,x,ue,U,he,T,_,te,W,Ze,q,Ne="PyTorch Distributed",fe,z,Se='PyTorch supports <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow"><code>DistributedDataParallel</code></a> which enables data parallelism.',me,N,Re='To start, create a Python file and import <code>torch.distributed</code> and <code>torch.multiprocessing</code> to set up the distributed process group and to spawn the processes for inference on each GPU. You should also initialize a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',ye,S,we,R,Ae='You’ll want to create a function to run inference; <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow"><code>init_process_group</code></a> handles creating a distributed environment with the type of backend to use, the <code>rank</code> of the current process, and the <code>world_size</code> or the number of processes participating. If you’re running inference in parallel over 2 GPUs, then the <code>world_size</code> is 2.',Me,A,Be='Move the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process, where each process handles a different prompt:',be,B,Je,X,Xe='To run the distributed inference, call <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow"><code>mp.spawn</code></a> to run the <code>run_inference</code> function on the number of GPUs defined in <code>world_size</code>:',Te,V,ge,Y,Ve="Once you’ve completed the inference script, use the <code>--nproc_per_node</code> argument to specify the number of GPUs to use and call <code>torchrun</code> to run the script:",ve,L,Ue;return $=new ke({}),k=new ke({}),H=new K({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFkaXN0cmlidXRlZF9zdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBcGlwZWxpbmUudG8oZGlzdHJpYnV0ZWRfc3RhdGUuZGV2aWNlKSUwQSUwQXdpdGglMjBkaXN0cmlidXRlZF9zdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiU1RCklMjBhcyUyMHByb21wdCUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdC5zYXZlKGYlMjJyZXN1bHRfJTdCZGlzdHJpYnV0ZWRfc3RhdGUucHJvY2Vzc19pbmRleCU3RC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)

<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`}}),x=new K({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2"}}),U=new nt({props:{$$slots:{default:[at]},$$scope:{ctx:se}}}),W=new ke({}),S=new K({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzZCUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

sd = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`}}),B=new K({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBzZC50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    sd.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`}}),V=new K({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`}}),L=new K({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2"}}),{c(){o=n("meta"),j=i(),p=n("h1"),h=n("a"),O=n("span"),f($.$$.fragment),$e=i(),Q=n("span"),Q.textContent=Ge,le=i(),C=n("p"),C.innerHTML=Ie,ne=i(),Z=n("p"),Z.textContent=Ee,ae=i(),J=n("h2"),v=n("a"),ee=n("span"),f(k.$$.fragment),Ce=i(),F=n("span"),F.textContent=He,ie=i(),G=n("p"),G.innerHTML=Pe,re=i(),I=n("p"),I.innerHTML=xe,oe=i(),E=n("p"),E.innerHTML=We,ce=i(),f(H.$$.fragment),pe=i(),P=n("p"),P.innerHTML=ze,de=i(),f(x.$$.fragment),ue=i(),f(U.$$.fragment),he=i(),T=n("h2"),_=n("a"),te=n("span"),f(W.$$.fragment),Ze=i(),q=n("span"),q.textContent=Ne,fe=i(),z=n("p"),z.innerHTML=Se,me=i(),N=n("p"),N.innerHTML=Re,ye=i(),f(S.$$.fragment),we=i(),R=n("p"),R.innerHTML=Ae,Me=i(),A=n("p"),A.innerHTML=Be,be=i(),f(B.$$.fragment),Je=i(),X=n("p"),X.innerHTML=Xe,Te=i(),f(V.$$.fragment),ge=i(),Y=n("p"),Y.innerHTML=Ve,ve=i(),f(L.$$.fragment),this.h()},l(e){const t=lt("svelte-1phssyn",document.head);o=a(t,"META",{name:!0,content:!0}),t.forEach(s),j=r(e),p=a(e,"H1",{class:!0});var D=g(p);h=a(D,"A",{id:!0,class:!0,href:!0});var Ye=g(h);O=a(Ye,"SPAN",{});var Le=g(O);m($.$$.fragment,Le),Le.forEach(s),Ye.forEach(s),$e=r(D),Q=a(D,"SPAN",{"data-svelte-h":!0}),c(Q)!=="svelte-11c9v6"&&(Q.textContent=Ge),D.forEach(s),le=r(e),C=a(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-a7bv7i"&&(C.innerHTML=Ie),ne=r(e),Z=a(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1qu3csy"&&(Z.textContent=Ee),ae=r(e),J=a(e,"H2",{class:!0});var _e=g(J);v=a(_e,"A",{id:!0,class:!0,href:!0});var De=g(v);ee=a(De,"SPAN",{});var Qe=g(ee);m(k.$$.fragment,Qe),Qe.forEach(s),De.forEach(s),Ce=r(_e),F=a(_e,"SPAN",{"data-svelte-h":!0}),c(F)!=="svelte-ns7zer"&&(F.textContent=He),_e.forEach(s),ie=r(e),G=a(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-13uq1g2"&&(G.innerHTML=Pe),re=r(e),I=a(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1nobwhy"&&(I.innerHTML=xe),oe=r(e),E=a(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-198f1dx"&&(E.innerHTML=We),ce=r(e),m(H.$$.fragment,e),pe=r(e),P=a(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1ohh8as"&&(P.innerHTML=ze),de=r(e),m(x.$$.fragment,e),ue=r(e),m(U.$$.fragment,e),he=r(e),T=a(e,"H2",{class:!0});var je=g(T);_=a(je,"A",{id:!0,class:!0,href:!0});var Fe=g(_);te=a(Fe,"SPAN",{});var qe=g(te);m(W.$$.fragment,qe),qe.forEach(s),Fe.forEach(s),Ze=r(je),q=a(je,"SPAN",{"data-svelte-h":!0}),c(q)!=="svelte-192505x"&&(q.textContent=Ne),je.forEach(s),fe=r(e),z=a(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-jtiddl"&&(z.innerHTML=Se),me=r(e),N=a(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-2sodfx"&&(N.innerHTML=Re),ye=r(e),m(S.$$.fragment,e),we=r(e),R=a(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-qkdvuf"&&(R.innerHTML=Ae),Me=r(e),A=a(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1ghswyg"&&(A.innerHTML=Be),be=r(e),m(B.$$.fragment,e),Je=r(e),X=a(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1ecd3vq"&&(X.innerHTML=Xe),Te=r(e),m(V.$$.fragment,e),ge=r(e),Y=a(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-ykaora"&&(Y.innerHTML=Ve),ve=r(e),m(L.$$.fragment,e),this.h()},h(){d(o,"name","hf:doc:metadata"),d(o,"content",JSON.stringify(rt)),d(h,"id","distributed-inference-with-multiple-gpus"),d(h,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(h,"href","#distributed-inference-with-multiple-gpus"),d(p,"class","relative group"),d(v,"id","accelerate"),d(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(v,"href","#accelerate"),d(J,"class","relative group"),d(_,"id","pytorch-distributed"),d(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(_,"href","#pytorch-distributed"),d(T,"class","relative group")},m(e,t){u(document.head,o),l(e,j,t),l(e,p,t),u(p,h),u(h,O),y($,O,null),u(p,$e),u(p,Q),l(e,le,t),l(e,C,t),l(e,ne,t),l(e,Z,t),l(e,ae,t),l(e,J,t),u(J,v),u(v,ee),y(k,ee,null),u(J,Ce),u(J,F),l(e,ie,t),l(e,G,t),l(e,re,t),l(e,I,t),l(e,oe,t),l(e,E,t),l(e,ce,t),y(H,e,t),l(e,pe,t),l(e,P,t),l(e,de,t),y(x,e,t),l(e,ue,t),y(U,e,t),l(e,he,t),l(e,T,t),u(T,_),u(_,te),y(W,te,null),u(T,Ze),u(T,q),l(e,fe,t),l(e,z,t),l(e,me,t),l(e,N,t),l(e,ye,t),y(S,e,t),l(e,we,t),l(e,R,t),l(e,Me,t),l(e,A,t),l(e,be,t),y(B,e,t),l(e,Je,t),l(e,X,t),l(e,Te,t),y(V,e,t),l(e,ge,t),l(e,Y,t),l(e,ve,t),y(L,e,t),Ue=!0},p(e,[t]){const D={};t&2&&(D.$$scope={dirty:t,ctx:e}),U.$set(D)},i(e){Ue||(w($.$$.fragment,e),w(k.$$.fragment,e),w(H.$$.fragment,e),w(x.$$.fragment,e),w(U.$$.fragment,e),w(W.$$.fragment,e),w(S.$$.fragment,e),w(B.$$.fragment,e),w(V.$$.fragment,e),w(L.$$.fragment,e),Ue=!0)},o(e){M($.$$.fragment,e),M(k.$$.fragment,e),M(H.$$.fragment,e),M(x.$$.fragment,e),M(U.$$.fragment,e),M(W.$$.fragment,e),M(S.$$.fragment,e),M(B.$$.fragment,e),M(V.$$.fragment,e),M(L.$$.fragment,e),Ue=!1},d(e){e&&(s(j),s(p),s(le),s(C),s(ne),s(Z),s(ae),s(J),s(ie),s(G),s(re),s(I),s(oe),s(E),s(ce),s(pe),s(P),s(de),s(ue),s(he),s(T),s(fe),s(z),s(me),s(N),s(ye),s(we),s(R),s(Me),s(A),s(be),s(Je),s(X),s(Te),s(ge),s(Y),s(ve)),s(o),b($),b(k),b(H,e),b(x,e),b(U,e),b(W),b(S,e),b(B,e),b(V,e),b(L,e)}}}const rt={local:"distributed-inference-with-multiple-gpus",sections:[{local:"accelerate",title:"🤗 Accelerate"},{local:"pytorch-distributed",title:"PyTorch Distributed"}],title:"Distributed inference with multiple GPUs"};function ot(se){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends tt{constructor(o){super(),st(this,o,ot,it,Ke,{})}}export{ft as component};
