import{s as At,o as Kt,n as Dt}from"../chunks/scheduler.c57aa7ef.js";import{S as Ot,i as ea,g as o,s as l,r as p,A as ta,h as r,f as a,c as n,j as Nt,u as d,x as i,k as qt,y as aa,a as s,v as m,d as f,t as c,w as h}from"../chunks/index.c50cb18e.js";import{T as sa}from"../chunks/Tip.9268b0ca.js";import{C as y}from"../chunks/CodeBlock.34f0a53d.js";import{H as M,E as la}from"../chunks/EditOnGithub.958a8a49.js";function na(we){let u,_='Starting from PEFT verion v0.11.0, PEFT automatically promotes the dtype of adapter weights from <code>torch.float16</code> and <code>torch.bfloat16</code> to <code>torch.float32</code> where appropriate. To <em>prevent</em> this behavior, you can pass <code>autocast_adapter_dtype=False</code> to <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>, to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>, and to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.';return{c(){u=o("p"),u.innerHTML=_},l(g){u=r(g,"P",{"data-svelte-h":!0}),i(u)!=="svelte-1oj6850"&&(u.innerHTML=_)},m(g,ye){s(g,u,ye)},p:Dt,d(g){g&&a(u)}}}function oa(we){let u,_,g,ye,b,_e,T,Mt="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",be,j,Te,x,wt="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",je,$,_t="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",xe,v,bt="In general, you can update the package version by running this command inside your Python environment:",$e,J,ve,Z,Tt="Installing PEFT from source is useful for keeping up with the latest developments:",Je,k,Ze,U,ke,C,jt='This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',Ue,W,Ce,B,xt='Alternatively, you can use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',We,G,Be,w,Ge,F,Fe,R,$t='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',Re,I,vt="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",Ie,H,He,X,Jt="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",Xe,V,Zt='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',Ve,L,Le,P,kt='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',Pe,Y,Ye,E,Ee,z,Ut="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",ze,S,Ct="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",Se,Q,Wt="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",Qe,N,Bt="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",Ne,q,qe,A,Gt="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",Ae,K,Ke,D,Ft="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and also storing the embedding layer in addition to the adapter weights when saving the adapter.",De,O,Rt="Save the embedding layer by adding it to the <code>target_modules</code> of the config. The embedding layer name must follow the standard naming scheme from Transformers. For example, the Mistral config could look like this:",Oe,ee,et,te,It='Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_input_embeddings" rel="nofollow">get_input_embeddings</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_output_embeddings" rel="nofollow">get_output_embeddings</a>. This is generally the case for Transformers models.',tt,ae,Ht="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",at,se,st,le,Xt="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",lt,ne,Vt='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',nt,oe,ot,re,Lt='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',rt,ie,Pt='The <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',it,pe,pt,de,Yt="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",dt,me,Et="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",mt,fe,zt="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",ft,ce,ct,he,St='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',ht,ue,ut,ge,gt,Me,yt;return b=new M({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),j=new M({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),J=new y({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),k=new y({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),U=new M({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h2"}}),W=new y({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),w=new sa({props:{$$slots:{default:[na]},$$scope:{ctx:we}}}),F=new M({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),H=new M({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),L=new M({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),Y=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),E=new M({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),q=new y({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),K=new M({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),ee=new y({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),se=new y({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_pretrained(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),oe=new M({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),pe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),ce=new y({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),ue=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFnZXRfbGF5ZXJfc3RhdHVzKHBpcGUudGV4dF9lbmNvZGVyKSUwQSUwQWdldF9tb2RlbF9zdGF0dXMocGlwZS51bmV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
)`,wrap:!1}}),ge=new la({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){u=o("meta"),_=l(),g=o("p"),ye=l(),p(b.$$.fragment),_e=l(),T=o("p"),T.textContent=Mt,be=l(),p(j.$$.fragment),Te=l(),x=o("p"),x.textContent=wt,je=l(),$=o("ul"),$.innerHTML=_t,xe=l(),v=o("p"),v.textContent=bt,$e=l(),p(J.$$.fragment),ve=l(),Z=o("p"),Z.textContent=Tt,Je=l(),p(k.$$.fragment),Ze=l(),p(U.$$.fragment),ke=l(),C=o("p"),C.innerHTML=jt,Ue=l(),p(W.$$.fragment),Ce=l(),B=o("p"),B.innerHTML=xt,We=l(),p(G.$$.fragment),Be=l(),p(w.$$.fragment),Ge=l(),p(F.$$.fragment),Fe=l(),R=o("p"),R.innerHTML=$t,Re=l(),I=o("p"),I.textContent=vt,Ie=l(),p(H.$$.fragment),He=l(),X=o("p"),X.textContent=Jt,Xe=l(),V=o("ol"),V.innerHTML=Zt,Ve=l(),p(L.$$.fragment),Le=l(),P=o("p"),P.innerHTML=kt,Pe=l(),p(Y.$$.fragment),Ye=l(),p(E.$$.fragment),Ee=l(),z=o("p"),z.innerHTML=Ut,ze=l(),S=o("p"),S.innerHTML=Ct,Se=l(),Q=o("p"),Q.innerHTML=Wt,Qe=l(),N=o("p"),N.textContent=Bt,Ne=l(),p(q.$$.fragment),qe=l(),A=o("p"),A.innerHTML=Gt,Ae=l(),p(K.$$.fragment),Ke=l(),D=o("p"),D.textContent=Ft,De=l(),O=o("p"),O.innerHTML=Rt,Oe=l(),p(ee.$$.fragment),et=l(),te=o("p"),te.innerHTML=It,tt=l(),ae=o("p"),ae.innerHTML=Ht,at=l(),p(se.$$.fragment),st=l(),le=o("p"),le.textContent=Xt,lt=l(),ne=o("p"),ne.innerHTML=Vt,nt=l(),p(oe.$$.fragment),ot=l(),re=o("p"),re.innerHTML=Lt,rt=l(),ie=o("p"),ie.innerHTML=Pt,it=l(),p(pe.$$.fragment),pt=l(),de=o("p"),de.innerHTML=Yt,dt=l(),me=o("p"),me.textContent=Et,mt=l(),fe=o("p"),fe.innerHTML=zt,ft=l(),p(ce.$$.fragment),ct=l(),he=o("p"),he.innerHTML=St,ht=l(),p(ue.$$.fragment),ut=l(),p(ge.$$.fragment),gt=l(),Me=o("p"),this.h()},l(e){const t=ta("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(a),_=n(e),g=r(e,"P",{}),Nt(g).forEach(a),ye=n(e),d(b.$$.fragment,e),_e=n(e),T=r(e,"P",{"data-svelte-h":!0}),i(T)!=="svelte-wwms7a"&&(T.textContent=Mt),be=n(e),d(j.$$.fragment,e),Te=n(e),x=r(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-18nlz3r"&&(x.textContent=wt),je=n(e),$=r(e,"UL",{"data-svelte-h":!0}),i($)!=="svelte-ccv654"&&($.innerHTML=_t),xe=n(e),v=r(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1cuqjyb"&&(v.textContent=bt),$e=n(e),d(J.$$.fragment,e),ve=n(e),Z=r(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-h5ykrw"&&(Z.textContent=Tt),Je=n(e),d(k.$$.fragment,e),Ze=n(e),d(U.$$.fragment,e),ke=n(e),C=r(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-oa0e54"&&(C.innerHTML=jt),Ue=n(e),d(W.$$.fragment,e),Ce=n(e),B=r(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-p7trz1"&&(B.innerHTML=xt),We=n(e),d(G.$$.fragment,e),Be=n(e),d(w.$$.fragment,e),Ge=n(e),d(F.$$.fragment,e),Fe=n(e),R=r(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-ns8zue"&&(R.innerHTML=$t),Re=n(e),I=r(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-lfc2ft"&&(I.textContent=vt),Ie=n(e),d(H.$$.fragment,e),He=n(e),X=r(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-16feh"&&(X.textContent=Jt),Xe=n(e),V=r(e,"OL",{"data-svelte-h":!0}),i(V)!=="svelte-1fvhlks"&&(V.innerHTML=Zt),Ve=n(e),d(L.$$.fragment,e),Le=n(e),P=r(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-q1qqrd"&&(P.innerHTML=kt),Pe=n(e),d(Y.$$.fragment,e),Ye=n(e),d(E.$$.fragment,e),Ee=n(e),z=r(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-5heszj"&&(z.innerHTML=Ut),ze=n(e),S=r(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-c4824l"&&(S.innerHTML=Ct),Se=n(e),Q=r(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1ou3c35"&&(Q.innerHTML=Wt),Qe=n(e),N=r(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1g4txs2"&&(N.textContent=Bt),Ne=n(e),d(q.$$.fragment,e),qe=n(e),A=r(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1fbeum6"&&(A.innerHTML=Gt),Ae=n(e),d(K.$$.fragment,e),Ke=n(e),D=r(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-15igmai"&&(D.textContent=Ft),De=n(e),O=r(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1cgzlph"&&(O.innerHTML=Rt),Oe=n(e),d(ee.$$.fragment,e),et=n(e),te=r(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-kwgcwv"&&(te.innerHTML=It),tt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-ucua6z"&&(ae.innerHTML=Ht),at=n(e),d(se.$$.fragment,e),st=n(e),le=r(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-nkv7o7"&&(le.textContent=Xt),lt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-a0ibfa"&&(ne.innerHTML=Vt),nt=n(e),d(oe.$$.fragment,e),ot=n(e),re=r(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1f0hxdh"&&(re.innerHTML=Lt),rt=n(e),ie=r(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1ygf8mz"&&(ie.innerHTML=Pt),it=n(e),d(pe.$$.fragment,e),pt=n(e),de=r(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1gb1r7d"&&(de.innerHTML=Yt),dt=n(e),me=r(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-19sfzdf"&&(me.textContent=Et),mt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-18r4lni"&&(fe.innerHTML=zt),ft=n(e),d(ce.$$.fragment,e),ct=n(e),he=r(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-17rnlhh"&&(he.innerHTML=St),ht=n(e),d(ue.$$.fragment,e),ut=n(e),d(ge.$$.fragment,e),gt=n(e),Me=r(e,"P",{}),Nt(Me).forEach(a),this.h()},h(){qt(u,"name","hf:doc:metadata"),qt(u,"content",ra)},m(e,t){aa(document.head,u),s(e,_,t),s(e,g,t),s(e,ye,t),m(b,e,t),s(e,_e,t),s(e,T,t),s(e,be,t),m(j,e,t),s(e,Te,t),s(e,x,t),s(e,je,t),s(e,$,t),s(e,xe,t),s(e,v,t),s(e,$e,t),m(J,e,t),s(e,ve,t),s(e,Z,t),s(e,Je,t),m(k,e,t),s(e,Ze,t),m(U,e,t),s(e,ke,t),s(e,C,t),s(e,Ue,t),m(W,e,t),s(e,Ce,t),s(e,B,t),s(e,We,t),m(G,e,t),s(e,Be,t),m(w,e,t),s(e,Ge,t),m(F,e,t),s(e,Fe,t),s(e,R,t),s(e,Re,t),s(e,I,t),s(e,Ie,t),m(H,e,t),s(e,He,t),s(e,X,t),s(e,Xe,t),s(e,V,t),s(e,Ve,t),m(L,e,t),s(e,Le,t),s(e,P,t),s(e,Pe,t),m(Y,e,t),s(e,Ye,t),m(E,e,t),s(e,Ee,t),s(e,z,t),s(e,ze,t),s(e,S,t),s(e,Se,t),s(e,Q,t),s(e,Qe,t),s(e,N,t),s(e,Ne,t),m(q,e,t),s(e,qe,t),s(e,A,t),s(e,Ae,t),m(K,e,t),s(e,Ke,t),s(e,D,t),s(e,De,t),s(e,O,t),s(e,Oe,t),m(ee,e,t),s(e,et,t),s(e,te,t),s(e,tt,t),s(e,ae,t),s(e,at,t),m(se,e,t),s(e,st,t),s(e,le,t),s(e,lt,t),s(e,ne,t),s(e,nt,t),m(oe,e,t),s(e,ot,t),s(e,re,t),s(e,rt,t),s(e,ie,t),s(e,it,t),m(pe,e,t),s(e,pt,t),s(e,de,t),s(e,dt,t),s(e,me,t),s(e,mt,t),s(e,fe,t),s(e,ft,t),m(ce,e,t),s(e,ct,t),s(e,he,t),s(e,ht,t),m(ue,e,t),s(e,ut,t),m(ge,e,t),s(e,gt,t),s(e,Me,t),yt=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),w.$set(Qt)},i(e){yt||(f(b.$$.fragment,e),f(j.$$.fragment,e),f(J.$$.fragment,e),f(k.$$.fragment,e),f(U.$$.fragment,e),f(W.$$.fragment,e),f(G.$$.fragment,e),f(w.$$.fragment,e),f(F.$$.fragment,e),f(H.$$.fragment,e),f(L.$$.fragment,e),f(Y.$$.fragment,e),f(E.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(ce.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),yt=!0)},o(e){c(b.$$.fragment,e),c(j.$$.fragment,e),c(J.$$.fragment,e),c(k.$$.fragment,e),c(U.$$.fragment,e),c(W.$$.fragment,e),c(G.$$.fragment,e),c(w.$$.fragment,e),c(F.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(Y.$$.fragment,e),c(E.$$.fragment,e),c(q.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(ge.$$.fragment,e),yt=!1},d(e){e&&(a(_),a(g),a(ye),a(_e),a(T),a(be),a(Te),a(x),a(je),a($),a(xe),a(v),a($e),a(ve),a(Z),a(Je),a(Ze),a(ke),a(C),a(Ue),a(Ce),a(B),a(We),a(Be),a(Ge),a(Fe),a(R),a(Re),a(I),a(Ie),a(He),a(X),a(Xe),a(V),a(Ve),a(Le),a(P),a(Pe),a(Ye),a(Ee),a(z),a(ze),a(S),a(Se),a(Q),a(Qe),a(N),a(Ne),a(qe),a(A),a(Ae),a(Ke),a(D),a(De),a(O),a(Oe),a(et),a(te),a(tt),a(ae),a(at),a(st),a(le),a(lt),a(ne),a(nt),a(ot),a(re),a(rt),a(ie),a(it),a(pt),a(de),a(dt),a(me),a(mt),a(fe),a(ft),a(ct),a(he),a(ht),a(ut),a(gt),a(Me)),a(u),h(b,e),h(j,e),h(J,e),h(k,e),h(U,e),h(W,e),h(G,e),h(w,e),h(F,e),h(H,e),h(L,e),h(Y,e),h(E,e),h(q,e),h(K,e),h(ee,e),h(se,e),h(oe,e),h(pe,e),h(ce,e),h(ue,e),h(ge,e)}}}const ra='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2}],"depth":1}';function ia(we){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ha extends Ot{constructor(u){super(),ea(this,u,ia,oa,At,{})}}export{ha as component};
