import{s as hs,o as _s,n as B}from"../chunks/scheduler.182ea377.js";import{S as bs,i as vs,g as a,s as l,p as u,x as Is,A as ws,h as o,f as i,c as r,j as w,q as h,m,y as ys,k as f,v as t,a as g,r as _,d as b,t as v,u as I}from"../chunks/index.008d68e4.js";import{T as on}from"../chunks/Tip.4f096367.js";import{D as J}from"../chunks/Docstring.7aec8b85.js";import{C as Q}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as gt}from"../chunks/IconCopyLink.96bbb92b.js";import{E as sn}from"../chunks/ExampleCodeBlock.23e54afe.js";function xs(C){let n,y='For text-to-image we use <code>stabilityai/stable-diffusion-2-1-unclip-small</code> as it was trained on CLIP ViT-L/14 embedding, the same as the Karlo model prior. <a href="https://hf.co/stabilityai/stable-diffusion-2-1-unclip" rel="nofollow">stabilityai/stable-diffusion-2-1-unclip</a> was trained on OpenCLIP ViT-H, so we don’t recommend its use.';return{c(){n=a("p"),n.innerHTML=y},l(p){n=o(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-ascgy4"&&(n.innerHTML=y)},m(p,d){g(p,n,d)},p:B,d(p){p&&i(n)}}}function $s(C){let n,y='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){n=a("p"),n.innerHTML=y},l(p){n=o(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1wmc0l4"&&(n.innerHTML=y)},m(p,d){g(p,n,d)},p:B,d(p){p&&i(n)}}}function Ps(C){let n,y="Examples:",p,d,x;return d=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZ1c2luZyUyRnN0YWJsZS11bmNsaXAtMi0xLWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTIwJTIwJTIzJTIwVE9ETyUyMHVwZGF0ZSUyMG1vZGVsJTIwcGF0aCUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2hvcnNlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_horse.png&quot;</span>)`}}),{c(){n=a("p"),n.textContent=y,p=l(),u(d.$$.fragment)},l(s){n=o(s,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=y),p=r(s),h(d.$$.fragment,s)},m(s,T){g(s,n,T),g(s,p,T),_(d,s,T),x=!0},p:B,i(s){x||(b(d.$$.fragment,s),x=!0)},o(s){v(d.$$.fragment,s),x=!1},d(s){s&&(i(n),i(p)),I(d,s)}}}function Ms(C){let n,y=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=a("p"),n.innerHTML=y},l(p){n=o(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-ackzsn"&&(n.innerHTML=y)},m(p,d){g(p,n,d)},p:B,d(p){p&&i(n)}}}function Us(C){let n,y="Examples:",p,d,x;return d=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){n=a("p"),n.textContent=y,p=l(),u(d.$$.fragment)},l(s){n=o(s,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=y),p=r(s),h(d.$$.fragment,s)},m(s,T){g(s,n,T),g(s,p,T),_(d,s,T),x=!0},p:B,i(s){x||(b(d.$$.fragment,s),x=!0)},o(s){v(d.$$.fragment,s),x=!1},d(s){s&&(i(n),i(p)),I(d,s)}}}function Ts(C){let n,y=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=a("p"),n.textContent=y},l(p){n=o(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-17p1lpg"&&(n.textContent=y)},m(p,d){g(p,n,d)},p:B,d(p){p&&i(n)}}}function Cs(C){let n,y="Examples:",p,d,x;return d=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){n=a("p"),n.textContent=y,p=l(),u(d.$$.fragment)},l(s){n=o(s,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=y),p=r(s),h(d.$$.fragment,s)},m(s,T){g(s,n,T),g(s,p,T),_(d,s,T),x=!0},p:B,i(s){x||(b(d.$$.fragment,s),x=!0)},o(s){v(d.$$.fragment,s),x=!1},d(s){s&&(i(n),i(p)),I(d,s)}}}function Js(C){let n,y="Examples:",p,d,x;return d=new Q({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZnVzaW5nJTJGc3RhYmxlLXVuY2xpcC0yLTEtbC1pbWcyaW1nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUyMCUyMCUyMyUyMFRPRE8lMjB1cGRhdGUlMjBtb2RlbCUyMHBhdGglMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNzY4JTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyQyUyMHRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBpbml0X2ltYWdlKS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyZmFudGFzeV9sYW5kc2NhcGUucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l-img2img&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt, init_image).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`}}),{c(){n=a("p"),n.textContent=y,p=l(),u(d.$$.fragment)},l(s){n=o(s,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=y),p=r(s),h(d.$$.fragment,s)},m(s,T){g(s,n,T),g(s,p,T),_(d,s,T),x=!0},p:B,i(s){x||(b(d.$$.fragment,s),x=!0)},o(s){v(d.$$.fragment,s),x=!1},d(s){s&&(i(n),i(p)),I(d,s)}}}function Ls(C){let n,y=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=a("p"),n.innerHTML=y},l(p){n=o(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-ackzsn"&&(n.innerHTML=y)},m(p,d){g(p,n,d)},p:B,d(p){p&&i(n)}}}function js(C){let n,y="Examples:",p,d,x;return d=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){n=a("p"),n.textContent=y,p=l(),u(d.$$.fragment)},l(s){n=o(s,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=y),p=r(s),h(d.$$.fragment,s)},m(s,T){g(s,n,T),g(s,p,T),_(d,s,T),x=!0},p:B,i(s){x||(b(d.$$.fragment,s),x=!0)},o(s){v(d.$$.fragment,s),x=!1},d(s){s&&(i(n),i(p)),I(d,s)}}}function ks(C){let n,y=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=a("p"),n.textContent=y},l(p){n=o(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-17p1lpg"&&(n.textContent=y)},m(p,d){g(p,n,d)},p:B,d(p){p&&i(n)}}}function Ss(C){let n,y="Examples:",p,d,x;return d=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){n=a("p"),n.textContent=y,p=l(),u(d.$$.fragment)},l(s){n=o(s,"P",{"data-svelte-h":!0}),m(n)!=="svelte-kvfsh7"&&(n.textContent=y),p=r(s),h(d.$$.fragment,s)},m(s,T){g(s,n,T),g(s,p,T),_(d,s,T),x=!0},p:B,i(s){x||(b(d.$$.fragment,s),x=!0)},o(s){v(d.$$.fragment,s),x=!1},d(s){s&&(i(n),i(p)),I(d,s)}}}function Zs(C){let n,y,p,d,x,s,T,ft,_o="Stable unCLIP",wn,Te,bo=`Stable unCLIP checkpoints are finetuned from <a href="./stable_diffusion/stable_diffusion_2">Stable Diffusion 2.1</a> checkpoints to condition on CLIP image embeddings.
Stable unCLIP still conditions on text embeddings. Given the two separate conditionings, stable unCLIP can be used
for text guided image variation. When combined with an unCLIP prior, it can also be used for full text to image generation.`,yn,Ce,vo="The abstract from the paper is:",xn,Je,Io="<em>Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.</em>",$n,X,D,ln,Le,ta,ut,wo="Tips",Pn,je,yo="Stable unCLIP takes  <code>noise_level</code> as input during inference which determines how much noise is added to the image embeddings. A higher <code>noise_level</code> increases variation in the final un-noised images. By default, we do not add any additional noise to the image embeddings (<code>noise_level = 0</code>).",Mn,F,q,rn,ke,na,ht,xo="Text-to-Image Generation",Un,Se,Tn,O,Cn,z,K,pn,Ze,aa,_t,$o="Text guided Image-to-Image Variation",Jn,We,Ln,Ge,Po="Optionally, you can also pass a prompt to <code>pipe</code> such as:",jn,Ee,kn,ee,Sn,R,te,dn,Be,oa,bt,Mo="StableUnCLIPPipeline",Zn,$,Ne,sa,vt,Uo="Pipeline for text-to-image generation using stable unCLIP.",ia,It,To=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,la,wt,Co="The pipeline also inherits the following loading methods:",ra,yt,Jo='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',pa,N,Ve,da,xt,Lo="The call function to the pipeline for generation.",ca,ne,ma,k,Xe,ga,$t,jo=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,fa,ae,ua,oe,ha,se,Fe,_a,Pt,ko=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,ba,ie,ze,va,Mt,So=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ia,le,Re,wa,Ut,Zo=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ya,S,He,xa,Tt,Wo=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,$a,re,Pa,pe,Ma,de,Ye,Ua,Ct,Go='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ta,ce,Ae,Ca,Jt,Eo="Encodes the prompt into text encoder hidden states.",Ja,L,Qe,La,Lt,Bo=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,ja,jt,No="The noise is applied in two ways:",ka,kt,Vo="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",Sa,St,Xo="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",Za,Zt,Fo="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",Wn,H,me,cn,De,Wa,Wt,zo="StableUnCLIPImg2ImgPipeline",Gn,P,qe,Ga,Gt,Ro="Pipeline for text-guided image-to-image generation using stable unCLIP.",Ea,Et,Ho=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ba,Bt,Yo="The pipeline also inherits the following loading methods:",Na,Nt,Ao='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Va,V,Oe,Xa,Vt,Qo="The call function to the pipeline for generation.",Fa,ge,za,Z,Ke,Ra,Xt,Do=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ha,fe,Ya,ue,Aa,he,et,Qa,Ft,qo=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Da,_e,tt,qa,zt,Oo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Oa,be,nt,Ka,Rt,Ko=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,eo,W,at,to,Ht,es=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,no,ve,ao,Ie,oo,we,ot,so,Yt,ts='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',io,ye,st,lo,At,ns="Encodes the prompt into text encoder hidden states.",ro,j,it,po,Qt,as=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,co,Dt,os="The noise is applied in two ways:",mo,qt,ss="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",go,Ot,is="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",fo,Kt,ls="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",En,Y,xe,mn,lt,uo,en,rs="ImagePipelineOutput",Bn,A,rt,ho,tn,ps="Output class for image pipelines.",Nn;return s=new gt({}),Le=new gt({}),ke=new gt({}),Se=new Q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UnCLIPScheduler, DDPMScheduler, StableUnCLIPPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> PriorTransformer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTokenizer, CLIPTextModelWithProjection

prior_model_id = <span class="hljs-string">&quot;kakaobrain/karlo-v1-alpha&quot;</span>
data_type = torch.float16
prior = PriorTransformer.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior&quot;</span>, torch_dtype=data_type)

prior_text_model_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
prior_tokenizer = CLIPTokenizer.from_pretrained(prior_text_model_id)
prior_text_model = CLIPTextModelWithProjection.from_pretrained(prior_text_model_id, torch_dtype=data_type)
prior_scheduler = UnCLIPScheduler.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior_scheduler&quot;</span>)
prior_scheduler = DDPMScheduler.from_config(prior_scheduler.config)

stable_unclip_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>

pipe = StableUnCLIPPipeline.from_pretrained(
    stable_unclip_model_id,
    torch_dtype=data_type,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    prior_tokenizer=prior_tokenizer,
    prior_text_encoder=prior_text_model,
    prior=prior,
    prior_scheduler=prior_scheduler,
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
wave_prompt = <span class="hljs-string">&quot;dramatic wave, the Oceans roar, Strong wave spiral across the oceans as the waves unfurl into roaring crests; perfect wave form; perfect wave shape; dramatic wave shape; wave shape unbelievable; wave; wave shape spectacular&quot;</span>

image = pipe(prompt=wave_prompt).images[<span class="hljs-number">0</span>]
image`}}),O=new on({props:{warning:!0,$$slots:{default:[xs]},$$scope:{ctx:C}}}),Ze=new gt({}),We=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLXVuY2xpcCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhdGlvbiUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3RhYmxlX3VuY2xpcCUyRnRhcnNpbGFfZG9fYW1hcmFsLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKGluaXRfaW1hZ2UpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJ2YXJpYXRpb25faW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip&quot;</span>, torch_dtype=torch.float16, variation=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/stable_unclip/tarsila_do_amaral.png&quot;</span>
init_image = load_image(url)

images = pipe(init_image).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image.png&quot;</span>)`}}),Ee=new Q({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShpbml0X2ltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

image = pipe(init_image, prompt=prompt).images[<span class="hljs-number">0</span>]
image`}}),ee=new on({props:{$$slots:{default:[$s]},$$scope:{ctx:C}}}),Be=new gt({}),Ne=new J({props:{name:"class diffusers.StableUnCLIPPipeline",anchor:"diffusers.StableUnCLIPPipeline",parameters:[{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior",val:": PriorTransformer"},{name:"prior_scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"prior_tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen <code>CLIPTextModelWithProjection</code> text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.StableUnCLIPPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Scheduler used in the prior denoising process.`,name:"prior_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen <code>CLIPTextModel</code> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L61"}}),Ve=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Optional = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"noise_level",val:": int = 0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_latents",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps in the prior denoising process. More denoising steps usually lead to a
higher quality image at the expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"prior_guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_latents",description:`<strong>prior_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
embedding generation in the prior denoising process. Can be used to tweak the same generation with
different prompts. If not provided, a latents tensor is generated by sampling using the supplied random
<code>generator</code>.`,name:"prior_latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L649",returnDescription:`
<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ne=new sn({props:{anchor:"diffusers.StableUnCLIPPipeline.__call__.example",$$slots:{default:[Ps]},$$scope:{ctx:C}}}),Xe=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),ae=new on({props:{warning:!0,$$slots:{default:[Ms]},$$scope:{ctx:C}}}),oe=new sn({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.example",$$slots:{default:[Us]},$$scope:{ctx:C}}}),Fe=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),ze=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L159"}}),Re=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L167"}}),He=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),re=new on({props:{warning:!0,$$slots:{default:[Ts]},$$scope:{ctx:C}}}),pe=new sn({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Cs]},$$scope:{ctx:C}}}),Ye=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),Ae=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L302"}}),Qe=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": Optional = None"},{name:"generator",val:": Optional = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L603"}}),De=new gt({}),qe=new J({props:{name:"class diffusers.StableUnCLIPImg2ImgPipeline",anchor:"diffusers.StableUnCLIPImg2ImgPipeline",parameters:[{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
Feature extractor for image pre-processing before being encoded.`,name:"feature_extractor"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
CLIP vision model for encoding images.`,name:"image_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>~transformers.CLIPTokenizer</code>) &#x2014;
A [<code>~transformers.CLIPTokenizer</code>)].`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L72"}}),Oe=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__",parameters:[{name:"image",val:": Union = None"},{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Optional = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"noise_level",val:": int = 0"},{name:"image_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, either <code>prompt_embeds</code> will be
used or prompt is initialized to <code>&quot;&quot;</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code> or tensor representing an image batch. The image is encoded to its CLIP embedding which the
<code>unet</code> is conditioned on. The image is <em>not</em> encoded by the <code>vae</code> and then used as the latents in the
denoising process like it is in the standard Stable Diffusion text-guided image variation process.`,name:"image"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated CLIP embeddings to condition the <code>unet</code> on. These latents are not used in the denoising
process. If you want to provide pre-generated latents, pass them to <code>__call__</code> as <code>latents</code>.`,name:"image_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L623",returnDescription:`
<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ge=new sn({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.example",$$slots:{default:[Js]},$$scope:{ctx:C}}}),Ke=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),fe=new on({props:{warning:!0,$$slots:{default:[Ls]},$$scope:{ctx:C}}}),ue=new sn({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[js]},$$scope:{ctx:C}}}),et=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),tt=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L160"}}),nt=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L168"}}),at=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),ve=new on({props:{warning:!0,$$slots:{default:[ks]},$$scope:{ctx:C}}}),Ie=new sn({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Ss]},$$scope:{ctx:C}}}),ot=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),st=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L264"}}),it=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": Optional = None"},{name:"generator",val:": Optional = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L577"}}),lt=new gt({}),rt=new J({props:{name:"class diffusers.ImagePipelineOutput",anchor:"diffusers.ImagePipelineOutput",parameters:[{name:"images",val:": Union"}],parametersDescription:[{anchor:"diffusers.ImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L115"}}),{c(){n=a("meta"),y=l(),p=a("h1"),d=a("a"),x=a("span"),u(s.$$.fragment),T=l(),ft=a("span"),ft.textContent=_o,wn=l(),Te=a("p"),Te.innerHTML=bo,yn=l(),Ce=a("p"),Ce.textContent=vo,xn=l(),Je=a("p"),Je.innerHTML=Io,$n=l(),X=a("h2"),D=a("a"),ln=a("span"),u(Le.$$.fragment),ta=l(),ut=a("span"),ut.textContent=wo,Pn=l(),je=a("p"),je.innerHTML=yo,Mn=l(),F=a("h3"),q=a("a"),rn=a("span"),u(ke.$$.fragment),na=l(),ht=a("span"),ht.textContent=xo,Un=Is(`

Stable unCLIP can be leveraged for text-to-image generation by pipelining it with the prior model of KakaoBrain's open source DALL-E 2 replication [Karlo](https://huggingface.co/kakaobrain/karlo-v1-alpha):

	`),u(Se.$$.fragment),Tn=l(),u(O.$$.fragment),Cn=l(),z=a("h3"),K=a("a"),pn=a("span"),u(Ze.$$.fragment),aa=l(),_t=a("span"),_t.textContent=$o,Jn=l(),u(We.$$.fragment),Ln=l(),Ge=a("p"),Ge.innerHTML=Po,jn=l(),u(Ee.$$.fragment),kn=l(),u(ee.$$.fragment),Sn=l(),R=a("h2"),te=a("a"),dn=a("span"),u(Be.$$.fragment),oa=l(),bt=a("span"),bt.textContent=Mo,Zn=l(),$=a("div"),u(Ne.$$.fragment),sa=l(),vt=a("p"),vt.textContent=Uo,ia=l(),It=a("p"),It.innerHTML=To,la=l(),wt=a("p"),wt.textContent=Co,ra=l(),yt=a("ul"),yt.innerHTML=Jo,pa=l(),N=a("div"),u(Ve.$$.fragment),da=l(),xt=a("p"),xt.textContent=Lo,ca=l(),u(ne.$$.fragment),ma=l(),k=a("div"),u(Xe.$$.fragment),ga=l(),$t=a("p"),$t.textContent=jo,fa=l(),u(ae.$$.fragment),ua=l(),u(oe.$$.fragment),ha=l(),se=a("div"),u(Fe.$$.fragment),_a=l(),Pt=a("p"),Pt.innerHTML=ko,ba=l(),ie=a("div"),u(ze.$$.fragment),va=l(),Mt=a("p"),Mt.textContent=So,Ia=l(),le=a("div"),u(Re.$$.fragment),wa=l(),Ut=a("p"),Ut.innerHTML=Zo,ya=l(),S=a("div"),u(He.$$.fragment),xa=l(),Tt=a("p"),Tt.innerHTML=Wo,$a=l(),u(re.$$.fragment),Pa=l(),u(pe.$$.fragment),Ma=l(),de=a("div"),u(Ye.$$.fragment),Ua=l(),Ct=a("p"),Ct.innerHTML=Go,Ta=l(),ce=a("div"),u(Ae.$$.fragment),Ca=l(),Jt=a("p"),Jt.textContent=Eo,Ja=l(),L=a("div"),u(Qe.$$.fragment),La=l(),Lt=a("p"),Lt.innerHTML=Bo,ja=l(),jt=a("p"),jt.textContent=No,ka=l(),kt=a("ol"),kt.innerHTML=Vo,Sa=l(),St=a("p"),St.innerHTML=Xo,Za=l(),Zt=a("p"),Zt.textContent=Fo,Wn=l(),H=a("h2"),me=a("a"),cn=a("span"),u(De.$$.fragment),Wa=l(),Wt=a("span"),Wt.textContent=zo,Gn=l(),P=a("div"),u(qe.$$.fragment),Ga=l(),Gt=a("p"),Gt.textContent=Ro,Ea=l(),Et=a("p"),Et.innerHTML=Ho,Ba=l(),Bt=a("p"),Bt.textContent=Yo,Na=l(),Nt=a("ul"),Nt.innerHTML=Ao,Va=l(),V=a("div"),u(Oe.$$.fragment),Xa=l(),Vt=a("p"),Vt.textContent=Qo,Fa=l(),u(ge.$$.fragment),za=l(),Z=a("div"),u(Ke.$$.fragment),Ra=l(),Xt=a("p"),Xt.textContent=Do,Ha=l(),u(fe.$$.fragment),Ya=l(),u(ue.$$.fragment),Aa=l(),he=a("div"),u(et.$$.fragment),Qa=l(),Ft=a("p"),Ft.innerHTML=qo,Da=l(),_e=a("div"),u(tt.$$.fragment),qa=l(),zt=a("p"),zt.textContent=Oo,Oa=l(),be=a("div"),u(nt.$$.fragment),Ka=l(),Rt=a("p"),Rt.innerHTML=Ko,eo=l(),W=a("div"),u(at.$$.fragment),to=l(),Ht=a("p"),Ht.innerHTML=es,no=l(),u(ve.$$.fragment),ao=l(),u(Ie.$$.fragment),oo=l(),we=a("div"),u(ot.$$.fragment),so=l(),Yt=a("p"),Yt.innerHTML=ts,io=l(),ye=a("div"),u(st.$$.fragment),lo=l(),At=a("p"),At.textContent=ns,ro=l(),j=a("div"),u(it.$$.fragment),po=l(),Qt=a("p"),Qt.innerHTML=as,co=l(),Dt=a("p"),Dt.textContent=os,mo=l(),qt=a("ol"),qt.innerHTML=ss,go=l(),Ot=a("p"),Ot.innerHTML=is,fo=l(),Kt=a("p"),Kt.textContent=ls,En=l(),Y=a("h2"),xe=a("a"),mn=a("span"),u(lt.$$.fragment),uo=l(),en=a("span"),en.textContent=rs,Bn=l(),A=a("div"),u(rt.$$.fragment),ho=l(),tn=a("p"),tn.textContent=ps,this.h()},l(e){const c=ws("svelte-1phssyn",document.head);n=o(c,"META",{name:!0,content:!0}),c.forEach(i),y=r(e),p=o(e,"H1",{class:!0});var pt=w(p);d=o(pt,"A",{id:!0,class:!0,href:!0});var gn=w(d);x=o(gn,"SPAN",{});var fn=w(x);h(s.$$.fragment,fn),fn.forEach(i),gn.forEach(i),T=r(pt),ft=o(pt,"SPAN",{"data-svelte-h":!0}),m(ft)!=="svelte-v5wcx7"&&(ft.textContent=_o),pt.forEach(i),wn=r(e),Te=o(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-bd6hsa"&&(Te.innerHTML=bo),yn=r(e),Ce=o(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1cwsb16"&&(Ce.textContent=vo),xn=r(e),Je=o(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-ha34c8"&&(Je.innerHTML=Io),$n=r(e),X=o(e,"H2",{class:!0});var dt=w(X);D=o(dt,"A",{id:!0,class:!0,href:!0});var un=w(D);ln=o(un,"SPAN",{});var hn=w(ln);h(Le.$$.fragment,hn),hn.forEach(i),un.forEach(i),ta=r(dt),ut=o(dt,"SPAN",{"data-svelte-h":!0}),m(ut)!=="svelte-12o6a2j"&&(ut.textContent=wo),dt.forEach(i),Pn=r(e),je=o(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-ozodyw"&&(je.innerHTML=yo),Mn=r(e),F=o(e,"H3",{class:!0});var ct=w(F);q=o(ct,"A",{id:!0,class:!0,href:!0});var _n=w(q);rn=o(_n,"SPAN",{});var bn=w(rn);h(ke.$$.fragment,bn),bn.forEach(i),_n.forEach(i),na=r(ct),ht=o(ct,"SPAN",{"data-svelte-h":!0}),m(ht)!=="svelte-18cls7s"&&(ht.textContent=xo),ct.forEach(i),Un=ys(e,`

Stable unCLIP can be leveraged for text-to-image generation by pipelining it with the prior model of KakaoBrain's open source DALL-E 2 replication [Karlo](https://huggingface.co/kakaobrain/karlo-v1-alpha):

	`),h(Se.$$.fragment,e),Tn=r(e),h(O.$$.fragment,e),Cn=r(e),z=o(e,"H3",{class:!0});var mt=w(z);K=o(mt,"A",{id:!0,class:!0,href:!0});var vn=w(K);pn=o(vn,"SPAN",{});var In=w(pn);h(Ze.$$.fragment,In),In.forEach(i),vn.forEach(i),aa=r(mt),_t=o(mt,"SPAN",{"data-svelte-h":!0}),m(_t)!=="svelte-taw4ak"&&(_t.textContent=$o),mt.forEach(i),Jn=r(e),h(We.$$.fragment,e),Ln=r(e),Ge=o(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1mvqeru"&&(Ge.innerHTML=Po),jn=r(e),h(Ee.$$.fragment,e),kn=r(e),h(ee.$$.fragment,e),Sn=r(e),R=o(e,"H2",{class:!0});var Vn=w(R);te=o(Vn,"A",{id:!0,class:!0,href:!0});var ds=w(te);dn=o(ds,"SPAN",{});var cs=w(dn);h(Be.$$.fragment,cs),cs.forEach(i),ds.forEach(i),oa=r(Vn),bt=o(Vn,"SPAN",{"data-svelte-h":!0}),m(bt)!=="svelte-go5i11"&&(bt.textContent=Mo),Vn.forEach(i),Zn=r(e),$=o(e,"DIV",{class:!0});var M=w($);h(Ne.$$.fragment,M),sa=r(M),vt=o(M,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-2c89j6"&&(vt.textContent=Uo),ia=r(M),It=o(M,"P",{"data-svelte-h":!0}),m(It)!=="svelte-496sm0"&&(It.innerHTML=To),la=r(M),wt=o(M,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-14s6m4u"&&(wt.textContent=Co),ra=r(M),yt=o(M,"UL",{"data-svelte-h":!0}),m(yt)!=="svelte-ks5x56"&&(yt.innerHTML=Jo),pa=r(M),N=o(M,"DIV",{class:!0});var nn=w(N);h(Ve.$$.fragment,nn),da=r(nn),xt=o(nn,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-50j04k"&&(xt.textContent=Lo),ca=r(nn),h(ne.$$.fragment,nn),nn.forEach(i),ma=r(M),k=o(M,"DIV",{class:!0});var $e=w(k);h(Xe.$$.fragment,$e),ga=r($e),$t=o($e,"P",{"data-svelte-h":!0}),m($t)!=="svelte-10jaql7"&&($t.textContent=jo),fa=r($e),h(ae.$$.fragment,$e),ua=r($e),h(oe.$$.fragment,$e),$e.forEach(i),ha=r(M),se=o(M,"DIV",{class:!0});var Xn=w(se);h(Fe.$$.fragment,Xn),_a=r(Xn),Pt=o(Xn,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1lh0nh5"&&(Pt.innerHTML=ko),Xn.forEach(i),ba=r(M),ie=o(M,"DIV",{class:!0});var Fn=w(ie);h(ze.$$.fragment,Fn),va=r(Fn),Mt=o(Fn,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-14bnrb6"&&(Mt.textContent=So),Fn.forEach(i),Ia=r(M),le=o(M,"DIV",{class:!0});var zn=w(le);h(Re.$$.fragment,zn),wa=r(zn),Ut=o(zn,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-1s3c06i"&&(Ut.innerHTML=Zo),zn.forEach(i),ya=r(M),S=o(M,"DIV",{class:!0});var Pe=w(S);h(He.$$.fragment,Pe),xa=r(Pe),Tt=o(Pe,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-e03q3e"&&(Tt.innerHTML=Wo),$a=r(Pe),h(re.$$.fragment,Pe),Pa=r(Pe),h(pe.$$.fragment,Pe),Pe.forEach(i),Ma=r(M),de=o(M,"DIV",{class:!0});var Rn=w(de);h(Ye.$$.fragment,Rn),Ua=r(Rn),Ct=o(Rn,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-1vfte1e"&&(Ct.innerHTML=Go),Rn.forEach(i),Ta=r(M),ce=o(M,"DIV",{class:!0});var Hn=w(ce);h(Ae.$$.fragment,Hn),Ca=r(Hn),Jt=o(Hn,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-16q0ax1"&&(Jt.textContent=Eo),Hn.forEach(i),Ja=r(M),L=o(M,"DIV",{class:!0});var G=w(L);h(Qe.$$.fragment,G),La=r(G),Lt=o(G,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-1e71opl"&&(Lt.innerHTML=Bo),ja=r(G),jt=o(G,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-acyrt"&&(jt.textContent=No),ka=r(G),kt=o(G,"OL",{"data-svelte-h":!0}),m(kt)!=="svelte-114uhci"&&(kt.innerHTML=Vo),Sa=r(G),St=o(G,"P",{"data-svelte-h":!0}),m(St)!=="svelte-46dthp"&&(St.innerHTML=Xo),Za=r(G),Zt=o(G,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-4ngutd"&&(Zt.textContent=Fo),G.forEach(i),M.forEach(i),Wn=r(e),H=o(e,"H2",{class:!0});var Yn=w(H);me=o(Yn,"A",{id:!0,class:!0,href:!0});var ms=w(me);cn=o(ms,"SPAN",{});var gs=w(cn);h(De.$$.fragment,gs),gs.forEach(i),ms.forEach(i),Wa=r(Yn),Wt=o(Yn,"SPAN",{"data-svelte-h":!0}),m(Wt)!=="svelte-6mp1ud"&&(Wt.textContent=zo),Yn.forEach(i),Gn=r(e),P=o(e,"DIV",{class:!0});var U=w(P);h(qe.$$.fragment,U),Ga=r(U),Gt=o(U,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-y15i80"&&(Gt.textContent=Ro),Ea=r(U),Et=o(U,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-496sm0"&&(Et.innerHTML=Ho),Ba=r(U),Bt=o(U,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-14s6m4u"&&(Bt.textContent=Yo),Na=r(U),Nt=o(U,"UL",{"data-svelte-h":!0}),m(Nt)!=="svelte-ks5x56"&&(Nt.innerHTML=Ao),Va=r(U),V=o(U,"DIV",{class:!0});var an=w(V);h(Oe.$$.fragment,an),Xa=r(an),Vt=o(an,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-50j04k"&&(Vt.textContent=Qo),Fa=r(an),h(ge.$$.fragment,an),an.forEach(i),za=r(U),Z=o(U,"DIV",{class:!0});var Me=w(Z);h(Ke.$$.fragment,Me),Ra=r(Me),Xt=o(Me,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-10jaql7"&&(Xt.textContent=Do),Ha=r(Me),h(fe.$$.fragment,Me),Ya=r(Me),h(ue.$$.fragment,Me),Me.forEach(i),Aa=r(U),he=o(U,"DIV",{class:!0});var An=w(he);h(et.$$.fragment,An),Qa=r(An),Ft=o(An,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1lh0nh5"&&(Ft.innerHTML=qo),An.forEach(i),Da=r(U),_e=o(U,"DIV",{class:!0});var Qn=w(_e);h(tt.$$.fragment,Qn),qa=r(Qn),zt=o(Qn,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-14bnrb6"&&(zt.textContent=Oo),Qn.forEach(i),Oa=r(U),be=o(U,"DIV",{class:!0});var Dn=w(be);h(nt.$$.fragment,Dn),Ka=r(Dn),Rt=o(Dn,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-1s3c06i"&&(Rt.innerHTML=Ko),Dn.forEach(i),eo=r(U),W=o(U,"DIV",{class:!0});var Ue=w(W);h(at.$$.fragment,Ue),to=r(Ue),Ht=o(Ue,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-e03q3e"&&(Ht.innerHTML=es),no=r(Ue),h(ve.$$.fragment,Ue),ao=r(Ue),h(Ie.$$.fragment,Ue),Ue.forEach(i),oo=r(U),we=o(U,"DIV",{class:!0});var qn=w(we);h(ot.$$.fragment,qn),so=r(qn),Yt=o(qn,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-1vfte1e"&&(Yt.innerHTML=ts),qn.forEach(i),io=r(U),ye=o(U,"DIV",{class:!0});var On=w(ye);h(st.$$.fragment,On),lo=r(On),At=o(On,"P",{"data-svelte-h":!0}),m(At)!=="svelte-16q0ax1"&&(At.textContent=ns),On.forEach(i),ro=r(U),j=o(U,"DIV",{class:!0});var E=w(j);h(it.$$.fragment,E),po=r(E),Qt=o(E,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-1e71opl"&&(Qt.innerHTML=as),co=r(E),Dt=o(E,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-acyrt"&&(Dt.textContent=os),mo=r(E),qt=o(E,"OL",{"data-svelte-h":!0}),m(qt)!=="svelte-114uhci"&&(qt.innerHTML=ss),go=r(E),Ot=o(E,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-46dthp"&&(Ot.innerHTML=is),fo=r(E),Kt=o(E,"P",{"data-svelte-h":!0}),m(Kt)!=="svelte-4ngutd"&&(Kt.textContent=ls),E.forEach(i),U.forEach(i),En=r(e),Y=o(e,"H2",{class:!0});var Kn=w(Y);xe=o(Kn,"A",{id:!0,class:!0,href:!0});var fs=w(xe);mn=o(fs,"SPAN",{});var us=w(mn);h(lt.$$.fragment,us),us.forEach(i),fs.forEach(i),uo=r(Kn),en=o(Kn,"SPAN",{"data-svelte-h":!0}),m(en)!=="svelte-1ula3t"&&(en.textContent=rs),Kn.forEach(i),Bn=r(e),A=o(e,"DIV",{class:!0});var ea=w(A);h(rt.$$.fragment,ea),ho=r(ea),tn=o(ea,"P",{"data-svelte-h":!0}),m(tn)!=="svelte-19wetgi"&&(tn.textContent=ps),ea.forEach(i),this.h()},h(){f(n,"name","hf:doc:metadata"),f(n,"content",JSON.stringify(Ws)),f(d,"id","stable-unclip"),f(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(d,"href","#stable-unclip"),f(p,"class","relative group"),f(D,"id","tips"),f(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(D,"href","#tips"),f(X,"class","relative group"),f(q,"id","texttoimage-generation"),f(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(q,"href","#texttoimage-generation"),f(F,"class","relative group"),f(K,"id","text-guided-imagetoimage-variation"),f(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(K,"href","#text-guided-imagetoimage-variation"),f(z,"class","relative group"),f(te,"id","diffusers.StableUnCLIPPipeline"),f(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(te,"href","#diffusers.StableUnCLIPPipeline"),f(R,"class","relative group"),f(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(me,"id","diffusers.StableUnCLIPImg2ImgPipeline"),f(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(me,"href","#diffusers.StableUnCLIPImg2ImgPipeline"),f(H,"class","relative group"),f(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(xe,"id","diffusers.ImagePipelineOutput"),f(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(xe,"href","#diffusers.ImagePipelineOutput"),f(Y,"class","relative group"),f(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,n),g(e,y,c),g(e,p,c),t(p,d),t(d,x),_(s,x,null),t(p,T),t(p,ft),g(e,wn,c),g(e,Te,c),g(e,yn,c),g(e,Ce,c),g(e,xn,c),g(e,Je,c),g(e,$n,c),g(e,X,c),t(X,D),t(D,ln),_(Le,ln,null),t(X,ta),t(X,ut),g(e,Pn,c),g(e,je,c),g(e,Mn,c),g(e,F,c),t(F,q),t(q,rn),_(ke,rn,null),t(F,na),t(F,ht),g(e,Un,c),_(Se,e,c),g(e,Tn,c),_(O,e,c),g(e,Cn,c),g(e,z,c),t(z,K),t(K,pn),_(Ze,pn,null),t(z,aa),t(z,_t),g(e,Jn,c),_(We,e,c),g(e,Ln,c),g(e,Ge,c),g(e,jn,c),_(Ee,e,c),g(e,kn,c),_(ee,e,c),g(e,Sn,c),g(e,R,c),t(R,te),t(te,dn),_(Be,dn,null),t(R,oa),t(R,bt),g(e,Zn,c),g(e,$,c),_(Ne,$,null),t($,sa),t($,vt),t($,ia),t($,It),t($,la),t($,wt),t($,ra),t($,yt),t($,pa),t($,N),_(Ve,N,null),t(N,da),t(N,xt),t(N,ca),_(ne,N,null),t($,ma),t($,k),_(Xe,k,null),t(k,ga),t(k,$t),t(k,fa),_(ae,k,null),t(k,ua),_(oe,k,null),t($,ha),t($,se),_(Fe,se,null),t(se,_a),t(se,Pt),t($,ba),t($,ie),_(ze,ie,null),t(ie,va),t(ie,Mt),t($,Ia),t($,le),_(Re,le,null),t(le,wa),t(le,Ut),t($,ya),t($,S),_(He,S,null),t(S,xa),t(S,Tt),t(S,$a),_(re,S,null),t(S,Pa),_(pe,S,null),t($,Ma),t($,de),_(Ye,de,null),t(de,Ua),t(de,Ct),t($,Ta),t($,ce),_(Ae,ce,null),t(ce,Ca),t(ce,Jt),t($,Ja),t($,L),_(Qe,L,null),t(L,La),t(L,Lt),t(L,ja),t(L,jt),t(L,ka),t(L,kt),t(L,Sa),t(L,St),t(L,Za),t(L,Zt),g(e,Wn,c),g(e,H,c),t(H,me),t(me,cn),_(De,cn,null),t(H,Wa),t(H,Wt),g(e,Gn,c),g(e,P,c),_(qe,P,null),t(P,Ga),t(P,Gt),t(P,Ea),t(P,Et),t(P,Ba),t(P,Bt),t(P,Na),t(P,Nt),t(P,Va),t(P,V),_(Oe,V,null),t(V,Xa),t(V,Vt),t(V,Fa),_(ge,V,null),t(P,za),t(P,Z),_(Ke,Z,null),t(Z,Ra),t(Z,Xt),t(Z,Ha),_(fe,Z,null),t(Z,Ya),_(ue,Z,null),t(P,Aa),t(P,he),_(et,he,null),t(he,Qa),t(he,Ft),t(P,Da),t(P,_e),_(tt,_e,null),t(_e,qa),t(_e,zt),t(P,Oa),t(P,be),_(nt,be,null),t(be,Ka),t(be,Rt),t(P,eo),t(P,W),_(at,W,null),t(W,to),t(W,Ht),t(W,no),_(ve,W,null),t(W,ao),_(Ie,W,null),t(P,oo),t(P,we),_(ot,we,null),t(we,so),t(we,Yt),t(P,io),t(P,ye),_(st,ye,null),t(ye,lo),t(ye,At),t(P,ro),t(P,j),_(it,j,null),t(j,po),t(j,Qt),t(j,co),t(j,Dt),t(j,mo),t(j,qt),t(j,go),t(j,Ot),t(j,fo),t(j,Kt),g(e,En,c),g(e,Y,c),t(Y,xe),t(xe,mn),_(lt,mn,null),t(Y,uo),t(Y,en),g(e,Bn,c),g(e,A,c),_(rt,A,null),t(A,ho),t(A,tn),Nn=!0},p(e,[c]){const pt={};c&2&&(pt.$$scope={dirty:c,ctx:e}),O.$set(pt);const gn={};c&2&&(gn.$$scope={dirty:c,ctx:e}),ee.$set(gn);const fn={};c&2&&(fn.$$scope={dirty:c,ctx:e}),ne.$set(fn);const dt={};c&2&&(dt.$$scope={dirty:c,ctx:e}),ae.$set(dt);const un={};c&2&&(un.$$scope={dirty:c,ctx:e}),oe.$set(un);const hn={};c&2&&(hn.$$scope={dirty:c,ctx:e}),re.$set(hn);const ct={};c&2&&(ct.$$scope={dirty:c,ctx:e}),pe.$set(ct);const _n={};c&2&&(_n.$$scope={dirty:c,ctx:e}),ge.$set(_n);const bn={};c&2&&(bn.$$scope={dirty:c,ctx:e}),fe.$set(bn);const mt={};c&2&&(mt.$$scope={dirty:c,ctx:e}),ue.$set(mt);const vn={};c&2&&(vn.$$scope={dirty:c,ctx:e}),ve.$set(vn);const In={};c&2&&(In.$$scope={dirty:c,ctx:e}),Ie.$set(In)},i(e){Nn||(b(s.$$.fragment,e),b(Le.$$.fragment,e),b(ke.$$.fragment,e),b(Se.$$.fragment,e),b(O.$$.fragment,e),b(Ze.$$.fragment,e),b(We.$$.fragment,e),b(Ee.$$.fragment,e),b(ee.$$.fragment,e),b(Be.$$.fragment,e),b(Ne.$$.fragment,e),b(Ve.$$.fragment,e),b(ne.$$.fragment,e),b(Xe.$$.fragment,e),b(ae.$$.fragment,e),b(oe.$$.fragment,e),b(Fe.$$.fragment,e),b(ze.$$.fragment,e),b(Re.$$.fragment,e),b(He.$$.fragment,e),b(re.$$.fragment,e),b(pe.$$.fragment,e),b(Ye.$$.fragment,e),b(Ae.$$.fragment,e),b(Qe.$$.fragment,e),b(De.$$.fragment,e),b(qe.$$.fragment,e),b(Oe.$$.fragment,e),b(ge.$$.fragment,e),b(Ke.$$.fragment,e),b(fe.$$.fragment,e),b(ue.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(at.$$.fragment,e),b(ve.$$.fragment,e),b(Ie.$$.fragment,e),b(ot.$$.fragment,e),b(st.$$.fragment,e),b(it.$$.fragment,e),b(lt.$$.fragment,e),b(rt.$$.fragment,e),Nn=!0)},o(e){v(s.$$.fragment,e),v(Le.$$.fragment,e),v(ke.$$.fragment,e),v(Se.$$.fragment,e),v(O.$$.fragment,e),v(Ze.$$.fragment,e),v(We.$$.fragment,e),v(Ee.$$.fragment,e),v(ee.$$.fragment,e),v(Be.$$.fragment,e),v(Ne.$$.fragment,e),v(Ve.$$.fragment,e),v(ne.$$.fragment,e),v(Xe.$$.fragment,e),v(ae.$$.fragment,e),v(oe.$$.fragment,e),v(Fe.$$.fragment,e),v(ze.$$.fragment,e),v(Re.$$.fragment,e),v(He.$$.fragment,e),v(re.$$.fragment,e),v(pe.$$.fragment,e),v(Ye.$$.fragment,e),v(Ae.$$.fragment,e),v(Qe.$$.fragment,e),v(De.$$.fragment,e),v(qe.$$.fragment,e),v(Oe.$$.fragment,e),v(ge.$$.fragment,e),v(Ke.$$.fragment,e),v(fe.$$.fragment,e),v(ue.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(nt.$$.fragment,e),v(at.$$.fragment,e),v(ve.$$.fragment,e),v(Ie.$$.fragment,e),v(ot.$$.fragment,e),v(st.$$.fragment,e),v(it.$$.fragment,e),v(lt.$$.fragment,e),v(rt.$$.fragment,e),Nn=!1},d(e){e&&(i(y),i(p),i(wn),i(Te),i(yn),i(Ce),i(xn),i(Je),i($n),i(X),i(Pn),i(je),i(Mn),i(F),i(Un),i(Tn),i(Cn),i(z),i(Jn),i(Ln),i(Ge),i(jn),i(kn),i(Sn),i(R),i(Zn),i($),i(Wn),i(H),i(Gn),i(P),i(En),i(Y),i(Bn),i(A)),i(n),I(s),I(Le),I(ke),I(Se,e),I(O,e),I(Ze),I(We,e),I(Ee,e),I(ee,e),I(Be),I(Ne),I(Ve),I(ne),I(Xe),I(ae),I(oe),I(Fe),I(ze),I(Re),I(He),I(re),I(pe),I(Ye),I(Ae),I(Qe),I(De),I(qe),I(Oe),I(ge),I(Ke),I(fe),I(ue),I(et),I(tt),I(nt),I(at),I(ve),I(Ie),I(ot),I(st),I(it),I(lt),I(rt)}}}const Ws={local:"stable-unclip",sections:[{local:"tips",sections:[{local:"texttoimage-generation",title:"Text-to-Image Generation"},{local:"text-guided-imagetoimage-variation",title:"Text guided Image-to-Image Variation"}],title:"Tips"},{local:"diffusers.StableUnCLIPPipeline",title:"StableUnCLIPPipeline"},{local:"diffusers.StableUnCLIPImg2ImgPipeline",title:"StableUnCLIPImg2ImgPipeline"},{local:"diffusers.ImagePipelineOutput",title:"ImagePipelineOutput"}],title:"Stable unCLIP"};function Gs(C){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends bs{constructor(n){super(),vs(this,n,Gs,Zs,hs,{})}}export{Rs as component};
