import{s as Ot,o as Kt,n as Je}from"../chunks/scheduler.182ea377.js";import{S as en,i as tn,g as a,s as r,p as v,A as nn,h as o,f as i,c as p,j as T,q as w,m as u,k as g,v as t,a as h,r as y,d as x,t as $,u as M}from"../chunks/index.008d68e4.js";import{T as St}from"../chunks/Tip.4f096367.js";import{D as j}from"../chunks/Docstring.7aec8b85.js";import{C as It}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as Pt}from"../chunks/IconCopyLink.96bbb92b.js";import{E as Dt}from"../chunks/ExampleCodeBlock.23e54afe.js";function sn(S){let s,b='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,l,_='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){s=a("p"),s.innerHTML=b,c=r(),l=a("p"),l.innerHTML=_},l(n){s=o(n,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1j961ct"&&(s.innerHTML=b),c=p(n),l=o(n,"P",{"data-svelte-h":!0}),u(l)!=="svelte-z4pn9c"&&(l.innerHTML=_)},m(n,U){h(n,s,U),h(n,c,U),h(n,l,U)},p:Je,d(n){n&&(i(s),i(c),i(l))}}}function an(S){let s,b="Examples:",c,l,_;return l=new It({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teDQtdXBzY2FsZXIlMjIlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGxldCdzJTIwZG93bmxvYWQlMjBhbiUyMCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkMi11cHNjYWxlJTJGbG93X3Jlc19jYXQucG5nJTIyJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWxvd19yZXNfaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFsb3dfcmVzX2ltZyUyMCUzRCUyMGxvd19yZXNfaW1nLnJlc2l6ZSgoMTI4JTJDJTIwMTI4KSklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwd2hpdGUlMjBjYXQlMjIlMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEbG93X3Jlc19pbWcpLmltYWdlcyU1QjAlNUQlMEF1cHNjYWxlZF9pbWFnZS5zYXZlKCUyMnVwc2FtcGxlZF9jYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model and scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionUpscalePipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an  image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd2-upscale/low_res_cat.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = low_res_img.resize((<span class="hljs-number">128</span>, <span class="hljs-number">128</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a white cat&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = pipeline(prompt=prompt, image=low_res_img).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;upsampled_cat.png&quot;</span>)`}}),{c(){s=a("p"),s.textContent=b,c=r(),v(l.$$.fragment)},l(n){s=o(n,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=b),c=p(n),w(l.$$.fragment,n)},m(n,U){h(n,s,U),h(n,c,U),y(l,n,U),_=!0},p:Je,i(n){_||(x(l.$$.fragment,n),_=!0)},o(n){$(l.$$.fragment,n),_=!1},d(n){n&&(i(s),i(c)),M(l,n)}}}function on(S){let s,b=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){s=a("p"),s.innerHTML=b},l(c){s=o(c,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ackzsn"&&(s.innerHTML=b)},m(c,l){h(c,s,l)},p:Je,d(c){c&&i(s)}}}function ln(S){let s,b="Examples:",c,l,_;return l=new It({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){s=a("p"),s.textContent=b,c=r(),v(l.$$.fragment)},l(n){s=o(n,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=b),c=p(n),w(l.$$.fragment,n)},m(n,U){h(n,s,U),h(n,c,U),y(l,n,U),_=!0},p:Je,i(n){_||(x(l.$$.fragment,n),_=!0)},o(n){$(l.$$.fragment,n),_=!1},d(n){n&&(i(s),i(c)),M(l,n)}}}function rn(S){let s,b=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){s=a("p"),s.textContent=b},l(c){s=o(c,"P",{"data-svelte-h":!0}),u(s)!=="svelte-17p1lpg"&&(s.textContent=b)},m(c,l){h(c,s,l)},p:Je,d(c){c&&i(s)}}}function pn(S){let s,b="Examples:",c,l,_;return l=new It({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){s=a("p"),s.textContent=b,c=r(),v(l.$$.fragment)},l(n){s=o(n,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=b),c=p(n),w(l.$$.fragment,n)},m(n,U){h(n,s,U),h(n,c,U),y(l,n,U),_=!0},p:Je,i(n){_||(x(l.$$.fragment,n),_=!0)},o(n){$(l.$$.fragment,n),_=!1},d(n){n&&(i(s),i(c)),M(l,n)}}}function cn(S){let s,b,c,l,_,n,U,fe,Jt="Super-resolution",Le,q,jt='The Stable Diffusion upscaler diffusion model was created by the researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. It is used to enhance the resolution of input images by a factor of 4.',Ne,W,Ee,k,G,je,O,qe,me,kt="StableDiffusionUpscalePipeline",Be,d,K,Oe,ue,Ct="Pipeline for text-guided image super-resolution using Stable Diffusion 2.",Ke,ge,Zt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,et,he,Wt="The pipeline also inherits the following loading methods:",tt,_e,Gt='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',nt,J,ee,st,be,Lt="The call function to the pipeline for generation.",at,L,ot,P,te,it,ve,Nt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,lt,N,rt,E,pt,B,ne,ct,we,Et=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,dt,D,se,ft,ye,Bt=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,mt,F,ut,X,gt,R,ae,ht,xe,Ft='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',_t,V,oe,bt,$e,Xt="Disables the FreeU mechanism if enabled.",vt,I,ie,wt,Me,Rt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',yt,Ue,Vt="The suffixes after the scaling factors represent the stages where they are being applied.",xt,Te,zt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,$t,z,le,Mt,Se,At="Encodes the prompt into text encoder hidden states.",Fe,C,A,ke,re,Ut,Pe,Ht="StableDiffusionPipelineOutput",Xe,Z,pe,Tt,De,Qt="Output class for Stable Diffusion pipelines.",Re;return n=new Pt({}),W=new St({props:{$$slots:{default:[sn]},$$scope:{ctx:S}}}),O=new Pt({}),K=new j({props:{name:"class diffusers.StableDiffusionUpscalePipeline",anchor:"diffusers.StableDiffusionUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"low_res_scheduler",val:": DDPMScheduler"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": Optional = None"},{name:"feature_extractor",val:": Optional = None"},{name:"watermarker",val:": Optional = None"},{name:"max_noise_level",val:": int = 350"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionUpscalePipeline.low_res_scheduler",description:`<strong>low_res_scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler used to add initial noise to the low resolution conditioning image. It must be an instance of
<a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>.`,name:"low_res_scheduler"},{anchor:"diffusers.StableDiffusionUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L70"}}),ee=new j({props:{name:"__call__",anchor:"diffusers.StableDiffusionUpscalePipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"noise_level",val:": int = 20"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled.`,name:"image"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L561",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),L=new Dt({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.example",$$slots:{default:[an]},$$scope:{ctx:S}}}),te=new j({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),N=new St({props:{warning:!0,$$slots:{default:[on]},$$scope:{ctx:S}}}),E=new Dt({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[ln]},$$scope:{ctx:S}}}),ne=new j({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),se=new j({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),F=new St({props:{warning:!0,$$slots:{default:[rn]},$$scope:{ctx:S}}}),X=new Dt({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[pn]},$$scope:{ctx:S}}}),ae=new j({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),oe=new j({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L557"}}),ie=new j({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L534"}}),le=new j({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L205"}}),re=new Pt({}),pe=new j({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){s=a("meta"),b=r(),c=a("h1"),l=a("a"),_=a("span"),v(n.$$.fragment),U=r(),fe=a("span"),fe.textContent=Jt,Le=r(),q=a("p"),q.innerHTML=jt,Ne=r(),v(W.$$.fragment),Ee=r(),k=a("h2"),G=a("a"),je=a("span"),v(O.$$.fragment),qe=r(),me=a("span"),me.textContent=kt,Be=r(),d=a("div"),v(K.$$.fragment),Oe=r(),ue=a("p"),ue.textContent=Ct,Ke=r(),ge=a("p"),ge.innerHTML=Zt,et=r(),he=a("p"),he.textContent=Wt,tt=r(),_e=a("ul"),_e.innerHTML=Gt,nt=r(),J=a("div"),v(ee.$$.fragment),st=r(),be=a("p"),be.textContent=Lt,at=r(),v(L.$$.fragment),ot=r(),P=a("div"),v(te.$$.fragment),it=r(),ve=a("p"),ve.textContent=Nt,lt=r(),v(N.$$.fragment),rt=r(),v(E.$$.fragment),pt=r(),B=a("div"),v(ne.$$.fragment),ct=r(),we=a("p"),we.innerHTML=Et,dt=r(),D=a("div"),v(se.$$.fragment),ft=r(),ye=a("p"),ye.innerHTML=Bt,mt=r(),v(F.$$.fragment),ut=r(),v(X.$$.fragment),gt=r(),R=a("div"),v(ae.$$.fragment),ht=r(),xe=a("p"),xe.innerHTML=Ft,_t=r(),V=a("div"),v(oe.$$.fragment),bt=r(),$e=a("p"),$e.textContent=Xt,vt=r(),I=a("div"),v(ie.$$.fragment),wt=r(),Me=a("p"),Me.innerHTML=Rt,yt=r(),Ue=a("p"),Ue.textContent=Vt,xt=r(),Te=a("p"),Te.innerHTML=zt,$t=r(),z=a("div"),v(le.$$.fragment),Mt=r(),Se=a("p"),Se.textContent=At,Fe=r(),C=a("h2"),A=a("a"),ke=a("span"),v(re.$$.fragment),Ut=r(),Pe=a("span"),Pe.textContent=Ht,Xe=r(),Z=a("div"),v(pe.$$.fragment),Tt=r(),De=a("p"),De.textContent=Qt,this.h()},l(e){const f=nn("svelte-1phssyn",document.head);s=o(f,"META",{name:!0,content:!0}),f.forEach(i),b=p(e),c=o(e,"H1",{class:!0});var ce=T(c);l=o(ce,"A",{id:!0,class:!0,href:!0});var Ce=T(l);_=o(Ce,"SPAN",{});var Ze=T(_);w(n.$$.fragment,Ze),Ze.forEach(i),Ce.forEach(i),U=p(ce),fe=o(ce,"SPAN",{"data-svelte-h":!0}),u(fe)!=="svelte-1ok3vjl"&&(fe.textContent=Jt),ce.forEach(i),Le=p(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1rmru20"&&(q.innerHTML=jt),Ne=p(e),w(W.$$.fragment,e),Ee=p(e),k=o(e,"H2",{class:!0});var de=T(k);G=o(de,"A",{id:!0,class:!0,href:!0});var We=T(G);je=o(We,"SPAN",{});var Ge=T(je);w(O.$$.fragment,Ge),Ge.forEach(i),We.forEach(i),qe=p(de),me=o(de,"SPAN",{"data-svelte-h":!0}),u(me)!=="svelte-1fi5btq"&&(me.textContent=kt),de.forEach(i),Be=p(e),d=o(e,"DIV",{class:!0});var m=T(d);w(K.$$.fragment,m),Oe=p(m),ue=o(m,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-gmgvzq"&&(ue.textContent=Ct),Ke=p(m),ge=o(m,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-496sm0"&&(ge.innerHTML=Zt),et=p(m),he=o(m,"P",{"data-svelte-h":!0}),u(he)!=="svelte-14s6m4u"&&(he.textContent=Wt),tt=p(m),_e=o(m,"UL",{"data-svelte-h":!0}),u(_e)!=="svelte-iou1i9"&&(_e.innerHTML=Gt),nt=p(m),J=o(m,"DIV",{class:!0});var Ie=T(J);w(ee.$$.fragment,Ie),st=p(Ie),be=o(Ie,"P",{"data-svelte-h":!0}),u(be)!=="svelte-50j04k"&&(be.textContent=Lt),at=p(Ie),w(L.$$.fragment,Ie),Ie.forEach(i),ot=p(m),P=o(m,"DIV",{class:!0});var H=T(P);w(te.$$.fragment,H),it=p(H),ve=o(H,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-10jaql7"&&(ve.textContent=Nt),lt=p(H),w(N.$$.fragment,H),rt=p(H),w(E.$$.fragment,H),H.forEach(i),pt=p(m),B=o(m,"DIV",{class:!0});var Ve=T(B);w(ne.$$.fragment,Ve),ct=p(Ve),we=o(Ve,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1lh0nh5"&&(we.innerHTML=Et),Ve.forEach(i),dt=p(m),D=o(m,"DIV",{class:!0});var Q=T(D);w(se.$$.fragment,Q),ft=p(Q),ye=o(Q,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-e03q3e"&&(ye.innerHTML=Bt),mt=p(Q),w(F.$$.fragment,Q),ut=p(Q),w(X.$$.fragment,Q),Q.forEach(i),gt=p(m),R=o(m,"DIV",{class:!0});var ze=T(R);w(ae.$$.fragment,ze),ht=p(ze),xe=o(ze,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1vfte1e"&&(xe.innerHTML=Ft),ze.forEach(i),_t=p(m),V=o(m,"DIV",{class:!0});var Ae=T(V);w(oe.$$.fragment,Ae),bt=p(Ae),$e=o(Ae,"P",{"data-svelte-h":!0}),u($e)!=="svelte-psupw6"&&($e.textContent=Xt),Ae.forEach(i),vt=p(m),I=o(m,"DIV",{class:!0});var Y=T(I);w(ie.$$.fragment,Y),wt=p(Y),Me=o(Y,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1f3tmq1"&&(Me.innerHTML=Rt),yt=p(Y),Ue=o(Y,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-xjijlp"&&(Ue.textContent=Vt),xt=p(Y),Te=o(Y,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-hy0nzs"&&(Te.innerHTML=zt),Y.forEach(i),$t=p(m),z=o(m,"DIV",{class:!0});var He=T(z);w(le.$$.fragment,He),Mt=p(He),Se=o(He,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-16q0ax1"&&(Se.textContent=At),He.forEach(i),m.forEach(i),Fe=p(e),C=o(e,"H2",{class:!0});var Qe=T(C);A=o(Qe,"A",{id:!0,class:!0,href:!0});var Yt=T(A);ke=o(Yt,"SPAN",{});var qt=T(ke);w(re.$$.fragment,qt),qt.forEach(i),Yt.forEach(i),Ut=p(Qe),Pe=o(Qe,"SPAN",{"data-svelte-h":!0}),u(Pe)!=="svelte-1ocdz42"&&(Pe.textContent=Ht),Qe.forEach(i),Xe=p(e),Z=o(e,"DIV",{class:!0});var Ye=T(Z);w(pe.$$.fragment,Ye),Tt=p(Ye),De=o(Ye,"P",{"data-svelte-h":!0}),u(De)!=="svelte-1qpjiuf"&&(De.textContent=Qt),Ye.forEach(i),this.h()},h(){g(s,"name","hf:doc:metadata"),g(s,"content",JSON.stringify(dn)),g(l,"id","superresolution"),g(l,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(l,"href","#superresolution"),g(c,"class","relative group"),g(G,"id","diffusers.StableDiffusionUpscalePipeline"),g(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(G,"href","#diffusers.StableDiffusionUpscalePipeline"),g(k,"class","relative group"),g(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(A,"id","diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),g(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(A,"href","#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),g(C,"class","relative group"),g(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){t(document.head,s),h(e,b,f),h(e,c,f),t(c,l),t(l,_),y(n,_,null),t(c,U),t(c,fe),h(e,Le,f),h(e,q,f),h(e,Ne,f),y(W,e,f),h(e,Ee,f),h(e,k,f),t(k,G),t(G,je),y(O,je,null),t(k,qe),t(k,me),h(e,Be,f),h(e,d,f),y(K,d,null),t(d,Oe),t(d,ue),t(d,Ke),t(d,ge),t(d,et),t(d,he),t(d,tt),t(d,_e),t(d,nt),t(d,J),y(ee,J,null),t(J,st),t(J,be),t(J,at),y(L,J,null),t(d,ot),t(d,P),y(te,P,null),t(P,it),t(P,ve),t(P,lt),y(N,P,null),t(P,rt),y(E,P,null),t(d,pt),t(d,B),y(ne,B,null),t(B,ct),t(B,we),t(d,dt),t(d,D),y(se,D,null),t(D,ft),t(D,ye),t(D,mt),y(F,D,null),t(D,ut),y(X,D,null),t(d,gt),t(d,R),y(ae,R,null),t(R,ht),t(R,xe),t(d,_t),t(d,V),y(oe,V,null),t(V,bt),t(V,$e),t(d,vt),t(d,I),y(ie,I,null),t(I,wt),t(I,Me),t(I,yt),t(I,Ue),t(I,xt),t(I,Te),t(d,$t),t(d,z),y(le,z,null),t(z,Mt),t(z,Se),h(e,Fe,f),h(e,C,f),t(C,A),t(A,ke),y(re,ke,null),t(C,Ut),t(C,Pe),h(e,Xe,f),h(e,Z,f),y(pe,Z,null),t(Z,Tt),t(Z,De),Re=!0},p(e,[f]){const ce={};f&2&&(ce.$$scope={dirty:f,ctx:e}),W.$set(ce);const Ce={};f&2&&(Ce.$$scope={dirty:f,ctx:e}),L.$set(Ce);const Ze={};f&2&&(Ze.$$scope={dirty:f,ctx:e}),N.$set(Ze);const de={};f&2&&(de.$$scope={dirty:f,ctx:e}),E.$set(de);const We={};f&2&&(We.$$scope={dirty:f,ctx:e}),F.$set(We);const Ge={};f&2&&(Ge.$$scope={dirty:f,ctx:e}),X.$set(Ge)},i(e){Re||(x(n.$$.fragment,e),x(W.$$.fragment,e),x(O.$$.fragment,e),x(K.$$.fragment,e),x(ee.$$.fragment,e),x(L.$$.fragment,e),x(te.$$.fragment,e),x(N.$$.fragment,e),x(E.$$.fragment,e),x(ne.$$.fragment,e),x(se.$$.fragment,e),x(F.$$.fragment,e),x(X.$$.fragment,e),x(ae.$$.fragment,e),x(oe.$$.fragment,e),x(ie.$$.fragment,e),x(le.$$.fragment,e),x(re.$$.fragment,e),x(pe.$$.fragment,e),Re=!0)},o(e){$(n.$$.fragment,e),$(W.$$.fragment,e),$(O.$$.fragment,e),$(K.$$.fragment,e),$(ee.$$.fragment,e),$(L.$$.fragment,e),$(te.$$.fragment,e),$(N.$$.fragment,e),$(E.$$.fragment,e),$(ne.$$.fragment,e),$(se.$$.fragment,e),$(F.$$.fragment,e),$(X.$$.fragment,e),$(ae.$$.fragment,e),$(oe.$$.fragment,e),$(ie.$$.fragment,e),$(le.$$.fragment,e),$(re.$$.fragment,e),$(pe.$$.fragment,e),Re=!1},d(e){e&&(i(b),i(c),i(Le),i(q),i(Ne),i(Ee),i(k),i(Be),i(d),i(Fe),i(C),i(Xe),i(Z)),i(s),M(n),M(W,e),M(O),M(K),M(ee),M(L),M(te),M(N),M(E),M(ne),M(se),M(F),M(X),M(ae),M(oe),M(ie),M(le),M(re),M(pe)}}}const dn={local:"superresolution",sections:[{local:"diffusers.StableDiffusionUpscalePipeline",title:"StableDiffusionUpscalePipeline"},{local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",title:"StableDiffusionPipelineOutput"}],title:"Super-resolution"};function fn(S){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wn extends en{constructor(s){super(),tn(this,s,fn,cn,Ot,{})}}export{wn as component};
