import{s as nn,o as an,n as mt}from"../chunks/scheduler.182ea377.js";import{S as on,i as sn,g as s,s as i,p as u,A as rn,h as r,f as n,c as o,j as T,q as g,m as c,k as f,v as d,a,r as _,d as v,t as b,u as w}from"../chunks/index.008d68e4.js";import{T as yt}from"../chunks/Tip.4f096367.js";import{D as ct}from"../chunks/Docstring.7aec8b85.js";import{C as _e}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as At}from"../chunks/IconCopyLink.96bbb92b.js";import{E as ln}from"../chunks/ExampleCodeBlock.23e54afe.js";function pn(A){let l,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=s("p"),l.innerHTML=M},l(p){l=r(p,"P",{"data-svelte-h":!0}),c(l)!=="svelte-1wmc0l4"&&(l.innerHTML=M)},m(p,m){a(p,l,m)},p:mt,d(p){p&&n(l)}}}function dn(A){let l,M="Notice that while initializing <code>pipe</code>, you’re setting <code>text_encoder</code> to <code>None</code> so that it’s not loaded.";return{c(){l=s("p"),l.innerHTML=M},l(p){l=r(p,"P",{"data-svelte-h":!0}),c(l)!=="svelte-1of5pjk"&&(l.innerHTML=M)},m(p,m){a(p,l,m)},p:mt,d(p){p&&n(l)}}}function cn(A){let l,M="Text embeddings computed in 8-bit can impact the quality of the generated images because of the information loss in the representation space caused by the reduced precision. It’s recommended to compare the outputs with and without 8-bit.";return{c(){l=s("p"),l.textContent=M},l(p){l=r(p,"P",{"data-svelte-h":!0}),c(l)!=="svelte-1rutysd"&&(l.textContent=M)},m(p,m){a(p,l,m)},p:mt,d(p){p&&n(l)}}}function mn(A){let l,M="Examples:",p,m,P;return m=new _e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUGl4QXJ0QWxwaGFQaXBlbGluZSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMHJlcGxhY2UlMjB0aGUlMjBjaGVja3BvaW50JTIwaWQlMjB3aXRoJTIwJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItNTEyeDUxMiUyMiUyMHRvby4lMEFwaXBlJTIwJTNEJTIwUGl4QXJ0QWxwaGFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItMTAyNC1NUyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjMlMjBFbmFibGUlMjBtZW1vcnklMjBvcHRpbWl6YXRpb25zLiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc21hbGwlMjBjYWN0dXMlMjB3aXRoJTIwYSUyMGhhcHB5JTIwZmFjZSUyMGluJTIwdGhlJTIwU2FoYXJhJTIwZGVzZXJ0LiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtAlphaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can replace the checkpoint id with &quot;PixArt-alpha/PixArt-XL-2-512x512&quot; too.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PixArtAlphaPipeline.from_pretrained(<span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable memory optimizations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){l=s("p"),l.textContent=M,p=i(),u(m.$$.fragment)},l(h){l=r(h,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),p=o(h),g(m.$$.fragment,h)},m(h,X){a(h,l,X),a(h,p,X),_(m,h,X),P=!0},p:mt,i(h){P||(v(m.$$.fragment,h),P=!0)},o(h){b(m.$$.fragment,h),P=!1},d(h){h&&(n(l),n(p)),w(m,h)}}}function hn(A){let l,M,p,m,P,h,X,ve,Pt="PixArt-α",Ue,L,Jt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/header_collage.png"/>',Ce,H,$t='<a href="https://huggingface.co/papers/2310.00426" rel="nofollow">PixArt-α: Fast Training of Diffusion Transformer for Photorealistic Text-to-Image Synthesis</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',ke,W,jt="The abstract from the paper is:",Ge,R,It="<em>The most advanced text-to-image (T2I) models require significant training costs (e.g., millions of GPU hours), seriously hindering the fundamental innovation for the AIGC community while increasing CO2 emissions. This paper introduces PIXART-α, a Transformer-based T2I diffusion model whose image generation quality is competitive with state-of-the-art image generators (e.g., Imagen, SDXL, and even Midjourney), reaching near-commercial application standards. Additionally, it supports high-resolution image synthesis up to 1024px resolution with low training cost, as shown in Figure 1 and 2. To achieve this goal, three core designs are proposed: (1) Training strategy decomposition: We devise three distinct training steps that separately optimize pixel dependency, text-image alignment, and image aesthetic quality; (2) Efficient T2I Transformer: We incorporate cross-attention modules into Diffusion Transformer (DiT) to inject text conditions and streamline the computation-intensive class-condition branch; (3) High-informative data: We emphasize the significance of concept density in text-image pairs and leverage a large Vision-Language model to auto-label dense pseudo-captions to assist text-image alignment learning. As a result, PIXART-α’s training speed markedly surpasses existing large-scale T2I models, e.g., PIXART-α only takes 10.8% of Stable Diffusion v1.5’s training time (675 vs. 6,250 A100 GPU days), saving nearly $300,000 ($26,000 vs. $320,000) and reducing 90% CO2 emissions. Moreover, compared with a larger SOTA model, RAPHAEL, our training cost is merely 1%. Extensive experiments demonstrate that PIXART-α excels in image quality, artistry, and semantic control. We hope PIXART-α will provide new insights to the AIGC community and startups to accelerate building their own high-quality yet low-cost generative models from scratch.</em>",Be,V,Ut='You can find the original codebase at <a href="https://github.com/PixArt-alpha/PixArt-alpha" rel="nofollow">PixArt-alpha/PixArt-alpha</a> and all the available checkpoints at <a href="https://huggingface.co/PixArt-alpha" rel="nofollow">PixArt-alpha</a>.',Ze,N,Ct="Some notes about this pipeline:",Ee,Q,kt='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="./dit">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-alpha/blob/08fbbd281ec96866109bdd2cdb75f2f58fb17610/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as Stable Diffusion XL, Imagen, and DALL-E 2, while being more efficient than them.</li>',Xe,I,Le,$,U,Je,S,ht,be,Gt="Inference with under 8GB GPU VRAM",He,F,Bt='Run the <a href="/docs/diffusers/main/en/api/pipelines/pixart#diffusers.PixArtAlphaPipeline">PixArtAlphaPipeline</a> with under 8GB GPU VRAM by loading the text encoder in 8-bit precision. Let’s walk through a full-fledged example.',We,q,Zt='First, install the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library:',Re,Y,Ve,D,Et="Then load the text encoder in 8-bit:",Ne,z,Qe,O,Xt="Now, use the <code>pipe</code> to encode a prompt:",Se,K,Fe,ee,Lt="Since text embeddings have been computed, remove the <code>text_encoder</code> and <code>pipe</code> from the memory, and free up som GPU VRAM:",qe,te,Ye,ne,Ht="Then compute the latents with the prompt embeddings as inputs:",De,ae,ze,C,Oe,ie,Wt="Once the latents are computed, pass it off to the VAE to decode into a real image:",Ke,oe,et,se,Rt='By deleting components you aren’t using and flushing the GPU VRAM, you should be able to run <a href="/docs/diffusers/main/en/api/pipelines/pixart#diffusers.PixArtAlphaPipeline">PixArtAlphaPipeline</a> with under 8GB GPU VRAM.',tt,re,Vt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/8bits_cat.png"/>',nt,le,Nt='If you want a report of your memory-usage, run this <a href="https://gist.github.com/sayakpaul/3ae0f847001d342af27018a96f467e4e" rel="nofollow">script</a>.',at,k,it,pe,Qt="While loading the <code>text_encoder</code>, you set <code>load_in_8bit</code> to <code>True</code>. You could also specify <code>load_in_4bit</code> to bring your memory requirements down even further to under 7GB.",ot,j,G,$e,de,ft,we,St="PixArtAlphaPipeline",st,x,ce,ut,xe,Ft="Pipeline for text-to-image generation using PixArt-Alpha.",gt,Me,qt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,_t,J,me,vt,Te,Yt="Function invoked when calling the pipeline for generation.",bt,B,wt,Z,he,xt,ye,Dt="Returns binned height and width.",Mt,E,fe,Tt,Ae,zt="Encodes the prompt into text encoder hidden states.",rt;return h=new At({}),I=new yt({props:{$$slots:{default:[pn]},$$scope:{ctx:A}}}),S=new At({}),Y=new _e({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes"}}),z=new _e({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFBpeEFydEFscGhhUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTBBKSUwQXBpcGUlMjAlM0QlMjBQaXhBcnRBbHBoYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtAlphaPipeline
<span class="hljs-keyword">import</span> torch

text_encoder = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,

)
pipe = PixArtAlphaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    text_encoder=text_encoder,
    transformer=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`}}),K=new _e({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmN1dGUlMjBjYXQlMjIlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcHJvbXB0X2F0dGVudGlvbl9tYXNrJTJDJTIwbmVnYXRpdmVfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2F0dGVudGlvbl9tYXNrJTIwJTNEJTIwcGlwZS5lbmNvZGVfcHJvbXB0KHByb21wdCk=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    prompt = <span class="hljs-string">&quot;cute cat&quot;</span>
    prompt_embeds, prompt_attention_mask, negative_embeds, negative_prompt_attention_mask = pipe.encode_prompt(prompt)`}}),te=new _e({props:{code:"aW1wb3J0JTIwZ2MlMjAlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTBBZGVsJTIwdGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZSUwQWZsdXNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gc 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()

<span class="hljs-keyword">del</span> text_encoder
<span class="hljs-keyword">del</span> pipe
flush()`}}),ae=new _e({props:{code:"cGlwZSUyMCUzRCUyMFBpeEFydEFscGhhUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlBpeEFydC1hbHBoYSUyRlBpeEFydC1YTC0yLTEwMjQtTVMlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWxhdGVudHMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRE5vbmUlMkMlMjAlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfYXR0ZW50aW9uX21hc2slM0Rwcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slM0RuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQSUwQWRlbCUyMHBpcGUudHJhbnNmb3JtZXIlMEFmbHVzaCgp",highlighted:`pipe = PixArtAlphaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

latents = pipe(
    negative_prompt=<span class="hljs-literal">None</span>, 
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    prompt_attention_mask=prompt_attention_mask,
    negative_prompt_attention_mask=negative_prompt_attention_mask,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images

<span class="hljs-keyword">del</span> pipe.transformer
flush()`}}),C=new yt({props:{$$slots:{default:[dn]},$$scope:{ctx:A}}}),oe=new _e({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjBwaXBlLnZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    image = pipe.vae.decode(latents / pipe.vae.config.scaling_factor, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
image = pipe.image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`}}),k=new yt({props:{warning:!0,$$slots:{default:[cn]},$$scope:{ctx:A}}}),de=new At({}),ce=new ct({props:{name:"class diffusers.PixArtAlphaPipeline",anchor:"diffusers.PixArtAlphaPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": Transformer2DModel"},{name:"scheduler",val:": DPMSolverMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PixArtAlphaPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. PixArt-Alpha uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.PixArtAlphaPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.PixArtAlphaPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel">Transformer2DModel</a>) &#x2014;
A text conditioned <code>Transformer2DModel</code> to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.PixArtAlphaPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L182"}}),me=new ct({props:{name:"__call__",anchor:"diffusers.PixArtAlphaPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L666",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),B=new ln({props:{anchor:"diffusers.PixArtAlphaPipeline.__call__.example",$$slots:{default:[mn]},$$scope:{ctx:A}}}),he=new ct({props:{name:"classify_height_width_bin",anchor:"diffusers.PixArtAlphaPipeline.classify_height_width_bin",parameters:[{name:"height",val:": int"},{name:"width",val:": int"},{name:"ratios",val:": dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L634"}}),fe=new ct({props:{name:"encode_prompt",anchor:"diffusers.PixArtAlphaPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"clean_caption",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha, it&#x2019;s should be the embeddings of the &quot;&quot;
string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (bool, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L251"}}),{c(){l=s("meta"),M=i(),p=s("h1"),m=s("a"),P=s("span"),u(h.$$.fragment),X=i(),ve=s("span"),ve.textContent=Pt,Ue=i(),L=s("p"),L.innerHTML=Jt,Ce=i(),H=s("p"),H.innerHTML=$t,ke=i(),W=s("p"),W.textContent=jt,Ge=i(),R=s("p"),R.innerHTML=It,Be=i(),V=s("p"),V.innerHTML=Ut,Ze=i(),N=s("p"),N.textContent=Ct,Ee=i(),Q=s("ul"),Q.innerHTML=kt,Xe=i(),u(I.$$.fragment),Le=i(),$=s("h2"),U=s("a"),Je=s("span"),u(S.$$.fragment),ht=i(),be=s("span"),be.textContent=Gt,He=i(),F=s("p"),F.innerHTML=Bt,We=i(),q=s("p"),q.innerHTML=Zt,Re=i(),u(Y.$$.fragment),Ve=i(),D=s("p"),D.textContent=Et,Ne=i(),u(z.$$.fragment),Qe=i(),O=s("p"),O.innerHTML=Xt,Se=i(),u(K.$$.fragment),Fe=i(),ee=s("p"),ee.innerHTML=Lt,qe=i(),u(te.$$.fragment),Ye=i(),ne=s("p"),ne.textContent=Ht,De=i(),u(ae.$$.fragment),ze=i(),u(C.$$.fragment),Oe=i(),ie=s("p"),ie.textContent=Wt,Ke=i(),u(oe.$$.fragment),et=i(),se=s("p"),se.innerHTML=Rt,tt=i(),re=s("p"),re.innerHTML=Vt,nt=i(),le=s("p"),le.innerHTML=Nt,at=i(),u(k.$$.fragment),it=i(),pe=s("p"),pe.innerHTML=Qt,ot=i(),j=s("h2"),G=s("a"),$e=s("span"),u(de.$$.fragment),ft=i(),we=s("span"),we.textContent=St,st=i(),x=s("div"),u(ce.$$.fragment),ut=i(),xe=s("p"),xe.textContent=Ft,gt=i(),Me=s("p"),Me.innerHTML=qt,_t=i(),J=s("div"),u(me.$$.fragment),vt=i(),Te=s("p"),Te.textContent=Yt,bt=i(),u(B.$$.fragment),wt=i(),Z=s("div"),u(he.$$.fragment),xt=i(),ye=s("p"),ye.textContent=Dt,Mt=i(),E=s("div"),u(fe.$$.fragment),Tt=i(),Ae=s("p"),Ae.textContent=zt,this.h()},l(e){const t=rn("svelte-1phssyn",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(n),M=o(e),p=r(e,"H1",{class:!0});var ue=T(p);m=r(ue,"A",{id:!0,class:!0,href:!0});var je=T(m);P=r(je,"SPAN",{});var Ie=T(P);g(h.$$.fragment,Ie),Ie.forEach(n),je.forEach(n),X=o(ue),ve=r(ue,"SPAN",{"data-svelte-h":!0}),c(ve)!=="svelte-741zrl"&&(ve.textContent=Pt),ue.forEach(n),Ue=o(e),L=r(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-v8u40f"&&(L.innerHTML=Jt),Ce=o(e),H=r(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-9ej743"&&(H.innerHTML=$t),ke=o(e),W=r(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1cwsb16"&&(W.textContent=jt),Ge=o(e),R=r(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1ddr7a0"&&(R.innerHTML=It),Be=o(e),V=r(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1c7kadv"&&(V.innerHTML=Ut),Ze=o(e),N=r(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-v1sn1g"&&(N.textContent=Ct),Ee=o(e),Q=r(e,"UL",{"data-svelte-h":!0}),c(Q)!=="svelte-1o0jwg8"&&(Q.innerHTML=kt),Xe=o(e),g(I.$$.fragment,e),Le=o(e),$=r(e,"H2",{class:!0});var ge=T($);U=r(ge,"A",{id:!0,class:!0,href:!0});var Ot=T(U);Je=r(Ot,"SPAN",{});var Kt=T(Je);g(S.$$.fragment,Kt),Kt.forEach(n),Ot.forEach(n),ht=o(ge),be=r(ge,"SPAN",{"data-svelte-h":!0}),c(be)!=="svelte-l48sr5"&&(be.textContent=Gt),ge.forEach(n),He=o(e),F=r(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-143a3hz"&&(F.innerHTML=Bt),We=o(e),q=r(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-c2h3fb"&&(q.innerHTML=Zt),Re=o(e),g(Y.$$.fragment,e),Ve=o(e),D=r(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-5r7318"&&(D.textContent=Et),Ne=o(e),g(z.$$.fragment,e),Qe=o(e),O=r(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-rj1jgt"&&(O.innerHTML=Xt),Se=o(e),g(K.$$.fragment,e),Fe=o(e),ee=r(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-b16cf1"&&(ee.innerHTML=Lt),qe=o(e),g(te.$$.fragment,e),Ye=o(e),ne=r(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-w3d4de"&&(ne.textContent=Ht),De=o(e),g(ae.$$.fragment,e),ze=o(e),g(C.$$.fragment,e),Oe=o(e),ie=r(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-1yf7wfg"&&(ie.textContent=Wt),Ke=o(e),g(oe.$$.fragment,e),et=o(e),se=r(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-ev444i"&&(se.innerHTML=Rt),tt=o(e),re=r(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1g55ccf"&&(re.innerHTML=Vt),nt=o(e),le=r(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-11lvu0m"&&(le.innerHTML=Nt),at=o(e),g(k.$$.fragment,e),it=o(e),pe=r(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1i82z60"&&(pe.innerHTML=Qt),ot=o(e),j=r(e,"H2",{class:!0});var lt=T(j);G=r(lt,"A",{id:!0,class:!0,href:!0});var en=T(G);$e=r(en,"SPAN",{});var tn=T($e);g(de.$$.fragment,tn),tn.forEach(n),en.forEach(n),ft=o(lt),we=r(lt,"SPAN",{"data-svelte-h":!0}),c(we)!=="svelte-19xzd93"&&(we.textContent=St),lt.forEach(n),st=o(e),x=r(e,"DIV",{class:!0});var y=T(x);g(ce.$$.fragment,y),ut=o(y),xe=r(y,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-31ka93"&&(xe.textContent=Ft),gt=o(y),Me=r(y,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-wu1jmh"&&(Me.innerHTML=qt),_t=o(y),J=r(y,"DIV",{class:!0});var Pe=T(J);g(me.$$.fragment,Pe),vt=o(Pe),Te=r(Pe,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-v78lg8"&&(Te.textContent=Yt),bt=o(Pe),g(B.$$.fragment,Pe),Pe.forEach(n),wt=o(y),Z=r(y,"DIV",{class:!0});var pt=T(Z);g(he.$$.fragment,pt),xt=o(pt),ye=r(pt,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-vknpvz"&&(ye.textContent=Dt),pt.forEach(n),Mt=o(y),E=r(y,"DIV",{class:!0});var dt=T(E);g(fe.$$.fragment,dt),Tt=o(dt),Ae=r(dt,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-16q0ax1"&&(Ae.textContent=zt),dt.forEach(n),y.forEach(n),this.h()},h(){f(l,"name","hf:doc:metadata"),f(l,"content",JSON.stringify(fn)),f(m,"id","pixart"),f(m,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(m,"href","#pixart"),f(p,"class","relative group"),f(U,"id","inference-with-under-8gb-gpu-vram"),f(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(U,"href","#inference-with-under-8gb-gpu-vram"),f($,"class","relative group"),f(G,"id","diffusers.PixArtAlphaPipeline"),f(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(G,"href","#diffusers.PixArtAlphaPipeline"),f(j,"class","relative group"),f(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),a(e,M,t),a(e,p,t),d(p,m),d(m,P),_(h,P,null),d(p,X),d(p,ve),a(e,Ue,t),a(e,L,t),a(e,Ce,t),a(e,H,t),a(e,ke,t),a(e,W,t),a(e,Ge,t),a(e,R,t),a(e,Be,t),a(e,V,t),a(e,Ze,t),a(e,N,t),a(e,Ee,t),a(e,Q,t),a(e,Xe,t),_(I,e,t),a(e,Le,t),a(e,$,t),d($,U),d(U,Je),_(S,Je,null),d($,ht),d($,be),a(e,He,t),a(e,F,t),a(e,We,t),a(e,q,t),a(e,Re,t),_(Y,e,t),a(e,Ve,t),a(e,D,t),a(e,Ne,t),_(z,e,t),a(e,Qe,t),a(e,O,t),a(e,Se,t),_(K,e,t),a(e,Fe,t),a(e,ee,t),a(e,qe,t),_(te,e,t),a(e,Ye,t),a(e,ne,t),a(e,De,t),_(ae,e,t),a(e,ze,t),_(C,e,t),a(e,Oe,t),a(e,ie,t),a(e,Ke,t),_(oe,e,t),a(e,et,t),a(e,se,t),a(e,tt,t),a(e,re,t),a(e,nt,t),a(e,le,t),a(e,at,t),_(k,e,t),a(e,it,t),a(e,pe,t),a(e,ot,t),a(e,j,t),d(j,G),d(G,$e),_(de,$e,null),d(j,ft),d(j,we),a(e,st,t),a(e,x,t),_(ce,x,null),d(x,ut),d(x,xe),d(x,gt),d(x,Me),d(x,_t),d(x,J),_(me,J,null),d(J,vt),d(J,Te),d(J,bt),_(B,J,null),d(x,wt),d(x,Z),_(he,Z,null),d(Z,xt),d(Z,ye),d(x,Mt),d(x,E),_(fe,E,null),d(E,Tt),d(E,Ae),rt=!0},p(e,[t]){const ue={};t&2&&(ue.$$scope={dirty:t,ctx:e}),I.$set(ue);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),C.$set(je);const Ie={};t&2&&(Ie.$$scope={dirty:t,ctx:e}),k.$set(Ie);const ge={};t&2&&(ge.$$scope={dirty:t,ctx:e}),B.$set(ge)},i(e){rt||(v(h.$$.fragment,e),v(I.$$.fragment,e),v(S.$$.fragment,e),v(Y.$$.fragment,e),v(z.$$.fragment,e),v(K.$$.fragment,e),v(te.$$.fragment,e),v(ae.$$.fragment,e),v(C.$$.fragment,e),v(oe.$$.fragment,e),v(k.$$.fragment,e),v(de.$$.fragment,e),v(ce.$$.fragment,e),v(me.$$.fragment,e),v(B.$$.fragment,e),v(he.$$.fragment,e),v(fe.$$.fragment,e),rt=!0)},o(e){b(h.$$.fragment,e),b(I.$$.fragment,e),b(S.$$.fragment,e),b(Y.$$.fragment,e),b(z.$$.fragment,e),b(K.$$.fragment,e),b(te.$$.fragment,e),b(ae.$$.fragment,e),b(C.$$.fragment,e),b(oe.$$.fragment,e),b(k.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(me.$$.fragment,e),b(B.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),rt=!1},d(e){e&&(n(M),n(p),n(Ue),n(L),n(Ce),n(H),n(ke),n(W),n(Ge),n(R),n(Be),n(V),n(Ze),n(N),n(Ee),n(Q),n(Xe),n(Le),n($),n(He),n(F),n(We),n(q),n(Re),n(Ve),n(D),n(Ne),n(Qe),n(O),n(Se),n(Fe),n(ee),n(qe),n(Ye),n(ne),n(De),n(ze),n(Oe),n(ie),n(Ke),n(et),n(se),n(tt),n(re),n(nt),n(le),n(at),n(it),n(pe),n(ot),n(j),n(st),n(x)),n(l),w(h),w(I,e),w(S),w(Y,e),w(z,e),w(K,e),w(te,e),w(ae,e),w(C,e),w(oe,e),w(k,e),w(de),w(ce),w(me),w(B),w(he),w(fe)}}}const fn={local:"pixart",sections:[{local:"inference-with-under-8gb-gpu-vram",title:"Inference with under 8GB GPU VRAM"},{local:"diffusers.PixArtAlphaPipeline",title:"PixArtAlphaPipeline"}],title:"PixArt-α"};function un(A){return an(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tn extends on{constructor(l){super(),sn(this,l,un,hn,nn,{})}}export{Tn as component};
