import{s as wt,o as xt,n as bt}from"../chunks/scheduler.182ea377.js";import{S as yt,i as $t,g as o,s as r,p as v,A as Dt,h as a,f as t,c as l,j as _,q as M,m as p,k as f,v as s,a as i,r as b,d as w,t as x,u as y}from"../chunks/index.008d68e4.js";import{T as Lt}from"../chunks/Tip.4f096367.js";import{D as he}from"../chunks/Docstring.7aec8b85.js";import{C as Tt}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as Re}from"../chunks/IconCopyLink.96bbb92b.js";import{E as Ct}from"../chunks/ExampleCodeBlock.23e54afe.js";function Pt(te){let d,$='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){d=o("p"),d.innerHTML=$},l(u){d=a(u,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1wmc0l4"&&(d.innerHTML=$)},m(u,h){i(u,d,h)},p:bt,d(u){u&&t(d)}}}function kt(te){let d,$="Examples:",u,h,D;return h=new Tt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyME11c2ljTERNUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHNjaXB5JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnVjc2QtcmVhY2glMkZtdXNpY2xkbSUyMiUwQXBpcGUlMjAlM0QlMjBNdXNpY0xETVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVGVjaG5vJTIwbXVzaWMlMjB3aXRoJTIwYSUyMHN0cm9uZyUyQyUyMHVwYmVhdCUyMHRlbXBvJTIwYW5kJTIwaGlnaCUyMG1lbG9kaWMlMjByaWZmcyUyMiUwQWF1ZGlvJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAlMkMlMjBhdWRpb19sZW5ndGhfaW5fcyUzRDUuMCkuYXVkaW9zJTVCMCU1RCUwQSUwQSUyMyUyMHNhdmUlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUyMGFzJTIwYSUyMC53YXYlMjBmaWxlJTBBc2NpcHkuaW8ud2F2ZmlsZS53cml0ZSglMjJ0ZWNobm8ud2F2JTIyJTJDJTIwcmF0ZSUzRDE2MDAwJTJDJTIwZGF0YSUzRGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MusicLDMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;ucsd-reach/musicldm&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = MusicLDMPipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(prompt, num_inference_steps=<span class="hljs-number">10</span>, audio_length_in_s=<span class="hljs-number">5.0</span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the audio sample as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`}}),{c(){d=o("p"),d.textContent=$,u=r(),v(h.$$.fragment)},l(c){d=a(c,"P",{"data-svelte-h":!0}),p(d)!=="svelte-kvfsh7"&&(d.textContent=$),u=l(c),M(h.$$.fragment,c)},m(c,N){i(c,d,N),i(c,u,N),b(h,c,N),D=!0},p:bt,i(c){D||(w(h.$$.fragment,c),D=!0)},o(c){x(h.$$.fragment,c),D=!1},d(c){c&&(t(d),t(u)),y(h,c)}}}function Ut(te){let d,$,u,h,D,c,N,ne,Fe="MusicLDM",ge,I,Qe=`MusicLDM was proposed in <a href="https://huggingface.co/papers/2308.01546" rel="nofollow">MusicLDM: Enhancing Novelty in Text-to-Music Generation Using Beat-Synchronous Mixup Strategies</a> by Ke Chen, Yusong Wu, Haohe Liu, Marianna Nezhurina, Taylor Berg-Kirkpatrick, Shlomo Dubnov.
MusicLDM takes a text prompt as input and predicts the corresponding music sample.`,_e,G,Ye=`Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a> and <a href="https://huggingface.co/docs/diffusers/api/pipelines/audioldm" rel="nofollow">AudioLDM</a>,
MusicLDM is a text-to-music <em>latent diffusion model (LDM)</em> that learns continuous audio representations from <a href="https://huggingface.co/docs/transformers/main/model_doc/clap" rel="nofollow">CLAP</a>
latents.`,ve,E,Ke="MusicLDM is trained on a corpus of 466 hours of music data. Beat-synchronous data augmentation strategies are applied to the music samples, both in the time domain and in the latent space. Using beat-synchronous data augmentation strategies encourages the model to interpolate between the training samples, but stay within the domain of the training data. The result is generated music that is more diverse while staying faithful to the corresponding style.",Me,J,et="The abstract of the paper is the following:",be,B,tt="<em>Diffusion models have shown promising results in cross-modal generation tasks, including text-to-image and text-to-audio generation. However, generating music, as a special type of audio, presents unique challenges due to limited availability of music data and sensitive issues related to copyright and plagiarism. In this paper, to tackle these challenges, we first construct a state-of-the-art text-to-music model, MusicLDM, that adapts Stable Diffusion and AudioLDM architectures to the music domain. We achieve this by retraining the contrastive language-audio pretraining model (CLAP) and the Hifi-GAN vocoder, as components of MusicLDM, on a collection of music data samples. Then, to address the limitations of training data and to avoid plagiarism, we leverage a beat tracking model and propose two different mixup strategies for data augmentation: beat-synchronous audio mixup and beat-synchronous latent mixup, which recombine training audio directly or via a latent embeddings space, respectively. Such mixup strategies encourage the model to interpolate between musical training samples and generate new music within the convex hull of the training data, making the generated music more diverse while still staying faithful to the corresponding style. In addition to popular evaluation metrics, we design several new evaluation metrics based on CLAP score to demonstrate that our proposed MusicLDM and beat-synchronous mixup strategies improve both the quality and novelty of generated music, as well as the correspondence between input text and generated music.</em>",we,q,nt='This pipeline was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>.',xe,T,P,ue,Z,Ne,oe,ot="Tips",ye,V,at="When constructing a prompt, keep in mind:",$e,W,st="<li>Descriptive prompt inputs work best; use adjectives to describe the sound (for example, “high quality” or “clear”) and make the prompt context specific where possible (e.g. “melodic techno with a fast beat and synths” works better than “techno”).</li> <li>Using a <em>negative prompt</em> can significantly improve the quality of the generated audio. Try using a negative prompt of “low quality, average quality”.</li>",De,z,it="During inference:",Le,O,rt="<li>The <em>quality</em> of the generated audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>Multiple waveforms can be generated in one go: set <code>num_waveforms_per_prompt</code> to a value greater than 1 to enable. Automatic scoring will be performed between the generated waveforms and prompt text, and the audios ranked from best to worst accordingly.</li> <li>The <em>length</em> of the generated audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",Te,k,Ce,C,U,me,X,Ie,ae,lt="MusicLDMPipeline",Pe,m,R,Ge,se,dt="Pipeline for text-to-audio generation using MusicLDM.",Ee,ie,ct=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Je,L,F,Be,re,pt="The call function to the pipeline for generation.",qe,j,Ze,S,Q,Ve,le,ut=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,We,A,Y,ze,de,mt=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Oe,H,K,Xe,ce,ft=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ke;return c=new Re({}),Z=new Re({}),k=new Lt({props:{$$slots:{default:[Pt]},$$scope:{ctx:te}}}),X=new Re({}),R=new he({props:{name:"class diffusers.MusicLDMPipeline",anchor:"diffusers.MusicLDMPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": Union"},{name:"tokenizer",val:": Union"},{name:"feature_extractor",val:": Optional"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.MusicLDMPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.MusicLDMPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>) &#x2014;
Frozen text-audio embedding model (<code>ClapTextModel</code>), specifically the
<a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant.`,name:"text_encoder"},{anchor:"diffusers.MusicLDMPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.MusicLDMPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapFeatureExtractor" rel="nofollow">ClapFeatureExtractor</a>) &#x2014;
Feature extractor to compute mel-spectrograms from audio waveforms.`,name:"feature_extractor"},{anchor:"diffusers.MusicLDMPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.MusicLDMPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.MusicLDMPipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code>.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L67"}}),F=new he({props:{name:"__call__",anchor:"diffusers.MusicLDMPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"audio_length_in_s",val:": Optional = None"},{name:"num_inference_steps",val:": int = 200"},{name:"guidance_scale",val:": float = 2.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_waveforms_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"}],parametersDescription:[{anchor:"diffusers.MusicLDMPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10.24) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.MusicLDMPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.MusicLDMPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.MusicLDMPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt. If <code>num_waveforms_per_prompt &gt; 1</code>, the text encoding
model is a joint text-audio model (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>), and the tokenizer is a
<code>[~transformers.ClapProcessor]</code>, then automatic scoring will be performed between the generated outputs
and the input text. This scoring ranks the generated waveforms based on their cosine similarity to text
input in the joint text-audio embedding space.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.MusicLDMPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.MusicLDMPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.MusicLDMPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MusicLDMPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MusicLDMPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioPipelineOutput">AudioPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.MusicLDMPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.MusicLDMPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.MusicLDMPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.MusicLDMPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated audio. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object. Set to <code>&quot;latent&quot;</code> to return the latent diffusion
model (LDM) output.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L434",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated audio.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> or <code>tuple</code></p>
`}}),j=new Ct({props:{anchor:"diffusers.MusicLDMPipeline.__call__.example",$$slots:{default:[kt]},$$scope:{ctx:te}}}),Q=new he({props:{name:"disable_vae_slicing",anchor:"diffusers.MusicLDMPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L125"}}),Y=new he({props:{name:"enable_model_cpu_offload",anchor:"diffusers.MusicLDMPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L400"}}),K=new he({props:{name:"enable_vae_slicing",anchor:"diffusers.MusicLDMPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L117"}}),{c(){d=o("meta"),$=r(),u=o("h1"),h=o("a"),D=o("span"),v(c.$$.fragment),N=r(),ne=o("span"),ne.textContent=Fe,ge=r(),I=o("p"),I.innerHTML=Qe,_e=r(),G=o("p"),G.innerHTML=Ye,ve=r(),E=o("p"),E.textContent=Ke,Me=r(),J=o("p"),J.textContent=et,be=r(),B=o("p"),B.innerHTML=tt,we=r(),q=o("p"),q.innerHTML=nt,xe=r(),T=o("h2"),P=o("a"),ue=o("span"),v(Z.$$.fragment),Ne=r(),oe=o("span"),oe.textContent=ot,ye=r(),V=o("p"),V.textContent=at,$e=r(),W=o("ul"),W.innerHTML=st,De=r(),z=o("p"),z.textContent=it,Le=r(),O=o("ul"),O.innerHTML=rt,Te=r(),v(k.$$.fragment),Ce=r(),C=o("h2"),U=o("a"),me=o("span"),v(X.$$.fragment),Ie=r(),ae=o("span"),ae.textContent=lt,Pe=r(),m=o("div"),v(R.$$.fragment),Ge=r(),se=o("p"),se.textContent=dt,Ee=r(),ie=o("p"),ie.innerHTML=ct,Je=r(),L=o("div"),v(F.$$.fragment),Be=r(),re=o("p"),re.textContent=pt,qe=r(),v(j.$$.fragment),Ze=r(),S=o("div"),v(Q.$$.fragment),Ve=r(),le=o("p"),le.innerHTML=ut,We=r(),A=o("div"),v(Y.$$.fragment),ze=r(),de=o("p"),de.innerHTML=mt,Oe=r(),H=o("div"),v(K.$$.fragment),Xe=r(),ce=o("p"),ce.textContent=ft,this.h()},l(e){const n=Dt("svelte-1phssyn",document.head);d=a(n,"META",{name:!0,content:!0}),n.forEach(t),$=l(e),u=a(e,"H1",{class:!0});var ee=_(u);h=a(ee,"A",{id:!0,class:!0,href:!0});var fe=_(h);D=a(fe,"SPAN",{});var ht=_(D);M(c.$$.fragment,ht),ht.forEach(t),fe.forEach(t),N=l(ee),ne=a(ee,"SPAN",{"data-svelte-h":!0}),p(ne)!=="svelte-1xq3cwj"&&(ne.textContent=Fe),ee.forEach(t),ge=l(e),I=a(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-dgtsvr"&&(I.innerHTML=Qe),_e=l(e),G=a(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-xz1yc5"&&(G.innerHTML=Ye),ve=l(e),E=a(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-59771y"&&(E.textContent=Ke),Me=l(e),J=a(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-wu27l3"&&(J.textContent=et),be=l(e),B=a(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-qsxrno"&&(B.innerHTML=tt),we=l(e),q=a(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-ig43pw"&&(q.innerHTML=nt),xe=l(e),T=a(e,"H2",{class:!0});var Ue=_(T);P=a(Ue,"A",{id:!0,class:!0,href:!0});var gt=_(P);ue=a(gt,"SPAN",{});var _t=_(ue);M(Z.$$.fragment,_t),_t.forEach(t),gt.forEach(t),Ne=l(Ue),oe=a(Ue,"SPAN",{"data-svelte-h":!0}),p(oe)!=="svelte-12o6a2j"&&(oe.textContent=ot),Ue.forEach(t),ye=l(e),V=a(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1dvtu0c"&&(V.textContent=at),$e=l(e),W=a(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-1gnv7ni"&&(W.innerHTML=st),De=l(e),z=a(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1g0t9wk"&&(z.textContent=it),Le=l(e),O=a(e,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-1ynscju"&&(O.innerHTML=rt),Te=l(e),M(k.$$.fragment,e),Ce=l(e),C=a(e,"H2",{class:!0});var je=_(C);U=a(je,"A",{id:!0,class:!0,href:!0});var vt=_(U);me=a(vt,"SPAN",{});var Mt=_(me);M(X.$$.fragment,Mt),Mt.forEach(t),vt.forEach(t),Ie=l(je),ae=a(je,"SPAN",{"data-svelte-h":!0}),p(ae)!=="svelte-1mfj3t9"&&(ae.textContent=lt),je.forEach(t),Pe=l(e),m=a(e,"DIV",{class:!0});var g=_(m);M(R.$$.fragment,g),Ge=l(g),se=a(g,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1abu1jx"&&(se.textContent=dt),Ee=l(g),ie=a(g,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-496sm0"&&(ie.innerHTML=ct),Je=l(g),L=a(g,"DIV",{class:!0});var pe=_(L);M(F.$$.fragment,pe),Be=l(pe),re=a(pe,"P",{"data-svelte-h":!0}),p(re)!=="svelte-50j04k"&&(re.textContent=pt),qe=l(pe),M(j.$$.fragment,pe),pe.forEach(t),Ze=l(g),S=a(g,"DIV",{class:!0});var Se=_(S);M(Q.$$.fragment,Se),Ve=l(Se),le=a(Se,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1s3c06i"&&(le.innerHTML=ut),Se.forEach(t),We=l(g),A=a(g,"DIV",{class:!0});var Ae=_(A);M(Y.$$.fragment,Ae),ze=l(Ae),de=a(Ae,"P",{"data-svelte-h":!0}),p(de)!=="svelte-d7vywi"&&(de.innerHTML=mt),Ae.forEach(t),Oe=l(g),H=a(g,"DIV",{class:!0});var He=_(H);M(K.$$.fragment,He),Xe=l(He),ce=a(He,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-14bnrb6"&&(ce.textContent=ft),He.forEach(t),g.forEach(t),this.h()},h(){f(d,"name","hf:doc:metadata"),f(d,"content",JSON.stringify(jt)),f(h,"id","musicldm"),f(h,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(h,"href","#musicldm"),f(u,"class","relative group"),f(P,"id","tips"),f(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(P,"href","#tips"),f(T,"class","relative group"),f(U,"id","diffusers.MusicLDMPipeline"),f(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),f(U,"href","#diffusers.MusicLDMPipeline"),f(C,"class","relative group"),f(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){s(document.head,d),i(e,$,n),i(e,u,n),s(u,h),s(h,D),b(c,D,null),s(u,N),s(u,ne),i(e,ge,n),i(e,I,n),i(e,_e,n),i(e,G,n),i(e,ve,n),i(e,E,n),i(e,Me,n),i(e,J,n),i(e,be,n),i(e,B,n),i(e,we,n),i(e,q,n),i(e,xe,n),i(e,T,n),s(T,P),s(P,ue),b(Z,ue,null),s(T,Ne),s(T,oe),i(e,ye,n),i(e,V,n),i(e,$e,n),i(e,W,n),i(e,De,n),i(e,z,n),i(e,Le,n),i(e,O,n),i(e,Te,n),b(k,e,n),i(e,Ce,n),i(e,C,n),s(C,U),s(U,me),b(X,me,null),s(C,Ie),s(C,ae),i(e,Pe,n),i(e,m,n),b(R,m,null),s(m,Ge),s(m,se),s(m,Ee),s(m,ie),s(m,Je),s(m,L),b(F,L,null),s(L,Be),s(L,re),s(L,qe),b(j,L,null),s(m,Ze),s(m,S),b(Q,S,null),s(S,Ve),s(S,le),s(m,We),s(m,A),b(Y,A,null),s(A,ze),s(A,de),s(m,Oe),s(m,H),b(K,H,null),s(H,Xe),s(H,ce),ke=!0},p(e,[n]){const ee={};n&2&&(ee.$$scope={dirty:n,ctx:e}),k.$set(ee);const fe={};n&2&&(fe.$$scope={dirty:n,ctx:e}),j.$set(fe)},i(e){ke||(w(c.$$.fragment,e),w(Z.$$.fragment,e),w(k.$$.fragment,e),w(X.$$.fragment,e),w(R.$$.fragment,e),w(F.$$.fragment,e),w(j.$$.fragment,e),w(Q.$$.fragment,e),w(Y.$$.fragment,e),w(K.$$.fragment,e),ke=!0)},o(e){x(c.$$.fragment,e),x(Z.$$.fragment,e),x(k.$$.fragment,e),x(X.$$.fragment,e),x(R.$$.fragment,e),x(F.$$.fragment,e),x(j.$$.fragment,e),x(Q.$$.fragment,e),x(Y.$$.fragment,e),x(K.$$.fragment,e),ke=!1},d(e){e&&(t($),t(u),t(ge),t(I),t(_e),t(G),t(ve),t(E),t(Me),t(J),t(be),t(B),t(we),t(q),t(xe),t(T),t(ye),t(V),t($e),t(W),t(De),t(z),t(Le),t(O),t(Te),t(Ce),t(C),t(Pe),t(m)),t(d),y(c),y(Z),y(k,e),y(X),y(R),y(F),y(j),y(Q),y(Y),y(K)}}}const jt={local:"musicldm",sections:[{local:"tips",title:"Tips"},{local:"diffusers.MusicLDMPipeline",title:"MusicLDMPipeline"}],title:"MusicLDM"};function St(te){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends yt{constructor(d){super(),$t(this,d,St,Ut,wt,{})}}export{Bt as component};
