import{s as xs,o as Vs,n as ne}from"../chunks/scheduler.182ea377.js";import{S as Js,i as js,g as a,s,p as h,A as Us,h as i,f as t,c as r,j as f,q as _,m as g,k as p,v as n,a as m,r as b,d as y,t as k,u as v}from"../chunks/index.008d68e4.js";import{T as Cs}from"../chunks/Tip.4f096367.js";import{D as I}from"../chunks/Docstring.7aec8b85.js";import{C as De}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as q}from"../chunks/IconCopyLink.96bbb92b.js";import{E as Fe}from"../chunks/ExampleCodeBlock.23e54afe.js";function $s(T){let l,P='Check out the <a href="https://huggingface.co/kandinsky-community" rel="nofollow">Kandinsky Community</a> organization on the Hub for the official model checkpoints for tasks like text-to-image, image-to-image, and inpainting.';return{c(){l=a("p"),l.innerHTML=P},l(u){l=i(u,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1nfky5i"&&(l.innerHTML=P)},m(u,c){m(u,l,c)},p:ne,d(u){u&&t(l)}}}function Zs(T){let l,P='Make sure to check out the schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=a("p"),l.innerHTML=P},l(u){l=i(u,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1rr33yw"&&(l.innerHTML=P)},m(u,c){m(u,l,c)},p:ne,d(u){u&&t(l)}}}function Ks(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBaW1hZ2VfZW1iJTJDJTIwbmVnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpLnRvX3R1cGxlKCklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0RuZWdhdGl2ZV9pbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2UlNUIwJTVELnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, negative_image_emb = pipe_prior(prompt).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function Ws(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lWMjJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQW91dCUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RvdXQuaW1hZ2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzdGFycnlfY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior.interpolate(images_texts, weights)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=out.image_embeds,
<span class="hljs-meta">... </span>    negative_image_embeds=out.negative_image_embeds,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function Gs(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQXplcm9faW1hZ2VfZW1iJTIwJTNEJTIwb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lWMjJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMmNhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>zero_image_emb = out.negative_image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function Es(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbGlvbiUyMGluJTIwZ2FsYXhpZXMlMkMlMjBzcGlyYWxzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwc21va2UlMkMlMjBpcmlkZXNjZW50JTJDJTIwaW50cmljYXRlJTIwZGV0YWlsJTJDJTIwb2N0YW5lJTIwcmVuZGVyJTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function qs(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JFbWIyRW1iUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIycmVkJTIwY2F0JTJDJTIwNGslMjBwaG90byUyMiUwQWltZyUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBaW1hZ2VfZW1iJTJDJTIwbmFnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjBpbWFnZSUzRGltZyUyQyUyMHN0cmVuZ3RoJTNEMC4yKS50b190dXBsZSgpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTIyJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorEmb2EmbPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, nagative_image_emb = pipe_prior(prompt, image=img, strength=<span class="hljs-number">0.2</span>).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder, torch_dtype=torch.float16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function Ls(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yRW1iMkVtYlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMFBJTCUwQSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lWMjJQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nMSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBaW1nMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRnN0YXJyeV9uaWdodC5qcGVnJTIyJTBBKSUwQSUwQWltYWdlc190ZXh0cyUyMCUzRCUyMCU1QiUyMmElMjBjYXQlMjIlMkMlMjBpbWcxJTJDJTIwaW1nMiU1RCUwQXdlaWdodHMlMjAlM0QlMjAlNUIwLjMlMkMlMjAwLjMlMkMlMjAwLjQlNUQlMEFpbWFnZV9lbWIlMkMlMjB6ZXJvX2ltYWdlX2VtYiUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorEmb2EmbPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function Bs(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function Ns(T){let l,P="Examples:",u,c,w;return c=new De({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXItaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMjIlMjAlMjIlMkZrYW5kaW5za3klMkZjYXQucG5nJTIyJTBBKSUwQSUwQW1hc2slMjAlM0QlMjBucC56ZXJvcygoNzY4JTJDJTIwNzY4KSUyQyUyMGR0eXBlJTNEbnAuZmxvYXQzMiklMEElMjMlMjBMZXQncyUyMG1hc2slMjBvdXQlMjBhbiUyMGFyZWElMjBhYm92ZSUyMHRoZSUyMGNhdCdzJTIwaGVhZCUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRG9yaWdpbmFsX2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`}}),{c(){l=a("p"),l.textContent=P,u=s(),h(c.$$.fragment)},l(o){l=i(o,"P",{"data-svelte-h":!0}),g(l)!=="svelte-kvfsh7"&&(l.textContent=P),u=r(o),_(c.$$.fragment,o)},m(o,M){m(o,l,M),m(o,u,M),b(c,o,M),w=!0},p:ne,i(o){w||(y(c.$$.fragment,o),w=!0)},o(o){k(c.$$.fragment,o),w=!1},d(o){o&&(t(l),t(u)),v(c,o)}}}function Fs(T){let l,P,u,c,w,o,M,Kn,li="Kandinsky 2.2",to,Re,di='Kandinsky 2.2 is created by <a href="https://github.com/cene555" rel="nofollow">Arseniy Shakhmatov</a>, <a href="https://github.com/razzant" rel="nofollow">Anton Razzhigaev</a>, <a href="https://github.com/AlexWortega" rel="nofollow">Aleksandr Nikolich</a>, <a href="https://github.com/oriBetelgeuse" rel="nofollow">Vladimir Arkhipkin</a>, <a href="https://github.com/boomb0om" rel="nofollow">Igor Pavlov</a>, <a href="https://github.com/kuznetsoffandrey" rel="nofollow">Andrey Kuznetsov</a>, and <a href="https://github.com/denndimitrov" rel="nofollow">Denis Dimitrov</a>.',oo,Se,ci="The description from it’s GitHub page is:",ao,Qe,pi="<em>Kandinsky 2.2 brings substantial improvements upon its predecessor, Kandinsky 2.1, by introducing a new, more powerful image encoder - CLIP-ViT-G and the ControlNet support. The switch to CLIP-ViT-G as the image encoder significantly increases the model’s capability to generate more aesthetic pictures and better understand text, thus enhancing the model’s overall performance. The addition of the ControlNet mechanism allows the model to effectively control the process of generating images. This leads to more accurate and visually appealing outputs and opens new possibilities for text-guided image manipulation.</em>",io,Xe,mi='The original codebase can be found at <a href="https://github.com/ai-forever/Kandinsky-2" rel="nofollow">ai-forever/Kandinsky-2</a>.',so,ue,ro,fe,lo,te,he,Nt,ze,No,Wn,gi="KandinskyV22PriorPipeline",co,x,He,Fo,Gn,ui="Pipeline for generating image prior for Kandinsky",Do,En,fi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ro,L,Ye,So,qn,hi="Function invoked when calling the pipeline for generation.",Qo,_e,Xo,B,Ae,zo,Ln,_i="Function invoked when using the prior pipeline for interpolation.",Ho,be,po,oe,ye,Ft,Oe,Yo,Bn,bi="KandinskyV22Pipeline",mo,U,en,Ao,Nn,yi="Pipeline for text-to-image generation using Kandinsky",Oo,Fn,ki=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ea,N,nn,na,Dn,vi="Function invoked when calling the pipeline for generation.",ta,ke,go,ae,ve,Dt,tn,oa,Rn,wi="KandinskyV22CombinedPipeline",uo,V,on,aa,Sn,Mi="Combined Pipeline for text-to-image generation using Kandinsky",ia,Qn,Pi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,sa,F,an,ra,Xn,Ii="Function invoked when calling the pipeline for generation.",la,we,da,Me,sn,ca,zn,Ti=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,fo,ie,Pe,Rt,rn,pa,Hn,Ci="KandinskyV22ControlnetPipeline",ho,$,ln,ma,Yn,xi="Pipeline for text-to-image generation using Kandinsky",ga,An,Vi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ua,D,dn,fa,On,Ji="Function invoked when calling the pipeline for generation.",ha,et,ji="Examples:",_o,se,Ie,St,cn,_a,nt,Ui="KandinskyV22PriorEmb2EmbPipeline",bo,J,pn,ba,tt,$i="Pipeline for generating image prior for Kandinsky",ya,ot,Zi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ka,R,mn,va,at,Ki="Function invoked when calling the pipeline for generation.",wa,Te,Ma,S,gn,Pa,it,Wi="Function invoked when using the prior pipeline for interpolation.",Ia,Ce,yo,re,xe,Qt,un,Ta,st,Gi="KandinskyV22Img2ImgPipeline",ko,Z,fn,Ca,rt,Ei="Pipeline for image-to-image generation using Kandinsky",xa,lt,qi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Va,Q,hn,Ja,dt,Li="Function invoked when calling the pipeline for generation.",ja,ct,Bi="Examples:",vo,le,Ve,Xt,_n,Ua,pt,Ni="KandinskyV22Img2ImgCombinedPipeline",wo,C,bn,$a,mt,Fi="Combined Pipeline for image-to-image generation using Kandinsky",Za,gt,Di=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ka,X,yn,Wa,ut,Ri="Function invoked when calling the pipeline for generation.",Ga,Je,Ea,je,kn,qa,ft,Si=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,La,Ue,vn,Ba,ht,Qi=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Mo,de,$e,zt,wn,Na,_t,Xi="KandinskyV22ControlnetImg2ImgPipeline",Po,K,Mn,Fa,bt,zi="Pipeline for image-to-image generation using Kandinsky",Da,yt,Hi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ra,z,Pn,Sa,kt,Yi="Function invoked when calling the pipeline for generation.",Qa,vt,Ai="Examples:",Io,ce,Ze,Ht,In,Xa,wt,Oi="KandinskyV22InpaintPipeline",To,W,Tn,za,Mt,es="Pipeline for text-guided image inpainting using Kandinsky2.1",Ha,Pt,ns=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ya,H,Cn,Aa,It,ts="Function invoked when calling the pipeline for generation.",Oa,Tt,os="Examples:",Co,pe,Ke,Yt,xn,ei,Ct,as="KandinskyV22InpaintCombinedPipeline",xo,j,Vn,ni,xt,is="Combined Pipeline for inpainting generation using Kandinsky",ti,Vt,ss=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,oi,Y,Jn,ai,Jt,rs="Function invoked when calling the pipeline for generation.",ii,We,si,Ge,jn,ri,jt,ls=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Vo;return o=new q({}),ue=new Cs({props:{$$slots:{default:[$s]},$$scope:{ctx:T}}}),fe=new Cs({props:{$$slots:{default:[Zs]},$$scope:{ctx:T}}}),ze=new q({}),He=new I({props:{name:"class diffusers.KandinskyV22PriorPipeline",anchor:"diffusers.KandinskyV22PriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L84"}}),Ye=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L370",returnType:`
<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),_e=new Fe({props:{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.example",$$slots:{default:[Ks]},$$scope:{ctx:T}}}),Ae=new I({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L131",returnType:`
<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),be=new Fe({props:{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.example",$$slots:{default:[Ws]},$$scope:{ctx:T}}}),Oe=new q({}),en=new I({props:{name:"class diffusers.KandinskyV22Pipeline",anchor:"diffusers.KandinskyV22Pipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Pipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L64"}}),nn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22Pipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L122",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ke=new Fe({props:{anchor:"diffusers.KandinskyV22Pipeline.__call__.example",$$slots:{default:[Gs]},$$scope:{ctx:T}}}),tn=new q({}),on=new I({props:{name:"class diffusers.KandinskyV22CombinedPipeline",anchor:"diffusers.KandinskyV22CombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22CombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L107"}}),an=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22CombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the prior pipeline.
The function is called with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your prior pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the decoder pipeline.
The function is called with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors
as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L201",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),we=new Fe({props:{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.example",$$slots:{default:[Es]},$$scope:{ctx:T}}}),sn=new I({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22CombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L181"}}),rn=new q({}),ln=new I({props:{name:"class diffusers.KandinskyV22ControlnetPipeline",anchor:"diffusers.KandinskyV22ControlnetPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L106"}}),dn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L151",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),cn=new q({}),pn=new I({props:{name:"class diffusers.KandinskyV22PriorEmb2EmbPipeline",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L102"}}),mn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"strength",val:": float = 0.3"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>emb</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added.`,name:"strength"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.emb",description:`<strong>emb</strong> (<code>torch.FloatTensor</code>) &#x2014;
The image embedding.`,name:"emb"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L396",returnType:`
<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),Te=new Fe({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.example",$$slots:{default:[qs]},$$scope:{ctx:T}}}),gn=new I({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L155",returnType:`
<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),Ce=new Fe({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.example",$$slots:{default:[Ls]},$$scope:{ctx:T}}}),un=new q({}),fn=new I({props:{name:"class diffusers.KandinskyV22Img2ImgPipeline",anchor:"diffusers.KandinskyV22Img2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L92"}}),hn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L190",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),_n=new q({}),bn=new I({props:{name:"class diffusers.KandinskyV22Img2ImgCombinedPipeline",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L334"}}),yn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L438",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Je=new Fe({props:{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.example",$$slots:{default:[Bs]},$$scope:{ctx:T}}}),kn=new I({props:{name:"enable_model_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L408"}}),vn=new I({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L418"}}),wn=new q({}),Mn=new I({props:{name:"class diffusers.KandinskyV22ControlnetImg2ImgPipeline",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L120"}}),Pn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L206",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),In=new q({}),Tn=new I({props:{name:"class diffusers.KandinskyV22InpaintPipeline",anchor:"diffusers.KandinskyV22InpaintPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L235"}}),Cn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L294",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),xn=new q({}),Vn=new I({props:{name:"class diffusers.KandinskyV22InpaintCombinedPipeline",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L582"}}),Jn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L676",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),We=new Fe({props:{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.example",$$slots:{default:[Ns]},$$scope:{ctx:T}}}),jn=new I({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L656"}}),{c(){l=a("meta"),P=s(),u=a("h1"),c=a("a"),w=a("span"),h(o.$$.fragment),M=s(),Kn=a("span"),Kn.textContent=li,to=s(),Re=a("p"),Re.innerHTML=di,oo=s(),Se=a("p"),Se.textContent=ci,ao=s(),Qe=a("p"),Qe.innerHTML=pi,io=s(),Xe=a("p"),Xe.innerHTML=mi,so=s(),h(ue.$$.fragment),ro=s(),h(fe.$$.fragment),lo=s(),te=a("h2"),he=a("a"),Nt=a("span"),h(ze.$$.fragment),No=s(),Wn=a("span"),Wn.textContent=gi,co=s(),x=a("div"),h(He.$$.fragment),Fo=s(),Gn=a("p"),Gn.textContent=ui,Do=s(),En=a("p"),En.innerHTML=fi,Ro=s(),L=a("div"),h(Ye.$$.fragment),So=s(),qn=a("p"),qn.textContent=hi,Qo=s(),h(_e.$$.fragment),Xo=s(),B=a("div"),h(Ae.$$.fragment),zo=s(),Ln=a("p"),Ln.textContent=_i,Ho=s(),h(be.$$.fragment),po=s(),oe=a("h2"),ye=a("a"),Ft=a("span"),h(Oe.$$.fragment),Yo=s(),Bn=a("span"),Bn.textContent=bi,mo=s(),U=a("div"),h(en.$$.fragment),Ao=s(),Nn=a("p"),Nn.textContent=yi,Oo=s(),Fn=a("p"),Fn.innerHTML=ki,ea=s(),N=a("div"),h(nn.$$.fragment),na=s(),Dn=a("p"),Dn.textContent=vi,ta=s(),h(ke.$$.fragment),go=s(),ae=a("h2"),ve=a("a"),Dt=a("span"),h(tn.$$.fragment),oa=s(),Rn=a("span"),Rn.textContent=wi,uo=s(),V=a("div"),h(on.$$.fragment),aa=s(),Sn=a("p"),Sn.textContent=Mi,ia=s(),Qn=a("p"),Qn.innerHTML=Pi,sa=s(),F=a("div"),h(an.$$.fragment),ra=s(),Xn=a("p"),Xn.textContent=Ii,la=s(),h(we.$$.fragment),da=s(),Me=a("div"),h(sn.$$.fragment),ca=s(),zn=a("p"),zn.innerHTML=Ti,fo=s(),ie=a("h2"),Pe=a("a"),Rt=a("span"),h(rn.$$.fragment),pa=s(),Hn=a("span"),Hn.textContent=Ci,ho=s(),$=a("div"),h(ln.$$.fragment),ma=s(),Yn=a("p"),Yn.textContent=xi,ga=s(),An=a("p"),An.innerHTML=Vi,ua=s(),D=a("div"),h(dn.$$.fragment),fa=s(),On=a("p"),On.textContent=Ji,ha=s(),et=a("p"),et.textContent=ji,_o=s(),se=a("h2"),Ie=a("a"),St=a("span"),h(cn.$$.fragment),_a=s(),nt=a("span"),nt.textContent=Ui,bo=s(),J=a("div"),h(pn.$$.fragment),ba=s(),tt=a("p"),tt.textContent=$i,ya=s(),ot=a("p"),ot.innerHTML=Zi,ka=s(),R=a("div"),h(mn.$$.fragment),va=s(),at=a("p"),at.textContent=Ki,wa=s(),h(Te.$$.fragment),Ma=s(),S=a("div"),h(gn.$$.fragment),Pa=s(),it=a("p"),it.textContent=Wi,Ia=s(),h(Ce.$$.fragment),yo=s(),re=a("h2"),xe=a("a"),Qt=a("span"),h(un.$$.fragment),Ta=s(),st=a("span"),st.textContent=Gi,ko=s(),Z=a("div"),h(fn.$$.fragment),Ca=s(),rt=a("p"),rt.textContent=Ei,xa=s(),lt=a("p"),lt.innerHTML=qi,Va=s(),Q=a("div"),h(hn.$$.fragment),Ja=s(),dt=a("p"),dt.textContent=Li,ja=s(),ct=a("p"),ct.textContent=Bi,vo=s(),le=a("h2"),Ve=a("a"),Xt=a("span"),h(_n.$$.fragment),Ua=s(),pt=a("span"),pt.textContent=Ni,wo=s(),C=a("div"),h(bn.$$.fragment),$a=s(),mt=a("p"),mt.textContent=Fi,Za=s(),gt=a("p"),gt.innerHTML=Di,Ka=s(),X=a("div"),h(yn.$$.fragment),Wa=s(),ut=a("p"),ut.textContent=Ri,Ga=s(),h(Je.$$.fragment),Ea=s(),je=a("div"),h(kn.$$.fragment),qa=s(),ft=a("p"),ft.innerHTML=Si,La=s(),Ue=a("div"),h(vn.$$.fragment),Ba=s(),ht=a("p"),ht.innerHTML=Qi,Mo=s(),de=a("h2"),$e=a("a"),zt=a("span"),h(wn.$$.fragment),Na=s(),_t=a("span"),_t.textContent=Xi,Po=s(),K=a("div"),h(Mn.$$.fragment),Fa=s(),bt=a("p"),bt.textContent=zi,Da=s(),yt=a("p"),yt.innerHTML=Hi,Ra=s(),z=a("div"),h(Pn.$$.fragment),Sa=s(),kt=a("p"),kt.textContent=Yi,Qa=s(),vt=a("p"),vt.textContent=Ai,Io=s(),ce=a("h2"),Ze=a("a"),Ht=a("span"),h(In.$$.fragment),Xa=s(),wt=a("span"),wt.textContent=Oi,To=s(),W=a("div"),h(Tn.$$.fragment),za=s(),Mt=a("p"),Mt.textContent=es,Ha=s(),Pt=a("p"),Pt.innerHTML=ns,Ya=s(),H=a("div"),h(Cn.$$.fragment),Aa=s(),It=a("p"),It.textContent=ts,Oa=s(),Tt=a("p"),Tt.textContent=os,Co=s(),pe=a("h2"),Ke=a("a"),Yt=a("span"),h(xn.$$.fragment),ei=s(),Ct=a("span"),Ct.textContent=as,xo=s(),j=a("div"),h(Vn.$$.fragment),ni=s(),xt=a("p"),xt.textContent=is,ti=s(),Vt=a("p"),Vt.innerHTML=ss,oi=s(),Y=a("div"),h(Jn.$$.fragment),ai=s(),Jt=a("p"),Jt.textContent=rs,ii=s(),h(We.$$.fragment),si=s(),Ge=a("div"),h(jn.$$.fragment),ri=s(),jt=a("p"),jt.innerHTML=ls,this.h()},l(e){const d=Us("svelte-1phssyn",document.head);l=i(d,"META",{name:!0,content:!0}),d.forEach(t),P=r(e),u=i(e,"H1",{class:!0});var Un=f(u);c=i(Un,"A",{id:!0,class:!0,href:!0});var At=f(c);w=i(At,"SPAN",{});var Ot=f(w);_(o.$$.fragment,Ot),Ot.forEach(t),At.forEach(t),M=r(Un),Kn=i(Un,"SPAN",{"data-svelte-h":!0}),g(Kn)!=="svelte-12daj4v"&&(Kn.textContent=li),Un.forEach(t),to=r(e),Re=i(e,"P",{"data-svelte-h":!0}),g(Re)!=="svelte-1a9feuc"&&(Re.innerHTML=di),oo=r(e),Se=i(e,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-1og8lwg"&&(Se.textContent=ci),ao=r(e),Qe=i(e,"P",{"data-svelte-h":!0}),g(Qe)!=="svelte-xseaz5"&&(Qe.innerHTML=pi),io=r(e),Xe=i(e,"P",{"data-svelte-h":!0}),g(Xe)!=="svelte-14rg3yz"&&(Xe.innerHTML=mi),so=r(e),_(ue.$$.fragment,e),ro=r(e),_(fe.$$.fragment,e),lo=r(e),te=i(e,"H2",{class:!0});var $n=f(te);he=i($n,"A",{id:!0,class:!0,href:!0});var eo=f(he);Nt=i(eo,"SPAN",{});var no=f(Nt);_(ze.$$.fragment,no),no.forEach(t),eo.forEach(t),No=r($n),Wn=i($n,"SPAN",{"data-svelte-h":!0}),g(Wn)!=="svelte-ajppxd"&&(Wn.textContent=gi),$n.forEach(t),co=r(e),x=i(e,"DIV",{class:!0});var G=f(x);_(He.$$.fragment,G),Fo=r(G),Gn=i(G,"P",{"data-svelte-h":!0}),g(Gn)!=="svelte-gfz7tn"&&(Gn.textContent=ui),Do=r(G),En=i(G,"P",{"data-svelte-h":!0}),g(En)!=="svelte-wu1jmh"&&(En.innerHTML=fi),Ro=r(G),L=i(G,"DIV",{class:!0});var me=f(L);_(Ye.$$.fragment,me),So=r(me),qn=i(me,"P",{"data-svelte-h":!0}),g(qn)!=="svelte-v78lg8"&&(qn.textContent=hi),Qo=r(me),_(_e.$$.fragment,me),me.forEach(t),Xo=r(G),B=i(G,"DIV",{class:!0});var ge=f(B);_(Ae.$$.fragment,ge),zo=r(ge),Ln=i(ge,"P",{"data-svelte-h":!0}),g(Ln)!=="svelte-1k7d7q8"&&(Ln.textContent=_i),Ho=r(ge),_(be.$$.fragment,ge),ge.forEach(t),G.forEach(t),po=r(e),oe=i(e,"H2",{class:!0});var Zn=f(oe);ye=i(Zn,"A",{id:!0,class:!0,href:!0});var ds=f(ye);Ft=i(ds,"SPAN",{});var cs=f(Ft);_(Oe.$$.fragment,cs),cs.forEach(t),ds.forEach(t),Yo=r(Zn),Bn=i(Zn,"SPAN",{"data-svelte-h":!0}),g(Bn)!=="svelte-uqvz9z"&&(Bn.textContent=bi),Zn.forEach(t),mo=r(e),U=i(e,"DIV",{class:!0});var Ee=f(U);_(en.$$.fragment,Ee),Ao=r(Ee),Nn=i(Ee,"P",{"data-svelte-h":!0}),g(Nn)!=="svelte-jhhofy"&&(Nn.textContent=yi),Oo=r(Ee),Fn=i(Ee,"P",{"data-svelte-h":!0}),g(Fn)!=="svelte-wu1jmh"&&(Fn.innerHTML=ki),ea=r(Ee),N=i(Ee,"DIV",{class:!0});var Ut=f(N);_(nn.$$.fragment,Ut),na=r(Ut),Dn=i(Ut,"P",{"data-svelte-h":!0}),g(Dn)!=="svelte-v78lg8"&&(Dn.textContent=vi),ta=r(Ut),_(ke.$$.fragment,Ut),Ut.forEach(t),Ee.forEach(t),go=r(e),ae=i(e,"H2",{class:!0});var Jo=f(ae);ve=i(Jo,"A",{id:!0,class:!0,href:!0});var ps=f(ve);Dt=i(ps,"SPAN",{});var ms=f(Dt);_(tn.$$.fragment,ms),ms.forEach(t),ps.forEach(t),oa=r(Jo),Rn=i(Jo,"SPAN",{"data-svelte-h":!0}),g(Rn)!=="svelte-1oy5hbi"&&(Rn.textContent=wi),Jo.forEach(t),uo=r(e),V=i(e,"DIV",{class:!0});var A=f(V);_(on.$$.fragment,A),aa=r(A),Sn=i(A,"P",{"data-svelte-h":!0}),g(Sn)!=="svelte-1spbql3"&&(Sn.textContent=Mi),ia=r(A),Qn=i(A,"P",{"data-svelte-h":!0}),g(Qn)!=="svelte-wu1jmh"&&(Qn.innerHTML=Pi),sa=r(A),F=i(A,"DIV",{class:!0});var $t=f(F);_(an.$$.fragment,$t),ra=r($t),Xn=i($t,"P",{"data-svelte-h":!0}),g(Xn)!=="svelte-v78lg8"&&(Xn.textContent=Ii),la=r($t),_(we.$$.fragment,$t),$t.forEach(t),da=r(A),Me=i(A,"DIV",{class:!0});var jo=f(Me);_(sn.$$.fragment,jo),ca=r(jo),zn=i(jo,"P",{"data-svelte-h":!0}),g(zn)!=="svelte-1ff7ilh"&&(zn.innerHTML=Ti),jo.forEach(t),A.forEach(t),fo=r(e),ie=i(e,"H2",{class:!0});var Uo=f(ie);Pe=i(Uo,"A",{id:!0,class:!0,href:!0});var gs=f(Pe);Rt=i(gs,"SPAN",{});var us=f(Rt);_(rn.$$.fragment,us),us.forEach(t),gs.forEach(t),pa=r(Uo),Hn=i(Uo,"SPAN",{"data-svelte-h":!0}),g(Hn)!=="svelte-ulcnpn"&&(Hn.textContent=Ci),Uo.forEach(t),ho=r(e),$=i(e,"DIV",{class:!0});var qe=f($);_(ln.$$.fragment,qe),ma=r(qe),Yn=i(qe,"P",{"data-svelte-h":!0}),g(Yn)!=="svelte-jhhofy"&&(Yn.textContent=xi),ga=r(qe),An=i(qe,"P",{"data-svelte-h":!0}),g(An)!=="svelte-wu1jmh"&&(An.innerHTML=Vi),ua=r(qe),D=i(qe,"DIV",{class:!0});var Zt=f(D);_(dn.$$.fragment,Zt),fa=r(Zt),On=i(Zt,"P",{"data-svelte-h":!0}),g(On)!=="svelte-v78lg8"&&(On.textContent=Ji),ha=r(Zt),et=i(Zt,"P",{"data-svelte-h":!0}),g(et)!=="svelte-kvfsh7"&&(et.textContent=ji),Zt.forEach(t),qe.forEach(t),_o=r(e),se=i(e,"H2",{class:!0});var $o=f(se);Ie=i($o,"A",{id:!0,class:!0,href:!0});var fs=f(Ie);St=i(fs,"SPAN",{});var hs=f(St);_(cn.$$.fragment,hs),hs.forEach(t),fs.forEach(t),_a=r($o),nt=i($o,"SPAN",{"data-svelte-h":!0}),g(nt)!=="svelte-35qtap"&&(nt.textContent=Ui),$o.forEach(t),bo=r(e),J=i(e,"DIV",{class:!0});var O=f(J);_(pn.$$.fragment,O),ba=r(O),tt=i(O,"P",{"data-svelte-h":!0}),g(tt)!=="svelte-gfz7tn"&&(tt.textContent=$i),ya=r(O),ot=i(O,"P",{"data-svelte-h":!0}),g(ot)!=="svelte-wu1jmh"&&(ot.innerHTML=Zi),ka=r(O),R=i(O,"DIV",{class:!0});var Kt=f(R);_(mn.$$.fragment,Kt),va=r(Kt),at=i(Kt,"P",{"data-svelte-h":!0}),g(at)!=="svelte-v78lg8"&&(at.textContent=Ki),wa=r(Kt),_(Te.$$.fragment,Kt),Kt.forEach(t),Ma=r(O),S=i(O,"DIV",{class:!0});var Wt=f(S);_(gn.$$.fragment,Wt),Pa=r(Wt),it=i(Wt,"P",{"data-svelte-h":!0}),g(it)!=="svelte-1k7d7q8"&&(it.textContent=Wi),Ia=r(Wt),_(Ce.$$.fragment,Wt),Wt.forEach(t),O.forEach(t),yo=r(e),re=i(e,"H2",{class:!0});var Zo=f(re);xe=i(Zo,"A",{id:!0,class:!0,href:!0});var _s=f(xe);Qt=i(_s,"SPAN",{});var bs=f(Qt);_(un.$$.fragment,bs),bs.forEach(t),_s.forEach(t),Ta=r(Zo),st=i(Zo,"SPAN",{"data-svelte-h":!0}),g(st)!=="svelte-1u871af"&&(st.textContent=Gi),Zo.forEach(t),ko=r(e),Z=i(e,"DIV",{class:!0});var Le=f(Z);_(fn.$$.fragment,Le),Ca=r(Le),rt=i(Le,"P",{"data-svelte-h":!0}),g(rt)!=="svelte-1nm2rj2"&&(rt.textContent=Ei),xa=r(Le),lt=i(Le,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-wu1jmh"&&(lt.innerHTML=qi),Va=r(Le),Q=i(Le,"DIV",{class:!0});var Gt=f(Q);_(hn.$$.fragment,Gt),Ja=r(Gt),dt=i(Gt,"P",{"data-svelte-h":!0}),g(dt)!=="svelte-v78lg8"&&(dt.textContent=Li),ja=r(Gt),ct=i(Gt,"P",{"data-svelte-h":!0}),g(ct)!=="svelte-kvfsh7"&&(ct.textContent=Bi),Gt.forEach(t),Le.forEach(t),vo=r(e),le=i(e,"H2",{class:!0});var Ko=f(le);Ve=i(Ko,"A",{id:!0,class:!0,href:!0});var ys=f(Ve);Xt=i(ys,"SPAN",{});var ks=f(Xt);_(_n.$$.fragment,ks),ks.forEach(t),ys.forEach(t),Ua=r(Ko),pt=i(Ko,"SPAN",{"data-svelte-h":!0}),g(pt)!=="svelte-kh8lxg"&&(pt.textContent=Ni),Ko.forEach(t),wo=r(e),C=i(e,"DIV",{class:!0});var E=f(C);_(bn.$$.fragment,E),$a=r(E),mt=i(E,"P",{"data-svelte-h":!0}),g(mt)!=="svelte-1ql3mrb"&&(mt.textContent=Fi),Za=r(E),gt=i(E,"P",{"data-svelte-h":!0}),g(gt)!=="svelte-wu1jmh"&&(gt.innerHTML=Di),Ka=r(E),X=i(E,"DIV",{class:!0});var Et=f(X);_(yn.$$.fragment,Et),Wa=r(Et),ut=i(Et,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-v78lg8"&&(ut.textContent=Ri),Ga=r(Et),_(Je.$$.fragment,Et),Et.forEach(t),Ea=r(E),je=i(E,"DIV",{class:!0});var Wo=f(je);_(kn.$$.fragment,Wo),qa=r(Wo),ft=i(Wo,"P",{"data-svelte-h":!0}),g(ft)!=="svelte-d7vywi"&&(ft.innerHTML=Si),Wo.forEach(t),La=r(E),Ue=i(E,"DIV",{class:!0});var Go=f(Ue);_(vn.$$.fragment,Go),Ba=r(Go),ht=i(Go,"P",{"data-svelte-h":!0}),g(ht)!=="svelte-1ff7ilh"&&(ht.innerHTML=Qi),Go.forEach(t),E.forEach(t),Mo=r(e),de=i(e,"H2",{class:!0});var Eo=f(de);$e=i(Eo,"A",{id:!0,class:!0,href:!0});var vs=f($e);zt=i(vs,"SPAN",{});var ws=f(zt);_(wn.$$.fragment,ws),ws.forEach(t),vs.forEach(t),Na=r(Eo),_t=i(Eo,"SPAN",{"data-svelte-h":!0}),g(_t)!=="svelte-1xn2iqj"&&(_t.textContent=Xi),Eo.forEach(t),Po=r(e),K=i(e,"DIV",{class:!0});var Be=f(K);_(Mn.$$.fragment,Be),Fa=r(Be),bt=i(Be,"P",{"data-svelte-h":!0}),g(bt)!=="svelte-1nm2rj2"&&(bt.textContent=zi),Da=r(Be),yt=i(Be,"P",{"data-svelte-h":!0}),g(yt)!=="svelte-wu1jmh"&&(yt.innerHTML=Hi),Ra=r(Be),z=i(Be,"DIV",{class:!0});var qt=f(z);_(Pn.$$.fragment,qt),Sa=r(qt),kt=i(qt,"P",{"data-svelte-h":!0}),g(kt)!=="svelte-v78lg8"&&(kt.textContent=Yi),Qa=r(qt),vt=i(qt,"P",{"data-svelte-h":!0}),g(vt)!=="svelte-kvfsh7"&&(vt.textContent=Ai),qt.forEach(t),Be.forEach(t),Io=r(e),ce=i(e,"H2",{class:!0});var qo=f(ce);Ze=i(qo,"A",{id:!0,class:!0,href:!0});var Ms=f(Ze);Ht=i(Ms,"SPAN",{});var Ps=f(Ht);_(In.$$.fragment,Ps),Ps.forEach(t),Ms.forEach(t),Xa=r(qo),wt=i(qo,"SPAN",{"data-svelte-h":!0}),g(wt)!=="svelte-1csqpos"&&(wt.textContent=Oi),qo.forEach(t),To=r(e),W=i(e,"DIV",{class:!0});var Ne=f(W);_(Tn.$$.fragment,Ne),za=r(Ne),Mt=i(Ne,"P",{"data-svelte-h":!0}),g(Mt)!=="svelte-2p9m8a"&&(Mt.textContent=es),Ha=r(Ne),Pt=i(Ne,"P",{"data-svelte-h":!0}),g(Pt)!=="svelte-wu1jmh"&&(Pt.innerHTML=ns),Ya=r(Ne),H=i(Ne,"DIV",{class:!0});var Lt=f(H);_(Cn.$$.fragment,Lt),Aa=r(Lt),It=i(Lt,"P",{"data-svelte-h":!0}),g(It)!=="svelte-v78lg8"&&(It.textContent=ts),Oa=r(Lt),Tt=i(Lt,"P",{"data-svelte-h":!0}),g(Tt)!=="svelte-kvfsh7"&&(Tt.textContent=os),Lt.forEach(t),Ne.forEach(t),Co=r(e),pe=i(e,"H2",{class:!0});var Lo=f(pe);Ke=i(Lo,"A",{id:!0,class:!0,href:!0});var Is=f(Ke);Yt=i(Is,"SPAN",{});var Ts=f(Yt);_(xn.$$.fragment,Ts),Ts.forEach(t),Is.forEach(t),ei=r(Lo),Ct=i(Lo,"SPAN",{"data-svelte-h":!0}),g(Ct)!=="svelte-1rpiq53"&&(Ct.textContent=as),Lo.forEach(t),xo=r(e),j=i(e,"DIV",{class:!0});var ee=f(j);_(Vn.$$.fragment,ee),ni=r(ee),xt=i(ee,"P",{"data-svelte-h":!0}),g(xt)!=="svelte-ydcvxp"&&(xt.textContent=is),ti=r(ee),Vt=i(ee,"P",{"data-svelte-h":!0}),g(Vt)!=="svelte-wu1jmh"&&(Vt.innerHTML=ss),oi=r(ee),Y=i(ee,"DIV",{class:!0});var Bt=f(Y);_(Jn.$$.fragment,Bt),ai=r(Bt),Jt=i(Bt,"P",{"data-svelte-h":!0}),g(Jt)!=="svelte-v78lg8"&&(Jt.textContent=rs),ii=r(Bt),_(We.$$.fragment,Bt),Bt.forEach(t),si=r(ee),Ge=i(ee,"DIV",{class:!0});var Bo=f(Ge);_(jn.$$.fragment,Bo),ri=r(Bo),jt=i(Bo,"P",{"data-svelte-h":!0}),g(jt)!=="svelte-1ff7ilh"&&(jt.innerHTML=ls),Bo.forEach(t),ee.forEach(t),this.h()},h(){p(l,"name","hf:doc:metadata"),p(l,"content",JSON.stringify(Ds)),p(c,"id","kandinsky-22"),p(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(c,"href","#kandinsky-22"),p(u,"class","relative group"),p(he,"id","diffusers.KandinskyV22PriorPipeline"),p(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(he,"href","#diffusers.KandinskyV22PriorPipeline"),p(te,"class","relative group"),p(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ye,"id","diffusers.KandinskyV22Pipeline"),p(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ye,"href","#diffusers.KandinskyV22Pipeline"),p(oe,"class","relative group"),p(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ve,"id","diffusers.KandinskyV22CombinedPipeline"),p(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ve,"href","#diffusers.KandinskyV22CombinedPipeline"),p(ae,"class","relative group"),p(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Pe,"id","diffusers.KandinskyV22ControlnetPipeline"),p(Pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Pe,"href","#diffusers.KandinskyV22ControlnetPipeline"),p(ie,"class","relative group"),p(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Ie,"id","diffusers.KandinskyV22PriorEmb2EmbPipeline"),p(Ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ie,"href","#diffusers.KandinskyV22PriorEmb2EmbPipeline"),p(se,"class","relative group"),p(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(xe,"id","diffusers.KandinskyV22Img2ImgPipeline"),p(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(xe,"href","#diffusers.KandinskyV22Img2ImgPipeline"),p(re,"class","relative group"),p(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Ve,"id","diffusers.KandinskyV22Img2ImgCombinedPipeline"),p(Ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ve,"href","#diffusers.KandinskyV22Img2ImgCombinedPipeline"),p(le,"class","relative group"),p(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p($e,"id","diffusers.KandinskyV22ControlnetImg2ImgPipeline"),p($e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($e,"href","#diffusers.KandinskyV22ControlnetImg2ImgPipeline"),p(de,"class","relative group"),p(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Ze,"id","diffusers.KandinskyV22InpaintPipeline"),p(Ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ze,"href","#diffusers.KandinskyV22InpaintPipeline"),p(ce,"class","relative group"),p(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Ke,"id","diffusers.KandinskyV22InpaintCombinedPipeline"),p(Ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Ke,"href","#diffusers.KandinskyV22InpaintCombinedPipeline"),p(pe,"class","relative group"),p(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){n(document.head,l),m(e,P,d),m(e,u,d),n(u,c),n(c,w),b(o,w,null),n(u,M),n(u,Kn),m(e,to,d),m(e,Re,d),m(e,oo,d),m(e,Se,d),m(e,ao,d),m(e,Qe,d),m(e,io,d),m(e,Xe,d),m(e,so,d),b(ue,e,d),m(e,ro,d),b(fe,e,d),m(e,lo,d),m(e,te,d),n(te,he),n(he,Nt),b(ze,Nt,null),n(te,No),n(te,Wn),m(e,co,d),m(e,x,d),b(He,x,null),n(x,Fo),n(x,Gn),n(x,Do),n(x,En),n(x,Ro),n(x,L),b(Ye,L,null),n(L,So),n(L,qn),n(L,Qo),b(_e,L,null),n(x,Xo),n(x,B),b(Ae,B,null),n(B,zo),n(B,Ln),n(B,Ho),b(be,B,null),m(e,po,d),m(e,oe,d),n(oe,ye),n(ye,Ft),b(Oe,Ft,null),n(oe,Yo),n(oe,Bn),m(e,mo,d),m(e,U,d),b(en,U,null),n(U,Ao),n(U,Nn),n(U,Oo),n(U,Fn),n(U,ea),n(U,N),b(nn,N,null),n(N,na),n(N,Dn),n(N,ta),b(ke,N,null),m(e,go,d),m(e,ae,d),n(ae,ve),n(ve,Dt),b(tn,Dt,null),n(ae,oa),n(ae,Rn),m(e,uo,d),m(e,V,d),b(on,V,null),n(V,aa),n(V,Sn),n(V,ia),n(V,Qn),n(V,sa),n(V,F),b(an,F,null),n(F,ra),n(F,Xn),n(F,la),b(we,F,null),n(V,da),n(V,Me),b(sn,Me,null),n(Me,ca),n(Me,zn),m(e,fo,d),m(e,ie,d),n(ie,Pe),n(Pe,Rt),b(rn,Rt,null),n(ie,pa),n(ie,Hn),m(e,ho,d),m(e,$,d),b(ln,$,null),n($,ma),n($,Yn),n($,ga),n($,An),n($,ua),n($,D),b(dn,D,null),n(D,fa),n(D,On),n(D,ha),n(D,et),m(e,_o,d),m(e,se,d),n(se,Ie),n(Ie,St),b(cn,St,null),n(se,_a),n(se,nt),m(e,bo,d),m(e,J,d),b(pn,J,null),n(J,ba),n(J,tt),n(J,ya),n(J,ot),n(J,ka),n(J,R),b(mn,R,null),n(R,va),n(R,at),n(R,wa),b(Te,R,null),n(J,Ma),n(J,S),b(gn,S,null),n(S,Pa),n(S,it),n(S,Ia),b(Ce,S,null),m(e,yo,d),m(e,re,d),n(re,xe),n(xe,Qt),b(un,Qt,null),n(re,Ta),n(re,st),m(e,ko,d),m(e,Z,d),b(fn,Z,null),n(Z,Ca),n(Z,rt),n(Z,xa),n(Z,lt),n(Z,Va),n(Z,Q),b(hn,Q,null),n(Q,Ja),n(Q,dt),n(Q,ja),n(Q,ct),m(e,vo,d),m(e,le,d),n(le,Ve),n(Ve,Xt),b(_n,Xt,null),n(le,Ua),n(le,pt),m(e,wo,d),m(e,C,d),b(bn,C,null),n(C,$a),n(C,mt),n(C,Za),n(C,gt),n(C,Ka),n(C,X),b(yn,X,null),n(X,Wa),n(X,ut),n(X,Ga),b(Je,X,null),n(C,Ea),n(C,je),b(kn,je,null),n(je,qa),n(je,ft),n(C,La),n(C,Ue),b(vn,Ue,null),n(Ue,Ba),n(Ue,ht),m(e,Mo,d),m(e,de,d),n(de,$e),n($e,zt),b(wn,zt,null),n(de,Na),n(de,_t),m(e,Po,d),m(e,K,d),b(Mn,K,null),n(K,Fa),n(K,bt),n(K,Da),n(K,yt),n(K,Ra),n(K,z),b(Pn,z,null),n(z,Sa),n(z,kt),n(z,Qa),n(z,vt),m(e,Io,d),m(e,ce,d),n(ce,Ze),n(Ze,Ht),b(In,Ht,null),n(ce,Xa),n(ce,wt),m(e,To,d),m(e,W,d),b(Tn,W,null),n(W,za),n(W,Mt),n(W,Ha),n(W,Pt),n(W,Ya),n(W,H),b(Cn,H,null),n(H,Aa),n(H,It),n(H,Oa),n(H,Tt),m(e,Co,d),m(e,pe,d),n(pe,Ke),n(Ke,Yt),b(xn,Yt,null),n(pe,ei),n(pe,Ct),m(e,xo,d),m(e,j,d),b(Vn,j,null),n(j,ni),n(j,xt),n(j,ti),n(j,Vt),n(j,oi),n(j,Y),b(Jn,Y,null),n(Y,ai),n(Y,Jt),n(Y,ii),b(We,Y,null),n(j,si),n(j,Ge),b(jn,Ge,null),n(Ge,ri),n(Ge,jt),Vo=!0},p(e,[d]){const Un={};d&2&&(Un.$$scope={dirty:d,ctx:e}),ue.$set(Un);const At={};d&2&&(At.$$scope={dirty:d,ctx:e}),fe.$set(At);const Ot={};d&2&&(Ot.$$scope={dirty:d,ctx:e}),_e.$set(Ot);const $n={};d&2&&($n.$$scope={dirty:d,ctx:e}),be.$set($n);const eo={};d&2&&(eo.$$scope={dirty:d,ctx:e}),ke.$set(eo);const no={};d&2&&(no.$$scope={dirty:d,ctx:e}),we.$set(no);const G={};d&2&&(G.$$scope={dirty:d,ctx:e}),Te.$set(G);const me={};d&2&&(me.$$scope={dirty:d,ctx:e}),Ce.$set(me);const ge={};d&2&&(ge.$$scope={dirty:d,ctx:e}),Je.$set(ge);const Zn={};d&2&&(Zn.$$scope={dirty:d,ctx:e}),We.$set(Zn)},i(e){Vo||(y(o.$$.fragment,e),y(ue.$$.fragment,e),y(fe.$$.fragment,e),y(ze.$$.fragment,e),y(He.$$.fragment,e),y(Ye.$$.fragment,e),y(_e.$$.fragment,e),y(Ae.$$.fragment,e),y(be.$$.fragment,e),y(Oe.$$.fragment,e),y(en.$$.fragment,e),y(nn.$$.fragment,e),y(ke.$$.fragment,e),y(tn.$$.fragment,e),y(on.$$.fragment,e),y(an.$$.fragment,e),y(we.$$.fragment,e),y(sn.$$.fragment,e),y(rn.$$.fragment,e),y(ln.$$.fragment,e),y(dn.$$.fragment,e),y(cn.$$.fragment,e),y(pn.$$.fragment,e),y(mn.$$.fragment,e),y(Te.$$.fragment,e),y(gn.$$.fragment,e),y(Ce.$$.fragment,e),y(un.$$.fragment,e),y(fn.$$.fragment,e),y(hn.$$.fragment,e),y(_n.$$.fragment,e),y(bn.$$.fragment,e),y(yn.$$.fragment,e),y(Je.$$.fragment,e),y(kn.$$.fragment,e),y(vn.$$.fragment,e),y(wn.$$.fragment,e),y(Mn.$$.fragment,e),y(Pn.$$.fragment,e),y(In.$$.fragment,e),y(Tn.$$.fragment,e),y(Cn.$$.fragment,e),y(xn.$$.fragment,e),y(Vn.$$.fragment,e),y(Jn.$$.fragment,e),y(We.$$.fragment,e),y(jn.$$.fragment,e),Vo=!0)},o(e){k(o.$$.fragment,e),k(ue.$$.fragment,e),k(fe.$$.fragment,e),k(ze.$$.fragment,e),k(He.$$.fragment,e),k(Ye.$$.fragment,e),k(_e.$$.fragment,e),k(Ae.$$.fragment,e),k(be.$$.fragment,e),k(Oe.$$.fragment,e),k(en.$$.fragment,e),k(nn.$$.fragment,e),k(ke.$$.fragment,e),k(tn.$$.fragment,e),k(on.$$.fragment,e),k(an.$$.fragment,e),k(we.$$.fragment,e),k(sn.$$.fragment,e),k(rn.$$.fragment,e),k(ln.$$.fragment,e),k(dn.$$.fragment,e),k(cn.$$.fragment,e),k(pn.$$.fragment,e),k(mn.$$.fragment,e),k(Te.$$.fragment,e),k(gn.$$.fragment,e),k(Ce.$$.fragment,e),k(un.$$.fragment,e),k(fn.$$.fragment,e),k(hn.$$.fragment,e),k(_n.$$.fragment,e),k(bn.$$.fragment,e),k(yn.$$.fragment,e),k(Je.$$.fragment,e),k(kn.$$.fragment,e),k(vn.$$.fragment,e),k(wn.$$.fragment,e),k(Mn.$$.fragment,e),k(Pn.$$.fragment,e),k(In.$$.fragment,e),k(Tn.$$.fragment,e),k(Cn.$$.fragment,e),k(xn.$$.fragment,e),k(Vn.$$.fragment,e),k(Jn.$$.fragment,e),k(We.$$.fragment,e),k(jn.$$.fragment,e),Vo=!1},d(e){e&&(t(P),t(u),t(to),t(Re),t(oo),t(Se),t(ao),t(Qe),t(io),t(Xe),t(so),t(ro),t(lo),t(te),t(co),t(x),t(po),t(oe),t(mo),t(U),t(go),t(ae),t(uo),t(V),t(fo),t(ie),t(ho),t($),t(_o),t(se),t(bo),t(J),t(yo),t(re),t(ko),t(Z),t(vo),t(le),t(wo),t(C),t(Mo),t(de),t(Po),t(K),t(Io),t(ce),t(To),t(W),t(Co),t(pe),t(xo),t(j)),t(l),v(o),v(ue,e),v(fe,e),v(ze),v(He),v(Ye),v(_e),v(Ae),v(be),v(Oe),v(en),v(nn),v(ke),v(tn),v(on),v(an),v(we),v(sn),v(rn),v(ln),v(dn),v(cn),v(pn),v(mn),v(Te),v(gn),v(Ce),v(un),v(fn),v(hn),v(_n),v(bn),v(yn),v(Je),v(kn),v(vn),v(wn),v(Mn),v(Pn),v(In),v(Tn),v(Cn),v(xn),v(Vn),v(Jn),v(We),v(jn)}}}const Ds={local:"kandinsky-22",sections:[{local:"diffusers.KandinskyV22PriorPipeline",title:"KandinskyV22PriorPipeline"},{local:"diffusers.KandinskyV22Pipeline",title:"KandinskyV22Pipeline"},{local:"diffusers.KandinskyV22CombinedPipeline",title:"KandinskyV22CombinedPipeline"},{local:"diffusers.KandinskyV22ControlnetPipeline",title:"KandinskyV22ControlnetPipeline"},{local:"diffusers.KandinskyV22PriorEmb2EmbPipeline",title:"KandinskyV22PriorEmb2EmbPipeline"},{local:"diffusers.KandinskyV22Img2ImgPipeline",title:"KandinskyV22Img2ImgPipeline"},{local:"diffusers.KandinskyV22Img2ImgCombinedPipeline",title:"KandinskyV22Img2ImgCombinedPipeline"},{local:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",title:"KandinskyV22ControlnetImg2ImgPipeline"},{local:"diffusers.KandinskyV22InpaintPipeline",title:"KandinskyV22InpaintPipeline"},{local:"diffusers.KandinskyV22InpaintCombinedPipeline",title:"KandinskyV22InpaintCombinedPipeline"}],title:"Kandinsky 2.2"};function Rs(T){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Os extends Js{constructor(l){super(),js(this,l,Rs,Fs,xs,{})}}export{Os as component};
