import{s as es,o as ts,n as Ln}from"../chunks/scheduler.182ea377.js";import{S as ns,i as as,g as a,s as l,p as u,A as ss,h as s,f as t,c as o,j as c,q as h,m as d,k as p,v as n,a as r,r as g,d as M,t as b,u as y}from"../chunks/index.008d68e4.js";import{T as Ka}from"../chunks/Tip.4f096367.js";import{D as Z}from"../chunks/Docstring.7aec8b85.js";import{C as Jt}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as E}from"../chunks/IconCopyLink.96bbb92b.js";import{E as is}from"../chunks/ExampleCodeBlock.23e54afe.js";function ls(D){let m,J="AnimateDiff tends to work better with finetuned Stable Diffusion models. If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the AnimateDiff checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){m=a("p"),m.innerHTML=J},l(w){m=s(w,"P",{"data-svelte-h":!0}),d(m)!=="svelte-vnv4xn"&&(m.innerHTML=J)},m(w,T){r(w,m,T)},p:Ln,d(w){w&&t(m)}}}function os(D){let m,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){m=a("p"),m.innerHTML=J},l(w){m=s(w,"P",{"data-svelte-h":!0}),d(m)!=="svelte-1wmc0l4"&&(m.innerHTML=J)},m(w,T){r(w,m,T)},p:Ln,d(w){w&&t(m)}}}function rs(D){let m,J="Examples:",w,T,U;return T=new Jt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJmcmFua2pvc2h1YSUyRnRvb255b3VfYmV0YTYlMjIlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIlMkMlMjBzdGVwc19vZmZzZXQlM0QxJTJDJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSklMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCUyMkElMjBjb3JnaSUyMHdhbGtpbmclMjBpbiUyMHRoZSUyMHBhcmslMjIpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler(beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>, steps_offset=<span class="hljs-number">1</span>, clip_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt=<span class="hljs-string">&quot;A corgi walking in the park&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`}}),{c(){m=a("p"),m.textContent=J,w=l(),u(T.$$.fragment)},l(v){m=s(v,"P",{"data-svelte-h":!0}),d(m)!=="svelte-kvfsh7"&&(m.textContent=J),w=o(v),h(T.$$.fragment,v)},m(v,ae){r(v,m,ae),r(v,w,ae),g(T,v,ae),U=!0},p:Ln,i(v){U||(M(T.$$.fragment,v),U=!0)},o(v){b(T.$$.fragment,v),U=!1},d(v){v&&(t(m),t(w)),y(T,v)}}}function ps(D){let m,J,w,T,U,v,ae,Xe,qn="Text-to-Video Generation with AnimateDiff",jt,x,V,ut,se,yn,Pe,On="Overview",Ut,ie,Kn='<a href="https://arxiv.org/abs/2307.04725" rel="nofollow">AnimateDiff: Animate Your Personalized Text-to-Image Diffusion Models without Specific Tuning</a> by Yuwei Guo, Ceyuan Yang, Anyi Rao, Yaohui Wang, Yu Qiao, Dahua Lin, Bo Dai.',It,le,ea="The abstract of the paper is the following:",Zt,oe,ta='<em>With the advance of text-to-image models (e.g., Stable Diffusion) and corresponding personalization techniques such as DreamBooth and LoRA, everyone can manifest their imagination into high-quality images at an affordable cost. Subsequently, there is a great demand for image animation techniques to further combine generated static images with motion dynamics. In this report, we propose a practical framework to animate most of the existing personalized text-to-image models once and for all, saving efforts in model-specific tuning. At the core of the proposed framework is to insert a newly initialized motion modeling module into the frozen text-to-image model and train it on video clips to distill reasonable motion priors. Once trained, by simply injecting this motion modeling module, all personalized versions derived from the same base T2I readily become text-driven models that produce diverse and personalized animated images. We conduct our evaluation on several public representative personalized text-to-image models across anime pictures and realistic photographs, and demonstrate that our proposed framework helps these models generate temporally smooth animation clips while preserving the domain and diversity of their outputs. Code and pre-trained weights will be publicly available at <a href="https://animatediff.github.io/" rel="nofollow">this https URL</a>.</em>',xt,W,R,ht,re,wn,Qe,na="Available Pipelines",Wt,pe,aa='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py" rel="nofollow">AnimateDiffPipeline</a></td> <td><em>Text-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr></tbody>',kt,k,F,gt,de,_n,Ye,sa="Available checkpoints",Bt,ce,ia='Motion Adapter checkpoints can be found under <a href="https://huggingface.co/guoyww/" rel="nofollow">guoyww</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.4/1.5.',At,B,S,Mt,me,vn,He,la="Usage example",Ct,fe,oa="AnimateDiff works with a MotionAdapter checkpoint and a Stable Diffusion model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in Stable Diffusion UNet.",Gt,ue,ra="The following example demonstrates how to use a <em>MotionAdapter</em> checkpoint with Diffusers for inference based on StableDiffusion-1.4/1.5.",$t,he,Et,ge,pa="Here are some sample outputs:",Dt,Me,da=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-realistic-doc.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,Vt,N,Rt,A,X,bt,be,Tn,ze,ca="Using Motion LoRAs",Ft,ye,ma="Motion LoRAs are a collection of LoRAs that work with the <code>guoyww/animatediff-motion-adapter-v1-5-2</code> checkpoint. These LoRAs are responsible for adding specific types of motion to the animations.",St,we,Nt,_e,fa=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,Xt,C,P,yt,ve,Jn,Le,ua="Using Motion LoRAs with PEFT",Pt,Te,ha='You can also leverage the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> backend to combine Motion LoRA’s and create more complex animations.',Qt,Je,ga="First install PEFT with",Yt,je,Ht,Ue,Ma="Then you can use the following code to combine Motion LoRAs.",zt,Ie,Lt,Ze,ba=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-pan-left-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,qt,Q,Ot,G,Y,wt,xe,jn,qe,ya="AnimateDiffPipeline",Kt,f,We,Un,Oe,wa="Pipeline for text-to-video generation.",In,Ke,_a=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Zn,et,va="The pipeline also inherits the following loading methods:",xn,tt,Ta='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Wn,I,ke,kn,nt,Ja="The call function to the pipeline for generation.",Bn,H,An,z,Be,Cn,at,ja="Disables the FreeU mechanism if enabled.",Gn,L,Ae,$n,st,Ua=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,En,q,Ce,Dn,it,Ia=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Vn,j,Ge,Rn,lt,Za='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Fn,ot,xa="The suffixes after the scaling factors represent the stages where they are being applied.",Sn,rt,Wa=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Nn,O,$e,Xn,pt,ka=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Pn,K,Ee,Qn,dt,Ba=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Yn,ee,De,Hn,ct,Aa="Encodes the prompt into text encoder hidden states.",en,Ve,Ca="<li>enable_freeu</li> <li>disable_freeu</li> <li>enable_vae_slicing</li> <li>disable_vae_slicing</li> <li>enable_vae_tiling</li> <li>disable_vae_tiling</li>",tn,$,te,_t,Re,zn,mt,Ga="AnimateDiffPipelineOutput",nn,Fe,Se,an;return v=new E({}),se=new E({}),re=new E({}),de=new E({}),me=new E({}),he=new Jt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`}}),N=new Ka({props:{$$slots:{default:[ls]},$$scope:{ctx:D}}}),be=new E({}),we=new Jt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>
)

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`}}),ve=new E({}),je=new Jt({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft"}}),Ie=new Jt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>,
)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-pan-left&quot;</span>, adapter_name=<span class="hljs-string">&quot;pan-left&quot;</span>,
)
pipe.set_adapters([<span class="hljs-string">&quot;zoom-out&quot;</span>, <span class="hljs-string">&quot;pan-left&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>])

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`}}),Q=new Ka({props:{$$slots:{default:[os]},$$scope:{ctx:D}}}),xe=new E({}),We=new Z({props:{name:"class diffusers.AnimateDiffPipeline",anchor:"diffusers.AnimateDiffPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L87"}}),ke=new Z({props:{name:"__call__",anchor:"diffusers.AnimateDiffPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L542",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),H=new is({props:{anchor:"diffusers.AnimateDiffPipeline.__call__.example",$$slots:{default:[rs]},$$scope:{ctx:D}}}),Be=new Z({props:{name:"disable_freeu",anchor:"diffusers.AnimateDiffPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L441"}}),Ae=new Z({props:{name:"disable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L393"}}),Ce=new Z({props:{name:"disable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L410"}}),Ge=new Z({props:{name:"enable_freeu",anchor:"diffusers.AnimateDiffPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L418"}}),$e=new Z({props:{name:"enable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L385"}}),Ee=new Z({props:{name:"enable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L401"}}),De=new Z({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L154"}}),Re=new E({}),Se=new Z({props:{name:"class diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",parameters:[{name:"frames",val:": Union"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L82"}}),{c(){m=a("meta"),J=l(),w=a("h1"),T=a("a"),U=a("span"),u(v.$$.fragment),ae=l(),Xe=a("span"),Xe.textContent=qn,jt=l(),x=a("h2"),V=a("a"),ut=a("span"),u(se.$$.fragment),yn=l(),Pe=a("span"),Pe.textContent=On,Ut=l(),ie=a("p"),ie.innerHTML=Kn,It=l(),le=a("p"),le.textContent=ea,Zt=l(),oe=a("p"),oe.innerHTML=ta,xt=l(),W=a("h2"),R=a("a"),ht=a("span"),u(re.$$.fragment),wn=l(),Qe=a("span"),Qe.textContent=na,Wt=l(),pe=a("table"),pe.innerHTML=aa,kt=l(),k=a("h2"),F=a("a"),gt=a("span"),u(de.$$.fragment),_n=l(),Ye=a("span"),Ye.textContent=sa,Bt=l(),ce=a("p"),ce.innerHTML=ia,At=l(),B=a("h2"),S=a("a"),Mt=a("span"),u(me.$$.fragment),vn=l(),He=a("span"),He.textContent=la,Ct=l(),fe=a("p"),fe.textContent=oa,Gt=l(),ue=a("p"),ue.innerHTML=ra,$t=l(),u(he.$$.fragment),Et=l(),ge=a("p"),ge.textContent=pa,Dt=l(),Me=a("table"),Me.innerHTML=da,Vt=l(),u(N.$$.fragment),Rt=l(),A=a("h2"),X=a("a"),bt=a("span"),u(be.$$.fragment),Tn=l(),ze=a("span"),ze.textContent=ca,Ft=l(),ye=a("p"),ye.innerHTML=ma,St=l(),u(we.$$.fragment),Nt=l(),_e=a("table"),_e.innerHTML=fa,Xt=l(),C=a("h2"),P=a("a"),yt=a("span"),u(ve.$$.fragment),Jn=l(),Le=a("span"),Le.textContent=ua,Pt=l(),Te=a("p"),Te.innerHTML=ha,Qt=l(),Je=a("p"),Je.textContent=ga,Yt=l(),u(je.$$.fragment),Ht=l(),Ue=a("p"),Ue.textContent=Ma,zt=l(),u(Ie.$$.fragment),Lt=l(),Ze=a("table"),Ze.innerHTML=ba,qt=l(),u(Q.$$.fragment),Ot=l(),G=a("h2"),Y=a("a"),wt=a("span"),u(xe.$$.fragment),jn=l(),qe=a("span"),qe.textContent=ya,Kt=l(),f=a("div"),u(We.$$.fragment),Un=l(),Oe=a("p"),Oe.textContent=wa,In=l(),Ke=a("p"),Ke.innerHTML=_a,Zn=l(),et=a("p"),et.textContent=va,xn=l(),tt=a("ul"),tt.innerHTML=Ta,Wn=l(),I=a("div"),u(ke.$$.fragment),kn=l(),nt=a("p"),nt.textContent=Ja,Bn=l(),u(H.$$.fragment),An=l(),z=a("div"),u(Be.$$.fragment),Cn=l(),at=a("p"),at.textContent=ja,Gn=l(),L=a("div"),u(Ae.$$.fragment),$n=l(),st=a("p"),st.innerHTML=Ua,En=l(),q=a("div"),u(Ce.$$.fragment),Dn=l(),it=a("p"),it.innerHTML=Ia,Vn=l(),j=a("div"),u(Ge.$$.fragment),Rn=l(),lt=a("p"),lt.innerHTML=Za,Fn=l(),ot=a("p"),ot.textContent=xa,Sn=l(),rt=a("p"),rt.innerHTML=Wa,Nn=l(),O=a("div"),u($e.$$.fragment),Xn=l(),pt=a("p"),pt.textContent=ka,Pn=l(),K=a("div"),u(Ee.$$.fragment),Qn=l(),dt=a("p"),dt.textContent=Ba,Yn=l(),ee=a("div"),u(De.$$.fragment),Hn=l(),ct=a("p"),ct.textContent=Aa,en=l(),Ve=a("ul"),Ve.innerHTML=Ca,tn=l(),$=a("h2"),te=a("a"),_t=a("span"),u(Re.$$.fragment),zn=l(),mt=a("span"),mt.textContent=Ga,nn=l(),Fe=a("div"),u(Se.$$.fragment),this.h()},l(e){const i=ss("svelte-1phssyn",document.head);m=s(i,"META",{name:!0,content:!0}),i.forEach(t),J=o(e),w=s(e,"H1",{class:!0});var Ne=c(w);T=s(Ne,"A",{id:!0,class:!0,href:!0});var vt=c(T);U=s(vt,"SPAN",{});var Tt=c(U);h(v.$$.fragment,Tt),Tt.forEach(t),vt.forEach(t),ae=o(Ne),Xe=s(Ne,"SPAN",{"data-svelte-h":!0}),d(Xe)!=="svelte-8xzfzk"&&(Xe.textContent=qn),Ne.forEach(t),jt=o(e),x=s(e,"H2",{class:!0});var sn=c(x);V=s(sn,"A",{id:!0,class:!0,href:!0});var $a=c(V);ut=s($a,"SPAN",{});var Ea=c(ut);h(se.$$.fragment,Ea),Ea.forEach(t),$a.forEach(t),yn=o(sn),Pe=s(sn,"SPAN",{"data-svelte-h":!0}),d(Pe)!=="svelte-1jsw1pg"&&(Pe.textContent=On),sn.forEach(t),Ut=o(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1heixsu"&&(ie.innerHTML=Kn),It=o(e),le=s(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-wu27l3"&&(le.textContent=ea),Zt=o(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-17654bv"&&(oe.innerHTML=ta),xt=o(e),W=s(e,"H2",{class:!0});var ln=c(W);R=s(ln,"A",{id:!0,class:!0,href:!0});var Da=c(R);ht=s(Da,"SPAN",{});var Va=c(ht);h(re.$$.fragment,Va),Va.forEach(t),Da.forEach(t),wn=o(ln),Qe=s(ln,"SPAN",{"data-svelte-h":!0}),d(Qe)!=="svelte-1vodb8j"&&(Qe.textContent=na),ln.forEach(t),Wt=o(e),pe=s(e,"TABLE",{"data-svelte-h":!0}),d(pe)!=="svelte-1es4wyd"&&(pe.innerHTML=aa),kt=o(e),k=s(e,"H2",{class:!0});var on=c(k);F=s(on,"A",{id:!0,class:!0,href:!0});var Ra=c(F);gt=s(Ra,"SPAN",{});var Fa=c(gt);h(de.$$.fragment,Fa),Fa.forEach(t),Ra.forEach(t),_n=o(on),Ye=s(on,"SPAN",{"data-svelte-h":!0}),d(Ye)!=="svelte-1bwe2sz"&&(Ye.textContent=sa),on.forEach(t),Bt=o(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1eu5pwh"&&(ce.innerHTML=ia),At=o(e),B=s(e,"H2",{class:!0});var rn=c(B);S=s(rn,"A",{id:!0,class:!0,href:!0});var Sa=c(S);Mt=s(Sa,"SPAN",{});var Na=c(Mt);h(me.$$.fragment,Na),Na.forEach(t),Sa.forEach(t),vn=o(rn),He=s(rn,"SPAN",{"data-svelte-h":!0}),d(He)!=="svelte-11riiwe"&&(He.textContent=la),rn.forEach(t),Ct=o(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-q9bvzo"&&(fe.textContent=oa),Gt=o(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-o3l8n4"&&(ue.innerHTML=ra),$t=o(e),h(he.$$.fragment,e),Et=o(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1pxzje"&&(ge.textContent=pa),Dt=o(e),Me=s(e,"TABLE",{"data-svelte-h":!0}),d(Me)!=="svelte-5250wa"&&(Me.innerHTML=da),Vt=o(e),h(N.$$.fragment,e),Rt=o(e),A=s(e,"H2",{class:!0});var pn=c(A);X=s(pn,"A",{id:!0,class:!0,href:!0});var Xa=c(X);bt=s(Xa,"SPAN",{});var Pa=c(bt);h(be.$$.fragment,Pa),Pa.forEach(t),Xa.forEach(t),Tn=o(pn),ze=s(pn,"SPAN",{"data-svelte-h":!0}),d(ze)!=="svelte-1kecrms"&&(ze.textContent=ca),pn.forEach(t),Ft=o(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-u1dwwg"&&(ye.innerHTML=ma),St=o(e),h(we.$$.fragment,e),Nt=o(e),_e=s(e,"TABLE",{"data-svelte-h":!0}),d(_e)!=="svelte-16prig"&&(_e.innerHTML=fa),Xt=o(e),C=s(e,"H2",{class:!0});var dn=c(C);P=s(dn,"A",{id:!0,class:!0,href:!0});var Qa=c(P);yt=s(Qa,"SPAN",{});var Ya=c(yt);h(ve.$$.fragment,Ya),Ya.forEach(t),Qa.forEach(t),Jn=o(dn),Le=s(dn,"SPAN",{"data-svelte-h":!0}),d(Le)!=="svelte-1q4bbpn"&&(Le.textContent=ua),dn.forEach(t),Pt=o(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1gecok3"&&(Te.innerHTML=ha),Qt=o(e),Je=s(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-26fcye"&&(Je.textContent=ga),Yt=o(e),h(je.$$.fragment,e),Ht=o(e),Ue=s(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1e37vkb"&&(Ue.textContent=Ma),zt=o(e),h(Ie.$$.fragment,e),Lt=o(e),Ze=s(e,"TABLE",{"data-svelte-h":!0}),d(Ze)!=="svelte-3p6096"&&(Ze.innerHTML=ba),qt=o(e),h(Q.$$.fragment,e),Ot=o(e),G=s(e,"H2",{class:!0});var cn=c(G);Y=s(cn,"A",{id:!0,class:!0,href:!0});var Ha=c(Y);wt=s(Ha,"SPAN",{});var za=c(wt);h(xe.$$.fragment,za),za.forEach(t),Ha.forEach(t),jn=o(cn),qe=s(cn,"SPAN",{"data-svelte-h":!0}),d(qe)!=="svelte-1i2ywmd"&&(qe.textContent=ya),cn.forEach(t),Kt=o(e),f=s(e,"DIV",{class:!0});var _=c(f);h(We.$$.fragment,_),Un=o(_),Oe=s(_,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-19ipoo4"&&(Oe.textContent=wa),In=o(_),Ke=s(_,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-496sm0"&&(Ke.innerHTML=_a),Zn=o(_),et=s(_,"P",{"data-svelte-h":!0}),d(et)!=="svelte-14s6m4u"&&(et.textContent=va),xn=o(_),tt=s(_,"UL",{"data-svelte-h":!0}),d(tt)!=="svelte-jjuyoc"&&(tt.innerHTML=Ta),Wn=o(_),I=s(_,"DIV",{class:!0});var ft=c(I);h(ke.$$.fragment,ft),kn=o(ft),nt=s(ft,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-50j04k"&&(nt.textContent=Ja),Bn=o(ft),h(H.$$.fragment,ft),ft.forEach(t),An=o(_),z=s(_,"DIV",{class:!0});var mn=c(z);h(Be.$$.fragment,mn),Cn=o(mn),at=s(mn,"P",{"data-svelte-h":!0}),d(at)!=="svelte-psupw6"&&(at.textContent=ja),mn.forEach(t),Gn=o(_),L=s(_,"DIV",{class:!0});var fn=c(L);h(Ae.$$.fragment,fn),$n=o(fn),st=s(fn,"P",{"data-svelte-h":!0}),d(st)!=="svelte-1s3c06i"&&(st.innerHTML=Ua),fn.forEach(t),En=o(_),q=s(_,"DIV",{class:!0});var un=c(q);h(Ce.$$.fragment,un),Dn=o(un),it=s(un,"P",{"data-svelte-h":!0}),d(it)!=="svelte-pkn4ui"&&(it.innerHTML=Ia),un.forEach(t),Vn=o(_),j=s(_,"DIV",{class:!0});var ne=c(j);h(Ge.$$.fragment,ne),Rn=o(ne),lt=s(ne,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1f3tmq1"&&(lt.innerHTML=Za),Fn=o(ne),ot=s(ne,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-xjijlp"&&(ot.textContent=xa),Sn=o(ne),rt=s(ne,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-hy0nzs"&&(rt.innerHTML=Wa),ne.forEach(t),Nn=o(_),O=s(_,"DIV",{class:!0});var hn=c(O);h($e.$$.fragment,hn),Xn=o(hn),pt=s(hn,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-14bnrb6"&&(pt.textContent=ka),hn.forEach(t),Pn=o(_),K=s(_,"DIV",{class:!0});var gn=c(K);h(Ee.$$.fragment,gn),Qn=o(gn),dt=s(gn,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1xwrf7t"&&(dt.textContent=Ba),gn.forEach(t),Yn=o(_),ee=s(_,"DIV",{class:!0});var Mn=c(ee);h(De.$$.fragment,Mn),Hn=o(Mn),ct=s(Mn,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-16q0ax1"&&(ct.textContent=Aa),Mn.forEach(t),_.forEach(t),en=o(e),Ve=s(e,"UL",{"data-svelte-h":!0}),d(Ve)!=="svelte-17fwsy1"&&(Ve.innerHTML=Ca),tn=o(e),$=s(e,"H2",{class:!0});var bn=c($);te=s(bn,"A",{id:!0,class:!0,href:!0});var La=c(te);_t=s(La,"SPAN",{});var qa=c(_t);h(Re.$$.fragment,qa),qa.forEach(t),La.forEach(t),zn=o(bn),mt=s(bn,"SPAN",{"data-svelte-h":!0}),d(mt)!=="svelte-1js218o"&&(mt.textContent=Ga),bn.forEach(t),nn=o(e),Fe=s(e,"DIV",{class:!0});var Oa=c(Fe);h(Se.$$.fragment,Oa),Oa.forEach(t),this.h()},h(){p(m,"name","hf:doc:metadata"),p(m,"content",JSON.stringify(ds)),p(T,"id","texttovideo-generation-with-animatediff"),p(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(T,"href","#texttovideo-generation-with-animatediff"),p(w,"class","relative group"),p(V,"id","overview"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#overview"),p(x,"class","relative group"),p(R,"id","available-pipelines"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#available-pipelines"),p(W,"class","relative group"),p(F,"id","available-checkpoints"),p(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(F,"href","#available-checkpoints"),p(k,"class","relative group"),p(S,"id","usage-example"),p(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(S,"href","#usage-example"),p(B,"class","relative group"),p(X,"id","using-motion-loras"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#using-motion-loras"),p(A,"class","relative group"),p(P,"id","using-motion-loras-with-peft"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#using-motion-loras-with-peft"),p(C,"class","relative group"),p(Y,"id","diffusers.AnimateDiffPipeline"),p(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Y,"href","#diffusers.AnimateDiffPipeline"),p(G,"class","relative group"),p(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(te,"id","diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"),p(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(te,"href","#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"),p($,"class","relative group"),p(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){n(document.head,m),r(e,J,i),r(e,w,i),n(w,T),n(T,U),g(v,U,null),n(w,ae),n(w,Xe),r(e,jt,i),r(e,x,i),n(x,V),n(V,ut),g(se,ut,null),n(x,yn),n(x,Pe),r(e,Ut,i),r(e,ie,i),r(e,It,i),r(e,le,i),r(e,Zt,i),r(e,oe,i),r(e,xt,i),r(e,W,i),n(W,R),n(R,ht),g(re,ht,null),n(W,wn),n(W,Qe),r(e,Wt,i),r(e,pe,i),r(e,kt,i),r(e,k,i),n(k,F),n(F,gt),g(de,gt,null),n(k,_n),n(k,Ye),r(e,Bt,i),r(e,ce,i),r(e,At,i),r(e,B,i),n(B,S),n(S,Mt),g(me,Mt,null),n(B,vn),n(B,He),r(e,Ct,i),r(e,fe,i),r(e,Gt,i),r(e,ue,i),r(e,$t,i),g(he,e,i),r(e,Et,i),r(e,ge,i),r(e,Dt,i),r(e,Me,i),r(e,Vt,i),g(N,e,i),r(e,Rt,i),r(e,A,i),n(A,X),n(X,bt),g(be,bt,null),n(A,Tn),n(A,ze),r(e,Ft,i),r(e,ye,i),r(e,St,i),g(we,e,i),r(e,Nt,i),r(e,_e,i),r(e,Xt,i),r(e,C,i),n(C,P),n(P,yt),g(ve,yt,null),n(C,Jn),n(C,Le),r(e,Pt,i),r(e,Te,i),r(e,Qt,i),r(e,Je,i),r(e,Yt,i),g(je,e,i),r(e,Ht,i),r(e,Ue,i),r(e,zt,i),g(Ie,e,i),r(e,Lt,i),r(e,Ze,i),r(e,qt,i),g(Q,e,i),r(e,Ot,i),r(e,G,i),n(G,Y),n(Y,wt),g(xe,wt,null),n(G,jn),n(G,qe),r(e,Kt,i),r(e,f,i),g(We,f,null),n(f,Un),n(f,Oe),n(f,In),n(f,Ke),n(f,Zn),n(f,et),n(f,xn),n(f,tt),n(f,Wn),n(f,I),g(ke,I,null),n(I,kn),n(I,nt),n(I,Bn),g(H,I,null),n(f,An),n(f,z),g(Be,z,null),n(z,Cn),n(z,at),n(f,Gn),n(f,L),g(Ae,L,null),n(L,$n),n(L,st),n(f,En),n(f,q),g(Ce,q,null),n(q,Dn),n(q,it),n(f,Vn),n(f,j),g(Ge,j,null),n(j,Rn),n(j,lt),n(j,Fn),n(j,ot),n(j,Sn),n(j,rt),n(f,Nn),n(f,O),g($e,O,null),n(O,Xn),n(O,pt),n(f,Pn),n(f,K),g(Ee,K,null),n(K,Qn),n(K,dt),n(f,Yn),n(f,ee),g(De,ee,null),n(ee,Hn),n(ee,ct),r(e,en,i),r(e,Ve,i),r(e,tn,i),r(e,$,i),n($,te),n(te,_t),g(Re,_t,null),n($,zn),n($,mt),r(e,nn,i),r(e,Fe,i),g(Se,Fe,null),an=!0},p(e,[i]){const Ne={};i&2&&(Ne.$$scope={dirty:i,ctx:e}),N.$set(Ne);const vt={};i&2&&(vt.$$scope={dirty:i,ctx:e}),Q.$set(vt);const Tt={};i&2&&(Tt.$$scope={dirty:i,ctx:e}),H.$set(Tt)},i(e){an||(M(v.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(N.$$.fragment,e),M(be.$$.fragment,e),M(we.$$.fragment,e),M(ve.$$.fragment,e),M(je.$$.fragment,e),M(Ie.$$.fragment,e),M(Q.$$.fragment,e),M(xe.$$.fragment,e),M(We.$$.fragment,e),M(ke.$$.fragment,e),M(H.$$.fragment,e),M(Be.$$.fragment,e),M(Ae.$$.fragment,e),M(Ce.$$.fragment,e),M(Ge.$$.fragment,e),M($e.$$.fragment,e),M(Ee.$$.fragment,e),M(De.$$.fragment,e),M(Re.$$.fragment,e),M(Se.$$.fragment,e),an=!0)},o(e){b(v.$$.fragment,e),b(se.$$.fragment,e),b(re.$$.fragment,e),b(de.$$.fragment,e),b(me.$$.fragment,e),b(he.$$.fragment,e),b(N.$$.fragment,e),b(be.$$.fragment,e),b(we.$$.fragment,e),b(ve.$$.fragment,e),b(je.$$.fragment,e),b(Ie.$$.fragment,e),b(Q.$$.fragment,e),b(xe.$$.fragment,e),b(We.$$.fragment,e),b(ke.$$.fragment,e),b(H.$$.fragment,e),b(Be.$$.fragment,e),b(Ae.$$.fragment,e),b(Ce.$$.fragment,e),b(Ge.$$.fragment,e),b($e.$$.fragment,e),b(Ee.$$.fragment,e),b(De.$$.fragment,e),b(Re.$$.fragment,e),b(Se.$$.fragment,e),an=!1},d(e){e&&(t(J),t(w),t(jt),t(x),t(Ut),t(ie),t(It),t(le),t(Zt),t(oe),t(xt),t(W),t(Wt),t(pe),t(kt),t(k),t(Bt),t(ce),t(At),t(B),t(Ct),t(fe),t(Gt),t(ue),t($t),t(Et),t(ge),t(Dt),t(Me),t(Vt),t(Rt),t(A),t(Ft),t(ye),t(St),t(Nt),t(_e),t(Xt),t(C),t(Pt),t(Te),t(Qt),t(Je),t(Yt),t(Ht),t(Ue),t(zt),t(Lt),t(Ze),t(qt),t(Ot),t(G),t(Kt),t(f),t(en),t(Ve),t(tn),t($),t(nn),t(Fe)),t(m),y(v),y(se),y(re),y(de),y(me),y(he,e),y(N,e),y(be),y(we,e),y(ve),y(je,e),y(Ie,e),y(Q,e),y(xe),y(We),y(ke),y(H),y(Be),y(Ae),y(Ce),y(Ge),y($e),y(Ee),y(De),y(Re),y(Se)}}}const ds={local:"texttovideo-generation-with-animatediff",sections:[{local:"overview",title:"Overview"},{local:"available-pipelines",title:"Available Pipelines"},{local:"available-checkpoints",title:"Available checkpoints"},{local:"usage-example",title:"Usage example"},{local:"using-motion-loras",title:"Using Motion LoRAs"},{local:"using-motion-loras-with-peft",title:"Using Motion LoRAs with PEFT"},{local:"diffusers.AnimateDiffPipeline",title:"AnimateDiffPipeline"},{local:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",title:"AnimateDiffPipelineOutput"}],title:"Text-to-Video Generation with AnimateDiff"};function cs(D){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends ns{constructor(m){super(),as(this,m,cs,ps,es,{})}}export{ys as component};
