import{s as Zt,n as kt,o as xt}from"../chunks/scheduler.182ea377.js";import{S as jt,i as _t,g as s,s as i,p as c,A as Gt,h as n,f as t,c as o,j as u,q as h,m,k as r,v as p,a,r as d,d as f,t as b,u as g}from"../chunks/index.008d68e4.js";import{I as ce}from"../chunks/IconCopyLink.96bbb92b.js";import{C as te}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as $t}from"../chunks/DocNotebookDropdown.bb388256.js";function Wt(ze){let y,he,M,T,oe,$,Le,le,De="Stable Diffusion XL Turbo",de,W,fe,C,Ke=`SDXL Turbo is an adversarial time-distilled <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> (SDXL) model capable
of running inference in as little as 1 step.`,be,B,Oe="This guide will show you how to use SDXL-Turbo for text-to-image and image-to-image.",ge,S,et="Before you begin, make sure you have the following libraries installed:",ye,X,Me,w,Z,re,H,Qe,ae,tt="Load model checkpoints",we,I,lt='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',ve,F,Ue,N,at='You can also use the <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method to load a model checkpoint stored in a single file format (<code>.ckpt</code> or <code>.safetensors</code>) from the Hub or locally:',Je,Y,Te,v,k,pe,R,Ae,se,st="Text-to-image",Ze,V,nt="For text-to-image, pass a text prompt. By default, SDXL Turbo generates a 512x512 image, and that resolution gives the best results. You can try setting the <code>height</code> and <code>width</code> parameters to 768x768 or 1024x1024, but you should expect quality degradations when doing so.",ke,E,it=`Make sure to set <code>guidance_scale</code> to 0.0 to disable, as the model was trained without it. A single inference step is enough to generate high quality images.
Increasing the number of steps to 2, 3 or 4 should improve image quality.`,xe,L,je,x,ot='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-text2img.png" alt="generated image of a racoon in a robe"/>',_e,U,j,me,Q,Pe,ne,rt="Image-to-image",Ge,A,pt=`For image-to-image generation, make sure that <code>num_inference_steps * strength</code> is larger or equal to 1.
The image-to-image pipeline will run for <code>int(num_inference_steps * strength)</code> steps, e.g. <code>0.5 * 2.0 = 1</code> step in
our example below.`,$e,P,We,_,mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-img2img.png" alt="Image-to-image generation sample using SDXL Turbo"/>',Ce,J,G,ue,q,qe,ie,ut="Speed-up SDXL Turbo even more",Be,z,ct="<li>Compile the UNet if you are using PyTorch version 2 or better. The first inference run will be very slow, but subsequent ones will be much faster.</li>",Se,D,Xe,K,ht="<li>When using the default VAE, keep it in <code>float32</code> to avoid costly <code>dtype</code> conversions before and after each generation. You only need to do this one before your first generation:</li>",He,O,Ie,ee,dt='As an alternative, you can also use a <a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">16-bit VAE</a> created by community member <a href="https://huggingface.co/madebyollin" rel="nofollow"><code>@madebyollin</code></a> that does not need to be upcasted to <code>float32</code>.',Fe;return $=new ce({}),W=new $t({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"}]}}),X=new te({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwb21lZ2Fjb25m",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate omegaconf</span>`}}),H=new ce({}),F=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),Y=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMkZibG9iJTJGbWFpbiUyRnNkX3hsX3R1cmJvXzEuMF9mcDE2LnNhZmV0ZW5zb3JzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sdxl-turbo/blob/main/sd_xl_turbo_1.0_fp16.safetensors&quot;</span>, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),R=new ce({}),L=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lX3RleHQyaW1hZ2UlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZV90ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjaW5lbWF0aWMlMjBzaG90JTIwb2YlMjBhJTIwYmFieSUyMHJhY29vbiUyMHdlYXJpbmclMjBhbiUyMGludHJpY2F0ZSUyMGl0YWxpYW4lMjBwcmllc3QlMjByb2JlLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2image = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline_text2image = pipeline_text2image.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cinematic shot of a baby racoon wearing an intricate italian priest robe.&quot;</span>

image = pipeline_text2image(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images[<span class="hljs-number">0</span>]
image`}}),Q=new ce({}),P=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjB1c2UlMjBmcm9tX3BpcGUlMjB0byUyMGF2b2lkJTIwY29uc3VtaW5nJTIwYWRkaXRpb25hbCUyMG1lbW9yeSUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMGNoZWNrcG9pbnQlMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltYWdlKS50byglMjJjdWRhJTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhdC5wbmclMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC41JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMikuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">2</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),q=new ce({}),D=new te({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:'pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)'}}),O=new te({props:{code:"cGlwZS51cGNhc3RfdmFlKCk=",highlighted:"pipe.upcast_vae()"}}),{c(){y=s("meta"),he=i(),M=s("h1"),T=s("a"),oe=s("span"),c($.$$.fragment),Le=i(),le=s("span"),le.textContent=De,de=i(),c(W.$$.fragment),fe=i(),C=s("p"),C.innerHTML=Ke,be=i(),B=s("p"),B.textContent=Oe,ge=i(),S=s("p"),S.textContent=et,ye=i(),c(X.$$.fragment),Me=i(),w=s("h2"),Z=s("a"),re=s("span"),c(H.$$.fragment),Qe=i(),ae=s("span"),ae.textContent=tt,we=i(),I=s("p"),I.innerHTML=lt,ve=i(),c(F.$$.fragment),Ue=i(),N=s("p"),N.innerHTML=at,Je=i(),c(Y.$$.fragment),Te=i(),v=s("h2"),k=s("a"),pe=s("span"),c(R.$$.fragment),Ae=i(),se=s("span"),se.textContent=st,Ze=i(),V=s("p"),V.innerHTML=nt,ke=i(),E=s("p"),E.innerHTML=it,xe=i(),c(L.$$.fragment),je=i(),x=s("div"),x.innerHTML=ot,_e=i(),U=s("h2"),j=s("a"),me=s("span"),c(Q.$$.fragment),Pe=i(),ne=s("span"),ne.textContent=rt,Ge=i(),A=s("p"),A.innerHTML=pt,$e=i(),c(P.$$.fragment),We=i(),_=s("div"),_.innerHTML=mt,Ce=i(),J=s("h2"),G=s("a"),ue=s("span"),c(q.$$.fragment),qe=i(),ie=s("span"),ie.textContent=ut,Be=i(),z=s("ul"),z.innerHTML=ct,Se=i(),c(D.$$.fragment),Xe=i(),K=s("ul"),K.innerHTML=ht,He=i(),c(O.$$.fragment),Ie=i(),ee=s("p"),ee.innerHTML=dt,this.h()},l(e){const l=Gt("svelte-1phssyn",document.head);y=n(l,"META",{name:!0,content:!0}),l.forEach(t),he=o(e),M=n(e,"H1",{class:!0});var Ne=u(M);T=n(Ne,"A",{id:!0,class:!0,href:!0});var ft=u(T);oe=n(ft,"SPAN",{});var bt=u(oe);h($.$$.fragment,bt),bt.forEach(t),ft.forEach(t),Le=o(Ne),le=n(Ne,"SPAN",{"data-svelte-h":!0}),m(le)!=="svelte-182wv2r"&&(le.textContent=De),Ne.forEach(t),de=o(e),h(W.$$.fragment,e),fe=o(e),C=n(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1465uj8"&&(C.innerHTML=Ke),be=o(e),B=n(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-851pbc"&&(B.textContent=Oe),ge=o(e),S=n(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-cwruts"&&(S.textContent=et),ye=o(e),h(X.$$.fragment,e),Me=o(e),w=n(e,"H2",{class:!0});var Ye=u(w);Z=n(Ye,"A",{id:!0,class:!0,href:!0});var gt=u(Z);re=n(gt,"SPAN",{});var yt=u(re);h(H.$$.fragment,yt),yt.forEach(t),gt.forEach(t),Qe=o(Ye),ae=n(Ye,"SPAN",{"data-svelte-h":!0}),m(ae)!=="svelte-1fq4gef"&&(ae.textContent=tt),Ye.forEach(t),we=o(e),I=n(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-hva56b"&&(I.innerHTML=lt),ve=o(e),h(F.$$.fragment,e),Ue=o(e),N=n(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1bnykxt"&&(N.innerHTML=at),Je=o(e),h(Y.$$.fragment,e),Te=o(e),v=n(e,"H2",{class:!0});var Re=u(v);k=n(Re,"A",{id:!0,class:!0,href:!0});var Mt=u(k);pe=n(Mt,"SPAN",{});var wt=u(pe);h(R.$$.fragment,wt),wt.forEach(t),Mt.forEach(t),Ae=o(Re),se=n(Re,"SPAN",{"data-svelte-h":!0}),m(se)!=="svelte-ws6p24"&&(se.textContent=st),Re.forEach(t),Ze=o(e),V=n(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1urqyhr"&&(V.innerHTML=nt),ke=o(e),E=n(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-d70s1"&&(E.innerHTML=it),xe=o(e),h(L.$$.fragment,e),je=o(e),x=n(e,"DIV",{class:!0,"data-svelte-h":!0}),m(x)!=="svelte-1lx4ppg"&&(x.innerHTML=ot),_e=o(e),U=n(e,"H2",{class:!0});var Ve=u(U);j=n(Ve,"A",{id:!0,class:!0,href:!0});var vt=u(j);me=n(vt,"SPAN",{});var Ut=u(me);h(Q.$$.fragment,Ut),Ut.forEach(t),vt.forEach(t),Pe=o(Ve),ne=n(Ve,"SPAN",{"data-svelte-h":!0}),m(ne)!=="svelte-1r5u1a2"&&(ne.textContent=rt),Ve.forEach(t),Ge=o(e),A=n(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1rvgn5v"&&(A.innerHTML=pt),$e=o(e),h(P.$$.fragment,e),We=o(e),_=n(e,"DIV",{class:!0,"data-svelte-h":!0}),m(_)!=="svelte-ovbosa"&&(_.innerHTML=mt),Ce=o(e),J=n(e,"H2",{class:!0});var Ee=u(J);G=n(Ee,"A",{id:!0,class:!0,href:!0});var Jt=u(G);ue=n(Jt,"SPAN",{});var Tt=u(ue);h(q.$$.fragment,Tt),Tt.forEach(t),Jt.forEach(t),qe=o(Ee),ie=n(Ee,"SPAN",{"data-svelte-h":!0}),m(ie)!=="svelte-1jaf4mw"&&(ie.textContent=ut),Ee.forEach(t),Be=o(e),z=n(e,"UL",{"data-svelte-h":!0}),m(z)!=="svelte-1d7cg56"&&(z.innerHTML=ct),Se=o(e),h(D.$$.fragment,e),Xe=o(e),K=n(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-jn62ws"&&(K.innerHTML=ht),He=o(e),h(O.$$.fragment,e),Ie=o(e),ee=n(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1pt3hz0"&&(ee.innerHTML=dt),this.h()},h(){r(y,"name","hf:doc:metadata"),r(y,"content",JSON.stringify(Ct)),r(T,"id","stable-diffusion-xl-turbo"),r(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(T,"href","#stable-diffusion-xl-turbo"),r(M,"class","relative group"),r(Z,"id","load-model-checkpoints"),r(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Z,"href","#load-model-checkpoints"),r(w,"class","relative group"),r(k,"id","texttoimage"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#texttoimage"),r(v,"class","relative group"),r(x,"class","flex justify-center"),r(j,"id","imagetoimage"),r(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(j,"href","#imagetoimage"),r(U,"class","relative group"),r(_,"class","flex justify-center"),r(G,"id","speedup-sdxl-turbo-even-more"),r(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(G,"href","#speedup-sdxl-turbo-even-more"),r(J,"class","relative group")},m(e,l){p(document.head,y),a(e,he,l),a(e,M,l),p(M,T),p(T,oe),d($,oe,null),p(M,Le),p(M,le),a(e,de,l),d(W,e,l),a(e,fe,l),a(e,C,l),a(e,be,l),a(e,B,l),a(e,ge,l),a(e,S,l),a(e,ye,l),d(X,e,l),a(e,Me,l),a(e,w,l),p(w,Z),p(Z,re),d(H,re,null),p(w,Qe),p(w,ae),a(e,we,l),a(e,I,l),a(e,ve,l),d(F,e,l),a(e,Ue,l),a(e,N,l),a(e,Je,l),d(Y,e,l),a(e,Te,l),a(e,v,l),p(v,k),p(k,pe),d(R,pe,null),p(v,Ae),p(v,se),a(e,Ze,l),a(e,V,l),a(e,ke,l),a(e,E,l),a(e,xe,l),d(L,e,l),a(e,je,l),a(e,x,l),a(e,_e,l),a(e,U,l),p(U,j),p(j,me),d(Q,me,null),p(U,Pe),p(U,ne),a(e,Ge,l),a(e,A,l),a(e,$e,l),d(P,e,l),a(e,We,l),a(e,_,l),a(e,Ce,l),a(e,J,l),p(J,G),p(G,ue),d(q,ue,null),p(J,qe),p(J,ie),a(e,Be,l),a(e,z,l),a(e,Se,l),d(D,e,l),a(e,Xe,l),a(e,K,l),a(e,He,l),d(O,e,l),a(e,Ie,l),a(e,ee,l),Fe=!0},p:kt,i(e){Fe||(f($.$$.fragment,e),f(W.$$.fragment,e),f(X.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(Y.$$.fragment,e),f(R.$$.fragment,e),f(L.$$.fragment,e),f(Q.$$.fragment,e),f(P.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),Fe=!0)},o(e){b($.$$.fragment,e),b(W.$$.fragment,e),b(X.$$.fragment,e),b(H.$$.fragment,e),b(F.$$.fragment,e),b(Y.$$.fragment,e),b(R.$$.fragment,e),b(L.$$.fragment,e),b(Q.$$.fragment,e),b(P.$$.fragment,e),b(q.$$.fragment,e),b(D.$$.fragment,e),b(O.$$.fragment,e),Fe=!1},d(e){e&&(t(he),t(M),t(de),t(fe),t(C),t(be),t(B),t(ge),t(S),t(ye),t(Me),t(w),t(we),t(I),t(ve),t(Ue),t(N),t(Je),t(Te),t(v),t(Ze),t(V),t(ke),t(E),t(xe),t(je),t(x),t(_e),t(U),t(Ge),t(A),t($e),t(We),t(_),t(Ce),t(J),t(Be),t(z),t(Se),t(Xe),t(K),t(He),t(Ie),t(ee)),t(y),g($),g(W,e),g(X,e),g(H),g(F,e),g(Y,e),g(R),g(L,e),g(Q),g(P,e),g(q),g(D,e),g(O,e)}}}const Ct={local:"stable-diffusion-xl-turbo",sections:[{local:"load-model-checkpoints",title:"Load model checkpoints"},{local:"texttoimage",title:"Text-to-image"},{local:"imagetoimage",title:"Image-to-image"},{local:"speedup-sdxl-turbo-even-more",title:"Speed-up SDXL Turbo even more"}],title:"Stable Diffusion XL Turbo"};function Bt(ze){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends jt{constructor(y){super(),_t(this,y,Bt,Wt,Zt,{})}}export{Nt as component};
